/****************************************************************************
 Copyright (c) 2010-2012 cocos2d-x.org
 Copyright (c) 2008-2010 Ricardo Quesada
 Copyright (c) 2011      Zynga Inc.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var removeCnt = 0;
var MyLayer = NASView.extend({
    isMouseDown:false,
    helloImg:null,
    circle:null,
    sprite:null,

    init:function () {

    
        cc.AudioEngine.getInstance().playMusic(s_TitleMusic,true);
        cc.AudioEngine.getInstance().setMusicVolume(0.3);
        //////////////////////////////
        // 1. super init first
        this._super();
        
        removeCnt = 0;
        
        /////////////////////////////
        // 2. add a menu item with "X" image, which is clicked to quit the program
        //    you may modify it.
        // ask director the window size
        var size = cc.Director.getInstance().getWinSize();

        this.backgroundSprite = cc.Sprite.create(s_MenuBackGround);
        this.backgroundSprite.setAnchorPoint(cc.p(0.5, 0.5));
        this.backgroundSprite.setPosition(cc.p(size.width / 2, size.height / 2));
        this.addChild(this.backgroundSprite,0);

    
        var btnStart = NASButtonView.buttonWithFile(s_MenuButtonStart,this,0);
        btnStart.setTag(10);
        btnStart.setPosition(cc.p(size.width / 2 , 30));
        this.addChild(btnStart, 1);
        
        var btnCollect = NASButtonView.buttonWithFile(s_MenuButtonCollection,this,0);
        btnCollect.setTag(999);
        btnCollect.setPosition(cc.p(size.width / 2 - 160 , 30));
        this.addChild(btnCollect, 1);
        
    },
    
    buttonEvent:function(sender, event, pTouch){
        var tag = sender.getTag();
        cc.AudioEngine.getInstance().stopMusic();

         if (event == NASButtonViewEventTouchDown){
            if (tag == 999) {
                cc.Director.getInstance().replaceScene(cc.TransitionRotoZoom.create(0.5, new CollectScene));
        
            }else{
                //BGM 後から実装
                cc.Director.getInstance().replaceScene(cc.TransitionRotoZoom.create(0.5, GameLayer.create(tag)));
            }
            //cc.Director.getInstance().replaceScene(cc.TransitionRotoZoom.create(0.5, new GameScene(1)));
          }
     }
    
});

var MyScene = cc.Scene.extend({
    onEnter:function () {
        this._super();
        var layer = new MyLayer();
        this.addChild(layer);
        layer.init();
    }
});
