//////////////Type NORMAL START//////////////
var normalTypeOptions = {
getTileUrl: function(coord, zoom) {
    var normalizedCoord = getNormalizedCoord(coord, zoom);
    if (!normalizedCoord) {
        return null;
    }
    var boundnorm = Math.pow(2, zoom);
    return "http://maps.tamrielma.ps/oblivion" + "/" + "normal" + "/" + zoom + "/" + normalizedCoord.x + "/" +
    (boundnorm - normalizedCoord.y - 1) + ".jpg";
},
tileSize: new google.maps.Size(256, 256),
isPng: false,
maxZoom: 6,
minZoom: 1,
radius: 1738000,
name: 'Normal'
};


var normalMapType = new google.maps.ImageMapType(normalTypeOptions);    
//////////////Type NORMAL END//////////////
//////////////Type GAME START//////////////
var gameTypeOptions = {
getTileUrl: function(coord, zoom) {
    var normalizedCoord = getNormalizedCoord(coord, zoom);
    if (!normalizedCoord) {
        return null;
    }
    var boundnorm = Math.pow(2, zoom);
    return "http://maps.tamrielma.ps/oblivion" + "/" + "game" + "/" + zoom + "/" + normalizedCoord.x + "/" +
    (boundnorm - normalizedCoord.y - 1) + ".jpg";
},
tileSize: new google.maps.Size(256, 256),
isPng: false,
maxZoom: 6,
minZoom: 1,
radius: 1738000,
name: 'Game'
};
var gameMapType = new google.maps.ImageMapType(gameTypeOptions);
//////////////Type GAME END//////////////
//////////////Type BUMP START//////////////
var gameTypeOptions = {
getTileUrl: function(coord, zoom) {
    var normalizedCoord = getNormalizedCoord(coord, zoom);
    if (!normalizedCoord) {
        return null;
    }
    var boundnorm = Math.pow(2, zoom);
    return "http://maps.tamrielma.ps/oblivion" + "/" + "bump" + "/" + zoom + "/" + normalizedCoord.x + "/" +
    (boundnorm - normalizedCoord.y - 1) + ".jpg";
},
tileSize: new google.maps.Size(256, 256),
isPng: false,
maxZoom: 6,
minZoom: 1,
radius: 1738000,
name: 'Bump'
};
var bumpMapType = new google.maps.ImageMapType(gameTypeOptions);
//////////////Type BUMP END//////////////
//////////////Type COLOR START//////////////
var gameTypeOptions = {
getTileUrl: function(coord, zoom) {
    var normalizedCoord = getNormalizedCoord(coord, zoom);
    if (!normalizedCoord) {
        return null;
    }
    var boundnorm = Math.pow(2, zoom);
    return "http://maps.tamrielma.ps/oblivion" + "/" + "color" + "/" + zoom + "/" + normalizedCoord.x + "/" +
    (boundnorm - normalizedCoord.y - 1) + ".jpg";
},
tileSize: new google.maps.Size(256, 256),
isPng: false,
maxZoom: 6,
minZoom: 1,
radius: 1738000,
name: 'Color'
};
var colorMapType = new google.maps.ImageMapType(gameTypeOptions);
//////////////Type COLOR END//////////////

var fusione = '1Kr80f6uQeLHRIMiOH4xDujGPlqxF1W3rpGnL6e4';

function initialize() {
    var mapNormal = ['Normal']  
    var mapGame = ['Game']   
    var mapBump = [ 'Bump']  
    var mapColor = ['Color']       
    var myLatlng = new google.maps.LatLng(0, 8);
    
    if(screen.width<768||screen.height<768){   
        var myOptions = {
        center: myLatlng,
        zoom: 2,
        mapTypeControl: true,
        streetViewControl: false,      
	        mapTypeControlOptions: {
	        //style: google.maps.MapTypeControlStyle.DROPDOWN_MENU,
		    position: google.maps.ControlPosition.TOP_CENTER,
	        mapTypeIds: ['Normal','Color','Bump','Game']
	        }             
        }
    }
    else {  
        var myOptions = {
        center: myLatlng,
        zoom: 3,
        mapTypeControl: true,
        streetViewControl: false,      
	        mapTypeControlOptions: {
		    position: google.maps.ControlPosition.BOTTOM_CENTER,
	        mapTypeIds: ['Normal','Color','Bump','Game']
	        }             
        }
    }     
    map = new google.maps.Map(document.getElementById("map_canvas"), myOptions ); 
    google.maps.event.addListener(map, 'tilesloaded',  function(){
                                  document.getElementById("caricamento").style.display = 'none';
                                  });
    map.mapTypes.set('Game',gameMapType)
    map.mapTypes.set('Normal',normalMapType)
    map.mapTypes.set('Bump',bumpMapType)
    map.mapTypes.set('Color',colorMapType)    
    map.setMapTypeId('Normal'); 

	layerMarkers = new google.maps.FusionTablesLayer({});
	layerMarkers.setMap(map);     	 
}


function filterData() {
	var filter = [];
	var idx = 0;
	var seletts = document.getElementsByName('selett');
	for (var i = 0, selett; selett = seletts[i]; i++) {
		if (selett.selected) {
			var selettName = selett.value.replace(/'/g, '\\\'');
			filter.push("'" + selettName + "'");
		}
		if (document.getElementById('toggleAll').selected) {
			var i = 0;
			for (i = 0; i <= 70; i++) {
				filter[idx] = i;
				idx++;
			}
		}
	}
	if (filter.length) {
		if (!layerMarkers.getMap()) {
			layerMarkers.setMap(map);
		}
		layerMarkers.setOptions({
			query: {
				select: 'numero',
				from: fusione,
				where: "'numero' IN (" + filter.join(',') + ')'
			}
		});
	} else {
		layerMarkers.setMap(null);
	}
}


/*
function toggleMarkers(layerMarkers) { 
    var fusione = 924956; ///ID TABLE
    var arr_numero = [];
    var idx = 0;
    if (document.getElementById('toggleAll').selected)   {
    	  arr_numero[idx] = [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15];
    	  idx++;
    	}  
    if (document.getElementById('toggleDaedric').selected)   { ///DAEDRIC///N1//// 
        arr_numero[idx] = 1;
        idx++;
    }    
    if (document.getElementById('toggleCities').selected)   {  ///CITIES///N2////
        arr_numero[idx] = 2;
        idx++;
    }   
    if (document.getElementById('toggleForts').selected)   {   ///FORTS///N3////
        arr_numero[idx] = 3;
        idx++;
    }
    if (document.getElementById('toggleInns').selected)   { ///INNS///N4////
        arr_numero[idx] = 4;
        idx++;
    }
    if (document.getElementById('togglePeaks').selected)   { ///PEAKS///N5////
        arr_numero[idx] = 5;
        idx++;
    }
    if (document.getElementById('toggleCamps').selected)   { ///CAMPS///N6////
        arr_numero[idx] = 6;
        idx++;
    }
    if (document.getElementById('toggleSettlements').selected)   { ///SETTLEMENTS///N7////
        arr_numero[idx] = 7;
        idx++;
    }
    if (document.getElementById('toggleCaves').selected)   { ///CAVES///N8////
        arr_numero[idx] = 8;
        idx++;
    }
    if (document.getElementById('toggleAyleid_Ruins').selected)   { ///Ayleid_Ruins///N9////
        arr_numero[idx] = 9;
        idx++;
    }
    if (document.getElementById('toggleMines').selected)   { ///Mines///N10////
        arr_numero[idx] = 10;
        idx++;
    }
    if (document.getElementById('toggleOblivion_Gate').selected)   { ///Oblivion_Gate///N11////
        arr_numero[idx] = 11;                                       
        idx++;
    } 
    if (document.getElementById('toggleWayshrines').selected)   { ///Wayshrines///N12////
        arr_numero[idx] = 12;
        idx++;
    } 
    if (document.getElementById('toggleDoomstones').selected)   { ///Doomstones///N13////
        arr_numero[idx] = 13;
        idx++;
    } 
    if (document.getElementById('toggleRunestones').selected)   { ///Runestones///N14////
        arr_numero[idx] = 14;
        idx++;
    } 
    if (document.getElementById("toggleNirnroot").selected)   { ///Mines///N15////
        arr_numero[idx] = 15;
        idx++;
    }                                    
    lista_numero = arr_numero.join(',');
   	if (lista_numero == "") {
		lista_numero = "'no_selection'";
	}
    layerMarkers.setQuery("SELECT Location FROM "+ fusione +" WHERE numero IN (" + lista_numero + ")");
}
*/

function getNormalizedCoord(coord, zoom) {  var y = coord.y;  var x = coord.x;  var tileRange = 1 << zoom;  if (y < 0 || y >= tileRange) {  return null;  }  if (x < 0 || x >= tileRange) {  x = (x % tileRange + tileRange) % tileRange;  }  return {  x: x,  y: y  }; }