//////////////Type ANTIQUE START//////////////
var antiqueTypeOptions = {
getTileUrl: function(coord, zoom) {
    var normalizedCoord = getNormalizedCoord(coord, zoom);
    if (!normalizedCoord) {
        return null;
    }
    var boundnorm = Math.pow(2, zoom);
    return "http://maps.tamrielma.ps/si" + "/" + "antique" + "/" + zoom + "/" + normalizedCoord.x + "/" +
    (boundnorm - normalizedCoord.y - 1) + ".jpg";
},
tileSize: new google.maps.Size(256, 256),
isPng: false,
maxZoom: 4,
minZoom: 1,
radius: 1738000,
name: 'Antique'
};
var antiqueMapType = new google.maps.ImageMapType(antiqueTypeOptions);    
//////////////Type NORMAL END//////////////

//////////////Type GAME START//////////////
var gameTypeOptions = {
getTileUrl: function(coord, zoom) {
    var normalizedCoord = getNormalizedCoord(coord, zoom);
    if (!normalizedCoord) {
        return null;
    }
    var boundnorm = Math.pow(2, zoom);
    return "http://maps.tamrielma.ps/si" + "/" + "game" + "/" + zoom + "/" + normalizedCoord.x + "/" +
    (boundnorm - normalizedCoord.y - 1) + ".jpg";
},
tileSize: new google.maps.Size(256, 256),
isPng: false,
maxZoom: 4,
minZoom: 1,
radius: 1738000,
name: 'Game'
};
var gameMapType = new google.maps.ImageMapType(gameTypeOptions);
//////////////Type GAME END//////////////
//////////////Type COLOR START//////////////
var gameTypeOptions = {
getTileUrl: function(coord, zoom) {
    var normalizedCoord = getNormalizedCoord(coord, zoom);
    if (!normalizedCoord) {
        return null;
    }
    var boundnorm = Math.pow(2, zoom);
    return "http://maps.tamrielma.ps/si" + "/" + "color" + "/" + zoom + "/" + normalizedCoord.x + "/" +
    (boundnorm - normalizedCoord.y - 1) + ".jpg";
},
tileSize: new google.maps.Size(256, 256),
isPng: false,
maxZoom: 4,
minZoom: 1,
radius: 173800,
name: 'Color'
};
var colorMapType = new google.maps.ImageMapType(gameTypeOptions);
//////////////Type COLOR END//////////////
var fusione = '1OM18MrZ1hbJmy575f2Idk0DW17B4WQF0m-hY0Lg';  //TABLE ID

function initialize() {   
    var mapNormal = ['Antique']  
    var mapGame = ['Game']     
    var mapColor = ['Color']       
    var myLatlng = new google.maps.LatLng(0, 0);
    if(screen.width<768||screen.height<768){  
        var myOptions = {
        center: myLatlng,
        zoom: 1,
        mapTypeControl: true,
        streetViewControl: false,      
        mapTypeControlOptions: {
        //style: google.maps.MapTypeControlStyle.DROPDOWN_MENU,
	    position: google.maps.ControlPosition.TOP_CENTER,
        mapTypeIds: ['Antique','Color','Game']
        }             
        }
    }       
    else {  
        var myOptions = {
        center: myLatlng,
        zoom: 2,
        mapTypeControl: true,
        streetViewControl: false,      
        mapTypeControlOptions: {
	    position: google.maps.ControlPosition.BOTTOM_CENTER,
        mapTypeIds: ['Antique','Color','Game']
        }             
        }
    }   
    map = new google.maps.Map(document.getElementById("map_canvas"), myOptions ); 
    google.maps.event.addListener(map, 'tilesloaded',  function(){
                                  document.getElementById("caricamento").style.display = 'none';
                                  });
    
    map.mapTypes.set('Game',gameMapType)
    map.mapTypes.set('Antique',antiqueMapType)
    map.mapTypes.set('Color',colorMapType)    
    map.setMapTypeId('Game'); 

    layerMarkers = new google.maps.FusionTablesLayer({});
    layerMarkers.setMap(map);   
}


function filterData() {
	var filter = [];
	var idx = 0;
	var seletts = document.getElementsByName('selett');
	for (var i = 0, selett; selett = seletts[i]; i++) {
		if (selett.selected) {
			var selettName = selett.value.replace(/'/g, '\\\'');
			filter.push("'" + selettName + "'");
		}
		if (document.getElementById('toggleAll').selected) {
			var i = 0;
			for (i = 0; i <= 70; i++) {
				filter[idx] = i;
				idx++;
			}
		}
	}
	if (filter.length) {
		if (!layerMarkers.getMap()) {
			layerMarkers.setMap(map);
		}
		layerMarkers.setOptions({
			query: {
				select: 'numero',
				from: fusione,
				where: "'numero' IN (" + filter.join(',') + ')'
			}
		});
	} else {
		layerMarkers.setMap(null);
	}
}


   
function getNormalizedCoord(coord, zoom) {  var y = coord.y;  var x = coord.x;  var tileRange = 1 << zoom;  if (y < 0 || y >= tileRange) {  return null;  }  if (x < 0 || x >= tileRange) {  x = (x % tileRange + tileRange) % tileRange;  }  return {  x: x,  y: y  }; }
/////////////////////////////////////////