window.addEventListener('DOMContentLoaded', function() {

  'use strict';
  
  // LOCALIZATION
  var translate = navigator.mozL10n.get;
  navigator.mozL10n.once(start);

  function start() {
    var message = document.getElementById('message');
    message.textContent = translate('message');
  }
  
  
  
  // GAME VARS
  var level = 1;
  var rushStatus = false;
  var allowTaps = false;
  var rushTaps = new Array();
  var playerTaps = new Array();
  
  var leveltag = document.getElementById('leveltag');
  var modal = document.getElementById('modal');
  var medal = document.getElementById('medal');
  var retry = document.getElementById('retry');
  
  // NAVIGATION CONTROL
  var start = document.getElementById('start');
  start.addEventListener("animationend", function(e){
    start.className = start.className.replace(/\banimate\b/,'');
  }, false);
  
  
  
  // GET THE BLOCKS
  var blocks = new Array(
    document.getElementById('block1'),
    document.getElementById('block2'),
    document.getElementById('block3'),
    document.getElementById('block4')
  );

  
  
  // DISABLE "ON" STATE AFTER ANIMATION ENDS
  blocks[0].addEventListener("animationend", function(e){ blocks[0].className = "block"; }, false);
  blocks[1].addEventListener("animationend", function(e){ blocks[1].className = "block"; }, false);
  blocks[2].addEventListener("animationend", function(e){ blocks[2].className = "block"; }, false);
  blocks[3].addEventListener("animationend", function(e){ blocks[3].className = "block"; }, false);
  
  
  
  // BLOCKS TOUCH
  function blockTouch(e, b){
    
    console.log( b );
    var id = b.getAttribute('data-id');
    
    // PLAYER TAP
    var totalTaps = playerTaps.push( id );
    var tindex = totalTaps - 1;
    
    // COMPARE TAPS
    if( playerTaps[tindex] == rushTaps[tindex] ){
      console.log('OK! ' + playerTaps[tindex]);
      
      // EVALUATE TAPS
      b.className = "block on";
    }else{
      console.log('PERDISTE! ' + (totalTaps - 1) + ' correcta!');
      
      // EVALUATE TAPS
      allowTaps = false;
      rushStatus = false;
      start.className = "go animate";
      
      medal.innerHTML = level;
      modal.className = "enter";
      
    }
    
    var increase = Math.floor(level/3);
    if( totalTaps == (increase + 4) ){
      console.log('GANASTE!');
      level++;
      leveltag.innerHTML = level;
      allowTaps = false;
      rush();
      start.className = "rush animate";
    }
    
  }
  blocks[0].addEventListener("touchstart", function(e){ if( allowTaps ) blockTouch(e, this) }, false);
  blocks[1].addEventListener("touchstart", function(e){ if( allowTaps ) blockTouch(e, this) }, false);
  blocks[2].addEventListener("touchstart", function(e){ if( allowTaps ) blockTouch(e, this) }, false);
  blocks[3].addEventListener("touchstart", function(e){ if( allowTaps ) blockTouch(e, this) }, false);
  
  
  
      // HOME
      document.querySelector('#play').addEventListener ('click', function () {
        document.querySelector('#game-board').className = 'current';
        document.querySelector('#splash-home').className = 'left';
        start.className = "go animate";
      });

  
  
      // GAME BOARD
      document.querySelector('#quit').addEventListener ('click', function () {
        document.querySelector('#splash-home').className = 'current';
        document.querySelector('#game-board').className = 'right';
        // RESET
        level = 1;
        leveltag.innerHTML = level;
        allowTaps = false;
        rushStatus = false;
        modal.className = "leave";
      });

      document.querySelector('#start').addEventListener ('click', function () {
        if( !rushStatus ){
          start.className = "rush animate";
          rush();
        }
      });
  
  
  
  // GAME FUNCTIONS
  var siconbg = document.getElementById('siconbg');
  siconbg.addEventListener("animationend", function(e){
    console.log('TIME ENDED!');
    rushStatus = false;
    start.className = "go animate";
    
    // EVALUATE TAPS
    allowTaps = false;
    rushStatus = false;
    start.className = "go animate";

    medal.innerHTML = level;
    modal.className = "enter";
    
  }, false);
  
  
  
  // PLAYER TURN
  function listenTaps(){
    siconbg.style.animationDuration = "20s";
    playerTaps = new Array();
    allowTaps = true;
    console.log( rushTaps );
  }
  
  
  
  // THE RUSH
  function rush(){
    
    var counter = 1;
    var prev = -1;
    
    rushTaps = new Array();
    rushStatus = true;
    
    // DEFINE THE RUSH
    var rush = setInterval(function(){
      
      var index = Math.floor( Math.random() * 4 ) + 1;
      index--;
      rushTaps.push(index);
      
      console.log( index );
      
      blocks[index].className = "block on";
      
      
      // RUSH STOPPED
      var increase = Math.floor(level/3);
      if( increase + 4 == counter ){
        clearInterval( rush );
        listenTaps();
        start.className = "timer animate";
      }
      
      
      counter++;
      
    }, 800);
    
  }
  
  retry.addEventListener ('click', function () {
    modal.className = "leave";
    level = 1;
    leveltag.innerHTML = level;
    allowTaps = false;
    rushStatus = false;
  });
  

});
