/*!
 * Tea Reader
 * Copyright (C) 2015  TEA - the ebook alternative
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
function listDir(e,t){"use strict";var r,n,o,i=[];navigator.getDeviceStorage?(r=navigator.getDeviceStorage("sdcard"),n=r.available(),n.onsuccess=function(){"available"===this.result?(o=r.enumerate(),o.onsuccess=function(){if(this.done)e&&e(i);else{var t=this.result;t&&!/\.Trashes/i.test(t.name)&&/.*\/[^\.][\w\-_\., ']*\.epub$/i.test(t.name)&&!excludedFilesList.includes(t.name)&&i.push(t.name),this["continue"]()}},o.onerror=function(){if(this.error&&this.error.name){if(t)return void t(this.error);console.warn(this.error)}else console.warn("No epub file found",this.error);e&&e()}):t&&t({name:"SdCardUnavailable",message:"SD card is unavailable"})},n.onerror=function(){t&&t(this.error)}):(console.error("no device storage"),e&&e())}function updateTitle(e){"use strict";document.l10n.updateData({number:e}),document.l10n.localizeNode(document.querySelector("header")),e>0?document.querySelector("footer").classList.remove("disabled"):document.querySelector("footer").classList.add("disabled")}function selectFile(e){"use strict";var t,r;if(t=e.target,"input"===t.tagName.toLowerCase())r=t;else{for(;"li"!==t.tagName.toLowerCase();)t=t.parentNode;r=t.querySelector("input")}r.checked=!r.checked,updateTitle(document.querySelectorAll(".picker-list-files input:checked").length)}function selectAll(){"use strict";var e,t=0;for(e=document.querySelectorAll(".picker-list-files input"),t;t<e.length;t+=1)e[t].checked=!0;updateTitle(e.length)}function sendFiles(e){"use strict";if(!e.target.classList.contains("disabled")){var t,r,n,o,i,s,c,a=[],l=[];if(s=function(){l.push(this.result),i.length===l.length&&(a.length>0&&activityRequest.postError(a.join(", ")),activityRequest.postResult({files:l}))},c=function(){a.push("can't pick the epub "+n)},activityRequest&&navigator.getDeviceStorage)for(t=navigator.getDeviceStorage("sdcard"),i=document.querySelectorAll("input:checked"),o=0;o<i.length;o+=1)n=i[o].getAttribute("id"),activityRequest&&navigator.getDeviceStorage&&(r=t.get(n),r.onsuccess=s,r.onerror=c);else console.warn("you're not in a Firefox OS phone or simulator")}}function removeWaitingWheel(){"use strict";document.querySelector(".waiting").remove()}function displayFiles(e){"use strict";var t,r,n=document.querySelector(".picker-list-files"),o="";removeWaitingWheel(),e&&e.length>0?(e=e.map(function(e){var t,r=e.split("/");return t=r.pop(),{fullPath:e,path:r.join("/"),name:t,letter:t.substring(0,1).toUpperCase()}}),e=e.sort(function(e,t){return e.name.toLowerCase().localeCompare(t.name.toLowerCase(),navigator.language)}),e.forEach(function(e){o!==e.letter&&(o=e.letter,r=document.createElement("h2"),r.innerHTML=o,n.appendChild(r)),t=document.createElement("li"),t.setAttribute("data-filename",e.fullPath),t.innerHTML='<input type="checkbox" id="'+e.fullPath+'" /><label for="'+e.fullPath+'"></label><div class="file-title"><span class="picker-file-title">'+e.name+'</span><span class="picker-file-path">'+e.path+"</span></div>",n.appendChild(t)}),document.querySelector(".picker-list-files").addEventListener("click",selectFile,!0),document.querySelector(".picker-all").addEventListener("click",selectAll,!1),document.querySelector("footer").addEventListener("click",sendFiles,!1)):(t=document.createElement("li"),t.classList.add("empty"),t.innerHTML='<div class="file-title"><span class="picker-file-title">'+window.document.l10n.getSync("noEpubOnPhone")+'</span><span class="picker-file-path">'+window.document.l10n.getSync("thatsSad")+"</span></div>",n.appendChild(t),document.querySelector(".picker-all").remove())}function displayError(e){"use strict";var t,r,n;t=document.querySelector(".picker-list-files"),removeWaitingWheel(),r=document.createElement("li"),r.classList.add("error"),n='<div class="file-title"><span class="picker-file-title">',n+=window.document.l10n.getSync(e&&"SecurityError"===e.name?"permissionRefusedToSdCard":e&&"SdCardUnavailable"===e.name?"sdCardUnavailable":"unknownError"),r.innerHTML=n+"</span></div>",t.appendChild(r),document.querySelector(".picker-all").remove()}function cancelActivity(){"use strict";activityRequest?activityRequest.postError("cancel"):console.warn("you are not in a Firefox OS phone or simulator")}if(!navigator.getDeviceStorage){var storageTypes=["sdcard","pictures","videos","music"],DeviceStorage=function(e){"use strict";this.storageName=e};DeviceStorage.prototype.enumerate=function(e){"use strict";var t,r,n;return n=this,e=e||"books",t={onsuccess:!1,onerror:function(e){console.error(e)}},r=new XMLHttpRequest,r.open("GET",e+"/list",!0),r.onload=function(){var o=r.responseText.split("\n").filter(function(e){return e.length>0});t["continue"]=function(){if(t.done=0===o.length,t.done)t.onsuccess&&t.onsuccess();else{var r=n.get(e+"/"+o.pop());r.onsuccess=function(){t.result=this.result,t.onsuccess&&t.onsuccess()}}},t["continue"]()},r.onerror=function(e){t.onerror(e)},r.send(),t},DeviceStorage.prototype.get=function(e){"use strict";var t={onsuccess:!1,onerror:function(e){console.error(e)}},r=new XMLHttpRequest;return r.open("GET",e,!0),r.responseType="arraybuffer",r.onload=function(){200===r.status||0===r.status?(t.result=new File([r.response],e),t.onsuccess&&t.onsuccess()):(t.error="Error getting "+e+" : "+r.statusText+" ("+r.status+")",t.onerror())},r.onerror=function(e){t.onerror(e)},r.send(),t},DeviceStorage.prototype.addNamed=function(e,t){"use strict";var r={onsuccess:!1,onerror:function(e){console.error(new Error(e))}};return setTimeout(function(){console.debug(t+" written on SD card"),r.onsuccess&&(r.result=t,r.onsuccess())},100),r},DeviceStorage.prototype["delete"]=function(e){"use strict";var t={onsuccess:!1,onerror:function(e){console.error(e)}};return setTimeout(function(){console.debug(e+" deleted on SD card"),t.onsuccess&&t.onsuccess()},100),t},DeviceStorage.prototype.available=function(){"use strict";var e={result:"available",onsuccess:!1,onerror:function(e){console.error(e)}};return setTimeout(function(){e.onsuccess&&e.onsuccess()},100),e},DeviceStorage.prototype.addEventListener=function(){"use strict"};var getDeviceStorage=function(e){"use strict";var t=null;return e&&-1!==storageTypes.indexOf(e)&&(t=new DeviceStorage(e)),t};navigator.getDeviceStorage=getDeviceStorage}[].includes||(Array.prototype.includes=function(e){"use strict";if(void 0===this||null===this)throw new TypeError("Impossible de convertir this en objet");var t=Object(this),r=parseInt(t.length,10)||0;if(0===r)return!1;var n,o=parseInt(arguments[1],10)||0;o>=0?n=o:(n=r+o,0>n&&(n=0));for(var i;r>n;){if(i=t[n],e===i||e!==e&&i!==i)return!0;n+=1}return!1});var activityRequest,excludedFilesList=[];!function(){"use strict";window.document.l10n.ready(function(){listDir(displayFiles,displayError),document.l10n.updateData({number:0}),document.l10n.localizeNode(document.querySelector("body")),navigator.mozSetMessageHandler?navigator.mozSetMessageHandler("activity",function(e){activityRequest=e,excludedFilesList=e.source.data.exclude}):console.warn("you are not in a Firefox OS phone or simulator"),document.querySelector("button.back").addEventListener("click",cancelActivity)})}();