
(function ($) {
	"use strict";
	var idiomaActual = 'en';

	function calcula(preu, tipus, anys) {

		var valor1,
			valor2,
			valor3 = 0.0,
			resul,
			resultat,
			mensual,
			potencia,
			multiplicador,
			factor,
			quotam,
			i = 0,
			mesos,
			

		tipus = parseFloat(tipus);
		anys = parseFloat(anys);
		preu = parseFloat(preu);

		//Fem el clcul de les quotes de finanament

		mensual = tipus * 100 / 12;
		potencia = mensual / 10000 + 1;
		multiplicador = potencia;
		mesos = anys * 12;
		for (i = 1; i < mesos; i = i + 1) {
			multiplicador = potencia * multiplicador;
		}
		factor = multiplicador * mensual / (10000 * (multiplicador - 1));
		quotam = preu * factor;
		resul = parseInt(quotam * 100, 10);
		resultat = parseFloat(resul) / 100;
		return resultat;
	}

	function actualitzaCalcul() {
		var $tipus,
			$preu,
			$anys,
			valid = false;

		$tipus = $("#tipus");
		$preu = $("#preu");
		$anys = $("#anys");
		valid = /^\d+(\.\d*)?$/.test($preu.val());
		valid = valid && /^\d+(\.\d*)?$/.test($tipus.val()) && /^\d+(\.\d*)?$/.test($anys.val());

		if (valid) {
			$("#quota").html(calcula($preu.val(), $tipus.val(), $anys.val()));
		}
	}

	function guardar(){
		var tipus,
			preu,
			anys,
			quota, 
			total,
			str;

		tipus = $("#tipus").val();
		preu = $("#preu").val();
		anys = parseFloat($("#anys").val());
		quota = parseFloat($("#quota").html());
		total = Math.round(quota * anys * 100) / 100;

		str = "<tr><th>" + preu + "</th>";
		str = str + "<td>" + tipus + "</td>";
		str = str + "<td>" + anys + "</td>";
		str = str + "<td>" + quota + "</td>";
		str = str + "<td>" + total + "</td>";
		str = str + '<td><a href="#home" data-icon="minus" data-role="button" data-iconpos="notext">Home</a></td></tr>';

			  
		$("#table-favs").find("tbody").append(str).find("a").button();
		saveFavs({
			'preu' : preu,
			'tipus' : tipus,
			'anys' : anys,
			'quota' : quota,
			'total' : total
		});	
	}

	function saveFavs(fav){
		var favs;
		favs = JSON.parse(localStorage.getItem('favs')) || [];
		favs.push(fav);
		localStorage.setItem('favs', JSON.stringify(favs));
	}

	function esborrarFavs(e){
		var t = $(e.target), r = [];
		t.closest("tr").remove();
		$("#table-favs").find("tbody").find("tr").each(function(i,d){
			r.push($(d).data('value'));
		});
		localStorage.setItem('favs', JSON.stringify(r));

	}

	function renderFavs(){
		var str = '', favs;

		favs = JSON.parse(localStorage.getItem('favs')) || [];

		$.each(favs, function(i, fav){
			var actual = JSON.stringify(fav);
			if(fav != null){
				str = str + "<tr data-value='" + actual + "'><th>" + fav.preu + "</th>";
				str = str + "<td>" + fav.tipus + "</td>";
				str = str + "<td>" + fav.anys + "</td>";
				str = str + "<td>" + fav.quota + "</td>";
				str = str + "<td>" + fav.total + "</td>"
				str = str + '<td><a href="#home" data-icon="minus" data-role="button" data-iconpos="notext">Home</a></td></tr>';
			}
		});
			  
		$("#table-favs").find("tbody").append(str).find("a").button();
		$("#table-favs").table("refresh");
	}
	
	function aplicaIdioma(data){
		log("idioma : " + JSON.stringify(data));
		$(".locale_msg").each(function(i,element){
			$(element).html(data[$(element).data("localeid")].message);
		});
	}
	
	function triaIdiomes(idioma){
		log("idioma : " + idioma);
		window.localStorage.setItem("hipoteques", JSON.stringify({"lang" : idioma}));
		idiomaActual = idioma;
		$.getJSON("locale_" + idioma + ".json")
			.done(aplicaIdioma)
			.fail(function(data){
				log("fail : " + data.status + " " + data.statusText +" locale_" + idioma + ".json");
			});
	}
	
	function selectIdiomes(){
    	var $this = $(this), idioma;
		idioma = $(":selected", $this).val();
		triaIdiomes(idioma);
	//	$("#config").dialog("close");
		$.mobile.changePage('#home');
	}
	
	function carregaIdiomes(){
		var select = $("select.language"), selected = '';

		$.getJSON("locales.json").done(function(data) {
			
				$.each(data, function(index, element){
				if(index === idiomaActual){ 
					selected = " selected = 'selected'";
				} else {
					selected = "";					
				}	
				select.append("<option value='" + index + "' " + selected + " >" + element + "</option>" );
			});
			select.selectmenu('refresh');
		});
	}
	
	function iniciar(){
		var local =	window.localStorage.getItem("hipoteques"), 
			parsed,
			select = $("select.language"), selected = '';
		
		actualitzaCalcul();
		$("#calcul").on("click", "input", actualitzaCalcul);
	    $("#tipus, #anys, #preu").bind("change", actualitzaCalcul);
		if(!local){
			//$("#config").dialog();
			$.mobile.changePage('#config');
		} else {
			parsed = JSON.parse(local);
			triaIdiomes(parsed.lang);
		}
		select.on("change", selectIdiomes);
		$("button.ok").on("click", function(){
			select.trigger("change");
		});


		$("#guardar").on("click", guardar);
	}


	
	function iniciarIdioma(){
		carregaIdiomes();
	}	
	
	function log(msg) {
		$("div.log").append(msg + "<br>");
	}
	
	


	$("#home").one("pageshow", iniciar);
	$("#favs").one("pagecreate", renderFavs);

	$("#config").on("pageinit", iniciarIdioma);

	$("#favs table").on("click", "div.ui-btn", esborrarFavs);

}(jQuery));
