// Roller Coaster Configuration File


// Datatypes
// ------------------------------------------------------------------
//
// Boolean
// Booleans have two possible values true or false.
//     Example:
//         value: true
// Number
// Numbers can be represented as whole numbers or decimals.
//     Example:
//         x: -20
//         alpha: 0.4
//
// String
// String are described with quotes surrounding zero or more characters.
//     Example:
//         filename: "image1.png"
//
// Object 
// Objects are described with curly brackets surrounding 'name: value' pairs delimited by commas.
//     Example:
//         {
//             name1: value1,
//             name2: value2
//         }
//
// Array
// Arrays are described with square brackets surrounding values delimited by commas.
//     Example:
//         [
//             value1,
//             value2
//         ]

// Framework Properties
// ------------------------------------------------------------------
//
// View Properties
//     type (String)
//     filename (String): The url of image of the view is defined by the resourcePath and the filename.
//     x (Number): Location of view relative to the left of the viewport.
//     y (Number): Location of view relative to the top of the viewport.
//     offsetX (Number): Distance in pixels the image is shifted right.
//     offsetY (Number): Distance in pixels the image is shifted down.
//     numFrames (Number): Number of frames of animation. If this property is set and greater than one, the view will be a sprite.
//     frameRate (Number): Delay between frames of animation (in 1 / 60 second increments).
//         Example:
//              frameRate: 60 // The delay between frames is one second
//              frameRate: 10 // The delay between frames is on 10 / 60 or 0.6 seconds
//     loop (Boolean): If true the animation will continue to play indefinitely after started until stopped.
//         Example:
//              alpha: 0.5 // View will be rendered at half transparency
//     hotspots (Array):  Array of bounding rectangles that will act as the hotspot for the view if specified.
//         Example:
//              hotspots: [
//					{x: 38, y: 0, width: 161, height: 45},
//					{x: 9, y: 45, width: 201, height: 51}
//              ]
//     hotspotsVisible (Boolean): If true the hotspot rectangles of the view will be outlined. This is used for debug purposes only. 
//     states (Array): Array of views that describe specific states of the view.
//         Example:
//             states: [
//					{
//						type: "ON",
//						filename: "light-switch-on.png"
//					},{
//						type: "OFF",
//						filename: "light-switch-off.png"
//					}
//				]
//
// Audio Properties
//     states (Array): Array of audio sprites.
//         State Properties:
//             name (String): Type of audio state. 
//             startTime (Number): Start time of the state in seconds.
//             duration (Number): The duration of the state in seconds.
//             loop (Boolean): If true the state will loop.
//         Example:
//             states: [
//                 {
//                     type: "intro", 
//                     startTime: 0,
//                     duration: 3
//                 },
//  
// Game Properties
//     element (HTML Element): The HTML element in which the game will be populated. Usually a div element.
//         Example:
//              element: window.document.getElementById("game"),
//     device (String): What device the game is launched in (e.g. "IPHONE", "IPAD").
//     resourcePath (String): The url where all resources are relative to. Note the "/" is required.
//         Example:
//             resourcePath: "resources/"
//.    deviceOffset (Object):
//         Example:
//             deviceOffset: {
//.                iPhone: {x: -32, y: -64}
//.            }
//     rounds (Array): An array of objects containing each round's properties.
//	   startImageFilename (String): The url of image title card show at the beginning of the game.
//     audioEnabled (Boolean): If false audio will not be loaded or played.
//     audioFilename (String): The url of the audio file.

// Roller Coaster Specific Properties
// ------------------------------------------------------------------
//
// Game Properties
//
//     audio
//         Available States:
//             PAYOFF: Played after the path is traced.
//             MUSIC: Loops in the background.
//      hint
//         Properties:
//             color: The color (in hex e.g. #ff0000 for red) of the hint line.
//		       speed: The speed (in pixels per second) at which the line is drawn.
//		       width: The diameter of the line.
//		       dashWidth: The length of the dash.
//		       dashGap: The length of the gap between dashes.
//         
// Round Properties
//
//     background
//         Properties:
//            filename: Filename of the background image.
//     rider: Character that will traverse the path upon round completion.
//         Available States:
//             INTRO: Initial state of the bubble.
//             RIDE: Displayed when the rider is moving along the path.
//     dataPoints (Array): Array of objects that describe the points which define the shape.
//         Example:
//             dataPoints: [ 
//			    	{ 
//                      i: 0,
//                      x: 329,
//                      y: 594
//                  }, {
//                      i: 1,
//                      x: 329,
//                      y: 192
//                  }
//             ]
//     hintPaths (Array): Array of objects that describe the hint paths by the using the index 'i' values of the dataPoints.
//          Example:
//              hintPaths: [
//				    [ 0, 1, 2 ],
//                  [ 3, 4 ]
//			    ]
//     successPath (Array): Array of index 'i' values of the dataPoints that describe the path the rider will traverse on sucess.
//          Example:
//              successPath: [ 0, 1, 2, 1, 3, 1, 4 ]
//     targetItems: Items that are activated by touch.  Target items are not visible until activated. Once all target items are activated the round is complete.
//     payoff: View that is displayed while the rider is moving along the path after the round is complete.

WM.config = {
	resourcePath: "resources/",
	deviceOffset: { //chopping of the BG image to iPhone size specs. Image BG must be 1024x768
		iPhone: {
			x: -32,
			y: -96
		}
	},
	gameIcon: "icon-rollerCoaster-shapes.png",
	loadingImageWhiteFilename: "loading-white.png",
	loadingImageColorFilename: "loading-color.png",
	landscapeOnlyFilename: "landscape-only.png",
	exitButtonFilename: "exit-button.png",
	startImageFilename: "startImage-rollerCoaster-shapes.jpg",
	audioEnabled: true,
	audioFilename: "audio-rollerCoaster-shapes.mp3", //all audio including intro, payoff, and music is in this one file
	audio: {
		states: [
			{
				name: "music", 
				startTime: 46,
				duration: 16.5,
				loop: true
			}
		]
	},
	hint: {
		color: "#ffea00",
		speed: 10,
		width: 5, //width of the line itself. Makes the dots get bigger
		dashWidth: 10, //width of the dash in pixels. Cannot go higher than 10px
		dashGap: 10 //number of pixels between each dash. Cannot go lower than 10px
	},
	rounds: [
		{ //Round 1
			audio: {
				states: [
					{
						name: "intro",
						startTime: 0,
						duration: 1.8
					},
					{
						name: "payoff",
						startTime: 2,
						duration: 1.8
					}
				]
			},
			background: {
				filename: "background-circus.jpg"
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO", //poof animation
						filename: "telly-appear.png",
						offsetX: -107,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE", //ride animation
						filename: "telly.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10, //can find this on the stage of the .fla file
						loop: true,
						offsetX: -109,
						offsetY: -150
					}
				]
			},
			dataPoints: [ //points in the object where the coaster and dots changes direction. Make these up based on x y coordinates in Fireworks
				{ i: 0, x: 329, y: 594 },
				{ i: 1, x: 329, y: 192 },
				{ i: 2, x: 715, y: 192 },
				{ i: 3, x: 715, y: 594 }
			],
			hintPaths: [ //these are the dotted line points
				[ 0, 1, 2, 3, 0 ]
			],
			successPath: [ 0, 1, 2, 3, 0 ], //this is the payoff rollercoaster ride path
			targetItems: [
				{ filename: "square-01.png", x: 324, y: 544 },
				{ filename: "square-02.png", x: 324, y: 483 },
				{ filename: "square-03.png", x: 324, y: 424 },
				{ filename: "square-04.png", x: 324, y: 365 },
				{ filename: "square-05.png", x: 324, y: 306 },
				{ filename: "square-06.png", x: 324, y: 247 },
				{ filename: "square-07.png", x: 324, y: 187 },
				{ filename: "square-08.png", x: 384, y: 187 },
				{ filename: "square-09.png", x: 439, y: 187 },
				{ filename: "square-10.png", x: 494, y: 187 },
				{ filename: "square-11.png", x: 549, y: 187 },
				{ filename: "square-12.png", x: 604, y: 187 },
				{ filename: "square-13.png", x: 661, y: 187 },
				{ filename: "square-14.png", x: 684, y: 247 },
				{ filename: "square-15.png", x: 684, y: 306 },
				{ filename: "square-16.png", x: 684, y: 365 },
				{ filename: "square-17.png", x: 684, y: 424 },
				{ filename: "square-18.png", x: 684, y: 483 },
				{ filename: "square-19.png", x: 661, y: 544 },
				{ filename: "square-20.png", x: 604, y: 563 },
				{ filename: "square-21.png", x: 549, y: 563 },
				{ filename: "square-22.png", x: 494, y: 563 },
				{ filename: "square-23.png", x: 439, y: 563 },
				{ filename: "square-24.png", x: 384, y: 563 }
			],
			payoff: { filename: "square-payoff.png", x: 324, y: 187 }
		},{ //Round 2
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 21.9,
						duration: 2
					},
					{
						name: "payoff",
						startTime: 24.8,
						duration: 3
					}
				]
			},
			background: {
				filename: "background-circus.jpg"
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "telly-appear.png",
						offsetX: -107,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "telly.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -109,
						offsetY: -150
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 517, y: 614 },
				{ i: 1, x: 201, y: 381 },
				{ i: 2, x: 505, y: 172 },
				{ i: 3, x: 818, y: 396 }														
			],
			hintPaths: [
				[ 0, 1, 2, 3, 0 ]
			],
			successPath: [ 0, 1, 2, 3, 0 ],
			targetItems: [
				{ filename: "rhombus-01.png", x: 452, y: 575 },
				{ filename: "rhombus-02.png", x: 416, y: 549 },
				{ filename: "rhombus-03.png", x: 371, y: 516 },
				{ filename: "rhombus-04.png", x: 326, y: 483 },
				{ filename: "rhombus-05.png", x: 285, y: 452 },
				{ filename: "rhombus-06.png", x: 226, y: 409 },
				{ filename: "rhombus-07.png", x: 191, y: 361 },
				{ filename: "rhombus-08.png", x: 220, y: 331 },
				{ filename: "rhombus-09.png", x: 263, y: 301 },
				{ filename: "rhombus-10.png", x: 307, y: 267 },
				{ filename: "rhombus-11.png", x: 357, y: 233 },
				{ filename: "rhombus-12.png", x: 406, y: 208 },
				{ filename: "rhombus-13.png", x: 442, y: 165 },
				{ filename: "rhombus-14.png", x: 505, y: 208 },
				{ filename: "rhombus-15.png", x: 541, y: 233 },
				{ filename: "rhombus-16.png", x: 588, y: 267 },
				{ filename: "rhombus-17.png", x: 636, y: 301 },
				{ filename: "rhombus-18.png", x: 677, y: 331 },
				{ filename: "rhombus-19.png", x: 718, y: 361 },
				{ filename: "rhombus-20.png", x: 696, y: 409 },
				{ filename: "rhombus-21.png", x: 653, y: 452 },
				{ filename: "rhombus-22.png", x: 608, y: 483 },
				{ filename: "rhombus-23.png", x: 562, y: 516 },
				{ filename: "rhombus-24.png", x: 525, y: 549 }
			],
			payoff: { filename: "rhombus-payoff.png", x: 191, y: 165 }
		},{ //Round 3
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 4,
						duration: 2.5
					},
					{
						name: "payoff",
						startTime: 7,
						duration: 2.5
					}
				]
			},
			background: {
				filename: "background-circus.jpg"
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "telly-appear.png",
						offsetX: -107,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "telly.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -109,
						offsetY: -150
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 500, y: 596 },
				{ i: 1, x: 480, y: 594 },
				{ i: 2, x: 460, y: 588 },
				{ i: 3, x: 437, y: 580 },
				{ i: 4, x: 417, y: 570 },
				{ i: 5, x: 406, y: 563 },
				{ i: 6, x: 395, y: 554 },
				{ i: 7, x: 378, y: 540 },
				{ i: 8, x: 362, y: 523 },
				{ i: 9, x: 349, y: 503 },
				{ i: 10, x: 337, y: 481 },
				{ i: 11, x: 326, y: 455 },
				{ i: 12, x: 318, y: 426 },
				{ i: 13, x: 315, y: 400 },
				{ i: 14, x: 316, y: 378 },
				{ i: 15, x: 319, y: 358 },
				{ i: 16, x: 325, y: 336 },
				{ i: 17, x: 333, y: 315 },
				{ i: 18, x: 344, y: 293 },
				{ i: 19, x: 359, y: 268 },
				{ i: 20, x: 383, y: 242 },
				{ i: 21, x: 408, y: 224 },
				{ i: 22, x: 434, y: 210 },
				{ i: 23, x: 460, y: 200 },
				{ i: 24, x: 482, y: 194 },
				{ i: 25, x: 503, y: 192 },
				{ i: 26, x: 525, y: 192 },
				{ i: 27, x: 546, y: 194 },
				{ i: 28, x: 568, y: 198 },
				{ i: 29, x: 589, y: 205 },
				{ i: 30, x: 613, y: 216 },
				{ i: 31, x: 634, y: 228 },
				{ i: 32, x: 657, y: 248 },
				{ i: 33, x: 676, y: 268 },
				{ i: 34, x: 692, y: 291 },
				{ i: 35, x: 705, y: 316 },
				{ i: 36, x: 714, y: 339 },
				{ i: 37, x: 718, y: 361 },
				{ i: 38, x: 721, y: 379 },
				{ i: 39, x: 721, y: 401 },
				{ i: 40, x: 719, y: 420 },
				{ i: 41, x: 716, y: 443 },
				{ i: 42, x: 709, y: 466 },
				{ i: 43, x: 698, y: 486 },
				{ i: 44, x: 687, y: 508 },
				{ i: 45, x: 668, y: 530 },
				{ i: 46, x: 645, y: 552 },
				{ i: 47, x: 618, y: 572 },
				{ i: 48, x: 594, y: 582 },
				{ i: 49, x: 570, y: 590 },
				{ i: 50, x: 547, y: 595 },
				{ i: 51, x: 523, y: 597 }
			],
			hintPaths: [
				[ 0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0 ]
			],
			successPath: [ 0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0 ],
			targetItems: [
				{ filename: "circle-01.png", x: 497, y: 499 },
				{ filename: "circle-02.png", x: 447, y: 472 },
				{ filename: "circle-03.png", x: 417, y: 469 },
				{ filename: "circle-04.png", x: 338, y: 499 },
				{ filename: "circle-05.png", x: 323, y: 469 },
				{ filename: "circle-06.png", x: 310, y: 419 },
				{ filename: "circle-07.png", x: 310, y: 370 },
				{ filename: "circle-08.png", x: 310, y: 320 },
				{ filename: "circle-09.png", x: 323, y: 290 },
				{ filename: "circle-10.png", x: 336, y: 211 },
				{ filename: "circle-11.png", x: 417, y: 198 },
				{ filename: "circle-12.png", x: 447, y: 186 },
				{ filename: "circle-13.png", x: 497, y: 185 },
				{ filename: "circle-14.png", x: 546, y: 185 },
				{ filename: "circle-15.png", x: 596, y: 199 },
				{ filename: "circle-16.png", x: 624, y: 213 },
				{ filename: "circle-17.png", x: 624, y: 290 },
				{ filename: "circle-18.png", x: 597, y: 320 },
				{ filename: "circle-19.png", x: 624, y: 370 },
				{ filename: "circle-20.png", x: 596, y: 419 },
				{ filename: "circle-21.png", x: 624, y: 469 },
				{ filename: "circle-22.png", x: 624, y: 499 },
				{ filename: "circle-23.png", x: 596, y: 469 },
				{ filename: "circle-24.png", x: 546, y: 469 }
			],
			payoff: { filename: "circle-payoff.png", x: 310, y: 185 }
		},{ //Round 4
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 34,
						duration: 2.5
					},
					{
						name: "payoff",
						startTime: 36.5,
						duration: 2.5
					}
				]
			},
			background: {
				filename: "background-circus.jpg"
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "telly-appear.png",
						offsetX: -107,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "telly.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -109,
						offsetY: -150
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 405, y: 599 },
				{ i: 1, x: 279, y: 400 },
				{ i: 2, x: 405, y: 188 },
				{ i: 3, x: 631, y: 188 },
				{ i: 4, x: 756, y: 399 },
				{ i: 5, x: 632, y: 599 }
			],
			hintPaths: [
				[ 0, 1, 2, 3, 4, 5, 0 ]
			],
			successPath: [ 0, 1, 2, 3, 4, 5, 0 ],
			targetItems: [
				{ filename: "hexagon-01.png", x: 361, y: 565 },
				{ filename: "hexagon-02.png", x: 344, y: 517 },
				{ filename: "hexagon-03.png", x: 313, y: 469 },
				{ filename: "hexagon-04.png", x: 284, y: 421 },
				{ filename: "hexagon-05.png", x: 271, y: 376 },
				{ filename: "hexagon-06.png", x: 285, y: 328 },
				{ filename: "hexagon-07.png", x: 314, y: 280 },
				{ filename: "hexagon-08.png", x: 342, y: 232 },
				{ filename: "hexagon-09.png", x: 364, y: 182 },
				{ filename: "hexagon-10.png", x: 441, y: 182 },
				{ filename: "hexagon-11.png", x: 491, y: 182 },
				{ filename: "hexagon-12.png", x: 541, y: 182 },
				{ filename: "hexagon-13.png", x: 591, y: 182 },
				{ filename: "hexagon-14.png", x: 621, y: 232 },
				{ filename: "hexagon-15.png", x: 649, y: 280 },
				{ filename: "hexagon-16.png", x: 678, y: 328 },
				{ filename: "hexagon-17.png", x: 704, y: 376 },
				{ filename: "hexagon-18.png", x: 675, y: 421 },
				{ filename: "hexagon-19.png", x: 646, y: 469 },
				{ filename: "hexagon-20.png", x: 616, y: 517 },
				{ filename: "hexagon-21.png", x: 591, y: 565 },
				{ filename: "hexagon-22.png", x: 541, y: 570 },
				{ filename: "hexagon-23.png", x: 491, y: 570 },
				{ filename: "hexagon-24.png", x: 441, y: 570 }
			],
			payoff: { filename: "hexagon-payoff.png", x: 271, y: 181 }
		},{ //Round 5
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 16,
						duration: 2
					},
					{
						name: "payoff",
						startTime: 19,
						duration: 2
					}
				]
			},
			background: {
				filename: "background-circus.jpg"
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "telly-appear.png",
						offsetX: -107,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "telly.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -109,
						offsetY: -150
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 233, y: 595 },
				{ i: 1, x: 233, y: 189 },
				{ i: 2, x: 815, y: 190 },
				{ i: 3, x: 815, y: 594 }
			],
			hintPaths: [
				[ 0, 1, 2, 3, 0]
			],
			successPath: [ 0, 1, 2, 3, 0],
			targetItems: [
				{ filename: "rectangle-01.png", x: 227, y: 529 },
				{ filename: "rectangle-02.png", x: 227, y: 460 },
				{ filename: "rectangle-03.png", x: 227, y: 392 },
				{ filename: "rectangle-04.png", x: 227, y: 324 },
				{ filename: "rectangle-05.png", x: 227, y: 255 },
				{ filename: "rectangle-06.png", x: 227, y: 183 },
				{ filename: "rectangle-07.png", x: 300, y: 183 },
				{ filename: "rectangle-08.png", x: 375, y: 183 },
				{ filename: "rectangle-09.png", x: 450, y: 183 },
				{ filename: "rectangle-10.png", x: 525, y: 183 },
				{ filename: "rectangle-11.png", x: 600, y: 183 },
				{ filename: "rectangle-12.png", x: 675, y: 183 },
				{ filename: "rectangle-13.png", x: 750, y: 183 },
				{ filename: "rectangle-14.png", x: 786, y: 255 },
				{ filename: "rectangle-15.png", x: 786, y: 324 },
				{ filename: "rectangle-16.png", x: 786, y: 392 },
				{ filename: "rectangle-17.png", x: 786, y: 460 },
				{ filename: "rectangle-18.png", x: 750, y: 529 },
				{ filename: "rectangle-19.png", x: 675, y: 565 },
				{ filename: "rectangle-20.png", x: 600, y: 565 },
				{ filename: "rectangle-21.png", x: 525, y: 565 },
				{ filename: "rectangle-22.png", x: 450, y: 565 },
				{ filename: "rectangle-23.png", x: 375, y: 565 },
				{ filename: "rectangle-24.png", x: 300, y: 565 }
			],
			payoff: { filename: "rectangle-payoff.png", x: 227, y: 183 }
		},{ //Round 6
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 40,
						duration: 2.5
					},
					{
						name: "payoff",
						startTime: 43,
						duration: 2.5
					}
				]
			},
			background: {
				filename: "background-circus.jpg"
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "telly-appear.png",
						offsetX: -107,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "telly.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -109,
						offsetY: -150
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 436, y: 600 },
				{ i: 1, x: 315, y: 481 },
				{ i: 2, x: 315, y: 310 },
				{ i: 3, x: 436, y: 191 },
				{ i: 4, x: 599, y: 192 },
				{ i: 5, x: 722, y: 314 },
				{ i: 6, x: 722, y: 479 },
				{ i: 7, x: 600, y: 600 }
			],
			hintPaths: [
				[ 0, 1, 2, 3, 4, 5, 6, 7, 0 ]
			],
			successPath: [ 0, 1, 2, 3, 4, 5, 6, 7, 0 ],
			targetItems: [
				{ filename: "octagon-01.png", x: 375, y: 564 },
				{ filename: "octagon-02.png", x: 355, y: 529 },
				{ filename: "octagon-03.png", x: 319, y: 494 },
				{ filename: "octagon-04.png", x: 309, y: 447 },
				{ filename: "octagon-05.png", x: 309, y: 397 },
				{ filename: "octagon-06.png", x: 309, y: 347 },
				{ filename: "octagon-07.png", x: 309, y: 297 },
				{ filename: "octagon-08.png", x: 319, y: 262 },
				{ filename: "octagon-09.png", x: 354, y: 227 },
				{ filename: "octagon-10.png", x: 375, y: 185 },
				{ filename: "octagon-11.png", x: 469, y: 185 },
				{ filename: "octagon-12.png", x: 519, y: 185 },
				{ filename: "octagon-13.png", x: 569, y: 185 },
				{ filename: "octagon-14.png", x: 592, y: 227 },
				{ filename: "octagon-15.png", x: 627, y: 262 },
				{ filename: "octagon-16.png", x: 661, y: 297 },
				{ filename: "octagon-17.png", x: 693, y: 347 },
				{ filename: "octagon-18.png", x: 693, y: 397 },
				{ filename: "octagon-19.png", x: 661, y: 447 },
				{ filename: "octagon-20.png", x: 627, y: 494 },
				{ filename: "octagon-21.png", x: 592, y: 529 },
				{ filename: "octagon-22.png", x: 569, y: 564 },
				{ filename: "octagon-23.png", x: 519, y: 571 },
				{ filename: "octagon-24.png", x: 469, y: 571 }
			],
			payoff: { filename: "octagon-payoff.png", x: 309, y: 184 }
		},{ //Round 7
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 9,
						duration: 2.8
					},
					{
						name: "payoff",
						startTime: 13,
						duration: 2.5
					}
				]
			},
			background: {
				filename: "background-circus.jpg"
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "telly-appear.png",
						offsetX: -107,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "telly.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -109,
						offsetY: -150
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 281, y: 597 },
				{ i: 1, x: 522, y: 186 },
				{ i: 2, x: 776, y: 596 }
			],
			hintPaths: [
				[ 0, 1, 2, 0 ]
			],
			successPath: [ 0, 1, 2, 0 ],
			targetItems: [

				{ filename: "triangle-01.png", x: 269, y: 510 },
				{ filename: "triangle-02.png", x: 324, y: 460 },
				{ filename: "triangle-03.png", x: 354, y: 410 },
				{ filename: "triangle-04.png", x: 383, y: 360 },
				{ filename: "triangle-05.png", x: 412, y: 310 },
				{ filename: "triangle-06.png", x: 442, y: 260 },
				{ filename: "triangle-07.png", x: 468, y: 176 },
				{ filename: "triangle-08.png", x: 523, y: 260 },
				{ filename: "triangle-09.png", x: 523, y: 310 },
				{ filename: "triangle-10.png", x: 536, y: 360 },
				{ filename: "triangle-11.png", x: 565, y: 410 },
				{ filename: "triangle-12.png", x: 598, y: 460 },
				{ filename: "triangle-13.png", x: 675, y: 510 },
				{ filename: "triangle-14.png", x: 625, y: 510 },
				{ filename: "triangle-15.png", x: 575, y: 510 },
				{ filename: "triangle-16.png", x: 528, y: 510 },
				{ filename: "triangle-17.png", x: 478, y: 510 },
				{ filename: "triangle-18.png", x: 428, y: 510 },
				{ filename: "triangle-19.png", x: 378, y: 510 }
			],
			payoff: { filename: "triangle-payoff.png", x: 269, y: 176 }
		},{ //Round 8
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 28,
						duration: 2.5
					},
					{
						name: "payoff",
						startTime: 30.5,
						duration: 2.7
					}
				]
			},
			background: {
				filename: "background-circus.jpg"
			},
			rider: {
				type: "RIDER",
				speed: 5,
				states: [
					{
						type: "INTRO",
						filename: "telly-appear.png",
						offsetX: -107,
						offsetY: -195,
						numFrames: 16
					},{
						type: "RIDE",
						filename: "telly.png",
						numFrames: 24,
						autoStart: true,
						frameRate: 10,
						loop: true,
						offsetX: -109,
						offsetY: -150
					}
				]
			},
			dataPoints: [ 
				{ i: 0, x: 390, y: 600 },
				{ i: 1, x: 311, y: 345 },
				{ i: 2, x: 521, y: 188 },
				{ i: 3, x: 739, y: 346 },
				{ i: 4, x: 657, y: 598 }
			],
			hintPaths: [
				[ 0, 1, 2, 3, 4, 0 ]
			],
			successPath: [ 0, 1, 2, 3, 4, 0 ],
			targetItems: [
				{ filename: "pentagon-01.png", x: 361, y: 535 },
				{ filename: "pentagon-02.png", x: 343, y: 496 },
				{ filename: "pentagon-03.png", x: 334, y: 449 },
				{ filename: "pentagon-04.png", x: 320, y: 401 },
				{ filename: "pentagon-05.png", x: 308, y: 366 },
				{ filename: "pentagon-06.png", x: 303, y: 284 },
				{ filename: "pentagon-07.png", x: 364, y: 259 },
				{ filename: "pentagon-08.png", x: 409, y: 228 },
				{ filename: "pentagon-09.png", x: 454, y: 191 },
				{ filename: "pentagon-10.png", x: 503, y: 181 },
				{ filename: "pentagon-11.png", x: 546, y: 195 },
				{ filename: "pentagon-12.png", x: 591, y: 227 },
				{ filename: "pentagon-13.png", x: 636, y: 259 },
				{ filename: "pentagon-14.png", x: 681, y: 284 },
				{ filename: "pentagon-15.png", x: 591, y: 366 },
				{ filename: "pentagon-16.png", x: 596, y: 401 },
				{ filename: "pentagon-17.png", x: 581, y: 449 },
				{ filename: "pentagon-18.png", x: 581, y: 496 },
				{ filename: "pentagon-19.png", x: 617, y: 535 },
				{ filename: "pentagon-20.png", x: 581, y: 535 },
				{ filename: "pentagon-21.png", x: 542, y: 496 },
				{ filename: "pentagon-22.png", x: 503, y: 496 },
				{ filename: "pentagon-23.png", x: 464, y: 496 },
				{ filename: "pentagon-24.png", x: 428, y: 535 }
			],
			payoff: { filename: "pentagon-payoff.png", x: 304, y: 182 }
		}
	]
};