function addLoadEvent(func) {
  var oldonload = window.onload;
  if (typeof window.onload != 'function') {
    window.onload = func;
  } else {
    window.onload = function() {
      if (oldonload) {
        oldonload();
      }
      func();
    }
  }
}

function initApp(){
	var language,
		site = getCookie('site');

	if(site == undefined){
		language = getLanguage();

		switch(language){
			case 'es':
				document.getElementById('choise-country').style.display = 'block';
			break;

			case 'pt':
				goUrl('br', true);
			break;

			case 'en':
				goUrl('en', true);
			break;
		}
	}else{
		goUrl(site, false);
	}
}


function goUrl(site, writeCookie){
	var siteUrl,
		arrSites = [];

	if(writeCookie)
		setCookie('site',site,730);

	arrSites['br'] = 'http://m.terra.com.br';
	arrSites['en'] = 'http://m.terra.com';
	arrSites['ar'] = 'http://m.terra.com.ar';
	arrSites['cl'] = 'http://m.terra.cl';
	arrSites['co'] = 'http://m.terra.com.co';
	arrSites['es'] = 'http://m.terra.es';
	arrSites['mx'] = 'http://m.terra.com.mx';
	arrSites['pe'] = 'http://m.terra.com.pe';
	
	if(site == undefined || site == '')
		site = 'en';

	window.location = arrSites[site];
}

function getLanguage(){
	var x,
		EnumLanguage = ['en','pt','es'],
		language = 'en',
		browserLanguage = navigator.language;

	if (browserLanguage != undefined || browserLanguage != ''){
		var temp = browserLanguage.split('-');

		for(x in EnumLanguage){
			if(EnumLanguage[x] == temp[0]){
				language = temp[0];
			}
		}
	}
	
	return language;	
}

function setCookie(c_name,value,exdays){
	var exdate=new Date();
	exdate.setDate(exdate.getDate() + exdays);
	var c_value=escape(value) + ((exdays==null) ? "" : "; expires="+exdate.toUTCString());
	document.cookie=c_name + "=" + c_value;
}

function getCookie(c_name){
	var i,x,y,ARRcookies=document.cookie.split(";");

	for (i=0;i<ARRcookies.length;i++){
		x=ARRcookies[i].substr(0,ARRcookies[i].indexOf("="));
		y=ARRcookies[i].substr(ARRcookies[i].indexOf("=")+1);
		x=x.replace(/^\s+|\s+$/g,"");

		if (x==c_name){
			return unescape(y);
		}
	}
}

addLoadEvent(initApp);