SettingsView = BaseView.extend({
    
    template: Handlebars.templates.settings,
    m_parameters : JSON.parse(localStorage.getItem("parameters")) || {},
    initialize: function()
      {
	  
	  SettingsView.__super__.initialize.call(this,arguments);
      },

    events : 
      {
	  "change input[name=options-theme]" : "on_radioTheme_changed",
	  "change input[name=options-lang]"  : "on_radioLang_changed",
	  "change input[name=options-map]"   : "on_radioMap_changed"
      },
    
    on_radioTheme_changed: function(e)
      {
	  this.m_parameters.theme = $(e.currentTarget).attr('data-value');
	  localStorage.setItem("parameters",JSON.stringify(this.m_parameters));
	  $("body")
	      .removeClass("dark")
	      .removeClass("light")
	      .addClass(this.m_parameters.theme);
      },

    on_radioLang_changed : function(e)
      {
	  this.m_parameters.lang = $(e.currentTarget).attr('data-value');
	  localStorage.setItem("parameters",JSON.stringify(this.m_parameters));
	  I18n.setLang({
	      lang :this.m_parameters.lang,
	      success : function(){}
	  });
	  this.translate();
      },

    on_radioMap_changed : function(e)
      {
	  this.m_parameters.map = $(e.currentTarget).attr('data-value');
	  localStorage.setItem("parameters",JSON.stringify(this.m_parameters));
      },

    render: function()
      {
	  console.log("HomeView::render");
	  $(this.el).html(this.template());
	  $("[data-value='" + this.m_parameters.theme + "']").parent().addClass("active");
	  $("[data-value='" + this.m_parameters.lang + "']").parent().addClass("active");
	  $("[data-value='" + this.m_parameters.map + "']").parent().addClass("active");
	  SettingsView.__super__.render.call(this,arguments);
	  return this;
      }
});
