// EmToucho: Touch event hack for Emscripten-based SDL 1.2 apps
// Copyright (c) 2014 Thomas Perl <m@thp.io>

EmToucho = {
    // Constants for events
    PRESS: 0,
    MOVE: 1,
    RELEASE: 2,

    currentEvent: undefined,
    eventQueue: [], // [{id: id1, state: PRESS, x: x1, y: y1}, ...]

    mapEvent: function (state, element, event) {
        // http://stackoverflow.com/questions/15344173
        var result = { id: event.identifier, state: state, x: event.pageX, y: event.pageY };

        do {
            result.x -= element.offsetLeft;
            result.y -= element.offsetTop;
            result.x += element.scrollLeft;
            result.y += element.scrollTop;
        } while (element = element.offsetParent);

        return result;
    },

    install: function () {
        var c = Module.canvas;
        var q = EmToucho.eventQueue;

        c.addEventListener('touchstart', function (event) {
            for (var i=0; i<event.changedTouches.length; i++) {
                q.push(EmToucho.mapEvent(EmToucho.PRESS, c, event.changedTouches[i]));
            }
            event.preventDefault();
        });
        c.addEventListener('touchmove', function (event) {
            for (var i=0; i<event.changedTouches.length; i++) {
                q.push(EmToucho.mapEvent(EmToucho.MOVE, c, event.changedTouches[i]));
            }
            event.preventDefault();
        });
        c.addEventListener('touchend', function (event) {
            for (var i=0; i<event.changedTouches.length; i++) {
                q.push(EmToucho.mapEvent(EmToucho.RELEASE, c, event.changedTouches[i]));
            }
            event.preventDefault();
        });
        c.addEventListener('touchcancel', function (event) {
            for (var i=0; i<event.changedTouches.length; i++) {
                q.push(EmToucho.mapEvent(EmToucho.RELEASE, c, event.changedTouches[i]));
            }
            event.preventDefault();
        });
    }
};

EmToucho.install();
