// Note: For maximum-speed code, see "Optimizing Code" on the Emscripten wiki, https://github.com/kripken/emscripten/wiki/Optimizing-Code
// Note: Some Emscripten settings may limit the speed of the generated code.
// The Module object: Our interface to the outside world. We import
// and export values on it, and do the work to get that through
// closure compiler if necessary. There are various ways Module can be used:
// 1. Not defined. We create it here
// 2. A function parameter, function(Module) { ..generated code.. }
// 3. pre-run appended it, var Module = {}; ..generated code..
// 4. External script tag defines var Module.
// We need to do an eval in order to handle the closure compiler
// case, where this code here is minified but Module was defined
// elsewhere (e.g. case 4 above). We also need to check if Module
// already exists (e.g. case 3 above).
// Note that if you want to run closure, and also to use Module
// after the generated code, you will need to define   var Module = {};
// before the code. Then that object will be used in the code, and you
// can continue to use Module afterwards as well.
var Module;
if (!Module) Module = eval('(function() { try { return Module || {} } catch(e) { return {} } })()');
// Sometimes an existing Module object exists with properties
// meant to overwrite the default module functionality. Here
// we collect those properties and reapply _after_ we configure
// the current environment's defaults to avoid having to be so
// defensive during initialization.
var moduleOverrides = {};
for (var key in Module) {
  if (Module.hasOwnProperty(key)) {
    moduleOverrides[key] = Module[key];
  }
}
// The environment setup code below is customized to use Module.
// *** Environment setup code ***
var ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof require === 'function';
var ENVIRONMENT_IS_WEB = typeof window === 'object';
var ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
var ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;
if (ENVIRONMENT_IS_NODE) {
  // Expose functionality in the same simple way that the shells work
  // Note that we pollute the global namespace here, otherwise we break in node
  Module['print'] = function print(x) {
    process['stdout'].write(x + '\n');
  };
  Module['printErr'] = function printErr(x) {
    process['stderr'].write(x + '\n');
  };
  var nodeFS = require('fs');
  var nodePath = require('path');
  Module['read'] = function read(filename, binary) {
    filename = nodePath['normalize'](filename);
    var ret = nodeFS['readFileSync'](filename);
    // The path is absolute if the normalized version is the same as the resolved.
    if (!ret && filename != nodePath['resolve'](filename)) {
      filename = path.join(__dirname, '..', 'src', filename);
      ret = nodeFS['readFileSync'](filename);
    }
    if (ret && !binary) ret = ret.toString();
    return ret;
  };
  Module['readBinary'] = function readBinary(filename) { return Module['read'](filename, true) };
  Module['load'] = function load(f) {
    globalEval(read(f));
  };
  Module['arguments'] = process['argv'].slice(2);
  module['exports'] = Module;
}
else if (ENVIRONMENT_IS_SHELL) {
  Module['print'] = print;
  if (typeof printErr != 'undefined') Module['printErr'] = printErr; // not present in v8 or older sm
  if (typeof read != 'undefined') {
    Module['read'] = read;
  } else {
    Module['read'] = function read() { throw 'no read() available (jsc?)' };
  }
  Module['readBinary'] = function readBinary(f) {
    return read(f, 'binary');
  };
  if (typeof scriptArgs != 'undefined') {
    Module['arguments'] = scriptArgs;
  } else if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }
  this['Module'] = Module;
  eval("if (typeof gc === 'function' && gc.toString().indexOf('[native code]') > 0) var gc = undefined"); // wipe out the SpiderMonkey shell 'gc' function, which can confuse closure (uses it as a minified name, and it is then initted to a non-falsey value unexpectedly)
}
else if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
  Module['read'] = function read(url) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, false);
    xhr.send(null);
    return xhr.responseText;
  };
  if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }
  if (typeof console !== 'undefined') {
    Module['print'] = function print(x) {
      console.log(x);
    };
    Module['printErr'] = function printErr(x) {
      console.log(x);
    };
  } else {
    // Probably a worker, and without console.log. We can do very little here...
    var TRY_USE_DUMP = false;
    Module['print'] = (TRY_USE_DUMP && (typeof(dump) !== "undefined") ? (function(x) {
      dump(x);
    }) : (function(x) {
      // self.postMessage(x); // enable this if you want stdout to be sent as messages
    }));
  }
  if (ENVIRONMENT_IS_WEB) {
    this['Module'] = Module;
  } else {
    Module['load'] = importScripts;
  }
}
else {
  // Unreachable because SHELL is dependant on the others
  throw 'Unknown runtime environment. Where are we?';
}
function globalEval(x) {
  eval.call(null, x);
}
if (!Module['load'] == 'undefined' && Module['read']) {
  Module['load'] = function load(f) {
    globalEval(Module['read'](f));
  };
}
if (!Module['print']) {
  Module['print'] = function(){};
}
if (!Module['printErr']) {
  Module['printErr'] = Module['print'];
}
if (!Module['arguments']) {
  Module['arguments'] = [];
}
// *** Environment setup code ***
// Closure helpers
Module.print = Module['print'];
Module.printErr = Module['printErr'];
// Callbacks
Module['preRun'] = [];
Module['postRun'] = [];
// Merge back in the overrides
for (var key in moduleOverrides) {
  if (moduleOverrides.hasOwnProperty(key)) {
    Module[key] = moduleOverrides[key];
  }
}
// === Auto-generated preamble library stuff ===
//========================================
// Runtime code shared with compiler
//========================================
var Runtime = {
  stackSave: function () {
    return STACKTOP;
  },
  stackRestore: function (stackTop) {
    STACKTOP = stackTop;
  },
  forceAlign: function (target, quantum) {
    quantum = quantum || 4;
    if (quantum == 1) return target;
    if (isNumber(target) && isNumber(quantum)) {
      return Math.ceil(target/quantum)*quantum;
    } else if (isNumber(quantum) && isPowerOfTwo(quantum)) {
      return '(((' +target + ')+' + (quantum-1) + ')&' + -quantum + ')';
    }
    return 'Math.ceil((' + target + ')/' + quantum + ')*' + quantum;
  },
  isNumberType: function (type) {
    return type in Runtime.INT_TYPES || type in Runtime.FLOAT_TYPES;
  },
  isPointerType: function isPointerType(type) {
  return type[type.length-1] == '*';
},
  isStructType: function isStructType(type) {
  if (isPointerType(type)) return false;
  if (isArrayType(type)) return true;
  if (/<?{ ?[^}]* ?}>?/.test(type)) return true; // { i32, i8 } etc. - anonymous struct types
  // See comment in isStructPointerType()
  return type[0] == '%';
},
  INT_TYPES: {"i1":0,"i8":0,"i16":0,"i32":0,"i64":0},
  FLOAT_TYPES: {"float":0,"double":0},
  or64: function (x, y) {
    var l = (x | 0) | (y | 0);
    var h = (Math.round(x / 4294967296) | Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  and64: function (x, y) {
    var l = (x | 0) & (y | 0);
    var h = (Math.round(x / 4294967296) & Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  xor64: function (x, y) {
    var l = (x | 0) ^ (y | 0);
    var h = (Math.round(x / 4294967296) ^ Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  getNativeTypeSize: function (type) {
    switch (type) {
      case 'i1': case 'i8': return 1;
      case 'i16': return 2;
      case 'i32': return 4;
      case 'i64': return 8;
      case 'float': return 4;
      case 'double': return 8;
      default: {
        if (type[type.length-1] === '*') {
          return Runtime.QUANTUM_SIZE; // A pointer
        } else if (type[0] === 'i') {
          var bits = parseInt(type.substr(1));
          assert(bits % 8 === 0);
          return bits/8;
        } else {
          return 0;
        }
      }
    }
  },
  getNativeFieldSize: function (type) {
    return Math.max(Runtime.getNativeTypeSize(type), Runtime.QUANTUM_SIZE);
  },
  dedup: function dedup(items, ident) {
  var seen = {};
  if (ident) {
    return items.filter(function(item) {
      if (seen[item[ident]]) return false;
      seen[item[ident]] = true;
      return true;
    });
  } else {
    return items.filter(function(item) {
      if (seen[item]) return false;
      seen[item] = true;
      return true;
    });
  }
},
  set: function set() {
  var args = typeof arguments[0] === 'object' ? arguments[0] : arguments;
  var ret = {};
  for (var i = 0; i < args.length; i++) {
    ret[args[i]] = 0;
  }
  return ret;
},
  STACK_ALIGN: 8,
  getAlignSize: function (type, size, vararg) {
    // we align i64s and doubles on 64-bit boundaries, unlike x86
    if (type == 'i64' || type == 'double' || vararg) return 8;
    if (!type) return Math.min(size, 8); // align structures internally to 64 bits
    return Math.min(size || (type ? Runtime.getNativeFieldSize(type) : 0), Runtime.QUANTUM_SIZE);
  },
  calculateStructAlignment: function calculateStructAlignment(type) {
    type.flatSize = 0;
    type.alignSize = 0;
    var diffs = [];
    var prev = -1;
    var index = 0;
    type.flatIndexes = type.fields.map(function(field) {
      index++;
      var size, alignSize;
      if (Runtime.isNumberType(field) || Runtime.isPointerType(field)) {
        size = Runtime.getNativeTypeSize(field); // pack char; char; in structs, also char[X]s.
        alignSize = Runtime.getAlignSize(field, size);
      } else if (Runtime.isStructType(field)) {
        if (field[1] === '0') {
          // this is [0 x something]. When inside another structure like here, it must be at the end,
          // and it adds no size
          // XXX this happens in java-nbody for example... assert(index === type.fields.length, 'zero-length in the middle!');
          size = 0;
          if (Types.types[field]) {
            alignSize = Runtime.getAlignSize(null, Types.types[field].alignSize);
          } else {
            alignSize = type.alignSize || QUANTUM_SIZE;
          }
        } else {
          size = Types.types[field].flatSize;
          alignSize = Runtime.getAlignSize(null, Types.types[field].alignSize);
        }
      } else if (field[0] == 'b') {
        // bN, large number field, like a [N x i8]
        size = field.substr(1)|0;
        alignSize = 1;
      } else if (field[0] === '<') {
        // vector type
        size = alignSize = Types.types[field].flatSize; // fully aligned
      } else if (field[0] === 'i') {
        // illegal integer field, that could not be legalized because it is an internal structure field
        // it is ok to have such fields, if we just use them as markers of field size and nothing more complex
        size = alignSize = parseInt(field.substr(1))/8;
        assert(size % 1 === 0, 'cannot handle non-byte-size field ' + field);
      } else {
        assert(false, 'invalid type for calculateStructAlignment');
      }
      if (type.packed) alignSize = 1;
      type.alignSize = Math.max(type.alignSize, alignSize);
      var curr = Runtime.alignMemory(type.flatSize, alignSize); // if necessary, place this on aligned memory
      type.flatSize = curr + size;
      if (prev >= 0) {
        diffs.push(curr-prev);
      }
      prev = curr;
      return curr;
    });
    if (type.name_[0] === '[') {
      // arrays have 2 elements, so we get the proper difference. then we scale here. that way we avoid
      // allocating a potentially huge array for [999999 x i8] etc.
      type.flatSize = parseInt(type.name_.substr(1))*type.flatSize/2;
    }
    type.flatSize = Runtime.alignMemory(type.flatSize, type.alignSize);
    if (diffs.length == 0) {
      type.flatFactor = type.flatSize;
    } else if (Runtime.dedup(diffs).length == 1) {
      type.flatFactor = diffs[0];
    }
    type.needsFlattening = (type.flatFactor != 1);
    return type.flatIndexes;
  },
  generateStructInfo: function (struct, typeName, offset) {
    var type, alignment;
    if (typeName) {
      offset = offset || 0;
      type = (typeof Types === 'undefined' ? Runtime.typeInfo : Types.types)[typeName];
      if (!type) return null;
      if (type.fields.length != struct.length) {
        printErr('Number of named fields must match the type for ' + typeName + ': possibly duplicate struct names. Cannot return structInfo');
        return null;
      }
      alignment = type.flatIndexes;
    } else {
      var type = { fields: struct.map(function(item) { return item[0] }) };
      alignment = Runtime.calculateStructAlignment(type);
    }
    var ret = {
      __size__: type.flatSize
    };
    if (typeName) {
      struct.forEach(function(item, i) {
        if (typeof item === 'string') {
          ret[item] = alignment[i] + offset;
        } else {
          // embedded struct
          var key;
          for (var k in item) key = k;
          ret[key] = Runtime.generateStructInfo(item[key], type.fields[i], alignment[i]);
        }
      });
    } else {
      struct.forEach(function(item, i) {
        ret[item[1]] = alignment[i];
      });
    }
    return ret;
  },
  dynCall: function (sig, ptr, args) {
    if (args && args.length) {
      if (!args.splice) args = Array.prototype.slice.call(args);
      args.splice(0, 0, ptr);
      return Module['dynCall_' + sig].apply(null, args);
    } else {
      return Module['dynCall_' + sig].call(null, ptr);
    }
  },
  functionPointers: [],
  addFunction: function (func) {
    for (var i = 0; i < Runtime.functionPointers.length; i++) {
      if (!Runtime.functionPointers[i]) {
        Runtime.functionPointers[i] = func;
        return 2*(1 + i);
      }
    }
    throw 'Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.';
  },
  removeFunction: function (index) {
    Runtime.functionPointers[(index-2)/2] = null;
  },
  getAsmConst: function (code, numArgs) {
    // code is a constant string on the heap, so we can cache these
    if (!Runtime.asmConstCache) Runtime.asmConstCache = {};
    var func = Runtime.asmConstCache[code];
    if (func) return func;
    var args = [];
    for (var i = 0; i < numArgs; i++) {
      args.push(String.fromCharCode(36) + i); // $0, $1 etc
    }
    return Runtime.asmConstCache[code] = eval('(function(' + args.join(',') + '){ ' + Pointer_stringify(code) + ' })'); // new Function does not allow upvars in node
  },
  warnOnce: function (text) {
    if (!Runtime.warnOnce.shown) Runtime.warnOnce.shown = {};
    if (!Runtime.warnOnce.shown[text]) {
      Runtime.warnOnce.shown[text] = 1;
      Module.printErr(text);
    }
  },
  funcWrappers: {},
  getFuncWrapper: function (func, sig) {
    assert(sig);
    if (!Runtime.funcWrappers[func]) {
      Runtime.funcWrappers[func] = function dynCall_wrapper() {
        return Runtime.dynCall(sig, func, arguments);
      };
    }
    return Runtime.funcWrappers[func];
  },
  UTF8Processor: function () {
    var buffer = [];
    var needed = 0;
    this.processCChar = function (code) {
      code = code & 0xFF;
      if (buffer.length == 0) {
        if ((code & 0x80) == 0x00) {        // 0xxxxxxx
          return String.fromCharCode(code);
        }
        buffer.push(code);
        if ((code & 0xE0) == 0xC0) {        // 110xxxxx
          needed = 1;
        } else if ((code & 0xF0) == 0xE0) { // 1110xxxx
          needed = 2;
        } else {                            // 11110xxx
          needed = 3;
        }
        return '';
      }
      if (needed) {
        buffer.push(code);
        needed--;
        if (needed > 0) return '';
      }
      var c1 = buffer[0];
      var c2 = buffer[1];
      var c3 = buffer[2];
      var c4 = buffer[3];
      var ret;
      if (buffer.length == 2) {
        ret = String.fromCharCode(((c1 & 0x1F) << 6)  | (c2 & 0x3F));
      } else if (buffer.length == 3) {
        ret = String.fromCharCode(((c1 & 0x0F) << 12) | ((c2 & 0x3F) << 6)  | (c3 & 0x3F));
      } else {
        // http://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
        var codePoint = ((c1 & 0x07) << 18) | ((c2 & 0x3F) << 12) |
                        ((c3 & 0x3F) << 6)  | (c4 & 0x3F);
        ret = String.fromCharCode(
          Math.floor((codePoint - 0x10000) / 0x400) + 0xD800,
          (codePoint - 0x10000) % 0x400 + 0xDC00);
      }
      buffer.length = 0;
      return ret;
    }
    this.processJSString = function processJSString(string) {
      string = unescape(encodeURIComponent(string));
      var ret = [];
      for (var i = 0; i < string.length; i++) {
        ret.push(string.charCodeAt(i));
      }
      return ret;
    }
  },
  stackAlloc: function (size) { var ret = STACKTOP;STACKTOP = (STACKTOP + size)|0;STACKTOP = (((STACKTOP)+7)&-8); return ret; },
  staticAlloc: function (size) { var ret = STATICTOP;STATICTOP = (STATICTOP + size)|0;STATICTOP = (((STATICTOP)+7)&-8); return ret; },
  dynamicAlloc: function (size) { var ret = DYNAMICTOP;DYNAMICTOP = (DYNAMICTOP + size)|0;DYNAMICTOP = (((DYNAMICTOP)+7)&-8); if (DYNAMICTOP >= TOTAL_MEMORY) enlargeMemory();; return ret; },
  alignMemory: function (size,quantum) { var ret = size = Math.ceil((size)/(quantum ? quantum : 8))*(quantum ? quantum : 8); return ret; },
  makeBigInt: function (low,high,unsigned) { var ret = (unsigned ? ((+((low>>>0)))+((+((high>>>0)))*(+4294967296))) : ((+((low>>>0)))+((+((high|0)))*(+4294967296)))); return ret; },
  GLOBAL_BASE: 8,
  QUANTUM_SIZE: 4,
  __dummy__: 0
}
//========================================
// Runtime essentials
//========================================
var __THREW__ = 0; // Used in checking for thrown exceptions.
var ABORT = false; // whether we are quitting the application. no code should run after this. set in exit() and abort()
var EXITSTATUS = 0;
var undef = 0;
// tempInt is used for 32-bit signed values or smaller. tempBigInt is used
// for 32-bit unsigned values or more than 32 bits. TODO: audit all uses of tempInt
var tempValue, tempInt, tempBigInt, tempInt2, tempBigInt2, tempPair, tempBigIntI, tempBigIntR, tempBigIntS, tempBigIntP, tempBigIntD, tempDouble, tempFloat;
var tempI64, tempI64b;
var tempRet0, tempRet1, tempRet2, tempRet3, tempRet4, tempRet5, tempRet6, tempRet7, tempRet8, tempRet9;
function assert(condition, text) {
  if (!condition) {
    abort('Assertion failed: ' + text);
  }
}
var globalScope = this;
// C calling interface. A convenient way to call C functions (in C files, or
// defined with extern "C").
//
// Note: LLVM optimizations can inline and remove functions, after which you will not be
//       able to call them. Closure can also do so. To avoid that, add your function to
//       the exports using something like
//
//         -s EXPORTED_FUNCTIONS='["_main", "_myfunc"]'
//
// @param ident      The name of the C function (note that C++ functions will be name-mangled - use extern "C")
// @param returnType The return type of the function, one of the JS types 'number', 'string' or 'array' (use 'number' for any C pointer, and
//                   'array' for JavaScript arrays and typed arrays; note that arrays are 8-bit).
// @param argTypes   An array of the types of arguments for the function (if there are no arguments, this can be ommitted). Types are as in returnType,
//                   except that 'array' is not possible (there is no way for us to know the length of the array)
// @param args       An array of the arguments to the function, as native JS values (as in returnType)
//                   Note that string arguments will be stored on the stack (the JS string will become a C string on the stack).
// @return           The return value, as a native JS value (as in returnType)
function ccall(ident, returnType, argTypes, args) {
  return ccallFunc(getCFunc(ident), returnType, argTypes, args);
}
Module["ccall"] = ccall;
// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
  try {
    var func = Module['_' + ident]; // closure exported function
    if (!func) func = eval('_' + ident); // explicit lookup
  } catch(e) {
  }
  assert(func, 'Cannot call unknown function ' + ident + ' (perhaps LLVM optimizations or closure removed it?)');
  return func;
}
// Internal function that does a C call using a function, not an identifier
function ccallFunc(func, returnType, argTypes, args) {
  var stack = 0;
  function toC(value, type) {
    if (type == 'string') {
      if (value === null || value === undefined || value === 0) return 0; // null string
      value = intArrayFromString(value);
      type = 'array';
    }
    if (type == 'array') {
      if (!stack) stack = Runtime.stackSave();
      var ret = Runtime.stackAlloc(value.length);
      writeArrayToMemory(value, ret);
      return ret;
    }
    return value;
  }
  function fromC(value, type) {
    if (type == 'string') {
      return Pointer_stringify(value);
    }
    assert(type != 'array');
    return value;
  }
  var i = 0;
  var cArgs = args ? args.map(function(arg) {
    return toC(arg, argTypes[i++]);
  }) : [];
  var ret = fromC(func.apply(null, cArgs), returnType);
  if (stack) Runtime.stackRestore(stack);
  return ret;
}
// Returns a native JS wrapper for a C function. This is similar to ccall, but
// returns a function you can call repeatedly in a normal way. For example:
//
//   var my_function = cwrap('my_c_function', 'number', ['number', 'number']);
//   alert(my_function(5, 22));
//   alert(my_function(99, 12));
//
function cwrap(ident, returnType, argTypes) {
  var func = getCFunc(ident);
  return function() {
    return ccallFunc(func, returnType, argTypes, Array.prototype.slice.call(arguments));
  }
}
Module["cwrap"] = cwrap;
// Sets a value in memory in a dynamic way at run-time. Uses the
// type data. This is the same as makeSetValue, except that
// makeSetValue is done at compile-time and generates the needed
// code then, whereas this function picks the right code at
// run-time.
// Note that setValue and getValue only do *aligned* writes and reads!
// Note that ccall uses JS types as for defining types, while setValue and
// getValue need LLVM types ('i8', 'i32') - this is a lower-level operation
function setValue(ptr, value, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': HEAP8[(ptr)]=value; break;
      case 'i8': HEAP8[(ptr)]=value; break;
      case 'i16': HEAP16[((ptr)>>1)]=value; break;
      case 'i32': HEAP32[((ptr)>>2)]=value; break;
      case 'i64': (tempI64 = [value>>>0,(tempDouble=value,(+(Math_abs(tempDouble))) >= (+1) ? (tempDouble > (+0) ? ((Math_min((+(Math_floor((tempDouble)/(+4294967296)))), (+4294967295)))|0)>>>0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble)))>>>0))/(+4294967296))))))>>>0) : 0)],HEAP32[((ptr)>>2)]=tempI64[0],HEAP32[(((ptr)+(4))>>2)]=tempI64[1]); break;
      case 'float': HEAPF32[((ptr)>>2)]=value; break;
      case 'double': HEAPF64[((ptr)>>3)]=value; break;
      default: abort('invalid type for setValue: ' + type);
    }
}
Module['setValue'] = setValue;
// Parallel to setValue.
function getValue(ptr, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': return HEAP8[(ptr)];
      case 'i8': return HEAP8[(ptr)];
      case 'i16': return HEAP16[((ptr)>>1)];
      case 'i32': return HEAP32[((ptr)>>2)];
      case 'i64': return HEAP32[((ptr)>>2)];
      case 'float': return HEAPF32[((ptr)>>2)];
      case 'double': return HEAPF64[((ptr)>>3)];
      default: abort('invalid type for setValue: ' + type);
    }
  return null;
}
Module['getValue'] = getValue;
var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call
var ALLOC_STATIC = 2; // Cannot be freed
var ALLOC_DYNAMIC = 3; // Cannot be freed except through sbrk
var ALLOC_NONE = 4; // Do not allocate
Module['ALLOC_NORMAL'] = ALLOC_NORMAL;
Module['ALLOC_STACK'] = ALLOC_STACK;
Module['ALLOC_STATIC'] = ALLOC_STATIC;
Module['ALLOC_DYNAMIC'] = ALLOC_DYNAMIC;
Module['ALLOC_NONE'] = ALLOC_NONE;
// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data, or a number. If a number, then the size of the block to allocate,
//        in *bytes* (note that this is sometimes confusing: the next parameter does not
//        affect this!)
// @types: Either an array of types, one for each byte (or 0 if no type at that position),
//         or a single type which is used for the entire block. This only matters if there
//         is initial data - if @slab is a number, then this does not matter at all and is
//         ignored.
// @allocator: How to allocate memory, see ALLOC_*
function allocate(slab, types, allocator, ptr) {
  var zeroinit, size;
  if (typeof slab === 'number') {
    zeroinit = true;
    size = slab;
  } else {
    zeroinit = false;
    size = slab.length;
  }
  var singleType = typeof types === 'string' ? types : null;
  var ret;
  if (allocator == ALLOC_NONE) {
    ret = ptr;
  } else {
    ret = [_malloc, Runtime.stackAlloc, Runtime.staticAlloc, Runtime.dynamicAlloc][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length));
  }
  if (zeroinit) {
    var ptr = ret, stop;
    assert((ret & 3) == 0);
    stop = ret + (size & ~3);
    for (; ptr < stop; ptr += 4) {
      HEAP32[((ptr)>>2)]=0;
    }
    stop = ret + size;
    while (ptr < stop) {
      HEAP8[((ptr++)|0)]=0;
    }
    return ret;
  }
  if (singleType === 'i8') {
    if (slab.subarray || slab.slice) {
      HEAPU8.set(slab, ret);
    } else {
      HEAPU8.set(new Uint8Array(slab), ret);
    }
    return ret;
  }
  var i = 0, type, typeSize, previousType;
  while (i < size) {
    var curr = slab[i];
    if (typeof curr === 'function') {
      curr = Runtime.getFunctionIndex(curr);
    }
    type = singleType || types[i];
    if (type === 0) {
      i++;
      continue;
    }
    if (type == 'i64') type = 'i32'; // special case: we have one i32 here, and one i32 later
    setValue(ret+i, curr, type);
    // no need to look up size unless type changes, so cache it
    if (previousType !== type) {
      typeSize = Runtime.getNativeTypeSize(type);
      previousType = type;
    }
    i += typeSize;
  }
  return ret;
}
Module['allocate'] = allocate;
function Pointer_stringify(ptr, /* optional */ length) {
  // TODO: use TextDecoder
  // Find the length, and check for UTF while doing so
  var hasUtf = false;
  var t;
  var i = 0;
  while (1) {
    t = HEAPU8[(((ptr)+(i))|0)];
    if (t >= 128) hasUtf = true;
    else if (t == 0 && !length) break;
    i++;
    if (length && i == length) break;
  }
  if (!length) length = i;
  var ret = '';
  if (!hasUtf) {
    var MAX_CHUNK = 1024; // split up into chunks, because .apply on a huge string can overflow the stack
    var curr;
    while (length > 0) {
      curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)));
      ret = ret ? ret + curr : curr;
      ptr += MAX_CHUNK;
      length -= MAX_CHUNK;
    }
    return ret;
  }
  var utf8 = new Runtime.UTF8Processor();
  for (i = 0; i < length; i++) {
    t = HEAPU8[(((ptr)+(i))|0)];
    ret += utf8.processCChar(t);
  }
  return ret;
}
Module['Pointer_stringify'] = Pointer_stringify;
// Given a pointer 'ptr' to a null-terminated UTF16LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.
function UTF16ToString(ptr) {
  var i = 0;
  var str = '';
  while (1) {
    var codeUnit = HEAP16[(((ptr)+(i*2))>>1)];
    if (codeUnit == 0)
      return str;
    ++i;
    // fromCharCode constructs a character from a UTF-16 code unit, so we can pass the UTF16 string right through.
    str += String.fromCharCode(codeUnit);
  }
}
Module['UTF16ToString'] = UTF16ToString;
// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr', 
// null-terminated and encoded in UTF16LE form. The copy will require at most (str.length*2+1)*2 bytes of space in the HEAP.
function stringToUTF16(str, outPtr) {
  for(var i = 0; i < str.length; ++i) {
    // charCodeAt returns a UTF-16 encoded code unit, so it can be directly written to the HEAP.
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    HEAP16[(((outPtr)+(i*2))>>1)]=codeUnit
  }
  // Null-terminate the pointer to the HEAP.
  HEAP16[(((outPtr)+(str.length*2))>>1)]=0
}
Module['stringToUTF16'] = stringToUTF16;
// Given a pointer 'ptr' to a null-terminated UTF32LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.
function UTF32ToString(ptr) {
  var i = 0;
  var str = '';
  while (1) {
    var utf32 = HEAP32[(((ptr)+(i*4))>>2)];
    if (utf32 == 0)
      return str;
    ++i;
    // Gotcha: fromCharCode constructs a character from a UTF-16 encoded code (pair), not from a Unicode code point! So encode the code point to UTF-16 for constructing.
    if (utf32 >= 0x10000) {
      var ch = utf32 - 0x10000;
      str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
    } else {
      str += String.fromCharCode(utf32);
    }
  }
}
Module['UTF32ToString'] = UTF32ToString;
// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr', 
// null-terminated and encoded in UTF32LE form. The copy will require at most (str.length+1)*4 bytes of space in the HEAP,
// but can use less, since str.length does not return the number of characters in the string, but the number of UTF-16 code units in the string.
function stringToUTF32(str, outPtr) {
  var iChar = 0;
  for(var iCodeUnit = 0; iCodeUnit < str.length; ++iCodeUnit) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    var codeUnit = str.charCodeAt(iCodeUnit); // possibly a lead surrogate
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) {
      var trailSurrogate = str.charCodeAt(++iCodeUnit);
      codeUnit = 0x10000 + ((codeUnit & 0x3FF) << 10) | (trailSurrogate & 0x3FF);
    }
    HEAP32[(((outPtr)+(iChar*4))>>2)]=codeUnit
    ++iChar;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP32[(((outPtr)+(iChar*4))>>2)]=0
}
Module['stringToUTF32'] = stringToUTF32;
function demangle(func) {
  try {
    if (typeof func === 'number') func = Pointer_stringify(func);
    if (func[0] !== '_') return func;
    if (func[1] !== '_') return func; // C function
    if (func[2] !== 'Z') return func;
    switch (func[3]) {
      case 'n': return 'operator new()';
      case 'd': return 'operator delete()';
    }
    var i = 3;
    // params, etc.
    var basicTypes = {
      'v': 'void',
      'b': 'bool',
      'c': 'char',
      's': 'short',
      'i': 'int',
      'l': 'long',
      'f': 'float',
      'd': 'double',
      'w': 'wchar_t',
      'a': 'signed char',
      'h': 'unsigned char',
      't': 'unsigned short',
      'j': 'unsigned int',
      'm': 'unsigned long',
      'x': 'long long',
      'y': 'unsigned long long',
      'z': '...'
    };
    function dump(x) {
      //return;
      if (x) Module.print(x);
      Module.print(func);
      var pre = '';
      for (var a = 0; a < i; a++) pre += ' ';
      Module.print (pre + '^');
    }
    var subs = [];
    function parseNested() {
      i++;
      if (func[i] === 'K') i++; // ignore const
      var parts = [];
      while (func[i] !== 'E') {
        if (func[i] === 'S') { // substitution
          i++;
          var next = func.indexOf('_', i);
          var num = func.substring(i, next) || 0;
          parts.push(subs[num] || '?');
          i = next+1;
          continue;
        }
        if (func[i] === 'C') { // constructor
          parts.push(parts[parts.length-1]);
          i += 2;
          continue;
        }
        var size = parseInt(func.substr(i));
        var pre = size.toString().length;
        if (!size || !pre) { i--; break; } // counter i++ below us
        var curr = func.substr(i + pre, size);
        parts.push(curr);
        subs.push(curr);
        i += pre + size;
      }
      i++; // skip E
      return parts;
    }
    var first = true;
    function parse(rawList, limit, allowVoid) { // main parser
      limit = limit || Infinity;
      var ret = '', list = [];
      function flushList() {
        return '(' + list.join(', ') + ')';
      }
      var name;
      if (func[i] === 'N') {
        // namespaced N-E
        name = parseNested().join('::');
        limit--;
        if (limit === 0) return rawList ? [name] : name;
      } else {
        // not namespaced
        if (func[i] === 'K' || (first && func[i] === 'L')) i++; // ignore const and first 'L'
        var size = parseInt(func.substr(i));
        if (size) {
          var pre = size.toString().length;
          name = func.substr(i + pre, size);
          i += pre + size;
        }
      }
      first = false;
      if (func[i] === 'I') {
        i++;
        var iList = parse(true);
        var iRet = parse(true, 1, true);
        ret += iRet[0] + ' ' + name + '<' + iList.join(', ') + '>';
      } else {
        ret = name;
      }
      paramLoop: while (i < func.length && limit-- > 0) {
        //dump('paramLoop');
        var c = func[i++];
        if (c in basicTypes) {
          list.push(basicTypes[c]);
        } else {
          switch (c) {
            case 'P': list.push(parse(true, 1, true)[0] + '*'); break; // pointer
            case 'R': list.push(parse(true, 1, true)[0] + '&'); break; // reference
            case 'L': { // literal
              i++; // skip basic type
              var end = func.indexOf('E', i);
              var size = end - i;
              list.push(func.substr(i, size));
              i += size + 2; // size + 'EE'
              break;
            }
            case 'A': { // array
              var size = parseInt(func.substr(i));
              i += size.toString().length;
              if (func[i] !== '_') throw '?';
              i++; // skip _
              list.push(parse(true, 1, true)[0] + ' [' + size + ']');
              break;
            }
            case 'E': break paramLoop;
            default: ret += '?' + c; break paramLoop;
          }
        }
      }
      if (!allowVoid && list.length === 1 && list[0] === 'void') list = []; // avoid (void)
      return rawList ? list : ret + flushList();
    }
    return parse();
  } catch(e) {
    return func;
  }
}
function demangleAll(text) {
  return text.replace(/__Z[\w\d_]+/g, function(x) { var y = demangle(x); return x === y ? x : (x + ' [' + y + ']') });
}
function stackTrace() {
  var stack = new Error().stack;
  return stack ? demangleAll(stack) : '(no stack trace available)'; // Stack trace is not available at least on IE10 and Safari 6.
}
// Memory management
var PAGE_SIZE = 4096;
function alignMemoryPage(x) {
  return (x+4095)&-4096;
}
var HEAP;
var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;
var STATIC_BASE = 0, STATICTOP = 0, staticSealed = false; // static area
var STACK_BASE = 0, STACKTOP = 0, STACK_MAX = 0; // stack area
var DYNAMIC_BASE = 0, DYNAMICTOP = 0; // dynamic area handled by sbrk
function enlargeMemory() {
  abort('Cannot enlarge memory arrays in asm.js. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value ' + TOTAL_MEMORY + ', or (2) set Module.TOTAL_MEMORY before the program runs.');
}
var TOTAL_STACK = Module['TOTAL_STACK'] || 5242880;
var TOTAL_MEMORY = Module['TOTAL_MEMORY'] || 16777216;
var FAST_MEMORY = Module['FAST_MEMORY'] || 2097152;
// Initialize the runtime's memory
// check for full engine support (use string 'subarray' to avoid closure compiler confusion)
assert(typeof Int32Array !== 'undefined' && typeof Float64Array !== 'undefined' && !!(new Int32Array(1)['subarray']) && !!(new Int32Array(1)['set']),
       'Cannot fallback to non-typed array case: Code is too specialized');
var buffer = new ArrayBuffer(TOTAL_MEMORY);
HEAP8 = new Int8Array(buffer);
HEAP16 = new Int16Array(buffer);
HEAP32 = new Int32Array(buffer);
HEAPU8 = new Uint8Array(buffer);
HEAPU16 = new Uint16Array(buffer);
HEAPU32 = new Uint32Array(buffer);
HEAPF32 = new Float32Array(buffer);
HEAPF64 = new Float64Array(buffer);
// Endianness check (note: assumes compiler arch was little-endian)
HEAP32[0] = 255;
assert(HEAPU8[0] === 255 && HEAPU8[3] === 0, 'Typed arrays 2 must be run on a little-endian system');
Module['HEAP'] = HEAP;
Module['HEAP8'] = HEAP8;
Module['HEAP16'] = HEAP16;
Module['HEAP32'] = HEAP32;
Module['HEAPU8'] = HEAPU8;
Module['HEAPU16'] = HEAPU16;
Module['HEAPU32'] = HEAPU32;
Module['HEAPF32'] = HEAPF32;
Module['HEAPF64'] = HEAPF64;
function callRuntimeCallbacks(callbacks) {
  while(callbacks.length > 0) {
    var callback = callbacks.shift();
    if (typeof callback == 'function') {
      callback();
      continue;
    }
    var func = callback.func;
    if (typeof func === 'number') {
      if (callback.arg === undefined) {
        Runtime.dynCall('v', func);
      } else {
        Runtime.dynCall('vi', func, [callback.arg]);
      }
    } else {
      func(callback.arg === undefined ? null : callback.arg);
    }
  }
}
var __ATPRERUN__  = []; // functions called before the runtime is initialized
var __ATINIT__    = []; // functions called during startup
var __ATMAIN__    = []; // functions called when main() is to be run
var __ATEXIT__    = []; // functions called during shutdown
var __ATPOSTRUN__ = []; // functions called after the runtime has exited
var runtimeInitialized = false;
function preRun() {
  // compatibility - merge in anything from Module['preRun'] at this time
  if (Module['preRun']) {
    if (typeof Module['preRun'] == 'function') Module['preRun'] = [Module['preRun']];
    while (Module['preRun'].length) {
      addOnPreRun(Module['preRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPRERUN__);
}
function ensureInitRuntime() {
  if (runtimeInitialized) return;
  runtimeInitialized = true;
  callRuntimeCallbacks(__ATINIT__);
}
function preMain() {
  callRuntimeCallbacks(__ATMAIN__);
}
function exitRuntime() {
  callRuntimeCallbacks(__ATEXIT__);
}
function postRun() {
  // compatibility - merge in anything from Module['postRun'] at this time
  if (Module['postRun']) {
    if (typeof Module['postRun'] == 'function') Module['postRun'] = [Module['postRun']];
    while (Module['postRun'].length) {
      addOnPostRun(Module['postRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPOSTRUN__);
}
function addOnPreRun(cb) {
  __ATPRERUN__.unshift(cb);
}
Module['addOnPreRun'] = Module.addOnPreRun = addOnPreRun;
function addOnInit(cb) {
  __ATINIT__.unshift(cb);
}
Module['addOnInit'] = Module.addOnInit = addOnInit;
function addOnPreMain(cb) {
  __ATMAIN__.unshift(cb);
}
Module['addOnPreMain'] = Module.addOnPreMain = addOnPreMain;
function addOnExit(cb) {
  __ATEXIT__.unshift(cb);
}
Module['addOnExit'] = Module.addOnExit = addOnExit;
function addOnPostRun(cb) {
  __ATPOSTRUN__.unshift(cb);
}
Module['addOnPostRun'] = Module.addOnPostRun = addOnPostRun;
// Tools
// This processes a JS string into a C-line array of numbers, 0-terminated.
// For LLVM-originating strings, see parser.js:parseLLVMString function
function intArrayFromString(stringy, dontAddNull, length /* optional */) {
  var ret = (new Runtime.UTF8Processor()).processJSString(stringy);
  if (length) {
    ret.length = length;
  }
  if (!dontAddNull) {
    ret.push(0);
  }
  return ret;
}
Module['intArrayFromString'] = intArrayFromString;
function intArrayToString(array) {
  var ret = [];
  for (var i = 0; i < array.length; i++) {
    var chr = array[i];
    if (chr > 0xFF) {
      chr &= 0xFF;
    }
    ret.push(String.fromCharCode(chr));
  }
  return ret.join('');
}
Module['intArrayToString'] = intArrayToString;
// Write a Javascript array to somewhere in the heap
function writeStringToMemory(string, buffer, dontAddNull) {
  var array = intArrayFromString(string, dontAddNull);
  var i = 0;
  while (i < array.length) {
    var chr = array[i];
    HEAP8[(((buffer)+(i))|0)]=chr
    i = i + 1;
  }
}
Module['writeStringToMemory'] = writeStringToMemory;
function writeArrayToMemory(array, buffer) {
  for (var i = 0; i < array.length; i++) {
    HEAP8[(((buffer)+(i))|0)]=array[i];
  }
}
Module['writeArrayToMemory'] = writeArrayToMemory;
function writeAsciiToMemory(str, buffer, dontAddNull) {
  for (var i = 0; i < str.length; i++) {
    HEAP8[(((buffer)+(i))|0)]=str.charCodeAt(i)
  }
  if (!dontAddNull) HEAP8[(((buffer)+(str.length))|0)]=0
}
Module['writeAsciiToMemory'] = writeAsciiToMemory;
function unSign(value, bits, ignore, sig) {
  if (value >= 0) {
    return value;
  }
  return bits <= 32 ? 2*Math.abs(1 << (bits-1)) + value // Need some trickery, since if bits == 32, we are right at the limit of the bits JS uses in bitshifts
                    : Math.pow(2, bits)         + value;
}
function reSign(value, bits, ignore, sig) {
  if (value <= 0) {
    return value;
  }
  var half = bits <= 32 ? Math.abs(1 << (bits-1)) // abs is needed if bits == 32
                        : Math.pow(2, bits-1);
  if (value >= half && (bits <= 32 || value > half)) { // for huge values, we can hit the precision limit and always get true here. so don't do that
                                                       // but, in general there is no perfect solution here. With 64-bit ints, we get rounding and errors
                                                       // TODO: In i64 mode 1, resign the two parts separately and safely
    value = -2*half + value; // Cannot bitshift half, as it may be at the limit of the bits JS uses in bitshifts
  }
  return value;
}
if (!Math['imul']) Math['imul'] = function imul(a, b) {
  var ah  = a >>> 16;
  var al = a & 0xffff;
  var bh  = b >>> 16;
  var bl = b & 0xffff;
  return (al*bl + ((ah*bl + al*bh) << 16))|0;
};
Math.imul = Math['imul'];
var Math_abs = Math.abs;
var Math_cos = Math.cos;
var Math_sin = Math.sin;
var Math_tan = Math.tan;
var Math_acos = Math.acos;
var Math_asin = Math.asin;
var Math_atan = Math.atan;
var Math_atan2 = Math.atan2;
var Math_exp = Math.exp;
var Math_log = Math.log;
var Math_sqrt = Math.sqrt;
var Math_ceil = Math.ceil;
var Math_floor = Math.floor;
var Math_pow = Math.pow;
var Math_imul = Math.imul;
var Math_fround = Math.fround;
var Math_min = Math.min;
// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// PRE_RUN_ADDITIONS (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyWatcher = null;
var dependenciesFulfilled = null; // overridden to take different actions when all run dependencies are fulfilled
function addRunDependency(id) {
  runDependencies++;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
}
Module['addRunDependency'] = addRunDependency;
function removeRunDependency(id) {
  runDependencies--;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    }
    if (dependenciesFulfilled) {
      var callback = dependenciesFulfilled;
      dependenciesFulfilled = null;
      callback(); // can add another dependenciesFulfilled
    }
  }
}
Module['removeRunDependency'] = removeRunDependency;
Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data
var memoryInitializer = null;
// === Body ===
STATIC_BASE = 8;
STATICTOP = STATIC_BASE + 154600;
var _stdout;
var _stdout=_stdout=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
var _stdin;
var _stdin=_stdin=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
var _stderr;
var _stderr=_stderr=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
/* global initializers */ __ATINIT__.push({ func: function() { runPostSets() } },{ func: function() { __GLOBAL__I_a() } },{ func: function() { __GLOBAL__I_a296() } });
var ___fsmu8;
var ___dso_handle;
var __ZTVN10__cxxabiv120__si_class_type_infoE;
__ZTVN10__cxxabiv120__si_class_type_infoE=allocate([0,0,0,0,248,51,2,0,50,1,0,0,176,0,0,0,78,0,0,0,184,0,0,0,8,0,0,0,8,0,0,0,6,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
var __ZTVN10__cxxabiv117__class_type_infoE;
__ZTVN10__cxxabiv117__class_type_infoE=allocate([0,0,0,0,8,52,2,0,50,1,0,0,40,1,0,0,78,0,0,0,184,0,0,0,8,0,0,0,28,0,0,0,4,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
var __ZN18GLockeAlphaTextureC1EPcii;
var __ZN18GLockeAlphaTextureD1Ev;
var __ZN12RenderedTextC1EPKc;
var __ZN12RenderedTextD1Ev;
var __ZN4GameC1EPKc;
var __ZN15HighscoresSceneC1EP4Game;
var __ZN9MenuSceneC1EP4Game;
var __ZN12ResultsSceneC1EP4Game;
var __ZN8SettingsC1Ev;
var __ZN10TitleSceneC1EP4Game;
var __ZN10TransitionC1EP4GameP5SceneS3_b;
var __ZN5BoardC1EP4Game;
var __ZN5BrickC1Eiii;
var __ZN11ColorSchemeC1Ev;
var __ZN12ConfirmSceneC1EP4GameP5ScenePKcS5_NS0_5EventES5_S6_;
var __ZN7PatternC1Ei;
var __ZN10RandomizerC1Ev;
var __ZN9RecordingC1Ev;
var __ZN5ScoreC1Ev;
var __ZNSt13runtime_errorC1EPKc;
var __ZNSt13runtime_errorD1Ev;
var __ZNSt12length_errorD1Ev;
var __ZNSt3__16localeC1Ev;
var __ZNSt3__16localeC1ERKS0_;
var __ZNSt3__16localeD1Ev;
var __ZNSt8bad_castC1Ev;
var __ZNSt8bad_castD1Ev;
/* memory initializer */ allocate([220,20,0,0,108,0,0,0,112,20,0,0,108,0,0,0,4,20,0,0,108,0,0,0,44,19,0,0,216,0,0,0,0,0,0,0,0,0,0,0,0,62,65,85,65,85,73,62,0,62,127,107,127,107,119,62,0,34,119,127,127,62,28,8,0,8,28,62,127,62,28,8,0,8,28,42,127,42,8,28,0,8,28,62,127,62,8,28,0,0,28,62,62,62,28,0,255,255,227,193,193,193,227,255,0,0,28,34,34,34,28,0,255,255,227,221,221,221,227,255,0,15,3,5,57,72,72,48,0,8,62,8,28,34,34,28,0,24,20,16,16,48,112,96,0,15,25,17,19,55,118,96,0,8,42,28,119,28,42,8,0,96,120,126,127,126,120,96,0,3,15,63,127,63,15,3,0,8,28,42,8,42,28,8,0,102,102,102,102,0,102,102,0,63,101,101,61,5,5,5,0,12,50,72,36,18,76,48,0,0,0,0,0,127,127,127,0,8,28,42,8,42,28,62,0,8,28,62,127,28,28,28,0,28,28,28,127,62,28,8,0,8,12,126,127,126,12,8,0,8,24,63,127,63,24,8,0,0,0,112,112,112,127,127,0,0,20,34,127,34,20,0,0,8,28,28,62,62,127,127,0,127,127,62,62,28,28,8,0,0,0,0,0,0,0,0,0,24,60,60,24,24,0,24,0,54,54,20,0,0,0,0,0,54,54,127,54,127,54,54,0,8,30,32,28,2,60,8,0,96,102,12,24,48,102,6,0,60,102,60,40,101,102,63,0,24,24,24,48,0,0,0,0,96,48,24,24,24,48,96,0,6,12,24,24,24,12,6,0,0,54,28,127,28,54,0,0,0,8,8,62,8,8,0,0,0,0,0,48,48,48,96,0,0,0,0,60,0,0,0,0,0,0,0,0,0,96,96,0,0,6,12,24,48,96,0,0,60,102,110,118,102,102,60,0,24,24,56,24,24,24,126,0,60,102,6,12,48,96,126,0,60,102,6,28,6,102,60,0,12,28,44,76,126,12,12,0,126,96,124,6,6,102,60,0,60,102,96,124,102,102,60,0,126,102,12,12,24,24,24,0,60,102,102,60,102,102,60,0,60,102,102,62,6,102,60,0,0,24,24,0,24,24,0,0,0,24,24,0,24,24,48,0,6,12,24,48,24,12,6,0,0,0,60,0,60,0,0,0,96,48,24,12,24,48,96,0,60,102,6,28,24,0,24,0,56,68,92,88,66,60,0,0,60,102,102,126,102,102,102,0,124,102,102,124,102,102,124,0,60,102,96,96,96,102,60,0,124,102,102,102,102,102,124,0,126,96,96,124,96,96,126,0,126,96,96,124,96,96,96,0,60,102,96,96,110,102,60,0,102,102,102,126,102,102,102,0,60,24,24,24,24,24,60,0,30,12,12,12,108,108,56,0,102,108,120,112,120,108,102,0,96,96,96,96,96,96,126,0,99,119,127,107,99,99,99,0,99,115,123,111,103,99,99,0,60,102,102,102,102,102,60,0,124,102,102,102,124,96,96,0,60,102,102,102,110,60,6,0,124,102,102,124,120,108,102,0,60,102,96,60,6,102,60,0,126,90,24,24,24,24,24,0,102,102,102,102,102,102,62,0,102,102,102,102,102,60,24,0,99,99,99,107,127,119,99,0,99,99,54,28,54,99,99,0,102,102,102,60,24,24,24,0,126,6,12,24,48,96,126,0,30,24,24,24,24,24,30,0,0,96,48,24,12,6,0,0,120,24,24,24,24,24,120,0,8,20,34,65,0,0,0,0,0,0,0,0,0,0,127,0,12,12,6,0,0,0,0,0,0,0,60,6,62,102,62,0,96,96,96,124,102,102,124,0,0,0,60,102,96,102,60,0,6,6,6,62,102,102,62,0,0,0,60,102,126,96,60,0,28,54,48,48,124,48,48,0,0,62,102,102,62,6,60,0,96,96,96,124,102,102,102,0,0,24,0,24,24,24,60,0,12,0,12,12,108,108,56,0,96,96,102,108,120,108,102,0,24,24,24,24,24,24,24,0,0,0,99,119,127,107,107,0,0,0,124,126,102,102,102,0,0,0,60,102,102,102,60,0,0,124,102,102,124,96,96,0,0,60,108,108,60,13,15,0,0,0,124,102,102,96,96,0,0,0,62,64,60,2,124,0,0,24,24,126,24,24,24,0,0,0,102,102,102,102,62,0,0,0,0,102,102,60,24,0,0,0,99,107,107,107,62,0,0,0,102,60,24,60,102,0,0,0,102,102,62,6,60,0,0,0,60,12,24,48,60,0,14,24,24,48,24,24,14,0,24,24,24,0,24,24,24,0,112,24,24,12,24,24,112,0,0,0,58,108,0,0,0,0,8,28,54,99,65,65,127,120,18,0,0,180,0,0,0,30,18,0,0,90,0,0,0,166,17,0,0,120,0,0,0,34,17,0,0,132,0,0,0,206,16,0,0,84,0,0,0,70,97,105,108,101,100,32,116,111,32,108,105,110,107,32,112,114,111,103,114,97,109,33,0,0,0,0,0,0,0,36,64,0,0,0,0,0,0,89,64,0,0,0,0,0,136,195,64,0,0,0,0,132,215,151,65,0,128,224,55,121,195,65,67,23,110,5,181,181,184,147,70,245,249,63,233,3,79,56,77,50,29,48,249,72,119,130,90,60,191,115,127,221,79,21,117,114,15,0,0,92,1,0,0,34,14,0,0,80,1,0,0,218,13,0,0,72,0,0,0,114,12,0,0,104,1,0,0,70,11,0,0,44,1,0,0,158,10,0,0,168,0,0,0,6,9,0,0,152,1,0,0,28,8,0,0,234,0,0,0,164,7,0,0,120,0,0,0,84,6,0,0,80,1,0,0,28,5,0,0,56,1,0,0,12,3,0,0,16,2,0,0,212,1,0,0,56,1,0,0,252,0,0,0,216,0,0,0,248,7,2,0,0,0,0,0,80,7,2,0,0,0,0,0,8,10,2,0,0,0,0,0,128,15,2,0,0,0,0,0,128,13,2,0,0,0,0,0,176,11,2,0,0,0,0,0,216,0,0,0,36,0,0,0,0,0,0,0,216,0,0,0,178,100,126,63,163,3,94,63,138,202,38,62,97,253,127,63,62,146,18,60,0,0,0,0,178,100,126,63,163,3,94,63,93,195,188,62,97,253,127,63,62,146,18,60,0,0,0,0,165,246,126,63,242,66,30,63,93,195,188,62,97,253,127,63,62,146,18,60,0,0,0,0,178,100,126,63,163,3,94,63,138,202,38,62,97,253,127,63,62,146,18,60,0,0,0,0,165,246,126,63,242,66,30,63,93,195,188,62,97,253,127,63,62,146,18,60,0,0,0,0,165,246,126,63,242,66,30,63,138,202,38,62,97,253,127,63,62,146,18,60,0,0,0,0,165,246,126,63,242,66,30,63,138,202,38,62,0,0,0,0,0,0,0,0,0,0,128,191,233,237,115,191,100,204,25,63,138,202,38,62,0,0,0,0,0,0,0,0,0,0,128,191,237,127,116,191,21,141,89,63,138,202,38,62,0,0,0,0,0,0,0,0,0,0,128,191,165,246,126,63,242,66,30,63,138,202,38,62,0,0,0,0,0,0,0,0,0,0,128,191,237,127,116,191,21,141,89,63,138,202,38,62,0,0,0,0,0,0,0,0,0,0,128,191,178,100,126,63,163,3,94,63,138,202,38,62,0,0,0,0,0,0,0,0,0,0,128,191,233,237,115,191,100,204,25,63,138,202,38,62,97,253,127,191,62,146,18,188,0,0,0,0,233,237,115,191,100,204,25,63,93,195,188,62,97,253,127,191,62,146,18,188,0,0,0,0,237,127,116,191,21,141,89,63,93,195,188,62,97,253,127,191,62,146,18,188,0,0,0,0,233,237,115,191,100,204,25,63,138,202,38,62,97,253,127,191,62,146,18,188,0,0,0,0,237,127,116,191,21,141,89,63,93,195,188,62,97,253,127,191,62,146,18,188,0,0,0,0,237,127,116,191,21,141,89,63,138,202,38,62,97,253,127,191,62,146,18,188,0,0,0,0,178,100,126,63,163,3,94,63,93,195,188,62,0,0,0,0,0,0,0,0,0,0,128,63,237,127,116,191,21,141,89,63,93,195,188,62,0,0,0,0,0,0,0,0,0,0,128,63,233,237,115,191,100,204,25,63,93,195,188,62,0,0,0,0,0,0,0,0,0,0,128,63,178,100,126,63,163,3,94,63,93,195,188,62,0,0,0,0,0,0,0,0,0,0,128,63,233,237,115,191,100,204,25,63,93,195,188,62,0,0,0,0,0,0,0,0,0,0,128,63,165,246,126,63,242,66,30,63,93,195,188,62,0,0,0,0,0,0,0,0,0,0,128,63,178,100,126,63,163,3,94,63,93,195,188,62,62,146,18,188,97,253,127,63,0,0,0,0,178,100,126,63,163,3,94,63,138,202,38,62,62,146,18,188,97,253,127,63,0,0,0,0,237,127,116,191,21,141,89,63,138,202,38,62,62,146,18,188,97,253,127,63,0,0,0,0,178,100,126,63,163,3,94,63,93,195,188,62,62,146,18,188,97,253,127,63,0,0,0,0,237,127,116,191,21,141,89,63,138,202,38,62,62,146,18,188,97,253,127,63,0,0,0,0,237,127,116,191,21,141,89,63,93,195,188,62,62,146,18,188,97,253,127,63,0,0,0,0,233,237,115,191,100,204,25,63,93,195,188,62,62,146,18,60,97,253,127,191,0,0,0,0,233,237,115,191,100,204,25,63,138,202,38,62,62,146,18,60,97,253,127,191,0,0,0,0,165,246,126,63,242,66,30,63,138,202,38,62,62,146,18,60,97,253,127,191,0,0,0,0,233,237,115,191,100,204,25,63,93,195,188,62,62,146,18,60,97,253,127,191,0,0,0,0,165,246,126,63,242,66,30,63,138,202,38,62,62,146,18,60,97,253,127,191,0,0,0,0,165,246,126,63,242,66,30,63,93,195,188,62,62,146,18,60,97,253,127,191,0,0,0,0,81,161,128,63,207,216,19,191,138,202,38,62,97,253,127,63,62,146,18,60,0,0,0,0,81,161,128,63,207,216,19,191,93,195,188,62,97,253,127,63,62,146,18,60,0,0,0,0,83,234,128,63,112,153,83,191,93,195,188,62,97,253,127,63,62,146,18,60,0,0,0,0,81,161,128,63,207,216,19,191,138,202,38,62,97,253,127,63,62,146,18,60,0,0,0,0,83,234,128,63,112,153,83,191,93,195,188,62,97,253,127,63,62,146,18,60,0,0,0,0,83,234,128,63,112,153,83,191,138,202,38,62,97,253,127,63,62,146,18,60,0,0,0,0,83,234,128,63,112,153,83,191,138,202,38,62,0,0,0,0,0,0,0,0,0,0,128,191,233,15,113,191,254,15,88,191,138,202,38,62,0,0,0,0,0,0,0,0,0,0,128,191,236,161,113,191,93,79,24,191,138,202,38,62,0,0,0,0,0,0,0,0,0,0,128,191,83,234,128,63,112,153,83,191,138,202,38,62,0,0,0,0,0,0,0,0,0,0,128,191,236,161,113,191,93,79,24,191,138,202,38,62,0,0,0,0,0,0,0,0,0,0,128,191,81,161,128,63,207,216,19,191,138,202,38,62,0,0,0,0,0,0,0,0,0,0,128,191,233,15,113,191,254,15,88,191,138,202,38,62,97,253,127,191,62,146,18,188,0,0,0,0,233,15,113,191,254,15,88,191,93,195,188,62,97,253,127,191,62,146,18,188,0,0,0,0,236,161,113,191,93,79,24,191,93,195,188,62,97,253,127,191,62,146,18,188,0,0,0,0,233,15,113,191,254,15,88,191,138,202,38,62,97,253,127,191,62,146,18,188,0,0,0,0,236,161,113,191,93,79,24,191,93,195,188,62,97,253,127,191,62,146,18,188,0,0,0,0,236,161,113,191,93,79,24,191,138,202,38,62,97,253,127,191,62,146,18,188,0,0,0,0,81,161,128,63,207,216,19,191,93,195,188,62,0,0,0,0,0,0,0,0,0,0,128,63,236,161,113,191,93,79,24,191,93,195,188,62,0,0,0,0,0,0,0,0,0,0,128,63,233,15,113,191,254,15,88,191,93,195,188,62,0,0,0,0,0,0,0,0,0,0,128,63,81,161,128,63,207,216,19,191,93,195,188,62,0,0,0,0,0,0,0,0,0,0,128,63,233,15,113,191,254,15,88,191,93,195,188,62,0,0,0,0,0,0,0,0,0,0,128,63,83,234,128,63,112,153,83,191,93,195,188,62,0,0,0,0,0,0,0,0,0,0,128,63,81,161,128,63,207,216,19,191,93,195,188,62,62,146,18,188,97,253,127,63,0,0,0,0,81,161,128,63,207,216,19,191,138,202,38,62,62,146,18,188,97,253,127,63,0,0,0,0,236,161,113,191,93,79,24,191,138,202,38,62,62,146,18,188,97,253,127,63,0,0,0,0,81,161,128,63,207,216,19,191,93,195,188,62,62,146,18,188,97,253,127,63,0,0,0,0,236,161,113,191,93,79,24,191,138,202,38,62,62,146,18,188,97,253,127,63,0,0,0,0,236,161,113,191,93,79,24,191,93,195,188,62,62,146,18,188,97,253,127,63,0,0,0,0,233,15,113,191,254,15,88,191,93,195,188,62,62,146,18,60,97,253,127,191,0,0,0,0,233,15,113,191,254,15,88,191,138,202,38,62,62,146,18,60,97,253,127,191,0,0,0,0,83,234,128,63,112,153,83,191,138,202,38,62,62,146,18,60,97,253,127,191,0,0,0,0,233,15,113,191,254,15,88,191,93,195,188,62,62,146,18,60,97,253,127,191,0,0,0,0,83,234,128,63,112,153,83,191,138,202,38,62,62,146,18,60,97,253,127,191,0,0,0,0,83,234,128,63,112,153,83,191,93,195,188,62,62,146,18,60,97,253,127,191,0,0,0,0,208,214,97,63,135,224,60,63,244,49,63,62,97,224,57,61,127,188,127,63,0,0,0,0,208,214,97,63,135,224,60,63,168,143,176,62,97,224,57,61,127,188,127,63,0,0,0,0,94,185,144,63,210,252,57,63,168,143,176,62,97,224,57,61,127,188,127,63,0,0,0,0,208,214,97,63,135,224,60,63,244,49,63,62,97,224,57,61,127,188,127,63,0,0,0,0,94,185,144,63,210,252,57,63,168,143,176,62,97,224,57,61,127,188,127,63,0,0,0,0,94,185,144,63,210,252,57,63,244,49,63,62,97,224,57,61,127,188,127,63,0,0,0,0,94,185,144,63,210,252,57,63,244,49,63,62,0,0,0,0,0,0,0,0,0,0,128,191,234,4,136,63,213,66,69,191,244,49,63,62,0,0,0,0,0,0,0,0,0,0,128,191,248,109,80,63,32,95,66,191,244,49,63,62,0,0,0,0,0,0,0,0,0,0,128,191,94,185,144,63,210,252,57,63,244,49,63,62,0,0,0,0,0,0,0,0,0,0,128,191,248,109,80,63,32,95,66,191,244,49,63,62,0,0,0,0,0,0,0,0,0,0,128,191,208,214,97,63,135,224,60,63,244,49,63,62,0,0,0,0,0,0,0,0,0,0,128,191,234,4,136,63,213,66,69,191,244,49,63,62,97,224,57,189,127,188,127,191,0,0,0,0,234,4,136,63,213,66,69,191,168,143,176,62,97,224,57,189,127,188,127,191,0,0,0,0,248,109,80,63,32,95,66,191,168,143,176,62,97,224,57,189,127,188,127,191,0,0,0,0,234,4,136,63,213,66,69,191,244,49,63,62,97,224,57,189,127,188,127,191,0,0,0,0,248,109,80,63,32,95,66,191,168,143,176,62,97,224,57,189,127,188,127,191,0,0,0,0,248,109,80,63,32,95,66,191,244,49,63,62,97,224,57,189,127,188,127,191,0,0,0,0,208,214,97,63,135,224,60,63,168,143,176,62,0,0,0,0,0,0,0,0,0,0,128,63,248,109,80,63,32,95,66,191,168,143,176,62,0,0,0,0,0,0,0,0,0,0,128,63,234,4,136,63,213,66,69,191,168,143,176,62,0,0,0,0,0,0,0,0,0,0,128,63,208,214,97,63,135,224,60,63,168,143,176,62,0,0,0,0,0,0,0,0,0,0,128,63,234,4,136,63,213,66,69,191,168,143,176,62,0,0,0,0,0,0,0,0,0,0,128,63,94,185,144,63,210,252,57,63,168,143,176,62,0,0,0,0,0,0,0,0,0,0,128,63,208,214,97,63,135,224,60,63,168,143,176,62,127,188,127,191,97,224,57,61,0,0,0,0,208,214,97,63,135,224,60,63,244,49,63,62,127,188,127,191,97,224,57,61,0,0,0,0,248,109,80,63,32,95,66,191,244,49,63,62,127,188,127,191,97,224,57,61,0,0,0,0,208,214,97,63,135,224,60,63,168,143,176,62,127,188,127,191,97,224,57,61,0,0,0,0,248,109,80,63,32,95,66,191,244,49,63,62,127,188,127,191,97,224,57,61,0,0,0,0,248,109,80,63,32,95,66,191,168,143,176,62,127,188,127,191,97,224,57,61,0,0,0,0,234,4,136,63,213,66,69,191,168,143,176,62,127,188,127,63,97,224,57,189,0,0,0,0,234,4,136,63,213,66,69,191,244,49,63,62,127,188,127,63,97,224,57,189,0,0,0,0,94,185,144,63,210,252,57,63,244,49,63,62,127,188,127,63,97,224,57,189,0,0,0,0,234,4,136,63,213,66,69,191,168,143,176,62,127,188,127,63,97,224,57,189,0,0,0,0,94,185,144,63,210,252,57,63,244,49,63,62,127,188,127,63,97,224,57,189,0,0,0,0,94,185,144,63,210,252,57,63,168,143,176,62,127,188,127,63,97,224,57,189,0,0,0,0,74,64,142,191,83,118,62,63,244,49,63,62,231,113,152,189,52,74,127,63,0,0,0,0,74,64,142,191,83,118,62,63,168,143,176,62,231,113,152,189,52,74,127,63,0,0,0,0,25,1,93,191,185,51,67,63,168,143,176,62,231,113,152,189,52,74,127,63,0,0,0,0,74,64,142,191,83,118,62,63,244,49,63,62,231,113,152,189,52,74,127,63,0,0,0,0,25,1,93,191,185,51,67,63,168,143,176,62,231,113,152,189,52,74,127,63,0,0,0,0,25,1,93,191,185,51,67,63,244,49,63,62,231,113,152,189,52,74,127,63,0,0,0,0,25,1,93,191,185,51,67,63,244,49,63,62,0,0,0,0,0,0,0,0,0,0,128,191,143,114,64,191,175,96,59,191,244,49,63,62,0,0,0,0,0,0,0,0,0,0,128,191,10,242,127,191,21,30,64,191,244,49,63,62,0,0,0,0,0,0,0,0,0,0,128,191,25,1,93,191,185,51,67,63,244,49,63,62,0,0,0,0,0,0,0,0,0,0,128,191,10,242,127,191,21,30,64,191,244,49,63,62,0,0,0,0,0,0,0,0,0,0,128,191,74,64,142,191,83,118,62,63,244,49,63,62,0,0,0,0,0,0,0,0,0,0,128,191,143,114,64,191,175,96,59,191,244,49,63,62,231,113,152,61,52,74,127,191,0,0,0,0,143,114,64,191,175,96,59,191,168,143,176,62,231,113,152,61,52,74,127,191,0,0,0,0,10,242,127,191,21,30,64,191,168,143,176,62,231,113,152,61,52,74,127,191,0,0,0,0,143,114,64,191,175,96,59,191,244,49,63,62,231,113,152,61,52,74,127,191,0,0,0,0,10,242,127,191,21,30,64,191,168,143,176,62,231,113,152,61,52,74,127,191,0,0,0,0,10,242,127,191,21,30,64,191,244,49,63,62,231,113,152,61,52,74,127,191,0,0,0,0,74,64,142,191,83,118,62,63,168,143,176,62,0,0,0,0,0,0,0,0,0,0,128,63,10,242,127,191,21,30,64,191,168,143,176,62,0,0,0,0,0,0,0,0,0,0,128,63,143,114,64,191,175,96,59,191,168,143,176,62,0,0,0,0,0,0,0,0,0,0,128,63,74,64,142,191,83,118,62,63,168,143,176,62,0,0,0,0,0,0,0,0,0,0,128,63,143,114,64,191,175,96,59,191,168,143,176,62,0,0,0,0,0,0,0,0,0,0,128,63,25,1,93,191,185,51,67,63,168,143,176,62,0,0,0,0,0,0,0,0,0,0,128,63,74,64,142,191,83,118,62,63,168,143,176,62,52,74,127,191,231,113,152,189,0,0,0,0,74,64,142,191,83,118,62,63,244,49,63,62,52,74,127,191,231,113,152,189,0,0,0,0,10,242,127,191,21,30,64,191,244,49,63,62,52,74,127,191,231,113,152,189,0,0,0,0,74,64,142,191,83,118,62,63,168,143,176,62,52,74,127,191,231,113,152,189,0,0,0,0,10,242,127,191,21,30,64,191,244,49,63,62,52,74,127,191,231,113,152,189,0,0,0,0,10,242,127,191,21,30,64,191,168,143,176,62,52,74,127,191,231,113,152,189,0,0,0,0,143,114,64,191,175,96,59,191,168,143,176,62,52,74,127,63,231,113,152,61,0,0,0,0,143,114,64,191,175,96,59,191,244,49,63,62,52,74,127,63,231,113,152,61,0,0,0,0,25,1,93,191,185,51,67,63,244,49,63,62,52,74,127,63,231,113,152,61,0,0,0,0,143,114,64,191,175,96,59,191,168,143,176,62,52,74,127,63,231,113,152,61,0,0,0,0,25,1,93,191,185,51,67,63,244,49,63,62,52,74,127,63,231,113,152,61,0,0,0,0,25,1,93,191,185,51,67,63,168,143,176,62,52,74,127,63,231,113,152,61,0,0,0,0,235,173,1,188,173,167,52,64,20,179,254,189,203,18,245,62,172,196,96,63,0,0,0,0,235,173,1,188,173,167,52,64,142,178,254,61,203,18,245,62,172,196,96,63,0,0,0,0,115,133,87,62,15,9,45,64,142,178,254,61,203,18,245,62,172,196,96,63,0,0,0,0,235,173,1,188,173,167,52,64,20,179,254,189,203,18,245,62,172,196,96,63,0,0,0,0,115,133,87,62,15,9,45,64,142,178,254,61,203,18,245,62,172,196,96,63,0,0,0,0,115,133,87,62,15,9,45,64,20,179,254,189,203,18,245,62,172,196,96,63,0,0,0,0,115,133,87,62,15,9,45,64,20,179,254,189,0,0,0,0,0,0,0,0,0,0,128,191,182,246,106,191,9,81,34,63,20,179,254,189,0,0,0,0,0,0,0,0,0,0,128,191,101,111,145,191,125,203,64,63,20,179,254,189,0,0,0,0,0,0,0,0,0,0,128,191,115,133,87,62,15,9,45,64,20,179,254,189,0,0,0,0,0,0,0,0,0,0,128,191,101,111,145,191,125,203,64,63,20,179,254,189,0,0,0,0,0,0,0,0,0,0,128,191,235,173,1,188,173,167,52,64,20,179,254,189,0,0,0,0,0,0,0,0,0,0,128,191,182,246,106,191,9,81,34,63,20,179,254,189,203,18,245,190,172,196,96,191,0,0,0,0,182,246,106,191,9,81,34,63,142,178,254,61,203,18,245,190,172,196,96,191,0,0,0,0,101,111,145,191,125,203,64,63,142,178,254,61,203,18,245,190,172,196,96,191,0,0,0,0,182,246,106,191,9,81,34,63,20,179,254,189,203,18,245,190,172,196,96,191,0,0,0,0,101,111,145,191,125,203,64,63,142,178,254,61,203,18,245,190,172,196,96,191,0,0,0,0,101,111,145,191,125,203,64,63,20,179,254,189,203,18,245,190,172,196,96,191,0,0,0,0,235,173,1,188,173,167,52,64,142,178,254,61,0,0,0,0,0,0,0,0,0,0,128,63,101,111,145,191,125,203,64,63,142,178,254,61,0,0,0,0,0,0,0,0,0,0,128,63,182,246,106,191,9,81,34,63,142,178,254,61,0,0,0,0,0,0,0,0,0,0,128,63,235,173,1,188,173,167,52,64,142,178,254,61,0,0,0,0,0,0,0,0,0,0,128,63,182,246,106,191,9,81,34,63,142,178,254,61,0,0,0,0,0,0,0,0,0,0,128,63,115,133,87,62,15,9,45,64,142,178,254,61,0,0,0,0,0,0,0,0,0,0,128,63,235,173,1,188,173,167,52,64,142,178,254,61,172,196,96,191,203,18,245,62,0,0,0,0,235,173,1,188,173,167,52,64,20,179,254,189,172,196,96,191,203,18,245,62,0,0,0,0,101,111,145,191,125,203,64,63,20,179,254,189,172,196,96,191,203,18,245,62,0,0,0,0,235,173,1,188,173,167,52,64,142,178,254,61,172,196,96,191,203,18,245,62,0,0,0,0,101,111,145,191,125,203,64,63,20,179,254,189,172,196,96,191,203,18,245,62,0,0,0,0,101,111,145,191,125,203,64,63,142,178,254,61,172,196,96,191,203,18,245,62,0,0,0,0,182,246,106,191,9,81,34,63,142,178,254,61,172,196,96,63,203,18,245,190,0,0,0,0,182,246,106,191,9,81,34,63,20,179,254,189,172,196,96,63,203,18,245,190,0,0,0,0,115,133,87,62,15,9,45,64,20,179,254,189,172,196,96,63,203,18,245,190,0,0,0,0,182,246,106,191,9,81,34,63,142,178,254,61,172,196,96,63,203,18,245,190,0,0,0,0,115,133,87,62,15,9,45,64,20,179,254,189,172,196,96,63,203,18,245,190,0,0,0,0,115,133,87,62,15,9,45,64,142,178,254,61,172,196,96,63,203,18,245,190,0,0,0,0,254,182,7,190,51,24,46,64,20,179,254,189,33,92,225,190,39,222,101,63,0,0,0,0,254,182,7,190,51,24,46,64,142,178,254,61,33,92,225,190,39,222,101,63,0,0,0,0,249,247,185,61,235,25,53,64,142,178,254,61,33,92,225,190,39,222,101,63,0,0,0,0,254,182,7,190,51,24,46,64,20,179,254,189,33,92,225,190,39,222,101,63,0,0,0,0,249,247,185,61,235,25,53,64,142,178,254,61,33,92,225,190,39,222,101,63,0,0,0,0,249,247,185,61,235,25,53,64,20,179,254,189,33,92,225,190,39,222,101,63,0,0,0,0,249,247,185,61,235,25,53,64,20,179,254,189,0,0,0,0,0,0,0,0,0,0,128,191,148,109,144,63,42,143,54,63,20,179,254,189,0,0,0,0,0,0,0,0,0,0,128,191,104,174,103,63,72,136,26,63,20,179,254,189,0,0,0,0,0,0,0,0,0,0,128,191,249,247,185,61,235,25,53,64,20,179,254,189,0,0,0,0,0,0,0,0,0,0,128,191,104,174,103,63,72,136,26,63,20,179,254,189,0,0,0,0,0,0,0,0,0,0,128,191,254,182,7,190,51,24,46,64,20,179,254,189,0,0,0,0,0,0,0,0,0,0,128,191,148,109,144,63,42,143,54,63,20,179,254,189,33,92,225,62,39,222,101,191,0,0,0,0,148,109,144,63,42,143,54,63,142,178,254,61,33,92,225,62,39,222,101,191,0,0,0,0,104,174,103,63,72,136,26,63,142,178,254,61,33,92,225,62,39,222,101,191,0,0,0,0,148,109,144,63,42,143,54,63,20,179,254,189,33,92,225,62,39,222,101,191,0,0,0,0,104,174,103,63,72,136,26,63,142,178,254,61,33,92,225,62,39,222,101,191,0,0,0,0,104,174,103,63,72,136,26,63,20,179,254,189,33,92,225,62,39,222,101,191,0,0,0,0,254,182,7,190,51,24,46,64,142,178,254,61,0,0,0,0,0,0,0,0,0,0,128,63,104,174,103,63,72,136,26,63,142,178,254,61,0,0,0,0,0,0,0,0,0,0,128,63,148,109,144,63,42,143,54,63,142,178,254,61,0,0,0,0,0,0,0,0,0,0,128,63,254,182,7,190,51,24,46,64,142,178,254,61,0,0,0,0,0,0,0,0,0,0,128,63,148,109,144,63,42,143,54,63,142,178,254,61,0,0,0,0,0,0,0,0,0,0,128,63,249,247,185,61,235,25,53,64,142,178,254,61,0,0,0,0,0,0,0,0,0,0,128,63,254,182,7,190,51,24,46,64,142,178,254,61,39,222,101,191,33,92,225,190,0,0,0,0,254,182,7,190,51,24,46,64,20,179,254,189,39,222,101,191,33,92,225,190,0,0,0,0,104,174,103,63,72,136,26,63,20,179,254,189,39,222,101,191,33,92,225,190,0,0,0,0,254,182,7,190,51,24,46,64,142,178,254,61,39,222,101,191,33,92,225,190,0,0,0,0,104,174,103,63,72,136,26,63,20,179,254,189,39,222,101,191,33,92,225,190,0,0,0,0,104,174,103,63,72,136,26,63,142,178,254,61,39,222,101,191,33,92,225,190,0,0,0,0,148,109,144,63,42,143,54,63,142,178,254,61,39,222,101,63,33,92,225,62,0,0,0,0,148,109,144,63,42,143,54,63,20,179,254,189,39,222,101,63,33,92,225,62,0,0,0,0,249,247,185,61,235,25,53,64,20,179,254,189,39,222,101,63,33,92,225,62,0,0,0,0,148,109,144,63,42,143,54,63,142,178,254,61,39,222,101,63,33,92,225,62,0,0,0,0,249,247,185,61,235,25,53,64,20,179,254,189,39,222,101,63,33,92,225,62,0,0,0,0,249,247,185,61,235,25,53,64,142,178,254,61,39,222,101,63,33,92,225,62,0,0,0,0,0,0,128,63,172,254,72,191,27,218,224,189,0,0,0,0,0,0,128,191,0,0,0,0,0,0,128,63,172,254,72,191,27,218,224,61,0,0,0,0,0,0,128,191,0,0,0,0,0,0,128,191,172,254,72,191,27,218,224,61,0,0,0,0,0,0,128,191,0,0,0,0,0,0,128,63,172,254,72,191,27,218,224,189,0,0,0,0,0,0,128,191,0,0,0,0,0,0,128,191,172,254,72,191,27,218,224,61,0,0,0,0,0,0,128,191,0,0,0,0,0,0,128,191,172,254,72,191,27,218,224,189,0,0,0,0,0,0,128,191,0,0,0,0,0,0,128,63,172,254,72,63,27,218,224,189,0,0,0,0,0,0,128,63,0,0,0,0,0,0,128,191,172,254,72,63,27,218,224,189,0,0,0,0,0,0,128,63,0,0,0,0,0,0,128,191,172,254,72,63,27,218,224,61,0,0,0,0,0,0,128,63,0,0,0,0,0,0,128,63,172,254,72,63,27,218,224,189,0,0,0,0,0,0,128,63,0,0,0,0,0,0,128,191,172,254,72,63,27,218,224,61,0,0,0,0,0,0,128,63,0,0,0,0,239,255,127,63,172,254,72,63,161,218,224,61,0,0,0,0,0,0,128,63,0,0,0,0,0,0,128,63,172,254,72,191,27,218,224,189,0,0,128,63,0,0,0,0,156,83,73,54,0,0,128,63,172,254,72,63,27,218,224,189,0,0,128,63,0,0,0,0,156,83,73,54,239,255,127,63,172,254,72,63,161,218,224,61,0,0,128,63,0,0,0,0,156,83,73,54,0,0,128,63,172,254,72,191,27,218,224,189,0,0,128,63,0,0,0,0,156,83,73,54,239,255,127,63,172,254,72,63,161,218,224,61,0,0,128,63,0,0,0,0,156,83,73,54,0,0,128,63,172,254,72,191,27,218,224,61,0,0,128,63,0,0,0,0,156,83,73,54,0,0,128,63,172,254,72,191,27,218,224,61,0,0,0,0,0,0,0,0,0,0,128,63,239,255,127,63,172,254,72,63,161,218,224,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,128,191,172,254,72,63,27,218,224,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,128,63,172,254,72,191,27,218,224,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,128,191,172,254,72,63,27,218,224,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,128,191,172,254,72,191,27,218,224,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,128,191,172,254,72,191,27,218,224,61,0,0,128,191,0,0,0,0,189,55,6,182,0,0,128,191,172,254,72,63,27,218,224,61,0,0,128,191,0,0,0,0,189,55,6,182,0,0,128,191,172,254,72,63,27,218,224,189,0,0,128,191,0,0,0,0,189,55,6,182,0,0,128,191,172,254,72,191,27,218,224,61,0,0,128,191,0,0,0,0,189,55,6,182,0,0,128,191,172,254,72,63,27,218,224,189,0,0,128,191,0,0,0,0,189,55,6,182,0,0,128,191,172,254,72,191,27,218,224,189,0,0,128,191,0,0,0,0,189,55,6,182,0,0,128,63,172,254,72,63,27,218,224,189,0,0,0,0,0,0,0,0,0,0,128,191,0,0,128,63,172,254,72,191,27,218,224,189,0,0,0,0,0,0,0,0,0,0,128,191,0,0,128,191,172,254,72,191,27,218,224,189,0,0,0,0,0,0,0,0,0,0,128,191,0,0,128,63,172,254,72,63,27,218,224,189,0,0,0,0,0,0,0,0,0,0,128,191,0,0,128,191,172,254,72,191,27,218,224,189,0,0,0,0,0,0,0,0,0,0,128,191,0,0,128,191,172,254,72,63,27,218,224,189,0,0,0,0,0,0,0,0,0,0,128,191,202,167,231,189,94,161,239,61,245,17,184,61,236,105,127,63,1,107,213,60,198,164,127,61,153,43,227,189,102,249,250,61,89,77,87,61,236,105,127,63,1,107,213,60,198,164,127,61,31,161,230,189,201,32,55,62,205,172,101,61,236,105,127,63,1,107,213,60,198,164,127,61,195,101,85,190,14,191,91,62,41,93,186,61,13,199,23,191,33,146,77,63,9,254,119,61,26,193,86,190,189,168,93,62,53,40,90,61,13,199,23,191,33,146,77,63,9,254,119,61,233,243,113,190,88,225,70,62,161,160,180,61,13,199,23,191,33,146,77,63,9,254,119,61,233,243,113,190,88,225,70,62,161,160,180,61,143,80,55,191,21,169,48,63,89,23,215,189,26,193,86,190,189,168,93,62,53,40,90,61,143,80,55,191,21,169,48,63,89,23,215,189,14,49,126,190,8,2,52,62,79,6,71,61,143,80,55,191,21,169,48,63,89,23,215,189,233,243,113,190,88,225,70,62,161,160,180,61,88,89,91,189,221,121,130,189,168,28,127,63,253,78,35,190,254,238,93,62,209,6,192,61,88,89,91,189,221,121,130,189,168,28,127,63,195,101,85,190,14,191,91,62,41,93,186,61,88,89,91,189,221,121,130,189,168,28,127,63,69,44,66,190,9,251,150,61,85,250,169,61,150,94,91,189,224,132,130,189,134,28,127,63,229,156,24,190,183,39,168,61,89,139,175,61,150,94,91,189,224,132,130,189,134,28,127,63,202,167,231,189,94,161,239,61,245,17,184,61,150,94,91,189,224,132,130,189,134,28,127,63,233,243,113,190,88,225,70,62,161,160,180,61,34,136,103,191,58,201,214,62,11,41,159,61,14,49,126,190,8,2,52,62,79,6,71,61,34,136,103,191,58,201,214,62,11,41,159,61,214,88,130,190,180,33,31,62,236,134,173,61,34,136,103,191,58,201,214,62,11,41,159,61,231,115,238,189,216,128,56,62,60,250,191,61,59,56,48,63,108,90,57,63,1,50,52,61,31,161,230,189,201,32,55,62,205,172,101,61,59,56,48,63,108,90,57,63,1,50,52,61,67,61,29,190,5,248,94,62,215,219,102,61,59,56,48,63,108,90,57,63,1,50,52,61,202,167,231,189,94,161,239,61,245,17,184,61,219,110,58,63,184,203,46,191,72,22,112,189,125,5,25,190,252,171,167,61,115,43,68,61,219,110,58,63,184,203,46,191,72,22,112,189,153,43,227,189,102,249,250,61,89,77,87,61,219,110,58,63,184,203,46,191,72,22,112,189,161,160,116,190,23,69,207,61,183,39,168,61,175,96,91,189,102,133,130,189,134,28,127,63,202,167,231,189,94,161,239,61,245,17,184,61,175,96,91,189,102,133,130,189,134,28,127,63,231,115,238,189,216,128,56,62,60,250,191,61,175,96,91,189,102,133,130,189,134,28,127,63,26,193,86,190,189,168,93,62,53,40,90,61,137,93,91,61,164,138,130,61,118,28,127,191,67,61,29,190,5,248,94,62,215,219,102,61,137,93,91,61,164,138,130,61,118,28,127,191,14,49,126,190,8,2,52,62,79,6,71,61,137,93,91,61,164,138,130,61,118,28,127,191,214,88,130,190,180,33,31,62,236,134,173,61,35,163,123,191,48,43,148,188,214,83,59,190,14,49,126,190,8,2,52,62,79,6,71,61,35,163,123,191,48,43,148,188,214,83,59,190,75,118,124,190,228,187,244,61,206,165,56,61,35,163,123,191,48,43,148,188,214,83,59,190,214,88,130,190,180,33,31,62,236,134,173,61,162,95,91,189,199,130,130,189,134,28,127,63,231,115,238,189,216,128,56,62,60,250,191,61,162,95,91,189,199,130,130,189,134,28,127,63,253,78,35,190,254,238,93,62,209,6,192,61,162,95,91,189,199,130,130,189,134,28,127,63,229,156,24,190,183,39,168,61,89,139,175,61,173,109,50,63,125,146,55,191,241,72,60,187,125,5,25,190,252,171,167,61,115,43,68,61,173,109,50,63,125,146,55,191,241,72,60,187,202,167,231,189,94,161,239,61,245,17,184,61,173,109,50,63,125,146,55,191,241,72,60,187,214,88,130,190,180,33,31,62,236,134,173,61,187,68,117,191,49,125,143,190,144,188,115,61,75,118,124,190,228,187,244,61,206,165,56,61,187,68,117,191,49,125,143,190,144,188,115,61,161,160,116,190,23,69,207,61,183,39,168,61,187,68,117,191,49,125,143,190,144,188,115,61,153,43,227,189,102,249,250,61,89,77,87,61,150,94,91,61,236,133,130,61,134,28,127,191,125,5,25,190,252,171,167,61,115,43,68,61,150,94,91,61,236,133,130,61,134,28,127,191,152,137,82,190,229,12,165,61,209,119,55,61,150,94,91,61,236,133,130,61,134,28,127,191,233,243,113,190,88,225,70,62,161,160,180,61,157,73,91,189,20,148,130,189,118,28,127,63,214,88,130,190,180,33,31,62,236,134,173,61,157,73,91,189,20,148,130,189,118,28,127,63,253,78,35,190,254,238,93,62,209,6,192,61,157,73,91,189,20,148,130,189,118,28,127,63,31,161,230,189,201,32,55,62,205,172,101,61,150,94,91,61,102,133,130,61,134,28,127,191,152,137,82,190,229,12,165,61,209,119,55,61,150,94,91,61,102,133,130,61,134,28,127,191,75,118,124,190,228,187,244,61,206,165,56,61,150,94,91,61,102,133,130,61,134,28,127,191,214,88,130,190,180,33,31,62,236,134,173,61,150,94,91,189,249,134,130,189,134,28,127,63,161,160,116,190,23,69,207,61,183,39,168,61,150,94,91,189,249,134,130,189,134,28,127,63,231,115,238,189,216,128,56,62,60,250,191,61,150,94,91,189,249,134,130,189,134,28,127,63,161,160,116,190,23,69,207,61,183,39,168,61,225,153,44,191,218,57,53,191,246,122,87,190,75,118,124,190,228,187,244,61,206,165,56,61,225,153,44,191,218,57,53,191,246,122,87,190,152,137,82,190,229,12,165,61,209,119,55,61,225,153,44,191,218,57,53,191,246,122,87,190,161,160,116,190,23,69,207,61,183,39,168,61,175,96,91,189,65,130,130,189,134,28,127,63,69,44,66,190,9,251,150,61,85,250,169,61,175,96,91,189,65,130,130,189,134,28,127,63,202,167,231,189,94,161,239,61,245,17,184,61,175,96,91,189,65,130,130,189,134,28,127,63,253,78,35,190,254,238,93,62,209,6,192,61,247,57,62,189,229,99,127,63,84,228,80,61,26,193,86,190,189,168,93,62,53,40,90,61,247,57,62,189,229,99,127,63,84,228,80,61,195,101,85,190,14,191,91,62,41,93,186,61,247,57,62,189,229,99,127,63,84,228,80,61,161,160,116,190,23,69,207,61,183,39,168,61,171,122,249,190,155,58,95,191,242,149,64,61,152,137,82,190,229,12,165,61,209,119,55,61,171,122,249,190,155,58,95,191,242,149,64,61,69,44,66,190,9,251,150,61,85,250,169,61,171,122,249,190,155,58,95,191,242,149,64,61,231,115,238,189,216,128,56,62,60,250,191,61,3,119,36,63,109,171,65,63,16,91,250,61,67,61,29,190,5,248,94,62,215,219,102,61,3,119,36,63,109,171,65,63,16,91,250,61,253,78,35,190,254,238,93,62,209,6,192,61,3,119,36,63,109,171,65,63,16,91,250,61,253,78,35,190,254,238,93,62,209,6,192,61,236,247,196,188,110,219,127,63,56,20,190,60,67,61,29,190,5,248,94,62,215,219,102,61,236,247,196,188,110,219,127,63,56,20,190,60,26,193,86,190,189,168,93,62,53,40,90,61,236,247,196,188,110,219,127,63,56,20,190,60,67,61,29,190,5,248,94,62,215,219,102,61,175,96,91,61,127,135,130,61,134,28,127,191,75,118,124,190,228,187,244,61,206,165,56,61,175,96,91,61,127,135,130,61,134,28,127,191,14,49,126,190,8,2,52,62,79,6,71,61,175,96,91,61,127,135,130,61,134,28,127,191,202,167,231,189,94,161,239,61,245,17,184,61,201,118,126,63,230,31,61,61,102,20,203,61,31,161,230,189,201,32,55,62,205,172,101,61,201,118,126,63,230,31,61,61,102,20,203,61,231,115,238,189,216,128,56,62,60,250,191,61,201,118,126,63,230,31,61,61,102,20,203,61,69,44,66,190,9,251,150,61,85,250,169,61,3,148,6,61,220,47,123,191,18,191,66,190,152,137,82,190,229,12,165,61,209,119,55,61,3,148,6,61,220,47,123,191,18,191,66,190,125,5,25,190,252,171,167,61,115,43,68,61,3,148,6,61,220,47,123,191,18,191,66,190,31,161,230,189,201,32,55,62,205,172,101,61,137,93,91,61,236,133,130,61,134,28,127,191,153,43,227,189,102,249,250,61,89,77,87,61,137,93,91,61,236,133,130,61,134,28,127,191,152,137,82,190,229,12,165,61,209,119,55,61,137,93,91,61,236,133,130,61,134,28,127,191,67,61,29,190,5,248,94,62,215,219,102,61,100,90,91,61,30,138,130,61,134,28,127,191,31,161,230,189,201,32,55,62,205,172,101,61,100,90,91,61,30,138,130,61,134,28,127,191,75,118,124,190,228,187,244,61,206,165,56,61,100,90,91,61,30,138,130,61,134,28,127,191,125,5,25,190,252,171,167,61,115,43,68,61,174,240,78,62,69,183,122,191,12,115,130,59,229,156,24,190,183,39,168,61,89,139,175,61,174,240,78,62,69,183,122,191,12,115,130,59,69,44,66,190,9,251,150,61,85,250,169,61,174,240,78,62,69,183,122,191,12,115,130,59,74,9,33,62,121,36,94,62,184,91,178,61,76,255,50,63,208,155,54,63,155,3,68,189,125,91,64,62,125,176,60,62,16,174,64,61,76,255,50,63,208,155,54,63,155,3,68,189,201,59,23,62,219,49,101,62,199,74,76,61,76,255,50,63,208,155,54,63,155,3,68,189,30,21,223,61,75,143,102,62,140,72,180,61,202,83,206,190,79,87,103,63,123,76,20,62,184,86,187,61,97,198,100,62,118,52,78,61,202,83,206,190,79,87,103,63,123,76,20,62,51,52,158,61,106,49,88,62,103,12,179,61,202,83,206,190,79,87,103,63,123,76,20,62,141,211,80,61,1,80,53,62,150,36,175,61,190,104,15,60,175,68,128,189,204,124,127,63,58,33,68,62,249,74,48,62,47,253,171,61,190,104,15,60,175,68,128,189,204,124,127,63,74,9,33,62,121,36,94,62,184,91,178,61,190,104,15,60,175,68,128,189,204,124,127,63,249,216,13,62,210,112,170,61,224,129,161,61,101,199,6,63,95,93,89,191,115,158,49,61,239,146,24,62,137,209,179,61,128,70,41,61,101,199,6,63,95,93,89,191,115,158,49,61,168,138,57,62,9,195,224,61,187,38,164,61,101,199,6,63,95,93,89,191,115,158,49,61,51,52,158,61,106,49,88,62,103,12,179,61,226,58,54,191,90,127,51,63,51,249,38,189,184,86,187,61,97,198,100,62,118,52,78,61,226,58,54,191,90,127,51,63,51,249,38,189,120,95,85,61,145,180,59,62,244,78,69,61,226,58,54,191,90,127,51,63,51,249,38,189,51,52,158,61,106,49,88,62,103,12,179,61,156,167,74,191,196,37,27,63,225,69,159,61,120,95,85,61,145,180,59,62,244,78,69,61,156,167,74,191,196,37,27,63,225,69,159,61,141,211,80,61,1,80,53,62,150,36,175,61,156,167,74,191,196,37,27,63,225,69,159,61,201,59,23,62,219,49,101,62,199,74,76,61,83,117,15,188,140,76,128,61,187,124,127,191,120,95,85,61,145,180,59,62,244,78,69,61,83,117,15,188,140,76,128,61,187,124,127,191,184,86,187,61,97,198,100,62,118,52,78,61,83,117,15,188,140,76,128,61,187,124,127,191,168,138,57,62,9,195,224,61,187,38,164,61,225,95,52,63,142,89,46,191,211,21,76,190,239,146,24,62,137,209,179,61,128,70,41,61,225,95,52,63,142,89,46,191,211,21,76,190,176,230,64,62,148,250,2,62,2,44,50,61,225,95,52,63,142,89,46,191,211,21,76,190,58,33,68,62,249,74,48,62,47,253,171,61,147,227,74,63,202,53,25,63,44,211,239,61,125,91,64,62,125,176,60,62,16,174,64,61,147,227,74,63,202,53,25,63,44,211,239,61,74,9,33,62,121,36,94,62,184,91,178,61,147,227,74,63,202,53,25,63,44,211,239,61,168,138,57,62,9,195,224,61,187,38,164,61,37,202,122,63].concat([113,0,45,190,135,250,221,61,176,230,64,62,148,250,2,62,2,44,50,61,37,202,122,63,113,0,45,190,135,250,221,61,58,33,68,62,249,74,48,62,47,253,171,61,37,202,122,63,113,0,45,190,135,250,221,61,141,211,80,61,1,80,53,62,150,36,175,61,190,104,15,60,187,69,128,189,204,124,127,63,47,249,95,61,85,109,247,61,140,216,167,61,190,104,15,60,187,69,128,189,204,124,127,63,58,33,68,62,249,74,48,62,47,253,171,61,190,104,15,60,187,69,128,189,204,124,127,63,176,230,64,62,148,250,2,62,2,44,50,61,19,155,15,188,68,81,128,61,187,124,127,191,239,146,24,62,137,209,179,61,128,70,41,61,19,155,15,188,68,81,128,61,187,124,127,191,138,5,190,61,13,250,178,61,47,48,43,61,19,155,15,188,68,81,128,61,187,124,127,191,141,211,80,61,1,80,53,62,150,36,175,61,198,222,127,191,118,81,244,187,12,143,253,188,120,95,85,61,145,180,59,62,244,78,69,61,198,222,127,191,118,81,244,187,12,143,253,188,55,139,87,61,101,254,1,62,230,204,54,61,198,222,127,191,118,81,244,187,12,143,253,188,141,211,80,61,1,80,53,62,150,36,175,61,32,40,127,191,64,222,139,189,21,27,51,61,55,139,87,61,101,254,1,62,230,204,54,61,32,40,127,191,64,222,139,189,21,27,51,61,47,249,95,61,85,109,247,61,140,216,167,61,32,40,127,191,64,222,139,189,21,27,51,61,51,52,158,61,106,49,88,62,103,12,179,61,34,113,15,60,199,70,128,189,204,124,127,63,141,211,80,61,1,80,53,62,150,36,175,61,34,113,15,60,199,70,128,189,204,124,127,63,74,9,33,62,121,36,94,62,184,91,178,61,34,113,15,60,199,70,128,189,204,124,127,63,81,165,198,61,144,45,171,61,199,76,162,61,76,138,15,60,30,78,128,189,187,124,127,63,249,216,13,62,210,112,170,61,224,129,161,61,76,138,15,60,30,78,128,189,187,124,127,63,168,138,57,62,9,195,224,61,187,38,164,61,76,138,15,60,30,78,128,189,187,124,127,63,125,91,64,62,125,176,60,62,16,174,64,61,133,121,15,188,224,72,128,61,204,124,127,191,176,230,64,62,148,250,2,62,2,44,50,61,133,121,15,188,224,72,128,61,204,124,127,191,55,139,87,61,101,254,1,62,230,204,54,61,133,121,15,188,224,72,128,61,204,124,127,191,74,9,33,62,121,36,94,62,184,91,178,61,11,183,44,62,219,223,121,63,232,136,12,62,201,59,23,62,219,49,101,62,199,74,76,61,11,183,44,62,219,223,121,63,232,136,12,62,30,21,223,61,75,143,102,62,140,72,180,61,11,183,44,62,219,223,121,63,232,136,12,62,47,249,95,61,85,109,247,61,140,216,167,61,133,121,15,60,212,71,128,189,204,124,127,63,81,165,198,61,144,45,171,61,199,76,162,61,133,121,15,60,212,71,128,189,204,124,127,63,168,138,57,62,9,195,224,61,187,38,164,61,133,121,15,60,212,71,128,189,204,124,127,63,47,249,95,61,85,109,247,61,140,216,167,61,133,121,15,60,249,74,128,189,204,124,127,63,168,138,57,62,9,195,224,61,187,38,164,61,133,121,15,60,249,74,128,189,204,124,127,63,58,33,68,62,249,74,48,62,47,253,171,61,133,121,15,60,249,74,128,189,204,124,127,63,47,249,95,61,85,109,247,61,140,216,167,61,146,207,51,191,201,34,53,191,109,197,158,189,55,139,87,61,101,254,1,62,230,204,54,61,146,207,51,191,201,34,53,191,109,197,158,189,138,5,190,61,13,250,178,61,47,48,43,61,146,207,51,191,201,34,53,191,109,197,158,189,47,249,95,61,85,109,247,61,140,216,167,61,25,32,41,191,140,45,64,191,192,9,5,187,138,5,190,61,13,250,178,61,47,48,43,61,25,32,41,191,140,45,64,191,192,9,5,187,81,165,198,61,144,45,171,61,199,76,162,61,25,32,41,191,140,45,64,191,192,9,5,187,30,21,223,61,75,143,102,62,140,72,180,61,63,30,250,187,101,194,127,63,20,206,46,189,201,59,23,62,219,49,101,62,199,74,76,61,63,30,250,187,101,194,127,63,20,206,46,189,184,86,187,61,97,198,100,62,118,52,78,61,63,30,250,187,101,194,127,63,20,206,46,189,176,230,64,62,148,250,2,62,2,44,50,61,133,121,15,188,65,70,128,61,204,124,127,191,138,5,190,61,13,250,178,61,47,48,43,61,133,121,15,188,65,70,128,61,204,124,127,191,55,139,87,61,101,254,1,62,230,204,54,61,133,121,15,188,65,70,128,61,204,124,127,191,51,52,158,61,106,49,88,62,103,12,179,61,34,113,15,60,237,73,128,189,204,124,127,63,74,9,33,62,121,36,94,62,184,91,178,61,34,113,15,60,237,73,128,189,204,124,127,63,30,21,223,61,75,143,102,62,140,72,180,61,34,113,15,60,237,73,128,189,204,124,127,63,201,59,23,62,219,49,101,62,199,74,76,61,34,113,15,188,115,74,128,61,204,124,127,191,125,91,64,62,125,176,60,62,16,174,64,61,34,113,15,188,115,74,128,61,204,124,127,191,120,95,85,61,145,180,59,62,244,78,69,61,34,113,15,188,115,74,128,61,204,124,127,191,58,33,68,62,249,74,48,62,47,253,171,61,128,212,126,63,111,185,122,60,99,11,193,189,176,230,64,62,148,250,2,62,2,44,50,61,128,212,126,63,111,185,122,60,99,11,193,189,125,91,64,62,125,176,60,62,16,174,64,61,128,212,126,63,111,185,122,60,99,11,193,189,125,91,64,62,125,176,60,62,16,174,64,61,34,113,15,188,65,70,128,61,204,124,127,191,55,139,87,61,101,254,1,62,230,204,54,61,34,113,15,188,65,70,128,61,204,124,127,191,120,95,85,61,145,180,59,62,244,78,69,61,34,113,15,188,65,70,128,61,204,124,127,191,81,165,198,61,144,45,171,61,199,76,162,61,122,86,210,59,214,169,126,191,66,151,208,189,138,5,190,61,13,250,178,61,47,48,43,61,122,86,210,59,214,169,126,191,66,151,208,189,239,146,24,62,137,209,179,61,128,70,41,61,122,86,210,59,214,169,126,191,66,151,208,189,239,146,24,62,137,209,179,61,128,70,41,61,211,219,31,188,20,5,126,191,67,115,253,189,249,216,13,62,210,112,170,61,224,129,161,61,211,219,31,188,20,5,126,191,67,115,253,189,81,165,198,61,144,45,171,61,199,76,162,61,211,219,31,188,20,5,126,191,67,115,253,189,154,180,41,60,168,1,131,189,235,254,177,188,147,30,254,190,211,108,190,61,224,246,92,191,64,195,91,189,80,56,187,189,140,159,70,60,147,30,254,190,211,108,190,61,224,246,92,191,153,244,151,189,64,161,158,188,195,213,1,61,147,30,254,190,211,108,190,61,224,246,92,191,154,180,41,60,168,1,131,189,235,254,177,188,147,30,254,190,211,108,190,61,224,246,92,191,153,244,151,189,64,161,158,188,195,213,1,61,147,30,254,190,211,108,190,61,224,246,92,191,46,227,38,188,193,114,4,60,89,25,13,187,147,30,254,190,211,108,190,61,224,246,92,191,46,227,38,188,193,114,4,60,89,25,13,187,233,156,83,63,188,122,181,62,83,206,223,190,90,104,231,60,32,121,103,58,36,123,132,61,233,156,83,63,188,122,181,62,83,206,223,190,31,218,71,61,13,193,145,189,92,199,56,61,233,156,83,63,188,122,181,62,83,206,223,190,31,218,71,61,13,193,145,189,92,199,56,61,199,156,83,63,53,122,181,62,62,207,223,190,154,180,41,60,168,1,131,189,235,254,177,188,199,156,83,63,53,122,181,62,62,207,223,190,46,227,38,188,193,114,4,60,89,25,13,187,199,156,83,63,53,122,181,62,62,207,223,190,90,104,231,60,32,121,103,58,36,123,132,61,67,29,254,62,235,110,190,189,52,247,92,63,57,124,18,189,216,158,217,188,74,206,201,61,67,29,254,62,235,110,190,189,52,247,92,63,29,89,121,188,182,247,201,189,90,183,161,61,67,29,254,62,235,110,190,189,52,247,92,63,90,104,231,60,32,121,103,58,36,123,132,61,247,30,254,62,17,114,190,189,173,246,92,63,29,89,121,188,182,247,201,189,90,183,161,61,247,30,254,62,17,114,190,189,173,246,92,63,31,218,71,61,13,193,145,189,92,199,56,61,247,30,254,62,17,114,190,189,173,246,92,63,64,195,91,189,80,56,187,189,140,159,70,60,199,156,83,191,53,122,181,190,62,207,223,62,29,89,121,188,182,247,201,189,90,183,161,61,199,156,83,191,53,122,181,190,62,207,223,62,57,124,18,189,216,158,217,188,74,206,201,61,199,156,83,191,53,122,181,190,62,207,223,62,64,195,91,189,80,56,187,189,140,159,70,60,199,156,83,191,53,122,181,190,62,207,223,62,57,124,18,189,216,158,217,188,74,206,201,61,199,156,83,191,53,122,181,190,62,207,223,62,153,244,151,189,64,161,158,188,195,213,1,61,199,156,83,191,53,122,181,190,62,207,223,62,64,195,91,189,80,56,187,189,140,159,70,60,90,212,135,62,81,49,110,191,110,109,129,190,154,180,41,60,168,1,131,189,235,254,177,188,90,212,135,62,81,49,110,191,110,109,129,190,31,218,71,61,13,193,145,189,92,199,56,61,90,212,135,62,81,49,110,191,110,109,129,190,64,195,91,189,80,56,187,189,140,159,70,60,90,212,135,62,81,49,110,191,110,109,129,190,31,218,71,61,13,193,145,189,92,199,56,61,90,212,135,62,81,49,110,191,110,109,129,190,29,89,121,188,182,247,201,189,90,183,161,61,90,212,135,62,81,49,110,191,110,109,129,190,57,124,18,189,216,158,217,188,74,206,201,61,225,212,135,190,64,49,110,63,43,109,129,62,90,104,231,60,32,121,103,58,36,123,132,61,225,212,135,190,64,49,110,63,43,109,129,62,46,227,38,188,193,114,4,60,89,25,13,187,225,212,135,190,64,49,110,63,43,109,129,62,57,124,18,189,216,158,217,188,74,206,201,61,90,212,135,190,81,49,110,63,110,109,129,62,46,227,38,188,193,114,4,60,89,25,13,187,90,212,135,190,81,49,110,63,110,109,129,62,153,244,151,189,64,161,158,188,195,213,1,61,90,212,135,190,81,49,110,63,110,109,129,62,189,53,76,191,238,9,58,63,33,201,140,61,78,180,43,60,222,118,161,188,174,239,127,63,108,209,58,191,138,171,58,63,1,109,139,61,78,180,43,60,222,118,161,188,174,239,127,63,20,5,70,191,83,206,59,63,68,139,140,61,78,180,43,60,222,118,161,188,174,239,127,63,216,41,18,191,66,118,6,63,225,184,12,61,48,44,127,63,83,62,164,61,174,241,153,187,225,127,19,191,249,129,23,63,30,138,130,61,48,44,127,63,83,62,164,61,174,241,153,187,193,27,18,191,60,50,6,63,58,88,127,61,48,44,127,63,83,62,164,61,174,241,153,187,232,79,23,191,190,49,4,63,160,222,12,61,198,53,206,62,138,32,106,191,135,167,23,189,216,41,18,191,66,118,6,63,225,184,12,61,198,53,206,62,138,32,106,191,135,167,23,189,193,27,18,191,60,50,6,63,58,88,127,61,198,53,206,62,138,32,106,191,135,167,23,189,176,84,23,191,234,148,31,63,205,145,21,61,199,17,87,63,185,223,5,63,109,115,19,62,155,118,29,191,48,102,39,63,121,230,133,61,199,17,87,63,185,223,5,63,109,115,19,62,225,127,19,191,249,129,23,63,30,138,130,61,199,17,87,63,185,223,5,63,109,115,19,62,191,72,60,191,45,37,59,63,51,135,36,61,161,134,207,61,14,107,126,63,151,142,57,61,20,5,70,191,83,206,59,63,68,139,140,61,161,134,207,61,14,107,126,63,151,142,57,61,108,209,58,191,138,171,58,63,1,109,139,61,161,134,207,61,14,107,126,63,151,142,57,61,68,110,70,191,42,25,60,63,1,137,38,61,209,148,237,190,65,159,96,63,235,30,249,189,146,207,79,191,70,35,55,63,1,137,38,61,209,148,237,190,65,159,96,63,235,30,249,189,189,53,76,191,238,9,58,63,33,201,140,61,209,148,237,190,65,159,96,63,235,30,249,189,110,104,70,191,244,55,33,63,160,252,29,61,31,46,77,191,27,216,22,191,72,25,209,61,234,208,57,191,116,65,17,63,248,194,132,61,31,46,77,191,27,216,22,191,72,25,209,61,85,191,74,191,115,101,40,63,236,219,137,61,31,46,77,191,27,216,22,191,72,25,209,61,234,208,57,191,116,65,17,63,248,194,132,61,71,201,43,60,63,173,162,188,124,239,127,63,225,127,19,191,249,129,23,63,30,138,130,61,71,201,43,60,63,173,162,188,124,239,127,63,85,191,74,191,115,101,40,63,236,219,137,61,71,201,43,60,63,173,162,188,124,239,127,63,53,208,40,191,130,201,9,63,113,147,17,61,126,57,155,190,7,208,115,191,241,158,3,189,26,134,23,191,44,13,4,63,243,146,127,61,126,57,155,190,7,208,115,191,241,158,3,189,22,79,45,191,85,249,10,63,174,182,130,61,126,57,155,190,7,208,115,191,241,158,3,189,216,41,18,191,66,118,6,63,225,184,12,61,127,76,127,63,28,179,108,61,168,26,61,61,166,238,18,191,73,131,19,63,139,254,16,61,127,76,127,63,28,179,108,61,168,26,61,61,225,127,19,191,249,129,23,63,30,138,130,61,127,76,127,63,28,179,108,61,168,26,61,61,146,207,79,191,70,35,55,63,1,137,38,61,198,20,44,188,1,20,163,60,107,239,127,191,68,110,70,191,42,25,60,63,1,137,38,61,198,20,44,188,1,20,163,60,107,239,127,191,191,72,60,191,45,37,59,63,51,135,36,61,198,20,44,188,1,20,163,60,107,239,127,191,166,238,18,191,73,131,19,63,139,254,16,61,142,174,110,63,204,97,175,62,165,244,236,189,176,84,23,191,234,148,31,63,205,145,21,61,142,174,110,63,204,97,175,62,165,244,236,189,225,127,19,191,249,129,23,63,30,138,130,61,142,174,110,63,204,97,175,62,165,244,236,189,68,110,70,191,42,25,60,63,1,137,38,61,26,52,140,190,15,208,117,63,27,16,97,61,189,53,76,191,238,9,58,63,33,201,140,61,26,52,140,190,15,208,117,63,27,16,97,61,20,5,70,191,83,206,59,63,68,139,140,61,26,52,140,190,15,208,117,63,27,16,97,61,22,79,45,191,85,249,10,63,174,182,130,61,220,213,43,60,112,177,162,188,124,239,127,63,193,27,18,191,60,50,6,63,58,88,127,61,220,213,43,60,112,177,162,188,124,239,127,63,225,127,19,191,249,129,23,63,30,138,130,61,220,213,43,60,112,177,162,188,124,239,127,63,232,79,23,191,190,49,4,63,160,222,12,61,233,128,188,62,151,2,110,191,77,244,249,187,193,27,18,191,60,50,6,63,58,88,127,61,233,128,188,62,151,2,110,191,77,244,249,187,26,134,23,191,44,13,4,63,243,146,127,61,233,128,188,62,151,2,110,191,77,244,249,187,166,129,79,191,186,129,54,63,65,128,140,61,121,205,43,60,144,158,162,188,124,239,127,63,138,146,44,191,206,22,52,63,111,47,137,61,121,205,43,60,144,158,162,188,124,239,127,63,108,209,58,191,138,171,58,63,1,109,139,61,121,205,43,60,144,158,162,188,124,239,127,63,146,207,79,191,70,35,55,63,1,137,38,61,14,218,43,188,102,133,162,60,124,239,127,191,191,72,60,191,45,37,59,63,51,135,36,61,14,218,43,188,102,133,162,60,124,239,127,191,150,118,42,191,197,56,51,63,222,4,31,61,14,218,43,188,102,133,162,60,124,239,127,191,34,53,57,191,160,222,16,63,192,147,22,61,0,230,202,190,215,189,105,191,43,105,197,189,53,208,40,191,130,201,9,63,113,147,17,61,0,230,202,190,215,189,105,191,43,105,197,189,22,79,45,191,85,249,10,63,174,182,130,61,0,230,202,190,215,189,105,191,43,105,197,189,85,191,74,191,115,101,40,63,236,219,137,61,171,209,43,60,169,160,162,188,124,239,127,63,225,127,19,191,249,129,23,63,30,138,130,61,171,209,43,60,169,160,162,188,124,239,127,63,155,118,29,191,48,102,39,63,121,230,133,61,171,209,43,60,169,160,162,188,124,239,127,63,150,118,42,191,197,56,51,63,222,4,31,61,160,196,207,62,83,231,105,63,136,73,184,188,191,72,60,191,45,37,59,63,51,135,36,61,160,196,207,62,83,231,105,63,136,73,184,188,108,209,58,191,138,171,58,63,1,109,139,61,160,196,207,62,83,231,105,63,136,73,184,188,34,53,57,191,160,222,16,63,192,147,22,61,71,201,43,188,63,173,162,60,124,239,127,191,176,84,23,191,234,148,31,63,205,145,21,61,71,201,43,188,63,173,162,60,124,239,127,191,166,238,18,191,73,131,19,63,139,254,16,61,71,201,43,188,63,173,162,60,124,239,127,191,110,104,70,191,244,55,33,63,160,252,29,61,121,205,43,188,137,179,162,60,124,239,127,191,146,207,79,191,70,35,55,63,1,137,38,61,121,205,43,188,137,179,162,60,124,239,127,191,150,118,42,191,197,56,51,63,222,4,31,61,121,205,43,188,137,179,162,60,124,239,127,191,176,84,23,191,234,148,31,63,205,145,21,61,166,213,52,63,82,73,49,63,54,230,21,190,150,118,42,191,197,56,51,63,222,4,31,61,166,213,52,63,82,73,49,63,54,230,21,190,155,118,29,191,48,102,39,63,121,230,133,61,166,213,52,63,82,73,49,63,54,230,21,190,22,79,45,191,85,249,10,63,174,182,130,61,21,197,43,60,120,156,162,188,124,239,127,63,225,127,19,191,249,129,23,63,30,138,130,61,21,197,43,60,120,156,162,188,124,239,127,63,234,208,57,191,116,65,17,63,248,194,132,61,21,197,43,60,120,156,162,188,124,239,127,63,150,118,42,191,197,56,51,63,222,4,31,61,32,70,36,63,121,202,66,63,179,8,197,61,138,146,44,191,206,22,52,63,111,47,137,61,32,70,36,63,121,202,66,63,179,8,197,61,155,118,29,191,48,102,39,63,121,230,133,61,32,70,36,63,121,202,66,63,179,8,197,61,53,208,40,191,130,201,9,63,113,147,17,61,188,3,156,190,111,184,115,191,201,255,228,188,232,79,23,191,190,49,4,63,160,222,12,61,188,3,156,190,111,184,115,191,201,255,228,188,26,134,23,191,44,13,4,63,243,146,127,61,188,3,156,190,111,184,115,191,201,255,228,188,34,53,57,191,160,222,16,63,192,147,22,61,125,179,229,190,214,198,100,191,187,38,36,60,22,79,45,191,85,249,10,63,174,182,130,61,125,179,229,190,214,198,100,191,187,38,36,60,234,208,57,191,116,65,17,63,248,194,132,61,125,179,229,190,214,198,100,191,187,38,36,60,110,104,70,191,244,55,33,63,160,252,29,61,249,48,71,191,112,152,32,191,38,228,3,189,34,53,57,191,160,222,16,63,192,147,22,61,249,48,71,191,112,152,32,191,38,228,3,189,234,208,57,191,116,65,17,63,248,194,132,61,249,48,71,191,112,152,32,191,38,228,3,189,150,118,42,191,197,56,51,63,222,4,31,61,167,207,214,62,96,90,104,63,131,80,94,60,108,209,58,191,138,171,58,63,1,109,139,61,167,207,214,62,96,90,104,63,131,80,94,60,138,146,44,191,206,22,52,63,111,47,137,61,167,207,214,62,96,90,104,63,131,80,94,60,146,207,79,191,70,35,55,63,1,137,38,61,124,157,104,191,255,149,197,190,208,69,35,190,110,104,70,191,244,55,33,63,160,252,29,61,124,157,104,191,255,149,197,190,208,69,35,190,85,191,74,191,115,101,40,63,236,219,137,61,124,157,104,191,255,149,197,190,208,69,35,190,166,129,79,191,186,129,54,63,65,128,140,61,21,197,43,60,177,139,162,188,124,239,127,63,108,209,58,191,138,171,58,63,1,109,139,61,21,197,43,60,177,139,162,188,124,239,127,63,189,53,76,191,238,9,58,63,33,201,140,61,21,197,43,60,177,139,162,188,124,239,127,63,232,79,23,191,190,49,4,63,160,222,12,61,42,29,44,188,211,74,161,60,174,239,127,191,53,208,40,191,130,201,9,63,113,147,17,61,42,29,44,188,211,74,161,60,174,239,127,191,216,41,18,191,66,118,6,63,225,184,12,61,42,29,44,188,211,74,161,60,174,239,127,191,85,191,74,191,115,101,40,63,236,219,137,61,121,205,43,60,38,171,162,188,124,239,127,63,138,146,44,191,206,22,52,63,111,47,137,61,121,205,43,60,38,171,162,188,124,239,127,63,166,129,79,191,186,129,54,63,65,128,140,61,121,205,43,60,38,171,162,188,124,239,127,63,146,207,79,191,70,35,55,63,1,137,38,61,51,137,114,191,123,189,163,190,162,96,70,60,85,191,74,191,115,101,40,63,236,219,137,61,51,137,114,191,123,189,163,190,162,96,70,60,166,129,79,191,186,129,54,63,65,128,140,61,51,137,114,191,123,189,163,190,162,96,70,60,110,104,70,191,244,55,33,63,160,252,29,61,21,197,43,188,38,171,162,60,124,239,127,191,150,118,42,191,197,56,51,63,222,4,31,61,21,197,43,188,38,171,162,60,124,239,127,191,176,84,23,191,234,148,31,63,205,145,21,61,21,197,43,188,38,171,162,60,124,239,127,191,53,208,40,191,130,201,9,63,113,147,17,61,121,205,43,188,112,177,162,60,124,239,127,191,34,53,57,191,160,222,16,63,192,147,22,61,121,205,43,188,112,177,162,60,124,239,127,191,166,238,18,191,73,131,19,63,139,254,16,61,121,205,43,188,112,177,162,60,124,239,127,191,34,53,57,191,160,222,16,63,192,147,22,61,21,197,43,188,244,166,162,60,124,239,127,191,110,104,70,191,244,55,33,63,160,252,29,61,21,197,43,188,244,166,162,60,124,239,127,191,176,84,23,191,234,148,31,63,205,145,21,61,21,197,43,188,244,166,162,60,124,239,127,191,146,207,79,191,70,35,55,63,1,137,38,61,128,127,58,191,162,209,45,63,175,39,186,61,166,129,79,191,186,129,54,63,65,128,140,61,128,127,58,191,162,209,45,63,175,39,186,61,189,53,76,191,238,9,58,63,33,201,140,61,128,127,58,191,162,209,45,63,175,39,186,61,191,72,60,191,45,37,59,63,51,135,36,61,6,76,192,61,145,181,126,63,215,109,16,61,68,110,70,191,42,25,60,63,1,137,38,61,6,76,192,61,145,181,126,63,215,109,16,61,20,5,70,191,83,206,59,63,68,139,140,61,6,76,192,61,145,181,126,63,215,109,16,61,26,134,23,191,44,13,4,63,243,146,127,61,106,247,43,60,92,89,162,188,141,239,127,63,193,27,18,191,60,50,6,63,58,88,127,61,106,247,43,60,92,89,162,188,141,239,127,63,22,79,45,191,85,249,10,63,174,182,130,61,106,247,43,60,92,89,162,188,141,239,127,63,53,208,40,191,130,201,9,63,113,147,17,61,178,188,43,188,144,158,162,60,124,239,127,191,166,238,18,191,73,131,19,63,139,254,16,61,178,188,43,188,144,158,162,60,124,239,127,191,216,41,18,191,66,118,6,63,225,184,12,61,178,188,43,188,144,158,162,60,124,239,127,191,85,191,74,191,115,101,40,63,236,219,137,61,121,205,43,60,63,173,162,188,124,239,127,63,155,118,29,191,48,102,39,63,121,230,133,61,121,205,43,60,63,173,162,188,124,239,127,63,138,146,44,191,206,22,52,63,111,47,137,61,121,205,43,60,63,173,162,188,124,239,127,63,213,202,140,62,178,244,49,190,219,25,134,61,184,174,80,63,98,135,13,191,228,245,48,190,47,223,138,62,29,4,45,190,148,132,4,61,184,174,80,63,98,135,13,191,228,245,48,190,160,249,172,62,203,132,159,189,101,25,98,61,184,174,80,63,98,135,13,191,228,245,48,190,200,67,79,62,140,132,102,190,136,105,95,61,219,165,205,61,0,253,190,62,146,32,108,63,24,206,85,62,74,178,110,190,159,202,105,61,219,165,205,61,0,253,190,62,146,32,108,63,231,57,154,62,29,176,59,190,146,32,220,60,219,165,205,61,0,253,190,62,146,32,108,63,231,57,154,62,29,176,59,190,146,32,220,60,142,31,114,191,241,185,147,62,109,168,24,62,108,37,156,62,178,160,64,190,118,192,117,61,142,31,114,191,241,185,147,62,109,168,24,62,160,249,172,62,203,132,159,189,101,25,98,61,142,31,114,191,241,185,147,62,109,168,24,62,231,57,154,62,29,176,59,190,146,32,220,60,1,194,215,190,16,175,99,63,96,120,53,62,24,206,85,62,74,178,110,190,159,202,105,61,1,194,215,190,16,175,99,63,96,120,53,62,108,37,156,62,178,160,64,190,118,192,117,61,1,194,215,190,16,175,99,63,96,120,53,62,47,223,138,62,29,4,45,190,148,132,4,61,177,138,55,61,64,47,140,190,65,243,117,63,231,57,154,62,29,176,59,190,146,32,220,60,177,138,55,61,64,47,140,190,65,243,117,63,160,249,172,62,203,132,159,189,101,25,98,61,177,138,55,61,64,47,140,190,65,243,117,63,200,67,79,62,140,132,102,190,136,105,95,61,154,96,104,62,159,4,214,61,185,225,119,63,231,57,154,62,29,176,59,190,146,32,220,60,154,96,104,62,159,4,214,61,185,225,119,63,47,223,138,62,29,4,45,190,148,132,4,61,154,96,104,62,159,4,214,61,185,225,119,63,108,37,156,62,178,160,64,190,118,192,117,61,119,159,51,190,136,241,26,60,234,4,124,191,213,202,140,62,178,244,49,190,219,25,134,61,119,159,51,190,136,241,26,60,234,4,124,191,160,249,172,62,203,132,159,189,101,25,98,61,119,159,51,190,136,241,26,60,234,4,124,191,213,202,140,62,178,244,49,190,219,25,134,61,185,254,21,63,81,49,74,191,57,183,57,190,200,67,79,62,140,132,102,190,136,105,95,61,185,254,21,63,81,49,74,191,57,183,57,190,47,223,138,62,29,4,45,190,148,132,4,61,185,254,21,63,81,49,74,191,57,183,57,190,213,202,140,62,178,244,49,190,219,25,134,61,158,152,149,189,101,143,96,62,73,17,121,191,108,37,156,62,178,160,64,190,118,192,117,61,158,152,149,189,101,143,96,62,73,17,121,191,24,206,85,62,74,178,110,190,159,202,105,61,158,152,149,189,101,143,96,62,73,17,121,191,213,202,140,62,178,244,49,190,219,25,134,61,170,212,108,62,251,147,248,189,252,28,119,191,24,206,85,62,74,178,110,190,159,202,105,61,170,212,108,62,251,147,248,189,252,28,119,191,200,67,79,62,140,132,102,190,136,105,95,61,170,212,108,62,251,147,248,189,252,28,119,191,253,189,92,63,186,218,18,63,26,191,240,60,46,3,78,188,96,200,106,61,21,143,127,191,7,154,67,63,92,170,50,63,59,170,26,61,46,3,78,188,96,200,106,61,21,143,127,191,12,5,108,63,61,183,32,63,24,8,2,61,46,3,78,188,96,200,106,61,21,143,127,191,156,53,100,63,123,107,44,63,79,203,143,61,96,35,45,63,161,106,60,63,196,152,244,60,159,201,106,63,139,194,38,63,225,212,7,61,96,35,45,63,161,106,60,63,196,152,244,60,197,59,100,63,227,195,44,63,12,173,14,61,96,35,45,63,161,106,60,63,196,152,244,60,144,192,31,63,147,110,39,63,245,102,148,61,30,167,0,191,232,51,92,63,200,6,178,189,95,64,43,63,137,64,45,63,116,153,26,61,30,167,0,191,232,51,92,63,200,6,178,189,16,203,22,63,133,65,33,63,154,178,19,61,30,167,0,191,232,51,92,63,200,6,178,189,159,201,106,63,139,194,38,63,225,212,7,61,202,250,77,188,159,205,106,61,4,143,127,191,7,154,67,63,92,170,50,63,59,170,26,61,202,250,77,188,159,205,106,61,4,143,127,191,93,107,87,63,199,189,49,63,208,210,21,61,202,250,77,188,159,205,106,61,4,143,127,191,231,141,79,63,209,116,10,63,124,70,130,61,53,238,77,60,196,208,106,189,4,143,127,63,144,192,31,63,147,110,39,63,245,102,148,61,53,238,77,60,196,208,106,189,4,143,127,63,38,197,19,63,91,122,28,63,150,147,144,61,53,238,77,60,196,208,106,189,4,143,127,63,135,139,52,63,83,149,2,63,95,97,129,61,103,242,77,60,146,204,106,189,21,143,127,63,231,141,79,63,209,116,10,63,124,70,130,61,103,242,77,60,146,204,106,189,21,143,127,63,38,197,19,63,91,122,28,63,150,147,144,61,103,242,77,60,146,204,106,189,21,143,127,63,155,173,64,63,144,73,50,63,64,18,150,61,5,195,249,61,116,153,118,63,52,243,116,62,238,176,101,63,17,200,45,63,254,69,144,61,5,195,249,61,116,153,118,63,52,243,116,62,93,107,87,63,199,189,49,63,208,210,21,61,5,195,249,61,116,153,118,63,52,243,116,62,16,121,15,63,68,220,8,63,76,254,135,61,253,103,77,60,115,75,107,189,159,142,127,63,135,139,52,63,83,149,2,63,95,97,129,61,253,103,77,60,115,75,107,189,159,142,127,63,145,72,11,63,135,79,14,63,141,236,138,61,253,103,77,60,115,75,107,189,159,142,127,63,145,72,11,63,135,79,14,63,141,236,138,61,69,128,91,191,155,174,3,63,214,252,120,188,38,197,19,63,91,122,28,63,150,147,144,61,69,128,91,191,155,174,3,63,214,252,120,188,16,203,22,63,133,65,33,63,154,178,19,61,69,128,91,191,155,174,3,63,214,252,120,188,231,141,79,63,209,116,10,63,124,70,130,61,46,3,78,60,121,202,106,189,21,143,127,63,199,74,108,63,194,21,32,63,118,80,137,61,46,3,78,60,121,202,106,189,21,143,127,63,155,173,64,63,144,73,50,63,64,18,150,61,46,3,78,60,121,202,106,189,21,143,127,63,155,173,64,63,144,73,50,63,64,18,150,61,36,9,66,61,228,76,127,63,91,64,104,61,93,107,87,63,199,189,49,63,208,210,21,61,36,9,66,61,228,76,127,63,91,64,104,61,7,154,67,63,92,170,50,63,59,170,26,61,36,9,66,61,228,76,127,63,91,64,104,61,159,201,106,63,139,194,38,63,225,212,7,61,142,91,76,188,31,133,107,61,126,142,127,191,93,107,87,63,199,189,49,63,208,210,21,61,142,91,76,188,31,133,107,61,126,142,127,191,197,59,100,63,227,195,44,63,12,173,14,61,142,91,76,188,31,133,107,61,126,142,127,191,16,121,15,63,68,220,8,63,76,254,135,61,144,21,72,191,143,142,31,191,167,31,212,188,159,30,11,63,41,174,14,63,30,252,4,61,144,21,72,191,143,142,31,191,167,31,212,188,88,116,15,63,129,66,9,63,78,65,254,60,144,21,72,191,143,142,31,191,167,31,212,188,135,139,52,63,83,149,2,63,95,97,129,61,252,254,77,60,96,200,106,189,21,143,127,63,38,197,19,63,91,122,28,63,150,147,144,61,252,254,77,60,96,200,106,189,21,143,127,63,145,72,11,63,135,79,14,63,141,236,138,61,252,254,77,60,96,200,106,189,21,143,127,63,156,53,100,63,123,107,44,63,79,203,143,61,196,35,249,190,116,40,15,63,111,211,43,191,238,176,101,63,17,200,45,63,254,69,144,61,196,35,249,190,116,40,15,63,111,211,43,191,159,201,106,63,139,194,38,63,225,212,7,61,196,35,249,190,116,40,15,63,111,211,43,191,155,173,64,63,144,73,50,63,64,18,150,61,247,30,94,190,20,203,121,63,212,243,238,188,7,154,67,63,92,170,50,63,59,170,26,61,247,30,94,190,20,203,121,63,212,243,238,188,95,64,43,63,137,64,45,63,116,153,26,61,247,30,94,190,20,203,121,63,212,243,238,188,199,74,108,63,194,21,32,63,118,80,137,61,103,242,77,60,246,212,106,189,4,143,127,63,238,176,101,63,17,200,45,63,254,69,144,61,103,242,77,60,246,212,106,189,4,143,127,63,155,173,64,63,144,73,50,63,64,18,150,61,103,242,77,60,246,212,106,189,4,143,127,63,16,121,15,63,68,220,8,63,76,254,135,61,145,10,75,191,239,228,27,191,70,96,44,188,145,72,11,63,135,79,14,63,141,236,138,61,145,10,75,191,239,228,27,191,70,96,44,188,159,30,11,63,41,174,14,63,30,252,4,61,145,10,75,191,239,228,27,191,70,96,44,188,88,116,15,63,129,66,9,63,78,65,254,60,182,162,77,188,80,29,107,61,193,142,127,191,159,30,11,63,41,174,14,63,30,252,4,61,182,162,77,188,80,29,107,61,193,142,127,191,50,2,58,63,197,146,2,63,86,212,224,60,182,162,77,188,80,29,107,61,193,142,127,191,38,197,19,63,91,122,28,63,150,147,144,61,9,84,43,191,83,150,57,63,69,218,38,62,144,192,31,63,147,110,39,63,245,102,148,61,9,84,43,191,83,150,57,63,69,218,38,62,16,203,22,63,133,65,33,63,154,178,19,61,9,84,43,191,83,150,57,63,69,218,38,62,50,2,58,63,197,146,2,63,86,212,224,60,152,246,77,188,121,202,106,61,21,143,127,191,159,30,11,63,41,174,14,63,30,252,4,61,152,246,77,188,121,202,106,61,21,143,127,191,16,203,22,63,133,65,33,63,154,178,19,61,152,246,77,188,121,202,106,61,21,143,127,191,145,72,11,63,135,79,14,63,141,236,138,61,187,208,88,191,226,200,7,63,244,111,23,61,16,203,22,63,133,65,33,63,154,178,19,61,187,208,88,191,226,200,7,63,244,111,23,61,159,30,11,63,41,174,14,63,30,252,4,61,187,208,88,191,226,200,7,63,244,111,23,61,16,121,15,63,68,220,8,63,76,254,135,61,161,188,31,190,182,159,124,191,129,8,49,189,88,116,15,63,129,66,9,63,78,65,254,60,161,188,31,190,182,159,124,191,129,8,49,189,50,2,58,63,197,146,2,63,86,212,224,60,161,188,31,190,182,159,124,191,129,8,49,189,253,189,92,63,186,218,18,63,26,191,240,60,53,238,77,188,208,209,106,61,4,143,127,191,16,203,22,63,133,65,33,63,154,178,19,61,53,238,77,188,208,209,106,61,4,143,127,191,95,64,43,63,137,64,45,63,116,153,26,61,53,238,77,188,208,209,106,61,4,143,127,191,144,192,31,63,147,110,39,63,245,102,148,61,113,89,157,190,141,152,109,63,114,52,87,62,155,173,64,63,144,73,50,63,64,18,150,61,113,89,157,190,141,152,109,63,114,52,87,62,95,64,43,63,137,64,45,63,116,153,26,61,113,89,157,190,141,152,109,63,114,52,87,62,231,141,79,63,209,116,10,63,124,70,130,61,152,251,140,62,189,109,114,191,61,124,41,62,135,139,52,63,83,149,2,63,95,97,129,61,152,251,140,62,189,109,114,191,61,124,41,62,50,2,58,63,197,146,2,63,86,212,224,60,152,251,140,62,189,109,114,191,61,124,41,62,199,74,108,63,194,21,32,63,118,80,137,61,236,248,43,63,148,190,60,191,202,222,146,189,253,189,92,63,186,218,18,63,26,191,240,60,236,248,43,63,148,190,60,191,202,222,146,189,12,5,108,63,61,183,32,63,24,8,2,61,236,248,43,63,148,190,60,191,202,222,146,189,253,189,92,63,186,218,18,63,26,191,240,60,46,3,78,188,109,201,106,61,21,143,127,191,95,64,43,63,137,64,45,63,116,153,26,61,46,3,78,188,109,201,106,61,21,143,127,191,7,154,67,63,92,170,50,63,59,170,26,61,46,3,78,188,109,201,106,61,21,143,127,191,238,176,101,63,17,200,45,63,254,69,144,61,241,71,45,63,252,81,60,191,143,251,214,188,156,53,100,63,123,107,44,63,79,203,143,61,241,71,45,63,252,81,60,191,143,251,214,188,197,59,100,63,227,195,44,63,12,173,14,61,241,71,45,63,252,81,60,191,143,251,214,188,238,176,101,63,17,200,45,63,254,69,144,61,182,101,100,63,28,177,214,62,61,238,43,62,199,74,108,63,194,21,32,63,118,80,137,61,182,101,100,63,28,177,214,62,61,238,43,62,159,201,106,63,139,194,38,63,225,212,7,61,182,101,100,63,28,177,214,62,61,238,43,62,50,2,58,63,197,146,2,63,86,212,224,60,242,94,213,62,34,227,97,191,223,193,95,190,253,189,92,63,186,218,18,63,26,191,240,60,242,94,213,62,34,227,97,191,223,193,95,190,231,141,79,63,209,116,10,63,124,70,130,61,242,94,213,62,34,227,97,191,223,193,95,190,231,141,79,63,209,116,10,63,124,70,130,61,202,250,77,60,134,203,106,189,21,143,127,63,155,173,64,63,144,73,50,63,64,18,150,61,202,250,77,60,134,203,106,189,21,143,127,63,144,192,31,63,147,110,39,63,245,102,148,61,202,250,77,60,134,203,106,189,21,143,127,63,199,74,108,63,194,21,32,63,118,80,137,61,185,195,122,63,156,106,77,62,117,176,126,188,12,5,108,63,61,183,32,63,24,8,2,61,185,195,122,63,156,106,77,62,117,176,126,188,159,201,106,63,139,194,38,63,225,212,7,61,185,195,122,63,156,106,77,62,117,176,126,188,135,139,52,63,83,149,2,63,95,97,129,61,194,79,44,190,241,15,123,191,51,167,203,189,16,121,15,63,68,220,8,63,76,254,135,61,194,79,44,190,241,15,123,191,51,167,203,189,50,2,58,63,197,146,2,63,86,212,224,60,194,79,44,190,241,15,123,191,51,167,203,189,231,141,79,63,209,116,10,63,124,70,130,61,32,237,23,63,243,61,75,191,234,121,7,62,253,189,92,63,186,218,18,63,26,191,240,60,32,237,23,63,243,61,75,191,234,121,7,62,199,74,108,63,194,21,32,63,118,80,137,61,32,237,23,63,243,61,75,191,234,121,7,62,16,203,22,63,133,65,33,63,154,178,19,61,103,242,77,188,134,203,106,61,21,143,127,191,253,189,92,63,186,218,18,63,26,191,240,60,103,242,77,188,134,203,106,61,21,143,127,191,50,2,58,63,197,146,2,63,86,212,224,60,103,242,77,188,134,203,106,61,21,143,127,191,12,5,108,63,61,183,32,63,24,8,2,61,46,3,78,188,109,201,106,61,21,143,127,191,7,154,67,63,92,170,50,63,59,170,26,61,46,3,78,188,109,201,106,61,21,143,127,191,159,201,106,63,139,194,38,63,225,212,7,61,46,3,78,188,109,201,106,61,21,143,127,191,238,176,101,63,17,200,45,63,254,69,144,61,245,129,180,62,140,18,108,63,81,250,34,190,197,59,100,63,227,195,44,63,12,173,14,61,245,129,180,62,140,18,108,63,81,250,34,190,93,107,87,63,199,189,49,63,208,210,21,61,245,129,180,62,140,18,108,63,81,250,34,190,253,17,158,190,243,255,26,190,192,174,134,61,229,69,206,190,147,144,104,191,95,9,228,189,158,149,156,190,203,46,24,190,43,108,6,61,229,69,206,190,147,144,104,191,95,9,228,189,154,67,82,190,160,250,71,190,103,239,76,61,229,69,206,190,147,144,104,191,95,9,228,189,253,17,158,190,243,255,26,190,192,174,134,61,218,26,209,190,130,230,79,191,254,95,213,190,154,67,82,190,160,250,71,190,103,239,76,61,218,26,209,190,130,230,79,191,254,95,213,190,25,227,83,190,61,157,75,190,228,161,111,61,218,26,209,190,130,230,79,191,254,95,213,190,103,68,161,190,177,168,56,190,173,138,240,60,132,157,18,62,18,50,124,63,186,75,194,61,198,192,162,190,217,121,59,190,185,55,127,61,132,157,18,62,18,50,124,63,186,75,194,61,25,227,83,190,61,157,75,190,228,161,111,61,132,157,18,62,18,50,124,63,186,75,194,61,103,68,161,190,177,168,56,190,173,138,240,60,182,214,79,63,253,79,18,63,123,49,244,61,102,76,193,190,52,47,199,189,150,10,106,61,182,214,79,63,253,79,18,63,123,49,244,61,198,192,162,190,217,121,59,190,185,55,127,61,182,214,79,63,253,79,18,63,123,49,244,61,102,76,193,190,52,47,199,189,150,10,106,61,211,102,56,63,245,102,48,191,11,212,162,61,39,137,189,190,83,7,185,189,87,179,78,61,211,102,56,63,245,102,48,191,11,212,162,61,188,230,189,190,131,51,184,189,164,137,119,61,211,102,56,63,245,102,48,191,11,212,162,61,103,68,161,190,177,168,56,190,173,138,240,60,250,155,80,61,74,236,106,63,173,195,201,62,25,227,83,190,61,157,75,190,228,161,111,61,250,155,80,61,74,236,106,63,173,195,201,62,154,67,82,190,160,250,71,190,103,239,76,61,250,155,80,61,74,236,106,63,173,195,201,62,253,17,158,190,243,255,26,190,192,174,134,61,93,165,51,191,215,76,54,191,220,74,175,188,188,230,189,190,131,51,184,189,164,137,119,61,93,165,51,191,215,76,54,191,220,74,175,188,39,137,189,190,83,7,185,189,87,179,78,61,93,165,51,191,215,76,54,191,220,74,175,188,253,17,158,190,243,255,26,190,192,174,134,61,111,41,47,191,87,34,56,191,160,112,246,189,39,137,189,190,83,7,185,189,87,179,78,61,111,41,47,191,87,34,56,191,160,112,246,189,158,149,156,190,203,46,24,190,43,108,6,61,111,41,47,191,87,34,56,191,160,112,246,189,253,17,158,190,243,255,26,190,192,174,134,61,166,69,45,62,117,1,111,61,169,221,123,191,198,192,162,190,217,121,59,190,185,55,127,61,166,69,45,62,117,1,111,61,169,221,123,191,102,76,193,190,52,47,199,189,150,10,106,61,166,69,45,62,117,1,111,61,169,221,123,191,253,17,158,190,243,255,26,190,192,174,134,61,78,157,135,62,66,118,62,62,134,56,114,191,102,76,193,190,52,47,199,189,150,10,106,61,78,157,135,62,66,118,62,62,134,56,114,191,188,230,189,190,131,51,184,189,164,137,119,61,78,157,135,62,66,118,62,62,134,56,114,191,39,137,189,190,83,7,185,189,87,179,78,61,9,251,18,63,84,31,40,62,16,88,77,63,102,76,193,190,52,47,199,189,150,10,106,61,9,251,18,63,84,31,40,62,16,88,77,63,103,68,161,190,177,168,56,190,173,138,240,60,9,251,18,63,84,31,40,62,16,88,77,63,39,137,189,190,83,7,185,189,87,179,78,61,101,171,11,62,175,148,21,190,224,213,122,63,103,68,161,190,177,168,56,190,173,138,240,60,101,171,11,62,175,148,21,190,224,213,122,63,158,149,156,190,203,46,24,190,43,108,6,61,101,171,11,62,175,148,21,190,224,213,122,63,198,192,162,190,217,121,59,190,185,55,127,61,86,43,147,188,123,45,232,61,223,78,126,191,253,17,158,190,243,255,26,190,192,174,134,61,86,43,147,188,123,45,232,61,223,78,126,191,25,227,83,190,61,157,75,190,228,161,111,61,86,43,147,188,123,45,232,61,223,78,126,191,158,149,156,190,203,46,24,190,43,108,6,61,111,102,68,190,172,198,82,189,218,230,122,63,103,68,161,190,177,168,56,190,173,138,240,60,111,102,68,190,172,198,82,189,218,230,122,63,154,67,82,190,160,250,71,190,103,239,76,61,111,102,68,190,172,198,82,189,218,230,122,63,39,46,199,60,227,82,85,190,239,201,3,61,108,120,218,189,153,42,96,191,69,41,241,62,24,11,227,61,222,230,93,190,140,72,20,61,108,120,218,189,153,42,96,191,69,41,241,62,194,221,25,61,255,178,75,190,135,167,87,61,108,120,218,189,153,42,96,191,69,41,241,62,184,33,22,62,191,185,175,190,215,24,148,61,110,167,65,191,79,5,4,63,39,245,205,190,165,17,211,61,247,91,195,190,251,36,215,61,110,167,65,191,79,5,4,63,39,245,205,190,64,138,26,62,0,142,165,190,63,172,183,61,110,167,65,191,79,5,4,63,39,245,205,190,110,167,141,61,107,153,204,190,62,89,177,61,130,60,179,62,73,161,80,63,62,117,236,62,141,210,37,189,169,51,175,190,149,16,140,61,130,60,179,62,73,161,80,63,62,117,236,62,198,220,53,187,224,48,193,190,61,129,208,61,130,60,179,62,73,161,80,63,62,117,236,62,110,167,141,61,107,153,204,190,62,89,177,61,208,155,74,61,33,203,42,63,225,70,62,191,198,220,53,187,224,48,193,190,61,129,208,61,208,155,74,61,33,203,42,63,225,70,62,191,165,17,211,61,247,91,195,190,251,36,215,61,208,155,74,61,33,203,42,63,225,70,62,191,141,210,37,189,169,51,175,190,149,16,140,61,75,33,48,63,196,9,76,61,138,87,57,191,10,214,56,189,127,80,135,190,33,2,142,61,75,33,48,63,196,9,76,61,138,87,57,191,198,220,53,187,224,48,193,190,61,129,208,61,75,33,48,63,196,9,76,61,138,87,57,191,194,221,25,61,255,178,75,190,135,167,87,61,58,59,153,60,38,1,138,190,150,122,118,191,101,223,213,61,161,45,87,190])
.concat([15,212,105,61,58,59,153,60,38,1,138,190,150,122,118,191,168,57,25,62,115,16,132,190,230,30,146,61,58,59,153,60,38,1,138,190,150,122,118,191,231,58,29,62,120,98,142,190,178,19,94,61,115,132,124,191,255,36,126,189,223,224,27,190,64,138,26,62,0,142,165,190,63,172,183,61,115,132,124,191,255,36,126,189,223,224,27,190,168,57,25,62,115,16,132,190,230,30,146,61,115,132,124,191,255,36,126,189,223,224,27,190,231,58,29,62,120,98,142,190,178,19,94,61,39,161,124,191,63,115,6,62,232,108,193,61,184,33,22,62,191,185,175,190,215,24,148,61,39,161,124,191,63,115,6,62,232,108,193,61,64,138,26,62,0,142,165,190,63,172,183,61,39,161,124,191,63,115,6,62,232,108,193,61,110,167,141,61,107,153,204,190,62,89,177,61,133,65,153,188,226,0,138,62,150,122,118,63,184,33,22,62,191,185,175,190,215,24,148,61,133,65,153,188,226,0,138,62,150,122,118,63,141,210,37,189,169,51,175,190,149,16,140,61,133,65,153,188,226,0,138,62,150,122,118,63,39,46,199,60,227,82,85,190,239,201,3,61,192,121,29,63,48,158,73,191,96,201,21,189,194,221,25,61,255,178,75,190,135,167,87,61,192,121,29,63,48,158,73,191,96,201,21,189,10,214,56,189,127,80,135,190,33,2,142,61,192,121,29,63,48,158,73,191,96,201,21,189,102,108,232,188,42,227,127,190,108,65,47,61,208,40,29,63,40,210,73,191,100,31,36,189,39,46,199,60,227,82,85,190,239,201,3,61,208,40,29,63,40,210,73,191,100,31,36,189,10,214,56,189,127,80,135,190,33,2,142,61,208,40,29,63,40,210,73,191,100,31,36,189,10,214,56,189,127,80,135,190,33,2,142,61,158,67,153,60,92,0,138,190,167,122,118,191,168,57,25,62,115,16,132,190,230,30,146,61,158,67,153,60,92,0,138,190,167,122,118,191,64,138,26,62,0,142,165,190,63,172,183,61,158,67,153,60,92,0,138,190,167,122,118,191,24,11,227,61,222,230,93,190,140,72,20,61,73,187,57,191,10,44,48,191,176,3,231,187,168,57,25,62,115,16,132,190,230,30,146,61,73,187,57,191,10,44,48,191,176,3,231,187,101,223,213,61,161,45,87,190,15,212,105,61,73,187,57,191,10,44,48,191,176,3,231,187,141,210,37,189,169,51,175,190,149,16,140,61,138,145,85,63,140,49,48,61,86,185,12,63,102,108,232,188,42,227,127,190,108,65,47,61,138,145,85,63,140,49,48,61,86,185,12,63,10,214,56,189,127,80,135,190,33,2,142,61,138,145,85,63,140,49,48,61,86,185,12,63,24,11,227,61,222,230,93,190,140,72,20,61,118,27,80,191,128,211,235,190,125,120,182,62,231,58,29,62,120,98,142,190,178,19,94,61,118,27,80,191,128,211,235,190,125,120,182,62,168,57,25,62,115,16,132,190,230,30,146,61,118,27,80,191,128,211,235,190,125,120,182,62,184,33,22,62,191,185,175,190,215,24,148,61,133,65,153,188,4,1,138,62,150,122,118,63,102,108,232,188,42,227,127,190,108,65,47,61,133,65,153,188,4,1,138,62,150,122,118,63,141,210,37,189,169,51,175,190,149,16,140,61,133,65,153,188,4,1,138,62,150,122,118,63,184,33,22,62,191,185,175,190,215,24,148,61,133,65,153,188,71,1,138,62,133,122,118,63,231,58,29,62,120,98,142,190,178,19,94,61,133,65,153,188,71,1,138,62,133,122,118,63,102,108,232,188,42,227,127,190,108,65,47,61,133,65,153,188,71,1,138,62,133,122,118,63,24,11,227,61,222,230,93,190,140,72,20,61,193,87,52,190,196,9,116,191,167,90,123,62,101,223,213,61,161,45,87,190,15,212,105,61,193,87,52,190,196,9,116,191,167,90,123,62,194,221,25,61,255,178,75,190,135,167,87,61,193,87,52,190,196,9,116,191,167,90,123,62,10,214,56,189,127,80,135,190,33,2,142,61,158,67,153,60,25,0,138,190,183,122,118,191,194,221,25,61,255,178,75,190,135,167,87,61,158,67,153,60,25,0,138,190,183,122,118,191,168,57,25,62,115,16,132,190,230,30,146,61,158,67,153,60,25,0,138,190,183,122,118,191,10,214,56,189,127,80,135,190,33,2,142,61,108,63,153,60,38,1,138,190,133,122,118,191,64,138,26,62,0,142,165,190,63,172,183,61,108,63,153,60,38,1,138,190,133,122,118,191,165,17,211,61,247,91,195,190,251,36,215,61,108,63,153,60,38,1,138,190,133,122,118,191,198,220,53,187,224,48,193,190,61,129,208,61,108,63,153,60,38,1,138,190,133,122,118,191,10,214,56,189,127,80,135,190,33,2,142,61,108,63,153,60,38,1,138,190,133,122,118,191,165,17,211,61,247,91,195,190,251,36,215,61,108,63,153,60,38,1,138,190,133,122,118,191,231,58,29,62,120,98,142,190,178,19,94,61,158,67,153,188,126,0,138,62,167,122,118,63,39,46,199,60,227,82,85,190,239,201,3,61,158,67,153,188,126,0,138,62,167,122,118,63,102,108,232,188,42,227,127,190,108,65,47,61,158,67,153,188,126,0,138,62,167,122,118,63,231,58,29,62,120,98,142,190,178,19,94,61,26,78,153,188,46,255,137,62,217,122,118,63,24,11,227,61,222,230,93,190,140,72,20,61,26,78,153,188,46,255,137,62,217,122,118,63,39,46,199,60,227,82,85,190,239,201,3,61,26,78,153,188,46,255,137,62,217,122,118,63,184,33,22,62,191,185,175,190,215,24,148,61,168,85,12,191,96,200,78,63,130,26,94,62,110,167,141,61,107,153,204,190,62,89,177,61,168,85,12,191,96,200,78,63,130,26,94,62,165,17,211,61,247,91,195,190,251,36,215,61,168,85,12,191,96,200,78,63,130,26,94,62,220,155,95,187,231,200,106,190,81,250,2,61,113,201,81,191,25,88,247,190,122,222,157,62,186,158,232,60,193,168,140,190,82,158,57,61,113,201,81,191,25,88,247,190,122,222,157,62,172,31,155,60,38,139,123,190,140,159,134,61,113,201,81,191,25,88,247,190,122,222,157,62,172,31,155,60,38,139,123,190,140,159,134,61,34,57,153,60,71,1,138,190,133,122,118,191,253,20,7,61,111,45,163,190,241,17,177,61,34,57,153,60,71,1,138,190,133,122,118,191,149,45,34,190,42,167,133,190,14,101,136,61,34,57,153,60,71,1,138,190,133,122,118,191,131,109,20,190,166,69,125,190,47,105,12,61,241,161,244,62,47,48,63,191,191,211,236,62,59,142,159,189,37,35,87,190,38,24,206,60,241,161,244,62,47,48,63,191,191,211,236,62,200,9,211,189,188,230,85,190,19,99,89,61,241,161,244,62,47,48,63,191,191,211,236,62,200,9,211,189,188,230,85,190,19,99,89,61,83,61,153,60,59,0,138,190,167,122,118,191,84,225,15,189,73,72,84,190,173,250,92,61,83,61,153,60,59,0,138,190,167,122,118,191,172,31,155,60,38,139,123,190,140,159,134,61,83,61,153,60,59,0,138,190,167,122,118,191,149,45,34,190,42,167,133,190,14,101,136,61,34,57,153,60,4,1,138,190,150,122,118,191,200,9,211,189,188,230,85,190,19,99,89,61,34,57,153,60,4,1,138,190,150,122,118,191,172,31,155,60,38,139,123,190,140,159,134,61,34,57,153,60,4,1,138,190,150,122,118,191,121,204,192,188,39,217,202,190,132,97,160,61,108,63,153,188,59,0,138,62,167,122,118,63,3,63,26,190,20,203,181,190,236,190,131,61,108,63,153,188,59,0,138,62,167,122,118,63,235,173,225,189,165,135,201,190,155,116,155,61,108,63,153,188,59,0,138,62,167,122,118,63,54,62,35,190,31,187,171,190,185,253,178,61,158,67,153,60,92,0,138,190,167,122,118,191,253,20,7,61,111,45,163,190,241,17,177,61,158,67,153,60,92,0,138,190,167,122,118,191,10,128,113,187,32,121,191,190,98,75,207,61,158,67,153,60,92,0,138,190,167,122,118,191,3,182,3,61,149,185,169,190,214,2,123,61,213,64,127,191,230,203,75,189,198,23,109,61,253,20,7,61,111,45,163,190,241,17,177,61,213,64,127,191,230,203,75,189,198,23,109,61,186,158,232,60,193,168,140,190,82,158,57,61,213,64,127,191,230,203,75,189,198,23,109,61,186,158,232,60,193,168,140,190,82,158,57,61,147,83,119,191,78,13,100,190,41,148,5,190,253,20,7,61,111,45,163,190,241,17,177,61,147,83,119,191,78,13,100,190,41,148,5,190,172,31,155,60,38,139,123,190,140,159,134,61,147,83,119,191,78,13,100,190,41,148,5,190,121,204,192,188,39,217,202,190,132,97,160,61,108,63,153,188,126,0,138,62,167,122,118,63,239,227,40,190,255,179,158,190,18,164,82,61,108,63,153,188,126,0,138,62,167,122,118,63,3,63,26,190,20,203,181,190,236,190,131,61,108,63,153,188,126,0,138,62,167,122,118,63,121,204,192,188,39,217,202,190,132,97,160,61,83,61,153,188,126,0,138,62,167,122,118,63,3,182,3,61,149,185,169,190,214,2,123,61,83,61,153,188,126,0,138,62,167,122,118,63,239,227,40,190,255,179,158,190,18,164,82,61,83,61,153,188,126,0,138,62,167,122,118,63,235,173,225,189,165,135,201,190,155,116,155,61,19,130,61,63,120,209,39,63,40,211,24,190,54,62,35,190,31,187,171,190,185,253,178,61,19,130,61,63,120,209,39,63,40,211,24,190,117,231,233,189,160,52,196,190,18,50,208,61,19,130,61,63,120,209,39,63,40,211,24,190,2,217,107,189,80,26,202,190,157,13,217,61,183,69,153,60,50,2,138,190,99,122,118,191,117,231,233,189,160,52,196,190,18,50,208,61,183,69,153,60,50,2,138,190,99,122,118,191,10,128,113,187,32,121,191,190,98,75,207,61,183,69,153,60,50,2,138,190,99,122,118,191,220,155,95,187,231,200,106,190,81,250,2,61,85,136,19,191,14,46,81,191,172,27,111,188,172,31,155,60,38,139,123,190,140,159,134,61,85,136,19,191,14,46,81,191,172,27,111,188,84,225,15,189,73,72,84,190,173,250,92,61,85,136,19,191,14,46,81,191,172,27,111,188,10,128,113,187,32,121,191,190,98,75,207,61,0,172,86,191,113,30,254,62,82,14,102,190,253,20,7,61,111,45,163,190,241,17,177,61,0,172,86,191,113,30,254,62,82,14,102,190,3,182,3,61,149,185,169,190,214,2,123,61,0,172,86,191,113,30,254,62,82,14,102,190,3,182,3,61,149,185,169,190,214,2,123,61,83,61,153,188,105,1,138,62,133,122,118,63,131,109,20,190,166,69,125,190,47,105,12,61,83,61,153,188,105,1,138,62,133,122,118,63,239,227,40,190,255,179,158,190,18,164,82,61,83,61,153,188,105,1,138,62,133,122,118,63,121,204,192,188,39,217,202,190,132,97,160,61,239,115,180,190,254,67,78,63,250,183,243,190,2,217,107,189,80,26,202,190,157,13,217,61,239,115,180,190,254,67,78,63,250,183,243,190,10,128,113,187,32,121,191,190,98,75,207,61,239,115,180,190,254,67,78,63,250,183,243,190,235,173,225,189,165,135,201,190,155,116,155,61,25,231,51,63,240,167,38,63,208,236,146,190,3,63,26,190,20,203,181,190,236,190,131,61,25,231,51,63,240,167,38,63,208,236,146,190,54,62,35,190,31,187,171,190,185,253,178,61,25,231,51,63,240,167,38,63,208,236,146,190,3,182,3,61,149,185,169,190,214,2,123,61,208,71,153,188,248,255,137,62,183,122,118,63,186,158,232,60,193,168,140,190,82,158,57,61,208,71,153,188,248,255,137,62,183,122,118,63,131,109,20,190,166,69,125,190,47,105,12,61,208,71,153,188,248,255,137,62,183,122,118,63,3,63,26,190,20,203,181,190,236,190,131,61,67,84,113,63,201,88,165,62,245,215,171,61,239,227,40,190,255,179,158,190,18,164,82,61,67,84,113,63,201,88,165,62,245,215,171,61,54,62,35,190,31,187,171,190,185,253,178,61,67,84,113,63,201,88,165,62,245,215,171,61,131,109,20,190,166,69,125,190,47,105,12,61,22,167,46,63,53,12,59,191,190,45,216,188,200,9,211,189,188,230,85,190,19,99,89,61,22,167,46,63,53,12,59,191,190,45,216,188,149,45,34,190,42,167,133,190,14,101,136,61,22,167,46,63,53,12,59,191,190,45,216,188,235,173,225,189,165,135,201,190,155,116,155,61,250,96,89,62,45,204,106,63,193,168,172,190,117,231,233,189,160,52,196,190,18,50,208,61,250,96,89,62,45,204,106,63,193,168,172,190,2,217,107,189,80,26,202,190,157,13,217,61,250,96,89,62,45,204,106,63,193,168,172,190,186,158,232,60,193,168,140,190,82,158,57,61,208,71,153,188,25,0,138,62,183,122,118,63,220,155,95,187,231,200,106,190,81,250,2,61,208,71,153,188,25,0,138,62,183,122,118,63,131,109,20,190,166,69,125,190,47,105,12,61,208,71,153,188,25,0,138,62,183,122,118,63,220,155,95,187,231,200,106,190,81,250,2,61,1,76,153,188,84,2,138,62,99,122,118,63,59,142,159,189,37,35,87,190,38,24,206,60,1,76,153,188,84,2,138,62,99,122,118,63,131,109,20,190,166,69,125,190,47,105,12,61,1,76,153,188,84,2,138,62,99,122,118,63,59,142,159,189,37,35,87,190,38,24,206,60,203,72,133,190,193,29,88,191,159,231,239,62,220,155,95,187,231,200,106,190,81,250,2,61,203,72,133,190,193,29,88,191,159,231,239,62,84,225,15,189,73,72,84,190,173,250,92,61,203,72,133,190,193,29,88,191,159,231,239,62,121,204,192,188,39,217,202,190,132,97,160,61,49,211,246,60,81,218,127,63,153,71,126,188,235,173,225,189,165,135,201,190,155,116,155,61,49,211,246,60,81,218,127,63,153,71,126,188,2,217,107,189,80,26,202,190,157,13,217,61,49,211,246,60,81,218,127,63,153,71,126,188,3,182,3,61,149,185,169,190,214,2,123,61,239,87,65,191,178,184,39,63,91,6,156,60,121,204,192,188,39,217,202,190,132,97,160,61,239,87,65,191,178,184,39,63,91,6,156,60,10,128,113,187,32,121,191,190,98,75,207,61,239,87,65,191,178,184,39,63,91,6,156,60,239,227,40,190,255,179,158,190,18,164,82,61,213,65,122,63,16,235,141,189,168,171,75,190,149,45,34,190,42,167,133,190,14,101,136,61,213,65,122,63,16,235,141,189,168,171,75,190,54,62,35,190,31,187,171,190,185,253,178,61,213,65,122,63,16,235,141,189,168,171,75,190,239,227,40,190,255,179,158,190,18,164,82,61,36,67,110,63,32,96,93,190,99,13,151,62,131,109,20,190,166,69,125,190,47,105,12,61,36,67,110,63,32,96,93,190,99,13,151,62,149,45,34,190,42,167,133,190,14,101,136,61,36,67,110,63,32,96,93,190,99,13,151,62,117,231,233,189,160,52,196,190,18,50,208,61,158,67,153,60,159,0,138,190,167,122,118,191,54,62,35,190,31,187,171,190,185,253,178,61,158,67,153,60,159,0,138,190,167,122,118,191,10,128,113,187,32,121,191,190,98,75,207,61,158,67,153,60,159,0,138,190,167,122,118,191,149,45,34,190,42,167,133,190,14,101,136,61,158,67,153,60,113,255,137,190,200,122,118,191,253,20,7,61,111,45,163,190,241,17,177,61,158,67,153,60,113,255,137,190,200,122,118,191,54,62,35,190,31,187,171,190,185,253,178,61,158,67,153,60,113,255,137,190,200,122,118,191,59,142,159,189,37,35,87,190,38,24,206,60,227,142,183,60,244,107,127,191,225,183,129,61,84,225,15,189,73,72,84,190,173,250,92,61,227,142,183,60,244,107,127,191,225,183,129,61,200,9,211,189,188,230,85,190,19,99,89,61,227,142,183,60,244,107,127,191,225,183,129,61,147,143,9,191,152,51,219,188,78,96,122,61,16,4,72,58,23,14,4,187,222,255,127,63,202,193,236,62,41,93,122,61,227,250,119,61,16,4,72,58,23,14,4,187,222,255,127,63,148,46,9,191,117,1,239,61,76,142,123,61,16,4,72,58,23,14,4,187,222,255,127,63,92,115,103,63,201,86,239,62,90,245,121,61,200,126,246,61,33,29,126,191,102,247,100,188,184,148,55,63,184,62,228,62,117,29,42,188,200,126,246,61,33,29,126,191,102,247,100,188,127,134,103,63,93,223,239,62,78,180,43,188,200,126,246,61,33,29,126,191,102,247,100,188,244,194,205,62,223,108,83,190,241,245,117,61,211,104,70,63,78,98,28,191,11,151,37,190,237,127,152,62,104,147,163,190,24,39,62,188,211,104,70,63,78,98,28,191,11,151,37,190,198,250,214,62,214,171,40,190,138,144,58,188,211,104,70,63,78,98,28,191,11,151,37,190,44,97,9,191,52,130,237,61,234,88,37,188,244,192,71,186,137,236,3,59,222,255,127,191,139,111,216,62,212,240,125,62,68,247,44,188,244,192,71,186,137,236,3,59,222,255,127,191,189,57,236,62,129,203,131,61,203,128,51,188,244,192,71,186,137,236,3,59,222,255,127,191,44,97,9,191,52,130,237,61,234,88,37,188,16,4,72,186,222,30,4,59,222,255,127,191,150,232,236,190,243,226,148,62,103,127,32,188,16,4,72,186,222,30,4,59,222,255,127,191,139,111,216,62,212,240,125,62,68,247,44,188,16,4,72,186,222,30,4,59,222,255,127,191,153,154,228,190,165,104,101,190,159,118,120,61,16,4,72,58,23,14,4,187,222,255,127,63,239,59,142,62,133,151,168,190,130,85,117,61,16,4,72,58,23,14,4,187,222,255,127,63,244,194,205,62,223,108,83,190,241,245,117,61,16,4,72,58,23,14,4,187,222,255,127,63,98,104,57,191,241,131,211,62,87,152,126,61,119,100,36,191,190,220,67,191,213,91,67,61,55,251,107,191,151,54,20,63,115,74,128,61,119,100,36,191,190,220,67,191,213,91,67,61,11,181,106,191,159,0,18,63,150,150,17,188,119,100,36,191,190,220,67,191,213,91,67,61,153,44,66,63,92,116,226,62,68,52,122,61,189,58,71,58,137,236,3,187,222,255,127,63,92,115,103,63,201,86,239,62,90,245,121,61,189,58,71,58,137,236,3,187,222,255,127,63,67,231,33,63,31,133,227,62,31,157,122,61,189,58,71,58,137,236,3,187,222,255,127,63,239,59,142,62,133,151,168,190,130,85,117,61,75,62,158,62,21,54,115,191,233,41,50,189,33,30,169,61,9,111,199,190,160,198,61,188,75,62,158,62,21,54,115,191,233,41,50,189,237,127,152,62,104,147,163,190,24,39,62,188,75,62,158,62,21,54,115,191,233,41,50,189,106,162,111,191,248,53,66,63,214,29,11,188,244,192,71,186,137,236,3,59,222,255,127,191,63,114,83,191,34,84,89,63,203,130,9,188,244,192,71,186,137,236,3,59,222,255,127,191,195,69,26,191,88,115,80,63,109,113,13,188,244,192,71,186,137,236,3,59,222,255,127,191,248,140,0,63,14,102,47,63,138,2,125,61,16,4,72,58,79,148,4,187,222,255,127,63,198,82,116,63,195,183,64,63,112,40,124,61,16,4,72,58,79,148,4,187,222,255,127,63,94,129,32,63,58,88,67,63,141,67,125,61,16,4,72,58,79,148,4,187,222,255,127,63,183,13,133,63,225,127,19,63,252,110,122,61,248,198,120,63,244,253,20,190,227,23,62,190,21,200,130,63,232,132,12,63,31,130,42,188,248,198,120,63,244,253,20,190,227,23,62,190,116,39,132,63,83,207,30,63,178,71,40,188,248,198,120,63,244,253,20,190,227,23,62,190,68,196,165,62,203,15,244,62,178,215,123,61,136,129,66,191,21,113,38,63,79,90,56,187,248,140,0,63,14,102,47,63,138,2,125,61,136,129,66,191,21,113,38,63,79,90,56,187,91,9,165,62,204,12,243,62,180,59,36,188,136,129,66,191,21,113,38,63,79,90,56,187,153,154,228,190,165,104,101,190,159,118,120,61,70,123,104,191,116,41,214,190,55,28,150,60,147,143,9,191,152,51,219,188,78,96,122,61,70,123,104,191,116,41,214,190,55,28,150,60,254,14,9,191,210,223,11,189,202,79,42,188,70,123,104,191,116,41,214,190,55,28,150,60,185,226,226,190,70,238,105,190,143,225,49,188,16,4,72,186,165,47,4,59,222,255,127,191,254,14,9,191,210,223,11,189,202,79,42,188,16,4,72,186,165,47,4,59,222,255,127,191,198,250,214,62,214,171,40,190,138,144,58,188,16,4,72,186,165,47,4,59,222,255,127,191,254,14,9,191,210,223,11,189,202,79,42,188,244,192,71,186,23,14,4,59,222,255,127,191,44,97,9,191,52,130,237,61,234,88,37,188,244,192,71,186,23,14,4,59,222,255,127,191,189,57,236,62,129,203,131,61,203,128,51,188,244,192,71,186,23,14,4,59,222,255,127,191,84,252,255,190,239,202,182,62,139,110,125,61,253,104,120,190,155,61,120,191,215,52,239,188,98,104,57,191,241,131,211,62,87,152,126,61,253,104,120,190,155,61,120,191,215,52,239,188,204,183,2,191,45,66,185,62,109,140,29,188,253,104,120,190,155,61,120,191,215,52,239,188,98,104,57,191,241,131,211,62,87,152,126,61,16,4,72,58,79,148,4,187,222,255,127,63,118,136,223,61,220,70,211,62,101,252,123,61,16,4,72,58,79,148,4,187,222,255,127,63,218,172,154,190,153,15,216,62,146,89,125,61,16,4,72,58,79,148,4,187,222,255,127,63,98,104,57,191,241,131,211,62,87,152,126,61,16,4,72,58,137,236,3,187,222,255,127,63,94,18,247,62,214,139,201,62,181,169,122,61,16,4,72,58,137,236,3,187,222,255,127,63,118,136,223,61,220,70,211,62,101,252,123,61,16,4,72,58,137,236,3,187,222,255,127,63,114,221,72,191,2,188,89,63,47,50,129,61,57,14,28,62,189,112,123,63,236,22,225,189,195,69,26,191,88,115,80,63,109,113,13,188,57,14,28,62,189,112,123,63,236,22,225,189,63,114,83,191,34,84,89,63,203,130,9,188,57,14,28,62,189,112,123,63,236,22,225,189,94,18,247,62,214,139,201,62,181,169,122,61,156,250,68,63,172,230,29,191,137,211,41,190,41,32,213,62,240,54,159,62,18,48,122,61,156,250,68,63,172,230,29,191,137,211,41,190,209,148,221,62,45,153,179,62,104,176,41,188,156,250,68,63,172,230,29,191,137,211,41,190,55,251,107,191,151,54,20,63,115,74,128,61,244,192,71,58,165,47,4,187,222,255,127,63,7,97,230,190,194,23,22,63,36,43,127,61,244,192,71,58,165,47,4,187,222,255,127,63,206,57,112,191,48,212,61,63,181,252,128,61,244,192,71,58,165,47,4,187,222,255,127,63,70,97,47,63,181,226,71,63,64,161,30,188,44,71,72,186,223,135,3,59,222,255,127,191,117,3,93,63,155,32,74,63,96,148,32,188,44,71,72,186,223,135,3,59,222,255,127,191,70,182,119,63,28,94,60,63,231,168,35,188,44,71,72,186,223,135,3,59,222,255,127,191,206,57,112,191,48,212,61,63,181,252,128,61,134,4,84,191,246,237,12,63,44,41,215,61,219,190,99,191,124,153,80,63,231,54,129,61,134,4,84,191,246,237,12,63,44,41,215,61,106,162,111,191,248,53,66,63,214,29,11,188,134,4,84,191,246,237,12,63,44,41,215,61,244,194,205,62,223,108,83,190,241,245,117,61,90,46,51,63,149,15,53,191,249,129,203,61,239,59,142,62,133,151,168,190,130,85,117,61,90,46,51,63,149,15,53,191,249,129,203,61,237,127,152,62,104,147,163,190,24,39,62,188,90,46,51,63,149,15,53,191,249,129,203,61,239,59,142,62,133,151,168,190,130,85,117,61,27,214,148,62,167,236,116,191,104,230,73,60,100,62,160,61,207,162,199,190,247,116,117,61,27,214,148,62,167,236,116,191,104,230,73,60,33,30,169,61,9,111,199,190,160,198,61,188,27,214,148,62,167,236,116,191,104,230,73,60,98,104,57,191,241,131,211,62,87,152,126,61,16,4,72,58,22,165,4,187,222,255,127,63,218,172,154,190,153,15,216,62,146,89,125,61,16,4,72,58,22,165,4,187,222,255,127,63,83,93,200,190,195,41,243,62,18,17,126,61,16,4,72,58,22,165,4,187,222,255,127,63,118,136,223,61,220,70,211,62,101,252,123,61,244,192,71,58,165,47,4,187,222,255,127,63,94,18,247,62,214,139,201,62,181,169,122,61,244,192,71,58,165,47,4,187,222,255,127,63,67,231,33,63,31,133,227,62,31,157,122,61,244,192,71,58,165,47,4,187,222,255,127,63,172,2,5,63,246,211,51,63,170,43,31,188,244,192,71,186,193,114,4,59,222,255,127,191,70,97,47,63,181,226,71,63,64,161,30,188,244,192,71,186,193,114,4,59,222,255,127,191,70,182,119,63,28,94,60,63,231,168,35,188,244,192,71,186,193,114,4,59,222,255,127,191,106,162,111,191,248,53,66,63,214,29,11,188,16,4,72,186,165,47,4,59,222,255,127,191,195,69,26,191,88,115,80,63,109,113,13,188,16,4,72,186,165,47,4,59,222,255,127,191,173,50,243,190,85,221,47,63,54,62,19,188,16,4,72,186,165,47,4,59,222,255,127,191,68,196,165,62,203,15,244,62,178,215,123,61,244,192,71,58,165,47,4,187,222,255,127,63,183,13,133,63,225,127,19,63,252,110,122,61,244,192,71,58,165,47,4,187,222,255,127,63,248,140,0,63,14,102,47,63,138,2,125,61,244,192,71,58,165,47,4,187,222,255,127,63,248,140,0,63,14,102,47,63,138,2,125,61,239,114,65,191,143,138,39,63,71,233,210,188,172,2,5,63,246,211,51,63,170,43,31,188,239,114,65,191,143,138,39,63,71,233,210,188,91,9,165,62,204,12,243,62,180,59,36,188,239,114,65,191,143,138,39,63,71,233,210,188,147,143,9,191,152,51,219,188,78,96,122,61,203,248,127,191,99,151,40,60,78,41,47,60,148,46,9,191,117,1,239,61,76,142,123,61,203,248,127,191,99,151,40,60,78,41,47,60,44,97,9,191,52,130,237,61,234,88,37,188,203,248,127,191,99,151,40,60,78,41,47,60,209,148,221,62,45,153,179,62,104,176,41,188,148,19,9,63,250,185,85,191,159,170,2,62,178,160,12,63,30,224,217,62,142,176,40,188,148,19,9,63,250,185,85,191,159,170,2,62,94,18,247,62,214,139,201,62,181,169,122,61,148,19,9,63,250,185,85,191,159,170,2,62,198,82,116,63,195,183,64,63,112,40,124,61,129,10,99,63,185,137,218,62,95,12,53,62,183,13,133,63,225,127,19,63,252,110,122,61,129,10,99,63,185,137,218,62,95,12,53,62,116,39,132,63,83,207,30,63,178,71,40,188,129,10,99,63,185,137,218,62,95,12,53,62,100,62,160,61,207,162,199,190,247,116,117,61,84,197,244,189,240,20,126,191,130,59,208,60,153,40,114,190,67,58,180,190,81,192,118,61,84,197,244,189,240,20,126,191,130,59,208,60,138,199,101,190,24,233,181,190,192,207,56,188,84,197,244,189,240,20,126,191,130,59,208,60,153,40,114,190,67,58,180,190,81,192,118,61,217,38,5,191,249,134,90,191,227,223,231,60,153,154,228,190,165,104,101,190,159,118,120,61,217,38,5,191,249,134,90,191,227,223,231,60,185,226,226,190,70,238,105,190,143,225,49,188,217,38,5,191,249,134,90,191,227,223,231,60,118,136,223,61,220,70,211,62,101,252,123,61,100,205,72,58,156,80,8,187,206,255,127,63,67,231,33,63,31,133,227,62,31,157,122,61,100,205,72,58,156,80,8,187,206,255,127,63,92,115,103,63,201,86,239,62,90,245,121,61,100,205,72,58,156,80,8,187,206,255,127,63,118,136,223,61,220,70,211,62,101,252,123,61,216,125,71,58,109,169,3,187,222,255,127,63,92,115,103,63,201,86,239,62,90,245,121,61,216,125,71,58,109,169,3,187,222,255,127,63,68,196,165,62,203,15,244,62,178,215,123,61,216,125,71,58,109,169,3,187,222,255,127,63,11,181,106,191,159,0,18,63,150,150,17,188,16,4,72,186,108,64,4,59,222,255,127,191,106,162,111,191,248,53,66,63,214,29,11,188,16,4,72,186,108,64,4,59,222,255,127,191,173,50,243,190,85,221,47,63,54,62,19,188,16,4,72,186,108,64,4,59,222,255,127,191,68,196,165,62,203,15,244,62,178,215,123,61,216,125,71,58,23,14,4,187,222,255,127,63,92,115,103,63,201,86,239,62,90,245,121,61,216,125,71,58,23,14,4,187,222,255,127,63,183,13,133,63,225,127,19,63,252,110,122,61,216,125,71,58,23,14,4,187,222,255,127,63,114,221,72,191,2,188,89,63,47,50,129,61,52,134,145,62,213,175,108,63,61,240,129,62,101,227,9,191,224,101,70,63,115,128,128,61,52,134,145,62,213,175,108,63,61,240,129,62,195,69,26,191,88,115,80,63,109,113,13,188,52,134,145,62,213,175,108,63,61,240,129,62,172,2,5,63,246,211,51,63,170,43,31,188,244,192,71,186,222,30,4,59,222,255,127,191,70,182,119,63,28,94,60,63,231,168,35,188,244,192,71,186,222,30,4,59,222,255,127,191,116,39,132,63,83,207,30,63,178,71,40,188,244,192,71,186,222,30,4,59,222,255,127,191,153,154,228,190,165,104,101,190,159,118,120,61,184,59,103,191,218,140,219,190,208,66,130,188,254,14,9,191,210,223,11,189,202,79,42,188,184,59,103,191,218,140,219,190,208,66,130,188,185,226,226,190,70,238,105,190,143,225,49,188,184,59,103,191,218,140,219,190,208,66,130,188,118,136,223,61,220,70,211,62,101,252,123,61,135,107,181,60,99,237,127,63,53,96,16,60,209,176,216,61,35,163,211,62,139,139,35,188,135,107,181,60,99,237,127,63,53,96,16,60,85,108,156,190,18,77,216,62,9,27,30,188,135,107,181,60,99,237,127,63,53,96,16,60,94,129,32,63,58,88,67,63,141,67,125,61,249,104,217,190,123,164,101,63,231,227,250,189,70,97,47,63,181,226,71,63,64,161,30,188,249,104,217,190,123,164,101,63,231,227,250,189,172,2,5,63,246,211,51,63,170,43,31,188,249,104,217,190,123,164,101,63,231,227,250,189,219,190,99,191,124,153,80,63,231,54,129,61,51,137,162,190,192,38,111,63,51,195,38,62,114,221,72,191,2,188,89,63,47,50,129,61,51,137,162,190,192,38,111,63,51,195,38,62,63,114,83,191,34,84,89,63,203,130,9,188,51,137,162,190,192,38,111,63,51,195,38,62,11,181,106,191,159,0,18,63,150,150,17,188,244,192,71,186,222,30,4,59,222,255,127,191,173,50,243,190,85,221,47,63,54,62,19,188,244,192,71,186,222,30,4,59,222,255,127,191,46,199,219,190,98,74,4,63,168,111,25,188,244,192,71,186,222,30,4,59,222,255,127,191,153,154,228,190,165,104,101,190,159,118,120,61,16,4,72,58,23,14,4,187,222,255,127,63,244,194,205,62,223,108,83,190,241,245,117,61,16,4,72,58,23,14,4,187,222,255,127,63,147,143,9,191,152,51,219,188,78,96,122,61,16,4,72,58,23,14,4,187,222,255,127,63,7,97,230,190,194,23,22,63,36,43,127,61,147,57,94,63,60,46,234,62,235,169,69,190,83,93,200,190,195,41,243,62,18,17,126,61,147,57,94,63,60,46,234,62,235,169,69,190,46,199,219,190,98,74,4,63,168,111,25,188,147,57,94,63,60,46,234,62,235,169,69,190,91,9,165,62,204,12,243,62,180,59,36,188,216,125,71,186,222,30,4,59,222,255,127,191,172,2,5,63,246,211,51,63,170,43,31,188,216,125,71,186,222,30,4,59,222,255,127,191,116,39,132,63,83,207,30,63,178,71,40,188,216,125,71,186,222,30,4,59,222,255,127,191,94,18,247,62,214,139,201,62,181,169,122,61,95,235,162,62,13,171,112,191,51,83,250,189,178,160,12,63,30,224,217,62,142,176,40,188,95,235,162,62,13,171,112,191,51,83,250,189,67,231,33,63,31,133,227,62,31,157,122,61,95,235,162,62,13,171,112,191,51,83,250,189,55,251,107,191,151,54,20,63,115,74,128,61,170,67,126,191,156,166,207,189,70,235,104,189,106,162,111,191,248,53,66,63,214,29,11,188,170,67,126,191,156,166,207,189,70,235,104,189,11,181,106,191,159,0,18,63,150,150,17,188,170,67,126,191,156,166,207,189,70,235,104,189,98,104,57,191,241,131,211,62,87,152,126,61,165,192,114,190,96,175,120,191,155,173,60,188,201,3,57,191,240,193,211,62,190,48,25,188,165,192,114,190,96,175,120,191,155,173,60,188,204,183,2,191,45,66,185,62,109,140,29,188,165,192,114,190,96,175,120,191,155,173,60,188,153,40,114,190,67,58,180,190,81,192,118,61,244,192,71,58,51,81,4,187,222,255,127,63,239,59,142,62,133,151,168,190,130,85,117,61,244,192,71,58,51,81,4,187,222,255,127,63,153,154,228,190,165,104,101,190,159,118,120,61,244,192,71,58,51,81,4,187,222,255,127,63,83,93,200,190,195,41,243,62,18,17,126,61,60,163,25,63,132,127,73,63,63,224,17,62,85,108,156,190,18,77,216,62,9,27,30,188,60,163,25,63,132,127,73,63,63,224,17,62,46,199,219,190,98,74,4,63,168,111,25,188,60,163,25,63,132,127,73,63,63,224,17,62,91,9,165,62,204,12,243,62,180,59,36,188,16,4,72,186,79,148,4,59,222,255,127,191,116,39,132,63,83,207,30,63,178,71,40,188,16,4,72,186,79,148,4,59,222,255,127,191,21,200,130,63,232,132,12,63,31,130,42,188,16,4,72,186,79,148,4,59,222,255,127,191,138,199,101,190,24,233,181,190,192,207,56,188,16,4,72,186,222,30,4,59,222,255,127,191,185,226,226,190,70,238,105,190,143,225,49,188,16,4,72,186,222,30,4,59,222,255,127,191,237,127,152,62,104,147,163,190,24,39,62,188,16,4,72,186,222,30,4,59,222,255,127,191,67,231,33,63,31,133,227,62,31,157,122,61,22,189,243,61,183,70,124,191,109,114,248,61,178,160,12,63,30,224,217,62,142,176,40,188,22,189,243,61,183,70,124,191,109,114,248,61,184,148,55,63,184,62,228,62,117,29,42,188,22,189,243,61,183,70,124,191,109,114,248,61,41,32,213,62,240,54,159,62,18,48,122,61,147,25,123,63,154,180,57,62,17,53,145,189,202,193,236,62,41,93,122,61,227,250,119,61,147,25,123,63,154,180,57,62,17,53,145,189,139,111,216,62,212,240,125,62,68,247,44,188,147,25,123,63,154,180,57,62,17,53,145,189,7,97,230,190,194,23,22,63,36,43,127,61,221,35,119,63,117,205,132,62,90,15,223,60,46,199,219,190,98,74,4,63,168,111,25,188,221,35,119,63,117,205,132,62,90,15,223,60,173,50,243,190,85,221,47,63,54,62,19,188,221,35,119,63,117,205,132,62,90,15,223,60,94,129,32,63,58,88,67,63,141,67,125,61,44,71,72,58,166,152,3,187,222,255,127,63,198,82,116,63,195,183,64,63,112,40,124,61,44,71,72,58,166,152,3,187,222,255,127,63,226,177,79,63,33,90,75,63,195,241,124,61,44,71,72,58,166,152,3,187,222,255,127,63,152,219,237,190,70,235,144,62,242,180,124,61,244,192,71,58,221,181,4,187,222,255,127,63,41,32,213,62,240,54,159,62,18,48,122,61,244,192,71,58,221,181,4,187,222,255,127,63,84,252,255,190,239,202,182,62,139,110,125,61,244,192,71,58,221,181,4,187,222,255,127,63,152,219,237,190,70,235,144,62,242,180,124,61,244,192,71,58,108,64,4,187,222,255,127,63,202,193,236,62,41,93,122,61,227,250,119,61,244,192,71,58,108,64,4,187,222,255,127,63,41,32,213,62,240,54,159,62,18,48,122,61,244,192,71,58,108,64,4,187,222,255,127,63,150,232,236,190,243,226,148,62,103,127,32,188,16,4,72,186,108,64,4,59,222,255,127,191,209,148,221,62,45,153,179,62,104,176,41,188,16,4,72,186,108,64,4,59,222,255,127,191,139,111,216,62,212,240,125,62,68,247,44,188,16,4,72,186,108,64,4,59,222,255,127,191,219,190,99,191,124,153,80,63,231,54,129,61,90,73,31,191,141,70,66,63,129,206,68,190,63,114,83,191,34,84,89,63,203,130,9,188,90,73,31,191,141,70,66,63,129,206,68,190,106,162,111,191,248,53,66,63,214,29,11,188,90,73,31,191,141,70,66,63,129,206,68,190,98,104,57,191,241,131,211,62,87,152,126,61,244,192,71,58,108,64,4,187,222,255,127,63,83,93,200,190,195,41,243,62,18,17,126,61,244,192,71,58,108,64,4,187,222,255,127,63,55,251,107,191,151,54,20,63,115,74,128,61,244,192,71,58,108,64,4,187,222,255,127,63,91,9,165,62,204,12,243,62,180,59,36,188,244,192,71,186,222,30,4,59,222,255,127,191,21,200,130,63,232,132,12,63,31,130,42,188,244,192,71,186,222,30,4,59,222,255,127,191,127,134,103,63,93,223,239,62,78,180,43,188,244,192,71,186,222,30,4,59,222,255,127,191,94,129,32,63,58,88,67,63,141,67,125,61,187,67,42,190,217,234,122,63,248,54,221,61,226,177,79,63,33,90,75,63,195,241,124,61,187,67,42,190,217,234,122,63,248,54,221,61,70,97,47,63,181,226,71,63,64,161,30,188,187,67,42,190,217,234,122,63,248,54,221,61,185,226,226,190,70,238,105,190,143,225,49,188,16,4,72,186,165,47,4,59,222,255,127,191,198,250,214,62,214,171,40,190,138,144,58,188,16,4,72,186,165,47,4,59,222,255,127,191,237,127,152,62,104,147,163,190,24,39,62,188,16,4,72,186,165,47,4,59,222,255,127,191,202,193,236,62,41,93,122,61,227,250,119,61,233,214,123,63,25,112,54,190,235,226,182,188,198,250,214,62,214,171,40,190,138,144,58,188,233,214,123,63,25,112,54,190,235,226,182,188,189,57,236,62,129,203,131,61,203,128,51,188,233,214,123,63,25,112,54,190,235,226,182,188,201,3,57,191,240,193,211,62,190,48,25,188,244,192,71,186,23,14,4,59,222,255,127,191,11,181,106,191,159,0,18,63,150,150,17,188,244,192,71,186,23,14,4,59,222,255,127,191,46,199,219,190,98,74,4,63,168,111,25,188,244,192,71,186,23,14,4,59,222,255,127,191,226,177,79,63,33,90,75,63,195,241,124,61,24,125,141,62,149,129,115,63,195,160,12,62,198,82,116,63,195,183,64,63,112,40,124,61,24,125,141,62,149,129,115,63,195,160,12,62,117,3,93,63,155,32,74,63,96,148,32,188,24,125,141,62,149,129,115,63,195,160,12,62,100,62,160,61,207,162,199,190,247,116,117,61,78,239,226,189,132,103,126,191,66,8,72,188,138,199,101,190,24,233,181,190,192,207,56,188,78,239,226,189,132,103,126,191,66,8,72,188,33,30,169,61,9,111,199,190,160,198,61,188,78,239,226,189,132,103,126,191,66,8,72,188,84,252,255,190,239,202,182,62,139,110,125,61,130,114,83,191,30,165,14,191,92,255,174,61,204,183,2,191,45,66,185,62,109,140,29,188,130,114,83,191,30,165,14,191,92,255,174,61,150,232,236,190,243,226,148,62,103,127,32,188,130,114,83,191,30,165,14,191,92,255,174,61,138,199,101,190,24,233,181,190,192,207,56,188,244,192,71,186,80,253,3,59,222,255,127,191,237,127,152,62,104,147,163,190,24,39,62,188,244,192,71,186,80,253,3,59,222,255,127,191,33,30,169,61,9,111,199,190,160,198,61,188,244,192,71,186,80,253,3,59,222,255,127,191,202,193,236,62,41,93,122,61,227,250,119,61,237,129,122,63,217,234,82,62,145,152,160,187,189,57,236,62,129,203,131,61,203,128,51,188,237,129,122,63,217,234,82,62,145,152,160,187,139,111,216,62,212,240,125,62,68,247,44,188,237,129,122,63,217,234,82,62,145,152,160,187,55,251,107,191,151,54,20,63,115,74,128,61,244,192,71,58,137,236,3,187,222,255,127,63,83,93,200,190,195,41,243,62,18,17,126,61,244,192,71,58,137,236,3,187,222,255,127,63,7,97,230,190,194,23,22,63,36,43,127,61,244,192,71,58,137,236,3,187,222,255,127,63,202,193,236,62,41,93,122,61,227,250,119,61,176,254,119,63,1,162,96,190,206,110,237,61,244,194,205,62,223,108,83,190,241,245,117,61,176,254,119,63,1,162,96,190,206,110,237,61,198,250,214,62,214,171,40,190,138,144,58,188,176,254,119,63,1,162,96,190,206,110,237,61,152,219,237,190,70,235,144,62,242,180,124,61,148,191,107,191,221,93,199,62,62,7,150,60,150,232,236,190,243,226,148,62,103,127,32,188,148,191,107,191,221,93,199,62,62,7,150,60,44,97,9,191,52,130,237,61,234,88,37,188,148,191,107,191,221,93,199,62,62,7,150,60,98,104,57,191,241,131,211,62,87,152,126,61,133,205,32,191,54,35,71,191,166,151,152,188,11,181,106,191,159,0,18,63,150,150,17,188,133,205,32,191,54,35,71,191,166,151,152,188,201,3,57,191,240,193,211,62,190,48,25,188,133,205,32,191,54,35,71,191,166,151,152,188,218,172,154,190,153,15,216,62,146,89,125,61,25,27,186,60,28,238,127,63,189,170,179,59,118,136,223,61,220,70,211,62,101,252,123,61,25,27,186,60,28,238,127,63,189,170,179,59,85,108,156,190,18,77,216,62,9,27,30,188,25,27,186,60,28,238,127,63,189,170,179,59,201,3,57,191,240,193,211,62,190,48,25,188,16,4,72,186,108,64,4,59,222,255,127,191,46,199,219,190,98,74,4,63,168,111,25,188,16,4,72,186,108,64,4,59,222,255,127,191,85,108,156,190,18,77,216,62,9,27,30,188,16,4,72,186,108,64,4,59,222,255,127,191,209,176,216,61,35,163,211,62,139,139,35,188,244,192,71,186,109,169,3,59,222,255,127,191,91,9,165,62,204,12,243,62,180,59,36,188,244,192,71,186,109,169,3,59,222,255,127,191,127,134,103,63,93,223,239,62,78,180,43,188,244,192,71,186,109,169,3,59,222,255,127,191,209,176,216,61,35,163,211,62,139,139,35,188,216,125,71,186,225,240,2,59,222,255,127,191,127,134,103,63,93,223,239,62,78,180,43,188,216,125,71,186,225,240,2,59,222,255,127,191,184,148,55,63,184,62,228,62,117,29,42,188,216,125,71,186,225,240,2,59,222,255,127,191,83,93,200,190,195,41,243,62,18,17,126,61,243,147,2,63,79,36,92,63,240,52,153,188,218,172,154,190,153,15,216,62,146,89,125,61,243,147,2,63,79,36,92,63,240,52,153,188,85,108,156,190,18,77,216,62,9,27,30,188,243,147,2,63,79,36,92,63,240,52,153,188,254,14,9,191,210,223,11,189,202,79,42,188,244,192,71,186,108,64,4,59,222,255,127,191,189,57,236,62,129,203,131,61,203,128,51,188,244,192,71,186,108,64,4,59,222,255,127,191,198,250,214,62,214,171,40,190,138,144,58,188,244,192,71,186,108,64,4,59,222,255,127,191,91,9,165,62,204,12,243,62,180,59,36,188,160,138,139,190,75,62,118,63,141,237,181,60,209,176,216,61,35,163,211,62,139,139,35,188,160,138,139,190,75,62,118,63,141,237,181,60,118,136,223,61,220,70,211,62,101,252,123,61,160,138,139,190,75,62,118,63,141,237,181,60,84,252,255,190,239,202,182,62,139,110,125,61,16,4,72,58,194,219,3,187,222,255,127,63,41,32,213,62,240,54,159,62,18,48,122,61,16,4,72,58,194,219,3,187,222,255,127,63,94,18,247,62,214,139,201,62,181,169,122,61,16,4,72,58,194,219,3,187,222,255,127,63,92,115,103,63,201,86,239,62,90,245,121,61,246,121,44,62,167,150,121,191,179,183,20,190,153,44,66,63,92,116,226,62,68,52,122,61,246,121,44,62,167,150,121,191,179,183,20,190,184,148,55,63,184,62,228,62,117,29,42,188,246,121,44,62,167,150,121,191,179,183,20,190,101,227,9,191,224,101,70,63,115,128,128,61,226,146,47,63,202,54,48,63,195,240,113,190,173,50,243,190,85,221,47,63,54,62,19,188,226,146,47,63,202,54,48,63,195,240,113,190,195,69,26,191,88,115,80,63,109,113,13,188,226,146,47,63,202,54,48,63,195,240,113,190,148,46,9,191,117,1,239,61,76,142,123,61,220,74,107,191,87,180,201,62,102,76,193,59,152,219,237,190,70,235,144,62,242,180,124,61,220,74,107,191,87,180,201,62,102,76,193,59])
.concat([44,97,9,191,52,130,237,61,234,88,37,188,220,74,107,191,87,180,201,62,102,76,193,59,184,148,55,63,184,62,228,62,117,29,42,188,244,192,71,186,23,14,4,59,222,255,127,191,178,160,12,63,30,224,217,62,142,176,40,188,244,192,71,186,23,14,4,59,222,255,127,191,209,176,216,61,35,163,211,62,139,139,35,188,244,192,71,186,23,14,4,59,222,255,127,191,198,82,116,63,195,183,64,63,112,40,124,61,117,1,95,63,99,95,250,62,47,109,56,61,116,39,132,63,83,207,30,63,178,71,40,188,117,1,95,63,99,95,250,62,47,109,56,61,70,182,119,63,28,94,60,63,231,168,35,188,117,1,95,63,99,95,250,62,47,109,56,61,206,57,112,191,48,212,61,63,181,252,128,61,16,4,72,58,222,30,4,187,222,255,127,63,7,97,230,190,194,23,22,63,36,43,127,61,16,4,72,58,222,30,4,187,222,255,127,63,101,227,9,191,224,101,70,63,115,128,128,61,16,4,72,58,222,30,4,187,222,255,127,63,147,143,9,191,152,51,219,188,78,96,122,61,163,230,127,191,192,231,7,188,173,133,217,188,44,97,9,191,52,130,237,61,234,88,37,188,163,230,127,191,192,231,7,188,173,133,217,188,254,14,9,191,210,223,11,189,202,79,42,188,163,230,127,191,192,231,7,188,173,133,217,188,55,251,107,191,151,54,20,63,115,74,128,61,241,70,126,191,46,60,207,189,235,199,102,189,206,57,112,191,48,212,61,63,181,252,128,61,241,70,126,191,46,60,207,189,235,199,102,189,106,162,111,191,248,53,66,63,214,29,11,188,241,70,126,191,46,60,207,189,235,199,102,189,147,143,9,191,152,51,219,188,78,96,122,61,16,4,72,58,23,14,4,187,222,255,127,63,244,194,205,62,223,108,83,190,241,245,117,61,16,4,72,58,23,14,4,187,222,255,127,63,202,193,236,62,41,93,122,61,227,250,119,61,16,4,72,58,23,14,4,187,222,255,127,63,219,190,99,191,124,153,80,63,231,54,129,61,16,4,72,58,52,186,3,187,222,255,127,63,101,227,9,191,224,101,70,63,115,128,128,61,16,4,72,58,52,186,3,187,222,255,127,63,114,221,72,191,2,188,89,63,47,50,129,61,16,4,72,58,52,186,3,187,222,255,127,63,153,40,114,190,67,58,180,190,81,192,118,61,232,78,0,191,117,57,93,191,186,77,56,189,185,226,226,190,70,238,105,190,143,225,49,188,232,78,0,191,117,57,93,191,186,77,56,189,138,199,101,190,24,233,181,190,192,207,56,188,232,78,0,191,117,57,93,191,186,77,56,189,150,232,236,190,243,226,148,62,103,127,32,188,244,192,71,186,222,30,4,59,222,255,127,191,204,183,2,191,45,66,185,62,109,140,29,188,244,192,71,186,222,30,4,59,222,255,127,191,209,148,221,62,45,153,179,62,104,176,41,188,244,192,71,186,222,30,4,59,222,255,127,191,84,252,255,190,239,202,182,62,139,110,125,61,16,4,72,58,138,85,3,187,222,255,127,63,94,18,247,62,214,139,201,62,181,169,122,61,16,4,72,58,138,85,3,187,222,255,127,63,98,104,57,191,241,131,211,62,87,152,126,61,16,4,72,58,138,85,3,187,222,255,127,63,248,140,0,63,14,102,47,63,138,2,125,61,244,192,71,58,23,14,4,187,222,255,127,63,183,13,133,63,225,127,19,63,252,110,122,61,244,192,71,58,23,14,4,187,222,255,127,63,198,82,116,63,195,183,64,63,112,40,124,61,244,192,71,58,23,14,4,187,222,255,127,63,101,227,9,191,224,101,70,63,115,128,128,61,132,17,95,63,18,80,209,62,46,231,138,62,7,97,230,190,194,23,22,63,36,43,127,61,132,17,95,63,18,80,209,62,46,231,138,62,173,50,243,190,85,221,47,63,54,62,19,188,132,17,95,63,18,80,209,62,46,231,138,62,206,57,112,191,48,212,61,63,181,252,128,61,16,4,72,58,137,236,3,187,222,255,127,63,101,227,9,191,224,101,70,63,115,128,128,61,16,4,72,58,137,236,3,187,222,255,127,63,219,190,99,191,124,153,80,63,231,54,129,61,16,4,72,58,137,236,3,187,222,255,127,63,153,40,114,190,67,58,180,190,81,192,118,61,244,192,71,58,194,219,3,187,222,255,127,63,100,62,160,61,207,162,199,190,247,116,117,61,244,192,71,58,194,219,3,187,222,255,127,63,239,59,142,62,133,151,168,190,130,85,117,61,244,192,71,58,194,219,3,187,222,255,127,63,152,219,237,190,70,235,144,62,242,180,124,61,213,92,102,191,55,111,220,190,116,98,143,189,84,252,255,190,239,202,182,62,139,110,125,61,213,92,102,191,55,111,220,190,116,98,143,189,150,232,236,190,243,226,148,62,103,127,32,188,213,92,102,191,55,111,220,190,116,98,143,189,148,46,9,191,117,1,239,61,76,142,123,61,244,192,71,58,165,47,4,187,222,255,127,63,202,193,236,62,41,93,122,61,227,250,119,61,244,192,71,58,165,47,4,187,222,255,127,63,152,219,237,190,70,235,144,62,242,180,124,61,244,192,71,58,165,47,4,187,222,255,127,63,248,140,0,63,14,102,47,63,138,2,125,61,19,43,7,191,97,136,88,63,51,194,155,61,94,129,32,63,58,88,67,63,141,67,125,61,19,43,7,191,97,136,88,63,51,194,155,61,172,2,5,63,246,211,51,63,170,43,31,188,19,43,7,191,97,136,88,63,51,194,155,61,201,3,57,191,240,193,211,62,190,48,25,188,16,4,72,186,226,89,2,59,222,255,127,191,85,108,156,190,18,77,216,62,9,27,30,188,16,4,72,186,226,89,2,59,222,255,127,191,209,176,216,61,35,163,211,62,139,139,35,188,16,4,72,186,226,89,2,59,222,255,127,191,153,44,66,63,92,116,226,62,68,52,122,61,62,91,135,188,93,196,127,191,27,16,33,189,67,231,33,63,31,133,227,62,31,157,122,61,62,91,135,188,93,196,127,191,27,16,33,189,184,148,55,63,184,62,228,62,117,29,42,188,62,91,135,188,93,196,127,191,27,16,33,189,41,32,213,62,240,54,159,62,18,48,122,61,44,239,122,63,102,247,196,189,149,42,49,62,139,111,216,62,212,240,125,62,68,247,44,188,44,239,122,63,102,247,196,189,149,42,49,62,209,148,221,62,45,153,179,62,104,176,41,188,44,239,122,63,102,247,196,189,149,42,49,62,92,115,103,63,201,86,239,62,90,245,121,61,78,179,16,63,208,42,83,191,13,52,31,188,127,134,103,63,93,223,239,62,78,180,43,188,78,179,16,63,208,42,83,191,13,52,31,188,21,200,130,63,232,132,12,63,31,130,42,188,78,179,16,63,208,42,83,191,13,52,31,188,209,176,216,61,35,163,211,62,139,139,35,188,16,4,72,58,21,60,5,187,222,255,127,63,178,160,12,63,30,224,217,62,142,176,40,188,16,4,72,58,21,60,5,187,222,255,127,63,201,3,57,191,240,193,211,62,190,48,25,188,16,4,72,58,21,60,5,187,222,255,127,63,91,9,165,62,204,12,243,62,180,59,36,188,205,90,146,190,196,66,117,63,35,44,170,188,118,136,223,61,220,70,211,62,101,252,123,61,205,90,146,190,196,66,117,63,35,44,170,188,68,196,165,62,203,15,244,62,178,215,123,61,205,90,146,190,196,66,117,63,35,44,170,188,226,177,79,63,33,90,75,63,195,241,124,61,114,55,72,189,167,91,126,63,141,211,208,189,117,3,93,63,155,32,74,63,96,148,32,188,114,55,72,189,167,91,126,63,141,211,208,189,70,97,47,63,181,226,71,63,64,161,30,188,114,55,72,189,167,91,126,63,141,211,208,189,183,13,133,63,225,127,19,63,252,110,122,61,176,174,30,63,223,164,69,191,221,209,15,62,92,115,103,63,201,86,239,62,90,245,121,61,176,174,30,63,223,164,69,191,221,209,15,62,21,200,130,63,232,132,12,63,31,130,42,188,176,174,30,63,223,164,69,191,221,209,15,62,201,3,57,191,240,193,211,62,190,48,25,188,16,4,72,186,222,30,4,59,222,255,127,191,178,160,12,63,30,224,217,62,142,176,40,188,16,4,72,186,222,30,4,59,222,255,127,191,209,148,221,62,45,153,179,62,104,176,41,188,16,4,72,186,222,30,4,59,222,255,127,191,198,82,116,63,195,183,64,63,112,40,124,61,94,156,232,62,168,200,97,63,244,106,0,190,70,182,119,63,28,94,60,63,231,168,35,188,94,156,232,62,168,200,97,63,244,106,0,190,117,3,93,63,155,32,74,63,96,148,32,188,94,156,232,62,168,200,97,63,244,106,0,190,204,183,2,191,45,66,185,62,109,140,29,188,244,192,71,186,108,64,4,59,222,255,127,191,201,3,57,191,240,193,211,62,190,48,25,188,244,192,71,186,108,64,4,59,222,255,127,191,209,148,221,62,45,153,179,62,104,176,41,188,244,192,71,186,108,64,4,59,222,255,127,191,169,221,135,190,183,238,174,62,190,76,148,61,210,224,206,190,98,188,94,63,226,145,144,190,2,74,115,190,57,14,180,62,49,10,130,61,210,224,206,190,98,188,94,63,226,145,144,190,168,0,144,190,168,30,169,62,209,116,118,61,210,224,206,190,98,188,94,63,226,145,144,190,129,119,18,190,231,83,167,62,17,86,163,61,1,25,50,63,119,188,17,63,30,78,224,190,178,158,154,189,150,5,115,62,32,213,144,61,1,25,50,63,119,188,17,63,30,78,224,190,81,132,36,190,14,189,173,62,105,85,139,61,1,25,50,63,119,188,17,63,30,78,224,190,81,132,36,190,14,189,173,62,105,85,139,61,169,49,129,61,240,49,216,60,149,102,127,191,15,38,165,190,74,97,134,62,190,103,100,61,169,49,129,61,240,49,216,60,149,102,127,191,168,0,144,190,168,30,169,62,209,116,118,61,169,49,129,61,240,49,216,60,149,102,127,191,169,221,135,190,183,238,174,62,190,76,148,61,199,45,54,191,108,234,24,63,159,90,189,62,168,0,144,190,168,30,169,62,209,116,118,61,199,45,54,191,108,234,24,63,159,90,189,62,70,63,162,190,138,6,145,62,29,119,138,61,199,45,54,191,108,234,24,63,159,90,189,62,70,63,162,190,138,6,145,62,29,119,138,61,23,73,59,191,202,50,244,62,39,106,249,190,168,0,144,190,168,30,169,62,209,116,118,61,23,73,59,191,202,50,244,62,39,106,249,190,15,38,165,190,74,97,134,62,190,103,100,61,23,73,59,191,202,50,244,62,39,106,249,190,76,227,119,190,167,179,19,61,160,193,134,61,241,44,129,189,52,77,216,188,165,102,127,63,5,22,128,189,145,212,226,61,208,12,162,61,241,44,129,189,52,77,216,188,165,102,127,63,194,248,137,189,201,146,89,62,74,240,166,61,241,44,129,189,52,77,216,188,165,102,127,63,225,151,122,189,191,209,206,61,127,76,139,61,229,43,129,61,176,87,216,60,165,102,127,191,250,123,73,190,74,151,126,60,185,56,106,61,229,43,129,61,176,87,216,60,165,102,127,191,143,51,125,190,147,111,54,61,237,73,96,61,229,43,129,61,176,87,216,60,165,102,127,191,5,22,128,189,145,212,226,61,208,12,162,61,68,222,126,63,7,152,57,61,179,125,168,61,225,151,122,189,191,209,206,61,127,76,139,61,68,222,126,63,7,152,57,61,179,125,168,61,194,248,137,189,201,146,89,62,74,240,166,61,68,222,126,63,7,152,57,61,179,125,168,61,178,158,154,189,150,5,115,62,32,213,144,61,22,48,129,61,208,68,216,60,149,102,127,191,225,151,122,189,191,209,206,61,127,76,139,61,22,48,129,61,208,68,216,60,149,102,127,191,95,209,157,190,99,38,1,62,126,86,89,61,22,48,129,61,208,68,216,60,149,102,127,191,70,63,162,190,138,6,145,62,29,119,138,61,253,45,129,189,158,64,216,188,165,102,127,63,129,119,18,190,231,83,167,62,17,86,163,61,253,45,129,189,158,64,216,188,165,102,127,63,190,77,95,190,229,179,180,62,32,9,155,61,253,45,129,189,158,64,216,188,165,102,127,63,76,227,119,190,167,179,19,61,160,193,134,61,10,47,129,189,208,68,216,188,149,102,127,63,82,13,43,190,155,202,34,60,145,14,143,61,10,47,129,189,208,68,216,188,149,102,127,63,204,36,170,189,170,129,102,61,202,112,156,61,10,47,129,189,208,68,216,188,149,102,127,63,70,63,162,190,138,6,145,62,29,119,138,61,165,220,101,191,232,188,198,187,200,92,225,62,15,38,165,190,74,97,134,62,190,103,100,61,165,220,101,191,232,188,198,187,200,92,225,62,20,175,162,190,92,0,26,62,103,39,131,61,165,220,101,191,232,188,198,187,200,92,225,62,20,175,162,190,92,0,26,62,103,39,131,61,146,202,84,191,236,104,156,189,93,249,12,191,15,38,165,190,74,97,134,62,190,103,100,61,146,202,84,191,236,104,156,189,93,249,12,191,95,209,157,190,99,38,1,62,126,86,89,61,146,202,84,191,236,104,156,189,93,249,12,191,70,63,162,190,138,6,145,62,29,119,138,61,119,45,129,189,27,75,216,188,165,102,127,63,20,175,162,190,92,0,26,62,103,39,131,61,119,45,129,189,27,75,216,188,165,102,127,63,129,119,18,190,231,83,167,62,17,86,163,61,119,45,129,189,27,75,216,188,165,102,127,63,194,248,137,189,201,146,89,62,74,240,166,61,210,195,100,63,195,240,209,61,115,187,223,190,225,151,122,189,191,209,206,61,127,76,139,61,210,195,100,63,195,240,209,61,115,187,223,190,178,158,154,189,150,5,115,62,32,213,144,61,210,195,100,63,195,240,209,61,115,187,223,190,178,158,154,189,150,5,115,62,32,213,144,61,22,48,129,61,208,68,216,60,149,102,127,191,95,209,157,190,99,38,1,62,126,86,89,61,22,48,129,61,208,68,216,60,149,102,127,191,15,38,165,190,74,97,134,62,190,103,100,61,22,48,129,61,208,68,216,60,149,102,127,191,169,221,135,190,183,238,174,62,190,76,148,61,109,55,129,189,49,12,216,188,149,102,127,63,70,63,162,190,138,6,145,62,29,119,138,61,109,55,129,189,49,12,216,188,149,102,127,63,190,77,95,190,229,179,180,62,32,9,155,61,109,55,129,189,49,12,216,188,149,102,127,63,118,223,209,189,170,186,7,61,124,70,130,61,156,48,129,61,109,60,216,60,149,102,127,191,210,167,21,190,32,240,64,60,91,236,118,61,156,48,129,61,109,60,216,60,149,102,127,191,250,123,73,190,74,151,126,60,185,56,106,61,156,48,129,61,109,60,216,60,149,102,127,191,20,175,162,190,92,0,26,62,103,39,131,61,169,49,129,189,84,58,216,188,149,102,127,63,76,227,119,190,167,179,19,61,160,193,134,61,169,49,129,189,84,58,216,188,149,102,127,63,194,248,137,189,201,146,89,62,74,240,166,61,169,49,129,189,84,58,216,188,149,102,127,63,20,175,162,190,92,0,26,62,103,39,131,61,219,247,64,191,232,249,251,190,99,242,222,62,95,209,157,190,99,38,1,62,126,86,89,61,219,247,64,191,232,249,251,190,99,242,222,62,76,227,119,190,167,179,19,61,160,193,134,61,219,247,64,191,232,249,251,190,99,242,222,62,76,227,119,190,167,179,19,61,160,193,134,61,92,29,76,191,172,254,24,191,50,170,172,189,95,209,157,190,99,38,1,62,126,86,89,61,92,29,76,191,172,254,24,191,50,170,172,189,143,51,125,190,147,111,54,61,237,73,96,61,92,29,76,191,172,254,24,191,50,170,172,189,20,175,162,190,92,0,26,62,103,39,131,61,169,49,129,189,84,58,216,188,149,102,127,63,194,248,137,189,201,146,89,62,74,240,166,61,169,49,129,189,84,58,216,188,149,102,127,63,129,119,18,190,231,83,167,62,17,86,163,61,169,49,129,189,84,58,216,188,149,102,127,63,190,77,95,190,229,179,180,62,32,9,155,61,244,110,44,62,120,125,106,63,117,118,186,190,81,132,36,190,14,189,173,62,105,85,139,61,244,110,44,62,120,125,106,63,117,118,186,190,2,74,115,190,57,14,180,62,49,10,130,61,244,110,44,62,120,125,106,63,117,118,186,190,81,132,36,190,14,189,173,62,105,85,139,61,22,48,129,61,133,62,216,60,149,102,127,191,178,158,154,189,150,5,115,62,32,213,144,61,22,48,129,61,133,62,216,60,149,102,127,191,15,38,165,190,74,97,134,62,190,103,100,61,22,48,129,61,133,62,216,60,149,102,127,191,76,227,119,190,167,179,19,61,160,193,134,61,17,53,225,190,86,212,76,191,183,209,208,190,143,51,125,190,147,111,54,61,237,73,96,61,17,53,225,190,86,212,76,191,183,209,208,190,250,123,73,190,74,151,126,60,185,56,106,61,17,53,225,190,86,212,76,191,183,209,208,190,225,151,122,189,191,209,206,61,127,76,139,61,156,48,129,61,59,56,216,60,149,102,127,191,118,223,209,189,170,186,7,61,124,70,130,61,156,48,129,61,59,56,216,60,149,102,127,191,250,123,73,190,74,151,126,60,185,56,106,61,156,48,129,61,59,56,216,60,149,102,127,191,225,151,122,189,191,209,206,61,127,76,139,61,144,47,129,61,141,41,216,60,165,102,127,191,143,51,125,190,147,111,54,61,237,73,96,61,144,47,129,61,141,41,216,60,165,102,127,191,95,209,157,190,99,38,1,62,126,86,89,61,144,47,129,61,141,41,216,60,165,102,127,191,76,227,119,190,167,179,19,61,160,193,134,61,28,93,165,190,151,172,94,191,90,244,190,62,250,123,73,190,74,151,126,60,185,56,106,61,28,93,165,190,151,172,94,191,90,244,190,62,82,13,43,190,155,202,34,60,145,14,143,61,28,93,165,190,151,172,94,191,90,244,190,62,82,13,43,190,155,202,34,60,145,14,143,61,82,98,87,189,189,251,115,191,235,170,152,190,250,123,73,190,74,151,126,60,185,56,106,61,82,98,87,189,189,251,115,191,235,170,152,190,210,167,21,190,32,240,64,60,91,236,118,61,82,98,87,189,189,251,115,191,235,170,152,190,76,227,119,190,167,179,19,61,160,193,134,61,22,48,129,189,215,47,216,188,165,102,127,63,204,36,170,189,170,129,102,61,202,112,156,61,22,48,129,189,215,47,216,188,165,102,127,63,5,22,128,189,145,212,226,61,208,12,162,61,22,48,129,189,215,47,216,188,165,102,127,63,168,0,144,190,168,30,169,62,209,116,118,61,156,48,129,61,94,102,216,60,149,102,127,191,2,74,115,190,57,14,180,62,49,10,130,61,156,48,129,61,94,102,216,60,149,102,127,191,81,132,36,190,14,189,173,62,105,85,139,61,156,48,129,61,94,102,216,60,149,102,127,191,82,13,43,190,155,202,34,60,145,14,143,61,110,139,82,62,81,244,112,191,51,53,137,62,210,167,21,190,32,240,64,60,91,236,118,61,110,139,82,62,81,244,112,191,51,53,137,62,150,65,245,189,209,175,173,60,109,202,149,61,110,139,82,62,81,244,112,191,51,53,137,62,150,65,245,189,209,175,173,60,109,202,149,61,125,234,224,62,123,244,90,191,201,174,140,190,210,167,21,190,32,240,64,60,91,236,118,61,125,234,224,62,123,244,90,191,201,174,140,190,118,223,209,189,170,186,7,61,124,70,130,61,125,234,224,62,123,244,90,191,201,174,140,190,82,13,43,190,155,202,34,60,145,14,143,61,244,55,129,189,230,5,216,188,149,102,127,63,150,65,245,189,209,175,173,60,109,202,149,61,244,55,129,189,230,5,216,188,149,102,127,63,204,36,170,189,170,129,102,61,202,112,156,61,244,55,129,189,230,5,216,188,149,102,127,63,194,248,137,189,201,146,89,62,74,240,166,61,93,249,48,63,83,149,238,62,225,94,13,63,178,158,154,189,150,5,115,62,32,213,144,61,93,249,48,63,83,149,238,62,225,94,13,63,129,119,18,190,231,83,167,62,17,86,163,61,93,249,48,63,83,149,238,62,225,94,13,63,150,65,245,189,209,175,173,60,109,202,149,61,224,187,37,63,55,57,52,191,128,128,149,62,118,223,209,189,170,186,7,61,124,70,130,61,224,187,37,63,55,57,52,191,128,128,149,62,204,36,170,189,170,129,102,61,202,112,156,61,224,187,37,63,55,57,52,191,128,128,149,62,204,36,170,189,170,129,102,61,202,112,156,61,181,50,77,63,63,58,237,190,233,127,193,190,118,223,209,189,170,186,7,61,124,70,130,61,181,50,77,63,63,58,237,190,233,127,193,190,225,151,122,189,191,209,206,61,127,76,139,61,181,50,77,63,63,58,237,190,233,127,193,190,129,119,18,190,231,83,167,62,17,86,163,61,230,88,134,62,145,125,84,63,228,246,251,62,81,132,36,190,14,189,173,62,105,85,139,61,230,88,134,62,145,125,84,63,228,246,251,62,190,77,95,190,229,179,180,62,32,9,155,61,230,88,134,62,145,125,84,63,228,246,251,62,2,74,115,190,57,14,180,62,49,10,130,61,33,172,118,190,229,43,109,63,68,23,148,62,169,221,135,190,183,238,174,62,190,76,148,61,33,172,118,190,229,43,109,63,68,23,148,62,190,77,95,190,229,179,180,62,32,9,155,61,33,172,118,190,229,43,109,63,68,23,148,62,204,36,170,189,170,129,102,61,202,112,156,61,72,106,89,63,123,74,174,190,15,157,206,62,225,151,122,189,191,209,206,61,127,76,139,61,72,106,89,63,123,74,174,190,15,157,206,62,5,22,128,189,145,212,226,61,208,12,162,61,72,106,89,63,123,74,174,190,15,157,206,62,88,87,197,189,78,43,229,189,218,3,173,58,199,218,127,191,23,17,69,188,94,245,0,61,138,232,183,189,248,252,0,191,248,221,116,61,199,218,127,191,23,17,69,188,94,245,0,61,195,155,181,189,52,20,255,190,215,222,199,61,199,218,127,191,23,17,69,188,94,245,0,61,88,87,197,189,78,43,229,189,218,3,173,58,182,218,127,191,236,247,68,188,149,15,1,61,195,155,181,189,52,20,255,190,215,222,199,61,182,218,127,191,236,247,68,188,149,15,1,61,11,10,195,189,91,148,217,189,212,71,32,61,182,218,127,191,236,247,68,188,149,15,1,61,11,10,195,189,91,148,217,189,212,71,32,61,47,133,135,188,65,42,125,63,146,6,23,190,234,3,73,188,30,137,215,189,218,146,21,61,47,133,135,188,65,42,125,63,146,6,23,190,80,110,91,188,138,31,227,189,253,188,169,186,47,133,135,188,65,42,125,63,146,6,23,190,80,110,91,188,138,31,227,189,253,188,169,186,140,162,135,188,237,41,125,63,44,14,23,190,88,87,197,189,78,43,229,189,218,3,173,58,140,162,135,188,237,41,125,63,44,14,23,190,11,10,195,189,91,148,217,189,212,71,32,61,140,162,135,188,237,41,125,63,44,14,23,190,234,3,73,188,30,137,215,189,218,146,21,61,182,218,127,63,236,247,68,60,149,15,1,189,87,35,187,187,100,145,254,190,211,131,194,61,182,218,127,63,236,247,68,60,149,15,1,189,35,248,223,187,128,187,0,191,242,39,106,61,182,218,127,63,236,247,68,60,149,15,1,189,234,3,73,188,30,137,215,189,218,146,21,61,182,218,127,63,236,247,68,60,136,14,1,189,35,248,223,187,128,187,0,191,242,39,106,61,182,218,127,63,236,247,68,60,136,14,1,189,80,110,91,188,138,31,227,189,253,188,169,186,182,218,127,63,236,247,68,60,136,14,1,189,138,232,183,189,248,252,0,191,248,221,116,61,140,162,135,60,48,42,125,191,158,7,23,62,35,248,223,187,128,187,0,191,242,39,106,61,140,162,135,60,48,42,125,191,158,7,23,62,87,35,187,187,100,145,254,190,211,131,194,61,140,162,135,60,48,42,125,191,158,7,23,62,138,232,183,189,248,252,0,191,248,221,116,61,122,139,135,60,237,41,125,191,111,14,23,62,87,35,187,187,100,145,254,190,211,131,194,61,122,139,135,60,237,41,125,191,111,14,23,62,195,155,181,189,52,20,255,190,215,222,199,61,122,139,135,60,237,41,125,191,111,14,23,62,138,232,183,189,248,252,0,191,248,221,116,61,9,168,240,188,15,125,23,190,69,18,125,191,88,87,197,189,78,43,229,189,218,3,173,58,9,168,240,188,15,125,23,190,69,18,125,191,80,110,91,188,138,31,227,189,253,188,169,186,9,168,240,188,15,125,23,190,69,18,125,191,138,232,183,189,248,252,0,191,248,221,116,61,34,170,240,188,15,125,23,190,69,18,125,191,80,110,91,188,138,31,227,189,253,188,169,186,34,170,240,188,15,125,23,190,69,18,125,191,35,248,223,187,128,187,0,191,242,39,106,61,34,170,240,188,15,125,23,190,69,18,125,191,87,35,187,187,100,145,254,190,211,131,194,61,16,147,240,60,70,124,23,62,85,18,125,63,234,3,73,188,30,137,215,189,218,146,21,61,16,147,240,60,70,124,23,62,85,18,125,63,11,10,195,189,91,148,217,189,212,71,32,61,16,147,240,60,70,124,23,62,85,18,125,63,87,35,187,187,100,145,254,190,211,131,194,61,59,172,240,60,15,125,23,62,69,18,125,63,11,10,195,189,91,148,217,189,212,71,32,61,59,172,240,60,15,125,23,62,69,18,125,63,195,155,181,189,52,20,255,190,215,222,199,61,59,172,240,60,15,125,23,62,69,18,125,63,124,67,161,61,46,31,185,62,84,254,149,61,104,118,109,190,173,80,112,63,231,138,130,190,252,167,219,61,161,49,187,62,234,207,126,61,104,118,109,190,173,80,112,63,231,138,130,190,203,134,117,61,71,56,181,62,80,25,127,61,104,118,109,190,173,80,112,63,231,138,130,190,77,131,2,62,193,167,185,62,177,78,149,61,105,200,168,62,250,69,93,63,0,114,194,190,173,76,56,62,179,183,172,62,142,206,121,61,105,200,168,62,250,69,93,63,0,114,194,190,252,167,219,61,161,49,187,62,234,207,126,61,105,200,168,62,250,69,93,63,0,114,194,190,110,138,119,62,119,247,96,62,65,74,108,61,249,215,242,187,213,205,197,60,24,235,127,191,244,55,33,188,125,235,35,62,242,8,110,61,249,215,242,187,213,205,197,60,24,235,127,191,175,151,166,59,2,186,151,62,107,15,123,61,249,215,242,187,213,205,197,60,24,235,127,191,124,67,161,61,46,31,185,62,84,254,149,61,33,87,10,191,34,168,58,63,96,2,215,62,203,134,117,61,71,56,181,62,80,25,127,61,33,87,10,191,34,168,58,63,96,2,215,62,106,249,129,60,63,116,161,62,139,169,148,61,33,87,10,191,34,168,58,63,96,2,215,62,106,249,129,60,63,116,161,62,139,169,148,61,161,46,38,191,44,40,32,63,127,136,221,190,203,134,117,61,71,56,181,62,80,25,127,61,161,46,38,191,44,40,32,63,127,136,221,190,175,151,166,59,2,186,151,62,107,15,123,61,161,46,38,191,44,40,32,63,127,136,221,190,252,23,72,62,15,124,164,62,42,58,146,61,4,228,67,63,82,186,212,62,83,202,251,190,110,138,119,62,119,247,96,62,65,74,108,61,4,228,67,63,82,186,212,62,83,202,251,190,173,76,56,62,179,183,172,62,142,206,121,61,4,228,67,63,82,186,212,62,83,202,251,190,252,167,219,61,161,49,187,62,234,207,126,61,169,250,149,188,106,247,115,63,195,216,154,62,124,67,161,61,46,31,185,62,84,254,149,61,169,250,149,188,106,247,115,63,195,216,154,62,77,131,2,62,193,167,185,62,177,78,149,61,169,250,149,188,106,247,115,63,195,216,154,62,224,218,105,62,72,194,190,61,105,113,134,61,205,115,124,63,169,192,41,190,193,110,216,59,49,66,104,62,211,220,170,61,187,66,95,61,205,115,124,63,169,192,41,190,193,110,216,59,50,32,123,62,244,54,70,62,204,39,139,61,205,115,124,63,169,192,41,190,193,110,216,59,50,32,123,62,244,54,70,62,204,39,139,61,228,44,92,63,65,213,168,189,151,228,0,191,49,66,104,62,211,220,170,61,187,66,95,61,228,44,92,63,65,213,168,189,151,228,0,191,110,138,119,62,119,247,96,62,65,74,108,61,228,44,92,63,65,213,168,189,151,228,0,191,110,138,119,62,119,247,96,62,65,74,108,61,93,224,242,187,57,214,197,60,24,235,127,191,49,66,104,62,211,220,170,61,187,66,95,61,93,224,242,187,57,214,197,60,24,235,127,191,244,55,33,188,125,235,35,62,242,8,110,61,93,224,242,187,57,214,197,60,24,235,127,191,106,249,129,60,63,116,161,62,139,169,148,61,192,232,242,59,213,205,197,188,24,235,127,63,187,236,87,188,150,33,62,62,50,176,142,61,192,232,242,59,213,205,197,188,24,235,127,63,252,23,72,62,15,124,164,62,42,58,146,61,192,232,242,59,213,205,197,188,24,235,127,63,106,249,129,60,63,116,161,62,139,169,148,61,160,250,87,191,216,216,53,62,108,179,1,63,175,151,166,59,2,186,151,62,107,15,123,61,160,250,87,191,216,216,53,62,108,179,1,63,187,236,87,188,150,33,62,62,50,176,142,61,160,250,87,191,216,216,53,62,108,179,1,63,187,236,87,188,150,33,62,62,50,176,142,61,254,13,94,191,104,203,217,61,239,227,248,190,175,151,166,59,2,186,151,62,107,15,123,61,254,13,94,191,104,203,217,61,239,227,248,190,244,55,33,188,125,235,35,62,242,8,110,61,254,13,94,191,104,203,217,61,239,227,248,190,106,249,129,60,63,116,161,62,139,169,148,61,192,232,242,59,198,247,197,188,7,235,127,63,252,23,72,62,15,124,164,62,42,58,146,61,192,232,242,59,198,247,197,188,7,235,127,63,77,131,2,62,193,167,185,62,177,78,149,61,192,232,242,59,198,247,197,188,7,235,127,63,50,32,123,62,244,54,70,62,204,39,139,61,40,41,80,63,27,157,155,62,186,44,254,62,110,138,119,62,119,247,96,62,65,74,108,61,40,41,80,63,27,157,155,62,186,44,254,62,252,23,72,62,15,124,164,62,42,58,146,61,40,41,80,63,27,157,155,62,186,44,254,62,187,236,87,188,150,33,62,62,50,176,142,61,249,215,242,59,156,222,197,188,24,235,127,63,167,37,22,61,161,128,109,61,78,157,135,61,249,215,242,59,156,222,197,188,24,235,127,63,50,32,123,62,244,54,70,62,204,39,139,61,249,215,242,59,156,222,197,188,24,235,127,63,49,66,104,62,211,220,170,61,187,66,95,61,249,215,242,187,213,205,197,60,24,235,127,191,78,99,155,61,7,125,233,60,173,105,94,61,249,215,242,187,213,205,197,60,24,235,127,191,150,92,5,61,75,58,138,61,251,148,99,61,249,215,242,187,213,205,197,60,24,235,127,191,49,66,104,62,211,220,170,61,187,66,95,61,93,224,242,187,81,216,197,60,24,235,127,191,150,92,5,61,75,58,138,61,251,148,99,61,93,224,242,187,81,216,197,60,24,235,127,191,244,55,33,188,125,235,35,62,242,8,110,61,93,224,242,187,81,216,197,60,24,235,127,191,124,67,161,61,46,31,185,62,84,254,149,61,137,98,242,59,228,163,197,188,41,235,127,63,106,249,129,60,63,116,161,62,139,169,148,61,137,98,242,59,228,163,197,188,41,235,127,63,77,131,2,62,193,167,185,62,177,78,149,61,137,98,242,59,228,163,197,188,41,235,127,63,187,236,87,188,150,33,62,62,50,176,142,61,132,72,78,191,64,218,167,190,44,129,252,62,244,55,33,188,125,235,35,62,242,8,110,61,132,72,78,191,64,218,167,190,44,129,252,62,167,37,22,61,161,128,109,61,78,157,135,61,132,72,78,191,64,218,167,190,44,129,252,62,167,37,22,61,161,128,109,61,78,157,135,61,64,194,104,191,63,225,212,190,35,16,175,188,244,55,33,188,125,235,35,62,242,8,110,61,64,194,104,191,63,225,212,190,35,16,175,188,150,92,5,61,75,58,138,61,251,148,99,61,64,194,104,191,63,225,212,190,35,16,175,188,252,23,72,62,15,124,164,62,42,58,146,61,44,41,239,62,179,40,64,63,221,66,239,62,173,76,56,62,179,183,172,62,142,206,121,61,44,41,239,62,179,40,64,63,221,66,239,62,77,131,2,62,193,167,185,62,177,78,149,61,44,41,239,62,179,40,64,63,221,66,239,62,173,76,56,62,179,183,172,62,142,206,121,61,93,224,242,187,213,205,197,60,24,235,127,191,110,138,119,62,119,247,96,62,65,74,108,61,93,224,242,187,213,205,197,60,24,235,127,191,175,151,166,59,2,186,151,62,107,15,123,61,93,224,242,187,213,205,197,60,24,235,127,191,49,66,104,62,211,220,170,61,187,66,95,61,192,232,242,187,57,214,197,60,24,235,127,191,127,21,48,62,243,142,211,60,226,57,91,61,192,232,242,187,57,214,197,60,24,235,127,191,78,99,155,61,7,125,233,60,173,105,94,61,192,232,242,187,57,214,197,60,24,235,127,191,167,37,22,61,161,128,109,61,78,157,135,61,131,163,32,191,107,96,47,191,50,119,189,190,150,92,5,61,75,58,138,61,251,148,99,61,131,163,32,191,107,96,47,191,50,119,189,190,78,99,155,61,7,125,233,60,173,105,94,61,131,163,32,191,107,96,47,191,50,119,189,190,167,37,22,61,161,128,109,61,78,157,135,61,150,207,242,59,238,207,197,188,24,235,127,63,94,105,73,62,70,37,53,61,233,128,132,61,150,207,242,59,238,207,197,188,24,235,127,63,224,218,105,62,72,194,190,61,105,113,134,61,150,207,242,59,238,207,197,188,24,235,127,63,167,37,22,61,161,128,109,61,78,157,135,61,249,215,242,59,163,201,197,188,24,235,127,63,50,60,214,61,32,70,136,60,76,137,132,61,249,215,242,59,163,201,197,188,24,235,127,63,94,105,73,62,70,37,53,61,233,128,132,61,249,215,242,59,163,201,197,188,24,235,127,63,167,37,22,61,161,128,109,61,78,157,135,61,153,158,240,190,127,109,73,191,124,211,204,62,78,99,155,61,7,125,233,60,173,105,94,61,153,158,240,190,127,109,73,191,124,211,204,62,50,60,214,61,32,70,136,60,76,137,132,61,153,158,240,190,127,109,73,191,124,211,204,62,50,60,214,61,32,70,136,60,76,137,132,61,116,70,140,190,167,207,106,191,69,15,148,190,78,99,155,61,7,125,233,60,173,105,94,61,116,70,140,190,167,207,106,191,69,15,148,190,103,70,255,61,145,238,103,60,73,131,91,61,116,70,140,190,167,207,106,191,69,15,148,190,187,236,87,188,150,33,62,62,50,176,142,61,249,215,242,59,163,201,197,188,24,235,127,63,50,32,123,62,244,54,70,62,204,39,139,61,249,215,242,59,163,201,197,188,24,235,127,63,252,23,72,62,15,124,164,62,42,58,146,61,249,215,242,59,163,201,197,188,24,235,127,63,203,134,117,61,71,56,181,62,80,25,127,61,21,27,243,187,171,180,197,60,24,235,127,191,252,167,219,61,161,49,187,62,234,207,126,61,21,27,243,187,171,180,197,60,24,235,127,191,173,76,56,62,179,183,172,62,142,206,121,61,21,27,243,187,171,180,197,60,24,235,127,191,50,60,214,61,32,70,136,60,76,137,132,61,48,214,183,60,148,106,119,191,177,247,130,62,103,70,255,61,145,238,103,60,73,131,91,61,48,214,183,60,148,106,119,191,177,247,130,62,168,255,28,62,91,207,144,60,35,217,131,61,48,214,183,60,148,106,119,191,177,247,130,62,168,255,28,62,91,207,144,60,35,217,131,61,235,57,105,62,236,220,108,191,239,85,155,190,103,70,255,61,145,238,103,60,73,131,91,61,235,57,105,62,236,220,108,191,239,85,155,190,127,21,48,62,243,142,211,60,226,57,91,61,235,57,105,62,236,220,108,191,239,85,155,190,173,76,56,62,179,183,172,62,142,206,121,61,135,249,242,187,99,239,197,60,24,235,127,191,175,151,166,59,2,186,151,62,107,15,123,61,135,249,242,187,99,239,197,60,24,235,127,191,203,134,117,61,71,56,181,62,80,25,127,61,135,249,242,187,99,239,197,60,24,235,127,191,50,60,214,61,32,70,136,60,76,137,132,61,50,199,242,59,245,186,197,188,24,235,127,63,168,255,28,62,91,207,144,60,35,217,131,61,50,199,242,59,245,186,197,188,24,235,127,63,94,105,73,62,70,37,53,61,233,128,132,61,50,199,242,59,245,186,197,188,24,235,127,63,168,255,28,62,91,207,144,60,35,217,131,61,34,57,1,63,210,223,83,191,102,74,123,62,127,21,48,62,243,142,211,60,226,57,91,61,34,57,1,63,210,223,83,191,102,74,123,62,94,105,73,62,70,37,53,61,233,128,132,61,34,57,1,63,210,223,83,191,102,74,123,62,94,105,73,62,70,37,53,61,233,128,132,61,73,216,39,63,179,240,29,191,156,225,222,190,127,21,48,62,243,142,211,60,226,57,91,61,73,216,39,63,179,240,29,191,156,225,222,190,49,66,104,62,211,220,170,61,187,66,95,61,73,216,39,63,179,240,29,191,156,225,222,190,167,37,22,61,161,128,109,61,78,157,135,61,93,224,242,59,156,222,197,188,24,235,127,63,224,218,105,62,72,194,190,61,105,113,134,61,93,224,242,59,156,222,197,188,24,235,127,63,50,32,123,62,244,54,70,62,204,39,139,61,93,224,242,59,156,222,197,188,24,235,127,63,127,21,48,62,243,142,211,60,226,57,91,61,36,241,242,187,78,151,197,60,41,235,127,191,103,70,255,61,145,238,103,60,73,131,91,61,36,241,242,187,78,151,197,60,41,235,127,191,78,99,155,61,7,125,233,60,173,105,94,61,36,241,242,187,78,151,197,60,41,235,127,191,94,105,73,62,70,37,53,61,233,128,132,61,93,78,73,63,69,15,4,191,20,9,174,62,49,66,104,62,211,220,170,61,187,66,95,61,93,78,73,63,69,15,4,191,20,9,174,62,224,218,105,62,72,194,190,61,105,113,134,61,93,78,73,63,69,15,4,191,20,9,174,62,12,230,47,186,156,82,222,189,194,219,3,187,182,218,127,191,129,4,69,188,161,16,1,61,32,240,192,59,226,33,0,191,29,56,103,61,182,218,127,191,129,4,69,188,161,16,1,61,235,196,229,59,7,94,253,190,233,11,193,61,182,218,127,191,129,4,69,188,161,16,1,61,12,230,47,186,156,82,222,189,194,219,3,187,182,218,127,191,129,4,69,188,149,15,1,61,235,196,229,59,7,94,253,190,233,11,193,61,182,218,127,191,129,4,69,188,149,15,1,61,161,128,237,57,170,187,210,189,5,163,18,61,182,218,127,191,129,4,69,188,149,15,1,61,161,128,237,57,170,187,210,189,5,163,18,61,97,137,135,188,65,42,125,63,146,6,23,190,14,215,170,61,108,176,208,189,255,236,7,61,97,137,135,188,65,42,125,63,146,6,23,190,194,137,168,61,216,70,220,189,23,158,151,187,97,137,135,188,65,42,125,63,146,6,23,190,194,137,168,61,216,70,220,189,23,158,151,187,140,162,135,188,254,41,125,63,32,13,23,190,12,230,47,186,156,82,222,189,194,219,3,187,140,162,135,188,254,41,125,63,32,13,23,190,161,128,237,57,170,187,210,189,5,163,18,61,140,162,135,188,254,41,125,63,32,13,23,190,14,215,170,61,108,176,208,189,255,236,7,61,182,218,127,63,236,247,68,60,149,15,1,189,86,69,184,61,56,219,252,190,230,176,187,61,182,218,127,63,236,247,68,60,149,15,1,189,10,248,181,61,244,192,255,190,23,130,92,61,182,218,127,63,236,247,68,60,149,15,1,189,14,215,170,61,108,176,208,189,255,236,7,61,182,218,127,63,236,247,68,60,136,14,1,189,10,248,181,61,244,192,255,190,23,130,92,61,182,218,127,63,236,247,68,60,136,14,1,189,194,137,168,61,216,70,220,189,23,158,151,187,182,218,127,63,236,247,68,60,136,14,1,189,32,240,192,59,226,33,0,191,29,56,103,61,122,139,135,60,237,41,125,191,44,14,23,62,10,248,181,61,244,192,255,190,23,130,92,61,122,139,135,60,237,41,125,191,44,14,23,62,86,69,184,61,56,219,252,190,230,176,187,61,122,139,135,60,237,41,125,191,44,14,23,62,32,240,192,59,226,33,0,191,29,56,103,61,122,139,135,60,237,41,125,191,111,14,23,62,86,69,184,61,56,219,252,190,230,176,187,61,122,139,135,60,237,41,125,191,111,14,23,62,235,196,229,59,7,94,253,190,233,11,193,61,122,139,135,60,237,41,125,191,111,14,23,62,32,240,192,59,226,33,0,191,29,56,103,61,9,168,240,188,15,125,23,190,69,18,125,191,12,230,47,186,156,82,222,189,194,219,3,187,9,168,240,188,15,125,23,190,69,18,125,191,194,137,168,61,216,70,220,189,23,158,151,187,9,168,240,188,15,125,23,190,69,18,125,191,32,240,192,59,226,33,0,191,29,56,103,61,59,172,240,188,15,125,23,190,69,18,125,191,194,137,168,61,216,70,220,189,23,158,151,187,59,172,240,188,15,125,23,190,69,18,125,191,10,248,181,61,244,192,255,190,23,130,92,61,59,172,240,188,15,125,23,190,69,18,125,191,86,69,184,61,56,219,252,190,230,176,187,61,59,172,240,60,70,124,23,62,69,18,125,63,14,215,170,61,108,176,208,189,255,236,7,61,59,172,240,60,70,124,23,62,69,18,125,63,161,128,237,57,170,187,210,189,5,163,18,61,59,172,240,60,70,124,23,62,69,18,125,63,86,69,184,61,56,219,252,190,230,176,187,61,83,174,240,60,137,124,23,62,69,18,125,63,161,128,237,57,170,187,210,189,5,163,18,61,83,174,240,60,137,124,23,62,69,18,125,63,235,196,229,59,7,94,253,190,233,11,193,61,83,174,240,60,137,124,23,62,69,18,125,63,227,169,39,190,0,0,0,0,174,188,52,190,0,0,0,0,0,0,128,191,0,0,0,0,233,239,37,190,0,0,0,0,131,52,179,190,0,0,0,0,0,0,128,191,0,0,0,0,225,96,207,189,0,0,0,0,75,30,127,190,0,0,0,0,0,0,128,191,0,0,0,0,243,57,151,189,106,164,133,61,133,177,197,189,187,124,63,63,90,160,221,188,68,196,41,191,70,67,6,189,106,164,133,61,50,173,77,189,187,124,63,63,90,160,221,188,68,196,41,191,175,152,145,189,0,0,0,0,147,228,185,189,187,124,63,63,90,160,221,188,68,196,41,191,12,177,250,189,106,164,133,61,111,215,75,189,218,87,38,191,8,33,32,189,143,85,66,63,4,55,2,190,0,0,0,0,103,71,106,189,218,87,38,191,8,33,32,189,143,85,66,63,35,186,103,189,0,0,0,0,134,90,83,59,218,87,38,191,8,33,32,189,143,85,66,63,27,100,2,62,106,164,133,61,225,124,106,189,153,40,38,63,45,36,32,61,254,125,66,63,199,156,103,61,106,164,133,61,218,140,83,59,153,40,38,63,45,36,32,61,254,125,66,63,55,0,251,61,0,0,0,0,146,5,76,189,153,40,38,63,45,36,32,61,254,125,66,63,174,103,72,61,106,164,133,61,187,69,136,190,105,26,104,63,65,17,203,61,98,243,209,62,237,156,230,60,106,164,133,61,157,129,97,190,105,26,104,63,65,17,203,61,98,243,209,62,115,216,61,61,0,0,0,0,34,141,122,190,105,26,104,63,65,17,203,61,98,243,209,62,52,48,146,61,106,164,133,61,7,206,185,189,237,101,123,191,147,110,203,188,220,155,63,190,214,1,208,61,106,164,133,61,75,30,127,190,237,101,123,191,147,110,203,188,220,155,63,190,230,207,151,61,0,0,0,0,175,148,197,189,237,101,123,191,147,110,203,188,220,155,63,190,166,128,52,188,106,164,133,61,204,212,156,190,211,104,234,190,236,79,34,189,32,94,99,191,3,122,225,187,0,0,0,0,177,110,156,190,211,104,234,190,236,79,34,189,32,94,99,191,74,66,34,189,0,0,0,0,29,203,147,190,211,104,234,190,236,79,34,189,32,94,99,191,12,177,250,189,106,164,133,61,111,215,75,189,0,0,0,0,0,0,128,63,0,0,0,0,199,156,103,61,106,164,133,61,218,140,83,59,0,0,0,0,0,0,128,63,0,0,0,0,27,100,2,62,106,164,133,61,225,124,106,189,0,0,0,0,0,0,128,63,0,0,0,0,74,66,34,189,0,0,0,0,29,203,147,190,0,0,0,0,0,0,128,191,0,0,0,0,85,250,9,61,0,0,0,0,182,76,150,190,0,0,0,0,0,0,128,191,0,0,0,0,115,216,61,61,0,0,0,0,34,141,122,190,0,0,0,0,0,0,128,191,0,0,0,0,35,186,103,189,106,164,133,61,231,113,4,191,0,0,0,0,0,0,128,63,0,0,0,0,20,8,251,61,106,164,133,61,44,186,237,190,0,0,0,0,0,0,128,63,0,0,0,0,82,182,72,61,106,164,133,61,231,23,5,191,0,0,0,0])
.concat([0,0,128,63,0,0,0,0,237,156,230,60,106,164,133,61,157,129,97,190,45,233,20,63,127,136,13,190,189,52,77,63,185,223,33,187,0,0,0,0,40,70,86,190,45,233,20,63,127,136,13,190,189,52,77,63,115,216,61,61,0,0,0,0,34,141,122,190,45,233,20,63,127,136,13,190,189,52,77,63,58,234,232,188,106,164,133,61,11,127,238,190,117,59,251,60,238,61,220,60,121,201,127,63,70,67,6,189,0,0,0,0,114,135,237,190,117,59,251,60,238,61,220,60,121,201,127,63,215,80,234,60,0,0,0,0,99,126,238,190,117,59,251,60,238,61,220,60,121,201,127,63,104,3,208,61,0,0,0,0,60,134,135,190,0,0,0,0,0,0,128,191,0,0,0,0,56,247,39,62,0,0,0,0,226,203,172,190,0,0,0,0,0,0,128,191,0,0,0,0,50,60,38,62,0,0,0,0,111,246,39,190,0,0,0,0,0,0,128,191,0,0,0,0,99,184,250,189,0,0,0,0,240,191,237,190,0,0,0,0,0,0,128,191,0,0,0,0,5,219,72,189,0,0,0,0,181,23,5,191,0,0,0,0,0,0,128,191,0,0,0,0,199,156,103,61,0,0,0,0,25,114,4,191,0,0,0,0,0,0,128,191,0,0,0,0,160,169,39,190,106,164,133,61,171,204,172,190,28,234,127,191,120,65,196,188,170,43,31,188,233,239,37,190,0,0,0,0,131,52,179,190,28,234,127,191,120,65,196,188,170,43,31,188,227,169,39,190,0,0,0,0,174,188,52,190,28,234,127,191,120,65,196,188,170,43,31,188,12,177,250,189,106,164,133,61,111,215,75,189,0,0,0,0,0,0,128,63,156,83,73,182,215,80,234,60,106,164,133,61,174,245,69,189,0,0,0,0,0,0,128,63,156,83,73,182,70,67,6,189,106,164,133,61,50,173,77,189,0,0,0,0,0,0,128,63,156,83,73,182,99,184,250,189,0,0,0,0,240,191,237,190,0,0,0,0,0,0,128,191,0,0,0,0,199,156,103,61,0,0,0,0,25,114,4,191,0,0,0,0,0,0,128,191,0,0,0,0,65,103,2,62,0,0,0,0,100,235,233,190,0,0,0,0,0,0,128,191,0,0,0,0,160,169,39,190,106,164,133,61,171,204,172,190,201,170,116,191,135,162,0,61,142,202,149,190,42,58,2,190,106,164,133,61,19,242,233,190,201,170,116,191,135,162,0,61,142,202,149,190,233,239,37,190,0,0,0,0,131,52,179,190,201,170,116,191,135,162,0,61,142,202,149,190,20,8,251,61,106,164,133,61,44,186,237,190,180,170,113,63,68,138,1,61,133,35,168,190,172,59,38,62,106,164,133,61,64,52,179,190,180,170,113,63,68,138,1,61,133,35,168,190,65,103,2,62,0,0,0,0,100,235,233,190,180,170,113,63,68,138,1,61,133,35,168,190,200,125,43,189,106,164,133,61,77,17,112,190,0,0,0,0,0,0,128,63,0,0,0,0,237,156,230,60,106,164,133,61,157,129,97,190,0,0,0,0,0,0,128,63,0,0,0,0,174,103,72,61,106,164,133,61,187,69,136,190,0,0,0,0,0,0,128,63,0,0,0,0,99,184,250,189,0,0,0,0,240,191,237,190,0,0,0,0,0,0,128,63,0,0,0,0,65,103,2,62,0,0,0,0,100,235,233,190,0,0,0,0,0,0,128,63,0,0,0,0,215,80,234,60,0,0,0,0,99,126,238,190,0,0,0,0,0,0,128,63,0,0,0,0,237,157,145,189,106,164,133,61,30,194,216,190,229,126,63,63,164,166,221,60,198,193,41,63,37,62,151,189,0,0,0,0,3,207,213,190,229,126,63,63,164,166,221,60,198,193,41,63,70,67,6,189,0,0,0,0,114,135,237,190,229,126,63,63,164,166,221,60,198,193,41,63,99,184,250,189,0,0,0,0,240,191,237,190,0,0,0,0,0,0,128,191,0,0,0,0,215,80,234,60,0,0,0,0,99,126,238,190,0,0,0,0,0,0,128,191,0,0,0,0,70,67,6,189,0,0,0,0,114,135,237,190,0,0,0,0,0,0,128,191,0,0,0,0,166,128,52,188,106,164,133,61,204,212,156,190,48,41,62,62,192,6,132,189,84,1,123,191,35,133,178,60,106,164,133,61,80,166,153,190,48,41,62,62,192,6,132,189,84,1,123,191,85,250,9,61,0,0,0,0,182,76,150,190,48,41,62,62,192,6,132,189,84,1,123,191,9,22,7,61,106,164,133,61,35,134,237,190,148,46,253,188,152,162,220,188,226,200,127,63,58,234,232,188,106,164,133,61,11,127,238,190,148,46,253,188,152,162,220,188,226,200,127,63,215,80,234,60,0,0,0,0,99,126,238,190,148,46,253,188,152,162,220,188,226,200,127,63,52,48,146,61,106,164,133,61,7,206,185,189,93,49,63,191,195,42,222,60,223,24,42,191,230,207,151,61,0,0,0,0,175,148,197,189,93,49,63,191,195,42,222,60,223,24,42,191,9,22,7,61,0,0,0,0,174,183,77,189,93,49,63,191,195,42,222,60,223,24,42,191,20,8,251,61,106,164,133,61,44,186,237,190,0,0,0,0,0,0,128,63,0,0,0,0,58,234,232,188,106,164,133,61,11,127,238,190,0,0,0,0,0,0,128,63,0,0,0,0,9,22,7,61,106,164,133,61,35,134,237,190,0,0,0,0,0,0,128,63,0,0,0,0,166,128,52,188,106,164,133,61,204,212,156,190,0,0,0,0,0,0,128,63,0,0,0,0,174,103,72,61,106,164,133,61,187,69,136,190,0,0,0,0,0,0,128,63,0,0,0,0,35,133,178,60,106,164,133,61,80,166,153,190,0,0,0,0,0,0,128,63,0,0,0,0,12,177,250,189,106,164,133,61,111,215,75,189,0,0,0,0,0,0,128,63,0,0,0,0,243,57,151,189,106,164,133,61,133,177,197,189,0,0,0,0,0,0,128,63,0,0,0,0,111,240,37,190,106,164,133,61,232,245,39,190,0,0,0,0,0,0,128,63,0,0,0,0,111,240,37,190,106,164,133,61,232,245,39,190,114,163,116,191,244,106,0,189,13,251,149,62,227,169,39,190,0,0,0,0,174,188,52,190,114,163,116,191,244,106,0,189,13,251,149,62,4,55,2,190,0,0,0,0,103,71,106,189,114,163,116,191,244,106,0,189,13,251,149,62,215,80,234,60,106,164,133,61,174,245,69,189,124,44,253,188,127,160,220,60,226,200,127,191,9,22,7,61,0,0,0,0,174,183,77,189,124,44,253,188,127,160,220,60,226,200,127,191,58,234,232,188,0,0,0,0,111,240,69,189,124,44,253,188,127,160,220,60,226,200,127,191,199,156,103,61,106,164,133,61,218,140,83,59,207,220,195,60,9,80,19,61,219,194,127,63,5,219,72,189,106,164,133,61,112,148,188,59,207,220,195,60,9,80,19,61,219,194,127,63,82,182,72,61,0,0,0,0,155,173,188,59,207,220,195,60,9,80,19,61,219,194,127,63,160,169,39,190,106,164,133,61,171,204,172,190,0,0,0,0,0,0,128,63,0,0,0,0,237,157,145,189,106,164,133,61,30,194,216,190,0,0,0,0,0,0,128,63,0,0,0,0,42,58,2,190,106,164,133,61,19,242,233,190,0,0,0,0,0,0,128,63,0,0,0,0,12,177,250,189,106,164,133,61,111,215,75,189,0,0,0,0,0,0,128,191,189,55,134,53,27,100,2,62,106,164,133,61,225,124,106,189,0,0,0,0,0,0,128,191,189,55,134,53,215,80,234,60,106,164,133,61,174,245,69,189,0,0,0,0,0,0,128,191,189,55,134,53,35,186,103,189,0,0,0,0,134,90,83,59,0,0,0,0,0,0,128,191,0,0,0,0,4,55,2,190,0,0,0,0,103,71,106,189,0,0,0,0,0,0,128,191,0,0,0,0,55,0,251,61,0,0,0,0,146,5,76,189,0,0,0,0,0,0,128,191,0,0,0,0,123,247,39,62,106,164,133,61,64,190,52,190,251,233,127,63,162,241,196,188,133,148,31,60,50,60,38,62,0,0,0,0,111,246,39,190,251,233,127,63,162,241,196,188,133,148,31,60,56,247,39,62,0,0,0,0,226,203,172,190,251,233,127,63,162,241,196,188,133,148,31,60,52,48,146,61,106,164,133,61,7,206,185,189,0,0,0,0,0,0,128,63,0,0,0,0,123,247,39,62,106,164,133,61,64,190,52,190,0,0,0,0,0,0,128,63,0,0,0,0,214,1,208,61,106,164,133,61,75,30,127,190,0,0,0,0,0,0,128,63,0,0,0,0,9,22,7,61,106,164,133,61,35,134,237,190,103,38,52,191,70,211,217,60,215,193,53,63,215,80,234,60,0,0,0,0,99,126,238,190,103,38,52,191,70,211,217,60,215,193,53,63,114,53,146,61,0,0,0,0,159,199,216,190,103,38,52,191,70,211,217,60,215,193,53,63,123,247,39,62,106,164,133,61,64,190,52,190,222,142,116,63,126,226,0,61,212,127,150,62,27,100,2,62,106,164,133,61,225,124,106,189,222,142,116,63,126,226,0,61,212,127,150,62,50,60,38,62,0,0,0,0,111,246,39,190,222,142,116,63,126,226,0,61,212,127,150,62,42,58,2,190,106,164,133,61,19,242,233,190,4,90,38,191,57,37,32,61,168,83,66,191,35,186,103,189,106,164,133,61,231,113,4,191,4,90,38,191,57,37,32,61,168,83,66,191,99,184,250,189,0,0,0,0,240,191,237,190,4,90,38,191,57,37,32,61,168,83,66,191,111,240,37,190,106,164,133,61,232,245,39,190,28,234,127,191,235,31,196,60,92,228,30,60,160,169,39,190,106,164,133,61,171,204,172,190,28,234,127,191,235,31,196,60,92,228,30,60,227,169,39,190,0,0,0,0,174,188,52,190,28,234,127,191,235,31,196,60,92,228,30,60,114,53,146,61,0,0,0,0,159,199,216,190,0,0,0,0,0,0,128,191,0,0,0,0,215,80,234,60,0,0,0,0,99,126,238,190,0,0,0,0,0,0,128,191,0,0,0,0,65,103,2,62,0,0,0,0,100,235,233,190,0,0,0,0,0,0,128,191,0,0,0,0,99,184,250,189,0,0,0,0,240,191,237,190,0,0,0,0,0,0,128,191,0,0,0,0,70,67,6,189,0,0,0,0,114,135,237,190,0,0,0,0,0,0,128,191,0,0,0,0,37,62,151,189,0,0,0,0,3,207,213,190,0,0,0,0,0,0,128,191,0,0,0,0,70,67,6,189,106,164,133,61,50,173,77,189,90,126,52,63,22,161,216,60,223,106,53,191,58,234,232,188,0,0,0,0,111,240,69,189,90,126,52,63,22,161,216,60,223,106,53,191,175,152,145,189,0,0,0,0,147,228,185,189,90,126,52,63,22,161,216,60,223,106,53,191,172,59,38,62,106,164,133,61,64,52,179,190,53,150,116,63,17,26,1,189,51,79,150,190,56,247,39,62,0,0,0,0,226,203,172,190,53,150,116,63,17,26,1,189,51,79,150,190,65,103,2,62,0,0,0,0,100,235,233,190,53,150,116,63,17,26,1,189,51,79,150,190,214,1,208,61,106,164,133,61,75,30,127,190,0,0,0,0,0,0,128,63,0,0,0,0,172,59,38,62,106,164,133,61,64,52,179,190,0,0,0,0,0,0,128,63,0,0,0,0,23,212,151,61,106,164,133,61,23,214,213,190,0,0,0,0,0,0,128,63,0,0,0,0,199,156,103,61,106,164,133,61,218,140,83,59,148,49,26,63,64,161,30,189,214,28,76,63,82,182,72,61,0,0,0,0,155,173,188,59,148,49,26,63,64,161,30,189,214,28,76,63,55,0,251,61,0,0,0,0,146,5,76,189,148,49,26,63,64,161,30,189,214,28,76,63,82,182,72,61,106,164,133,61,231,23,5,191,207,220,195,60,9,80,19,189,219,194,127,191,199,156,103,61,0,0,0,0,25,114,4,191,207,220,195,60,9,80,19,189,219,194,127,191,5,219,72,189,0,0,0,0,181,23,5,191,207,220,195,60,9,80,19,189,219,194,127,191,215,80,234,60,106,164,133,61,174,245,69,189,133,35,52,191,226,202,217,188,168,196,53,191,52,48,146,61,106,164,133,61,7,206,185,189,133,35,52,191,226,202,217,188,168,196,53,191,9,22,7,61,0,0,0,0,174,183,77,189,133,35,52,191,226,202,217,188,168,196,53,191,11,210,12,188,106,164,133,61,75,176,88,190,0,0,0,0,0,0,128,63,0,0,0,0,237,156,230,60,106,164,133,61,157,129,97,190,0,0,0,0,0,0,128,63,0,0,0,0,200,125,43,189,106,164,133,61,77,17,112,190,0,0,0,0,0,0,128,63,0,0,0,0,11,210,12,188,106,164,133,61,75,176,88,190,250,213,16,191,76,85,218,59,253,20,83,63,200,125,43,189,106,164,133,61,77,17,112,190,250,213,16,191,76,85,218,59,253,20,83,63,231,143,41,189,0,0,0,0,56,50,111,190,250,213,16,191,76,85,218,59,253,20,83,63,11,210,12,188,106,164,133,61,75,176,88,190,211,219,123,191,132,127,177,189,63,140,32,62,185,223,33,187,0,0,0,0,40,70,86,190,211,219,123,191,132,127,177,189,63,140,32,62,195,46,10,188,106,164,133,61,13,168,87,190,211,219,123,191,132,127,177,189,63,140,32,62,5,219,72,189,106,164,133,61,112,148,188,59,113,86,196,188,240,77,19,189,202,194,127,63,35,186,103,189,0,0,0,0,134,90,83,59,113,86,196,188,240,77,19,189,202,194,127,63,82,182,72,61,0,0,0,0,155,173,188,59,113,86,196,188,240,77,19,189,202,194,127,63,237,157,145,189,106,164,133,61,30,194,216,190,0,0,0,0,0,0,128,63,0,0,0,0,58,234,232,188,106,164,133,61,11,127,238,190,0,0,0,0,0,0,128,63,0,0,0,0,42,58,2,190,106,164,133,61,19,242,233,190,0,0,0,0,0,0,128,63,0,0,0,0,233,239,37,190,0,0,0,0,131,52,179,190,0,0,0,0,0,0,128,191,0,0,0,0,99,184,250,189,0,0,0,0,240,191,237,190,0,0,0,0,0,0,128,191,0,0,0,0,37,62,151,189,0,0,0,0,3,207,213,190,0,0,0,0,0,0,128,191,0,0,0,0,82,182,72,61,106,164,133,61,231,23,5,191,68,52,26,63,127,166,30,61,206,26,76,191,20,8,251,61,106,164,133,61,44,186,237,190,68,52,26,63,127,166,30,61,206,26,76,191,199,156,103,61,0,0,0,0,25,114,4,191,68,52,26,63,127,166,30,61,206,26,76,191,4,55,2,190,0,0,0,0,103,71,106,189,0,0,0,0,0,0,128,191,0,0,0,0,227,169,39,190,0,0,0,0,174,188,52,190,0,0,0,0,0,0,128,191,0,0,0,0,175,152,145,189,0,0,0,0,147,228,185,189,0,0,0,0,0,0,128,191,0,0,0,0,58,234,232,188,106,164,133,61,11,127,238,190,44,129,52,63,122,169,216,188,253,103,53,63,237,157,145,189,106,164,133,61,30,194,216,190,44,129,52,63,122,169,216,188,253,103,53,63,70,67,6,189,0,0,0,0,114,135,237,190,44,129,52,63,122,169,216,188,253,103,53,63,5,219,72,189,106,164,133,61,112,148,188,59,62,92,26,191,57,182,30,61,135,252,75,63,12,177,250,189,106,164,133,61,111,215,75,189,62,92,26,191,57,182,30,61,135,252,75,63,35,186,103,189,0,0,0,0,134,90,83,59,62,92,26,191,57,182,30,61,135,252,75,63,214,1,208,61,106,164,133,61,75,30,127,190,0,0,0,0,0,0,128,63,0,0,0,0,123,247,39,62,106,164,133,61,64,190,52,190,0,0,0,0,0,0,128,63,0,0,0,0,172,59,38,62,106,164,133,61,64,52,179,190,0,0,0,0,0,0,128,63,0,0,0,0,35,186,103,189,0,0,0,0,134,90,83,59,0,0,0,0,0,0,128,191,0,0,0,0,55,0,251,61,0,0,0,0,146,5,76,189,0,0,0,0,0,0,128,191,0,0,0,0,82,182,72,61,0,0,0,0,155,173,188,59,0,0,0,0,0,0,128,191,0,0,0,0,114,53,146,61,0,0,0,0,159,199,216,190,0,0,0,0,0,0,128,191,0,0,0,0,65,103,2,62,0,0,0,0,100,235,233,190,0,0,0,0,0,0,128,191,0,0,0,0,56,247,39,62,0,0,0,0,226,203,172,190,0,0,0,0,0,0,128,191,0,0,0,0,20,8,251,61,106,164,133,61,44,186,237,190,195,42,38,63,107,41,32,189,24,124,66,191,65,103,2,62,0,0,0,0,100,235,233,190,195,42,38,63,107,41,32,189,24,124,66,191,199,156,103,61,0,0,0,0,25,114,4,191,195,42,38,63,107,41,32,189,24,124,66,191,160,169,39,190,106,164,133,61,171,204,172,190,0,0,0,0,0,0,128,63,0,0,0,0,116,98,207,189,106,164,133,61,60,134,135,190,0,0,0,0,0,0,128,63,0,0,0,0,237,157,145,189,106,164,133,61,30,194,216,190,0,0,0,0,0,0,128,63,0,0,0,0,231,143,41,189,0,0,0,0,56,50,111,190,0,0,0,0,0,0,128,191,0,0,0,0,115,216,61,61,0,0,0,0,34,141,122,190,0,0,0,0,0,0,128,191,0,0,0,0,185,223,33,187,0,0,0,0,40,70,86,190,0,0,0,0,0,0,128,191,0,0,0,0,27,100,2,62,106,164,133,61,225,124,106,189,198,162,113,63,25,113,1,189,34,81,168,62,55,0,251,61,0,0,0,0,146,5,76,189,198,162,113,63,25,113,1,189,34,81,168,62,50,60,38,62,0,0,0,0,111,246,39,190,198,162,113,63,25,113,1,189,34,81,168,62,4,55,2,190,0,0,0,0,103,71,106,189,0,0,0,0,0,0,128,63,0,0,0,0,58,234,232,188,0,0,0,0,111,240,69,189,0,0,0,0,0,0,128,63,0,0,0,0,55,0,251,61,0,0,0,0,146,5,76,189,0,0,0,0,0,0,128,63,0,0,0,0,104,3,208,61,0,0,0,0,60,134,135,190,0,0,0,0,0,0,128,191,0,0,0,0,114,53,146,61,0,0,0,0,159,199,216,190,0,0,0,0,0,0,128,191,0,0,0,0,56,247,39,62,0,0,0,0,226,203,172,190,0,0,0,0,0,0,128,191,0,0,0,0,233,239,37,190,0,0,0,0,131,52,179,190,0,0,0,0,0,0,128,191,0,0,0,0,37,62,151,189,0,0,0,0,3,207,213,190,0,0,0,0,0,0,128,191,0,0,0,0,225,96,207,189,0,0,0,0,75,30,127,190,0,0,0,0,0,0,128,191,0,0,0,0,5,219,72,189,106,164,133,61,112,148,188,59,0,0,0,0,0,0,128,63,0,0,0,0,199,156,103,61,106,164,133,61,218,140,83,59,0,0,0,0,0,0,128,63,0,0,0,0,12,177,250,189,106,164,133,61,111,215,75,189,0,0,0,0,0,0,128,63,0,0,0,0,140,18,52,189,106,164,133,61,47,54,141,190,0,0,0,0,0,0,128,63,0,0,0,0,174,103,72,61,106,164,133,61,187,69,136,190,0,0,0,0,0,0,128,63,0,0,0,0,166,128,52,188,106,164,133,61,204,212,156,190,0,0,0,0,0,0,128,63,0,0,0,0,35,133,178,60,106,164,133,61,80,166,153,190,51,82,71,63,83,207,162,61,255,89,31,191,174,103,72,61,106,164,133,61,187,69,136,190,51,82,71,63,83,207,162,61,255,89,31,191,85,250,9,61,0,0,0,0,182,76,150,190,51,82,71,63,83,207,162,61,255,89,31,191,166,128,52,188,106,164,133,61,204,212,156,190,223,250,144,62,116,178,212,59,77,132,117,191,85,250,9,61,0,0,0,0,182,76,150,190,223,250,144,62,116,178,212,59,77,132,117,191,3,122,225,187,0,0,0,0,177,110,156,190,223,250,144,62,116,178,212,59,77,132,117,191,230,207,151,61,0,0,0,0,175,148,197,189,0,0,0,0,0,0,128,191,0,0,0,0,104,3,208,61,0,0,0,0,60,134,135,190,0,0,0,0,0,0,128,191,0,0,0,0,50,60,38,62,0,0,0,0,111,246,39,190,0,0,0,0,0,0,128,191,0,0,0,0,111,240,37,190,106,164,133,61,232,245,39,190,0,0,0,0,0,0,128,63,0,0,0,0,243,57,151,189,106,164,133,61,133,177,197,189,0,0,0,0,0,0,128,63,0,0,0,0,116,98,207,189,106,164,133,61,60,134,135,190,0,0,0,0,0,0,128,63,0,0,0,0,42,58,2,190,106,164,133,61,19,242,233,190,0,0,0,0,0,0,128,191,0,0,0,0,58,234,232,188,106,164,133,61,11,127,238,190,0,0,0,0,0,0,128,191,0,0,0,0,20,8,251,61,106,164,133,61,44,186,237,190,0,0,0,0,0,0,128,191,0,0,0,0,58,234,232,188,0,0,0,0,111,240,69,189,0,0,0,0,0,0,128,191,0,0,0,0,9,22,7,61,0,0,0,0,174,183,77,189,0,0,0,0,0,0,128,191,0,0,0,0,55,0,251,61,0,0,0,0,146,5,76,189,0,0,0,0,0,0,128,191,0,0,0,0,116,98,207,189,106,164,133,61,60,134,135,190,74,122,124,63,155,227,28,189,176,172,36,190,243,57,151,189,106,164,133,61,133,177,197,189,74,122,124,63,155,227,28,189,176,172,36,190,225,96,207,189,0,0,0,0,75,30,127,190,74,122,124,63,155,227,28,189,176,172,36,190,9,22,7,61,0,0,0,0,174,183,77,189,0,0,0,0,0,0,128,191,0,0,0,0,230,207,151,61,0,0,0,0,175,148,197,189,0,0,0,0,0,0,128,191,0,0,0,0,55,0,251,61,0,0,0,0,146,5,76,189,0,0,0,0,0,0,128,191,0,0,0,0,23,212,151,61,106,164,133,61,23,214,213,190,0,0,0,0,0,0,128,63,0,0,0,0,172,59,38,62,106,164,133,61,64,52,179,190,0,0,0,0,0,0,128,63,0,0,0,0,20,8,251,61,106,164,133,61,44,186,237,190,0,0,0,0,0,0,128,63,0,0,0,0,5,219,72,189,0,0,0,0,181,23,5,191,88,84,196,188,228,76,19,61,202,194,127,191,35,186,103,189,106,164,133,61,231,113,4,191,88,84,196,188,228,76,19,61,202,194,127,191,82,182,72,61,106,164,133,61,231,23,5,191,88,84,196,188,228,76,19,61,202,194,127,191,116,98,207,189,106,164,133,61,60,134,135,190,212,125,124,63,68,220,28,61,180,86,36,62,225,96,207,189,0,0,0,0,75,30,127,190,212,125,124,63,68,220,28,61,180,86,36,62,37,62,151,189,0,0,0,0,3,207,213,190,212,125,124,63,68,220,28,61,180,86,36,62,243,57,151,189,106,164,133,61,133,177,197,189,165,102,123,63,65,125,203,60,101,140,63,190,175,152,145,189,0,0,0,0,147,228,185,189,165,102,123,63,65,125,203,60,101,140,63,190,225,96,207,189,0,0,0,0,75,30,127,190,165,102,123,63,65,125,203,60,101,140,63,190,23,212,151,61,106,164,133,61,23,214,213,190,0,0,0,0,0,0,128,63,0,0,0,0,20,8,251,61,106,164,133,61,44,186,237,190,0,0,0,0,0,0,128,63,0,0,0,0,9,22,7,61,106,164,133,61,35,134,237,190,0,0,0,0,0,0,128,63,0,0,0,0,70,67,6,189,106,164,133,61,50,173,77,189,117,59,251,60,214,59,220,188,121,201,127,191,215,80,234,60,106,164,133,61,174,245,69,189,117,59,251,60,214,59,220,188,121,201,127,191,58,234,232,188,0,0,0,0,111,240,69,189,117,59,251,60,214,59,220,188,121,201,127,191,200,125,43,189,106,164,133,61,77,17,112,190,0,0,0,0,0,0,128,63,0,0,0,0,174,103,72,61,106,164,133,61,187,69,136,190,0,0,0,0,0,0,128,63,0,0,0,0,140,18,52,189,106,164,133,61,47,54,141,190,0,0,0,0,0,0,128,63,0,0,0,0,42,58,2,190,106,164,133,61,19,242,233,190,0,0,0,0,0,0,128,63,0,0,0,0,20,8,251,61,106,164,133,61,44,186,237,190,0,0,0,0,0,0,128,63,0,0,0,0,35,186,103,189,106,164,133,61,231,113,4,191,0,0,0,0,0,0,128,63,0,0,0,0,11,210,12,188,106,164,133,61,75,176,88,190,0,0,0,0,0,0,128,63,0,0,0,0,195,46,10,188,106,164,133,61,13,168,87,190,0,0,0,0,0,0,128,63,0,0,0,0,237,156,230,60,106,164,133,61,157,129,97,190,0,0,0,0,0,0,128,63,0,0,0,0,230,207,151,61,0,0,0,0,175,148,197,189,0,0,0,0,0,0,128,191,0,0,0,0,50,60,38,62,0,0,0,0,111,246,39,190,0,0,0,0,0,0,128,191,0,0,0,0,55,0,251,61,0,0,0,0,146,5,76,189,0,0,0,0,0,0,128,191,0,0,0,0,4,55,2,190,0,0,0,0,103,71,106,189,0,0,0,0,0,0,128,191,0,0,0,0,175,152,145,189,0,0,0,0,147,228,185,189,0,0,0,0,0,0,128,191,0,0,0,0,58,234,232,188,0,0,0,0,111,240,69,189,0,0,0,0,0,0,128,191,0,0,0,0,52,48,146,61,106,164,133,61,7,206,185,189,0,0,0,0,0,0,128,63,0,0,0,0,27,100,2,62,106,164,133,61,225,124,106,189,0,0,0,0,0,0,128,63,0,0,0,0,123,247,39,62,106,164,133,61,64,190,52,190,0,0,0,0,0,0,128,63,0,0,0,0,11,210,12,188,106,164,133,61,75,176,88,190,108,177,7,191,73,134,156,188,37,6,89,63,231,143,41,189,0,0,0,0,56,50,111,190,108,177,7,191,73,134,156,188,37,6,89,63,185,223,33,187,0,0,0,0,40,70,86,190,108,177,7,191,73,134,156,188,37,6,89,63,42,58,2,190,106,164,133,61,19,242,233,190,101,196,113,191,104,33,1,189,184,144,167,190,99,184,250,189,0,0,0,0,240,191,237,190,101,196,113,191,104,33,1,189,184,144,167,190,233,239,37,190,0,0,0,0,131,52,179,190,101,196,113,191,104,33,1,189,184,144,167,190,111,240,37,190,106,164,133,61,232,245,39,190,0,0,0,0,0,0,128,63,0,0,0,0,116,98,207,189,106,164,133,61,60,134,135,190,0,0,0,0,0,0,128,63,0,0,0,0,160,169,39,190,106,164,133,61,171,204,172,190,0,0,0,0,0,0,128,63,0,0,0,0,74,66,34,189,0,0,0,0,29,203,147,190,0,0,0,0,0,0,128,191,0,0,0,0,3,122,225,187,0,0,0,0,177,110,156,190,0,0,0,0,0,0,128,191,0,0,0,0,85,250,9,61,0,0,0,0,182,76,150,190,0,0,0,0,0,0,128,191,0,0,0,0,35,186,103,189,106,164,133,61,231,113,4,191,238,94,26,191,132,188,30,189,127,250,75,191,5,219,72,189,0,0,0,0,181,23,5,191,238,94,26,191,132,188,30,189,127,250,75,191,99,184,250,189,0,0,0,0,240,191,237,190,238,94,26,191,132,188,30,189,127,250,75,191,237,156,230,60,106,164,133,61,157,129,97,190,14,18,130,62,211,249,48,61,167,90,119,63,195,46,10,188,106,164,133,61,13,168,87,190,14,18,130,62,211,249,48,61,167,90,119,63,185,223,33,187,0,0,0,0,40,70,86,190,14,18,130,62,211,249,48,61,167,90,119,63,12,177,250,189,106,164,133,61,111,215,75,189,0,0,0,0,0,0,128,63,0,0,0,0,70,67,6,189,106,164,133,61,50,173,77,189,0,0,0,0,0,0,128,63,0,0,0,0,243,57,151,189,106,164,133,61,133,177,197,189,0,0,0,0,0,0,128,63,0,0,0,0,214,1,208,61,106,164,133,61,75,30,127,190,146,121,124,191,86,243,28,61,186,189,36,190,104,3,208,61,0,0,0,0,60,134,135,190,146,121,124,191,86,243,28,61,186,189,36,190,230,207,151,61,0,0,0,0,175,148,197,189,146,121,124,191,86,243,28,61,186,189,36,190,74,66,34,189,0,0,0,0,29,203,147,190,194,219,127,191,76,139,250,187,99,128,4,189,231,143,41,189,0,0,0,0,56,50,111,190,194,219,127,191,76,139,250,187,99,128,4,189,200,125,43,189,106,164,133,61,77,17,112,190,194,219,127,191,76,139,250,187,99,128,4,189,231,143,41,189,0,0,0,0,56,50,111,190,0,0,0,0,0,0,128,191,0,0,0,0,74,66,34,189,0,0,0,0,29,203,147,190,0,0,0,0,0,0,128,191,0,0,0,0,115,216,61,61,0,0,0,0,34,141,122,190,0,0,0,0,0,0,128,191,0,0,0,0,214,1,208,61,106,164,133,61,75,30,127,190,11,125,124,191,255,235,28,189,190,103,36,62,23,212,151,61,106,164,133,61,23,214,213,190,11,125,124,191,255,235,28,189,190,103,36,62,104,3,208,61,0,0,0,0,60,134,135,190,11,125,124,191,255,235,28,189,190,103,36,62,215,80,234,60,106,164,133,61,174,245,69,189,0,0,0,0,0,0,128,63,0,0,0,0,27,100,2,62,106,164,133,61,225,124,106,189,0,0,0,0,0,0,128,63,0,0,0,0,52,48,146,61,106,164,133,61,7,206,185,189,0,0,0,0,0,0,128,63,0,0,0,0,23,212,151,61,106,164,133,61,23,214,213,190,152,51,63,191,39,51,222,188,97,22,42,63,9,22,7,61,106,164,133,61,35,134,237,190,152,51,63,191,39,51,222,188,97,22,42,63,114,53,146,61,0,0,0,0,159,199,216,190,152,51,63,191,39,51,222,188,97,22,42,63,12,177,250,189,106,164,133,61,111,215,75,189,136,188,113,191,62,8,1,61,52,190,167,62,111,240,37,190,106,164,133,61,232,245,39,190,136,188,113,191,62,8,1,61,52,190,167,62,4,55,2,190,0,0,0,0,103,71,106,189,136,188,113,191,62,8,1,61,52,190,167,62,140,18,52,189,106,164,133,61,47,54,141,190,106,21,45,191,249,72,202,61,62,235,58,191,166,128,52,188,106,164,133,61,204,212,156,190,106,21,45,191,249,72,202,61,62,235,58,191,74,66,34,189,0,0,0,0,29,203,147,190,106,21,45,191,249,72,202,61,62,235,58,191,74,66,34,189,0,0,0,0,29,203,147,190,70,237,126,191,191,68,156,189,251,149,78,61,200,125,43,189,106,164,133,61,77,17,112,190,70,237,126,191,191,68,156,189,251,149,78,61,140,18,52,189,106,164,133,61,47,54,141,190,70,237,126,191,191,68,156,189,251,149,78,61,237,157,145,189,106,164,133,61,30,194,216,190,60,107,123,63,1,163,203,188,103,43,63,62,116,98,207,189,106,164,133,61,60,134,135,190,60,107,123,63,1,163,203,188,103,43,63,62,37,62,151,189,0,0,0,0,3,207,213,190,60,107,123,63,1,163,203,188,103,43,63,62,23,212,151,61,106,164,133,61,23,214,213,190,131,106,123,191,83,148,203,60,222,58,63,62,114,53,146,61,0,0,0,0,159,199,216,190,131,106,123,191,83,148,203,60,222,58,63,62,104,3,208,61,0,0,0,0,60,134,135,190,131,106,123,191,83,148,203,60,222,58,63,62,227,169,39,190,0,0,0,0,174,188,52,190,0,0,0,0,0,0,128,191,0,0,0,0,225,96,207,189,0,0,0,0,75,30,127,190,0,0,0,0,0,0,128,191,0,0,0,0,175,152,145,189,0,0,0,0,147,228,185,189,0,0,0,0,0,0,128,191,0,0,0,0,174,103,72,61,106,164,133,61,187,69,136,190,129,7,118,63,146,151,245,189,140,248,126,190,115,216,61,61,0,0,0,0,34,141,122,190,129,7,118,63,146,151,245,189,140,248,126,190,85,250,9,61,0,0,0,0,182,76,150,190,129,7,118,63,146,151,245,189,140,248,126,190,172,59,38,62,106,164,133,61,64,52,179,190,234,233,127,63,48,19,197,60,211,219,31,188,123,247,39,62,106,164,133,61,64,190,52,190,234,233,127,63,48,19,197,60,211,219,31,188,56,247,39,62,0,0,0,0,226,203,172,190,234,233,127,63,48,19,197,60,211,219,31,188,25,4,246,189,0,0,0,0,215,134,250,190,0,0,0,0,0,0,128,191,0,0,0,0,163,176,139,187,0,0,0,0,197,203,3,191,0,0,0,0,0,0,128,191,0,0,0,0,62,236,133,61,0,0,0,0,197,203,3,191,0,0,0,0,0,0,128,191,0,0,0,0,25,4,246,189,0,0,0,0,215,134,250,190,0,0,0,0,0,0,128,191,0,0,0,0,62,236,133,61,0,0,0,0,197,203,3,191,0,0,0,0,0,0,128,191,0,0,0,0,197,57,106,187,0,0,0,0,151,117,231,190,0,0,0,0,0,0,128,191,0,0,0,0,197,57,106,187,0,0,0,0,151,117,231,190,0,0,0,0,0,0,128,191,0,0,0,0,62,236,133,61,0,0,0,0,197,203,3,191,0,0,0,0,0,0,128,191,0,0,0,0,62,236,133,61,0,0,0,0,147,28,112,189,0,0,0,0,0,0,128,191,0,0,0,0,25,4,246,189,0,0,0,0,150,10,218,190,0,0,0,0,0,0,128,191,0,0,0,0,25,4,246,189,0,0,0,0,215,134,250,190,0,0,0,0,0,0,128,191,0,0,0,0,197,57,106,187,0,0,0,0,151,117,231,190,0,0,0,0,0,0,128,191,0,0,0,0,197,57,106,187,0,0,0,0,147,28,112,189,0,0,0,0,0,0,128,191,0,0,0,0,197,57,106,187,0,0,0,0,151,117,231,190,0,0,0,0,0,0,128,191,0,0,0,0,62,236,133,61,0,0,0,0,147,28,112,189,0,0,0,0,0,0,128,191,0,0,0,0,157,17,229,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,157,17,229,189,0,0,0,0,147,28,112,189,0,0,0,0,0,0,128,191,0,0,0,0,197,57,106,187,0,0,0,0,147,28,112,189,0,0,0,0,0,0,128,191,0,0,0,0,157,17,229,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,197,57,106,187,0,0,0,0,147,28,112,189,0,0,0,0,0,0,128,191,0,0,0,0,62,236,133,61,0,0,0,0,147,28,112,189,0,0,0,0,0,0,128,191,0,0,0,0,157,17,229,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,62,236,133,61,0,0,0,0,147,28,112,189,0,0,0,0,0,0,128,191,0,0,0,0,68,108,48,62,0,0,0,0,147,28,112,189,0,0,0,0,0,0,128,191,0,0,0,0,157,17,229,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,68,108,48,62,0,0,0,0,147,28,112,189,0,0,0,0,0,0,128,191,0,0,0,0,68,108,48,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,25,4,246,189,106,164,133,61,215,134,250,190,0,0,0,0,0,0,128,63,0,0,0,0,62,236,133,61,106,164,133,61,197,203,3,191,0,0,0,0,0,0,128,63,0,0,0,0,163,176,139,187,106,164,133,61,197,203,3,191,0,0,0,0,0,0,128,63,0,0,0,0,25,4,246,189,106,164,133,61,215,134,250,190,0,0,0,0,0,0,128,63,0,0,0,0,197,57,106,187,106,164,133,61,151,117,231,190,0,0,0,0,0,0,128,63,0,0,0,0,62,236,133,61,106,164,133,61,197,203,3,191,0,0,0,0,0,0,128,63,0,0,0,0,197,57,106,187,106,164,133,61,151,117,231,190,0,0,0,0,0,0,128,63,0,0,0,0,62,236,133,61,106,164,133,61,147,28,112,189,0,0,0,0,0,0,128,63,0,0,0,0,62,236,133,61,106,164,133,61,197,203,3,191,0,0,0,0,0,0,128,63,0,0,0,0,25,4,246,189,106,164,133,61,150,10,218,190,0,0,0,0,0,0,128,63,0,0,0,0,197,57,106,187,106,164,133,61,151,117,231,190,0,0,0,0,0,0,128,63,0,0,0,0,25,4,246,189,106,164,133,61,215,134,250,190,0,0,0,0,0,0,128,63,0,0,0,0,197,57,106,187,106,164,133,61,147,28,112,189,0,0,0,0,0,0,128,63,0,0,0,0,62,236,133,61,106,164,133,61,147,28,112,189,0,0,0,0,0,0,128,63,0,0,0,0,197,57,106,187,106,164,133,61,151,117,231,190,0,0,0,0,0,0,128,63,0,0,0,0,157,17,229,189,106,164,133,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,197,57,106,187,106,164,133,61,147,28,112,189,0,0,0,0,0,0,128,63,0,0,0,0,157,17,229,189,106,164,133,61,147,28,112,189,0,0,0,0,0,0,128,63,0,0,0,0,157,17,229,189,106,164,133,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,62,236,133,61,106,164,133,61,147,28,112,189,0,0,0,0,0,0,128,63,0,0,0,0,197,57,106,187,106,164,133,61,147,28,112,189,0,0,0,0,0,0,128,63,0,0,0,0,157,17,229,189,106,164,133,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,68,108,48,62,106,164,133,61,147,28,112,189,0,0,0,0,0,0,128,63,0,0,0,0,62,236,133,61,106,164,133,61,147,28,112,189,0,0,0,0,0,0,128,63,0,0,0,0,157,17,229,189,106,164,133,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,68,108,48,62,106,164,133,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,68,108,48,62,106,164,133,61,147,28,112,189,0,0,0,0,0,0,128,63,0,0,0,0,157,17,229,189,0,0,0,0,147,28,112,189,0,0,128,191,0,0,0,0,0,0,0,0,157,17,229,189,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,0,0,0,0,157,17,229,189,106,164,133,61,0,0,0,0,0,0,128,191,0,0,0,0,0,0,0,0,157,17,229,189,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,0,0,0,0,157,17,229,189,106,164,133,61,0,0,0,0,0,0,128,191,0,0,0,0,0,0,0,0,157,17,229,189,106,164,133,61,147,28,112,189,0,0,128,191,0,0,0,0,0,0,0,0,163,176,139,187,106,164,133,61,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,62,236,133,61,106,164,133,61,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,62,236,133,61,0,0,0,0,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,62,236,133,61,106,164,133,61,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,62,236,133,61,0,0,0,0,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,163,176,139,187,0,0,0,0,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,62,236,133,61,106,164,133,61,197,203,3,191,0,0,128,63,0,0,0,0,0,0,0,0,62,236,133,61,106,164,133,61,147,28,112,189,0,0,128,63,0,0,0,0,0,0,0,0,62,236,133,61,0,0,0,0,147,28,112,189,0,0,128,63,0,0,0,0,0,0,0,0,62,236,133,61,106,164,133,61,147,28,112,189,0,0,128,63,0,0,0,0,0,0,0,0,62,236,133,61,0,0,0,0,147,28,112,189,0,0,128,63,0,0,0,0,0,0,0,0,62,236,133,61,0,0,0,0,197,203,3,191,0,0,128,63,0,0,0,0,0,0,0,0,68,108,48,62,106,164,133,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,157,17,229,189,106,164,133,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,157,17,229,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,157,17,229,189,106,164,133,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,157,17,229,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,68,108,48,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,68,108,48,62,106,164,133,61,147,28,112,189,0,0,128,63,0,0,0,0,0,0,0,0,68,108,48,62,106,164,133,61,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,68,108,48,62,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,68,108,48,62,106,164,133,61,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,68,108,48,62,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,68,108,48,62,0,0,0,0,147,28,112,189,0,0,128,63,0,0,0,0,0,0,0,0,25,4,246,189,106,164,133,61,150,10,218,190,0,0,128,191,0,0,0,0,0,0,0,0,25,4,246,189,106,164,133,61,215,134,250,190,0,0,128,191,0,0,0,0,0,0,0,0,25,4,246,189,0,0,0,0,215,134,250,190,0,0,128,191,0,0,0,0,0,0,0,0,25,4,246,189,106,164,133,61,215,134,250,190,0,0,128,191,0,0,0,0,0,0,0,0,25,4,246,189,0,0,0,0,215,134,250,190,0,0,128,191,0,0,0,0,0,0,0,0,25,4,246,189,0,0,0,0,150,10,218,190,0,0,128,191,0,0,0,0,0,0,0,0,197,57,106,187,0,0,0,0,147,28,112,189,0,0,0,0,0,0,0,0,0,0,128,191,157,17,229,189,0,0,0,0,147,28,112,189,0,0,0,0,0,0,0,0,0,0,128,191,157,17,229,189,106,164,133,61,147,28,112,189,0,0,0,0,0,0,0,0,0,0,128,191,157,17,229,189,0,0,0,0,147,28,112,189,0,0,0,0,0,0,0,0,0,0,128,191,157,17,229,189,106,164,133,61,147,28,112,189,0,0,0,0,0,0,0,0,0,0,128,191,197,57,106,187,106,164,133,61,147,28,112,189,0,0,0,0,0,0,0,0,0,0,128,191,197,57,106,187,106,164,133,61,147,28,112,189,0,0,128,191,0,0,0,0,0,0,0,0,197,57,106,187,106,164,133,61,151,117,231,190,0,0,128,191,0,0,0,0,0,0,0,0,197,57,106,187,0,0,0,0,151,117,231,190,0,0,128,191,0,0,0,0,0,0,0,0,197,57,106,187,106,164,133,61,151,117,231,190,0,0,128,191,0,0,0,0,0,0,0,0,197,57,106,187,0,0,0,0,151,117,231,190,0,0,128,191,0,0,0,0,0,0,0,0,197,57,106,187,0,0,0,0,147,28,112,189,0,0,128,191,0,0,0,0,0,0,0,0,25,4,246,189,106,164,133,61,215,134,250,190,251,62,92,190,0,0,0,0,50,2,122,191,163,176,139,187,106,164,133,61,197,203,3,191,251,62,92,190,0,0,0,0,50,2,122,191,163,176,139,187,0,0,0,0,197,203,3,191,251,62,92,190,0,0,0,0,50,2,122,191,163,176,139,187,106,164,133,61,197,203,3,191,251,62,92,190,0,0,0,0,50,2,122,191,163,176,139,187,0,0,0,0,197,203,3,191,251,62,92,190,0,0,0,0,50,2,122,191,25,4,246,189,0,0,0,0,215,134,250,190,251,62,92,190,0,0,0,0,50,2,122,191,197,57,106,187,106,164,133,61,151,117,231,190,215,163,96,62,0,0,0,0,156,195,121,63,25,4,246,189,106,164,133,61,150,10,218,190,215,163,96,62,0,0,0,0,156,195,121,63,25,4,246,189,0,0,0,0,150,10,218,190,215,163,96,62,0,0,0,0,156,195,121,63,25,4,246,189,106,164,133,61,150,10,218,190,215,163,96,62,0,0,0,0,156,195,121,63,25,4,246,189,0,0,0,0,150,10,218,190,215,163,96,62,0,0,0,0,156,195,121,63,197,57,106,187,0,0,0,0,151,117,231,190,215,163,96,62,0,0,0,0,156,195,121,63,62,236,133,61,106,164,133,61,147,28,112,189,0,0,0,0,0,0,0,0,0,0,128,191,68,108,48,62,106,164,133,61,147,28,112,189,0,0,0,0,0,0,0,0,0,0,128,191,68,108,48,62,0,0,0,0,147,28,112,189,0,0,0,0,0,0,0,0,0,0,128,191,68,108,48,62,106,164,133,61,147,28,112,189,0,0,0,0,0,0,0,0,0,0,128,191,68,108,48,62,0,0,0,0,147,28,112,189,0,0,0,0,0,0,0,0,0,0,128,191,62,236,133,61,0,0,0,0,147,28,112,189,0,0,0,0,0,0,0,0,0,0,128,191,138,172,53,189,106,164,133,61])
.concat([72,194,6,191,222,199,209,61,178,18,243,188,64,138,126,191,190,193,23,61,0,0,0,0,25,29,4,191,222,199,209,61,178,18,243,188,64,138,126,191,41,149,48,189,0,0,0,0,75,58,6,191,222,199,209,61,178,18,243,188,64,138,126,191,199,184,98,61,0,0,0,0,81,135,165,190,0,0,0,0,0,0,128,191,0,0,0,0,214,168,7,62,0,0,0,0,136,188,173,190,0,0,0,0,0,0,128,191,0,0,0,0,123,133,165,61,0,0,0,0,108,92,127,190,0,0,0,0,0,0,128,191,0,0,0,0,91,210,49,190,0,0,0,0,218,225,111,189,0,0,0,0,0,0,128,191,0,0,0,0,107,127,199,189,0,0,0,0,147,28,112,189,0,0,0,0,0,0,128,191,0,0,0,0,91,210,49,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,159,230,132,61,0,0,0,0,216,126,194,190,0,0,0,0,0,0,128,191,0,0,0,0,164,23,53,61,0,0,0,0,59,140,225,190,0,0,0,0,0,0,128,191,0,0,0,0,36,72,5,62,0,0,0,0,154,148,218,190,0,0,0,0,0,0,128,191,0,0,0,0,91,210,49,190,0,0,0,0,218,225,111,189,0,0,0,0,0,0,128,191,0,0,0,0,86,240,91,186,0,0,0,0,138,87,121,190,0,0,0,0,0,0,128,191,0,0,0,0,123,133,165,61,0,0,0,0,108,92,127,190,0,0,0,0,0,0,128,191,0,0,0,0,242,206,49,190,106,164,133,61,115,44,111,189,0,0,0,0,0,0,128,63,0,0,0,0,8,119,199,189,106,164,133,61,147,28,112,189,0,0,0,0,0,0,128,63,0,0,0,0,239,228,83,61,106,164,133,61,176,143,94,190,0,0,0,0,0,0,128,63,0,0,0,0,113,28,248,60,106,164,133,61,224,101,230,190,141,183,149,190,148,131,89,187,41,207,116,63,15,128,184,188,106,164,133,61,109,170,238,190,141,183,149,190,148,131,89,187,41,207,116,63,4,229,182,188,0,0,0,0,81,192,238,190,141,183,149,190,148,131,89,187,41,207,116,63,113,28,248,60,106,164,133,61,224,101,230,190,0,0,0,0,0,0,128,191,189,55,134,53,76,51,13,62,106,164,133,61,139,81,207,190,0,0,0,0,0,0,128,191,189,55,134,53,15,128,184,188,106,164,133,61,109,170,238,190,0,0,0,0,0,0,128,191,189,55,134,53,35,159,215,189,0,0,0,0,209,204,3,191,0,0,0,0,0,0,128,191,0,0,0,0,41,149,48,189,0,0,0,0,75,58,6,191,0,0,0,0,0,0,128,191,0,0,0,0,190,193,23,61,0,0,0,0,25,29,4,191,0,0,0,0,0,0,128,191,0,0,0,0,91,210,49,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,139,113,14,62,0,0,0,0,147,28,112,189,0,0,0,0,0,0,128,191,0,0,0,0,139,113,14,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,15,128,184,188,106,164,133,61,109,170,238,190,112,9,192,61,45,234,19,187,13,223,126,63,71,175,166,189,0,0,0,0,41,231,235,190,112,9,192,61,45,234,19,187,13,223,126,63,4,229,182,188,0,0,0,0,81,192,238,190,112,9,192,61,45,234,19,187,13,223,126,63,86,240,91,186,0,0,0,0,138,87,121,190,0,0,0,0,0,0,128,191,0,0,0,0,199,184,98,61,0,0,0,0,81,135,165,190,0,0,0,0,0,0,128,191,0,0,0,0,123,133,165,61,0,0,0,0,108,92,127,190,0,0,0,0,0,0,128,191,0,0,0,0,139,113,14,62,106,164,133,61,147,28,112,189,0,0,128,63,0,0,0,0,0,0,0,0,139,113,14,62,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,139,113,14,62,0,0,0,0,147,28,112,189,0,0,128,63,0,0,0,0,0,0,0,0,91,210,49,190,106,164,133,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,139,113,14,62,106,164,133,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,139,113,14,62,106,164,133,61,147,28,112,189,0,0,0,0,0,0,128,63,0,0,0,0,91,210,49,190,106,164,133,61,0,0,0,0,0,0,128,191,0,0,0,0,156,83,201,182,91,210,49,190,0,0,0,0,218,225,111,189,0,0,128,191,0,0,0,0,156,83,201,182,91,210,49,190,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,156,83,201,182,15,128,184,188,106,164,133,61,109,170,238,190,0,0,0,0,0,0,128,63,0,0,0,0,230,202,224,61,106,164,133,61,208,180,236,190,0,0,0,0,0,0,128,63,0,0,0,0,202,55,187,61,106,164,133,61,226,115,247,190,0,0,0,0,0,0,128,63,0,0,0,0,244,52,128,61,106,164,133,61,165,218,175,190,142,2,124,191,164,193,109,61,67,254,41,190,159,230,132,61,0,0,0,0,216,126,194,190,142,2,124,191,164,193,109,61,67,254,41,190,199,184,98,61,0,0,0,0,81,135,165,190,142,2,124,191,164,193,109,61,67,254,41,190,230,202,224,61,106,164,133,61,208,180,236,190,134,173,101,63,242,150,43,61,88,29,225,190,76,51,13,62,106,164,133,61,139,81,207,190,134,173,101,63,242,150,43,61,88,29,225,190,36,72,5,62,0,0,0,0,154,148,218,190,134,173,101,63,242,150,43,61,88,29,225,190,117,89,44,190,106,164,133,61,132,214,251,190,0,0,0,0,0,0,128,63,0,0,0,0,96,115,14,61,106,164,133,61,2,46,4,191,0,0,0,0,0,0,128,63,0,0,0,0,138,172,53,189,106,164,133,61,72,194,6,191,0,0,0,0,0,0,128,63,0,0,0,0,91,210,49,190,106,164,133,61,0,0,0,0,0,0,128,191,89,133,77,57,139,225,106,185,242,206,49,190,106,164,133,61,115,44,111,189,0,0,128,191,89,133,77,57,139,225,106,185,91,210,49,190,0,0,0,0,218,225,111,189,0,0,128,191,89,133,77,57,139,225,106,185,227,22,115,61,106,164,133,61,22,132,210,190,98,162,113,191,180,203,151,61,201,201,164,62,164,23,53,61,0,0,0,0,59,140,225,190,98,162,113,191,180,203,151,61,201,201,164,62,159,230,132,61,0,0,0,0,216,126,194,190,98,162,113,191,180,203,151,61,201,201,164,62,202,55,187,61,106,164,133,61,226,115,247,190,172,82,6,63,126,169,31,188,87,234,89,191,172,253,189,61,0,0,0,0,135,164,246,190,172,82,6,63,126,169,31,188,87,234,89,191,190,193,23,61,0,0,0,0,25,29,4,191,172,82,6,63,126,169,31,188,87,234,89,191,139,113,14,62,106,164,133,61,147,28,112,189,0,0,128,63,0,0,0,0,0,0,0,0,139,113,14,62,106,164,133,61,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,139,113,14,62,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,91,210,49,190,106,164,133,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,8,119,199,189,106,164,133,61,147,28,112,189,0,0,0,0,0,0,128,63,0,0,0,0,242,206,49,190,106,164,133,61,115,44,111,189,0,0,0,0,0,0,128,63,0,0,0,0,76,51,13,62,106,164,133,61,139,81,207,190,132,99,126,63,85,249,222,189,120,209,215,188,214,168,7,62,0,0,0,0,136,188,173,190,132,99,126,63,85,249,222,189,120,209,215,188,36,72,5,62,0,0,0,0,154,148,218,190,132,99,126,63,85,249,222,189,120,209,215,188,139,113,14,62,106,164,133,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,91,210,49,190,106,164,133,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,91,210,49,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,138,172,53,189,106,164,133,61,72,194,6,191,13,85,1,62,230,93,245,57,48,243,125,191,96,115,14,61,106,164,133,61,2,46,4,191,13,85,1,62,230,93,245,57,48,243,125,191,190,193,23,61,0,0,0,0,25,29,4,191,13,85,1,62,230,93,245,57,48,243,125,191,97,139,45,190,0,0,0,0,174,15,251,190,0,0,0,0,0,0,128,191,0,0,0,0,35,159,215,189,0,0,0,0,209,204,3,191,0,0,0,0,0,0,128,191,0,0,0,0,190,193,23,61,0,0,0,0,25,29,4,191,0,0,0,0,0,0,128,191,0,0,0,0,80,24,244,61,106,164,133,61,73,134,156,190,6,42,75,63,176,3,103,61,43,22,27,63,239,228,83,61,106,164,133,61,176,143,94,190,6,42,75,63,176,3,103,61,43,22,27,63,123,133,165,61,0,0,0,0,108,92,127,190,6,42,75,63,176,3,103,61,43,22,27,63,227,22,115,61,106,164,133,61,22,132,210,190,0,0,0,0,0,0,128,63,0,0,0,0,76,51,13,62,106,164,133,61,139,81,207,190,0,0,0,0,0,0,128,63,0,0,0,0,113,28,248,60,106,164,133,61,224,101,230,190,0,0,0,0,0,0,128,63,0,0,0,0,244,52,128,61,106,164,133,61,165,218,175,190,151,55,127,191,96,233,124,189,240,53,68,61,227,22,115,61,106,164,133,61,22,132,210,190,151,55,127,191,96,233,124,189,240,53,68,61,159,230,132,61,0,0,0,0,216,126,194,190,151,55,127,191,96,233,124,189,240,53,68,61,97,139,45,190,0,0,0,0,174,15,251,190,0,0,0,0,0,0,128,191,0,0,0,0,190,193,23,61,0,0,0,0,25,29,4,191,0,0,0,0,0,0,128,191,0,0,0,0,172,253,189,61,0,0,0,0,135,164,246,190,0,0,0,0,0,0,128,191,0,0,0,0,96,115,14,61,106,164,133,61,2,46,4,191,40,238,0,63,154,66,103,60,33,34,93,191,202,55,187,61,106,164,133,61,226,115,247,190,40,238,0,63,154,66,103,60,33,34,93,191,190,193,23,61,0,0,0,0,25,29,4,191,40,238,0,63,154,66,103,60,33,34,93,191,60,136,45,190,106,164,133,61,55,23,215,190,0,0,0,0,0,0,128,63,0,0,0,0,101,114,170,189,106,164,133,61,38,166,235,190,0,0,0,0,0,0,128,63,0,0,0,0,117,89,44,190,106,164,133,61,132,214,251,190,0,0,0,0,0,0,128,63,0,0,0,0,202,55,187,61,106,164,133,61,226,115,247,190,85,189,64,63,0,0,0,0,82,124,40,191,230,202,224,61,106,164,133,61,208,180,236,190,85,189,64,63,0,0,0,0,82,124,40,191,230,202,224,61,0,0,0,0,208,180,236,190,85,189,64,63,0,0,0,0,82,124,40,191,101,114,170,189,106,164,133,61,38,166,235,190,0,0,0,0,0,0,128,63,0,0,0,0,15,128,184,188,106,164,133,61,109,170,238,190,0,0,0,0,0,0,128,63,0,0,0,0,117,89,44,190,106,164,133,61,132,214,251,190,0,0,0,0,0,0,128,63,0,0,0,0,101,114,170,189,106,164,133,61,38,166,235,190,34,56,214,62,62,207,159,59,35,131,104,63,189,114,45,190,0,0,0,0,7,38,215,190,34,56,214,62,62,207,159,59,35,131,104,63,71,175,166,189,0,0,0,0,41,231,235,190,34,56,214,62,62,207,159,59,35,131,104,63,242,206,49,190,106,164,133,61,115,44,111,189,0,0,0,0,0,0,128,63,0,0,0,0,239,228,83,61,106,164,133,61,176,143,94,190,0,0,0,0,0,0,128,63,0,0,0,0,45,35,117,60,106,164,133,61,78,240,133,190,0,0,0,0,0,0,128,63,0,0,0,0,91,210,49,190,106,164,133,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,139,113,14,62,106,164,133,61,147,28,112,189,0,0,0,0,0,0,128,63,0,0,0,0,8,119,199,189,106,164,133,61,147,28,112,189,0,0,0,0,0,0,128,63,0,0,0,0,189,114,45,190,0,0,0,0,7,38,215,190,0,0,0,0,0,0,128,191,0,0,0,0,97,139,45,190,0,0,0,0,174,15,251,190,0,0,0,0,0,0,128,191,0,0,0,0,71,175,166,189,0,0,0,0,41,231,235,190,0,0,0,0,0,0,128,191,0,0,0,0,117,89,44,190,106,164,133,61,132,214,251,190,39,246,136,190,131,52,163,61,86,211,117,191,138,172,53,189,106,164,133,61,72,194,6,191,39,246,136,190,131,52,163,61,86,211,117,191,35,159,215,189,0,0,0,0,209,204,3,191,39,246,136,190,131,52,163,61,86,211,117,191,45,35,117,60,106,164,133,61,78,240,133,190,69,41,81,191,95,179,28,61,233,71,19,191,199,184,98,61,0,0,0,0,81,135,165,190,69,41,81,191,95,179,28,61,233,71,19,191,86,240,91,186,0,0,0,0,138,87,121,190,69,41,81,191,95,179,28,61,233,71,19,191,242,206,49,190,106,164,133,61,115,44,111,189,220,159,59,191,180,203,55,188,226,35,46,191,45,35,117,60,106,164,133,61,78,240,133,190,220,159,59,191,180,203,55,188,226,35,46,191,86,240,91,186,0,0,0,0,138,87,121,190,220,159,59,191,180,203,55,188,226,35,46,191,202,55,187,61,106,164,133,61,226,115,247,190,74,153,64,63,187,43,187,185,122,165,40,191,230,202,224,61,0,0,0,0,208,180,236,190,74,153,64,63,187,43,187,185,122,165,40,191,172,253,189,61,0,0,0,0,135,164,246,190,74,153,64,63,187,43,187,185,122,165,40,191,80,24,244,61,106,164,133,61,73,134,156,190,44,74,93,63,29,33,163,189,119,44,254,62,123,133,165,61,0,0,0,0,108,92,127,190,44,74,93,63,29,33,163,189,119,44,254,62,214,168,7,62,0,0,0,0,136,188,173,190,44,74,93,63,29,33,163,189,119,44,254,62,60,136,45,190,106,164,133,61,55,23,215,190,116,237,127,191,197,83,143,60,95,211,131,188,117,89,44,190,106,164,133,61,132,214,251,190,116,237,127,191,197,83,143,60,95,211,131,188,97,139,45,190,0,0,0,0,174,15,251,190,116,237,127,191,197,83,143,60,95,211,131,188,138,172,53,189,106,164,133,61,72,194,6,191,56,78,26,190,222,119,12,189,167,236,124,191,41,149,48,189,0,0,0,0,75,58,6,191,56,78,26,190,222,119,12,189,167,236,124,191,35,159,215,189,0,0,0,0,209,204,3,191,56,78,26,190,222,119,12,189,167,236,124,191,244,52,128,61,106,164,133,61,165,218,175,190,0,0,0,0,0,0,128,63,0,0,0,0,80,24,244,61,106,164,133,61,73,134,156,190,0,0,0,0,0,0,128,63,0,0,0,0,76,51,13,62,106,164,133,61,139,81,207,190,0,0,0,0,0,0,128,63,0,0,0,0,15,128,184,188,106,164,133,61,109,170,238,190,0,0,0,0,0,0,128,63,0,0,0,0,202,55,187,61,106,164,133,61,226,115,247,190,0,0,0,0,0,0,128,63,0,0,0,0,117,89,44,190,106,164,133,61,132,214,251,190,0,0,0,0,0,0,128,63,0,0,0,0,91,210,49,190,0,0,0,0,218,225,111,189,0,0,0,0,0,0,128,191,0,0,0,0,123,133,165,61,0,0,0,0,108,92,127,190,0,0,0,0,0,0,128,191,0,0,0,0,107,127,199,189,0,0,0,0,147,28,112,189,0,0,0,0,0,0,128,191,0,0,0,0,76,51,13,62,106,164,133,61,139,81,207,190,0,0,0,0,0,0,128,63,0,0,0,0,230,202,224,61,106,164,133,61,208,180,236,190,0,0,0,0,0,0,128,63,0,0,0,0,15,128,184,188,106,164,133,61,109,170,238,190,0,0,0,0,0,0,128,63,0,0,0,0,199,184,98,61,0,0,0,0,81,135,165,190,0,0,0,0,0,0,128,191,0,0,0,0,159,230,132,61,0,0,0,0,216,126,194,190,0,0,0,0,0,0,128,191,0,0,0,0,214,168,7,62,0,0,0,0,136,188,173,190,0,0,0,0,0,0,128,191,0,0,0,0,227,22,115,61,106,164,133,61,22,132,210,190,117,62,76,191,119,43,171,189,48,217,24,63,113,28,248,60,106,164,133,61,224,101,230,190,117,62,76,191,119,43,171,189,48,217,24,63,164,23,53,61,0,0,0,0,59,140,225,190,117,62,76,191,119,43,171,189,48,217,24,63,60,136,45,190,106,164,133,61,55,23,215,190,222,255,127,191,91,206,165,186,15,184,174,58,97,139,45,190,0,0,0,0,174,15,251,190,222,255,127,191,91,206,165,186,15,184,174,58,189,114,45,190,0,0,0,0,7,38,215,190,222,255,127,191,91,206,165,186,15,184,174,58,117,89,44,190,106,164,133,61,132,214,251,190,28,123,182,190,145,126,123,188,254,39,111,191,35,159,215,189,0,0,0,0,209,204,3,191,28,123,182,190,145,126,123,188,254,39,111,191,97,139,45,190,0,0,0,0,174,15,251,190,28,123,182,190,145,126,123,188,254,39,111,191,159,230,132,61,0,0,0,0,216,126,194,190,0,0,0,0,0,0,128,191,0,0,0,0,36,72,5,62,0,0,0,0,154,148,218,190,0,0,0,0,0,0,128,191,0,0,0,0,214,168,7,62,0,0,0,0,136,188,173,190,0,0,0,0,0,0,128,191,0,0,0,0,45,35,117,60,106,164,133,61,78,240,133,190,240,223,92,191,185,253,114,189,102,135,0,191,244,52,128,61,106,164,133,61,165,218,175,190,240,223,92,191,185,253,114,189,102,135,0,191,199,184,98,61,0,0,0,0,81,135,165,190,240,223,92,191,185,253,114,189,102,135,0,191,45,35,117,60,106,164,133,61,78,240,133,190,0,0,0,0,0,0,128,63,0,0,0,0,80,24,244,61,106,164,133,61,73,134,156,190,0,0,0,0,0,0,128,63,0,0,0,0,244,52,128,61,106,164,133,61,165,218,175,190,0,0,0,0,0,0,128,63,0,0,0,0,71,175,166,189,0,0,0,0,41,231,235,190,0,0,0,0,0,0,128,191,0,0,0,0,97,139,45,190,0,0,0,0,174,15,251,190,0,0,0,0,0,0,128,191,0,0,0,0,4,229,182,188,0,0,0,0,81,192,238,190,0,0,0,0,0,0,128,191,0,0,0,0,4,229,182,188,0,0,0,0,81,192,238,190,0,0,0,0,0,0,128,191,0,0,0,0,97,139,45,190,0,0,0,0,174,15,251,190,0,0,0,0,0,0,128,191,0,0,0,0,172,253,189,61,0,0,0,0,135,164,246,190,0,0,0,0,0,0,128,191,0,0,0,0,139,113,14,62,0,0,0,0,147,28,112,189,189,55,134,53,0,0,0,0,0,0,128,191,8,119,199,189,106,164,133,61,147,28,112,189,189,55,134,53,0,0,0,0,0,0,128,191,139,113,14,62,106,164,133,61,147,28,112,189,189,55,134,53,0,0,0,0,0,0,128,191,113,28,248,60,106,164,133,61,224,101,230,190,15,182,184,190,153,44,110,61,186,75,110,63,4,229,182,188,0,0,0,0,81,192,238,190,15,182,184,190,153,44,110,61,186,75,110,63,164,23,53,61,0,0,0,0,59,140,225,190,15,182,184,190,153,44,110,61,186,75,110,63,4,229,182,188,0,0,0,0,81,192,238,190,0,0,0,0,0,0,128,191,0,0,0,0,172,253,189,61,0,0,0,0,135,164,246,190,0,0,0,0,0,0,128,191,0,0,0,0,230,202,224,61,0,0,0,0,208,180,236,190,0,0,0,0,0,0,128,191,0,0,0,0,239,228,83,61,106,164,133,61,176,143,94,190,92,143,58,63,158,10,56,188,182,71,47,63,8,119,199,189,106,164,133,61,147,28,112,189,92,143,58,63,158,10,56,188,182,71,47,63,123,133,165,61,0,0,0,0,108,92,127,190,92,143,58,63,158,10,56,188,182,71,47,63,230,202,224,61,106,164,133,61,208,180,236,190,179,209,93,63,0,0,0,0,82,152,255,190,36,72,5,62,0,0,0,0,154,148,218,190,179,209,93,63,0,0,0,0,82,152,255,190,230,202,224,61,0,0,0,0,208,180,236,190,179,209,93,63,0,0,0,0,82,152,255,190,139,113,14,62,0,0,0,0,147,28,112,189,189,55,134,53,0,0,0,0,0,0,128,191,107,127,199,189,0,0,0,0,147,28,112,189,189,55,134,53,0,0,0,0,0,0,128,191,8,119,199,189,106,164,133,61,147,28,112,189,189,55,134,53,0,0,0,0,0,0,128,191,8,119,199,189,106,164,133,61,147,28,112,189,61,14,59,63,19,153,57,185,88,198,46,63,107,127,199,189,0,0,0,0,147,28,112,189,61,14,59,63,19,153,57,185,88,198,46,63,123,133,165,61,0,0,0,0,108,92,127,190,61,14,59,63,19,153,57,185,88,198,46,63,242,206,49,190,106,164,133,61,115,44,111,189,57,11,59,191,178,184,255,58,92,201,46,191,86,240,91,186,0,0,0,0,138,87,121,190,57,11,59,191,178,184,255,58,92,201,46,191,91,210,49,190,0,0,0,0,218,225,111,189,57,11,59,191,178,184,255,58,92,201,46,191,4,229,182,188,0,0,0,0,81,192,238,190,0,0,0,0,0,0,128,191,0,0,0,0,230,202,224,61,0,0,0,0,208,180,236,190,0,0,0,0,0,0,128,191,0,0,0,0,36,72,5,62,0,0,0,0,154,148,218,190,0,0,0,0,0,0,128,191,0,0,0,0,164,23,53,61,0,0,0,0,59,140,225,190,0,0,0,0,0,0,128,191,0,0,0,0,4,229,182,188,0,0,0,0,81,192,238,190,0,0,0,0,0,0,128,191,0,0,0,0,36,72,5,62,0,0,0,0,154,148,218,190,0,0,0,0,0,0,128,191,0,0,0,0,45,35,117,60,106,164,133,61,78,240,133,190,0,0,0,0,0,0,128,63,0,0,0,0,239,228,83,61,106,164,133,61,176,143,94,190,0,0,0,0,0,0,128,63,0,0,0,0,80,24,244,61,106,164,133,61,73,134,156,190,0,0,0,0,0,0,128,63,0,0,0,0,117,89,44,190,106,164,133,61,132,214,251,190,0,0,0,0,0,0,128,63,0,0,0,0,202,55,187,61,106,164,133,61,226,115,247,190,0,0,0,0,0,0,128,63,0,0,0,0,96,115,14,61,106,164,133,61,2,46,4,191,0,0,0,0,0,0,128,63,0,0,0,0,139,113,14,62,106,164,133,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,91,210,49,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,139,113,14,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,91,210,49,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,107,127,199,189,0,0,0,0,147,28,112,189,0,0,0,0,0,0,128,191,0,0,0,0,139,113,14,62,0,0,0,0,147,28,112,189,0,0,0,0,0,0,128,191,0,0,0,0,76,51,13,62,106,164,133,61,139,81,207,190,22,51,122,63,8,86,213,61,100,174,60,62,80,24,244,61,106,164,133,61,73,134,156,190,22,51,122,63,8,86,213,61,100,174,60,62,214,168,7,62,0,0,0,0,136,188,173,190,22,51,122,63,8,86,213,61,100,174,60,62,15,128,184,188,106,164,133,61,109,170,238,190,131,220,197,61,206,194,158,187,163,204,126,63,101,114,170,189,106,164,133,61,38,166,235,190,131,220,197,61,206,194,158,187,163,204,126,63,71,175,166,189,0,0,0,0,41,231,235,190,131,220,197,61,206,194,158,187,163,204,126,63,101,114,170,189,106,164,133,61,38,166,235,190,80,28,216,62,184,147,136,186,219,19,104,63,60,136,45,190,106,164,133,61,55,23,215,190,80,28,216,62,184,147,136,186,219,19,104,63,189,114,45,190,0,0,0,0,7,38,215,190,80,28,216,62,184,147,136,186,219,19,104,63,244,52,128,61,106,164,133,61,165,218,175,190,0,0,0,0,0,0,128,63,0,0,0,0,76,51,13,62,106,164,133,61,139,81,207,190,0,0,0,0,0,0,128,63,0,0,0,0,227,22,115,61,106,164,133,61,22,132,210,190,0,0,0,0,0,0,128,63,0,0,0,0,243,56,12,189,106,164,133,61,99,42,125,190,0,0,0,0,0,0,128,63,0,0,0,0,241,73,199,61,106,164,133,61,230,116,121,190,0,0,0,0,0,0,128,63,0,0,0,0,139,107,60,61,106,164,133,61,5,110,141,190,0,0,0,0,0,0,128,63,0,0,0,0,250,43,100,189,106,164,133,61,152,109,39,60,0,0,0,0,0,0,128,63,0,0,0,0,181,194,244,60,106,164,133,61,21,168,69,59,0,0,0,0,0,0,128,63,0,0,0,0,157,76,252,189,106,164,133,61,183,42,9,59,0,0,0,0,0,0,128,63,0,0,0,0,168,29,62,190,106,164,133,61,206,168,121,188,0,0,0,0,0,0,128,63,0,0,0,0,193,112,174,189,106,164,133,61,195,157,75,189,0,0,0,0,0,0,128,63,0,0,0,0,83,151,60,190,106,164,133,61,217,34,169,189,0,0,0,0,0,0,128,63,0,0,0,0,181,194,244,60,106,164,133,61,21,168,69,59,246,152,200,61,10,215,35,188,144,193,126,63,230,36,84,189,0,0,0,0,145,96,42,60,246,152,200,61,10,215,35,188,144,193,126,63,167,232,8,61,0,0,0,0,251,202,3,59,246,152,200,61,10,215,35,188,144,193,126,63,220,157,53,61,106,164,133,61,130,60,3,191,61,215,19,63,50,118,66,188,43,249,80,191,108,205,182,61,0,0,0,0,107,183,245,190,61,215,19,63,50,118,66,188,43,249,80,191,160,51,41,61,0,0,0,0,227,138,3,191,61,215,19,63,50,118,66,188,43,249,80,191,213,66,137,61,106,164,133,61,148,218,235,189,66,90,127,191,209,235,143,189,194,217,45,60,132,183,135,61,106,164,133,61,149,130,62,190,66,90,127,191,209,235,143,189,194,217,45,60,178,15,146,61,0,0,0,0,180,204,18,190,66,90,127,191,209,235,143,189,194,217,45,60,169,21,198,189,0,0,0,0,33,120,124,190,0,0,0,0,0,0,128,191,0,0,0,0,73,102,53,61,0,0,0,0,131,166,141,190,0,0,0,0,0,0,128,191,0,0,0,0,233,129,15,189,0,0,0,0,72,80,124,190,0,0,0,0,0,0,128,191,0,0,0,0,169,21,198,189,106,164,133,61,194,138,155,190,94,16,145,188,162,38,122,187,65,245,127,191,183,238,102,188,106,164,133,61,132,74,156,190,94,16,145,188,162,38,122,187,65,245,127,191,68,249,130,188,0,0,0,0,141,37,156,190,94,16,145,188,162,38,122,187,65,245,127,191,90,243,99,61,0,0,0,0,170,12,83,190,0,0,0,0,0,0,128,191,0,0,0,0,200,8,40,59,0,0,0,0,94,45,119,190,0,0,0,0,0,0,128,191,0,0,0,0,43,23,234,61,0,0,0,0,122,139,103,190,0,0,0,0,0,0,128,191,0,0,0,0,169,21,198,189,0,0,0,0,33,120,124,190,0,0,0,0,0,0,128,191,0,0,0,0,68,249,130,188,0,0,0,0,141,37,156,190,0,0,0,0,0,0,128,191,0,0,0,0,182,161,194,61,0,0,0,0,19,240,155,190,0,0,0,0,0,0,128,191,0,0,0,0,243,56,12,189,106,164,133,61,99,42,125,190,185,223,33,187,202,111,81,60,110,250,127,63,169,21,198,189,0,0,0,0,33,120,124,190,185,223,33,187,202,111,81,60,110,250,127,63,233,129,15,189,0,0,0,0,72,80,124,190,185,223,33,187,202,111,81,60,110,250,127,63,138,57,56,190,0,0,0,0,152,19,52,188,0,0,0,0,0,0,128,191,0,0,0,0,159,228,14,190,0,0,0,0,6,190,130,189,0,0,0,0,0,0,128,191,0,0,0,0,173,104,51,189,0,0,0,0,92,171,61,189,0,0,0,0,0,0,128,191,0,0,0,0,213,66,137,61,106,164,133,61,148,218,235,189,153,101,119,191,70,12,59,61,52,134,129,190,178,15,146,61,0,0,0,0,180,204,18,190,153,101,119,191,70,12,59,61,52,134,129,190,220,46,116,61,0,0,0,0,246,7,202,189,153,101,119,191,70,12,59,61,52,134,129,190,182,161,194,61,0,0,0,0,19,240,155,190,0,0,0,0,0,0,128,191,0,0,0,0,73,102,53,61,0,0,0,0,131,166,141,190,0,0,0,0,0,0,128,191,0,0,0,0,169,21,198,189,0,0,0,0,33,120,124,190,0,0,0,0,0,0,128,191,0,0,0,0,138,57,56,190,0,0,0,0,152,19,52,188,0,0,0,0,0,0,128,191,0,0,0,0,193,142,255,61,0,0,0,0,8,57,143,189,0,0,0,0,0,0,128,191,0,0,0,0,107,43,182,61,0,0,0,0,238,150,228,188,0,0,0,0,0,0,128,191,0,0,0,0,182,162,45,190,0,0,0,0,104,231,0,191,0,0,0,0,0,0,128,191,0,0,0,0,146,89,61,189,0,0,0,0,204,94,6,191,0,0,0,0,0,0,128,191,0,0,0,0,160,51,41,61,0,0,0,0,227,138,3,191,0,0,0,0,0,0,128,191,0,0,0,0,233,129,15,189,0,0,0,0,72,80,124,190,0,0,0,0,0,0,128,191,0,0,0,0,73,102,53,61,0,0,0,0,131,166,141,190,0,0,0,0,0,0,128,191,0,0,0,0,241,73,199,61,0,0,0,0,230,116,121,190,0,0,0,0,0,0,128,191,0,0,0,0,133,38,9,61,106,164,133,61,230,88,166,190,140,16,86,191,89,247,15,60,250,97,12,191,163,2,103,61,0,0,0,0,13,198,184,190,140,16,86,191,89,247,15,60,250,97,12,191,233,71,3,61,0,0,0,0,122,195,165,190,140,16,86,191,89,247,15,60,250,97,12,191,169,21,198,189,106,164,133,61,33,120,124,190,0,0,0,0,0,0,128,63,0,0,0,0,139,107,60,61,106,164,133,61,5,110,141,190,0,0,0,0,0,0,128,63,0,0,0,0,15,71,183,61,106,164,133,61,210,28,153,190,0,0,0,0,0,0,128,63,0,0,0,0,45,147,225,58,106,164,133,61,189,57,92,189,240,25,249,190,193,59,57,189,213,91,95,191,14,45,50,61,106,164,133,61,53,211,157,189,240,25,249,190,193,59,57,189,213,91,95,191,138,233,2,61,0,0,0,0,69,184,137,189,240,25,249,190,193,59,57,189,213,91,95,191,11,210,236,61,106,164,133,61,121,176,101,190,171,38,108,63,199,244,4,188,35,161,197,190,35,19,16,62,0,0,0,0,111,243,38,190,171,38,108,63,199,244,4,188,35,161,197,190,43,23,234,61,0,0,0,0,122,139,103,190,171,38,108,63,199,244,4,188,35,161,197,190,108,205,182,61,106,164,133,61,107,183,245,190,252,140,75,63,0,0,0,0,112,64,27,191,157,161,248,61,0,0,0,0,167,35,224,190,252,140,75,63,0,0,0,0,112,64,27,191,108,205,182,61,0,0,0,0,107,183,245,190,252,140,75,63,0,0,0,0,112,64,27,191,202,250,141,189,106,164,133,61,112,178,237,190,4,56,109,62,165,48,239,188,133,236,120,63,150,151,44,190,106,164,133,61,7,152,225,190,4,56,109,62,165,48,239,188,133,236,120,63,133,207,150,189,0,0,0,0,153,44,238,190,4,56,109,62,165,48,239,188,133,236,120,63,169,21,198,189,106,164,133,61,33,120,124,190,0,0,0,0,0,0,128,63,0,0,0,0,183,238,102,188,106,164,133,61,132,74,156,190,0,0,0,0,0,0,128,63,0,0,0,0,169,21,198,189,106,164,133,61,194,138,155,190,0,0,0,0,0,0,128,63,0,0,0,0,19,102,10,62,106,164,133,61,249,20,192,189,93,53,123,63,71,203,193,189,136,190,43,62,193,142,255,61,0,0,0,0,8,57,143,189,93,53,123,63,71,203,193,189,136,190,43,62,35,19,16,62,0,0,0,0,111,243,38,190,93,53,123,63,71,203,193,189,136,190,43,62,202,250,141,189,106,164,133,61,112,178,237,190,0,0,0,0,0,0,128,63,0,0,0,0,220,157,53,61,106,164,133,61,130,60,3,191,0,0,0,0,0,0,128,63,0,0,0,0,252,254,45,190,106,164,133,61,196,179,0,191,0,0,0,0,0,0,128,63,0,0,0,0,157,76,252,189,106,164,133,61,183,42,9,59,233,97,40,190,103,124,95,189,247,32,124,63,138,57,56,190,0,0,0,0,152,19,52,188,233,97,40,190,103,124,95,189,247,32,124,63,230,36,84,189,0,0,0,0,145,96,42,60,233,97,40,190,103,124,95,189,247,32,124,63,14,45,50,61,106,164,133,61,53,211,157,189,0,0,0,0,0,0,128,63,0,0,0,0,19,102,10,62,106,164,133,61,249,20,192,189,0,0,0,0,0,0,128,63,0,0,0,0,213,66,137,61,106,164,133,61,148,218,235,189,0,0,0,0,0,0,128,63,0,0,0,0,243,56,12,189,106,164,133,61,99,42,125,190,0,0,0,0,0,0,128,63,0,0,0,0,11,210,236,61,106,164,133,61,121,176,101,190,0,0,0,0,0,0,128,63,0,0,0,0,241,73,199,61,106,164,133,61,230,116,121,190,0,0,0,0,0,0,128,63,0,0,0,0,14,45,50,61,106,164,133,61,53,211,157,189,192,175,89,191,164,225,20,189,40,101,6,191,213,66,137,61,106,164,133,61,148,218,235,189,192,175,89,191,164,225,20,189,40,101,6,191,220,46,116,61,0,0,0,0,246,7,202,189,192,175,89,191,164,225,20,189,40,101,6,191,3,233,194,61,106,164,133,61,235,139,4,189,175,209,242,62,40,10,116,60,201,88,97,63,167,232,8,61,0,0,0,0,251,202,3,59,175,209,242,62,40,10,116,60,201,88,97,63,107,43,182,61,0,0,0,0,238,150,228,188,175,209,242,62,40,10,116,60,201,88,97,63,243,56,12,189,106,164,133,61,99,42,125,190,7,66,50,60,0,0,0,0,34,252,127,63,169,21,198,189,106,164,133,61,33,120,124,190,7,66,50,60,0,0,0,0,34,252,127,63,169,21,198,189,0,0,0,0,33,120,124,190,7,66,50,60,0,0,0,0,34,252,127,63,133,38,9,61,106,164,133,61,230,88,166,190,253,161,89,191,233,185,5,188,142,201,6,191,241,184,104,61,106,164,133,61,10,163,185,190,253,161,89,191,233,185,5,188,142,201,6,191,163,2,103,61,0,0,0,0,13,198,184,190,253,161,89,191,233,185,5,188,142,201,6,191,152,80,65,188,106,164,133,61,168,196,237,190,93,50,142,188,4,231,140,59,132,245,127,63,133,207,150,189,0,0,0,0,153,44,238,190,93,50,142,188,4,231,140,59,132,245,127,63,236,76,33,188,0,0,0,0,128,155,237,190,93,50,142,188,4,231,140,59,132,245,127,63,3,233,194,61,106,164,133,61,235,139,4,189,140,186,66,63,154,66,231,188,150,6,38,63,107,43,182,61,0,0,0,0,238,150,228,188,140,186,66,63,154,66,231,188,150,6,38,63,193,142,255,61,0,0,0,0,8,57,143,189,140,186,66,63,154,66,231,188,150,6,38,63,241,184,104,61,106,164,133,61,10,163,185,190,19,213,127,191,136,105,223,187,232,135,17,61,85,107,97,61,106,164,133,61,55,81,211,190,19,213,127,191,136,105,223,187,232,135,17,61,233,125,99,61,0,0,0,0,55,113,210,190,19,213,127,191,136,105,223,187,232,135,17,61,193,58,46,190,0,0,0,0,1,81,224,190,0,0,0,0,0,0,128,191,0,0,0,0,182,162,45,190,0,0,0,0,104,231,0,191,0,0,0,0,0,0,128,191,0,0,0,0,133,207,150,189,0,0,0,0,153,44,238,190,0,0,0,0,0,0,128,191,0,0,0,0,193,112,174,189,106,164,133,61,195,157,75,189,0,0,0,0,0,0,128,63,0,0,0,0,3,233,194,61,106,164,133,61,235,139,4,189,0,0,0,0,0,0,128,63,0,0,0,0,45,147,225,58,106,164,133,61,189,57,92,189,0,0,0,0,0,0,128,63,0,0,0,0,168,29,62,190,106,164,133,61,206,168,121,188,0,0,0,0,0,0,128,63,0,0,0,0,3,233,194,61,106,164,133,61,235,139,4,189,0,0,0,0,0,0,128,63,0,0,0,0,193,112,174,189,106,164,133,61,195,157,75,189,0,0,0,0,0,0,128,63,0,0,0,0,52,75,66,189,106,164,133,61,33,118,6,191,43,52,0,62,124,213,74,187,9,252,125,191,160,51,41,61,0,0,0,0,227,138,3,191,43,52,0,62,124,213,74,187,9,252,125,191,146,89,61,189,0,0,0,0,204,94,6,191,43,52,0,62,124,213,74,187,9,252,125,191,220,46,116,61,0,0,0,0,246,7,202,189,0,0,0,0,0,0,128,191,0,0,0,0,178,15,146,61,0,0,0,0,180,204,18,190,0,0,0,0,0,0,128,191,0,0,0,0,35,19,16,62,0,0,0,0,111,243,38,190,0,0,0,0,0,0,128,191,0,0,0,0,178,187,0,61,106,164,133,61,33,228,228,190,41,151,190,190,203,160,218,187,158,152,109,63,152,80,65,188,106,164,133,61,168,196,237,190,41,151,190,190,203,160,218,187,158,152,109,63,236,76,33,188,0,0,0,0,128,155,237,190,41,151,190,190,203,160,218,187,158,152,109,63,183,238,102,188,106,164,133,61,132,74,156,190,222,113,186,190,57,241,213,59,202,106,110,191,233,71,3,61,0,0,0,0,122,195,165,190,222,113,186,190,57,241,213,59,202,106,110,191,68,249,130,188,0,0,0,0,141,37,156,190,222,113,186,190,57,241,213,59,202,106,110,191,132,183,135,61,106,164,133,61,149,130,62,190,121,117,62,191,240,133,169,189,249,189,41,63,170,96,212,60,106,164,133,61,202,220,108,190,121,117,62,191,240,133,169,189,249,189,41,63,90,243,99,61,0,0,0,0,170,12,83,190,121,117,62,191,240,133,169,189,249,189,41,63,150,151,44,190,106,164,133,61,7,152,225,190,79,234,127,191,255,230,197,60,236,49,17,188,182,162,45,190,0,0,0,0,104,231,0,191,79,234,127,191,255,230,197,60,236,49,17,188,193,58,46,190,0,0,0,0,1,81,224,190,79,234,127,191,255,230,197,60,236,49,17,188,183,238,102,188,106,164,133,61,132,74,156,190,180,91,195,190,81,130,254,187,182,159,108,191,133,38,9,61,106,164,133,61,230,88,166,190,180,91,195,190,81,130,254,187,182,159,108,191,233,71,3,61,0,0,0,0,122,195,165,190,180,91,195,190,81,130,254,187,182,159,108,191,133,38,9,61,106,164,133,61,230,88,166,190,0,0,0,0,0,0,128,63,0,0,0,0,15,71,183,61,106,164,133,61,210,28,153,190,0,0,0,0,0,0,128,63,0,0,0,0,99,42,253,61,106,164,133,61,62,203,179,190,0,0,0,0,0,0,128,63,0,0,0,0,150,151,44,190,106,164,133,61,7,152,225,190,77,50,138,62,211,76,247,60,145,96,118,63,193,58,46,190,0,0,0,0,1,81,224,190,77,50,138,62,211,76,247,60,145,96,118,63,133,207,150,189,0,0,0,0,153,44,238,190,77,50,138,62,211,76,247,60,145,96,118,63,213,66,137,61,106,164,133,61,148,218,235,189,0,0,0,0,0,0,128,63,0,0,0,0,19,102,10,62,106,164,133,61,249,20,192,189,0,0,0,0,0,0,128,63,0,0,0,0,132,183,135,61,106,164,133,61,149,130,62,190,0,0,0,0,0,0,128,63,0,0,0,0,241,184,104,61,106,164,133,61,10,163,185,190,220,244,127,191,205,92,224,59,204,96,140,60,233,125,99,61,0,0,0,0,55,113,210,190,220,244,127,191,205,92,224,59,204,96,140,60,163,2,103,61,0,0,0,0,13,198,184,190,220,244,127,191,205,92,224,59,204,96,140,60,220,157,53,61,106,164,133,61,130,60,3,191,236,191,22,63,0,0,0,0,58,232,78,191,108,205,182,61,106,164,133,61,107,183,245,190,236,191,22,63,0,0,0,0,58,232,78,191,108,205,182,61,0,0,0,0,107,183,245,190,236,191,22,63,0,0,0,0,58,232,78,191,133,207,150,189,0,0,0,0,153,44,238,190,0,0,0,0,0,0,128,191,0,0,0,0,182,162,45,190,0,0,0,0,104,231,0,191,0,0,0,0,0,0,128,191,0,0,0,0,160,51,41,61,0,0,0,0,227,138,3,191,0,0,0,0,0,0,128,191,0,0,0,0,169,21,198,189,106,164,133,61,33,120,124,190,0,0,128,191,0,0,0,0,0,0,0,0,169,21,198,189,0,0,0,0,194,138,155,190,0,0,128,191,0,0,0,0,0,0,0,0,169,21,198,189,0,0,0,0,33,120,124,190,0,0,128,191,0,0,0,0,0,0,0,0,193,112,174,189,106,164,133,61,195,157,75,189,253,79,62,189,170,183,166,189,114,223,126,191,45,147,225,58,106,164,133,61,189,57,92,189,253,79,62,189,170,183,166,189,114,223,126,191,173,104,51,189,0,0,0,0,92,171,61,189,253,79,62,189,170,183,166,189,114,223,126,191,133,207,150,189,0,0,0,0,153,44,238,190,0,0,0,0,0,0,128,191,0,0,0,0,160,51,41,61,0,0,0,0,227,138,3,191,0,0,0,0,0,0,128,191,0,0,0,0,108,205,182,61,0,0,0,0,107,183,245,190,0,0,0,0,0,0,128,191,0,0,0,0,220,46,116,61,0,0,0,0,246,7,202,189,0,0,0,0,0,0,128,191,0,0,0,0,35,19,16,62,0,0,0,0,111,243,38,190,0,0,0,0,0,0,128,191,0,0,0,0,193,142,255,61,0,0,0,0,8,57,143,189,0,0,0,0,0,0,128,191,0,0,0,0,241,184,104,61,106,164,133,61,10,163,185,190,0,0,0,0,0,0,128,63,0,0,0,0,56,159,250,61,106,164,133,61,134,199,222,190,0,0,0,0,0,0,128,63,0,0,0,0,85,107,97,61,106,164,133,61,55,81,211,190,0,0,0,0,0,0,128,63,0,0,0,0,202,250,141,189,106,164,133,61,112,178,237,190,0,0,0,0,0,0,128,63,0,0,0,0,56,159,250,61,106,164,133,61,134,199,222,190,0,0,0,0,0,0,128,63,0,0,0,0,108,205,182,61,106,164,133,61,107,183,245,190,0,0,0,0,0,0,128,63,0,0,0,0,202,250,141,189,106,164,133,61,112,178,237,190,0,0,0,0,0,0,128,63,0,0,0,0,108,205,182,61,106,164,133,61,107,183,245,190,0,0,0,0,0,0,128,63,0,0,0,0,220,157,53,61,106,164,133,61,130,60,3,191,0,0,0,0,0,0,128,63,0,0,0,0,157,76,252,189,106,164,133,61,183,42,9,59,235,197,136,190,182,47,32,61,82,126,118,63,168,29,62,190,106,164,133,61,206,168,121,188,235,197,136,190,182,47,32,61,82,126,118,63,138,57,56,190,0,0,0,0,152,19,52,188,235,197,136,190,182,47,32,61,82,126,118,63,133,207,150,189,0,0,0,0,153,44,238,190,0,0,0,0,0,0,128,191,0,0,0,0,108,205,182,61,0,0,0,0,107,183,245,190,0,0,0,0,0,0,128,191,0,0,0,0,157,161,248,61,0,0,0,0,167,35,224,190,0,0,0,0,0,0,128,191,0,0,0,0,133,207,150,189,0,0,0,0,153,44,238,190,0,0,0,0,0,0,128,63,0,0,0,0,157,161,248,61,0,0,0,0,167,35,224,190,0,0,0,0,0,0,128,63,0,0,0,0,236,76,33,188,0,0,0,0,128,155,237,190,0,0,0,0,0,0,128,63,0,0,0,0,85,107,97,61,106,164,133,61,55,81,211,190,126,143,86,191,80,25,255,59,148,160,11,63,63,88,6,61,0,0,0,0,168,85,228,190,126,143,86,191,80,25,255,59,148,160,11,63,233,125,99,61,0,0,0,0,55,113,210,190,126,143,86,191,80,25,255,59,148,160,11,63,170,96,212,60,106,164,133,61,202,220,108,190,248,196,130,190,66,179,107,189,10,18,119,63,243,56,12,189,106,164,133,61,99,42,125,190,248,196,130,190,66,179,107,189,10,18,119,63,200,8,40,59,0,0,0,0,94,45,119,190,248,196,130,190,66,179,107,189,10,18,119,63,168,29,62,190,106,164,133,61,206,168,121,188,0,0,0,0,0,0,128,63,0,0,0,0])
.concat([181,194,244,60,106,164,133,61,21,168,69,59,0,0,0,0,0,0,128,63,0,0,0,0,3,233,194,61,106,164,133,61,235,139,4,189,0,0,0,0,0,0,128,63,0,0,0,0,132,183,135,61,106,164,133,61,149,130,62,190,0,0,0,0,0,0,128,63,0,0,0,0,11,210,236,61,106,164,133,61,121,176,101,190,0,0,0,0,0,0,128,63,0,0,0,0,170,96,212,60,106,164,133,61,202,220,108,190,0,0,0,0,0,0,128,63,0,0,0,0,169,21,198,189,106,164,133,61,33,120,124,190,0,0,0,0,0,0,128,63,0,0,0,0,243,56,12,189,106,164,133,61,99,42,125,190,0,0,0,0,0,0,128,63,0,0,0,0,139,107,60,61,106,164,133,61,5,110,141,190,0,0,0,0,0,0,128,63,0,0,0,0,90,243,99,61,0,0,0,0,170,12,83,190,0,0,0,0,0,0,128,191,0,0,0,0,43,23,234,61,0,0,0,0,122,139,103,190,0,0,0,0,0,0,128,191,0,0,0,0,35,19,16,62,0,0,0,0,111,243,38,190,0,0,0,0,0,0,128,191,0,0,0,0,132,183,135,61,106,164,133,61,149,130,62,190,0,0,0,0,0,0,128,63,0,0,0,0,170,182,11,62,106,164,133,61,197,142,54,190,0,0,0,0,0,0,128,63,0,0,0,0,11,210,236,61,106,164,133,61,121,176,101,190,0,0,0,0,0,0,128,63,0,0,0,0,157,76,252,189,106,164,133,61,183,42,9,59,0,0,0,0,0,0,128,63,0,0,0,0,181,194,244,60,106,164,133,61,21,168,69,59,0,0,0,0,0,0,128,63,0,0,0,0,168,29,62,190,106,164,133,61,206,168,121,188,0,0,0,0,0,0,128,63,0,0,0,0,45,147,225,58,106,164,133,61,189,57,92,189,37,3,136,190,86,129,154,61,145,11,118,191,138,233,2,61,0,0,0,0,69,184,137,189,37,3,136,190,86,129,154,61,145,11,118,191,173,104,51,189,0,0,0,0,92,171,61,189,37,3,136,190,86,129,154,61,145,11,118,191,138,233,2,61,0,0,0,0,69,184,137,189,0,0,0,0,0,0,128,191,0,0,0,0,220,46,116,61,0,0,0,0,246,7,202,189,0,0,0,0,0,0,128,191,0,0,0,0,193,142,255,61,0,0,0,0,8,57,143,189,0,0,0,0,0,0,128,191,0,0,0,0,63,88,6,61,0,0,0,0,168,85,228,190,0,0,0,0,0,0,128,191,0,0,0,0,236,76,33,188,0,0,0,0,128,155,237,190,0,0,0,0,0,0,128,191,0,0,0,0,157,161,248,61,0,0,0,0,167,35,224,190,0,0,0,0,0,0,128,191,0,0,0,0,19,102,10,62,106,164,133,61,249,20,192,189,30,22,86,63,221,93,135,61,8,88,11,63,3,233,194,61,106,164,133,61,235,139,4,189,30,22,86,63,221,93,135,61,8,88,11,63,193,142,255,61,0,0,0,0,8,57,143,189,30,22,86,63,221,93,135,61,8,88,11,63,138,57,56,190,0,0,0,0,152,19,52,188,0,0,0,0,0,0,128,191,0,0,0,0,121,36,62,190,0,0,0,0,13,170,173,189,0,0,0,0,0,0,128,191,0,0,0,0,159,228,14,190,0,0,0,0,6,190,130,189,0,0,0,0,0,0,128,191,0,0,0,0,181,194,244,60,106,164,133,61,21,168,69,59,131,195,171,61,124,155,254,59,39,23,127,63,250,43,100,189,106,164,133,61,152,109,39,60,131,195,171,61,124,155,254,59,39,23,127,63,230,36,84,189,0,0,0,0,145,96,42,60,131,195,171,61,124,155,254,59,39,23,127,63,200,8,40,59,0,0,0,0,94,45,119,190,0,0,0,0,0,0,128,191,0,0,0,0,241,73,199,61,0,0,0,0,230,116,121,190,0,0,0,0,0,0,128,191,0,0,0,0,43,23,234,61,0,0,0,0,122,139,103,190,0,0,0,0,0,0,128,191,0,0,0,0,170,96,212,60,106,164,133,61,202,220,108,190,0,0,0,0,0,0,128,63,189,55,134,181,11,210,236,61,106,164,133,61,121,176,101,190,0,0,0,0,0,0,128,63,189,55,134,181,243,56,12,189,106,164,133,61,99,42,125,190,0,0,0,0,0,0,128,63,189,55,134,181,108,205,182,61,106,164,133,61,107,183,245,190,232,216,77,63,108,33,72,60,74,41,24,191,56,159,250,61,106,164,133,61,134,199,222,190,232,216,77,63,108,33,72,60,74,41,24,191,157,161,248,61,0,0,0,0,167,35,224,190,232,216,77,63,108,33,72,60,74,41,24,191,45,147,225,58,106,164,133,61,189,57,92,189,0,0,0,0,0,0,128,63,0,0,0,0,19,102,10,62,106,164,133,61,249,20,192,189,0,0,0,0,0,0,128,63,0,0,0,0,14,45,50,61,106,164,133,61,53,211,157,189,0,0,0,0,0,0,128,63,0,0,0,0,183,238,102,188,106,164,133,61,132,74,156,190,0,0,0,0,0,0,128,63,0,0,0,0,15,71,183,61,106,164,133,61,210,28,153,190,0,0,0,0,0,0,128,63,0,0,0,0,133,38,9,61,106,164,133,61,230,88,166,190,0,0,0,0,0,0,128,63,0,0,0,0,3,233,194,61,106,164,133,61,235,139,4,189,214,226,243,62,11,96,74,60,157,17,97,63,181,194,244,60,106,164,133,61,21,168,69,59,214,226,243,62,11,96,74,60,157,17,97,63,167,232,8,61,0,0,0,0,251,202,3,59,214,226,243,62,11,96,74,60,157,17,97,63,52,75,66,189,106,164,133,61,33,118,6,191,214,173,46,190,56,189,11,188,4,61,124,191,146,89,61,189,0,0,0,0,204,94,6,191,214,173,46,190,56,189,11,188,4,61,124,191,182,162,45,190,0,0,0,0,104,231,0,191,214,173,46,190,56,189,11,188,4,61,124,191,233,125,99,61,0,0,0,0,55,113,210,190,0,0,0,0,0,0,128,191,0,0,0,0,63,88,6,61,0,0,0,0,168,85,228,190,0,0,0,0,0,0,128,191,0,0,0,0,157,161,248,61,0,0,0,0,167,35,224,190,0,0,0,0,0,0,128,191,0,0,0,0,178,187,0,61,106,164,133,61,33,228,228,190,0,0,0,0,0,0,128,63,0,0,0,0,56,159,250,61,106,164,133,61,134,199,222,190,0,0,0,0,0,0,128,63,0,0,0,0,152,80,65,188,106,164,133,61,168,196,237,190,0,0,0,0,0,0,128,63,0,0,0,0,250,43,100,189,106,164,133,61,152,109,39,60,174,215,244,189,107,125,145,187,82,41,126,63,157,76,252,189,106,164,133,61,183,42,9,59,174,215,244,189,107,125,145,187,82,41,126,63,230,36,84,189,0,0,0,0,145,96,42,60,174,215,244,189,107,125,145,187,82,41,126,63,173,104,51,189,0,0,0,0,92,171,61,189,0,0,0,0,0,0,128,191,0,0,0,0,138,233,2,61,0,0,0,0,69,184,137,189,0,0,0,0,0,0,128,191,0,0,0,0,193,142,255,61,0,0,0,0,8,57,143,189,0,0,0,0,0,0,128,191,0,0,0,0,241,73,199,61,106,164,133,61,230,116,121,190,195,157,55,63,0,0,0,0,120,98,50,191,43,23,234,61,0,0,0,0,122,139,103,190,195,157,55,63,0,0,0,0,120,98,50,191,241,73,199,61,0,0,0,0,230,116,121,190,195,157,55,63,0,0,0,0,120,98,50,191,170,182,11,62,106,164,133,61,197,142,54,190,221,93,127,63,217,151,140,61,116,93,120,60,19,102,10,62,106,164,133,61,249,20,192,189,221,93,127,63,217,151,140,61,116,93,120,60,35,19,16,62,0,0,0,0,111,243,38,190,221,93,127,63,217,151,140,61,116,93,120,60,138,57,56,190,0,0,0,0,152,19,52,188,0,0,0,0,0,0,128,191,0,0,0,0,107,43,182,61,0,0,0,0,238,150,228,188,0,0,0,0,0,0,128,191,0,0,0,0,167,232,8,61,0,0,0,0,251,202,3,59,0,0,0,0,0,0,128,191,0,0,0,0,241,184,104,61,106,164,133,61,10,163,185,190,0,0,0,0,0,0,128,63,0,0,0,0,99,42,253,61,106,164,133,61,62,203,179,190,0,0,0,0,0,0,128,63,0,0,0,0,56,159,250,61,106,164,133,61,134,199,222,190,0,0,0,0,0,0,128,63,0,0,0,0,202,250,141,189,106,164,133,61,112,178,237,190,0,0,0,0,0,0,128,191,0,0,0,0,152,80,65,188,106,164,133,61,168,196,237,190,0,0,0,0,0,0,128,191,0,0,0,0,56,159,250,61,106,164,133,61,134,199,222,190,0,0,0,0,0,0,128,191,0,0,0,0,252,254,45,190,106,164,133,61,196,179,0,191,0,0,0,0,0,0,128,63,0,0,0,0,220,157,53,61,106,164,133,61,130,60,3,191,0,0,0,0,0,0,128,63,0,0,0,0,52,75,66,189,106,164,133,61,33,118,6,191,0,0,0,0,0,0,128,63,0,0,0,0,85,107,97,61,106,164,133,61,55,81,211,190,36,237,82,191,215,190,0,188,254,14,17,63,178,187,0,61,106,164,133,61,33,228,228,190,36,237,82,191,215,190,0,188,254,14,17,63,63,88,6,61,0,0,0,0,168,85,228,190,36,237,82,191,215,190,0,188,254,14,17,63,169,21,198,189,106,164,133,61,194,138,155,190,128,153,111,188,0,0,0,0,253,248,127,191,68,249,130,188,0,0,0,0,141,37,156,190,128,153,111,188,0,0,0,0,253,248,127,191,169,21,198,189,0,0,0,0,194,138,155,190,128,153,111,188,0,0,0,0,253,248,127,191,163,2,103,61,0,0,0,0,13,198,184,190,0,0,0,0,0,0,128,191,0,0,0,0,233,125,99,61,0,0,0,0,55,113,210,190,0,0,0,0,0,0,128,191,0,0,0,0,157,161,248,61,0,0,0,0,167,35,224,190,0,0,0,0,0,0,128,191,0,0,0,0,163,2,103,61,0,0,0,0,13,198,184,190,0,0,0,0,0,0,128,191,0,0,0,0,157,161,248,61,0,0,0,0,167,35,224,190,0,0,0,0,0,0,128,191,0,0,0,0,78,65,254,61,0,0,0,0,54,200,180,190,0,0,0,0,0,0,128,191,0,0,0,0,230,36,84,189,0,0,0,0,145,96,42,60,0,0,0,0,0,0,128,191,0,0,0,0,138,57,56,190,0,0,0,0,152,19,52,188,0,0,0,0,0,0,128,191,0,0,0,0,167,232,8,61,0,0,0,0,251,202,3,59,0,0,0,0,0,0,128,191,0,0,0,0,193,112,174,189,106,164,133,61,195,157,75,189,185,23,56,62,252,139,128,61,227,80,123,191,173,104,51,189,0,0,0,0,92,171,61,189,185,23,56,62,252,139,128,61,227,80,123,191,159,228,14,190,0,0,0,0,6,190,130,189,185,23,56,62,252,139,128,61,227,80,123,191,83,151,60,190,106,164,133,61,217,34,169,189,71,174,211,62,137,234,173,60,95,8,105,191,159,228,14,190,0,0,0,0,6,190,130,189,71,174,211,62,137,234,173,60,95,8,105,191,121,36,62,190,0,0,0,0,13,170,173,189,71,174,211,62,137,234,173,60,95,8,105,191,15,71,183,61,106,164,133,61,210,28,153,190,231,142,246,62,145,184,7,189,148,51,96,63,73,102,53,61,0,0,0,0,131,166,141,190,231,142,246,62,145,184,7,189,148,51,96,63,182,161,194,61,0,0,0,0,19,240,155,190,231,142,246,62,145,184,7,189,148,51,96,63,168,29,62,190,106,164,133,61,206,168,121,188,51,221,127,191,14,78,196,60,221,6,181,188,83,151,60,190,106,164,133,61,217,34,169,189,51,221,127,191,14,78,196,60,221,6,181,188,121,36,62,190,0,0,0,0,13,170,173,189,51,221,127,191,14,78,196,60,221,6,181,188,11,210,236,61,106,164,133,61,121,176,101,190,235,30,105,63,152,79,22,189,148,188,210,190,170,182,11,62,106,164,133,61,197,142,54,190,235,30,105,63,152,79,22,189,148,188,210,190,35,19,16,62,0,0,0,0,111,243,38,190,235,30,105,63,152,79,22,189,148,188,210,190,45,147,225,58,106,164,133,61,189,57,92,189,0,0,0,0,0,0,128,63,0,0,0,0,3,233,194,61,106,164,133,61,235,139,4,189,0,0,0,0,0,0,128,63,0,0,0,0,19,102,10,62,106,164,133,61,249,20,192,189,0,0,0,0,0,0,128,63,0,0,0,0,56,159,250,61,106,164,133,61,134,199,222,190,144,215,127,63,131,80,94,188,64,190,4,189,78,65,254,61,0,0,0,0,54,200,180,190,144,215,127,63,131,80,94,188,64,190,4,189,157,161,248,61,0,0,0,0,167,35,224,190,144,215,127,63,131,80,94,188,64,190,4,189,241,73,199,61,0,0,0,0,230,116,121,190,26,107,7,63,58,177,7,188,134,61,89,191,73,102,53,61,0,0,0,0,131,166,141,190,26,107,7,63,58,177,7,188,134,61,89,191,139,107,60,61,106,164,133,61,5,110,141,190,26,107,7,63,58,177,7,188,134,61,89,191,99,42,253,61,106,164,133,61,62,203,179,190,123,131,91,63,188,206,6,188,150,179,3,63,182,161,194,61,0,0,0,0,19,240,155,190,123,131,91,63,188,206,6,188,150,179,3,63,78,65,254,61,0,0,0,0,54,200,180,190,123,131,91,63,188,206,6,188,150,179,3,63,252,254,45,190,106,164,133,61,196,179,0,191,190,250,56,190,28,154,50,60,223,197,123,191,52,75,66,189,106,164,133,61,33,118,6,191,190,250,56,190,28,154,50,60,223,197,123,191,182,162,45,190,0,0,0,0,104,231,0,191,190,250,56,190,28,154,50,60,223,197,123,191,241,73,199,61,106,164,133,61,230,116,121,190,51,169,57,63,17,84,141,59,142,64,48,191,11,210,236,61,106,164,133,61,121,176,101,190,51,169,57,63,17,84,141,59,142,64,48,191,43,23,234,61,0,0,0,0,122,139,103,190,51,169,57,63,17,84,141,59,142,64,48,191,150,151,44,190,106,164,133,61,7,152,225,190,7,239,127,191,6,44,185,187,176,172,180,60,252,254,45,190,106,164,133,61,196,179,0,191,7,239,127,191,6,44,185,187,176,172,180,60,182,162,45,190,0,0,0,0,104,231,0,191,7,239,127,191,6,44,185,187,176,172,180,60,233,71,3,61,0,0,0,0,122,195,165,190,0,0,0,0,0,0,128,191,0,0,0,0,163,2,103,61,0,0,0,0,13,198,184,190,0,0,0,0,0,0,128,191,0,0,0,0,78,65,254,61,0,0,0,0,54,200,180,190,0,0,0,0,0,0,128,191,0,0,0,0,52,75,66,189,106,164,133,61,33,118,6,191,45,64,11,62,150,231,65,60,149,154,125,191,220,157,53,61,106,164,133,61,130,60,3,191,45,64,11,62,150,231,65,60,149,154,125,191,160,51,41,61,0,0,0,0,227,138,3,191,45,64,11,62,150,231,65,60,149,154,125,191,168,29,62,190,106,164,133,61,206,168,121,188,41,89,126,191,222,2,169,189,143,84,159,61,121,36,62,190,0,0,0,0,13,170,173,189,41,89,126,191,222,2,169,189,143,84,159,61,138,57,56,190,0,0,0,0,152,19,52,188,41,89,126,191,222,2,169,189,143,84,159,61,139,107,60,61,106,164,133,61,5,110,141,190,79,89,9,63,0,0,0,0,11,9,88,191,241,73,199,61,106,164,133,61,230,116,121,190,79,89,9,63,0,0,0,0,11,9,88,191,241,73,199,61,0,0,0,0,230,116,121,190,79,89,9,63,0,0,0,0,11,9,88,191,243,56,12,189,106,164,133,61,99,42,125,190,234,94,7,190,241,187,105,60,27,186,125,63,233,129,15,189,0,0,0,0,72,80,124,190,234,94,7,190,241,187,105,60,27,186,125,63,200,8,40,59,0,0,0,0,94,45,119,190,234,94,7,190,241,187,105,60,27,186,125,63,169,21,198,189,106,164,133,61,33,120,124,190,0,0,0,0,0,0,128,63,0,0,0,0,15,71,183,61,106,164,133,61,210,28,153,190,0,0,0,0,0,0,128,63,0,0,0,0,183,238,102,188,106,164,133,61,132,74,156,190,0,0,0,0,0,0,128,63,0,0,0,0,233,71,3,61,0,0,0,0,122,195,165,190,0,0,0,0,0,0,128,191,0,0,0,0,78,65,254,61,0,0,0,0,54,200,180,190,0,0,0,0,0,0,128,191,0,0,0,0,182,161,194,61,0,0,0,0,19,240,155,190,0,0,0,0,0,0,128,191,0,0,0,0,152,80,65,188,106,164,133,61,168,196,237,190,50,203,30,59,28,179,108,188,253,248,127,63,202,250,141,189,106,164,133,61,112,178,237,190,50,203,30,59,28,179,108,188,253,248,127,63,133,207,150,189,0,0,0,0,153,44,238,190,50,203,30,59,28,179,108,188,253,248,127,63,178,187,0,61,106,164,133,61,33,228,228,190,100,35,200,190,141,179,233,59,220,159,107,63,236,76,33,188,0,0,0,0,128,155,237,190,100,35,200,190,141,179,233,59,220,159,107,63,63,88,6,61,0,0,0,0,168,85,228,190,100,35,200,190,141,179,233,59,220,159,107,63,133,38,9,61,106,164,133,61,230,88,166,190,0,0,0,0,0,0,128,63,0,0,0,0,99,42,253,61,106,164,133,61,62,203,179,190,0,0,0,0,0,0,128,63,0,0,0,0,241,184,104,61,106,164,133,61,10,163,185,190,0,0,0,0,0,0,128,63,0,0,0,0,85,107,97,61,106,164,133,61,55,81,211,190,0,0,0,0,0,0,128,63,0,0,0,0,56,159,250,61,106,164,133,61,134,199,222,190,0,0,0,0,0,0,128,63,0,0,0,0,178,187,0,61,106,164,133,61,33,228,228,190,0,0,0,0,0,0,128,63,0,0,0,0,138,57,56,190,0,0,0,0,152,19,52,188,0,0,0,0,0,0,128,191,0,0,0,0,173,104,51,189,0,0,0,0,92,171,61,189,0,0,0,0,0,0,128,191,0,0,0,0,193,142,255,61,0,0,0,0,8,57,143,189,0,0,0,0,0,0,128,191,0,0,0,0,170,96,212,60,106,164,133,61,202,220,108,190,209,90,13,191,31,45,142,61,205,177,84,63,200,8,40,59,0,0,0,0,94,45,119,190,209,90,13,191,31,45,142,61,205,177,84,63,90,243,99,61,0,0,0,0,170,12,83,190,209,90,13,191,31,45,142,61,205,177,84,63,14,45,50,61,106,164,133,61,53,211,157,189,155,3,64,191,126,56,8,61,5,25,41,191,220,46,116,61,0,0,0,0,246,7,202,189,155,3,64,191,126,56,8,61,5,25,41,191,138,233,2,61,0,0,0,0,69,184,137,189,155,3,64,191,126,56,8,61,5,25,41,191,200,8,40,59,0,0,0,0,94,45,119,190,0,0,0,0,0,0,128,191,0,0,0,0,233,129,15,189,0,0,0,0,72,80,124,190,0,0,0,0,0,0,128,191,0,0,0,0,241,73,199,61,0,0,0,0,230,116,121,190,0,0,0,0,0,0,128,191,0,0,0,0,68,249,130,188,0,0,0,0,141,37,156,190,0,0,0,0,0,0,128,191,0,0,0,0,233,71,3,61,0,0,0,0,122,195,165,190,0,0,0,0,0,0,128,191,0,0,0,0,182,161,194,61,0,0,0,0,19,240,155,190,0,0,0,0,0,0,128,191,0,0,0,0,139,107,60,61,106,164,133,61,5,110,141,190,136,215,237,62,251,229,147,188,173,167,98,63,73,102,53,61,0,0,0,0,131,166,141,190,136,215,237,62,251,229,147,188,173,167,98,63,15,71,183,61,106,164,133,61,210,28,153,190,136,215,237,62,251,229,147,188,173,167,98,63,150,151,44,190,106,164,133,61,7,152,225,190,0,0,0,0,0,0,128,63,0,0,0,0,202,250,141,189,106,164,133,61,112,178,237,190,0,0,0,0,0,0,128,63,0,0,0,0,252,254,45,190,106,164,133,61,196,179,0,191,0,0,0,0,0,0,128,63,0,0,0,0,132,183,135,61,106,164,133,61,149,130,62,190,0,0,0,0,0,0,128,63,0,0,0,0,19,102,10,62,106,164,133,61,249,20,192,189,0,0,0,0,0,0,128,63,0,0,0,0,170,182,11,62,106,164,133,61,197,142,54,190,0,0,0,0,0,0,128,63,0,0,0,0,178,15,146,61,0,0,0,0,180,204,18,190,0,0,0,0,0,0,128,191,0,0,0,0,90,243,99,61,0,0,0,0,170,12,83,190,0,0,0,0,0,0,128,191,0,0,0,0,35,19,16,62,0,0,0,0,111,243,38,190,0,0,0,0,0,0,128,191,0,0,0,0,132,183,135,61,106,164,133,61,149,130,62,190,224,131,119,191,95,38,170,61,97,56,119,62,90,243,99,61,0,0,0,0,170,12,83,190,224,131,119,191,95,38,170,61,97,56,119,62,178,15,146,61,0,0,0,0,180,204,18,190,224,131,119,191,95,38,170,61,97,56,119,62,56,159,250,61,106,164,133,61,134,199,222,190,111,246,127,63,175,180,12,60,37,90,114,188,99,42,253,61,106,164,133,61,62,203,179,190,111,246,127,63,175,180,12,60,37,90,114,188,78,65,254,61,0,0,0,0,54,200,180,190,111,246,127,63,175,180,12,60,37,90,114,188,169,21,198,189,106,164,133,61,33,120,124,190,0,0,128,191,0,0,0,0,0,0,0,0,169,21,198,189,106,164,133,61,194,138,155,190,0,0,128,191,0,0,0,0,0,0,0,0,169,21,198,189,0,0,0,0,194,138,155,190,0,0,128,191,0,0,0,0,0,0,0,0,99,42,253,61,106,164,133,61,62,203,179,190,101,25,86,63,181,196,202,60,93,52,12,63,15,71,183,61,106,164,133,61,210,28,153,190,101,25,86,63,181,196,202,60,93,52,12,63,182,161,194,61,0,0,0,0,19,240,155,190,101,25,86,63,181,196,202,60,93,52,12,63,83,151,60,190,106,164,133,61,217,34,169,189,185,26,161,62,144,136,105,189,214,142,114,191,193,112,174,189,106,164,133,61,195,157,75,189,185,26,161,62,144,136,105,189,214,142,114,191,159,228,14,190,0,0,0,0,6,190,130,189,185,26,161,62,144,136,105,189,214,142,114,191,169,21,198,189,0,0,0,0,33,120,124,190,0,0,0,0,0,0,128,191,0,0,0,0,169,21,198,189,0,0,0,0,194,138,155,190,0,0,0,0,0,0,128,191,0,0,0,0,68,249,130,188,0,0,0,0,141,37,156,190,0,0,0,0,0,0,128,191,0,0,0,0,87,233,238,187,0,0,0,0,197,203,3,191,0,0,0,0,0,0,128,191,0,0,0,0,161,244,133,59,0,0,0,0,38,27,231,190,0,0,0,0,0,0,128,191,0,0,0,0,214,83,91,190,0,0,0,0,221,37,65,190,0,0,0,0,0,0,128,191,0,0,0,0,161,244,133,59,0,0,0,0,38,27,231,190,0,0,0,0,0,0,128,191,0,0,0,0,87,233,238,187,0,0,0,0,197,203,3,191,0,0,0,0,0,0,128,191,0,0,0,0,55,82,150,61,0,0,0,0,197,203,3,191,0,0,0,0,0,0,128,191,0,0,0,0,161,244,133,59,0,0,0,0,38,27,231,190,0,0,0,0,0,0,128,191,0,0,0,0,55,82,150,61,0,0,0,0,197,203,3,191,0,0,0,0,0,0,128,191,0,0,0,0,55,82,150,61,0,0,0,0,10,157,55,190,0,0,0,0,0,0,128,191,0,0,0,0,214,83,91,190,0,0,0,0,221,37,65,190,0,0,0,0,0,0,128,191,0,0,0,0,161,244,133,59,0,0,0,0,38,27,231,190,0,0,0,0,0,0,128,191,0,0,0,0,243,31,34,190,0,0,0,0,10,157,55,190,0,0,0,0,0,0,128,191,0,0,0,0,161,244,133,59,0,0,0,0,10,157,55,190,0,0,0,0,0,0,128,191,0,0,0,0,161,244,133,59,0,0,0,0,38,27,231,190,0,0,0,0,0,0,128,191,0,0,0,0,55,82,150,61,0,0,0,0,10,157,55,190,0,0,0,0,0,0,128,191,0,0,0,0,214,83,91,190,0,0,0,0,18,105,251,189,0,0,0,0,0,0,128,191,0,0,0,0,214,83,91,190,0,0,0,0,221,37,65,190,0,0,0,0,0,0,128,191,0,0,0,0,243,31,34,190,0,0,0,0,10,157,55,190,0,0,0,0,0,0,128,191,0,0,0,0,214,83,91,190,0,0,0,0,18,105,251,189,0,0,0,0,0,0,128,191,0,0,0,0,243,31,34,190,0,0,0,0,10,157,55,190,0,0,0,0,0,0,128,191,0,0,0,0,161,244,133,59,0,0,0,0,10,157,55,190,0,0,0,0,0,0,128,191,0,0,0,0,214,83,91,190,0,0,0,0,18,105,251,189,0,0,0,0,0,0,128,191,0,0,0,0,161,244,133,59,0,0,0,0,10,157,55,190,0,0,0,0,0,0,128,191,0,0,0,0,55,82,150,61,0,0,0,0,10,157,55,190,0,0,0,0,0,0,128,191,0,0,0,0,214,83,91,190,0,0,0,0,18,105,251,189,0,0,0,0,0,0,128,191,0,0,0,0,55,82,150,61,0,0,0,0,10,157,55,190,0,0,0,0,0,0,128,191,0,0,0,0,110,109,17,62,0,0,0,0,10,157,55,190,0,0,0,0,0,0,128,191,0,0,0,0,214,83,91,190,0,0,0,0,18,105,251,189,0,0,0,0,0,0,128,191,0,0,0,0,110,109,17,62,0,0,0,0,10,157,55,190,0,0,0,0,0,0,128,191,0,0,0,0,110,109,17,62,0,0,0,0,18,105,251,189,0,0,0,0,0,0,128,191,0,0,0,0,161,244,133,59,0,0,0,0,18,105,251,189,0,0,0,0,0,0,0,0,0,0,0,0,214,83,91,190,0,0,0,0,18,105,251,189,0,0,0,0,0,0,0,0,0,0,0,0,110,109,17,62,0,0,0,0,18,105,251,189,0,0,0,0,0,0,0,0,0,0,0,0,161,244,133,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,161,244,133,59,0,0,0,0,18,105,251,189,0,0,0,0,0,0,128,191,0,0,0,0,55,82,150,61,0,0,0,0,18,105,251,189,0,0,0,0,0,0,128,191,0,0,0,0,55,82,150,61,0,0,0,0,18,105,251,189,0,0,0,0,0,0,0,0,0,0,0,0,161,244,133,59,0,0,0,0,18,105,251,189,0,0,0,0,0,0,0,0,0,0,0,0,110,109,17,62,0,0,0,0,18,105,251,189,0,0,0,0,0,0,0,0,0,0,0,0,161,244,133,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,55,82,150,61,0,0,0,0,18,105,251,189,0,0,0,0,0,0,128,191,0,0,0,0,55,82,150,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,214,83,91,190,106,164,133,61,221,37,65,190,0,0,0,0,0,0,128,63,0,0,0,0,161,244,133,59,106,164,133,61,38,27,231,190,0,0,0,0,0,0,128,63,0,0,0,0,87,233,238,187,106,164,133,61,197,203,3,191,0,0,0,0,0,0,128,63,0,0,0,0,161,244,133,59,106,164,133,61,38,27,231,190,0,0,0,0,0,0,128,63,0,0,0,0,55,82,150,61,106,164,133,61,197,203,3,191,0,0,0,0,0,0,128,63,0,0,0,0,87,233,238,187,106,164,133,61,197,203,3,191,0,0,0,0,0,0,128,63,0,0,0,0,161,244,133,59,106,164,133,61,38,27,231,190,0,0,0,0,0,0,128,63,0,0,0,0,55,82,150,61,106,164,133,61,10,157,55,190,0,0,0,0,0,0,128,63,0,0,0,0,55,82,150,61,106,164,133,61,197,203,3,191,0,0,0,0,0,0,128,63,0,0,0,0,214,83,91,190,106,164,133,61,221,37,65,190,0,0,0,0,0,0,128,63,0,0,0,0,243,31,34,190,106,164,133,61,10,157,55,190,0,0,0,0,0,0,128,63,0,0,0,0,161,244,133,59,106,164,133,61,38,27,231,190,0,0,0,0,0,0,128,63,0,0,0,0,161,244,133,59,106,164,133,61,10,157,55,190,0,0,0,0,0,0,128,63,0,0,0,0,55,82,150,61,106,164,133,61,10,157,55,190,0,0,0,0,0,0,128,63,0,0,0,0,161,244,133,59,106,164,133,61,38,27,231,190,0,0,0,0,0,0,128,63,0,0,0,0,214,83,91,190,106,164,133,61,18,105,251,189,0,0,0,0,0,0,128,63,0,0,0,0,243,31,34,190,106,164,133,61,10,157,55,190,0,0,0,0,0,0,128,63,0,0,0,0,214,83,91,190,106,164,133,61,221,37,65,190,0,0,0,0,0,0,128,63,0,0,0,0,214,83,91,190,106,164,133,61,18,105,251,189,0,0,0,0,0,0,128,63,0,0,0,0,161,244,133,59,106,164,133,61,10,157,55,190,0,0,0,0,0,0,128,63,0,0,0,0,243,31,34,190,106,164,133,61,10,157,55,190,0,0,0,0,0,0,128,63,0,0,0,0,214,83,91,190,106,164,133,61,18,105,251,189,0,0,0,0,0,0,128,63,0,0,0,0,55,82,150,61,106,164,133,61,10,157,55,190,0,0,0,0,0,0,128,63,0,0,0,0,161,244,133,59,106,164,133,61,10,157,55,190,0,0,0,0,0,0,128,63,0,0,0,0,214,83,91,190,106,164,133,61,18,105,251,189,0,0,0,0,0,0,128,63,0,0,0,0,110,109,17,62,106,164,133,61,10,157,55,190,0,0,0,0,0,0,128,63,0,0,0,0,55,82,150,61,106,164,133,61,10,157,55,190,0,0,0,0,0,0,128,63,0,0,0,0,214,83,91,190,106,164,133,61,18,105,251,189,0,0,0,0,0,0,128,63,0,0,0,0,110,109,17,62,106,164,133,61,18,105,251,189,0,0,0,0,0,0,128,63,0,0,0,0,110,109,17,62,106,164,133,61,10,157,55,190,0,0,0,0,0,0,128,63,0,0,0,0,161,244,133,59,106,164,133,61,18,105,251,189,0,0,0,0,0,0,0,0,0,0,0,0,110,109,17,62,106,164,133,61,18,105,251,189,0,0,0,0,0,0,0,0,0,0,0,0,214,83,91,190,106,164,133,61,18,105,251,189,0,0,0,0,0,0,0,0,0,0,0,0,161,244,133,59,106,164,133,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,55,82,150,61,106,164,133,61,18,105,251,189,0,0,0,0,0,0,128,63,0,0,0,0,161,244,133,59,106,164,133,61,18,105,251,189,0,0,0,0,0,0,128,63,0,0,0,0,55,82,150,61,106,164,133,61,18,105,251,189,0,0,0,0,0,0,0,0,0,0,0,0,110,109,17,62,106,164,133,61,18,105,251,189,0,0,0,0,0,0,0,0,0,0,0,0,161,244,133,59,106,164,133,61,18,105,251,189,0,0,0,0,0,0,0,0,0,0,0,0,161,244,133,59,106,164,133,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,55,82,150,61,106,164,133,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,55,82,150,61,106,164,133,61,18,105,251,189,0,0,0,0,0,0,128,63,0,0,0,0,161,244,133,59,106,164,133,61,0,0,0,0,0,0,128,191,0,0,0,0,0,0,0,0,161,244,133,59,106,164,133,61,18,105,251,189,0,0,128,191,0,0,0,0,0,0,0,0,161,244,133,59,0,0,0,0,18,105,251,189,0,0,128,191,0,0,0,0,0,0,0,0,161,244,133,59,106,164,133,61,18,105,251,189,0,0,128,191,0,0,0,0,0,0,0,0,161,244,133,59,0,0,0,0,18,105,251,189,0,0,128,191,0,0,0,0,0,0,0,0,161,244,133,59,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,0,0,0,0,161,244,133,59,0,0,0,0,38,27,231,190,0,0,128,191,0,0,0,0,0,0,0,0,161,244,133,59,0,0,0,0,10,157,55,190,0,0,128,191,0,0,0,0,0,0,0,0,161,244,133,59,106,164,133,61,10,157,55,190,0,0,128,191,0,0,0,0,0,0,0,0,161,244,133,59,0,0,0,0,10,157,55,190,0,0,128,191,0,0,0,0,0,0,0,0,161,244,133,59,106,164,133,61,10,157,55,190,0,0,128,191,0,0,0,0,0,0,0,0,161,244,133,59,106,164,133,61,38,27,231,190,0,0,128,191,0,0,0,0,0,0,0,0,243,31,34,190,106,164,133,61,10,157,55,190,0,0,0,0,0,0,0,0,0,0,128,191,161,244,133,59,106,164,133,61,10,157,55,190,0,0,0,0,0,0,0,0,0,0,128,191,161,244,133,59,0,0,0,0,10,157,55,190,0,0,0,0,0,0,0,0,0,0,128,191,161,244,133,59,106,164,133,61,10,157,55,190,0,0,0,0,0,0,0,0,0,0,128,191,161,244,133,59,0,0,0,0,10,157,55,190,0,0,0,0,0,0,0,0,0,0,128,191,243,31,34,190,0,0,0,0,10,157,55,190,0,0,0,0,0,0,0,0,0,0,128,191,55,82,150,61,106,164,133,61,18,105,251,189,0,0,128,63,0,0,0,0,0,0,0,0,55,82,150,61,106,164,133,61,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,55,82,150,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,55,82,150,61,106,164,133,61,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,55,82,150,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,55,82,150,61,0,0,0,0,18,105,251,189,0,0,128,63,0,0,0,0,0,0,0,0,87,233,238,187,0,0,0,0,197,203,3,191,31,47,88,191,0,0,0,0,88,29,9,191,214,83,91,190,0,0,0,0,221,37,65,190,31,47,88,191,0,0,0,0,88,29,9,191,214,83,91,190,106,164,133,61,221,37,65,190,31,47,88,191,0,0,0,0,88,29,9,191,214,83,91,190,0,0,0,0,221,37,65,190,31,47,88,191,0,0,0,0,88,29,9,191,214,83,91,190,106,164,133,61,221,37,65,190,31,47,88,191,0,0,0,0,88,29,9,191,87,233,238,187,106,164,133,61,197,203,3,191,31,47,88,191,0,0,0,0,88,29,9,191,55,82,150,61,106,164,133,61,10,157,55,190,0,0,0,0,0,0,0,0,0,0,128,191,110,109,17,62,106,164,133,61,10,157,55,190,0,0,0,0,0,0,0,0,0,0,128,191,110,109,17,62,0,0,0,0,10,157,55,190,0,0,0,0,0,0,0,0,0,0,128,191,110,109,17,62,106,164,133,61,10,157,55,190,0,0,0,0,0,0,0,0,0,0,128,191,110,109,17,62,0,0,0,0,10,157,55,190,0,0,0,0,0,0,0,0,0,0,128,191,55,82,150,61,0,0,0,0,10,157,55,190,0,0,0,0,0,0,0,0,0,0,128,191,243,31,34,190,0,0,0,0,10,157,55,190,7,208,91,63,0,0,0,0,13,56,3,63,161,244,133,59,0,0,0,0,38,27,231,190,7,208,91,63,0,0,0,0,13,56,3,63,161,244,133,59,106,164,133,61,38,27,231,190,7,208,91,63,0,0,0,0,13,56,3,63,161,244,133,59,0,0,0,0,38,27,231,190,7,208,91,63,0,0,0,0,13,56,3,63,161,244,133,59,106,164,133,61,38,27,231,190,7,208,91,63,0,0,0,0,13,56,3,63,243,31,34,190,106,164,133,61,10,157,55,190,7,208,91,63,0,0,0,0,13,56,3,63,87,233,238,187,106,164,133,61,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,55,82,150,61,106,164,133,61,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,55,82,150,61,0,0,0,0,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,55,82,150,61,106,164,133,61,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,55,82,150,61,0,0,0,0,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,87,233,238,187,0,0,0,0,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,110,109,17,62,106,164,133,61,18,105,251,189,0,0,0,0,0,0,0,0,0,0,128,63,55,82,150,61,106,164,133,61,18,105,251,189,0,0,0,0,0,0,0,0,0,0,128,63,55,82,150,61,0,0,0,0,18,105,251,189,0,0,0,0,0,0,0,0,0,0,128,63,55,82,150,61,106,164,133,61,18,105,251,189,0,0,0,0,0,0,0,0,0,0,128,63,55,82,150,61,0,0,0,0,18,105,251,189,0,0,0,0,0,0,0,0,0,0,128,63,110,109,17,62,0,0,0,0,18,105,251,189,0,0,0,0,0,0,0,0,0,0,128,63,214,83,91,190,106,164,133,61,18,105,251,189,0,0,128,191,0,0,0,0,0,0,0,0,214,83,91,190,106,164,133,61,221,37,65,190,0,0,128,191,0,0,0,0,0,0,0,0,214,83,91,190,0,0,0,0,221,37,65,190,0,0,128,191,0,0,0,0,0,0,0,0,214,83,91,190,106,164,133,61,221,37,65,190,0,0,128,191,0,0,0,0,0,0,0,0,214,83,91,190,0,0,0,0,221,37,65,190,0,0,128,191,0,0,0,0,0,0,0,0,214,83,91,190,0,0,0,0,18,105,251,189,0,0,128,191,0,0,0,0,0,0,0,0,55,82,150,61,106,164,133,61,197,203,3,191,0,0,128,63,0,0,0,0,0,0,0,0,55,82,150,61,106,164,133,61,10,157,55,190,0,0,128,63,0,0,0,0,0,0,0,0,55,82,150,61,0,0,0,0,10,157,55,190,0,0,128,63,0,0,0,0,0,0,0,0,55,82,150,61,106,164,133,61,10,157,55,190,0,0,128,63,0,0,0,0,0,0,0,0,55,82,150,61,0,0,0,0,10,157,55,190,0,0,128,63,0,0,0,0,0,0,0,0,55,82,150,61,0,0,0,0,197,203,3,191,0,0,128,63,0,0,0,0,0,0,0,0,55,82,150,61,106,164,133,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,161,244,133,59,106,164,133,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,161,244,133,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,161,244,133,59,106,164,133,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,161,244,133,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,55,82,150,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,110,109,17,62,106,164,133,61,10,157,55,190,0,0,128,63,0,0,0,0,0,0,0,0,110,109,17,62,106,164,133,61,18,105,251,189,0,0,128,63,0,0,0,0,0,0,0,0,110,109,17,62,0,0,0,0,18,105,251,189,0,0,128,63,0,0,0,0,0,0,0,0,110,109,17,62,106,164,133,61,18,105,251,189,0,0,128,63,0,0,0,0,0,0,0,0,110,109,17,62,0,0,0,0,18,105,251,189,0,0,128,63,0,0,0,0,0,0,0,0,110,109,17,62,0,0,0,0,10,157,55,190,0,0,128,63,0,0,0,0,0,0,0,0,161,244,133,59,106,164,133,61,18,105,251,189,0,0,0,0,0,0,0,0,0,0,128,63,214,83,91,190,106,164,133,61,18,105,251,189,0,0,0,0,0,0,0,0,0,0,128,63,214,83,91,190,0,0,0,0,18,105,251,189,0,0,0,0,0,0,0,0,0,0,128,63,214,83,91,190,106,164,133,61,18,105,251,189,0,0,0,0,0,0,0,0,0,0,128,63,214,83,91,190,0,0,0,0,18,105,251,189,0,0,0,0,0,0,0,0,0,0,128,63,161,244,133,59,0,0,0,0,18,105,251,189,0,0,0,0,0,0,0,0,0,0,128,63,152,133,6,190,0,0,0,0,251,35,132,190,0,0,0,0,0,0,128,191,0,0,0,0,225,239,7,190,0,0,0,0,197,203,3,191,0,0,0,0,0,0,128,191,0,0,0,0,187,238,141,189,0,0,0,0,247,147,233,190,0,0,0,0,0,0,128,191,0,0,0,0,187,238,141,189,0,0,0,0,247,147,233,190,0,0,0,0,0,0,128,191,0,0,0,0,225,239,7,190,0,0,0,0,197,203,3,191,0,0,0,0,0,0,128,191,0,0,0,0,46,2,3,62,0,0,0,0,197,203,3,191,0,0,0,0,0,0,128,191,0,0,0,0,187,238,141,189,0,0,0,0,247,147,233,190,0,0,0,0,0,0,128,191,0,0,0,0,46,2,3,62,0,0,0,0,197,203,3,191,0,0,0,0,0,0,128,191,0,0,0,0,46,2,3,62,0,0,0,0,247,147,233,190,0,0,0,0,0,0,128,191,0,0,0,0,152,133,6,190,0,0,0,0,251,35,132,190,0,0,0,0,0,0,128,191,0,0,0,0,187,238,141,189,0,0,0,0,247,147,233,190,0,0,0,0,0,0,128,191,0,0,0,0,225,13,137,189,0,0,0,0,218,2,170,190,0,0,0,0,0,0,128,191,0,0,0,0,141,67,189,61,106,164,133,61,87,62,75,190,129,207,127,191,28,7,222,60,220,155,223,60,88,29,185,61,0,0,0,0,179,210,84,190,129,207,127,191,28,7,222,60,220,155,223,60,136,99,189,61,0,0,0,0,78,154,6,190,129,207,127,191,28,7,222,60,220,155,223,60,85,138,157,188,0,0,0,0,20,36,174,190,47,22,78,191,235,167,127,60,20,209,23,191,107,153,140,188,106,164,133,61,242,178,174,190,47,22,78,191,235,167,127,60,20,209,23,191,66,66,148,188,0,0,0,0,171,237,174,190,47,22,78,191,235,167,127,60,20,209,23,191,249,130,6,190,106,164,133,61,224,103,132,190,0,0,0,0,0,0,128,63,0,0,0,0,187,238,141,189,106,164,133,61,247,147,233,190,0,0,0,0,0,0,128,63,0,0,0,0,225,239,7,190,106,164,133,61,197,203,3,191,0,0,0,0,0,0,128,63,0,0,0,0,243,84,135,61,0,0,0,0,195,68,163,189,0,0,0,0,0,0,128,191,0,0,0,0,136,99,189,61,0,0,0,0,78,154,6,190,0,0,0,0,0,0,128,191,0,0,0,0,118,196,17,62,0,0,0,0,10,190,137,189,0,0,0,0,0,0,128,191,0,0,0,0,187,238,141,189,106,164,133,61,247,147,233,190,0,0,0,0,0,0,128,63,0,0,0,0,46,2,3,62,106,164,133,61,247,147,233,190,0,0,0,0,0,0,128,63,0,0,0,0,46,2,3,62,106,164,133,61,197,203,3,191,0,0,0,0,0,0,128,63,0,0,0,0,94,128,13,190,0,0,0,0,201,174,52,187,0,0,0,0,0,0,128,191,0,0,0,0,81,22,30,190,0,0,0,0,245,189,166,189,0,0,0,0,0,0,128,191,0,0,0,0,204,11,144,189,0,0,0,0,42,55,81,189,0,0,0,0,0,0,128,191,0,0,0,0,5,22,0,62,106,164,133,61,66,235,145,190,116,8,84,63,51,108,20,60,114,110,15,191,13,228,25,62,106,164,133,61,222,176,125,190,116,8,84,63,51,108,20,60,114,110,15,191,34,108,24,62,0,0,0,0,150,120,128,190,116,8,84,63,51,108,20,60,114,110,15,191,99,155,20,190,106,164,133,61,172,226,141,187,0,0,0,0,0,0,128,63,0,0,0,0,135,24,111,61,106,164,133,61,229,209,13,58,0,0,0,0,0,0,128,63,0,0,0,0,226,63,13,62,106,164,133,61,180,231,114,189,0,0,0,0,0,0,128,63,0,0,0,0,225,13,137,189,0,0,0,0,218,2,170,190,0,0,0,0,0,0,128,63,0,0,0,0,85,138,157,188,0,0,0,0,20,36,174,190,0,0,0,0,0,0,128,63,0,0,0,0,66,66,148,188,0,0,0,0,171,237,174,190,0,0,0,0,0,0,128,63,0,0,0,0,13,228,25,62,106,164,133,61,222,176,125,190,241,104,123,63,207,158,75,188,98,159,64,190,180,88,42,62,0,0,0,0,37,93,35,190,241,104,123,63,207,158,75,188,98,159,64,190,34,108,24,62,0,0,0,0,150,120,128,190,241,104,123,63,207,158,75,188,98,159,64,190,225,13,137,189,0,0,0,0,218,2,170,190,0,0,0,0,0,0,128,191,0,0,0,0,66,66,148,188,0,0,0,0,171,237,174,190,0,0,0,0])
.concat([0,0,128,191,0,0,0,0,44,17,104,61,0,0,0,0,6,214,169,190,0,0,0,0,0,0,128,191,0,0,0,0,249,130,6,190,106,164,133,61,224,103,132,190,0,0,0,0,0,0,128,63,0,0,0,0,166,96,141,189,106,164,133,61,74,9,169,190,0,0,0,0,0,0,128,63,0,0,0,0,187,238,141,189,106,164,133,61,247,147,233,190,0,0,0,0,0,0,128,63,0,0,0,0,247,177,226,61,106,164,133,61,62,151,153,190,93,197,54,63,65,186,88,187,150,63,51,191,5,22,0,62,0,0,0,0,66,235,145,190,93,197,54,63,65,186,88,187,150,63,51,191,17,114,222,61,0,0,0,0,22,132,154,190,93,197,54,63,65,186,88,187,150,63,51,191,225,239,7,190,0,0,0,0,197,203,3,191,4,255,127,191,77,46,70,57,167,116,176,59,152,133,6,190,0,0,0,0,251,35,132,190,4,255,127,191,77,46,70,57,167,116,176,59,249,130,6,190,106,164,133,61,224,103,132,190,4,255,127,191,77,46,70,57,167,116,176,59,13,228,25,62,106,164,133,61,222,176,125,190,86,73,124,63,162,150,102,60,94,47,45,190,55,51,42,62,106,164,133,61,17,168,30,190,86,73,124,63,162,150,102,60,94,47,45,190,180,88,42,62,0,0,0,0,37,93,35,190,86,73,124,63,162,150,102,60,94,47,45,190,46,2,3,62,106,164,133,61,197,203,3,191,0,0,128,63,0,0,0,0,0,0,0,0,46,2,3,62,106,164,133,61,247,147,233,190,0,0,128,63,0,0,0,0,0,0,0,0,46,2,3,62,0,0,0,0,247,147,233,190,0,0,128,63,0,0,0,0,0,0,0,0,38,52,9,189,106,164,133,61,7,122,40,60,118,192,245,189,89,223,192,187,83,37,126,63,94,128,13,190,0,0,0,0,201,174,52,187,118,192,245,189,89,223,192,187,83,37,126,63,203,47,3,189,0,0,0,0,107,13,37,60,118,192,245,189,89,223,192,187,83,37,126,63,185,165,181,61,106,164,133,61,140,17,233,189,0,0,0,0,0,0,128,63,0,0,0,0,55,51,42,62,106,164,133,61,17,168,30,190,0,0,0,0,0,0,128,63,0,0,0,0,141,67,189,61,106,164,133,61,87,62,75,190,0,0,0,0,0,0,128,63,0,0,0,0,141,67,189,61,106,164,133,61,87,62,75,190,218,87,98,191,178,241,32,189,133,91,238,62,1,134,133,61,106,164,133,61,72,22,128,190,218,87,98,191,178,241,32,189,133,91,238,62,88,29,185,61,0,0,0,0,179,210,84,190,218,87,98,191,178,241,32,189,133,91,238,62,55,51,42,62,106,164,133,61,17,168,30,190,107,98,117,63,103,240,247,60,223,21,145,62,226,63,13,62,106,164,133,61,180,231,114,189,107,98,117,63,103,240,247,60,223,21,145,62,118,196,17,62,0,0,0,0,10,190,137,189,107,98,117,63,103,240,247,60,223,21,145,62,146,89,157,189,106,164,133,61,38,253,141,190,0,0,0,0,0,0,128,63,0,0,0,0,88,146,188,61,106,164,133,61,185,166,160,190,0,0,0,0,0,0,128,63,0,0,0,0,51,165,117,61,106,164,133,61,246,66,169,190,0,0,0,0,0,0,128,63,0,0,0,0,1,134,133,61,106,164,133,61,72,22,128,190,83,149,190,190,18,107,33,190,213,38,106,63,231,140,168,188,106,164,133,61,157,245,145,190,83,149,190,190,18,107,33,190,213,38,106,63,15,129,35,61,0,0,0,0,201,28,139,190,83,149,190,190,18,107,33,190,213,38,106,63,226,63,13,62,106,164,133,61,180,231,114,189,164,226,39,63,30,138,66,189,63,225,64,63,228,243,138,61,0,0,0,0,80,224,29,187,164,226,39,63,30,138,66,189,63,225,64,63,118,196,17,62,0,0,0,0,10,190,137,189,164,226,39,63,30,138,66,189,63,225,64,63,185,165,181,61,106,164,133,61,140,17,233,189,175,123,127,191,154,65,60,189,47,137,51,189,141,67,189,61,106,164,133,61,87,62,75,190,175,123,127,191,154,65,60,189,47,137,51,189,136,99,189,61,0,0,0,0,78,154,6,190,175,123,127,191,154,65,60,189,47,137,51,189,247,177,226,61,106,164,133,61,62,151,153,190,182,159,56,63,0,0,0,0,121,87,49,191,5,22,0,62,106,164,133,61,66,235,145,190,182,159,56,63,0,0,0,0,121,87,49,191,5,22,0,62,0,0,0,0,66,235,145,190,182,159,56,63,0,0,0,0,121,87,49,191,46,2,3,62,106,164,133,61,197,203,3,191,0,0,128,63,0,0,0,0,0,0,0,0,46,2,3,62,0,0,0,0,247,147,233,190,0,0,128,63,0,0,0,0,0,0,0,0,46,2,3,62,0,0,0,0,197,203,3,191,0,0,128,63,0,0,0,0,0,0,0,0,107,153,140,188,106,164,133,61,242,178,174,190,198,192,42,190,124,69,55,188,77,102,124,191,85,138,157,188,0,0,0,0,20,36,174,190,198,192,42,190,124,69,55,188,77,102,124,191,225,13,137,189,0,0,0,0,218,2,170,190,198,192,42,190,124,69,55,188,77,102,124,191,88,146,188,61,106,164,133,61,185,166,160,190,152,48,22,63,0,0,0,0,76,80,79,191,17,114,222,61,0,0,0,0,22,132,154,190,152,48,22,63,0,0,0,0,76,80,79,191,88,146,188,61,0,0,0,0,185,166,160,190,152,48,22,63,0,0,0,0,76,80,79,191,88,146,188,61,106,164,133,61,185,166,160,190,128,98,24,63,147,26,90,59,53,180,77,191,247,177,226,61,106,164,133,61,62,151,153,190,128,98,24,63,147,26,90,59,53,180,77,191,17,114,222,61,0,0,0,0,22,132,154,190,128,98,24,63,147,26,90,59,53,180,77,191,5,108,167,189,106,164,133,61,217,149,86,189,79,178,173,62,248,197,37,61,95,152,112,191,204,11,144,189,0,0,0,0,42,55,81,189,79,178,173,62,248,197,37,61,95,152,112,191,81,22,30,190,0,0,0,0,245,189,166,189,79,178,173,62,248,197,37,61,95,152,112,191,226,63,13,62,106,164,133,61,180,231,114,189,100,173,25,63,229,70,81,61,231,82,76,63,135,24,111,61,106,164,133,61,229,209,13,58,100,173,25,63,229,70,81,61,231,82,76,63,228,243,138,61,0,0,0,0,80,224,29,187,100,173,25,63,229,70,81,61,231,82,76,63,241,244,10,61,106,164,133,61,42,54,102,189,76,110,56,191,139,110,221,189,11,95,47,191,185,165,181,61,106,164,133,61,140,17,233,189,76,110,56,191,139,110,221,189,11,95,47,191,243,84,135,61,0,0,0,0,195,68,163,189,76,110,56,191,139,110,221,189,11,95,47,191,94,128,13,190,0,0,0,0,201,174,52,187,0,0,0,0,0,0,128,191,0,0,0,0,228,243,138,61,0,0,0,0,80,224,29,187,0,0,0,0,0,0,128,191,0,0,0,0,203,47,3,189,0,0,0,0,107,13,37,60,0,0,0,0,0,0,128,191,0,0,0,0,173,132,30,190,106,164,133,61,98,46,169,189,129,176,195,62,2,217,107,188,248,136,108,191,5,108,167,189,106,164,133,61,217,149,86,189,129,176,195,62,2,217,107,188,248,136,108,191,81,22,30,190,0,0,0,0,245,189,166,189,129,176,195,62,2,217,107,188,248,136,108,191,1,134,133,61,106,164,133,61,72,22,128,190,194,223,71,191,29,119,202,61,74,241,29,63,15,129,35,61,0,0,0,0,201,28,139,190,194,223,71,191,29,119,202,61,74,241,29,63,88,29,185,61,0,0,0,0,179,210,84,190,194,223,71,191,29,119,202,61,74,241,29,63,141,67,189,61,106,164,133,61,87,62,75,190,0,0,0,0,0,0,128,63,0,0,0,0,55,51,42,62,106,164,133,61,17,168,30,190,0,0,0,0,0,0,128,63,0,0,0,0,13,228,25,62,106,164,133,61,222,176,125,190,0,0,0,0,0,0,128,63,0,0,0,0,231,140,168,188,106,164,133,61,157,245,145,190,0,0,0,0,0,0,128,63,0,0,0,0,5,22,0,62,106,164,133,61,66,235,145,190,0,0,0,0,0,0,128,63,0,0,0,0,247,177,226,61,106,164,133,61,62,151,153,190,0,0,0,0,0,0,128,63,0,0,0,0,152,133,6,190,0,0,0,0,251,35,132,190,0,0,0,0,0,0,128,191,0,0,0,0,225,13,137,189,0,0,0,0,218,2,170,190,0,0,0,0,0,0,128,191,0,0,0,0,192,34,159,189,0,0,0,0,82,154,141,190,0,0,0,0,0,0,128,191,0,0,0,0,46,2,3,62,0,0,0,0,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,225,239,7,190,0,0,0,0,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,225,239,7,190,106,164,133,61,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,146,89,157,189,106,164,133,61,38,253,141,190,155,117,6,62,57,182,30,60,114,197,125,63,192,34,159,189,0,0,0,0,82,154,141,190,155,117,6,62,57,182,30,60,114,197,125,63,136,245,6,189,0,0,0,0,114,163,144,190,155,117,6,62,57,182,30,60,114,197,125,63,187,238,141,189,106,164,133,61,247,147,233,190,241,243,127,63,0,0,0,0,96,31,157,188,225,13,137,189,0,0,0,0,218,2,170,190,241,243,127,63,0,0,0,0,96,31,157,188,187,238,141,189,0,0,0,0,247,147,233,190,241,243,127,63,0,0,0,0,96,31,157,188,192,34,159,189,0,0,0,0,82,154,141,190,0,0,0,0,0,0,128,191,0,0,0,0,225,13,137,189,0,0,0,0,218,2,170,190,0,0,0,0,0,0,128,191,0,0,0,0,44,17,104,61,0,0,0,0,6,214,169,190,0,0,0,0,0,0,128,191,0,0,0,0,51,165,117,61,106,164,133,61,246,66,169,190,196,147,237,62,0,0,0,0,126,197,98,191,88,146,188,61,106,164,133,61,185,166,160,190,196,147,237,62,0,0,0,0,126,197,98,191,88,146,188,61,0,0,0,0,185,166,160,190,196,147,237,62,0,0,0,0,126,197,98,191,5,22,0,62,106,164,133,61,66,235,145,190,185,250,81,63,0,0,0,0,160,112,18,191,34,108,24,62,0,0,0,0,150,120,128,190,185,250,81,63,0,0,0,0,160,112,18,191,5,22,0,62,0,0,0,0,66,235,145,190,185,250,81,63,0,0,0,0,160,112,18,191,231,140,168,188,106,164,133,61,157,245,145,190,74,212,11,62,205,114,89,60,75,148,125,63,146,89,157,189,106,164,133,61,38,253,141,190,74,212,11,62,205,114,89,60,75,148,125,63,136,245,6,189,0,0,0,0,114,163,144,190,74,212,11,62,205,114,89,60,75,148,125,63,192,34,159,189,0,0,0,0,82,154,141,190,0,0,0,0,0,0,128,191,0,0,0,0,44,17,104,61,0,0,0,0,6,214,169,190,0,0,0,0,0,0,128,191,0,0,0,0,88,146,188,61,0,0,0,0,185,166,160,190,0,0,0,0,0,0,128,191,0,0,0,0,146,89,157,189,106,164,133,61,38,253,141,190,0,0,0,0,0,0,128,191,0,0,0,0,231,140,168,188,106,164,133,61,157,245,145,190,0,0,0,0,0,0,128,191,0,0,0,0,247,177,226,61,106,164,133,61,62,151,153,190,0,0,0,0,0,0,128,191,0,0,0,0,192,34,159,189,0,0,0,0,82,154,141,190,0,0,0,0,0,0,128,191,0,0,0,0,88,146,188,61,0,0,0,0,185,166,160,190,0,0,0,0,0,0,128,191,0,0,0,0,136,245,6,189,0,0,0,0,114,163,144,190,0,0,0,0,0,0,128,191,0,0,0,0,46,2,3,62,106,164,133,61,247,147,233,190,0,0,0,0,0,0,0,0,0,0,128,63,187,238,141,189,106,164,133,61,247,147,233,190,0,0,0,0,0,0,0,0,0,0,128,63,187,238,141,189,0,0,0,0,247,147,233,190,0,0,0,0,0,0,0,0,0,0,128,63,5,108,167,189,106,164,133,61,217,149,86,189,126,201,6,189,152,192,109,189,252,109,127,191,241,244,10,61,106,164,133,61,42,54,102,189,126,201,6,189,152,192,109,189,252,109,127,191,158,35,114,60,0,0,0,0,18,19,84,189,126,201,6,189,152,192,109,189,252,109,127,191,136,245,6,189,0,0,0,0,114,163,144,190,0,0,0,0,0,0,128,191,0,0,0,0,88,146,188,61,0,0,0,0,185,166,160,190,0,0,0,0,0,0,128,191,0,0,0,0,17,114,222,61,0,0,0,0,22,132,154,190,0,0,0,0,0,0,128,191,0,0,0,0,46,2,3,62,106,164,133,61,247,147,233,190,0,0,0,0,0,0,0,0,0,0,128,63,187,238,141,189,0,0,0,0,247,147,233,190,0,0,0,0,0,0,0,0,0,0,128,63,46,2,3,62,0,0,0,0,247,147,233,190,0,0,0,0,0,0,0,0,0,0,128,63,99,155,20,190,106,164,133,61,172,226,141,187,0,0,0,0,0,0,128,63,0,0,0,0,5,108,167,189,106,164,133,61,217,149,86,189,0,0,0,0,0,0,128,63,0,0,0,0,173,132,30,190,106,164,133,61,98,46,169,189,0,0,0,0,0,0,128,63,0,0,0,0,146,89,157,189,106,164,133,61,38,253,141,190,201,56,166,62,167,148,215,59,155,32,114,63,249,130,6,190,106,164,133,61,224,103,132,190,201,56,166,62,167,148,215,59,155,32,114,63,192,34,159,189,0,0,0,0,82,154,141,190,201,56,166,62,167,148,215,59,155,32,114,63,187,238,141,189,106,164,133,61,247,147,233,190,0,0,0,0,0,0,128,63,0,0,0,0,46,2,3,62,106,164,133,61,197,203,3,191,0,0,0,0,0,0,128,63,0,0,0,0,225,239,7,190,106,164,133,61,197,203,3,191,0,0,0,0,0,0,128,63,0,0,0,0,204,11,144,189,0,0,0,0,42,55,81,189,0,0,0,0,0,0,128,63,0,0,0,0,158,35,114,60,0,0,0,0,18,19,84,189,0,0,0,0,0,0,128,63,0,0,0,0,118,196,17,62,0,0,0,0,10,190,137,189,0,0,0,0,0,0,128,63,0,0,0,0,146,89,157,189,106,164,133,61,38,253,141,190,0,0,0,0,0,0,128,63,0,0,0,0,51,165,117,61,106,164,133,61,246,66,169,190,0,0,0,0,0,0,128,63,0,0,0,0,166,96,141,189,106,164,133,61,74,9,169,190,0,0,0,0,0,0,128,63,0,0,0,0,241,244,10,61,106,164,133,61,42,54,102,189,235,31,244,190,194,222,164,61,165,20,96,191,243,84,135,61,0,0,0,0,195,68,163,189,235,31,244,190,194,222,164,61,165,20,96,191,158,35,114,60,0,0,0,0,18,19,84,189,235,31,244,190,194,222,164,61,165,20,96,191,1,134,133,61,106,164,133,61,72,22,128,190,0,0,0,0,0,0,128,63,0,0,0,0,13,228,25,62,106,164,133,61,222,176,125,190,0,0,0,0,0,0,128,63,0,0,0,0,231,140,168,188,106,164,133,61,157,245,145,190,0,0,0,0,0,0,128,63,0,0,0,0,136,245,6,189,0,0,0,0,114,163,144,190,0,0,0,0,0,0,128,191,0,0,0,0,17,114,222,61,0,0,0,0,22,132,154,190,0,0,0,0,0,0,128,191,0,0,0,0,5,22,0,62,0,0,0,0,66,235,145,190,0,0,0,0,0,0,128,191,0,0,0,0,99,155,20,190,106,164,133,61,172,226,141,187,81,131,121,191,192,89,202,189,174,129,77,62,81,22,30,190,0,0,0,0,245,189,166,189,81,131,121,191,192,89,202,189,174,129,77,62,94,128,13,190,0,0,0,0,201,174,52,187,81,131,121,191,192,89,202,189,174,129,77,62,136,245,6,189,0,0,0,0,114,163,144,190,0,0,0,0,0,0,128,191,0,0,0,0,5,22,0,62,0,0,0,0,66,235,145,190,0,0,0,0,0,0,128,191,0,0,0,0,15,129,35,61,0,0,0,0,201,28,139,190,0,0,0,0,0,0,128,191,0,0,0,0,15,129,35,61,0,0,0,0,201,28,139,190,0,0,0,0,0,0,128,191,0,0,0,0,5,22,0,62,0,0,0,0,66,235,145,190,0,0,0,0,0,0,128,191,0,0,0,0,34,108,24,62,0,0,0,0,150,120,128,190,0,0,0,0,0,0,128,191,0,0,0,0,5,108,167,189,106,164,133,61,217,149,86,189,82,68,6,188,164,51,176,188,162,238,127,191,158,35,114,60,0,0,0,0,18,19,84,189,82,68,6,188,164,51,176,188,162,238,127,191,204,11,144,189,0,0,0,0,42,55,81,189,82,68,6,188,164,51,176,188,162,238,127,191,55,51,42,62,106,164,133,61,17,168,30,190,157,185,119,63,171,205,127,188,135,224,128,62,118,196,17,62,0,0,0,0,10,190,137,189,157,185,119,63,171,205,127,188,135,224,128,62,180,88,42,62,0,0,0,0,37,93,35,190,157,185,119,63,171,205,127,188,135,224,128,62,185,165,181,61,106,164,133,61,140,17,233,189,0,0,0,0,0,0,128,63,0,0,0,0,226,63,13,62,106,164,133,61,180,231,114,189,0,0,0,0,0,0,128,63,0,0,0,0,55,51,42,62,106,164,133,61,17,168,30,190,0,0,0,0,0,0,128,63,0,0,0,0,166,96,141,189,106,164,133,61,74,9,169,190,0,0,0,0,0,0,128,63,0,0,0,0,51,165,117,61,106,164,133,61,246,66,169,190,0,0,0,0,0,0,128,63,0,0,0,0,107,153,140,188,106,164,133,61,242,178,174,190,0,0,0,0,0,0,128,63,0,0,0,0,225,239,7,190,0,0,0,0,197,203,3,191,4,255,127,191,0,0,0,0,79,7,178,59,249,130,6,190,106,164,133,61,224,103,132,190,4,255,127,191,0,0,0,0,79,7,178,59,225,239,7,190,106,164,133,61,197,203,3,191,4,255,127,191,0,0,0,0,79,7,178,59,135,24,111,61,106,164,133,61,229,209,13,58,155,230,253,61,225,208,219,188,154,238,125,63,203,47,3,189,0,0,0,0,107,13,37,60,155,230,253,61,225,208,219,188,154,238,125,63,228,243,138,61,0,0,0,0,80,224,29,187,155,230,253,61,225,208,219,188,154,238,125,63,166,96,141,189,106,164,133,61,74,9,169,190,128,128,85,190,10,131,178,60,202,79,122,191,107,153,140,188,106,164,133,61,242,178,174,190,128,128,85,190,10,131,178,60,202,79,122,191,225,13,137,189,0,0,0,0,218,2,170,190,128,128,85,190,10,131,178,60,202,79,122,191,241,244,10,61,106,164,133,61,42,54,102,189,0,0,0,0,0,0,128,63,0,0,0,0,226,63,13,62,106,164,133,61,180,231,114,189,0,0,0,0,0,0,128,63,0,0,0,0,185,165,181,61,106,164,133,61,140,17,233,189,0,0,0,0,0,0,128,63,0,0,0,0,146,89,157,189,106,164,133,61,38,253,141,190,0,0,0,0,0,0,128,63,0,0,0,0,247,177,226,61,106,164,133,61,62,151,153,190,0,0,0,0,0,0,128,63,0,0,0,0,88,146,188,61,106,164,133,61,185,166,160,190,0,0,0,0,0,0,128,63,0,0,0,0,231,140,168,188,106,164,133,61,157,245,145,190,133,177,21,190,142,176,136,61,59,172,124,63,136,245,6,189,0,0,0,0,114,163,144,190,133,177,21,190,142,176,136,61,59,172,124,63,15,129,35,61,0,0,0,0,201,28,139,190,133,177,21,190,142,176,136,61,59,172,124,63,51,165,117,61,106,164,133,61,246,66,169,190,42,84,231,62,163,143,249,187,91,95,100,191,88,146,188,61,0,0,0,0,185,166,160,190,42,84,231,62,163,143,249,187,91,95,100,191,44,17,104,61,0,0,0,0,6,214,169,190,42,84,231,62,163,143,249,187,91,95,100,191,99,155,20,190,106,164,133,61,172,226,141,187,23,16,126,191,112,206,136,187,25,84,251,61,173,132,30,190,106,164,133,61,98,46,169,189,23,16,126,191,112,206,136,187,25,84,251,61,81,22,30,190,0,0,0,0,245,189,166,189,23,16,126,191,112,206,136,187,25,84,251,61,94,128,13,190,0,0,0,0,201,174,52,187,0,0,0,0,0,0,128,191,0,0,0,0,204,11,144,189,0,0,0,0,42,55,81,189,0,0,0,0,0,0,128,191,0,0,0,0,118,196,17,62,0,0,0,0,10,190,137,189,0,0,0,0,0,0,128,191,0,0,0,0,141,67,189,61,106,164,133,61,87,62,75,190,0,0,0,0,0,0,128,63,0,0,0,0,13,228,25,62,106,164,133,61,222,176,125,190,0,0,0,0,0,0,128,63,0,0,0,0,1,134,133,61,106,164,133,61,72,22,128,190,0,0,0,0,0,0,128,63,0,0,0,0,187,238,141,189,106,164,133,61,247,147,233,190,118,221,127,63,121,173,4,61,61,214,12,187,166,96,141,189,106,164,133,61,74,9,169,190,118,221,127,63,121,173,4,61,61,214,12,187,225,13,137,189,0,0,0,0,218,2,170,190,118,221,127,63,121,173,4,61,61,214,12,187,231,140,168,188,106,164,133,61,157,245,145,190,0,0,0,0,0,0,128,63,0,0,0,0,13,228,25,62,106,164,133,61,222,176,125,190,0,0,0,0,0,0,128,63,0,0,0,0,5,22,0,62,106,164,133,61,66,235,145,190,0,0,0,0,0,0,128,63,0,0,0,0,99,155,20,190,106,164,133,61,172,226,141,187,0,0,0,0,0,0,128,63,0,0,0,0,38,52,9,189,106,164,133,61,7,122,40,60,0,0,0,0,0,0,128,63,0,0,0,0,135,24,111,61,106,164,133,61,229,209,13,58,0,0,0,0,0,0,128,63,0,0,0,0,88,29,185,61,0,0,0,0,179,210,84,190,0,0,0,0,0,0,128,191,0,0,0,0,15,129,35,61,0,0,0,0,201,28,139,190,0,0,0,0,0,0,128,191,0,0,0,0,34,108,24,62,0,0,0,0,150,120,128,190,0,0,0,0,0,0,128,191,0,0,0,0,5,108,167,189,106,164,133,61,217,149,86,189,0,0,0,0,0,0,128,63,0,0,0,0,226,63,13,62,106,164,133,61,180,231,114,189,0,0,0,0,0,0,128,63,0,0,0,0,241,244,10,61,106,164,133,61,42,54,102,189,0,0,0,0,0,0,128,63,0,0,0,0,135,24,111,61,106,164,133,61,229,209,13,58,106,251,215,61,13,111,86,186,129,146,126,63,38,52,9,189,106,164,133,61,7,122,40,60,106,251,215,61,13,111,86,186,129,146,126,63,203,47,3,189,0,0,0,0,107,13,37,60,106,251,215,61,13,111,86,186,129,146,126,63,99,155,20,190,106,164,133,61,172,226,141,187,0,0,0,0,0,0,128,63,0,0,0,0,226,63,13,62,106,164,133,61,180,231,114,189,0,0,0,0,0,0,128,63,0,0,0,0,5,108,167,189,106,164,133,61,217,149,86,189,0,0,0,0,0,0,128,63,0,0,0,0,38,52,9,189,106,164,133,61,7,122,40,60,75,234,4,190,227,109,37,60,57,210,125,63,99,155,20,190,106,164,133,61,172,226,141,187,75,234,4,190,227,109,37,60,57,210,125,63,94,128,13,190,0,0,0,0,201,174,52,187,75,234,4,190,227,109,37,60,57,210,125,63,185,165,181,61,106,164,133,61,140,17,233,189,176,115,99,191,227,167,145,61,50,31,232,190,136,99,189,61,0,0,0,0,78,154,6,190,176,115,99,191,227,167,145,61,50,31,232,190,243,84,135,61,0,0,0,0,195,68,163,189,176,115,99,191,227,167,145,61,50,31,232,190,88,29,185,61,0,0,0,0,179,210,84,190,0,0,0,0,0,0,128,191,0,0,0,0,34,108,24,62,0,0,0,0,150,120,128,190,0,0,0,0,0,0,128,191,0,0,0,0,180,88,42,62,0,0,0,0,37,93,35,190,0,0,0,0,0,0,128,191,0,0,0,0,249,130,6,190,106,164,133,61,224,103,132,190,145,181,166,62,175,64,244,59,200,10,114,63,152,133,6,190,0,0,0,0,251,35,132,190,145,181,166,62,175,64,244,59,200,10,114,63,192,34,159,189,0,0,0,0,82,154,141,190,145,181,166,62,175,64,244,59,200,10,114,63,107,153,140,188,106,164,133,61,242,178,174,190,111,14,7,62,201,30,161,59,177,194,125,191,44,17,104,61,0,0,0,0,6,214,169,190,111,14,7,62,201,30,161,59,177,194,125,191,66,66,148,188,0,0,0,0,171,237,174,190,111,14,7,62,201,30,161,59,177,194,125,191,136,99,189,61,0,0,0,0,78,154,6,190,0,0,0,0,0,0,128,191,0,0,0,0,180,88,42,62,0,0,0,0,37,93,35,190,0,0,0,0,0,0,128,191,0,0,0,0,118,196,17,62,0,0,0,0,10,190,137,189,0,0,0,0,0,0,128,191,0,0,0,0,94,128,13,190,0,0,0,0,201,174,52,187,0,0,0,0,0,0,128,191,0,0,0,0,118,196,17,62,0,0,0,0,10,190,137,189,0,0,0,0,0,0,128,191,0,0,0,0,228,243,138,61,0,0,0,0,80,224,29,187,0,0,0,0,0,0,128,191,0,0,0,0,249,130,6,190,106,164,133,61,224,103,132,190,0,0,0,0,0,0,128,63,0,0,0,0,146,89,157,189,106,164,133,61,38,253,141,190,0,0,0,0,0,0,128,63,0,0,0,0,166,96,141,189,106,164,133,61,74,9,169,190,0,0,0,0,0,0,128,63,0,0,0,0,107,153,140,188,106,164,133,61,242,178,174,190,210,169,11,62,170,126,37,60,57,152,125,191,51,165,117,61,106,164,133,61,246,66,169,190,210,169,11,62,170,126,37,60,57,152,125,191,44,17,104,61,0,0,0,0,6,214,169,190,210,169,11,62,170,126,37,60,57,152,125,191,158,35,114,60,0,0,0,0,18,19,84,189,0,0,0,0,0,0,128,191,0,0,0,0,243,84,135,61,0,0,0,0,195,68,163,189,0,0,0,0,0,0,128,191,0,0,0,0,118,196,17,62,0,0,0,0,10,190,137,189,0,0,0,0,0,0,128,191,0,0,0,0,46,2,3,62,0,0,0,0,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,225,239,7,190,106,164,133,61,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,46,2,3,62,106,164,133,61,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,136,99,189,61,0,0,0,0,78,154,6,190,0,0,0,0,0,0,128,191,0,0,0,0,88,29,185,61,0,0,0,0,179,210,84,190,0,0,0,0,0,0,128,191,0,0,0,0,180,88,42,62,0,0,0,0,37,93,35,190,0,0,0,0,0,0,128,191,0,0,0,0,89,249,165,61,106,164,133,61,64,18,182,189,0,0,0,0,0,0,128,63,0,0,0,0,0,59,247,61,106,164,133,61,180,146,22,189,0,0,0,0,0,0,128,63,0,0,0,0,175,68,32,62,106,164,133,61,250,180,234,189,0,0,0,0,0,0,128,63,0,0,0,0,119,77,168,61,0,0,0,0,57,127,115,190,0,0,0,0,0,0,128,191,0,0,0,0,199,19,1,61,0,0,0,0,143,114,144,190,0,0,0,0,0,0,128,191,0,0,0,0,40,242,20,62,0,0,0,0,242,206,129,190,0,0,0,0,0,0,128,191,0,0,0,0,171,208,224,189,106,164,133,61,15,186,140,190,0,0,0,0,0,0,128,63,0,0,0,0,13,53,170,61,106,164,133,61,134,59,167,190,0,0,0,0,0,0,128,63,0,0,0,0,199,47,124,189,106,164,133,61,189,82,166,190,0,0,0,0,0,0,128,63,0,0,0,0,103,213,231,187,106,164,133,61,47,138,174,190,124,10,32,62,149,241,111,60,141,211,124,191,13,53,170,61,106,164,133,61,134,59,167,190,124,10,32,62,149,241,111,60,141,211,124,191,16,89,164,61,0,0,0,0,165,245,167,190,124,10,32,62,149,241,111,60,141,211,124,191,192,32,105,189,106,164,133,61,218,59,3,191,0,0,0,0,0,0,128,63,0,0,0,0,95,183,232,61,106,164,133,61,63,142,2,191,0,0,0,0,0,0,128,63,0,0,0,0,122,198,190,59,106,164,133,61,23,70,6,191,0,0,0,0,0,0,128,63,0,0,0,0,221,182,47,190,0,0,0,0,4,87,169,190,0,0,0,0,0,0,128,191,0,0,0,0,0,116,216,189,0,0,0,0,122,198,174,190,0,0,0,0,0,0,128,191,0,0,0,0,206,82,210,189,0,0,0,0,174,214,145,190,0,0,0,0,0,0,128,191,0,0,0,0,60,47,85,61,106,164,133,61,231,112,173,59,190,221,146,59,66,124,0,62,106,249,125,63,1,162,96,189,106,164,133,61,154,68,189,59,190,221,146,59,66,124,0,62,106,249,125,63,113,1,232,188,0,0,0,0,197,230,99,60,190,221,146,59,66,124,0,62,106,249,125,63,248,166,169,61,106,164,133,61,49,67,115,190,1,252,127,191,43,51,37,60,126,225,149,59,119,77,168,61,0,0,0,0,57,127,115,190,1,252,127,191,43,51,37,60,126,225,149,59,139,168,169,61,0,0,0,0,97,142,190,189,1,252,127,191,43,51,37,60,126,225,149,59,206,82,210,189,0,0,0,0,174,214,145,190,141,210,165,188,211,192,15,60,19,240,127,63,199,19,1,61,0,0,0,0,143,114,144,190,141,210,165,188,211,192,15,60,19,240,127,63,84,29,242,60,106,164,133,61,198,194,144,190,141,210,165,188,211,192,15,60,19,240,127,63,1,162,96,189,106,164,133,61,154,68,189,59,0,0,0,0,0,0,128,63,0,0,0,0,0,59,247,61,106,164,133,61,180,146,22,189,0,0,0,0,0,0,128,63,0,0,0,0,64,193,5,190,106,164,133,61,48,47,64,189,0,0,0,0,0,0,128,63,0,0,0,0,16,205,44,190,0,0,0,0,159,117,29,190,0,0,0,0,0,0,128,191,0,0,0,0,221,182,47,190,0,0,0,0,4,87,169,190,0,0,0,0,0,0,128,191,0,0,0,0,71,57,184,189,0,0,0,0,11,68,111,190,0,0,0,0,0,0,128,191,0,0,0,0,175,68,32,62,106,164,133,61,250,180,234,189,206,170,103,63,214,30,182,61,19,14,213,62,0,59,247,61,106,164,133,61,180,146,22,189,206,170,103,63,214,30,182,61,19,14,213,62,12,204,10,62,0,0,0,0,127,132,97,189,206,170,103,63,214,30,182,61,19,14,213,62,27,244,37,61,106,164,133,61,31,188,238,190,0,0,0,0,0,0,128,63,0,0,0,0,201,228,244,61,106,164,133,61,21,59,226,190,0,0,0,0,0,0,128,63,0,0,0,0,95,183,232,61,106,164,133,61,63,142,2,191,0,0,0,0,0,0,128,63,0,0,0,0,113,1,232,188,0,0,0,0,197,230,99,60,0,0,0,0,0,0,128,191,0,0,0,0,223,108,3,190,0,0,0,0,49,94,51,189,0,0,0,0,0,0,128,191,0,0,0,0,197,113,160,61,0,0,0,0,195,244,189,187,0,0,0,0,0,0,128,191,0,0,0,0,117,230,46,190,106,164,133,61,153,73,172,190,208,97,114,191,201,33,98,60,90,157,164,190,43,77,10,190,106,164,133,61,14,45,226,190,208,97,114,191,201,33,98,60,90,157,164,190,73,161,12,190,0,0,0,0,102,46,224,190,208,97,114,191,201,33,98,60,90,157,164,190,0,59,247,61,106,164,133,61,180,146,22,189,94,105,5,63,22,222,133,61,216,216,89,63,60,47,85,61,106,164,133,61,231,112,173,59,94,105,5,63,22,222,133,61,216,216,89,63,197,113,160,61,0,0,0,0,195,244,189,187,94,105,5,63,22,222,133,61,216,216,89,63,119,77,168,61,0,0,0,0,57,127,115,190,0,0,0,0,0,0,128,191,0,0,0,0,40,242,20,62,0,0,0,0,242,206,129,190,0,0,0,0,0,0,128,191,0,0,0,0,89,192,36,62,0,0,0,0,129,95,35,190,0,0,0,0,0,0,128,191,0,0,0,0,252,255,120,189,0,0,0,0,49,207,2,191,0,0,0,0,0,0,128,191,0,0,0,0,141,13,221,59,0,0,0,0,58,30,7,191,0,0,0,0,0,0,128,191,0,0,0,0,240,194,246,61,0,0,0,0,61,70,1,191,0,0,0,0,0,0,128,191,0,0,0,0,223,108,3,190,0,0,0,0,49,94,51,189,0,0,0,0,0,0,128,191,0,0,0,0,12,204,10,62,0,0,0,0,127,132,97,189,0,0,0,0,0,0,128,191,0,0,0,0,197,113,160,61,0,0,0,0,195,244,189,187,0,0,0,0,0,0,128,191,0,0,0,0,248,166,169,61,106,164,133,61,49,67,115,190,234,147,40,191,181,110,131,59,9,168,64,63,199,19,1,61,0,0,0,0,143,114,144,190,234,147,40,191,181,110,131,59,9,168,64,63,119,77,168,61,0,0,0,0,57,127,115,190,234,147,40,191,181,110,131,59,9,168,64,63,201,228,244,61,106,164,133,61,21,59,226,190,67,199,150,190,166,70,136,189,212,13,116,63,27,244,37,61,106,164,133,61,31,188,238,190,67,199,150,190,166,70,136,189,212,13,116,63,185,112,224,61,0,0,0,0,121,36,230,190,67,199,150,190,166,70,136,189,212,13,116,63,67,59,103,189,106,164,133,61,31,190,140,190,38,141,93,63,243,200,15,190,41,62,246,62,71,58,195,189,106,164,133,61,1,219,81,190,38,141,93,63,243,200,15,190,41,62,246,62,71,57,184,189,0,0,0,0,11,68,111,190,38,141,93,63,243,200,15,190,41,62,246,62,100,120,28,62,106,164,133,61,111,69,114,190,16,4,124,63,161,20,141,189,101,142,37,190,89,192,36,62,0,0,0,0,129,95,35,190,16,4,124,63,161,20,141,189,101,142,37,190,40,242,20,62,0,0,0,0,242,206,129,190,16,4,124,63,161,20,141,189,101,142,37,190,221,182,47,190,0,0,0,0,4,87,169,190,0,0,0,0,0,0,128,191,0,0,0,0,206,82,210,189,0,0,0,0,174,214,145,190,0,0,0,0,0,0,128,191,0,0,0,0,71,57,184,189,0,0,0,0,11,68,111,190,0,0,0,0,0,0,128,191,0,0,0,0,57,179,45,190,106,164,133,61,136,101,35,190,212,242,127,191,30,252,68,188,60,165,131,60,221,182,47,190,0,0,0,0,4,87,169,190,212,242,127,191,30,252,68,188,60,165,131,60,16,205,44,190,0,0,0,0,159,117,29,190,212,242,127,191,30,252,68,188,60,165,131,60,117,230,46,190,106,164,133,61,153,73,172,190,0,0,0,0,0,0,128,63,0,0,0,0,171,208,224,189,106,164,133,61,15,186,140,190,0,0,0,0,0,0,128,63,0,0,0,0,223,169,192,189,106,164,133,61,10,218,196,190,0,0,0,0,0,0,128,63,0,0,0,0,1,162,96,189,106,164,133,61,154,68,189,59,255,32,18,191,48,98,159,60,7,35,82,63,64,193,5,190,106,164,133,61,48,47,64,189,255,32,18,191,48,98,159,60,7,35,82,63,223,108,3,190,0,0,0,0,49,94,51,189,255,32,18,191,48,98,159,60,7,35,82,63,16,205,44,190,0,0,0,0,159,117,29,190,0,0,0,0,0,0,128,191,0,0,0,0,71,57,184,189,0,0,0,0,11,68,111,190,0,0,0,0,0,0,128,191,0,0,0,0,38,53,180,189,0,0,0,0,146,35,189,189,0,0,0,0,0,0,128,191,0,0,0,0,57,179,45,190,106,164,133,61,136,101,35,190,0,0,0,0,0,0,128,63,0,0,0,0,67,59,103,189,106,164,133,61,31,190,140,190,0,0,0,0,0,0,128,63,0,0,0,0,117,230,46,190,106,164,133,61,153,73,172,190,0,0,0,0,0,0,128,63,0,0,0,0,199,47,124,189,106,164,133,61,189,82,166,190,102,162,144,190,198,252,92,187,100,146,117,191,103,213,231,187,106,164,133,61,47,138,174,190,102,162,144,190,198,252,92,187,100,146,117,191,56,75,201,187,0,0,0,0,21,144,174,190,102,162,144,190,198,252,92,187,100,146,117,191,252,255,120,189,0,0,0,0,49,207,2,191,0,0,0,0,0,0,128,191,0,0,0,0,240,194,246,61,0,0,0,0,61,70,1,191,0,0,0,0,0,0,128,191,0,0,0,0,27,186,25,61,0,0,0,0,85,52,238,190,0,0,0,0,0,0,128,191,0,0,0,0,27,186,25,61,0,0,0,0,85,52,238,190,0,0,0,0,0,0,128,191,0,0,0,0,240,194,246,61,0,0,0,0,61,70,1,191,0,0,0,0,0,0,128,191,0,0,0,0,185,112,224,61,0,0,0,0,121,36,230,190,0,0,0,0,0,0,128,191,0,0,0,0,206,82,210,189,0,0,0,0,174,214,145,190,0,0,0,0,0,0,128,191,0,0,0,0,149,214,255,61,0,0,0,0,78,212,146,190,0,0,0,0,0,0,128,191,0,0,0,0,199,19,1,61,0,0,0,0,143,114,144,190,0,0,0,0,0,0,128,191,0,0,0,0,211,246,175,187,106,164,133,61,0,54,32,189,0,0,0,0,0,0,128,63,0,0,0,0,0,59,247,61,106,164,133,61,180,146,22,189,0,0,0,0,0,0,128,63,0,0,0,0,89,249,165,61,106,164,133,61,64,18,182,189,0,0,0,0,0,0,128,63,0,0,0,0,64,193,5,190,106,164,133,61,48,47,64,189,0,0,0,0,0,0,128,63,0,0,0,0,211,246,175,187,106,164,133,61,0,54,32,189,0,0,0,0,0,0,128,63,0,0,0,0,71,57,184,189,106,164,133,61,213,3,198,189,0,0,0,0,0,0,128,63,0,0,0,0,139,168,169,61,0,0,0,0,97,142,190,189,0,0,0,0,0,0,128,191,0,0,0,0,89,192,36,62,0,0,0,0,129,95,35,190,0,0,0,0,0,0,128,191,0,0,0,0,12,204,10,62,0,0,0,0,127,132,97,189,0,0,0,0,0,0,128,191,0,0,0,0,223,108,3,190,0,0,0,0,49,94,51,189,0,0,0,0,0,0,128,191,0,0,0,0,38,53,180,189,0,0,0,0,146,35,189,189,0,0,0,0,0,0,128,191,0,0,0,0,143,252,193,57,0,0,0,0,196,5,32,189,0,0,0,0,0,0,128,191,0,0,0,0,248,166,169,61,106,164,133,61,49,67,115,190,0,0,0,0,0,0,128,63,0,0,0,0,100,120,28,62,106,164,133,61,111,69,114,190,0,0,0,0,0,0,128,63,0,0,0,0,84,29,242,60,106,164,133,61,198,194,144,190,0,0,0,0,0,0,128,63,0,0,0,0,57,179,45,190,106,164,133,61,136,101,35,190,64,249,127,191,174,44,81,60,249,244,216,59,117,230,46,190,106,164,133,61,153,73,172,190,64,249,127,191,174,44,81,60,249,244,216,59,221,182,47,190,0,0,0,0,4,87,169,190,64,249,127,191,174,44,81,60,249,244,216,59,57,179,45,190,106,164,133,61,136,101,35,190,0,0,0,0,0,0,128,63,0,0,0,0,71,57,184,189,106,164,133,61,213,3,198,189,0,0,0,0,0,0,128,63,0,0,0,0,71,58,195,189,106,164,133,61,1,219,81,190,0,0,0,0,0,0,128,63,0,0,0,0,175,68,32,62,106,164,133,61,250,180,234,189,107,158,119,63,166,10,198,189,175,68,112,62,12,204,10,62,0,0,0,0,127,132,97,189,107,158,119,63,166,10,198,189,175,68,112,62,89,192,36,62,0,0,0,0,129,95,35,190,107,158,119,63,166,10,198,189,175,68,112,62,89,249,165,61,106,164,133,61,64,18,182,189,152,23,12,191,202,163,27,61,179,11,86,191,139,168,169,61,0,0,0,0,97,142,190,189,152,23,12,191,202,163,27,61,179,11,86,191,143,252,193,57,0,0,0,0,196,5,32,189,152,23,12,191,202,163,27,61,179,11,86,191,43,77,10,190,106,164,133,61,14,45,226,190,0,0,0,0,0,0,128,63,0,0,0,0,27,244,37,61,106,164,133,61,31,188,238,190,0,0,0,0,0,0,128,63,0,0,0,0,31,46,217,189,106,164,133,61,113,5,244,190,0,0,0,0,0,0,128,63,0,0,0,0,199,19,1,61,0,0,0,0,143,114,144,190,0,0,0,0,0,0,128,191,0,0,0,0,149,214,255,61,0,0,0,0,78,212,146,190,0,0,0,0,0,0,128,191,0,0,0,0,40,242,20,62,0,0,0,0,242,206,129,190,0,0,0,0,0,0,128,191,0,0,0,0,89,249,165,61,106,164,133,61,64,18,182,189,0,0,0,0,0,0,128,63,0,0,0,0,175,68,32,62,106,164,133,61,250,180,234,189,0,0,0,0,0,0,128,63,0,0,0,0,248,166,169,61,106,164,133,61,49,67,115,190,0,0,0,0,0,0,128,63,0,0,0,0,27,244,37,61,106,164,133,61,31,188,238,190,7,121,13,62,21,168,69,189,112,62,125,63,49,126,26,189,106,164,133,61,7,36,233,190,7,121,13,62,21,168,69,189,112,62,125,63,108,175,133,188,0,0,0,0,1,77,236,190,7,121,13,62,21,168,69,189,112,62,125,63,211,246,175,187,106,164,133,61,0,54,32,189,44,17,4,63,117,90,55,61,33,1,91,191,143,252,193,57,0,0,0,0,196,5,32,189,44,17,4,63,117,90,55,61,33,1,91,191,38,53,180,189,0,0,0,0,146,35,189,189,44,17,4,63,117,90,55,61,33,1,91,191,67,59,103,189,106,164,133,61,31,190,140,190,208,210,37,63,191,239,15,62,201,175,63,63,71,57,184,189,0,0,0,0,11,68,111,190,208,210,37,63,191,239,15,62,201,175,63,63,228,129,8,189,0,0,0,0,183,182,144,190,208,210,37,63,191,239,15,62,201,175,63,63,60,47,85,61,106,164,133,61,231,112,173,59,113,58,57,62,153,128,191,189,245,162,122,63,113,1,232,188,0,0,0,0,197,230,99,60,113,58,57,62,153,128,191,189,245,162,122,63,197,113,160,61,0,0,0,0,195,244,189,187,113,58,57,62,153,128,191,189,245,162,122,63,192,32,105,189,106,164,133,61,218,59,3,191,0,0,0,0,0,0,128,63,0,0,0,0,27,244,37,61,106,164,133,61,31,188,238,190,0,0,0,0,0,0,128,63,0,0,0,0,95,183,232,61,106,164,133,61,63,142,2,191,0,0,0,0,0,0,128,63,0,0,0,0,43,190,33,187,106,164,133,61,129,92,146,190,0,0,0,0,0,0,128,63,0,0,0,0,84,29,242,60,106,164,133,61,198,194,144,190,0,0,0,0,0,0,128,63,0,0,0,0,149,214,255,61,106,164,133,61,78,212,146,190,0,0,0,0,0,0,128,63,0,0,0,0,71,57,184,189,106,164,133,61,213,3,198,189,99,241,15,63,73,131,27,189,200,121,83,191,211,246,175,187,106,164,133,61,0,54,32,189,99,241,15,63,73,131,27,189,200,121,83,191,38,53,180,189,0,0,0,0,146,35,189,189,99,241,15,63,73,131,27,189,200,121,83,191,49,126,26,189,106,164,133,61,7,36,233,190,208,15,71,63,163,119,234,189,208,70,30,63,223,169,192,189,106,164,133,61,10,218,196,190,208,15,71,63,163,119,234,189,208,70,30,63,206,142,148,189,0,0,0,0,222,231,216,190,208,15,71,63,163,119,234,189,208,70,30,63,31,46,217,189,0,0,0,0,113,5,244,190,0,0,0,0,0,0,128,191,0,0,0,0,252,255,120,189,0,0,0,0,49,207,2,191,0,0,0,0,0,0,128,191,0,0,0,0,27,186,25,61,0,0,0,0,85,52,238,190,0,0,0,0,0,0,128,191,0,0,0,0,73,161,12,190,0,0,0,0,102,46,224,190,0,0,0,0,0,0,128,191,0,0,0,0,31,46,217,189,0,0,0,0,113,5,244,190,0,0,0,0,0,0,128,191,0,0,0,0,27,186,25,61,0,0,0,0,85,52,238,190,0,0,0,0,0,0,128,191,0,0,0,0,84,29,242,60,106,164,133,61,198,194,144,190,0,0,0,0,0,0,128,63,0,0,0,0,100,120,28,62,106,164,133,61,111,69,114,190,0,0,0,0,0,0,128,63,0,0,0,0,149,214,255,61,106,164,133,61,78,212,146,190,0,0,0,0,0,0,128,63,0,0,0,0,64,193,5,190,106,164,133,61,48,47,64,189,0,0,0,0,0,0,128,63,0,0,0,0,71,57,184,189,106,164,133,61,213,3,198,189,0,0,0,0,0,0,128,63,0,0,0,0,57,179,45,190,106,164,133,61])
.concat([136,101,35,190,0,0,0,0,0,0,128,63,0,0,0,0,117,230,46,190,106,164,133,61,153,73,172,190,0,0,0,0,0,0,128,63,0,0,0,0,223,169,192,189,106,164,133,61,10,218,196,190,0,0,0,0,0,0,128,63,0,0,0,0,43,77,10,190,106,164,133,61,14,45,226,190,0,0,0,0,0,0,128,63,0,0,0,0,171,208,224,189,106,164,133,61,15,186,140,190,0,0,0,0,0,0,128,63,0,0,0,0,149,214,255,61,106,164,133,61,78,212,146,190,0,0,0,0,0,0,128,63,0,0,0,0,13,53,170,61,106,164,133,61,134,59,167,190,0,0,0,0,0,0,128,63,0,0,0,0,27,244,37,61,106,164,133,61,31,188,238,190,185,137,90,190,239,0,207,60,176,4,122,63,27,186,25,61,0,0,0,0,85,52,238,190,185,137,90,190,239,0,207,60,176,4,122,63,185,112,224,61,0,0,0,0,121,36,230,190,185,137,90,190,239,0,207,60,176,4,122,63,108,175,133,188,0,0,0,0,1,77,236,190,0,0,0,0,0,0,128,63,0,0,0,0,73,161,12,190,0,0,0,0,102,46,224,190,0,0,0,0,0,0,128,63,0,0,0,0,27,186,25,61,0,0,0,0,85,52,238,190,0,0,0,0,0,0,128,63,0,0,0,0,223,169,192,189,106,164,133,61,10,218,196,190,55,142,124,63,104,119,168,189,151,174,16,62,171,208,224,189,106,164,133,61,15,186,140,190,55,142,124,63,104,119,168,189,151,174,16,62,0,116,216,189,0,0,0,0,122,198,174,190,55,142,124,63,104,119,168,189,151,174,16,62,211,246,175,187,106,164,133,61,0,54,32,189,16,90,255,190,13,57,54,189,208,152,93,191,89,249,165,61,106,164,133,61,64,18,182,189,16,90,255,190,13,57,54,189,208,152,93,191,143,252,193,57,0,0,0,0,196,5,32,189,16,90,255,190,13,57,54,189,208,152,93,191,31,46,217,189,106,164,133,61,113,5,244,190,86,214,26,191,0,0,0,0,202,221,75,191,252,255,120,189,0,0,0,0,49,207,2,191,86,214,26,191,0,0,0,0,202,221,75,191,31,46,217,189,0,0,0,0,113,5,244,190,86,214,26,191,0,0,0,0,202,221,75,191,223,108,3,190,0,0,0,0,49,94,51,189,0,0,0,0,0,0,128,63,0,0,0,0,143,252,193,57,0,0,0,0,196,5,32,189,0,0,0,0,0,0,128,63,0,0,0,0,12,204,10,62,0,0,0,0,127,132,97,189,0,0,0,0,0,0,128,63,0,0,0,0,171,208,224,189,106,164,133,61,15,186,140,190,158,237,125,63,115,186,236,61,79,33,87,189,206,82,210,189,0,0,0,0,174,214,145,190,158,237,125,63,115,186,236,61,79,33,87,189,0,116,216,189,0,0,0,0,122,198,174,190,158,237,125,63,115,186,236,61,79,33,87,189,199,47,124,189,106,164,133,61,189,82,166,190,147,169,146,190,78,100,230,187,3,68,117,191,56,75,201,187,0,0,0,0,21,144,174,190,147,169,146,190,78,100,230,187,3,68,117,191,23,102,129,189,0,0,0,0,166,212,165,190,147,169,146,190,78,100,230,187,3,68,117,191,171,208,224,189,106,164,133,61,15,186,140,190,0,0,0,0,0,0,128,63,0,0,0,0,67,59,103,189,106,164,133,61,31,190,140,190,0,0,0,0,0,0,128,63,0,0,0,0,43,190,33,187,106,164,133,61,129,92,146,190,0,0,0,0,0,0,128,63,0,0,0,0,73,161,12,190,0,0,0,0,102,46,224,190,0,0,0,0,0,0,128,191,0,0,0,0,108,175,133,188,0,0,0,0,1,77,236,190,0,0,0,0,0,0,128,191,0,0,0,0,206,142,148,189,0,0,0,0,222,231,216,190,0,0,0,0,0,0,128,191,0,0,0,0,223,169,192,189,106,164,133,61,10,218,196,190,139,169,108,63,76,251,166,61,41,178,190,62,0,116,216,189,0,0,0,0,122,198,174,190,139,169,108,63,76,251,166,61,41,178,190,62,206,142,148,189,0,0,0,0,222,231,216,190,139,169,108,63,76,251,166,61,41,178,190,62,13,53,170,61,106,164,133,61,134,59,167,190,119,158,48,63,0,0,0,0,169,80,57,191,149,214,255,61,106,164,133,61,78,212,146,190,119,158,48,63,0,0,0,0,169,80,57,191,149,214,255,61,0,0,0,0,78,212,146,190,119,158,48,63,0,0,0,0,169,80,57,191,31,46,217,189,106,164,133,61,113,5,244,190,0,0,0,0,0,0,128,63,0,0,0,0,27,244,37,61,106,164,133,61,31,188,238,190,0,0,0,0,0,0,128,63,0,0,0,0,192,32,105,189,106,164,133,61,218,59,3,191,0,0,0,0,0,0,128,63,0,0,0,0,248,166,169,61,106,164,133,61,49,67,115,190,0,0,0,0,0,0,128,63,0,0,0,0,175,68,32,62,106,164,133,61,250,180,234,189,0,0,0,0,0,0,128,63,0,0,0,0,100,120,28,62,106,164,133,61,111,69,114,190,0,0,0,0,0,0,128,63,0,0,0,0,64,193,5,190,106,164,133,61,48,47,64,189,129,67,112,191,79,148,132,188,252,139,176,62,16,205,44,190,0,0,0,0,159,117,29,190,129,67,112,191,79,148,132,188,252,139,176,62,223,108,3,190,0,0,0,0,49,94,51,189,129,67,112,191,79,148,132,188,252,139,176,62,117,230,46,190,106,164,133,61,153,73,172,190,54,205,115,191,105,55,122,188,207,247,155,190,73,161,12,190,0,0,0,0,102,46,224,190,54,205,115,191,105,55,122,188,207,247,155,190,221,182,47,190,0,0,0,0,4,87,169,190,54,205,115,191,105,55,122,188,207,247,155,190,122,198,190,59,106,164,133,61,23,70,6,191,169,135,8,62,136,158,84,61,179,93,125,191,95,183,232,61,106,164,133,61,63,142,2,191,169,135,8,62,136,158,84,61,179,93,125,191,141,13,221,59,0,0,0,0,58,30,7,191,169,135,8,62,136,158,84,61,179,93,125,191,49,126,26,189,106,164,133,61,7,36,233,190,145,69,14,63,188,122,213,61,95,37,83,63,206,142,148,189,0,0,0,0,222,231,216,190,145,69,14,63,188,122,213,61,95,37,83,63,108,175,133,188,0,0,0,0,1,77,236,190,145,69,14,63,188,122,213,61,95,37,83,63,185,112,224,61,0,0,0,0,121,36,230,190,217,124,124,63,234,62,16,190,48,74,176,189,95,183,232,61,106,164,133,61,63,142,2,191,217,124,124,63,234,62,16,190,48,74,176,189,201,228,244,61,106,164,133,61,21,59,226,190,217,124,124,63,234,62,16,190,48,74,176,189,221,182,47,190,0,0,0,0,4,87,169,190,0,0,0,0,0,0,128,191,0,0,0,0,73,161,12,190,0,0,0,0,102,46,224,190,0,0,0,0,0,0,128,191,0,0,0,0,206,142,148,189,0,0,0,0,222,231,216,190,0,0,0,0,0,0,128,191,0,0,0,0,43,190,33,187,106,164,133,61,129,92,146,190,107,98,1,61,114,83,131,189,92,88,127,191,228,129,8,189,0,0,0,0,183,182,144,190,107,98,1,61,114,83,131,189,92,88,127,191,206,82,210,189,0,0,0,0,174,214,145,190,107,98,1,61,114,83,131,189,92,88,127,191,49,126,26,189,106,164,133,61,7,36,233,190,64,218,255,56,0,0,128,191,38,29,101,58,27,244,37,61,106,164,133,61,31,188,238,190,64,218,255,56,0,0,128,191,38,29,101,58,43,77,10,190,106,164,133,61,14,45,226,190,64,218,255,56,0,0,128,191,38,29,101,58,221,182,47,190,0,0,0,0,4,87,169,190,0,0,0,0,0,0,128,191,0,0,0,0,206,142,148,189,0,0,0,0,222,231,216,190,0,0,0,0,0,0,128,191,0,0,0,0,0,116,216,189,0,0,0,0,122,198,174,190,0,0,0,0,0,0,128,191,0,0,0,0,139,168,169,61,0,0,0,0,97,142,190,189,0,0,0,0,0,0,128,191,0,0,0,0,119,77,168,61,0,0,0,0,57,127,115,190,0,0,0,0,0,0,128,191,0,0,0,0,89,192,36,62,0,0,0,0,129,95,35,190,0,0,0,0,0,0,128,191,0,0,0,0,95,183,232,61,106,164,133,61,63,142,2,191,111,47,73,62,85,249,94,189,157,159,122,191,240,194,246,61,0,0,0,0,61,70,1,191,111,47,73,62,85,249,94,189,157,159,122,191,141,13,221,59,0,0,0,0,58,30,7,191,111,47,73,62,85,249,94,189,157,159,122,191,141,13,221,59,0,0,0,0,58,30,7,191,235,56,62,190,195,102,64,61,175,65,123,191,192,32,105,189,106,164,133,61,218,59,3,191,235,56,62,190,195,102,64,61,175,65,123,191,122,198,190,59,106,164,133,61,23,70,6,191,235,56,62,190,195,102,64,61,175,65,123,191,248,166,169,61,106,164,133,61,49,67,115,190,51,138,37,191,221,150,72,188,28,64,67,63,84,29,242,60,106,164,133,61,198,194,144,190,51,138,37,191,221,150,72,188,28,64,67,63,199,19,1,61,0,0,0,0,143,114,144,190,51,138,37,191,221,150,72,188,28,64,67,63,13,53,170,61,106,164,133,61,134,59,167,190,24,179,45,63,53,126,97,188,113,5,60,191,149,214,255,61,0,0,0,0,78,212,146,190,24,179,45,63,53,126,97,188,113,5,60,191,16,89,164,61,0,0,0,0,165,245,167,190,24,179,45,63,53,126,97,188,113,5,60,191,43,77,10,190,106,164,133,61,14,45,226,190,57,42,71,191,53,67,42,188,82,209,32,191,31,46,217,189,0,0,0,0,113,5,244,190,57,42,71,191,53,67,42,188,82,209,32,191,73,161,12,190,0,0,0,0,102,46,224,190,57,42,71,191,53,67,42,188,82,209,32,191,206,82,210,189,0,0,0,0,174,214,145,190,0,0,0,0,0,0,128,191,0,0,0,0,16,89,164,61,0,0,0,0,165,245,167,190,0,0,0,0,0,0,128,191,0,0,0,0,149,214,255,61,0,0,0,0,78,212,146,190,0,0,0,0,0,0,128,191,0,0,0,0,57,179,45,190,106,164,133,61,136,101,35,190,0,0,0,0,0,0,128,63,0,0,0,0,71,58,195,189,106,164,133,61,1,219,81,190,0,0,0,0,0,0,128,63,0,0,0,0,67,59,103,189,106,164,133,61,31,190,140,190,0,0,0,0,0,0,128,63,0,0,0,0,31,46,217,189,106,164,133,61,113,5,244,190,145,95,23,191,14,187,111,60,202,106,78,191,192,32,105,189,106,164,133,61,218,59,3,191,145,95,23,191,14,187,111,60,202,106,78,191,252,255,120,189,0,0,0,0,49,207,2,191,145,95,23,191,14,187,111,60,202,106,78,191,141,13,221,59,0,0,0,0,58,30,7,191,28,153,119,190,249,163,40,188,208,99,120,191,252,255,120,189,0,0,0,0,49,207,2,191,28,153,119,190,249,163,40,188,208,99,120,191,192,32,105,189,106,164,133,61,218,59,3,191,28,153,119,190,249,163,40,188,208,99,120,191,71,58,195,189,106,164,133,61,1,219,81,190,219,79,126,63,219,248,211,61,47,247,73,189,71,57,184,189,106,164,133,61,213,3,198,189,219,79,126,63,219,248,211,61,47,247,73,189,71,57,184,189,0,0,0,0,11,68,111,190,219,79,126,63,219,248,211,61,47,247,73,189,206,82,210,189,0,0,0,0,174,214,145,190,51,81,196,189,23,128,38,62,254,101,123,63,84,29,242,60,106,164,133,61,198,194,144,190,51,81,196,189,23,128,38,62,254,101,123,63,43,190,33,187,106,164,133,61,129,92,146,190,51,81,196,189,23,128,38,62,254,101,123,63,89,249,165,61,106,164,133,61,64,18,182,189,176,227,127,191,31,106,219,188,163,201,69,188,248,166,169,61,106,164,133,61,49,67,115,190,176,227,127,191,31,106,219,188,163,201,69,188,139,168,169,61,0,0,0,0,97,142,190,189,176,227,127,191,31,106,219,188,163,201,69,188,117,230,46,190,106,164,133,61,153,73,172,190,0,0,0,0,0,0,128,191,0,0,0,0,67,59,103,189,106,164,133,61,31,190,140,190,0,0,0,0,0,0,128,191,0,0,0,0,171,208,224,189,106,164,133,61,15,186,140,190,0,0,0,0,0,0,128,191,0,0,0,0,43,77,10,190,106,164,133,61,14,45,226,190,144,191,68,191,0,0,0,0,105,201,35,191,31,46,217,189,106,164,133,61,113,5,244,190,144,191,68,191,0,0,0,0,105,201,35,191,31,46,217,189,0,0,0,0,113,5,244,190,144,191,68,191,0,0,0,0,105,201,35,191,43,190,33,187,106,164,133,61,129,92,146,190,210,196,75,62,49,183,59,189,23,155,122,63,67,59,103,189,106,164,133,61,31,190,140,190,210,196,75,62,49,183,59,189,23,155,122,63,228,129,8,189,0,0,0,0,183,182,144,190,210,196,75,62,49,183,59,189,23,155,122,63,23,102,129,189,0,0,0,0,166,212,165,190,0,0,0,0,0,0,128,191,0,0,0,0,56,75,201,187,0,0,0,0,21,144,174,190,0,0,0,0,0,0,128,191,0,0,0,0,16,89,164,61,0,0,0,0,165,245,167,190,0,0,0,0,0,0,128,191,0,0,0,0,103,213,231,187,106,164,133,61,47,138,174,190,64,48,23,62,139,27,55,59,135,49,125,191,16,89,164,61,0,0,0,0,165,245,167,190,64,48,23,62,139,27,55,59,135,49,125,191,56,75,201,187,0,0,0,0,21,144,174,190,64,48,23,62,139,27,55,59,135,49,125,191,1,162,96,189,106,164,133,61,154,68,189,59,0,0,0,0,0,0,128,63,0,0,0,0,60,47,85,61,106,164,133,61,231,112,173,59,0,0,0,0,0,0,128,63,0,0,0,0,0,59,247,61,106,164,133,61,180,146,22,189,0,0,0,0,0,0,128,63,0,0,0,0,206,82,210,189,0,0,0,0,174,214,145,190,0,0,0,0,0,0,128,191,0,0,0,0,228,129,8,189,0,0,0,0,183,182,144,190,0,0,0,0,0,0,128,191,0,0,0,0,71,57,184,189,0,0,0,0,11,68,111,190,0,0,0,0,0,0,128,191,0,0,0,0,64,193,5,190,106,164,133,61,48,47,64,189,0,0,0,0,0,0,128,191,0,0,0,0,0,59,247,61,106,164,133,61,180,146,22,189,0,0,0,0,0,0,128,191,0,0,0,0,211,246,175,187,106,164,133,61,0,54,32,189,0,0,0,0,0,0,128,191,0,0,0,0,100,120,28,62,106,164,133,61,111,69,114,190,155,229,126,63,119,132,179,61,96,5,248,188,175,68,32,62,106,164,133,61,250,180,234,189,155,229,126,63,119,132,179,61,96,5,248,188,89,192,36,62,0,0,0,0,129,95,35,190,155,229,126,63,119,132,179,61,96,5,248,188,223,108,3,190,0,0,0,0,49,94,51,189,0,0,0,0,0,0,128,191,0,0,0,0,16,205,44,190,0,0,0,0,159,117,29,190,0,0,0,0,0,0,128,191,0,0,0,0,38,53,180,189,0,0,0,0,146,35,189,189,0,0,0,0,0,0,128,191,0,0,0,0,0,59,247,61,106,164,133,61,180,146,22,189,145,181,38,63,59,57,131,189,171,149,65,63,197,113,160,61,0,0,0,0,195,244,189,187,145,181,38,63,59,57,131,189,171,149,65,63,12,204,10,62,0,0,0,0,127,132,97,189,145,181,38,63,59,57,131,189,171,149,65,63,71,57,184,189,106,164,133,61,213,3,198,189,236,221,127,63,255,117,238,60,106,50,99,188,38,53,180,189,0,0,0,0,146,35,189,189,236,221,127,63,255,117,238,60,106,50,99,188,71,57,184,189,0,0,0,0,11,68,111,190,236,221,127,63,255,117,238,60,106,50,99,188,185,112,224,61,0,0,0,0,121,36,230,190,179,120,121,63,213,203,239,61,167,4,68,62,240,194,246,61,0,0,0,0,61,70,1,191,179,120,121,63,213,203,239,61,167,4,68,62,95,183,232,61,106,164,133,61,63,142,2,191,179,120,121,63,213,203,239,61,167,4,68,62,171,208,224,189,106,164,133,61,15,186,140,190,90,216,51,191,48,127,5,61,185,254,53,191,23,102,129,189,0,0,0,0,166,212,165,190,90,216,51,191,48,127,5,61,185,254,53,191,206,82,210,189,0,0,0,0,174,214,145,190,90,216,51,191,48,127,5,61,185,254,53,191,143,252,193,57,0,0,0,0,196,5,32,189,0,0,0,0,0,0,128,191,0,0,0,0,139,168,169,61,0,0,0,0,97,142,190,189,0,0,0,0,0,0,128,191,0,0,0,0,12,204,10,62,0,0,0,0,127,132,97,189,0,0,0,0,0,0,128,191,0,0,0,0,43,77,10,190,106,164,133,61,14,45,226,190,0,0,0,0,0,0,128,63,0,0,0,0,223,169,192,189,106,164,133,61,10,218,196,190,0,0,0,0,0,0,128,63,0,0,0,0,49,126,26,189,106,164,133,61,7,36,233,190,0,0,0,0,0,0,128,63,0,0,0,0,149,214,255,61,106,164,133,61,78,212,146,190,209,177,95,63,236,79,226,60,193,145,248,190,100,120,28,62,106,164,133,61,111,69,114,190,209,177,95,63,236,79,226,60,193,145,248,190,40,242,20,62,0,0,0,0,242,206,129,190,209,177,95,63,236,79,226,60,193,145,248,190,149,214,255,61,106,164,133,61,78,212,146,190,146,205,89,63,0,0,0,0,60,135,6,191,40,242,20,62,0,0,0,0,242,206,129,190,146,205,89,63,0,0,0,0,60,135,6,191,149,214,255,61,0,0,0,0,78,212,146,190,146,205,89,63,0,0,0,0,60,135,6,191,199,47,124,189,106,164,133,61,189,82,166,190,0,0,0,0,0,0,128,63,0,0,0,0,13,53,170,61,106,164,133,61,134,59,167,190,0,0,0,0,0,0,128,63,0,0,0,0,103,213,231,187,106,164,133,61,47,138,174,190,0,0,0,0,0,0,128,63,0,0,0,0,64,193,5,190,106,164,133,61,48,47,64,189,152,223,113,191,104,5,134,60,236,132,167,62,57,179,45,190,106,164,133,61,136,101,35,190,152,223,113,191,104,5,134,60,236,132,167,62,16,205,44,190,0,0,0,0,159,117,29,190,152,223,113,191,104,5,134,60,236,132,167,62,171,208,224,189,106,164,133,61,15,186,140,190,0,0,0,0,0,0,128,191,0,0,0,0,43,190,33,187,106,164,133,61,129,92,146,190,0,0,0,0,0,0,128,191,0,0,0,0,149,214,255,61,106,164,133,61,78,212,146,190,0,0,0,0,0,0,128,191,0,0,0,0,171,208,224,189,106,164,133,61,15,186,140,190,245,71,56,191,124,72,248,59,226,175,49,191,199,47,124,189,106,164,133,61,189,82,166,190,245,71,56,191,124,72,248,59,226,175,49,191,23,102,129,189,0,0,0,0,166,212,165,190,245,71,56,191,124,72,248,59,226,175,49,191,1,162,96,189,106,164,133,61,154,68,189,59,83,176,254,190,116,239,193,189,173,192,92,63,223,108,3,190,0,0,0,0,49,94,51,189,83,176,254,190,116,239,193,189,173,192,92,63,113,1,232,188,0,0,0,0,197,230,99,60,83,176,254,190,116,239,193,189,173,192,92,63,206,82,210,189,0,0,0,0,174,214,145,190,0,0,0,0,0,0,128,191,0,0,0,0,23,102,129,189,0,0,0,0,166,212,165,190,0,0,0,0,0,0,128,191,0,0,0,0,16,89,164,61,0,0,0,0,165,245,167,190,0,0,0,0,0,0,128,191,0,0,0,0,27,244,37,61,106,164,133,61,31,188,238,190,98,15,141,61,184,233,79,60,11,95,127,63,108,175,133,188,0,0,0,0,1,77,236,190,98,15,141,61,184,233,79,60,11,95,127,63,27,186,25,61,0,0,0,0,85,52,238,190,98,15,141,61,184,233,79,60,11,95,127,63,176,55,33,190,0,0,0,0,247,147,233,190,0,0,0,0,0,0,128,191,0,0,0,0,176,55,33,190,0,0,0,0,197,203,3,191,0,0,0,0,0,0,128,191,0,0,0,0,37,179,42,62,0,0,0,0,197,203,3,191,0,0,0,0,0,0,128,191,0,0,0,0,176,55,33,190,0,0,0,0,247,147,233,190,0,0,0,0,0,0,128,191,0,0,0,0,37,179,42,62,0,0,0,0,197,203,3,191,0,0,0,0,0,0,128,191,0,0,0,0,37,179,42,62,0,0,0,0,119,104,248,190,0,0,0,0,0,0,128,191,0,0,0,0,176,55,33,190,0,0,0,0,247,147,233,190,0,0,0,0,0,0,128,191,0,0,0,0,37,179,42,62,0,0,0,0,119,104,248,190,0,0,0,0,0,0,128,191,0,0,0,0,224,128,182,61,0,0,0,0,247,147,233,190,0,0,0,0,0,0,128,191,0,0,0,0,224,128,182,61,0,0,0,0,247,147,233,190,0,0,0,0,0,0,128,191,0,0,0,0,37,179,42,62,0,0,0,0,119,104,248,190,0,0,0,0,0,0,128,191,0,0,0,0,35,218,142,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,52,185,184,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,224,128,182,61,0,0,0,0,247,147,233,190,0,0,0,0,0,0,128,191,0,0,0,0,35,218,142,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,176,55,33,190,106,164,133,61,247,147,233,190,0,0,0,0,0,0,128,63,0,0,0,0,37,179,42,62,106,164,133,61,197,203,3,191,0,0,0,0,0,0,128,63,0,0,0,0,176,55,33,190,106,164,133,61,197,203,3,191,0,0,0,0,0,0,128,63,0,0,0,0,176,55,33,190,106,164,133,61,247,147,233,190,0,0,0,0,0,0,128,63,0,0,0,0,37,179,42,62,106,164,133,61,119,104,248,190,0,0,0,0,0,0,128,63,0,0,0,0,37,179,42,62,106,164,133,61,197,203,3,191,0,0,0,0,0,0,128,63,0,0,0,0,176,55,33,190,106,164,133,61,247,147,233,190,0,0,0,0,0,0,128,63,0,0,0,0,224,128,182,61,106,164,133,61,247,147,233,190,0,0,0,0,0,0,128,63,0,0,0,0,37,179,42,62,106,164,133,61,119,104,248,190,0,0,0,0,0,0,128,63,0,0,0,0,224,128,182,61,106,164,133,61,247,147,233,190,0,0,0,0,0,0,128,63,0,0,0,0,35,218,142,188,106,164,133,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,37,179,42,62,106,164,133,61,119,104,248,190,0,0,0,0,0,0,128,63,0,0,0,0,52,185,184,189,106,164,133,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,35,218,142,188,106,164,133,61,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,224,128,182,61,106,164,133,61,247,147,233,190,0,0,0,0,0,0,128,63,0,0,0,0,35,218,142,188,106,164,133,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,52,185,184,189,106,164,133,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,52,185,184,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,52,185,184,189,106,164,133,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,52,185,184,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,35,218,142,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,37,179,42,62,106,164,133,61,119,104,248,190,130,87,111,63,0,0,0,0,205,172,181,62,35,218,142,188,106,164,133,61,0,0,0,0,130,87,111,63,0,0,0,0,205,172,181,62,35,218,142,188,0,0,0,0,0,0,0,0,130,87,111,63,0,0,0,0,205,172,181,62,35,218,142,188,106,164,133,61,0,0,0,0,130,87,111,63,0,0,0,0,205,172,181,62,35,218,142,188,0,0,0,0,0,0,0,0,130,87,111,63,0,0,0,0,205,172,181,62,37,179,42,62,0,0,0,0,119,104,248,190,130,87,111,63,0,0,0,0,205,172,181,62,52,185,184,189,106,164,133,61,0,0,0,0,213,65,110,191,0,0,0,0,203,74,187,190,224,128,182,61,106,164,133,61,247,147,233,190,213,65,110,191,0,0,0,0,203,74,187,190,224,128,182,61,0,0,0,0,247,147,233,190,213,65,110,191,0,0,0,0,203,74,187,190,224,128,182,61,106,164,133,61,247,147,233,190,213,65,110,191,0,0,0,0,203,74,187,190,224,128,182,61,0,0,0,0,247,147,233,190,213,65,110,191,0,0,0,0,203,74,187,190,52,185,184,189,0,0,0,0,0,0,0,0,213,65,110,191,0,0,0,0,203,74,187,190,224,128,182,61,106,164,133,61,247,147,233,190,0,0,0,0,0,0,0,0,0,0,128,63,176,55,33,190,106,164,133,61,247,147,233,190,0,0,0,0,0,0,0,0,0,0,128,63,176,55,33,190,0,0,0,0,247,147,233,190,0,0,0,0,0,0,0,0,0,0,128,63,176,55,33,190,106,164,133,61,247,147,233,190,0,0,0,0,0,0,0,0,0,0,128,63,176,55,33,190,0,0,0,0,247,147,233,190,0,0,0,0,0,0,0,0,0,0,128,63,224,128,182,61,0,0,0,0,247,147,233,190,0,0,0,0,0,0,0,0,0,0,128,63,37,179,42,62,106,164,133,61,197,203,3,191,0,0,128,63,0,0,0,0,0,0,0,0,37,179,42,62,106,164,133,61,119,104,248,190,0,0,128,63,0,0,0,0,0,0,0,0,37,179,42,62,0,0,0,0,119,104,248,190,0,0,128,63,0,0,0,0,0,0,0,0,37,179,42,62,106,164,133,61,119,104,248,190,0,0,128,63,0,0,0,0,0,0,0,0,37,179,42,62,0,0,0,0,119,104,248,190,0,0,128,63,0,0,0,0,0,0,0,0,37,179,42,62,0,0,0,0,197,203,3,191,0,0,128,63,0,0,0,0,0,0,0,0,176,55,33,190,0,0,0,0,197,203,3,191,0,0,128,191,0,0,0,0,0,0,0,0,176,55,33,190,0,0,0,0,247,147,233,190,0,0,128,191,0,0,0,0,0,0,0,0,176,55,33,190,106,164,133,61,247,147,233,190,0,0,128,191,0,0,0,0,0,0,0,0,176,55,33,190,0,0,0,0,247,147,233,190,0,0,128,191,0,0,0,0,0,0,0,0,176,55,33,190,106,164,133,61,247,147,233,190,0,0,128,191,0,0,0,0,0,0,0,0,176,55,33,190,106,164,133,61,197,203,3,191,0,0,128,191,0,0,0,0,0,0,0,0,37,179,42,62,0,0,0,0,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,176,55,33,190,0,0,0,0,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,176,55,33,190,106,164,133,61,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,176,55,33,190,0,0,0,0,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,176,55,33,190,106,164,133,61,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,37,179,42,62,106,164,133,61,197,203,3,191,0,0,0,0,0,0,0,0,0,0,128,191,124,99,40,190,106,164,133,61,43,76,191,189,0,0,0,0,0,0,128,63,0,0,0,0,241,160,185,189,106,164,133,61,97,79,187,189,0,0,0,0,0,0,128,63,0,0,0,0,253,132,35,190,106,164,133,61,77,21,76,190,0,0,0,0,0,0,128,63,0,0,0,0,158,180,32,190,106,164,133,61,114,49,190,190,174,17,125,191,111,183,20,190,249,160,39,189,155,27,19,190,0,0,0,0,207,220,235,190,174,17,125,191,111,183,20,190,249,160,39,189,208,41,24,190,0,0,0,0,29,204,174,190,174,17,125,191,111,183,20,190,249,160,39,189,198,77,29,62,106,164,133,61,64,194,96,190,208,236,126,63,3,182,163,61,212,181,54,189,248,109,40,62,0,0,0,0,40,68,192,189,208,236,126,63,3,182,163,61,212,181,54,189,117,148,35,62,0,0,0,0,216,97,76,190,208,236,126,63,3,182,163,61,212,181,54,189,112,6,63,61,106,164,133,61,14,22,238,190,148,74,200,190,58,6,20,62,176,172,104,63,104,5,6,60,0,0,0,0,75,63,241,190,148,74,200,190,58,6,20,62,176,172,104,63,211,247,154,61,0,0,0,0,233,95,226,190,148,74,200,190,58,6,20,62,176,172,104,63,53,65,84,188,106,164,133,61,71,118,37,60,72,253,69,190,69,159,143,60,12,33,123,63,30,51,208,189,106,164,133,61,223,253,241,187,72,253,69,190,69,159,143,60,12,33,123,63,37,63,98,188,0,0,0,0,49,208,53,60,72,253,69,190,69,159,143,60,12,33,123,63,150,32,163,61,106,164,133,61,173,110,101,190,150,146,113,191,254,14,157,190,79,119,254,189,29,30,194,61,0,0,0,0,87,36,54,190,150,146,113,191,254,14,157,190,79,119,254,189,7,150,163,61,0,0,0,0,56,103,132,189,150,146,113,191,254,14,157,190,79,119,254,189,42,115,147,189,0,0,0,0,160,220,230,190,148,249,127,63,124,184,100,188,23,183,209,185,137,149,145,189,106,164,133,61,250,238,230,190,148,249,127,63,124,184,100,188,23,183,209,185,58,121,145,189,106,164,133,61,135,254,161,190,148,249,127,63,124,184,100,188,23,183,209,185,159,118,152,189,0,0,0,0,218,140,139,190,0,0,0,0,0,0,128,191,0,0,0,0,126,28,141,189,0,0,0,0,146,233,160,190,0,0,0,0,0,0,128,191,0,0,0,0,14,77,9,62,0,0,0,0,245,47,161,190,0,0,0,0,0,0,128,191,0,0,0,0,230,203,75,61,106,164,133,61,121,173,156,190,0,0,0,0,0,0,128,63,0,0,0,0,226,145,152,61,106,164,133,61,218,140,139,190,0,0,0,0,0,0,128,63,0,0,0,0,145,9,40,62,106,164,133,61,134,57,193,190,0,0,0,0,0,0,128,63,0,0,0,0,169,159,39,62,106,164,133,61,192,8,186,189,192,205,78,63,197,89,145,188,187,210,22,63,29,199,207,61,0,0,0,0,161,106,244,187,192,205,78,63,197,89,145,188,187,210,22,63,248,109,40,62,0,0,0,0,40,68,192,189,192,205,78,63,197,89,145,188,187,210,22,63,163,115,158,61,106,164,133,61,171,94,126,189,0,0,0,0,0,0,128,63,0,0,0,0,2,211,201,61,106,164,133,61,200,235,193,187,0,0,0,0,0,0,128,63,0,0,0,0,169,159,39,62,106,164,133,61,192,8,186,189,0,0,0,0,0,0,128,63,0,0,0,0,168,58,228,187,106,164,133,61,190,188,240,190,106,78,254,61,251,61,201,190,117,61,105,191,42,115,147,189,0,0,0,0,160,220,230,190,106,78,254,61,251,61,201,190,117,61,105,191,155,27,19,190,0,0,0,0,207,220,235,190,106,78,254,61,251,61,201,190,117,61,105,191,253,132,35,190,106,164,133,61,77,21,76,190,0,0,0,0,0,0,128,63,0,0,0,0,116,68,158,189,106,164,133,61,64,78,104,190,0,0,0,0,0,0,128,63,0,0,0,0,211,246,175,189,106,164,133,61,73,185,139,190,0,0,0,0,0,0,128,63,0,0,0,0,240,135,95,189,0,0,0,0,214,84,86,189,0,0,0,0,0,0,128,191,0,0,0,0,7,150,163,61,0,0,0,0,56,103,132,189,0,0,0,0,0,0,128,191,0,0,0,0,29,199,207,61,0,0,0,0,161,106,244,187,0,0,0,0,0,0,128,191,0,0,0,0,101,254,17,189,106,164,133,61,237,244,67,189,242,210,29,63,165,105,0,190,101,253,70,191,240,135,95,189,0,0,0,0,214,84,86,189,242,210,29,63,165,105,0,190,101,253,70,191,241,160,185,189,106,164,133,61,97,79,187,189,242,210,29,63,165,105,0,190,101,253,70,191,48,101,0,190,106,164,133,61,160,137,248,190,0,0,0,0,0,0,128,63,0,0,0,0,137,149,145,189,106,164,133,61,250,238,230,190,0,0,0,0,0,0,128,63,0,0,0,0,168,58,228,187,106,164,133,61,190,188,240,190,0,0,0,0,0,0,128,63,0,0,0,0,58,121,145,189,106,164,133,61,135,254,161,190,210,84,175,61,189,56,241,188,216,242,126,191,230,203,75,61,106,164,133,61,121,173,156,190,210,84,175,61,189,56,241,188,216,242,126,191,126,28,141,189,0,0,0,0,146,233,160,190,210,84,175,61,189,56,241,188,216,242,126,191,155,27,19,190,0,0,0,0,207,220,235,190,0,0,0,0,0,0,128,191,0,0,0,0,64,160,179,188,0,0,0,0,146,33,7,191,0,0,0,0,0,0,128,191,0,0,0,0,178,103,175,61,0,0,0,0,164,227,2,191,0,0,0,0,0,0,128,191,0,0,0,0,0,197,24,190,0,0,0,0,234,180,46,189,0,0,0,0,0,0,128,191,0,0,0,0,84,57,29,190,0,0,0,0,91,153,96,190,0,0,0,0,0,0,128,191,0,0,0,0,168,109,163,189,0,0,0,0,108,175,101,190,0,0,0,0,0,0,128,191,0,0,0,0,44,98,184,61,106,164,133,61,69,47,195,190,0,0,0,0,0,0,128,63,0,0,0,0,145,9,40,62,106,164,133,61,134,57,193,190,0,0,0,0,0,0,128,63,0,0,0,0,112,6,63,61,106,164,133,61,14,22,238,190,0,0,0,0,0,0,128,63,0,0,0,0,158,180,32,190,106,164,133,61,114,49,190,190,0,0,0,0,0,0,128,63,0,0,0,0,58,121,145,189,106,164,133,61,135,254,161,190,0,0,0,0,0,0,128,63,0,0,0,0,137,149,145,189,106,164,133,61,250,238,230,190,0,0,0,0,0,0,128,63,0,0,0,0,158,180,32,190,106,164,133,61,114,49,190,190,0,0,0,0,0,0,128,63,0,0,0,0,137,149,145,189,106,164,133,61,250,238,230,190,0,0,0,0,0,0,128,63,0,0,0,0,48,101,0,190,106,164,133,61,160,137,248,190,0,0,0,0,0,0,128,63,0,0,0,0,30,51,208,189,106,164,133,61,223,253,241,187,0,0,0,0,0,0,128,63,0,0,0,0,163,115,158,61,106,164,133,61,171,94,126,189,0,0,0,0,0,0,128,63,0,0,0,0,101,254,17,189,106,164,133,61,237,244,67,189,0,0,0,0,0,0,128,63,0,0,0,0,226,145,152,61,106,164,133,61,218,140,139,190,182,103,14,63,106,245,85,61,206,80,84,191,198,77,29,62,106,164,133,61,64,194,96,190,182,103,14,63,106,245,85,61,206,80,84,191,21,227,156,61,0,0,0,0,24,238,140,190,182,103,14,63,106,245,85,61,206,80,84,191,2,211,201,61,106,164,133,61,200,235,193,187,16,150,17,62,99,127,89,60,116,96,125,63,53,65,84,188,106,164,133,61,71,118,37,60,16,150,17,62,99,127,89,60,116,96,125,63,37,63,98,188,0,0,0,0,49,208,53,60,16,150,17,62,99,127,89,60,116,96,125,63,30,196,78,188,106,164,133,61,114,111,6,191,228,219,27,62,163,64,159,60,236,247,124,191,178,103,175,61,0,0,0,0,164,227,2,191,228,219,27,62,163,64,159,60,236,247,124,191,64,160,179,188,0,0,0,0,146,33,7,191,228,219,27,62,163,64,159,60,236,247,124,191,44,98,184,61,106,164,133,61,69,47,195,190,92,90,93,191,153,45,105,190,208,67,229,62,112,6,63,61,106,164,133,61,14,22,238,190,92,90,93,191,153,45,105,190,208,67,229,62,211,247,154,61,0,0,0,0,233,95,226,190,92,90,93,191,153,45,105,190,208,67,229,62,30,196,78,188,106,164,133,61,114,111,6,191,215,20,24,62,231,54,97,60,234,34,125,191,199,15,181,61,106,164,133,61,0,141,2,191,215,20,24,62,231,54,97,60,234,34,125,191,178,103,175,61,0,0,0,0,164,227,2,191,215,20,24,62,231,54,97,60,234,34,125,191,155,27,19,190,0,0,0,0,207,220,235,190,0,0,0,0,0,0,128,191,0,0,0,0,178,103,175,61,0,0,0,0,164,227,2,191,0,0,0,0,0,0,128,191,0,0,0,0,3,36,26,185,0,0,0,0,15,209,240,190,0,0,0,0,0,0,128,191,0,0,0,0,3,36,26,185,0,0,0,0,15,209,240,190,0,0,0,0,0,0,128,191,0,0,0,0,178,103,175,61,0,0,0,0,164,227,2,191,0,0,0,0,0,0,128,191,0,0,0,0,203,16,7,62,0,0,0,0,127,223,239,190,0,0,0,0,0,0,128,191,0,0,0,0,48,101,0,190,106,164,133,61,160,137,248,190,114,112,169,190,66,205,176,61,235,143,112,191,30,196,78,188,106,164,133,61,114,111,6,191,114,112,169,190,66,205,176,61,235,143,112,191,64,160,179,188,0,0,0,0,146,33,7,191,114,112,169,190,66,205,176,61,235,143,112,191,104,5,6,60,0,0,0,0,75,63,241,190,0,0,0,0,0,0,128,63,0,0,0,0,3,36,26,185,0,0,0,0,15,209,240,190,0,0,0,0,0,0,128,63,0,0,0,0,203,16,7,62,0,0,0,0,127,223,239,190,0,0,0,0,0,0,128,63,0,0,0,0,199,15,181,61,106,164,133,61,0,141,2,191,72,165,48,63,0,0,0,0,44,74,57,191,203,16,7,62,106,164,133,61,127,223,239,190,72,165,48,63,0,0,0,0,44,74,57,191,203,16,7,62,0,0,0,0,127,223,239,190,72,165,48,63,0,0,0,0,44,74,57,191,230,203,75,61,106,164,133,61,121,173,156,190,120,185,92,191,175,94,85,190,144,102,236,190,44,98,184,61,106,164,133,61,69,47,195,190,120,185,92,191,175,94,85,190,144,102,236,190,63,143,145,61,0,0,0,0,164,251,161,190,120,185,92,191,175,94,85,190,144,102,236,190,211,246,175,189,106,164,133,61,73,185,139,190,0,0,0,0,0,0,128,63,0,0,0,0,226,145,152,61,106,164,133,61,218,140,139,190,0,0,0,0,0,0,128,63,0,0,0,0,230,203,75,61,106,164,133,61,121,173,156,190,0,0,0,0,0,0,128,63,0,0,0,0,84,2,194,189,0,0,0,0,228,106,228,189,0,0,0,0,0,0,128,191,0,0,0,0,240,135,95,189,0,0,0,0,214,84,86,189,0,0,0,0,0,0,128,191,0,0,0,0,0,197,24,190,0,0,0,0,234,180,46,189,0,0,0,0,0,0,128,191,0,0,0,0,159,118,152,189,0,0,0,0,218,140,139,190,0,0,0,0,0,0,128,191,0,0,0,0,208,41,24,190,0,0,0,0,29,204,174,190,0,0,0,0,0,0,128,191,0,0,0,0,126,28,141,189,0,0,0,0,146,233,160,190,0,0,0,0,0,0,128,191,0,0,0,0,30,51,208,189,106,164,133,61,223,253,241,187,0,0,0,0,0,0,128,63,0,0,0,0,2,211,201,61,106,164,133,61,200,235,193,187,0,0,0,0,0,0,128,63,0,0,0,0,163,115,158,61,106,164,133,61,171,94,126,189,0,0,0,0,0,0,128,63,0,0,0,0,253,132,35,190,106,164,133,61,77,21,76,190,37,202,50,191,124,180,24,62,85,51,51,191,211,246,175,189,106,164,133,61,73,185,139,190,37,202,50,191,124,180,24,62,85,51,51,191,84,57,29,190,0,0,0,0,91,153,96,190,37,202,50,191,124,180,24,62,85,51,51,191,104,5,6,60,0,0,0,0,75,63,241,190,0,0,0,0,0,0,128,191,0,0,0,0,203,16,7,62,0,0,0,0,127,223,239,190,0,0,0,0,0,0,128,191,0,0,0,0,114,252,32,62,0,0,0,0,185,227,213,190,0,0,0,0,0,0,128,191,0,0,0,0,54,228,95,61,0,0,0,0,79,88,114,190,0,0,0,0,0,0,128,191,0,0,0,0,21,227,156,61,0,0,0,0,24,238,140,190,0,0,0,0,0,0,128,191,0,0,0,0,117,148,35,62,0,0,0,0,216,97,76,190,0,0,0,0,0,0,128,191,0,0,0,0,7,150,163,61,0,0,0,0,56,103,132,189,0,0,0,0,0,0,128,191,0,0,0,0,117,148,35,62,0,0,0,0,216,97,76,190,0,0,0,0,0,0,128,191,0,0,0,0,248,109,40,62,0,0,0,0,40,68,192,189,0,0,0,0,0,0,128,191,0,0,0,0,211,247,154,61,0,0,0,0,233,95,226,190,0,0,0,0,0,0,128,191,0,0,0,0,104,5,6,60,0,0,0,0,75,63,241,190,0,0,0,0,0,0,128,191,0,0,0,0,114,252,32,62,0,0,0,0,185,227,213,190,0,0,0,0,0,0,128,191,0,0,0,0,112,6,63,61,106,164,133,61,14,22,238,190,111,246,231,189,0,0,0,0,71,90,126,63,3,36,26,185,106,164,133,61,15,209,240,190,111,246,231,189,0,0,0,0,71,90,126,63,3,36,26,185,0,0,0,0,15,209,240,190,111,246,231,189,0,0,0,0,71,90,126,63,116,68,158,189,106,164,133,61,64,78,104,190,0,0,0,0,0,0,128,63,0,0,0,0,198,77,29,62,106,164,133,61,64,194,96,190,0,0,0,0,0,0,128,63,0,0,0,0,211,246,175,189,106,164,133,61,73,185,139,190,0,0,0,0,0,0,128,63,0,0,0,0,241,160,185,189,106,164,133,61,97,79,187,189,109,85,82,63,46,143,245,61,126,170,14,191,240,135,95,189,0,0,0,0,214,84,86,189,109,85,82,63,46,143,245,61,126,170,14,191,84,2,194,189,0,0,0,0,228,106,228,189,109,85,82,63,46,143,245,61,126,170,14,191,211,246,175,189,106,164,133,61,73,185,139,190,75,5,45,191,51,167,235,189,141,93,58,63,208,41,24,190,0,0,0,0,29,204,174,190,75,5,45,191,51,167,235,189,141,93,58,63,159,118,152,189,0,0,0,0,218,140,139,190,75,5,45,191,51,167,235,189,141,93,58,63,112,6,63,61,106,164,133,61,14,22,238,190,177,80,203,61,47,48,27,190,131,195,123,63,3,36,26,185,0,0,0,0,15,209,240,190,177,80,203,61,47,48,27,190,131,195,123,63,104,5,6,60,0,0,0,0,75,63,241,190,177,80,203,61,47,48,27,190,131,195,123,63,0,197,24,190,0,0,0,0,234,180,46,189,0,0,0,0,0,0,128,191,0,0,0,0,168,109,163,189,0,0,0,0,108,175,101,190,0,0,0,0,0,0,128,191,0,0,0,0,84,2,194,189,0,0,0,0,228,106,228,189,0,0,0,0,0,0,128,191,0,0,0,0,3,36,26,185,106,164,133,61,15,209,240,190,231,197,137,61,0,0,0,0,144,107,127,63,155,27,19,190,0,0,0,0,207,220,235,190,231,197,137,61,0,0,0,0,144,107,127,63,3,36,26,185,0,0,0,0,15,209,240,190,231,197,137,61,0,0,0,0,144,107,127,63,145,9,40,62,106,164,133,61,134,57,193,190,23,244,114,63,77,159,109,190,212,96,90,62,14,77,9,62,0,0,0,0,245,47,161,190,23,244,114,63,77,159,109,190,212,96,90,62,114,252,32,62,0,0,0,0,185,227,213,190,23,244,114,63,77,159,109,190,212,96,90,62,30,51,208,189,106,164,133,61,223,253,241,187,38,251,183,190,105,227,104,190,171,178,103,63,0,197,24,190,0,0,0,0,234,180,46,189,38,251,183,190,105,227,104,190,171,178,103,63,37,63,98,188,0,0,0,0,49,208,53,60,38,251,183,190,105,227,104,190,171,178,103,63,84,57,29,190,0,0,0,0,91,153,96,190,0,0,0,0,0,0,128,191,0,0,0,0,54,228,95,61,0,0,0,0,79,88,114,190,0,0,0,0,0,0,128,191,0,0,0,0,168,109,163,189,0,0,0,0,108,175,101,190,0,0,0,0,0,0,128,191,0,0,0,0,112,6,63,61,106,164,133,61,14,22,238,190,0,0,0,0,0,0,128,63,0,0,0,0,203,16,7,62,106,164,133,61,127,223,239,190,0,0,0,0,0,0,128,63,0,0,0,0,3,36,26,185,106,164,133,61,15,209,240,190,0,0,0,0,0,0,128,63,0,0,0,0,30,51,208,189,106,164,133,61,223,253,241,187,0,0,0,0,0,0,128,63,0,0,0,0,101,254,17,189,106,164,133,61,237,244,67,189,0,0,0,0,0,0,128,63,0,0,0,0,124,99,40,190,106,164,133,61,43,76,191,189,0,0,0,0,0,0,128,63,0,0,0,0])
.concat([58,121,145,189,106,164,133,61,135,254,161,190,221,205,127,63,179,150,2,61,9,109,185,188,126,28,141,189,0,0,0,0,146,233,160,190,221,205,127,63,179,150,2,61,9,109,185,188,42,115,147,189,0,0,0,0,160,220,230,190,221,205,127,63,179,150,2,61,9,109,185,188,54,228,95,61,0,0,0,0,79,88,114,190,0,0,0,0,0,0,128,191,0,0,0,0,84,57,29,190,0,0,0,0,91,153,96,190,0,0,0,0,0,0,128,191,0,0,0,0,21,227,156,61,0,0,0,0,24,238,140,190,0,0,0,0,0,0,128,191,0,0,0,0,198,77,29,62,106,164,133,61,64,194,96,190,211,19,42,63,212,13,36,190,164,227,58,191,117,148,35,62,0,0,0,0,216,97,76,190,211,19,42,63,212,13,36,190,164,227,58,191,21,227,156,61,0,0,0,0,24,238,140,190,211,19,42,63,212,13,36,190,164,227,58,191,150,32,163,61,106,164,133,61,173,110,101,190,0,0,0,0,0,0,128,63,0,0,0,0,169,159,39,62,106,164,133,61,192,8,186,189,0,0,0,0,0,0,128,63,0,0,0,0,198,77,29,62,106,164,133,61,64,194,96,190,0,0,0,0,0,0,128,63,0,0,0,0,2,211,201,61,106,164,133,61,200,235,193,187,90,186,34,62,75,234,132,188,116,182,124,63,37,63,98,188,0,0,0,0,49,208,53,60,90,186,34,62,75,234,132,188,116,182,124,63,29,199,207,61,0,0,0,0,161,106,244,187,90,186,34,62,75,234,132,188,116,182,124,63,158,180,32,190,106,164,133,61,114,49,190,190,10,72,115,191,128,73,42,62,6,186,134,190,48,101,0,190,106,164,133,61,160,137,248,190,10,72,115,191,128,73,42,62,6,186,134,190,155,27,19,190,0,0,0,0,207,220,235,190,10,72,115,191,128,73,42,62,6,186,134,190,30,51,208,189,106,164,133,61,223,253,241,187,106,166,71,191,118,84,133,62,250,181,17,63,124,99,40,190,106,164,133,61,43,76,191,189,106,166,71,191,118,84,133,62,250,181,17,63,0,197,24,190,0,0,0,0,234,180,46,189,106,166,71,191,118,84,133,62,250,181,17,63,150,32,163,61,106,164,133,61,173,110,101,190,0,0,0,0,0,0,128,191,0,0,0,0,198,77,29,62,106,164,133,61,64,194,96,190,0,0,0,0,0,0,128,191,0,0,0,0,116,68,158,189,106,164,133,61,64,78,104,190,0,0,0,0,0,0,128,191,0,0,0,0,3,36,26,185,106,164,133,61,15,209,240,190,0,0,0,0,0,0,128,63,0,0,0,0,203,16,7,62,106,164,133,61,127,223,239,190,0,0,0,0,0,0,128,63,0,0,0,0,199,15,181,61,106,164,133,61,0,141,2,191,0,0,0,0,0,0,128,63,0,0,0,0,44,98,184,61,106,164,133,61,69,47,195,190,69,244,119,191,243,29,124,62,146,233,16,189,211,247,154,61,0,0,0,0,233,95,226,190,69,244,119,191,243,29,124,62,146,233,16,189,63,143,145,61,0,0,0,0,164,251,161,190,69,244,119,191,243,29,124,62,146,233,16,189,230,203,75,61,106,164,133,61,121,173,156,190,31,216,113,188,81,191,27,62,72,254,124,191,63,143,145,61,0,0,0,0,164,251,161,190,31,216,113,188,81,191,27,62,72,254,124,191,126,28,141,189,0,0,0,0,146,233,160,190,31,216,113,188,81,191,27,62,72,254,124,191,198,77,29,62,106,164,133,61,64,194,96,190,203,47,127,63,184,58,128,60,45,238,159,189,169,159,39,62,106,164,133,61,192,8,186,189,203,47,127,63,184,58,128,60,45,238,159,189,248,109,40,62,0,0,0,0,40,68,192,189,203,47,127,63,184,58,128,60,45,238,159,189,7,150,163,61,0,0,0,0,56,103,132,189,0,0,0,0,0,0,128,191,0,0,0,0,248,109,40,62,0,0,0,0,40,68,192,189,0,0,0,0,0,0,128,191,0,0,0,0,29,199,207,61,0,0,0,0,161,106,244,187,0,0,0,0,0,0,128,191,0,0,0,0,48,101,0,190,106,164,133,61,160,137,248,190,207,190,242,190,210,194,69,190,238,232,91,191,64,160,179,188,0,0,0,0,146,33,7,191,207,190,242,190,210,194,69,190,238,232,91,191,155,27,19,190,0,0,0,0,207,220,235,190,207,190,242,190,210,194,69,190,238,232,91,191,150,32,163,61,106,164,133,61,173,110,101,190,225,11,79,191,174,243,79,62,68,76,13,63,54,228,95,61,0,0,0,0,79,88,114,190,225,11,79,191,174,243,79,62,68,76,13,63,29,30,194,61,0,0,0,0,87,36,54,190,225,11,79,191,174,243,79,62,68,76,13,63,241,160,185,189,106,164,133,61,97,79,187,189,25,118,124,63,230,229,208,189,128,182,5,62,84,2,194,189,0,0,0,0,228,106,228,189,25,118,124,63,230,229,208,189,128,182,5,62,168,109,163,189,0,0,0,0,108,175,101,190,25,118,124,63,230,229,208,189,128,182,5,62,163,115,158,61,106,164,133,61,171,94,126,189,0,0,0,0,0,0,128,63,0,0,0,0,169,159,39,62,106,164,133,61,192,8,186,189,0,0,0,0,0,0,128,63,0,0,0,0,150,32,163,61,106,164,133,61,173,110,101,190,0,0,0,0,0,0,128,63,0,0,0,0,203,16,7,62,106,164,133,61,127,223,239,190,173,21,101,63,0,0,0,0,18,135,228,190,114,252,32,62,0,0,0,0,185,227,213,190,173,21,101,63,0,0,0,0,18,135,228,190,203,16,7,62,0,0,0,0,127,223,239,190,173,21,101,63,0,0,0,0,18,135,228,190,163,115,158,61,106,164,133,61,171,94,126,189,151,202,127,191,174,244,26,189,198,196,102,188,150,32,163,61,106,164,133,61,173,110,101,190,151,202,127,191,174,244,26,189,198,196,102,188,7,150,163,61,0,0,0,0,56,103,132,189,151,202,127,191,174,244,26,189,198,196,102,188,199,15,181,61,106,164,133,61,0,141,2,191,95,209,45,63,205,58,99,188,83,233,59,191,203,16,7,62,0,0,0,0,127,223,239,190,95,209,45,63,205,58,99,188,83,233,59,191,178,103,175,61,0,0,0,0,164,227,2,191,95,209,45,63,205,58,99,188,83,233,59,191,145,9,40,62,106,164,133,61,134,57,193,190,99,183,59,63,172,0,135,62,147,113,32,63,226,145,152,61,106,164,133,61,218,140,139,190,99,183,59,63,172,0,135,62,147,113,32,63,14,77,9,62,0,0,0,0,245,47,161,190,99,183,59,63,172,0,135,62,147,113,32,63,3,36,26,185,106,164,133,61,15,209,240,190,123,75,185,60,32,70,200,61,11,181,126,63,168,58,228,187,106,164,133,61,190,188,240,190,123,75,185,60,32,70,200,61,11,181,126,63,155,27,19,190,0,0,0,0,207,220,235,190,123,75,185,60,32,70,200,61,11,181,126,63,37,63,98,188,0,0,0,0,49,208,53,60,0,0,0,0,0,0,128,191,0,0,0,0,0,197,24,190,0,0,0,0,234,180,46,189,0,0,0,0,0,0,128,191,0,0,0,0,29,199,207,61,0,0,0,0,161,106,244,187,0,0,0,0,0,0,128,191,0,0,0,0,124,99,40,190,106,164,133,61,43,76,191,189,159,58,122,191,71,202,86,190,40,40,197,60,84,57,29,190,0,0,0,0,91,153,96,190,159,58,122,191,71,202,86,190,40,40,197,60,0,197,24,190,0,0,0,0,234,180,46,189,159,58,122,191,71,202,86,190,40,40,197,60,211,246,175,189,106,164,133,61,73,185,139,190,7,234,76,191,214,87,39,62,106,162,19,63,158,180,32,190,106,164,133,61,114,49,190,190,7,234,76,191,214,87,39,62,106,162,19,63,208,41,24,190,0,0,0,0,29,204,174,190,7,234,76,191,214,87,39,62,106,162,19,63,168,109,163,189,0,0,0,0,108,175,101,190,224,100,187,61,221,91,17,61,152,195,126,63,54,228,95,61,0,0,0,0,79,88,114,190,224,100,187,61,221,91,17,61,152,195,126,63,116,68,158,189,106,164,133,61,64,78,104,190,224,100,187,61,221,91,17,61,152,195,126,63,63,143,145,61,0,0,0,0,164,251,161,190,0,0,0,0,0,0,128,191,0,0,0,0,114,252,32,62,0,0,0,0,185,227,213,190,0,0,0,0,0,0,128,191,0,0,0,0,14,77,9,62,0,0,0,0,245,47,161,190,0,0,0,0,0,0,128,191,0,0,0,0,230,203,75,61,106,164,133,61,121,173,156,190,0,0,0,0,0,0,128,63,0,0,0,0,145,9,40,62,106,164,133,61,134,57,193,190,0,0,0,0,0,0,128,63,0,0,0,0,44,98,184,61,106,164,133,61,69,47,195,190,0,0,0,0,0,0,128,63,0,0,0,0,126,28,141,189,0,0,0,0,146,233,160,190,0,0,0,0,0,0,128,191,0,0,0,0,63,143,145,61,0,0,0,0,164,251,161,190,0,0,0,0,0,0,128,191,0,0,0,0,14,77,9,62,0,0,0,0,245,47,161,190,0,0,0,0,0,0,128,191,0,0,0,0,253,132,35,190,106,164,133,61,77,21,76,190,0,0,0,0,0,0,128,63,0,0,0,0,241,160,185,189,106,164,133,61,97,79,187,189,0,0,0,0,0,0,128,63,0,0,0,0,116,68,158,189,106,164,133,61,64,78,104,190,0,0,0,0,0,0,128,63,0,0,0,0,159,118,152,189,0,0,0,0,218,140,139,190,0,0,0,0,0,0,128,191,0,0,0,0,14,77,9,62,0,0,0,0,245,47,161,190,0,0,0,0,0,0,128,191,0,0,0,0,21,227,156,61,0,0,0,0,24,238,140,190,0,0,0,0,0,0,128,191,0,0,0,0,211,246,175,189,106,164,133,61,73,185,139,190,0,0,0,0,0,0,128,63,0,0,0,0,198,77,29,62,106,164,133,61,64,194,96,190,0,0,0,0,0,0,128,63,0,0,0,0,226,145,152,61,106,164,133,61,218,140,139,190,0,0,0,0,0,0,128,63,0,0,0,0,168,58,228,187,106,164,133,61,190,188,240,190,107,128,146,62,70,126,253,186,190,75,117,63,137,149,145,189,106,164,133,61,250,238,230,190,107,128,146,62,70,126,253,186,190,75,117,63,42,115,147,189,0,0,0,0,160,220,230,190,107,128,146,62,70,126,253,186,190,75,117,63,116,68,158,189,106,164,133,61,64,78,104,190,86,156,126,63,214,143,13,189,13,252,200,61,241,160,185,189,106,164,133,61,97,79,187,189,86,156,126,63,214,143,13,189,13,252,200,61,168,109,163,189,0,0,0,0,108,175,101,190,86,156,126,63,214,143,13,189,13,252,200,61,169,159,39,62,106,164,133,61,192,8,186,189,65,17,75,63,146,207,171,60,117,202,27,63,2,211,201,61,106,164,133,61,200,235,193,187,65,17,75,63,146,207,171,60,117,202,27,63,29,199,207,61,0,0,0,0,161,106,244,187,65,17,75,63,146,207,171,60,117,202,27,63,48,101,0,190,106,164,133,61,160,137,248,190,0,0,0,0,0,0,128,63,0,0,0,0,168,58,228,187,106,164,133,61,190,188,240,190,0,0,0,0,0,0,128,63,0,0,0,0,3,36,26,185,106,164,133,61,15,209,240,190,0,0,0,0,0,0,128,63,0,0,0,0,7,150,163,61,0,0,0,0,56,103,132,189,116,207,186,189,79,206,16,61,160,197,126,191,240,135,95,189,0,0,0,0,214,84,86,189,116,207,186,189,79,206,16,61,160,197,126,191,163,115,158,61,106,164,133,61,171,94,126,189,116,207,186,189,79,206,16,61,160,197,126,191,211,246,175,189,106,164,133,61,73,185,139,190,0,0,0,0,0,0,128,63,0,0,0,0,58,121,145,189,106,164,133,61,135,254,161,190,0,0,0,0,0,0,128,63,0,0,0,0,158,180,32,190,106,164,133,61,114,49,190,190,0,0,0,0,0,0,128,63,0,0,0,0,163,115,158,61,106,164,133,61,171,94,126,189,112,6,255,189,20,235,212,61,250,155,124,191,240,135,95,189,0,0,0,0,214,84,86,189,112,6,255,189,20,235,212,61,250,155,124,191,101,254,17,189,106,164,133,61,237,244,67,189,112,6,255,189,20,235,212,61,250,155,124,191,63,143,145,61,0,0,0,0,164,251,161,190,0,0,0,0,0,0,128,191,0,0,0,0,211,247,154,61,0,0,0,0,233,95,226,190,0,0,0,0,0,0,128,191,0,0,0,0,114,252,32,62,0,0,0,0,185,227,213,190,0,0,0,0,0,0,128,191,0,0,0,0,112,6,63,61,106,164,133,61,14,22,238,190,0,0,0,0,0,0,128,63,0,0,0,0,145,9,40,62,106,164,133,61,134,57,193,190,0,0,0,0,0,0,128,63,0,0,0,0,203,16,7,62,106,164,133,61,127,223,239,190,0,0,0,0,0,0,128,63,0,0,0,0,208,41,24,190,0,0,0,0,29,204,174,190,0,0,0,0,0,0,128,191,0,0,0,0,155,27,19,190,0,0,0,0,207,220,235,190,0,0,0,0,0,0,128,191,0,0,0,0,42,115,147,189,0,0,0,0,160,220,230,190,0,0,0,0,0,0,128,191,0,0,0,0,29,30,194,61,0,0,0,0,87,36,54,190,0,0,0,0,0,0,128,191,0,0,0,0,54,228,95,61,0,0,0,0,79,88,114,190,0,0,0,0,0,0,128,191,0,0,0,0,117,148,35,62,0,0,0,0,216,97,76,190,0,0,0,0,0,0,128,191,0,0,0,0,208,41,24,190,0,0,0,0,29,204,174,190,0,0,0,0,0,0,128,191,0,0,0,0,42,115,147,189,0,0,0,0,160,220,230,190,0,0,0,0,0,0,128,191,0,0,0,0,126,28,141,189,0,0,0,0,146,233,160,190,0,0,0,0,0,0,128,191,0,0,0,0,211,246,175,189,106,164,133,61,73,185,139,190,14,45,14,191,151,201,208,189,161,72,83,191,159,118,152,189,0,0,0,0,218,140,139,190,14,45,14,191,151,201,208,189,161,72,83,191,84,57,29,190,0,0,0,0,91,153,96,190,14,45,14,191,151,201,208,189,161,72,83,191,54,228,95,61,0,0,0,0,79,88,114,190,114,249,143,188,237,155,59,190,98,160,123,63,150,32,163,61,106,164,133,61,173,110,101,190,114,249,143,188,237,155,59,190,98,160,123,63,116,68,158,189,106,164,133,61,64,78,104,190,114,249,143,188,237,155,59,190,98,160,123,63,30,51,208,189,106,164,133,61,223,253,241,187,0,0,0,0,0,0,128,63,0,0,0,0,53,65,84,188,106,164,133,61,71,118,37,60,0,0,0,0,0,0,128,63,0,0,0,0,2,211,201,61,106,164,133,61,200,235,193,187,0,0,0,0,0,0,128,63,0,0,0,0,48,101,0,190,106,164,133,61,160,137,248,190,0,0,0,0,0,0,128,63,0,0,0,0,3,36,26,185,106,164,133,61,15,209,240,190,0,0,0,0,0,0,128,63,0,0,0,0,199,15,181,61,106,164,133,61,0,141,2,191,0,0,0,0,0,0,128,63,0,0,0,0,211,246,175,189,106,164,133,61,73,185,139,190,0,0,0,0,0,0,128,63,0,0,0,0,230,203,75,61,106,164,133,61,121,173,156,190,0,0,0,0,0,0,128,63,0,0,0,0,58,121,145,189,106,164,133,61,135,254,161,190,0,0,0,0,0,0,128,63,0,0,0,0,48,101,0,190,106,164,133,61,160,137,248,190,0,0,0,0,0,0,128,63,0,0,0,0,199,15,181,61,106,164,133,61,0,141,2,191,0,0,0,0,0,0,128,63,0,0,0,0,30,196,78,188,106,164,133,61,114,111,6,191,0,0,0,0,0,0,128,63,0,0,0,0,124,99,40,190,106,164,133,61,43,76,191,189,0,0,0,0,0,0,128,63,0,0,0,0,101,254,17,189,106,164,133,61,237,244,67,189,0,0,0,0,0,0,128,63,0,0,0,0,241,160,185,189,106,164,133,61,97,79,187,189,0,0,0,0,0,0,128,63,0,0,0,0,84,57,29,190,0,0,0,0,91,153,96,190,0,0,0,0,0,0,128,191,0,0,0,0,159,118,152,189,0,0,0,0,218,140,139,190,0,0,0,0,0,0,128,191,0,0,0,0,21,227,156,61,0,0,0,0,24,238,140,190,0,0,0,0,0,0,128,191,0,0,0,0,226,145,152,61,106,164,133,61,218,140,139,190,12,35,17,63,98,159,128,188,10,216,82,63,21,227,156,61,0,0,0,0,24,238,140,190,12,35,17,63,98,159,128,188,10,216,82,63,14,77,9,62,0,0,0,0,245,47,161,190,12,35,17,63,98,159,128,188,10,216,82,63,7,150,163,61,0,0,0,0,56,103,132,189,0,0,0,0,0,0,128,191,0,0,0,0,29,30,194,61,0,0,0,0,87,36,54,190,0,0,0,0,0,0,128,191,0,0,0,0,117,148,35,62,0,0,0,0,216,97,76,190,0,0,0,0,0,0,128,191,0,0,0,0,0,197,24,190,0,0,0,0,234,180,46,189,0,0,0,0,0,0,128,191,0,0,0,0,240,135,95,189,0,0,0,0,214,84,86,189,0,0,0,0,0,0,128,191,0,0,0,0,29,199,207,61,0,0,0,0,161,106,244,187,0,0,0,0,0,0,128,191,0,0,0,0,124,99,40,190,106,164,133,61,43,76,191,189,196,235,126,191,8,2,164,189,32,40,55,189,253,132,35,190,106,164,133,61,77,21,76,190,196,235,126,191,8,2,164,189,32,40,55,189,84,57,29,190,0,0,0,0,91,153,96,190,196,235,126,191,8,2,164,189,32,40,55,189,203,16,7,62,106,164,133,61,127,223,239,190,159,2,112,63,245,20,217,61,223,164,169,190,145,9,40,62,106,164,133,61,134,57,193,190,159,2,112,63,245,20,217,61,223,164,169,190,114,252,32,62,0,0,0,0,185,227,213,190,159,2,112,63,245,20,217,61,223,164,169,190,8,29,148,61,106,164,133,61,90,102,225,190,46,169,6,191,220,47,31,188,238,180,89,63,204,237,222,60,106,164,133,61,134,175,239,190,46,169,6,191,220,47,31,188,238,180,89,63,143,111,239,60,0,0,0,0,185,109,239,190,46,169,6,191,220,47,31,188,238,180,89,63,236,78,247,189,106,164,133,61,110,137,244,190,0,0,0,0,0,0,128,63,0,0,0,0,116,208,5,62,106,164,133,61,108,38,239,190,0,0,0,0,0,0,128,63,0,0,0,0,216,244,96,61,106,164,133,61,76,24,5,191,0,0,0,0,0,0,128,63,0,0,0,0,73,130,208,61,106,164,133,61,84,1,23,190,0,0,0,0,0,0,128,63,0,0,0,0,177,251,46,62,106,164,133,61,181,197,53,190,0,0,0,0,0,0,128,63,0,0,0,0,51,106,222,61,106,164,133,61,141,240,118,190,0,0,0,0,0,0,128,63,0,0,0,0,3,206,82,61,106,164,133,61,64,191,143,189,81,245,243,190,34,170,240,61,65,13,95,191,83,89,148,61,0,0,0,0,11,66,185,189,81,245,243,190,34,170,240,61,65,13,95,191,146,150,74,188,0,0,0,0,96,144,52,189,81,245,243,190,34,170,240,61,65,13,95,191,58,88,255,189,0,0,0,0,40,70,102,190,0,0,0,0,0,0,128,191,0,0,0,0,120,69,32,190,0,0,0,0,16,236,152,190,0,0,0,0,0,0,128,191,0,0,0,0,170,98,170,189,0,0,0,0,52,128,143,190,0,0,0,0,0,0,128,191,0,0,0,0,11,154,246,189,0,0,0,0,211,19,22,188,0,0,0,0,0,0,128,191,0,0,0,0,85,134,1,62,0,0,0,0,37,177,100,189,0,0,0,0,0,0,128,191,0,0,0,0,208,214,65,61,0,0,0,0,56,158,79,58,0,0,0,0,0,0,128,191,0,0,0,0,236,78,247,189,106,164,133,61,110,137,244,190,0,0,0,0,0,0,128,63,0,0,0,0,36,38,168,189,106,164,133,61,132,183,215,190,0,0,0,0,0,0,128,63,0,0,0,0,228,191,0,189,106,164,133,61,236,137,238,190,0,0,0,0,0,0,128,63,0,0,0,0,110,250,51,188,0,0,0,0,226,86,49,190,0,0,0,0,0,0,128,191,0,0,0,0,69,158,132,189,0,0,0,0,174,241,57,190,0,0,0,0,0,0,128,191,0,0,0,0,38,28,58,61,0,0,0,0,111,128,57,190,0,0,0,0,0,0,128,191,0,0,0,0,228,191,0,189,106,164,133,61,236,137,238,190,89,21,41,63,38,228,131,187,118,54,64,63,36,38,168,189,106,164,133,61,132,183,215,190,89,21,41,63,38,228,131,187,118,54,64,63,166,127,169,189,0,0,0,0,128,153,215,190,89,21,41,63,38,228,131,187,118,54,64,63,228,191,0,189,106,164,133,61,236,137,238,190,229,11,38,63,191,129,73,60,208,209,66,63,166,127,169,189,0,0,0,0,128,153,215,190,229,11,38,63,191,129,73,60,208,209,66,63,92,113,241,188,0,0,0,0,169,218,238,190,229,11,38,63,191,129,73,60,208,209,66,63,148,222,119,61,106,164,133,61,62,150,62,190,209,30,15,62,216,12,48,61,142,63,125,63,110,250,51,188,0,0,0,0,226,86,49,190,209,30,15,62,216,12,48,61,142,63,125,63,38,28,58,61,0,0,0,0,111,128,57,190,209,30,15,62,216,12,48,61,142,63,125,63,83,89,148,61,0,0,0,0,11,66,185,189,0,0,0,0,0,0,128,191,0,0,0,0,213,203,47,62,0,0,0,0,38,166,59,190,0,0,0,0,0,0,128,191,0,0,0,0,85,134,1,62,0,0,0,0,37,177,100,189,0,0,0,0,0,0,128,191,0,0,0,0,89,80,248,189,106,164,133,61,105,81,31,188,0,0,0,0,0,0,128,63,0,0,0,0,206,137,253,61,106,164,133,61,194,252,85,189,0,0,0,0,0,0,128,63,0,0,0,0,240,167,6,189,106,164,133,61,148,191,59,189,0,0,0,0,0,0,128,63,0,0,0,0,233,41,210,61,0,0,0,0,120,239,104,190,0,0,0,0,0,0,128,191,0,0,0,0,8,29,148,61,0,0,0,0,220,240,131,190,0,0,0,0,0,0,128,191,0,0,0,0,213,203,47,62,0,0,0,0,38,166,59,190,0,0,0,0,0,0,128,191,0,0,0,0,254,239,8,188,106,164,133,61,247,174,49,190,88,28,30,190,205,60,57,60,213,233,124,63,69,158,132,189,0,0,0,0,174,241,57,190,88,28,30,190,205,60,57,60,213,233,124,63,110,250,51,188,0,0,0,0,226,86,49,190,88,28,30,190,205,60,57,60,213,233,124,63,86,72,217,189,0,0,0,0,60,20,253,190,0,0,0,0,0,0,128,191,0,0,0,0,149,158,233,60,0,0,0,0,182,44,7,191,0,0,0,0,0,0,128,191,0,0,0,0,19,124,3,62,0,0,0,0,118,193,240,190,0,0,0,0,0,0,128,191,0,0,0,0,58,88,255,189,0,0,0,0,40,70,102,190,0,0,0,0,0,0,128,191,0,0,0,0,170,98,170,189,0,0,0,0,52,128,143,190,0,0,0,0,0,0,128,191,0,0,0,0,2,132,15,189,0,0,0,0,76,108,110,190,0,0,0,0,0,0,128,191,0,0,0,0,50,200,45,62,106,164,133,61,74,94,181,190,212,242,127,63,159,176,68,188,177,196,131,188,213,203,47,62,0,0,0,0,38,166,59,190,212,242,127,63,159,176,68,188,177,196,131,188,76,226,44,62,0,0,0,0,29,86,184,190,212,242,127,63,159,176,68,188,177,196,131,188,216,244,96,61,106,164,133,61,76,24,5,191,253,74,255,62,209,117,193,189,158,149,92,191,19,124,3,62,0,0,0,0,118,193,240,190,253,74,255,62,209,117,193,189,158,149,92,191,149,158,233,60,0,0,0,0,182,44,7,191,253,74,255,62,209,117,193,189,158,149,92,191,131,135,169,189,106,164,133,61,17,138,141,190,64,135,37,63,61,44,20,189,203,16,67,191,49,94,243,188,106,164,133,61,190,246,108,190,64,135,37,63,61,44,20,189,203,16,67,191,2,132,15,189,0,0,0,0,76,108,110,190,64,135,37,63,61,44,20,189,203,16,67,191,236,78,247,189,106,164,133,61,110,137,244,190,0,0,0,0,0,0,128,63,0,0,0,0,216,244,96,61,106,164,133,61,76,24,5,191,0,0,0,0,0,0,128,63,0,0,0,0,39,218,85,189,106,164,133,61,244,249,4,191,0,0,0,0,0,0,128,63,0,0,0,0,149,158,233,60,0,0,0,0,182,44,7,191,204,96,140,187,95,67,0,62,64,251,125,191,39,218,85,189,106,164,133,61,244,249,4,191,204,96,140,187,95,67,0,62,64,251,125,191,216,244,96,61,106,164,133,61,76,24,5,191,204,96,140,187,95,67,0,62,64,251,125,191,148,222,119,61,106,164,133,61,62,150,62,190,118,139,32,63,172,30,176,189,6,47,70,63,38,28,58,61,0,0,0,0,111,128,57,190,118,139,32,63,172,30,176,189,6,47,70,63,233,41,210,61,0,0,0,0,120,239,104,190,118,139,32,63,172,30,176,189,6,47,70,63,73,130,208,61,106,164,133,61,84,1,23,190,129,152,108,191,4,2,189,61,81,189,189,190,128,242,215,61,0,0,0,0,238,235,48,190,129,152,108,191,4,2,189,61,81,189,189,190,83,89,148,61,0,0,0,0,11,66,185,189,129,152,108,191,4,2,189,61,81,189,189,190,92,113,241,188,0,0,0,0,169,218,238,190,0,0,0,0,0,0,128,191,0,0,0,0,86,72,217,189,0,0,0,0,60,20,253,190,0,0,0,0,0,0,128,191,0,0,0,0,143,111,239,60,0,0,0,0,185,109,239,190,0,0,0,0,0,0,128,191,0,0,0,0,143,111,239,60,0,0,0,0,185,109,239,190,0,0,0,0,0,0,128,191,0,0,0,0,86,72,217,189,0,0,0,0,60,20,253,190,0,0,0,0,0,0,128,191,0,0,0,0,19,124,3,62,0,0,0,0,118,193,240,190,0,0,0,0,0,0,128,191,0,0,0,0,128,242,215,61,0,0,0,0,238,235,48,190,0,0,0,0,0,0,128,191,0,0,0,0,233,41,210,61,0,0,0,0,120,239,104,190,0,0,0,0,0,0,128,191,0,0,0,0,213,203,47,62,0,0,0,0,38,166,59,190,0,0,0,0,0,0,128,191,0,0,0,0,10,188,179,61,106,164,133,61,121,87,141,190,190,217,106,191,75,6,224,61,217,237,195,190,77,191,196,61,0,0,0,0,169,22,161,190,190,217,106,191,75,6,224,61,217,237,195,190,8,29,148,61,0,0,0,0,220,240,131,190,190,217,106,191,75,6,224,61,217,237,195,190,131,135,169,189,106,164,133,61,17,138,141,190,56,135,51,63,152,193,24,61,154,63,54,191,2,132,15,189,0,0,0,0,76,108,110,190,56,135,51,63,152,193,24,61,154,63,54,191,170,98,170,189,0,0,0,0,52,128,143,190,56,135,51,63,152,193,24,61,154,63,54,191,162,183,248,188,106,164,133,61,104,64,61,60,0,0,0,0,0,0,128,63,0,0,0,0,92,113,49,61,106,164,133,61,8,34,11,59,0,0,0,0,0,0,128,63,0,0,0,0,89,80,248,189,106,164,133,61,105,81,31,188,0,0,0,0,0,0,128,63,0,0,0,0,216,244,96,61,106,164,133,61,76,24,5,191,133,95,18,63,208,154,159,60,131,247,81,191,116,208,5,62,106,164,133,61,108,38,239,190,133,95,18,63,208,154,159,60,131,247,81,191,19,124,3,62,0,0,0,0,118,193,240,190,133,95,18,63,208,154,159,60,131,247,81,191,103,129,22,190,106,164,133,61,196,11,130,190,21,227,104,191,219,253,10,190,104,235,200,62,120,69,32,190,0,0,0,0,16,236,152,190,21,227,104,191,219,253,10,190,104,235,200,62,58,88,255,189,0,0,0,0,40,70,102,190,21,227,104,191,219,253,10,190,104,235,200,62,3,206,82,61,106,164,133,61,64,191,143,189,185,111,85,191,47,48,203,189,149,13,11,191,73,130,208,61,106,164,133,61,84,1,23,190,185,111,85,191,47,48,203,189,149,13,11,191,83,89,148,61,0,0,0,0,11,66,185,189,185,111,85,191,47,48,203,189,149,13,11,191,89,80,248,189,106,164,133,61,105,81,31,188,161,246,127,191,19,156,122,185,250,180,138,188,226,31,246,189,106,164,133,61,16,65,149,189,161,246,127,191,19,156,122,185,250,180,138,188,55,28,246,189,0,0,0,0,63,55,148,189,161,246,127,191,19,156,122,185,250,180,138,188,11,122,239,60,106,164,133,61,61,211,107,190,71,171,6,191,85,249,30,60,175,179,89,191,8,29,148,61,0,0,0,0,220,240,131,190,71,171,6,191,85,249,30,60,175,179,89,191,147,254,222,60,0,0,0,0,43,80,107,190,71,171,6,191,85,249,30,60,175,179,89,191,147,254,222,60,0,0,0,0,43,80,107,190,23,131,71,61,14,247,145,60,202,167,127,191,2,132,15,189,0,0,0,0,76,108,110,190,23,131,71,61,14,247,145,60,202,167,127,191,49,94,243,188,106,164,133,61,190,246,108,190,23,131,71,61,14,247,145,60,202,167,127,191,148,222,119,61,106,164,133,61,62,150,62,190,148,74,56,62,142,205,14,187,187,209,123,63,254,239,8,188,106,164,133,61,247,174,49,190,148,74,56,62,142,205,14,187,187,209,123,63,110,250,51,188,0,0,0,0,226,86,49,190,148,74,56,62,142,205,14,187,187,209,123,63,32,238,138,189,106,164,133,61,17,24,59,190,0,0,0,0,0,0,128,63,0,0,0,0,148,222,119,61,106,164,133,61,62,150,62,190,0,0,0,0,0,0,128,63,0,0,0,0,103,129,22,190,106,164,133,61,196,11,130,190,0,0,0,0,0,0,128,63,0,0,0,0,39,218,85,189,106,164,133,61,244,249,4,191,70,64,117,190,2,156,46,190,163,175,116,191,149,158,233,60,0,0,0,0,182,44,7,191,70,64,117,190,2,156,46,190,163,175,116,191,86,72,217,189,0,0,0,0,60,20,253,190,70,64,117,190,2,156,46,190,163,175,116,191,30,51,32,190,106,164,133,61,74,207,204,190,197,230,127,191,187,154,188,188,61,42,126,188,34,137,30,190,0,0,0,0,111,214,208,190,197,230,127,191,187,154,188,188,61,42,126,188,120,69,32,190,0,0,0,0,16,236,152,190,197,230,127,191,187,154,188,188,61,42,126,188,103,129,22,190,106,164,133,61,196,11,130,190,0,0,0,0,0,0,128,191,0,0,0,0,51,106,222,61,106,164,133,61,141,240,118,190,0,0,0,0,0,0,128,191,0,0,0,0,11,122,239,60,106,164,133,61,61,211,107,190,0,0,0,0,0,0,128,191,0,0,0,0,204,237,222,60,106,164,133,61,134,175,239,190,0,0,0,0,0,0,128,63,0,0,0,0,116,208,5,62,106,164,133,61,108,38,239,190,0,0,0,0,0,0,128,63,0,0,0,0,236,78,247,189,106,164,133,61,110,137,244,190,0,0,0,0,0,0,128,63,0,0,0,0,240,167,6,189,106,164,133,61,148,191,59,189,5,195,129,62,124,243,91,61,137,66,119,191,146,150,74,188,0,0,0,0,96,144,52,189,5,195,129,62,124,243,91,61,137,66,119,191,55,28,246,189,0,0,0,0,63,55,148,189,5,195,129,62,124,243,91,61,137,66,119,191,10,188,179,61,0,0,0,0,189,255,215,190,0,0,0,0,0,0,128,191,0,0,0,0,143,111,239,60,0,0,0,0,185,109,239,190,0,0,0,0,0,0,128,191,0,0,0,0,19,124,3,62,0,0,0,0,118,193,240,190,0,0,0,0,0,0,128,191,0,0,0,0,86,72,217,189,0,0,0,0,60,20,253,190,0,0,0,0,0,0,128,191,0,0,0,0,92,113,241,188,0,0,0,0,169,218,238,190,0,0,0,0,0,0,128,191,0,0,0,0,166,127,169,189,0,0,0,0,128,153,215,190,0,0,0,0,0,0,128,191,0,0,0,0,236,78,247,189,106,164,133,61,110,137,244,190,25,172,4,191,243,62,206,61,72,106,89,191,39,218,85,189,106,164,133,61,244,249,4,191,25,172,4,191,243,62,206,61,72,106,89,191,86,72,217,189,0,0,0,0,60,20,253,190,25,172,4,191,243,62,206,61,72,106,89,191,34,137,30,190,0,0,0,0,111,214,208,190,0,0,0,0,0,0,128,191,0,0,0,0,86,72,217,189,0,0,0,0,60,20,253,190,0,0,0,0,0,0,128,191,0,0,0,0,166,127,169,189,0,0,0,0,128,153,215,190,0,0,0,0,0,0,128,191,0,0,0,0,77,191,196,61,106,164,133,61,142,64,196,190,140,101,126,191,24,233,165,61,5,164,157,61,10,188,179,61,0,0,0,0,189,255,215,190,140,101,126,191,24,233,165,61,5,164,157,61,77,191,196,61,0,0,0,0,169,22,161,190,140,101,126,191,24,233,165,61,5,164,157,61,73,130,208,61,106,164,133,61,84,1,23,190,41,151,126,191,4,201,155,61,15,156,147,189,51,106,222,61,106,164,133,61,141,240,118,190,41,151,126,191,4,201,155,61,15,156,147,189,233,41,210,61,0,0,0,0,120,239,104,190,41,151,126,191,4,201,155,61,15,156,147,189,73,130,208,61,106,164,133,61,84,1,23,190,166,238,126,191,163,92,154,189,236,160,82,61,233,41,210,61,0,0,0,0,120,239,104,190,166,238,126,191,163,92,154,189,236,160,82,61,128,242,215,61,0,0,0,0,238,235,48,190,166,238,126,191,163,92,154,189,236,160,82,61,50,200,45,62,106,164,133,61,74,94,181,190,0,0,0,0,0,0,128,63,0,0,0,0,116,208,5,62,106,164,133,61,108,38,239,190,0,0,0,0,0,0,128,63,0,0,0,0,8,29,148,61,106,164,133,61,90,102,225,190,0,0,0,0,0,0,128,63,0,0,0,0,162,183,248,188,106,164,133,61,104,64,61,60,195,97,105,190,18,221,179,59,45,66,121,63,89,80,248,189,106,164,133,61,105,81,31,188,195,97,105,190,18,221,179,59,45,66,121,63,11,154,246,189,0,0,0,0,211,19,22,188,195,97,105,190,18,221,179,59,45,66,121,63,32,238,138,189,106,164,133,61,17,24,59,190,181,111,42,191,209,144,209,61,80,54,61,63,103,129,22,190,106,164,133,61,196,11,130,190,181,111,42,191,209,144,209,61,80,54,61,63,58,88,255,189,0,0,0,0,40,70,102,190,181,111,42,191,209,144,209,61,80,54,61,63,116,208,5,62,106,164,133,61,108,38,239,190,62,232,113,63,225,206,133,60,63,83,167,190,50,200,45,62,106,164,133,61,74,94,181,190,62,232,113,63,225,206,133,60,63,83,167,190,76,226,44,62,0,0,0,0,29,86,184,190,62,232,113,63,225,206,133,60,63,83,167,190,11,122,239,60,106,164,133,61,61,211,107,190,0,0,0,0,0,0,128,63,0,0,0,0,51,106,222,61,106,164,133,61,141,240,118,190,0,0,0,0,0,0,128,63,0,0,0,0,10,188,179,61,106,164,133,61,121,87,141,190,0,0,0,0,0,0,128,63,0,0,0,0,11,154,246,189,0,0,0,0,211,19,22,188,0,0,0,0,0,0,128,191,0,0,0,0,55,28,246,189,0,0,0,0,63,55,148,189,0,0,0,0,0,0,128,191,0,0,0,0,146,150,74,188,0,0,0,0,96,144,52,189,0,0,0,0,0,0,128,191,0,0,0,0,254,239,8,188,106,164,133,61,247,174,49,190,251,89,28,190,117,85,32,60,97,252,124,63,32,238,138,189,106,164,133,61,17,24,59,190,251,89,28,190,117,85,32,60,97,252,124,63,69,158,132,189,0,0,0,0,174,241,57,190,251,89,28,190,117,85,32,60,97,252,124,63,10,188,179,61,106,164,133,61,121,87,141,190,0,0,0,0,0,0,128,63,0,0,0,0,177,251,46,62,106,164,133,61,181,197,53,190,0,0,0,0,0,0,128,63,0,0,0,0,50,200,45,62,106,164,133,61,74,94,181,190,0,0,0,0,0,0,128,63,0,0,0,0,32,238,138,189,106,164,133,61,17,24,59,190,210,229,21,191,126,172,96,188,212,126,79,63,58,88,255,189,0,0,0,0,40,70,102,190,210,229,21,191,126,172,96,188,212,126,79,63,69,158,132,189,0,0,0,0,174,241,57,190,210,229,21,191,126,172,96,188,212,126,79,63,30,51,32,190,106,164,133,61,74,207,204,190,0,0,0,0,0,0,128,63,0,0,0,0,131,135,169,189,106,164,133,61,17,138,141,190,0,0,0,0,0,0,128,63,0,0,0,0,36,38,168,189,106,164,133,61,132,183,215,190,0,0,0,0,0,0,128,63,0,0,0,0,103,129,22,190,106,164,133,61,196,11,130,190,0,0,0,0,0,0,128,191,0,0,0,0,11,122,239,60,106,164,133,61,61,211,107,190,0,0,0,0,0,0,128,191,0,0,0,0,49,94,243,188,106,164,133,61,190,246,108,190,0,0,0,0,0,0,128,191,0,0,0,0,103,129,22,190,106,164,133,61,196,11,130,190,0,0,0,0,0,0,128,63,0,0,0,0,148,222,119,61,106,164,133,61,62,150,62,190,0,0,0,0,0,0,128,63,0,0,0,0,51,106,222,61,106,164,133,61,141,240,118,190,0,0,0,0,0,0,128,63,0,0,0,0,51,106,222,61,106,164,133,61,141,240,118,190,30,82,64,63,162,179,140,61,187,11,40,63,148,222,119,61,106,164,133,61,62,150,62,190,30,82,64,63,162,179,140,61,187,11,40,63,233,41,210,61,0,0,0,0,120,239,104,190,30,82,64,63,162,179,140,61,187,11,40,63,92,113,49,61,106,164,133,61,8,34,11,59,246,152,8,62,165,50,69,188,133,177,125,63,96,88,254,188,0,0,0,0,154,207,57,60,246,152,8,62,165,50,69,188,133,177,125,63,208,214,65,61,0,0,0,0,56,158,79,58,246,152,8,62,165,50,69,188,133,177,125,63,10,188,179,61,0,0,0,0,189,255,215,190,0,0,0,0,0,0,128,191,0,0,0,0,19,124,3,62,0,0,0,0,118,193,240,190,0,0,0,0,0,0,128,191,0,0,0,0,76,226,44,62,0,0,0,0,29,86,184,190,0,0,0,0,0,0,128,191,0,0,0,0,36,38,168,189,106,164,133,61,132,183,215,190,240,251,127,63,0,26,37,188,106,103,152,59,131,135,169,189,106,164,133,61,17,138,141,190,240,251,127,63,0,26,37,188,106,103,152,59,166,127,169,189,0,0,0,0,128,153,215,190,240,251,127,63,0,26,37,188,106,103,152,59,83,89,148,61,0,0,0,0,11,66,185,189,0,0,0,0,0,0,128,191,0,0,0,0,128,242,215,61,0,0,0,0,238,235,48,190,0,0,0,0,0,0,128,191,0,0,0,0,213,203,47,62,0,0,0,0,38,166,59,190,0,0,0,0,0,0,128,191,0,0,0,0,147,254,222,60,0,0,0,0,43,80,107,190,0,0,0,0,0,0,128,191,0,0,0,0,8,29,148,61,0,0,0,0,220,240,131,190,0,0,0,0,0,0,128,191,0,0,0,0,233,41,210,61,0,0,0,0,120,239,104,190,0,0,0,0,0,0,128,191,0,0,0,0,240,167,6,189,106,164,133,61,148,191,59,189,87,33,141,190,126,252,229,189,182,101,116,191,3,206,82,61,106,164,133,61,64,191,143,189,87,33,141,190,126,252,229,189,182,101,116,191,146,150,74,188,0,0,0,0,96,144,52,189,87,33,141,190,126,252,229,189,182,101,116,191,50,200,45,62,106,164,133,61,74,94,181,190,64,249,127,63,89,250,80,60,205,114,217,187,177,251,46,62,106,164,133,61,181,197,53,190,64,249,127,63,89,250,80,60,205,114,217,187,213,203,47,62,0,0,0,0,38,166,59,190,64,249,127,63,89,250,80,60,205,114,217,187,77,191,196,61,106,164,133,61,142,64,196,190,190,217,106,191,75,6,224,189,250,237,195,62,8,29,148,61,106,164,133,61,90,102,225,190,190,217,106,191,75,6,224,189,250,237,195,62,10,188,179,61,0,0,0,0,189,255,215,190,190,217,106,191,75,6,224,189,250,237,195,62,103,129,22,190,106,164,133,61,196,11,130,190,0,0,0,0,0,0,128,63,0,0,0,0,49,94,243,188,106,164,133,61,190,246,108,190,0,0,0,0,0,0,128,63,0,0,0,0,131,135,169,189,106,164,133,61,17,138,141,190,0,0,0,0,0,0,128,63,0,0,0,0,116,208,5,62,106,164,133,61,108,38,239,190,203,77,112,63,161,133,132,188,38,84,176,190,76,226,44,62,0,0,0,0,29,86,184,190,203,77,112,63,161,133,132,188,38,84,176,190,19,124,3,62,0,0,0,0,118,193,240,190,203,77,112,63,161,133,132,188,38,84,176,190,8,29,148,61,0,0,0,0,220,240,131,190,0,0,0,0,0,0,128,191,0,0,0,0,76,226,44,62,0,0,0,0,29,86,184,190,0,0,0,0,0,0,128,191,0,0,0,0,213,203,47,62,0,0,0,0,38,166,59,190,0,0,0,0,0,0,128,191,0,0,0,0,3,206,82,61,106,164,133,61,64,191,143,189,0,0,0,0,0,0,128,63,0,0,0,0,206,137,253,61,106,164,133,61,194,252,85,189,0,0,0,0,0,0,128,63,0,0,0,0,73,130,208,61,106,164,133,61,84,1,23,190,0,0,0,0,0,0,128,63,0,0,0,0,146,150,74,188,0,0,0,0,96,144,52,189,0,0,0,0,0,0,128,191,0,0,0,0,83,89,148,61,0,0,0,0,11,66,185,189,0,0,0,0,0,0,128,191,0,0,0,0,85,134,1,62,0,0,0,0,37,177,100,189,0,0,0,0,0,0,128,191,0,0,0,0,131,135,169,189,106,164,133,61,17,138,141,190,76,254,127,63,237,240,215,187,69,184,73,59,170,98,170,189,0,0,0,0,52,128,143,190,76,254,127,63,237,240,215,187,69,184,73,59,166,127,169,189,0,0,0,0,128,153,215,190,76,254,127,63,237,240,215,187,69,184,73,59,204,237,222,60,106,164,133,61,134,175,239,190,132,74,28,61,43,219,7,188,255,205,127,63,228,191,0,189,106,164,133,61,236,137,238,190,132,74,28,61,43,219,7,188,255,205,127,63,92,113,241,188,0,0,0,0,169,218,238,190,132,74,28,61,43,219,7,188,255,205,127,63,11,154,246,189,0,0,0,0,211,19,22,188,0,0,0,0,0,0,128,191,0,0,0,0,146,150,74,188,0,0,0,0,96,144,52,189,0,0,0,0,0,0,128,191,0,0,0,0,85,134,1,62,0,0,0,0,37,177,100,189,0,0,0,0,0,0,128,191,0,0,0,0,10,188,179,61,106,164,133,61,121,87,141,190,0,0,0,0,0,0,128,63,0,0,0,0,50,200,45,62,106,164,133,61,74,94,181,190,0,0,0,0,0,0,128,63,0,0,0,0,77,191,196,61,106,164,133,61,142,64,196,190,0,0,0,0,0,0,128,63,0,0,0,0,51,106,222,61,106,164,133,61,141,240,118,190,189,55,134,53,0,0,128,63,189,55,134,181,177,251,46,62,106,164,133,61,181,197,53,190,189,55,134,53,0,0,128,63,189,55,134,181,10,188,179,61,106,164,133,61,121,87,141,190,189,55,134,53,0,0,128,63,189,55,134,181,77,191,196,61,106,164,133,61,142,64,196,190,0,0,0,0,0,0,128,63,0,0,0,0,50,200,45,62,106,164,133,61,74,94,181,190,0,0,0,0,0,0,128,63,0,0,0,0,8,29,148,61,106,164,133,61,90,102,225,190,0,0,0,0,0,0,128,63,0,0,0,0,2,132,15,189,0,0,0,0,76,108,110,190,0,0,0,0,0,0,128,191,0,0,0,0,147,254,222,60,0,0,0,0,43,80,107,190,0,0,0,0,0,0,128,191,0,0,0,0,58,88,255,189,0,0,0,0,40,70,102,190,0,0,0,0,0,0,128,191,0,0,0,0,73,130,208,61,106,164,133,61,84,1,23,190,0,0,0,0,0,0,128,63,0,0,0,0,206,137,253,61,106,164,133,61,194,252,85,189,0,0,0,0,0,0,128,63,0,0,0,0,177,251,46,62,106,164,133,61,181,197,53,190,0,0,0,0,0,0,128,63,0,0,0,0,204,237,222,60,106,164,133,61,134,175,239,190,48,132,156,60,229,126,7,60,199,241,127,63,92,113,241,188,0,0,0,0,169,218,238,190,48,132,156,60,229,126,7,60,199,241,127,63,143,111,239,60,0,0,0,0,185,109,239,190,48,132,156,60,229,126,7,60,199,241,127,63,206,137,253,61,106,164,133,61,194,252,85,189,125,230,20,63])
.concat([82,239,169,188,145,44,80,63,208,214,65,61,0,0,0,0,56,158,79,58,125,230,20,63,82,239,169,188,145,44,80,63,85,134,1,62,0,0,0,0,37,177,100,189,125,230,20,63,82,239,169,188,145,44,80,63,240,167,6,189,106,164,133,61,148,191,59,189,0,0,0,0,0,0,128,63,0,0,0,0,206,137,253,61,106,164,133,61,194,252,85,189,0,0,0,0,0,0,128,63,0,0,0,0,3,206,82,61,106,164,133,61,64,191,143,189,0,0,0,0,0,0,128,63,0,0,0,0,30,51,32,190,106,164,133,61,74,207,204,190,0,0,0,0,0,0,128,63,0,0,0,0,36,38,168,189,106,164,133,61,132,183,215,190,0,0,0,0,0,0,128,63,0,0,0,0,236,78,247,189,106,164,133,61,110,137,244,190,0,0,0,0,0,0,128,63,0,0,0,0,120,69,32,190,0,0,0,0,16,236,152,190,0,0,0,0,0,0,128,191,0,0,0,0,34,137,30,190,0,0,0,0,111,214,208,190,0,0,0,0,0,0,128,191,0,0,0,0,166,127,169,189,0,0,0,0,128,153,215,190,0,0,0,0,0,0,128,191,0,0,0,0,103,129,22,190,106,164,133,61,196,11,130,190,0,0,0,0,0,0,128,63,0,0,0,0,131,135,169,189,106,164,133,61,17,138,141,190,0,0,0,0,0,0,128,63,0,0,0,0,30,51,32,190,106,164,133,61,74,207,204,190,0,0,0,0,0,0,128,63,0,0,0,0,103,129,22,190,106,164,133,61,196,11,130,190,36,40,126,191,50,230,206,61,82,210,131,61,30,51,32,190,106,164,133,61,74,207,204,190,36,40,126,191,50,230,206,61,82,210,131,61,120,69,32,190,0,0,0,0,16,236,152,190,36,40,126,191,50,230,206,61,82,210,131,61,77,191,196,61,0,0,0,0,169,22,161,190,0,0,0,0,0,0,128,191,0,0,0,0,10,188,179,61,0,0,0,0,189,255,215,190,0,0,0,0,0,0,128,191,0,0,0,0,76,226,44,62,0,0,0,0,29,86,184,190,0,0,0,0,0,0,128,191,0,0,0,0,254,239,8,188,106,164,133,61,247,174,49,190,0,0,0,0,0,0,128,63,0,0,0,0,148,222,119,61,106,164,133,61,62,150,62,190,0,0,0,0,0,0,128,63,0,0,0,0,32,238,138,189,106,164,133,61,17,24,59,190,0,0,0,0,0,0,128,63,0,0,0,0,120,69,32,190,0,0,0,0,16,236,152,190,0,0,0,0,0,0,128,191,0,0,0,0,166,127,169,189,0,0,0,0,128,153,215,190,0,0,0,0,0,0,128,191,0,0,0,0,170,98,170,189,0,0,0,0,52,128,143,190,0,0,0,0,0,0,128,191,0,0,0,0,96,88,254,188,0,0,0,0,154,207,57,60,0,0,0,0,0,0,128,191,0,0,0,0,11,154,246,189,0,0,0,0,211,19,22,188,0,0,0,0,0,0,128,191,0,0,0,0,208,214,65,61,0,0,0,0,56,158,79,58,0,0,0,0,0,0,128,191,0,0,0,0,58,88,255,189,0,0,0,0,40,70,102,190,0,0,0,0,0,0,128,191,0,0,0,0,147,254,222,60,0,0,0,0,43,80,107,190,0,0,0,0,0,0,128,191,0,0,0,0,233,41,210,61,0,0,0,0,120,239,104,190,0,0,0,0,0,0,128,191,0,0,0,0,8,29,148,61,106,164,133,61,90,102,225,190,0,0,0,0,0,0,128,63,0,0,0,0,116,208,5,62,106,164,133,61,108,38,239,190,0,0,0,0,0,0,128,63,0,0,0,0,204,237,222,60,106,164,133,61,134,175,239,190,0,0,0,0,0,0,128,63,0,0,0,0,69,158,132,189,0,0,0,0,174,241,57,190,0,0,0,0,0,0,128,191,0,0,0,0,233,41,210,61,0,0,0,0,120,239,104,190,0,0,0,0,0,0,128,191,0,0,0,0,38,28,58,61,0,0,0,0,111,128,57,190,0,0,0,0,0,0,128,191,0,0,0,0,92,113,49,61,106,164,133,61,8,34,11,59,69,246,1,62,73,45,148,187,91,237,125,63,162,183,248,188,106,164,133,61,104,64,61,60,69,246,1,62,73,45,148,187,91,237,125,63,96,88,254,188,0,0,0,0,154,207,57,60,69,246,1,62,73,45,148,187,91,237,125,63,236,78,247,189,106,164,133,61,110,137,244,190,239,113,94,191,120,66,143,189,190,221,250,190,86,72,217,189,0,0,0,0,60,20,253,190,239,113,94,191,120,66,143,189,190,221,250,190,34,137,30,190,0,0,0,0,111,214,208,190,239,113,94,191,120,66,143,189,190,221,250,190,89,80,248,189,106,164,133,61,105,81,31,188,0,0,0,0,0,0,128,63,0,0,0,0,92,113,49,61,106,164,133,61,8,34,11,59,0,0,0,0,0,0,128,63,0,0,0,0,206,137,253,61,106,164,133,61,194,252,85,189,0,0,0,0,0,0,128,63,0,0,0,0,177,251,46,62,106,164,133,61,181,197,53,190,125,150,111,63,70,180,157,60,172,26,180,62,206,137,253,61,106,164,133,61,194,252,85,189,125,150,111,63,70,180,157,60,172,26,180,62,85,134,1,62,0,0,0,0,37,177,100,189,125,150,111,63,70,180,157,60,172,26,180,62,228,191,0,189,106,164,133,61,236,137,238,190,0,0,0,0,0,0,128,63,0,0,0,0,204,237,222,60,106,164,133,61,134,175,239,190,0,0,0,0,0,0,128,63,0,0,0,0,236,78,247,189,106,164,133,61,110,137,244,190,0,0,0,0,0,0,128,63,0,0,0,0,206,137,253,61,106,164,133,61,194,252,85,189,145,72,15,63,92,201,142,60,93,25,84,63,92,113,49,61,106,164,133,61,8,34,11,59,145,72,15,63,92,201,142,60,93,25,84,63,208,214,65,61,0,0,0,0,56,158,79,58,145,72,15,63,92,201,142,60,93,25,84,63,177,251,46,62,106,164,133,61,181,197,53,190,16,61,113,63,16,207,146,188,9,26,171,62,85,134,1,62,0,0,0,0,37,177,100,189,16,61,113,63,16,207,146,188,9,26,171,62,213,203,47,62,0,0,0,0,38,166,59,190,16,61,113,63,16,207,146,188,9,26,171,62,162,183,248,188,106,164,133,61,104,64,61,60,47,248,100,190,234,120,76,186,161,132,121,63,11,154,246,189,0,0,0,0,211,19,22,188,47,248,100,190,234,120,76,186,161,132,121,63,96,88,254,188,0,0,0,0,154,207,57,60,47,248,100,190,234,120,76,186,161,132,121,63,8,29,148,61,106,164,133,61,90,102,225,190,0,57,29,191,35,20,155,61,156,25,73,63,143,111,239,60,0,0,0,0,185,109,239,190,0,57,29,191,35,20,155,61,156,25,73,63,10,188,179,61,0,0,0,0,189,255,215,190,0,57,29,191,35,20,155,61,156,25,73,63,147,254,222,60,0,0,0,0,43,80,107,190,198,138,154,60,59,26,7,188,27,242,127,191,49,94,243,188,106,164,133,61,190,246,108,190,198,138,154,60,59,26,7,188,27,242,127,191,11,122,239,60,106,164,133,61,61,211,107,190,198,138,154,60,59,26,7,188,27,242,127,191,226,31,246,189,106,164,133,61,16,65,149,189,24,123,151,62,24,237,241,187,30,136,116,191,240,167,6,189,106,164,133,61,148,191,59,189,24,123,151,62,24,237,241,187,30,136,116,191,55,28,246,189,0,0,0,0,63,55,148,189,24,123,151,62,24,237,241,187,30,136,116,191,11,122,239,60,106,164,133,61,61,211,107,190,29,58,29,191,119,16,155,189,194,24,73,191,10,188,179,61,106,164,133,61,121,87,141,190,29,58,29,191,119,16,155,189,194,24,73,191,8,29,148,61,0,0,0,0,220,240,131,190,29,58,29,191,119,16,155,189,194,24,73,191,89,80,248,189,106,164,133,61,105,81,31,188,26,250,127,191,164,111,82,188,193,59,121,187,55,28,246,189,0,0,0,0,63,55,148,189,26,250,127,191,164,111,82,188,193,59,121,187,11,154,246,189,0,0,0,0,211,19,22,188,26,250,127,191,164,111,82,188,193,59,121,187,10,188,179,61,106,164,133,61,121,87,141,190,140,101,126,191,159,233,165,189,127,163,157,189,77,191,196,61,106,164,133,61,142,64,196,190,140,101,126,191,159,233,165,189,127,163,157,189,77,191,196,61,0,0,0,0,169,22,161,190,140,101,126,191,159,233,165,189,127,163,157,189,30,51,32,190,106,164,133,61,74,207,204,190,250,124,104,191,230,60,227,60,55,222,213,190,236,78,247,189,106,164,133,61,110,137,244,190,250,124,104,191,230,60,227,60,55,222,213,190,34,137,30,190,0,0,0,0,111,214,208,190,250,124,104,191,230,60,227,60,55,222,213,190,69,158,132,189,0,0,0,0,174,241,57,190,0,0,0,0,0,0,128,191,0,0,0,0,58,88,255,189,0,0,0,0,40,70,102,190,0,0,0,0,0,0,128,191,0,0,0,0,233,41,210,61,0,0,0,0,120,239,104,190,0,0,0,0,0,0,128,191,0,0,0,0,8,29,148,61,0,0,0,0,220,240,131,190,0,0,0,0,0,0,128,191,0,0,0,0,77,191,196,61,0,0,0,0,169,22,161,190,0,0,0,0,0,0,128,191,0,0,0,0,76,226,44,62,0,0,0,0,29,86,184,190,0,0,0,0,0,0,128,191,0,0,0,0,89,80,248,189,106,164,133,61,105,81,31,188,0,0,0,0,0,0,128,63,0,0,0,0,240,167,6,189,106,164,133,61,148,191,59,189,0,0,0,0,0,0,128,63,0,0,0,0,226,31,246,189,106,164,133,61,16,65,149,189,0,0,0,0,0,0,128,63,0,0,0,0,40,96,155,190,41,9,137,187,208,67,133,190,0,0,0,0,0,0,128,191,0,0,0,0,189,140,186,62,41,9,137,187,132,73,137,190,0,0,0,0,0,0,128,191,0,0,0,0,138,117,170,62,41,9,137,187,127,19,58,190,0,0,0,0,0,0,128,191,0,0,0,0,245,72,139,190,41,9,137,187,204,13,54,190,0,0,0,0,0,0,128,191,0,0,0,0,40,96,155,190,41,9,137,187,208,67,133,190,0,0,0,0,0,0,128,191,0,0,0,0,8,205,142,61,41,9,137,187,127,19,58,190,0,0,0,0,0,0,128,191,0,0,0,0,8,205,142,61,41,9,137,187,127,19,58,190,0,0,0,0,0,0,128,191,0,0,0,0,40,96,155,190,41,9,137,187,208,67,133,190,0,0,0,0,0,0,128,191,0,0,0,0,138,117,170,62,41,9,137,187,127,19,58,190,0,0,0,0,0,0,128,191,0,0,0,0,245,72,139,190,41,9,137,187,204,13,54,190,19,185,96,187,243,87,116,191,132,186,152,190,8,205,142,61,41,9,137,187,127,19,58,190,19,185,96,187,243,87,116,191,132,186,152,190,154,36,22,189,194,47,117,188,36,126,21,190,19,185,96,187,243,87,116,191,132,186,152,190,154,36,22,189,194,47,117,188,36,126,21,190,199,132,216,61,152,137,126,191,4,254,112,60,8,205,142,61,41,9,137,187,127,19,58,190,199,132,216,61,152,137,126,191,4,254,112,60,231,54,225,59,41,9,137,187,154,67,138,62,199,132,216,61,152,137,126,191,4,254,112,60,94,14,187,189,41,9,137,187,230,61,134,62,98,248,8,187,117,233,127,191,124,12,214,60,154,36,22,189,194,47,117,188,36,126,21,190,98,248,8,187,117,233,127,191,124,12,214,60,231,54,225,59,41,9,137,187,154,67,138,62,98,248,8,187,117,233,127,191,124,12,214,60,76,110,156,190,4,1,242,61,168,141,130,190,0,0,0,0,0,0,128,63,0,0,0,0,102,103,169,62,4,1,242,61,114,167,52,190,0,0,0,0,0,0,128,63,0,0,0,0,153,126,185,62,4,1,242,61,125,147,134,190,0,0,0,0,0,0,128,63,0,0,0,0,25,87,140,190,4,1,242,61,123,161,48,190,0,0,0,0,0,0,128,63,0,0,0,0,121,148,138,61,4,1,242,61,114,167,52,190,0,0,0,0,0,0,128,63,0,0,0,0,76,110,156,190,4,1,242,61,168,141,130,190,0,0,0,0,0,0,128,63,0,0,0,0,121,148,138,61,4,1,242,61,114,167,52,190,0,0,0,0,0,0,128,63,0,0,0,0,102,103,169,62,4,1,242,61,114,167,52,190,0,0,0,0,0,0,128,63,0,0,0,0,76,110,156,190,4,1,242,61,168,141,130,190,0,0,0,0,0,0,128,63,0,0,0,0,25,87,140,190,4,1,242,61,123,161,48,190,19,185,96,59,243,87,116,63,132,186,152,62,184,149,30,189,158,235,219,61,23,18,16,190,19,185,96,59,243,87,116,63,132,186,152,62,121,148,138,61,4,1,242,61,114,167,52,190,19,185,96,59,243,87,116,63,132,186,152,62,184,149,30,189,158,235,219,61,23,18,16,190,199,132,216,189,152,137,126,63,4,254,112,188,251,173,157,59,4,1,242,61,194,249,140,62,199,132,216,189,152,137,126,63,4,254,112,188,121,148,138,61,4,1,242,61,114,167,52,190,199,132,216,189,152,137,126,63,4,254,112,188,237,70,191,189,4,1,242,61,237,243,136,62,98,248,8,59,117,233,127,63,124,12,214,188,251,173,157,59,4,1,242,61,194,249,140,62,98,248,8,59,117,233,127,63,124,12,214,188,184,149,30,189,158,235,219,61,23,18,16,190,98,248,8,59,117,233,127,63,124,12,214,188,76,110,156,190,4,1,242,61,168,141,130,190,168,143,64,188,194,75,48,61,186,190,127,191,153,126,185,62,4,1,242,61,125,147,134,190,168,143,64,188,194,75,48,61,186,190,127,191,189,140,186,62,41,9,137,187,132,73,137,190,168,143,64,188,194,75,48,61,186,190,127,191,76,110,156,190,4,1,242,61,168,141,130,190,168,143,64,188,194,75,48,61,186,190,127,191,189,140,186,62,41,9,137,187,132,73,137,190,168,143,64,188,194,75,48,61,186,190,127,191,40,96,155,190,41,9,137,187,208,67,133,190,168,143,64,188,194,75,48,61,186,190,127,191,237,70,191,189,4,1,242,61,237,243,136,62,94,186,125,191,246,153,51,188,93,169,7,190,184,149,30,189,158,235,219,61,23,18,16,190,94,186,125,191,246,153,51,188,93,169,7,190,154,36,22,189,194,47,117,188,36,126,21,190,94,186,125,191,246,153,51,188,93,169,7,190,237,70,191,189,4,1,242,61,237,243,136,62,94,186,125,191,246,153,51,188,93,169,7,190,154,36,22,189,194,47,117,188,36,126,21,190,94,186,125,191,246,153,51,188,93,169,7,190,94,14,187,189,41,9,137,187,230,61,134,62,94,186,125,191,246,153,51,188,93,169,7,190,153,126,185,62,4,1,242,61,125,147,134,190,70,150,112,63,156,80,136,58,240,248,174,62,102,103,169,62,4,1,242,61,114,167,52,190,70,150,112,63,156,80,136,58,240,248,174,62,138,117,170,62,41,9,137,187,127,19,58,190,70,150,112,63,156,80,136,58,240,248,174,62,153,126,185,62,4,1,242,61,125,147,134,190,70,150,112,63,156,80,136,58,240,248,174,62,138,117,170,62,41,9,137,187,127,19,58,190,70,150,112,63,156,80,136,58,240,248,174,62,189,140,186,62,41,9,137,187,132,73,137,190,70,150,112,63,156,80,136,58,240,248,174,62,40,96,155,190,41,9,137,187,208,67,133,190,235,28,111,191,212,14,255,188,111,46,182,62,245,72,139,190,41,9,137,187,204,13,54,190,235,28,111,191,212,14,255,188,111,46,182,62,25,87,140,190,4,1,242,61,123,161,48,190,235,28,111,191,212,14,255,188,111,46,182,62,40,96,155,190,41,9,137,187,208,67,133,190,235,28,111,191,212,14,255,188,111,46,182,62,25,87,140,190,4,1,242,61,123,161,48,190,235,28,111,191,212,14,255,188,111,46,182,62,76,110,156,190,4,1,242,61,168,141,130,190,235,28,111,191,212,14,255,188,111,46,182,62,102,103,169,62,4,1,242,61,114,167,52,190,0,0,0,0,134,30,49,189,185,194,127,63,121,148,138,61,4,1,242,61,114,167,52,190,0,0,0,0,134,30,49,189,185,194,127,63,8,205,142,61,41,9,137,187,127,19,58,190,0,0,0,0,134,30,49,189,185,194,127,63,102,103,169,62,4,1,242,61,114,167,52,190,0,0,0,0,134,30,49,189,185,194,127,63,8,205,142,61,41,9,137,187,127,19,58,190,0,0,0,0,134,30,49,189,185,194,127,63,138,117,170,62,41,9,137,187,127,19,58,190,0,0,0,0,134,30,49,189,185,194,127,63,121,148,138,61,4,1,242,61,114,167,52,190,13,139,125,63,240,162,47,60,34,26,13,62,251,173,157,59,4,1,242,61,194,249,140,62,13,139,125,63,240,162,47,60,34,26,13,62,231,54,225,59,41,9,137,187,154,67,138,62,13,139,125,63,240,162,47,60,34,26,13,62,121,148,138,61,4,1,242,61,114,167,52,190,13,139,125,63,240,162,47,60,34,26,13,62,231,54,225,59,41,9,137,187,154,67,138,62,13,139,125,63,240,162,47,60,34,26,13,62,8,205,142,61,41,9,137,187,127,19,58,190,13,139,125,63,240,162,47,60,34,26,13,62,251,173,157,59,4,1,242,61,194,249,140,62,116,40,163,189,233,10,54,189,183,238,126,63,237,70,191,189,4,1,242,61,237,243,136,62,116,40,163,189,233,10,54,189,183,238,126,63,94,14,187,189,41,9,137,187,230,61,134,62,116,40,163,189,233,10,54,189,183,238,126,63,251,173,157,59,4,1,242,61,194,249,140,62,116,40,163,189,233,10,54,189,183,238,126,63,94,14,187,189,41,9,137,187,230,61,134,62,116,40,163,189,233,10,54,189,183,238,126,63,231,54,225,59,41,9,137,187,154,67,138,62,116,40,163,189,233,10,54,189,183,238,126,63,245,72,139,190,41,9,137,187,204,13,54,190,251,5,11,190,242,211,56,189,213,93,125,63,154,36,22,189,194,47,117,188,36,126,21,190,251,5,11,190,242,211,56,189,213,93,125,63,184,149,30,189,158,235,219,61,23,18,16,190,251,5,11,190,242,211,56,189,213,93,125,63,245,72,139,190,41,9,137,187,204,13,54,190,251,5,11,190,242,211,56,189,213,93,125,63,184,149,30,189,158,235,219,61,23,18,16,190,251,5,11,190,242,211,56,189,213,93,125,63,25,87,140,190,4,1,242,61,123,161,48,190,251,5,11,190,242,211,56,189,213,93,125,63,86,212,128,190,0,0,0,0,175,210,109,62,0,0,0,0,0,0,128,191,0,0,0,0,224,75,65,190,0,0,0,0,37,119,40,190,0,0,0,0,0,0,128,191,0,0,0,0,125,175,225,189,0,0,0,0,247,203,135,189,0,0,0,0,0,0,128,191,0,0,0,0,125,175,225,189,0,0,0,0,247,203,135,189,0,0,0,0,0,0,128,191,0,0,0,0,224,75,65,190,0,0,0,0,37,119,40,190,0,0,0,0,0,0,128,191,0,0,0,0,144,164,132,62,0,0,0,0,109,87,232,189,0,0,0,0,0,0,128,191,0,0,0,0,125,175,225,189,0,0,0,0,247,203,135,189,0,0,0,0,0,0,128,191,0,0,0,0,144,164,132,62,0,0,0,0,109,87,232,189,0,0,0,0,0,0,128,191,0,0,0,0,113,171,192,61,0,0,0,0,118,82,95,189,0,0,0,0,0,0,128,191,0,0,0,0,113,171,192,61,0,0,0,0,118,82,95,189,0,0,0,0,0,0,128,191,0,0,0,0,144,164,132,62,0,0,0,0,109,87,232,189,0,0,0,0,0,0,128,191,0,0,0,0,185,26,105,62,0,0,0,0,172,171,2,61,0,0,0,0,0,0,128,191,0,0,0,0,86,212,128,190,0,0,0,0,175,210,109,62,0,0,0,0,0,0,128,191,0,0,0,0,125,175,225,189,0,0,0,0,247,203,135,189,0,0,0,0,0,0,128,191,0,0,0,0,104,6,17,190,0,0,0,0,133,65,9,62,0,0,0,0,0,0,128,191,0,0,0,0,213,236,65,189,0,0,0,0,5,250,196,60,0,0,0,0,0,0,128,191,0,0,0,0,113,171,192,61,0,0,0,0,118,82,95,189,0,0,0,0,0,0,128,191,0,0,0,0,185,26,105,62,0,0,0,0,172,171,2,61,0,0,0,0,0,0,128,191,0,0,0,0,125,149,12,62,0,0,0,0,226,117,45,62,0,0,0,0,0,0,128,191,0,0,0,0,39,161,20,62,0,0,0,0,214,26,202,61,0,0,0,0,0,0,128,191,0,0,0,0,99,38,113,62,0,0,0,0,78,96,250,61,0,0,0,0,0,0,128,191,0,0,0,0,125,149,12,62,0,0,0,0,226,117,45,62,0,0,0,0,0,0,128,191,0,0,0,0,99,38,113,62,0,0,0,0,78,96,250,61,0,0,0,0,0,0,128,191,0,0,0,0,82,15,97,62,0,0,0,0,219,247,128,62,0,0,0,0,0,0,128,191,0,0,0,0,86,212,128,190,0,0,0,0,175,210,109,62,0,0,0,0,0,0,128,191,0,0,0,0,104,6,17,190,0,0,0,0,133,65,9,62,0,0,0,0,0,0,128,191,0,0,0,0,125,149,12,62,0,0,0,0,226,117,45,62,0,0,0,0,0,0,128,191,0,0,0,0,86,212,128,190,0,0,0,0,175,210,109,62,0,0,0,0,0,0,128,191,0,0,0,0,125,149,12,62,0,0,0,0,226,117,45,62,0,0,0,0,0,0,128,191,0,0,0,0,82,15,97,62,0,0,0,0,219,247,128,62,0,0,0,0,0,0,128,191,0,0,0,0,86,212,128,190,20,123,200,61,175,210,109,62,0,0,0,0,0,0,128,63,0,0,0,0,125,175,225,189,20,123,200,61,247,203,135,189,0,0,0,0,0,0,128,63,0,0,0,0,224,75,65,190,20,123,200,61,37,119,40,190,0,0,0,0,0,0,128,63,0,0,0,0,125,175,225,189,20,123,200,61,247,203,135,189,0,0,0,0,0,0,128,63,0,0,0,0,144,164,132,62,20,123,200,61,109,87,232,189,0,0,0,0,0,0,128,63,0,0,0,0,224,75,65,190,20,123,200,61,37,119,40,190,0,0,0,0,0,0,128,63,0,0,0,0,125,175,225,189,20,123,200,61,247,203,135,189,0,0,0,0,0,0,128,63,0,0,0,0,113,171,192,61,20,123,200,61,118,82,95,189,0,0,0,0,0,0,128,63,0,0,0,0,144,164,132,62,20,123,200,61,109,87,232,189,0,0,0,0,0,0,128,63,0,0,0,0,113,171,192,61,20,123,200,61,118,82,95,189,0,0,0,0,0,0,128,63,0,0,0,0,185,26,105,62,20,123,200,61,172,171,2,61,0,0,0,0,0,0,128,63,0,0,0,0,144,164,132,62,20,123,200,61,109,87,232,189,0,0,0,0,0,0,128,63,0,0,0,0,86,212,128,190,20,123,200,61,175,210,109,62,0,0,0,0,0,0,128,63,0,0,0,0,104,6,17,190,20,123,200,61,133,65,9,62,0,0,0,0,0,0,128,63,0,0,0,0,125,175,225,189,20,123,200,61,247,203,135,189,0,0,0,0,0,0,128,63,0,0,0,0,213,236,65,189,20,123,200,61,5,250,196,60,0,0,0,0,0,0,128,63,0,0,0,0,185,26,105,62,20,123,200,61,172,171,2,61,0,0,0,0,0,0,128,63,0,0,0,0,113,171,192,61,20,123,200,61,118,82,95,189,0,0,0,0,0,0,128,63,0,0,0,0,125,149,12,62,20,123,200,61,226,117,45,62,0,0,0,0,0,0,128,63,0,0,0,0,99,38,113,62,20,123,200,61,78,96,250,61,0,0,0,0,0,0,128,63,0,0,0,0,39,161,20,62,20,123,200,61,214,26,202,61,0,0,0,0,0,0,128,63,0,0,0,0,125,149,12,62,20,123,200,61,226,117,45,62,0,0,0,0,0,0,128,63,0,0,0,0,82,15,97,62,20,123,200,61,219,247,128,62,0,0,0,0,0,0,128,63,0,0,0,0,99,38,113,62,20,123,200,61,78,96,250,61,0,0,0,0,0,0,128,63,0,0,0,0,86,212,128,190,20,123,200,61,175,210,109,62,0,0,0,0,0,0,128,63,0,0,0,0,125,149,12,62,20,123,200,61,226,117,45,62,0,0,0,0,0,0,128,63,0,0,0,0,104,6,17,190,20,123,200,61,133,65,9,62,0,0,0,0,0,0,128,63,0,0,0,0,86,212,128,190,20,123,200,61,175,210,109,62,0,0,0,0,0,0,128,63,0,0,0,0,82,15,97,62,20,123,200,61,219,247,128,62,0,0,0,0,0,0,128,63,0,0,0,0,125,149,12,62,20,123,200,61,226,117,45,62,0,0,0,0,0,0,128,63,0,0,0,0,224,75,65,190,0,0,0,0,37,119,40,190,220,216,124,191,0,0,0,0,92,56,32,190,86,212,128,190,0,0,0,0,175,210,109,62,220,216,124,191,0,0,0,0,92,56,32,190,86,212,128,190,20,123,200,61,175,210,109,62,220,216,124,191,0,0,0,0,92,56,32,190,224,75,65,190,0,0,0,0,37,119,40,190,220,216,124,191,0,0,0,0,92,56,32,190,86,212,128,190,20,123,200,61,175,210,109,62,220,216,124,191,0,0,0,0,92,56,32,190,224,75,65,190,20,123,200,61,37,119,40,190,220,216,124,191,0,0,0,0,92,56,32,190,99,38,113,62,0,0,0,0,78,96,250,61,117,61,129,62,0,0,0,0,191,181,119,191,39,161,20,62,0,0,0,0,214,26,202,61,117,61,129,62,0,0,0,0,191,181,119,191,39,161,20,62,20,123,200,61,214,26,202,61,117,61,129,62,0,0,0,0,191,181,119,191,99,38,113,62,0,0,0,0,78,96,250,61,117,61,129,62,0,0,0,0,191,181,119,191,39,161,20,62,20,123,200,61,214,26,202,61,117,61,129,62,0,0,0,0,191,181,119,191,99,38,113,62,20,123,200,61,78,96,250,61,117,61,129,62,0,0,0,0,191,181,119,191,125,175,225,189,0,0,0,0,247,203,135,189,201,233,107,189,0,0,0,0,54,147,127,63,113,171,192,61,0,0,0,0,118,82,95,189,201,233,107,189,0,0,0,0,54,147,127,63,113,171,192,61,20,123,200,61,118,82,95,189,201,233,107,189,0,0,0,0,54,147,127,63,125,175,225,189,0,0,0,0,247,203,135,189,201,233,107,189,0,0,0,0,54,147,127,63,113,171,192,61,20,123,200,61,118,82,95,189,201,233,107,189,0,0,0,0,54,147,127,63,125,175,225,189,20,123,200,61,247,203,135,189,201,233,107,189,0,0,0,0,54,147,127,63,213,236,65,189,0,0,0,0,5,250,196,60,169,246,233,188,0,0,0,0,67,229,127,63,185,26,105,62,0,0,0,0,172,171,2,61,169,246,233,188,0,0,0,0,67,229,127,63,185,26,105,62,20,123,200,61,172,171,2,61,169,246,233,188,0,0,0,0,67,229,127,63,213,236,65,189,0,0,0,0,5,250,196,60,169,246,233,188,0,0,0,0,67,229,127,63,185,26,105,62,20,123,200,61,172,171,2,61,169,246,233,188,0,0,0,0,67,229,127,63,213,236,65,189,20,123,200,61,5,250,196,60,169,246,233,188,0,0,0,0,67,229,127,63,39,161,20,62,0,0,0,0,214,26,202,61,47,111,126,191,0,0,0,0,166,41,226,189,125,149,12,62,0,0,0,0,226,117,45,62,47,111,126,191,0,0,0,0,166,41,226,189,125,149,12,62,20,123,200,61,226,117,45,62,47,111,126,191,0,0,0,0,166,41,226,189,39,161,20,62,0,0,0,0,214,26,202,61,47,111,126,191,0,0,0,0,166,41,226,189,125,149,12,62,20,123,200,61,226,117,45,62,47,111,126,191,0,0,0,0,166,41,226,189,39,161,20,62,20,123,200,61,214,26,202,61,47,111,126,191,0,0,0,0,166,41,226,189,144,164,132,62,0,0,0,0,109,87,232,189,91,10,232,61,0,0,0,0,4,90,126,191,224,75,65,190,0,0,0,0,37,119,40,190,91,10,232,61,0,0,0,0,4,90,126,191,224,75,65,190,20,123,200,61,37,119,40,190,91,10,232,61,0,0,0,0,4,90,126,191,144,164,132,62,0,0,0,0,109,87,232,189,91,10,232,61,0,0,0,0,4,90,126,191,224,75,65,190,20,123,200,61,37,119,40,190,91,10,232,61,0,0,0,0,4,90,126,191,144,164,132,62,20,123,200,61,109,87,232,189,91,10,232,61,0,0,0,0,4,90,126,191,104,6,17,190,0,0,0,0,133,65,9,62,66,232,124,63,0,0,0,0,238,175,30,62,125,175,225,189,0,0,0,0,247,203,135,189,66,232,124,63,0,0,0,0,238,175,30,62,125,175,225,189,20,123,200,61,247,203,135,189,66,232,124,63,0,0,0,0,238,175,30,62,104,6,17,190,0,0,0,0,133,65,9,62,66,232,124,63,0,0,0,0,238,175,30,62,125,175,225,189,20,123,200,61,247,203,135,189,66,232,124,63,0,0,0,0,238,175,30,62,104,6,17,190,20,123,200,61,133,65,9,62,66,232,124,63,0,0,0,0,238,175,30,62,125,149,12,62,0,0,0,0,226,117,45,62,168,197,0,62,0,0,0,0,182,247,125,191,104,6,17,190,0,0,0,0,133,65,9,62,168,197,0,62,0,0,0,0,182,247,125,191,104,6,17,190,20,123,200,61,133,65,9,62,168,197,0,62,0,0,0,0,182,247,125,191,125,149,12,62,0,0,0,0,226,117,45,62,168,197,0,62,0,0,0,0,182,247,125,191,104,6,17,190,20,123,200,61,133,65,9,62,168,197,0,62,0,0,0,0,182,247,125,191,125,149,12,62,20,123,200,61,226,117,45,62,168,197,0,62,0,0,0,0,182,247,125,191,82,15,97,62,0,0,0,0,219,247,128,62,209,35,126,63,0,0,0,0,25,112,246,61,99,38,113,62,0,0,0,0,78,96,250,61,209,35,126,63,0,0,0,0,25,112,246,61,99,38,113,62,20,123,200,61,78,96,250,61,209,35,126,63,0,0,0,0,25,112,246,61,82,15,97,62,0,0,0,0,219,247,128,62,209,35,126,63,0,0,0,0,25,112,246,61,99,38,113,62,20,123,200,61,78,96,250,61,209,35,126,63,0,0,0,0,25,112,246,61,82,15,97,62,20,123,200,61,219,247,128,62,209,35,126,63,0,0,0,0,25,112,246,61,86,212,128,190,0,0,0,0,175,210,109,62,68,133,42,189,0,0,0,0,46,199,127,63,82,15,97,62,0,0,0,0,219,247,128,62,68,133,42,189,0,0,0,0,46,199,127,63,82,15,97,62,20,123,200,61,219,247,128,62,68,133,42,189,0,0,0,0,46,199,127,63,86,212,128,190,0,0,0,0,175,210,109,62,68,133,42,189,0,0,0,0,46,199,127,63,82,15,97,62,20,123,200,61,219,247,128,62,68,133,42,189,0,0,0,0,46,199,127,63,86,212,128,190,20,123,200,61,175,210,109,62,68,133,42,189,0,0,0,0,46,199,127,63,185,26,105,62,0,0,0,0,172,171,2,61,206,55,122,63,0,0,0,0,106,103,88,62,144,164,132,62,0,0,0,0,109,87,232,189,206,55,122,63,0,0,0,0,106,103,88,62,144,164,132,62,20,123,200,61,109,87,232,189,206,55,122,63,0,0,0,0,106,103,88,62,185,26,105,62,0,0,0,0,172,171,2,61,206,55,122,63,0,0,0,0,106,103,88,62,144,164,132,62,20,123,200,61,109,87,232,189,206,55,122,63,0,0,0,0,106,103,88,62,185,26,105,62,20,123,200,61,172,171,2,61,206,55,122,63,0,0,0,0,106,103,88,62,113,171,192,61,0,0,0,0,118,82,95,189,51,166,248,190,0,0,0,0,193,200,95,191,213,236,65,189,0,0,0,0,5,250,196,60,51,166,248,190,0,0,0,0,193,200,95,191,213,236,65,189,20,123,200,61,5,250,196,60,51,166,248,190,0,0,0,0,193,200,95,191,113,171,192,61,0,0,0,0,118,82,95,189,51,166,248,190,0,0,0,0,193,200,95,191,213,236,65,189,20,123,200,61,5,250,196,60,51,166,248,190,0,0,0,0,193,200,95,191,113,171,192,61,20,123,200,61,118,82,95,189,51,166,248,190,0,0,0,0,193,200,95,191,29,230,27,190,0,0,0,0,92,1,197,189,0,0,0,0,0,0,128,191,0,0,0,0,103,41,129,62,0,0,0,0,148,46,221,189,0,0,0,0,0,0,128,191,0,0,0,0,2,12,235,61,0,0,0,0,202,21,94,188,0,0,0,0,0,0,128,191,0,0,0,0,2,12,235,61,0,0,0,0,202,21,94,188,0,0,0,0,0,0,128,191,0,0,0,0,103,41,129,62,0,0,0,0,148,46,221,189,0,0,0,0,0,0,128,191,0,0,0,0,224,156,1,62,0,0,0,0,161,161,127,62,0,0,0,0,0,0,128,191,0,0,0,0,53,42,96,190,0,0,0,0,207,78,18,63,0,0,0,0,0,0,128,191,0,0,0,0,29,230,27,190,0,0,0,0,92,1,197,189,0,0,0,0,0,0,128,191,0,0,0,0,46,27,93,189,0,0,0,0,214,168,7,59,0,0,0,0,0,0,128,191,0,0,0,0,46,27,93,189,0,0,0,0,214,168,7,59,0,0,0,0,0,0,128,191,0,0,0,0,29,230,27,190,0,0,0,0,92,1,197,189,0,0,0,0,0,0,128,191,0,0,0,0,2,12,235,61,0,0,0,0,202,21,94,188,0,0,0,0,0,0,128,191,0,0,0,0,148,189,101,61,0,0,0,0,112,235,14,62,0,0,0,0,0,0,128,191,0,0,0,0,2,12,235,61,0,0,0,0,202,21,94,188,0,0,0,0,0,0,128,191,0,0,0,0,224,156,1,62,0,0,0,0,161,161,127,62,0,0,0,0,0,0,128,191,0,0,0,0,53,42,96,190,0,0,0,0,207,78,18,63,0,0,0,0,0,0,128,191,0,0,0,0,46,27,93,189,0,0,0,0,214,168,7,59,0,0,0,0,0,0,128,191,0,0,0,0,198,21,151,189,0,0,0,0,245,189,22,62,0,0,0,0,0,0,128,191,0,0,0,0,198,21,151,189,0,0,0,0,245,189,22,62,0,0,0,0,0,0,128,191,0,0,0,0,148,189,101,61,0,0,0,0,112,235,14,62,0,0,0,0,0,0,128,191,0,0,0,0,224,156,1,62,0,0,0,0,161,161,127,62,0,0,0,0,0,0,128,191,0,0,0,0,53,42,96,190,0,0,0,0,207,78,18,63,0,0,0,0,0,0,128,191,0,0,0,0,198,21,151,189,0,0,0,0,245,189,22,62,0,0,0,0,0,0,128,191,0,0,0,0,133,67,175,189,0,0,0,0,226,115,119,62,0,0,0,0,0,0,128,191,0,0,0,0,133,67,175,189,0,0,0,0,226,115,119,62,0,0,0,0,0,0,128,191,0,0,0,0,198,21,151,189,0,0,0,0,245,189,22,62,0,0,0,0,0,0,128,191,0,0,0,0,224,156,1,62,0,0,0,0,161,161,127,62,0,0,0,0,0,0,128,191,0,0,0,0,53,42,96,190,0,0,0,0,207,78,18,63,0,0,0,0,0,0,128,191,0,0,0,0,133,67,175,189,0,0,0,0,226,115,119,62,0,0,0,0,0,0,128,191,0,0,0,0,189,112,231,189,0,0,0,0,212,95,19,63,0,0,0,0,0,0,128,191,0,0,0,0,29,230,27,190,106,78,190,61,92,1,197,189,0,0,0,0,0,0,128,63,0,0,0,0,2,12,235,61,106,78,190,61,202,21,94,188,0,0,0,0,0,0,128,63,0,0,0,0,103,41,129,62,106,78,190,61,148,46,221,189,0,0,0,0,0,0,128,63,0,0,0,0,2,12,235,61,106,78,190,61,202,21,94,188,0,0,0,0,0,0,128,63,0,0,0,0,224,156,1,62,106,78,190,61,161,161,127,62,0,0,0,0,0,0,128,63,0,0,0,0,103,41,129,62,106,78,190,61,148,46,221,189,0,0,0,0,0,0,128,63,0,0,0,0,53,42,96,190,106,78,190,61,207,78,18,63,0,0,0,0,0,0,128,63,0,0,0,0,46,27,93,189,106,78,190,61,214,168,7,59,0,0,0,0,0,0,128,63,0,0,0,0,29,230,27,190,106,78,190,61,92,1,197,189,0,0,0,0,0,0,128,63,0,0,0,0,46,27,93,189,106,78,190,61,214,168,7,59,0,0,0,0,0,0,128,63,0,0,0,0,2,12,235,61,106,78,190,61,202,21,94,188,0,0,0,0,0,0,128,63,0,0,0,0,29,230,27,190,106,78,190,61,92,1,197,189,0,0,0,0,0,0,128,63,0,0,0,0,148,189,101,61,106,78,190,61,112,235,14,62,0,0,0,0,0,0,128,63,0,0,0,0,224,156,1,62,106,78,190,61,161,161,127,62,0,0,0,0,0,0,128,63,0,0,0,0,2,12,235,61,106,78,190,61,202,21,94,188,0,0,0,0,0,0,128,63,0,0,0,0,53,42,96,190,106,78,190,61,207,78,18,63,0,0,0,0,0,0,128,63,0,0,0,0,198,21,151,189,106,78,190,61,245,189,22,62,0,0,0,0,0,0,128,63,0,0,0,0,46,27,93,189,106,78,190,61,214,168,7,59,0,0,0,0,0,0,128,63,0,0,0,0,198,21,151,189,106,78,190,61,245,189,22,62,0,0,0,0,0,0,128,63,0,0,0,0,224,156,1,62,106,78,190,61,161,161,127,62,0,0,0,0,0,0,128,63,0,0,0,0,148,189,101,61,106,78,190,61,112,235,14,62,0,0,0,0,0,0,128,63,0,0,0,0,53,42,96,190,106,78,190,61,207,78,18,63,0,0,0,0,0,0,128,63,0,0,0,0,133,67,175,189,106,78,190,61,226,115,119,62,0,0,0,0,0,0,128,63,0,0,0,0,198,21,151,189,106,78,190,61,245,189,22,62,0,0,0,0,0,0,128,63,0,0,0,0,133,67,175,189,106,78,190,61,226,115,119,62,0,0,0,0,0,0,128,63,0,0,0,0,224,156,1,62,106,78,190,61,161,161,127,62,0,0,0,0,0,0,128,63,0,0,0,0,198,21,151,189,106,78,190,61,245,189,22,62,0,0,0,0,0,0,128,63,0,0,0,0,53,42,96,190,106,78,190,61,207,78,18,63,0,0,0,0,0,0,128,63,0,0,0,0,189,112,231,189,106,78,190,61,212,95,19,63,0,0,0,0,0,0,128,63,0,0,0,0,133,67,175,189,106,78,190,61,226,115,119,62,0,0,0,0,0,0,128,63,0,0,0,0,189,112,231,189,0,0,0,0,212,95,19,63,32,36,127,63,0,0,0,0,90,158,167,61,133,67,175,189,0,0,0,0,226,115,119,62,32,36,127,63,0,0,0,0,90,158,167,61,133,67,175,189,106,78,190,61,226,115,119,62,32,36,127,63,0,0,0,0,90,158,167,61,189,112,231,189,0,0,0,0,212,95,19,63,32,36,127,63,0,0,0,0,90,158,167,61,133,67,175,189,106,78,190,61,226,115,119,62,32,36,127,63,0,0,0,0,90,158,167,61,189,112,231,189,106,78,190,61,212,95,19,63,32,36,127,63,0,0,0,0,90,158,167,61,224,156,1,62,0,0,0,0,161,161,127,62,144,132,113,63,0,0,0,0,17,196,169,62,103,41,129,62,0,0,0,0,148,46,221,189,144,132,113,63,0,0,0,0,17,196,169,62,103,41,129,62,106,78,190,61,148,46,221,189,144,132,113,63,0,0,0,0,17,196,169,62,224,156,1,62,0,0,0,0,161,161,127,62,144,132,113,63,0,0,0,0,17,196,169,62,103,41,129,62,106,78,190,61,148,46,221,189,144,132,113,63,0,0,0,0,17,196,169,62,224,156,1,62,106,78,190,61,161,161,127,62,144,132,113,63,0,0,0,0,17,196,169,62,103,41,129,62,0,0,0,0,148,46,221,189,30,250,238,188,0,0,0,0,21,228,127,191,29,230,27,190,0,0,0,0,92,1,197,189,30,250,238,188,0,0,0,0,21,228,127,191,29,230,27,190,106,78,190,61,92,1,197,189,30,250,238,188,0,0,0,0,21,228,127,191,103,41,129,62,0,0,0,0,148,46,221,189,30,250,238,188,0,0,0,0,21,228,127,191,29,230,27,190,106,78,190,61,92,1,197,189,30,250,238,188,0,0,0,0,21,228,127,191,103,41,129,62,106,78,190,61,148,46,221,189,30,250,238,188,0,0,0,0,21,228,127,191,133,67,175,189,0,0,0,0,226,115,119,62,73,20,26,189,0,0,0,0,154,209,127,63,224,156,1,62,0,0,0,0,161,161,127,62,73,20,26,189,0,0,0,0,154,209,127,63,224,156,1,62,106,78,190,61,161,161,127,62,73,20,26,189,0,0,0,0,154,209,127,63,133,67,175,189,0,0,0,0,226,115,119,62,73,20,26,189,0,0,0,0,154,209,127,63,224,156,1,62,106,78,190,61,161,161,127,62,73,20,26,189,0,0,0,0,154,209,127,63,133,67,175,189,106,78,190,61,226,115,119,62,73,20,26,189,0,0,0,0,154,209,127,63,2,12,235,61,106,78,190,61,202,21,94,188,78,210,188,61,0,0,0,0,226,232,126,63,46,27,93,189,106,78,190,61,214,168,7,59,78,210,188,61,0,0,0,0,226,232,126,63,46,27,93,189,0,0,0,0,214,168,7,59,78,210,188,61,0,0,0,0,226,232,126,63,2,12,235,61,106,78,190,61,202,21,94,188,78,210,188,61,0,0,0,0,226,232,126,63,46,27,93,189,0,0,0,0,214,168,7,59,78,210,188,61,0,0,0,0,226,232,126,63,2,12,235,61,0,0,0,0,202,21,94,188,78,210,188,61,0,0,0,0,226,232,126,63,2,12,235,61,0,0,0,0,202,21,94,188,86,12,111,191,0,0,0,0,84,55,183,190,148,189,101,61,0,0,0,0,112,235,14,62,86,12,111,191,0,0,0,0,84,55,183,190,148,189,101,61,106,78,190,61,112,235,14,62,86,12,111,191,0,0,0,0,84,55,183,190,2,12,235,61,0,0,0,0,202,21,94,188,86,12,111,191,0,0,0,0,84,55,183,190,148,189,101,61,106,78,190,61,112,235,14,62,86,12,111,191,0,0,0,0,84,55,183,190,2,12,235,61,106,78,190,61,202,21,94,188,86,12,111,191,0,0,0,0,84,55,183,190,148,189,101,61,0,0,0,0,112,235,14,62,123,134,112,189,0,0,0,0,227,142,127,191,198,21,151,189,0,0,0,0,245,189,22,62,123,134,112,189,0,0,0,0,227,142,127,191,198,21,151,189,106,78,190,61,245,189,22,62,123,134,112,189,0,0,0,0,227,142,127,191,148,189,101,61,0,0,0,0,112,235,14,62,123,134,112,189,0,0,0,0,227,142,127,191,198,21,151,189,106,78,190,61,245,189,22,62,123,134,112,189,0,0,0,0,227,142,127,191,148,189,101,61,106,78,190,61,112,235,14,62,123,134,112,189,0,0,0,0,227,142,127,191,198,21,151,189,0,0,0,0,245,189,22,62,9,167,125,63,0,0,0,0,16,91,10,62,46,27,93,189,0,0,0,0,214,168,7,59,9,167,125,63,0,0,0,0,16,91,10,62,46,27,93,189,106,78,190,61,214,168,7,59,9,167,125,63,0,0,0,0,16,91,10,62,198,21,151,189,0,0,0,0,245,189,22,62,9,167,125,63,0,0,0,0,16,91,10,62,46,27,93,189,106,78,190,61,214,168,7,59,9,167,125,63,0,0,0,0,16,91,10,62,198,21,151,189,106,78,190,61,245,189,22,62,9,167,125,63,0,0,0,0,16,91,10,62,53,42,96,190,0,0,0,0,207,78,18,63,184,7,33,189,0,0,0,0,87,205,127,63,189,112,231,189,0,0,0,0,212,95,19,63,184,7,33,189,0,0,0,0,87,205,127,63,189,112,231,189,106,78,190,61,212,95,19,63,184,7,33,189,0,0,0,0,87,205,127,63,53,42,96,190,0,0,0,0,207,78,18,63,184,7,33,189,0,0,0,0,87,205,127,63,189,112,231,189,106,78,190,61,212,95,19,63,184,7,33,189,0,0,0,0,87,205,127,63,53,42,96,190,106,78,190,61,207,78,18,63,184,7,33,189,0,0,0,0,87,205,127,63,29,230,27,190,0,0,0,0,92,1,197,189,203,187,126,191,0,0,0,0,3,120,203,189,53,42,96,190,0,0,0,0,207,78,18,63,203,187,126,191,0,0,0,0,3,120,203,189,53,42,96,190,106,78,190,61,207,78,18,63,203,187,126,191,0,0,0,0,3,120,203,189,29,230,27,190,0,0,0,0,92,1,197,189,203,187,126,191,0,0,0,0,3,120,203,189,53,42,96,190,106,78,190,61])
.concat([207,78,18,63,203,187,126,191,0,0,0,0,3,120,203,189,29,230,27,190,106,78,190,61,92,1,197,189,203,187,126,191,0,0,0,0,3,120,203,189,79,31,161,61,0,0,0,0,82,97,108,189,0,0,0,0,0,0,128,191,0,0,0,0,185,166,64,189,0,0,0,0,66,234,246,189,0,0,0,0,0,0,128,191,0,0,0,0,209,32,53,62,0,0,0,0,237,210,230,189,0,0,0,0,0,0,128,191,0,0,0,0,79,31,161,61,0,0,0,0,82,97,108,189,0,0,0,0,0,0,128,191,0,0,0,0,209,32,53,62,0,0,0,0,237,210,230,189,0,0,0,0,0,0,128,191,0,0,0,0,133,38,57,62,0,0,0,0,5,137,109,188,0,0,0,0,0,0,128,191,0,0,0,0,9,136,233,61,0,0,0,0,5,137,109,188,0,0,0,0,0,0,128,191,0,0,0,0,79,31,161,61,0,0,0,0,82,97,108,189,0,0,0,0,0,0,128,191,0,0,0,0,133,38,57,62,0,0,0,0,5,137,109,188,0,0,0,0,0,0,128,191,0,0,0,0,41,176,160,189,0,0,0,0,213,91,131,62,0,0,0,0,0,0,128,191,0,0,0,0,178,156,132,59,0,0,0,0,53,127,12,189,0,0,0,0,0,0,128,191,0,0,0,0,81,76,222,56,0,0,0,0,76,166,122,62,0,0,0,0,0,0,128,191,0,0,0,0,41,176,160,189,0,0,0,0,213,91,131,62,0,0,0,0,0,0,128,191,0,0,0,0,185,166,64,189,0,0,0,0,66,234,246,189,0,0,0,0,0,0,128,191,0,0,0,0,178,156,132,59,0,0,0,0,53,127,12,189,0,0,0,0,0,0,128,191,0,0,0,0,178,156,132,59,0,0,0,0,53,127,12,189,0,0,0,0,0,0,128,191,0,0,0,0,185,166,64,189,0,0,0,0,66,234,246,189,0,0,0,0,0,0,128,191,0,0,0,0,79,31,161,61,0,0,0,0,82,97,108,189,0,0,0,0,0,0,128,191,0,0,0,0,79,31,161,61,172,227,184,61,82,97,108,189,0,0,0,0,0,0,128,63,0,0,0,0,209,32,53,62,172,227,184,61,237,210,230,189,0,0,0,0,0,0,128,63,0,0,0,0,185,166,64,189,172,227,184,61,66,234,246,189,0,0,0,0,0,0,128,63,0,0,0,0,79,31,161,61,172,227,184,61,82,97,108,189,0,0,0,0,0,0,128,63,0,0,0,0,133,38,57,62,172,227,184,61,5,137,109,188,0,0,0,0,0,0,128,63,0,0,0,0,209,32,53,62,172,227,184,61,237,210,230,189,0,0,0,0,0,0,128,63,0,0,0,0,9,136,233,61,172,227,184,61,5,137,109,188,0,0,0,0,0,0,128,63,0,0,0,0,133,38,57,62,172,227,184,61,5,137,109,188,0,0,0,0,0,0,128,63,0,0,0,0,79,31,161,61,172,227,184,61,82,97,108,189,0,0,0,0,0,0,128,63,0,0,0,0,41,176,160,189,172,227,184,61,213,91,131,62,0,0,0,0,0,0,128,63,0,0,0,0,81,76,222,56,172,227,184,61,76,166,122,62,0,0,0,0,0,0,128,63,0,0,0,0,178,156,132,59,172,227,184,61,53,127,12,189,0,0,0,0,0,0,128,63,0,0,0,0,41,176,160,189,172,227,184,61,213,91,131,62,0,0,0,0,0,0,128,63,0,0,0,0,178,156,132,59,172,227,184,61,53,127,12,189,0,0,0,0,0,0,128,63,0,0,0,0,185,166,64,189,172,227,184,61,66,234,246,189,0,0,0,0,0,0,128,63,0,0,0,0,178,156,132,59,172,227,184,61,53,127,12,189,0,0,0,0,0,0,128,63,0,0,0,0,79,31,161,61,172,227,184,61,82,97,108,189,0,0,0,0,0,0,128,63,0,0,0,0,185,166,64,189,172,227,184,61,66,234,246,189,0,0,0,0,0,0,128,63,0,0,0,0,209,32,53,62,0,0,0,0,237,210,230,189,94,161,15,61,0,0,0,0,178,215,127,191,185,166,64,189,0,0,0,0,66,234,246,189,94,161,15,61,0,0,0,0,178,215,127,191,185,166,64,189,172,227,184,61,66,234,246,189,94,161,15,61,0,0,0,0,178,215,127,191,209,32,53,62,0,0,0,0,237,210,230,189,94,161,15,61,0,0,0,0,178,215,127,191,185,166,64,189,172,227,184,61,66,234,246,189,94,161,15,61,0,0,0,0,178,215,127,191,209,32,53,62,172,227,184,61,237,210,230,189,94,161,15,61,0,0,0,0,178,215,127,191,9,136,233,61,0,0,0,0,5,137,109,188,0,0,0,0,0,0,0,0,0,0,128,63,133,38,57,62,0,0,0,0,5,137,109,188,0,0,0,0,0,0,0,0,0,0,128,63,133,38,57,62,172,227,184,61,5,137,109,188,0,0,0,0,0,0,0,0,0,0,128,63,9,136,233,61,0,0,0,0,5,137,109,188,0,0,0,0,0,0,0,0,0,0,128,63,133,38,57,62,172,227,184,61,5,137,109,188,0,0,0,0,0,0,0,0,0,0,128,63,9,136,233,61,172,227,184,61,5,137,109,188,0,0,0,0,0,0,0,0,0,0,128,63,178,156,132,59,0,0,0,0,53,127,12,189,0,0,0,0,0,0,0,0,0,0,0,0,178,156,132,59,0,0,0,0,53,127,12,189,0,0,0,0,0,0,0,0,0,0,0,0,178,156,132,59,172,227,184,61,53,127,12,189,0,0,0,0,0,0,0,0,0,0,0,0,178,156,132,59,0,0,0,0,53,127,12,189,0,0,0,0,0,0,0,0,0,0,0,0,178,156,132,59,172,227,184,61,53,127,12,189,0,0,0,0,0,0,0,0,0,0,0,0,178,156,132,59,172,227,184,61,53,127,12,189,0,0,0,0,0,0,0,0,0,0,0,0,81,76,222,56,0,0,0,0,76,166,122,62,114,249,127,63,0,0,0,0,97,83,103,60,178,156,132,59,0,0,0,0,53,127,12,189,114,249,127,63,0,0,0,0,97,83,103,60,178,156,132,59,172,227,184,61,53,127,12,189,114,249,127,63,0,0,0,0,97,83,103,60,81,76,222,56,0,0,0,0,76,166,122,62,114,249,127,63,0,0,0,0,97,83,103,60,178,156,132,59,172,227,184,61,53,127,12,189,114,249,127,63,0,0,0,0,97,83,103,60,81,76,222,56,172,227,184,61,76,166,122,62,114,249,127,63,0,0,0,0,97,83,103,60,185,166,64,189,0,0,0,0,66,234,246,189,163,29,127,191,0,0,0,0,5,20,170,189,41,176,160,189,0,0,0,0,213,91,131,62,163,29,127,191,0,0,0,0,5,20,170,189,41,176,160,189,172,227,184,61,213,91,131,62,163,29,127,191,0,0,0,0,5,20,170,189,185,166,64,189,0,0,0,0,66,234,246,189,163,29,127,191,0,0,0,0,5,20,170,189,41,176,160,189,172,227,184,61,213,91,131,62,163,29,127,191,0,0,0,0,5,20,170,189,185,166,64,189,172,227,184,61,66,234,246,189,163,29,127,191,0,0,0,0,5,20,170,189,133,38,57,62,0,0,0,0,5,137,109,188,163,203,127,63,0,0,0,0,137,182,35,189,209,32,53,62,0,0,0,0,237,210,230,189,163,203,127,63,0,0,0,0,137,182,35,189,209,32,53,62,172,227,184,61,237,210,230,189,163,203,127,63,0,0,0,0,137,182,35,189,133,38,57,62,0,0,0,0,5,137,109,188,163,203,127,63,0,0,0,0,137,182,35,189,209,32,53,62,172,227,184,61,237,210,230,189,163,203,127,63,0,0,0,0,137,182,35,189,133,38,57,62,172,227,184,61,5,137,109,188,163,203,127,63,0,0,0,0,137,182,35,189,79,31,161,61,0,0,0,0,82,97,108,189,29,34,70,191,0,0,0,0,210,27,34,63,9,136,233,61,0,0,0,0,5,137,109,188,29,34,70,191,0,0,0,0,210,27,34,63,9,136,233,61,172,227,184,61,5,137,109,188,29,34,70,191,0,0,0,0,210,27,34,63,79,31,161,61,0,0,0,0,82,97,108,189,29,34,70,191,0,0,0,0,210,27,34,63,9,136,233,61,172,227,184,61,5,137,109,188,29,34,70,191,0,0,0,0,210,27,34,63,79,31,161,61,172,227,184,61,82,97,108,189,29,34,70,191,0,0,0,0,210,27,34,63,41,176,160,189,0,0,0,0,213,91,131,62,113,230,23,62,0,0,0,0,233,42,125,63,81,76,222,56,0,0,0,0,76,166,122,62,113,230,23,62,0,0,0,0,233,42,125,63,81,76,222,56,172,227,184,61,76,166,122,62,113,230,23,62,0,0,0,0,233,42,125,63,41,176,160,189,0,0,0,0,213,91,131,62,113,230,23,62,0,0,0,0,233,42,125,63,81,76,222,56,172,227,184,61,76,166,122,62,113,230,23,62,0,0,0,0,233,42,125,63,41,176,160,189,172,227,184,61,213,91,131,62,113,230,23,62,0,0,0,0,233,42,125,63,178,156,132,59,0,0,0,0,53,127,12,189,217,61,153,62,0,0,0,0,196,67,116,63,79,31,161,61,0,0,0,0,82,97,108,189,217,61,153,62,0,0,0,0,196,67,116,63,79,31,161,61,172,227,184,61,82,97,108,189,217,61,153,62,0,0,0,0,196,67,116,63,178,156,132,59,0,0,0,0,53,127,12,189,217,61,153,62,0,0,0,0,196,67,116,63,79,31,161,61,172,227,184,61,82,97,108,189,217,61,153,62,0,0,0,0,196,67,116,63,178,156,132,59,172,227,184,61,53,127,12,189,217,61,153,62,0,0,0,0,196,67,116,63,210,141,176,188,0,0,0,0,8,119,159,190,0,0,0,0,0,0,128,191,0,0,0,0,106,160,121,61,0,0,0,0,187,124,163,190,0,0,0,0,0,0,128,191,0,0,0,0,123,21,25,61,0,0,0,0,42,84,135,190,0,0,0,0,0,0,128,191,0,0,0,0,136,189,208,188,0,0,0,0,123,75,129,190,0,0,0,0,0,0,128,191,0,0,0,0,210,141,176,188,0,0,0,0,8,119,159,190,0,0,0,0,0,0,128,191,0,0,0,0,123,21,25,61,0,0,0,0,42,84,135,190,0,0,0,0,0,0,128,191,0,0,0,0,218,57,237,189,0,0,0,0,127,46,58,190,0,0,0,0,0,0,128,191,0,0,0,0,201,255,196,189,0,0,0,0,38,87,137,190,0,0,0,0,0,0,128,191,0,0,0,0,136,189,208,188,0,0,0,0,123,75,129,190,0,0,0,0,0,0,128,191,0,0,0,0,136,189,208,188,0,0,0,0,123,75,129,190,0,0,0,0,0,0,128,191,0,0,0,0,123,21,25,61,0,0,0,0,42,84,135,190,0,0,0,0,0,0,128,191,0,0,0,0,18,103,229,61,0,0,0,0,42,84,135,190,0,0,0,0,0,0,128,191,0,0,0,0,136,189,208,188,0,0,0,0,123,75,129,190,0,0,0,0,0,0,128,191,0,0,0,0,18,103,229,61,0,0,0,0,42,84,135,190,0,0,0,0,0,0,128,191,0,0,0,0,37,91,221,61,0,0,0,0,110,23,42,190,0,0,0,0,0,0,128,191,0,0,0,0,218,57,237,189,0,0,0,0,127,46,58,190,0,0,0,0,0,0,128,191,0,0,0,0,136,189,208,188,0,0,0,0,123,75,129,190,0,0,0,0,0,0,128,191,0,0,0,0,180,233,72,189,0,0,0,0,42,58,66,190,0,0,0,0,0,0,128,191,0,0,0,0,180,233,72,189,0,0,0,0,42,58,66,190,0,0,0,0,0,0,128,191,0,0,0,0,136,189,208,188,0,0,0,0,123,75,129,190,0,0,0,0,0,0,128,191,0,0,0,0,37,91,221,61,0,0,0,0,110,23,42,190,0,0,0,0,0,0,128,191,0,0,0,0,14,221,172,189,0,0,0,0,64,51,136,62,0,0,0,0,0,0,128,191,0,0,0,0,180,233,72,189,0,0,0,0,42,58,66,190,0,0,0,0,0,0,128,191,0,0,0,0,193,202,33,60,0,0,0,0,204,40,54,190,0,0,0,0,0,0,128,191,0,0,0,0,193,202,33,60,0,0,0,0,204,40,54,190,0,0,0,0,0,0,128,191,0,0,0,0,180,233,72,189,0,0,0,0,42,58,66,190,0,0,0,0,0,0,128,191,0,0,0,0,37,91,221,61,0,0,0,0,110,23,42,190,0,0,0,0,0,0,128,191,0,0,0,0,14,221,172,189,0,0,0,0,64,51,136,62,0,0,0,0,0,0,128,191,0,0,0,0,193,202,33,60,0,0,0,0,204,40,54,190,0,0,0,0,0,0,128,191,0,0,0,0,254,96,96,188,0,0,0,0,171,236,59,62,0,0,0,0,0,0,128,191,0,0,0,0,123,21,25,61,0,0,0,0,161,242,63,62,0,0,0,0,0,0,128,191,0,0,0,0,105,56,197,61,0,0,0,0,154,178,19,62,0,0,0,0,0,0,128,191,0,0,0,0,163,231,22,62,0,0,0,0,9,254,71,62,0,0,0,0,0,0,128,191,0,0,0,0,14,221,172,189,0,0,0,0,64,51,136,62,0,0,0,0,0,0,128,191,0,0,0,0,254,96,96,188,0,0,0,0,171,236,59,62,0,0,0,0,0,0,128,191,0,0,0,0,123,21,25,61,0,0,0,0,161,242,63,62,0,0,0,0,0,0,128,191,0,0,0,0,14,221,172,189,0,0,0,0,64,51,136,62,0,0,0,0,0,0,128,191,0,0,0,0,123,21,25,61,0,0,0,0,161,242,63,62,0,0,0,0,0,0,128,191,0,0,0,0,163,231,22,62,0,0,0,0,9,254,71,62,0,0,0,0,0,0,128,191,0,0,0,0,14,221,172,189,0,0,0,0,64,51,136,62,0,0,0,0,0,0,128,191,0,0,0,0,163,231,22,62,0,0,0,0,9,254,71,62,0,0,0,0,0,0,128,191,0,0,0,0,138,231,140,61,0,0,0,0,26,54,138,62,0,0,0,0,0,0,128,191,0,0,0,0,210,141,176,188,109,56,204,61,8,119,159,190,0,0,0,0,0,0,128,63,0,0,0,0,123,21,25,61,109,56,204,61,42,84,135,190,0,0,0,0,0,0,128,63,0,0,0,0,106,160,121,61,109,56,204,61,187,124,163,190,0,0,0,0,0,0,128,63,0,0,0,0,136,189,208,188,109,56,204,61,123,75,129,190,0,0,0,0,0,0,128,63,0,0,0,0,123,21,25,61,109,56,204,61,42,84,135,190,0,0,0,0,0,0,128,63,0,0,0,0,210,141,176,188,109,56,204,61,8,119,159,190,0,0,0,0,0,0,128,63,0,0,0,0,218,57,237,189,109,56,204,61,127,46,58,190,0,0,0,0,0,0,128,63,0,0,0,0,136,189,208,188,109,56,204,61,123,75,129,190,0,0,0,0,0,0,128,63,0,0,0,0,201,255,196,189,109,56,204,61,38,87,137,190,0,0,0,0,0,0,128,63,0,0,0,0,136,189,208,188,109,56,204,61,123,75,129,190,0,0,0,0,0,0,128,63,0,0,0,0,18,103,229,61,109,56,204,61,42,84,135,190,0,0,0,0,0,0,128,63,0,0,0,0,123,21,25,61,109,56,204,61,42,84,135,190,0,0,0,0,0,0,128,63,0,0,0,0,136,189,208,188,109,56,204,61,123,75,129,190,0,0,0,0,0,0,128,63,0,0,0,0,37,91,221,61,109,56,204,61,110,23,42,190,0,0,0,0,0,0,128,63,0,0,0,0,18,103,229,61,109,56,204,61,42,84,135,190,0,0,0,0,0,0,128,63,0,0,0,0,218,57,237,189,109,56,204,61,127,46,58,190,0,0,0,0,0,0,128,63,0,0,0,0,180,233,72,189,109,56,204,61,42,58,66,190,0,0,0,0,0,0,128,63,0,0,0,0,136,189,208,188,109,56,204,61,123,75,129,190,0,0,0,0,0,0,128,63,0,0,0,0,180,233,72,189,109,56,204,61,42,58,66,190,0,0,0,0,0,0,128,63,0,0,0,0,37,91,221,61,109,56,204,61,110,23,42,190,0,0,0,0,0,0,128,63,0,0,0,0,136,189,208,188,109,56,204,61,123,75,129,190,0,0,0,0,0,0,128,63,0,0,0,0,14,221,172,189,109,56,204,61,64,51,136,62,0,0,0,0,0,0,128,63,0,0,0,0,193,202,33,60,109,56,204,61,204,40,54,190,0,0,0,0,0,0,128,63,0,0,0,0,180,233,72,189,109,56,204,61,42,58,66,190,0,0,0,0,0,0,128,63,0,0,0,0,193,202,33,60,109,56,204,61,204,40,54,190,0,0,0,0,0,0,128,63,0,0,0,0,37,91,221,61,109,56,204,61,110,23,42,190,0,0,0,0,0,0,128,63,0,0,0,0,180,233,72,189,109,56,204,61,42,58,66,190,0,0,0,0,0,0,128,63,0,0,0,0,14,221,172,189,109,56,204,61,64,51,136,62,0,0,0,0,0,0,128,63,0,0,0,0,254,96,96,188,109,56,204,61,171,236,59,62,0,0,0,0,0,0,128,63,0,0,0,0,193,202,33,60,109,56,204,61,204,40,54,190,0,0,0,0,0,0,128,63,0,0,0,0,123,21,25,61,109,56,204,61,161,242,63,62,0,0,0,0,0,0,128,63,0,0,0,0,163,231,22,62,109,56,204,61,9,254,71,62,0,0,0,0,0,0,128,63,0,0,0,0,105,56,197,61,109,56,204,61,154,178,19,62,0,0,0,0,0,0,128,63,0,0,0,0,14,221,172,189,109,56,204,61,64,51,136,62,0,0,0,0,0,0,128,63,0,0,0,0,123,21,25,61,109,56,204,61,161,242,63,62,0,0,0,0,0,0,128,63,0,0,0,0,254,96,96,188,109,56,204,61,171,236,59,62,0,0,0,0,0,0,128,63,0,0,0,0,14,221,172,189,109,56,204,61,64,51,136,62,0,0,0,0,0,0,128,63,0,0,0,0,163,231,22,62,109,56,204,61,9,254,71,62,0,0,0,0,0,0,128,63,0,0,0,0,123,21,25,61,109,56,204,61,161,242,63,62,0,0,0,0,0,0,128,63,0,0,0,0,14,221,172,189,109,56,204,61,64,51,136,62,0,0,0,0,0,0,128,63,0,0,0,0,138,231,140,61,109,56,204,61,26,54,138,62,0,0,0,0,0,0,128,63,0,0,0,0,163,231,22,62,109,56,204,61,9,254,71,62,0,0,0,0,0,0,128,63,0,0,0,0,123,21,25,61,0,0,0,0,161,242,63,62,94,20,157,61,0,0,0,0,238,62,127,191,254,96,96,188,0,0,0,0,171,236,59,62,94,20,157,61,0,0,0,0,238,62,127,191,254,96,96,188,109,56,204,61,171,236,59,62,94,20,157,61,0,0,0,0,238,62,127,191,123,21,25,61,0,0,0,0,161,242,63,62,94,20,157,61,0,0,0,0,238,62,127,191,254,96,96,188,109,56,204,61,171,236,59,62,94,20,157,61,0,0,0,0,238,62,127,191,123,21,25,61,109,56,204,61,161,242,63,62,94,20,157,61,0,0,0,0,238,62,127,191,123,21,25,61,0,0,0,0,42,84,135,190,22,77,107,63,0,0,0,0,192,175,201,62,106,160,121,61,0,0,0,0,187,124,163,190,22,77,107,63,0,0,0,0,192,175,201,62,106,160,121,61,109,56,204,61,187,124,163,190,22,77,107,63,0,0,0,0,192,175,201,62,123,21,25,61,0,0,0,0,42,84,135,190,22,77,107,63,0,0,0,0,192,175,201,62,106,160,121,61,109,56,204,61,187,124,163,190,22,77,107,63,0,0,0,0,192,175,201,62,123,21,25,61,109,56,204,61,42,84,135,190,22,77,107,63,0,0,0,0,192,175,201,62,254,96,96,188,0,0,0,0,171,236,59,62,16,117,127,63,0,0,0,0,36,72,133,61,193,202,33,60,0,0,0,0,204,40,54,190,16,117,127,63,0,0,0,0,36,72,133,61,193,202,33,60,109,56,204,61,204,40,54,190,16,117,127,63,0,0,0,0,36,72,133,61,254,96,96,188,0,0,0,0,171,236,59,62,16,117,127,63,0,0,0,0,36,72,133,61,193,202,33,60,109,56,204,61,204,40,54,190,16,117,127,63,0,0,0,0,36,72,133,61,254,96,96,188,109,56,204,61,171,236,59,62,16,117,127,63,0,0,0,0,36,72,133,61,18,103,229,61,0,0,0,0,42,84,135,190,0,0,0,0,0,0,0,0,0,0,128,191,123,21,25,61,0,0,0,0,42,84,135,190,0,0,0,0,0,0,0,0,0,0,128,191,123,21,25,61,109,56,204,61,42,84,135,190,0,0,0,0,0,0,0,0,0,0,128,191,18,103,229,61,0,0,0,0,42,84,135,190,0,0,0,0,0,0,0,0,0,0,128,191,123,21,25,61,109,56,204,61,42,84,135,190,0,0,0,0,0,0,0,0,0,0,128,191,18,103,229,61,109,56,204,61,42,84,135,190,0,0,0,0,0,0,0,0,0,0,128,191,218,57,237,189,0,0,0,0,127,46,58,190,220,74,239,61,0,0,0,0,37,63,126,63,180,233,72,189,0,0,0,0,42,58,66,190,220,74,239,61,0,0,0,0,37,63,126,63,180,233,72,189,109,56,204,61,42,58,66,190,220,74,239,61,0,0,0,0,37,63,126,63,218,57,237,189,0,0,0,0,127,46,58,190,220,74,239,61,0,0,0,0,37,63,126,63,180,233,72,189,109,56,204,61,42,58,66,190,220,74,239,61,0,0,0,0,37,63,126,63,218,57,237,189,109,56,204,61,127,46,58,190,220,74,239,61,0,0,0,0,37,63,126,63,105,56,197,61,0,0,0,0,154,178,19,62,162,99,23,191,0,0,0,0,143,112,78,191,123,21,25,61,0,0,0,0,161,242,63,62,162,99,23,191,0,0,0,0,143,112,78,191,123,21,25,61,109,56,204,61,161,242,63,62,162,99,23,191,0,0,0,0,143,112,78,191,105,56,197,61,0,0,0,0,154,178,19,62,162,99,23,191,0,0,0,0,143,112,78,191,123,21,25,61,109,56,204,61,161,242,63,62,162,99,23,191,0,0,0,0,143,112,78,191,105,56,197,61,109,56,204,61,154,178,19,62,162,99,23,191,0,0,0,0,143,112,78,191,180,233,72,189,0,0,0,0,42,58,66,190,167,59,127,191,0,0,0,0,64,107,158,189,14,221,172,189,0,0,0,0,64,51,136,62,167,59,127,191,0,0,0,0,64,107,158,189,14,221,172,189,109,56,204,61,64,51,136,62,167,59,127,191,0,0,0,0,64,107,158,189,180,233,72,189,0,0,0,0,42,58,66,190,167,59,127,191,0,0,0,0,64,107,158,189,14,221,172,189,109,56,204,61,64,51,136,62,167,59,127,191,0,0,0,0,64,107,158,189,180,233,72,189,109,56,204,61,42,58,66,190,167,59,127,191,0,0,0,0,64,107,158,189,163,231,22,62,0,0,0,0,9,254,71,62,247,4,53,63,0,0,0,0,247,4,53,191,105,56,197,61,0,0,0,0,154,178,19,62,247,4,53,63,0,0,0,0,247,4,53,191,105,56,197,61,109,56,204,61,154,178,19,62,247,4,53,63,0,0,0,0,247,4,53,191,163,231,22,62,0,0,0,0,9,254,71,62,247,4,53,63,0,0,0,0,247,4,53,191,105,56,197,61,109,56,204,61,154,178,19,62,247,4,53,63,0,0,0,0,247,4,53,191,163,231,22,62,109,56,204,61,9,254,71,62,247,4,53,63,0,0,0,0,247,4,53,191,210,141,176,188,0,0,0,0,8,119,159,190,214,110,127,191,0,0,0,0,163,59,136,189,136,189,208,188,0,0,0,0,123,75,129,190,214,110,127,191,0,0,0,0,163,59,136,189,136,189,208,188,109,56,204,61,123,75,129,190,214,110,127,191,0,0,0,0,163,59,136,189,210,141,176,188,0,0,0,0,8,119,159,190,214,110,127,191,0,0,0,0,163,59,136,189,136,189,208,188,109,56,204,61,123,75,129,190,214,110,127,191,0,0,0,0,163,59,136,189,210,141,176,188,109,56,204,61,8,119,159,190,214,110,127,191,0,0,0,0,163,59,136,189,106,160,121,61,0,0,0,0,187,124,163,190,191,43,194,189,0,0,0,0,195,216,126,191,210,141,176,188,0,0,0,0,8,119,159,190,191,43,194,189,0,0,0,0,195,216,126,191,210,141,176,188,109,56,204,61,8,119,159,190,191,43,194,189,0,0,0,0,195,216,126,191,106,160,121,61,0,0,0,0,187,124,163,190,191,43,194,189,0,0,0,0,195,216,126,191,210,141,176,188,109,56,204,61,8,119,159,190,191,43,194,189,0,0,0,0,195,216,126,191,106,160,121,61,109,56,204,61,187,124,163,190,191,43,194,189,0,0,0,0,195,216,126,191,193,202,33,60,0,0,0,0,204,40,54,190,75,2,244,189,0,0,0,0,48,45,126,63,37,91,221,61,0,0,0,0,110,23,42,190,75,2,244,189,0,0,0,0,48,45,126,63,37,91,221,61,109,56,204,61,110,23,42,190,75,2,244,189,0,0,0,0,48,45,126,63,193,202,33,60,0,0,0,0,204,40,54,190,75,2,244,189,0,0,0,0,48,45,126,63,37,91,221,61,109,56,204,61,110,23,42,190,75,2,244,189,0,0,0,0,48,45,126,63,193,202,33,60,109,56,204,61,204,40,54,190,75,2,244,189,0,0,0,0,48,45,126,63,14,221,172,189,0,0,0,0,64,51,136,62,76,252,209,188,0,0,0,0,112,234,127,63,138,231,140,61,0,0,0,0,26,54,138,62,76,252,209,188,0,0,0,0,112,234,127,63,138,231,140,61,109,56,204,61,26,54,138,62,76,252,209,188,0,0,0,0,112,234,127,63,14,221,172,189,0,0,0,0,64,51,136,62,76,252,209,188,0,0,0,0,112,234,127,63,138,231,140,61,109,56,204,61,26,54,138,62,76,252,209,188,0,0,0,0,112,234,127,63,14,221,172,189,109,56,204,61,64,51,136,62,76,252,209,188,0,0,0,0,112,234,127,63,37,91,221,61,0,0,0,0,110,23,42,190,163,203,127,63,0,0,0,0,137,182,35,61,18,103,229,61,0,0,0,0,42,84,135,190,163,203,127,63,0,0,0,0,137,182,35,61,18,103,229,61,109,56,204,61,42,84,135,190,163,203,127,63,0,0,0,0,137,182,35,61,37,91,221,61,0,0,0,0,110,23,42,190,163,203,127,63,0,0,0,0,137,182,35,61,18,103,229,61,109,56,204,61,42,84,135,190,163,203,127,63,0,0,0,0,137,182,35,61,37,91,221,61,109,56,204,61,110,23,42,190,163,203,127,63,0,0,0,0,137,182,35,61,136,189,208,188,0,0,0,0,123,75,129,190,108,35,94,62,0,0,0,0,100,231,121,191,201,255,196,189,0,0,0,0,38,87,137,190,108,35,94,62,0,0,0,0,100,231,121,191,201,255,196,189,109,56,204,61,38,87,137,190,108,35,94,62,0,0,0,0,100,231,121,191,136,189,208,188,0,0,0,0,123,75,129,190,108,35,94,62,0,0,0,0,100,231,121,191,201,255,196,189,109,56,204,61,38,87,137,190,108,35,94,62,0,0,0,0,100,231,121,191,136,189,208,188,109,56,204,61,123,75,129,190,108,35,94,62,0,0,0,0,100,231,121,191,201,255,196,189,0,0,0,0,38,87,137,190,81,162,121,191,0,0,0,0,158,240,98,190,218,57,237,189,0,0,0,0,127,46,58,190,81,162,121,191,0,0,0,0,158,240,98,190,218,57,237,189,109,56,204,61,127,46,58,190,81,162,121,191,0,0,0,0,158,240,98,190,201,255,196,189,0,0,0,0,38,87,137,190,81,162,121,191,0,0,0,0,158,240,98,190,218,57,237,189,109,56,204,61,127,46,58,190,81,162,121,191,0,0,0,0,158,240,98,190,201,255,196,189,109,56,204,61,38,87,137,190,81,162,121,191,0,0,0,0,158,240,98,190,138,231,140,61,0,0,0,0,26,54,138,62,236,81,48,63,0,0,0,0,137,153,57,63,163,231,22,62,0,0,0,0,9,254,71,62,236,81,48,63,0,0,0,0,137,153,57,63,163,231,22,62,109,56,204,61,9,254,71,62,236,81,48,63,0,0,0,0,137,153,57,63,138,231,140,61,0,0,0,0,26,54,138,62,236,81,48,63,0,0,0,0,137,153,57,63,163,231,22,62,109,56,204,61,9,254,71,62,236,81,48,63,0,0,0,0,137,153,57,63,138,231,140,61,109,56,204,61,26,54,138,62,236,81,48,63,0,0,0,0,137,153,57,63,174,101,194,190,205,175,230,56,101,110,190,190,0,0,0,0,0,0,128,191,0,0,0,0,98,72,182,190,205,175,230,56,14,76,46,191,0,0,0,0,0,0,128,191,0,0,0,0,166,213,144,186,205,175,230,56,247,120,193,190,0,0,0,0,0,0,128,191,0,0,0,0,166,213,144,186,205,175,230,56,247,120,193,190,0,0,0,0,0,0,128,191,0,0,0,0,177,194,109,61,205,175,230,56,66,204,9,191,0,0,0,0,0,0,128,191,0,0,0,0,197,199,247,62,205,175,230,56,201,145,238,189,0,0,0,0,0,0,128,191,0,0,0,0,174,101,194,190,205,175,230,56,101,110,190,190,0,0,0,0,0,0,128,191,0,0,0,0,166,213,144,186,205,175,230,56,247,120,193,190,0,0,0,0,0,0,128,191,0,0,0,0,197,199,247,62,205,175,230,56,201,145,238,189,0,0,0,0,0,0,128,191,0,0,0,0,58,5,73,190,205,175,230,56,73,243,39,190,0,0,0,0,0,0,128,191,0,0,0,0,174,101,194,190,205,175,230,56,101,110,190,190,0,0,0,0,0,0,128,191,0,0,0,0,197,199,247,62,205,175,230,56,201,145,238,189,0,0,0,0,0,0,128,191,0,0,0,0,220,218,242,190,205,175,230,56,109,115,3,190,0,0,0,0,0,0,128,191,0,0,0,0,70,182,227,190,205,175,230,56,78,185,138,190,0,0,0,0,0,0,128,191,0,0,0,0,58,5,73,190,205,175,230,56,73,243,39,190,0,0,0,0,0,0,128,191,0,0,0,0,220,218,242,190,205,175,230,56,109,115,3,190,0,0,0,0,0,0,128,191,0,0,0,0,58,5,73,190,205,175,230,56,73,243,39,190,0,0,0,0,0,0,128,191,0,0,0,0,197,199,247,62,205,175,230,56,201,145,238,189,0,0,0,0,0,0,128,191,0,0,0,0,202,225,139,190,205,175,230,56,79,178,213,60,0,0,0,0,0,0,128,191,0,0,0,0,220,218,242,190,205,175,230,56,109,115,3,190,0,0,0,0,0,0,128,191,0,0,0,0,197,199,247,62,205,175,230,56,201,145,238,189,0,0,0,0,0,0,128,191,0,0,0,0,202,225,139,190,205,175,230,56,79,178,213,60,0,0,0,0,0,0,128,191,0,0,0,0,197,199,247,62,205,175,230,56,201,145,238,189,0,0,0,0,0,0,128,191,0,0,0,0,213,37,23,63,205,175,230,56,64,78,24,59,0,0,0,0,0,0,128,191,0,0,0,0,202,225,139,190,205,175,230,56,79,178,213,60,0,0,0,0,0,0,128,191,0,0,0,0,213,37,23,63,205,175,230,56,64,78,24,59,0,0,0,0,0,0,128,191,0,0,0,0,31,45,26,63,205,175,230,56,22,193,223,61,0,0,0,0,0,0,128,191,0,0,0,0,251,174,224,190,205,175,230,56,5,108,199,61,0,0,0,0,0,0,128,191,0,0,0,0,202,225,139,190,205,175,230,56,79,178,213,60,0,0,0,0,0,0,128,191,0,0,0,0,31,45,26,63,205,175,230,56,22,193,223,61,0,0,0,0,0,0,128,191,0,0,0,0,249,130,206,190,205,175,230,56,212,15,138,62,0,0,0,0,0,0,128,191,0,0,0,0,251,174,224,190,205,175,230,56,5,108,199,61,0,0,0,0,0,0,128,191,0,0,0,0,31,45,26,63,205,175,230,56,22,193,223,61,0,0,0,0,0,0,128,191,0,0,0,0,249,130,206,190,205,175,230,56,212,15,138,62,0,0,0,0,0,0,128,191,0,0,0,0,31,45,26,63,205,175,230,56,22,193,223,61,0,0,0,0,0,0,128,191,0,0,0,0,227,110,0,63,205,175,230,56,168,138,105,62,0,0,0,0,0,0,128,191,0,0,0,0,249,130,206,190,205,175,230,56,212,15,138,62,0,0,0,0,0,0,128,191,0,0,0,0,227,110,0,63,205,175,230,56,168,138,105,62,0,0,0,0,0,0,128,191,0,0,0,0,161,158,30,190,205,175,230,56,24,37,144,62,0,0,0,0,0,0,128,191,0,0,0,0,161,158,30,190,205,175,230,56,24,37,144,62,0,0,0,0,0,0,128,191,0,0,0,0,227,110,0,63,205,175,230,56,168,138,105,62,0,0,0,0,0,0,128,191,0,0,0,0,48,185,241,62,205,175,230,56,21,58,223,62,0,0,0,0,0,0,128,191,0,0,0,0,10,100,6,190,205,175,230,56,200,68,226,62,0,0,0,0,0,0,128,191,0,0,0,0,161,158,30,190,205,175,230,56,24,37,144,62,0,0,0,0,0,0,128,191,0,0,0,0,9,78,61,61,205,175,230,56,39,250,204,62,0,0,0,0,0,0,128,191,0,0,0,0,9,78,61,61,205,175,230,56,39,250,204,62,0,0,0,0,0,0,128,191,0,0,0,0,161,158,30,190,205,175,230,56,24,37,144,62,0,0,0,0,0,0,128,191,0,0,0,0,48,185,241,62,205,175,230,56,21,58,223,62,0,0,0,0,0,0,128,191,0,0,0,0,31,214,147,62,205,175,230,56,139,164,253,62,0,0,0,0,0,0,128,191,0,0,0,0,9,78,61,61,205,175,230,56,39,250,204,62,0,0,0,0,0,0,128,191,0,0,0,0,48,185,241,62,205,175,230,56,21,58,223,62,0,0,0,0,0,0,128,191,0,0,0,0,174,101,194,190,218,201,96,61,101,110,190,190,0,0,0,0,0,0,128,63,0,0,0,0,166,213,144,186,218,201,96,61,247,120,193,190,0,0,0,0,0,0,128,63,0,0,0,0,98,72,182,190,218,201,96,61,14,76,46,191,0,0,0,0,0,0,128,63,0,0,0,0,166,213,144,186,218,201,96,61,247,120,193,190,0,0,0,0,0,0,128,63,0,0,0,0,197,199,247,62,218,201,96,61,201,145,238,189,0,0,0,0,0,0,128,63,0,0,0,0,177,194,109,61,218,201,96,61,66,204,9,191,0,0,0,0,0,0,128,63,0,0,0,0,174,101,194,190,218,201,96,61,101,110,190,190,0,0,0,0,0,0,128,63,0,0,0,0,197,199,247,62,218,201,96,61,201,145,238,189,0,0,0,0,0,0,128,63,0,0,0,0,166,213,144,186,218,201,96,61,247,120,193,190,0,0,0,0,0,0,128,63,0,0,0,0,58,5,73,190,218,201,96,61,73,243,39,190,0,0,0,0,0,0,128,63,0,0,0,0,197,199,247,62,218,201,96,61,201,145,238,189,0,0,0,0,0,0,128,63,0,0,0,0,174,101,194,190,218,201,96,61,101,110,190,190,0,0,0,0,0,0,128,63,0,0,0,0,220,218,242,190,218,201,96,61,109,115,3,190,0,0,0,0,0,0,128,63,0,0,0,0,58,5,73,190,218,201,96,61,73,243,39,190,0,0,0,0,0,0,128,63,0,0,0,0,70,182,227,190,218,201,96,61,78,185,138,190,0,0,0,0,0,0,128,63,0,0,0,0,220,218,242,190,218,201,96,61,109,115,3,190,0,0,0,0,0,0,128,63,0,0,0,0,197,199,247,62,218,201,96,61,201,145,238,189,0,0,0,0,0,0,128,63,0,0,0,0,58,5,73,190,218,201,96,61,73,243,39,190,0,0,0,0,0,0,128,63,0,0,0,0,202,225,139,190,218,201,96,61,79,178,213,60,0,0,0,0,0,0,128,63,0,0,0,0,197,199,247,62,218,201,96,61,201,145,238,189,0,0,0,0,0,0,128,63,0,0,0,0,220,218,242,190,218,201,96,61,109,115,3,190,0,0,0,0,0,0,128,63,0,0,0,0,202,225,139,190,218,201,96,61,79,178,213,60,0,0,0,0,0,0,128,63,0,0,0,0,213,37,23,63,218,201,96,61,64,78,24,59,0,0,0,0,0,0,128,63,0,0,0,0,197,199,247,62,218,201,96,61,201,145,238,189,0,0,0,0,0,0,128,63,0,0,0,0,202,225,139,190,218,201,96,61,79,178,213,60,0,0,0,0,0,0,128,63,0,0,0,0,31,45,26,63,218,201,96,61,22,193,223,61,0,0,0,0,0,0,128,63,0,0,0,0,213,37,23,63,218,201,96,61,64,78,24,59,0,0,0,0,0,0,128,63,0,0,0,0,251,174,224,190,218,201,96,61,5,108,199,61,0,0,0,0,0,0,128,63,0,0,0,0,31,45,26,63,218,201,96,61,22,193,223,61,0,0,0,0,0,0,128,63,0,0,0,0,202,225,139,190,218,201,96,61,79,178,213,60,0,0,0,0,0,0,128,63,0,0,0,0,249,130,206,190,218,201,96,61,212,15,138,62,0,0,0,0,0,0,128,63,0,0,0,0,31,45,26,63,218,201,96,61,22,193,223,61,0,0,0,0,0,0,128,63,0,0,0,0,251,174,224,190,218,201,96,61,5,108,199,61,0,0,0,0,0,0,128,63,0,0,0,0,249,130,206,190,218,201,96,61,212,15,138,62,0,0,0,0,0,0,128,63,0,0,0,0,227,110,0,63,218,201,96,61,168,138,105,62,0,0,0,0,0,0,128,63,0,0,0,0,31,45,26,63,218,201,96,61,22,193,223,61,0,0,0,0,0,0,128,63,0,0,0,0,249,130,206,190,218,201,96,61,212,15,138,62,0,0,0,0,0,0,128,63,0,0,0,0,161,158,30,190,218,201,96,61,24,37,144,62,0,0,0,0,0,0,128,63,0,0,0,0,227,110,0,63,218,201,96,61,168,138,105,62,0,0,0,0,0,0,128,63,0,0,0,0,161,158,30,190,218,201,96,61,24,37,144,62,0,0,0,0,0,0,128,63,0,0,0,0,48,185,241,62,218,201,96,61,21,58,223,62,0,0,0,0,0,0,128,63,0,0,0,0,227,110,0,63,218,201,96,61,168,138,105,62,0,0,0,0,0,0,128,63,0,0,0,0,10,100,6,190,218,201,96,61,200,68,226,62,0,0,0,0,0,0,128,63,0,0,0,0,9,78,61,61,218,201,96,61,39,250,204,62,0,0,0,0,0,0,128,63,0,0,0,0,161,158,30,190,218,201,96,61,24,37,144,62,0,0,0,0,0,0,128,63,0,0,0,0,9,78,61,61,218,201,96,61,39,250,204,62,0,0,0,0,0,0,128,63,0,0,0,0,48,185,241,62,218,201,96,61,21,58,223,62,0,0,0,0,0,0,128,63,0,0,0,0,161,158,30,190,218,201,96,61,24,37,144,62,0,0,0,0,0,0,128,63,0,0,0,0,31,214,147,62,218,201,96,61,139,164,253,62,0,0,0,0,0,0,128,63,0,0,0,0,48,185,241,62,218,201,96,61,21,58,223,62,0,0,0,0,0,0,128,63,0,0,0,0,9,78,61,61,218,201,96,61,39,250,204,62,0,0,0,0,0,0,128,63,0,0,0,0,58,5,73,190,205,175,230,56,73,243,39,190,169,106,202,62,0,0,0,0,251,36,107,191,70,182,227,190,205,175,230,56,78,185,138,190,169,106,202,62,0,0,0,0,251,36,107,191,70,182,227,190,218,201,96,61,78,185,138,190,169,106,202,62,0,0,0,0,251,36,107,191,58,5,73,190,205,175,230,56,73,243,39,190,169,106,202,62,0,0,0,0,251,36,107,191,70,182,227,190,218,201,96,61,78,185,138,190,169,106,202,62,0,0,0,0,251,36,107,191,58,5,73,190,218,201,96,61,73,243,39,190,169,106,202,62,0,0,0,0,251,36,107,191,213,37,23,63,205,175,230,56,64,78,24,59,181,165,62,63,0,0,0,0,123,217,42,191,197,199,247,62,205,175,230,56,201,145,238,189,181,165,62,63,0,0,0,0,123,217,42,191,197,199,247,62,218,201,96,61,201,145,238,189,181,165,62,63,0,0,0,0,123,217,42,191,213,37,23,63,205,175,230,56,64,78,24,59,181,165,62,63,0,0,0,0,123,217,42,191,197,199,247,62,218,201,96,61,201,145,238,189,181,165,62,63,0,0,0,0,123,217,42,191,213,37,23,63,218,201,96,61,64,78,24,59,181,165,62,63,0,0,0,0,123,217,42,191,166,213,144,186,205,175,230,56,247,120,193,190,181,53,38,63,0,0,0,0,166,180,66,191,98,72,182,190,205,175,230,56,14,76,46,191,181,53,38,63,0,0,0,0,166,180,66,191,98,72,182,190,218,201,96,61,14,76,46,191,181,53,38,63,0,0,0,0,166,180,66,191,166,213,144,186,205,175,230,56,247,120,193,190,181,53,38,63,0,0,0,0,166,180,66,191,98,72,182,190,218,201,96,61,14,76,46,191,181,53,38,63,0,0,0,0,166,180,66,191,166,213,144,186,218,201,96,61,247,120,193,190,181,53,38,63,0,0,0,0,166,180,66,191,249,130,206,190,205,175,230,56,212,15,138,62,109,169,67,189,0,0,0,0,40,181,127,63,161,158,30,190,205,175,230,56,24,37,144,62,109,169,67,189,0,0,0,0,40,181,127,63,161,158,30,190,218,201,96,61,24,37,144,62,109,169,67,189,0,0,0,0,40,181,127,63,249,130,206,190,205,175,230,56,212,15,138,62,109,169,67,189,0,0,0,0,40,181,127,63,161,158,30,190,218,201,96,61,24,37,144,62,109,169,67,189,0,0,0,0,40,181,127,63,249,130,206,190,218,201,96,61,212,15,138,62,109,169,67,189,0,0,0,0,40,181,127,63,174,101,194,190,205,175,230,56,101,110,190,190,172,255,63,191,0,0,0,0,101,84,41,63,58,5,73,190,205,175,230,56,73,243,39,190,172,255,63,191,0,0,0,0,101,84,41,63,58,5,73,190,218,201,96,61,73,243,39,190,172,255,63,191,0,0,0,0,101,84,41,63,174,101,194,190,205,175,230,56,101,110,190,190,172,255,63,191,0,0,0,0,101,84,41,63,58,5,73,190,218,201,96,61,73,243,39,190,172,255,63,191,0,0,0,0,101,84,41,63,174,101,194,190,218,201,96,61,101,110,190,190,172,255,63,191,0,0,0,0,101,84,41,63,31,45,26,63,205,175,230,56,22,193,223,61,151,114,126,63,0,0,0,0,206,52,225,189,213,37,23,63,205,175,230,56,64,78,24,59,151,114,126,63,0,0,0,0,206,52,225,189,213,37,23,63,218,201,96,61,64,78,24,59,151,114,126,63,0,0,0,0,206,52,225,189,31,45,26,63,205,175,230,56,22,193,223,61,151,114,126,63,0,0,0,0,206,52,225,189,213,37,23,63,218,201,96,61,64,78,24,59,151,114,126,63,0,0,0,0,206,52,225,189,31,45,26,63,218,201,96,61,22,193,223,61,151,114,126,63,0,0,0,0,206,52,225,189,220,218,242,190,205,175,230,56,109,115,3,190,82,237,27,191,0,0,0,0,171,8,75,63,202,225,139,190,205,175,230,56,79,178,213,60,82,237,27,191,0,0,0,0,171,8,75,63,202,225,139,190,218,201,96,61,79,178,213,60,82,237,27,191,0,0,0,0,171,8,75,63,220,218,242,190,205,175,230,56,109,115,3,190,82,237,27,191,0,0,0,0,171,8,75,63,202,225,139,190,218,201,96,61,79,178,213,60,82,237,27,191,0,0,0,0,171,8,75,63,220,218,242,190,218,201,96,61,109,115,3,190,82,237,27,191,0,0,0,0,171,8,75,63,10,100,6,190,205,175,230,56,200,68,226,62,186,161,105,62,0,0,0,0,125,63,121,63,9,78,61,61,205,175,230,56,39,250,204,62,186,161,105,62,0,0,0,0,125,63,121,63,9,78,61,61,218,201,96,61,39,250,204,62,186,161,105,62,0,0,0,0,125,63,121,63,10,100,6,190,205,175,230,56,200,68,226,62,186,161,105,62,0,0,0,0,125,63,121,63,9,78,61,61,218,201,96,61,39,250,204,62,186,161,105,62,0,0,0,0,125,63,121,63,10,100,6,190,218,201,96,61,200,68,226,62,186,161,105,62,0,0,0,0,125,63,121,63,177,194,109,61,205,175,230,56,66,204,9,191,232,47,112,191,0,0,0,0,23,40,177,190,166,213,144,186,205,175,230,56,247,120,193,190,232,47,112,191,0,0,0,0,23,40,177,190,166,213,144,186,218,201,96,61,247,120,193,190,232,47,112,191,0,0,0,0,23,40,177,190,177,194,109,61,205,175,230,56,66,204,9,191,232,47,112,191,0,0,0,0,23,40,177,190,166,213,144,186,218,201,96,61,247,120,193,190,232,47,112,191,0,0,0,0,23,40,177,190])
.concat([177,194,109,61,218,201,96,61,66,204,9,191,232,47,112,191,0,0,0,0,23,40,177,190,98,72,182,190,205,175,230,56,14,76,46,191,146,64,127,191,0,0,0,0,102,104,156,189,174,101,194,190,205,175,230,56,101,110,190,190,146,64,127,191,0,0,0,0,102,104,156,189,174,101,194,190,218,201,96,61,101,110,190,190,146,64,127,191,0,0,0,0,102,104,156,189,98,72,182,190,205,175,230,56,14,76,46,191,146,64,127,191,0,0,0,0,102,104,156,189,174,101,194,190,218,201,96,61,101,110,190,190,146,64,127,191,0,0,0,0,102,104,156,189,98,72,182,190,218,201,96,61,14,76,46,191,146,64,127,191,0,0,0,0,102,104,156,189,31,214,147,62,205,175,230,56,139,164,253,62,188,203,157,62,0,0,0,0,231,137,115,63,48,185,241,62,205,175,230,56,21,58,223,62,188,203,157,62,0,0,0,0,231,137,115,63,48,185,241,62,218,201,96,61,21,58,223,62,188,203,157,62,0,0,0,0,231,137,115,63,31,214,147,62,205,175,230,56,139,164,253,62,188,203,157,62,0,0,0,0,231,137,115,63,48,185,241,62,218,201,96,61,21,58,223,62,188,203,157,62,0,0,0,0,231,137,115,63,31,214,147,62,218,201,96,61,139,164,253,62,188,203,157,62,0,0,0,0,231,137,115,63,197,199,247,62,205,175,230,56,201,145,238,189,116,35,52,63,0,0,0,0,92,229,53,191,177,194,109,61,205,175,230,56,66,204,9,191,116,35,52,63,0,0,0,0,92,229,53,191,177,194,109,61,218,201,96,61,66,204,9,191,116,35,52,63,0,0,0,0,92,229,53,191,197,199,247,62,205,175,230,56,201,145,238,189,116,35,52,63,0,0,0,0,92,229,53,191,177,194,109,61,218,201,96,61,66,204,9,191,116,35,52,63,0,0,0,0,92,229,53,191,197,199,247,62,218,201,96,61,201,145,238,189,116,35,52,63,0,0,0,0,92,229,53,191,227,110,0,63,205,175,230,56,168,138,105,62,245,103,67,63,0,0,0,0,208,98,37,63,31,45,26,63,205,175,230,56,22,193,223,61,245,103,67,63,0,0,0,0,208,98,37,63,31,45,26,63,218,201,96,61,22,193,223,61,245,103,67,63,0,0,0,0,208,98,37,63,227,110,0,63,205,175,230,56,168,138,105,62,245,103,67,63,0,0,0,0,208,98,37,63,31,45,26,63,218,201,96,61,22,193,223,61,245,103,67,63,0,0,0,0,208,98,37,63,227,110,0,63,218,201,96,61,168,138,105,62,245,103,67,63,0,0,0,0,208,98,37,63,202,225,139,190,205,175,230,56,79,178,213,60,202,106,202,190,0,0,0,0,234,36,107,191,251,174,224,190,205,175,230,56,5,108,199,61,202,106,202,190,0,0,0,0,234,36,107,191,251,174,224,190,218,201,96,61,5,108,199,61,202,106,202,190,0,0,0,0,234,36,107,191,202,225,139,190,205,175,230,56,79,178,213,60,202,106,202,190,0,0,0,0,234,36,107,191,251,174,224,190,218,201,96,61,5,108,199,61,202,106,202,190,0,0,0,0,234,36,107,191,202,225,139,190,218,201,96,61,79,178,213,60,202,106,202,190,0,0,0,0,234,36,107,191,251,174,224,190,205,175,230,56,5,108,199,61,14,188,122,191,0,0,0,0,94,158,78,62,249,130,206,190,205,175,230,56,212,15,138,62,14,188,122,191,0,0,0,0,94,158,78,62,249,130,206,190,218,201,96,61,212,15,138,62,14,188,122,191,0,0,0,0,94,158,78,62,251,174,224,190,205,175,230,56,5,108,199,61,14,188,122,191,0,0,0,0,94,158,78,62,249,130,206,190,218,201,96,61,212,15,138,62,14,188,122,191,0,0,0,0,94,158,78,62,251,174,224,190,218,201,96,61,5,108,199,61,14,188,122,191,0,0,0,0,94,158,78,62,161,158,30,190,205,175,230,56,24,37,144,62,95,66,125,191,0,0,0,0,63,112,21,62,10,100,6,190,205,175,230,56,200,68,226,62,95,66,125,191,0,0,0,0,63,112,21,62,10,100,6,190,218,201,96,61,200,68,226,62,95,66,125,191,0,0,0,0,63,112,21,62,161,158,30,190,205,175,230,56,24,37,144,62,95,66,125,191,0,0,0,0,63,112,21,62,10,100,6,190,218,201,96,61,200,68,226,62,95,66,125,191,0,0,0,0,63,112,21,62,161,158,30,190,218,201,96,61,24,37,144,62,95,66,125,191,0,0,0,0,63,112,21,62,70,182,227,190,205,175,230,56,78,185,138,190,214,169,122,191,0,0,0,0,109,254,79,190,220,218,242,190,205,175,230,56,109,115,3,190,214,169,122,191,0,0,0,0,109,254,79,190,220,218,242,190,218,201,96,61,109,115,3,190,214,169,122,191,0,0,0,0,109,254,79,190,70,182,227,190,205,175,230,56,78,185,138,190,214,169,122,191,0,0,0,0,109,254,79,190,220,218,242,190,218,201,96,61,109,115,3,190,214,169,122,191,0,0,0,0,109,254,79,190,70,182,227,190,218,201,96,61,78,185,138,190,214,169,122,191,0,0,0,0,109,254,79,190,9,78,61,61,205,175,230,56,39,250,204,62,132,211,186,190,0,0,0,0,58,89,110,63,31,214,147,62,205,175,230,56,139,164,253,62,132,211,186,190,0,0,0,0,58,89,110,63,31,214,147,62,218,201,96,61,139,164,253,62,132,211,186,190,0,0,0,0,58,89,110,63,9,78,61,61,205,175,230,56,39,250,204,62,132,211,186,190,0,0,0,0,58,89,110,63,31,214,147,62,218,201,96,61,139,164,253,62,132,211,186,190,0,0,0,0,58,89,110,63,9,78,61,61,218,201,96,61,39,250,204,62,132,211,186,190,0,0,0,0,58,89,110,63,48,185,241,62,205,175,230,56,21,58,223,62,222,114,125,63,0,0,0,0,122,53,16,62,227,110,0,63,205,175,230,56,168,138,105,62,222,114,125,63,0,0,0,0,122,53,16,62,227,110,0,63,218,201,96,61,168,138,105,62,222,114,125,63,0,0,0,0,122,53,16,62,48,185,241,62,205,175,230,56,21,58,223,62,222,114,125,63,0,0,0,0,122,53,16,62,227,110,0,63,218,201,96,61,168,138,105,62,222,114,125,63,0,0,0,0,122,53,16,62,48,185,241,62,218,201,96,61,21,58,223,62,222,114,125,63,0,0,0,0,122,53,16,62,40,128,242,62,172,173,216,60,62,121,216,60,0,0,0,0,0,0,128,191,0,0,0,0,229,14,227,62,172,173,216,60,150,36,79,61,0,0,0,0,0,0,128,191,0,0,0,0,68,165,113,62,172,173,216,60,238,4,59,189,0,0,0,0,0,0,128,191,0,0,0,0,40,128,242,62,172,173,216,60,62,121,216,60,0,0,0,0,0,0,128,191,0,0,0,0,68,165,113,62,172,173,216,60,238,4,59,189,0,0,0,0,0,0,128,191,0,0,0,0,67,203,130,62,172,173,216,60,111,217,161,189,0,0,0,0,0,0,128,191,0,0,0,0,229,14,227,62,172,173,216,60,150,36,79,61,143,254,31,63,0,0,0,0,39,216,71,63,40,128,242,62,172,173,216,60,62,121,216,60,143,254,31,63,0,0,0,0,39,216,71,63,40,128,242,62,207,75,133,61,62,121,216,60,143,254,31,63,0,0,0,0,39,216,71,63,229,14,227,62,172,173,216,60,150,36,79,61,143,254,31,63,0,0,0,0,39,216,71,63,40,128,242,62,207,75,133,61,62,121,216,60,143,254,31,63,0,0,0,0,39,216,71,63,229,14,227,62,207,75,133,61,150,36,79,61,143,254,31,63,0,0,0,0,39,216,71,63,67,203,130,62,172,173,216,60,111,217,161,189,0,0,0,0,0,0,128,191,0,0,0,0,68,165,113,62,172,173,216,60,238,4,59,189,0,0,0,0,0,0,128,191,0,0,0,0,101,112,148,61,172,173,216,60,244,112,18,190,0,0,0,0,0,0,128,191,0,0,0,0,67,203,130,62,172,173,216,60,111,217,161,189,0,0,0,0,0,0,128,191,0,0,0,0,101,112,148,61,172,173,216,60,244,112,18,190,0,0,0,0,0,0,128,191,0,0,0,0,39,161,212,61,172,173,216,60,79,147,41,190,0,0,0,0,0,0,128,191,0,0,0,0,229,14,227,62,207,75,133,61,150,36,79,61,0,0,0,0,0,0,128,63,0,0,0,0,40,128,242,62,207,75,133,61,62,121,216,60,0,0,0,0,0,0,128,63,0,0,0,0,67,203,130,62,207,75,133,61,111,217,161,189,0,0,0,0,0,0,128,63,0,0,0,0,229,14,227,62,207,75,133,61,150,36,79,61,0,0,0,0,0,0,128,63,0,0,0,0,67,203,130,62,207,75,133,61,111,217,161,189,0,0,0,0,0,0,128,63,0,0,0,0,68,165,113,62,207,75,133,61,238,4,59,189,0,0,0,0,0,0,128,63,0,0,0,0,40,128,242,62,207,75,133,61,62,121,216,60,188,206,222,62,0,0,0,0,53,125,102,191,40,128,242,62,172,173,216,60,62,121,216,60,188,206,222,62,0,0,0,0,53,125,102,191,67,203,130,62,172,173,216,60,111,217,161,189,188,206,222,62,0,0,0,0,53,125,102,191,40,128,242,62,207,75,133,61,62,121,216,60,188,206,222,62,0,0,0,0,53,125,102,191,67,203,130,62,172,173,216,60,111,217,161,189,188,206,222,62,0,0,0,0,53,125,102,191,67,203,130,62,207,75,133,61,111,217,161,189,188,206,222,62,0,0,0,0,53,125,102,191,229,14,227,62,172,173,216,60,150,36,79,61,182,106,215,190,0,0,0,0,37,61,104,63,229,14,227,62,207,75,133,61,150,36,79,61,182,106,215,190,0,0,0,0,37,61,104,63,68,165,113,62,207,75,133,61,238,4,59,189,182,106,215,190,0,0,0,0,37,61,104,63,229,14,227,62,172,173,216,60,150,36,79,61,182,106,215,190,0,0,0,0,37,61,104,63,68,165,113,62,207,75,133,61,238,4,59,189,182,106,215,190,0,0,0,0,37,61,104,63,68,165,113,62,172,173,216,60,238,4,59,189,182,106,215,190,0,0,0,0,37,61,104,63,39,161,212,61,172,173,216,60,79,147,41,190,0,0,0,0,0,0,128,191,0,0,0,0,101,112,148,61,172,173,216,60,244,112,18,190,0,0,0,0,0,0,128,191,0,0,0,0,75,88,155,188,172,173,216,60,162,122,139,190,0,0,0,0,0,0,128,191,0,0,0,0,39,161,212,61,172,173,216,60,79,147,41,190,0,0,0,0,0,0,128,191,0,0,0,0,75,88,155,188,172,173,216,60,162,122,139,190,0,0,0,0,0,0,128,191,0,0,0,0,203,218,166,58,172,173,216,60,155,84,156,190,0,0,0,0,0,0,128,191,0,0,0,0,68,165,113,62,207,75,133,61,238,4,59,189,0,0,0,0,0,0,128,63,0,0,0,0,67,203,130,62,207,75,133,61,111,217,161,189,0,0,0,0,0,0,128,63,0,0,0,0,39,161,212,61,207,75,133,61,79,147,41,190,0,0,0,0,0,0,128,63,0,0,0,0,68,165,113,62,207,75,133,61,238,4,59,189,0,0,0,0,0,0,128,63,0,0,0,0,39,161,212,61,207,75,133,61,79,147,41,190,0,0,0,0,0,0,128,63,0,0,0,0,101,112,148,61,207,75,133,61,244,112,18,190,0,0,0,0,0,0,128,63,0,0,0,0,67,203,130,62,207,75,133,61,111,217,161,189,52,219,253,62,0,0,0,0,93,81,94,191,67,203,130,62,172,173,216,60,111,217,161,189,52,219,253,62,0,0,0,0,93,81,94,191,39,161,212,61,172,173,216,60,79,147,41,190,52,219,253,62,0,0,0,0,93,81,94,191,67,203,130,62,207,75,133,61,111,217,161,189,52,219,253,62,0,0,0,0,93,81,94,191,39,161,212,61,172,173,216,60,79,147,41,190,52,219,253,62,0,0,0,0,93,81,94,191,39,161,212,61,207,75,133,61,79,147,41,190,52,219,253,62,0,0,0,0,93,81,94,191,101,112,148,61,207,75,133,61,244,112,18,190,161,247,2,191,0,0,0,0,111,246,91,63,101,112,148,61,172,173,216,60,244,112,18,190,161,247,2,191,0,0,0,0,111,246,91,63,68,165,113,62,172,173,216,60,238,4,59,189,161,247,2,191,0,0,0,0,111,246,91,63,101,112,148,61,207,75,133,61,244,112,18,190,161,247,2,191,0,0,0,0,111,246,91,63,68,165,113,62,172,173,216,60,238,4,59,189,161,247,2,191,0,0,0,0,111,246,91,63,68,165,113,62,207,75,133,61,238,4,59,189,161,247,2,191,0,0,0,0,111,246,91,63,203,218,166,58,172,173,216,60,155,84,156,190,0,0,0,0,0,0,128,191,0,0,0,0,75,88,155,188,172,173,216,60,162,122,139,190,0,0,0,0,0,0,128,191,0,0,0,0,56,244,70,190,172,173,216,60,172,171,194,190,0,0,0,0,0,0,128,191,0,0,0,0,203,218,166,58,172,173,216,60,155,84,156,190,0,0,0,0,0,0,128,191,0,0,0,0,56,244,70,190,172,173,216,60,172,171,194,190,0,0,0,0,0,0,128,191,0,0,0,0,121,59,50,190,172,173,216,60,198,133,211,190,0,0,0,0,0,0,128,191,0,0,0,0,75,88,155,188,207,75,133,61,162,122,139,190,136,18,81,191,0,0,0,0,98,187,19,63,75,88,155,188,172,173,216,60,162,122,139,190,136,18,81,191,0,0,0,0,98,187,19,63,101,112,148,61,172,173,216,60,244,112,18,190,136,18,81,191,0,0,0,0,98,187,19,63,75,88,155,188,207,75,133,61,162,122,139,190,136,18,81,191,0,0,0,0,98,187,19,63,101,112,148,61,172,173,216,60,244,112,18,190,136,18,81,191,0,0,0,0,98,187,19,63,101,112,148,61,207,75,133,61,244,112,18,190,136,18,81,191,0,0,0,0,98,187,19,63,101,112,148,61,207,75,133,61,244,112,18,190,0,0,0,0,0,0,128,63,0,0,0,0,39,161,212,61,207,75,133,61,79,147,41,190,0,0,0,0,0,0,128,63,0,0,0,0,203,218,166,58,207,75,133,61,155,84,156,190,0,0,0,0,0,0,128,63,0,0,0,0,101,112,148,61,207,75,133,61,244,112,18,190,0,0,0,0,0,0,128,63,0,0,0,0,203,218,166,58,207,75,133,61,155,84,156,190,0,0,0,0,0,0,128,63,0,0,0,0,75,88,155,188,207,75,133,61,162,122,139,190,0,0,0,0,0,0,128,63,0,0,0,0,39,161,212,61,207,75,133,61,79,147,41,190,69,98,78,63,0,0,0,0,24,119,23,191,39,161,212,61,172,173,216,60,79,147,41,190,69,98,78,63,0,0,0,0,24,119,23,191,203,218,166,58,172,173,216,60,155,84,156,190,69,98,78,63,0,0,0,0,24,119,23,191,39,161,212,61,207,75,133,61,79,147,41,190,69,98,78,63,0,0,0,0,24,119,23,191,203,218,166,58,172,173,216,60,155,84,156,190,69,98,78,63,0,0,0,0,24,119,23,191,203,218,166,58,207,75,133,61,155,84,156,190,69,98,78,63,0,0,0,0,24,119,23,191,56,244,70,190,207,75,133,61,172,171,194,190,56,20,90,191,0,0,0,0,156,20,6,191,121,59,50,190,207,75,133,61,198,133,211,190,56,20,90,191,0,0,0,0,156,20,6,191,121,59,50,190,172,173,216,60,198,133,211,190,56,20,90,191,0,0,0,0,156,20,6,191,56,244,70,190,207,75,133,61,172,171,194,190,56,20,90,191,0,0,0,0,156,20,6,191,121,59,50,190,172,173,216,60,198,133,211,190,56,20,90,191,0,0,0,0,156,20,6,191,56,244,70,190,172,173,216,60,172,171,194,190,56,20,90,191,0,0,0,0,156,20,6,191,56,244,70,190,207,75,133,61,172,171,194,190,190,20,6,191,0,0,0,0,39,20,90,63,56,244,70,190,172,173,216,60,172,171,194,190,190,20,6,191,0,0,0,0,39,20,90,63,75,88,155,188,172,173,216,60,162,122,139,190,190,20,6,191,0,0,0,0,39,20,90,63,56,244,70,190,207,75,133,61,172,171,194,190,190,20,6,191,0,0,0,0,39,20,90,63,75,88,155,188,172,173,216,60,162,122,139,190,190,20,6,191,0,0,0,0,39,20,90,63,75,88,155,188,207,75,133,61,162,122,139,190,190,20,6,191,0,0,0,0,39,20,90,63,75,88,155,188,207,75,133,61,162,122,139,190,0,0,0,0,0,0,128,63,0,0,0,0,203,218,166,58,207,75,133,61,155,84,156,190,0,0,0,0,0,0,128,63,0,0,0,0,121,59,50,190,207,75,133,61,198,133,211,190,0,0,0,0,0,0,128,63,0,0,0,0,75,88,155,188,207,75,133,61,162,122,139,190,0,0,0,0,0,0,128,63,0,0,0,0,121,59,50,190,207,75,133,61,198,133,211,190,0,0,0,0,0,0,128,63,0,0,0,0,56,244,70,190,207,75,133,61,172,171,194,190,0,0,0,0,0,0,128,63,0,0,0,0,203,218,166,58,207,75,133,61,155,84,156,190,190,20,6,63,0,0,0,0,39,20,90,191,203,218,166,58,172,173,216,60,155,84,156,190,190,20,6,63,0,0,0,0,39,20,90,191,121,59,50,190,172,173,216,60,198,133,211,190,190,20,6,63,0,0,0,0,39,20,90,191,203,218,166,58,207,75,133,61,155,84,156,190,190,20,6,63,0,0,0,0,39,20,90,191,121,59,50,190,172,173,216,60,198,133,211,190,190,20,6,63,0,0,0,0,39,20,90,191,121,59,50,190,207,75,133,61,198,133,211,190,190,20,6,63,0,0,0,0,39,20,90,191,217,90,151,190,148,23,25,61,254,42,160,189,0,0,0,0,0,0,128,191,0,0,0,0,206,138,144,190,148,23,25,61,11,93,201,189,0,0,0,0,0,0,128,191,0,0,0,0,30,253,15,190,148,23,25,61,195,128,165,189,0,0,0,0,0,0,128,191,0,0,0,0,217,90,151,190,148,23,25,61,254,42,160,189,0,0,0,0,0,0,128,191,0,0,0,0,30,253,15,190,148,23,25,61,195,128,165,189,0,0,0,0,0,0,128,191,0,0,0,0,43,78,21,190,148,23,25,61,118,137,106,189,0,0,0,0,0,0,128,191,0,0,0,0,206,138,144,190,148,23,25,61,11,93,201,189,60,132,85,191,0,0,0,0,142,59,13,191,217,90,151,190,148,23,25,61,254,42,160,189,60,132,85,191,0,0,0,0,142,59,13,191,217,90,151,190,34,225,123,61,254,42,160,189,60,132,85,191,0,0,0,0,142,59,13,191,206,138,144,190,148,23,25,61,11,93,201,189,60,132,85,191,0,0,0,0,142,59,13,191,217,90,151,190,34,225,123,61,254,42,160,189,60,132,85,191,0,0,0,0,142,59,13,191,206,138,144,190,34,225,123,61,11,93,201,189,60,132,85,191,0,0,0,0,142,59,13,191,43,78,21,190,148,23,25,61,118,137,106,189,0,0,0,0,0,0,128,191,0,0,0,0,30,253,15,190,148,23,25,61,195,128,165,189,0,0,0,0,0,0,128,191,0,0,0,0,190,135,203,188,148,23,25,61,21,28,94,189,0,0,0,0,0,0,128,191,0,0,0,0,43,78,21,190,148,23,25,61,118,137,106,189,0,0,0,0,0,0,128,191,0,0,0,0,190,135,203,188,148,23,25,61,21,28,94,189,0,0,0,0,0,0,128,191,0,0,0,0,192,91,32,189,148,23,25,61,226,147,14,189,0,0,0,0,0,0,128,191,0,0,0,0,206,138,144,190,34,225,123,61,11,93,201,189,0,0,0,0,0,0,128,63,0,0,0,0,217,90,151,190,34,225,123,61,254,42,160,189,0,0,0,0,0,0,128,63,0,0,0,0,43,78,21,190,34,225,123,61,118,137,106,189,0,0,0,0,0,0,128,63,0,0,0,0,206,138,144,190,34,225,123,61,11,93,201,189,0,0,0,0,0,0,128,63,0,0,0,0,43,78,21,190,34,225,123,61,118,137,106,189,0,0,0,0,0,0,128,63,0,0,0,0,30,253,15,190,34,225,123,61,195,128,165,189,0,0,0,0,0,0,128,63,0,0,0,0,217,90,151,190,34,225,123,61,254,42,160,189,45,205,13,190,0,0,0,0,160,136,125,63,217,90,151,190,148,23,25,61,254,42,160,189,45,205,13,190,0,0,0,0,160,136,125,63,43,78,21,190,148,23,25,61,118,137,106,189,45,205,13,190,0,0,0,0,160,136,125,63,217,90,151,190,34,225,123,61,254,42,160,189,45,205,13,190,0,0,0,0,160,136,125,63,43,78,21,190,148,23,25,61,118,137,106,189,45,205,13,190,0,0,0,0,160,136,125,63,43,78,21,190,34,225,123,61,118,137,106,189,45,205,13,190,0,0,0,0,160,136,125,63,206,138,144,190,148,23,25,61,11,93,201,189,199,44,251,61,0,0,0,0,69,17,126,191,206,138,144,190,34,225,123,61,11,93,201,189,199,44,251,61,0,0,0,0,69,17,126,191,30,253,15,190,34,225,123,61,195,128,165,189,199,44,251,61,0,0,0,0,69,17,126,191,206,138,144,190,148,23,25,61,11,93,201,189,199,44,251,61,0,0,0,0,69,17,126,191,30,253,15,190,34,225,123,61,195,128,165,189,199,44,251,61,0,0,0,0,69,17,126,191,30,253,15,190,148,23,25,61,195,128,165,189,199,44,251,61,0,0,0,0,69,17,126,191,192,91,32,189,148,23,25,61,226,147,14,189,0,0,0,0,0,0,128,191,0,0,0,0,190,135,203,188,148,23,25,61,21,28,94,189,0,0,0,0,0,0,128,191,0,0,0,0,145,38,94,61,148,23,25,61,25,0,170,59,0,0,0,0,0,0,128,191,0,0,0,0,192,91,32,189,148,23,25,61,226,147,14,189,0,0,0,0,0,0,128,191,0,0,0,0,145,38,94,61,148,23,25,61,25,0,170,59,0,0,0,0,0,0,128,191,0,0,0,0,33,172,70,61,148,23,25,61,1,106,234,60,0,0,0,0,0,0,128,191,0,0,0,0,30,253,15,190,34,225,123,61,195,128,165,189,0,0,0,0,0,0,128,63,0,0,0,0,43,78,21,190,34,225,123,61,118,137,106,189,0,0,0,0,0,0,128,63,0,0,0,0,192,91,32,189,34,225,123,61,226,147,14,189,0,0,0,0,0,0,128,63,0,0,0,0,30,253,15,190,34,225,123,61,195,128,165,189,0,0,0,0,0,0,128,63,0,0,0,0,192,91,32,189,34,225,123,61,226,147,14,189,0,0,0,0,0,0,128,63,0,0,0,0,190,135,203,188,34,225,123,61,21,28,94,189,0,0,0,0,0,0,128,63,0,0,0,0,43,78,21,190,34,225,123,61,118,137,106,189,53,237,82,190,0,0,0,0,165,130,122,63,43,78,21,190,148,23,25,61,118,137,106,189,53,237,82,190,0,0,0,0,165,130,122,63,192,91,32,189,148,23,25,61,226,147,14,189,53,237,82,190,0,0,0,0,165,130,122,63,43,78,21,190,34,225,123,61,118,137,106,189,53,237,82,190,0,0,0,0,165,130,122,63,192,91,32,189,148,23,25,61,226,147,14,189,53,237,82,190,0,0,0,0,165,130,122,63,192,91,32,189,34,225,123,61,226,147,14,189,53,237,82,190,0,0,0,0,165,130,122,63,190,135,203,188,34,225,123,61,21,28,94,189,207,48,101,62,0,0,0,0,107,129,121,191,190,135,203,188,148,23,25,61,21,28,94,189,207,48,101,62,0,0,0,0,107,129,121,191,30,253,15,190,148,23,25,61,195,128,165,189,207,48,101,62,0,0,0,0,107,129,121,191,190,135,203,188,34,225,123,61,21,28,94,189,207,48,101,62,0,0,0,0,107,129,121,191,30,253,15,190,148,23,25,61,195,128,165,189,207,48,101,62,0,0,0,0,107,129,121,191,30,253,15,190,34,225,123,61,195,128,165,189,207,48,101,62,0,0,0,0,107,129,121,191,33,172,70,61,148,23,25,61,1,106,234,60,0,0,0,0,0,0,128,191,0,0,0,0,145,38,94,61,148,23,25,61,25,0,170,59,0,0,0,0,0,0,128,191,0,0,0,0,164,83,55,62,148,23,25,61,47,80,18,61,0,0,0,0,0,0,128,191,0,0,0,0,33,172,70,61,148,23,25,61,1,106,234,60,0,0,0,0,0,0,128,191,0,0,0,0,164,83,55,62,148,23,25,61,47,80,18,61,0,0,0,0,0,0,128,191,0,0,0,0,8,117,49,62,148,23,25,61,32,68,114,61,0,0,0,0,0,0,128,191,0,0,0,0,145,38,94,61,34,225,123,61,25,0,170,59,231,197,25,63,0,0,0,0,147,171,76,191,145,38,94,61,148,23,25,61,25,0,170,59,231,197,25,63,0,0,0,0,147,171,76,191,190,135,203,188,148,23,25,61,21,28,94,189,231,197,25,63,0,0,0,0,147,171,76,191,145,38,94,61,34,225,123,61,25,0,170,59,231,197,25,63,0,0,0,0,147,171,76,191,190,135,203,188,148,23,25,61,21,28,94,189,231,197,25,63,0,0,0,0,147,171,76,191,190,135,203,188,34,225,123,61,21,28,94,189,231,197,25,63,0,0,0,0,147,171,76,191,190,135,203,188,34,225,123,61,21,28,94,189,0,0,0,0,0,0,128,63,0,0,0,0,192,91,32,189,34,225,123,61,226,147,14,189,0,0,0,0,0,0,128,63,0,0,0,0,33,172,70,61,34,225,123,61,1,106,234,60,0,0,0,0,0,0,128,63,0,0,0,0,190,135,203,188,34,225,123,61,21,28,94,189,0,0,0,0,0,0,128,63,0,0,0,0,33,172,70,61,34,225,123,61,1,106,234,60,0,0,0,0,0,0,128,63,0,0,0,0,145,38,94,61,34,225,123,61,25,0,170,59,0,0,0,0,0,0,128,63,0,0,0,0,192,91,32,189,34,225,123,61,226,147,14,189,253,17,22,191,0,0,0,0,132,102,79,63,192,91,32,189,148,23,25,61,226,147,14,189,253,17,22,191,0,0,0,0,132,102,79,63,33,172,70,61,148,23,25,61,1,106,234,60,253,17,22,191,0,0,0,0,132,102,79,63,192,91,32,189,34,225,123,61,226,147,14,189,253,17,22,191,0,0,0,0,132,102,79,63,33,172,70,61,148,23,25,61,1,106,234,60,253,17,22,191,0,0,0,0,132,102,79,63,33,172,70,61,34,225,123,61,1,106,234,60,253,17,22,191,0,0,0,0,132,102,79,63,164,83,55,62,34,225,123,61,47,80,18,61,118,170,120,63,0,0,0,0,134,90,115,62,8,117,49,62,34,225,123,61,32,68,114,61,118,170,120,63,0,0,0,0,134,90,115,62,8,117,49,62,148,23,25,61,32,68,114,61,118,170,120,63,0,0,0,0,134,90,115,62,164,83,55,62,34,225,123,61,47,80,18,61,118,170,120,63,0,0,0,0,134,90,115,62,8,117,49,62,148,23,25,61,32,68,114,61,118,170,120,63,0,0,0,0,134,90,115,62,164,83,55,62,148,23,25,61,47,80,18,61,118,170,120,63,0,0,0,0,134,90,115,62,164,83,55,62,34,225,123,61,47,80,18,61,12,91,115,62,0,0,0,0,101,170,120,191,164,83,55,62,148,23,25,61,47,80,18,61,12,91,115,62,0,0,0,0,101,170,120,191,145,38,94,61,148,23,25,61,25,0,170,59,12,91,115,62,0,0,0,0,101,170,120,191,164,83,55,62,34,225,123,61,47,80,18,61,12,91,115,62,0,0,0,0,101,170,120,191,145,38,94,61,148,23,25,61,25,0,170,59,12,91,115,62,0,0,0,0,101,170,120,191,145,38,94,61,34,225,123,61,25,0,170,59,12,91,115,62,0,0,0,0,101,170,120,191,145,38,94,61,34,225,123,61,25,0,170,59,0,0,0,0,0,0,128,63,0,0,0,0,33,172,70,61,34,225,123,61,1,106,234,60,0,0,0,0,0,0,128,63,0,0,0,0,8,117,49,62,34,225,123,61,32,68,114,61,0,0,0,0,0,0,128,63,0,0,0,0,145,38,94,61,34,225,123,61,25,0,170,59,0,0,0,0,0,0,128,63,0,0,0,0,8,117,49,62,34,225,123,61,32,68,114,61,0,0,0,0,0,0,128,63,0,0,0,0,164,83,55,62,34,225,123,61,47,80,18,61,0,0,0,0,0,0,128,63,0,0,0,0,33,172,70,61,34,225,123,61,1,106,234,60,12,91,115,190,0,0,0,0,101,170,120,63,33,172,70,61,148,23,25,61,1,106,234,60,12,91,115,190,0,0,0,0,101,170,120,63,8,117,49,62,148,23,25,61,32,68,114,61,12,91,115,190,0,0,0,0,101,170,120,63,33,172,70,61,34,225,123,61,1,106,234,60,12,91,115,190,0,0,0,0,101,170,120,63,8,117,49,62,148,23,25,61,32,68,114,61,12,91,115,190,0,0,0,0,101,170,120,63,8,117,49,62,34,225,123,61,32,68,114,61,12,91,115,190,0,0,0,0,101,170,120,63,172,142,212,62,52,242,121,61,140,159,118,62,0,0,128,191,0,0,0,0,0,0,0,0,172,142,212,62,52,242,121,61,131,52,83,62,0,0,128,191,0,0,0,0,0,0,0,0,172,142,212,62,55,142,216,60,131,52,83,62,0,0,128,191,0,0,0,0,0,0,0,0,172,142,212,62,52,242,121,61,140,159,118,62,0,0,128,191,0,0,0,0,0,0,0,0,172,142,212,62,55,142,216,60,131,52,83,62,0,0,128,191,0,0,0,0,0,0,0,0,172,142,212,62,55,142,216,60,140,159,118,62,0,0,128,191,0,0,0,0,0,0,0,0,172,142,212,62,55,142,216,60,140,159,118,62,74,13,45,190,0,0,0,0,101,81,124,191,91,207,64,62,55,142,216,60,54,58,143,62,74,13,45,190,0,0,0,0,101,81,124,191,91,207,64,62,52,242,121,61,54,58,143,62,74,13,45,190,0,0,0,0,101,81,124,191,172,142,212,62,55,142,216,60,140,159,118,62,74,13,45,190,0,0,0,0,101,81,124,191,91,207,64,62,52,242,121,61,54,58,143,62,74,13,45,190,0,0,0,0,101,81,124,191,172,142,212,62,52,242,121,61,140,159,118,62,74,13,45,190,0,0,0,0,101,81,124,191,58,230,76,62,52,242,121,61,220,41,125,62,0,0,0,0,0,0,128,191,0,0,0,0,91,207,64,62,52,242,121,61,54,58,143,62,0,0,0,0,0,0,128,191,0,0,0,0,235,199,166,60,52,242,121,61,37,205,95,62,0,0,0,0,0,0,128,191,0,0,0,0,58,230,76,62,52,242,121,61,220,41,125,62,0,0,0,0,0,0,128,191,0,0,0,0,235,199,166,60,52,242,121,61,37,205,95,62,0,0,0,0,0,0,128,191,0,0,0,0,194,193,222,60,52,242,121,61,39,21,61,62,0,0,0,0,0,0,128,191,0,0,0,0,172,142,212,62,52,242,121,61,131,52,83,62,47,168,63,62,0,0,0,0,217,121,123,63,58,230,76,62,52,242,121,61,220,41,125,62,47,168,63,62,0,0,0,0,217,121,123,63,58,230,76,62,55,142,216,60,220,41,125,62,47,168,63,62,0,0,0,0,217,121,123,63,172,142,212,62,52,242,121,61,131,52,83,62,47,168,63,62,0,0,0,0,217,121,123,63,58,230,76,62,55,142,216,60,220,41,125,62,47,168,63,62,0,0,0,0,217,121,123,63,172,142,212,62,55,142,216,60,131,52,83,62,47,168,63,62,0,0,0,0,217,121,123,63,172,142,212,62,52,242,121,61,131,52,83,62,0,0,0,0,0,0,128,191,0,0,0,0,172,142,212,62,52,242,121,61,140,159,118,62,0,0,0,0,0,0,128,191,0,0,0,0,91,207,64,62,52,242,121,61,54,58,143,62,0,0,0,0,0,0,128,191,0,0,0,0,172,142,212,62,52,242,121,61,131,52,83,62,0,0,0,0,0,0,128,191,0,0,0,0,91,207,64,62,52,242,121,61,54,58,143,62,0,0,0,0,0,0,128,191,0,0,0,0,58,230,76,62,52,242,121,61,220,41,125,62,0,0,0,0,0,0,128,191,0,0,0,0,58,230,76,62,55,142,216,60,220,41,125,62,0,0,0,0,0,0,128,63,0,0,0,0,91,207,64,62,55,142,216,60,54,58,143,62,0,0,0,0,0,0,128,63,0,0,0,0,172,142,212,62,55,142,216,60,140,159,118,62,0,0,0,0,0,0,128,63,0,0,0,0,58,230,76,62,55,142,216,60,220,41,125,62,0,0,0,0,0,0,128,63,0,0,0,0,172,142,212,62,55,142,216,60,140,159,118,62,0,0,0,0,0,0,128,63,0,0,0,0,172,142,212,62,55,142,216,60,131,52,83,62,0,0,0,0,0,0,128,63,0,0,0,0,194,193,222,60,52,242,121,61,39,21,61,62,0,0,0,0,0,0,128,191,0,0,0,0,235,199,166,60,52,242,121,61,37,205,95,62,0,0,0,0,0,0,128,191,0,0,0,0,83,232,12,190,52,242,121,61,107,45,60,62,0,0,0,0,0,0,128,191,0,0,0,0,194,193,222,60,52,242,121,61,39,21,61,62,0,0,0,0,0,0,128,191,0,0,0,0,83,232,12,190,52,242,121,61,107,45,60,62,0,0,0,0,0,0,128,191,0,0,0,0,217,179,231,189,52,242,121,61,78,37,35,62,0,0,0,0,0,0,128,191,0,0,0,0,91,207,64,62,55,142,216,60,54,58,143,62,0,0,0,0,0,0,128,63,0,0,0,0,58,230,76,62,55,142,216,60,220,41,125,62,0,0,0,0,0,0,128,63,0,0,0,0,194,193,222,60,55,142,216,60,39,21,61,62,0,0,0,0,0,0,128,63,0,0,0,0,91,207,64,62,55,142,216,60,54,58,143,62,0,0,0,0,0,0,128,63,0,0,0,0,194,193,222,60,55,142,216,60,39,21,61,62,0,0,0,0,0,0,128,63,0,0,0,0,235,199,166,60,55,142,216,60,37,205,95,62,0,0,0,0,0,0,128,63,0,0,0,0,58,230,76,62,55,142,216,60,220,41,125,62,87,63,174,190,0,0,0,0,246,183,112,63,58,230,76,62,52,242,121,61,220,41,125,62,87,63,174,190,0,0,0,0,246,183,112,63,194,193,222,60,52,242,121,61,39,21,61,62,87,63,174,190,0,0,0,0,246,183,112,63,58,230,76,62,55,142,216,60,220,41,125,62,87,63,174,190,0,0,0,0,246,183,112,63,194,193,222,60,52,242,121,61,39,21,61,62,87,63,174,190,0,0,0,0,246,183,112,63,194,193,222,60,55,142,216,60,39,21,61,62,87,63,174,190,0,0,0,0,246,183,112,63,235,199,166,60,55,142,216,60,37,205,95,62,90,69,175,62,0,0,0,0,97,136,112,191,235,199,166,60,52,242,121,61,37,205,95,62,90,69,175,62,0,0,0,0,97,136,112,191,91,207,64,62,52,242,121,61,54,58,143,62,90,69,175,62,0,0,0,0,97,136,112,191,235,199,166,60,55,142,216,60,37,205,95,62,90,69,175,62,0,0,0,0,97,136,112,191,91,207,64,62,52,242,121,61,54,58,143,62,90,69,175,62,0,0,0,0,97,136,112,191,91,207,64,62,55,142,216,60,54,58,143,62,90,69,175,62,0,0,0,0,97,136,112,191,217,179,231,189,52,242,121,61,78,37,35,62,0,0,0,0,0,0,128,191,0,0,0,0,83,232,12,190,52,242,121,61,107,45,60,62,0,0,0,0,0,0,128,191,0,0,0,0,56,220,87,190,52,242,121,61,89,78,226,61,0,0,0,0,0,0,128,191,0,0,0,0,217,179,231,189,52,242,121,61,78,37,35,62,0,0,0,0,0,0,128,191,0,0,0,0,56,220,87,190,52,242,121,61,89,78,226,61,0,0,0,0,0,0,128,191,0,0,0,0,20,206,62,190,52,242,121,61,155,61,176,61,0,0,0,0,0,0,128,191,0,0,0,0,83,232,12,190,55,142,216,60,107,45,60,62,238,61,92,62,0,0,0,0,50,2,122,191,83,232,12,190,52,242,121,61,107,45,60,62,238,61,92,62,0,0,0,0,50,2,122,191,235,199,166,60,52,242,121,61,37,205,95,62,238,61,92,62,0,0,0,0,50,2,122,191,83,232,12,190,55,142,216,60,107,45,60,62,238,61,92,62,0,0,0,0,50,2,122,191,235,199,166,60,52,242,121,61,37,205,95,62,238,61,92,62,0,0,0,0,50,2,122,191,235,199,166,60,55,142,216,60,37,205,95,62,238,61,92,62,0,0,0,0,50,2,122,191,235,199,166,60,55,142,216,60,37,205,95,62,0,0,0,0,0,0,128,63,0,0,0,0,194,193,222,60,55,142,216,60,39,21,61,62,0,0,0,0,0,0,128,63,0,0,0,0,217,179,231,189,55,142,216,60,78,37,35,62,0,0,0,0,0,0,128,63,0,0,0,0,235,199,166,60,55,142,216,60,37,205,95,62,0,0,0,0,0,0,128,63,0,0,0,0,217,179,231,189,55,142,216,60,78,37,35,62,0,0,0,0,0,0,128,63,0,0,0,0,83,232,12,190,55,142,216,60,107,45,60,62,0,0,0,0,0,0,128,63,0,0,0,0,194,193,222,60,55,142,216,60,39,21,61,62,84,227,53,190,0,0,0,0,217,237,123,63,194,193,222,60,52,242,121,61,39,21,61,62,84,227,53,190,0,0,0,0,217,237,123,63,217,179,231,189,52,242,121,61,78,37,35,62,84,227,53,190,0,0,0,0,217,237,123,63,194,193,222,60,55,142,216,60,39,21,61,62,84,227,53,190,0,0,0,0,217,237,123,63,217,179,231,189,52,242,121,61,78,37,35,62,84,227,53,190,0,0,0,0,217,237,123,63,217,179,231,189,55,142,216,60,78,37,35,62,84,227,53,190,0,0,0,0,217,237,123,63,56,220,87,190,55,142,216,60,89,78,226,61,208,238,52,63,0,0,0,0,30,27,53,63,20,206,62,190,55,142,216,60,155,61,176,61,208,238,52,63,0,0,0,0,30,27,53,63,20,206,62,190,52,242,121,61,155,61,176,61,208,238,52,63,0,0,0,0,30,27,53,63,56,220,87,190,55,142,216,60,89,78,226,61,208,238,52,63,0,0,0,0,30,27,53,63,20,206,62,190,52,242,121,61,155,61,176,61,208,238,52,63,0,0,0,0,30,27,53,63,56,220,87,190,52,242,121,61,89,78,226,61,208,238,52,63,0,0,0,0,30,27,53,63,217,179,231,189,55,142,216,60,78,37,35,62,30,27,53,191,0,0,0,0,208,238,52,63,217,179,231,189,52,242,121,61,78,37,35,62,30,27,53,191,0,0,0,0,208,238,52,63,20,206,62,190,52,242,121,61,155,61,176,61,30,27,53,191,0,0,0,0,208,238,52,63,217,179,231,189,55,142,216,60,78,37,35,62,30,27,53,191,0,0,0,0,208,238,52,63,20,206,62,190,52,242,121,61,155,61,176,61,30,27,53,191,0,0,0,0,208,238,52,63,20,206,62,190,55,142,216,60,155,61,176,61,30,27,53,191,0,0,0,0,208,238,52,63,56,220,87,190,55,142,216,60,89,78,226,61,30,27,53,63,0,0,0,0,208,238,52,191,56,220,87,190,52,242,121,61,89,78,226,61,30,27,53,63,0,0,0,0,208,238,52,191,83,232,12,190,52,242,121,61,107,45,60,62,30,27,53,63,0,0,0,0,208,238,52,191,56,220,87,190,55,142,216,60,89,78,226,61,30,27,53,63,0,0,0,0,208,238,52,191,83,232,12,190,52,242,121,61,107,45,60,62,30,27,53,63,0,0,0,0,208,238,52,191,83,232,12,190,55,142,216,60,107,45,60,62,30,27,53,63,0,0,0,0,208,238,52,191,83,232,12,190,55,142,216,60,107,45,60,62,0,0,0,0,0,0,128,63,0,0,0,0,217,179,231,189,55,142,216,60,78,37,35,62,0,0,0,0,0,0,128,63,0,0,0,0,20,206,62,190,55,142,216,60,155,61,176,61,0,0,0,0,0,0,128,63,0,0,0,0,83,232,12,190,55,142,216,60,107,45,60,62,0,0,0,0,0,0,128,63,0,0,0,0,20,206,62,190,55,142,216,60,155,61,176,61,0,0,0,0,0,0,128,63,0,0,0,0,56,220,87,190,55,142,216,60,89,78,226,61,0,0,0,0,0,0,128,63,0,0,0,0,74,117,108,0,0,0,0,0,74,117,110,0,0,0,0,0,65,112,114,0,0,0,0,0,77,97,114,0,0,0,0,0,70,101,98,0,0,0,0,0,74,97,110,0,0,0,0,0,68,101,99,101,109,98,101,114,0,0,0,0,0,0,0,0,117,110,115,117,112,112,111,114,116,101,100,32,108,111,99,97,108,101,32,102,111,114,32,115,116,97,110,100,97,114,100,32,105,110,112,117,116,0,0,0,78,111,118,101,109,98,101,114,0,0,0,0,0,0,0,0,79,99,116,111,98,101,114,0,83,101,112,116,101,109,98,101,114,0,0,0,0,0,0,0,32,35,35,0,0,0,0,0,65,117,103,117,115,116,0,0,74,117,108,121,0,0,0,0,74,117,110,101,0,0,0,0,77,97,121,0,0,0,0,0,65,112,114,105,108,0,0,0,77,97,114,99,104,0,0,0,70,101,98,114,117,97,114,121,0,0,0,0,0,0,0,0,74,97,110,117,97,114,121,0,98,97,115,105,99,95,115,116,114,105,110,103,0,0,0,0,68,0,0,0,101,0,0,0,99,0,0,0,0,0,0,0,35,99,0,0,0,0,0,0,78,0,0,0,111,0,0,0,118,0,0,0,0,0,0,0,79,0,0,0,99,0,0,0,116,0,0,0,0,0,0,0,83,0,0,0,101,0,0,0,112,0,0,0,0,0,0,0,65,0,0,0,117,0,0,0,103,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,108,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,110,0,0,0,0,0,0,0,77,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,65,0,0,0,112,0,0,0,114,0,0,0,0,0,0,0,77,0,0,0,97,0,0,0,114,0,0,0,0,0,0,0,70,0,0,0,101,0,0,0,98,0,0,0,0,0,0,0,32,99,35,0,0,0,0,0,74,0,0,0,97,0,0,0,110,0,0,0,0,0,0,0,68,0,0,0,101,0,0,0,99,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,0,0,0,0,78,0,0,0,111,0,0,0,118,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,0,0,0,0,79,0,0,0,99,0,0,0,116,0,0,0,111,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,83,0,0,0,101,0,0,0,112,0,0,0,116,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,65,0,0,0,117,0,0,0,103,0,0,0,117,0,0,0,115,0,0,0,116,0,0,0,0,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,108,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,110,0,0,0,101,0,0,0,0,0,0,0,0,0,0,0,65,0,0,0,112,0,0,0,114,0,0,0,105,0,0,0,108,0,0,0,0,0,0,0,32,32,35,0,0,0,0,0,77,0,0,0,97,0,0,0,114,0,0,0,99,0,0,0,104,0,0,0,0,0,0,0,70,0,0,0,101,0,0,0,98,0,0,0,114,0,0,0,117,0,0,0,97,0,0,0,114,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,74,0,0,0,97,0,0,0,110,0,0,0,117,0,0,0,97,0,0,0,114,0,0,0,121,0,0,0,0,0,0,0,80,77,0,0,0,0,0,0,112,114,101,99,105,115,105,111,110,32,109,101,100,105,117,109,112,32,102,108,111,97,116,59,10,118,97,114,121,105,110,103,32,118,101,99,52,32,99,111,108,59,10,118,111,105,100,32,109,97,105,110,40,41,10,123,10,32,32,32,32,103,108,95,70,114,97,103,67,111,108,111,114,32,61,32,99,111,108,59,10,125,10,0,0,0,0,0,65,77,0,0,0,0,0,0,35,0,0,0,0,0,0,0,80,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,65,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,114,101,116,117,114,110,32,69,109,84,111,117,99,104,111,46,99,117,114,114,101,110,116,69,118,101,110,116,46,121,59,0,112,114,101,99,105,115,105,111,110,32,109,101,100,105,117,109])
.concat([112,32,102,108,111,97,116,59,10,97,116,116,114,105,98,117,116,101,32,118,101,99,52,32,118,116,120,99,111,111,114,100,59,10,97,116,116,114,105,98,117,116,101,32,118,101,99,51,32,110,114,109,97,108,118,101,99,59,10,117,110,105,102,111,114,109,32,109,97,116,52,32,112,114,111,106,101,99,116,105,111,110,59,10,117,110,105,102,111,114,109,32,109,97,116,52,32,109,111,100,101,108,118,105,101,119,59,10,117,110,105,102,111,114,109,32,118,101,99,52,32,99,111,108,111,114,59,10,117,110,105,102,111,114,109,32,118,101,99,51,32,108,105,103,104,116,112,111,115,59,10,118,97,114,121,105,110,103,32,118,101,99,52,32,99,111,108,59,10,118,111,105,100,32,109,97,105,110,40,41,10,123,10,32,32,32,32,103,108,95,80,111,115,105,116,105,111,110,32,61,32,118,116,120,99,111,111,114,100,32,42,32,109,111,100,101,108,118,105,101,119,32,42,32,112,114,111,106,101,99,116,105,111,110,59,10,32,32,32,32,118,101,99,51,32,112,32,61,32,118,101,99,51,40,118,116,120,99,111,111,114,100,32,42,32,109,111,100,101,108,118,105,101,119,41,59,10,32,32,32,32,118,101,99,51,32,110,110,32,61,32,110,111,114,109,97,108,105,122,101,40,118,101,99,51,40,118,101,99,52,40,110,114,109,97,108,118,101,99,44,32,48,46,48,41,32,42,32,109,111,100,101,108,118,105,101,119,41,41,59,10,32,32,32,32,118,101,99,51,32,76,32,61,32,110,111,114,109,97,108,105,122,101,40,112,32,45,32,108,105,103,104,116,112,111,115,41,59,10,32,32,32,32,102,108,111,97,116,32,100,105,102,102,117,115,101,32,61,32,99,108,97,109,112,40,100,111,116,40,110,110,44,32,76,41,44,32,48,46,48,44,32,49,46,48,41,59,10,32,32,32,32,99,111,108,32,61,32,118,101,99,52,40,99,111,108,111,114,46,114,103,98,32,42,32,40,48,46,54,32,43,32,48,46,52,32,42,32,100,105,102,102,117,115,101,41,44,32,99,111,108,111,114,46,97,41,59,10,125,10,0,0,0,0,0,0,35,35,0,0,0,0,0,0,81,117,105,116,0,0,0,0,112,114,101,99,105,115,105,111,110,32,109,101,100,105,117,109,112,32,102,108,111,97,116,59,10,97,116,116,114,105,98,117,116,101,32,118,101,99,52,32,118,116,120,99,111,111,114,100,59,10,97,116,116,114,105,98,117,116,101,32,118,101,99,52,32,118,116,120,99,111,108,111,114,59,10,117,110,105,102,111,114,109,32,109,97,116,52,32,112,114,111,106,101,99,116,105,111,110,59,10,118,97,114,121,105,110,103,32,118,101,99,52,32,99,111,108,59,10,10,118,111,105,100,32,109,97,105,110,40,41,10,123,10,32,32,32,32,103,108,95,80,111,115,105,116,105,111,110,32,61,32,118,116,120,99,111,111,114,100,32,42,32,112,114,111,106,101,99,116,105,111,110,59,10,32,32,32,32,99,111,108,32,61,32,118,116,120,99,111,108,111,114,59,10,125,10,0,0,0,0,114,101,116,117,114,110,32,69,109,84,111,117,99,104,111,46,99,117,114,114,101,110,116,69,118,101,110,116,46,120,59,0,108,111,99,97,108,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,0,0,0,115,116,100,58,58,98,97,100,95,99,97,115,116,0,0,0,37,0,0,0,73,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,112,0,0,0,0,0,0,0,37,73,58,37,77,58,37,83,32,37,112,0,0,0,0,0,37,0,0,0,97,0,0,0,32,0,0,0,37,0,0,0,98,0,0,0,32,0,0,0,37,0,0,0,100,0,0,0,32,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,89,0,0,0,0,0,0,0,0,0,0,0,112,114,101,99,105,115,105,111,110,32,109,101,100,105,117,109,112,32,102,108,111,97,116,59,10,117,110,105,102,111,114,109,32,115,97,109,112,108,101,114,50,68,32,115,97,109,112,108,101,114,59,10,118,97,114,121,105,110,103,32,118,101,99,52,32,99,111,108,59,10,118,97,114,121,105,110,103,32,118,101,99,50,32,116,101,120,59,10,10,118,111,105,100,32,109,97,105,110,40,41,10,123,10,32,32,32,32,103,108,95,70,114,97,103,67,111,108,111,114,32,61,32,118,101,99,52,40,99,111,108,46,114,103,98,44,32,116,101,120,116,117,114,101,50,68,40,115,97,109,112,108,101,114,44,32,116,101,120,41,46,97,32,42,32,99,111,108,46,97,41,59,10,125,10,0,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,0,37,97,32,37,98,32,37,100,32,37,72,58,37,77,58,37,83,32,37,89,0,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,0,0,0,0,0,0,0,0,35,120,0,0,0,0,0,0,37,72,58,37,77,58,37,83,0,0,0,0,0,0,0,0,118,49,46,49,46,53,0,0,82,101,115,117,109,101,0,0,37,0,0,0,109,0,0,0,47,0,0,0,37,0,0,0,100,0,0,0,47,0,0,0,37,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,37,109,47,37,100,47,37,121,0,0,0,0,0,0,0,0,114,101,116,117,114,110,32,69,109,84,111,117,99,104,111,46,99,117,114,114,101,110,116,69,118,101,110,116,46,115,116,97,116,101,59,0,0,0,0,0,102,0,0,0,97,0,0,0,108,0,0,0,115,0,0,0,101,0,0,0,0,0,0,0,37,112,0,0,0,0,0,0,102,97,108,115,101,0,0,0,116,0,0,0,114,0,0,0,117,0,0,0,101,0,0,0,0,0,0,0,0,0,0,0,116,114,117,101,0,0,0,0,112,114,101,99,105,115,105,111,110,32,109,101,100,105,117,109,112,32,102,108,111,97,116,59,10,97,116,116,114,105,98,117,116,101,32,118,101,99,52,32,118,116,120,99,111,111,114,100,59,10,97,116,116,114,105,98,117,116,101,32,118,101,99,50,32,116,101,120,99,111,111,114,100,59,10,97,116,116,114,105,98,117,116,101,32,118,101,99,52,32,118,116,120,99,111,108,111,114,59,10,117,110,105,102,111,114,109,32,109,97,116,52,32,112,114,111,106,101,99,116,105,111,110,59,10,118,97,114,121,105,110,103,32,118,101,99,52,32,99,111,108,59,10,118,97,114,121,105,110,103,32,118,101,99,50,32,116,101,120,59,10,10,118,111,105,100,32,109,97,105,110,40,41,10,123,10,32,32,32,32,103,108,95,80,111,115,105,116,105,111,110,32,61,32,118,116,120,99,111,111,114,100,32,42,32,112,114,111,106,101,99,116,105,111,110,59,10,32,32,32,32,99,111,108,32,61,32,118,116,120,99,111,108,111,114,59,10,32,32,32,32,116,101,120,32,61,32,116,101,120,99,111,111,114,100,59,10,125,10,0,0,0,0,0,114,98,0,0,0,0,0,0,58,32,0,0,0,0,0,0,35,99,35,35,0,0,0,0,35,99,35,0,0,0,0,0,78,101,119,32,114,101,99,111,114,100,33,0,0,0,0,0,105,111,115,95,98,97,115,101,58,58,99,108,101,97,114,0,82,101,112,108,97,121,0,0,71,97,109,101,32,80,97,117,115,101,100,46,0,0,0,0,114,101,116,117,114,110,32,69,109,84,111,117,99,104,111,46,99,117,114,114,101,110,116,69,118,101,110,116,46,105,100,59,0,0,0,0,0,0,0,0,118,116,120,99,111,108,111,114,0,0,0,0,0,0,0,0,116,101,120,99,111,111,114,100,0,0,0,0,0,0,0,0,67,0,0,0,0,0,0,0,118,101,99,116,111,114,0,0,108,105,103,104,116,112,111,115,0,0,0,0,0,0,0,0,72,79,77,69,0,0,0,0,37,46,48,76,102,0,0,0,99,111,108,111,114,0,0,0,60,99,62,32,50,48,49,51,32,116,104,112,46,105,111,0,109,111,110,101,121,95,103,101,116,32,101,114,114,111,114,0,112,114,101,99,105,115,105,111,110,32,109,101,100,105,117,109,112,32,102,108,111,97,116,59,10,118,97,114,121,105,110,103,32,118,101,99,52,32,99,111,108,59,10,10,118,111,105,100,32,109,97,105,110,40,41,10,123,10,32,32,32,32,103,108,95,70,114,97,103,67,111,108,111,114,32,61,32,99,111,108,59,10,125,10,0,0,0,0,109,111,100,101,108,118,105,101,119,0,0,0,0,0,0,0,83,99,111,114,101,58,0,0,83,97,116,0,0,0,0,0,70,114,105,0,0,0,0,0,105,111,115,116,114,101,97,109,0,0,0,0,0,0,0,0,37,76,102,0,0,0,0,0,84,104,117,0,0,0,0,0,87,101,100,0,0,0,0,0,83,116,97,114,116,32,71,97,109,101,0,0,0,0,0,0,84,117,101,0,0,0,0,0,112,114,111,106,101,99,116,105,111,110,0,0,0,0,0,0,77,111,110,0,0,0,0,0,83,117,110,0,0,0,0,0,83,97,116,117,114,100,97,121,0,0,0,0,0,0,0,0,83,99,111,114,101,58,0,0,70,114,105,100,97,121,0,0,84,104,117,114,115,100,97,121,0,0,0,0,0,0,0,0,119,98,0,0,0,0,0,0,87,101,100,110,101,115,100,97,121,0,0,0,0,0,0,0,84,117,101,115,100,97,121,0,32,35,32,0,0,0,0,0,77,111,110,100,97,121,0,0,83,117,110,100,97,121,0,0,110,114,109,97,108,118,101,99,0,0,0,0,0,0,0,0,83,0,0,0,97,0,0,0,116,0,0,0,0,0,0,0,70,0,0,0,114,0,0,0,105,0,0,0,0,0,0,0,84,0,0,0,104,0,0,0,117,0,0,0,0,0,0,0,87,0,0,0,101,0,0,0,100,0,0,0,0,0,0,0,47,46,99,111,110,102,105,103,47,116,101,116,114,101,112,101,116,101,116,101,0,0,0,0,84,0,0,0,117,0,0,0,101,0,0,0,0,0,0,0,84,111,117,99,104,32,116,111,32,99,111,110,116,105,110,117,101,0,0,0,0,0,0,0,77,0,0,0,111,0,0,0,110,0,0,0,0,0,0,0,76,105,110,101,115,58,0,0,117,110,115,112,101,99,105,102,105,101,100,32,105,111,115,116,114,101,97,109,95,99,97,116,101,103,111,114,121,32,101,114,114,111,114,0,0,0,0,0,72,105,103,104,115,99,111,114,101,115,0,0,0,0,0,0,83,0,0,0,117,0,0,0,110,0,0,0,0,0,0,0,76,105,110,101,115,58,0,0,83,0,0,0,97,0,0,0,116,0,0,0,117,0,0,0,114,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,70,0,0,0,114,0,0,0,105,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,98,101,115,116,46,114,101,99,0,0,0,0,0,0,0,0,84,0,0,0,104,0,0,0,117,0,0,0,114,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,118,116,120,99,111,111,114,100,0,0,0,0,0,0,0,0,87,0,0,0,101,0,0,0,100,0,0,0,110,0,0,0,101,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,84,0,0,0,117,0,0,0,101,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,77,0,0,0,111,0,0,0,110,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,83,0,0,0,117,0,0,0,110,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,108,97,115,116,46,114,101,99,0,0,0,0,0,0,0,0,68,101,99,0,0,0,0,0,78,111,118,0,0,0,0,0,79,99,116,0,0,0,0,0,83,101,112,0,0,0,0,0,65,117,103,0,0,0,0,0,69,109,84,111,117,99,104,111,46,99,117,114,114,101,110,116,69,118,101,110,116,32,61,32,69,109,84,111,117,99,104,111,46,101,118,101,110,116,81,117,101,117,101,46,115,104,105,102,116,40,41,59,0,0,0,0,114,101,116,117,114,110,32,69,109,84,111,117,99,104,111,46,101,118,101,110,116,81,117,101,117,101,46,108,101,110,103,116,104,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,49,50,51,52,53,54,55,56,57,0,0,0,0,0,0,48,49,50,51,52,53,54,55,56,57,0,0,0,0,0,0,37,0,0,0,89,0,0,0,45,0,0,0,37,0,0,0,109,0,0,0,45,0,0,0,37,0,0,0,100,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,0,0,0,0,37,0,0,0,73,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,112,0,0,0,0,0,0,0,37,0,0,0,109,0,0,0,47,0,0,0,37,0,0,0,100,0,0,0,47,0,0,0,37,0,0,0,121,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,37,72,58,37,77,58,37,83,37,72,58,37,77,0,0,0,37,73,58,37,77,58,37,83,32,37,112,0,0,0,0,0,37,89,45,37,109,45,37,100,37,109,47,37,100,47,37,121,37,72,58,37,77,58,37,83,37,0,0,0,0,0,0,0,37,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,46,2,0,40,0,0,0,142,0,0,0,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,46,2,0,244,0,0,0,198,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,46,2,0,84,0,0,0,66,1,0,0,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,46,2,0,112,0,0,0,10,0,0,0,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,46,2,0,112,0,0,0,22,0,0,0,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,46,2,0,48,1,0,0,4,1,0,0,64,0,0,0,2,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,46,2,0,56,1,0,0,232,0,0,0,64,0,0,0,4,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,46,2,0,196,0,0,0,236,0,0,0,64,0,0,0,12,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,46,2,0,58,1,0,0,168,0,0,0,64,0,0,0,10,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,47,2,0,52,1,0,0,110,0,0,0,64,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,47,2,0,192,0,0,0,132,0,0,0,64,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,47,2,0,50,0,0,0,134,0,0,0,64,0,0,0,122,0,0,0,6,0,0,0,34,0,0,0,8,0,0,0,24,0,0,0,60,0,0,0,2,0,0,0,248,255,255,255,168,47,2,0,22,0,0,0,10,0,0,0,34,0,0,0,14,0,0,0,2,0,0,0,32,0,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,47,2,0,38,1,0,0,24,1,0,0,64,0,0,0,20,0,0,0,20,0,0,0,66,0,0,0,30,0,0,0,22,0,0,0,2,0,0,0,4,0,0,0,248,255,255,255,208,47,2,0,66,0,0,0,104,0,0,0,116,0,0,0,124,0,0,0,94,0,0,0,44,0,0,0,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,47,2,0,90,0,0,0,238,0,0,0,64,0,0,0,46,0,0,0,40,0,0,0,20,0,0,0,66,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,48,2,0,120,0,0,0,80,0,0,0,64,0,0,0,42,0,0,0,80,0,0,0,24,0,0,0,86,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,48,2,0,42,1,0,0,2,0,0,0,64,0,0,0,24,0,0,0,32,0,0,0,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,48,2,0,62,0,0,0,6,0,0,0,64,0,0,0,38,0,0,0,12,0,0,0,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,48,2,0,10,1,0,0,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,48,2,0,36,0,0,0,74,0,0,0,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,48,2,0,8,0,0,0,208,0,0,0,64,0,0,0,26,0,0,0,6,0,0,0,16,0,0,0,4,0,0,0,14,0,0,0,4,0,0,0,2,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,48,2,0,118,0,0,0,20,0,0,0,64,0,0,0,20,0,0,0,24,0,0,0,38,0,0,0,22,0,0,0,36,0,0,0,8,0,0,0,6,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,48,2,0,52,0,0,0,28,0,0,0,64,0,0,0,52,0,0,0,50,0,0,0,42,0,0,0,44,0,0,0,32,0,0,0,48,0,0,0,40,0,0,0,58,0,0,0,56,0,0,0,54,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,48,2,0,68,0,0,0,4,0,0,0,64,0,0,0,62,0,0,0,76,0,0,0,70,0,0,0,72,0,0,0,64,0,0,0,74,0,0,0,68,0,0,0,82,0,0,0,80,0,0,0,78,0,0,0,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,48,2,0,86,0,0,0,108,0,0,0,64,0,0,0,8,0,0,0,22,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,2,0,34,0,0,0,212,0,0,0,64,0,0,0,16,0,0,0,28,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,49,2,0,14,1,0,0,228,0,0,0,64,0,0,0,16,0,0,0,10,0,0,0,14,0,0,0,120,0,0,0,98,0,0,0,24,0,0,0,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,49,2,0,216,0,0,0,162,0,0,0,64,0,0,0,12,0,0,0,14,0,0,0,18,0,0,0,50,0,0,0,8,0,0,0,20,0,0,0,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,49,2,0,216,0,0,0,24,0,0,0,64,0,0,0,4,0,0,0,2,0,0,0,4,0,0,0,96,0,0,0,60,0,0,0,12,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,49,2,0,216,0,0,0,122,0,0,0,64,0,0,0,6,0,0,0,8,0,0,0,22,0,0,0,30,0,0,0,70,0,0,0,10,0,0,0,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,49,2,0,216,0,0,0,44,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,49,2,0,72,0,0,0,188,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,49,2,0,216,0,0,0,92,0,0,0,64,0,0,0,20,0,0,0,2,0,0,0,4,0,0,0,10,0,0,0,16,0,0,0,28,0,0,0,22,0,0,0,6,0,0,0,4,0,0,0,8,0,0,0,10,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,49,2,0,62,1,0,0,46,0,0,0,64,0,0,0,10,0,0,0,4,0,0,0,18,0,0,0,36,0,0,0,8,0,0,0,6,0,0,0,26,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,2,0,82,0,0,0,20,1,0,0,72,0,0,0,6,0,0,0,14,0,0,0,32,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,50,2,0,216,0,0,0,96,0,0,0,64,0,0,0,6,0,0,0,8,0,0,0,22,0,0,0,30,0,0,0,70,0,0,0,10,0,0,0,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,50,2,0,216,0,0,0,200,0,0,0,64,0,0,0,6,0,0,0,8,0,0,0,22,0,0,0,30,0,0,0,70,0,0,0,10,0,0,0,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,50,2,0,160,0,0,0,156,0,0,0,108,0,0,0,22,0,0,0,14,0,0,0,24,0,0,0,86,0,0,0,100,0,0,0,34,0,0,0,28,0,0,0,26,0,0,0,6,0,0,0,44,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,50,2,0,12,0,0,0,146,0,0,0,92,0,0,0,40,0,0,0,30,0,0,0,20,0,0,0,48,0,0,0,82,0,0,0,18,0,0,0,6,0,0,0,12,0,0,0,26,0,0,0,16,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,104,50,2,0,58,0,0,0,2,1,0,0,252,255,255,255,252,255,255,255,104,50,2,0,174,0,0,0,158,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,128,50,2,0,12,1,0,0,30,1,0,0,252,255,255,255,252,255,255,255,128,50,2,0,128,0,0,0,248,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,152,50,2,0,100,0,0,0,46,1,0,0,248,255,255,255,248,255,255,255,152,50,2,0,218,0,0,0,28,1,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,176,50,2,0,126,0,0,0,254,0,0,0,248,255,255,255,248,255,255,255,176,50,2,0,166,0,0,0,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,50,2,0,252,0,0,0,220,0,0,0,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,50,2,0,44,1,0,0,224,0,0,0,28,0,0,0,22,0,0,0,14,0,0,0,24,0,0,0,56,0,0,0,100,0,0,0,34,0,0,0,28,0,0,0,26,0,0,0,6,0,0,0,30,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,2,0,186,0,0,0,214,0,0,0,78,0,0,0,40,0,0,0,30,0,0,0,20,0,0,0,88,0,0,0,82,0,0,0,18,0,0,0,6,0,0,0,12,0,0,0,26,0,0,0,42,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,51,2,0,22,1,0,0,172,0,0,0,64,0,0,0,64,0,0,0,118,0,0,0,68,0,0,0,114,0,0,0,8,0,0,0,54,0,0,0,52,0,0,0,40,0,0,0,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,51,2,0,124,0,0,0,70,0,0,0,64,0,0,0,130,0,0,0,114,0,0,0,100,0,0,0,34,0,0,0,110,0,0,0,44,0,0,0,112,0,0,0,82,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,51,2,0,26,1,0,0,140,0,0,0,64,0,0,0,16,0,0,0,58,0,0,0,12,0,0,0,74,0,0,0,116,0,0,0,84,0,0,0,92,0,0,0,88,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,51,2,0,88,0,0,0,206,0,0,0,64,0,0,0,102,0,0,0,106,0,0,0,52,0,0,0,10,0,0,0,46,0,0,0,36,0,0,0,74,0,0,0,104,0,0,0,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,51,2,0,104,0,0,0,18,0,0,0,60,0,0,0,22,0,0,0,14,0,0,0,24,0,0,0,86,0,0,0,100,0,0,0,34,0,0,0,68,0,0,0,78,0,0,0,12,0,0,0,44,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,51,2,0,16,0,0,0,16,1,0,0,96,0,0,0,40,0,0,0,30,0,0,0,20,0,0,0,48,0,0,0,82,0,0,0,18,0,0,0,18,0,0,0,24,0,0,0,2,0,0,0,16,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,51,2,0,50,1,0,0,246,0,0,0,78,0,0,0,184,0,0,0,8,0,0,0,2,0,0,0,12,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,0,0,0,0,1,0,0,84,0,0,0,26,0,0,0,32,0,0,0,38,0,0,0,20,0,0,0,250,0,0,0,70,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,0,0,0,38,0,0,0,84,0,0,0,26,0,0,0,32,0,0,0,32,0,0,0,20,0,0,0,250,0,0,0,14,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,0,0,0,48,0,0,0,84,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,1,0,0,178,0,0,0,62,0,0,0,10,0,0,0,12,0,0,0,18,0,0,0,4,0,0,0,180,0,0,0,106,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,12,0,0,0,2,0,0,0,10,0,0,0,2,0,0,0,26,0,0,0,106,0,0,0,2,0,0,0,2,0,0,0,4,0,0,0,8,0,0,0,8,0,0,0,18,0,0,0,8,0,0,0,64,1,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,12,0,0,0,2,0,0,0,10,0,0,0,2,0,0,0,26,0,0,0,106,0,0,0,2,0,0,0,2,0,0,0,4,0,0,0,8,0,0,0,8,0,0,0,18,0,0,0,8,0,0,0,64,1,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,0,0,0,234,0,0,0,84,0,0,0,26,0,0,0,32,0,0,0,32,0,0,0,20,0,0,0,250,0,0,0,14,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,0,0,0,130,0,0,0,84,0,0,0,26,0,0,0,32,0,0,0,32,0,0,0,20,0,0,0,250,0,0,0,14,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,0,0,0,6,1,0,0,4,0,0,0,2,0,0,0,8,0,0,0,94,0,0,0,10,0,0,0,60,0,0,0,64,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,210,0,0,0,54,1,0,0,84,0,0,0,30,0,0,0,16,0,0,0,42,0,0,0,18,0,0,0,8,1,0,0,58,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,83,116,57,116,121,112,101,95,105,110,102,111,0,0,0,0,83,116,57,101,120,99,101,112,116,105,111,110,0,0,0,0,83,116,57,98,97,100,95,97,108,108,111,99,0,0,0,0,83,116,56,98,97,100,95,99,97,115,116,0,0,0,0,0,83,116,49,51,114,117,110,116,105,109,101,95,101,114,114,111,114,0,0,0,0,0,0,0,83,116,49,50,108,101,110,103,116,104,95,101,114,114,111,114,0,0,0,0,0,0,0,0,83,116,49,49,108,111,103,105,99,95,101,114,114,111,114,0,78,83,116,51,95,95,49,57,116,105,109,101,95,98,97,115,101,69,0,0,0,0,0,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,78,83,116,51,95,95,49,57,98,97,115,105,99,95,105,111,115,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,57,98,97,115,105,99,95,105,111,115,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,112,117,116,73,119,69,69,0,0,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,112,117,116,73,99,69,69,0,0,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,103,101,116,73,119,69,69,0,0,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,103,101,116,73,99,69,69,0,0,0,78,83,116,51,95,95,49,56,116,105,109,101,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,0,78,83,116,51,95,95,49,56,116,105,109,101,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,0,78,83,116,51,95,95,49,56,116,105,109,101,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,0,78,83,116,51,95,95,49,56,116,105,109,101,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,0,78,83,116,51,95,95,49,56,110,117,109,112,117,110,99,116,73,119,69,69,0,0,0,0,78,83,116,51,95,95,49,56,110,117,109,112,117,110,99,116,73,99,69,69,0,0,0,0,78,83,116,51,95,95,49,56,109,101,115,115,97,103,101,115,73,119,69,69,0,0,0,0,78,83,116,51,95,95,49,56,109,101,115,115,97,103,101,115,73,99,69,69,0,0,0,0,78,83,116,51,95,95,49,56,105,111,115,95,98,97,115,101,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,56,105,111,115,95,98,97,115,101,55,102,97,105,108,117,114,101,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,55,110,117,109,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,55,110,117,109,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,55,110,117,109,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,55,110,117,109,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,55,99,111,108,108,97,116,101,73,119,69,69,0,0,0,0,0,78,83,116,51,95,95,49,55,99,111,108,108,97,116,101,73,99,69,69,0,0,0,0,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,119,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,99,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,68,115,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,0,0,0,0,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,68,105,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,0,0,0,0,0,78,83,116,51,95,95,49,54,108,111,99,97,108,101,53,102,97,99,101,116,69,0,0,0,78,83,116,51,95,95,49,54,108,111,99,97,108,101,53,95,95,105,109,112,69,0,0,0,78,83,116,51,95,95,49,53,99,116,121,112,101,73,119,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,53,99,116,121,112,101,73,99,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,50,48,95,95,116,105,109,101,95,103,101,116,95,99,95,115,116,111,114,97,103,101,73,119,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,50,48,95,95,116,105,109,101,95,103,101,116,95,99,95,115,116,111,114,97,103,101,73,99,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,57,95,95,105,111,115,116,114,101,97,109,95,99,97,116,101,103,111,114,121,69,0,0,0,78,83,116,51,95,95,49,49,55,95,95,119,105,100,101,110,95,102,114,111,109,95,117,116,102,56,73,76,106,51,50,69,69,69,0,0,0,0,0,0,78,83,116,51,95,95,49,49,54,95,95,110,97,114,114,111,119,95,116,111,95,117,116,102,56,73,76,106,51,50,69,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,53,98,97,115,105,99,95,115,116,114,101,97,109,98,117,102,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,53,98,97,115,105,99,95,115,116,114,101,97,109,98,117,102,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,52,101,114,114,111,114,95,99,97,116,101,103,111,114,121,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,52,95,95,115,104,97,114,101,100,95,99,111,117,110,116,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,52,95,95,110,117,109,95,112,117,116,95,98,97,115,101,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,52,95,95,110,117,109,95,103,101,116,95,98,97,115,101,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,51,109,101,115,115,97,103,101,115,95,98,97,115,101,69,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,111,115,116,114,101,97,109,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,111,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,105,115,116,114,101,97,109,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,105,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,0,78,83,116,51,95,95,49,49,50,115,121,115,116,101,109,95,101,114,114,111,114,69,0,0,78,83,116,51,95,95,49,49,50,99,111,100,101,99,118,116,95,98,97,115,101,69,0,0,78,83,116,51,95,95,49,49,50,95,95,100,111,95,109,101,115,115,97,103,101,69,0,0,78,83,116,51,95,95,49,49,49,95,95,115,116,100,111,117,116,98,117,102,73,119,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,49,95,95,115,116,100,111,117,116,98,117,102,73,99,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,112,117,116,73,119,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,112,117,116,73,99,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,103,101,116,73,119,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,103,101,116,73,99,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,119,76,98,49,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,119,76,98,48,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,99,76,98,49,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,99,76,98,48,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,95,98,97,115,101,69,0,0,0,0,78,83,116,51,95,95,49,49,48,99,116,121,112,101,95,98,97,115,101,69,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,116,105,109,101,95,112,117,116,69,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,115,116,100,105,110,98,117,102,73,119,69,69,0,78,83,116,51,95,95,49,49,48,95,95,115,116,100,105,110,98,117,102,73,99,69,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,49,95,95,118,109,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,0,0,0,0,0,88,34,2,0,0,0,0,0,104,34,2,0,0,0,0,0,120,34,2,0,8,46,2,0,0,0,0,0,0,0,0,0,136,34,2,0,8,46,2,0,0,0,0,0,0,0,0,0,152,34,2,0,8,46,2,0,0,0,0,0,0,0,0,0,176,34,2,0,80,46,2,0,0,0,0,0,0,0,0,0,200,34,2,0,8,46,2,0,0,0,0,0,0,0,0,0,216,34,2,0,136,31,2,0,240,34,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,16,51,2,0,0,0,0,0,136,31,2,0,56,35,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,24,51,2,0,0,0,0,0,136,31,2,0,128,35,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,32,51,2,0,0,0,0,0,136,31,2,0,200,35,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,40,51,2,0,0,0,0,0,0,0,0,0,16,36,2,0,88,48,2,0,0,0,0,0,0,0,0,0,64,36,2,0,88,48,2,0,0,0,0,0,136,31,2,0,112,36,2,0,0,0,0,0,1,0,0,0,80,50,2,0,0,0,0,0,136,31,2,0,136,36,2,0,0,0,0,0,1,0,0,0,80,50,2,0,0,0,0,0,136,31,2,0,160,36,2,0,0,0,0,0,1,0,0,0,88,50,2,0,0,0,0,0,136,31,2,0,184,36,2,0,0,0,0,0,1,0,0,0,88,50,2,0,0,0,0,0,136,31,2,0,208,36,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,192,51,2,0,0,8,0,0,136,31,2,0,24,37,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,192,51,2,0,0,8,0,0,136,31,2,0,96,37,2,0,0,0,0,0,3,0,0,0,144,49,2,0,2,0,0,0,96,46,2,0,2,0,0,0,240,49,2,0,0,8,0,0,136,31,2,0,168,37,2,0,0,0,0,0,3,0,0,0,144,49,2,0,2,0,0,0,96,46,2,0,2,0,0,0,248,49,2,0,0,8,0,0,0,0,0,0,240,37,2,0,144,49,2,0,0,0,0,0])
.concat([0,0,0,0,8,38,2,0,144,49,2,0,0,0,0,0,136,31,2,0,32,38,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,96,50,2,0,2,0,0,0,136,31,2,0,56,38,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,96,50,2,0,2,0,0,0,0,0,0,0,80,38,2,0,0,0,0,0,104,38,2,0,200,50,2,0,0,0,0,0,136,31,2,0,136,38,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,8,47,2,0,0,0,0,0,136,31,2,0,208,38,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,32,47,2,0,0,0,0,0,136,31,2,0,24,39,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,56,47,2,0,0,0,0,0,136,31,2,0,96,39,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,80,47,2,0,0,0,0,0,0,0,0,0,168,39,2,0,144,49,2,0,0,0,0,0,0,0,0,0,192,39,2,0,144,49,2,0,0,0,0,0,136,31,2,0,216,39,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,216,50,2,0,2,0,0,0,136,31,2,0,0,40,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,216,50,2,0,2,0,0,0,136,31,2,0,40,40,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,216,50,2,0,2,0,0,0,136,31,2,0,80,40,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,216,50,2,0,2,0,0,0,0,0,0,0,120,40,2,0,72,50,2,0,0,0,0,0,0,0,0,0,144,40,2,0,144,49,2,0,0,0,0,0,136,31,2,0,168,40,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,184,51,2,0,2,0,0,0,136,31,2,0,192,40,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,184,51,2,0,2,0,0,0,0,0,0,0,216,40,2,0,0,0,0,0,0,41,2,0,0,0,0,0,40,41,2,0,224,50,2,0,0,0,0,0,0,0,0,0,72,41,2,0,112,49,2,0,0,0,0,0,0,0,0,0,112,41,2,0,112,49,2,0,0,0,0,0,0,0,0,0,152,41,2,0,0,0,0,0,208,41,2,0,0,0,0,0,8,42,2,0,0,0,0,0,40,42,2,0,0,0,0,0,72,42,2,0,0,0,0,0,104,42,2,0,0,0,0,0,136,42,2,0,136,31,2,0,160,42,2,0,0,0,0,0,1,0,0,0,232,46,2,0,3,244,255,255,136,31,2,0,208,42,2,0,0,0,0,0,1,0,0,0,248,46,2,0,3,244,255,255,136,31,2,0,0,43,2,0,0,0,0,0,1,0,0,0,232,46,2,0,3,244,255,255,136,31,2,0,48,43,2,0,0,0,0,0,1,0,0,0,248,46,2,0,3,244,255,255,0,0,0,0,96,43,2,0,48,46,2,0,0,0,0,0,0,0,0,0,120,43,2,0,0,0,0,0,144,43,2,0,64,50,2,0,0,0,0,0,0,0,0,0,168,43,2,0,48,50,2,0,0,0,0,0,0,0,0,0,200,43,2,0,56,50,2,0,0,0,0,0,0,0,0,0,232,43,2,0,0,0,0,0,8,44,2,0,0,0,0,0,40,44,2,0,0,0,0,0,72,44,2,0,136,31,2,0,104,44,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,176,51,2,0,2,0,0,0,136,31,2,0,136,44,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,176,51,2,0,2,0,0,0,136,31,2,0,168,44,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,176,51,2,0,2,0,0,0,136,31,2,0,200,44,2,0,0,0,0,0,2,0,0,0,144,49,2,0,2,0,0,0,176,51,2,0,2,0,0,0,0,0,0,0,232,44,2,0,0,0,0,0,0,45,2,0,0,0,0,0,24,45,2,0,0,0,0,0,48,45,2,0,48,50,2,0,0,0,0,0,0,0,0,0,72,45,2,0,56,50,2,0,0,0,0,0,0,0,0,0,96,45,2,0,8,52,2,0,0,0,0,0,0,0,0,0,136,45,2,0,8,52,2,0,0,0,0,0,0,0,0,0,176,45,2,0,24,52,2,0,0,0,0,0,0,0,0,0,216,45,2,0,0,46,2,0,0,0,0,0,48,49,50,51,52,53,54,55,56,57,97,98,99,100,101,102,65,66,67,68,69,70,120,88,43,45,112,80,105,73,110,78,0,0,0,0,0,0,0,0,33,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,20,0,0,0,0,0,0,0,176,4,0,0,0,0,0,0,44,1,0,0,0,0,0,0,96,9,0,0,0,0,0,0,88,2,0,0,0,0,0,0,50,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,64,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,25,0,0,0,0,0,0,0,18,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,25,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,1,0,0,0,3,0,0,0,7,0,0,0,1,0,0,0,4,0,0,0,5,0,0,0,1,0,0,0,6,0,0,0,10,0,0,0,1,0,0,0,4,0,0,0,7,0,0,0,1,0,0,0,6,0,0,0,7,0,0,0,1,0,0,0,7,0,0,0,9,0,0,0,1,0,0,0,8,0,0,0,14,0,0,0,1,0,0,0,6,0,0,0,11,0,0,0,1,0,0,0,4,0,0,0,12,0,0,0,1,0,0,0,8,0,0,0,12,0,0,0,160,14,2,0,176,16,2,0,0,0,0,0,152,14,2,0,0,0,0,0,176,12,2,0,248,9,2,0,0,0,0,0,160,14,2,0,176,7,2,0,0,0,0,0,160,14,2,0,224,6,2,0,0,0,0,0,200,5,2,0,248,9,2,0,0,0,0,0,32,5,2,0,176,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0])
, "i8", ALLOC_NONE, Runtime.GLOBAL_BASE)
var tempDoublePtr = Runtime.alignMemory(allocate(12, "i8", ALLOC_STATIC), 8);
assert(tempDoublePtr % 8 == 0);
function copyTempFloat(ptr) { // functions, because inlining this code increases code size too much
  HEAP8[tempDoublePtr] = HEAP8[ptr];
  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];
  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];
  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];
}
function copyTempDouble(ptr) {
  HEAP8[tempDoublePtr] = HEAP8[ptr];
  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];
  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];
  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];
  HEAP8[tempDoublePtr+4] = HEAP8[ptr+4];
  HEAP8[tempDoublePtr+5] = HEAP8[ptr+5];
  HEAP8[tempDoublePtr+6] = HEAP8[ptr+6];
  HEAP8[tempDoublePtr+7] = HEAP8[ptr+7];
}
  function ___gxx_personality_v0() {
    }
  function _emscripten_set_main_loop(func, fps, simulateInfiniteLoop) {
      Module['noExitRuntime'] = true;
      Browser.mainLoop.runner = function Browser_mainLoop_runner() {
        if (ABORT) return;
        if (Browser.mainLoop.queue.length > 0) {
          var start = Date.now();
          var blocker = Browser.mainLoop.queue.shift();
          blocker.func(blocker.arg);
          if (Browser.mainLoop.remainingBlockers) {
            var remaining = Browser.mainLoop.remainingBlockers;
            var next = remaining%1 == 0 ? remaining-1 : Math.floor(remaining);
            if (blocker.counted) {
              Browser.mainLoop.remainingBlockers = next;
            } else {
              // not counted, but move the progress along a tiny bit
              next = next + 0.5; // do not steal all the next one's progress
              Browser.mainLoop.remainingBlockers = (8*remaining + next)/9;
            }
          }
          console.log('main loop blocker "' + blocker.name + '" took ' + (Date.now() - start) + ' ms'); //, left: ' + Browser.mainLoop.remainingBlockers);
          Browser.mainLoop.updateStatus();
          setTimeout(Browser.mainLoop.runner, 0);
          return;
        }
        if (Browser.mainLoop.shouldPause) {
          // catch pauses from non-main loop sources
          Browser.mainLoop.paused = true;
          Browser.mainLoop.shouldPause = false;
          return;
        }
        if (Module['preMainLoop']) {
          Module['preMainLoop']();
        }
        try {
          Runtime.dynCall('v', func);
        } catch (e) {
          if (e instanceof ExitStatus) {
            return;
          } else {
            if (e && typeof e === 'object' && e.stack) Module.printErr('exception thrown: ' + [e, e.stack]);
            throw e;
          }
        }
        if (Module['postMainLoop']) {
          Module['postMainLoop']();
        }
        if (Browser.mainLoop.shouldPause) {
          // catch pauses from the main loop itself
          Browser.mainLoop.paused = true;
          Browser.mainLoop.shouldPause = false;
          return;
        }
        Browser.mainLoop.scheduler();
      }
      if (fps && fps > 0) {
        Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler() {
          setTimeout(Browser.mainLoop.runner, 1000/fps); // doing this each time means that on exception, we stop
        }
      } else {
        Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler() {
          Browser.requestAnimationFrame(Browser.mainLoop.runner);
        }
      }
      Browser.mainLoop.scheduler();
      if (simulateInfiniteLoop) {
        throw 'SimulateInfiniteLoop';
      }
    }
  var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};
  var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};
  var ___errno_state=0;function ___setErrNo(value) {
      // For convenient setting and returning of errno.
      HEAP32[((___errno_state)>>2)]=value
      return value;
    }
  var PATH={splitPath:function (filename) {
        var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
        return splitPathRe.exec(filename).slice(1);
      },normalizeArray:function (parts, allowAboveRoot) {
        // if the path tries to go above the root, `up` ends up > 0
        var up = 0;
        for (var i = parts.length - 1; i >= 0; i--) {
          var last = parts[i];
          if (last === '.') {
            parts.splice(i, 1);
          } else if (last === '..') {
            parts.splice(i, 1);
            up++;
          } else if (up) {
            parts.splice(i, 1);
            up--;
          }
        }
        // if the path is allowed to go above the root, restore leading ..s
        if (allowAboveRoot) {
          for (; up--; up) {
            parts.unshift('..');
          }
        }
        return parts;
      },normalize:function (path) {
        var isAbsolute = path.charAt(0) === '/',
            trailingSlash = path.substr(-1) === '/';
        // Normalize the path
        path = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), !isAbsolute).join('/');
        if (!path && !isAbsolute) {
          path = '.';
        }
        if (path && trailingSlash) {
          path += '/';
        }
        return (isAbsolute ? '/' : '') + path;
      },dirname:function (path) {
        var result = PATH.splitPath(path),
            root = result[0],
            dir = result[1];
        if (!root && !dir) {
          // No dirname whatsoever
          return '.';
        }
        if (dir) {
          // It has a dirname, strip trailing slash
          dir = dir.substr(0, dir.length - 1);
        }
        return root + dir;
      },basename:function (path) {
        // EMSCRIPTEN return '/'' for '/', not an empty string
        if (path === '/') return '/';
        var lastSlash = path.lastIndexOf('/');
        if (lastSlash === -1) return path;
        return path.substr(lastSlash+1);
      },extname:function (path) {
        return PATH.splitPath(path)[3];
      },join:function () {
        var paths = Array.prototype.slice.call(arguments, 0);
        return PATH.normalize(paths.join('/'));
      },join2:function (l, r) {
        return PATH.normalize(l + '/' + r);
      },resolve:function () {
        var resolvedPath = '',
          resolvedAbsolute = false;
        for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
          var path = (i >= 0) ? arguments[i] : FS.cwd();
          // Skip empty and invalid entries
          if (typeof path !== 'string') {
            throw new TypeError('Arguments to path.resolve must be strings');
          } else if (!path) {
            continue;
          }
          resolvedPath = path + '/' + resolvedPath;
          resolvedAbsolute = path.charAt(0) === '/';
        }
        // At this point the path should be resolved to a full absolute path, but
        // handle relative paths to be safe (might happen when process.cwd() fails)
        resolvedPath = PATH.normalizeArray(resolvedPath.split('/').filter(function(p) {
          return !!p;
        }), !resolvedAbsolute).join('/');
        return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
      },relative:function (from, to) {
        from = PATH.resolve(from).substr(1);
        to = PATH.resolve(to).substr(1);
        function trim(arr) {
          var start = 0;
          for (; start < arr.length; start++) {
            if (arr[start] !== '') break;
          }
          var end = arr.length - 1;
          for (; end >= 0; end--) {
            if (arr[end] !== '') break;
          }
          if (start > end) return [];
          return arr.slice(start, end - start + 1);
        }
        var fromParts = trim(from.split('/'));
        var toParts = trim(to.split('/'));
        var length = Math.min(fromParts.length, toParts.length);
        var samePartsLength = length;
        for (var i = 0; i < length; i++) {
          if (fromParts[i] !== toParts[i]) {
            samePartsLength = i;
            break;
          }
        }
        var outputParts = [];
        for (var i = samePartsLength; i < fromParts.length; i++) {
          outputParts.push('..');
        }
        outputParts = outputParts.concat(toParts.slice(samePartsLength));
        return outputParts.join('/');
      }};
  var TTY={ttys:[],init:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // currently, FS.init does not distinguish if process.stdin is a file or TTY
        //   // device, it always assumes it's a TTY device. because of this, we're forcing
        //   // process.stdin to UTF8 encoding to at least make stdin reading compatible
        //   // with text files until FS.init can be refactored.
        //   process['stdin']['setEncoding']('utf8');
        // }
      },shutdown:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // inolen: any idea as to why node -e 'process.stdin.read()' wouldn't exit immediately (with process.stdin being a tty)?
        //   // isaacs: because now it's reading from the stream, you've expressed interest in it, so that read() kicks off a _read() which creates a ReadReq operation
        //   // inolen: I thought read() in that case was a synchronous operation that just grabbed some amount of buffered data if it exists?
        //   // isaacs: it is. but it also triggers a _read() call, which calls readStart() on the handle
        //   // isaacs: do process.stdin.pause() and i'd think it'd probably close the pending call
        //   process['stdin']['pause']();
        // }
      },register:function (dev, ops) {
        TTY.ttys[dev] = { input: [], output: [], ops: ops };
        FS.registerDevice(dev, TTY.stream_ops);
      },stream_ops:{open:function (stream) {
          var tty = TTY.ttys[stream.node.rdev];
          if (!tty) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          stream.tty = tty;
          stream.seekable = false;
        },close:function (stream) {
          // flush any pending line data
          if (stream.tty.output.length) {
            stream.tty.ops.put_char(stream.tty, 10);
          }
        },read:function (stream, buffer, offset, length, pos /* ignored */) {
          if (!stream.tty || !stream.tty.ops.get_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          var bytesRead = 0;
          for (var i = 0; i < length; i++) {
            var result;
            try {
              result = stream.tty.ops.get_char(stream.tty);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            if (result === undefined && bytesRead === 0) {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
            if (result === null || result === undefined) break;
            bytesRead++;
            buffer[offset+i] = result;
          }
          if (bytesRead) {
            stream.node.timestamp = Date.now();
          }
          return bytesRead;
        },write:function (stream, buffer, offset, length, pos) {
          if (!stream.tty || !stream.tty.ops.put_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          for (var i = 0; i < length; i++) {
            try {
              stream.tty.ops.put_char(stream.tty, buffer[offset+i]);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
          }
          if (length) {
            stream.node.timestamp = Date.now();
          }
          return i;
        }},default_tty_ops:{get_char:function (tty) {
          if (!tty.input.length) {
            var result = null;
            if (ENVIRONMENT_IS_NODE) {
              result = process['stdin']['read']();
              if (!result) {
                if (process['stdin']['_readableState'] && process['stdin']['_readableState']['ended']) {
                  return null;  // EOF
                }
                return undefined;  // no data available
              }
            } else if (typeof window != 'undefined' &&
              typeof window.prompt == 'function') {
              // Browser.
              result = window.prompt('Input: ');  // returns null on cancel
              if (result !== null) {
                result += '\n';
              }
            } else if (typeof readline == 'function') {
              // Command line.
              result = readline();
              if (result !== null) {
                result += '\n';
              }
            }
            if (!result) {
              return null;
            }
            tty.input = intArrayFromString(result, true);
          }
          return tty.input.shift();
        },put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['print'](tty.output.join(''));
            tty.output = [];
          } else {
            tty.output.push(TTY.utf8.processCChar(val));
          }
        }},default_tty1_ops:{put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['printErr'](tty.output.join(''));
            tty.output = [];
          } else {
            tty.output.push(TTY.utf8.processCChar(val));
          }
        }}};
  var MEMFS={ops_table:null,CONTENT_OWNING:1,CONTENT_FLEXIBLE:2,CONTENT_FIXED:3,mount:function (mount) {
        return MEMFS.createNode(null, '/', 16384 | 0777, 0);
      },createNode:function (parent, name, mode, dev) {
        if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
          // no supported
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (!MEMFS.ops_table) {
          MEMFS.ops_table = {
            dir: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                lookup: MEMFS.node_ops.lookup,
                mknod: MEMFS.node_ops.mknod,
                mknod: MEMFS.node_ops.mknod,
                rename: MEMFS.node_ops.rename,
                unlink: MEMFS.node_ops.unlink,
                rmdir: MEMFS.node_ops.rmdir,
                readdir: MEMFS.node_ops.readdir,
                symlink: MEMFS.node_ops.symlink
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek
              }
            },
            file: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek,
                read: MEMFS.stream_ops.read,
                write: MEMFS.stream_ops.write,
                allocate: MEMFS.stream_ops.allocate,
                mmap: MEMFS.stream_ops.mmap
              }
            },
            link: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                readlink: MEMFS.node_ops.readlink
              },
              stream: {}
            },
            chrdev: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: FS.chrdev_stream_ops
            },
          };
        }
        var node = FS.createNode(parent, name, mode, dev);
        if (FS.isDir(node.mode)) {
          node.node_ops = MEMFS.ops_table.dir.node;
          node.stream_ops = MEMFS.ops_table.dir.stream;
          node.contents = {};
        } else if (FS.isFile(node.mode)) {
          node.node_ops = MEMFS.ops_table.file.node;
          node.stream_ops = MEMFS.ops_table.file.stream;
          node.contents = [];
          node.contentMode = MEMFS.CONTENT_FLEXIBLE;
        } else if (FS.isLink(node.mode)) {
          node.node_ops = MEMFS.ops_table.link.node;
          node.stream_ops = MEMFS.ops_table.link.stream;
        } else if (FS.isChrdev(node.mode)) {
          node.node_ops = MEMFS.ops_table.chrdev.node;
          node.stream_ops = MEMFS.ops_table.chrdev.stream;
        }
        node.timestamp = Date.now();
        // add the new node to the parent
        if (parent) {
          parent.contents[name] = node;
        }
        return node;
      },ensureFlexible:function (node) {
        if (node.contentMode !== MEMFS.CONTENT_FLEXIBLE) {
          var contents = node.contents;
          node.contents = Array.prototype.slice.call(contents);
          node.contentMode = MEMFS.CONTENT_FLEXIBLE;
        }
      },node_ops:{getattr:function (node) {
          var attr = {};
          // device numbers reuse inode numbers.
          attr.dev = FS.isChrdev(node.mode) ? node.id : 1;
          attr.ino = node.id;
          attr.mode = node.mode;
          attr.nlink = 1;
          attr.uid = 0;
          attr.gid = 0;
          attr.rdev = node.rdev;
          if (FS.isDir(node.mode)) {
            attr.size = 4096;
          } else if (FS.isFile(node.mode)) {
            attr.size = node.contents.length;
          } else if (FS.isLink(node.mode)) {
            attr.size = node.link.length;
          } else {
            attr.size = 0;
          }
          attr.atime = new Date(node.timestamp);
          attr.mtime = new Date(node.timestamp);
          attr.ctime = new Date(node.timestamp);
          // NOTE: In our implementation, st_blocks = Math.ceil(st_size/st_blksize),
          //       but this is not required by the standard.
          attr.blksize = 4096;
          attr.blocks = Math.ceil(attr.size / attr.blksize);
          return attr;
        },setattr:function (node, attr) {
          if (attr.mode !== undefined) {
            node.mode = attr.mode;
          }
          if (attr.timestamp !== undefined) {
            node.timestamp = attr.timestamp;
          }
          if (attr.size !== undefined) {
            MEMFS.ensureFlexible(node);
            var contents = node.contents;
            if (attr.size < contents.length) contents.length = attr.size;
            else while (attr.size > contents.length) contents.push(0);
          }
        },lookup:function (parent, name) {
          throw FS.genericErrors[ERRNO_CODES.ENOENT];
        },mknod:function (parent, name, mode, dev) {
          return MEMFS.createNode(parent, name, mode, dev);
        },rename:function (old_node, new_dir, new_name) {
          // if we're overwriting a directory at new_name, make sure it's empty.
          if (FS.isDir(old_node.mode)) {
            var new_node;
            try {
              new_node = FS.lookupNode(new_dir, new_name);
            } catch (e) {
            }
            if (new_node) {
              for (var i in new_node.contents) {
                throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
              }
            }
          }
          // do the internal rewiring
          delete old_node.parent.contents[old_node.name];
          old_node.name = new_name;
          new_dir.contents[new_name] = old_node;
          old_node.parent = new_dir;
        },unlink:function (parent, name) {
          delete parent.contents[name];
        },rmdir:function (parent, name) {
          var node = FS.lookupNode(parent, name);
          for (var i in node.contents) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
          }
          delete parent.contents[name];
        },readdir:function (node) {
          var entries = ['.', '..']
          for (var key in node.contents) {
            if (!node.contents.hasOwnProperty(key)) {
              continue;
            }
            entries.push(key);
          }
          return entries;
        },symlink:function (parent, newname, oldpath) {
          var node = MEMFS.createNode(parent, newname, 0777 | 40960, 0);
          node.link = oldpath;
          return node;
        },readlink:function (node) {
          if (!FS.isLink(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return node.link;
        }},stream_ops:{read:function (stream, buffer, offset, length, position) {
          var contents = stream.node.contents;
          if (position >= contents.length)
            return 0;
          var size = Math.min(contents.length - position, length);
          assert(size >= 0);
          if (size > 8 && contents.subarray) { // non-trivial, and typed array
            buffer.set(contents.subarray(position, position + size), offset);
          } else
          {
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i];
            }
          }
          return size;
        },write:function (stream, buffer, offset, length, position, canOwn) {
          var node = stream.node;
          node.timestamp = Date.now();
          var contents = node.contents;
          if (length && contents.length === 0 && position === 0 && buffer.subarray) {
            // just replace it with the new data
            if (canOwn && offset === 0) {
              node.contents = buffer; // this could be a subarray of Emscripten HEAP, or allocated from some other source.
              node.contentMode = (buffer.buffer === HEAP8.buffer) ? MEMFS.CONTENT_OWNING : MEMFS.CONTENT_FIXED;
            } else {
              node.contents = new Uint8Array(buffer.subarray(offset, offset+length));
              node.contentMode = MEMFS.CONTENT_FIXED;
            }
            return length;
          }
          MEMFS.ensureFlexible(node);
          var contents = node.contents;
          while (contents.length < position) contents.push(0);
          for (var i = 0; i < length; i++) {
            contents[position + i] = buffer[offset + i];
          }
          return length;
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.contents.length;
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          stream.ungotten = [];
          stream.position = position;
          return position;
        },allocate:function (stream, offset, length) {
          MEMFS.ensureFlexible(stream.node);
          var contents = stream.node.contents;
          var limit = offset + length;
          while (limit > contents.length) contents.push(0);
        },mmap:function (stream, buffer, offset, length, position, prot, flags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          var ptr;
          var allocated;
          var contents = stream.node.contents;
          // Only make a new copy when MAP_PRIVATE is specified.
          if ( !(flags & 2) &&
                (contents.buffer === buffer || contents.buffer === buffer.buffer) ) {
            // We can't emulate MAP_SHARED when the file is not backed by the buffer
            // we're mapping to (e.g. the HEAP buffer).
            allocated = false;
            ptr = contents.byteOffset;
          } else {
            // Try to avoid unnecessary slices.
            if (position > 0 || position + length < contents.length) {
              if (contents.subarray) {
                contents = contents.subarray(position, position + length);
              } else {
                contents = Array.prototype.slice.call(contents, position, position + length);
              }
            }
            allocated = true;
            ptr = _malloc(length);
            if (!ptr) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOMEM);
            }
            buffer.set(contents, ptr);
          }
          return { ptr: ptr, allocated: allocated };
        }}};
  var IDBFS={dbs:{},indexedDB:function () {
        return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
      },DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",mount:function (mount) {
        return MEMFS.mount.apply(null, arguments);
      },syncfs:function (mount, populate, callback) {
        IDBFS.getLocalSet(mount, function(err, local) {
          if (err) return callback(err);
          IDBFS.getRemoteSet(mount, function(err, remote) {
            if (err) return callback(err);
            var src = populate ? remote : local;
            var dst = populate ? local : remote;
            IDBFS.reconcile(src, dst, callback);
          });
        });
      },reconcile:function (src, dst, callback) {
        var total = 0;
        var create = {};
        for (var key in src.files) {
          if (!src.files.hasOwnProperty(key)) continue;
          var e = src.files[key];
          var e2 = dst.files[key];
          if (!e2 || e.timestamp > e2.timestamp) {
            create[key] = e;
            total++;
          }
        }
        var remove = {};
        for (var key in dst.files) {
          if (!dst.files.hasOwnProperty(key)) continue;
          var e = dst.files[key];
          var e2 = src.files[key];
          if (!e2) {
            remove[key] = e;
            total++;
          }
        }
        if (!total) {
          // early out
          return callback(null);
        }
        var completed = 0;
        function done(err) {
          if (err) return callback(err);
          if (++completed >= total) {
            return callback(null);
          }
        };
        // create a single transaction to handle and IDB reads / writes we'll need to do
        var db = src.type === 'remote' ? src.db : dst.db;
        var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readwrite');
        transaction.onerror = function transaction_onerror() { callback(this.error); };
        var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
        for (var path in create) {
          if (!create.hasOwnProperty(path)) continue;
          var entry = create[path];
          if (dst.type === 'local') {
            // save file to local
            try {
              if (FS.isDir(entry.mode)) {
                FS.mkdir(path, entry.mode);
              } else if (FS.isFile(entry.mode)) {
                var stream = FS.open(path, 'w+', 0666);
                FS.write(stream, entry.contents, 0, entry.contents.length, 0, true /* canOwn */);
                FS.close(stream);
              }
              done(null);
            } catch (e) {
              return done(e);
            }
          } else {
            // save file to IDB
            var req = store.put(entry, path);
            req.onsuccess = function req_onsuccess() { done(null); };
            req.onerror = function req_onerror() { done(this.error); };
          }
        }
        for (var path in remove) {
          if (!remove.hasOwnProperty(path)) continue;
          var entry = remove[path];
          if (dst.type === 'local') {
            // delete file from local
            try {
              if (FS.isDir(entry.mode)) {
                // TODO recursive delete?
                FS.rmdir(path);
              } else if (FS.isFile(entry.mode)) {
                FS.unlink(path);
              }
              done(null);
            } catch (e) {
              return done(e);
            }
          } else {
            // delete file from IDB
            var req = store.delete(path);
            req.onsuccess = function req_onsuccess() { done(null); };
            req.onerror = function req_onerror() { done(this.error); };
          }
        }
      },getLocalSet:function (mount, callback) {
        var files = {};
        function isRealDir(p) {
          return p !== '.' && p !== '..';
        };
        function toAbsolute(root) {
          return function(p) {
            return PATH.join2(root, p);
          }
        };
        var check = FS.readdir(mount.mountpoint)
          .filter(isRealDir)
          .map(toAbsolute(mount.mountpoint));
        while (check.length) {
          var path = check.pop();
          var stat, node;
          try {
            var lookup = FS.lookupPath(path);
            node = lookup.node;
            stat = FS.stat(path);
          } catch (e) {
            return callback(e);
          }
          if (FS.isDir(stat.mode)) {
            check.push.apply(check, FS.readdir(path)
              .filter(isRealDir)
              .map(toAbsolute(path)));
            files[path] = { mode: stat.mode, timestamp: stat.mtime };
          } else if (FS.isFile(stat.mode)) {
            files[path] = { contents: node.contents, mode: stat.mode, timestamp: stat.mtime };
          } else {
            return callback(new Error('node type not supported'));
          }
        }
        return callback(null, { type: 'local', files: files });
      },getDB:function (name, callback) {
        // look it up in the cache
        var db = IDBFS.dbs[name];
        if (db) {
          return callback(null, db);
        }
        var req;
        try {
          req = IDBFS.indexedDB().open(name, IDBFS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        req.onupgradeneeded = function req_onupgradeneeded() {
          db = req.result;
          db.createObjectStore(IDBFS.DB_STORE_NAME);
        };
        req.onsuccess = function req_onsuccess() {
          db = req.result;
          // add to the cache
          IDBFS.dbs[name] = db;
          callback(null, db);
        };
        req.onerror = function req_onerror() {
          callback(this.error);
        };
      },getRemoteSet:function (mount, callback) {
        var files = {};
        IDBFS.getDB(mount.mountpoint, function(err, db) {
          if (err) return callback(err);
          var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readonly');
          transaction.onerror = function transaction_onerror() { callback(this.error); };
          var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
          store.openCursor().onsuccess = function store_openCursor_onsuccess(event) {
            var cursor = event.target.result;
            if (!cursor) {
              return callback(null, { type: 'remote', db: db, files: files });
            }
            files[cursor.key] = cursor.value;
            cursor.continue();
          };
        });
      }};
  var NODEFS={isWindows:false,staticInit:function () {
        NODEFS.isWindows = !!process.platform.match(/^win/);
      },mount:function (mount) {
        assert(ENVIRONMENT_IS_NODE);
        return NODEFS.createNode(null, '/', NODEFS.getMode(mount.opts.root), 0);
      },createNode:function (parent, name, mode, dev) {
        if (!FS.isDir(mode) && !FS.isFile(mode) && !FS.isLink(mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node = FS.createNode(parent, name, mode);
        node.node_ops = NODEFS.node_ops;
        node.stream_ops = NODEFS.stream_ops;
        return node;
      },getMode:function (path) {
        var stat;
        try {
          stat = fs.lstatSync(path);
          if (NODEFS.isWindows) {
            // On Windows, directories return permission bits 'rw-rw-rw-', even though they have 'rwxrwxrwx', so 
            // propagate write bits to execute bits.
            stat.mode = stat.mode | ((stat.mode & 146) >> 1);
          }
        } catch (e) {
          if (!e.code) throw e;
          throw new FS.ErrnoError(ERRNO_CODES[e.code]);
        }
        return stat.mode;
      },realPath:function (node) {
        var parts = [];
        while (node.parent !== node) {
          parts.push(node.name);
          node = node.parent;
        }
        parts.push(node.mount.opts.root);
        parts.reverse();
        return PATH.join.apply(null, parts);
      },flagsToPermissionStringMap:{0:"r",1:"r+",2:"r+",64:"r",65:"r+",66:"r+",129:"rx+",193:"rx+",514:"w+",577:"w",578:"w+",705:"wx",706:"wx+",1024:"a",1025:"a",1026:"a+",1089:"a",1090:"a+",1153:"ax",1154:"ax+",1217:"ax",1218:"ax+",4096:"rs",4098:"rs+"},flagsToPermissionString:function (flags) {
        if (flags in NODEFS.flagsToPermissionStringMap) {
          return NODEFS.flagsToPermissionStringMap[flags];
        } else {
          return flags;
        }
      },node_ops:{getattr:function (node) {
          var path = NODEFS.realPath(node);
          var stat;
          try {
            stat = fs.lstatSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          // node.js v0.10.20 doesn't report blksize and blocks on Windows. Fake them with default blksize of 4096.
          // See http://support.microsoft.com/kb/140365
          if (NODEFS.isWindows && !stat.blksize) {
            stat.blksize = 4096;
          }
          if (NODEFS.isWindows && !stat.blocks) {
            stat.blocks = (stat.size+stat.blksize-1)/stat.blksize|0;
          }
          return {
            dev: stat.dev,
            ino: stat.ino,
            mode: stat.mode,
            nlink: stat.nlink,
            uid: stat.uid,
            gid: stat.gid,
            rdev: stat.rdev,
            size: stat.size,
            atime: stat.atime,
            mtime: stat.mtime,
            ctime: stat.ctime,
            blksize: stat.blksize,
            blocks: stat.blocks
          };
        },setattr:function (node, attr) {
          var path = NODEFS.realPath(node);
          try {
            if (attr.mode !== undefined) {
              fs.chmodSync(path, attr.mode);
              // update the common node structure mode as well
              node.mode = attr.mode;
            }
            if (attr.timestamp !== undefined) {
              var date = new Date(attr.timestamp);
              fs.utimesSync(path, date, date);
            }
            if (attr.size !== undefined) {
              fs.truncateSync(path, attr.size);
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },lookup:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          var mode = NODEFS.getMode(path);
          return NODEFS.createNode(parent, name, mode);
        },mknod:function (parent, name, mode, dev) {
          var node = NODEFS.createNode(parent, name, mode, dev);
          // create the backing node for this in the fs root as well
          var path = NODEFS.realPath(node);
          try {
            if (FS.isDir(node.mode)) {
              fs.mkdirSync(path, node.mode);
            } else {
              fs.writeFileSync(path, '', { mode: node.mode });
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          return node;
        },rename:function (oldNode, newDir, newName) {
          var oldPath = NODEFS.realPath(oldNode);
          var newPath = PATH.join2(NODEFS.realPath(newDir), newName);
          try {
            fs.renameSync(oldPath, newPath);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },unlink:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          try {
            fs.unlinkSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },rmdir:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          try {
            fs.rmdirSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },readdir:function (node) {
          var path = NODEFS.realPath(node);
          try {
            return fs.readdirSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },symlink:function (parent, newName, oldPath) {
          var newPath = PATH.join2(NODEFS.realPath(parent), newName);
          try {
            fs.symlinkSync(oldPath, newPath);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },readlink:function (node) {
          var path = NODEFS.realPath(node);
          try {
            return fs.readlinkSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        }},stream_ops:{open:function (stream) {
          var path = NODEFS.realPath(stream.node);
          try {
            if (FS.isFile(stream.node.mode)) {
              stream.nfd = fs.openSync(path, NODEFS.flagsToPermissionString(stream.flags));
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },close:function (stream) {
          try {
            if (FS.isFile(stream.node.mode) && stream.nfd) {
              fs.closeSync(stream.nfd);
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },read:function (stream, buffer, offset, length, position) {
          // FIXME this is terrible.
          var nbuffer = new Buffer(length);
          var res;
          try {
            res = fs.readSync(stream.nfd, nbuffer, 0, length, position);
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          if (res > 0) {
            for (var i = 0; i < res; i++) {
              buffer[offset + i] = nbuffer[i];
            }
          }
          return res;
        },write:function (stream, buffer, offset, length, position) {
          // FIXME this is terrible.
          var nbuffer = new Buffer(buffer.subarray(offset, offset + length));
          var res;
          try {
            res = fs.writeSync(stream.nfd, nbuffer, 0, length, position);
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          return res;
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              try {
                var stat = fs.fstatSync(stream.nfd);
                position += stat.size;
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
              }
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          stream.position = position;
          return position;
        }}};
  var _stdin=allocate(1, "i32*", ALLOC_STATIC);
  var _stdout=allocate(1, "i32*", ALLOC_STATIC);
  var _stderr=allocate(1, "i32*", ALLOC_STATIC);
  function _fflush(stream) {
      // int fflush(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fflush.html
      // we don't currently perform any user-space buffering of data
    }var FS={root:null,mounts:[],devices:[null],streams:[null],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,ErrnoError:null,genericErrors:{},handleFSError:function (e) {
        if (!(e instanceof FS.ErrnoError)) throw e + ' : ' + stackTrace();
        return ___setErrNo(e.errno);
      },lookupPath:function (path, opts) {
        path = PATH.resolve(FS.cwd(), path);
        opts = opts || { recurse_count: 0 };
        if (opts.recurse_count > 8) {  // max recursive lookup of 8
          throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
        }
        // split the path
        var parts = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), false);
        // start at the root
        var current = FS.root;
        var current_path = '/';
        for (var i = 0; i < parts.length; i++) {
          var islast = (i === parts.length-1);
          if (islast && opts.parent) {
            // stop resolving
            break;
          }
          current = FS.lookupNode(current, parts[i]);
          current_path = PATH.join2(current_path, parts[i]);
          // jump to the mount's root node if this is a mountpoint
          if (FS.isMountpoint(current)) {
            current = current.mount.root;
          }
          // follow symlinks
          // by default, lookupPath will not follow a symlink if it is the final path component.
          // setting opts.follow = true will override this behavior.
          if (!islast || opts.follow) {
            var count = 0;
            while (FS.isLink(current.mode)) {
              var link = FS.readlink(current_path);
              current_path = PATH.resolve(PATH.dirname(current_path), link);
              var lookup = FS.lookupPath(current_path, { recurse_count: opts.recurse_count });
              current = lookup.node;
              if (count++ > 40) {  // limit max consecutive symlinks to 40 (SYMLOOP_MAX).
                throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
              }
            }
          }
        }
        return { path: current_path, node: current };
      },getPath:function (node) {
        var path;
        while (true) {
          if (FS.isRoot(node)) {
            var mount = node.mount.mountpoint;
            if (!path) return mount;
            return mount[mount.length-1] !== '/' ? mount + '/' + path : mount + path;
          }
          path = path ? node.name + '/' + path : node.name;
          node = node.parent;
        }
      },hashName:function (parentid, name) {
        var hash = 0;
        for (var i = 0; i < name.length; i++) {
          hash = ((hash << 5) - hash + name.charCodeAt(i)) | 0;
        }
        return ((parentid + hash) >>> 0) % FS.nameTable.length;
      },hashAddNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        node.name_next = FS.nameTable[hash];
        FS.nameTable[hash] = node;
      },hashRemoveNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        if (FS.nameTable[hash] === node) {
          FS.nameTable[hash] = node.name_next;
        } else {
          var current = FS.nameTable[hash];
          while (current) {
            if (current.name_next === node) {
              current.name_next = node.name_next;
              break;
            }
            current = current.name_next;
          }
        }
      },lookupNode:function (parent, name) {
        var err = FS.mayLookup(parent);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        var hash = FS.hashName(parent.id, name);
        for (var node = FS.nameTable[hash]; node; node = node.name_next) {
          var nodeName = node.name;
          if (node.parent.id === parent.id && nodeName === name) {
            return node;
          }
        }
        // if we failed to find it in the cache, call into the VFS
        return FS.lookup(parent, name);
      },createNode:function (parent, name, mode, rdev) {
        if (!FS.FSNode) {
          FS.FSNode = function(parent, name, mode, rdev) {
            this.id = FS.nextInode++;
            this.name = name;
            this.mode = mode;
            this.node_ops = {};
            this.stream_ops = {};
            this.rdev = rdev;
            this.parent = null;
            this.mount = null;
            if (!parent) {
              parent = this;  // root node sets parent to itself
            }
            this.parent = parent;
            this.mount = parent.mount;
            FS.hashAddNode(this);
          };
          // compatibility
          var readMode = 292 | 73;
          var writeMode = 146;
          FS.FSNode.prototype = {};
          // NOTE we must use Object.defineProperties instead of individual calls to
          // Object.defineProperty in order to make closure compiler happy
          Object.defineProperties(FS.FSNode.prototype, {
            read: {
              get: function() { return (this.mode & readMode) === readMode; },
              set: function(val) { val ? this.mode |= readMode : this.mode &= ~readMode; }
            },
            write: {
              get: function() { return (this.mode & writeMode) === writeMode; },
              set: function(val) { val ? this.mode |= writeMode : this.mode &= ~writeMode; }
            },
            isFolder: {
              get: function() { return FS.isDir(this.mode); },
            },
            isDevice: {
              get: function() { return FS.isChrdev(this.mode); },
            },
          });
        }
        return new FS.FSNode(parent, name, mode, rdev);
      },destroyNode:function (node) {
        FS.hashRemoveNode(node);
      },isRoot:function (node) {
        return node === node.parent;
      },isMountpoint:function (node) {
        return node.mounted;
      },isFile:function (mode) {
        return (mode & 61440) === 32768;
      },isDir:function (mode) {
        return (mode & 61440) === 16384;
      },isLink:function (mode) {
        return (mode & 61440) === 40960;
      },isChrdev:function (mode) {
        return (mode & 61440) === 8192;
      },isBlkdev:function (mode) {
        return (mode & 61440) === 24576;
      },isFIFO:function (mode) {
        return (mode & 61440) === 4096;
      },isSocket:function (mode) {
        return (mode & 49152) === 49152;
      },flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:function (str) {
        var flags = FS.flagModes[str];
        if (typeof flags === 'undefined') {
          throw new Error('Unknown file open mode: ' + str);
        }
        return flags;
      },flagsToPermissionString:function (flag) {
        var accmode = flag & 2097155;
        var perms = ['r', 'w', 'rw'][accmode];
        if ((flag & 512)) {
          perms += 'w';
        }
        return perms;
      },nodePermissions:function (node, perms) {
        if (FS.ignorePermissions) {
          return 0;
        }
        // return 0 if any user, group or owner bits are set.
        if (perms.indexOf('r') !== -1 && !(node.mode & 292)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('w') !== -1 && !(node.mode & 146)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('x') !== -1 && !(node.mode & 73)) {
          return ERRNO_CODES.EACCES;
        }
        return 0;
      },mayLookup:function (dir) {
        return FS.nodePermissions(dir, 'x');
      },mayCreate:function (dir, name) {
        try {
          var node = FS.lookupNode(dir, name);
          return ERRNO_CODES.EEXIST;
        } catch (e) {
        }
        return FS.nodePermissions(dir, 'wx');
      },mayDelete:function (dir, name, isdir) {
        var node;
        try {
          node = FS.lookupNode(dir, name);
        } catch (e) {
          return e.errno;
        }
        var err = FS.nodePermissions(dir, 'wx');
        if (err) {
          return err;
        }
        if (isdir) {
          if (!FS.isDir(node.mode)) {
            return ERRNO_CODES.ENOTDIR;
          }
          if (FS.isRoot(node) || FS.getPath(node) === FS.cwd()) {
            return ERRNO_CODES.EBUSY;
          }
        } else {
          if (FS.isDir(node.mode)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return 0;
      },mayOpen:function (node, flags) {
        if (!node) {
          return ERRNO_CODES.ENOENT;
        }
        if (FS.isLink(node.mode)) {
          return ERRNO_CODES.ELOOP;
        } else if (FS.isDir(node.mode)) {
          if ((flags & 2097155) !== 0 ||  // opening for write
              (flags & 512)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return FS.nodePermissions(node, FS.flagsToPermissionString(flags));
      },MAX_OPEN_FDS:4096,nextfd:function (fd_start, fd_end) {
        fd_start = fd_start || 1;
        fd_end = fd_end || FS.MAX_OPEN_FDS;
        for (var fd = fd_start; fd <= fd_end; fd++) {
          if (!FS.streams[fd]) {
            return fd;
          }
        }
        throw new FS.ErrnoError(ERRNO_CODES.EMFILE);
      },getStream:function (fd) {
        return FS.streams[fd];
      },createStream:function (stream, fd_start, fd_end) {
        if (!FS.FSStream) {
          FS.FSStream = function(){};
          FS.FSStream.prototype = {};
          // compatibility
          Object.defineProperties(FS.FSStream.prototype, {
            object: {
              get: function() { return this.node; },
              set: function(val) { this.node = val; }
            },
            isRead: {
              get: function() { return (this.flags & 2097155) !== 1; }
            },
            isWrite: {
              get: function() { return (this.flags & 2097155) !== 0; }
            },
            isAppend: {
              get: function() { return (this.flags & 1024); }
            }
          });
        }
        if (stream.__proto__) {
          // reuse the object
          stream.__proto__ = FS.FSStream.prototype;
        } else {
          var newStream = new FS.FSStream();
          for (var p in stream) {
            newStream[p] = stream[p];
          }
          stream = newStream;
        }
        var fd = FS.nextfd(fd_start, fd_end);
        stream.fd = fd;
        FS.streams[fd] = stream;
        return stream;
      },closeStream:function (fd) {
        FS.streams[fd] = null;
      },chrdev_stream_ops:{open:function (stream) {
          var device = FS.getDevice(stream.node.rdev);
          // override node's stream ops with the device's
          stream.stream_ops = device.stream_ops;
          // forward the open call
          if (stream.stream_ops.open) {
            stream.stream_ops.open(stream);
          }
        },llseek:function () {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }},major:function (dev) {
        return ((dev) >> 8);
      },minor:function (dev) {
        return ((dev) & 0xff);
      },makedev:function (ma, mi) {
        return ((ma) << 8 | (mi));
      },registerDevice:function (dev, ops) {
        FS.devices[dev] = { stream_ops: ops };
      },getDevice:function (dev) {
        return FS.devices[dev];
      },syncfs:function (populate, callback) {
        if (typeof(populate) === 'function') {
          callback = populate;
          populate = false;
        }
        var completed = 0;
        var total = FS.mounts.length;
        function done(err) {
          if (err) {
            return callback(err);
          }
          if (++completed >= total) {
            callback(null);
          }
        };
        // sync all mounts
        for (var i = 0; i < FS.mounts.length; i++) {
          var mount = FS.mounts[i];
          if (!mount.type.syncfs) {
            done(null);
            continue;
          }
          mount.type.syncfs(mount, populate, done);
        }
      },mount:function (type, opts, mountpoint) {
        var lookup;
        if (mountpoint) {
          lookup = FS.lookupPath(mountpoint, { follow: false });
          mountpoint = lookup.path;  // use the absolute path
        }
        var mount = {
          type: type,
          opts: opts,
          mountpoint: mountpoint,
          root: null
        };
        // create a root node for the fs
        var root = type.mount(mount);
        root.mount = mount;
        mount.root = root;
        // assign the mount info to the mountpoint's node
        if (lookup) {
          lookup.node.mount = mount;
          lookup.node.mounted = true;
          // compatibility update FS.root if we mount to /
          if (mountpoint === '/') {
            FS.root = mount.root;
          }
        }
        // add to our cached list of mounts
        FS.mounts.push(mount);
        return root;
      },lookup:function (parent, name) {
        return parent.node_ops.lookup(parent, name);
      },mknod:function (path, mode, dev) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var err = FS.mayCreate(parent, name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.mknod) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.mknod(parent, name, mode, dev);
      },create:function (path, mode) {
        mode = mode !== undefined ? mode : 0666;
        mode &= 4095;
        mode |= 32768;
        return FS.mknod(path, mode, 0);
      },mkdir:function (path, mode) {
        mode = mode !== undefined ? mode : 0777;
        mode &= 511 | 512;
        mode |= 16384;
        return FS.mknod(path, mode, 0);
      },mkdev:function (path, mode, dev) {
        if (typeof(dev) === 'undefined') {
          dev = mode;
          mode = 0666;
        }
        mode |= 8192;
        return FS.mknod(path, mode, dev);
      },symlink:function (oldpath, newpath) {
        var lookup = FS.lookupPath(newpath, { parent: true });
        var parent = lookup.node;
        var newname = PATH.basename(newpath);
        var err = FS.mayCreate(parent, newname);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.symlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.symlink(parent, newname, oldpath);
      },rename:function (old_path, new_path) {
        var old_dirname = PATH.dirname(old_path);
        var new_dirname = PATH.dirname(new_path);
        var old_name = PATH.basename(old_path);
        var new_name = PATH.basename(new_path);
        // parents must exist
        var lookup, old_dir, new_dir;
        try {
          lookup = FS.lookupPath(old_path, { parent: true });
          old_dir = lookup.node;
          lookup = FS.lookupPath(new_path, { parent: true });
          new_dir = lookup.node;
        } catch (e) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        // need to be part of the same mount
        if (old_dir.mount !== new_dir.mount) {
          throw new FS.ErrnoError(ERRNO_CODES.EXDEV);
        }
        // source must exist
        var old_node = FS.lookupNode(old_dir, old_name);
        // old path should not be an ancestor of the new path
        var relative = PATH.relative(old_path, new_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        // new path should not be an ancestor of the old path
        relative = PATH.relative(new_path, old_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
        }
        // see if the new path already exists
        var new_node;
        try {
          new_node = FS.lookupNode(new_dir, new_name);
        } catch (e) {
          // not fatal
        }
        // early out if nothing needs to change
        if (old_node === new_node) {
          return;
        }
        // we'll need to delete the old entry
        var isdir = FS.isDir(old_node.mode);
        var err = FS.mayDelete(old_dir, old_name, isdir);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        // need delete permissions if we'll be overwriting.
        // need create permissions if new doesn't already exist.
        err = new_node ?
          FS.mayDelete(new_dir, new_name, isdir) :
          FS.mayCreate(new_dir, new_name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!old_dir.node_ops.rename) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(old_node) || (new_node && FS.isMountpoint(new_node))) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        // if we are going to change the parent, check write permissions
        if (new_dir !== old_dir) {
          err = FS.nodePermissions(old_dir, 'w');
          if (err) {
            throw new FS.ErrnoError(err);
          }
        }
        // remove the node from the lookup hash
        FS.hashRemoveNode(old_node);
        // do the underlying fs rename
        try {
          old_dir.node_ops.rename(old_node, new_dir, new_name);
        } catch (e) {
          throw e;
        } finally {
          // add the node back to the hash (in case node_ops.rename
          // changed its name)
          FS.hashAddNode(old_node);
        }
      },rmdir:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, true);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.rmdir) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        parent.node_ops.rmdir(parent, name);
        FS.destroyNode(node);
      },readdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        if (!node.node_ops.readdir) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        return node.node_ops.readdir(node);
      },unlink:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, false);
        if (err) {
          // POSIX says unlink should set EPERM, not EISDIR
          if (err === ERRNO_CODES.EISDIR) err = ERRNO_CODES.EPERM;
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.unlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        parent.node_ops.unlink(parent, name);
        FS.destroyNode(node);
      },readlink:function (path) {
        var lookup = FS.lookupPath(path, { follow: false });
        var link = lookup.node;
        if (!link.node_ops.readlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        return link.node_ops.readlink(link);
      },stat:function (path, dontFollow) {
        var lookup = FS.lookupPath(path, { follow: !dontFollow });
        var node = lookup.node;
        if (!node.node_ops.getattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return node.node_ops.getattr(node);
      },lstat:function (path) {
        return FS.stat(path, true);
      },chmod:function (path, mode, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          mode: (mode & 4095) | (node.mode & ~4095),
          timestamp: Date.now()
        });
      },lchmod:function (path, mode) {
        FS.chmod(path, mode, true);
      },fchmod:function (fd, mode) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chmod(stream.node, mode);
      },chown:function (path, uid, gid, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          timestamp: Date.now()
          // we ignore the uid / gid for now
        });
      },lchown:function (path, uid, gid) {
        FS.chown(path, uid, gid, true);
      },fchown:function (fd, uid, gid) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chown(stream.node, uid, gid);
      },truncate:function (path, len) {
        if (len < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: true });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!FS.isFile(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var err = FS.nodePermissions(node, 'w');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        node.node_ops.setattr(node, {
          size: len,
          timestamp: Date.now()
        });
      },ftruncate:function (fd, len) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        FS.truncate(stream.node, len);
      },utime:function (path, atime, mtime) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        node.node_ops.setattr(node, {
          timestamp: Math.max(atime, mtime)
        });
      },open:function (path, flags, mode, fd_start, fd_end) {
        flags = typeof flags === 'string' ? FS.modeStringToFlags(flags) : flags;
        mode = typeof mode === 'undefined' ? 0666 : mode;
        if ((flags & 64)) {
          mode = (mode & 4095) | 32768;
        } else {
          mode = 0;
        }
        var node;
        if (typeof path === 'object') {
          node = path;
        } else {
          path = PATH.normalize(path);
          try {
            var lookup = FS.lookupPath(path, {
              follow: !(flags & 131072)
            });
            node = lookup.node;
          } catch (e) {
            // ignore
          }
        }
        // perhaps we need to create the node
        if ((flags & 64)) {
          if (node) {
            // if O_CREAT and O_EXCL are set, error out if the node already exists
            if ((flags & 128)) {
              throw new FS.ErrnoError(ERRNO_CODES.EEXIST);
            }
          } else {
            // node doesn't exist, try to create it
            node = FS.mknod(path, mode, 0);
          }
        }
        if (!node) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        // can't truncate a device
        if (FS.isChrdev(node.mode)) {
          flags &= ~512;
        }
        // check permissions
        var err = FS.mayOpen(node, flags);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        // do truncation if necessary
        if ((flags & 512)) {
          FS.truncate(node, 0);
        }
        // we've already handled these, don't pass down to the underlying vfs
        flags &= ~(128 | 512);
        // register the stream with the filesystem
        var stream = FS.createStream({
          node: node,
          path: FS.getPath(node),  // we want the absolute path to the node
          flags: flags,
          seekable: true,
          position: 0,
          stream_ops: node.stream_ops,
          // used by the file family libc calls (fopen, fwrite, ferror, etc.)
          ungotten: [],
          error: false
        }, fd_start, fd_end);
        // call the new stream's open function
        if (stream.stream_ops.open) {
          stream.stream_ops.open(stream);
        }
        if (Module['logReadFiles'] && !(flags & 1)) {
          if (!FS.readFiles) FS.readFiles = {};
          if (!(path in FS.readFiles)) {
            FS.readFiles[path] = 1;
            Module['printErr']('read file: ' + path);
          }
        }
        return stream;
      },close:function (stream) {
        try {
          if (stream.stream_ops.close) {
            stream.stream_ops.close(stream);
          }
        } catch (e) {
          throw e;
        } finally {
          FS.closeStream(stream.fd);
        }
      },llseek:function (stream, offset, whence) {
        if (!stream.seekable || !stream.stream_ops.llseek) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        return stream.stream_ops.llseek(stream, offset, whence);
      },read:function (stream, buffer, offset, length, position) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.read) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        var bytesRead = stream.stream_ops.read(stream, buffer, offset, length, position);
        if (!seeking) stream.position += bytesRead;
        return bytesRead;
      },write:function (stream, buffer, offset, length, position, canOwn) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.write) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        if (stream.flags & 1024) {
          // seek to the end before writing in append mode
          FS.llseek(stream, 0, 2);
        }
        var bytesWritten = stream.stream_ops.write(stream, buffer, offset, length, position, canOwn);
        if (!seeking) stream.position += bytesWritten;
        return bytesWritten;
      },allocate:function (stream, offset, length) {
        if (offset < 0 || length <= 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (!FS.isFile(stream.node.mode) && !FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
        }
        if (!stream.stream_ops.allocate) {
          throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
        }
        stream.stream_ops.allocate(stream, offset, length);
      },mmap:function (stream, buffer, offset, length, position, prot, flags) {
        // TODO if PROT is PROT_WRITE, make sure we have write access
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EACCES);
        }
        if (!stream.stream_ops.mmap) {
          throw new FS.errnoError(ERRNO_CODES.ENODEV);
        }
        return stream.stream_ops.mmap(stream, buffer, offset, length, position, prot, flags);
      },ioctl:function (stream, cmd, arg) {
        if (!stream.stream_ops.ioctl) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTTY);
        }
        return stream.stream_ops.ioctl(stream, cmd, arg);
      },readFile:function (path, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'r';
        opts.encoding = opts.encoding || 'binary';
        var ret;
        var stream = FS.open(path, opts.flags);
        var stat = FS.stat(path);
        var length = stat.size;
        var buf = new Uint8Array(length);
        FS.read(stream, buf, 0, length, 0);
        if (opts.encoding === 'utf8') {
          ret = '';
          var utf8 = new Runtime.UTF8Processor();
          for (var i = 0; i < length; i++) {
            ret += utf8.processCChar(buf[i]);
          }
        } else if (opts.encoding === 'binary') {
          ret = buf;
        } else {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        FS.close(stream);
        return ret;
      },writeFile:function (path, data, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'w';
        opts.encoding = opts.encoding || 'utf8';
        var stream = FS.open(path, opts.flags, opts.mode);
        if (opts.encoding === 'utf8') {
          var utf8 = new Runtime.UTF8Processor();
          var buf = new Uint8Array(utf8.processJSString(data));
          FS.write(stream, buf, 0, buf.length, 0);
        } else if (opts.encoding === 'binary') {
          FS.write(stream, data, 0, data.length, 0);
        } else {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        FS.close(stream);
      },cwd:function () {
        return FS.currentPath;
      },chdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        if (!FS.isDir(lookup.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        var err = FS.nodePermissions(lookup.node, 'x');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        FS.currentPath = lookup.path;
      },createDefaultDirectories:function () {
        FS.mkdir('/tmp');
      },createDefaultDevices:function () {
        // create /dev
        FS.mkdir('/dev');
        // setup /dev/null
        FS.registerDevice(FS.makedev(1, 3), {
          read: function() { return 0; },
          write: function() { return 0; }
        });
        FS.mkdev('/dev/null', FS.makedev(1, 3));
        // setup /dev/tty and /dev/tty1
        // stderr needs to print output using Module['printErr']
        // so we register a second tty just for it.
        TTY.register(FS.makedev(5, 0), TTY.default_tty_ops);
        TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops);
        FS.mkdev('/dev/tty', FS.makedev(5, 0));
        FS.mkdev('/dev/tty1', FS.makedev(6, 0));
        // we're not going to emulate the actual shm device,
        // just create the tmp dirs that reside in it commonly
        FS.mkdir('/dev/shm');
        FS.mkdir('/dev/shm/tmp');
      },createStandardStreams:function () {
        // TODO deprecate the old functionality of a single
        // input / output callback and that utilizes FS.createDevice
        // and instead require a unique set of stream ops
        // by default, we symlink the standard streams to the
        // default tty devices. however, if the standard streams
        // have been overwritten we create a unique device for
        // them instead.
        if (Module['stdin']) {
          FS.createDevice('/dev', 'stdin', Module['stdin']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdin');
        }
        if (Module['stdout']) {
          FS.createDevice('/dev', 'stdout', null, Module['stdout']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdout');
        }
        if (Module['stderr']) {
          FS.createDevice('/dev', 'stderr', null, Module['stderr']);
        } else {
          FS.symlink('/dev/tty1', '/dev/stderr');
        }
        // open default streams for the stdin, stdout and stderr devices
        var stdin = FS.open('/dev/stdin', 'r');
        HEAP32[((_stdin)>>2)]=stdin.fd;
        assert(stdin.fd === 1, 'invalid handle for stdin (' + stdin.fd + ')');
        var stdout = FS.open('/dev/stdout', 'w');
        HEAP32[((_stdout)>>2)]=stdout.fd;
        assert(stdout.fd === 2, 'invalid handle for stdout (' + stdout.fd + ')');
        var stderr = FS.open('/dev/stderr', 'w');
        HEAP32[((_stderr)>>2)]=stderr.fd;
        assert(stderr.fd === 3, 'invalid handle for stderr (' + stderr.fd + ')');
      },ensureErrnoError:function () {
        if (FS.ErrnoError) return;
        FS.ErrnoError = function ErrnoError(errno) {
          this.errno = errno;
          for (var key in ERRNO_CODES) {
            if (ERRNO_CODES[key] === errno) {
              this.code = key;
              break;
            }
          }
          this.message = ERRNO_MESSAGES[errno];
          this.stack = stackTrace();
        };
        FS.ErrnoError.prototype = new Error();
        FS.ErrnoError.prototype.constructor = FS.ErrnoError;
        // Some errors may happen quite a bit, to avoid overhead we reuse them (and suffer a lack of stack info)
        [ERRNO_CODES.ENOENT].forEach(function(code) {
          FS.genericErrors[code] = new FS.ErrnoError(code);
          FS.genericErrors[code].stack = '<generic error, no stack>';
        });
      },staticInit:function () {
        FS.ensureErrnoError();
        FS.nameTable = new Array(4096);
        FS.root = FS.createNode(null, '/', 16384 | 0777, 0);
        FS.mount(MEMFS, {}, '/');
        FS.createDefaultDirectories();
        FS.createDefaultDevices();
      },init:function (input, output, error) {
        assert(!FS.init.initialized, 'FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)');
        FS.init.initialized = true;
        FS.ensureErrnoError();
        // Allow Module.stdin etc. to provide defaults, if none explicitly passed to us here
        Module['stdin'] = input || Module['stdin'];
        Module['stdout'] = output || Module['stdout'];
        Module['stderr'] = error || Module['stderr'];
        FS.createStandardStreams();
      },quit:function () {
        FS.init.initialized = false;
        for (var i = 0; i < FS.streams.length; i++) {
          var stream = FS.streams[i];
          if (!stream) {
            continue;
          }
          FS.close(stream);
        }
      },getMode:function (canRead, canWrite) {
        var mode = 0;
        if (canRead) mode |= 292 | 73;
        if (canWrite) mode |= 146;
        return mode;
      },joinPath:function (parts, forceRelative) {
        var path = PATH.join.apply(null, parts);
        if (forceRelative && path[0] == '/') path = path.substr(1);
        return path;
      },absolutePath:function (relative, base) {
        return PATH.resolve(base, relative);
      },standardizePath:function (path) {
        return PATH.normalize(path);
      },findObject:function (path, dontResolveLastLink) {
        var ret = FS.analyzePath(path, dontResolveLastLink);
        if (ret.exists) {
          return ret.object;
        } else {
          ___setErrNo(ret.error);
          return null;
        }
      },analyzePath:function (path, dontResolveLastLink) {
        // operate from within the context of the symlink's target
        try {
          var lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          path = lookup.path;
        } catch (e) {
        }
        var ret = {
          isRoot: false, exists: false, error: 0, name: null, path: null, object: null,
          parentExists: false, parentPath: null, parentObject: null
        };
        try {
          var lookup = FS.lookupPath(path, { parent: true });
          ret.parentExists = true;
          ret.parentPath = lookup.path;
          ret.parentObject = lookup.node;
          ret.name = PATH.basename(path);
          lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          ret.exists = true;
          ret.path = lookup.path;
          ret.object = lookup.node;
          ret.name = lookup.node.name;
          ret.isRoot = lookup.path === '/';
        } catch (e) {
          ret.error = e.errno;
        };
        return ret;
      },createFolder:function (parent, name, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.mkdir(path, mode);
      },createPath:function (parent, path, canRead, canWrite) {
        parent = typeof parent === 'string' ? parent : FS.getPath(parent);
        var parts = path.split('/').reverse();
        while (parts.length) {
          var part = parts.pop();
          if (!part) continue;
          var current = PATH.join2(parent, part);
          try {
            FS.mkdir(current);
          } catch (e) {
            // ignore EEXIST
          }
          parent = current;
        }
        return current;
      },createFile:function (parent, name, properties, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.create(path, mode);
      },createDataFile:function (parent, name, data, canRead, canWrite, canOwn) {
        var path = name ? PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name) : parent;
        var mode = FS.getMode(canRead, canWrite);
        var node = FS.create(path, mode);
        if (data) {
          if (typeof data === 'string') {
            var arr = new Array(data.length);
            for (var i = 0, len = data.length; i < len; ++i) arr[i] = data.charCodeAt(i);
            data = arr;
          }
          // make sure we can write to the file
          FS.chmod(node, mode | 146);
          var stream = FS.open(node, 'w');
          FS.write(stream, data, 0, data.length, 0, canOwn);
          FS.close(stream);
          FS.chmod(node, mode);
        }
        return node;
      },createDevice:function (parent, name, input, output) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(!!input, !!output);
        if (!FS.createDevice.major) FS.createDevice.major = 64;
        var dev = FS.makedev(FS.createDevice.major++, 0);
        // Create a fake device that a set of stream ops to emulate
        // the old behavior.
        FS.registerDevice(dev, {
          open: function(stream) {
            stream.seekable = false;
          },
          close: function(stream) {
            // flush any pending line data
            if (output && output.buffer && output.buffer.length) {
              output(10);
            }
          },
          read: function(stream, buffer, offset, length, pos /* ignored */) {
            var bytesRead = 0;
            for (var i = 0; i < length; i++) {
              var result;
              try {
                result = input();
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
              if (result === undefined && bytesRead === 0) {
                throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
              }
              if (result === null || result === undefined) break;
              bytesRead++;
              buffer[offset+i] = result;
            }
            if (bytesRead) {
              stream.node.timestamp = Date.now();
            }
            return bytesRead;
          },
          write: function(stream, buffer, offset, length, pos) {
            for (var i = 0; i < length; i++) {
              try {
                output(buffer[offset+i]);
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
            }
            if (length) {
              stream.node.timestamp = Date.now();
            }
            return i;
          }
        });
        return FS.mkdev(path, mode, dev);
      },createLink:function (parent, name, target, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        return FS.symlink(target, path);
      },forceLoadFile:function (obj) {
        if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
        var success = true;
        if (typeof XMLHttpRequest !== 'undefined') {
          throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
        } else if (Module['read']) {
          // Command-line.
          try {
            // WARNING: Can't read binary files in V8's d8 or tracemonkey's js, as
            //          read() will try to parse UTF8.
            obj.contents = intArrayFromString(Module['read'](obj.url), true);
          } catch (e) {
            success = false;
          }
        } else {
          throw new Error('Cannot load without read() or XMLHttpRequest.');
        }
        if (!success) ___setErrNo(ERRNO_CODES.EIO);
        return success;
      },createLazyFile:function (parent, name, url, canRead, canWrite) {
        if (typeof XMLHttpRequest !== 'undefined') {
          if (!ENVIRONMENT_IS_WORKER) throw 'Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc';
          // Lazy chunked Uint8Array (implements get and length from Uint8Array). Actual getting is abstracted away for eventual reuse.
          function LazyUint8Array() {
            this.lengthKnown = false;
            this.chunks = []; // Loaded chunks. Index is the chunk number
          }
          LazyUint8Array.prototype.get = function LazyUint8Array_get(idx) {
            if (idx > this.length-1 || idx < 0) {
              return undefined;
            }
            var chunkOffset = idx % this.chunkSize;
            var chunkNum = Math.floor(idx / this.chunkSize);
            return this.getter(chunkNum)[chunkOffset];
          }
          LazyUint8Array.prototype.setDataGetter = function LazyUint8Array_setDataGetter(getter) {
            this.getter = getter;
          }
          LazyUint8Array.prototype.cacheLength = function LazyUint8Array_cacheLength() {
              // Find length
              var xhr = new XMLHttpRequest();
              xhr.open('HEAD', url, false);
              xhr.send(null);
              if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
              var datalength = Number(xhr.getResponseHeader("Content-length"));
              var header;
              var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
              var chunkSize = 1024*1024; // Chunk size in bytes
              if (!hasByteServing) chunkSize = datalength;
              // Function to get a range from the remote URL.
              var doXHR = (function(from, to) {
                if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
                if (to > datalength-1) throw new Error("only " + datalength + " bytes available! programmer error!");
                // TODO: Use mozResponseArrayBuffer, responseStream, etc. if available.
                var xhr = new XMLHttpRequest();
                xhr.open('GET', url, false);
                if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);
                // Some hints to the browser that we want binary data.
                if (typeof Uint8Array != 'undefined') xhr.responseType = 'arraybuffer';
                if (xhr.overrideMimeType) {
                  xhr.overrideMimeType('text/plain; charset=x-user-defined');
                }
                xhr.send(null);
                if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
                if (xhr.response !== undefined) {
                  return new Uint8Array(xhr.response || []);
                } else {
                  return intArrayFromString(xhr.responseText || '', true);
                }
              });
              var lazyArray = this;
              lazyArray.setDataGetter(function(chunkNum) {
                var start = chunkNum * chunkSize;
                var end = (chunkNum+1) * chunkSize - 1; // including this byte
                end = Math.min(end, datalength-1); // if datalength-1 is selected, this is the last block
                if (typeof(lazyArray.chunks[chunkNum]) === "undefined") {
                  lazyArray.chunks[chunkNum] = doXHR(start, end);
                }
                if (typeof(lazyArray.chunks[chunkNum]) === "undefined") throw new Error("doXHR failed!");
                return lazyArray.chunks[chunkNum];
              });
              this._length = datalength;
              this._chunkSize = chunkSize;
              this.lengthKnown = true;
          }
          var lazyArray = new LazyUint8Array();
          Object.defineProperty(lazyArray, "length", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._length;
              }
          });
          Object.defineProperty(lazyArray, "chunkSize", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._chunkSize;
              }
          });
          var properties = { isDevice: false, contents: lazyArray };
        } else {
          var properties = { isDevice: false, url: url };
        }
        var node = FS.createFile(parent, name, properties, canRead, canWrite);
        // This is a total hack, but I want to get this lazy file code out of the
        // core of MEMFS. If we want to keep this lazy file concept I feel it should
        // be its own thin LAZYFS proxying calls to MEMFS.
        if (properties.contents) {
          node.contents = properties.contents;
        } else if (properties.url) {
          node.contents = null;
          node.url = properties.url;
        }
        // override each stream op with one that tries to force load the lazy file first
        var stream_ops = {};
        var keys = Object.keys(node.stream_ops);
        keys.forEach(function(key) {
          var fn = node.stream_ops[key];
          stream_ops[key] = function forceLoadLazyFile() {
            if (!FS.forceLoadFile(node)) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            return fn.apply(null, arguments);
          };
        });
        // use a custom read function
        stream_ops.read = function stream_ops_read(stream, buffer, offset, length, position) {
          if (!FS.forceLoadFile(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EIO);
          }
          var contents = stream.node.contents;
          if (position >= contents.length)
            return 0;
          var size = Math.min(contents.length - position, length);
          assert(size >= 0);
          if (contents.slice) { // normal array
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i];
            }
          } else {
            for (var i = 0; i < size; i++) { // LazyUint8Array from sync binary XHR
              buffer[offset + i] = contents.get(position + i);
            }
          }
          return size;
        };
        node.stream_ops = stream_ops;
        return node;
      },createPreloadedFile:function (parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile, canOwn) {
        Browser.init();
        // TODO we should allow people to just pass in a complete filename instead
        // of parent and name being that we just join them anyways
        var fullname = name ? PATH.resolve(PATH.join2(parent, name)) : parent;
        function processData(byteArray) {
          function finish(byteArray) {
            if (!dontCreateFile) {
              FS.createDataFile(parent, name, byteArray, canRead, canWrite, canOwn);
            }
            if (onload) onload();
            removeRunDependency('cp ' + fullname);
          }
          var handled = false;
          Module['preloadPlugins'].forEach(function(plugin) {
            if (handled) return;
            if (plugin['canHandle'](fullname)) {
              plugin['handle'](byteArray, fullname, finish, function() {
                if (onerror) onerror();
                removeRunDependency('cp ' + fullname);
              });
              handled = true;
            }
          });
          if (!handled) finish(byteArray);
        }
        addRunDependency('cp ' + fullname);
        if (typeof url == 'string') {
          Browser.asyncLoad(url, function(byteArray) {
            processData(byteArray);
          }, onerror);
        } else {
          processData(url);
        }
      },indexedDB:function () {
        return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
      },DB_NAME:function () {
        return 'EM_FS_' + window.location.pathname;
      },DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = function openRequest_onupgradeneeded() {
          console.log('creating db');
          var db = openRequest.result;
          db.createObjectStore(FS.DB_STORE_NAME);
        };
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          var transaction = db.transaction([FS.DB_STORE_NAME], 'readwrite');
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var putRequest = files.put(FS.analyzePath(path).object.contents, path);
            putRequest.onsuccess = function putRequest_onsuccess() { ok++; if (ok + fail == total) finish() };
            putRequest.onerror = function putRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      },loadFilesFromDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = onerror; // no database to load from
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          try {
            var transaction = db.transaction([FS.DB_STORE_NAME], 'readonly');
          } catch(e) {
            onerror(e);
            return;
          }
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var getRequest = files.get(path);
            getRequest.onsuccess = function getRequest_onsuccess() {
              if (FS.analyzePath(path).exists) {
                FS.unlink(path);
              }
              FS.createDataFile(PATH.dirname(path), PATH.basename(path), getRequest.result, true, true, true);
              ok++;
              if (ok + fail == total) finish();
            };
            getRequest.onerror = function getRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      }};
  var Browser={mainLoop:{scheduler:null,shouldPause:false,paused:false,queue:[],pause:function () {
          Browser.mainLoop.shouldPause = true;
        },resume:function () {
          if (Browser.mainLoop.paused) {
            Browser.mainLoop.paused = false;
            Browser.mainLoop.scheduler();
          }
          Browser.mainLoop.shouldPause = false;
        },updateStatus:function () {
          if (Module['setStatus']) {
            var message = Module['statusMessage'] || 'Please wait...';
            var remaining = Browser.mainLoop.remainingBlockers;
            var expected = Browser.mainLoop.expectedBlockers;
            if (remaining) {
              if (remaining < expected) {
                Module['setStatus'](message + ' (' + (expected - remaining) + '/' + expected + ')');
              } else {
                Module['setStatus'](message);
              }
            } else {
              Module['setStatus']('');
            }
          }
        }},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:function () {
        if (!Module["preloadPlugins"]) Module["preloadPlugins"] = []; // needs to exist even in workers
        if (Browser.initted || ENVIRONMENT_IS_WORKER) return;
        Browser.initted = true;
        try {
          new Blob();
          Browser.hasBlobConstructor = true;
        } catch(e) {
          Browser.hasBlobConstructor = false;
          console.log("warning: no blob constructor, cannot create blobs with mimetypes");
        }
        Browser.BlobBuilder = typeof MozBlobBuilder != "undefined" ? MozBlobBuilder : (typeof WebKitBlobBuilder != "undefined" ? WebKitBlobBuilder : (!Browser.hasBlobConstructor ? console.log("warning: no BlobBuilder") : null));
        Browser.URLObject = typeof window != "undefined" ? (window.URL ? window.URL : window.webkitURL) : undefined;
        if (!Module.noImageDecoding && typeof Browser.URLObject === 'undefined') {
          console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");
          Module.noImageDecoding = true;
        }
        // Support for plugins that can process preloaded files. You can add more of these to
        // your app by creating and appending to Module.preloadPlugins.
        //
        // Each plugin is asked if it can handle a file based on the file's name. If it can,
        // it is given the file's raw data. When it is done, it calls a callback with the file's
        // (possibly modified) data. For example, a plugin might decompress a file, or it
        // might create some side data structure for use later (like an Image element, etc.).
        var imagePlugin = {};
        imagePlugin['canHandle'] = function imagePlugin_canHandle(name) {
          return !Module.noImageDecoding && /\.(jpg|jpeg|png|bmp)$/i.test(name);
        };
        imagePlugin['handle'] = function imagePlugin_handle(byteArray, name, onload, onerror) {
          var b = null;
          if (Browser.hasBlobConstructor) {
            try {
              b = new Blob([byteArray], { type: Browser.getMimetype(name) });
              if (b.size !== byteArray.length) { // Safari bug #118630
                // Safari's Blob can only take an ArrayBuffer
                b = new Blob([(new Uint8Array(byteArray)).buffer], { type: Browser.getMimetype(name) });
              }
            } catch(e) {
              Runtime.warnOnce('Blob constructor present but fails: ' + e + '; falling back to blob builder');
            }
          }
          if (!b) {
            var bb = new Browser.BlobBuilder();
            bb.append((new Uint8Array(byteArray)).buffer); // we need to pass a buffer, and must copy the array to get the right data range
            b = bb.getBlob();
          }
          var url = Browser.URLObject.createObjectURL(b);
          var img = new Image();
          img.onload = function img_onload() {
            assert(img.complete, 'Image ' + name + ' could not be decoded');
            var canvas = document.createElement('canvas');
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext('2d');
            ctx.drawImage(img, 0, 0);
            Module["preloadedImages"][name] = canvas;
            Browser.URLObject.revokeObjectURL(url);
            if (onload) onload(byteArray);
          };
          img.onerror = function img_onerror(event) {
            console.log('Image ' + url + ' could not be decoded');
            if (onerror) onerror();
          };
          img.src = url;
        };
        Module['preloadPlugins'].push(imagePlugin);
        var audioPlugin = {};
        audioPlugin['canHandle'] = function audioPlugin_canHandle(name) {
          return !Module.noAudioDecoding && name.substr(-4) in { '.ogg': 1, '.wav': 1, '.mp3': 1 };
        };
        audioPlugin['handle'] = function audioPlugin_handle(byteArray, name, onload, onerror) {
          var done = false;
          function finish(audio) {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = audio;
            if (onload) onload(byteArray);
          }
          function fail() {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = new Audio(); // empty shim
            if (onerror) onerror();
          }
          if (Browser.hasBlobConstructor) {
            try {
              var b = new Blob([byteArray], { type: Browser.getMimetype(name) });
            } catch(e) {
              return fail();
            }
            var url = Browser.URLObject.createObjectURL(b); // XXX we never revoke this!
            var audio = new Audio();
            audio.addEventListener('canplaythrough', function() { finish(audio) }, false); // use addEventListener due to chromium bug 124926
            audio.onerror = function audio_onerror(event) {
              if (done) return;
              console.log('warning: browser could not fully decode audio ' + name + ', trying slower base64 approach');
              function encode64(data) {
                var BASE = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
                var PAD = '=';
                var ret = '';
                var leftchar = 0;
                var leftbits = 0;
                for (var i = 0; i < data.length; i++) {
                  leftchar = (leftchar << 8) | data[i];
                  leftbits += 8;
                  while (leftbits >= 6) {
                    var curr = (leftchar >> (leftbits-6)) & 0x3f;
                    leftbits -= 6;
                    ret += BASE[curr];
                  }
                }
                if (leftbits == 2) {
                  ret += BASE[(leftchar&3) << 4];
                  ret += PAD + PAD;
                } else if (leftbits == 4) {
                  ret += BASE[(leftchar&0xf) << 2];
                  ret += PAD;
                }
                return ret;
              }
              audio.src = 'data:audio/x-' + name.substr(-3) + ';base64,' + encode64(byteArray);
              finish(audio); // we don't wait for confirmation this worked - but it's worth trying
            };
            audio.src = url;
            // workaround for chrome bug 124926 - we do not always get oncanplaythrough or onerror
            Browser.safeSetTimeout(function() {
              finish(audio); // try to use it even though it is not necessarily ready to play
            }, 10000);
          } else {
            return fail();
          }
        };
        Module['preloadPlugins'].push(audioPlugin);
        // Canvas event setup
        var canvas = Module['canvas'];
        canvas.requestPointerLock = canvas['requestPointerLock'] ||
                                    canvas['mozRequestPointerLock'] ||
                                    canvas['webkitRequestPointerLock'];
        canvas.exitPointerLock = document['exitPointerLock'] ||
                                 document['mozExitPointerLock'] ||
                                 document['webkitExitPointerLock'] ||
                                 function(){}; // no-op if function does not exist
        canvas.exitPointerLock = canvas.exitPointerLock.bind(document);
        function pointerLockChange() {
          Browser.pointerLock = document['pointerLockElement'] === canvas ||
                                document['mozPointerLockElement'] === canvas ||
                                document['webkitPointerLockElement'] === canvas;
        }
        document.addEventListener('pointerlockchange', pointerLockChange, false);
        document.addEventListener('mozpointerlockchange', pointerLockChange, false);
        document.addEventListener('webkitpointerlockchange', pointerLockChange, false);
        if (Module['elementPointerLock']) {
          canvas.addEventListener("click", function(ev) {
            if (!Browser.pointerLock && canvas.requestPointerLock) {
              canvas.requestPointerLock();
              ev.preventDefault();
            }
          }, false);
        }
      },createContext:function (canvas, useWebGL, setInModule, webGLContextAttributes) {
        var ctx;
        try {
          if (useWebGL) {
            var contextAttributes = {
              antialias: false,
              alpha: false
            };
            if (webGLContextAttributes) {
              for (var attribute in webGLContextAttributes) {
                contextAttributes[attribute] = webGLContextAttributes[attribute];
              }
            }
            ['experimental-webgl', 'webgl'].some(function(webglId) {
              return ctx = canvas.getContext(webglId, contextAttributes);
            });
          } else {
            ctx = canvas.getContext('2d');
          }
          if (!ctx) throw ':(';
        } catch (e) {
          Module.print('Could not create canvas - ' + e);
          return null;
        }
        if (useWebGL) {
          // Set the background of the WebGL canvas to black
          canvas.style.backgroundColor = "black";
          // Warn on context loss
          canvas.addEventListener('webglcontextlost', function(event) {
            alert('WebGL context lost. You will need to reload the page.');
          }, false);
        }
        if (setInModule) {
          Module.ctx = ctx;
          Module.useWebGL = useWebGL;
          Browser.moduleContextCreatedCallbacks.forEach(function(callback) { callback() });
          Browser.init();
        }
        return ctx;
      },destroyContext:function (canvas, useWebGL, setInModule) {},fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:function (lockPointer, resizeCanvas) {
        Browser.lockPointer = lockPointer;
        Browser.resizeCanvas = resizeCanvas;
        if (typeof Browser.lockPointer === 'undefined') Browser.lockPointer = true;
        if (typeof Browser.resizeCanvas === 'undefined') Browser.resizeCanvas = false;
        var canvas = Module['canvas'];
        function fullScreenChange() {
          Browser.isFullScreen = false;
          if ((document['webkitFullScreenElement'] || document['webkitFullscreenElement'] ||
               document['mozFullScreenElement'] || document['mozFullscreenElement'] ||
               document['fullScreenElement'] || document['fullscreenElement']) === canvas) {
            canvas.cancelFullScreen = document['cancelFullScreen'] ||
                                      document['mozCancelFullScreen'] ||
                                      document['webkitCancelFullScreen'];
            canvas.cancelFullScreen = canvas.cancelFullScreen.bind(document);
            if (Browser.lockPointer) canvas.requestPointerLock();
            Browser.isFullScreen = true;
            if (Browser.resizeCanvas) Browser.setFullScreenCanvasSize();
          } else if (Browser.resizeCanvas){
            Browser.setWindowedCanvasSize();
          }
          if (Module['onFullScreen']) Module['onFullScreen'](Browser.isFullScreen);
        }
        if (!Browser.fullScreenHandlersInstalled) {
          Browser.fullScreenHandlersInstalled = true;
          document.addEventListener('fullscreenchange', fullScreenChange, false);
          document.addEventListener('mozfullscreenchange', fullScreenChange, false);
          document.addEventListener('webkitfullscreenchange', fullScreenChange, false);
        }
        canvas.requestFullScreen = canvas['requestFullScreen'] ||
                                   canvas['mozRequestFullScreen'] ||
                                   (canvas['webkitRequestFullScreen'] ? function() { canvas['webkitRequestFullScreen'](Element['ALLOW_KEYBOARD_INPUT']) } : null);
        canvas.requestFullScreen();
      },requestAnimationFrame:function requestAnimationFrame(func) {
        if (typeof window === 'undefined') { // Provide fallback to setTimeout if window is undefined (e.g. in Node.js)
          setTimeout(func, 1000/60);
        } else {
          if (!window.requestAnimationFrame) {
            window.requestAnimationFrame = window['requestAnimationFrame'] ||
                                           window['mozRequestAnimationFrame'] ||
                                           window['webkitRequestAnimationFrame'] ||
                                           window['msRequestAnimationFrame'] ||
                                           window['oRequestAnimationFrame'] ||
                                           window['setTimeout'];
          }
          window.requestAnimationFrame(func);
        }
      },safeCallback:function (func) {
        return function() {
          if (!ABORT) return func.apply(null, arguments);
        };
      },safeRequestAnimationFrame:function (func) {
        return Browser.requestAnimationFrame(function() {
          if (!ABORT) func();
        });
      },safeSetTimeout:function (func, timeout) {
        return setTimeout(function() {
          if (!ABORT) func();
        }, timeout);
      },safeSetInterval:function (func, timeout) {
        return setInterval(function() {
          if (!ABORT) func();
        }, timeout);
      },getMimetype:function (name) {
        return {
          'jpg': 'image/jpeg',
          'jpeg': 'image/jpeg',
          'png': 'image/png',
          'bmp': 'image/bmp',
          'ogg': 'audio/ogg',
          'wav': 'audio/wav',
          'mp3': 'audio/mpeg'
        }[name.substr(name.lastIndexOf('.')+1)];
      },getUserMedia:function (func) {
        if(!window.getUserMedia) {
          window.getUserMedia = navigator['getUserMedia'] ||
                                navigator['mozGetUserMedia'];
        }
        window.getUserMedia(func);
      },getMovementX:function (event) {
        return event['movementX'] ||
               event['mozMovementX'] ||
               event['webkitMovementX'] ||
               0;
      },getMovementY:function (event) {
        return event['movementY'] ||
               event['mozMovementY'] ||
               event['webkitMovementY'] ||
               0;
      },mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,calculateMouseEvent:function (event) { // event should be mousemove, mousedown or mouseup
        if (Browser.pointerLock) {
          // When the pointer is locked, calculate the coordinates
          // based on the movement of the mouse.
          // Workaround for Firefox bug 764498
          if (event.type != 'mousemove' &&
              ('mozMovementX' in event)) {
            Browser.mouseMovementX = Browser.mouseMovementY = 0;
          } else {
            Browser.mouseMovementX = Browser.getMovementX(event);
            Browser.mouseMovementY = Browser.getMovementY(event);
          }
          // check if SDL is available
          if (typeof SDL != "undefined") {
          	Browser.mouseX = SDL.mouseX + Browser.mouseMovementX;
          	Browser.mouseY = SDL.mouseY + Browser.mouseMovementY;
          } else {
          	// just add the mouse delta to the current absolut mouse position
          	// FIXME: ideally this should be clamped against the canvas size and zero
          	Browser.mouseX += Browser.mouseMovementX;
          	Browser.mouseY += Browser.mouseMovementY;
          }        
        } else {
          // Otherwise, calculate the movement based on the changes
          // in the coordinates.
          var rect = Module["canvas"].getBoundingClientRect();
          var x, y;
          if (event.type == 'touchstart' ||
              event.type == 'touchend' ||
              event.type == 'touchmove') {
            var t = event.touches.item(0);
            if (t) {
              x = t.pageX - (window.scrollX + rect.left);
              y = t.pageY - (window.scrollY + rect.top);
            } else {
              return;
            }
          } else {
            x = event.pageX - (window.scrollX + rect.left);
            y = event.pageY - (window.scrollY + rect.top);
          }
          // the canvas might be CSS-scaled compared to its backbuffer;
          // SDL-using content will want mouse coordinates in terms
          // of backbuffer units.
          var cw = Module["canvas"].width;
          var ch = Module["canvas"].height;
          x = x * (cw / rect.width);
          y = y * (ch / rect.height);
          Browser.mouseMovementX = x - Browser.mouseX;
          Browser.mouseMovementY = y - Browser.mouseY;
          Browser.mouseX = x;
          Browser.mouseY = y;
        }
      },xhrLoad:function (url, onload, onerror) {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, true);
        xhr.responseType = 'arraybuffer';
        xhr.onload = function xhr_onload() {
          if (xhr.status == 200 || (xhr.status == 0 && xhr.response)) { // file URLs can return 0
            onload(xhr.response);
          } else {
            onerror();
          }
        };
        xhr.onerror = onerror;
        xhr.send(null);
      },asyncLoad:function (url, onload, onerror, noRunDep) {
        Browser.xhrLoad(url, function(arrayBuffer) {
          assert(arrayBuffer, 'Loading data file "' + url + '" failed (no arrayBuffer).');
          onload(new Uint8Array(arrayBuffer));
          if (!noRunDep) removeRunDependency('al ' + url);
        }, function(event) {
          if (onerror) {
            onerror();
          } else {
            throw 'Loading data file "' + url + '" failed.';
          }
        });
        if (!noRunDep) addRunDependency('al ' + url);
      },resizeListeners:[],updateResizeListeners:function () {
        var canvas = Module['canvas'];
        Browser.resizeListeners.forEach(function(listener) {
          listener(canvas.width, canvas.height);
        });
      },setCanvasSize:function (width, height, noUpdates) {
        var canvas = Module['canvas'];
        canvas.width = width;
        canvas.height = height;
        if (!noUpdates) Browser.updateResizeListeners();
      },windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:function () {
        var canvas = Module['canvas'];
        this.windowedWidth = canvas.width;
        this.windowedHeight = canvas.height;
        canvas.width = screen.width;
        canvas.height = screen.height;
        // check if SDL is available   
        if (typeof SDL != "undefined") {
        	var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        	flags = flags | 0x00800000; // set SDL_FULLSCREEN flag
        	HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      },setWindowedCanvasSize:function () {
        var canvas = Module['canvas'];
        canvas.width = this.windowedWidth;
        canvas.height = this.windowedHeight;
        // check if SDL is available       
        if (typeof SDL != "undefined") {
        	var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        	flags = flags & ~0x00800000; // clear SDL_FULLSCREEN flag
        	HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      }};var SDL={defaults:{width:320,height:200,copyOnLock:true},version:null,surfaces:{},canvasPool:[],events:[],fonts:[null],audios:[null],rwops:[null],music:{audio:null,volume:1},mixerFrequency:22050,mixerFormat:32784,mixerNumChannels:2,mixerChunkSize:1024,channelMinimumNumber:0,GL:false,glAttributes:{0:3,1:3,2:2,3:0,4:0,5:1,6:16,7:0,8:0,9:0,10:0,11:0,12:0,13:0,14:0,15:1,16:0,17:0,18:0},keyboardState:null,keyboardMap:{},canRequestFullscreen:false,isRequestingFullscreen:false,textInput:false,startTime:null,initFlags:0,buttonState:0,modState:0,DOMButtons:[0,0,0],DOMEventToSDLEvent:{},keyCodes:{16:1249,17:1248,18:1250,33:1099,34:1102,37:1104,38:1106,39:1103,40:1105,46:127,96:1112,97:1113,98:1114,99:1115,100:1116,101:1117,102:1118,103:1119,104:1120,105:1121,112:1082,113:1083,114:1084,115:1085,116:1086,117:1087,118:1088,119:1089,120:1090,121:1091,122:1092,123:1093,173:45,188:44,190:46,191:47,192:96},scanCodes:{8:42,9:43,13:40,27:41,32:44,44:54,46:55,47:56,48:39,49:30,50:31,51:32,52:33,53:34,54:35,55:36,56:37,57:38,59:51,61:46,91:47,92:49,93:48,96:52,97:4,98:5,99:6,100:7,101:8,102:9,103:10,104:11,105:12,106:13,107:14,108:15,109:16,110:17,111:18,112:19,113:20,114:21,115:22,116:23,117:24,118:25,119:26,120:27,121:28,122:29,305:224,308:226},loadRect:function (rect) {
        return {
          x: HEAP32[((rect + 0)>>2)],
          y: HEAP32[((rect + 4)>>2)],
          w: HEAP32[((rect + 8)>>2)],
          h: HEAP32[((rect + 12)>>2)]
        };
      },loadColorToCSSRGB:function (color) {
        var rgba = HEAP32[((color)>>2)];
        return 'rgb(' + (rgba&255) + ',' + ((rgba >> 8)&255) + ',' + ((rgba >> 16)&255) + ')';
      },loadColorToCSSRGBA:function (color) {
        var rgba = HEAP32[((color)>>2)];
        return 'rgba(' + (rgba&255) + ',' + ((rgba >> 8)&255) + ',' + ((rgba >> 16)&255) + ',' + (((rgba >> 24)&255)/255) + ')';
      },translateColorToCSSRGBA:function (rgba) {
        return 'rgba(' + (rgba&0xff) + ',' + (rgba>>8 & 0xff) + ',' + (rgba>>16 & 0xff) + ',' + (rgba>>>24)/0xff + ')';
      },translateRGBAToCSSRGBA:function (r, g, b, a) {
        return 'rgba(' + (r&0xff) + ',' + (g&0xff) + ',' + (b&0xff) + ',' + (a&0xff)/255 + ')';
      },translateRGBAToColor:function (r, g, b, a) {
        return r | g << 8 | b << 16 | a << 24;
      },makeSurface:function (width, height, flags, usePageCanvas, source, rmask, gmask, bmask, amask) {
        flags = flags || 0;
        var surf = _malloc(60);  // SDL_Surface has 15 fields of quantum size
        var buffer = _malloc(width*height*4); // TODO: only allocate when locked the first time
        var pixelFormat = _malloc(44);
        flags |= 1; // SDL_HWSURFACE - this tells SDL_MUSTLOCK that this needs to be locked
        //surface with SDL_HWPALETTE flag is 8bpp surface (1 byte)
        var is_SDL_HWPALETTE = flags & 0x00200000;  
        var bpp = is_SDL_HWPALETTE ? 1 : 4;
        HEAP32[((surf)>>2)]=flags         // SDL_Surface.flags
        HEAP32[(((surf)+(4))>>2)]=pixelFormat // SDL_Surface.format TODO
        HEAP32[(((surf)+(8))>>2)]=width         // SDL_Surface.w
        HEAP32[(((surf)+(12))>>2)]=height        // SDL_Surface.h
        HEAP32[(((surf)+(16))>>2)]=width * bpp       // SDL_Surface.pitch, assuming RGBA or indexed for now,
                                                                                 // since that is what ImageData gives us in browsers
        HEAP32[(((surf)+(20))>>2)]=buffer      // SDL_Surface.pixels
        HEAP32[(((surf)+(36))>>2)]=0      // SDL_Surface.offset
        HEAP32[(((surf)+(56))>>2)]=1
        HEAP32[((pixelFormat)>>2)]=0 /* XXX missing C define SDL_PIXELFORMAT_RGBA8888 */ // SDL_PIXELFORMAT_RGBA8888
        HEAP32[(((pixelFormat)+(4))>>2)]=0 // TODO
        HEAP8[(((pixelFormat)+(8))|0)]=bpp * 8
        HEAP8[(((pixelFormat)+(9))|0)]=bpp
        HEAP32[(((pixelFormat)+(12))>>2)]=rmask || 0x000000ff
        HEAP32[(((pixelFormat)+(16))>>2)]=gmask || 0x0000ff00
        HEAP32[(((pixelFormat)+(20))>>2)]=bmask || 0x00ff0000
        HEAP32[(((pixelFormat)+(24))>>2)]=amask || 0xff000000
        // Decide if we want to use WebGL or not
        var useWebGL = (flags & 0x04000000) != 0; // SDL_OPENGL
        SDL.GL = SDL.GL || useWebGL;
        var canvas;
        if (!usePageCanvas) {
          if (SDL.canvasPool.length > 0) {
            canvas = SDL.canvasPool.pop();
          } else {
            canvas = document.createElement('canvas');
          }
          canvas.width = width;
          canvas.height = height;
        } else {
          canvas = Module['canvas'];
        }
        var webGLContextAttributes = {
          antialias: ((SDL.glAttributes[13 /*SDL_GL_MULTISAMPLEBUFFERS*/] != 0) && (SDL.glAttributes[14 /*SDL_GL_MULTISAMPLESAMPLES*/] > 1)),
          depth: (SDL.glAttributes[6 /*SDL_GL_DEPTH_SIZE*/] > 0),
          stencil: (SDL.glAttributes[7 /*SDL_GL_STENCIL_SIZE*/] > 0)
        };
        var ctx = Browser.createContext(canvas, useWebGL, usePageCanvas, webGLContextAttributes);
        SDL.surfaces[surf] = {
          width: width,
          height: height,
          canvas: canvas,
          ctx: ctx,
          surf: surf,
          buffer: buffer,
          pixelFormat: pixelFormat,
          alpha: 255,
          flags: flags,
          locked: 0,
          usePageCanvas: usePageCanvas,
          source: source,
          isFlagSet: function(flag) {
            return flags & flag;
          }
        };
        return surf;
      },copyIndexedColorData:function (surfData, rX, rY, rW, rH) {
        // HWPALETTE works with palette
        // setted by SDL_SetColors
        if (!surfData.colors) {
          return;
        }
        var fullWidth  = Module['canvas'].width;
        var fullHeight = Module['canvas'].height;
        var startX  = rX || 0;
        var startY  = rY || 0;
        var endX    = (rW || (fullWidth - startX)) + startX;
        var endY    = (rH || (fullHeight - startY)) + startY;
        var buffer  = surfData.buffer;
        var data    = surfData.image.data;
        var colors  = surfData.colors;
        for (var y = startY; y < endY; ++y) {
          var indexBase = y * fullWidth;
          var colorBase = indexBase * 4;
          for (var x = startX; x < endX; ++x) {
            // HWPALETTE have only 256 colors (not rgba)
            var index = HEAPU8[((buffer + indexBase + x)|0)] * 3;
            var colorOffset = colorBase + x * 4;
            data[colorOffset   ] = colors[index   ];
            data[colorOffset +1] = colors[index +1];
            data[colorOffset +2] = colors[index +2];
            //unused: data[colorOffset +3] = color[index +3];
          }
        }
      },freeSurface:function (surf) {
        var refcountPointer = surf + 56;
        var refcount = HEAP32[((refcountPointer)>>2)];
        if (refcount > 1) {
          HEAP32[((refcountPointer)>>2)]=refcount - 1;
          return;
        }
        var info = SDL.surfaces[surf];
        if (!info.usePageCanvas && info.canvas) SDL.canvasPool.push(info.canvas);
        _free(info.buffer);
        _free(info.pixelFormat);
        _free(surf);
        SDL.surfaces[surf] = null;
      },touchX:0,touchY:0,savedKeydown:null,receiveEvent:function (event) {
        switch(event.type) {
          case 'touchstart':
            event.preventDefault();
            var touch = event.touches[0];
            touchX = touch.pageX;
            touchY = touch.pageY;
            var event = {
              type: 'mousedown',
              button: 0,
              pageX: touchX,
              pageY: touchY
            };
            SDL.DOMButtons[0] = 1;
            SDL.events.push(event);
            break;
          case 'touchmove':
            event.preventDefault();
            var touch = event.touches[0];
            touchX = touch.pageX;
            touchY = touch.pageY;
            event = {
              type: 'mousemove',
              button: 0,
              pageX: touchX,
              pageY: touchY
            };
            SDL.events.push(event);
            break;
          case 'touchend':
            event.preventDefault();
            event = {
              type: 'mouseup',
              button: 0,
              pageX: touchX,
              pageY: touchY
            };
            SDL.DOMButtons[0] = 0;
            SDL.events.push(event);
            break;
          case 'mousemove':
            if (Browser.pointerLock) {
              // workaround for firefox bug 750111
              if ('mozMovementX' in event) {
                event['movementX'] = event['mozMovementX'];
                event['movementY'] = event['mozMovementY'];
              }
              // workaround for Firefox bug 782777
              if (event['movementX'] == 0 && event['movementY'] == 0) {
                // ignore a mousemove event if it doesn't contain any movement info
                // (without pointer lock, we infer movement from pageX/pageY, so this check is unnecessary)
                event.preventDefault();
                return;
              }
            }
            // fall through
          case 'keydown': case 'keyup': case 'keypress': case 'mousedown': case 'mouseup': case 'DOMMouseScroll': case 'mousewheel':
            // If we preventDefault on keydown events, the subsequent keypress events
            // won't fire. However, it's fine (and in some cases necessary) to
            // preventDefault for keys that don't generate a character. Otherwise,
            // preventDefault is the right thing to do in general.
            if (event.type !== 'keydown' || (event.keyCode === 8 /* backspace */ || event.keyCode === 9 /* tab */)) {
              event.preventDefault();
            }
            if (event.type == 'DOMMouseScroll' || event.type == 'mousewheel') {
              var button = (event.type == 'DOMMouseScroll' ? event.detail : -event.wheelDelta) > 0 ? 4 : 3;
              var event2 = {
                type: 'mousedown',
                button: button,
                pageX: event.pageX,
                pageY: event.pageY
              };
              SDL.events.push(event2);
              event = {
                type: 'mouseup',
                button: button,
                pageX: event.pageX,
                pageY: event.pageY
              };
            } else if (event.type == 'mousedown') {
              SDL.DOMButtons[event.button] = 1;
            } else if (event.type == 'mouseup') {
              // ignore extra ups, can happen if we leave the canvas while pressing down, then return,
              // since we add a mouseup in that case
              if (!SDL.DOMButtons[event.button]) {
                return;
              }
              SDL.DOMButtons[event.button] = 0;
            }
            // We can only request fullscreen as the result of user input.
            // Due to this limitation, we toggle a boolean on keydown which
            // SDL_WM_ToggleFullScreen will check and subsequently set another
            // flag indicating for us to request fullscreen on the following
            // keyup. This isn't perfect, but it enables SDL_WM_ToggleFullScreen
            // to work as the result of a keypress (which is an extremely
            // common use case).
            if (event.type === 'keydown') {
              SDL.canRequestFullscreen = true;
            } else if (event.type === 'keyup') {
              if (SDL.isRequestingFullscreen) {
                Module['requestFullScreen'](true, true);
                SDL.isRequestingFullscreen = false;
              }
              SDL.canRequestFullscreen = false;
            }
            // SDL expects a unicode character to be passed to its keydown events.
            // Unfortunately, the browser APIs only provide a charCode property on
            // keypress events, so we must backfill in keydown events with their
            // subsequent keypress event's charCode.
            if (event.type === 'keypress' && SDL.savedKeydown) {
              // charCode is read-only
              SDL.savedKeydown.keypressCharCode = event.charCode;
              SDL.savedKeydown = null;
            } else if (event.type === 'keydown') {
              SDL.savedKeydown = event;
            }
            // Don't push keypress events unless SDL_StartTextInput has been called.
            if (event.type !== 'keypress' || SDL.textInput) {
              SDL.events.push(event);
            }
            break;
          case 'mouseout':
            // Un-press all pressed mouse buttons, because we might miss the release outside of the canvas
            for (var i = 0; i < 3; i++) {
              if (SDL.DOMButtons[i]) {
                SDL.events.push({
                  type: 'mouseup',
                  button: i,
                  pageX: event.pageX,
                  pageY: event.pageY
                });
                SDL.DOMButtons[i] = 0;
              }
            }
            event.preventDefault();
            break;
          case 'blur':
          case 'visibilitychange': {
            // Un-press all pressed keys: TODO
            for (var code in SDL.keyboardMap) {
              SDL.events.push({
                type: 'keyup',
                keyCode: SDL.keyboardMap[code]
              });
            }
            event.preventDefault();
            break;
          }
          case 'unload':
            if (Browser.mainLoop.runner) {
              SDL.events.push(event);
              // Force-run a main event loop, since otherwise this event will never be caught!
              Browser.mainLoop.runner();
            }
            return;
          case 'resize':
            SDL.events.push(event);
            // manually triggered resize event doesn't have a preventDefault member
            if (event.preventDefault) {
              event.preventDefault();
            }
            break;
        }
        if (SDL.events.length >= 10000) {
          Module.printErr('SDL event queue full, dropping events');
          SDL.events = SDL.events.slice(0, 10000);
        }
        return;
      },handleEvent:function (event) {
        if (event.handled) return;
        event.handled = true;
        switch (event.type) {
          case 'keydown': case 'keyup': {
            var down = event.type === 'keydown';
            var code = event.keyCode;
            if (code >= 65 && code <= 90) {
              code += 32; // make lowercase for SDL
            } else {
              code = SDL.keyCodes[event.keyCode] || event.keyCode;
            }
            HEAP8[(((SDL.keyboardState)+(code))|0)]=down;
            // TODO: lmeta, rmeta, numlock, capslock, KMOD_MODE, KMOD_RESERVED
            SDL.modState = (HEAP8[(((SDL.keyboardState)+(1248))|0)] ? 0x0040 | 0x0080 : 0) | // KMOD_LCTRL & KMOD_RCTRL
              (HEAP8[(((SDL.keyboardState)+(1249))|0)] ? 0x0001 | 0x0002 : 0) | // KMOD_LSHIFT & KMOD_RSHIFT
              (HEAP8[(((SDL.keyboardState)+(1250))|0)] ? 0x0100 | 0x0200 : 0); // KMOD_LALT & KMOD_RALT
            if (down) {
              SDL.keyboardMap[code] = event.keyCode; // save the DOM input, which we can use to unpress it during blur
            } else {
              delete SDL.keyboardMap[code];
            }
            break;
          }
          case 'mousedown': case 'mouseup':
            if (event.type == 'mousedown') {
              // SDL_BUTTON(x) is defined as (1 << ((x)-1)).  SDL buttons are 1-3,
              // and DOM buttons are 0-2, so this means that the below formula is
              // correct.
              SDL.buttonState |= 1 << event.button;
            } else if (event.type == 'mouseup') {
              SDL.buttonState &= ~(1 << event.button);
            }
            // fall through
          case 'mousemove': {
            Browser.calculateMouseEvent(event);
            break;
          }
        }
      },makeCEvent:function (event, ptr) {
        if (typeof event === 'number') {
          // This is a pointer to a native C event that was SDL_PushEvent'ed
          _memcpy(ptr, event, 28); // XXX
          return;
        }
        SDL.handleEvent(event);
        switch (event.type) {
          case 'keydown': case 'keyup': {
            var down = event.type === 'keydown';
            //Module.print('Received key event: ' + event.keyCode);
            var key = event.keyCode;
            if (key >= 65 && key <= 90) {
              key += 32; // make lowercase for SDL
            } else {
              key = SDL.keyCodes[event.keyCode] || event.keyCode;
            }
            var scan;
            if (key >= 1024) {
              scan = key - 1024;
            } else {
              scan = SDL.scanCodes[key] || key;
            }
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type]
            HEAP8[(((ptr)+(8))|0)]=down ? 1 : 0
            HEAP8[(((ptr)+(9))|0)]=0 // TODO
            HEAP32[(((ptr)+(12))>>2)]=scan
            HEAP32[(((ptr)+(16))>>2)]=key
            HEAP16[(((ptr)+(20))>>1)]=SDL.modState
            // some non-character keys (e.g. backspace and tab) won't have keypressCharCode set, fill in with the keyCode.
            HEAP32[(((ptr)+(24))>>2)]=event.keypressCharCode || key
            break;
          }
          case 'keypress': {
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type]
            // Not filling in windowID for now
            var cStr = intArrayFromString(String.fromCharCode(event.charCode));
            for (var i = 0; i < cStr.length; ++i) {
              HEAP8[(((ptr)+(8 + i))|0)]=cStr[i];
            }
            break;
          }
          case 'mousedown': case 'mouseup': case 'mousemove': {
            if (event.type != 'mousemove') {
              var down = event.type === 'mousedown';
              HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
              HEAP8[(((ptr)+(8))|0)]=event.button+1; // DOM buttons are 0-2, SDL 1-3
              HEAP8[(((ptr)+(9))|0)]=down ? 1 : 0;
              HEAP32[(((ptr)+(12))>>2)]=Browser.mouseX;
              HEAP32[(((ptr)+(16))>>2)]=Browser.mouseY;
            } else {
              HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
              HEAP8[(((ptr)+(8))|0)]=SDL.buttonState;
              HEAP32[(((ptr)+(12))>>2)]=Browser.mouseX;
              HEAP32[(((ptr)+(16))>>2)]=Browser.mouseY;
              HEAP32[(((ptr)+(20))>>2)]=Browser.mouseMovementX;
              HEAP32[(((ptr)+(24))>>2)]=Browser.mouseMovementY;
            }
            break;
          }
          case 'unload': {
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            break;
          }
          case 'resize': {
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            HEAP32[(((ptr)+(4))>>2)]=event.w;
            HEAP32[(((ptr)+(8))>>2)]=event.h;
            break;
          }
          case 'joystick_button_up': case 'joystick_button_down': {
            var state = event.type === 'joystick_button_up' ? 0 : 1;
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            HEAP8[(((ptr)+(4))|0)]=event.index;
            HEAP8[(((ptr)+(5))|0)]=event.button;
            HEAP8[(((ptr)+(6))|0)]=state;
            break;
          }
          case 'joystick_axis_motion': {
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            HEAP8[(((ptr)+(4))|0)]=event.index;
            HEAP8[(((ptr)+(5))|0)]=event.axis;
            HEAP32[(((ptr)+(8))>>2)]=SDL.joystickAxisValueConversion(event.value);
            break;
          }
          default: throw 'Unhandled SDL event: ' + event.type;
        }
      },estimateTextWidth:function (fontData, text) {
        var h = fontData.size;
        var fontString = h + 'px ' + fontData.name;
        var tempCtx = SDL.ttfContext;
        tempCtx.save();
        tempCtx.font = fontString;
        var ret = tempCtx.measureText(text).width | 0;
        tempCtx.restore();
        return ret;
      },allocateChannels:function (num) { // called from Mix_AllocateChannels and init
        if (SDL.numChannels && SDL.numChannels >= num && num != 0) return;
        SDL.numChannels = num;
        SDL.channels = [];
        for (var i = 0; i < num; i++) {
          SDL.channels[i] = {
            audio: null,
            volume: 1.0
          };
        }
      },setGetVolume:function (info, volume) {
        if (!info) return 0;
        var ret = info.volume * 128; // MIX_MAX_VOLUME
        if (volume != -1) {
          info.volume = volume / 128;
          if (info.audio) info.audio.volume = info.volume;
        }
        return ret;
      },debugSurface:function (surfData) {
        console.log('dumping surface ' + [surfData.surf, surfData.source, surfData.width, surfData.height]);
        var image = surfData.ctx.getImageData(0, 0, surfData.width, surfData.height);
        var data = image.data;
        var num = Math.min(surfData.width, surfData.height);
        for (var i = 0; i < num; i++) {
          console.log('   diagonal ' + i + ':' + [data[i*surfData.width*4 + i*4 + 0], data[i*surfData.width*4 + i*4 + 1], data[i*surfData.width*4 + i*4 + 2], data[i*surfData.width*4 + i*4 + 3]]);
        }
      },joystickEventState:0,lastJoystickState:{},joystickNamePool:{},recordJoystickState:function (joystick, state) {
        // Standardize button state.
        var buttons = new Array(state.buttons.length);
        for (var i = 0; i < state.buttons.length; i++) {
          buttons[i] = SDL.getJoystickButtonState(state.buttons[i]);
        }
        SDL.lastJoystickState[joystick] = {
          buttons: buttons,
          axes: state.axes.slice(0),
          timestamp: state.timestamp,
          index: state.index,
          id: state.id
        };
      },getJoystickButtonState:function (button) {
        if (typeof button === 'object') {
          // Current gamepad API editor's draft (Firefox Nightly)
          // https://dvcs.w3.org/hg/gamepad/raw-file/default/gamepad.html#idl-def-GamepadButton
          return button.pressed;
        } else {
          // Current gamepad API working draft (Firefox / Chrome Stable)
          // http://www.w3.org/TR/2012/WD-gamepad-20120529/#gamepad-interface
          return button > 0;
        }
      },queryJoysticks:function () {
        for (var joystick in SDL.lastJoystickState) {
          var state = SDL.getGamepad(joystick - 1);
          var prevState = SDL.lastJoystickState[joystick];
          // Check only if the timestamp has differed.
          // NOTE: Timestamp is not available in Firefox.
          if (typeof state.timestamp !== 'number' || state.timestamp !== prevState.timestamp) {
            var i;
            for (i = 0; i < state.buttons.length; i++) {
              var buttonState = SDL.getJoystickButtonState(state.buttons[i]);
              // NOTE: The previous state already has a boolean representation of
              //       its button, so no need to standardize its button state here.
              if (buttonState !== prevState.buttons[i]) {
                // Insert button-press event.
                SDL.events.push({
                  type: buttonState ? 'joystick_button_down' : 'joystick_button_up',
                  joystick: joystick,
                  index: joystick - 1,
                  button: i
                });
              }
            }
            for (i = 0; i < state.axes.length; i++) {
              if (state.axes[i] !== prevState.axes[i]) {
                // Insert axes-change event.
                SDL.events.push({
                  type: 'joystick_axis_motion',
                  joystick: joystick,
                  index: joystick - 1,
                  axis: i,
                  value: state.axes[i]
                });
              }
            }
            SDL.recordJoystickState(joystick, state);
          }
        }
      },joystickAxisValueConversion:function (value) {
        // Ensures that 0 is 0, 1 is 32767, and -1 is 32768.
        return Math.ceil(((value+1) * 32767.5) - 32768);
      },getGamepads:function () {
        var fcn = navigator.getGamepads || navigator.webkitGamepads || navigator.mozGamepads || navigator.gamepads || navigator.webkitGetGamepads;
        if (fcn !== undefined) {
          // The function must be applied on the navigator object.
          return fcn.apply(navigator);
        } else {
          return [];
        }
      },getGamepad:function (deviceIndex) {
        var gamepads = SDL.getGamepads();
        if (gamepads.length > deviceIndex && deviceIndex >= 0) {
          return gamepads[deviceIndex];
        }
        return null;
      }};function _SDL_PollEvent(ptr) {
      if (SDL.initFlags & 0x200 && SDL.joystickEventState) {
        // If SDL_INIT_JOYSTICK was supplied AND the joystick system is configured
        // to automatically query for events, query for joystick events.
        SDL.queryJoysticks();
      }
      if (SDL.events.length === 0) return 0;
      if (ptr) {
        SDL.makeCEvent(SDL.events.shift(), ptr);
      }
      return 1;
    }
  function _emscripten_asm_const_int(code) {
      var args = Array.prototype.slice.call(arguments, 1);
      return Runtime.getAsmConst(code, args.length).apply(null, args) | 0;
    }
  function _SDL_GL_SwapBuffers() {}
  function _SDL_Init(initFlags) {
      SDL.startTime = Date.now();
      SDL.initFlags = initFlags;
      // capture all key events. we just keep down and up, but also capture press to prevent default actions
      if (!Module['doNotCaptureKeyboard']) {
        document.addEventListener("keydown", SDL.receiveEvent);
        document.addEventListener("keyup", SDL.receiveEvent);
        document.addEventListener("keypress", SDL.receiveEvent);
        window.addEventListener("blur", SDL.receiveEvent);
        document.addEventListener("visibilitychange", SDL.receiveEvent);
      }
      if (initFlags & 0x200) {
        // SDL_INIT_JOYSTICK
        // Firefox will not give us Joystick data unless we register this NOP
        // callback.
        // https://bugzilla.mozilla.org/show_bug.cgi?id=936104
        addEventListener("gamepadconnected", function() {});
      }
      window.addEventListener("unload", SDL.receiveEvent);
      SDL.keyboardState = _malloc(0x10000); // Our SDL needs 512, but 64K is safe for older SDLs
      _memset(SDL.keyboardState, 0, 0x10000);
      // Initialize this structure carefully for closure
      SDL.DOMEventToSDLEvent['keydown'] = 0x300 /* SDL_KEYDOWN */;
      SDL.DOMEventToSDLEvent['keyup'] = 0x301 /* SDL_KEYUP */;
      SDL.DOMEventToSDLEvent['keypress'] = 0x303 /* SDL_TEXTINPUT */;
      SDL.DOMEventToSDLEvent['mousedown'] = 0x401 /* SDL_MOUSEBUTTONDOWN */;
      SDL.DOMEventToSDLEvent['mouseup'] = 0x402 /* SDL_MOUSEBUTTONUP */;
      SDL.DOMEventToSDLEvent['mousemove'] = 0x400 /* SDL_MOUSEMOTION */;
      SDL.DOMEventToSDLEvent['unload'] = 0x100 /* SDL_QUIT */;
      SDL.DOMEventToSDLEvent['resize'] = 0x7001 /* SDL_VIDEORESIZE/SDL_EVENT_COMPAT2 */;
      // These are not technically DOM events; the HTML gamepad API is poll-based.
      // However, we define them here, as the rest of the SDL code assumes that
      // all SDL events originate as DOM events.
      SDL.DOMEventToSDLEvent['joystick_axis_motion'] = 0x600 /* SDL_JOYAXISMOTION */;
      SDL.DOMEventToSDLEvent['joystick_button_down'] = 0x603 /* SDL_JOYBUTTONDOWN */;
      SDL.DOMEventToSDLEvent['joystick_button_up'] = 0x604 /* SDL_JOYBUTTONUP */;
      return 0; // success
    }
  function _SDL_GL_SetAttribute(attr, value) {
      if (!(attr in SDL.glAttributes)) {
        abort('Unknown SDL GL attribute (' + attr + '). Please check if your SDL version is supported.');
      }
      SDL.glAttributes[attr] = value;
    }
  function _SDL_SetVideoMode(width, height, depth, flags) {
      ['mousedown', 'mouseup', 'mousemove', 'DOMMouseScroll', 'mousewheel', 'mouseout'].forEach(function(event) {
        Module['canvas'].addEventListener(event, SDL.receiveEvent, true);
      });
      // (0,0) means 'use fullscreen' in native; in Emscripten, use the current canvas size.
      if (width == 0 && height == 0) {
        var canvas = Module['canvas'];
        width = canvas.width;
        height = canvas.height;
      }
      Browser.setCanvasSize(width, height, true);
      // Free the old surface first.
      if (SDL.screen) {
        SDL.freeSurface(SDL.screen);
        SDL.screen = null;
      }
      SDL.screen = SDL.makeSurface(width, height, flags, true, 'screen');
      if (!SDL.addedResizeListener) {
        SDL.addedResizeListener = true;
        Browser.resizeListeners.push(function(w, h) {
          SDL.receiveEvent({
            type: 'resize',
            w: w,
            h: h
          });
        });
      }
      return SDL.screen;
    }
  function _get_window_width() { return window.innerWidth; }
  function _get_window_height() { return window.innerHeight; }
  Module["_memcpy"] = _memcpy;var _llvm_memcpy_p0i8_p0i8_i32=_memcpy;
  var _cosf=Math_cos;
  function _fmin(x, y) {
      return isNaN(x) ? y : isNaN(y) ? x : Math.min(x, y);
    }var _fminf=_fmin;
  var _fabsf=Math_abs;
  var _tanf=Math_tan;
  var _sinf=Math_sin;
  function __exit(status) {
      // void _exit(int status);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/exit.html
      Module['exit'](status);
    }function _exit(status) {
      __exit(status);
    }function __ZSt9terminatev() {
      _exit(-1234);
    }
  Module["_memset"] = _memset;var _llvm_memset_p0i8_i64=_memset;
  function _llvm_lifetime_start() {}
  function _llvm_lifetime_end() {}
  var GL={counter:1,lastError:0,buffers:[],programs:[],framebuffers:[],renderbuffers:[],textures:[],uniforms:[],shaders:[],currArrayBuffer:0,currElementArrayBuffer:0,byteSizeByTypeRoot:5120,byteSizeByType:[1,1,2,2,4,4,4,2,3,4,8],programInfos:{},stringCache:{},packAlignment:4,unpackAlignment:4,init:function () {
        Browser.moduleContextCreatedCallbacks.push(GL.initExtensions);
      },recordError:function recordError(errorCode) {
        if (!GL.lastError) {
          GL.lastError = errorCode;
        }
      },getNewId:function (table) {
        var ret = GL.counter++;
        for (var i = table.length; i < ret; i++) {
          table[i] = null;
        }
        return ret;
      },MINI_TEMP_BUFFER_SIZE:16,miniTempBuffer:null,miniTempBufferViews:[0],MAX_TEMP_BUFFER_SIZE:2097152,tempBufferIndexLookup:null,tempVertexBuffers:null,tempIndexBuffers:null,tempQuadIndexBuffer:null,generateTempBuffers:function (quads) {
        GL.tempBufferIndexLookup = new Uint8Array(GL.MAX_TEMP_BUFFER_SIZE+1);
        GL.tempVertexBuffers = [];
        GL.tempIndexBuffers = [];
        var last = -1, curr = -1;
        var size = 1;
        for (var i = 0; i <= GL.MAX_TEMP_BUFFER_SIZE; i++) {
          if (i > size) {
            size <<= 1;
          }
          if (size != last) {
            curr++;
            GL.tempVertexBuffers[curr] = Module.ctx.createBuffer();
            Module.ctx.bindBuffer(Module.ctx.ARRAY_BUFFER, GL.tempVertexBuffers[curr]);
            Module.ctx.bufferData(Module.ctx.ARRAY_BUFFER, size, Module.ctx.DYNAMIC_DRAW);
            Module.ctx.bindBuffer(Module.ctx.ARRAY_BUFFER, null);
            GL.tempIndexBuffers[curr] = Module.ctx.createBuffer();
            Module.ctx.bindBuffer(Module.ctx.ELEMENT_ARRAY_BUFFER, GL.tempIndexBuffers[curr]);
            Module.ctx.bufferData(Module.ctx.ELEMENT_ARRAY_BUFFER, size, Module.ctx.DYNAMIC_DRAW);
            Module.ctx.bindBuffer(Module.ctx.ELEMENT_ARRAY_BUFFER, null);
            last = size;
          }
          GL.tempBufferIndexLookup[i] = curr;
        }
        if (quads) {
          // GL_QUAD indexes can be precalculated
          GL.tempQuadIndexBuffer = Module.ctx.createBuffer();
          Module.ctx.bindBuffer(Module.ctx.ELEMENT_ARRAY_BUFFER, GL.tempQuadIndexBuffer);
          var numIndexes = GL.MAX_TEMP_BUFFER_SIZE >> 1;
          var quadIndexes = new Uint16Array(numIndexes);
          var i = 0, v = 0;
          while (1) {
            quadIndexes[i++] = v;
            if (i >= numIndexes) break;
            quadIndexes[i++] = v+1;
            if (i >= numIndexes) break;
            quadIndexes[i++] = v+2;
            if (i >= numIndexes) break;
            quadIndexes[i++] = v;
            if (i >= numIndexes) break;
            quadIndexes[i++] = v+2;
            if (i >= numIndexes) break;
            quadIndexes[i++] = v+3;
            if (i >= numIndexes) break;
            v += 4;
          }
          Module.ctx.bufferData(Module.ctx.ELEMENT_ARRAY_BUFFER, quadIndexes, Module.ctx.STATIC_DRAW);
          Module.ctx.bindBuffer(Module.ctx.ELEMENT_ARRAY_BUFFER, null);
        }
      },findToken:function (source, token) {
        function isIdentChar(ch) {
          if (ch >= 48 && ch <= 57) // 0-9
            return true;
          if (ch >= 65 && ch <= 90) // A-Z
            return true;
          if (ch >= 97 && ch <= 122) // a-z
            return true;
          return false;
        }
        var i = -1;
        do {
          i = source.indexOf(token, i + 1);
          if (i < 0) {
            break;
          }
          if (i > 0 && isIdentChar(source[i - 1])) {
            continue;
          }
          i += token.length;
          if (i < source.length - 1 && isIdentChar(source[i + 1])) {
            continue;
          }
          return true;
        } while (true);
        return false;
      },getSource:function (shader, count, string, length) {
        var source = '';
        for (var i = 0; i < count; ++i) {
          var frag;
          if (length) {
            var len = HEAP32[(((length)+(i*4))>>2)];
            if (len < 0) {
              frag = Pointer_stringify(HEAP32[(((string)+(i*4))>>2)]);
            } else {
              frag = Pointer_stringify(HEAP32[(((string)+(i*4))>>2)], len);
            }
          } else {
            frag = Pointer_stringify(HEAP32[(((string)+(i*4))>>2)]);
          }
          source += frag;
        }
        // Let's see if we need to enable the standard derivatives extension
        type = Module.ctx.getShaderParameter(GL.shaders[shader], 0x8B4F /* GL_SHADER_TYPE */);
        if (type == 0x8B30 /* GL_FRAGMENT_SHADER */) {
          if (GL.findToken(source, "dFdx") ||
              GL.findToken(source, "dFdy") ||
              GL.findToken(source, "fwidth")) {
            source = "#extension GL_OES_standard_derivatives : enable\n" + source;
            var extension = Module.ctx.getExtension("OES_standard_derivatives");
          }
        }
        return source;
      },computeImageSize:function (width, height, sizePerPixel, alignment) {
        function roundedToNextMultipleOf(x, y) {
          return Math.floor((x + y - 1) / y) * y
        }
        var plainRowSize = width * sizePerPixel;
        var alignedRowSize = roundedToNextMultipleOf(plainRowSize, alignment);
        return (height <= 0) ? 0 :
                 ((height - 1) * alignedRowSize + plainRowSize);
      },getTexPixelData:function (type, format, width, height, pixels, internalFormat) {
        var sizePerPixel;
        switch (type) {
          case 0x1401 /* GL_UNSIGNED_BYTE */:
            switch (format) {
              case 0x1906 /* GL_ALPHA */:
              case 0x1909 /* GL_LUMINANCE */:
                sizePerPixel = 1;
                break;
              case 0x1907 /* GL_RGB */:
                sizePerPixel = 3;
                break;
              case 0x1908 /* GL_RGBA */:
                sizePerPixel = 4;
                break;
              case 0x190A /* GL_LUMINANCE_ALPHA */:
                sizePerPixel = 2;
                break;
              default:
                throw 'Invalid format (' + format + ')';
            }
            break;
          case 0x1403 /* GL_UNSIGNED_SHORT */:
            if (format == 0x1902 /* GL_DEPTH_COMPONENT */) {
              sizePerPixel = 2;
            } else {
              throw 'Invalid format (' + format + ')';
            }
            break;
          case 0x1405 /* GL_UNSIGNED_INT */:
            if (format == 0x1902 /* GL_DEPTH_COMPONENT */) {
              sizePerPixel = 4;
            } else {
              throw 'Invalid format (' + format + ')';
            }
            break;
          case 0x84FA /* UNSIGNED_INT_24_8_WEBGL */:
            sizePerPixel = 4;
            break;
          case 0x8363 /* GL_UNSIGNED_SHORT_5_6_5 */:
          case 0x8033 /* GL_UNSIGNED_SHORT_4_4_4_4 */:
          case 0x8034 /* GL_UNSIGNED_SHORT_5_5_5_1 */:
            sizePerPixel = 2;
            break;
          case 0x1406 /* GL_FLOAT */:
            switch (format) {
              case 0x1907 /* GL_RGB */:
                sizePerPixel = 3*4;
                break;
              case 0x1908 /* GL_RGBA */:
                sizePerPixel = 4*4;
                break;
              default:
                throw 'Invalid format (' + format + ')';
            }
            internalFormat = Module.ctx.RGBA;
            break;
          default:
            throw 'Invalid type (' + type + ')';
        }
        var bytes = GL.computeImageSize(width, height, sizePerPixel, GL.unpackAlignment);
        if (type == 0x1401 /* GL_UNSIGNED_BYTE */) {
          pixels = HEAPU8.subarray((pixels),(pixels+bytes));
        } else if (type == 0x1406 /* GL_FLOAT */) {
          pixels = HEAPF32.subarray((pixels)>>2,(pixels+bytes)>>2);
        } else if (type == 0x1405 /* GL_UNSIGNED_INT */ || type == 0x84FA /* UNSIGNED_INT_24_8_WEBGL */) {
          pixels = HEAPU32.subarray((pixels)>>2,(pixels+bytes)>>2);
        } else {
          pixels = HEAPU16.subarray((pixels)>>1,(pixels+bytes)>>1);
        }
        return {
          pixels: pixels,
          internalFormat: internalFormat
        }
      },initExtensions:function () {
        if (GL.initExtensions.done) return;
        GL.initExtensions.done = true;
        if (!Module.useWebGL) return; // an app might link both gl and 2d backends
        GL.miniTempBuffer = new Float32Array(GL.MINI_TEMP_BUFFER_SIZE);
        for (var i = 0; i < GL.MINI_TEMP_BUFFER_SIZE; i++) {
          GL.miniTempBufferViews[i] = GL.miniTempBuffer.subarray(0, i+1);
        }
        GL.maxVertexAttribs = Module.ctx.getParameter(Module.ctx.MAX_VERTEX_ATTRIBS);
        // Detect the presence of a few extensions manually, this GL interop layer itself will need to know if they exist. 
        GL.compressionExt = Module.ctx.getExtension('WEBGL_compressed_texture_s3tc') ||
                            Module.ctx.getExtension('MOZ_WEBGL_compressed_texture_s3tc') ||
                            Module.ctx.getExtension('WEBKIT_WEBGL_compressed_texture_s3tc');
        GL.anisotropicExt = Module.ctx.getExtension('EXT_texture_filter_anisotropic') ||
                            Module.ctx.getExtension('MOZ_EXT_texture_filter_anisotropic') ||
                            Module.ctx.getExtension('WEBKIT_EXT_texture_filter_anisotropic');
        GL.floatExt = Module.ctx.getExtension('OES_texture_float');
        // These are the 'safe' feature-enabling extensions that don't add any performance impact related to e.g. debugging, and
        // should be enabled by default so that client GLES2/GL code will not need to go through extra hoops to get its stuff working.
        // As new extensions are ratified at http://www.khronos.org/registry/webgl/extensions/ , feel free to add your new extensions
        // here, as long as they don't produce a performance impact for users that might not be using those extensions.
        // E.g. debugging-related extensions should probably be off by default.
        var automaticallyEnabledExtensions = [ "OES_texture_float", "OES_texture_half_float", "OES_standard_derivatives",
                                               "OES_vertex_array_object", "WEBGL_compressed_texture_s3tc", "WEBGL_depth_texture",
                                               "OES_element_index_uint", "EXT_texture_filter_anisotropic", "ANGLE_instanced_arrays",
                                               "OES_texture_float_linear", "OES_texture_half_float_linear", "WEBGL_compressed_texture_atc",
                                               "WEBGL_compressed_texture_pvrtc", "EXT_color_buffer_half_float", "WEBGL_color_buffer_float",
                                               "EXT_frag_depth", "EXT_sRGB", "WEBGL_draw_buffers", "WEBGL_shared_resources" ];
        function shouldEnableAutomatically(extension) {
          for(var i in automaticallyEnabledExtensions) {
            var include = automaticallyEnabledExtensions[i];
            if (ext.indexOf(include) != -1) {
              return true;
            }
          }
          return false;
        }
        var extensions = Module.ctx.getSupportedExtensions();
        for(var e in extensions) {
          var ext = extensions[e].replace('MOZ_', '').replace('WEBKIT_', '');
          if (automaticallyEnabledExtensions.indexOf(ext) != -1) {
            Module.ctx.getExtension(ext); // Calling .getExtension enables that extension permanently, no need to store the return value to be enabled.
          }
        }
      },populateUniformTable:function (program) {
        var p = GL.programs[program];
        GL.programInfos[program] = {
          uniforms: {},
          maxUniformLength: 0, // This is eagerly computed below, since we already enumerate all uniforms anyway.
          maxAttributeLength: -1 // This is lazily computed and cached, computed when/if first asked, "-1" meaning not computed yet.
        };
        var ptable = GL.programInfos[program];
        var utable = ptable.uniforms;
        // A program's uniform table maps the string name of an uniform to an integer location of that uniform.
        // The global GL.uniforms map maps integer locations to WebGLUniformLocations.
        var numUniforms = Module.ctx.getProgramParameter(p, Module.ctx.ACTIVE_UNIFORMS);
        for (var i = 0; i < numUniforms; ++i) {
          var u = Module.ctx.getActiveUniform(p, i);
          var name = u.name;
          ptable.maxUniformLength = Math.max(ptable.maxUniformLength, name.length+1);
          // Strip off any trailing array specifier we might have got, e.g. "[0]".
          if (name.indexOf(']', name.length-1) !== -1) {
            var ls = name.lastIndexOf('[');
            name = name.slice(0, ls);
          }
          // Optimize memory usage slightly: If we have an array of uniforms, e.g. 'vec3 colors[3];', then 
          // only store the string 'colors' in utable, and 'colors[0]', 'colors[1]' and 'colors[2]' will be parsed as 'colors'+i.
          // Note that for the GL.uniforms table, we still need to fetch the all WebGLUniformLocations for all the indices.
          var loc = Module.ctx.getUniformLocation(p, name);
          var id = GL.getNewId(GL.uniforms);
          utable[name] = [u.size, id];
          GL.uniforms[id] = loc;
          for (var j = 1; j < u.size; ++j) {
            var n = name + '['+j+']';
            loc = Module.ctx.getUniformLocation(p, n);
            id = GL.getNewId(GL.uniforms);
            GL.uniforms[id] = loc;
          }
        }
      }};function _glCreateProgram() {
      var id = GL.getNewId(GL.programs);
      var program = Module.ctx.createProgram();
      program.name = id;
      GL.programs[id] = program;
      return id;
    }
  function _glCreateShader(shaderType) {
      var id = GL.getNewId(GL.shaders);
      GL.shaders[id] = Module.ctx.createShader(shaderType);
      return id;
    }
  function _glShaderSource(shader, count, string, length) {
      var source = GL.getSource(shader, count, string, length);
      Module.ctx.shaderSource(GL.shaders[shader], source);
    }
  function _glCompileShader(shader) {
      Module.ctx.compileShader(GL.shaders[shader]);
    }
  function _glAttachShader(program, shader) {
      Module.ctx.attachShader(GL.programs[program],
                              GL.shaders[shader]);
    }
  function _glLinkProgram(program) {
      Module.ctx.linkProgram(GL.programs[program]);
      GL.programInfos[program] = null; // uniforms no longer keep the same names after linking
      GL.populateUniformTable(program);
    }
  function _glGetProgramiv(program, pname, p) {
      if (pname == 0x8B84) { // GL_INFO_LOG_LENGTH
        HEAP32[((p)>>2)]=Module.ctx.getProgramInfoLog(GL.programs[program]).length + 1;
      } else if (pname == 0x8B87 /* GL_ACTIVE_UNIFORM_MAX_LENGTH */) {
        var ptable = GL.programInfos[program];
        if (ptable) {
          HEAP32[((p)>>2)]=ptable.maxUniformLength;
          return;
        } else if (program < GL.counter) {
          GL.recordError(0x0502 /* GL_INVALID_OPERATION */);
        } else {
          GL.recordError(0x0501 /* GL_INVALID_VALUE */);
        }
      } else if (pname == 0x8B8A /* GL_ACTIVE_ATTRIBUTE_MAX_LENGTH */) {
        var ptable = GL.programInfos[program];
        if (ptable) {
          if (ptable.maxAttributeLength == -1) {
            var program = GL.programs[program];
            var numAttribs = Module.ctx.getProgramParameter(program, Module.ctx.ACTIVE_ATTRIBUTES);
            ptable.maxAttributeLength = 0; // Spec says if there are no active attribs, 0 must be returned.
            for(var i = 0; i < numAttribs; ++i) {
              var activeAttrib = Module.ctx.getActiveAttrib(program, i);
              ptable.maxAttributeLength = Math.max(ptable.maxAttributeLength, activeAttrib.name.length+1);
            }
          }
          HEAP32[((p)>>2)]=ptable.maxAttributeLength;
          return;
        } else if (program < GL.counter) {
          GL.recordError(0x0502 /* GL_INVALID_OPERATION */);
        } else {
          GL.recordError(0x0501 /* GL_INVALID_VALUE */);
        }
      } else {
        HEAP32[((p)>>2)]=Module.ctx.getProgramParameter(GL.programs[program], pname);
      }
    }
  function _atexit(func, arg) {
      __ATEXIT__.unshift({ func: func, arg: arg });
    }var ___cxa_atexit=_atexit;
  function _glGenTextures(n, textures) {
      for (var i = 0; i < n; i++) {
        var id = GL.getNewId(GL.textures);
        var texture = Module.ctx.createTexture();
        texture.name = id;
        GL.textures[id] = texture;
        HEAP32[(((textures)+(i*4))>>2)]=id;
      }
    }
  function _glBindTexture(target, texture) {
      Module.ctx.bindTexture(target, texture ? GL.textures[texture] : null);
    }
  function _glTexImage2D(target, level, internalFormat, width, height, border, format, type, pixels) {
      if (pixels) {
        var data = GL.getTexPixelData(type, format, width, height, pixels, internalFormat);
        pixels = data.pixels;
        internalFormat = data.internalFormat;
      } else {
        pixels = null;
      }
      Module.ctx.texImage2D(target, level, internalFormat, width, height, border, format, type, pixels);
    }
  function _glTexParameteri(x0, x1, x2) { Module.ctx.texParameteri(x0, x1, x2) }
  function _glDeleteTextures(n, textures) {
      for (var i = 0; i < n; i++) {
        var id = HEAP32[(((textures)+(i*4))>>2)];
        var texture = GL.textures[id];
        Module.ctx.deleteTexture(texture);
        texture.name = 0;
        GL.textures[id] = null;
      }
    }
  function _glClearColor(x0, x1, x2, x3) { Module.ctx.clearColor(x0, x1, x2, x3) }
  function _glEnable(x0) { Module.ctx.enable(x0) }
  function _glBlendFunc(x0, x1) { Module.ctx.blendFunc(x0, x1) }
  function _glGenBuffers(n, buffers) {
      for (var i = 0; i < n; i++) {
        var id = GL.getNewId(GL.buffers);
        var buffer = Module.ctx.createBuffer();
        buffer.name = id;
        GL.buffers[id] = buffer;
        HEAP32[(((buffers)+(i*4))>>2)]=id;
      }
    }
  function _glViewport(x0, x1, x2, x3) { Module.ctx.viewport(x0, x1, x2, x3) }
  function _glClear(x0) { Module.ctx.clear(x0) }
  function _glDisable(x0) { Module.ctx.disable(x0) }
  function _glBindBuffer(target, buffer) {
      var bufferObj = buffer ? GL.buffers[buffer] : null;
      if (target == Module.ctx.ARRAY_BUFFER) {
        GL.currArrayBuffer = buffer;
      } else if (target == Module.ctx.ELEMENT_ARRAY_BUFFER) {
        GL.currElementArrayBuffer = buffer;
      }
      Module.ctx.bindBuffer(target, bufferObj);
    }
  function _glBufferData(target, size, data, usage) {
      switch (usage) { // fix usages, WebGL only has *_DRAW
        case 0x88E1: // GL_STREAM_READ
        case 0x88E2: // GL_STREAM_COPY
          usage = 0x88E0; // GL_STREAM_DRAW
          break;
        case 0x88E5: // GL_STATIC_READ
        case 0x88E6: // GL_STATIC_COPY
          usage = 0x88E4; // GL_STATIC_DRAW
          break;
        case 0x88E9: // GL_DYNAMIC_READ
        case 0x88EA: // GL_DYNAMIC_COPY
          usage = 0x88E8; // GL_DYNAMIC_DRAW
          break;
      }
      Module.ctx.bufferData(target, HEAPU8.subarray(data, data+size), usage);
    }
  function _glUniformMatrix4fv(location, count, transpose, value) {
      location = GL.uniforms[location];
      var view;
      if (count == 1) {
        // avoid allocation for the common case of uploading one uniform matrix
        view = GL.miniTempBufferViews[15];
        for (var i = 0; i < 16; i++) {
          view[i] = HEAPF32[(((value)+(i*4))>>2)];
        }
      } else {
        view = HEAPF32.subarray((value)>>2,(value+count*64)>>2);
      }
      Module.ctx.uniformMatrix4fv(location, transpose, view);
    }
  function _glDrawArrays(mode, first, count) {
      Module.ctx.drawArrays(mode, first, count);
    }
  function _glUniform4fv(location, count, value) {
      location = GL.uniforms[location];
      var view;
      if (count == 1) {
        // avoid allocation for the common case of uploading one uniform
        view = GL.miniTempBufferViews[3];
        view[0] = HEAPF32[((value)>>2)];
        view[1] = HEAPF32[(((value)+(4))>>2)];
        view[2] = HEAPF32[(((value)+(8))>>2)];
        view[3] = HEAPF32[(((value)+(12))>>2)];
      } else {
        view = HEAPF32.subarray((value)>>2,(value+count*16)>>2);
      }
      Module.ctx.uniform4fv(location, view);
    }
  function __ZSt18uncaught_exceptionv() { // std::uncaught_exception()
      return !!__ZSt18uncaught_exceptionv.uncaught_exception;
    }function ___cxa_begin_catch(ptr) {
      __ZSt18uncaught_exceptionv.uncaught_exception--;
      return ptr;
    }
  function _llvm_eh_exception() {
      return HEAP32[((_llvm_eh_exception.buf)>>2)];
    }
  function ___cxa_free_exception(ptr) {
      try {
        return _free(ptr);
      } catch(e) { // XXX FIXME
      }
    }function ___cxa_end_catch() {
      if (___cxa_end_catch.rethrown) {
        ___cxa_end_catch.rethrown = false;
        return;
      }
      // Clear state flag.
      asm['setThrew'](0);
      // Clear type.
      HEAP32[(((_llvm_eh_exception.buf)+(4))>>2)]=0
      // Call destructor if one is registered then clear it.
      var ptr = HEAP32[((_llvm_eh_exception.buf)>>2)];
      var destructor = HEAP32[(((_llvm_eh_exception.buf)+(8))>>2)];
      if (destructor) {
        Runtime.dynCall('vi', destructor, [ptr]);
        HEAP32[(((_llvm_eh_exception.buf)+(8))>>2)]=0
      }
      // Free ptr if it isn't null.
      if (ptr) {
        ___cxa_free_exception(ptr);
        HEAP32[((_llvm_eh_exception.buf)>>2)]=0
      }
    }function ___cxa_rethrow() {
      ___cxa_end_catch.rethrown = true;
      throw HEAP32[((_llvm_eh_exception.buf)>>2)] + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";;
    }
  Module["_memmove"] = _memmove;var _llvm_memmove_p0i8_p0i8_i32=_memmove;
  function _glDisableVertexAttribArray(index) {
      Module.ctx.disableVertexAttribArray(index);
    }
  function _glUseProgram(program) {
      Module.ctx.useProgram(program ? GL.programs[program] : null);
    }
  function _glEnableVertexAttribArray(index) {
      Module.ctx.enableVertexAttribArray(index);
    }
  function _glVertexAttribPointer(index, size, type, normalized, stride, ptr) {
      Module.ctx.vertexAttribPointer(index, size, type, normalized, stride, ptr);
    }
  var _sqrtf=Math_sqrt;
  function _glGetAttribLocation(program, name) {
      program = GL.programs[program];
      name = Pointer_stringify(name);
      return Module.ctx.getAttribLocation(program, name);
    }
  function _glGetUniformLocation(program, name) {
      name = Pointer_stringify(name);
      var arrayOffset = 0;
      // If user passed an array accessor "[index]", parse the array index off the accessor.
      if (name.indexOf(']', name.length-1) !== -1) {
        var ls = name.lastIndexOf('[');
        var arrayIndex = name.slice(ls+1, -1);
        if (arrayIndex.length > 0) {
          arrayOffset = parseInt(arrayIndex);
          if (arrayOffset < 0) {
            return -1;
          }
        }
        name = name.slice(0, ls);
      }
      var ptable = GL.programInfos[program];
      if (!ptable) {
        return -1;
      }
      var utable = ptable.uniforms;
      var uniformInfo = utable[name]; // returns pair [ dimension_of_uniform_array, uniform_location ]
      if (uniformInfo && arrayOffset < uniformInfo[0]) { // Check if user asked for an out-of-bounds element, i.e. for 'vec4 colors[3];' user could ask for 'colors[10]' which should return -1.
        return uniformInfo[1]+arrayOffset;
      } else {
        return -1;
      }
    }
  function ___cxa_pure_virtual() {
      ABORT = true;
      throw 'Pure virtual function called!';
    }
  var SOCKFS={mount:function (mount) {
        return FS.createNode(null, '/', 16384 | 0777, 0);
      },createSocket:function (family, type, protocol) {
        var streaming = type == 1;
        if (protocol) {
          assert(streaming == (protocol == 6)); // if SOCK_STREAM, must be tcp
        }
        // create our internal socket structure
        var sock = {
          family: family,
          type: type,
          protocol: protocol,
          server: null,
          peers: {},
          pending: [],
          recv_queue: [],
          sock_ops: SOCKFS.websocket_sock_ops
        };
        // create the filesystem node to store the socket structure
        var name = SOCKFS.nextname();
        var node = FS.createNode(SOCKFS.root, name, 49152, 0);
        node.sock = sock;
        // and the wrapping stream that enables library functions such
        // as read and write to indirectly interact with the socket
        var stream = FS.createStream({
          path: name,
          node: node,
          flags: FS.modeStringToFlags('r+'),
          seekable: false,
          stream_ops: SOCKFS.stream_ops
        });
        // map the new stream to the socket structure (sockets have a 1:1
        // relationship with a stream)
        sock.stream = stream;
        return sock;
      },getSocket:function (fd) {
        var stream = FS.getStream(fd);
        if (!stream || !FS.isSocket(stream.node.mode)) {
          return null;
        }
        return stream.node.sock;
      },stream_ops:{poll:function (stream) {
          var sock = stream.node.sock;
          return sock.sock_ops.poll(sock);
        },ioctl:function (stream, request, varargs) {
          var sock = stream.node.sock;
          return sock.sock_ops.ioctl(sock, request, varargs);
        },read:function (stream, buffer, offset, length, position /* ignored */) {
          var sock = stream.node.sock;
          var msg = sock.sock_ops.recvmsg(sock, length);
          if (!msg) {
            // socket is closed
            return 0;
          }
          buffer.set(msg.buffer, offset);
          return msg.buffer.length;
        },write:function (stream, buffer, offset, length, position /* ignored */) {
          var sock = stream.node.sock;
          return sock.sock_ops.sendmsg(sock, buffer, offset, length);
        },close:function (stream) {
          var sock = stream.node.sock;
          sock.sock_ops.close(sock);
        }},nextname:function () {
        if (!SOCKFS.nextname.current) {
          SOCKFS.nextname.current = 0;
        }
        return 'socket[' + (SOCKFS.nextname.current++) + ']';
      },websocket_sock_ops:{createPeer:function (sock, addr, port) {
          var ws;
          if (typeof addr === 'object') {
            ws = addr;
            addr = null;
            port = null;
          }
          if (ws) {
            // for sockets that've already connected (e.g. we're the server)
            // we can inspect the _socket property for the address
            if (ws._socket) {
              addr = ws._socket.remoteAddress;
              port = ws._socket.remotePort;
            }
            // if we're just now initializing a connection to the remote,
            // inspect the url property
            else {
              var result = /ws[s]?:\/\/([^:]+):(\d+)/.exec(ws.url);
              if (!result) {
                throw new Error('WebSocket URL must be in the format ws(s)://address:port');
              }
              addr = result[1];
              port = parseInt(result[2], 10);
            }
          } else {
            // create the actual websocket object and connect
            try {
              var url = 'ws://' + addr + ':' + port;
              // the node ws library API is slightly different than the browser's
              var opts = ENVIRONMENT_IS_NODE ? {headers: {'websocket-protocol': ['binary']}} : ['binary'];
              // If node we use the ws library.
              var WebSocket = ENVIRONMENT_IS_NODE ? require('ws') : window['WebSocket'];
              ws = new WebSocket(url, opts);
              ws.binaryType = 'arraybuffer';
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EHOSTUNREACH);
            }
          }
          var peer = {
            addr: addr,
            port: port,
            socket: ws,
            dgram_send_queue: []
          };
          SOCKFS.websocket_sock_ops.addPeer(sock, peer);
          SOCKFS.websocket_sock_ops.handlePeerEvents(sock, peer);
          // if this is a bound dgram socket, send the port number first to allow
          // us to override the ephemeral port reported to us by remotePort on the
          // remote end.
          if (sock.type === 2 && typeof sock.sport !== 'undefined') {
            peer.dgram_send_queue.push(new Uint8Array([
                255, 255, 255, 255,
                'p'.charCodeAt(0), 'o'.charCodeAt(0), 'r'.charCodeAt(0), 't'.charCodeAt(0),
                ((sock.sport & 0xff00) >> 8) , (sock.sport & 0xff)
            ]));
          }
          return peer;
        },getPeer:function (sock, addr, port) {
          return sock.peers[addr + ':' + port];
        },addPeer:function (sock, peer) {
          sock.peers[peer.addr + ':' + peer.port] = peer;
        },removePeer:function (sock, peer) {
          delete sock.peers[peer.addr + ':' + peer.port];
        },handlePeerEvents:function (sock, peer) {
          var first = true;
          var handleOpen = function () {
            try {
              var queued = peer.dgram_send_queue.shift();
              while (queued) {
                peer.socket.send(queued);
                queued = peer.dgram_send_queue.shift();
              }
            } catch (e) {
              // not much we can do here in the way of proper error handling as we've already
              // lied and said this data was sent. shut it down.
              peer.socket.close();
            }
          };
          function handleMessage(data) {
            assert(typeof data !== 'string' && data.byteLength !== undefined);  // must receive an ArrayBuffer
            data = new Uint8Array(data);  // make a typed array view on the array buffer
            // if this is the port message, override the peer's port with it
            var wasfirst = first;
            first = false;
            if (wasfirst &&
                data.length === 10 &&
                data[0] === 255 && data[1] === 255 && data[2] === 255 && data[3] === 255 &&
                data[4] === 'p'.charCodeAt(0) && data[5] === 'o'.charCodeAt(0) && data[6] === 'r'.charCodeAt(0) && data[7] === 't'.charCodeAt(0)) {
              // update the peer's port and it's key in the peer map
              var newport = ((data[8] << 8) | data[9]);
              SOCKFS.websocket_sock_ops.removePeer(sock, peer);
              peer.port = newport;
              SOCKFS.websocket_sock_ops.addPeer(sock, peer);
              return;
            }
            sock.recv_queue.push({ addr: peer.addr, port: peer.port, data: data });
          };
          if (ENVIRONMENT_IS_NODE) {
            peer.socket.on('open', handleOpen);
            peer.socket.on('message', function(data, flags) {
              if (!flags.binary) {
                return;
              }
              handleMessage((new Uint8Array(data)).buffer);  // copy from node Buffer -> ArrayBuffer
            });
            peer.socket.on('error', function() {
              // don't throw
            });
          } else {
            peer.socket.onopen = handleOpen;
            peer.socket.onmessage = function peer_socket_onmessage(event) {
              handleMessage(event.data);
            };
          }
        },poll:function (sock) {
          if (sock.type === 1 && sock.server) {
            // listen sockets should only say they're available for reading
            // if there are pending clients.
            return sock.pending.length ? (64 | 1) : 0;
          }
          var mask = 0;
          var dest = sock.type === 1 ?  // we only care about the socket state for connection-based sockets
            SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport) :
            null;
          if (sock.recv_queue.length ||
              !dest ||  // connection-less sockets are always ready to read
              (dest && dest.socket.readyState === dest.socket.CLOSING) ||
              (dest && dest.socket.readyState === dest.socket.CLOSED)) {  // let recv return 0 once closed
            mask |= (64 | 1);
          }
          if (!dest ||  // connection-less sockets are always ready to write
              (dest && dest.socket.readyState === dest.socket.OPEN)) {
            mask |= 4;
          }
          if ((dest && dest.socket.readyState === dest.socket.CLOSING) ||
              (dest && dest.socket.readyState === dest.socket.CLOSED)) {
            mask |= 16;
          }
          return mask;
        },ioctl:function (sock, request, arg) {
          switch (request) {
            case 21531:
              var bytes = 0;
              if (sock.recv_queue.length) {
                bytes = sock.recv_queue[0].data.length;
              }
              HEAP32[((arg)>>2)]=bytes;
              return 0;
            default:
              return ERRNO_CODES.EINVAL;
          }
        },close:function (sock) {
          // if we've spawned a listen server, close it
          if (sock.server) {
            try {
              sock.server.close();
            } catch (e) {
            }
            sock.server = null;
          }
          // close any peer connections
          var peers = Object.keys(sock.peers);
          for (var i = 0; i < peers.length; i++) {
            var peer = sock.peers[peers[i]];
            try {
              peer.socket.close();
            } catch (e) {
            }
            SOCKFS.websocket_sock_ops.removePeer(sock, peer);
          }
          return 0;
        },bind:function (sock, addr, port) {
          if (typeof sock.saddr !== 'undefined' || typeof sock.sport !== 'undefined') {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);  // already bound
          }
          sock.saddr = addr;
          sock.sport = port || _mkport();
          // in order to emulate dgram sockets, we need to launch a listen server when
          // binding on a connection-less socket
          // note: this is only required on the server side
          if (sock.type === 2) {
            // close the existing server if it exists
            if (sock.server) {
              sock.server.close();
              sock.server = null;
            }
            // swallow error operation not supported error that occurs when binding in the
            // browser where this isn't supported
            try {
              sock.sock_ops.listen(sock, 0);
            } catch (e) {
              if (!(e instanceof FS.ErrnoError)) throw e;
              if (e.errno !== ERRNO_CODES.EOPNOTSUPP) throw e;
            }
          }
        },connect:function (sock, addr, port) {
          if (sock.server) {
            throw new FS.ErrnoError(ERRNO_CODS.EOPNOTSUPP);
          }
          // TODO autobind
          // if (!sock.addr && sock.type == 2) {
          // }
          // early out if we're already connected / in the middle of connecting
          if (typeof sock.daddr !== 'undefined' && typeof sock.dport !== 'undefined') {
            var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
            if (dest) {
              if (dest.socket.readyState === dest.socket.CONNECTING) {
                throw new FS.ErrnoError(ERRNO_CODES.EALREADY);
              } else {
                throw new FS.ErrnoError(ERRNO_CODES.EISCONN);
              }
            }
          }
          // add the socket to our peer list and set our
          // destination address / port to match
          var peer = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
          sock.daddr = peer.addr;
          sock.dport = peer.port;
          // always "fail" in non-blocking mode
          throw new FS.ErrnoError(ERRNO_CODES.EINPROGRESS);
        },listen:function (sock, backlog) {
          if (!ENVIRONMENT_IS_NODE) {
            throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
          }
          if (sock.server) {
             throw new FS.ErrnoError(ERRNO_CODES.EINVAL);  // already listening
          }
          var WebSocketServer = require('ws').Server;
          var host = sock.saddr;
          sock.server = new WebSocketServer({
            host: host,
            port: sock.sport
            // TODO support backlog
          });
          sock.server.on('connection', function(ws) {
            if (sock.type === 1) {
              var newsock = SOCKFS.createSocket(sock.family, sock.type, sock.protocol);
              // create a peer on the new socket
              var peer = SOCKFS.websocket_sock_ops.createPeer(newsock, ws);
              newsock.daddr = peer.addr;
              newsock.dport = peer.port;
              // push to queue for accept to pick up
              sock.pending.push(newsock);
            } else {
              // create a peer on the listen socket so calling sendto
              // with the listen socket and an address will resolve
              // to the correct client
              SOCKFS.websocket_sock_ops.createPeer(sock, ws);
            }
          });
          sock.server.on('closed', function() {
            sock.server = null;
          });
          sock.server.on('error', function() {
            // don't throw
          });
        },accept:function (listensock) {
          if (!listensock.server) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          var newsock = listensock.pending.shift();
          newsock.stream.flags = listensock.stream.flags;
          return newsock;
        },getname:function (sock, peer) {
          var addr, port;
          if (peer) {
            if (sock.daddr === undefined || sock.dport === undefined) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
            }
            addr = sock.daddr;
            port = sock.dport;
          } else {
            // TODO saddr and sport will be set for bind()'d UDP sockets, but what
            // should we be returning for TCP sockets that've been connect()'d?
            addr = sock.saddr || 0;
            port = sock.sport || 0;
          }
          return { addr: addr, port: port };
        },sendmsg:function (sock, buffer, offset, length, addr, port) {
          if (sock.type === 2) {
            // connection-less sockets will honor the message address,
            // and otherwise fall back to the bound destination address
            if (addr === undefined || port === undefined) {
              addr = sock.daddr;
              port = sock.dport;
            }
            // if there was no address to fall back to, error out
            if (addr === undefined || port === undefined) {
              throw new FS.ErrnoError(ERRNO_CODES.EDESTADDRREQ);
            }
          } else {
            // connection-based sockets will only use the bound
            addr = sock.daddr;
            port = sock.dport;
          }
          // find the peer for the destination address
          var dest = SOCKFS.websocket_sock_ops.getPeer(sock, addr, port);
          // early out if not connected with a connection-based socket
          if (sock.type === 1) {
            if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
            } else if (dest.socket.readyState === dest.socket.CONNECTING) {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
          }
          // create a copy of the incoming data to send, as the WebSocket API
          // doesn't work entirely with an ArrayBufferView, it'll just send
          // the entire underlying buffer
          var data;
          if (buffer instanceof Array || buffer instanceof ArrayBuffer) {
            data = buffer.slice(offset, offset + length);
          } else {  // ArrayBufferView
            data = buffer.buffer.slice(buffer.byteOffset + offset, buffer.byteOffset + offset + length);
          }
          // if we're emulating a connection-less dgram socket and don't have
          // a cached connection, queue the buffer to send upon connect and
          // lie, saying the data was sent now.
          if (sock.type === 2) {
            if (!dest || dest.socket.readyState !== dest.socket.OPEN) {
              // if we're not connected, open a new connection
              if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                dest = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
              }
              dest.dgram_send_queue.push(data);
              return length;
            }
          }
          try {
            // send the actual data
            dest.socket.send(data);
            return length;
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
        },recvmsg:function (sock, length) {
          // http://pubs.opengroup.org/onlinepubs/7908799/xns/recvmsg.html
          if (sock.type === 1 && sock.server) {
            // tcp servers should not be recv()'ing on the listen socket
            throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
          }
          var queued = sock.recv_queue.shift();
          if (!queued) {
            if (sock.type === 1) {
              var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
              if (!dest) {
                // if we have a destination address but are not connected, error out
                throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
              }
              else if (dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                // return null if the socket has closed
                return null;
              }
              else {
                // else, our socket is in a valid state but truly has nothing available
                throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
              }
            } else {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
          }
          // queued.data will be an ArrayBuffer if it's unadulterated, but if it's
          // requeued TCP data it'll be an ArrayBufferView
          var queuedLength = queued.data.byteLength || queued.data.length;
          var queuedOffset = queued.data.byteOffset || 0;
          var queuedBuffer = queued.data.buffer || queued.data;
          var bytesRead = Math.min(length, queuedLength);
          var res = {
            buffer: new Uint8Array(queuedBuffer, queuedOffset, bytesRead),
            addr: queued.addr,
            port: queued.port
          };
          // push back any unread data for TCP connections
          if (sock.type === 1 && bytesRead < queuedLength) {
            var bytesRemaining = queuedLength - bytesRead;
            queued.data = new Uint8Array(queuedBuffer, queuedOffset + bytesRead, bytesRemaining);
            sock.recv_queue.unshift(queued);
          }
          return res;
        }}};function _send(fd, buf, len, flags) {
      var sock = SOCKFS.getSocket(fd);
      if (!sock) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      // TODO honor flags
      return _write(fd, buf, len);
    }
  function _pwrite(fildes, buf, nbyte, offset) {
      // ssize_t pwrite(int fildes, const void *buf, size_t nbyte, off_t offset);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        var slab = HEAP8;
        return FS.write(stream, slab, buf, nbyte, offset);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _write(fildes, buf, nbyte) {
      // ssize_t write(int fildes, const void *buf, size_t nbyte);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        var slab = HEAP8;
        return FS.write(stream, slab, buf, nbyte);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }
  Module["_strlen"] = _strlen;function _fputs(s, stream) {
      // int fputs(const char *restrict s, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fputs.html
      return _write(stream, s, _strlen(s));
    }
  function _fputc(c, stream) {
      // int fputc(int c, FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fputc.html
      var chr = unSign(c & 0xFF);
      HEAP8[((_fputc.ret)|0)]=chr
      var ret = _write(stream, _fputc.ret, 1);
      if (ret == -1) {
        var streamObj = FS.getStream(stream);
        if (streamObj) streamObj.error = true;
        return -1;
      } else {
        return chr;
      }
    }function _puts(s) {
      // int puts(const char *s);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/puts.html
      // NOTE: puts() always writes an extra newline.
      var stdout = HEAP32[((_stdout)>>2)];
      var ret = _fputs(s, stdout);
      if (ret < 0) {
        return ret;
      } else {
        var newlineRet = _fputc(10, stdout);
        return (newlineRet < 0) ? -1 : ret + 1;
      }
    }
  function _fmod(x, y) {
      return x % y;
    }
  var _llvm_pow_f32=Math_pow;
  var _llvm_memset_p0i8_i32=_memset;
  function _srand(seed) {}
  function _time(ptr) {
      var ret = Math.floor(Date.now()/1000);
      if (ptr) {
        HEAP32[((ptr)>>2)]=ret
      }
      return ret;
    }
  function _strdup(ptr) {
      var len = _strlen(ptr);
      var newStr = _malloc(len + 1);
      (_memcpy(newStr, ptr, len)|0);
      HEAP8[(((newStr)+(len))|0)]=0;
      return newStr;
    }
  function _gettimeofday(ptr) {
      var now = Date.now();
      HEAP32[((ptr)>>2)]=Math.floor(now/1000); // seconds
      HEAP32[(((ptr)+(4))>>2)]=Math.floor((now-1000*Math.floor(now/1000))*1000); // microseconds
      return 0;
    }
  Module["_strcpy"] = _strcpy;
  var _environ=allocate(1, "i32*", ALLOC_STATIC);var ___environ=_environ;function ___buildEnvironment(env) {
      // WARNING: Arbitrary limit!
      var MAX_ENV_VALUES = 64;
      var TOTAL_ENV_SIZE = 1024;
      // Statically allocate memory for the environment.
      var poolPtr;
      var envPtr;
      if (!___buildEnvironment.called) {
        ___buildEnvironment.called = true;
        // Set default values. Use string keys for Closure Compiler compatibility.
        ENV['USER'] = 'root';
        ENV['PATH'] = '/';
        ENV['PWD'] = '/';
        ENV['HOME'] = '/home/emscripten';
        ENV['LANG'] = 'en_US.UTF-8';
        ENV['_'] = './this.program';
        // Allocate memory.
        poolPtr = allocate(TOTAL_ENV_SIZE, 'i8', ALLOC_STATIC);
        envPtr = allocate(MAX_ENV_VALUES * 4,
                          'i8*', ALLOC_STATIC);
        HEAP32[((envPtr)>>2)]=poolPtr
        HEAP32[((_environ)>>2)]=envPtr;
      } else {
        envPtr = HEAP32[((_environ)>>2)];
        poolPtr = HEAP32[((envPtr)>>2)];
      }
      // Collect key=value lines.
      var strings = [];
      var totalSize = 0;
      for (var key in env) {
        if (typeof env[key] === 'string') {
          var line = key + '=' + env[key];
          strings.push(line);
          totalSize += line.length;
        }
      }
      if (totalSize > TOTAL_ENV_SIZE) {
        throw new Error('Environment size exceeded TOTAL_ENV_SIZE!');
      }
      // Make new.
      var ptrSize = 4;
      for (var i = 0; i < strings.length; i++) {
        var line = strings[i];
        writeAsciiToMemory(line, poolPtr);
        HEAP32[(((envPtr)+(i * ptrSize))>>2)]=poolPtr;
        poolPtr += line.length + 1;
      }
      HEAP32[(((envPtr)+(strings.length * ptrSize))>>2)]=0;
    }var ENV={};function _getenv(name) {
      // char *getenv(const char *name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/getenv.html
      if (name === 0) return 0;
      name = Pointer_stringify(name);
      if (!ENV.hasOwnProperty(name)) return 0;
      if (_getenv.ret) _free(_getenv.ret);
      _getenv.ret = allocate(intArrayFromString(ENV[name]), 'i8', ALLOC_NORMAL);
      return _getenv.ret;
    }
  Module["_strcat"] = _strcat;
  function _stat(path, buf, dontResolveLastLink) {
      // http://pubs.opengroup.org/onlinepubs/7908799/xsh/stat.html
      // int stat(const char *path, struct stat *buf);
      // NOTE: dontResolveLastLink is a shortcut for lstat(). It should never be
      //       used in client code.
      path = typeof path !== 'string' ? Pointer_stringify(path) : path;
      try {
        var stat = dontResolveLastLink ? FS.lstat(path) : FS.stat(path);
        HEAP32[((buf)>>2)]=stat.dev;
        HEAP32[(((buf)+(4))>>2)]=0;
        HEAP32[(((buf)+(8))>>2)]=stat.ino;
        HEAP32[(((buf)+(12))>>2)]=stat.mode
        HEAP32[(((buf)+(16))>>2)]=stat.nlink
        HEAP32[(((buf)+(20))>>2)]=stat.uid
        HEAP32[(((buf)+(24))>>2)]=stat.gid
        HEAP32[(((buf)+(28))>>2)]=stat.rdev
        HEAP32[(((buf)+(32))>>2)]=0;
        HEAP32[(((buf)+(36))>>2)]=stat.size
        HEAP32[(((buf)+(40))>>2)]=4096
        HEAP32[(((buf)+(44))>>2)]=stat.blocks
        HEAP32[(((buf)+(48))>>2)]=Math.floor(stat.atime.getTime() / 1000)
        HEAP32[(((buf)+(52))>>2)]=0
        HEAP32[(((buf)+(56))>>2)]=Math.floor(stat.mtime.getTime() / 1000)
        HEAP32[(((buf)+(60))>>2)]=0
        HEAP32[(((buf)+(64))>>2)]=Math.floor(stat.ctime.getTime() / 1000)
        HEAP32[(((buf)+(68))>>2)]=0
        HEAP32[(((buf)+(72))>>2)]=stat.ino
        return 0;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }
  function _mknod(path, mode, dev) {
      // int mknod(const char *path, mode_t mode, dev_t dev);
      // http://pubs.opengroup.org/onlinepubs/7908799/xsh/mknod.html
      path = Pointer_stringify(path);
      // we don't want this in the JS API as the JS API
      // uses mknod to create all nodes.
      switch (mode & 61440) {
        case 32768:
        case 8192:
        case 24576:
        case 4096:
        case 49152:
          break;
        default:
          ___setErrNo(ERRNO_CODES.EINVAL);
          return -1;
      }
      try {
        FS.mknod(path, mode, dev);
        return 0;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _mkdir(path, mode) {
      // int mkdir(const char *path, mode_t mode);
      // http://pubs.opengroup.org/onlinepubs/7908799/xsh/mkdir.html
      path = Pointer_stringify(path);
      try {
        FS.mkdir(path, mode, 0);
        return 0;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }
  function _llvm_umul_with_overflow_i32(x, y) {
      x = x>>>0;
      y = y>>>0;
      return ((asm["setTempRet0"](x*y > 4294967295),(x*y)>>>0)|0);
    }
  function ___cxa_allocate_exception(size) {
      return _malloc(size);
    }
  function ___cxa_is_number_type(type) {
      var isNumber = false;
      try { if (type == __ZTIi) isNumber = true } catch(e){}
      try { if (type == __ZTIj) isNumber = true } catch(e){}
      try { if (type == __ZTIl) isNumber = true } catch(e){}
      try { if (type == __ZTIm) isNumber = true } catch(e){}
      try { if (type == __ZTIx) isNumber = true } catch(e){}
      try { if (type == __ZTIy) isNumber = true } catch(e){}
      try { if (type == __ZTIf) isNumber = true } catch(e){}
      try { if (type == __ZTId) isNumber = true } catch(e){}
      try { if (type == __ZTIe) isNumber = true } catch(e){}
      try { if (type == __ZTIc) isNumber = true } catch(e){}
      try { if (type == __ZTIa) isNumber = true } catch(e){}
      try { if (type == __ZTIh) isNumber = true } catch(e){}
      try { if (type == __ZTIs) isNumber = true } catch(e){}
      try { if (type == __ZTIt) isNumber = true } catch(e){}
      return isNumber;
    }function ___cxa_does_inherit(definiteType, possibilityType, possibility) {
      if (possibility == 0) return false;
      if (possibilityType == 0 || possibilityType == definiteType)
        return true;
      var possibility_type_info;
      if (___cxa_is_number_type(possibilityType)) {
        possibility_type_info = possibilityType;
      } else {
        var possibility_type_infoAddr = HEAP32[((possibilityType)>>2)] - 8;
        possibility_type_info = HEAP32[((possibility_type_infoAddr)>>2)];
      }
      switch (possibility_type_info) {
      case 0: // possibility is a pointer
        // See if definite type is a pointer
        var definite_type_infoAddr = HEAP32[((definiteType)>>2)] - 8;
        var definite_type_info = HEAP32[((definite_type_infoAddr)>>2)];
        if (definite_type_info == 0) {
          // Also a pointer; compare base types of pointers
          var defPointerBaseAddr = definiteType+8;
          var defPointerBaseType = HEAP32[((defPointerBaseAddr)>>2)];
          var possPointerBaseAddr = possibilityType+8;
          var possPointerBaseType = HEAP32[((possPointerBaseAddr)>>2)];
          return ___cxa_does_inherit(defPointerBaseType, possPointerBaseType, possibility);
        } else
          return false; // one pointer and one non-pointer
      case 1: // class with no base class
        return false;
      case 2: // class with base class
        var parentTypeAddr = possibilityType + 8;
        var parentType = HEAP32[((parentTypeAddr)>>2)];
        return ___cxa_does_inherit(definiteType, parentType, possibility);
      default:
        return false; // some unencountered type
      }
    }
  function ___resumeException(ptr) {
      if (HEAP32[((_llvm_eh_exception.buf)>>2)] == 0) HEAP32[((_llvm_eh_exception.buf)>>2)]=ptr;
      throw ptr + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";;
    }function ___cxa_find_matching_catch(thrown, throwntype) {
      if (thrown == -1) thrown = HEAP32[((_llvm_eh_exception.buf)>>2)];
      if (throwntype == -1) throwntype = HEAP32[(((_llvm_eh_exception.buf)+(4))>>2)];
      var typeArray = Array.prototype.slice.call(arguments, 2);
      // If throwntype is a pointer, this means a pointer has been
      // thrown. When a pointer is thrown, actually what's thrown
      // is a pointer to the pointer. We'll dereference it.
      if (throwntype != 0 && !___cxa_is_number_type(throwntype)) {
        var throwntypeInfoAddr= HEAP32[((throwntype)>>2)] - 8;
        var throwntypeInfo= HEAP32[((throwntypeInfoAddr)>>2)];
        if (throwntypeInfo == 0)
          thrown = HEAP32[((thrown)>>2)];
      }
      // The different catch blocks are denoted by different types.
      // Due to inheritance, those types may not precisely match the
      // type of the thrown object. Find one which matches, and
      // return the type of the catch block which should be called.
      for (var i = 0; i < typeArray.length; i++) {
        if (___cxa_does_inherit(typeArray[i], throwntype, thrown))
          return ((asm["setTempRet0"](typeArray[i]),thrown)|0);
      }
      // Shouldn't happen unless we have bogus data in typeArray
      // or encounter a type for which emscripten doesn't have suitable
      // typeinfo defined. Best-efforts match just in case.
      return ((asm["setTempRet0"](throwntype),thrown)|0);
    }function ___cxa_throw(ptr, type, destructor) {
      if (!___cxa_throw.initialized) {
        try {
          HEAP32[((__ZTVN10__cxxabiv119__pointer_type_infoE)>>2)]=0; // Workaround for libcxxabi integration bug
        } catch(e){}
        try {
          HEAP32[((__ZTVN10__cxxabiv117__class_type_infoE)>>2)]=1; // Workaround for libcxxabi integration bug
        } catch(e){}
        try {
          HEAP32[((__ZTVN10__cxxabiv120__si_class_type_infoE)>>2)]=2; // Workaround for libcxxabi integration bug
        } catch(e){}
        ___cxa_throw.initialized = true;
      }
      HEAP32[((_llvm_eh_exception.buf)>>2)]=ptr
      HEAP32[(((_llvm_eh_exception.buf)+(4))>>2)]=type
      HEAP32[(((_llvm_eh_exception.buf)+(8))>>2)]=destructor
      if (!("uncaught_exception" in __ZSt18uncaught_exceptionv)) {
        __ZSt18uncaught_exceptionv.uncaught_exception = 1;
      } else {
        __ZSt18uncaught_exceptionv.uncaught_exception++;
      }
      throw ptr + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";;
    }
  function _rand() {
      return Math.floor(Math.random()*0x80000000);
    }
  function _open(path, oflag, varargs) {
      // int open(const char *path, int oflag, ...);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/open.html
      var mode = HEAP32[((varargs)>>2)];
      path = Pointer_stringify(path);
      try {
        var stream = FS.open(path, oflag, mode);
        return stream.fd;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _fopen(filename, mode) {
      // FILE *fopen(const char *restrict filename, const char *restrict mode);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fopen.html
      var flags;
      mode = Pointer_stringify(mode);
      if (mode[0] == 'r') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 0;
        }
      } else if (mode[0] == 'w') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 1;
        }
        flags |= 64;
        flags |= 512;
      } else if (mode[0] == 'a') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 1;
        }
        flags |= 64;
        flags |= 1024;
      } else {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return 0;
      }
      var ret = _open(filename, flags, allocate([0x1FF, 0, 0, 0], 'i32', ALLOC_STACK));  // All creation permissions.
      return (ret == -1) ? 0 : ret;
    }
  function _recv(fd, buf, len, flags) {
      var sock = SOCKFS.getSocket(fd);
      if (!sock) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      // TODO honor flags
      return _read(fd, buf, len);
    }
  function _pread(fildes, buf, nbyte, offset) {
      // ssize_t pread(int fildes, void *buf, size_t nbyte, off_t offset);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/read.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        var slab = HEAP8;
        return FS.read(stream, slab, buf, nbyte, offset);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _read(fildes, buf, nbyte) {
      // ssize_t read(int fildes, void *buf, size_t nbyte);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/read.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        var slab = HEAP8;
        return FS.read(stream, slab, buf, nbyte);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _fread(ptr, size, nitems, stream) {
      // size_t fread(void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fread.html
      var bytesToRead = nitems * size;
      if (bytesToRead == 0) {
        return 0;
      }
      var bytesRead = 0;
      var streamObj = FS.getStream(stream);
      while (streamObj.ungotten.length && bytesToRead > 0) {
        HEAP8[((ptr++)|0)]=streamObj.ungotten.pop()
        bytesToRead--;
        bytesRead++;
      }
      var err = _read(stream, ptr, bytesToRead);
      if (err == -1) {
        if (streamObj) streamObj.error = true;
        return 0;
      }
      bytesRead += err;
      if (bytesRead < bytesToRead) streamObj.eof = true;
      return Math.floor(bytesRead / size);
    }
  function _close(fildes) {
      // int close(int fildes);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/close.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        FS.close(stream);
        return 0;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }
  function _fsync(fildes) {
      // int fsync(int fildes);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fsync.html
      var stream = FS.getStream(fildes);
      if (stream) {
        // We write directly to the file system, so there's nothing to do here.
        return 0;
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
    }function _fclose(stream) {
      // int fclose(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fclose.html
      _fsync(stream);
      return _close(stream);
    }
  function _fwrite(ptr, size, nitems, stream) {
      // size_t fwrite(const void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fwrite.html
      var bytesToWrite = nitems * size;
      if (bytesToWrite == 0) return 0;
      var bytesWritten = _write(stream, ptr, bytesToWrite);
      if (bytesWritten == -1) {
        var streamObj = FS.getStream(stream);
        if (streamObj) streamObj.error = true;
        return 0;
      } else {
        return Math.floor(bytesWritten / size);
      }
    }
  function _pthread_mutex_lock() {}
  function _pthread_mutex_unlock() {}
  function ___cxa_guard_acquire(variable) {
      if (!HEAP8[(variable)]) { // ignore SAFE_HEAP stuff because llvm mixes i64 and i8 here
        HEAP8[(variable)]=1;
        return 1;
      }
      return 0;
    }
  function ___cxa_guard_release() {}
  function _pthread_cond_broadcast() {
      return 0;
    }
  function _pthread_cond_wait() {
      return 0;
    }
  function _ungetc(c, stream) {
      // int ungetc(int c, FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/ungetc.html
      stream = FS.getStream(stream);
      if (!stream) {
        return -1;
      }
      if (c === -1) {
        // do nothing for EOF character
        return c;
      }
      c = unSign(c & 0xFF);
      stream.ungotten.push(c);
      stream.eof = false;
      return c;
    }
  function _fgetc(stream) {
      // int fgetc(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fgetc.html
      var streamObj = FS.getStream(stream);
      if (!streamObj) return -1;
      if (streamObj.eof || streamObj.error) return -1;
      var ret = _fread(_fgetc.ret, 1, 1, stream);
      if (ret == 0) {
        return -1;
      } else if (ret == -1) {
        streamObj.error = true;
        return -1;
      } else {
        return HEAPU8[((_fgetc.ret)|0)];
      }
    }var _getc=_fgetc;
  function ___errno_location() {
      return ___errno_state;
    }
  function _strerror_r(errnum, strerrbuf, buflen) {
      if (errnum in ERRNO_MESSAGES) {
        if (ERRNO_MESSAGES[errnum].length > buflen - 1) {
          return ___setErrNo(ERRNO_CODES.ERANGE);
        } else {
          var msg = ERRNO_MESSAGES[errnum];
          writeAsciiToMemory(msg, strerrbuf);
          return 0;
        }
      } else {
        return ___setErrNo(ERRNO_CODES.EINVAL);
      }
    }function _strerror(errnum) {
      if (!_strerror.buffer) _strerror.buffer = _malloc(256);
      _strerror_r(errnum, _strerror.buffer, 256);
      return _strerror.buffer;
    }
  function _abort() {
      Module['abort']();
    }
  function __reallyNegative(x) {
      return x < 0 || (x === 0 && (1/x) === -Infinity);
    }function __formatString(format, varargs) {
      var textIndex = format;
      var argIndex = 0;
      function getNextArg(type) {
        // NOTE: Explicitly ignoring type safety. Otherwise this fails:
        //       int x = 4; printf("%c\n", (char)x);
        var ret;
        if (type === 'double') {
          ret = HEAPF64[(((varargs)+(argIndex))>>3)];
        } else if (type == 'i64') {
          ret = [HEAP32[(((varargs)+(argIndex))>>2)],
                 HEAP32[(((varargs)+(argIndex+8))>>2)]];
          argIndex += 8; // each 32-bit chunk is in a 64-bit block
        } else {
          type = 'i32'; // varargs are always i32, i64, or double
          ret = HEAP32[(((varargs)+(argIndex))>>2)];
        }
        argIndex += Math.max(Runtime.getNativeFieldSize(type), Runtime.getAlignSize(type, null, true));
        return ret;
      }
      var ret = [];
      var curr, next, currArg;
      while(1) {
        var startTextIndex = textIndex;
        curr = HEAP8[(textIndex)];
        if (curr === 0) break;
        next = HEAP8[((textIndex+1)|0)];
        if (curr == 37) {
          // Handle flags.
          var flagAlwaysSigned = false;
          var flagLeftAlign = false;
          var flagAlternative = false;
          var flagZeroPad = false;
          var flagPadSign = false;
          flagsLoop: while (1) {
            switch (next) {
              case 43:
                flagAlwaysSigned = true;
                break;
              case 45:
                flagLeftAlign = true;
                break;
              case 35:
                flagAlternative = true;
                break;
              case 48:
                if (flagZeroPad) {
                  break flagsLoop;
                } else {
                  flagZeroPad = true;
                  break;
                }
              case 32:
                flagPadSign = true;
                break;
              default:
                break flagsLoop;
            }
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
          }
          // Handle width.
          var width = 0;
          if (next == 42) {
            width = getNextArg('i32');
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
          } else {
            while (next >= 48 && next <= 57) {
              width = width * 10 + (next - 48);
              textIndex++;
              next = HEAP8[((textIndex+1)|0)];
            }
          }
          // Handle precision.
          var precisionSet = false;
          if (next == 46) {
            var precision = 0;
            precisionSet = true;
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
            if (next == 42) {
              precision = getNextArg('i32');
              textIndex++;
            } else {
              while(1) {
                var precisionChr = HEAP8[((textIndex+1)|0)];
                if (precisionChr < 48 ||
                    precisionChr > 57) break;
                precision = precision * 10 + (precisionChr - 48);
                textIndex++;
              }
            }
            next = HEAP8[((textIndex+1)|0)];
          } else {
            var precision = 6; // Standard default.
          }
          // Handle integer sizes. WARNING: These assume a 32-bit architecture!
          var argSize;
          switch (String.fromCharCode(next)) {
            case 'h':
              var nextNext = HEAP8[((textIndex+2)|0)];
              if (nextNext == 104) {
                textIndex++;
                argSize = 1; // char (actually i32 in varargs)
              } else {
                argSize = 2; // short (actually i32 in varargs)
              }
              break;
            case 'l':
              var nextNext = HEAP8[((textIndex+2)|0)];
              if (nextNext == 108) {
                textIndex++;
                argSize = 8; // long long
              } else {
                argSize = 4; // long
              }
              break;
            case 'L': // long long
            case 'q': // int64_t
            case 'j': // intmax_t
              argSize = 8;
              break;
            case 'z': // size_t
            case 't': // ptrdiff_t
            case 'I': // signed ptrdiff_t or unsigned size_t
              argSize = 4;
              break;
            default:
              argSize = null;
          }
          if (argSize) textIndex++;
          next = HEAP8[((textIndex+1)|0)];
          // Handle type specifier.
          switch (String.fromCharCode(next)) {
            case 'd': case 'i': case 'u': case 'o': case 'x': case 'X': case 'p': {
              // Integer.
              var signed = next == 100 || next == 105;
              argSize = argSize || 4;
              var currArg = getNextArg('i' + (argSize * 8));
              var origArg = currArg;
              var argText;
              // Flatten i64-1 [low, high] into a (slightly rounded) double
              if (argSize == 8) {
                currArg = Runtime.makeBigInt(currArg[0], currArg[1], next == 117);
              }
              // Truncate to requested size.
              if (argSize <= 4) {
                var limit = Math.pow(256, argSize) - 1;
                currArg = (signed ? reSign : unSign)(currArg & limit, argSize * 8);
              }
              // Format the number.
              var currAbsArg = Math.abs(currArg);
              var prefix = '';
              if (next == 100 || next == 105) {
                if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], null); else
                argText = reSign(currArg, 8 * argSize, 1).toString(10);
              } else if (next == 117) {
                if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], true); else
                argText = unSign(currArg, 8 * argSize, 1).toString(10);
                currArg = Math.abs(currArg);
              } else if (next == 111) {
                argText = (flagAlternative ? '0' : '') + currAbsArg.toString(8);
              } else if (next == 120 || next == 88) {
                prefix = (flagAlternative && currArg != 0) ? '0x' : '';
                if (argSize == 8 && i64Math) {
                  if (origArg[1]) {
                    argText = (origArg[1]>>>0).toString(16);
                    var lower = (origArg[0]>>>0).toString(16);
                    while (lower.length < 8) lower = '0' + lower;
                    argText += lower;
                  } else {
                    argText = (origArg[0]>>>0).toString(16);
                  }
                } else
                if (currArg < 0) {
                  // Represent negative numbers in hex as 2's complement.
                  currArg = -currArg;
                  argText = (currAbsArg - 1).toString(16);
                  var buffer = [];
                  for (var i = 0; i < argText.length; i++) {
                    buffer.push((0xF - parseInt(argText[i], 16)).toString(16));
                  }
                  argText = buffer.join('');
                  while (argText.length < argSize * 2) argText = 'f' + argText;
                } else {
                  argText = currAbsArg.toString(16);
                }
                if (next == 88) {
                  prefix = prefix.toUpperCase();
                  argText = argText.toUpperCase();
                }
              } else if (next == 112) {
                if (currAbsArg === 0) {
                  argText = '(nil)';
                } else {
                  prefix = '0x';
                  argText = currAbsArg.toString(16);
                }
              }
              if (precisionSet) {
                while (argText.length < precision) {
                  argText = '0' + argText;
                }
              }
              // Add sign if needed
              if (currArg >= 0) {
                if (flagAlwaysSigned) {
                  prefix = '+' + prefix;
                } else if (flagPadSign) {
                  prefix = ' ' + prefix;
                }
              }
              // Move sign to prefix so we zero-pad after the sign
              if (argText.charAt(0) == '-') {
                prefix = '-' + prefix;
                argText = argText.substr(1);
              }
              // Add padding.
              while (prefix.length + argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad) {
                    argText = '0' + argText;
                  } else {
                    prefix = ' ' + prefix;
                  }
                }
              }
              // Insert the result into the buffer.
              argText = prefix + argText;
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 'f': case 'F': case 'e': case 'E': case 'g': case 'G': {
              // Float.
              var currArg = getNextArg('double');
              var argText;
              if (isNaN(currArg)) {
                argText = 'nan';
                flagZeroPad = false;
              } else if (!isFinite(currArg)) {
                argText = (currArg < 0 ? '-' : '') + 'inf';
                flagZeroPad = false;
              } else {
                var isGeneral = false;
                var effectivePrecision = Math.min(precision, 20);
                // Convert g/G to f/F or e/E, as per:
                // http://pubs.opengroup.org/onlinepubs/9699919799/functions/printf.html
                if (next == 103 || next == 71) {
                  isGeneral = true;
                  precision = precision || 1;
                  var exponent = parseInt(currArg.toExponential(effectivePrecision).split('e')[1], 10);
                  if (precision > exponent && exponent >= -4) {
                    next = ((next == 103) ? 'f' : 'F').charCodeAt(0);
                    precision -= exponent + 1;
                  } else {
                    next = ((next == 103) ? 'e' : 'E').charCodeAt(0);
                    precision--;
                  }
                  effectivePrecision = Math.min(precision, 20);
                }
                if (next == 101 || next == 69) {
                  argText = currArg.toExponential(effectivePrecision);
                  // Make sure the exponent has at least 2 digits.
                  if (/[eE][-+]\d$/.test(argText)) {
                    argText = argText.slice(0, -1) + '0' + argText.slice(-1);
                  }
                } else if (next == 102 || next == 70) {
                  argText = currArg.toFixed(effectivePrecision);
                  if (currArg === 0 && __reallyNegative(currArg)) {
                    argText = '-' + argText;
                  }
                }
                var parts = argText.split('e');
                if (isGeneral && !flagAlternative) {
                  // Discard trailing zeros and periods.
                  while (parts[0].length > 1 && parts[0].indexOf('.') != -1 &&
                         (parts[0].slice(-1) == '0' || parts[0].slice(-1) == '.')) {
                    parts[0] = parts[0].slice(0, -1);
                  }
                } else {
                  // Make sure we have a period in alternative mode.
                  if (flagAlternative && argText.indexOf('.') == -1) parts[0] += '.';
                  // Zero pad until required precision.
                  while (precision > effectivePrecision++) parts[0] += '0';
                }
                argText = parts[0] + (parts.length > 1 ? 'e' + parts[1] : '');
                // Capitalize 'E' if needed.
                if (next == 69) argText = argText.toUpperCase();
                // Add sign.
                if (currArg >= 0) {
                  if (flagAlwaysSigned) {
                    argText = '+' + argText;
                  } else if (flagPadSign) {
                    argText = ' ' + argText;
                  }
                }
              }
              // Add padding.
              while (argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad && (argText[0] == '-' || argText[0] == '+')) {
                    argText = argText[0] + '0' + argText.slice(1);
                  } else {
                    argText = (flagZeroPad ? '0' : ' ') + argText;
                  }
                }
              }
              // Adjust case.
              if (next < 97) argText = argText.toUpperCase();
              // Insert the result into the buffer.
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 's': {
              // String.
              var arg = getNextArg('i8*');
              var argLength = arg ? _strlen(arg) : '(null)'.length;
              if (precisionSet) argLength = Math.min(argLength, precision);
              if (!flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              if (arg) {
                for (var i = 0; i < argLength; i++) {
                  ret.push(HEAPU8[((arg++)|0)]);
                }
              } else {
                ret = ret.concat(intArrayFromString('(null)'.substr(0, argLength), true));
              }
              if (flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              break;
            }
            case 'c': {
              // Character.
              if (flagLeftAlign) ret.push(getNextArg('i8'));
              while (--width > 0) {
                ret.push(32);
              }
              if (!flagLeftAlign) ret.push(getNextArg('i8'));
              break;
            }
            case 'n': {
              // Write the length written so far to the next parameter.
              var ptr = getNextArg('i32*');
              HEAP32[((ptr)>>2)]=ret.length
              break;
            }
            case '%': {
              // Literal percent sign.
              ret.push(curr);
              break;
            }
            default: {
              // Unknown specifiers remain untouched.
              for (var i = startTextIndex; i < textIndex + 2; i++) {
                ret.push(HEAP8[(i)]);
              }
            }
          }
          textIndex += 2;
          // TODO: Support a/A (hex float) and m (last error) specifiers.
          // TODO: Support %1${specifier} for arg selection.
        } else {
          ret.push(curr);
          textIndex += 1;
        }
      }
      return ret;
    }function _snprintf(s, n, format, varargs) {
      // int snprintf(char *restrict s, size_t n, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var result = __formatString(format, varargs);
      var limit = (n === undefined) ? result.length
                                    : Math.min(result.length, Math.max(n - 1, 0));
      if (s < 0) {
        s = -s;
        var buf = _malloc(limit+1);
        HEAP32[((s)>>2)]=buf;
        s = buf;
      }
      for (var i = 0; i < limit; i++) {
        HEAP8[(((s)+(i))|0)]=result[i];
      }
      if (limit < n || (n === undefined)) HEAP8[(((s)+(i))|0)]=0;
      return result.length;
    }
  function _sysconf(name) {
      // long sysconf(int name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/sysconf.html
      switch(name) {
        case 30: return PAGE_SIZE;
        case 132:
        case 133:
        case 12:
        case 137:
        case 138:
        case 15:
        case 235:
        case 16:
        case 17:
        case 18:
        case 19:
        case 20:
        case 149:
        case 13:
        case 10:
        case 236:
        case 153:
        case 9:
        case 21:
        case 22:
        case 159:
        case 154:
        case 14:
        case 77:
        case 78:
        case 139:
        case 80:
        case 81:
        case 79:
        case 82:
        case 68:
        case 67:
        case 164:
        case 11:
        case 29:
        case 47:
        case 48:
        case 95:
        case 52:
        case 51:
        case 46:
          return 200809;
        case 27:
        case 246:
        case 127:
        case 128:
        case 23:
        case 24:
        case 160:
        case 161:
        case 181:
        case 182:
        case 242:
        case 183:
        case 184:
        case 243:
        case 244:
        case 245:
        case 165:
        case 178:
        case 179:
        case 49:
        case 50:
        case 168:
        case 169:
        case 175:
        case 170:
        case 171:
        case 172:
        case 97:
        case 76:
        case 32:
        case 173:
        case 35:
          return -1;
        case 176:
        case 177:
        case 7:
        case 155:
        case 8:
        case 157:
        case 125:
        case 126:
        case 92:
        case 93:
        case 129:
        case 130:
        case 131:
        case 94:
        case 91:
          return 1;
        case 74:
        case 60:
        case 69:
        case 70:
        case 4:
          return 1024;
        case 31:
        case 42:
        case 72:
          return 32;
        case 87:
        case 26:
        case 33:
          return 2147483647;
        case 34:
        case 1:
          return 47839;
        case 38:
        case 36:
          return 99;
        case 43:
        case 37:
          return 2048;
        case 0: return 2097152;
        case 3: return 65536;
        case 28: return 32768;
        case 44: return 32767;
        case 75: return 16384;
        case 39: return 1000;
        case 89: return 700;
        case 71: return 256;
        case 40: return 255;
        case 2: return 100;
        case 180: return 64;
        case 25: return 20;
        case 5: return 16;
        case 6: return 6;
        case 73: return 4;
        case 84: return 1;
      }
      ___setErrNo(ERRNO_CODES.EINVAL);
      return -1;
    }
  function ___cxa_guard_abort() {}
  function _isxdigit(chr) {
      return (chr >= 48 && chr <= 57) ||
             (chr >= 97 && chr <= 102) ||
             (chr >= 65 && chr <= 70);
    }var _isxdigit_l=_isxdigit;
  function _isdigit(chr) {
      return chr >= 48 && chr <= 57;
    }var _isdigit_l=_isdigit;
  function __getFloat(text) {
      return /^[+-]?[0-9]*\.?[0-9]+([eE][+-]?[0-9]+)?/.exec(text);
    }function __scanString(format, get, unget, varargs) {
      if (!__scanString.whiteSpace) {
        __scanString.whiteSpace = {};
        __scanString.whiteSpace[32] = 1;
        __scanString.whiteSpace[9] = 1;
        __scanString.whiteSpace[10] = 1;
        __scanString.whiteSpace[11] = 1;
        __scanString.whiteSpace[12] = 1;
        __scanString.whiteSpace[13] = 1;
      }
      // Supports %x, %4x, %d.%d, %lld, %s, %f, %lf.
      // TODO: Support all format specifiers.
      format = Pointer_stringify(format);
      var soFar = 0;
      if (format.indexOf('%n') >= 0) {
        // need to track soFar
        var _get = get;
        get = function get() {
          soFar++;
          return _get();
        }
        var _unget = unget;
        unget = function unget() {
          soFar--;
          return _unget();
        }
      }
      var formatIndex = 0;
      var argsi = 0;
      var fields = 0;
      var argIndex = 0;
      var next;
      mainLoop:
      for (var formatIndex = 0; formatIndex < format.length;) {
        if (format[formatIndex] === '%' && format[formatIndex+1] == 'n') {
          var argPtr = HEAP32[(((varargs)+(argIndex))>>2)];
          argIndex += Runtime.getAlignSize('void*', null, true);
          HEAP32[((argPtr)>>2)]=soFar;
          formatIndex += 2;
          continue;
        }
        if (format[formatIndex] === '%') {
          var nextC = format.indexOf('c', formatIndex+1);
          if (nextC > 0) {
            var maxx = 1;
            if (nextC > formatIndex+1) {
              var sub = format.substring(formatIndex+1, nextC);
              maxx = parseInt(sub);
              if (maxx != sub) maxx = 0;
            }
            if (maxx) {
              var argPtr = HEAP32[(((varargs)+(argIndex))>>2)];
              argIndex += Runtime.getAlignSize('void*', null, true);
              fields++;
              for (var i = 0; i < maxx; i++) {
                next = get();
                HEAP8[((argPtr++)|0)]=next;
              }
              formatIndex += nextC - formatIndex + 1;
              continue;
            }
          }
        }
        // handle %[...]
        if (format[formatIndex] === '%' && format.indexOf('[', formatIndex+1) > 0) {
          var match = /\%([0-9]*)\[(\^)?(\]?[^\]]*)\]/.exec(format.substring(formatIndex));
          if (match) {
            var maxNumCharacters = parseInt(match[1]) || Infinity;
            var negateScanList = (match[2] === '^');
            var scanList = match[3];
            // expand "middle" dashs into character sets
            var middleDashMatch;
            while ((middleDashMatch = /([^\-])\-([^\-])/.exec(scanList))) {
              var rangeStartCharCode = middleDashMatch[1].charCodeAt(0);
              var rangeEndCharCode = middleDashMatch[2].charCodeAt(0);
              for (var expanded = ''; rangeStartCharCode <= rangeEndCharCode; expanded += String.fromCharCode(rangeStartCharCode++));
              scanList = scanList.replace(middleDashMatch[1] + '-' + middleDashMatch[2], expanded);
            }
            var argPtr = HEAP32[(((varargs)+(argIndex))>>2)];
            argIndex += Runtime.getAlignSize('void*', null, true);
            fields++;
            for (var i = 0; i < maxNumCharacters; i++) {
              next = get();
              if (negateScanList) {
                if (scanList.indexOf(String.fromCharCode(next)) < 0) {
                  HEAP8[((argPtr++)|0)]=next;
                } else {
                  unget();
                  break;
                }
              } else {
                if (scanList.indexOf(String.fromCharCode(next)) >= 0) {
                  HEAP8[((argPtr++)|0)]=next;
                } else {
                  unget();
                  break;
                }
              }
            }
            // write out null-terminating character
            HEAP8[((argPtr++)|0)]=0;
            formatIndex += match[0].length;
            continue;
          }
        }      
        // remove whitespace
        while (1) {
          next = get();
          if (next == 0) return fields;
          if (!(next in __scanString.whiteSpace)) break;
        }
        unget();
        if (format[formatIndex] === '%') {
          formatIndex++;
          var suppressAssignment = false;
          if (format[formatIndex] == '*') {
            suppressAssignment = true;
            formatIndex++;
          }
          var maxSpecifierStart = formatIndex;
          while (format[formatIndex].charCodeAt(0) >= 48 &&
                 format[formatIndex].charCodeAt(0) <= 57) {
            formatIndex++;
          }
          var max_;
          if (formatIndex != maxSpecifierStart) {
            max_ = parseInt(format.slice(maxSpecifierStart, formatIndex), 10);
          }
          var long_ = false;
          var half = false;
          var longLong = false;
          if (format[formatIndex] == 'l') {
            long_ = true;
            formatIndex++;
            if (format[formatIndex] == 'l') {
              longLong = true;
              formatIndex++;
            }
          } else if (format[formatIndex] == 'h') {
            half = true;
            formatIndex++;
          }
          var type = format[formatIndex];
          formatIndex++;
          var curr = 0;
          var buffer = [];
          // Read characters according to the format. floats are trickier, they may be in an unfloat state in the middle, then be a valid float later
          if (type == 'f' || type == 'e' || type == 'g' ||
              type == 'F' || type == 'E' || type == 'G') {
            next = get();
            while (next > 0 && (!(next in __scanString.whiteSpace)))  {
              buffer.push(String.fromCharCode(next));
              next = get();
            }
            var m = __getFloat(buffer.join(''));
            var last = m ? m[0].length : 0;
            for (var i = 0; i < buffer.length - last + 1; i++) {
              unget();
            }
            buffer.length = last;
          } else {
            next = get();
            var first = true;
            // Strip the optional 0x prefix for %x.
            if ((type == 'x' || type == 'X') && (next == 48)) {
              var peek = get();
              if (peek == 120 || peek == 88) {
                next = get();
              } else {
                unget();
              }
            }
            while ((curr < max_ || isNaN(max_)) && next > 0) {
              if (!(next in __scanString.whiteSpace) && // stop on whitespace
                  (type == 's' ||
                   ((type === 'd' || type == 'u' || type == 'i') && ((next >= 48 && next <= 57) ||
                                                                     (first && next == 45))) ||
                   ((type === 'x' || type === 'X') && (next >= 48 && next <= 57 ||
                                     next >= 97 && next <= 102 ||
                                     next >= 65 && next <= 70))) &&
                  (formatIndex >= format.length || next !== format[formatIndex].charCodeAt(0))) { // Stop when we read something that is coming up
                buffer.push(String.fromCharCode(next));
                next = get();
                curr++;
                first = false;
              } else {
                break;
              }
            }
            unget();
          }
          if (buffer.length === 0) return 0;  // Failure.
          if (suppressAssignment) continue;
          var text = buffer.join('');
          var argPtr = HEAP32[(((varargs)+(argIndex))>>2)];
          argIndex += Runtime.getAlignSize('void*', null, true);
          switch (type) {
            case 'd': case 'u': case 'i':
              if (half) {
                HEAP16[((argPtr)>>1)]=parseInt(text, 10);
              } else if (longLong) {
                (tempI64 = [parseInt(text, 10)>>>0,(tempDouble=parseInt(text, 10),(+(Math_abs(tempDouble))) >= (+1) ? (tempDouble > (+0) ? ((Math_min((+(Math_floor((tempDouble)/(+4294967296)))), (+4294967295)))|0)>>>0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble)))>>>0))/(+4294967296))))))>>>0) : 0)],HEAP32[((argPtr)>>2)]=tempI64[0],HEAP32[(((argPtr)+(4))>>2)]=tempI64[1]);
              } else {
                HEAP32[((argPtr)>>2)]=parseInt(text, 10);
              }
              break;
            case 'X':
            case 'x':
              HEAP32[((argPtr)>>2)]=parseInt(text, 16)
              break;
            case 'F':
            case 'f':
            case 'E':
            case 'e':
            case 'G':
            case 'g':
            case 'E':
              // fallthrough intended
              if (long_) {
                HEAPF64[((argPtr)>>3)]=parseFloat(text)
              } else {
                HEAPF32[((argPtr)>>2)]=parseFloat(text)
              }
              break;
            case 's':
              var array = intArrayFromString(text);
              for (var j = 0; j < array.length; j++) {
                HEAP8[(((argPtr)+(j))|0)]=array[j]
              }
              break;
          }
          fields++;
        } else if (format[formatIndex].charCodeAt(0) in __scanString.whiteSpace) {
          next = get();
          while (next in __scanString.whiteSpace) {
            if (next <= 0) break mainLoop;  // End of input.
            next = get();
          }
          unget(next);
          formatIndex++;
        } else {
          // Not a specifier.
          next = get();
          if (format[formatIndex].charCodeAt(0) !== next) {
            unget(next);
            break mainLoop;
          }
          formatIndex++;
        }
      }
      return fields;
    }function _sscanf(s, format, varargs) {
      // int sscanf(const char *restrict s, const char *restrict format, ... );
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/scanf.html
      var index = 0;
      function get() { return HEAP8[(((s)+(index++))|0)]; };
      function unget() { index--; };
      return __scanString(format, get, unget, varargs);
    }
  function _catopen() { throw 'TODO: ' + aborter }
  function _catgets() { throw 'TODO: ' + aborter }
  function _catclose() { throw 'TODO: ' + aborter }
  function _newlocale(mask, locale, base) {
      return _malloc(4);
    }
  function _freelocale(locale) {
      _free(locale);
    }
  function _isascii(chr) {
      return chr >= 0 && (chr & 0x80) == 0;
    }
  function ___ctype_b_loc() {
      // http://refspecs.freestandards.org/LSB_3.0.0/LSB-Core-generic/LSB-Core-generic/baselib---ctype-b-loc.html
      var me = ___ctype_b_loc;
      if (!me.ret) {
        var values = [
          0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
          0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
          0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,8195,8194,8194,8194,8194,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,24577,49156,49156,49156,
          49156,49156,49156,49156,49156,49156,49156,49156,49156,49156,49156,49156,55304,55304,55304,55304,55304,55304,55304,55304,
          55304,55304,49156,49156,49156,49156,49156,49156,49156,54536,54536,54536,54536,54536,54536,50440,50440,50440,50440,50440,
          50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,49156,49156,49156,49156,49156,
          49156,54792,54792,54792,54792,54792,54792,50696,50696,50696,50696,50696,50696,50696,50696,50696,50696,50696,50696,50696,
          50696,50696,50696,50696,50696,50696,50696,49156,49156,49156,49156,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
          0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
          0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        ];
        var i16size = 2;
        var arr = _malloc(values.length * i16size);
        for (var i = 0; i < values.length; i++) {
          HEAP16[(((arr)+(i * i16size))>>1)]=values[i]
        }
        me.ret = allocate([arr + 128 * i16size], 'i16*', ALLOC_NORMAL);
      }
      return me.ret;
    }
  function ___ctype_tolower_loc() {
      // http://refspecs.freestandards.org/LSB_3.1.1/LSB-Core-generic/LSB-Core-generic/libutil---ctype-tolower-loc.html
      var me = ___ctype_tolower_loc;
      if (!me.ret) {
        var values = [
          128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,
          158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,
          188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,
          218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,
          248,249,250,251,252,253,254,-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
          33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,97,98,99,100,101,102,103,
          104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,91,92,93,94,95,96,97,98,99,100,101,102,103,
          104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,
          134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,
          164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,
          194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
          224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,
          254,255
        ];
        var i32size = 4;
        var arr = _malloc(values.length * i32size);
        for (var i = 0; i < values.length; i++) {
          HEAP32[(((arr)+(i * i32size))>>2)]=values[i]
        }
        me.ret = allocate([arr + 128 * i32size], 'i32*', ALLOC_NORMAL);
      }
      return me.ret;
    }
  function ___ctype_toupper_loc() {
      // http://refspecs.freestandards.org/LSB_3.1.1/LSB-Core-generic/LSB-Core-generic/libutil---ctype-toupper-loc.html
      var me = ___ctype_toupper_loc;
      if (!me.ret) {
        var values = [
          128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,
          158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,
          188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,
          218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,
          248,249,250,251,252,253,254,-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
          33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,
          73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,
          81,82,83,84,85,86,87,88,89,90,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,
          145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,
          175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,
          205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,
          235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255
        ];
        var i32size = 4;
        var arr = _malloc(values.length * i32size);
        for (var i = 0; i < values.length; i++) {
          HEAP32[(((arr)+(i * i32size))>>2)]=values[i]
        }
        me.ret = allocate([arr + 128 * i32size], 'i32*', ALLOC_NORMAL);
      }
      return me.ret;
    }
  function __isLeapYear(year) {
        return year%4 === 0 && (year%100 !== 0 || year%400 === 0);
    }
  function __arraySum(array, index) {
      var sum = 0;
      for (var i = 0; i <= index; sum += array[i++]);
      return sum;
    }
  var __MONTH_DAYS_LEAP=[31,29,31,30,31,30,31,31,30,31,30,31];
  var __MONTH_DAYS_REGULAR=[31,28,31,30,31,30,31,31,30,31,30,31];function __addDays(date, days) {
      var newDate = new Date(date.getTime());
      while(days > 0) {
        var leap = __isLeapYear(newDate.getFullYear());
        var currentMonth = newDate.getMonth();
        var daysInCurrentMonth = (leap ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR)[currentMonth];
        if (days > daysInCurrentMonth-newDate.getDate()) {
          // we spill over to next month
          days -= (daysInCurrentMonth-newDate.getDate()+1);
          newDate.setDate(1);
          if (currentMonth < 11) {
            newDate.setMonth(currentMonth+1)
          } else {
            newDate.setMonth(0);
            newDate.setFullYear(newDate.getFullYear()+1);
          }
        } else {
          // we stay in current month 
          newDate.setDate(newDate.getDate()+days);
          return newDate;
        }
      }
      return newDate;
    }function _strftime(s, maxsize, format, tm) {
      // size_t strftime(char *restrict s, size_t maxsize, const char *restrict format, const struct tm *restrict timeptr);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/strftime.html
      var date = {
        tm_sec: HEAP32[((tm)>>2)],
        tm_min: HEAP32[(((tm)+(4))>>2)],
        tm_hour: HEAP32[(((tm)+(8))>>2)],
        tm_mday: HEAP32[(((tm)+(12))>>2)],
        tm_mon: HEAP32[(((tm)+(16))>>2)],
        tm_year: HEAP32[(((tm)+(20))>>2)],
        tm_wday: HEAP32[(((tm)+(24))>>2)],
        tm_yday: HEAP32[(((tm)+(28))>>2)],
        tm_isdst: HEAP32[(((tm)+(32))>>2)]
      };
      var pattern = Pointer_stringify(format);
      // expand format
      var EXPANSION_RULES_1 = {
        '%c': '%a %b %d %H:%M:%S %Y',     // Replaced by the locale's appropriate date and time representation - e.g., Mon Aug  3 14:02:01 2013
        '%D': '%m/%d/%y',                 // Equivalent to %m / %d / %y
        '%F': '%Y-%m-%d',                 // Equivalent to %Y - %m - %d
        '%h': '%b',                       // Equivalent to %b
        '%r': '%I:%M:%S %p',              // Replaced by the time in a.m. and p.m. notation
        '%R': '%H:%M',                    // Replaced by the time in 24-hour notation
        '%T': '%H:%M:%S',                 // Replaced by the time
        '%x': '%m/%d/%y',                 // Replaced by the locale's appropriate date representation
        '%X': '%H:%M:%S',                 // Replaced by the locale's appropriate date representation
      };
      for (var rule in EXPANSION_RULES_1) {
        pattern = pattern.replace(new RegExp(rule, 'g'), EXPANSION_RULES_1[rule]);
      }
      var WEEKDAYS = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
      var MONTHS = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
      function leadingSomething(value, digits, character) {
        var str = typeof value === 'number' ? value.toString() : (value || '');
        while (str.length < digits) {
          str = character[0]+str;
        }
        return str;
      };
      function leadingNulls(value, digits) {
        return leadingSomething(value, digits, '0');
      };
      function compareByDay(date1, date2) {
        function sgn(value) {
          return value < 0 ? -1 : (value > 0 ? 1 : 0);
        };
        var compare;
        if ((compare = sgn(date1.getFullYear()-date2.getFullYear())) === 0) {
          if ((compare = sgn(date1.getMonth()-date2.getMonth())) === 0) {
            compare = sgn(date1.getDate()-date2.getDate());
          }
        }
        return compare;
      };
      function getFirstWeekStartDate(janFourth) {
          switch (janFourth.getDay()) {
            case 0: // Sunday
              return new Date(janFourth.getFullYear()-1, 11, 29);
            case 1: // Monday
              return janFourth;
            case 2: // Tuesday
              return new Date(janFourth.getFullYear(), 0, 3);
            case 3: // Wednesday
              return new Date(janFourth.getFullYear(), 0, 2);
            case 4: // Thursday
              return new Date(janFourth.getFullYear(), 0, 1);
            case 5: // Friday
              return new Date(janFourth.getFullYear()-1, 11, 31);
            case 6: // Saturday
              return new Date(janFourth.getFullYear()-1, 11, 30);
          }
      };
      function getWeekBasedYear(date) {
          var thisDate = __addDays(new Date(date.tm_year+1900, 0, 1), date.tm_yday);
          var janFourthThisYear = new Date(thisDate.getFullYear(), 0, 4);
          var janFourthNextYear = new Date(thisDate.getFullYear()+1, 0, 4);
          var firstWeekStartThisYear = getFirstWeekStartDate(janFourthThisYear);
          var firstWeekStartNextYear = getFirstWeekStartDate(janFourthNextYear);
          if (compareByDay(firstWeekStartThisYear, thisDate) <= 0) {
            // this date is after the start of the first week of this year
            if (compareByDay(firstWeekStartNextYear, thisDate) <= 0) {
              return thisDate.getFullYear()+1;
            } else {
              return thisDate.getFullYear();
            }
          } else { 
            return thisDate.getFullYear()-1;
          }
      };
      var EXPANSION_RULES_2 = {
        '%a': function(date) {
          return WEEKDAYS[date.tm_wday].substring(0,3);
        },
        '%A': function(date) {
          return WEEKDAYS[date.tm_wday];
        },
        '%b': function(date) {
          return MONTHS[date.tm_mon].substring(0,3);
        },
        '%B': function(date) {
          return MONTHS[date.tm_mon];
        },
        '%C': function(date) {
          var year = date.tm_year+1900;
          return leadingNulls(Math.floor(year/100),2);
        },
        '%d': function(date) {
          return leadingNulls(date.tm_mday, 2);
        },
        '%e': function(date) {
          return leadingSomething(date.tm_mday, 2, ' ');
        },
        '%g': function(date) {
          // %g, %G, and %V give values according to the ISO 8601:2000 standard week-based year. 
          // In this system, weeks begin on a Monday and week 1 of the year is the week that includes 
          // January 4th, which is also the week that includes the first Thursday of the year, and 
          // is also the first week that contains at least four days in the year. 
          // If the first Monday of January is the 2nd, 3rd, or 4th, the preceding days are part of 
          // the last week of the preceding year; thus, for Saturday 2nd January 1999, 
          // %G is replaced by 1998 and %V is replaced by 53. If December 29th, 30th, 
          // or 31st is a Monday, it and any following days are part of week 1 of the following year. 
          // Thus, for Tuesday 30th December 1997, %G is replaced by 1998 and %V is replaced by 01.
          return getWeekBasedYear(date).toString().substring(2);
        },
        '%G': function(date) {
          return getWeekBasedYear(date);
        },
        '%H': function(date) {
          return leadingNulls(date.tm_hour, 2);
        },
        '%I': function(date) {
          return leadingNulls(date.tm_hour < 13 ? date.tm_hour : date.tm_hour-12, 2);
        },
        '%j': function(date) {
          // Day of the year (001-366)
          return leadingNulls(date.tm_mday+__arraySum(__isLeapYear(date.tm_year+1900) ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, date.tm_mon-1), 3);
        },
        '%m': function(date) {
          return leadingNulls(date.tm_mon+1, 2);
        },
        '%M': function(date) {
          return leadingNulls(date.tm_min, 2);
        },
        '%n': function() {
          return '\n';
        },
        '%p': function(date) {
          if (date.tm_hour > 0 && date.tm_hour < 13) {
            return 'AM';
          } else {
            return 'PM';
          }
        },
        '%S': function(date) {
          return leadingNulls(date.tm_sec, 2);
        },
        '%t': function() {
          return '\t';
        },
        '%u': function(date) {
          var day = new Date(date.tm_year+1900, date.tm_mon+1, date.tm_mday, 0, 0, 0, 0);
          return day.getDay() || 7;
        },
        '%U': function(date) {
          // Replaced by the week number of the year as a decimal number [00,53]. 
          // The first Sunday of January is the first day of week 1; 
          // days in the new year before this are in week 0. [ tm_year, tm_wday, tm_yday]
          var janFirst = new Date(date.tm_year+1900, 0, 1);
          var firstSunday = janFirst.getDay() === 0 ? janFirst : __addDays(janFirst, 7-janFirst.getDay());
          var endDate = new Date(date.tm_year+1900, date.tm_mon, date.tm_mday);
          // is target date after the first Sunday?
          if (compareByDay(firstSunday, endDate) < 0) {
            // calculate difference in days between first Sunday and endDate
            var februaryFirstUntilEndMonth = __arraySum(__isLeapYear(endDate.getFullYear()) ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, endDate.getMonth()-1)-31;
            var firstSundayUntilEndJanuary = 31-firstSunday.getDate();
            var days = firstSundayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();
            return leadingNulls(Math.ceil(days/7), 2);
          }
          return compareByDay(firstSunday, janFirst) === 0 ? '01': '00';
        },
        '%V': function(date) {
          // Replaced by the week number of the year (Monday as the first day of the week) 
          // as a decimal number [01,53]. If the week containing 1 January has four 
          // or more days in the new year, then it is considered week 1. 
          // Otherwise, it is the last week of the previous year, and the next week is week 1. 
          // Both January 4th and the first Thursday of January are always in week 1. [ tm_year, tm_wday, tm_yday]
          var janFourthThisYear = new Date(date.tm_year+1900, 0, 4);
          var janFourthNextYear = new Date(date.tm_year+1901, 0, 4);
          var firstWeekStartThisYear = getFirstWeekStartDate(janFourthThisYear);
          var firstWeekStartNextYear = getFirstWeekStartDate(janFourthNextYear);
          var endDate = __addDays(new Date(date.tm_year+1900, 0, 1), date.tm_yday);
          if (compareByDay(endDate, firstWeekStartThisYear) < 0) {
            // if given date is before this years first week, then it belongs to the 53rd week of last year
            return '53';
          } 
          if (compareByDay(firstWeekStartNextYear, endDate) <= 0) {
            // if given date is after next years first week, then it belongs to the 01th week of next year
            return '01';
          }
          // given date is in between CW 01..53 of this calendar year
          var daysDifference;
          if (firstWeekStartThisYear.getFullYear() < date.tm_year+1900) {
            // first CW of this year starts last year
            daysDifference = date.tm_yday+32-firstWeekStartThisYear.getDate()
          } else {
            // first CW of this year starts this year
            daysDifference = date.tm_yday+1-firstWeekStartThisYear.getDate();
          }
          return leadingNulls(Math.ceil(daysDifference/7), 2);
        },
        '%w': function(date) {
          var day = new Date(date.tm_year+1900, date.tm_mon+1, date.tm_mday, 0, 0, 0, 0);
          return day.getDay();
        },
        '%W': function(date) {
          // Replaced by the week number of the year as a decimal number [00,53]. 
          // The first Monday of January is the first day of week 1; 
          // days in the new year before this are in week 0. [ tm_year, tm_wday, tm_yday]
          var janFirst = new Date(date.tm_year, 0, 1);
          var firstMonday = janFirst.getDay() === 1 ? janFirst : __addDays(janFirst, janFirst.getDay() === 0 ? 1 : 7-janFirst.getDay()+1);
          var endDate = new Date(date.tm_year+1900, date.tm_mon, date.tm_mday);
          // is target date after the first Monday?
          if (compareByDay(firstMonday, endDate) < 0) {
            var februaryFirstUntilEndMonth = __arraySum(__isLeapYear(endDate.getFullYear()) ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, endDate.getMonth()-1)-31;
            var firstMondayUntilEndJanuary = 31-firstMonday.getDate();
            var days = firstMondayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();
            return leadingNulls(Math.ceil(days/7), 2);
          }
          return compareByDay(firstMonday, janFirst) === 0 ? '01': '00';
        },
        '%y': function(date) {
          // Replaced by the last two digits of the year as a decimal number [00,99]. [ tm_year]
          return (date.tm_year+1900).toString().substring(2);
        },
        '%Y': function(date) {
          // Replaced by the year as a decimal number (for example, 1997). [ tm_year]
          return date.tm_year+1900;
        },
        '%z': function(date) {
          // Replaced by the offset from UTC in the ISO 8601:2000 standard format ( +hhmm or -hhmm ),
          // or by no characters if no timezone is determinable. 
          // For example, "-0430" means 4 hours 30 minutes behind UTC (west of Greenwich). 
          // If tm_isdst is zero, the standard time offset is used. 
          // If tm_isdst is greater than zero, the daylight savings time offset is used. 
          // If tm_isdst is negative, no characters are returned. 
          // FIXME: we cannot determine time zone (or can we?)
          return '';
        },
        '%Z': function(date) {
          // Replaced by the timezone name or abbreviation, or by no bytes if no timezone information exists. [ tm_isdst]
          // FIXME: we cannot determine time zone (or can we?)
          return '';
        },
        '%%': function() {
          return '%';
        }
      };
      for (var rule in EXPANSION_RULES_2) {
        if (pattern.indexOf(rule) >= 0) {
          pattern = pattern.replace(new RegExp(rule, 'g'), EXPANSION_RULES_2[rule](date));
        }
      }
      var bytes = intArrayFromString(pattern, false);
      if (bytes.length > maxsize) {
        return 0;
      } 
      writeArrayToMemory(bytes, s);
      return bytes.length-1;
    }var _strftime_l=_strftime;
  function _isspace(chr) {
      return (chr == 32) || (chr >= 9 && chr <= 13);
    }
  function __parseInt64(str, endptr, base, min, max, unsign) {
      var isNegative = false;
      // Skip space.
      while (_isspace(HEAP8[(str)])) str++;
      // Check for a plus/minus sign.
      if (HEAP8[(str)] == 45) {
        str++;
        isNegative = true;
      } else if (HEAP8[(str)] == 43) {
        str++;
      }
      // Find base.
      var ok = false;
      var finalBase = base;
      if (!finalBase) {
        if (HEAP8[(str)] == 48) {
          if (HEAP8[((str+1)|0)] == 120 ||
              HEAP8[((str+1)|0)] == 88) {
            finalBase = 16;
            str += 2;
          } else {
            finalBase = 8;
            ok = true; // we saw an initial zero, perhaps the entire thing is just "0"
          }
        }
      } else if (finalBase==16) {
        if (HEAP8[(str)] == 48) {
          if (HEAP8[((str+1)|0)] == 120 ||
              HEAP8[((str+1)|0)] == 88) {
            str += 2;
          }
        }
      }
      if (!finalBase) finalBase = 10;
      var start = str;
      // Get digits.
      var chr;
      while ((chr = HEAP8[(str)]) != 0) {
        var digit = parseInt(String.fromCharCode(chr), finalBase);
        if (isNaN(digit)) {
          break;
        } else {
          str++;
          ok = true;
        }
      }
      if (!ok) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return ((asm["setTempRet0"](0),0)|0);
      }
      // Set end pointer.
      if (endptr) {
        HEAP32[((endptr)>>2)]=str
      }
      try {
        var numberString = isNegative ? '-'+Pointer_stringify(start, str - start) : Pointer_stringify(start, str - start);
        i64Math.fromString(numberString, finalBase, min, max, unsign);
      } catch(e) {
        ___setErrNo(ERRNO_CODES.ERANGE); // not quite correct
      }
      return ((asm["setTempRet0"](((HEAP32[(((tempDoublePtr)+(4))>>2)])|0)),((HEAP32[((tempDoublePtr)>>2)])|0))|0);
    }function _strtoull(str, endptr, base) {
      return __parseInt64(str, endptr, base, 0, '18446744073709551615', true);  // ULONG_MAX.
    }var _strtoull_l=_strtoull;
  function _strtoll(str, endptr, base) {
      return __parseInt64(str, endptr, base, '-9223372036854775808', '9223372036854775807');  // LLONG_MIN, LLONG_MAX.
    }var _strtoll_l=_strtoll;
  function _uselocale(locale) {
      return 0;
    }
  var _llvm_va_start=undefined;
  function _sprintf(s, format, varargs) {
      // int sprintf(char *restrict s, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      return _snprintf(s, undefined, format, varargs);
    }function _asprintf(s, format, varargs) {
      return _sprintf(-s, format, varargs);
    }function _vasprintf(s, format, va_arg) {
      return _asprintf(s, format, HEAP32[((va_arg)>>2)]);
    }
  function _llvm_va_end() {}
  function _vsnprintf(s, n, format, va_arg) {
      return _snprintf(s, n, format, HEAP32[((va_arg)>>2)]);
    }
  function _vsscanf(s, format, va_arg) {
      return _sscanf(s, format, HEAP32[((va_arg)>>2)]);
    }
  function _sbrk(bytes) {
      // Implement a Linux-like 'memory area' for our 'process'.
      // Changes the size of the memory area by |bytes|; returns the
      // address of the previous top ('break') of the memory area
      // We control the "dynamic" memory - DYNAMIC_BASE to DYNAMICTOP
      var self = _sbrk;
      if (!self.called) {
        DYNAMICTOP = alignMemoryPage(DYNAMICTOP); // make sure we start out aligned
        self.called = true;
        assert(Runtime.dynamicAlloc);
        self.alloc = Runtime.dynamicAlloc;
        Runtime.dynamicAlloc = function() { abort('cannot dynamically allocate, sbrk now has control') };
      }
      var ret = DYNAMICTOP;
      if (bytes != 0) self.alloc(bytes);
      return ret;  // Previous break location.
    }
  function ___cxa_call_unexpected(exception) {
      Module.printErr('Unexpected exception thrown, this is not properly supported - aborting');
      ABORT = true;
      throw exception;
    }
FS.staticInit();__ATINIT__.unshift({ func: function() { if (!Module["noFSInit"] && !FS.init.initialized) FS.init() } });__ATMAIN__.push({ func: function() { FS.ignorePermissions = false } });__ATEXIT__.push({ func: function() { FS.quit() } });Module["FS_createFolder"] = FS.createFolder;Module["FS_createPath"] = FS.createPath;Module["FS_createDataFile"] = FS.createDataFile;Module["FS_createPreloadedFile"] = FS.createPreloadedFile;Module["FS_createLazyFile"] = FS.createLazyFile;Module["FS_createLink"] = FS.createLink;Module["FS_createDevice"] = FS.createDevice;
___errno_state = Runtime.staticAlloc(4); HEAP32[((___errno_state)>>2)]=0;
__ATINIT__.unshift({ func: function() { TTY.init() } });__ATEXIT__.push({ func: function() { TTY.shutdown() } });TTY.utf8 = new Runtime.UTF8Processor();
if (ENVIRONMENT_IS_NODE) { var fs = require("fs"); NODEFS.staticInit(); }
Module["requestFullScreen"] = function Module_requestFullScreen(lockPointer, resizeCanvas) { Browser.requestFullScreen(lockPointer, resizeCanvas) };
  Module["requestAnimationFrame"] = function Module_requestAnimationFrame(func) { Browser.requestAnimationFrame(func) };
  Module["setCanvasSize"] = function Module_setCanvasSize(width, height, noUpdates) { Browser.setCanvasSize(width, height, noUpdates) };
  Module["pauseMainLoop"] = function Module_pauseMainLoop() { Browser.mainLoop.pause() };
  Module["resumeMainLoop"] = function Module_resumeMainLoop() { Browser.mainLoop.resume() };
  Module["getUserMedia"] = function Module_getUserMedia() { Browser.getUserMedia() }
GL.init()
_llvm_eh_exception.buf = allocate(12, "void*", ALLOC_STATIC);
__ATINIT__.push({ func: function() { SOCKFS.root = FS.mount(SOCKFS, {}, null); } });
_fputc.ret = allocate([0], "i8", ALLOC_STATIC);
___buildEnvironment(ENV);
_fgetc.ret = allocate([0], "i8", ALLOC_STATIC);
STACK_BASE = STACKTOP = Runtime.alignMemory(STATICTOP);
staticSealed = true; // seal the static portion of memory
STACK_MAX = STACK_BASE + 5242880;
DYNAMIC_BASE = DYNAMICTOP = Runtime.alignMemory(STACK_MAX);
assert(DYNAMIC_BASE < TOTAL_MEMORY); // Stack must fit in TOTAL_MEMORY; allocations from here on may enlarge TOTAL_MEMORY
 var ctlz_i8 = allocate([8,7,6,6,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_DYNAMIC);
 var cttz_i8 = allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0], "i8", ALLOC_DYNAMIC);
var Math_min = Math.min;
function invoke_viiiii(index,a1,a2,a3,a4,a5) {
  try {
    Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vif(index,a1,a2) {
  try {
    Module["dynCall_vif"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vi(index,a1) {
  try {
    Module["dynCall_vi"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vii(index,a1,a2) {
  try {
    Module["dynCall_vii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiif(index,a1,a2,a3,a4,a5) {
  try {
    Module["dynCall_viiiif"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_ii(index,a1) {
  try {
    return Module["dynCall_ii"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiid(index,a1,a2,a3,a4,a5,a6,a7) {
  try {
    Module["dynCall_viiiiiid"](index,a1,a2,a3,a4,a5,a6,a7);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiii(index,a1,a2,a3,a4) {
  try {
    return Module["dynCall_iiiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiii(index,a1,a2,a3) {
  try {
    return Module["dynCall_iiii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiid(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module["dynCall_viiiiid"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8) {
  try {
    Module["dynCall_viiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7) {
  try {
    Module["dynCall_viiiiiii"](index,a1,a2,a3,a4,a5,a6,a7);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiiiif(index,a1,a2,a3,a4,a5,a6,a7,a8,a9) {
  try {
    Module["dynCall_viiiiiiiif"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vifii(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_vifii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9) {
  try {
    Module["dynCall_viiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiif(index,a1,a2,a3,a4,a5,a6,a7) {
  try {
    Module["dynCall_viiiiiif"](index,a1,a2,a3,a4,a5,a6,a7);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iii(index,a1,a2) {
  try {
    return Module["dynCall_iii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiii(index,a1,a2,a3,a4,a5) {
  try {
    return Module["dynCall_iiiiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viii(index,a1,a2,a3) {
  try {
    Module["dynCall_viii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_v(index) {
  try {
    Module["dynCall_v"](index);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8) {
  try {
    return Module["dynCall_iiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiii(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_viiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function asmPrintInt(x, y) {
  Module.print('int ' + x + ',' + y);// + ' ' + new Error().stack);
}
function asmPrintFloat(x, y) {
  Module.print('float ' + x + ',' + y);// + ' ' + new Error().stack);
}
// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer){"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.cttz_i8|0;var n=env.ctlz_i8|0;var o=env._stdin|0;var p=env._stdout|0;var q=env.__ZTVN10__cxxabiv117__class_type_infoE|0;var r=env.__ZTVN10__cxxabiv120__si_class_type_infoE|0;var s=env.___fsmu8|0;var t=env.___dso_handle|0;var u=env._stderr|0;var v=+env.NaN;var w=+env.Infinity;var x=0;var y=0;var z=0;var A=0;var B=0,C=0,D=0,E=0,F=0.0,G=0,H=0,I=0,J=0.0;var K=0;var L=0;var M=0;var N=0;var O=0;var P=0;var Q=0;var R=0;var S=0;var T=0;var U=global.Math.floor;var V=global.Math.abs;var W=global.Math.sqrt;var X=global.Math.pow;var Y=global.Math.cos;var Z=global.Math.sin;var _=global.Math.tan;var $=global.Math.acos;var aa=global.Math.asin;var ab=global.Math.atan;var ac=global.Math.atan2;var ad=global.Math.exp;var ae=global.Math.log;var af=global.Math.ceil;var ag=global.Math.imul;var ah=env.abort;var ai=env.assert;var aj=env.asmPrintInt;var ak=env.asmPrintFloat;var al=env.min;var am=env.invoke_viiiii;var an=env.invoke_vif;var ao=env.invoke_vi;var ap=env.invoke_vii;var aq=env.invoke_viiiif;var ar=env.invoke_ii;var as=env.invoke_viiiiiid;var at=env.invoke_iiiii;var au=env.invoke_iiii;var av=env.invoke_viiiiid;var aw=env.invoke_viiiiiiii;var ax=env.invoke_viiiiii;var ay=env.invoke_viiiiiii;var az=env.invoke_viiiiiiiif;var aA=env.invoke_vifii;var aB=env.invoke_viiiiiiiii;var aC=env.invoke_viiiiiif;var aD=env.invoke_iii;var aE=env.invoke_iiiiii;var aF=env.invoke_viii;var aG=env.invoke_v;var aH=env.invoke_iiiiiiiii;var aI=env.invoke_viiii;var aJ=env._llvm_lifetime_end;var aK=env._glClearColor;var aL=env.__scanString;var aM=env._fclose;var aN=env._pthread_mutex_lock;var aO=env.___cxa_end_catch;var aP=env._glLinkProgram;var aQ=env._strtoull;var aR=env._glBindTexture;var aS=env._fflush;var aT=env._isxdigit;var aU=env._fputc;var aV=env._fwrite;var aW=env._llvm_eh_exception;var aX=env._llvm_pow_f32;var aY=env._fputs;var aZ=env._llvm_umul_with_overflow_i32;var a_=env._glCompileShader;var a$=env._isspace;var a0=env._glDeleteTextures;var a1=env._read;var a2=env._fsync;var a3=env._glGenTextures;var a4=env._newlocale;var a5=env.___gxx_personality_v0;var a6=env._pthread_cond_wait;var a7=env.___cxa_rethrow;var a8=env._fmod;var a9=env.___resumeException;var ba=env._glCreateShader;var bb=env._llvm_va_end;var bc=env._cosf;var bd=env._vsscanf;var be=env._glDisable;var bf=env._fgetc;var bg=env._get_window_height;var bh=env._glGetProgramiv;var bi=env._glVertexAttribPointer;var bj=env.__getFloat;var bk=env._atexit;var bl=env._mknod;var bm=env.___cxa_free_exception;var bn=env._glGetUniformLocation;var bo=env._close;var bp=env._glUniform4fv;var bq=env.___setErrNo;var br=env.___cxa_guard_abort;var bs=env._glDrawArrays;var bt=env._exit;var bu=env._sprintf;var bv=env.___ctype_b_loc;var bw=env._freelocale;var bx=env._glAttachShader;var by=env._catgets;var bz=env.__isLeapYear;var bA=env._asprintf;var bB=env.___cxa_is_number_type;var bC=env.___cxa_does_inherit;var bD=env.___cxa_guard_acquire;var bE=env.___cxa_begin_catch;var bF=env._sinf;var bG=env._recv;var bH=env.__parseInt64;var bI=env.__ZSt18uncaught_exceptionv;var bJ=env._SDL_GL_SwapBuffers;var bK=env._puts;var bL=env.___cxa_call_unexpected;var bM=env._SDL_Init;var bN=env._get_window_width;var bO=env._fmin;var bP=env.__exit;var bQ=env._strftime;var bR=env._rand;var bS=env._fabsf;var bT=env.___cxa_throw;var bU=env._glUseProgram;var bV=env._send;var bW=env._glShaderSource;var bX=env._pread;var bY=env._SDL_SetVideoMode;var bZ=env._fopen;var b_=env._open;var b$=env._sqrtf;var b0=env._SDL_GL_SetAttribute;var b1=env.__arraySum;var b2=env._snprintf;var b3=env._SDL_PollEvent;var b4=env._glClear;var b5=env._mkdir;var b6=env._glEnableVertexAttribArray;var b7=env._glBindBuffer;var b8=env.___cxa_find_matching_catch;var b9=env._strdup;var ca=env._fread;var cb=env._glBufferData;var cc=env.__formatString;var cd=env._pthread_cond_broadcast;var ce=env._getenv;var cf=env.__ZSt9terminatev;var cg=env._gettimeofday;var ch=env._isascii;var ci=env._pthread_mutex_unlock;var cj=env._sbrk;var ck=env._tanf;var cl=env.___errno_location;var cm=env._strerror;var cn=env._catclose;var co=env._llvm_lifetime_start;var cp=env.___cxa_guard_release;var cq=env._ungetc;var cr=env._uselocale;var cs=env._vsnprintf;var ct=env._glDisableVertexAttribArray;var cu=env._sscanf;var cv=env._glTexImage2D;var cw=env._sysconf;var cx=env._srand;var cy=env._abort;var cz=env._isdigit;var cA=env._strtoll;var cB=env.___buildEnvironment;var cC=env.__addDays;var cD=env._glEnable;var cE=env.__reallyNegative;var cF=env._emscripten_asm_const_int;var cG=env._glGenBuffers;var cH=env._glGetAttribLocation;var cI=env.___cxa_allocate_exception;var cJ=env._glBlendFunc;var cK=env._glCreateProgram;var cL=env._stat;var cM=env.___cxa_pure_virtual;var cN=env._vasprintf;var cO=env._glViewport;var cP=env._emscripten_set_main_loop;var cQ=env._catopen;var cR=env.___ctype_toupper_loc;var cS=env.___ctype_tolower_loc;var cT=env._glUniformMatrix4fv;var cU=env._pwrite;var cV=env._strerror_r;var cW=env._glTexParameteri;var cX=env._write;var cY=env._time;var cZ=0.0;
// EMSCRIPTEN_START_FUNCS
function dl(a){a=a|0;var b=0;b=i;i=i+a|0;i=i+7&-8;return b|0}function dm(){return i|0}function dn(a){a=a|0;i=a}function dp(a,b){a=a|0;b=b|0;if((x|0)==0){x=a;y=b}}function dq(b){b=b|0;a[k]=a[b];a[k+1|0]=a[b+1|0];a[k+2|0]=a[b+2|0];a[k+3|0]=a[b+3|0]}function dr(b){b=b|0;a[k]=a[b];a[k+1|0]=a[b+1|0];a[k+2|0]=a[b+2|0];a[k+3|0]=a[b+3|0];a[k+4|0]=a[b+4|0];a[k+5|0]=a[b+5|0];a[k+6|0]=a[b+6|0];a[k+7|0]=a[b+7|0]}function ds(a){a=a|0;K=a}function dt(a){a=a|0;L=a}function du(a){a=a|0;M=a}function dv(a){a=a|0;N=a}function dw(a){a=a|0;O=a}function dx(a){a=a|0;P=a}function dy(a){a=a|0;Q=a}function dz(a){a=a|0;R=a}function dA(a){a=a|0;S=a}function dB(a){a=a|0;T=a}function dC(){c[35712]=q+8;c[35714]=q+8;c[35716]=r+8;c[35720]=r+8;c[35724]=r+8;c[35728]=r+8;c[35732]=r+8;c[35736]=q+8;c[35770]=r+8;c[35774]=r+8;c[35838]=r+8;c[35842]=r+8;c[35862]=q+8;c[35864]=r+8;c[35900]=r+8;c[35904]=r+8;c[35940]=r+8;c[35944]=r+8;c[35964]=q+8;c[35966]=q+8;c[35968]=r+8;c[35972]=r+8;c[35976]=r+8;c[35980]=q+8;c[35982]=q+8;c[35984]=q+8;c[35986]=q+8;c[35988]=q+8;c[35990]=q+8;c[35992]=q+8;c[36018]=r+8;c[36022]=q+8;c[36024]=r+8;c[36028]=r+8;c[36032]=r+8;c[36036]=q+8;c[36038]=q+8;c[36040]=q+8;c[36042]=q+8;c[36076]=q+8;c[36078]=q+8;c[36080]=q+8;c[36082]=r+8;c[36086]=r+8;c[36090]=r+8;c[36094]=r+8;c[36098]=r+8;c[36102]=r+8}function dD(a,b){a=a|0;b=b|0;var d=0;b=oD(24)|0;a=oD(108)|0;eJ(a,0);d=b;dH(d,a);c[b>>2]=139416;c[38400]=b;bM(32)|0;b0(17,1)|0;b0(6,16)|0;b0(13,1)|0;b0(14,2)|0;b=bN()|0;a=bY(b|0,bg()|0,0,67108864)|0;dI(d);dJ(d,c[a+8>>2]|0,c[a+12>>2]|0);cP(4,60,0);return 0}function dE(){dF(c[38400]|0);return}function dF(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;b=i;i=i+64|0;d=b|0;e=b+48|0;f=b+56|0;g=a|0;h=a+4|0;if(eP(c[h>>2]|0)|0){i=b;return}if((b3(d|0)|0)!=0){a=d|0;j=d+16|0;do{k=c[a>>2]|0;if((k|0)==768){switch(c[j>>2]|0){case 1103:{l=4;break};case 1106:{l=1;break};case 1105:{l=2;break};case 32:{l=5;break};case 1104:{l=3;break};default:{l=0}}eT(c[h>>2]|0,1,0,l)}else if((k|0)==769){switch(c[j>>2]|0){case 1103:{m=4;break};case 1106:{m=1;break};case 1105:{m=2;break};case 32:{m=5;break};case 1104:{m=3;break};default:{m=0}}eT(c[h>>2]|0,0,0,m)}}while((b3(d|0)|0)!=0)}if((cF(136008)|0)>0){do{cF(135952)|0;cF(134880)|0;d=cF(134416)|0;c[e>>2]=cF(133840)|0;c[f>>2]=cF(133080)|0;dL(g,e,f);do{if((d|0)==0){eR(c[h>>2]|0,1,c[e>>2]|0,c[f>>2]|0)}else{m=c[h>>2]|0;j=c[e>>2]|0;l=c[f>>2]|0;if((d|0)==1){eS(m,j,l);break}else{eR(m,0,j,l);break}}}while(0);}while((cF(136008)|0)>0)}dK(g);i=b;return}function dG(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;de[c[(c[a>>2]|0)+28>>2]&3](a,b,e,f,g,h,.8999999761581421);c8[c[(c[a>>2]|0)+44>>2]&31](a,1,d,e,f,g,h,1);return}function dH(b,d){b=b|0;d=d|0;c[b>>2]=139496;c[b+4>>2]=d;a[b+8|0]=0;c[b+12>>2]=0;c[b+16>>2]=0;g[b+20>>2]=1.0;return}function dI(a){a=a|0;d7();eC();return}function dJ(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0.0,l=0.0,m=0.0;f=i;i=i+16|0;h=f|0;j=f+8|0;c[h>>2]=d;c[j>>2]=e;c[b+12>>2]=d;c[b+16>>2]=e;a[b+8|0]=(d8(h,j)|0)&1;e=b+20|0;g[e>>2]=1.0;d=c[h>>2]|0;h=c[36144]|0;k=+(d|0);if((d|0)>(h|0)){l=k/+(h|0);g[e>>2]=l;m=l}else{m=1.0}eL(c[b+4>>2]|0,~~(k/m),~~(+(c[j>>2]|0)/m));i=f;return}function dK(a){a=a|0;eO(c[a+4>>2]|0,a|0);return}function dL(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0;f=c[d>>2]|0;if((a[b+8|0]&1)==0){h=f}else{c[d>>2]=c[e>>2];c[e>>2]=f;f=(c[b+16>>2]|0)-(c[d>>2]|0)|0;c[d>>2]=f;h=f}f=b+20|0;c[d>>2]=~~(+(h|0)/+g[f>>2]);c[e>>2]=~~(+(c[e>>2]|0)/+g[f>>2]);return}function dM(a,b,d,e,f,h,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;h=+h;j=j|0;k=+k;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0;l=i;i=i+1528|0;m=l|0;n=l+64|0;o=l+128|0;p=l+192|0;q=l+256|0;r=l+320|0;s=l+384|0;t=l+392|0;u=l+400|0;v=l+408|0;w=l+472|0;x=l+536|0;y=l+600|0;z=l+664|0;A=l+728|0;B=l+792|0;C=l+856|0;eH(b,s,t,u);D=+(c[s>>2]|0)*k/255.0;E=+(c[t>>2]|0)*k/255.0;F=+(c[u>>2]|0)*k/255.0;u=v;t=ef()|0;oN(u|0,t|0,64)|0;if(j){k=h*(+(e|0)*.5/+(c[a+16>>2]|0)+.2);g[w>>2]=1.0;oO(w+4|0,0,16);g[w+20>>2]=1.0;oO(w+24|0,0,16);g[w+40>>2]=1.0;g[w+44>>2]=-.20000000298023224;g[w+48>>2]=0.0;g[w+52>>2]=0.0;g[w+56>>2]=0.0;g[w+60>>2]=1.0;a=q;d0(q,v,w);oN(u|0,a|0,64)|0;g[x>>2]=1.0;oO(x+4|0,0,16);g[x+20>>2]=1.0;oO(x+24|0,0,16);g[x+40>>2]=.10000000149011612;oO(x+44|0,0,16);g[x+60>>2]=1.0;a=p;d0(p,v,x);oN(u|0,a|0,64)|0;G=k}else{G=h}h=+(d|0)+ +(c[36154]|0)*.5;k=+(e|0)+ +(c[36148]|0)*.5;g[y>>2]=1.0;g[y+4>>2]=0.0;g[y+8>>2]=0.0;g[y+12>>2]=h;g[y+16>>2]=0.0;g[y+20>>2]=1.0;g[y+24>>2]=0.0;g[y+28>>2]=k;g[y+32>>2]=0.0;g[y+36>>2]=0.0;g[y+40>>2]=1.0;oO(y+44|0,0,16);g[y+60>>2]=1.0;e=o;d0(o,v,y);oN(u|0,e|0,64)|0;e=c[36154]|0;if(j){k=+(c[36148]|0)*.95;g[z>>2]=+(e|0)*.95;oO(z+4|0,0,16);g[z+20>>2]=k;oO(z+24|0,0,16);g[z+40>>2]=.30000001192092896;oO(z+44|0,0,16);g[z+60>>2]=1.0;j=n;d0(n,v,z);oN(u|0,j|0,64)|0}else{k=+(c[36148]|0);g[A>>2]=+(e|0);oO(A+4|0,0,16);g[A+20>>2]=k;oO(A+24|0,0,16);g[A+40>>2]=.30000001192092896;oO(A+44|0,0,16);g[A+60>>2]=1.0;e=m;d0(m,v,A);oN(u|0,e|0,64)|0}k=f*3.141592653589793/180.0;f=+Z(k);h=+Y(k);k=1.0-h;H=k*.0952380895614624;I=f*.8728715181350708;J=k*.1904761791229248;K=f*.4364357590675354;L=k*.3809523582458496;M=f*.2182178795337677;g[B>>2]=h+k*.0476190447807312;g[B+4>>2]=H-I;g[B+8>>2]=K+J;g[B+12>>2]=0.0;g[B+16>>2]=H+I;g[B+20>>2]=h+J;g[B+24>>2]=L-M;g[B+28>>2]=0.0;g[B+32>>2]=J-K;g[B+36>>2]=M+L;g[B+40>>2]=h+k*.7619047164916992;oO(B+44|0,0,16);g[B+60>>2]=1.0;e=r;d0(r,v,B);oN(u|0,e|0,64)|0;k=D*.8999999761581421;h=E*.8999999761581421;L=F*.8999999761581421;e=C|0;g[e>>2]=-.5;g[C+4>>2]=-.5;g[C+8>>2]=.5;g[C+12>>2]=D;g[C+16>>2]=E;g[C+20>>2]=F;g[C+24>>2]=G;g[C+28>>2]=-.5;g[C+32>>2]=-.5;g[C+36>>2]=.5;g[C+40>>2]=D*1.2000000476837158;g[C+44>>2]=E*1.2000000476837158;g[C+48>>2]=F*1.2000000476837158;g[C+52>>2]=G;g[C+56>>2]=.5;g[C+60>>2]=-.5;g[C+64>>2]=.5;g[C+68>>2]=D;g[C+72>>2]=E;g[C+76>>2]=F;g[C+80>>2]=G;g[C+84>>2]=-.5;g[C+88>>2]=.5;g[C+92>>2]=.5;g[C+96>>2]=D;g[C+100>>2]=E;g[C+104>>2]=F;g[C+108>>2]=G;g[C+112>>2]=.5;g[C+116>>2]=.5;g[C+120>>2]=.5;g[C+124>>2]=D;g[C+128>>2]=E;g[C+132>>2]=F;g[C+136>>2]=G;g[C+140>>2]=-.5;g[C+144>>2]=.5;g[C+148>>2]=-.5;g[C+152>>2]=D;g[C+156>>2]=E;g[C+160>>2]=F;g[C+164>>2]=G;g[C+168>>2]=.5;g[C+172>>2]=.5;g[C+176>>2]=-.5;g[C+180>>2]=D;g[C+184>>2]=E;g[C+188>>2]=F;g[C+192>>2]=G;g[C+196>>2]=-.5;g[C+200>>2]=-.5;g[C+204>>2]=-.5;g[C+208>>2]=D;g[C+212>>2]=E;g[C+216>>2]=F;g[C+220>>2]=G;g[C+224>>2]=.5;g[C+228>>2]=-.5;g[C+232>>2]=-.5;g[C+236>>2]=D;g[C+240>>2]=E;g[C+244>>2]=F;g[C+248>>2]=G;g[C+252>>2]=-.5;g[C+256>>2]=-.5;g[C+260>>2]=.5;g[C+264>>2]=k;g[C+268>>2]=h;g[C+272>>2]=L;g[C+276>>2]=G;g[C+280>>2]=.5;g[C+284>>2]=-.5;g[C+288>>2]=.5;g[C+292>>2]=k;g[C+296>>2]=h;g[C+300>>2]=L;g[C+304>>2]=G;g[C+308>>2]=.5;g[C+312>>2]=-.5;g[C+316>>2]=.5;g[C+320>>2]=D;g[C+324>>2]=E;g[C+328>>2]=F;g[C+332>>2]=G;g[C+336>>2]=-.5;g[C+340>>2]=-.5;g[C+344>>2]=-.5;g[C+348>>2]=D;g[C+352>>2]=E;g[C+356>>2]=F;g[C+360>>2]=G;g[C+364>>2]=-.5;g[C+368>>2]=-.5;g[C+372>>2]=-.5;g[C+376>>2]=D;g[C+380>>2]=E;g[C+384>>2]=F;g[C+388>>2]=G;g[C+392>>2]=-.5;g[C+396>>2]=-.5;g[C+400>>2]=.5;g[C+404>>2]=D;g[C+408>>2]=E;g[C+412>>2]=F;g[C+416>>2]=G;g[C+420>>2]=-.5;g[C+424>>2]=.5;g[C+428>>2]=-.5;g[C+432>>2]=D;g[C+436>>2]=E;g[C+440>>2]=F;g[C+444>>2]=G;g[C+448>>2]=-.5;g[C+452>>2]=.5;g[C+456>>2]=.5;g[C+460>>2]=D;g[C+464>>2]=E;g[C+468>>2]=F;g[C+472>>2]=G;g[C+476>>2]=-.5;g[C+480>>2]=.5;g[C+484>>2]=.5;g[C+488>>2]=D;g[C+492>>2]=E;g[C+496>>2]=F;g[C+500>>2]=G;g[C+504>>2]=.5;g[C+508>>2]=-.5;g[C+512>>2]=-.5;g[C+516>>2]=D;g[C+520>>2]=E;g[C+524>>2]=F;g[C+528>>2]=G;g[C+532>>2]=.5;g[C+536>>2]=-.5;g[C+540>>2]=-.5;g[C+544>>2]=D;g[C+548>>2]=E;g[C+552>>2]=F;g[C+556>>2]=G;g[C+560>>2]=.5;g[C+564>>2]=-.5;g[C+568>>2]=.5;g[C+572>>2]=D;g[C+576>>2]=E;g[C+580>>2]=F;g[C+584>>2]=G;g[C+588>>2]=.5;g[C+592>>2]=.5;g[C+596>>2]=-.5;g[C+600>>2]=D;g[C+604>>2]=E;g[C+608>>2]=F;g[C+612>>2]=G;g[C+616>>2]=.5;g[C+620>>2]=.5;g[C+624>>2]=.5;g[C+628>>2]=D;g[C+632>>2]=E;g[C+636>>2]=F;g[C+640>>2]=G;g[C+644>>2]=.5;g[C+648>>2]=.5;g[C+652>>2]=.5;g[C+656>>2]=D;g[C+660>>2]=E;g[C+664>>2]=F;g[C+668>>2]=G;G=+g[v>>2];F=+g[v+4>>2];E=+g[v+8>>2];D=+g[v+12>>2];L=+g[v+16>>2];h=+g[v+20>>2];k=+g[v+24>>2];M=+g[v+28>>2];K=+g[v+32>>2];J=+g[v+36>>2];I=+g[v+40>>2];H=+g[v+44>>2];f=+g[v+48>>2];N=+g[v+52>>2];O=+g[v+56>>2];P=+g[v+60>>2];v=0;do{u=v*7|0;B=C+(u<<2)|0;Q=+g[B>>2];r=C+(u+1<<2)|0;R=+g[r>>2];A=C+(u+2<<2)|0;S=+g[A>>2];T=P+(Q*f+0.0+R*N+S*O);g[B>>2]=(D+(Q*G+0.0+R*F+S*E))/T;g[r>>2]=(M+(Q*L+0.0+R*h+S*k))/T;g[A>>2]=(H+(Q*K+0.0+R*J+S*I))/T;v=v+1|0;}while((v|0)<24);ei(24,e);i=l;return}function dN(a){a=a|0;var b=0.0;d9();b=+g[a+20>>2];ep(b,b,1.0);return}function dO(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;e=i;i=i+136|0;f=e|0;h=e+88|0;j=e+96|0;k=e+104|0;l=e+112|0;m=e+120|0;n=e+128|0;eI(b,h,j,k);eI(d,l,m,n);d=a+4|0;o=+Y(+(eN(c[d>>2]|0)|0)*4.0e-4)*.5+.5;p=1.0-o;q=(+g[h>>2]*o+ +g[l>>2]*p)*.15000000596046448;r=(+g[j>>2]*o+ +g[m>>2]*p)*.15000000596046448;s=(o*+g[k>>2]+p*+g[n>>2])*.15000000596046448;n=c[d>>2]|0;d=c[n+68>>2]|0;k=c[n+72>>2]|0;n=f|0;g[n>>2]=0.0;m=f+4|0;g[m>>2]=0.0;j=f+8|0;g[j>>2]=.5;l=f+12|0;g[l>>2]=q;h=f+16|0;g[h>>2]=r;a=f+20|0;g[a>>2]=s;b=f+24|0;g[b>>2]=.8999999761581421;t=f+28|0;p=+(d|0);g[t>>2]=p;d=f+32|0;g[d>>2]=0.0;u=f+36|0;g[u>>2]=.5;v=f+40|0;g[v>>2]=q;w=f+44|0;g[w>>2]=r;x=f+48|0;g[x>>2]=s;y=f+52|0;g[y>>2]=1.0;z=f+56|0;g[z>>2]=0.0;A=f+60|0;o=+(k|0);g[A>>2]=o;k=f+64|0;g[k>>2]=.5;B=f+68|0;g[B>>2]=q;C=f+72|0;g[C>>2]=r;D=f+76|0;g[D>>2]=s;E=f+80|0;g[E>>2]=1.0;ed(3,28,n,3);eg(3,n);g[n>>2]=p;g[m>>2]=0.0;g[j>>2]=.5;g[l>>2]=q;g[h>>2]=r;g[a>>2]=s;g[b>>2]=.8999999761581421;g[t>>2]=0.0;g[d>>2]=o;g[u>>2]=.5;g[v>>2]=q;g[w>>2]=r;g[x>>2]=s;g[y>>2]=1.0;g[z>>2]=p;g[A>>2]=o;g[k>>2]=.5;g[B>>2]=q;g[C>>2]=r;g[D>>2]=s;g[E>>2]=1.0;ed(3,28,n,3);eg(3,n);i=e;return}function dP(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var g=0,h=0.0,i=0.0;g=eN(c[a+4>>2]|0)|0;h=(b|0)==13?.4000000059604645:1.0;if((b|0)==13|(b|0)==1){i=1.0;dM(a,b,d,e,f,h,0,i);return}i=1.0- +bO(+1.0,+(+V(+(+_(+(g|0)*.001+ +(d|0)*30.0/+(c[a+12>>2]|0)+ +(e|0)*30.0/+(c[a+16>>2]|0))))))*.05;dM(a,b,d,e,f,h,0,i);return}function dQ(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;dM(a,0,b,c,0.0,.5,1,1.0);return}function dR(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;dM(a,13,c,d,0.0,b*.4,0,1.0);return}function dS(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;ea();el();a=(f|0)/2|0;en(+(a+d|0),+(((g|0)/4|0)+e|0),0.0);ep(+(a|0),+((g|0)/-2|0|0),1.0);ex(b,c);em();return}function dT(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0.0,l=0.0;f=i;i=i+24|0;e=f|0;h=f+8|0;j=f+16|0;el();en(+(b|0),+(d|0),-1.0);ep(100.0,100.0,1.0);k=+(eN(c[a+4>>2]|0)|0)*.5;l=+V(+(+Y(k*.5)*+Z(k*.01)))+1.0;eI(4,e,h,j);ek(l*+g[e>>2],l*+g[h>>2],l*+g[j>>2],1.0);eD(k);em();i=f;return}function dU(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0,z=0,A=0,B=0;b=i;i=i+88|0;d=b|0;e=c[a+4>>2]|0;a=c[e+68>>2]|0;f=c[e+72>>2]|0;e=d|0;g[e>>2]=0.0;h=d+4|0;g[h>>2]=0.0;j=d+8|0;g[j>>2]=.5;k=d+12|0;g[k>>2]=0.0;l=d+16|0;g[l>>2]=0.0;m=d+20|0;g[m>>2]=0.0;n=d+24|0;g[n>>2]=.8100000023841858;o=d+28|0;p=+(a|0);g[o>>2]=p;a=d+32|0;g[a>>2]=0.0;q=d+36|0;g[q>>2]=.5;r=d+40|0;g[r>>2]=0.0;s=d+44|0;g[s>>2]=0.0;t=d+48|0;g[t>>2]=0.0;u=d+52|0;g[u>>2]=.8999999761581421;v=d+56|0;g[v>>2]=0.0;w=d+60|0;x=+(f|0);g[w>>2]=x;f=d+64|0;g[f>>2]=.5;y=d+68|0;g[y>>2]=0.0;z=d+72|0;g[z>>2]=0.0;A=d+76|0;g[A>>2]=0.0;B=d+80|0;g[B>>2]=.8999999761581421;ed(3,28,e,3);eg(3,e);g[e>>2]=p;g[h>>2]=0.0;g[j>>2]=.5;g[k>>2]=0.0;g[l>>2]=0.0;g[m>>2]=0.0;g[n>>2]=.8100000023841858;g[o>>2]=0.0;g[a>>2]=x;g[q>>2]=.5;g[r>>2]=0.0;g[s>>2]=0.0;g[t>>2]=0.0;g[u>>2]=.8999999761581421;g[v>>2]=p;g[w>>2]=x;g[f>>2]=.5;g[y>>2]=0.0;g[z>>2]=0.0;g[A>>2]=0.0;g[B>>2]=.8999999761581421;ed(3,28,e,3);eg(3,e);i=b;return}function dV(a,b,c,d,e,f,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;h=+h;var j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0,u=0,v=0.0,w=0,x=0.0,y=0,z=0,A=0,B=0,C=0,D=0,E=0.0,F=0,G=0,H=0;a=i;i=i+112|0;j=a|0;k=a+88|0;l=a+96|0;m=a+104|0;eI(b,k,l,m);n=+g[k>>2];o=+g[l>>2];p=+g[m>>2];m=j|0;q=+(c|0);g[m>>2]=q;l=j+4|0;r=+(d|0);g[l>>2]=r;k=j+8|0;g[k>>2]=.5;b=j+12|0;g[b>>2]=n;s=j+16|0;g[s>>2]=o;t=j+20|0;g[t>>2]=p;u=j+24|0;v=h*.9;g[u>>2]=v;w=j+28|0;x=+(e+c|0);g[w>>2]=x;c=j+32|0;g[c>>2]=r;e=j+36|0;g[e>>2]=.5;y=j+40|0;g[y>>2]=n;z=j+44|0;g[z>>2]=o;A=j+48|0;g[A>>2]=p;B=j+52|0;g[B>>2]=h;C=j+56|0;g[C>>2]=q;D=j+60|0;E=+(f+d|0);g[D>>2]=E;d=j+64|0;g[d>>2]=.5;f=j+68|0;g[f>>2]=n;F=j+72|0;g[F>>2]=o;G=j+76|0;g[G>>2]=p;H=j+80|0;g[H>>2]=h;ed(3,28,m,3);eg(3,m);g[m>>2]=x;g[l>>2]=r;g[k>>2]=.5;g[b>>2]=n;g[s>>2]=o;g[t>>2]=p;g[u>>2]=v;g[w>>2]=q;g[c>>2]=E;g[e>>2]=.5;g[y>>2]=n;g[z>>2]=o;g[A>>2]=p;g[B>>2]=h;g[C>>2]=x;g[D>>2]=E;g[d>>2]=.5;g[f>>2]=n;g[F>>2]=o;g[G>>2]=p;g[H>>2]=h;ed(3,28,m,3);eg(3,m);i=a;return}function dW(a,b,c,d,e,f,h,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=+k;var l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0;a=i;i=i+112|0;l=a|0;m=a+88|0;n=a+96|0;o=a+104|0;eI(b,m,n,o);p=+g[m>>2];q=+g[n>>2];r=+g[o>>2];o=l|0;g[o>>2]=+(c|0);g[l+4>>2]=+(d|0);g[l+8>>2]=.5;g[l+12>>2]=p;g[l+16>>2]=q;g[l+20>>2]=r;g[l+24>>2]=k*.9;g[l+28>>2]=+(e|0);g[l+32>>2]=+(f|0);g[l+36>>2]=.5;g[l+40>>2]=p;g[l+44>>2]=q;g[l+48>>2]=r;g[l+52>>2]=k;g[l+56>>2]=+(h|0);g[l+60>>2]=+(j|0);g[l+64>>2]=.5;g[l+68>>2]=p;g[l+72>>2]=q;g[l+76>>2]=r;g[l+80>>2]=k;ed(3,28,o,3);eg(3,o);i=a;return}function dX(a,b,c,d,e,f,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0.0,p=0,q=0.0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0.0,H=0,I=0,J=0,K=0,L=0;a=i;i=i+112|0;j=a|0;k=a+8|0;l=a+16|0;m=a+24|0;n=m|0;o=+(d-10|0);g[n>>2]=o;p=m+4|0;q=+(e-10|0);g[p>>2]=q;r=m+8|0;g[r>>2]=.5;s=m+12|0;g[s>>2]=0.0;t=m+16|0;g[t>>2]=0.0;u=m+20|0;g[u>>2]=0.0;v=m+24|0;g[v>>2]=.7200000286102295;w=m+28|0;x=+(d+10+f|0);g[w>>2]=x;y=m+32|0;g[y>>2]=q;z=m+36|0;g[z>>2]=.5;A=m+40|0;g[A>>2]=0.0;B=m+44|0;g[B>>2]=0.0;C=m+48|0;g[C>>2]=0.0;D=m+52|0;g[D>>2]=.800000011920929;E=m+56|0;g[E>>2]=o;F=m+60|0;G=+(e+10+h|0);g[F>>2]=G;H=m+64|0;g[H>>2]=.5;I=m+68|0;g[I>>2]=0.0;J=m+72|0;g[J>>2]=0.0;K=m+76|0;g[K>>2]=0.0;L=m+80|0;g[L>>2]=.800000011920929;ed(3,28,n,3);eg(3,n);g[n>>2]=x;g[p>>2]=q;g[r>>2]=.5;g[s>>2]=0.0;g[t>>2]=0.0;g[u>>2]=0.0;g[v>>2]=.7200000286102295;g[w>>2]=o;g[y>>2]=G;g[z>>2]=.5;g[A>>2]=0.0;g[B>>2]=0.0;g[C>>2]=0.0;g[D>>2]=.800000011920929;g[E>>2]=x;g[F>>2]=G;g[H>>2]=.5;g[I>>2]=0.0;g[J>>2]=0.0;g[K>>2]=0.0;g[L>>2]=.800000011920929;ed(3,28,n,3);eg(3,n);eI(b,j,k,l);ek(+g[j>>2],+g[k>>2],+g[l>>2],1.0);el();l=(h|0)/2|0;en(+(f+d|0),+(l+e|0),0.0);ep(+(l|0),+((h|0)/-2|0|0),1.0);en(-.5,-.800000011920929,.20000000298023224);ep(3.200000047683716,3.200000047683716,1.0);eo(20.0,1.0,0.0,0.0);eB(c);em();i=a;return}function dY(a,b,d,e,f,h,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0;a=i;i=i+40|0;l=a|0;m=a+8|0;n=a+16|0;o=a+24|0;eE(o,d);el();if((k&1|0)==0){p=e;q=f}else{p=~~(+(e|0)+ +(h-(c[o>>2]<<1)|0)*.5);q=~~(+(f|0)+ +(j-(c[o+4>>2]<<1)|0)*.5)}en(+(p|0),+(q|0),0.0);ep(2.0,2.0,1.0);eI(b,l,m,n);ek(+g[l>>2],+g[m>>2],+g[n>>2],1.0);eG(o);em();eF(o);i=a;return}function dZ(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return}function d_(a,b,c){a=a|0;b=b|0;c=c|0;en(+(b|0),+(c|0),0.0);return}function d$(a){a=a|0;eb();return}function d0(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;d=+g[b>>2];e=+g[c>>2];f=+g[b+4>>2];h=+g[c+16>>2];i=+g[b+8>>2];j=+g[c+32>>2];k=+g[b+12>>2];l=+g[c+48>>2];g[a>>2]=d*e+f*h+i*j+k*l;m=+g[c+4>>2];n=+g[c+20>>2];o=+g[c+36>>2];p=+g[c+52>>2];g[a+4>>2]=d*m+f*n+i*o+k*p;q=+g[c+8>>2];r=+g[c+24>>2];s=+g[c+40>>2];t=+g[c+56>>2];g[a+8>>2]=d*q+f*r+i*s+k*t;u=+g[c+12>>2];v=+g[c+28>>2];w=+g[c+44>>2];x=+g[c+60>>2];g[a+12>>2]=d*u+f*v+i*w+k*x;k=+g[b+16>>2];i=+g[b+20>>2];f=+g[b+24>>2];d=+g[b+28>>2];g[a+16>>2]=k*e+i*h+f*j+d*l;g[a+20>>2]=k*m+i*n+f*o+d*p;g[a+24>>2]=k*q+i*r+f*s+d*t;g[a+28>>2]=k*u+i*v+f*w+d*x;d=+g[b+32>>2];f=+g[b+36>>2];i=+g[b+40>>2];k=+g[b+44>>2];g[a+32>>2]=d*e+f*h+i*j+k*l;g[a+36>>2]=d*m+f*n+i*o+k*p;g[a+40>>2]=d*q+f*r+i*s+k*t;g[a+44>>2]=d*u+f*v+i*w+k*x;k=+g[b+48>>2];i=+g[b+52>>2];f=+g[b+56>>2];d=+g[b+60>>2];g[a+48>>2]=k*e+i*h+f*j+d*l;g[a+52>>2]=k*m+i*n+f*o+d*p;g[a+56>>2]=k*q+i*r+f*s+d*t;g[a+60>>2]=k*u+i*v+f*w+d*x;return}function d1(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+24|0;e=d|0;f=d+8|0;g=d+16|0;c[e>>2]=a;c[f>>2]=b;b=cK()|0;a=ba(35633)|0;bW(a|0,1,e|0,0);a_(a|0);bx(b|0,a|0);a=ba(35632)|0;bW(a|0,1,f|0,0);a_(a|0);bx(b|0,a|0);aP(b|0);c[g>>2]=0;bh(b|0,35714,g|0);if((c[g>>2]|0)==0){bK(1104)|0;bt(0);return 0}else{i=d;return b|0}return 0}function d2(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;ev(a|0);b=a+4|0;d=c[b>>2]|0;e=a+8|0;f=c[e>>2]|0;do{if((d|0)!=(f|0)){g=d;do{oF(c[g>>2]|0);g=g+4|0;}while((g|0)!=(f|0));g=c[b>>2]|0;h=c[e>>2]|0;if((g|0)==(h|0)){break}c[e>>2]=h+(~((h-4+(-g|0)|0)>>>2)<<2)}}while(0);e=c[a>>2]|0;if((e|0)==0){return}oF(e);return}function d3(a){a=a|0;c[a>>2]=139792;oz(c[a+4>>2]|0);return}function d4(a){a=a|0;c[a>>2]=139792;oz(c[a+4>>2]|0);return}function d5(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=a|0;a=oD(12)|0;c[f>>2]=a;a3(1,a|0);c[(c[f>>2]|0)+4>>2]=d;c[(c[f>>2]|0)+8>>2]=e;aR(3553,c[c[f>>2]>>2]|0);cv(3553,0,6406,d|0,e|0,0,6406,5121,b|0);cW(3553,10241,9728);cW(3553,10240,9728);cW(3553,10242,33071);cW(3553,10243,33071);return}function d6(a){a=a|0;var b=0;b=a|0;a0(1,c[b>>2]|0);a=c[b>>2]|0;if((a|0)==0){return}oF(a);return}function d7(){var a=0,b=0,d=0,e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;a=c[38578]|0;b=c[38577]|0;if((a|0)==(b|0)){d=0}else{d=(a-b<<4)-1|0}e=c[38580]|0;f=c[38581]|0;if((d|0)==(f+e|0)){es(154304);h=c[38581]|0;i=c[38580]|0;j=c[38577]|0;k=c[38578]|0}else{h=f;i=e;j=b;k=a}a=h+i|0;do{if((k|0)==(j|0)){l=h}else{i=c[j+(a>>>6<<2)>>2]|0;b=a&63;e=i+(b<<6)|0;if((e|0)==0){l=h;break}g[e>>2]=1.0;oO(i+(b<<6)+4|0,0,16);g[i+(b<<6)+20>>2]=1.0;oO(i+(b<<6)+24|0,0,16);g[i+(b<<6)+40>>2]=1.0;oO(i+(b<<6)+44|0,0,16);g[i+(b<<6)+60>>2]=1.0;l=c[38581]|0}}while(0);c[38581]=l+1;oO(154328,0,16);aK(+0.0,+0.0,+0.0,+0.0);cD(3042);cJ(770,771);c[38562]=d1(c[38510]|0,c[38511]|0)|0;c[38563]=0;l=154048;while(1){h=c[l>>2]|0;if((h|0)==0){m=154168;break}c[l+8>>2]=cH(c[38562]|0,h|0)|0;c[38563]=(c[38563]|0)+(c[l+4>>2]<<2);h=l+12|0;if((h|0)==0){m=154168;break}else{l=h}}do{l=c[m>>2]|0;if((l|0)==0){break}c[m+4>>2]=bn(c[38562]|0,l|0)|0;m=m+8|0;}while((m|0)!=0);c[38454]=d1(c[38402]|0,c[38403]|0)|0;c[38455]=0;m=153616;while(1){l=c[m>>2]|0;if((l|0)==0){n=153736;break}c[m+8>>2]=cH(c[38454]|0,l|0)|0;c[38455]=(c[38455]|0)+(c[m+4>>2]<<2);l=m+12|0;if((l|0)==0){n=153736;break}else{m=l}}do{m=c[n>>2]|0;if((m|0)==0){break}c[n+4>>2]=bn(c[38454]|0,m|0)|0;n=n+8|0;}while((n|0)!=0);c[38508]=d1(c[38456]|0,c[38457]|0)|0;c[38509]=0;n=153832;while(1){m=c[n>>2]|0;if((m|0)==0){o=153952;break}c[n+8>>2]=cH(c[38508]|0,m|0)|0;c[38509]=(c[38509]|0)+(c[n+4>>2]<<2);m=n+12|0;if((m|0)==0){o=153952;break}else{n=m}}while(1){n=c[o>>2]|0;if((n|0)==0){p=132;break}c[o+4>>2]=bn(c[38508]|0,n|0)|0;n=o+8|0;if((n|0)==0){p=133;break}else{o=n}}if((p|0)==132){cG(1,154256);cG(1,154264);return}else if((p|0)==133){cG(1,154256);cG(1,154264);return}}function d8(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;d=i;i=i+384|0;e=d|0;f=d+64|0;h=d+128|0;j=d+192|0;k=d+256|0;l=d+320|0;cO(0,0,c[a>>2]|0,c[b>>2]|0);g[38588]=1.0;oO(154356,0,16);g[38593]=1.0;oO(154376,0,16);g[38598]=1.0;oO(154396,0,16);g[38603]=1.0;m=c[a>>2]|0;n=c[b>>2]|0;if((m|0)>(n|0)){c[a>>2]=n;c[b>>2]=m;g[j>>2]=-4.371138828673793e-8;g[j+4>>2]=-1.0;g[j+8>>2]=0.0;g[j+12>>2]=0.0;g[j+16>>2]=1.0;g[j+20>>2]=-4.371138828673793e-8;oO(j+24|0,0,16);g[j+40>>2]=1.0;oO(j+44|0,0,16);g[j+60>>2]=1.0;o=f;d0(f,154352,j);oN(154352,o|0,64)|0;p=1;q=c[a>>2]|0;r=c[b>>2]|0}else{p=0;q=m;r=n}s=+(-q|0)*.5;t=+(q|0)*.5;u=+(r|0)*.5;v=+(-r|0)*.5;w=t-s;x=v-u;g[k>>2]=20.0/w;g[k+4>>2]=0.0;g[k+8>>2]=(s+t)/w;g[k+12>>2]=0.0;g[k+16>>2]=0.0;g[k+20>>2]=20.0/x;g[k+24>>2]=(u+v)/x;g[k+28>>2]=0.0;g[k+32>>2]=0.0;g[k+36>>2]=0.0;g[k+40>>2]=-3.0;g[k+44>>2]=-40.0;g[k+48>>2]=0.0;g[k+52>>2]=0.0;g[k+56>>2]=-1.0;g[k+60>>2]=0.0;r=e;d0(e,154352,k);oN(154352,r|0,64)|0;x=+(-(c[a>>2]|0)|0)*.5;v=+(-(c[b>>2]|0)|0)*.5;g[l>>2]=1.0;g[l+4>>2]=0.0;g[l+8>>2]=0.0;g[l+12>>2]=x;g[l+16>>2]=0.0;g[l+20>>2]=1.0;g[l+24>>2]=0.0;g[l+28>>2]=v;g[l+32>>2]=0.0;g[l+36>>2]=0.0;g[l+40>>2]=1.0;g[l+44>>2]=-10.5;g[l+48>>2]=0.0;g[l+52>>2]=0.0;g[l+56>>2]=0.0;g[l+60>>2]=1.0;b=h;d0(h,154352,l);oN(154352,b|0,64)|0;i=d;return p|0}function d9(){var a=0,b=0,d=0;b4(16640);a=(c[38581]|0)-1+(c[38580]|0)|0;b=c[(c[38577]|0)+(a>>>6<<2)>>2]|0;d=a&63;g[b+(d<<6)>>2]=1.0;oO(b+(d<<6)+4|0,0,16);g[b+(d<<6)+20>>2]=1.0;oO(b+(d<<6)+24|0,0,16);g[b+(d<<6)+40>>2]=1.0;oO(b+(d<<6)+44|0,0,16);g[b+(d<<6)+60>>2]=1.0;return}function ea(){b4(256);return}function eb(){var a=0,b=0,d=0;a=c[38398]|0;if((a|0)==0){return}b=a+8|0;d=c[b>>2]|0;if((d|0)!=0){dh[c[c[a>>2]>>2]&31](a,c[a+4>>2]|0,d);c[b>>2]=0}c[38398]=0;return}function ec(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0;b=i;i=i+144|0;d=b|0;e=c[38398]|0;if((e|0)!=0){f=e+8|0;h=c[f>>2]|0;if((h|0)!=0){dh[c[c[e>>2]>>2]&31](e,c[e+4>>2]|0,h);c[f>>2]=0}c[38398]=0}be(2929);f=a|0;aR(3553,c[c[f>>2]>>2]|0);oO(d|0,0,20);j=+g[38582];g[d+20>>2]=j;k=+g[38583];g[d+24>>2]=k;l=+g[38584];g[d+28>>2]=l;m=+g[38585];g[d+32>>2]=m;g[d+36>>2]=0.0;a=c[f>>2]|0;f=a+8|0;g[d+40>>2]=+(c[f>>2]|0);g[d+44>>2]=0.0;g[d+48>>2]=0.0;g[d+52>>2]=1.0;g[d+56>>2]=j;g[d+60>>2]=k;g[d+64>>2]=l;g[d+68>>2]=m;h=a+4|0;g[d+72>>2]=+(c[h>>2]|0);g[d+76>>2]=0.0;g[d+80>>2]=0.0;g[d+84>>2]=1.0;g[d+88>>2]=0.0;g[d+92>>2]=j;g[d+96>>2]=k;g[d+100>>2]=l;g[d+104>>2]=m;g[d+108>>2]=+(c[h>>2]|0);g[d+112>>2]=+(c[f>>2]|0);g[d+116>>2]=0.0;g[d+120>>2]=1.0;g[d+124>>2]=1.0;g[d+128>>2]=j;g[d+132>>2]=k;g[d+136>>2]=l;g[d+140>>2]=m;f=c[38455]|0;h=144/(f>>>0)|0;ed(3,f,d|0,h);b7(34962,c[38566]|0);cb(34962,144,d|0,35040);bU(c[38454]|0);d=0;f=153616;while(1){if((c[f>>2]|0)==0){break}a=f+8|0;b6(c[a>>2]|0);e=f+4|0;bi(c[a>>2]|0,c[e>>2]|0,5126,0,c[38455]|0,d<<2|0);a=f+12|0;if((a|0)==0){break}else{d=(c[e>>2]|0)+d|0;f=a}}cT(c[38435]|0,1,0,154352);bs(5,0,h|0);h=153616;while(1){if((c[h>>2]|0)==0){n=157;break}ct(c[h+8>>2]|0);f=h+12|0;if((f|0)==0){n=158;break}else{h=f}}if((n|0)==157){bU(0);b7(34962,0);i=b;return}else if((n|0)==158){bU(0);b7(34962,0);i=b;return}}function ed(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;f=(c[38581]|0)-1+(c[38580]|0)|0;h=c[(c[38577]|0)+(f>>>6<<2)>>2]|0;i=f&63;f=(b|0)==0?a<<2:b;if((e|0)<=0){return}b=d;d=h+(i<<6)|0;j=h+(i<<6)+4|0;k=h+(i<<6)+8|0;l=h+(i<<6)+12|0;m=h+(i<<6)+16|0;n=h+(i<<6)+20|0;o=h+(i<<6)+24|0;p=h+(i<<6)+28|0;q=h+(i<<6)+32|0;r=h+(i<<6)+36|0;s=h+(i<<6)+40|0;t=h+(i<<6)+44|0;u=h+(i<<6)+48|0;v=h+(i<<6)+52|0;w=h+(i<<6)+56|0;x=h+(i<<6)+60|0;i=(a|0)==3;if((a|0)==4){a=0;do{h=ag(a,f)|0;y=b+h|0;z=+g[y>>2];A=+g[b+(h+4)>>2];B=+g[b+(h+8)>>2];C=+g[b+(h+12)>>2];D=z*+g[d>>2]+0.0+A*+g[j>>2]+B*+g[k>>2]+C*+g[l>>2];E=z*+g[m>>2]+0.0+A*+g[n>>2]+B*+g[o>>2]+C*+g[p>>2];F=z*+g[q>>2]+0.0+A*+g[r>>2]+B*+g[s>>2]+C*+g[t>>2];G=z*+g[u>>2]+0.0+A*+g[v>>2]+B*+g[w>>2]+C*+g[x>>2];if(i){g[y>>2]=D/G;g[b+(h+4)>>2]=E/G;g[b+(h+8)>>2]=F/G}else{g[y>>2]=D;g[b+(h+4)>>2]=E;g[b+(h+8)>>2]=F;g[b+(h+12)>>2]=G}a=a+1|0;}while((a|0)<(e|0));return}else{if(i){i=0;do{a=ag(i,f)|0;h=b+a|0;G=+g[h>>2];F=+g[b+(a+4)>>2];E=+g[b+(a+8)>>2];D=G*+g[m>>2]+0.0+F*+g[n>>2]+E*+g[o>>2]+ +g[p>>2];C=G*+g[q>>2]+0.0+F*+g[r>>2]+E*+g[s>>2]+ +g[t>>2];B=G*+g[u>>2]+0.0+F*+g[v>>2]+E*+g[w>>2]+ +g[x>>2];g[h>>2]=(G*+g[d>>2]+0.0+F*+g[j>>2]+E*+g[k>>2]+ +g[l>>2])/B;g[b+(a+4)>>2]=D/B;g[b+(a+8)>>2]=C/B;i=i+1|0;}while((i|0)<(e|0));return}else{B=0.0;C=0.0;D=0.0;E=0.0;i=0;while(1){a=ag(i,f)|0;F=E*+g[d>>2]+0.0+D*+g[j>>2]+C*+g[k>>2]+B*+g[l>>2];G=E*+g[m>>2]+0.0+D*+g[n>>2]+C*+g[o>>2]+B*+g[p>>2];A=E*+g[q>>2]+0.0+D*+g[r>>2]+C*+g[s>>2]+B*+g[t>>2];z=E*+g[u>>2]+0.0+D*+g[v>>2]+C*+g[w>>2]+B*+g[x>>2];g[b+a>>2]=F;g[b+(a+4)>>2]=G;g[b+(a+8)>>2]=A;g[b+(a+12)>>2]=z;a=i+1|0;if((a|0)<(e|0)){B=z;C=A;D=G;E=F;i=a}else{break}}return}}}function ee(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=c[38398]|0;if((d|0)!=0){e=d+8|0;f=c[e>>2]|0;if((f|0)!=0){dh[c[c[d>>2]>>2]&31](d,c[d+4>>2]|0,f);c[e>>2]=0}c[38398]=0}cD(2929);b7(34962,c[38564]|0);bU(c[38508]|0);e=0;f=153832;while(1){if((c[f>>2]|0)==0){break}d=f+8|0;b6(c[d>>2]|0);g=f+4|0;bi(c[d>>2]|0,c[g>>2]|0,5126,0,c[38509]|0,e<<2|0);d=f+12|0;if((d|0)==0){break}else{e=(c[g>>2]|0)+e|0;f=d}}cT(c[38489]|0,1,0,154352);f=(c[38581]|0)-1+(c[38580]|0)|0;cT(c[38491]|0,1,0,(c[(c[38577]|0)+(f>>>6<<2)>>2]|0)+((f&63)<<6)|0);bp(c[38493]|0,1,154328);bs(4,a|0,b|0);b=153832;while(1){if((c[b>>2]|0)==0){h=184;break}ct(c[b+8>>2]|0);a=b+12|0;if((a|0)==0){h=185;break}else{b=a}}if((h|0)==184){bU(0);b7(34962,0);return}else if((h|0)==185){bU(0);b7(34962,0);return}}function ef(){var a=0;a=(c[38581]|0)-1+(c[38580]|0)|0;return(c[(c[38577]|0)+(a>>>6<<2)>>2]|0)+((a&63)<<6)|0}function eg(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;d=b;b=ag(c[38563]|0,a)|0;a=c[38398]|0;if((a|0)!=154288){do{if((a|0)!=0){e=a+8|0;f=c[e>>2]|0;if((f|0)==0){break}dh[c[c[a>>2]>>2]&31](a,c[a+4>>2]|0,f);c[e>>2]=0}}while(0);c[38398]=154288}a=c[38574]|0;e=c[38575]|0;if((a+b|0)>>>0>e>>>0){f=e<<1;c[38575]=f;e=oA(c[38573]|0,f)|0;c[38573]=e;g=c[38574]|0;h=e;i=h+g|0;oN(i|0,d|0,b)|0;j=c[38574]|0;k=j+b|0;c[38574]=k;return}else{g=a;h=c[38573]|0;i=h+g|0;oN(i|0,d|0,b)|0;j=c[38574]|0;k=j+b|0;c[38574]=k;return}}function eh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;a=(d>>>0)/((c[38563]|0)>>>0)|0;be(2929);b7(34962,c[38566]|0);cb(34962,d|0,b|0,35040);bU(c[38562]|0);b=0;d=154048;while(1){if((c[d>>2]|0)==0){break}e=d+8|0;b6(c[e>>2]|0);f=d+4|0;bi(c[e>>2]|0,c[f>>2]|0,5126,0,c[38563]|0,b<<2|0);e=d+12|0;if((e|0)==0){break}else{b=(c[f>>2]|0)+b|0;d=e}}cT(c[38543]|0,1,0,154352);bs(4,0,a|0);a=154048;while(1){if((c[a>>2]|0)==0){g=205;break}ct(c[a+8>>2]|0);d=a+12|0;if((d|0)==0){g=206;break}else{a=d}}if((g|0)==205){bU(0);b7(34962,0);return}else if((g|0)==206){bU(0);b7(34962,0);return}}function ei(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;d=b;b=ag(c[38563]|0,a)|0;a=c[38398]|0;if((a|0)!=154272){do{if((a|0)!=0){e=a+8|0;f=c[e>>2]|0;if((f|0)==0){break}dh[c[c[a>>2]>>2]&31](a,c[a+4>>2]|0,f);c[e>>2]=0}}while(0);c[38398]=154272}a=c[38570]|0;e=c[38571]|0;if((a+b|0)>>>0>e>>>0){f=e<<1;c[38571]=f;e=oA(c[38569]|0,f)|0;c[38569]=e;g=c[38570]|0;h=e;i=h+g|0;oN(i|0,d|0,b)|0;j=c[38570]|0;k=j+b|0;c[38570]=k;return}else{g=a;h=c[38569]|0;i=h+g|0;oN(i|0,d|0,b)|0;j=c[38570]|0;k=j+b|0;c[38570]=k;return}}function ej(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;a=(d>>>0)/((c[38563]|0)>>>0)|0;cD(2929);b7(34962,c[38566]|0);cb(34962,d|0,b|0,35040);bU(c[38562]|0);b=0;d=154048;while(1){if((c[d>>2]|0)==0){break}e=d+8|0;b6(c[e>>2]|0);f=d+4|0;bi(c[e>>2]|0,c[f>>2]|0,5126,0,c[38563]|0,b<<2|0);e=d+12|0;if((e|0)==0){break}else{b=(c[f>>2]|0)+b|0;d=e}}cT(c[38543]|0,1,0,154352);bs(5,0,a|0);a=154048;while(1){if((c[a>>2]|0)==0){g=225;break}ct(c[a+8>>2]|0);d=a+12|0;if((d|0)==0){g=226;break}else{a=d}}if((g|0)==225){bU(0);b7(34962,0);return}else if((g|0)==226){bU(0);b7(34962,0);return}}function ek(a,b,c,d){a=+a;b=+b;c=+c;d=+d;g[38582]=a;g[38583]=b;g[38584]=c;g[38585]=d;return}function el(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;a=c[38581]|0;b=c[38580]|0;d=a-1+b|0;e=c[38577]|0;f=(c[e+(d>>>6<<2)>>2]|0)+((d&63)<<6)|0;d=c[38578]|0;if((d|0)==(e|0)){g=0}else{g=(d-e<<4)-1|0}if((g|0)==(a+b|0)){es(154304);h=c[38581]|0;i=c[38580]|0;j=c[38577]|0;k=c[38578]|0}else{h=a;i=b;j=e;k=d}d=h+i|0;if((k|0)==(j|0)){l=h+1|0;c[38581]=l;return}k=(c[j+(d>>>6<<2)>>2]|0)+((d&63)<<6)|0;if((k|0)==0){l=h+1|0;c[38581]=l;return}d=k;k=f;oN(d|0,k|0,64)|0;l=h+1|0;c[38581]=l;return}function em(){var a=0,b=0,d=0,e=0;a=c[38581]|0;c[38581]=a-1;b=c[38578]|0;d=c[38577]|0;if((b|0)==(d|0)){e=0}else{e=(b-d<<4)-1|0}if((e+(1-a)-(c[38580]|0)|0)>>>0<=127>>>0){return}oF(c[b-4>>2]|0);c[38578]=(c[38578]|0)-4;return}function en(a,b,d){a=+a;b=+b;d=+d;var e=0,f=0,h=0,j=0,k=0;e=i;i=i+128|0;f=e|0;h=e+64|0;j=(c[38581]|0)-1+(c[38580]|0)|0;k=(c[(c[38577]|0)+(j>>>6<<2)>>2]|0)+((j&63)<<6)|0;g[h>>2]=1.0;g[h+4>>2]=0.0;g[h+8>>2]=0.0;g[h+12>>2]=a;g[h+16>>2]=0.0;g[h+20>>2]=1.0;g[h+24>>2]=0.0;g[h+28>>2]=b;g[h+32>>2]=0.0;g[h+36>>2]=0.0;g[h+40>>2]=1.0;g[h+44>>2]=d;g[h+48>>2]=0.0;g[h+52>>2]=0.0;g[h+56>>2]=0.0;g[h+60>>2]=1.0;j=f;d0(f,k,h);h=k;oN(h|0,j|0,64)|0;i=e;return}function eo(a,b,d,e){a=+a;b=+b;d=+d;e=+e;var f=0,h=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0;f=i;i=i+128|0;h=f|0;j=f+64|0;k=(c[38581]|0)-1+(c[38580]|0)|0;l=(c[(c[38577]|0)+(k>>>6<<2)>>2]|0)+((k&63)<<6)|0;m=a*3.141592653589793/180.0;a=+Z(m);n=+W(b*b+d*d+e*e);o=b/n;b=d/n;d=e/n;n=+Y(m);m=1.0-n;e=m*o*b;p=a*d;q=m*o*d;r=a*b;s=m*b*d;t=a*o;g[j>>2]=n+m*o*o;g[j+4>>2]=e-p;g[j+8>>2]=r+q;g[j+12>>2]=0.0;g[j+16>>2]=e+p;g[j+20>>2]=n+m*b*b;g[j+24>>2]=s-t;g[j+28>>2]=0.0;g[j+32>>2]=q-r;g[j+36>>2]=t+s;g[j+40>>2]=n+m*d*d;oO(j+44|0,0,16);g[j+60>>2]=1.0;k=h;d0(h,l,j);j=l;oN(j|0,k|0,64)|0;i=f;return}function ep(a,b,d){a=+a;b=+b;d=+d;var e=0,f=0,h=0,j=0,k=0;e=i;i=i+128|0;f=e|0;h=e+64|0;j=(c[38581]|0)-1+(c[38580]|0)|0;k=(c[(c[38577]|0)+(j>>>6<<2)>>2]|0)+((j&63)<<6)|0;g[h>>2]=a;oO(h+4|0,0,16);g[h+20>>2]=b;oO(h+24|0,0,16);g[h+40>>2]=d;oO(h+44|0,0,16);g[h+60>>2]=1.0;j=f;d0(f,k,h);h=k;oN(h|0,j|0,64)|0;i=e;return}function eq(a,b,c){a=+a;b=+b;c=+c;return}function er(a,b){a=a|0;b=b|0;b7(34962,c[38564]|0);cb(34962,b|0,a|0,35044);b7(34962,0);return}function es(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0;b=i;i=i+32|0;d=b|0;e=b+8|0;f=a+16|0;g=c[f>>2]|0;if(g>>>0>63>>>0){c[f>>2]=g-64;g=a+4|0;f=c[g>>2]|0;h=c[f>>2]|0;j=f+4|0;c[g>>2]=j;k=a+8|0;l=c[k>>2]|0;m=a+12|0;do{if((l|0)==(c[m>>2]|0)){n=a|0;o=c[n>>2]|0;if(j>>>0>o>>>0){p=j;q=((p-o>>2)+1|0)/-2|0;r=q+1|0;s=l-p|0;oP(f+(r<<2)|0,j|0,s|0);p=f+(r+(s>>2)<<2)|0;c[k>>2]=p;c[g>>2]=(c[g>>2]|0)+(q<<2);t=p;break}p=l-o>>1;q=(p|0)==0?1:p;p=oD(q<<2)|0;s=p+(q>>>2<<2)|0;r=p+(q<<2)|0;if((j|0)==(l|0)){u=s;v=o}else{o=j;q=s;do{if((q|0)==0){w=0}else{c[q>>2]=c[o>>2];w=q}q=w+4|0;o=o+4|0;}while((o|0)!=(l|0));u=q;v=c[n>>2]|0}c[n>>2]=p;c[g>>2]=s;c[k>>2]=u;c[m>>2]=r;if((v|0)==0){t=u;break}oF(v);t=c[k>>2]|0}else{t=l}}while(0);if((t|0)==0){x=0}else{c[t>>2]=h;x=c[k>>2]|0}c[k>>2]=x+4;i=b;return}x=a|0;k=a+8|0;h=c[k>>2]|0;t=a+4|0;l=h-(c[t>>2]|0)>>2;v=a+12|0;u=v|0;m=c[u>>2]|0;g=a|0;a=m-(c[g>>2]|0)|0;if(l>>>0>=a>>2>>>0){w=a>>1;a=(w|0)==0?1:w;w=e+12|0;c[e+16>>2]=v;v=oD(a<<2)|0;j=v;f=e|0;c[f>>2]=j;o=j+(l<<2)|0;y=e+8|0;c[y>>2]=o;z=e+4|0;c[z>>2]=o;c[w>>2]=j+(a<<2);A=oD(4096)|0;do{if((l|0)==(a|0)){B=o-v|0;if(o>>>0>j>>>0){C=j+(l+(((B>>2)+1|0)/-2|0)<<2)|0;c[y>>2]=C;c[z>>2]=C;D=C;break}C=B>>1;B=(C|0)==0?1:C;C=oD(B<<2)|0;E=C+(B>>>2<<2)|0;c[f>>2]=C;c[z>>2]=E;c[y>>2]=E;c[w>>2]=C+(B<<2);if((v|0)==0){D=E;break}oF(v);D=E}else{D=o}}while(0);if((D|0)==0){F=0}else{c[D>>2]=A;F=c[y>>2]|0}c[y>>2]=F+4;F=c[k>>2]|0;while(1){if((F|0)==(c[t>>2]|0)){break}A=F-4|0;eu(e,A);F=A}e=c[g>>2]|0;c[g>>2]=c[f>>2];c[f>>2]=e;c[t>>2]=c[z>>2];c[z>>2]=F;z=c[k>>2]|0;c[k>>2]=c[y>>2];c[y>>2]=z;f=c[u>>2]|0;c[u>>2]=c[w>>2];c[w>>2]=f;if((F|0)!=(z|0)){c[y>>2]=z+(~((z-4+(-F|0)|0)>>>2)<<2)}if((e|0)==0){i=b;return}oF(e);i=b;return}e=oD(4096)|0;if((m|0)!=(h|0)){if((h|0)==0){G=0}else{c[h>>2]=e;G=c[k>>2]|0}c[k>>2]=G+4;i=b;return}c[d>>2]=e;et(x,d);d=c[t>>2]|0;x=c[d>>2]|0;e=d+4|0;c[t>>2]=e;G=c[k>>2]|0;do{if((G|0)==(c[u>>2]|0)){h=c[g>>2]|0;if(e>>>0>h>>>0){m=e;F=((m-h>>2)+1|0)/-2|0;z=F+1|0;y=G-m|0;oP(d+(z<<2)|0,e|0,y|0);m=d+(z+(y>>2)<<2)|0;c[k>>2]=m;c[t>>2]=(c[t>>2]|0)+(F<<2);H=m;break}m=G-h>>1;F=(m|0)==0?1:m;m=oD(F<<2)|0;y=m+(F>>>2<<2)|0;z=m+(F<<2)|0;if((e|0)==(G|0)){I=y;J=h}else{h=e;F=y;do{if((F|0)==0){K=0}else{c[F>>2]=c[h>>2];K=F}F=K+4|0;h=h+4|0;}while((h|0)!=(G|0));I=F;J=c[g>>2]|0}c[g>>2]=m;c[t>>2]=y;c[k>>2]=I;c[u>>2]=z;if((J|0)==0){H=I;break}oF(J);H=c[k>>2]|0}else{H=G}}while(0);if((H|0)==0){L=0}else{c[H>>2]=x;L=c[k>>2]|0}c[k>>2]=L+4;i=b;return}function et(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;d=a+4|0;e=c[d>>2]|0;f=a|0;do{if((e|0)==(c[f>>2]|0)){g=a+8|0;h=c[g>>2]|0;i=a+12|0;j=c[i>>2]|0;k=j;if(h>>>0<j>>>0){j=h;l=((k-j>>2)+1|0)/2|0;m=j-e|0;j=h+(l-(m>>2)<<2)|0;oP(j|0,e|0,m|0);c[d>>2]=j;c[g>>2]=(c[g>>2]|0)+(l<<2);n=j;break}j=k-e>>1;k=(j|0)==0?1:j;j=oD(k<<2)|0;l=j+((k+3|0)>>>2<<2)|0;m=j+(k<<2)|0;if((e|0)==(h|0)){o=l;p=e}else{k=e;q=l;do{if((q|0)==0){r=0}else{c[q>>2]=c[k>>2];r=q}q=r+4|0;k=k+4|0;}while((k|0)!=(h|0));o=q;p=c[f>>2]|0}c[f>>2]=j;c[d>>2]=l;c[g>>2]=o;c[i>>2]=m;if((p|0)==0){n=l;break}oF(p);n=c[d>>2]|0}else{n=e}}while(0);e=n-4|0;if((e|0)==0){s=n;t=s-4|0;c[d>>2]=t;return}c[e>>2]=c[b>>2];s=c[d>>2]|0;t=s-4|0;c[d>>2]=t;return}function eu(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;d=a+4|0;e=c[d>>2]|0;f=a|0;do{if((e|0)==(c[f>>2]|0)){g=a+8|0;h=c[g>>2]|0;i=a+12|0;j=c[i>>2]|0;k=j;if(h>>>0<j>>>0){j=h;l=((k-j>>2)+1|0)/2|0;m=j-e|0;j=h+(l-(m>>2)<<2)|0;oP(j|0,e|0,m|0);c[d>>2]=j;c[g>>2]=(c[g>>2]|0)+(l<<2);n=j;break}j=k-e>>1;k=(j|0)==0?1:j;j=oD(k<<2)|0;l=j+((k+3|0)>>>2<<2)|0;m=j+(k<<2)|0;if((e|0)==(h|0)){o=l;p=e}else{k=e;q=l;do{if((q|0)==0){r=0}else{c[q>>2]=c[k>>2];r=q}q=r+4|0;k=k+4|0;}while((k|0)!=(h|0));o=q;p=c[f>>2]|0}c[f>>2]=j;c[d>>2]=l;c[g>>2]=o;c[i>>2]=m;if((p|0)==0){n=l;break}oF(p);n=c[d>>2]|0}else{n=e}}while(0);e=n-4|0;if((e|0)==0){s=n;t=s-4|0;c[d>>2]=t;return}c[e>>2]=c[b>>2];s=c[d>>2]|0;t=s-4|0;c[d>>2]=t;return}function ev(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;b=a+4|0;d=c[b>>2]|0;e=a+16|0;f=c[e>>2]|0;g=d+(f>>>6<<2)|0;h=a+8|0;i=c[h>>2]|0;if((i|0)==(d|0)){j=0;k=0;l=a+20|0}else{m=a+20|0;a=f+(c[m>>2]|0)|0;j=(c[d+(a>>>6<<2)>>2]|0)+((a&63)<<6)|0;k=(c[g>>2]|0)+((f&63)<<6)|0;l=m}m=g;g=k;L419:while(1){k=g;do{if((k|0)==(j|0)){break L419}k=k+64|0;}while((k-(c[m>>2]|0)|0)!=4096);k=m+4|0;m=k;g=c[k>>2]|0}c[l>>2]=0;l=i-d>>2;if(l>>>0>2>>>0){i=d;while(1){oF(c[i>>2]|0);d=(c[b>>2]|0)+4|0;c[b>>2]=d;g=(c[h>>2]|0)-d>>2;if(g>>>0>2>>>0){i=d}else{n=g;break}}}else{n=l}if((n|0)==2){c[e>>2]=64;return}else if((n|0)==1){c[e>>2]=32;return}else{return}}function ew(){oO(154304|0,0|0,24|0);bk(102,154304,t|0)|0;g[38588]=1.0;g[38592]=0.0;g[38596]=0.0;g[38600]=0.0;g[38589]=0.0;g[38593]=1.0;g[38597]=0.0;g[38601]=0.0;g[38590]=0.0;g[38594]=0.0;g[38598]=1.0;g[38602]=0.0;g[38591]=0.0;g[38595]=0.0;g[38599]=0.0;g[38603]=1.0;oO(154040|0,0|0,216|0);c[38510]=c[332];c[38511]=c[334];c[38512]=135744;c[38513]=3;c[38515]=134920;c[38516]=4;c[38542]=135232;oO(153608|0,0|0,216|0);c[38402]=c[336];c[38403]=c[338];c[38404]=135744;c[38405]=3;c[38407]=134936;c[38408]=2;c[38410]=134920;c[38411]=4;c[38434]=135232;oO(153824|0,0|0,216|0);c[38456]=c[328];c[38457]=c[330];c[38458]=135744;c[38459]=3;c[38461]=135368;c[38462]=3;c[38488]=135232;c[38490]=135128;c[38492]=135e3;c[38494]=134968;c[38568]=139792;c[38569]=0;c[38570]=0;c[38571]=1024;c[38569]=oA(0,1024)|0;c[38568]=139632;bk(138,154272,t|0)|0;c[38572]=139792;c[38573]=0;c[38574]=0;c[38575]=1024;c[38573]=oA(0,1024)|0;c[38572]=139656;bk(98,154288,t|0)|0;return}function ex(a,b){a=a|0;b=b|0;var c=0.0,d=0.0;el();en(-1.0,0.0,0.0);el();c=+(a|0);d=+Y(c*.004)*20.0;ey(d);em();el();ep(-1.0,1.0,1.0);en(-2.0,0.0,0.0);ey(d);em();el();en(1.0,0.0,0.0);d=+Z(c*.003);eo(d*15.0,0.0,0.0,1.0);en(-1.0,0.0,0.0);ez();eo(d*-5.0,0.0,0.0,1.0);eA(b);em();em();return}function ey(b){b=+b;var d=0;eo(90.0,1.0,0.0,0.0);en(1.0,0.0,-.20000000298023224);eo(b,0.0,1.0,0.0);en(-1.0,0.0,.20000000298023224);en(.10000000149011612,0.0,0.0);en(0.0,-.05000000074505806,0.0);eo(-5.0,1.0,0.0,0.0);ek(1.0,1.0,1.0,1.0);ee(c[8]|0,c[9]|0);d=(a[144584]&1)==0;ek(d?.4830000102519989:.18199999630451202,d?.4830000102519989:.46700000762939453,d?.4830000102519989:.800000011920929,1.0);ee(c[6]|0,c[7]|0);d=(a[144584]&1)==0;ek(d?.6086666584014893:.3610000014305115,d?.6086666584014893:.800000011920929,d?.6086666584014893:.6650000214576721,1.0);ee(c[4]|0,c[5]|0);d=(a[144584]&1)==0;ek(d?.38466668128967285:.125,d?.38466668128967285:.2290000021457672,d?.38466668128967285:.800000011920929,1.0);ee(c[2]|0,c[3]|0);return}function ez(){var b=0;en(1.0,0.0,0.0);ek(0.0,0.0,0.0,1.0);ee(c[326]|0,c[327]|0);b=(a[144584]&1)==0;ek(b?.6313333511352539:.4650000035762787,b?.6313333511352539:.6290000081062317,b?.6313333511352539:.800000011920929,1.0);ee(c[324]|0,c[325]|0);ek(.800000011920929,.800000011920929,.800000011920929,1.0);ee(c[322]|0,c[323]|0);ek(1.0,1.0,1.0,1.0);ee(c[320]|0,c[321]|0);return}function eA(b){b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0;d=i;i=i+48|0;e=d|0;f=d+8|0;h=d+16|0;j=d+24|0;k=d+32|0;l=d+40|0;en(0.0,-2.799999952316284,0.0);el();ep(.8999999761581421,.8999999761581421,.30000001192092896);el();ep(.8999999761581421,.8999999761581421,1.0);eI(4,j,k,l);m=+g[j>>2]*.1;g[j>>2]=m;n=+g[k>>2]*.1;g[k>>2]=n;o=+g[l>>2]*.1;g[l>>2]=o;if((a[144584]&1)==0){p=(m+n+o)/3.0;q=p;r=p;s=p}else{q=m;r=o;s=n}ek(q,s,r,1.0);ee(c[340]|0,c[341]|0);em();eI(14,e,f,h);r=+g[e>>2]*.1;g[e>>2]=r;s=+g[f>>2]*.1;g[f>>2]=s;q=+g[h>>2]*.1;g[h>>2]=q;if((a[144584]&1)==0){n=(r+s+q)/3.0;t=n;u=n;v=n}else{t=r;u=q;v=s}ek(t,v,u,1.0);ee(c[342]|0,c[343]|0);ek(1.0,1.0,1.0,1.0);ep(.6000000238418579,.6000000238418579,1.0);en(1.0499999523162842,-.2800000011920929,.05000000074505806);eB(b);em();i=d;return}function eB(a){a=a|0;var b=0;eo(90.0,1.0,0.0,0.0);b=a;while(1){switch((b|0)%10|0|0){case 2:{ee(c[314]|0,c[315]|0);break};case 0:{ee(c[318]|0,c[319]|0);break};case 8:{ee(c[302]|0,c[303]|0);break};case 5:{ee(c[308]|0,c[309]|0);break};case 3:{ee(c[312]|0,c[313]|0);break};case 4:{ee(c[310]|0,c[311]|0);break};case 7:{ee(c[304]|0,c[305]|0);break};case 1:{ee(c[316]|0,c[317]|0);break};case 9:{ee(c[300]|0,c[301]|0);break};case 6:{ee(c[306]|0,c[307]|0);break};default:{}}en(-.4000000059604645,0.0,0.0);if((b+9|0)>>>0>18>>>0){b=(b|0)/10|0}else{break}}return}function eC(){eq(-3.0,1.0,3.0);er(1376,130752);return}function eD(a){a=+a;var b=0.0,d=0.0,e=0.0,f=0.0,g=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0,B=0;el();eo(-90.0,1.0,0.0,0.0);el();en(.44999998807907104,0.0,0.0);b=a*.2;a=+a8(+(b+-6.0),+360.0);if(a>180.0){d=a+-360.0}else{d=a}a=+V(+d);if(a<180.0){e=+X(+(a/180.0),+5.0);f=d*e+(1.0-e)*30.0}else{f=d}eo(f,1.0,.6000000238418579,.20000000298023224);ee(c[274]|0,c[275]|0);em();el();en(.8999999761581421,0.0,0.0);f=+a8(+(b+-12.0),+360.0);if(f>180.0){g=f+-360.0}else{g=f}f=+V(+g);if(f<180.0){d=+X(+(f/180.0),+5.0);h=g*d+(1.0-d)*30.0}else{h=g}eo(h,1.0,.6000000238418579,.20000000298023224);ee(c[272]|0,c[273]|0);em();el();en(1.350000023841858,0.0,0.0);h=+a8(+(b+-18.0),+360.0);if(h>180.0){i=h+-360.0}else{i=h}h=+V(+i);if(h<180.0){g=+X(+(h/180.0),+5.0);j=i*g+(1.0-g)*30.0}else{j=i}eo(j,1.0,.6000000238418579,.20000000298023224);ee(c[266]|0,c[267]|0);em();el();en(1.7999999523162842,0.0,0.0);en(-.10000000149011612,0.0,0.0);j=+a8(+(b+-24.0),+360.0);if(j>180.0){k=j+-360.0}else{k=j}j=+V(+k);if(j<180.0){i=+X(+(j/180.0),+5.0);l=k*i+(1.0-i)*30.0}else{l=k}eo(l,1.0,.6000000238418579,.20000000298023224);ee(c[268]|0,c[269]|0);em();el();en(2.25,0.0,0.0);en(-.10000000149011612,0.0,0.0);l=+a8(+(b+-30.0),+360.0);if(l>180.0){m=l+-360.0}else{m=l}l=+V(+m);if(l<180.0){k=+X(+(l/180.0),+5.0);n=m*k+(1.0-k)*30.0}else{n=m}eo(n,1.0,.6000000238418579,.20000000298023224);ee(c[272]|0,c[273]|0);em();en(-1.7999999523162842,2.0,.5);el();en(2.700000047683716,0.0,0.0);en(-.10000000149011612,0.0,0.0);en(-.05000000074505806,0.0,0.0);n=+a8(+(b+-36.0),+360.0);if(n>180.0){o=n+-360.0}else{o=n}n=+V(+o);if(n<180.0){m=+X(+(n/180.0),+5.0);p=o*m+(1.0-m)*30.0}else{p=o}eo(p,1.0,.6000000238418579,.20000000298023224);ee(c[270]|0,c[271]|0);em();el();en(3.1500000953674316,0.0,0.0);en(-.10000000149011612,0.0,0.0);p=+a8(+(b+-42.0),+360.0);if(p>180.0){q=p+-360.0}else{q=p}p=+V(+q);if(p<180.0){o=+X(+(p/180.0),+5.0);r=q*o+(1.0-o)*30.0}else{r=q}eo(r,1.0,.6000000238418579,.20000000298023224);ee(c[272]|0,c[273]|0);em();el();en(3.5999999046325684,0.0,0.0);en(-.10000000149011612,0.0,0.0);r=+a8(+(b+-48.0),+360.0);if(r>180.0){s=r+-360.0}else{s=r}r=+V(+s);if(r<180.0){q=+X(+(r/180.0),+5.0);t=s*q+(1.0-q)*30.0}else{t=s}eo(t,1.0,.6000000238418579,.20000000298023224);ee(c[266]|0,c[267]|0);em();el();en(4.050000190734863,0.0,0.0);en(-.10000000149011612,0.0,0.0);t=+a8(+(b+-54.0),+360.0);if(t>180.0){u=t+-360.0}else{u=t}t=+V(+u);if(t<180.0){s=+X(+(t/180.0),+5.0);v=u*s+(1.0-s)*30.0}else{v=u}eo(v,1.0,.6000000238418579,.20000000298023224);ee(c[272]|0,c[273]|0);em();el();en(4.5,0.0,0.0);en(-.10000000149011612,0.0,0.0);v=+a8(+(b+-60.0),+360.0);if(v>180.0){w=v+-360.0}else{w=v}v=+V(+w);if(v<180.0){u=+X(+(v/180.0),+5.0);x=w*u+(1.0-u)*30.0}else{x=w}eo(x,1.0,.6000000238418579,.20000000298023224);ee(c[266]|0,c[267]|0);em();el();en(4.949999809265137,0.0,0.0);en(-.10000000149011612,0.0,0.0);x=+a8(+(b+-66.0),+360.0);if(x>180.0){y=x+-360.0}else{y=x}x=+V(+y);if(x>=180.0){z=y;eo(z,1.0,.6000000238418579,.20000000298023224);A=c[272]|0;B=c[273]|0;ee(A,B);em();em();return}b=+X(+(x/180.0),+5.0);z=y*b+(1.0-b)*30.0;eo(z,1.0,.6000000238418579,.20000000298023224);A=c[272]|0;B=c[273]|0;ee(A,B);em();em();return}function eE(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;e=b+8|0;c[e>>2]=0;f=oQ(d|0)|0;g=f<<3;c[b>>2]=g;c[b+4>>2]=8;b=1;while(1){if((b|0)<(g|0)){b=b<<1}else{h=1;break}}while(1){if((h|0)<8){h=h<<1}else{break}}g=ag(h,b)|0;i=oE((g|0)>-1?g:-1)|0;oO(i|0,0,g|0);if((f|0)>0){g=0;j=0;while(1){k=a[d+g|0]|0;l=0;do{m=a[40+(k<<3)+l|0]|0;n=(ag(l,b)|0)+j|0;if((m&128|0)!=0){a[i+n|0]=-1}if((m&64|0)!=0){a[i+(n+1)|0]=-1}if((m&32|0)!=0){a[i+(n+2)|0]=-1}if((m&16|0)!=0){a[i+(n+3)|0]=-1}if((m&8|0)!=0){a[i+(n+4)|0]=-1}if((m&4|0)!=0){a[i+(n+5)|0]=-1}if((m&2|0)!=0){a[i+(n+6)|0]=-1}if((m&1|0)!=0){a[i+(n+7)|0]=-1}l=l+1|0;}while((l|0)<8);l=g+1|0;if((l|0)<(f|0)){g=l;j=j+8|0}else{break}}}j=oD(4)|0;d5(j,i,b,h);c[e>>2]=j;if((i|0)==0){return}oG(i);return}function eF(a){a=a|0;var b=0;b=c[a+8>>2]|0;if((b|0)==0){return}d6(b);oF(b);return}function eG(a){a=a|0;ec(c[a+8>>2]|0);return}function eH(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;c[f>>2]=0;c[e>>2]=0;c[d>>2]=0;switch(b|0){case 1:{c[f>>2]=240;c[e>>2]=240;c[d>>2]=240;break};case 3:{c[d>>2]=138;c[e>>2]=226;c[f>>2]=52;break};case 4:{c[d>>2]=114;c[e>>2]=159;c[f>>2]=207;break};case 5:{c[d>>2]=19;c[e>>2]=178;c[f>>2]=184;break};case 6:{c[d>>2]=164;c[e>>2]=29;c[f>>2]=169;break};case 7:{c[d>>2]=111;c[e>>2]=222;c[f>>2]=139;break};case 8:{c[d>>2]=255;c[e>>2]=77;c[f>>2]=18;break};case 9:{c[d>>2]=132;c[e>>2]=141;c[f>>2]=255;break};case 10:{c[d>>2]=234;c[e>>2]=20;c[f>>2]=121;break};case 11:{c[d>>2]=119;c[e>>2]=17;c[f>>2]=17;break};case 12:{c[d>>2]=255;c[e>>2]=111;c[f>>2]=71;break};case 14:case 13:{c[f>>2]=64;c[e>>2]=64;c[d>>2]=64;break};case 2:{c[d>>2]=239;c[e>>2]=41;c[f>>2]=41;break};default:{}}if((a[144584]&1)!=0){return}b=((c[e>>2]|0)+(c[d>>2]|0)+(c[f>>2]|0)|0)/3|0;c[f>>2]=b;c[e>>2]=b;c[d>>2]=b;return}function eI(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0;f=i;i=i+24|0;h=f|0;j=f+8|0;k=f+16|0;eH(a,h,j,k);g[b>>2]=+(c[h>>2]|0)/255.0;g[d>>2]=+(c[j>>2]|0)/255.0;g[e>>2]=+(c[k>>2]|0)/255.0;i=f;return}function eJ(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e8(a|0);oO(a+20|0,0,57);c[a+80>>2]=fn()|0;d=a+96|0;oO(a+84|0,0,24);e=oD(8)|0;e9(e,a);eK(a,e);cx(cY(0)|0);if((b|0)==0){f=b9(fo()|0)|0}else{f=b9(b|0)|0}c[d>>2]=f;fp(f);c[a+100>>2]=fq(c[d>>2]|0,135896)|0;f=fq(c[d>>2]|0,135688)|0;c[a+104>>2]=f;fv(f,a+8|0,a+16|0);return}function eK(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;d=a+20|0;e=a+40|0;do{if((c[e>>2]|0)!=0){if((c3[c[(c[b>>2]|0)+8>>2]&255](b)|0)==2){break}f=a+88|0;g=c[f>>2]|0;if((g|0)!=0){oF(g)}g=oD(20)|0;h=(c[e>>2]|0)-1+(c[a+36>>2]|0)|0;fj(g,a,c[(c[(c[a+24>>2]|0)+(h>>>10<<2)>>2]|0)+((h&1023)<<2)>>2]|0,b,1);c[f>>2]=g}}while(0);dh[c[(c[b>>2]|0)+24>>2]&31](b,c[a+68>>2]|0,c[a+72>>2]|0);g=a+28|0;f=c[g>>2]|0;h=a+24|0;i=c[h>>2]|0;if((f|0)==(i|0)){j=0}else{j=(f-i<<8)-1|0}k=a+36|0;a=c[k>>2]|0;l=c[e>>2]|0;if((j|0)==(l+a|0)){eU(d);m=c[e>>2]|0;n=c[k>>2]|0;o=c[h>>2]|0;p=c[g>>2]|0}else{m=l;n=a;o=i;p=f}f=m+n|0;if((p|0)==(o|0)){q=m;r=q+1|0;c[e>>2]=r;s=b;t=c[s>>2]|0;u=t+32|0;v=c[u>>2]|0;c1[v&127](b,14);return}p=(c[o+(f>>>10<<2)>>2]|0)+((f&1023)<<2)|0;if((p|0)==0){q=m;r=q+1|0;c[e>>2]=r;s=b;t=c[s>>2]|0;u=t+32|0;v=c[u>>2]|0;c1[v&127](b,14);return}c[p>>2]=b;q=c[e>>2]|0;r=q+1|0;c[e>>2]=r;s=b;t=c[s>>2]|0;u=t+32|0;v=c[u>>2]|0;c1[v&127](b,14);return}function eL(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;c[a+68>>2]=b;c[a+72>>2]=d;e=(c[a+40>>2]|0)-1+(c[a+36>>2]|0)|0;f=c[(c[(c[a+24>>2]|0)+(e>>>10<<2)>>2]|0)+((e&1023)<<2)>>2]|0;dh[c[(c[f>>2]|0)+24>>2]&31](f,b,d);return}function eM(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;switch(b|0){case 8:{d=oD(176)|0;fs(d,a);eK(a,d);break};case 10:{d=oD(176)|0;fs(d,a);eK(a,d);d=c[a+40>>2]|0;if((d|0)==0){e=0}else{f=d-1+(c[a+36>>2]|0)|0;e=c[(c[(c[a+24>>2]|0)+(f>>>10<<2)>>2]|0)+((f&1023)<<2)>>2]|0}fu(e,c[a+100>>2]|0);break};case 6:{eQ(a);e=oD(24)|0;e5(e,a);eK(a,e);break};case 11:{e=oD(56)|0;f=c[a+40>>2]|0;if((f|0)==0){g=0}else{d=f-1+(c[a+36>>2]|0)|0;g=c[(c[(c[a+24>>2]|0)+(d>>>10<<2)>>2]|0)+((d&1023)<<2)>>2]|0}fY(e,a,g,134864,134352,13,133632,12);eK(a,e);break};case 13:{eQ(a);break};case 12:{eQ(a);eQ(a);break};case 7:{e=oD(28)|0;e0(e,a);eK(a,e);break};case 9:{e=oD(24)|0;eY(e,a);eK(a,e);break};default:{}}e=(c[a+40>>2]|0)-1+(c[a+36>>2]|0)|0;g=c[(c[(c[a+24>>2]|0)+(e>>>10<<2)>>2]|0)+((e&1023)<<2)>>2]|0;c1[c[(c[g>>2]|0)+32>>2]&127](g,b);return}function eN(a){a=a|0;return c[a+92>>2]|0}function eO(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;e=b+88|0;f=c[e>>2]|0;do{if((f|0)!=0){if(!(fl(f)|0)){g=572;break}h=c[e>>2]|0;if((h|0)!=0){oF(h)}c[e>>2]=0}}while(0);while(1){if((g|0)==572){g=0;if((c[e>>2]|0)!=0){break}}f=b+64|0;h=c[f>>2]|0;if((h|0)==0){break}i=b+60|0;j=h-1+(c[i>>2]|0)|0;k=b+48|0;l=c[k>>2]|0;m=c[(c[l+(j>>>10<<2)>>2]|0)+((j&1023)<<2)>>2]|0;if((m|0)==0){n=h;o=l}else{c0[c[(c[m>>2]|0)+4>>2]&511](m);n=c[f>>2]|0;o=c[k>>2]|0}c[f>>2]=n-1;f=b+52|0;k=c[f>>2]|0;if((k|0)==(o|0)){p=0}else{p=(k-o<<8)-1|0}if((p+(1-n)-(c[i>>2]|0)|0)>>>0<=2047>>>0){g=572;continue}oF(c[k-4>>2]|0);c[f>>2]=(c[f>>2]|0)-4;g=572}do{if((a[b+76|0]&1)==0){g=fn()|0;n=b+80|0;p=g-(c[n>>2]|0)|0;o=b+92|0;c[o>>2]=(c[o>>2]|0)+p;c[n>>2]=g;g=b+84|0;n=(c[g>>2]|0)+p|0;c[g>>2]=n;p=c[36116]|0;if((n|0)<=(p|0)){q=n;r=p;break}p=b+40|0;n=b+36|0;o=b+24|0;while(1){f=c[e>>2]|0;if((f|0)==0){k=(c[p>>2]|0)-1+(c[n>>2]|0)|0;i=c[(c[(c[o>>2]|0)+(k>>>10<<2)>>2]|0)+((k&1023)<<2)>>2]|0;c0[c[(c[i>>2]|0)+28>>2]&511](i)}else{fk(f)}f=(c[g>>2]|0)-(c[36116]|0)|0;c[g>>2]=f;i=c[36116]|0;if((f|0)<=(i|0)){q=f;r=i;break}}}else{q=c[b+84>>2]|0;r=c[36116]|0}}while(0);g=d;c0[c[c[g>>2]>>2]&511](d);dh[c[(c[d>>2]|0)+4>>2]&31](d,4,5);o=c[e>>2]|0;if((o|0)==0){e=(c[b+40>>2]|0)-1+(c[b+36>>2]|0)|0;n=c[(c[(c[b+24>>2]|0)+(e>>>10<<2)>>2]|0)+((e&1023)<<2)>>2]|0;c1[c[(c[n>>2]|0)+20>>2]&127](n,d);s=c[g>>2]|0;t=s+56|0;u=c[t>>2]|0;c0[u&511](d);return}else{fm(o,d,+(q|0)/+(r|0));s=c[g>>2]|0;t=s+56|0;u=c[t>>2]|0;c0[u&511](d);return}}function eP(a){a=a|0;return(c[a+40>>2]|0)==0|0}function eQ(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;b=a+40|0;d=a+36|0;e=(c[b>>2]|0)-1+(c[d>>2]|0)|0;f=a+24|0;g=c[(c[(c[f>>2]|0)+(e>>>10<<2)>>2]|0)+((e&1023)<<2)>>2]|0;c1[c[(c[g>>2]|0)+32>>2]&127](g,15);g=(c[b>>2]|0)-1+(c[d>>2]|0)|0;e=c[(c[(c[f>>2]|0)+(g>>>10<<2)>>2]|0)+((g&1023)<<2)>>2]|0;g=a+52|0;h=c[g>>2]|0;i=a+48|0;j=c[i>>2]|0;if((h|0)==(j|0)){k=0}else{k=(h-j<<8)-1|0}l=a+60|0;m=c[l>>2]|0;n=a+64|0;o=c[n>>2]|0;if((k|0)==(o+m|0)){eU(a+44|0);p=c[n>>2]|0;q=c[l>>2]|0;r=c[i>>2]|0;s=c[g>>2]|0}else{p=o;q=m;r=j;s=h}h=p+q|0;do{if((s|0)==(r|0)){t=p}else{q=(c[r+(h>>>10<<2)>>2]|0)+((h&1023)<<2)|0;if((q|0)==0){t=p;break}c[q>>2]=e;t=c[n>>2]|0}}while(0);c[n>>2]=t+1;t=c[b>>2]|0;c[b>>2]=t-1;n=a+28|0;p=c[n>>2]|0;h=c[f>>2]|0;if((p|0)==(h|0)){u=0}else{u=(p-h<<8)-1|0}if((u+(1-t)-(c[d>>2]|0)|0)>>>0>2047>>>0){oF(c[p-4>>2]|0);c[n>>2]=(c[n>>2]|0)-4}if((c3[c[(c[e>>2]|0)+8>>2]&255](e)|0)!=2){n=a+88|0;p=c[n>>2]|0;if((p|0)!=0){oF(p)}p=oD(20)|0;t=c[b>>2]|0;if((t|0)==0){v=0}else{u=t-1+(c[d>>2]|0)|0;v=c[(c[(c[f>>2]|0)+(u>>>10<<2)>>2]|0)+((u&1023)<<2)>>2]|0}fj(p,a,e,v,0);c[n>>2]=p}p=(c[b>>2]|0)-1+(c[d>>2]|0)|0;n=c[(c[(c[f>>2]|0)+(p>>>10<<2)>>2]|0)+((p&1023)<<2)>>2]|0;dh[c[(c[n>>2]|0)+24>>2]&31](n,c[a+68>>2]|0,c[a+72>>2]|0);a=(c[b>>2]|0)-1+(c[d>>2]|0)|0;d=c[(c[(c[f>>2]|0)+(a>>>10<<2)>>2]|0)+((a&1023)<<2)>>2]|0;c1[c[(c[d>>2]|0)+32>>2]&127](d,16);return}function eR(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=(c[a+40>>2]|0)-1+(c[a+36>>2]|0)|0;g=c[(c[(c[a+24>>2]|0)+(f>>>10<<2)>>2]|0)+((f&1023)<<2)>>2]|0;f=c[(c[g>>2]|0)+12>>2]|0;if(b){dk[f&63](g,0,d,e);return}else{dk[f&63](g,2,d,e);return}}function eS(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=(c[a+40>>2]|0)-1+(c[a+36>>2]|0)|0;f=c[(c[(c[a+24>>2]|0)+(e>>>10<<2)>>2]|0)+((e&1023)<<2)>>2]|0;dk[c[(c[f>>2]|0)+12>>2]&63](f,1,b,d);return}function eT(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=(c[a+40>>2]|0)-1+(c[a+36>>2]|0)|0;g=c[(c[(c[a+24>>2]|0)+(f>>>10<<2)>>2]|0)+((f&1023)<<2)>>2]|0;dk[c[(c[g>>2]|0)+16>>2]&63](g,b,d,e);return}function eU(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0;b=i;i=i+32|0;d=b|0;e=b+8|0;f=a+16|0;g=c[f>>2]|0;if(g>>>0>1023>>>0){c[f>>2]=g-1024;g=a+4|0;f=c[g>>2]|0;h=c[f>>2]|0;j=f+4|0;c[g>>2]=j;k=a+8|0;l=c[k>>2]|0;m=a+12|0;do{if((l|0)==(c[m>>2]|0)){n=a|0;o=c[n>>2]|0;if(j>>>0>o>>>0){p=j;q=((p-o>>2)+1|0)/-2|0;r=q+1|0;s=l-p|0;oP(f+(r<<2)|0,j|0,s|0);p=f+(r+(s>>2)<<2)|0;c[k>>2]=p;c[g>>2]=(c[g>>2]|0)+(q<<2);t=p;break}p=l-o>>1;q=(p|0)==0?1:p;p=oD(q<<2)|0;s=p+(q>>>2<<2)|0;r=p+(q<<2)|0;if((j|0)==(l|0)){u=s;v=o}else{o=j;q=s;do{if((q|0)==0){w=0}else{c[q>>2]=c[o>>2];w=q}q=w+4|0;o=o+4|0;}while((o|0)!=(l|0));u=q;v=c[n>>2]|0}c[n>>2]=p;c[g>>2]=s;c[k>>2]=u;c[m>>2]=r;if((v|0)==0){t=u;break}oF(v);t=c[k>>2]|0}else{t=l}}while(0);if((t|0)==0){x=0}else{c[t>>2]=h;x=c[k>>2]|0}c[k>>2]=x+4;i=b;return}x=a|0;k=a+8|0;h=c[k>>2]|0;t=a+4|0;l=h-(c[t>>2]|0)>>2;v=a+12|0;u=v|0;m=c[u>>2]|0;g=a|0;a=m-(c[g>>2]|0)|0;if(l>>>0>=a>>2>>>0){w=a>>1;a=(w|0)==0?1:w;w=e+12|0;c[e+16>>2]=v;v=oD(a<<2)|0;j=v;f=e|0;c[f>>2]=j;o=j+(l<<2)|0;y=e+8|0;c[y>>2]=o;z=e+4|0;c[z>>2]=o;c[w>>2]=j+(a<<2);A=oD(4096)|0;do{if((l|0)==(a|0)){B=o-v|0;if(o>>>0>j>>>0){C=j+(l+(((B>>2)+1|0)/-2|0)<<2)|0;c[y>>2]=C;c[z>>2]=C;D=C;break}C=B>>1;B=(C|0)==0?1:C;C=oD(B<<2)|0;E=C+(B>>>2<<2)|0;c[f>>2]=C;c[z>>2]=E;c[y>>2]=E;c[w>>2]=C+(B<<2);if((v|0)==0){D=E;break}oF(v);D=E}else{D=o}}while(0);if((D|0)==0){F=0}else{c[D>>2]=A;F=c[y>>2]|0}c[y>>2]=F+4;F=c[k>>2]|0;while(1){if((F|0)==(c[t>>2]|0)){break}A=F-4|0;eW(e,A);F=A}e=c[g>>2]|0;c[g>>2]=c[f>>2];c[f>>2]=e;c[t>>2]=c[z>>2];c[z>>2]=F;z=c[k>>2]|0;c[k>>2]=c[y>>2];c[y>>2]=z;f=c[u>>2]|0;c[u>>2]=c[w>>2];c[w>>2]=f;if((F|0)!=(z|0)){c[y>>2]=z+(~((z-4+(-F|0)|0)>>>2)<<2)}if((e|0)==0){i=b;return}oF(e);i=b;return}e=oD(4096)|0;if((m|0)!=(h|0)){if((h|0)==0){G=0}else{c[h>>2]=e;G=c[k>>2]|0}c[k>>2]=G+4;i=b;return}c[d>>2]=e;eV(x,d);d=c[t>>2]|0;x=c[d>>2]|0;e=d+4|0;c[t>>2]=e;G=c[k>>2]|0;do{if((G|0)==(c[u>>2]|0)){h=c[g>>2]|0;if(e>>>0>h>>>0){m=e;F=((m-h>>2)+1|0)/-2|0;z=F+1|0;y=G-m|0;oP(d+(z<<2)|0,e|0,y|0);m=d+(z+(y>>2)<<2)|0;c[k>>2]=m;c[t>>2]=(c[t>>2]|0)+(F<<2);H=m;break}m=G-h>>1;F=(m|0)==0?1:m;m=oD(F<<2)|0;y=m+(F>>>2<<2)|0;z=m+(F<<2)|0;if((e|0)==(G|0)){I=y;J=h}else{h=e;F=y;do{if((F|0)==0){K=0}else{c[F>>2]=c[h>>2];K=F}F=K+4|0;h=h+4|0;}while((h|0)!=(G|0));I=F;J=c[g>>2]|0}c[g>>2]=m;c[t>>2]=y;c[k>>2]=I;c[u>>2]=z;if((J|0)==0){H=I;break}oF(J);H=c[k>>2]|0}else{H=G}}while(0);if((H|0)==0){L=0}else{c[H>>2]=x;L=c[k>>2]|0}c[k>>2]=L+4;i=b;return}function eV(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;d=a+4|0;e=c[d>>2]|0;f=a|0;do{if((e|0)==(c[f>>2]|0)){g=a+8|0;h=c[g>>2]|0;i=a+12|0;j=c[i>>2]|0;k=j;if(h>>>0<j>>>0){j=h;l=((k-j>>2)+1|0)/2|0;m=j-e|0;j=h+(l-(m>>2)<<2)|0;oP(j|0,e|0,m|0);c[d>>2]=j;c[g>>2]=(c[g>>2]|0)+(l<<2);n=j;break}j=k-e>>1;k=(j|0)==0?1:j;j=oD(k<<2)|0;l=j+((k+3|0)>>>2<<2)|0;m=j+(k<<2)|0;if((e|0)==(h|0)){o=l;p=e}else{k=e;q=l;do{if((q|0)==0){r=0}else{c[q>>2]=c[k>>2];r=q}q=r+4|0;k=k+4|0;}while((k|0)!=(h|0));o=q;p=c[f>>2]|0}c[f>>2]=j;c[d>>2]=l;c[g>>2]=o;c[i>>2]=m;if((p|0)==0){n=l;break}oF(p);n=c[d>>2]|0}else{n=e}}while(0);e=n-4|0;if((e|0)==0){s=n;t=s-4|0;c[d>>2]=t;return}c[e>>2]=c[b>>2];s=c[d>>2]|0;t=s-4|0;c[d>>2]=t;return}function eW(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;d=a+4|0;e=c[d>>2]|0;f=a|0;do{if((e|0)==(c[f>>2]|0)){g=a+8|0;h=c[g>>2]|0;i=a+12|0;j=c[i>>2]|0;k=j;if(h>>>0<j>>>0){j=h;l=((k-j>>2)+1|0)/2|0;m=j-e|0;j=h+(l-(m>>2)<<2)|0;oP(j|0,e|0,m|0);c[d>>2]=j;c[g>>2]=(c[g>>2]|0)+(l<<2);n=j;break}j=k-e>>1;k=(j|0)==0?1:j;j=oD(k<<2)|0;l=j+((k+3|0)>>>2<<2)|0;m=j+(k<<2)|0;if((e|0)==(h|0)){o=l;p=e}else{k=e;q=l;do{if((q|0)==0){r=0}else{c[q>>2]=c[k>>2];r=q}q=r+4|0;k=k+4|0;}while((k|0)!=(h|0));o=q;p=c[f>>2]|0}c[f>>2]=j;c[d>>2]=l;c[g>>2]=o;c[i>>2]=m;if((p|0)==0){n=l;break}oF(p);n=c[d>>2]|0}else{n=e}}while(0);e=n-4|0;if((e|0)==0){s=n;t=s-4|0;c[d>>2]=t;return}c[e>>2]=c[b>>2];s=c[d>>2]|0;t=s-4|0;c[d>>2]=t;return}function eX(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;b=a+4|0;d=c[b>>2]|0;e=a+16|0;f=c[e>>2]|0;g=d+(f>>>10<<2)|0;h=a+8|0;i=c[h>>2]|0;if((i|0)==(d|0)){j=0;k=0;l=a+20|0}else{m=a+20|0;a=f+(c[m>>2]|0)|0;j=(c[d+(a>>>10<<2)>>2]|0)+((a&1023)<<2)|0;k=(c[g>>2]|0)+((f&1023)<<2)|0;l=m}m=g;g=k;L857:while(1){k=g;do{if((k|0)==(j|0)){break L857}k=k+4|0;}while((k-(c[m>>2]|0)|0)!=4096);k=m+4|0;m=k;g=c[k>>2]|0}c[l>>2]=0;l=i-d>>2;if(l>>>0>2>>>0){i=d;while(1){oF(c[i>>2]|0);d=(c[b>>2]|0)+4|0;c[b>>2]=d;g=(c[h>>2]|0)-d>>2;if(g>>>0>2>>>0){i=d}else{n=g;break}}}else{n=l}if((n|0)==2){c[e>>2]=1024;return}else if((n|0)==1){c[e>>2]=512;return}else{return}}function eY(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=a|0;f7(d,b);c[a>>2]=139576;b=c[a+4>>2]|0;a=c[b+68>>2]|0;e=~~(+(a|0)*.8);f=(a-e|0)/2|0;a=((c[b+72>>2]|0)-50|0)/5|0;gi(d,c[b+8>>2]|0,f,a,e,50)|0;g=f-20|0;gj(d,135280,g,a-20|0,e,50,0,4)|0;gi(d,c[b+16>>2]|0,f,a+80|0,e,50)|0;gj(d,135608,g,a+60|0,e,50,0,4)|0;return}function eZ(a){a=a|0;f9(a|0);return}function e_(a){a=a|0;f9(a|0);oF(a);return}function e$(a){a=a|0;return 0}function e0(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=a|0;f7(d,b);c[a>>2]=139192;b=a+24|0;c[b>>2]=0;e=c[a+4>>2]|0;a=(c[e+68>>2]|0)-40|0;f=~~(+((c[e+72>>2]|0)-340|0)*.5);gh(d,135208,20,f,a,100,8)|0;gh(d,135576,20,f+120|0,a,100,9)|0;c[b>>2]=gh(d,134856,20,f+240|0,a,100,10)|0;return}function e1(a,b){a=a|0;b=b|0;var d=0,e=0;d=a|0;e=c[a+24>>2]|0;gk(d,e,fr(c[(c[a+4>>2]|0)+100>>2]|0)|0);gg(d,b);return}function e2(a,b){a=a|0;b=b|0;var d=0;gc(a|0,b);d=c[a+4>>2]|0;a=(c[d+68>>2]|0)/2|0;c8[c[(c[b>>2]|0)+44>>2]&31](b,1,134344,a,(c[d+72>>2]|0)-50|0,a,50,1);return}function e3(a){a=a|0;f9(a|0);return}function e4(a){a=a|0;f9(a|0);oF(a);return}function e5(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;d=i;i=i+24|0;e=d|0;f=a|0;f7(f,b);c[a>>2]=139680;b=a+4|0;a=c[b>>2]|0;g=c[a+68>>2]|0;h=~~(+(g|0)*.8);j=(g-h|0)/2|0;g=((c[a+72>>2]|0)-50|0)/5|0;k=a+4|0;gi(f,c[k>>2]|0,j,g,h,50)|0;l=j-20|0;gj(f,135144,l,g-20|0,h,50,0,4)|0;m=a+12|0;gi(f,c[m>>2]|0,j,g+80|0,h,50)|0;gj(f,135528,l,g+60|0,h,50,0,4)|0;h=c[k>>2]|0;k=a+8|0;if((h|0)<=(c[k>>2]|0)){i=d;return}c[k>>2]=h;c[a+16>>2]=c[m>>2];gv(e);gx(e,c[(c[b>>2]|0)+100>>2]|0);gy(e,c[(c[b>>2]|0)+104>>2]|0);m=c[b>>2]|0;gj(f,134824,0,~~(+(c[m+72>>2]|0)*.5),c[m+68>>2]|0,100,1,8)|0;m=c[e>>2]|0;if((m|0)==0){i=d;return}f=e+4|0;e=c[f>>2]|0;if((m|0)!=(e|0)){c[f>>2]=e+(~((e-8+(-m|0)|0)>>>3)<<3)}oF(m);i=d;return}function e6(a){a=a|0;f9(a|0);return}function e7(a){a=a|0;f9(a|0);oF(a);return}function e8(b){b=b|0;a[b|0]=1;a[b+1|0]=1;oO(b+4|0,0,16);return}function e9(a,b){a=a|0;b=b|0;gz(a|0,b);c[a>>2]=139816;return}function fa(a){a=a|0;gB(a|0);oF(a);return}function fb(a){a=a|0;gB(a|0);return}function fc(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;if((b|0)!=2){return}eM(c[a+4>>2]|0,7);return}function fd(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;if(b){return}eM(c[a+4>>2]|0,7);return}function fe(a,b){a=a|0;b=b|0;var d=0,e=0;d=a+4|0;a=c[d>>2]|0;c_[c[(c[b>>2]|0)+40>>2]&15](b,0,~~(+(c[a+72>>2]|0)*.2),c[a+68>>2]|0,100);a=b;e=c[d>>2]|0;c8[c[(c[a>>2]|0)+44>>2]&31](b,1,135008,0,((c[e+72>>2]|0)/2|0)-25|0,c[e+68>>2]|0,50,1);e=c[d>>2]|0;c8[c[(c[a>>2]|0)+44>>2]&31](b,8,135488,10,(c[e+72>>2]|0)-60|0,(c[e+68>>2]|0)-20|0,50,1);return}function ff(a,b,c){a=a|0;b=b|0;c=c|0;return}function fg(a){a=a|0;return}function fh(a,b){a=a|0;b=b|0;return}function fi(a,b){a=a|0;b=+b;return}function fj(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;c[b>>2]=d;a[b+4|0]=g&1;c[b+8>>2]=0;c[b+12>>2]=e;c[b+16>>2]=f;return}function fk(a){a=a|0;var b=0;b=a+8|0;c[b>>2]=(c[b>>2]|0)+1;return}function fl(a){a=a|0;return(c[a+8>>2]|0)>=(c[36120]|0)|0}function fm(b,d,e){b=b|0;d=d|0;e=+e;var f=0.0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;f=1.0-(+(c[b+8>>2]|0)+e)/+(c[36120]|0);e=1.0-(+X(+f,+3.0)*2.0-f*f);g=b+4|0;h=d;i=c[(c[h>>2]|0)+52>>2]|0;j=b|0;k=c[(c[j>>2]|0)+68>>2]|0;if((a[g]&1)==0){dh[i&31](d,~~(e*+(k|0)),0)}else{dh[i&31](d,~~(e*+(-k|0)*2.0),0)}k=b+12|0;i=c[k>>2]|0;c1[c[(c[i>>2]|0)+20>>2]&127](i,d);i=c[k>>2]|0;c$[c[(c[i>>2]|0)+36>>2]&7](i,1.0-e);dh[c[(c[h>>2]|0)+52>>2]&31](d,~~(e*+(c[(c[j>>2]|0)+68>>2]|0)),0);i=c[(c[h>>2]|0)+52>>2]|0;h=c[(c[j>>2]|0)+68>>2]|0;if((a[g]&1)==0){dh[i&31](d,-h<<1,0);l=b+16|0;m=c[l>>2]|0;n=m;o=c[n>>2]|0;p=o+20|0;q=c[p>>2]|0;c1[q&127](m,d);r=c[l>>2]|0;s=r;t=c[s>>2]|0;u=t+36|0;v=c[u>>2]|0;c$[v&7](r,e);return}else{dh[i&31](d,h,0);l=b+16|0;m=c[l>>2]|0;n=m;o=c[n>>2]|0;p=o+20|0;q=c[p>>2]|0;c1[q&127](m,d);r=c[l>>2]|0;s=r;t=c[s>>2]|0;u=t+36|0;v=c[u>>2]|0;c$[v&7](r,e);return}}function fn(){var b=0,d=0,e=0;b=i;i=i+8|0;d=b|0;if(!(a[136464]|0)){cg(148096,0)|0;a[136464]=1}if((cg(d|0,0)|0)!=0){e=0;i=b;return e|0}e=(((c[d+4>>2]|0)-(c[37025]|0)|0)/1e3|0)+(((c[d>>2]|0)-(c[37024]|0)|0)*1e3|0)|0;i=b;return e|0}function fo(){var a=0;oR(148104,ce(134984)|0)|0;a=148104+(oQ(148104)|0)|0;oN(a|0,135448,21)|0;return 148104}function fp(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+80|0;e=d|0;if((cL(b|0,e|0)|0)==0){if((c[e+12>>2]&61440|0)==16384){i=d;return}else{bt(1)}}f=b9(b|0)|0;L963:do{if((a[b]|0)!=0){g=e+12|0;h=0;L965:while(1){do{if((h|0)>0){j=f+h|0;if((a[j]|0)!=47){break}a[j]=0;if((cL(f|0,e|0)|0)==0){if((c[g>>2]&61440|0)!=16384){k=838;break L965}}else{if((b5(f|0,448)|0)!=0){k=840;break L965}}a[j]=47}}while(0);h=h+1|0;if(h>>>0>=(oQ(b|0)|0)>>>0){break L963}}if((k|0)==838){bt(1)}else if((k|0)==840){bt(1)}}}while(0);oz(f);if((b5(b|0,448)|0)==0){i=d;return}else{bt(1)}}function fq(b,c){b=b|0;c=c|0;var d=0,e=0;d=oQ(b|0)|0;e=oy(d+2+(oQ(c|0)|0)|0)|0;oR(e|0,b|0)|0;b=e+(oQ(e|0)|0)|0;C=47;a[b]=C&255;C=C>>8;a[b+1|0]=C&255;oS(e|0,c|0)|0;return e|0}function fr(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+80|0;d=b|0;if((cL(a|0,d|0)|0)!=0){e=0;i=b;return e|0}e=(c[d+12>>2]&61440|0)!=16384;i=b;return e|0}function fs(b,d){b=b|0;d=d|0;var e=0,f=0,h=0;gz(b|0,d);c[b>>2]=139360;g[b+8>>2]=1.0;c[b+12>>2]=-1;c[b+16>>2]=-1;c[b+20>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;c[b+32>>2]=c[36136];g[b+36>>2]=0.0;gs(b+40|0);fV(b+72|0);gC(b+76|0);d=b+96|0;e=ag(c[36150]|0,c[36156]|0)|0;f=aZ(e|0,20)|0;h=oE(K?-1:f)|0;if((e|0)!=0){f=h+(e*20|0)|0;e=h;do{a[e|0]=0;c[e+4>>2]=-1;a[e+8|0]=0;g[e+12>>2]=0.0;c[e+16>>2]=0;e=e+20|0;}while((e|0)!=(f|0))}c[d>>2]=h;c[b+140>>2]=0;oO(b+100|0,0,37);a[b+144|0]=1;a[b+145|0]=0;gv(b+148|0);c[b+172>>2]=0;ft(b,-1);return}function ft(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+8|0;f=e|0;g=b+100|0;h=c[g>>2]|0;if((h|0)!=0){oF(h)}if((d|0)==-1){j=gu(b+40|0)|0}else{j=d}d=oD(20)|0;gn(d,j);c[g>>2]=d;if((a[b+145|0]&1)!=0){i=e;return}d=c[b+28>>2]|0;g=f;h=b+160|0;k=d-(c[h>>2]|0)&255;c[f>>2]=5;a[g+4|0]=j&255;a[g+5|0]=k;k=b+152|0;j=c[k>>2]|0;if((j|0)==(c[b+156>>2]|0)){fP(b+148|0,g)}else{if((j|0)==0){l=0}else{g=j;j=c[f+4>>2]|0;c[g>>2]=c[f>>2];c[g+4>>2]=j;l=c[k>>2]|0}c[k>>2]=l+8}c[h>>2]=d;i=e;return}function fu(b,d){b=b|0;d=d|0;gx(b+148|0,d);c[b+28>>2]=0;a[b+145|0]=1;return}function fv(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;i=i+176|0;g=f|0;fs(g,0);h=g+148|0;gx(h,b);c[g+28>>2]=0;a[g+145|0]=1;gw(h,g,-1)|0;if((d|0)!=0){c[d>>2]=c[g+76>>2]}if((e|0)==0){fD(g);i=f;return}c[e>>2]=c[g+80>>2];fD(g);i=f;return}function fw(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;f=d;d=i;i=i+8|0;c[d>>2]=c[f>>2];c[d+4>>2]=c[f+4>>2];L1031:do{switch(c[d>>2]|0){case 1:{fA(b,a[d+4|0]|0);break};case 6:{f=c[b+4>>2]|0;if((f|0)==0){break L1031}eM(f,13);break};case 4:{fx(b,0)|0;break};case 5:{ft(b,a[d+4|0]|0);break};case 3:{fy(b);break};case 2:{fz(b,a[d+4|0]|0);break};default:{bt(1)}}}while(0);i=e;return}function fx(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;e=i;i=i+8|0;f=e|0;do{if(!d){if((a[b+145|0]&1)!=0){break}g=c[b+28>>2]|0;h=f;j=b+160|0;k=g-(c[j>>2]|0)&255;c[f>>2]=4;a[h+4|0]=0;a[h+5|0]=k;k=b+152|0;l=c[k>>2]|0;if((l|0)==(c[b+156>>2]|0)){fP(b+148|0,h)}else{if((l|0)==0){m=0}else{h=l;l=c[f+4>>2]|0;c[h>>2]=c[f>>2];c[h+4>>2]=l;m=c[k>>2]|0}c[k>>2]=m+8}c[j>>2]=g}}while(0);m=b+100|0;gq(c[m>>2]|0,1);f=c[m>>2]|0;if(!(fE(b,f)|0)){n=0;i=e;return n|0}gq(f,-1);fF(b);n=1;i=e;return n|0}function fy(b){b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0.0,o=0,p=0,q=0,r=0,s=0;d=i;i=i+8|0;e=d|0;if((a[b+145|0]&1)==0){f=c[b+28>>2]|0;h=e;j=b+160|0;k=f-(c[j>>2]|0)&255;c[e>>2]=3;a[h+4|0]=0;a[h+5|0]=k;k=b+152|0;l=c[k>>2]|0;if((l|0)==(c[b+156>>2]|0)){fP(b+148|0,h)}else{if((l|0)==0){m=0}else{h=l;l=c[e+4>>2]|0;c[h>>2]=c[e>>2];c[h+4>>2]=l;m=c[k>>2]|0}c[k>>2]=m+8}c[j>>2]=f}f=b+100|0;j=b+96|0;m=0;while(1){if((m|0)>=4){if((ag(c[36150]|0,c[36156]|0)|0)>0){k=0;do{l=c[j>>2]|0;h=l+(k*20|0)+8|0;do{if((a[h]&1)!=0){e=l+(k*20|0)+12|0;n=+g[e>>2]*.85;g[e>>2]=n;if(n>=.1){break}a[h]=0}}while(0);k=k+1|0;}while((k|0)<(ag(c[36150]|0,c[36156]|0)|0))}gq(c[f>>2]|0,1);o=c[f>>2]|0;if(fE(b,o)|0){break}else{m=0;continue}}k=c[f>>2]|0;h=(c[k+16>>2]|0)+(c[k+4>>2]|0)|0;l=c[k+8>>2]|0;if((m|0)>0){e=m-1|0;p=c[k+12>>2]|0;q=c[k>>2]|0;r=(c[144840+(q*96|0)+(p*24|0)+(e<<3)+4>>2]|0)+l|0;s=(c[144840+(q*96|0)+(p*24|0)+(e<<3)>>2]|0)+h|0}else{r=l;s=h}do{if((s|0)>=0){h=c[36156]|0;if((h|0)<=(s|0)){break}if(!((r|0)>-1&(c[36150]|0)>(r|0))){break}l=(ag(h,r)|0)+s|0;h=c[j>>2]|0;if((h+(l*20|0)|0)==0){break}a[h+(l*20|0)+8|0]=1;g[h+(l*20|0)+12>>2]=1.0}}while(0);m=m+1|0}gq(o,-1);fF(b);i=d;return}function fz(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;i=i+8|0;f=e|0;g=b+100|0;h=c[g>>2]|0;if((h|0)==0){i=e;return}if((a[b+145|0]&1)==0){j=c[b+28>>2]|0;k=f;l=b+160|0;m=j-(c[l>>2]|0)&255;c[f>>2]=2;a[k+4|0]=d&255;a[k+5|0]=m;m=b+152|0;n=c[m>>2]|0;if((n|0)==(c[b+156>>2]|0)){fP(b+148|0,k)}else{if((n|0)==0){o=0}else{k=n;n=c[f+4>>2]|0;c[k>>2]=c[f>>2];c[k+4>>2]=n;o=c[m>>2]|0}c[m>>2]=o+8}c[l>>2]=j;p=c[g>>2]|0}else{p=h}gr(p,d);p=c[g>>2]|0;g=(c[p+16>>2]|0)+(c[p+4>>2]|0)|0;h=c[p+8>>2]|0;j=p+12|0;l=p|0;o=c[36156]|0;m=c[36150]|0;n=b+96|0;L1105:do{if((g|0)>-1&(g|0)<(o|0)){do{if((g|0)<0){q=969}else{if(!((h|0)>-1&(m|0)>(h|0))){q=969;break}b=(ag(o,h)|0)+g|0;k=(c[n>>2]|0)+(b*20|0)|0;if((k|0)==0){q=969;break}if((a[k|0]&1)==0){q=969}}}while(0);L1111:do{if((q|0)==969){k=c[j>>2]|0;b=c[l>>2]|0;f=(c[144840+(b*96|0)+(k*24|0)>>2]|0)+g|0;r=(c[144840+(b*96|0)+(k*24|0)+4>>2]|0)+h|0;if(!((f|0)>-1&(f|0)<(o|0))){break L1105}do{if((f|0)>=0){if(!((r|0)>-1&(m|0)>(r|0))){break}k=(ag(o,r)|0)+f|0;b=(c[n>>2]|0)+(k*20|0)|0;if((b|0)==0){break}if((a[b|0]&1)!=0){break L1111}}}while(0);f=c[j>>2]|0;r=c[l>>2]|0;b=(c[144840+(r*96|0)+(f*24|0)+8>>2]|0)+g|0;k=(c[144840+(r*96|0)+(f*24|0)+12>>2]|0)+h|0;if(!((b|0)>-1&(b|0)<(o|0))){break L1105}do{if((b|0)>=0){if(!((k|0)>-1&(m|0)>(k|0))){break}f=(ag(o,k)|0)+b|0;r=(c[n>>2]|0)+(f*20|0)|0;if((r|0)==0){break}if((a[r|0]&1)!=0){break L1111}}}while(0);b=c[j>>2]|0;k=c[l>>2]|0;r=(c[144840+(k*96|0)+(b*24|0)+16>>2]|0)+g|0;f=(c[144840+(k*96|0)+(b*24|0)+20>>2]|0)+h|0;if(!((r|0)>-1&(r|0)<(o|0))){break L1105}if((r|0)<0){i=e;return}if(!((f|0)>-1&(m|0)>(f|0))){i=e;return}b=(ag(o,f)|0)+r|0;r=(c[n>>2]|0)+(b*20|0)|0;if((r|0)==0){i=e;return}if((a[r|0]&1)!=0){break}i=e;return}}while(0);gr(p,-d|0);i=e;return}}while(0);gr(p,-d|0);i=e;return}function fA(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;i=i+8|0;f=e|0;g=b+100|0;h=c[g>>2]|0;if((h|0)==0){i=e;return}if((a[b+145|0]&1)==0){j=c[b+28>>2]|0;k=f;l=b+160|0;m=j-(c[l>>2]|0)&255;c[f>>2]=1;a[k+4|0]=d&255;a[k+5|0]=m;m=b+152|0;n=c[m>>2]|0;if((n|0)==(c[b+156>>2]|0)){fP(b+148|0,k)}else{if((n|0)==0){o=0}else{k=n;n=c[f+4>>2]|0;c[k>>2]=c[f>>2];c[k+4>>2]=n;o=c[m>>2]|0}c[m>>2]=o+8}c[l>>2]=j;p=c[g>>2]|0}else{p=h}gp(p,d);p=c[g>>2]|0;g=(c[p+16>>2]|0)+(c[p+4>>2]|0)|0;h=c[p+8>>2]|0;j=p+12|0;l=p|0;o=c[36156]|0;m=c[36150]|0;n=b+96|0;do{if((g|0)>-1&(o|0)>(g|0)){if(!((h|0)>-1&(m|0)>(h|0))){q=1005;break}b=(ag(o,h)|0)+g|0;k=(c[n>>2]|0)+(b*20|0)|0;if((k|0)==0){q=1005;break}if((a[k|0]&1)==0){q=1005}}else{q=1005}}while(0);L1158:do{if((q|0)==1005){k=c[j>>2]|0;b=c[l>>2]|0;f=(c[144840+(b*96|0)+(k*24|0)>>2]|0)+g|0;r=(c[144840+(b*96|0)+(k*24|0)+4>>2]|0)+h|0;do{if((f|0)>-1&(o|0)>(f|0)){if(!((r|0)>-1&(m|0)>(r|0))){break}k=(ag(o,r)|0)+f|0;b=(c[n>>2]|0)+(k*20|0)|0;if((b|0)==0){break}if((a[b|0]&1)!=0){break L1158}}}while(0);f=c[j>>2]|0;r=c[l>>2]|0;b=(c[144840+(r*96|0)+(f*24|0)+8>>2]|0)+g|0;k=(c[144840+(r*96|0)+(f*24|0)+12>>2]|0)+h|0;do{if((b|0)>-1&(o|0)>(b|0)){if(!((k|0)>-1&(m|0)>(k|0))){break}f=(ag(o,k)|0)+b|0;r=(c[n>>2]|0)+(f*20|0)|0;if((r|0)==0){break}if((a[r|0]&1)!=0){break L1158}}}while(0);b=c[j>>2]|0;k=c[l>>2]|0;r=(c[144840+(k*96|0)+(b*24|0)+16>>2]|0)+g|0;f=(c[144840+(k*96|0)+(b*24|0)+20>>2]|0)+h|0;if(!((r|0)>-1&(o|0)>(r|0))){i=e;return}if(!((f|0)>-1&(m|0)>(f|0))){i=e;return}b=(ag(o,f)|0)+r|0;r=(c[n>>2]|0)+(b*20|0)|0;if((r|0)==0){i=e;return}if((a[r|0]&1)!=0){break}i=e;return}}while(0);gp(p,-d|0);i=e;return}function fB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;c[a+12>>2]=b;c[a+16>>2]=d;e=~~(+(b|0)*.05);c[a+20>>2]=e;c[a+24>>2]=d-(c[36118]<<1)-e-(ag((c[36148]|0)+(c[38394]|0)|0,c[36150]|0)|0);return}function fC(a){a=a|0;fD(a);oF(a);return}function fD(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;c[a>>2]=139360;b=c[a+96>>2]|0;if((b|0)!=0){oG(b|0)}b=c[a+100>>2]|0;if((b|0)!=0){oF(b)}b=c[a+148>>2]|0;d=b;if((b|0)!=0){e=a+152|0;f=c[e>>2]|0;if((b|0)!=(f|0)){c[e>>2]=f+(~((f-8+(-d|0)|0)>>>3)<<3)}oF(b)}b=c[a+104>>2]|0;if((b|0)==0){g=a|0;gB(g);return}d=a+108|0;f=c[d>>2]|0;if((b|0)!=(f|0)){c[d>>2]=f+(~((f-4+(-b|0)|0)>>>2)<<2)}oF(b);g=a|0;gB(g);return}function fE(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;e=(c[d+16>>2]|0)+(c[d+4>>2]|0)|0;f=c[d+8>>2]|0;g=d+12|0;h=d|0;d=c[36150]|0;i=c[36156]|0;j=b+96|0;if((f|0)>=(d|0)){k=1;return k|0}do{if((e|0)>-1&(i|0)>(e|0)&(f|0)>-1){b=(ag(i,f)|0)+e|0;l=(c[j>>2]|0)+(b*20|0)|0;if((l|0)==0){break}if((a[l|0]&1)==0){break}else{k=1}return k|0}}while(0);l=c[g>>2]|0;b=c[h>>2]|0;m=(c[144840+(b*96|0)+(l*24|0)>>2]|0)+e|0;n=(c[144840+(b*96|0)+(l*24|0)+4>>2]|0)+f|0;if((n|0)>=(d|0)){k=1;return k|0}do{if((m|0)>-1&(i|0)>(m|0)&(n|0)>-1){l=(ag(i,n)|0)+m|0;b=(c[j>>2]|0)+(l*20|0)|0;if((b|0)==0){break}if((a[b|0]&1)==0){break}else{k=1}return k|0}}while(0);m=c[g>>2]|0;n=c[h>>2]|0;b=(c[144840+(n*96|0)+(m*24|0)+8>>2]|0)+e|0;l=(c[144840+(n*96|0)+(m*24|0)+12>>2]|0)+f|0;if((l|0)>=(d|0)){k=1;return k|0}do{if((b|0)>-1&(i|0)>(b|0)&(l|0)>-1){m=(ag(i,l)|0)+b|0;n=(c[j>>2]|0)+(m*20|0)|0;if((n|0)==0){break}if((a[n|0]&1)==0){break}else{k=1}return k|0}}while(0);b=c[g>>2]|0;g=c[h>>2]|0;h=(c[144840+(g*96|0)+(b*24|0)+16>>2]|0)+e|0;e=(c[144840+(g*96|0)+(b*24|0)+20>>2]|0)+f|0;if((e|0)>=(d|0)){k=1;return k|0}do{if((h|0)>-1&(i|0)>(h|0)&(e|0)>-1){d=(ag(i,e)|0)+h|0;f=(c[j>>2]|0)+(d*20|0)|0;if((f|0)==0){break}if((a[f|0]&1)==0){break}else{k=1}return k|0}}while(0);k=0;return k|0}function fF(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;d=b+100|0;e=c[d>>2]|0;do{if((e|0)!=0){f=b+96|0;g=0;h=e;while(1){i=(c[h+16>>2]|0)+(c[h+4>>2]|0)|0;j=c[h+8>>2]|0;if((g|0)>0){k=g-1|0;l=c[h+12>>2]|0;m=c[h>>2]|0;n=(c[144840+(m*96|0)+(l*24|0)+(k<<3)+4>>2]|0)+j|0;o=(c[144840+(m*96|0)+(l*24|0)+(k<<3)>>2]|0)+i|0}else{n=j;o=i}if((o|0)<0){break}i=c[36156]|0;if((i|0)<=(o|0)){break}if(!((n|0)>-1&(c[36150]|0)>(n|0))){break}j=(ag(i,n)|0)+o|0;i=c[f>>2]|0;k=i+(j*20|0)|0;if((k|0)==0){break}c[i+(j*20|0)+4>>2]=go(h)|0;a[k|0]=1;k=g+1|0;if((k|0)>=4){p=1082;break}g=k;h=c[d>>2]|0}if((p|0)==1082){ft(b,-1);break}h=b+4|0;g=c[h>>2]|0;if((g|0)==0){return}if((a[b+145|0]&1)!=0){return}gy(b+148|0,c[g+100>>2]|0);c[(c[h>>2]|0)+4>>2]=c[b+76>>2];c[(c[h>>2]|0)+12>>2]=c[b+80>>2];eM(c[h>>2]|0,6);return}}while(0);fI(b);return}function fG(b){b=b|0;var d=0,e=0,f=0,h=0,j=0.0,k=0.0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;d=i;i=i+16|0;e=d|0;f=d+8|0;h=b+28|0;c[h>>2]=(c[h>>2]|0)+1;do{if((a[b+145|0]&1)==0){h=b+36|0;j=+g[h>>2]+1.0;g[h>>2]=j;k=+(c[b+32>>2]|0)/+g[b+8>>2];if(j<=k){break}do{fx(b,0)|0;j=+g[h>>2]-k;g[h>>2]=j;}while(j>k)}else{gw(b+148|0,b,4)|0}}while(0);h=b+108|0;l=b+104|0;m=c[l>>2]|0;n=((c[h>>2]|0)-m>>2)-1|0;L1271:do{if((n|0)>-1){o=b+16|0;p=b+12|0;q=n;r=n;s=m;while(1){t=r<<2>>2;u=c[s+(q<<2)>>2]|0;fS(u,e,f);do{if((c[f>>2]|0)>(c[o>>2]|0)){v=1098}else{w=c[e>>2]|0;if(((c[36154]|0)+w|0)<0){v=1098;break}if((w|0)>(c[p>>2]|0)){v=1098;break}fR(u)}}while(0);do{if((v|0)==1098){v=0;if((u|0)!=0){oF(u)}w=c[l>>2]|0;x=q<<2>>2;y=w+(x+1<<2)|0;z=(c[h>>2]|0)-y|0;A=z>>2;oP(w+(x<<2)|0,y|0,z|0);z=c[h>>2]|0;if((w+(A+x<<2)|0)==(z|0)){break}c[h>>2]=z+(~((z-4+(-(w+(A+t<<2)|0)|0)|0)>>>2)<<2)}}while(0);t=q-1|0;if((t|0)<=-1){break L1271}q=t;r=r+1073741823&1073741823;s=c[l>>2]|0}}}while(0);l=c[36156]|0;h=c[36150]|0;v=(ag(h,l)|0)-1|0;if((v|0)>0){e=b+96|0;f=v;do{v=(c[e>>2]|0)+(f*20|0)+16|0;m=c[v>>2]|0;if((m|0)>0){c[v>>2]=(m|0)/2|0}f=f-1|0;}while((f|0)>0);B=c[36156]|0;C=c[36150]|0}else{B=l;C=h}if((ag(C,B)|0)<=0){i=d;return}B=b+96|0;b=0;do{C=c[B>>2]|0;h=C+(b*20|0)+8|0;do{if((a[h]&1)!=0){l=C+(b*20|0)+12|0;k=+g[l>>2]*.85;g[l>>2]=k;if(k>=.1){break}a[h]=0}}while(0);b=b+1|0;}while((b|0)<(ag(c[36150]|0,c[36156]|0)|0));i=d;return}function fH(a,b){a=a|0;b=+b;c[a+172>>2]=~~((1.0-b)*+(-(c[36132]|0)|0));return}function fI(b){b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0;d=i;i=i+8|0;e=d|0;f=c[36150]|0;L1309:do{if((f|0)>0){h=b+96|0;j=b+36|0;k=b+32|0;l=b+20|0;m=b+24|0;n=b+104|0;o=b+108|0;p=b+112|0;q=0;r=0;s=f-1|0;t=f;L1311:while(1){u=c[36156]|0;L1313:do{if((u|0)>0){v=q;w=s;while(1){if((t|0)>(w|0)){x=0}else{y=0;break}while(1){z=(ag(u,w)|0)+x|0;A=(c[h>>2]|0)+(z*20|0)|0;if((A|0)!=0){if((a[A|0]&1)==0){break}}A=x+1|0;if((A|0)<(u|0)){x=A}else{B=v;C=w;break L1313}}if((w|0)>0){v=0;w=w-1|0}else{D=r;break L1311}}while(1){A=y+1|0;if((A|0)<(u|0)){y=A}else{B=v;C=w;break}}}else{B=q;C=s}}while(0);u=r+1|0;g[j>>2]=0.0;c[k>>2]=c[36136];w=(C|0)>-1;if(!w){D=u;break}v=C-B|0;A=B+1|0;z=C;E=c[36156]|0;while(1){if((E|0)>0){F=(z|0)>0;G=(z|0)==(C|0);H=z-1|0;I=0;J=E;while(1){do{if((c[36150]|0)>(z|0)){K=(ag(J,z)|0)+I|0;L=c[h>>2]|0;M=L+(K*20|0)|0;if((M|0)==0){break}if(!F){a[M|0]=0;break}do{if(G){N=c[36118]|0;O=c[38394]|0;P=N+(c[l>>2]|0)+(ag(O+(c[36154]|0)|0,I)|0)|0;Q=(c[m>>2]|0)+N+(ag((c[36148]|0)+O|0,v)|0)|0;O=oD(28)|0;fQ(O,c[L+(K*20|0)+4>>2]|0,P,Q);c[e>>2]=O;Q=c[o>>2]|0;if((Q|0)==(c[p>>2]|0)){fO(n,e);break}if((Q|0)==0){R=0}else{c[Q>>2]=O;R=c[o>>2]|0}c[o>>2]=R+4}}while(0);O=c[36156]|0;if(!((O|0)>(I|0)&(c[36150]|0)>(H|0))){break}Q=(ag(O,H)|0)+I|0;O=(c[h>>2]|0)+(Q*20|0)|0;if((O|0)==0){break}Q=M|0;P=O|0;c[Q>>2]=c[P>>2];c[Q+4>>2]=c[P+4>>2];c[Q+8>>2]=c[P+8>>2];c[Q+12>>2]=c[P+12>>2];c[Q+16>>2]=c[P+16>>2];c[L+(K*20|0)+16>>2]=ag(c[36148]|0,A)|0}}while(0);P=I+1|0;Q=c[36156]|0;if((P|0)<(Q|0)){I=P;J=Q}else{S=Q;T=H;break}}}else{S=E;T=z-1|0}if((z|0)>0){z=T;E=S}else{break}}if(!w){D=u;break}q=A;r=u;s=C;t=c[36150]|0}switch(D|0){case 4:{gD(b+76|0,5);break};case 0:{break L1309;break};case 1:{gD(b+76|0,2);break};case 2:{gD(b+76|0,3);break};case 3:{gD(b+76|0,4);break};default:{}}t=c[b+80>>2]|0;s=b+84|0;if((t-(c[s>>2]|0)|0)<(c[36140]|0)){i=d;return}c[s>>2]=t;fX(b+72|0);t=b+8|0;g[t>>2]=+g[t>>2]*1.100000023841858;i=d;return}}while(0);gD(b+76|0,1);i=d;return}function fJ(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0.0,X=0.0,Y=0.0,Z=0.0;e=i;i=i+40|0;f=e|0;h=e+24|0;j=e+32|0;k=c[(c[d>>2]|0)+4>>2]|0;l=b+72|0;m=fW(l,-1)|0;n=fW(l,-2)|0;dh[k&31](d,m,n);n=b+100|0;m=f;k=c[n>>2]|0;c[m>>2]=c[k>>2];c[m+4>>2]=c[k+4>>2];c[m+8>>2]=c[k+8>>2];c[m+12>>2]=c[k+12>>2];c[m+16>>2]=c[k+16>>2];do{gq(f,1);}while(!(fE(b,f)|0));gq(f,-1);k=c[36150]|0;if((k|0)>0){m=b+20|0;o=b+24|0;p=d;q=d;r=d;s=f+4|0;t=f+16|0;u=f+8|0;v=f+12|0;w=f|0;f=b+96|0;x=k;k=c[36156]|0;while(1){y=x-1|0;if((k|0)>0){z=0;A=k;while(1){if((c[36150]|0)>(y|0)){B=(ag(A,y)|0)+z|0;C=(c[f>>2]|0)+(B*20|0)|0}else{C=0}B=c[36118]|0;D=c[38394]|0;E=B+(c[m>>2]|0)+(ag(D+(c[36154]|0)|0,z)|0)|0;F=(c[o>>2]|0)+B+(ag((c[36148]|0)+D|0,y)|0)|0;D=c[n>>2]|0;B=D+4|0;G=D+16|0;H=D+8|0;I=D+12|0;J=D|0;K=0;while(1){if((K|0)>=4){L=1180;break}M=(c[G>>2]|0)+(c[B>>2]|0)|0;N=c[H>>2]|0;if((K|0)>0){O=K-1|0;P=c[I>>2]|0;Q=c[J>>2]|0;R=(c[144840+(Q*96|0)+(P*24|0)+(O<<3)+4>>2]|0)+N|0;S=(c[144840+(Q*96|0)+(P*24|0)+(O<<3)>>2]|0)+M|0}else{R=N;S=M}if((S|0)==(z|0)&(R|0)==(y|0)){L=1179;break}else{K=K+1|0}}L1388:do{if((L|0)==1179){L=0;K=c[(c[p>>2]|0)+8>>2]|0;J=fW(l,go(D)|0)|0;c2[K&3](d,J,E,F,0.0)}else if((L|0)==1180){L=0;if((a[C|0]&1)!=0){J=c[(c[p>>2]|0)+8>>2]|0;K=fW(l,c[C+4>>2]|0)|0;c2[J&3](d,K,E,F-(c[C+16>>2]|0)|0,0.0);break}L1394:do{if((a[144608]&1)!=0){K=(c[t>>2]|0)+(c[s>>2]|0)|0;J=c[u>>2]|0;I=c[v>>2]|0;H=c[w>>2]|0;B=0;while(1){if((B|0)>=4){break L1394}if((B|0)>0){G=B-1|0;T=(c[144840+(H*96|0)+(I*24|0)+(G<<3)+4>>2]|0)+J|0;U=(c[144840+(H*96|0)+(I*24|0)+(G<<3)>>2]|0)+K|0}else{T=J;U=K}if((U|0)==(z|0)&(T|0)==(y|0)){break}else{B=B+1|0}}c2[c[(c[p>>2]|0)+8>>2]&3](d,13,E,F,0.0);break L1388}}while(0);if((a[C+8|0]&1)==0){c_[c[(c[q>>2]|0)+12>>2]&15](d,E,F,(z|0)==(A-1|0),(y|0)==((c[36150]|0)-1|0));break}else{dc[c[(c[r>>2]|0)+16>>2]&3](d,+g[C+12>>2],E,F);break}}}while(0);F=z+1|0;E=c[36156]|0;if((F|0)<(E|0)){z=F;A=E}else{V=E;break}}}else{V=k}if((y|0)>0){x=y;k=V}else{break}}}V=c[b+104>>2]|0;k=b+108|0;if((V|0)!=(c[k>>2]|0)){x=d;C=V;do{fS(c[C>>2]|0,h,j);V=fT(c[C>>2]|0)|0;r=c[(c[x>>2]|0)+8>>2]|0;q=fW(l,V)|0;V=c[h>>2]|0;p=c[j>>2]|0;W=+fU(c[C>>2]|0);c2[r&3](d,q,V,p,W);C=C+4|0;}while((C|0)!=(c[k>>2]|0))}da[c[(c[d>>2]|0)+20>>2]&127](d,~~(+(c[b+28>>2]|0)*33.0),c[b+76>>2]|0,(c[b+12>>2]|0)-100|0,20,80,80);k=c[b+172>>2]|0;b=c[36132]|0;W=+(b|0)/5.0;X=W*.5;Y=W*2.0+X;Z=+(k|0)+(+(b|0)-Y)*.5;C=d;de[c[(c[C>>2]|0)+28>>2]&3](d,0,k,k,b,b,.5);b=~~Z;k=~~W;j=~~Y;de[c[(c[C>>2]|0)+28>>2]&3](d,1,b,b,k,j,1.0);de[c[(c[C>>2]|0)+28>>2]&3](d,1,~~(X+(W+Z)),b,k,j,1.0);i=e;return}function fK(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0.0,j=0,k=0.0,l=0.0,m=0,n=0,o=0;g=(d|0)==2;do{if(g){h=c[36132]|0;if(!((h|0)>(e|0)&(h|0)>(f|0))){break}h=c[b+4>>2]|0;if((h|0)==0){return}eM(h,11);return}}while(0);if((a[b+145|0]&1)!=0){return}if((d|0)==0){c[b+128>>2]=e;c[b+116>>2]=e;c[b+132>>2]=f;c[b+120>>2]=f;c[b+124>>2]=fn()|0;a[b+136|0]=0;a[b+144|0]=1;return}if(g){g=(c[b+116>>2]|0)-e|0;d=(c[b+120>>2]|0)-f|0;i=+W(+((ag(d,d)|0)+(ag(g,g)|0)|0));do{if((a[b+136|0]&1)==0&i<20.0){if((a[144536]&1)==0){fA(b,1);break}g=c[b+12>>2]|0;d=(g|0)/6|0;h=c[b+16>>2]|0;if((h-((h|0)/8|0)|0)<(f|0)){fy(b);break}if((d|0)>(e|0)){fz(b,-1);break}if((g-d|0)<(e|0)){fz(b,1);break}else{fA(b,1);break}}}while(0);c[b+140>>2]=0;return}d=b+128|0;g=d;h=c[g>>2]|0;j=f-(c[g+4>>2]|0)|0;g=fn()|0;i=+(c[b+16>>2]|0);k=+(c[b+12>>2]|0)/11.0;l=i/7.0;if(+(j|0)<=i/26.0){i=+(e-h|0);if(i>k){fz(b,1);c[d>>2]=e;c[b+132>>2]=f;a[b+136|0]=1;a[b+144|0]=0;return}if(i>=-0.0-k){return}fz(b,-1);c[d>>2]=e;c[b+132>>2]=f;a[b+136|0]=1;a[b+144|0]=0;return}h=b+140|0;do{if((g|0)==(c[h>>2]|0)){m=1220}else{if((g-(c[b+124>>2]|0)|0)>=300){m=1222;break}j=b+116|0;n=e-(c[j>>2]|0)|0;o=f-(c[j+4>>2]|0)|0;if(+W(+((ag(o,o)|0)+(ag(n,n)|0)|0))>l){m=1220}else{m=1222}}}while(0);do{if((m|0)==1220){n=b+144|0;if((a[n]&1)==0){m=1222;break}fy(b);c[h>>2]=0;a[n]=0}}while(0);if((m|0)==1222){fx(b,0)|0;c[h>>2]=g}c[d>>2]=e;c[b+132>>2]=f;a[b+136|0]=1;return}function fL(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;if((a[b+145|0]&1)!=0){return}if(!d){if(!((f|0)==2&(e^1))){return}g[b+36>>2]=0.0;c[b+32>>2]=c[36136];return}if((f|0)==4){fz(b,1)}else if((f|0)==3){fz(b,-1)}if(e){return}if((f|0)==5){fy(b);return}else if((f|0)==1){fA(b,1);return}else if((f|0)==2){fx(b,0)|0;g[b+36>>2]=0.0;c[b+32>>2]=c[36138];return}else{return}}function fM(a,b){a=a|0;b=b|0;return}function fN(a){a=a|0;return 1}function fO(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;d=a+4|0;e=a|0;f=c[e>>2]|0;g=f;h=(c[d>>2]|0)-g|0;i=h>>2;j=i+1|0;if(j>>>0>1073741823>>>0){l7(0)}k=a+8|0;a=(c[k>>2]|0)-g|0;if(a>>2>>>0>536870910>>>0){l=1073741823;m=1265}else{g=a>>1;a=g>>>0<j>>>0?j:g;if((a|0)==0){n=0;o=0}else{l=a;m=1265}}if((m|0)==1265){n=oD(l<<2)|0;o=l}l=n+(i<<2)|0;i=n+(o<<2)|0;if((l|0)!=0){c[l>>2]=c[b>>2]}b=n+(j<<2)|0;j=n;l=f;oN(j|0,l|0,h)|0;c[e>>2]=n;c[d>>2]=b;c[k>>2]=i;if((f|0)==0){return}oF(l);return}function fP(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;d=a+4|0;e=a|0;f=c[e>>2]|0;g=f;h=(c[d>>2]|0)-g|0;i=h>>3;j=i+1|0;if(j>>>0>536870911>>>0){l7(0)}k=a+8|0;a=(c[k>>2]|0)-g|0;if(a>>3>>>0>268435454>>>0){l=536870911;m=1277}else{g=a>>2;a=g>>>0<j>>>0?j:g;if((a|0)==0){n=0;o=0}else{l=a;m=1277}}if((m|0)==1277){n=oD(l<<3)|0;o=l}l=n+(i<<3)|0;i=n+(o<<3)|0;if((l|0)!=0){o=b;b=l;l=c[o+4>>2]|0;c[b>>2]=c[o>>2];c[b+4>>2]=l}l=n+(j<<3)|0;j=n;b=f;oN(j|0,b|0,h)|0;c[e>>2]=n;c[d>>2]=l;c[k>>2]=i;if((f|0)==0){return}oF(b);return}function fQ(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a>>2]=b;g[a+4>>2]=+(d|0);g[a+8>>2]=+(e|0);g[a+12>>2]=+(((bR()|0)%70|0)-30|0);g[a+16>>2]=-0.0- +((bR()|0)%30|0|0);g[a+20>>2]=0.0;g[a+24>>2]=+(((bR()|0)%45|0)-22|0);return}function fR(a){a=a|0;var b=0,c=0.0,d=0;b=a+4|0;g[b>>2]=+g[a+12>>2]+ +g[b>>2];b=a+16|0;c=+g[b>>2];d=a+8|0;g[d>>2]=c+ +g[d>>2];g[b>>2]=c+.5;b=a+20|0;g[b>>2]=+g[a+24>>2]+ +g[b>>2];return}function fS(a,b,d){a=a|0;b=b|0;d=d|0;c[b>>2]=~~+g[a+4>>2];c[d>>2]=~~+g[a+8>>2];return}function fT(a){a=a|0;return c[a>>2]|0}function fU(a){a=a|0;return+(+g[a+20>>2])}function fV(a){a=a|0;c[a>>2]=0;return}function fW(a,b){a=a|0;b=b|0;var d=0;switch(b|0){case-1:case 3:case 5:{d=c[144636+((c[a>>2]|0)*12|0)>>2]|0;return d|0};case 0:case 1:case 2:{d=c[144632+((c[a>>2]|0)*12|0)>>2]|0;return d|0};case-2:case 4:case 6:{d=c[144640+((c[a>>2]|0)*12|0)>>2]|0;return d|0};default:{d=0;return d|0}}return 0}function fX(a){a=a|0;var b=0;b=a|0;c[b>>2]=(((c[b>>2]|0)+1|0)>>>0)%10|0;return}function fY(a,b,d,e,f,g,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;gz(a|0,b);c[a>>2]=139736;c[a+8>>2]=d;c[a+12>>2]=e;c[a+16>>2]=f;c[a+20>>2]=g;c[a+24>>2]=h;c[a+28>>2]=i;oO(a+32|0,0,24);return}function fZ(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;if((b|0)!=2){return}b=c[a+36>>2]|0;if((b|0)>(d|0)){return}if(((c[a+32>>2]|0)+b|0)<(d|0)){return}d=c[a+48>>2]|0;do{if((d|0)<=(e|0)){if(((c[a+40>>2]|0)+d|0)<(e|0)){break}eM(c[a+4>>2]|0,c[a+20>>2]|0);return}}while(0);d=c[a+52>>2]|0;if((d|0)>(e|0)){return}if(((c[a+40>>2]|0)+d|0)<(e|0)){return}eM(c[a+4>>2]|0,c[a+28>>2]|0);return}function f_(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function f$(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=c[a+8>>2]|0;c1[c[(c[d>>2]|0)+20>>2]&127](d,b);c0[c[(c[b>>2]|0)+24>>2]&511](b);d=c[a+36>>2]|0;e=a+32|0;f=a+40|0;c8[c[(c[b>>2]|0)+44>>2]&31](b,1,c[a+12>>2]|0,d,c[a+44>>2]|0,c[e>>2]|0,c[f>>2]|0,1);g=b;da[c[(c[g>>2]|0)+60>>2]&127](b,4,c[a+16>>2]|0,d,c[a+48>>2]|0,c[e>>2]|0,c[f>>2]|0);da[c[(c[g>>2]|0)+60>>2]&127](b,4,c[a+24>>2]|0,d,c[a+52>>2]|0,c[e>>2]|0,c[f>>2]|0);return}function f0(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;d=c[a+4>>2]|0;c[a+32>>2]=~~(+(c[d+68>>2]|0)- +(c[36122]|0)*2.0);c[a+36>>2]=c[36122];b=d+72|0;d=~~(+(c[b>>2]|0)/5.0);c[a+40>>2]=d;e=~~(+(c[b>>2]|0)*.5- +(c[36122]|0)- +(d|0));c[a+44>>2]=e;b=(c[36122]|0)+d+e|0;c[a+48>>2]=b;c[a+52>>2]=(c[36122]|0)+d+b;return}function f1(a){a=a|0;return}function f2(a,b){a=a|0;b=b|0;return}function f3(a){a=a|0;gB(a|0);return}function f4(a){a=a|0;gB(a|0);oF(a);return}function f5(a){a=a|0;return 2}function f6(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0;if((a[b+44|0]&1)==0){return}switch(c[b+4>>2]|0){case 4:{c8[c[(c[d>>2]|0)+44>>2]&31](d,c[b+12>>2]|0,c[b+8>>2]|0,c[b+28>>2]|0,c[b+32>>2]|0,c[b+36>>2]|0,c[b+40>>2]|0,c[b+48>>2]|0);break};case 1:{c9[c[(c[d>>2]|0)+48>>2]&63](d,(a[c[b+20>>2]|0]&1)!=0,c[b+28>>2]|0,c[b+32>>2]|0,c[b+36>>2]|0,c[b+40>>2]|0);break};case 0:{da[c[(c[d>>2]|0)+60>>2]&127](d,4,c[b+8>>2]|0,c[b+28>>2]|0,c[b+32>>2]|0,c[b+36>>2]|0,c[b+40>>2]|0);break};case 2:{e=c[b+28>>2]|0;f=c[b+32>>2]|0;g=c[b+36>>2]|0;h=c[b+40>>2]|0;i=+((g|0)/5|0|0);j=i*2.5;k=+(e|0);l=+(g|0)*.5;m=+(f|0);n=(+(g|0)-j)*.5;o=m+n;p=d;de[c[(c[p>>2]|0)+28>>2]&3](d,0,e,f,g,h,.5);g=~~(k+l);db[c[(c[d>>2]|0)+32>>2]&3](d,1,~~(k+n),~~(m+l),g,~~o,g,~~(j+o),1.0);de[c[(c[p>>2]|0)+28>>2]&3](d,1,g,~~(m+(+(h|0)-i)*.5),~~(j*.5),~~i,1.0);break};case 3:{da[c[(c[d>>2]|0)+36>>2]&127](d,1,c[b+24>>2]|0,c[b+28>>2]|0,c[b+32>>2]|0,c[b+36>>2]|0,c[b+40>>2]|0);break};default:{}}if((a[b+45|0]&1)==0){return}de[c[(c[d>>2]|0)+28>>2]&3](d,1,c[b+28>>2]|0,c[b+32>>2]|0,c[b+36>>2]|0,c[b+40>>2]|0,.5);return}function f7(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;gz(b|0,d);c[b>>2]=139248;d=b+8|0;e=b+20|0;oO(d|0,0,16);f=oD(52)|0;g=c[(c[b+4>>2]|0)+72>>2]|0;h=c[36132]|0;c[f>>2]=b;c[f+4>>2]=2;c[f+8>>2]=0;c[f+12>>2]=1;c[f+16>>2]=13;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;c[f+32>>2]=g;c[f+36>>2]=h;c[f+40>>2]=h;a[f+44|0]=1;a[f+45|0]=0;c[f+48>>2]=0;c[e>>2]=f;gl(d,e);return}function f8(a){a=a|0;f9(a);oF(a);return}function f9(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;c[a>>2]=139248;b=a+12|0;d=c[b>>2]|0;e=a+8|0;f=c[e>>2]|0;if((d|0)==(f|0)){g=d;h=f;i=d}else{j=0;k=f;f=d;while(1){d=c[k+(j<<2)>>2]|0;if((d|0)==0){l=f;m=k}else{n=c[d+8>>2]|0;if((n|0)!=0){oz(n)}oF(d);l=c[b>>2]|0;m=c[e>>2]|0}d=j+1|0;n=m;if(d>>>0<l-n>>2>>>0){j=d;k=m;f=l}else{g=m;h=n;i=l;break}}}if((g|0)==0){o=a|0;gB(o);return}if((g|0)!=(i|0)){c[b>>2]=i+(~((i-4+(-h|0)|0)>>>2)<<2)}oF(g);o=a|0;gB(o);return}function ga(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;g=b+12|0;h=c[g>>2]|0;i=b+8|0;b=c[i>>2]|0;if((h|0)==(b|0)){return}if((d|0)==2){j=0;k=b}else{d=0;do{d=d+1|0;}while(d>>>0<h-b>>2>>>0);return}do{b=c[k+(j<<2)>>2]|0;do{if((a[b+44|0]&1)!=0){h=c[b+28>>2]|0;if((h|0)>(e|0)){break}if(((c[b+36>>2]|0)+h|0)<(e|0)){break}h=c[b+32>>2]|0;if((h|0)>(f|0)){break}if(((c[b+40>>2]|0)+h|0)<(f|0)){break}h=c[b+4>>2]|0;if((h|0)==0|(h|0)==2){eM(c[(c[b>>2]|0)+4>>2]|0,c[b+16>>2]|0);break}else if((h|0)==1){h=c[b+20>>2]|0;a[h]=a[h]&1^1;break}else{break}}}while(0);j=j+1|0;k=c[i>>2]|0;}while(j>>>0<(c[g>>2]|0)-k>>2>>>0);return}function gb(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;if(d){return}d=b+12|0;e=b+8|0;b=c[e>>2]|0;g=(c[d>>2]|0)-b>>2;h=0;while(1){if(h>>>0>=g>>>0){i=-1;j=0;k=1;break}l=c[b+(h<<2)>>2]|0;if((a[l+45|0]&1)==0){h=h+1|0}else{m=1388;break}}do{if((m|0)==1388){if((h|0)<=-1){i=h;j=0;k=1;break}b=(l|0)==0;if((f|0)!=5|b){i=h;j=l;k=b;break}if((a[l+44|0]&1)==0){i=h;j=l;k=0;break}if((c[l+36>>2]|0)<0){i=h;j=l;k=0;break}if((c[l+40>>2]|0)<0){i=h;j=l;k=0;break}b=c[l+4>>2]|0;if((b|0)==1){g=c[l+20>>2]|0;a[g]=a[g]&1^1;i=h;j=l;k=0;break}else if((b|0)==0|(b|0)==2){eM(c[(c[l>>2]|0)+4>>2]|0,c[l+16>>2]|0);i=h;j=l;k=0;break}else{i=h;j=l;k=0;break}}}while(0);if((f-1|0)>>>0>=2>>>0){return}do{if(k){n=0;o=c[e>>2]|0}else{a[j+45|0]=0;if((f|0)==1){p=i-1|0}else if((f|0)==2){p=i+1|0}else{p=i}l=c[e>>2]|0;h=((c[d>>2]|0)-l>>2)-1|0;if((p|0)<0){n=h;o=l;break}n=p>>>0>h>>>0?0:p;o=l}}while(0);a[(c[o+(n<<2)>>2]|0)+45|0]=1;return}function gc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=a+12|0;e=a+8|0;a=c[e>>2]|0;if((c[d>>2]|0)==(a|0)){return}else{f=0;g=a}do{f6(c[g+(f<<2)>>2]|0,b);f=f+1|0;g=c[e>>2]|0;}while(f>>>0<(c[d>>2]|0)-g>>2>>>0);return}function gd(a,b,c){a=a|0;b=b|0;c=c|0;return}function ge(a,b){a=a|0;b=+b;c[(c[a+20>>2]|0)+32>>2]=~~(+(c[(c[a+4>>2]|0)+72>>2]|0)- +(c[36132]|0)*b);return}function gf(a){a=a|0;return}function gg(a,b){a=a|0;b=b|0;return}function gh(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0;k=i;i=i+8|0;l=k|0;m=oD(52)|0;n=m;c[m>>2]=b;c[m+4>>2]=0;c[m+8>>2]=b9(d|0)|0;c[m+12>>2]=1;c[m+16>>2]=j;c[m+20>>2]=0;c[m+24>>2]=0;c[m+28>>2]=e;c[m+32>>2]=f;c[m+36>>2]=g;c[m+40>>2]=h;a[m+44|0]=1;a[m+45|0]=0;c[m+48>>2]=0;c[l>>2]=n;m=b+12|0;h=c[m>>2]|0;if((h|0)==(c[b+16>>2]|0)){gl(b+8|0,l);o=c[l>>2]|0;i=k;return o|0}if((h|0)==0){p=0}else{c[h>>2]=n;p=c[m>>2]|0}c[m>>2]=p+4;o=n;i=k;return o|0}function gi(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0;j=i;i=i+8|0;k=j|0;l=oD(52)|0;m=l;c[l>>2]=b;c[l+4>>2]=3;c[l+8>>2]=0;c[l+12>>2]=1;c[l+16>>2]=0;c[l+20>>2]=0;c[l+24>>2]=d;c[l+28>>2]=e;c[l+32>>2]=f;c[l+36>>2]=g;c[l+40>>2]=h;a[l+44|0]=1;a[l+45|0]=0;c[l+48>>2]=0;c[k>>2]=m;l=b+12|0;h=c[l>>2]|0;if((h|0)==(c[b+16>>2]|0)){gl(b+8|0,k);n=c[k>>2]|0;i=j;return n|0}if((h|0)==0){o=0}else{c[h>>2]=m;o=c[l>>2]|0}c[l>>2]=o+4;n=m;i=j;return n|0}function gj(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0;l=i;i=i+8|0;m=l|0;n=oD(52)|0;o=n;c[n>>2]=b;c[n+4>>2]=4;c[n+8>>2]=b9(d|0)|0;c[n+12>>2]=k;c[n+16>>2]=0;c[n+20>>2]=0;c[n+24>>2]=0;c[n+28>>2]=e;c[n+32>>2]=f;c[n+36>>2]=g;c[n+40>>2]=h;a[n+44|0]=1;a[n+45|0]=0;c[n+48>>2]=j;c[m>>2]=o;j=b+12|0;n=c[j>>2]|0;if((n|0)==(c[b+16>>2]|0)){gl(b+8|0,m);p=c[m>>2]|0;i=l;return p|0}if((n|0)==0){q=0}else{c[n>>2]=o;q=c[j>>2]|0}c[j>>2]=q+4;p=o;i=l;return p|0}function gk(b,c,d){b=b|0;c=c|0;d=d|0;a[c+44|0]=d&1;return}function gl(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;d=a+4|0;e=a|0;f=c[e>>2]|0;g=f;h=(c[d>>2]|0)-g|0;i=h>>2;j=i+1|0;if(j>>>0>1073741823>>>0){l7(0)}k=a+8|0;a=(c[k>>2]|0)-g|0;if(a>>2>>>0>536870910>>>0){l=1073741823;m=1447}else{g=a>>1;a=g>>>0<j>>>0?j:g;if((a|0)==0){n=0;o=0}else{l=a;m=1447}}if((m|0)==1447){n=oD(l<<2)|0;o=l}l=n+(i<<2)|0;i=n+(o<<2)|0;if((l|0)!=0){c[l>>2]=c[b>>2]}b=n+(j<<2)|0;j=n;l=f;oN(j|0,l|0,h)|0;c[e>>2]=n;c[d>>2]=b;c[k>>2]=i;if((f|0)==0){return}oF(l);return}function gm(){var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;b=i;i=i+24|0;d=b|0;if((a[153584]&1)!=0){i=b;return}a[153584]=1;e=0;f=0;g=0;h=0;j=c[36188]|0;while(1){do{if((j|0)==0){k=f;l=g;m=h;n=1468}else{o=h;p=g;q=1;r=0;s=0;t=f;u=j;while(1){v=0;w=r;x=q;y=p;z=o;while(1){A=a[u+v|0]|0;if((A<<24>>24|0)==99|(A<<24>>24|0)==120){B=w;C=A<<24>>24==99;D=v;E=s}else if((A<<24>>24|0)==35){c[d+(w<<3)>>2]=v;c[d+(w<<3)+4>>2]=s;B=w+1|0;C=x;D=y;E=z}else if((A<<24>>24|0)==0){break}else{B=w;C=x;D=y;E=z}v=v+1|0;w=B;x=C;y=D;z=E}F=t+1|0;v=c[144752+(F<<2)>>2]|0;if((v|0)==0){break}else{o=z;p=y;q=x;r=w;s=s+1|0;t=F;u=v}}if(x){k=F;l=y;m=z;n=1468;break}u=(c[d>>2]|0)-y|0;t=(c[d+4>>2]|0)-z|0;c[144840+(e*96|0)>>2]=u;c[144844+(e*96|0)>>2]=t;c[144864+(e*96|0)>>2]=u;c[144868+(e*96|0)>>2]=t;c[144888+(e*96|0)>>2]=u;c[144892+(e*96|0)>>2]=t;c[144912+(e*96|0)>>2]=u;c[144916+(e*96|0)>>2]=t;t=(c[d+8>>2]|0)-y|0;u=(c[d+12>>2]|0)-z|0;c[144848+(e*96|0)>>2]=t;c[144852+(e*96|0)>>2]=u;c[144872+(e*96|0)>>2]=t;c[144876+(e*96|0)>>2]=u;c[144896+(e*96|0)>>2]=t;c[144900+(e*96|0)>>2]=u;c[144920+(e*96|0)>>2]=t;c[144924+(e*96|0)>>2]=u;u=(c[d+16>>2]|0)-y|0;t=(c[d+20>>2]|0)-z|0;c[144856+(e*96|0)>>2]=u;c[144860+(e*96|0)>>2]=t;c[144880+(e*96|0)>>2]=u;c[144884+(e*96|0)>>2]=t;c[144904+(e*96|0)>>2]=u;c[144908+(e*96|0)>>2]=t;c[144928+(e*96|0)>>2]=u;c[144932+(e*96|0)>>2]=t;G=F;H=y;I=z}}while(0);if((n|0)==1468){n=0;t=(c[d+4>>2]|0)-m|0;u=(c[d>>2]|0)-l|0;c[144840+(e*96|0)>>2]=u;c[144844+(e*96|0)>>2]=t;s=-t|0;c[144864+(e*96|0)>>2]=s;c[144868+(e*96|0)>>2]=u;r=-u|0;c[144888+(e*96|0)>>2]=r;c[144892+(e*96|0)>>2]=s;c[144912+(e*96|0)>>2]=t;c[144916+(e*96|0)>>2]=r;r=(c[d+12>>2]|0)-m|0;t=(c[d+8>>2]|0)-l|0;c[144848+(e*96|0)>>2]=t;c[144852+(e*96|0)>>2]=r;s=-r|0;c[144872+(e*96|0)>>2]=s;c[144876+(e*96|0)>>2]=t;u=-t|0;c[144896+(e*96|0)>>2]=u;c[144900+(e*96|0)>>2]=s;c[144920+(e*96|0)>>2]=r;c[144924+(e*96|0)>>2]=u;u=(c[d+20>>2]|0)-m|0;r=(c[d+16>>2]|0)-l|0;c[144856+(e*96|0)>>2]=r;c[144860+(e*96|0)>>2]=u;s=-u|0;c[144880+(e*96|0)>>2]=s;c[144884+(e*96|0)>>2]=r;t=-r|0;c[144904+(e*96|0)>>2]=t;c[144908+(e*96|0)>>2]=s;c[144928+(e*96|0)>>2]=u;c[144932+(e*96|0)>>2]=t;G=k;H=l;I=m}t=G+1|0;u=c[144752+(t<<2)>>2]|0;if((u|0)==0){break}else{e=e+1|0;f=t;g=H;h=I;j=u}}i=b;return}function gn(a,b){a=a|0;b=b|0;c[a>>2]=b;c[a+4>>2]=(c[36156]|0)/2|0;c[a+8>>2]=-2;c[a+12>>2]=0;c[a+16>>2]=0;gm();return}function go(a){a=a|0;return c[a>>2]|0}function gp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=a+16|0;c[d>>2]=0;e=a+12|0;f=((c[e>>2]|0)+b|0)%4|0;b=f+(((f|0)>0?f+3|0:3)-f&-4)|0;c[e>>2]=b;e=c[a+4>>2]|0;f=a|0;a=(c[144840+((c[f>>2]|0)*96|0)+(b*24|0)>>2]|0)+e|0;g=(a|0)<(e|0)?a:e;h=(a|0)>(e|0)?a:e;a=(c[144840+((c[f>>2]|0)*96|0)+(b*24|0)+8>>2]|0)+e|0;i=(a|0)<(g|0)?a:g;g=(a|0)>(h|0)?a:h;h=(c[144840+((c[f>>2]|0)*96|0)+(b*24|0)+16>>2]|0)+e|0;e=(h|0)<(i|0)?h:i;i=(h|0)>(g|0)?h:g;if((e|0)<0){c[d>>2]=-e;return}e=c[36156]|0;if((i|0)<(e|0)){return}c[d>>2]=~(i-e);return}function gq(a,b){a=a|0;b=b|0;var d=0;d=a+8|0;c[d>>2]=(c[d>>2]|0)+b;return}function gr(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=a+16|0;e=c[d>>2]|0;do{if((e&b|0)<0){f=1485}else{if((e|0)>0&(b|0)>0){f=1485;break}g=c[a+4>>2]|0}}while(0);if((f|0)==1485){f=a+4|0;h=(c[f>>2]|0)+e|0;c[f>>2]=h;c[d>>2]=0;g=h}c[a+4>>2]=g+b;return}function gs(a){a=a|0;oO(a|0,0,32);gt(a);return}function gt(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0;oO(a|0,-1|0,28);do{b=a+(((bR()|0)%7|0)<<2)|0;}while((c[b>>2]|0)!=-1);c[b>>2]=0;do{d=a+(((bR()|0)%7|0)<<2)|0;}while((c[d>>2]|0)!=-1);c[d>>2]=1;do{e=a+(((bR()|0)%7|0)<<2)|0;}while((c[e>>2]|0)!=-1);c[e>>2]=2;do{f=a+(((bR()|0)%7|0)<<2)|0;}while((c[f>>2]|0)!=-1);c[f>>2]=3;do{g=a+(((bR()|0)%7|0)<<2)|0;}while((c[g>>2]|0)!=-1);c[g>>2]=4;do{h=a+(((bR()|0)%7|0)<<2)|0;}while((c[h>>2]|0)!=-1);c[h>>2]=5;do{i=a+(((bR()|0)%7|0)<<2)|0;}while((c[i>>2]|0)!=-1);c[i>>2]=6;c[a+28>>2]=0;return}function gu(a){a=a|0;var b=0,d=0,e=0;b=a+28|0;d=c[b>>2]|0;e=d+1|0;c[b>>2]=e;b=c[a+(d<<2)>>2]|0;if((e|0)!=7){return b|0}gt(a);return b|0}function gv(a){a=a|0;oO(a|0,0,24);return}function gw(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;g=i;i=i+24|0;h=g+8|0;j=g+16|0;k=d+16|0;l=(c[k>>2]|0)+f|0;c[k>>2]=l;m=d+20|0;n=c[m>>2]|0;o=d+4|0;p=c[o>>2]|0;q=d|0;d=c[q>>2]|0;L1794:do{if(n>>>0<p-d>>3>>>0){r=g|0;s=h;t=h+5|0;u=s+6|0;if((f|0)<0){v=n;w=d;while(1){x=w+(v<<3)|0;c[r>>2]=c[x>>2];a[r+4|0]=a[x+4|0]|0;y=a[w+(v<<3)+5|0]|0;z=y&255;A=b[x+6>>1]|0;c[s>>2]=c[r>>2];a[s+4|0]=a[r+4|0]|0;a[t]=y;b[u>>1]=A;fw(e,h);A=(c[m>>2]|0)+1|0;c[m>>2]=A;c[k>>2]=(c[k>>2]|0)-z;z=c[o>>2]|0;y=c[q>>2]|0;if(A>>>0<z-y>>3>>>0){v=A;w=y}else{B=A;C=z;D=y;break L1794}}}else{E=n;F=d;G=l;H=p}while(1){w=F+(E<<3)|0;c[r>>2]=c[w>>2];a[r+4|0]=a[w+4|0]|0;v=a[F+(E<<3)+5|0]|0;y=v&255;if((G|0)<=(y|0)){B=E;C=H;D=F;break L1794}z=b[w+6>>1]|0;c[s>>2]=c[r>>2];a[s+4|0]=a[r+4|0]|0;a[t]=v;b[u>>1]=z;fw(e,h);z=(c[m>>2]|0)+1|0;c[m>>2]=z;v=(c[k>>2]|0)-y|0;c[k>>2]=v;y=c[o>>2]|0;w=c[q>>2]|0;if(z>>>0<y-w>>3>>>0){E=z;F=w;G=v;H=y}else{B=z;C=y;D=w;break}}}else{B=n;C=p;D=d}}while(0);if(B>>>0<C-D>>3>>>0){I=1;i=g;return I|0}c[j>>2]=6;a[j+4|0]=0;a[j+5|0]=0;fw(e,j);I=0;i=g;return I|0}function gx(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;e=i;i=i+8|0;f=e|0;g=f;h=bZ(d|0,134792)|0;d=b|0;j=c[b>>2]|0;k=b+4|0;l=c[k>>2]|0;if((j|0)!=(l|0)){c[k>>2]=l+(~((l-8+(-j|0)|0)>>>3)<<3)}c[b+16>>2]=0;c[b+20>>2]=0;c[f>>2]=0;a[g+4|0]=0;a[g+5|0]=0;if((h|0)==0){i=e;return}j=f;if((ca(j|0,8,1,h|0)|0)==1){l=b+8|0;do{b=c[k>>2]|0;if((b|0)==(c[l>>2]|0)){fP(d,g)}else{if((b|0)==0){m=0}else{n=b;b=c[f+4>>2]|0;c[n>>2]=c[f>>2];c[n+4>>2]=b;m=c[k>>2]|0}c[k>>2]=m+8}}while((ca(j|0,8,1,h|0)|0)==1)}aM(h|0)|0;i=e;return}function gy(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=bZ(b|0,135312)|0;if((d|0)==0){return}b=a+4|0;e=a|0;a=c[e>>2]|0;if((c[b>>2]|0)!=(a|0)){f=0;g=a;do{aV(g+(f<<3)|0,8,1,d|0)|0;f=f+1|0;g=c[e>>2]|0;}while(f>>>0<(c[b>>2]|0)-g>>3>>>0)}aM(d|0)|0;return}function gz(a,b){a=a|0;b=b|0;c[a>>2]=139304;c[a+4>>2]=b;return}function gA(a){a=a|0;oF(a);return}function gB(a){a=a|0;return}function gC(a){a=a|0;oO(a|0,0,20);return}function gD(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;switch(b|0){case 1:{d=a|0;c[d>>2]=(c[d>>2]|0)+(c[36142]|0);c[a+16>>2]=0;e=0;break};case 5:{d=a+4|0;c[d>>2]=(c[d>>2]|0)+4;d=c[a+16>>2]|0;f=a|0;c[f>>2]=(ag(d,c[36128]|0)|0)+(c[f>>2]|0);e=d;break};case 3:{d=a+4|0;c[d>>2]=(c[d>>2]|0)+2;d=c[a+16>>2]|0;f=a|0;c[f>>2]=(ag(d,c[36130]|0)|0)+(c[f>>2]|0);e=d;break};case 4:{d=a+4|0;c[d>>2]=(c[d>>2]|0)+3;d=c[a+16>>2]|0;f=a|0;c[f>>2]=(ag(d,c[36124]|0)|0)+(c[f>>2]|0);e=d;break};case 2:{d=a+4|0;c[d>>2]=(c[d>>2]|0)+1;d=c[a+16>>2]|0;f=a|0;c[f>>2]=(ag(d,c[36126]|0)|0)+(c[f>>2]|0);e=d;break};default:{bt(1)}}c[a+16>>2]=e+1;c[a+12>>2]=b;return}function gE(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;b=i;i=i+32|0;d=b|0;e=b+8|0;f=b+16|0;g=b+24|0;h=c[o>>2]|0;g_(152456,h,152584);c[38362]=138524;c[38364]=138544;c[38363]=0;hT(153456,152456);c[38382]=0;c[38383]=-1;j=c[p>>2]|0;c[38090]=138304;md(152364);oO(152368,0,24);c[38090]=138672;c[38098]=j;me(g,152364);k=mg(g,152784)|0;l=k;mf(g);c[38099]=l;c[38100]=152592;a[152404]=(c3[c[(c[k>>2]|0)+28>>2]&255](l)|0)&1;c[38296]=138428;c[38297]=138448;hT(153188,152360);c[38315]=0;c[38316]=-1;l=c[u>>2]|0;c[38102]=138304;md(152412);oO(152416,0,24);c[38102]=138672;c[38110]=l;me(f,152412);k=mg(f,152784)|0;g=k;mf(f);c[38111]=g;c[38112]=152600;a[152452]=(c3[c[(c[k>>2]|0)+28>>2]&255](g)|0)&1;c[38340]=138428;c[38341]=138448;hT(153364,152408);c[38359]=0;c[38360]=-1;g=c[(c[(c[38340]|0)-12>>2]|0)+153384>>2]|0;c[38318]=138428;c[38319]=138448;hT(153276,g);c[38337]=0;c[38338]=-1;c[(c[(c[38362]|0)-12>>2]|0)+153520>>2]=153184;g=(c[(c[38340]|0)-12>>2]|0)+153364|0;c[g>>2]=c[g>>2]|8192;c[(c[(c[38340]|0)-12>>2]|0)+153432>>2]=153184;gM(152304,h,152608);c[38274]=138476;c[38276]=138496;c[38275]=0;hT(153104,152304);c[38294]=0;c[38295]=-1;c[38052]=138232;md(152212);oO(152216,0,24);c[38052]=138600;c[38060]=j;me(e,152212);j=mg(e,152776)|0;h=j;mf(e);c[38061]=h;c[38062]=152616;a[152252]=(c3[c[(c[j>>2]|0)+28>>2]&255](h)|0)&1;c[38204]=138380;c[38205]=138400;hT(152820,152208);c[38223]=0;c[38224]=-1;c[38064]=138232;md(152260);oO(152264,0,24);c[38064]=138600;c[38072]=l;me(d,152260);l=mg(d,152776)|0;h=l;mf(d);c[38073]=h;c[38074]=152624;a[152300]=(c3[c[(c[l>>2]|0)+28>>2]&255](h)|0)&1;c[38248]=138380;c[38249]=138400;hT(152996,152256);c[38267]=0;c[38268]=-1;h=c[(c[(c[38248]|0)-12>>2]|0)+153016>>2]|0;c[38226]=138380;c[38227]=138400;hT(152908,h);c[38245]=0;c[38246]=-1;c[(c[(c[38274]|0)-12>>2]|0)+153168>>2]=152816;h=(c[(c[38248]|0)-12>>2]|0)+152996|0;c[h>>2]=c[h>>2]|8192;c[(c[(c[38248]|0)-12>>2]|0)+153064>>2]=152816;i=b;return}function gF(a){a=a|0;iq(153184)|0;iq(153272)|0;iv(152816)|0;iv(152904)|0;return}function gG(a){a=a|0;c[a>>2]=138232;mf(a+4|0);return}function gH(a){a=a|0;c[a>>2]=138232;mf(a+4|0);oF(a);return}function gI(b,d){b=b|0;d=d|0;var e=0;c3[c[(c[b>>2]|0)+24>>2]&255](b)|0;e=mg(d,152776)|0;d=e;c[b+36>>2]=d;a[b+44|0]=(c3[c[(c[e>>2]|0)+28>>2]&255](d)|0)&1;return}function gJ(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;b=i;i=i+16|0;d=b|0;e=b+8|0;f=a+36|0;g=a+40|0;h=d|0;j=d+8|0;k=d;d=a+32|0;while(1){a=c[f>>2]|0;l=dg[c[(c[a>>2]|0)+20>>2]&31](a,c[g>>2]|0,h,j,e)|0;a=(c[e>>2]|0)-k|0;if((aV(h|0,1,a|0,c[d>>2]|0)|0)!=(a|0)){m=-1;n=1593;break}if((l|0)==2){m=-1;n=1592;break}else if((l|0)!=1){n=1590;break}}if((n|0)==1592){i=b;return m|0}else if((n|0)==1593){i=b;return m|0}else if((n|0)==1590){m=((aS(c[d>>2]|0)|0)!=0)<<31>>31;i=b;return m|0}return 0}function gK(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;if((a[b+44|0]&1)!=0){f=aV(d|0,4,e|0,c[b+32>>2]|0)|0;return f|0}g=b;if((e|0)>0){h=d;i=0}else{f=0;return f|0}while(1){if((df[c[(c[g>>2]|0)+52>>2]&31](b,c[h>>2]|0)|0)==-1){f=i;j=1601;break}d=i+1|0;if((d|0)<(e|0)){h=h+4|0;i=d}else{f=d;j=1603;break}}if((j|0)==1603){return f|0}else if((j|0)==1601){return f|0}return 0}function gL(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;e=i;i=i+32|0;f=e|0;g=e+8|0;h=e+16|0;j=e+24|0;k=(d|0)==-1;L1893:do{if(!k){c[g>>2]=d;if((a[b+44|0]&1)!=0){if((aV(g|0,4,1,c[b+32>>2]|0)|0)==1){break}else{l=-1}i=e;return l|0}m=f|0;c[h>>2]=m;n=g+4|0;o=b+36|0;p=b+40|0;q=f+8|0;r=f;s=b+32|0;t=g;while(1){u=c[o>>2]|0;v=dj[c[(c[u>>2]|0)+12>>2]&31](u,c[p>>2]|0,t,n,j,m,q,h)|0;if((c[j>>2]|0)==(t|0)){l=-1;w=1622;break}if((v|0)==3){w=1611;break}u=(v|0)==1;if(v>>>0>=2>>>0){l=-1;w=1618;break}v=(c[h>>2]|0)-r|0;if((aV(m|0,1,v|0,c[s>>2]|0)|0)!=(v|0)){l=-1;w=1621;break}if(u){t=u?c[j>>2]|0:t}else{break L1893}}if((w|0)==1611){if((aV(t|0,1,1,c[s>>2]|0)|0)==1){break}else{l=-1}i=e;return l|0}else if((w|0)==1621){i=e;return l|0}else if((w|0)==1622){i=e;return l|0}else if((w|0)==1618){i=e;return l|0}}}while(0);l=k?0:d;i=e;return l|0}function gM(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;i=i+8|0;g=f|0;h=b|0;c[h>>2]=138232;j=b+4|0;md(j);oO(b+8|0,0,24);c[h>>2]=139e3;c[b+32>>2]=d;c[b+40>>2]=e;c[b+48>>2]=-1;a[b+52|0]=0;me(g,j);j=mg(g,152776)|0;e=j;d=b+36|0;c[d>>2]=e;h=b+44|0;c[h>>2]=c3[c[(c[j>>2]|0)+24>>2]&255](e)|0;e=c[d>>2]|0;a[b+53|0]=(c3[c[(c[e>>2]|0)+28>>2]&255](e)|0)&1;if((c[h>>2]|0)<=8){mf(g);i=f;return}lz(132192);mf(g);i=f;return}function gN(a){a=a|0;c[a>>2]=138232;mf(a+4|0);return}function gO(a){a=a|0;c[a>>2]=138232;mf(a+4|0);oF(a);return}function gP(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;e=mg(d,152776)|0;d=e;f=b+36|0;c[f>>2]=d;g=b+44|0;c[g>>2]=c3[c[(c[e>>2]|0)+24>>2]&255](d)|0;d=c[f>>2]|0;a[b+53|0]=(c3[c[(c[d>>2]|0)+28>>2]&255](d)|0)&1;if((c[g>>2]|0)<=8){return}lz(132192);return}function gQ(a){a=a|0;return gT(a,0)|0}function gR(a){a=a|0;return gT(a,1)|0}function gS(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;i=i+32|0;f=e|0;g=e+8|0;h=e+16|0;j=e+24|0;k=b+52|0;l=(a[k]&1)!=0;if((d|0)==-1){if(l){m=-1;i=e;return m|0}n=c[b+48>>2]|0;a[k]=(n|0)!=-1|0;m=n;i=e;return m|0}n=b+48|0;L1936:do{if(l){c[h>>2]=c[n>>2];o=c[b+36>>2]|0;p=f|0;q=dj[c[(c[o>>2]|0)+12>>2]&31](o,c[b+40>>2]|0,h,h+4|0,j,p,f+8|0,g)|0;if((q|0)==3){a[p]=c[n>>2]&255;c[g>>2]=f+1}else if((q|0)==2|(q|0)==1){m=-1;i=e;return m|0}q=b+32|0;while(1){o=c[g>>2]|0;if(o>>>0<=p>>>0){break L1936}r=o-1|0;c[g>>2]=r;if((cq(a[r]|0,c[q>>2]|0)|0)==-1){m=-1;break}}i=e;return m|0}}while(0);c[n>>2]=d;a[k]=1;m=d;i=e;return m|0}function gT(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;e=i;i=i+32|0;f=e|0;g=e+8|0;h=e+16|0;j=e+24|0;k=b+52|0;if((a[k]&1)!=0){l=b+48|0;m=c[l>>2]|0;if(!d){n=m;i=e;return n|0}c[l>>2]=-1;a[k]=0;n=m;i=e;return n|0}m=c[b+44>>2]|0;k=(m|0)>1?m:1;L1956:do{if((k|0)>0){m=b+32|0;l=0;while(1){o=bf(c[m>>2]|0)|0;if((o|0)==-1){n=-1;break}a[f+l|0]=o&255;l=l+1|0;if((l|0)>=(k|0)){break L1956}}i=e;return n|0}}while(0);L1963:do{if((a[b+53|0]&1)==0){l=b+40|0;m=b+36|0;o=f|0;p=g+4|0;q=b+32|0;r=k;while(1){s=c[l>>2]|0;t=s;u=c[t>>2]|0;v=c[t+4>>2]|0;t=c[m>>2]|0;w=f+r|0;x=dj[c[(c[t>>2]|0)+16>>2]&31](t,s,o,w,h,g,p,j)|0;if((x|0)==3){y=1668;break}else if((x|0)==2){n=-1;y=1685;break}else if((x|0)!=1){z=r;break L1963}x=c[l>>2]|0;c[x>>2]=u;c[x+4>>2]=v;if((r|0)==8){n=-1;y=1684;break}v=bf(c[q>>2]|0)|0;if((v|0)==-1){n=-1;y=1679;break}a[w]=v&255;r=r+1|0}if((y|0)==1668){c[g>>2]=a[o]|0;z=r;break}else if((y|0)==1679){i=e;return n|0}else if((y|0)==1684){i=e;return n|0}else if((y|0)==1685){i=e;return n|0}}else{c[g>>2]=a[f|0]|0;z=k}}while(0);if(d){d=c[g>>2]|0;c[b+48>>2]=d;n=d;i=e;return n|0}d=b+32|0;b=z;while(1){if((b|0)<=0){break}z=b-1|0;if((cq(a[f+z|0]|0,c[d>>2]|0)|0)==-1){n=-1;y=1683;break}else{b=z}}if((y|0)==1683){i=e;return n|0}n=c[g>>2]|0;i=e;return n|0}function gU(a){a=a|0;c[a>>2]=138304;mf(a+4|0);return}function gV(a){a=a|0;c[a>>2]=138304;mf(a+4|0);oF(a);return}function gW(b,d){b=b|0;d=d|0;var e=0;c3[c[(c[b>>2]|0)+24>>2]&255](b)|0;e=mg(d,152784)|0;d=e;c[b+36>>2]=d;a[b+44|0]=(c3[c[(c[e>>2]|0)+28>>2]&255](d)|0)&1;return}function gX(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;b=i;i=i+16|0;d=b|0;e=b+8|0;f=a+36|0;g=a+40|0;h=d|0;j=d+8|0;k=d;d=a+32|0;while(1){a=c[f>>2]|0;l=dg[c[(c[a>>2]|0)+20>>2]&31](a,c[g>>2]|0,h,j,e)|0;a=(c[e>>2]|0)-k|0;if((aV(h|0,1,a|0,c[d>>2]|0)|0)!=(a|0)){m=-1;n=1694;break}if((l|0)==2){m=-1;n=1696;break}else if((l|0)!=1){n=1692;break}}if((n|0)==1696){i=b;return m|0}else if((n|0)==1692){m=((aS(c[d>>2]|0)|0)!=0)<<31>>31;i=b;return m|0}else if((n|0)==1694){i=b;return m|0}return 0}function gY(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;if((a[b+44|0]&1)!=0){g=aV(e|0,1,f|0,c[b+32>>2]|0)|0;return g|0}h=b;if((f|0)>0){i=e;j=0}else{g=0;return g|0}while(1){if((df[c[(c[h>>2]|0)+52>>2]&31](b,d[i]|0)|0)==-1){g=j;k=1703;break}e=j+1|0;if((e|0)<(f|0)){i=i+1|0;j=e}else{g=e;k=1705;break}}if((k|0)==1705){return g|0}else if((k|0)==1703){return g|0}return 0}function gZ(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;e=i;i=i+32|0;f=e|0;g=e+8|0;h=e+16|0;j=e+24|0;k=(d|0)==-1;L2014:do{if(!k){a[g]=d&255;if((a[b+44|0]&1)!=0){if((aV(g|0,1,1,c[b+32>>2]|0)|0)==1){break}else{l=-1}i=e;return l|0}m=f|0;c[h>>2]=m;n=g+1|0;o=b+36|0;p=b+40|0;q=f+8|0;r=f;s=b+32|0;t=g;while(1){u=c[o>>2]|0;v=dj[c[(c[u>>2]|0)+12>>2]&31](u,c[p>>2]|0,t,n,j,m,q,h)|0;if((c[j>>2]|0)==(t|0)){l=-1;w=1719;break}if((v|0)==3){w=1713;break}u=(v|0)==1;if(v>>>0>=2>>>0){l=-1;w=1724;break}v=(c[h>>2]|0)-r|0;if((aV(m|0,1,v|0,c[s>>2]|0)|0)!=(v|0)){l=-1;w=1721;break}if(u){t=u?c[j>>2]|0:t}else{break L2014}}if((w|0)==1713){if((aV(t|0,1,1,c[s>>2]|0)|0)==1){break}else{l=-1}i=e;return l|0}else if((w|0)==1721){i=e;return l|0}else if((w|0)==1724){i=e;return l|0}else if((w|0)==1719){i=e;return l|0}}}while(0);l=k?0:d;i=e;return l|0}function g_(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;i=i+8|0;g=f|0;h=b|0;c[h>>2]=138304;j=b+4|0;md(j);oO(b+8|0,0,24);c[h>>2]=139072;c[b+32>>2]=d;c[b+40>>2]=e;c[b+48>>2]=-1;a[b+52|0]=0;me(g,j);j=mg(g,152784)|0;e=j;d=b+36|0;c[d>>2]=e;h=b+44|0;c[h>>2]=c3[c[(c[j>>2]|0)+24>>2]&255](e)|0;e=c[d>>2]|0;a[b+53|0]=(c3[c[(c[e>>2]|0)+28>>2]&255](e)|0)&1;if((c[h>>2]|0)<=8){mf(g);i=f;return}lz(132192);mf(g);i=f;return}function g$(a){a=a|0;c[a>>2]=138304;mf(a+4|0);return}function g0(a){a=a|0;c[a>>2]=138304;mf(a+4|0);oF(a);return}function g1(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;e=mg(d,152784)|0;d=e;f=b+36|0;c[f>>2]=d;g=b+44|0;c[g>>2]=c3[c[(c[e>>2]|0)+24>>2]&255](d)|0;d=c[f>>2]|0;a[b+53|0]=(c3[c[(c[d>>2]|0)+28>>2]&255](d)|0)&1;if((c[g>>2]|0)<=8){return}lz(132192);return}function g2(a){a=a|0;return g5(a,0)|0}function g3(a){a=a|0;return g5(a,1)|0}function g4(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;i=i+32|0;f=e|0;g=e+8|0;h=e+16|0;j=e+24|0;k=b+52|0;l=(a[k]&1)!=0;if((d|0)==-1){if(l){m=-1;i=e;return m|0}n=c[b+48>>2]|0;a[k]=(n|0)!=-1|0;m=n;i=e;return m|0}n=b+48|0;L2057:do{if(l){a[h]=c[n>>2]&255;o=c[b+36>>2]|0;p=f|0;q=dj[c[(c[o>>2]|0)+12>>2]&31](o,c[b+40>>2]|0,h,h+1|0,j,p,f+8|0,g)|0;if((q|0)==3){a[p]=c[n>>2]&255;c[g>>2]=f+1}else if((q|0)==2|(q|0)==1){m=-1;i=e;return m|0}q=b+32|0;while(1){o=c[g>>2]|0;if(o>>>0<=p>>>0){break L2057}r=o-1|0;c[g>>2]=r;if((cq(a[r]|0,c[q>>2]|0)|0)==-1){m=-1;break}}i=e;return m|0}}while(0);c[n>>2]=d;a[k]=1;m=d;i=e;return m|0}function g5(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;f=i;i=i+32|0;g=f|0;h=f+8|0;j=f+16|0;k=f+24|0;l=b+52|0;if((a[l]&1)!=0){m=b+48|0;n=c[m>>2]|0;if(!e){o=n;i=f;return o|0}c[m>>2]=-1;a[l]=0;o=n;i=f;return o|0}n=c[b+44>>2]|0;l=(n|0)>1?n:1;L2077:do{if((l|0)>0){n=b+32|0;m=0;while(1){p=bf(c[n>>2]|0)|0;if((p|0)==-1){o=-1;break}a[g+m|0]=p&255;m=m+1|0;if((m|0)>=(l|0)){break L2077}}i=f;return o|0}}while(0);L2084:do{if((a[b+53|0]&1)==0){m=b+40|0;n=b+36|0;p=g|0;q=h+1|0;r=b+32|0;s=l;while(1){t=c[m>>2]|0;u=t;v=c[u>>2]|0;w=c[u+4>>2]|0;u=c[n>>2]|0;x=g+s|0;y=dj[c[(c[u>>2]|0)+16>>2]&31](u,t,p,x,j,h,q,k)|0;if((y|0)==3){z=1770;break}else if((y|0)==2){o=-1;z=1784;break}else if((y|0)!=1){A=s;break L2084}y=c[m>>2]|0;c[y>>2]=v;c[y+4>>2]=w;if((s|0)==8){o=-1;z=1786;break}w=bf(c[r>>2]|0)|0;if((w|0)==-1){o=-1;z=1783;break}a[x]=w&255;s=s+1|0}if((z|0)==1770){a[h]=a[p]|0;A=s;break}else if((z|0)==1783){i=f;return o|0}else if((z|0)==1784){i=f;return o|0}else if((z|0)==1786){i=f;return o|0}}else{a[h]=a[g|0]|0;A=l}}while(0);do{if(e){l=a[h]|0;c[b+48>>2]=l&255;B=l}else{l=b+32|0;k=A;while(1){if((k|0)<=0){z=1777;break}j=k-1|0;if((cq(d[g+j|0]|0|0,c[l>>2]|0)|0)==-1){o=-1;z=1780;break}else{k=j}}if((z|0)==1777){B=a[h]|0;break}else if((z|0)==1780){i=f;return o|0}}}while(0);o=B&255;i=f;return o|0}function g6(){gE(0);bk(170,153536,t|0)|0;return}function g7(a){a=a|0;return}function g8(a){a=a|0;var b=0;b=a+4|0;I=c[b>>2]|0,c[b>>2]=I+1,I;return}function g9(a){a=a|0;var b=0,d=0;b=a+4|0;if(((I=c[b>>2]|0,c[b>>2]=I+ -1,I)|0)!=0){d=0;return d|0}c0[c[(c[a>>2]|0)+8>>2]&511](a);d=1;return d|0}function ha(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;c[a>>2]=136608;d=a+4|0;if((d|0)==0){return}a=oQ(b|0)|0;e=a+1|0;f=oE(a+13|0)|0;c[f+4>>2]=a;c[f>>2]=a;a=f+12|0;c[d>>2]=a;c[f+8>>2]=0;oN(a|0,b|0,e)|0;return}function hb(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=136608;b=a+4|0;d=(c[b>>2]|0)-4|0;if(((I=c[d>>2]|0,c[d>>2]=I+ -1,I)-1|0)>=0){e=a;oF(e);return}d=(c[b>>2]|0)-12|0;if((d|0)==0){e=a;oF(e);return}oG(d);e=a;oF(e);return}function hc(a){a=a|0;var b=0;c[a>>2]=136608;b=a+4|0;a=(c[b>>2]|0)-4|0;if(((I=c[a>>2]|0,c[a>>2]=I+ -1,I)-1|0)>=0){return}a=(c[b>>2]|0)-12|0;if((a|0)==0){return}oG(a);return}function hd(a){a=a|0;return c[a+4>>2]|0}function he(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;c[b>>2]=136544;e=b+4|0;if((e|0)==0){return}if((a[d]&1)==0){f=d+1|0}else{f=c[d+8>>2]|0}d=oQ(f|0)|0;b=d+1|0;g=oE(d+13|0)|0;c[g+4>>2]=d;c[g>>2]=d;d=g+12|0;c[e>>2]=d;c[g+8>>2]=0;oN(d|0,f|0,b)|0;return}function hf(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;c[a>>2]=136544;d=a+4|0;if((d|0)==0){return}a=oQ(b|0)|0;e=a+1|0;f=oE(a+13|0)|0;c[f+4>>2]=a;c[f>>2]=a;a=f+12|0;c[d>>2]=a;c[f+8>>2]=0;oN(a|0,b|0,e)|0;return}function hg(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=136544;b=a+4|0;d=(c[b>>2]|0)-4|0;if(((I=c[d>>2]|0,c[d>>2]=I+ -1,I)-1|0)>=0){e=a;oF(e);return}d=(c[b>>2]|0)-12|0;if((d|0)==0){e=a;oF(e);return}oG(d);e=a;oF(e);return}function hh(a){a=a|0;var b=0;c[a>>2]=136544;b=a+4|0;a=(c[b>>2]|0)-4|0;if(((I=c[a>>2]|0,c[a>>2]=I+ -1,I)-1|0)>=0){return}a=(c[b>>2]|0)-12|0;if((a|0)==0){return}oG(a);return}function hi(a){a=a|0;return c[a+4>>2]|0}function hj(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=136608;b=a+4|0;d=(c[b>>2]|0)-4|0;if(((I=c[d>>2]|0,c[d>>2]=I+ -1,I)-1|0)>=0){e=a;oF(e);return}d=(c[b>>2]|0)-12|0;if((d|0)==0){e=a;oF(e);return}oG(d);e=a;oF(e);return}function hk(a){a=a|0;return}function hl(a,b,d){a=a|0;b=b|0;d=d|0;c[a>>2]=d;c[a+4>>2]=b;return}function hm(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+8|0;f=e|0;dh[c[(c[a>>2]|0)+12>>2]&31](f,a,b);if((c[f+4>>2]|0)!=(c[d+4>>2]|0)){g=0;i=e;return g|0}g=(c[f>>2]|0)==(c[d>>2]|0);i=e;return g|0}function hn(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;if((c[b+4>>2]|0)!=(a|0)){e=0;return e|0}e=(c[b>>2]|0)==(d|0);return e|0}function ho(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;d=cm(e|0)|0;e=oQ(d|0)|0;if(e>>>0>4294967279>>>0){hu(0)}if(e>>>0<11>>>0){a[b]=e<<1&255;f=b+1|0;oN(f|0,d|0,e)|0;g=f+e|0;a[g]=0;return}else{h=e+16&-16;i=oD(h)|0;c[b+8>>2]=i;c[b>>2]=h|1;c[b+4>>2]=e;f=i;oN(f|0,d|0,e)|0;g=f+e|0;a[g]=0;return}}function hp(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;g=i;h=f;j=i;i=i+12|0;i=i+7&-8;k=e|0;l=c[k>>2]|0;do{if((l|0)!=0){m=d[h]|0;if((m&1|0)==0){n=m>>>1}else{n=c[f+4>>2]|0}if((n|0)==0){o=l}else{hE(f,134800,2)|0;o=c[k>>2]|0}m=c[e+4>>2]|0;dh[c[(c[m>>2]|0)+24>>2]&31](j,m,o);m=j;p=a[m]|0;if((p&1)==0){q=j+1|0}else{q=c[j+8>>2]|0}r=p&255;if((r&1|0)==0){s=r>>>1}else{s=c[j+4>>2]|0}hE(f,q,s)|0;if((a[m]&1)==0){break}oF(c[j+8>>2]|0)}}while(0);j=b;c[j>>2]=c[h>>2];c[j+4>>2]=c[h+4>>2];c[j+8>>2]=c[h+8>>2];oO(h|0,0,12);i=g;return}function hq(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;i=i+32|0;g=d;d=i;i=i+8|0;c[d>>2]=c[g>>2];c[d+4>>2]=c[g+4>>2];g=f|0;h=f+16|0;j=oQ(e|0)|0;if(j>>>0>4294967279>>>0){hu(0)}if(j>>>0<11>>>0){a[h]=j<<1&255;k=h+1|0}else{l=j+16&-16;m=oD(l)|0;c[h+8>>2]=m;c[h>>2]=l|1;c[h+4>>2]=j;k=m}oN(k|0,e|0,j)|0;a[k+j|0]=0;hp(g,d,h);he(b|0,g);if((a[g]&1)!=0){oF(c[g+8>>2]|0)}if((a[h]&1)!=0){oF(c[h+8>>2]|0)}c[b>>2]=138568;h=d;d=b+8|0;b=c[h+4>>2]|0;c[d>>2]=c[h>>2];c[d+4>>2]=b;i=f;return}function hr(a){a=a|0;hh(a|0);oF(a);return}function hs(a){a=a|0;hh(a|0);return}function ht(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;e;if((c[a>>2]|0)==1){do{a6(152536,152512)|0;}while((c[a>>2]|0)==1)}if((c[a>>2]|0)!=0){f;return}c[a>>2]=1;g;c0[d&511](b);h;c[a>>2]=-1;i;cd(152536)|0;return}function hu(a){a=a|0;a=cI(8)|0;ha(a,132352);c[a>>2]=136576;bT(a|0,142912,42)}function hv(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=d;if((a[e]&1)==0){f=b;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];return}e=c[d+8>>2]|0;f=c[d+4>>2]|0;if(f>>>0>4294967279>>>0){hu(0)}if(f>>>0<11>>>0){a[b]=f<<1&255;g=b+1|0}else{d=f+16&-16;h=oD(d)|0;c[b+8>>2]=h;c[b>>2]=d|1;c[b+4>>2]=f;g=h}oN(g|0,e|0,f)|0;a[g+f|0]=0;return}function hw(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;if(e>>>0>4294967279>>>0){hu(0)}if(e>>>0<11>>>0){a[b]=e<<1&255;f=b+1|0;oN(f|0,d|0,e)|0;g=f+e|0;a[g]=0;return}else{h=e+16&-16;i=oD(h)|0;c[b+8>>2]=i;c[b>>2]=h|1;c[b+4>>2]=e;f=i;oN(f|0,d|0,e)|0;g=f+e|0;a[g]=0;return}}function hx(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;if(d>>>0>4294967279>>>0){hu(0)}if(d>>>0<11>>>0){a[b]=d<<1&255;f=b+1|0}else{g=d+16&-16;h=oD(g)|0;c[b+8>>2]=h;c[b>>2]=g|1;c[b+4>>2]=d;f=h}oO(f|0,e|0,d|0);a[f+d|0]=0;return}function hy(b){b=b|0;if((a[b]&1)==0){return}oF(c[b+8>>2]|0);return}function hz(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;e=oQ(d|0)|0;f=b;g=b;h=a[g]|0;if((h&1)==0){i=10;j=h}else{h=c[b>>2]|0;i=(h&-2)-1|0;j=h&255}if(i>>>0<e>>>0){h=j&255;if((h&1|0)==0){k=h>>>1}else{k=c[b+4>>2]|0}hF(b,i,e-i|0,k,0,k,e,d);return b|0}if((j&1)==0){l=f+1|0}else{l=c[b+8>>2]|0}oP(l|0,d|0,e|0);a[l+e|0]=0;if((a[g]&1)==0){a[g]=e<<1&255;return b|0}else{c[b+4>>2]=e;return b|0}return 0}function hA(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;f=b;g=a[f]|0;h=g&255;if((h&1|0)==0){i=h>>>1}else{i=c[b+4>>2]|0}if(i>>>0<d>>>0){h=d-i|0;hB(b,h,e)|0;return}if((g&1)==0){a[b+1+d|0]=0;a[f]=d<<1&255;return}else{a[(c[b+8>>2]|0)+d|0]=0;c[b+4>>2]=d;return}}function hB(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;if((d|0)==0){return b|0}f=b;g=a[f]|0;if((g&1)==0){h=10;i=g}else{g=c[b>>2]|0;h=(g&-2)-1|0;i=g&255}g=i&255;if((g&1|0)==0){j=g>>>1}else{j=c[b+4>>2]|0}if((h-j|0)>>>0<d>>>0){hG(b,h,d-h+j|0,j,j,0,0);k=a[f]|0}else{k=i}if((k&1)==0){l=b+1|0}else{l=c[b+8>>2]|0}oO(l+j|0,e|0,d|0);e=j+d|0;if((a[f]&1)==0){a[f]=e<<1&255}else{c[b+4>>2]=e}a[l+e|0]=0;return b|0}function hC(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;if(d>>>0>4294967279>>>0){hu(0)}e=b;f=b;g=a[f]|0;if((g&1)==0){h=10;i=g}else{g=c[b>>2]|0;h=(g&-2)-1|0;i=g&255}g=i&255;if((g&1|0)==0){j=g>>>1}else{j=c[b+4>>2]|0}g=j>>>0>d>>>0?j:d;if(g>>>0<11>>>0){k=11}else{k=g+16&-16}g=k-1|0;if((g|0)==(h|0)){return}if((g|0)==10){l=e+1|0;m=c[b+8>>2]|0;n=1;o=0}else{if(g>>>0>h>>>0){p=oD(k)|0}else{p=oD(k)|0}h=i&1;if(h<<24>>24==0){q=e+1|0}else{q=c[b+8>>2]|0}l=p;m=q;n=h<<24>>24!=0;o=1}h=i&255;if((h&1|0)==0){r=h>>>1}else{r=c[b+4>>2]|0}h=r+1|0;oN(l|0,m|0,h)|0;if(n){oF(m)}if(o){c[b>>2]=k|1;c[b+4>>2]=j;c[b+8>>2]=l;return}else{a[f]=j<<1&255;return}}function hD(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;e=b;f=a[e]|0;if((f&1)==0){g=(f&255)>>>1;h=10}else{g=c[b+4>>2]|0;h=(c[b>>2]&-2)-1|0}if((g|0)==(h|0)){hG(b,h,1,h,h,0,0);i=a[e]|0}else{i=f}if((i&1)==0){a[e]=(g<<1)+2&255;j=b+1|0;k=g+1|0;l=j+g|0;a[l]=d;m=j+k|0;a[m]=0;return}else{e=c[b+8>>2]|0;i=g+1|0;c[b+4>>2]=i;j=e;k=i;l=j+g|0;a[l]=d;m=j+k|0;a[m]=0;return}}function hE(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;f=b;g=a[f]|0;if((g&1)==0){h=10;i=g}else{g=c[b>>2]|0;h=(g&-2)-1|0;i=g&255}g=i&255;if((g&1|0)==0){j=g>>>1}else{j=c[b+4>>2]|0}if((h-j|0)>>>0<e>>>0){hF(b,h,e-h+j|0,j,j,0,e,d);return b|0}if((e|0)==0){return b|0}if((i&1)==0){k=b+1|0}else{k=c[b+8>>2]|0}i=k+j|0;oN(i|0,d|0,e)|0;d=j+e|0;if((a[f]&1)==0){a[f]=d<<1&255}else{c[b+4>>2]=d}a[k+d|0]=0;return b|0}function hF(b,d,e,f,g,h,i,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;if((-18-d|0)>>>0<e>>>0){hu(0)}if((a[b]&1)==0){k=b+1|0}else{k=c[b+8>>2]|0}do{if(d>>>0<2147483623>>>0){l=e+d|0;m=d<<1;n=l>>>0<m>>>0?m:l;if(n>>>0<11>>>0){o=11;break}o=n+16&-16}else{o=-17}}while(0);e=oD(o)|0;if((g|0)!=0){oN(e|0,k|0,g)|0}if((i|0)!=0){n=e+g|0;oN(n|0,j|0,i)|0}j=f-h|0;if((j|0)!=(g|0)){f=j-g|0;n=e+(i+g)|0;l=k+(h+g)|0;oN(n|0,l|0,f)|0}if((d|0)==10){p=b+8|0;c[p>>2]=e;q=o|1;r=b|0;c[r>>2]=q;s=j+i|0;t=b+4|0;c[t>>2]=s;u=e+s|0;a[u]=0;return}oF(k);p=b+8|0;c[p>>2]=e;q=o|1;r=b|0;c[r>>2]=q;s=j+i|0;t=b+4|0;c[t>>2]=s;u=e+s|0;a[u]=0;return}function hG(b,d,e,f,g,h,i){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;if((-17-d|0)>>>0<e>>>0){hu(0)}if((a[b]&1)==0){j=b+1|0}else{j=c[b+8>>2]|0}do{if(d>>>0<2147483623>>>0){k=e+d|0;l=d<<1;m=k>>>0<l>>>0?l:k;if(m>>>0<11>>>0){n=11;break}n=m+16&-16}else{n=-17}}while(0);e=oD(n)|0;if((g|0)!=0){oN(e|0,j|0,g)|0}m=f-h|0;if((m|0)!=(g|0)){f=m-g|0;m=e+(i+g)|0;i=j+(h+g)|0;oN(m|0,i|0,f)|0}if((d|0)==10){o=b+8|0;c[o>>2]=e;p=n|1;q=b|0;c[q>>2]=p;return}oF(j);o=b+8|0;c[o>>2]=e;p=n|1;q=b|0;c[q>>2]=p;return}function hH(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;if(e>>>0>1073741807>>>0){hu(0)}if(e>>>0<2>>>0){a[b]=e<<1&255;f=b+4|0;g=n9(f,d,e)|0;h=f+(e<<2)|0;c[h>>2]=0;return}else{i=e+4&-4;j=oD(i<<2)|0;c[b+8>>2]=j;c[b>>2]=i|1;c[b+4>>2]=e;f=j;g=n9(f,d,e)|0;h=f+(e<<2)|0;c[h>>2]=0;return}}function hI(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;if(d>>>0>1073741807>>>0){hu(0)}if(d>>>0<2>>>0){a[b]=d<<1&255;f=b+4|0;g=ob(f,e,d)|0;h=f+(d<<2)|0;c[h>>2]=0;return}else{i=d+4&-4;j=oD(i<<2)|0;c[b+8>>2]=j;c[b>>2]=i|1;c[b+4>>2]=d;f=j;g=ob(f,e,d)|0;h=f+(d<<2)|0;c[h>>2]=0;return}}function hJ(b){b=b|0;if((a[b]&1)==0){return}oF(c[b+8>>2]|0);return}function hK(a,b){a=a|0;b=b|0;return hL(a,b,n8(b)|0)|0}function hL(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;f=b;g=a[f]|0;if((g&1)==0){h=1;i=g}else{g=c[b>>2]|0;h=(g&-2)-1|0;i=g&255}if(h>>>0<e>>>0){g=i&255;if((g&1|0)==0){j=g>>>1}else{j=c[b+4>>2]|0}hO(b,h,e-h|0,j,0,j,e,d);return b|0}if((i&1)==0){k=b+4|0}else{k=c[b+8>>2]|0}oa(k,d,e)|0;c[k+(e<<2)>>2]=0;if((a[f]&1)==0){a[f]=e<<1&255;return b|0}else{c[b+4>>2]=e;return b|0}return 0}function hM(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;if(d>>>0>1073741807>>>0){hu(0)}e=b;f=a[e]|0;if((f&1)==0){g=1;h=f}else{f=c[b>>2]|0;g=(f&-2)-1|0;h=f&255}f=h&255;if((f&1|0)==0){i=f>>>1}else{i=c[b+4>>2]|0}f=i>>>0>d>>>0?i:d;if(f>>>0<2>>>0){j=2}else{j=f+4&-4}f=j-1|0;if((f|0)==(g|0)){return}if((f|0)==1){k=b+4|0;l=c[b+8>>2]|0;m=1;n=0}else{d=j<<2;if(f>>>0>g>>>0){o=oD(d)|0}else{o=oD(d)|0}d=h&1;if(d<<24>>24==0){p=b+4|0}else{p=c[b+8>>2]|0}k=o;l=p;m=d<<24>>24!=0;n=1}d=k;k=h&255;if((k&1|0)==0){q=k>>>1}else{q=c[b+4>>2]|0}n9(d,l,q+1|0)|0;if(m){oF(l)}if(n){c[b>>2]=j|1;c[b+4>>2]=i;c[b+8>>2]=d;return}else{a[e]=i<<1&255;return}}function hN(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;e=b;f=a[e]|0;if((f&1)==0){g=(f&255)>>>1;h=1}else{g=c[b+4>>2]|0;h=(c[b>>2]&-2)-1|0}if((g|0)==(h|0)){hP(b,h,1,h,h,0,0);i=a[e]|0}else{i=f}if((i&1)==0){a[e]=(g<<1)+2&255;j=b+4|0;k=g+1|0;l=j+(g<<2)|0;c[l>>2]=d;m=j+(k<<2)|0;c[m>>2]=0;return}else{e=c[b+8>>2]|0;i=g+1|0;c[b+4>>2]=i;j=e;k=i;l=j+(g<<2)|0;c[l>>2]=d;m=j+(k<<2)|0;c[m>>2]=0;return}}function hO(b,d,e,f,g,h,i,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;if((1073741806-d|0)>>>0<e>>>0){hu(0)}if((a[b]&1)==0){k=b+4|0}else{k=c[b+8>>2]|0}do{if(d>>>0<536870887>>>0){l=e+d|0;m=d<<1;n=l>>>0<m>>>0?m:l;if(n>>>0<2>>>0){o=2;break}o=n+4&-4}else{o=1073741807}}while(0);e=oD(o<<2)|0;if((g|0)!=0){n9(e,k,g)|0}if((i|0)!=0){n=e+(g<<2)|0;n9(n,j,i)|0}j=f-h|0;if((j|0)!=(g|0)){f=j-g|0;n=e+(i+g<<2)|0;l=k+(h+g<<2)|0;n9(n,l,f)|0}if((d|0)==1){p=b+8|0;c[p>>2]=e;q=o|1;r=b|0;c[r>>2]=q;s=j+i|0;t=b+4|0;c[t>>2]=s;u=e+(s<<2)|0;c[u>>2]=0;return}oF(k);p=b+8|0;c[p>>2]=e;q=o|1;r=b|0;c[r>>2]=q;s=j+i|0;t=b+4|0;c[t>>2]=s;u=e+(s<<2)|0;c[u>>2]=0;return}function hP(b,d,e,f,g,h,i){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;if((1073741807-d|0)>>>0<e>>>0){hu(0)}if((a[b]&1)==0){j=b+4|0}else{j=c[b+8>>2]|0}do{if(d>>>0<536870887>>>0){k=e+d|0;l=d<<1;m=k>>>0<l>>>0?l:k;if(m>>>0<2>>>0){n=2;break}n=m+4&-4}else{n=1073741807}}while(0);e=oD(n<<2)|0;if((g|0)!=0){n9(e,j,g)|0}m=f-h|0;if((m|0)!=(g|0)){f=m-g|0;m=e+(i+g<<2)|0;i=j+(h+g<<2)|0;n9(m,i,f)|0}if((d|0)==1){o=b+8|0;c[o>>2]=e;p=n|1;q=b|0;c[q>>2]=p;return}oF(j);o=b+8|0;c[o>>2]=e;p=n|1;q=b|0;c[q>>2]=p;return}function hQ(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+8|0;f=e|0;g=(c[b+24>>2]|0)==0;if(g){c[b+16>>2]=d|1}else{c[b+16>>2]=d}if(((g&1|d)&c[b+20>>2]|0)==0){i=e;return}e=cI(16)|0;do{if((a[154488]|0)==0){if((bD(154488)|0)==0){break}c[36888]=138072;bk(82,147552,t|0)|0}}while(0);b=oV(147552,0,32)|0;c[f>>2]=b&0|1;c[f+4>>2]=K|0;hq(e,f,134840);c[e>>2]=137256;bT(e|0,143456,36)}function hR(a){a=a|0;var b=0,d=0,e=0,f=0;c[a>>2]=137232;b=c[a+40>>2]|0;d=a+32|0;e=a+36|0;if((b|0)!=0){f=b;do{f=f-1|0;dh[c[(c[d>>2]|0)+(f<<2)>>2]&31](0,a,c[(c[e>>2]|0)+(f<<2)>>2]|0);}while((f|0)!=0)}mf(a+28|0);oz(c[d>>2]|0);oz(c[e>>2]|0);oz(c[a+48>>2]|0);oz(c[a+60>>2]|0);return}function hS(a,b){a=a|0;b=b|0;me(a,b+28|0);return}function hT(a,b){a=a|0;b=b|0;c[a+24>>2]=b;c[a+16>>2]=(b|0)==0;c[a+20>>2]=0;c[a+4>>2]=4098;c[a+12>>2]=0;c[a+8>>2]=6;b=a+28|0;oO(a+32|0,0,40);if((b|0)==0){return}md(b);return}function hU(a){a=a|0;c[a>>2]=138304;mf(a+4|0);oF(a);return}function hV(a){a=a|0;c[a>>2]=138304;mf(a+4|0);return}function hW(a,b){a=a|0;b=b|0;return}function hX(a,b,c){a=a|0;b=b|0;c=c|0;return a|0}function hY(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;g=a;c[g>>2]=0;c[g+4>>2]=0;g=a+8|0;c[g>>2]=-1;c[g+4>>2]=-1;return}function hZ(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;e=i;b=d;d=i;i=i+16|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];b=a;c[b>>2]=0;c[b+4>>2]=0;b=a+8|0;c[b>>2]=-1;c[b+4>>2]=-1;i=e;return}function h_(a){a=a|0;return 0}function h$(a){a=a|0;return 0}function h0(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;f=b;if((e|0)<=0){g=0;return g|0}h=b+12|0;i=b+16|0;j=d;d=0;while(1){k=c[h>>2]|0;if(k>>>0<(c[i>>2]|0)>>>0){c[h>>2]=k+1;l=a[k]|0}else{k=c3[c[(c[f>>2]|0)+40>>2]&255](b)|0;if((k|0)==-1){g=d;m=2266;break}l=k&255}a[j]=l;k=d+1|0;if((k|0)<(e|0)){j=j+1|0;d=k}else{g=k;m=2265;break}}if((m|0)==2266){return g|0}else if((m|0)==2265){return g|0}return 0}function h1(a){a=a|0;return-1|0}function h2(a){a=a|0;var b=0,e=0;if((c3[c[(c[a>>2]|0)+36>>2]&255](a)|0)==-1){b=-1;return b|0}e=a+12|0;a=c[e>>2]|0;c[e>>2]=a+1;b=d[a]|0;return b|0}function h3(a,b){a=a|0;b=b|0;return-1|0}function h4(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;g=b;if((f|0)<=0){h=0;return h|0}i=b+24|0;j=b+28|0;k=0;l=e;while(1){e=c[i>>2]|0;if(e>>>0<(c[j>>2]|0)>>>0){m=a[l]|0;c[i>>2]=e+1;a[e]=m}else{if((df[c[(c[g>>2]|0)+52>>2]&31](b,d[l]|0)|0)==-1){h=k;n=2283;break}}m=k+1|0;if((m|0)<(f|0)){k=m;l=l+1|0}else{h=m;n=2281;break}}if((n|0)==2281){return h|0}else if((n|0)==2283){return h|0}return 0}function h5(a,b){a=a|0;b=b|0;return-1|0}function h6(a){a=a|0;c[a>>2]=138232;mf(a+4|0);oF(a);return}function h7(a){a=a|0;c[a>>2]=138232;mf(a+4|0);return}function h8(a,b){a=a|0;b=b|0;return}function h9(a,b,c){a=a|0;b=b|0;c=c|0;return a|0}function ia(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;g=a;c[g>>2]=0;c[g+4>>2]=0;g=a+8|0;c[g>>2]=-1;c[g+4>>2]=-1;return}function ib(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;e=i;b=d;d=i;i=i+16|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];b=a;c[b>>2]=0;c[b+4>>2]=0;b=a+8|0;c[b>>2]=-1;c[b+4>>2]=-1;i=e;return}function ic(a){a=a|0;return 0}function id(a){a=a|0;return 0}function ie(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;e=a;if((d|0)<=0){f=0;return f|0}g=a+12|0;h=a+16|0;i=b;b=0;while(1){j=c[g>>2]|0;if(j>>>0<(c[h>>2]|0)>>>0){c[g>>2]=j+4;k=c[j>>2]|0}else{j=c3[c[(c[e>>2]|0)+40>>2]&255](a)|0;if((j|0)==-1){f=b;l=2302;break}else{k=j}}c[i>>2]=k;j=b+1|0;if((j|0)<(d|0)){i=i+4|0;b=j}else{f=j;l=2301;break}}if((l|0)==2301){return f|0}else if((l|0)==2302){return f|0}return 0}function ig(a){a=a|0;return-1|0}function ih(a){a=a|0;var b=0,d=0;if((c3[c[(c[a>>2]|0)+36>>2]&255](a)|0)==-1){b=-1;return b|0}d=a+12|0;a=c[d>>2]|0;c[d>>2]=a+4;b=c[a>>2]|0;return b|0}function ii(a,b){a=a|0;b=b|0;return-1|0}function ij(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;e=a;if((d|0)<=0){f=0;return f|0}g=a+24|0;h=a+28|0;i=0;j=b;while(1){b=c[g>>2]|0;if(b>>>0<(c[h>>2]|0)>>>0){k=c[j>>2]|0;c[g>>2]=b+4;c[b>>2]=k}else{if((df[c[(c[e>>2]|0)+52>>2]&31](a,c[j>>2]|0)|0)==-1){f=i;l=2318;break}}k=i+1|0;if((k|0)<(d|0)){i=k;j=j+4|0}else{f=k;l=2319;break}}if((l|0)==2319){return f|0}else if((l|0)==2318){return f|0}return 0}function ik(a,b){a=a|0;b=b|0;return-1|0}function il(a){a=a|0;hR(a+8|0);oF(a);return}function im(a){a=a|0;hR(a+8|0);return}function io(a){a=a|0;var b=0,d=0;b=a;d=c[(c[a>>2]|0)-12>>2]|0;hR(b+(d+8)|0);oF(b+d|0);return}function ip(a){a=a|0;hR(a+((c[(c[a>>2]|0)-12>>2]|0)+8)|0);return}function iq(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+8|0;e=d|0;f=b;g=c[(c[f>>2]|0)-12>>2]|0;h=b;if((c[h+(g+24)>>2]|0)==0){i=d;return b|0}j=e|0;a[j]=0;c[e+4>>2]=b;do{if((c[h+(g+16)>>2]|0)==0){k=c[h+(g+72)>>2]|0;if((k|0)!=0){iq(k)|0}a[j]=1;k=c[h+((c[(c[f>>2]|0)-12>>2]|0)+24)>>2]|0;if((c3[c[(c[k>>2]|0)+24>>2]&255](k)|0)!=-1){break}k=c[(c[f>>2]|0)-12>>2]|0;hQ(h+k|0,c[h+(k+16)>>2]|1)}}while(0);iA(e);i=d;return b|0}function ir(a){a=a|0;hR(a+8|0);oF(a);return}function is(a){a=a|0;hR(a+8|0);return}function it(a){a=a|0;var b=0,d=0;b=a;d=c[(c[a>>2]|0)-12>>2]|0;hR(b+(d+8)|0);oF(b+d|0);return}function iu(a){a=a|0;hR(a+((c[(c[a>>2]|0)-12>>2]|0)+8)|0);return}function iv(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+8|0;e=d|0;f=b;g=c[(c[f>>2]|0)-12>>2]|0;h=b;if((c[h+(g+24)>>2]|0)==0){i=d;return b|0}j=e|0;a[j]=0;c[e+4>>2]=b;do{if((c[h+(g+16)>>2]|0)==0){k=c[h+(g+72)>>2]|0;if((k|0)!=0){iv(k)|0}a[j]=1;k=c[h+((c[(c[f>>2]|0)-12>>2]|0)+24)>>2]|0;if((c3[c[(c[k>>2]|0)+24>>2]&255](k)|0)!=-1){break}k=c[(c[f>>2]|0)-12>>2]|0;hQ(h+k|0,c[h+(k+16)>>2]|1)}}while(0);iF(e);i=d;return b|0}function iw(a){a=a|0;hR(a+4|0);oF(a);return}function ix(a){a=a|0;hR(a+4|0);return}function iy(a){a=a|0;var b=0,d=0;b=a;d=c[(c[a>>2]|0)-12>>2]|0;hR(b+(d+4)|0);oF(b+d|0);return}function iz(a){a=a|0;hR(a+((c[(c[a>>2]|0)-12>>2]|0)+4)|0);return}function iA(a){a=a|0;var b=0,d=0,e=0;b=a+4|0;a=c[b>>2]|0;d=c[(c[a>>2]|0)-12>>2]|0;e=a;if((c[e+(d+24)>>2]|0)==0){return}if((c[e+(d+16)>>2]|0)!=0){return}if((c[e+(d+4)>>2]&8192|0)==0){return}if(bI()|0){return}d=c[b>>2]|0;e=c[d+((c[(c[d>>2]|0)-12>>2]|0)+24)>>2]|0;if((c3[c[(c[e>>2]|0)+24>>2]&255](e)|0)!=-1){return}e=c[b>>2]|0;b=c[(c[e>>2]|0)-12>>2]|0;d=e;hQ(d+b|0,c[d+(b+16)>>2]|1);return}function iB(a){a=a|0;hR(a+4|0);oF(a);return}function iC(a){a=a|0;hR(a+4|0);return}function iD(a){a=a|0;var b=0,d=0;b=a;d=c[(c[a>>2]|0)-12>>2]|0;hR(b+(d+4)|0);oF(b+d|0);return}function iE(a){a=a|0;hR(a+((c[(c[a>>2]|0)-12>>2]|0)+4)|0);return}function iF(a){a=a|0;var b=0,d=0,e=0;b=a+4|0;a=c[b>>2]|0;d=c[(c[a>>2]|0)-12>>2]|0;e=a;if((c[e+(d+24)>>2]|0)==0){return}if((c[e+(d+16)>>2]|0)!=0){return}if((c[e+(d+4)>>2]&8192|0)==0){return}if(bI()|0){return}d=c[b>>2]|0;e=c[d+((c[(c[d>>2]|0)-12>>2]|0)+24)>>2]|0;if((c3[c[(c[e>>2]|0)+24>>2]&255](e)|0)!=-1){return}e=c[b>>2]|0;b=c[(c[e>>2]|0)-12>>2]|0;d=e;hQ(d+b|0,c[d+(b+16)>>2]|1);return}function iG(a){a=a|0;return 135168}function iH(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)==1){hw(a,135536,35);return}else{ho(a,b|0,c);return}}function iI(a){a=a|0;hk(a|0);return}function iJ(a){a=a|0;hs(a|0);oF(a);return}function iK(a){a=a|0;hs(a|0);return}function iL(a){a=a|0;hR(a);oF(a);return}function iM(a){a=a|0;hk(a|0);oF(a);return}function iN(a){a=a|0;g7(a|0);oF(a);return}function iO(a){a=a|0;g7(a|0);return}function iP(a){a=a|0;g7(a|0);return}function iQ(b,c,d,e,f){b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0;L2822:do{if((e|0)==(f|0)){g=c}else{b=c;h=e;while(1){if((b|0)==(d|0)){i=-1;j=2434;break}k=a[b]|0;l=a[h]|0;if(k<<24>>24<l<<24>>24){i=-1;j=2431;break}if(l<<24>>24<k<<24>>24){i=1;j=2432;break}k=b+1|0;l=h+1|0;if((l|0)==(f|0)){g=k;break L2822}else{b=k;h=l}}if((j|0)==2434){return i|0}else if((j|0)==2432){return i|0}else if((j|0)==2431){return i|0}}}while(0);i=(g|0)!=(d|0)|0;return i|0}function iR(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;d=e;g=f-d|0;if(g>>>0>4294967279>>>0){hu(b)}if(g>>>0<11>>>0){a[b]=g<<1&255;h=b+1|0}else{i=g+16&-16;j=oD(i)|0;c[b+8>>2]=j;c[b>>2]=i|1;c[b+4>>2]=g;h=j}if((e|0)==(f|0)){k=h;a[k]=0;return}j=f+(-d|0)|0;d=h;g=e;while(1){a[d]=a[g]|0;e=g+1|0;if((e|0)==(f|0)){break}else{d=d+1|0;g=e}}k=h+j|0;a[k]=0;return}function iS(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0;if((c|0)==(d|0)){e=0;return e|0}else{f=c;g=0}while(1){c=(a[f]|0)+(g<<4)|0;b=c&-268435456;h=(b>>>24|b)^c;c=f+1|0;if((c|0)==(d|0)){e=h;break}else{f=c;g=h}}return e|0}function iT(a){a=a|0;g7(a|0);oF(a);return}function iU(a){a=a|0;g7(a|0);return}function iV(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0;L2858:do{if((e|0)==(f|0)){g=b}else{a=b;h=e;while(1){if((a|0)==(d|0)){i=-1;j=2461;break}k=c[a>>2]|0;l=c[h>>2]|0;if((k|0)<(l|0)){i=-1;j=2462;break}if((l|0)<(k|0)){i=1;j=2464;break}k=a+4|0;l=h+4|0;if((l|0)==(f|0)){g=k;break L2858}else{a=k;h=l}}if((j|0)==2462){return i|0}else if((j|0)==2461){return i|0}else if((j|0)==2464){return i|0}}}while(0);i=(g|0)!=(d|0)|0;return i|0}function iW(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;d=e;g=f-d|0;h=g>>2;if(h>>>0>1073741807>>>0){hu(b)}if(h>>>0<2>>>0){a[b]=g>>>1&255;i=b+4|0}else{g=h+4&-4;j=oD(g<<2)|0;c[b+8>>2]=j;c[b>>2]=g|1;c[b+4>>2]=h;i=j}if((e|0)==(f|0)){k=i;c[k>>2]=0;return}j=(f-4+(-d|0)|0)>>>2;d=i;h=e;while(1){c[d>>2]=c[h>>2];e=h+4|0;if((e|0)==(f|0)){break}else{d=d+4|0;h=e}}k=i+(j+1<<2)|0;c[k>>2]=0;return}function iX(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;if((b|0)==(d|0)){e=0;return e|0}else{f=b;g=0}while(1){b=(c[f>>2]|0)+(g<<4)|0;a=b&-268435456;h=(a>>>24|a)^b;b=f+4|0;if((b|0)==(d|0)){e=h;break}else{f=b;g=h}}return e|0}function iY(a){a=a|0;g7(a|0);oF(a);return}function iZ(a){a=a|0;g7(a|0);return}function i_(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;k=i;i=i+112|0;l=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[l>>2];l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=k|0;m=k+16|0;n=k+32|0;o=k+40|0;p=k+48|0;q=k+56|0;r=k+64|0;s=k+72|0;t=k+80|0;u=k+104|0;if((c[g+4>>2]&1|0)==0){c[n>>2]=-1;v=c[(c[d>>2]|0)+16>>2]|0;w=e|0;c[p>>2]=c[w>>2];c[q>>2]=c[f>>2];da[v&127](o,d,p,q,g,h,n);q=c[o>>2]|0;c[w>>2]=q;w=c[n>>2]|0;if((w|0)==0){a[j]=0}else if((w|0)==1){a[j]=1}else{a[j]=1;c[h>>2]=4}c[b>>2]=q;i=k;return}hS(r,g);q=r|0;r=c[q>>2]|0;if((c[38272]|0)!=-1){c[m>>2]=153088;c[m+4>>2]=14;c[m+8>>2]=0;ht(153088,m,114)}m=(c[38273]|0)-1|0;w=c[r+8>>2]|0;do{if((c[r+12>>2]|0)-w>>2>>>0>m>>>0){n=c[w+(m<<2)>>2]|0;if((n|0)==0){break}o=n;n=c[q>>2]|0;g9(n)|0;hS(s,g);n=s|0;p=c[n>>2]|0;if((c[38176]|0)!=-1){c[l>>2]=152704;c[l+4>>2]=14;c[l+8>>2]=0;ht(152704,l,114)}d=(c[38177]|0)-1|0;v=c[p+8>>2]|0;do{if((c[p+12>>2]|0)-v>>2>>>0>d>>>0){x=c[v+(d<<2)>>2]|0;if((x|0)==0){break}y=x;z=c[n>>2]|0;g9(z)|0;z=t|0;A=x;c1[c[(c[A>>2]|0)+24>>2]&127](z,y);c1[c[(c[A>>2]|0)+28>>2]&127](t+12|0,y);c[u>>2]=c[f>>2];a[j]=(i$(e,u,z,t+24|0,o,h,1)|0)==(z|0)|0;c[b>>2]=c[e>>2];hy(t+12|0);hy(t|0);i=k;return}}while(0);o=cI(4)|0;od(o);bT(o|0,142880,164)}}while(0);k=cI(4)|0;od(k);bT(k|0,142880,164)}function i$(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0;l=i;i=i+104|0;m=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[m>>2];m=(g-f|0)/12|0;n=l|0;do{if(m>>>0>100>>>0){o=oy(m)|0;if((o|0)!=0){p=o;q=o;break}oK();p=0;q=0}else{p=n;q=0}}while(0);n=(f|0)==(g|0);if(n){r=m;s=0}else{o=m;m=0;t=p;u=f;while(1){v=d[u]|0;if((v&1|0)==0){w=v>>>1}else{w=c[u+4>>2]|0}if((w|0)==0){a[t]=2;x=m+1|0;y=o-1|0}else{a[t]=1;x=m;y=o}v=u+12|0;if((v|0)==(g|0)){r=y;s=x;break}else{o=y;m=x;t=t+1|0;u=v}}}u=b|0;b=e|0;e=h;t=0;x=s;s=r;while(1){r=c[u>>2]|0;do{if((r|0)==0){z=0}else{if((c[r+12>>2]|0)!=(c[r+16>>2]|0)){z=r;break}if((c3[c[(c[r>>2]|0)+36>>2]&255](r)|0)==-1){c[u>>2]=0;z=0;break}else{z=c[u>>2]|0;break}}}while(0);r=(z|0)==0;m=c[b>>2]|0;if((m|0)==0){A=z;B=0}else{do{if((c[m+12>>2]|0)==(c[m+16>>2]|0)){if((c3[c[(c[m>>2]|0)+36>>2]&255](m)|0)!=-1){C=m;break}c[b>>2]=0;C=0}else{C=m}}while(0);A=c[u>>2]|0;B=C}D=(B|0)==0;if(!((r^D)&(s|0)!=0)){break}m=c[A+12>>2]|0;if((m|0)==(c[A+16>>2]|0)){E=(c3[c[(c[A>>2]|0)+36>>2]&255](A)|0)&255}else{E=a[m]|0}if(k){F=E}else{F=df[c[(c[e>>2]|0)+12>>2]&31](h,E)|0}do{if(n){G=x;H=s}else{m=t+1|0;L2969:do{if(k){y=s;o=x;w=p;v=0;I=f;while(1){do{if((a[w]|0)==1){J=I;if((a[J]&1)==0){K=I+1|0}else{K=c[I+8>>2]|0}if(F<<24>>24!=(a[K+t|0]|0)){a[w]=0;L=v;M=o;N=y-1|0;break}O=d[J]|0;if((O&1|0)==0){P=O>>>1}else{P=c[I+4>>2]|0}if((P|0)!=(m|0)){L=1;M=o;N=y;break}a[w]=2;L=1;M=o+1|0;N=y-1|0}else{L=v;M=o;N=y}}while(0);O=I+12|0;if((O|0)==(g|0)){Q=N;R=M;S=L;break L2969}y=N;o=M;w=w+1|0;v=L;I=O}}else{I=s;v=x;w=p;o=0;y=f;while(1){do{if((a[w]|0)==1){O=y;if((a[O]&1)==0){T=y+1|0}else{T=c[y+8>>2]|0}if(F<<24>>24!=(df[c[(c[e>>2]|0)+12>>2]&31](h,a[T+t|0]|0)|0)<<24>>24){a[w]=0;U=o;V=v;W=I-1|0;break}J=d[O]|0;if((J&1|0)==0){X=J>>>1}else{X=c[y+4>>2]|0}if((X|0)!=(m|0)){U=1;V=v;W=I;break}a[w]=2;U=1;V=v+1|0;W=I-1|0}else{U=o;V=v;W=I}}while(0);J=y+12|0;if((J|0)==(g|0)){Q=W;R=V;S=U;break L2969}I=W;v=V;w=w+1|0;o=U;y=J}}}while(0);if(!S){G=R;H=Q;break}m=c[u>>2]|0;y=m+12|0;o=c[y>>2]|0;if((o|0)==(c[m+16>>2]|0)){w=c[(c[m>>2]|0)+40>>2]|0;c3[w&255](m)|0}else{c[y>>2]=o+1}if((R+Q|0)>>>0<2>>>0|n){G=R;H=Q;break}o=t+1|0;y=R;m=p;w=f;while(1){do{if((a[m]|0)==2){v=d[w]|0;if((v&1|0)==0){Y=v>>>1}else{Y=c[w+4>>2]|0}if((Y|0)==(o|0)){Z=y;break}a[m]=0;Z=y-1|0}else{Z=y}}while(0);v=w+12|0;if((v|0)==(g|0)){G=Z;H=Q;break}else{y=Z;m=m+1|0;w=v}}}}while(0);t=t+1|0;x=G;s=H}do{if((A|0)==0){_=0}else{if((c[A+12>>2]|0)!=(c[A+16>>2]|0)){_=A;break}if((c3[c[(c[A>>2]|0)+36>>2]&255](A)|0)==-1){c[u>>2]=0;_=0;break}else{_=c[u>>2]|0;break}}}while(0);u=(_|0)==0;do{if(D){$=2607}else{if((c[B+12>>2]|0)!=(c[B+16>>2]|0)){if(u){break}else{$=2609;break}}if((c3[c[(c[B>>2]|0)+36>>2]&255](B)|0)==-1){c[b>>2]=0;$=2607;break}else{if(u^(B|0)==0){break}else{$=2609;break}}}}while(0);if(($|0)==2607){if(u){$=2609}}if(($|0)==2609){c[j>>2]=c[j>>2]|2}L3048:do{if(n){$=2614}else{u=f;B=p;while(1){if((a[B]|0)==2){aa=u;break L3048}b=u+12|0;if((b|0)==(g|0)){$=2614;break L3048}u=b;B=B+1|0}}}while(0);if(($|0)==2614){c[j>>2]=c[j>>2]|4;aa=g}if((q|0)==0){i=l;return aa|0}oz(q);i=l;return aa|0}function i0(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];i1(a,0,j,k,f,g,h);i=b;return}function i1(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0;e=i;i=i+72|0;l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[l>>2];l=e|0;m=e+32|0;n=e+40|0;o=e+56|0;p=o;q=i;i=i+4|0;i=i+7&-8;r=i;i=i+160|0;s=i;i=i+4|0;i=i+7&-8;t=i;i=i+4|0;i=i+7&-8;u=c[h+4>>2]&74;if((u|0)==0){v=0}else if((u|0)==8){v=16}else if((u|0)==64){v=8}else{v=10}u=l|0;jJ(n,h,u,m);oO(p|0,0,12);h=o;hA(o,10,0);if((a[p]&1)==0){l=h+1|0;w=l;x=l;y=o+8|0}else{l=o+8|0;w=c[l>>2]|0;x=h+1|0;y=l}c[q>>2]=w;l=r|0;c[s>>2]=l;c[t>>2]=0;h=f|0;f=g|0;g=o|0;z=o+4|0;A=a[m]|0;m=w;w=c[h>>2]|0;L3072:while(1){do{if((w|0)==0){B=0}else{if((c[w+12>>2]|0)!=(c[w+16>>2]|0)){B=w;break}if((c3[c[(c[w>>2]|0)+36>>2]&255](w)|0)!=-1){B=w;break}c[h>>2]=0;B=0}}while(0);C=(B|0)==0;D=c[f>>2]|0;do{if((D|0)==0){E=2642}else{if((c[D+12>>2]|0)!=(c[D+16>>2]|0)){if(C){F=D;G=0;break}else{H=m;I=D;J=0;break L3072}}if((c3[c[(c[D>>2]|0)+36>>2]&255](D)|0)==-1){c[f>>2]=0;E=2642;break}else{K=(D|0)==0;if(C^K){F=D;G=K;break}else{H=m;I=D;J=K;break L3072}}}}while(0);if((E|0)==2642){E=0;if(C){H=m;I=0;J=1;break}else{F=0;G=1}}D=d[p]|0;K=(D&1|0)==0;if(((c[q>>2]|0)-m|0)==((K?D>>>1:c[z>>2]|0)|0)){if(K){L=D>>>1;M=D>>>1}else{D=c[z>>2]|0;L=D;M=D}hA(o,L<<1,0);if((a[p]&1)==0){N=10}else{N=(c[g>>2]&-2)-1|0}hA(o,N,0);if((a[p]&1)==0){O=x}else{O=c[y>>2]|0}c[q>>2]=O+M;P=O}else{P=m}D=B+12|0;K=c[D>>2]|0;Q=B+16|0;if((K|0)==(c[Q>>2]|0)){R=(c3[c[(c[B>>2]|0)+36>>2]&255](B)|0)&255}else{R=a[K]|0}if((jj(R,v,P,q,t,A,n,l,s,u)|0)!=0){H=P;I=F;J=G;break}K=c[D>>2]|0;if((K|0)==(c[Q>>2]|0)){Q=c[(c[B>>2]|0)+40>>2]|0;c3[Q&255](B)|0;m=P;w=B;continue}else{c[D>>2]=K+1;m=P;w=B;continue}}w=d[n]|0;if((w&1|0)==0){S=w>>>1}else{S=c[n+4>>2]|0}do{if((S|0)!=0){w=c[s>>2]|0;if((w-r|0)>=160){break}P=c[t>>2]|0;c[s>>2]=w+4;c[w>>2]=P}}while(0);c[k>>2]=nT(H,c[q>>2]|0,j,v)|0;lD(n,l,c[s>>2]|0,j);do{if(C){T=0}else{if((c[B+12>>2]|0)!=(c[B+16>>2]|0)){T=B;break}if((c3[c[(c[B>>2]|0)+36>>2]&255](B)|0)!=-1){T=B;break}c[h>>2]=0;T=0}}while(0);h=(T|0)==0;L3132:do{if(J){E=2683}else{do{if((c[I+12>>2]|0)==(c[I+16>>2]|0)){if((c3[c[(c[I>>2]|0)+36>>2]&255](I)|0)!=-1){break}c[f>>2]=0;E=2683;break L3132}}while(0);if(!(h^(I|0)==0)){break}U=b|0;c[U>>2]=T;hy(o);hy(n);i=e;return}}while(0);do{if((E|0)==2683){if(h){break}U=b|0;c[U>>2]=T;hy(o);hy(n);i=e;return}}while(0);c[j>>2]=c[j>>2]|2;U=b|0;c[U>>2]=T;hy(o);hy(n);i=e;return}function i2(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];i3(a,0,j,k,f,g,h);i=b;return}function i3(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0;e=i;i=i+72|0;l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[l>>2];l=e|0;m=e+32|0;n=e+40|0;o=e+56|0;p=o;q=i;i=i+4|0;i=i+7&-8;r=i;i=i+160|0;s=i;i=i+4|0;i=i+7&-8;t=i;i=i+4|0;i=i+7&-8;u=c[h+4>>2]&74;if((u|0)==8){v=16}else if((u|0)==0){v=0}else if((u|0)==64){v=8}else{v=10}u=l|0;jJ(n,h,u,m);oO(p|0,0,12);h=o;hA(o,10,0);if((a[p]&1)==0){l=h+1|0;w=l;x=l;y=o+8|0}else{l=o+8|0;w=c[l>>2]|0;x=h+1|0;y=l}c[q>>2]=w;l=r|0;c[s>>2]=l;c[t>>2]=0;h=f|0;f=g|0;g=o|0;z=o+4|0;A=a[m]|0;m=w;w=c[h>>2]|0;L3157:while(1){do{if((w|0)==0){B=0}else{if((c[w+12>>2]|0)!=(c[w+16>>2]|0)){B=w;break}if((c3[c[(c[w>>2]|0)+36>>2]&255](w)|0)!=-1){B=w;break}c[h>>2]=0;B=0}}while(0);C=(B|0)==0;D=c[f>>2]|0;do{if((D|0)==0){E=2711}else{if((c[D+12>>2]|0)!=(c[D+16>>2]|0)){if(C){F=D;G=0;break}else{H=m;I=D;J=0;break L3157}}if((c3[c[(c[D>>2]|0)+36>>2]&255](D)|0)==-1){c[f>>2]=0;E=2711;break}else{L=(D|0)==0;if(C^L){F=D;G=L;break}else{H=m;I=D;J=L;break L3157}}}}while(0);if((E|0)==2711){E=0;if(C){H=m;I=0;J=1;break}else{F=0;G=1}}D=d[p]|0;L=(D&1|0)==0;if(((c[q>>2]|0)-m|0)==((L?D>>>1:c[z>>2]|0)|0)){if(L){M=D>>>1;N=D>>>1}else{D=c[z>>2]|0;M=D;N=D}hA(o,M<<1,0);if((a[p]&1)==0){O=10}else{O=(c[g>>2]&-2)-1|0}hA(o,O,0);if((a[p]&1)==0){P=x}else{P=c[y>>2]|0}c[q>>2]=P+N;Q=P}else{Q=m}D=B+12|0;L=c[D>>2]|0;R=B+16|0;if((L|0)==(c[R>>2]|0)){S=(c3[c[(c[B>>2]|0)+36>>2]&255](B)|0)&255}else{S=a[L]|0}if((jj(S,v,Q,q,t,A,n,l,s,u)|0)!=0){H=Q;I=F;J=G;break}L=c[D>>2]|0;if((L|0)==(c[R>>2]|0)){R=c[(c[B>>2]|0)+40>>2]|0;c3[R&255](B)|0;m=Q;w=B;continue}else{c[D>>2]=L+1;m=Q;w=B;continue}}w=d[n]|0;if((w&1|0)==0){T=w>>>1}else{T=c[n+4>>2]|0}do{if((T|0)!=0){w=c[s>>2]|0;if((w-r|0)>=160){break}Q=c[t>>2]|0;c[s>>2]=w+4;c[w>>2]=Q}}while(0);t=nS(H,c[q>>2]|0,j,v)|0;c[k>>2]=t;c[k+4>>2]=K;lD(n,l,c[s>>2]|0,j);do{if(C){U=0}else{if((c[B+12>>2]|0)!=(c[B+16>>2]|0)){U=B;break}if((c3[c[(c[B>>2]|0)+36>>2]&255](B)|0)!=-1){U=B;break}c[h>>2]=0;U=0}}while(0);h=(U|0)==0;L3217:do{if(J){E=2752}else{do{if((c[I+12>>2]|0)==(c[I+16>>2]|0)){if((c3[c[(c[I>>2]|0)+36>>2]&255](I)|0)!=-1){break}c[f>>2]=0;E=2752;break L3217}}while(0);if(!(h^(I|0)==0)){break}V=b|0;c[V>>2]=U;hy(o);hy(n);i=e;return}}while(0);do{if((E|0)==2752){if(h){break}V=b|0;c[V>>2]=U;hy(o);hy(n);i=e;return}}while(0);c[j>>2]=c[j>>2]|2;V=b|0;c[V>>2]=U;hy(o);hy(n);i=e;return}function i4(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];i5(a,0,j,k,f,g,h);i=b;return}function i5(e,f,g,h,j,k,l){e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0;f=i;i=i+72|0;m=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[m>>2];m=h;h=i;i=i+4|0;i=i+7&-8;c[h>>2]=c[m>>2];m=f|0;n=f+32|0;o=f+40|0;p=f+56|0;q=p;r=i;i=i+4|0;i=i+7&-8;s=i;i=i+160|0;t=i;i=i+4|0;i=i+7&-8;u=i;i=i+4|0;i=i+7&-8;v=c[j+4>>2]&74;if((v|0)==0){w=0}else if((v|0)==8){w=16}else if((v|0)==64){w=8}else{w=10}v=m|0;jJ(o,j,v,n);oO(q|0,0,12);j=p;hA(p,10,0);if((a[q]&1)==0){m=j+1|0;x=m;y=m;z=p+8|0}else{m=p+8|0;x=c[m>>2]|0;y=j+1|0;z=m}c[r>>2]=x;m=s|0;c[t>>2]=m;c[u>>2]=0;j=g|0;g=h|0;h=p|0;A=p+4|0;B=a[n]|0;n=x;x=c[j>>2]|0;L3242:while(1){do{if((x|0)==0){C=0}else{if((c[x+12>>2]|0)!=(c[x+16>>2]|0)){C=x;break}if((c3[c[(c[x>>2]|0)+36>>2]&255](x)|0)!=-1){C=x;break}c[j>>2]=0;C=0}}while(0);D=(C|0)==0;E=c[g>>2]|0;do{if((E|0)==0){F=2780}else{if((c[E+12>>2]|0)!=(c[E+16>>2]|0)){if(D){G=E;H=0;break}else{I=n;J=E;K=0;break L3242}}if((c3[c[(c[E>>2]|0)+36>>2]&255](E)|0)==-1){c[g>>2]=0;F=2780;break}else{L=(E|0)==0;if(D^L){G=E;H=L;break}else{I=n;J=E;K=L;break L3242}}}}while(0);if((F|0)==2780){F=0;if(D){I=n;J=0;K=1;break}else{G=0;H=1}}E=d[q]|0;L=(E&1|0)==0;if(((c[r>>2]|0)-n|0)==((L?E>>>1:c[A>>2]|0)|0)){if(L){M=E>>>1;N=E>>>1}else{E=c[A>>2]|0;M=E;N=E}hA(p,M<<1,0);if((a[q]&1)==0){O=10}else{O=(c[h>>2]&-2)-1|0}hA(p,O,0);if((a[q]&1)==0){P=y}else{P=c[z>>2]|0}c[r>>2]=P+N;Q=P}else{Q=n}E=C+12|0;L=c[E>>2]|0;R=C+16|0;if((L|0)==(c[R>>2]|0)){S=(c3[c[(c[C>>2]|0)+36>>2]&255](C)|0)&255}else{S=a[L]|0}if((jj(S,w,Q,r,u,B,o,m,t,v)|0)!=0){I=Q;J=G;K=H;break}L=c[E>>2]|0;if((L|0)==(c[R>>2]|0)){R=c[(c[C>>2]|0)+40>>2]|0;c3[R&255](C)|0;n=Q;x=C;continue}else{c[E>>2]=L+1;n=Q;x=C;continue}}x=d[o]|0;if((x&1|0)==0){T=x>>>1}else{T=c[o+4>>2]|0}do{if((T|0)!=0){x=c[t>>2]|0;if((x-s|0)>=160){break}Q=c[u>>2]|0;c[t>>2]=x+4;c[x>>2]=Q}}while(0);b[l>>1]=nR(I,c[r>>2]|0,k,w)|0;lD(o,m,c[t>>2]|0,k);do{if(D){U=0}else{if((c[C+12>>2]|0)!=(c[C+16>>2]|0)){U=C;break}if((c3[c[(c[C>>2]|0)+36>>2]&255](C)|0)!=-1){U=C;break}c[j>>2]=0;U=0}}while(0);j=(U|0)==0;L3302:do{if(K){F=2821}else{do{if((c[J+12>>2]|0)==(c[J+16>>2]|0)){if((c3[c[(c[J>>2]|0)+36>>2]&255](J)|0)!=-1){break}c[g>>2]=0;F=2821;break L3302}}while(0);if(!(j^(J|0)==0)){break}V=e|0;c[V>>2]=U;hy(p);hy(o);i=f;return}}while(0);do{if((F|0)==2821){if(j){break}V=e|0;c[V>>2]=U;hy(p);hy(o);i=f;return}}while(0);c[k>>2]=c[k>>2]|2;V=e|0;c[V>>2]=U;hy(p);hy(o);i=f;return}function i6(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];i7(a,0,j,k,f,g,h);i=b;return}function i7(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0;e=i;i=i+72|0;l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[l>>2];l=e|0;m=e+32|0;n=e+40|0;o=e+56|0;p=o;q=i;i=i+4|0;i=i+7&-8;r=i;i=i+160|0;s=i;i=i+4|0;i=i+7&-8;t=i;i=i+4|0;i=i+7&-8;u=c[h+4>>2]&74;if((u|0)==8){v=16}else if((u|0)==0){v=0}else if((u|0)==64){v=8}else{v=10}u=l|0;jJ(n,h,u,m);oO(p|0,0,12);h=o;hA(o,10,0);if((a[p]&1)==0){l=h+1|0;w=l;x=l;y=o+8|0}else{l=o+8|0;w=c[l>>2]|0;x=h+1|0;y=l}c[q>>2]=w;l=r|0;c[s>>2]=l;c[t>>2]=0;h=f|0;f=g|0;g=o|0;z=o+4|0;A=a[m]|0;m=w;w=c[h>>2]|0;L3327:while(1){do{if((w|0)==0){B=0}else{if((c[w+12>>2]|0)!=(c[w+16>>2]|0)){B=w;break}if((c3[c[(c[w>>2]|0)+36>>2]&255](w)|0)!=-1){B=w;break}c[h>>2]=0;B=0}}while(0);C=(B|0)==0;D=c[f>>2]|0;do{if((D|0)==0){E=2849}else{if((c[D+12>>2]|0)!=(c[D+16>>2]|0)){if(C){F=D;G=0;break}else{H=m;I=D;J=0;break L3327}}if((c3[c[(c[D>>2]|0)+36>>2]&255](D)|0)==-1){c[f>>2]=0;E=2849;break}else{K=(D|0)==0;if(C^K){F=D;G=K;break}else{H=m;I=D;J=K;break L3327}}}}while(0);if((E|0)==2849){E=0;if(C){H=m;I=0;J=1;break}else{F=0;G=1}}D=d[p]|0;K=(D&1|0)==0;if(((c[q>>2]|0)-m|0)==((K?D>>>1:c[z>>2]|0)|0)){if(K){L=D>>>1;M=D>>>1}else{D=c[z>>2]|0;L=D;M=D}hA(o,L<<1,0);if((a[p]&1)==0){N=10}else{N=(c[g>>2]&-2)-1|0}hA(o,N,0);if((a[p]&1)==0){O=x}else{O=c[y>>2]|0}c[q>>2]=O+M;P=O}else{P=m}D=B+12|0;K=c[D>>2]|0;Q=B+16|0;if((K|0)==(c[Q>>2]|0)){R=(c3[c[(c[B>>2]|0)+36>>2]&255](B)|0)&255}else{R=a[K]|0}if((jj(R,v,P,q,t,A,n,l,s,u)|0)!=0){H=P;I=F;J=G;break}K=c[D>>2]|0;if((K|0)==(c[Q>>2]|0)){Q=c[(c[B>>2]|0)+40>>2]|0;c3[Q&255](B)|0;m=P;w=B;continue}else{c[D>>2]=K+1;m=P;w=B;continue}}w=d[n]|0;if((w&1|0)==0){S=w>>>1}else{S=c[n+4>>2]|0}do{if((S|0)!=0){w=c[s>>2]|0;if((w-r|0)>=160){break}P=c[t>>2]|0;c[s>>2]=w+4;c[w>>2]=P}}while(0);c[k>>2]=nQ(H,c[q>>2]|0,j,v)|0;lD(n,l,c[s>>2]|0,j);do{if(C){T=0}else{if((c[B+12>>2]|0)!=(c[B+16>>2]|0)){T=B;break}if((c3[c[(c[B>>2]|0)+36>>2]&255](B)|0)!=-1){T=B;break}c[h>>2]=0;T=0}}while(0);h=(T|0)==0;L3387:do{if(J){E=2890}else{do{if((c[I+12>>2]|0)==(c[I+16>>2]|0)){if((c3[c[(c[I>>2]|0)+36>>2]&255](I)|0)!=-1){break}c[f>>2]=0;E=2890;break L3387}}while(0);if(!(h^(I|0)==0)){break}U=b|0;c[U>>2]=T;hy(o);hy(n);i=e;return}}while(0);do{if((E|0)==2890){if(h){break}U=b|0;c[U>>2]=T;hy(o);hy(n);i=e;return}}while(0);c[j>>2]=c[j>>2]|2;U=b|0;c[U>>2]=T;hy(o);hy(n);i=e;return}function i8(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];i9(a,0,j,k,f,g,h);i=b;return}function i9(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0;e=i;i=i+72|0;l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[l>>2];l=e|0;m=e+32|0;n=e+40|0;o=e+56|0;p=o;q=i;i=i+4|0;i=i+7&-8;r=i;i=i+160|0;s=i;i=i+4|0;i=i+7&-8;t=i;i=i+4|0;i=i+7&-8;u=c[h+4>>2]&74;if((u|0)==8){v=16}else if((u|0)==0){v=0}else if((u|0)==64){v=8}else{v=10}u=l|0;jJ(n,h,u,m);oO(p|0,0,12);h=o;hA(o,10,0);if((a[p]&1)==0){l=h+1|0;w=l;x=l;y=o+8|0}else{l=o+8|0;w=c[l>>2]|0;x=h+1|0;y=l}c[q>>2]=w;l=r|0;c[s>>2]=l;c[t>>2]=0;h=f|0;f=g|0;g=o|0;z=o+4|0;A=a[m]|0;m=w;w=c[h>>2]|0;L3412:while(1){do{if((w|0)==0){B=0}else{if((c[w+12>>2]|0)!=(c[w+16>>2]|0)){B=w;break}if((c3[c[(c[w>>2]|0)+36>>2]&255](w)|0)!=-1){B=w;break}c[h>>2]=0;B=0}}while(0);C=(B|0)==0;D=c[f>>2]|0;do{if((D|0)==0){E=2918}else{if((c[D+12>>2]|0)!=(c[D+16>>2]|0)){if(C){F=D;G=0;break}else{H=m;I=D;J=0;break L3412}}if((c3[c[(c[D>>2]|0)+36>>2]&255](D)|0)==-1){c[f>>2]=0;E=2918;break}else{K=(D|0)==0;if(C^K){F=D;G=K;break}else{H=m;I=D;J=K;break L3412}}}}while(0);if((E|0)==2918){E=0;if(C){H=m;I=0;J=1;break}else{F=0;G=1}}D=d[p]|0;K=(D&1|0)==0;if(((c[q>>2]|0)-m|0)==((K?D>>>1:c[z>>2]|0)|0)){if(K){L=D>>>1;M=D>>>1}else{D=c[z>>2]|0;L=D;M=D}hA(o,L<<1,0);if((a[p]&1)==0){N=10}else{N=(c[g>>2]&-2)-1|0}hA(o,N,0);if((a[p]&1)==0){O=x}else{O=c[y>>2]|0}c[q>>2]=O+M;P=O}else{P=m}D=B+12|0;K=c[D>>2]|0;Q=B+16|0;if((K|0)==(c[Q>>2]|0)){R=(c3[c[(c[B>>2]|0)+36>>2]&255](B)|0)&255}else{R=a[K]|0}if((jj(R,v,P,q,t,A,n,l,s,u)|0)!=0){H=P;I=F;J=G;break}K=c[D>>2]|0;if((K|0)==(c[Q>>2]|0)){Q=c[(c[B>>2]|0)+40>>2]|0;c3[Q&255](B)|0;m=P;w=B;continue}else{c[D>>2]=K+1;m=P;w=B;continue}}w=d[n]|0;if((w&1|0)==0){S=w>>>1}else{S=c[n+4>>2]|0}do{if((S|0)!=0){w=c[s>>2]|0;if((w-r|0)>=160){break}P=c[t>>2]|0;c[s>>2]=w+4;c[w>>2]=P}}while(0);c[k>>2]=nP(H,c[q>>2]|0,j,v)|0;lD(n,l,c[s>>2]|0,j);do{if(C){T=0}else{if((c[B+12>>2]|0)!=(c[B+16>>2]|0)){T=B;break}if((c3[c[(c[B>>2]|0)+36>>2]&255](B)|0)!=-1){T=B;break}c[h>>2]=0;T=0}}while(0);h=(T|0)==0;L3472:do{if(J){E=2959}else{do{if((c[I+12>>2]|0)==(c[I+16>>2]|0)){if((c3[c[(c[I>>2]|0)+36>>2]&255](I)|0)!=-1){break}c[f>>2]=0;E=2959;break L3472}}while(0);if(!(h^(I|0)==0)){break}U=b|0;c[U>>2]=T;hy(o);hy(n);i=e;return}}while(0);do{if((E|0)==2959){if(h){break}U=b|0;c[U>>2]=T;hy(o);hy(n);i=e;return}}while(0);c[j>>2]=c[j>>2]|2;U=b|0;c[U>>2]=T;hy(o);hy(n);i=e;return}function ja(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];jb(a,0,j,k,f,g,h);i=b;return}function jb(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0;e=i;i=i+72|0;l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[l>>2];l=e|0;m=e+32|0;n=e+40|0;o=e+56|0;p=o;q=i;i=i+4|0;i=i+7&-8;r=i;i=i+160|0;s=i;i=i+4|0;i=i+7&-8;t=i;i=i+4|0;i=i+7&-8;u=c[h+4>>2]&74;if((u|0)==8){v=16}else if((u|0)==0){v=0}else if((u|0)==64){v=8}else{v=10}u=l|0;jJ(n,h,u,m);oO(p|0,0,12);h=o;hA(o,10,0);if((a[p]&1)==0){l=h+1|0;w=l;x=l;y=o+8|0}else{l=o+8|0;w=c[l>>2]|0;x=h+1|0;y=l}c[q>>2]=w;l=r|0;c[s>>2]=l;c[t>>2]=0;h=f|0;f=g|0;g=o|0;z=o+4|0;A=a[m]|0;m=w;w=c[h>>2]|0;L3497:while(1){do{if((w|0)==0){B=0}else{if((c[w+12>>2]|0)!=(c[w+16>>2]|0)){B=w;break}if((c3[c[(c[w>>2]|0)+36>>2]&255](w)|0)!=-1){B=w;break}c[h>>2]=0;B=0}}while(0);C=(B|0)==0;D=c[f>>2]|0;do{if((D|0)==0){E=2987}else{if((c[D+12>>2]|0)!=(c[D+16>>2]|0)){if(C){F=D;G=0;break}else{H=m;I=D;J=0;break L3497}}if((c3[c[(c[D>>2]|0)+36>>2]&255](D)|0)==-1){c[f>>2]=0;E=2987;break}else{L=(D|0)==0;if(C^L){F=D;G=L;break}else{H=m;I=D;J=L;break L3497}}}}while(0);if((E|0)==2987){E=0;if(C){H=m;I=0;J=1;break}else{F=0;G=1}}D=d[p]|0;L=(D&1|0)==0;if(((c[q>>2]|0)-m|0)==((L?D>>>1:c[z>>2]|0)|0)){if(L){M=D>>>1;N=D>>>1}else{D=c[z>>2]|0;M=D;N=D}hA(o,M<<1,0);if((a[p]&1)==0){O=10}else{O=(c[g>>2]&-2)-1|0}hA(o,O,0);if((a[p]&1)==0){P=x}else{P=c[y>>2]|0}c[q>>2]=P+N;Q=P}else{Q=m}D=B+12|0;L=c[D>>2]|0;R=B+16|0;if((L|0)==(c[R>>2]|0)){S=(c3[c[(c[B>>2]|0)+36>>2]&255](B)|0)&255}else{S=a[L]|0}if((jj(S,v,Q,q,t,A,n,l,s,u)|0)!=0){H=Q;I=F;J=G;break}L=c[D>>2]|0;if((L|0)==(c[R>>2]|0)){R=c[(c[B>>2]|0)+40>>2]|0;c3[R&255](B)|0;m=Q;w=B;continue}else{c[D>>2]=L+1;m=Q;w=B;continue}}w=d[n]|0;if((w&1|0)==0){T=w>>>1}else{T=c[n+4>>2]|0}do{if((T|0)!=0){w=c[s>>2]|0;if((w-r|0)>=160){break}Q=c[t>>2]|0;c[s>>2]=w+4;c[w>>2]=Q}}while(0);t=nO(H,c[q>>2]|0,j,v)|0;c[k>>2]=t;c[k+4>>2]=K;lD(n,l,c[s>>2]|0,j);do{if(C){U=0}else{if((c[B+12>>2]|0)!=(c[B+16>>2]|0)){U=B;break}if((c3[c[(c[B>>2]|0)+36>>2]&255](B)|0)!=-1){U=B;break}c[h>>2]=0;U=0}}while(0);h=(U|0)==0;L3557:do{if(J){E=3028}else{do{if((c[I+12>>2]|0)==(c[I+16>>2]|0)){if((c3[c[(c[I>>2]|0)+36>>2]&255](I)|0)!=-1){break}c[f>>2]=0;E=3028;break L3557}}while(0);if(!(h^(I|0)==0)){break}V=b|0;c[V>>2]=U;hy(o);hy(n);i=e;return}}while(0);do{if((E|0)==3028){if(h){break}V=b|0;c[V>>2]=U;hy(o);hy(n);i=e;return}}while(0);c[j>>2]=c[j>>2]|2;V=b|0;c[V>>2]=U;hy(o);hy(n);i=e;return}function jc(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];jd(a,0,j,k,f,g,h);i=b;return}function jd(b,e,f,h,j,k,l){b=b|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0;e=i;i=i+80|0;m=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[m>>2];m=h;h=i;i=i+4|0;i=i+7&-8;c[h>>2]=c[m>>2];m=e+32|0;n=e+40|0;o=e+48|0;p=e+64|0;q=p;r=i;i=i+4|0;i=i+7&-8;s=i;i=i+160|0;t=i;i=i+4|0;i=i+7&-8;u=i;i=i+4|0;i=i+7&-8;v=i;i=i+1|0;i=i+7&-8;w=i;i=i+1|0;i=i+7&-8;x=e|0;jK(o,j,x,m,n);oO(q|0,0,12);j=p;hA(p,10,0);if((a[q]&1)==0){y=j+1|0;z=y;A=y;B=p+8|0}else{y=p+8|0;z=c[y>>2]|0;A=j+1|0;B=y}c[r>>2]=z;y=s|0;c[t>>2]=y;c[u>>2]=0;a[v]=1;a[w]=69;j=f|0;f=h|0;h=p|0;C=p+4|0;D=a[m]|0;m=a[n]|0;n=z;z=c[j>>2]|0;L3577:while(1){do{if((z|0)==0){E=0}else{if((c[z+12>>2]|0)!=(c[z+16>>2]|0)){E=z;break}if((c3[c[(c[z>>2]|0)+36>>2]&255](z)|0)!=-1){E=z;break}c[j>>2]=0;E=0}}while(0);F=(E|0)==0;G=c[f>>2]|0;do{if((G|0)==0){H=3052}else{if((c[G+12>>2]|0)!=(c[G+16>>2]|0)){if(F){I=G;J=0;break}else{K=n;L=G;M=0;break L3577}}if((c3[c[(c[G>>2]|0)+36>>2]&255](G)|0)==-1){c[f>>2]=0;H=3052;break}else{N=(G|0)==0;if(F^N){I=G;J=N;break}else{K=n;L=G;M=N;break L3577}}}}while(0);if((H|0)==3052){H=0;if(F){K=n;L=0;M=1;break}else{I=0;J=1}}G=d[q]|0;N=(G&1|0)==0;if(((c[r>>2]|0)-n|0)==((N?G>>>1:c[C>>2]|0)|0)){if(N){O=G>>>1;P=G>>>1}else{G=c[C>>2]|0;O=G;P=G}hA(p,O<<1,0);if((a[q]&1)==0){Q=10}else{Q=(c[h>>2]&-2)-1|0}hA(p,Q,0);if((a[q]&1)==0){R=A}else{R=c[B>>2]|0}c[r>>2]=R+P;S=R}else{S=n}G=E+12|0;N=c[G>>2]|0;T=E+16|0;if((N|0)==(c[T>>2]|0)){U=(c3[c[(c[E>>2]|0)+36>>2]&255](E)|0)&255}else{U=a[N]|0}if((jL(U,v,w,S,r,D,m,o,y,t,u,x)|0)!=0){K=S;L=I;M=J;break}N=c[G>>2]|0;if((N|0)==(c[T>>2]|0)){T=c[(c[E>>2]|0)+40>>2]|0;c3[T&255](E)|0;n=S;z=E;continue}else{c[G>>2]=N+1;n=S;z=E;continue}}z=d[o]|0;if((z&1|0)==0){V=z>>>1}else{V=c[o+4>>2]|0}do{if((V|0)!=0){if((a[v]&1)==0){break}z=c[t>>2]|0;if((z-s|0)>=160){break}S=c[u>>2]|0;c[t>>2]=z+4;c[z>>2]=S}}while(0);g[l>>2]=+nN(K,c[r>>2]|0,k);lD(o,y,c[t>>2]|0,k);do{if(F){W=0}else{if((c[E+12>>2]|0)!=(c[E+16>>2]|0)){W=E;break}if((c3[c[(c[E>>2]|0)+36>>2]&255](E)|0)!=-1){W=E;break}c[j>>2]=0;W=0}}while(0);j=(W|0)==0;L3638:do{if(M){H=3094}else{do{if((c[L+12>>2]|0)==(c[L+16>>2]|0)){if((c3[c[(c[L>>2]|0)+36>>2]&255](L)|0)!=-1){break}c[f>>2]=0;H=3094;break L3638}}while(0);if(!(j^(L|0)==0)){break}X=b|0;c[X>>2]=W;hy(p);hy(o);i=e;return}}while(0);do{if((H|0)==3094){if(j){break}X=b|0;c[X>>2]=W;hy(p);hy(o);i=e;return}}while(0);c[k>>2]=c[k>>2]|2;X=b|0;c[X>>2]=W;hy(p);hy(o);i=e;return}function je(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];jf(a,0,j,k,f,g,h);i=b;return}function jf(b,e,f,g,j,k,l){b=b|0;e=e|0;f=f|0;g=g|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0;e=i;i=i+80|0;m=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[m>>2];m=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[m>>2];m=e+32|0;n=e+40|0;o=e+48|0;p=e+64|0;q=p;r=i;i=i+4|0;i=i+7&-8;s=i;i=i+160|0;t=i;i=i+4|0;i=i+7&-8;u=i;i=i+4|0;i=i+7&-8;v=i;i=i+1|0;i=i+7&-8;w=i;i=i+1|0;i=i+7&-8;x=e|0;jK(o,j,x,m,n);oO(q|0,0,12);j=p;hA(p,10,0);if((a[q]&1)==0){y=j+1|0;z=y;A=y;B=p+8|0}else{y=p+8|0;z=c[y>>2]|0;A=j+1|0;B=y}c[r>>2]=z;y=s|0;c[t>>2]=y;c[u>>2]=0;a[v]=1;a[w]=69;j=f|0;f=g|0;g=p|0;C=p+4|0;D=a[m]|0;m=a[n]|0;n=z;z=c[j>>2]|0;L3658:while(1){do{if((z|0)==0){E=0}else{if((c[z+12>>2]|0)!=(c[z+16>>2]|0)){E=z;break}if((c3[c[(c[z>>2]|0)+36>>2]&255](z)|0)!=-1){E=z;break}c[j>>2]=0;E=0}}while(0);F=(E|0)==0;G=c[f>>2]|0;do{if((G|0)==0){H=3118}else{if((c[G+12>>2]|0)!=(c[G+16>>2]|0)){if(F){I=G;J=0;break}else{K=n;L=G;M=0;break L3658}}if((c3[c[(c[G>>2]|0)+36>>2]&255](G)|0)==-1){c[f>>2]=0;H=3118;break}else{N=(G|0)==0;if(F^N){I=G;J=N;break}else{K=n;L=G;M=N;break L3658}}}}while(0);if((H|0)==3118){H=0;if(F){K=n;L=0;M=1;break}else{I=0;J=1}}G=d[q]|0;N=(G&1|0)==0;if(((c[r>>2]|0)-n|0)==((N?G>>>1:c[C>>2]|0)|0)){if(N){O=G>>>1;P=G>>>1}else{G=c[C>>2]|0;O=G;P=G}hA(p,O<<1,0);if((a[q]&1)==0){Q=10}else{Q=(c[g>>2]&-2)-1|0}hA(p,Q,0);if((a[q]&1)==0){R=A}else{R=c[B>>2]|0}c[r>>2]=R+P;S=R}else{S=n}G=E+12|0;N=c[G>>2]|0;T=E+16|0;if((N|0)==(c[T>>2]|0)){U=(c3[c[(c[E>>2]|0)+36>>2]&255](E)|0)&255}else{U=a[N]|0}if((jL(U,v,w,S,r,D,m,o,y,t,u,x)|0)!=0){K=S;L=I;M=J;break}N=c[G>>2]|0;if((N|0)==(c[T>>2]|0)){T=c[(c[E>>2]|0)+40>>2]|0;c3[T&255](E)|0;n=S;z=E;continue}else{c[G>>2]=N+1;n=S;z=E;continue}}z=d[o]|0;if((z&1|0)==0){V=z>>>1}else{V=c[o+4>>2]|0}do{if((V|0)!=0){if((a[v]&1)==0){break}z=c[t>>2]|0;if((z-s|0)>=160){break}S=c[u>>2]|0;c[t>>2]=z+4;c[z>>2]=S}}while(0);h[l>>3]=+nM(K,c[r>>2]|0,k);lD(o,y,c[t>>2]|0,k);do{if(F){W=0}else{if((c[E+12>>2]|0)!=(c[E+16>>2]|0)){W=E;break}if((c3[c[(c[E>>2]|0)+36>>2]&255](E)|0)!=-1){W=E;break}c[j>>2]=0;W=0}}while(0);j=(W|0)==0;L3719:do{if(M){H=3160}else{do{if((c[L+12>>2]|0)==(c[L+16>>2]|0)){if((c3[c[(c[L>>2]|0)+36>>2]&255](L)|0)!=-1){break}c[f>>2]=0;H=3160;break L3719}}while(0);if(!(j^(L|0)==0)){break}X=b|0;c[X>>2]=W;hy(p);hy(o);i=e;return}}while(0);do{if((H|0)==3160){if(j){break}X=b|0;c[X>>2]=W;hy(p);hy(o);i=e;return}}while(0);c[k>>2]=c[k>>2]|2;X=b|0;c[X>>2]=W;hy(p);hy(o);i=e;return}function jg(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];jh(a,0,j,k,f,g,h);i=b;return}function jh(b,e,f,g,j,k,l){b=b|0;e=e|0;f=f|0;g=g|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0;e=i;i=i+80|0;m=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[m>>2];m=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[m>>2];m=e+32|0;n=e+40|0;o=e+48|0;p=e+64|0;q=p;r=i;i=i+4|0;i=i+7&-8;s=i;i=i+160|0;t=i;i=i+4|0;i=i+7&-8;u=i;i=i+4|0;i=i+7&-8;v=i;i=i+1|0;i=i+7&-8;w=i;i=i+1|0;i=i+7&-8;x=e|0;jK(o,j,x,m,n);oO(q|0,0,12);j=p;hA(p,10,0);if((a[q]&1)==0){y=j+1|0;z=y;A=y;B=p+8|0}else{y=p+8|0;z=c[y>>2]|0;A=j+1|0;B=y}c[r>>2]=z;y=s|0;c[t>>2]=y;c[u>>2]=0;a[v]=1;a[w]=69;j=f|0;f=g|0;g=p|0;C=p+4|0;D=a[m]|0;m=a[n]|0;n=z;z=c[j>>2]|0;L3739:while(1){do{if((z|0)==0){E=0}else{if((c[z+12>>2]|0)!=(c[z+16>>2]|0)){E=z;break}if((c3[c[(c[z>>2]|0)+36>>2]&255](z)|0)!=-1){E=z;break}c[j>>2]=0;E=0}}while(0);F=(E|0)==0;G=c[f>>2]|0;do{if((G|0)==0){H=3184}else{if((c[G+12>>2]|0)!=(c[G+16>>2]|0)){if(F){I=G;J=0;break}else{K=n;L=G;M=0;break L3739}}if((c3[c[(c[G>>2]|0)+36>>2]&255](G)|0)==-1){c[f>>2]=0;H=3184;break}else{N=(G|0)==0;if(F^N){I=G;J=N;break}else{K=n;L=G;M=N;break L3739}}}}while(0);if((H|0)==3184){H=0;if(F){K=n;L=0;M=1;break}else{I=0;J=1}}G=d[q]|0;N=(G&1|0)==0;if(((c[r>>2]|0)-n|0)==((N?G>>>1:c[C>>2]|0)|0)){if(N){O=G>>>1;P=G>>>1}else{G=c[C>>2]|0;O=G;P=G}hA(p,O<<1,0);if((a[q]&1)==0){Q=10}else{Q=(c[g>>2]&-2)-1|0}hA(p,Q,0);if((a[q]&1)==0){R=A}else{R=c[B>>2]|0}c[r>>2]=R+P;S=R}else{S=n}G=E+12|0;N=c[G>>2]|0;T=E+16|0;if((N|0)==(c[T>>2]|0)){U=(c3[c[(c[E>>2]|0)+36>>2]&255](E)|0)&255}else{U=a[N]|0}if((jL(U,v,w,S,r,D,m,o,y,t,u,x)|0)!=0){K=S;L=I;M=J;break}N=c[G>>2]|0;if((N|0)==(c[T>>2]|0)){T=c[(c[E>>2]|0)+40>>2]|0;c3[T&255](E)|0;n=S;z=E;continue}else{c[G>>2]=N+1;n=S;z=E;continue}}z=d[o]|0;if((z&1|0)==0){V=z>>>1}else{V=c[o+4>>2]|0}do{if((V|0)!=0){if((a[v]&1)==0){break}z=c[t>>2]|0;if((z-s|0)>=160){break}S=c[u>>2]|0;c[t>>2]=z+4;c[z>>2]=S}}while(0);h[l>>3]=+nL(K,c[r>>2]|0,k);lD(o,y,c[t>>2]|0,k);do{if(F){W=0}else{if((c[E+12>>2]|0)!=(c[E+16>>2]|0)){W=E;break}if((c3[c[(c[E>>2]|0)+36>>2]&255](E)|0)!=-1){W=E;break}c[j>>2]=0;W=0}}while(0);j=(W|0)==0;L3800:do{if(M){H=3226}else{do{if((c[L+12>>2]|0)==(c[L+16>>2]|0)){if((c3[c[(c[L>>2]|0)+36>>2]&255](L)|0)!=-1){break}c[f>>2]=0;H=3226;break L3800}}while(0);if(!(j^(L|0)==0)){break}X=b|0;c[X>>2]=W;hy(p);hy(o);i=e;return}}while(0);do{if((H|0)==3226){if(j){break}X=b|0;c[X>>2]=W;hy(p);hy(o);i=e;return}}while(0);c[k>>2]=c[k>>2]|2;X=b|0;c[X>>2]=W;hy(p);hy(o);i=e;return}function ji(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0;e=i;i=i+64|0;l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[l>>2];l=e|0;m=e+16|0;n=e+48|0;o=i;i=i+4|0;i=i+7&-8;p=i;i=i+12|0;i=i+7&-8;q=i;i=i+4|0;i=i+7&-8;r=i;i=i+160|0;s=i;i=i+4|0;i=i+7&-8;t=i;i=i+4|0;i=i+7&-8;oO(n|0,0,12);u=p;hS(o,h);h=o|0;o=c[h>>2]|0;if((c[38272]|0)!=-1){c[l>>2]=153088;c[l+4>>2]=14;c[l+8>>2]=0;ht(153088,l,114)}l=(c[38273]|0)-1|0;v=c[o+8>>2]|0;do{if((c[o+12>>2]|0)-v>>2>>>0>l>>>0){w=c[v+(l<<2)>>2]|0;if((w|0)==0){break}x=w;y=m|0;z=c[(c[w>>2]|0)+32>>2]|0;c5[z&15](x,144424,144450,y)|0;x=c[h>>2]|0;g9(x)|0;oO(u|0,0,12);x=p;hA(p,10,0);if((a[u]&1)==0){z=x+1|0;A=z;B=z;C=p+8|0}else{z=p+8|0;A=c[z>>2]|0;B=x+1|0;C=z}c[q>>2]=A;z=r|0;c[s>>2]=z;c[t>>2]=0;x=f|0;w=g|0;D=p|0;E=p+4|0;F=A;G=c[x>>2]|0;L3827:while(1){do{if((G|0)==0){H=0}else{if((c[G+12>>2]|0)!=(c[G+16>>2]|0)){H=G;break}if((c3[c[(c[G>>2]|0)+36>>2]&255](G)|0)!=-1){H=G;break}c[x>>2]=0;H=0}}while(0);I=(H|0)==0;J=c[w>>2]|0;do{if((J|0)==0){K=3257}else{if((c[J+12>>2]|0)!=(c[J+16>>2]|0)){if(I){break}else{L=F;break L3827}}if((c3[c[(c[J>>2]|0)+36>>2]&255](J)|0)==-1){c[w>>2]=0;K=3257;break}else{if(I^(J|0)==0){break}else{L=F;break L3827}}}}while(0);if((K|0)==3257){K=0;if(I){L=F;break}}J=d[u]|0;M=(J&1|0)==0;if(((c[q>>2]|0)-F|0)==((M?J>>>1:c[E>>2]|0)|0)){if(M){N=J>>>1;O=J>>>1}else{J=c[E>>2]|0;N=J;O=J}hA(p,N<<1,0);if((a[u]&1)==0){P=10}else{P=(c[D>>2]&-2)-1|0}hA(p,P,0);if((a[u]&1)==0){Q=B}else{Q=c[C>>2]|0}c[q>>2]=Q+O;R=Q}else{R=F}J=H+12|0;M=c[J>>2]|0;S=H+16|0;if((M|0)==(c[S>>2]|0)){T=(c3[c[(c[H>>2]|0)+36>>2]&255](H)|0)&255}else{T=a[M]|0}if((jj(T,16,R,q,t,0,n,z,s,y)|0)!=0){L=R;break}M=c[J>>2]|0;if((M|0)==(c[S>>2]|0)){S=c[(c[H>>2]|0)+40>>2]|0;c3[S&255](H)|0;F=R;G=H;continue}else{c[J>>2]=M+1;F=R;G=H;continue}}a[L+3|0]=0;do{if((a[154480]|0)==0){if((bD(154480)|0)==0){break}c[36886]=a4(2147483647,134952,0)|0}}while(0);G=jk(L,c[36886]|0,134480,(F=i,i=i+8|0,c[F>>2]=k,F)|0)|0;i=F;if((G|0)!=1){c[j>>2]=4}G=c[x>>2]|0;do{if((G|0)==0){U=0}else{if((c[G+12>>2]|0)!=(c[G+16>>2]|0)){U=G;break}if((c3[c[(c[G>>2]|0)+36>>2]&255](G)|0)!=-1){U=G;break}c[x>>2]=0;U=0}}while(0);x=(U|0)==0;G=c[w>>2]|0;do{if((G|0)==0){K=3302}else{if((c[G+12>>2]|0)!=(c[G+16>>2]|0)){if(!x){break}V=b|0;c[V>>2]=U;hy(p);hy(n);i=e;return}if((c3[c[(c[G>>2]|0)+36>>2]&255](G)|0)==-1){c[w>>2]=0;K=3302;break}if(!(x^(G|0)==0)){break}V=b|0;c[V>>2]=U;hy(p);hy(n);i=e;return}}while(0);do{if((K|0)==3302){if(x){break}V=b|0;c[V>>2]=U;hy(p);hy(n);i=e;return}}while(0);c[j>>2]=c[j>>2]|2;V=b|0;c[V>>2]=U;hy(p);hy(n);i=e;return}}while(0);e=cI(4)|0;od(e);bT(e|0,142880,164)}function jj(b,e,f,g,h,i,j,k,l,m){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0;n=c[g>>2]|0;o=(n|0)==(f|0);do{if(o){p=(a[m+24|0]|0)==b<<24>>24;if(!p){if((a[m+25|0]|0)!=b<<24>>24){break}}c[g>>2]=f+1;a[f]=p?43:45;c[h>>2]=0;q=0;return q|0}}while(0);p=d[j]|0;if((p&1|0)==0){r=p>>>1}else{r=c[j+4>>2]|0}if((r|0)!=0&b<<24>>24==i<<24>>24){i=c[l>>2]|0;if((i-k|0)>=160){q=0;return q|0}k=c[h>>2]|0;c[l>>2]=i+4;c[i>>2]=k;c[h>>2]=0;q=0;return q|0}k=m+26|0;i=m;while(1){if((i|0)==(k|0)){s=k;break}if((a[i]|0)==b<<24>>24){s=i;break}else{i=i+1|0}}i=s-m|0;if((i|0)>23){q=-1;return q|0}do{if((e|0)==8|(e|0)==10){if((i|0)<(e|0)){break}else{q=-1}return q|0}else if((e|0)==16){if((i|0)<22){break}if(o){q=-1;return q|0}if((n-f|0)>=3){q=-1;return q|0}if((a[n-1|0]|0)!=48){q=-1;return q|0}c[h>>2]=0;m=a[144424+i|0]|0;s=c[g>>2]|0;c[g>>2]=s+1;a[s]=m;q=0;return q|0}}while(0);f=a[144424+i|0]|0;c[g>>2]=n+1;a[n]=f;c[h>>2]=(c[h>>2]|0)+1;q=0;return q|0}function jk(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;i=i+16|0;g=f|0;h=g;c[h>>2]=e;c[h+4>>2]=0;h=cr(b|0)|0;b=bd(a|0,d|0,g|0)|0;if((h|0)==0){i=f;return b|0}cr(h|0)|0;i=f;return b|0}function jl(a){a=a|0;g7(a|0);oF(a);return}function jm(a){a=a|0;g7(a|0);return}function jn(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;k=i;i=i+112|0;l=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[l>>2];l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=k|0;m=k+16|0;n=k+32|0;o=k+40|0;p=k+48|0;q=k+56|0;r=k+64|0;s=k+72|0;t=k+80|0;u=k+104|0;if((c[g+4>>2]&1|0)==0){c[n>>2]=-1;v=c[(c[d>>2]|0)+16>>2]|0;w=e|0;c[p>>2]=c[w>>2];c[q>>2]=c[f>>2];da[v&127](o,d,p,q,g,h,n);q=c[o>>2]|0;c[w>>2]=q;w=c[n>>2]|0;if((w|0)==1){a[j]=1}else if((w|0)==0){a[j]=0}else{a[j]=1;c[h>>2]=4}c[b>>2]=q;i=k;return}hS(r,g);q=r|0;r=c[q>>2]|0;if((c[38270]|0)!=-1){c[m>>2]=153080;c[m+4>>2]=14;c[m+8>>2]=0;ht(153080,m,114)}m=(c[38271]|0)-1|0;w=c[r+8>>2]|0;do{if((c[r+12>>2]|0)-w>>2>>>0>m>>>0){n=c[w+(m<<2)>>2]|0;if((n|0)==0){break}o=n;n=c[q>>2]|0;g9(n)|0;hS(s,g);n=s|0;p=c[n>>2]|0;if((c[38174]|0)!=-1){c[l>>2]=152696;c[l+4>>2]=14;c[l+8>>2]=0;ht(152696,l,114)}d=(c[38175]|0)-1|0;v=c[p+8>>2]|0;do{if((c[p+12>>2]|0)-v>>2>>>0>d>>>0){x=c[v+(d<<2)>>2]|0;if((x|0)==0){break}y=x;z=c[n>>2]|0;g9(z)|0;z=t|0;A=x;c1[c[(c[A>>2]|0)+24>>2]&127](z,y);c1[c[(c[A>>2]|0)+28>>2]&127](t+12|0,y);c[u>>2]=c[f>>2];a[j]=(jo(e,u,z,t+24|0,o,h,1)|0)==(z|0)|0;c[b>>2]=c[e>>2];hJ(t+12|0);hJ(t|0);i=k;return}}while(0);o=cI(4)|0;od(o);bT(o|0,142880,164)}}while(0);k=cI(4)|0;od(k);bT(k|0,142880,164)}function jo(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0,ac=0,ad=0;l=i;i=i+104|0;m=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[m>>2];m=(g-f|0)/12|0;n=l|0;do{if(m>>>0>100>>>0){o=oy(m)|0;if((o|0)!=0){p=o;q=o;break}oK();p=0;q=0}else{p=n;q=0}}while(0);n=(f|0)==(g|0);if(n){r=m;s=0}else{o=m;m=0;t=p;u=f;while(1){v=d[u]|0;if((v&1|0)==0){w=v>>>1}else{w=c[u+4>>2]|0}if((w|0)==0){a[t]=2;x=m+1|0;y=o-1|0}else{a[t]=1;x=m;y=o}v=u+12|0;if((v|0)==(g|0)){r=y;s=x;break}else{o=y;m=x;t=t+1|0;u=v}}}u=b|0;b=e|0;e=h;t=0;x=s;s=r;while(1){r=c[u>>2]|0;do{if((r|0)==0){z=0}else{m=c[r+12>>2]|0;if((m|0)==(c[r+16>>2]|0)){A=c3[c[(c[r>>2]|0)+36>>2]&255](r)|0}else{A=c[m>>2]|0}if((A|0)==-1){c[u>>2]=0;z=0;break}else{z=c[u>>2]|0;break}}}while(0);r=(z|0)==0;m=c[b>>2]|0;if((m|0)==0){B=z;C=0}else{y=c[m+12>>2]|0;if((y|0)==(c[m+16>>2]|0)){D=c3[c[(c[m>>2]|0)+36>>2]&255](m)|0}else{D=c[y>>2]|0}if((D|0)==-1){c[b>>2]=0;E=0}else{E=m}B=c[u>>2]|0;C=E}F=(C|0)==0;if(!((r^F)&(s|0)!=0)){break}r=c[B+12>>2]|0;if((r|0)==(c[B+16>>2]|0)){G=c3[c[(c[B>>2]|0)+36>>2]&255](B)|0}else{G=c[r>>2]|0}if(k){H=G}else{H=df[c[(c[e>>2]|0)+28>>2]&31](h,G)|0}do{if(n){I=x;J=s}else{r=t+1|0;L4034:do{if(k){m=s;y=x;o=p;w=0;v=f;while(1){do{if((a[o]|0)==1){K=v;if((a[K]&1)==0){L=v+4|0}else{L=c[v+8>>2]|0}if((H|0)!=(c[L+(t<<2)>>2]|0)){a[o]=0;M=w;N=y;O=m-1|0;break}P=d[K]|0;if((P&1|0)==0){Q=P>>>1}else{Q=c[v+4>>2]|0}if((Q|0)!=(r|0)){M=1;N=y;O=m;break}a[o]=2;M=1;N=y+1|0;O=m-1|0}else{M=w;N=y;O=m}}while(0);P=v+12|0;if((P|0)==(g|0)){R=O;S=N;T=M;break L4034}m=O;y=N;o=o+1|0;w=M;v=P}}else{v=s;w=x;o=p;y=0;m=f;while(1){do{if((a[o]|0)==1){P=m;if((a[P]&1)==0){U=m+4|0}else{U=c[m+8>>2]|0}if((H|0)!=(df[c[(c[e>>2]|0)+28>>2]&31](h,c[U+(t<<2)>>2]|0)|0)){a[o]=0;V=y;W=w;X=v-1|0;break}K=d[P]|0;if((K&1|0)==0){Y=K>>>1}else{Y=c[m+4>>2]|0}if((Y|0)!=(r|0)){V=1;W=w;X=v;break}a[o]=2;V=1;W=w+1|0;X=v-1|0}else{V=y;W=w;X=v}}while(0);K=m+12|0;if((K|0)==(g|0)){R=X;S=W;T=V;break L4034}v=X;w=W;o=o+1|0;y=V;m=K}}}while(0);if(!T){I=S;J=R;break}r=c[u>>2]|0;m=r+12|0;y=c[m>>2]|0;if((y|0)==(c[r+16>>2]|0)){o=c[(c[r>>2]|0)+40>>2]|0;c3[o&255](r)|0}else{c[m>>2]=y+4}if((S+R|0)>>>0<2>>>0|n){I=S;J=R;break}y=t+1|0;m=S;r=p;o=f;while(1){do{if((a[r]|0)==2){w=d[o]|0;if((w&1|0)==0){Z=w>>>1}else{Z=c[o+4>>2]|0}if((Z|0)==(y|0)){_=m;break}a[r]=0;_=m-1|0}else{_=m}}while(0);w=o+12|0;if((w|0)==(g|0)){I=_;J=R;break}else{m=_;r=r+1|0;o=w}}}}while(0);t=t+1|0;x=I;s=J}do{if((B|0)==0){$=1}else{J=c[B+12>>2]|0;if((J|0)==(c[B+16>>2]|0)){aa=c3[c[(c[B>>2]|0)+36>>2]&255](B)|0}else{aa=c[J>>2]|0}if((aa|0)==-1){c[u>>2]=0;$=1;break}else{$=(c[u>>2]|0)==0;break}}}while(0);do{if(F){ab=3477}else{u=c[C+12>>2]|0;if((u|0)==(c[C+16>>2]|0)){ac=c3[c[(c[C>>2]|0)+36>>2]&255](C)|0}else{ac=c[u>>2]|0}if((ac|0)==-1){c[b>>2]=0;ab=3477;break}else{if($^(C|0)==0){break}else{ab=3479;break}}}}while(0);if((ab|0)==3477){if($){ab=3479}}if((ab|0)==3479){c[j>>2]=c[j>>2]|2}L4115:do{if(n){ab=3484}else{$=f;C=p;while(1){if((a[C]|0)==2){ad=$;break L4115}b=$+12|0;if((b|0)==(g|0)){ab=3484;break L4115}$=b;C=C+1|0}}}while(0);if((ab|0)==3484){c[j>>2]=c[j>>2]|4;ad=g}if((q|0)==0){i=l;return ad|0}oz(q);i=l;return ad|0}function jp(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];jq(a,0,j,k,f,g,h);i=b;return}function jq(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0;e=i;i=i+144|0;l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[l>>2];l=e|0;m=e+104|0;n=e+112|0;o=e+128|0;p=o;q=i;i=i+4|0;i=i+7&-8;r=i;i=i+160|0;s=i;i=i+4|0;i=i+7&-8;t=i;i=i+4|0;i=i+7&-8;u=c[h+4>>2]&74;if((u|0)==64){v=8}else if((u|0)==8){v=16}else if((u|0)==0){v=0}else{v=10}u=l|0;jM(n,h,u,m);oO(p|0,0,12);h=o;hA(o,10,0);if((a[p]&1)==0){l=h+1|0;w=l;x=l;y=o+8|0}else{l=o+8|0;w=c[l>>2]|0;x=h+1|0;y=l}c[q>>2]=w;l=r|0;c[s>>2]=l;c[t>>2]=0;h=f|0;f=g|0;g=o|0;z=o+4|0;A=c[m>>2]|0;m=w;w=c[h>>2]|0;L4139:while(1){do{if((w|0)==0){B=0}else{C=c[w+12>>2]|0;if((C|0)==(c[w+16>>2]|0)){D=c3[c[(c[w>>2]|0)+36>>2]&255](w)|0}else{D=c[C>>2]|0}if((D|0)!=-1){B=w;break}c[h>>2]=0;B=0}}while(0);E=(B|0)==0;C=c[f>>2]|0;do{if((C|0)==0){F=3513}else{G=c[C+12>>2]|0;if((G|0)==(c[C+16>>2]|0)){H=c3[c[(c[C>>2]|0)+36>>2]&255](C)|0}else{H=c[G>>2]|0}if((H|0)==-1){c[f>>2]=0;F=3513;break}else{G=(C|0)==0;if(E^G){I=C;J=G;break}else{K=m;L=C;M=G;break L4139}}}}while(0);if((F|0)==3513){F=0;if(E){K=m;L=0;M=1;break}else{I=0;J=1}}C=d[p]|0;G=(C&1|0)==0;if(((c[q>>2]|0)-m|0)==((G?C>>>1:c[z>>2]|0)|0)){if(G){N=C>>>1;O=C>>>1}else{C=c[z>>2]|0;N=C;O=C}hA(o,N<<1,0);if((a[p]&1)==0){P=10}else{P=(c[g>>2]&-2)-1|0}hA(o,P,0);if((a[p]&1)==0){Q=x}else{Q=c[y>>2]|0}c[q>>2]=Q+O;R=Q}else{R=m}C=B+12|0;G=c[C>>2]|0;S=B+16|0;if((G|0)==(c[S>>2]|0)){T=c3[c[(c[B>>2]|0)+36>>2]&255](B)|0}else{T=c[G>>2]|0}if((jI(T,v,R,q,t,A,n,l,s,u)|0)!=0){K=R;L=I;M=J;break}G=c[C>>2]|0;if((G|0)==(c[S>>2]|0)){S=c[(c[B>>2]|0)+40>>2]|0;c3[S&255](B)|0;m=R;w=B;continue}else{c[C>>2]=G+4;m=R;w=B;continue}}w=d[n]|0;if((w&1|0)==0){U=w>>>1}else{U=c[n+4>>2]|0}do{if((U|0)!=0){w=c[s>>2]|0;if((w-r|0)>=160){break}R=c[t>>2]|0;c[s>>2]=w+4;c[w>>2]=R}}while(0);c[k>>2]=nT(K,c[q>>2]|0,j,v)|0;lD(n,l,c[s>>2]|0,j);do{if(E){V=0}else{s=c[B+12>>2]|0;if((s|0)==(c[B+16>>2]|0)){W=c3[c[(c[B>>2]|0)+36>>2]&255](B)|0}else{W=c[s>>2]|0}if((W|0)!=-1){V=B;break}c[h>>2]=0;V=0}}while(0);h=(V|0)==0;do{if(M){F=3555}else{B=c[L+12>>2]|0;if((B|0)==(c[L+16>>2]|0)){X=c3[c[(c[L>>2]|0)+36>>2]&255](L)|0}else{X=c[B>>2]|0}if((X|0)==-1){c[f>>2]=0;F=3555;break}if(!(h^(L|0)==0)){break}Y=b|0;c[Y>>2]=V;hy(o);hy(n);i=e;return}}while(0);do{if((F|0)==3555){if(h){break}Y=b|0;c[Y>>2]=V;hy(o);hy(n);i=e;return}}while(0);c[j>>2]=c[j>>2]|2;Y=b|0;c[Y>>2]=V;hy(o);hy(n);i=e;return}function jr(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];js(a,0,j,k,f,g,h);i=b;return}function js(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0;e=i;i=i+144|0;l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[l>>2];l=e|0;m=e+104|0;n=e+112|0;o=e+128|0;p=o;q=i;i=i+4|0;i=i+7&-8;r=i;i=i+160|0;s=i;i=i+4|0;i=i+7&-8;t=i;i=i+4|0;i=i+7&-8;u=c[h+4>>2]&74;if((u|0)==64){v=8}else if((u|0)==0){v=0}else if((u|0)==8){v=16}else{v=10}u=l|0;jM(n,h,u,m);oO(p|0,0,12);h=o;hA(o,10,0);if((a[p]&1)==0){l=h+1|0;w=l;x=l;y=o+8|0}else{l=o+8|0;w=c[l>>2]|0;x=h+1|0;y=l}c[q>>2]=w;l=r|0;c[s>>2]=l;c[t>>2]=0;h=f|0;f=g|0;g=o|0;z=o+4|0;A=c[m>>2]|0;m=w;w=c[h>>2]|0;L4229:while(1){do{if((w|0)==0){B=0}else{C=c[w+12>>2]|0;if((C|0)==(c[w+16>>2]|0)){D=c3[c[(c[w>>2]|0)+36>>2]&255](w)|0}else{D=c[C>>2]|0}if((D|0)!=-1){B=w;break}c[h>>2]=0;B=0}}while(0);E=(B|0)==0;C=c[f>>2]|0;do{if((C|0)==0){F=3584}else{G=c[C+12>>2]|0;if((G|0)==(c[C+16>>2]|0)){H=c3[c[(c[C>>2]|0)+36>>2]&255](C)|0}else{H=c[G>>2]|0}if((H|0)==-1){c[f>>2]=0;F=3584;break}else{G=(C|0)==0;if(E^G){I=C;J=G;break}else{L=m;M=C;N=G;break L4229}}}}while(0);if((F|0)==3584){F=0;if(E){L=m;M=0;N=1;break}else{I=0;J=1}}C=d[p]|0;G=(C&1|0)==0;if(((c[q>>2]|0)-m|0)==((G?C>>>1:c[z>>2]|0)|0)){if(G){O=C>>>1;P=C>>>1}else{C=c[z>>2]|0;O=C;P=C}hA(o,O<<1,0);if((a[p]&1)==0){Q=10}else{Q=(c[g>>2]&-2)-1|0}hA(o,Q,0);if((a[p]&1)==0){R=x}else{R=c[y>>2]|0}c[q>>2]=R+P;S=R}else{S=m}C=B+12|0;G=c[C>>2]|0;T=B+16|0;if((G|0)==(c[T>>2]|0)){U=c3[c[(c[B>>2]|0)+36>>2]&255](B)|0}else{U=c[G>>2]|0}if((jI(U,v,S,q,t,A,n,l,s,u)|0)!=0){L=S;M=I;N=J;break}G=c[C>>2]|0;if((G|0)==(c[T>>2]|0)){T=c[(c[B>>2]|0)+40>>2]|0;c3[T&255](B)|0;m=S;w=B;continue}else{c[C>>2]=G+4;m=S;w=B;continue}}w=d[n]|0;if((w&1|0)==0){V=w>>>1}else{V=c[n+4>>2]|0}do{if((V|0)!=0){w=c[s>>2]|0;if((w-r|0)>=160){break}S=c[t>>2]|0;c[s>>2]=w+4;c[w>>2]=S}}while(0);t=nS(L,c[q>>2]|0,j,v)|0;c[k>>2]=t;c[k+4>>2]=K;lD(n,l,c[s>>2]|0,j);do{if(E){W=0}else{s=c[B+12>>2]|0;if((s|0)==(c[B+16>>2]|0)){X=c3[c[(c[B>>2]|0)+36>>2]&255](B)|0}else{X=c[s>>2]|0}if((X|0)!=-1){W=B;break}c[h>>2]=0;W=0}}while(0);h=(W|0)==0;do{if(N){F=3626}else{B=c[M+12>>2]|0;if((B|0)==(c[M+16>>2]|0)){Y=c3[c[(c[M>>2]|0)+36>>2]&255](M)|0}else{Y=c[B>>2]|0}if((Y|0)==-1){c[f>>2]=0;F=3626;break}if(!(h^(M|0)==0)){break}Z=b|0;c[Z>>2]=W;hy(o);hy(n);i=e;return}}while(0);do{if((F|0)==3626){if(h){break}Z=b|0;c[Z>>2]=W;hy(o);hy(n);i=e;return}}while(0);c[j>>2]=c[j>>2]|2;Z=b|0;c[Z>>2]=W;hy(o);hy(n);i=e;return}function jt(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];ju(a,0,j,k,f,g,h);i=b;return}function ju(e,f,g,h,j,k,l){e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0;f=i;i=i+144|0;m=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[m>>2];m=h;h=i;i=i+4|0;i=i+7&-8;c[h>>2]=c[m>>2];m=f|0;n=f+104|0;o=f+112|0;p=f+128|0;q=p;r=i;i=i+4|0;i=i+7&-8;s=i;i=i+160|0;t=i;i=i+4|0;i=i+7&-8;u=i;i=i+4|0;i=i+7&-8;v=c[j+4>>2]&74;if((v|0)==64){w=8}else if((v|0)==8){w=16}else if((v|0)==0){w=0}else{w=10}v=m|0;jM(o,j,v,n);oO(q|0,0,12);j=p;hA(p,10,0);if((a[q]&1)==0){m=j+1|0;x=m;y=m;z=p+8|0}else{m=p+8|0;x=c[m>>2]|0;y=j+1|0;z=m}c[r>>2]=x;m=s|0;c[t>>2]=m;c[u>>2]=0;j=g|0;g=h|0;h=p|0;A=p+4|0;B=c[n>>2]|0;n=x;x=c[j>>2]|0;L4319:while(1){do{if((x|0)==0){C=0}else{D=c[x+12>>2]|0;if((D|0)==(c[x+16>>2]|0)){E=c3[c[(c[x>>2]|0)+36>>2]&255](x)|0}else{E=c[D>>2]|0}if((E|0)!=-1){C=x;break}c[j>>2]=0;C=0}}while(0);F=(C|0)==0;D=c[g>>2]|0;do{if((D|0)==0){G=3655}else{H=c[D+12>>2]|0;if((H|0)==(c[D+16>>2]|0)){I=c3[c[(c[D>>2]|0)+36>>2]&255](D)|0}else{I=c[H>>2]|0}if((I|0)==-1){c[g>>2]=0;G=3655;break}else{H=(D|0)==0;if(F^H){J=D;K=H;break}else{L=n;M=D;N=H;break L4319}}}}while(0);if((G|0)==3655){G=0;if(F){L=n;M=0;N=1;break}else{J=0;K=1}}D=d[q]|0;H=(D&1|0)==0;if(((c[r>>2]|0)-n|0)==((H?D>>>1:c[A>>2]|0)|0)){if(H){O=D>>>1;P=D>>>1}else{D=c[A>>2]|0;O=D;P=D}hA(p,O<<1,0);if((a[q]&1)==0){Q=10}else{Q=(c[h>>2]&-2)-1|0}hA(p,Q,0);if((a[q]&1)==0){R=y}else{R=c[z>>2]|0}c[r>>2]=R+P;S=R}else{S=n}D=C+12|0;H=c[D>>2]|0;T=C+16|0;if((H|0)==(c[T>>2]|0)){U=c3[c[(c[C>>2]|0)+36>>2]&255](C)|0}else{U=c[H>>2]|0}if((jI(U,w,S,r,u,B,o,m,t,v)|0)!=0){L=S;M=J;N=K;break}H=c[D>>2]|0;if((H|0)==(c[T>>2]|0)){T=c[(c[C>>2]|0)+40>>2]|0;c3[T&255](C)|0;n=S;x=C;continue}else{c[D>>2]=H+4;n=S;x=C;continue}}x=d[o]|0;if((x&1|0)==0){V=x>>>1}else{V=c[o+4>>2]|0}do{if((V|0)!=0){x=c[t>>2]|0;if((x-s|0)>=160){break}S=c[u>>2]|0;c[t>>2]=x+4;c[x>>2]=S}}while(0);b[l>>1]=nR(L,c[r>>2]|0,k,w)|0;lD(o,m,c[t>>2]|0,k);do{if(F){W=0}else{t=c[C+12>>2]|0;if((t|0)==(c[C+16>>2]|0)){X=c3[c[(c[C>>2]|0)+36>>2]&255](C)|0}else{X=c[t>>2]|0}if((X|0)!=-1){W=C;break}c[j>>2]=0;W=0}}while(0);j=(W|0)==0;do{if(N){G=3697}else{C=c[M+12>>2]|0;if((C|0)==(c[M+16>>2]|0)){Y=c3[c[(c[M>>2]|0)+36>>2]&255](M)|0}else{Y=c[C>>2]|0}if((Y|0)==-1){c[g>>2]=0;G=3697;break}if(!(j^(M|0)==0)){break}Z=e|0;c[Z>>2]=W;hy(p);hy(o);i=f;return}}while(0);do{if((G|0)==3697){if(j){break}Z=e|0;c[Z>>2]=W;hy(p);hy(o);i=f;return}}while(0);c[k>>2]=c[k>>2]|2;Z=e|0;c[Z>>2]=W;hy(p);hy(o);i=f;return}function jv(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];jw(a,0,j,k,f,g,h);i=b;return}function jw(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0;e=i;i=i+144|0;l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[l>>2];l=e|0;m=e+104|0;n=e+112|0;o=e+128|0;p=o;q=i;i=i+4|0;i=i+7&-8;r=i;i=i+160|0;s=i;i=i+4|0;i=i+7&-8;t=i;i=i+4|0;i=i+7&-8;u=c[h+4>>2]&74;if((u|0)==64){v=8}else if((u|0)==0){v=0}else if((u|0)==8){v=16}else{v=10}u=l|0;jM(n,h,u,m);oO(p|0,0,12);h=o;hA(o,10,0);if((a[p]&1)==0){l=h+1|0;w=l;x=l;y=o+8|0}else{l=o+8|0;w=c[l>>2]|0;x=h+1|0;y=l}c[q>>2]=w;l=r|0;c[s>>2]=l;c[t>>2]=0;h=f|0;f=g|0;g=o|0;z=o+4|0;A=c[m>>2]|0;m=w;w=c[h>>2]|0;L4409:while(1){do{if((w|0)==0){B=0}else{C=c[w+12>>2]|0;if((C|0)==(c[w+16>>2]|0)){D=c3[c[(c[w>>2]|0)+36>>2]&255](w)|0}else{D=c[C>>2]|0}if((D|0)!=-1){B=w;break}c[h>>2]=0;B=0}}while(0);E=(B|0)==0;C=c[f>>2]|0;do{if((C|0)==0){F=3726}else{G=c[C+12>>2]|0;if((G|0)==(c[C+16>>2]|0)){H=c3[c[(c[C>>2]|0)+36>>2]&255](C)|0}else{H=c[G>>2]|0}if((H|0)==-1){c[f>>2]=0;F=3726;break}else{G=(C|0)==0;if(E^G){I=C;J=G;break}else{K=m;L=C;M=G;break L4409}}}}while(0);if((F|0)==3726){F=0;if(E){K=m;L=0;M=1;break}else{I=0;J=1}}C=d[p]|0;G=(C&1|0)==0;if(((c[q>>2]|0)-m|0)==((G?C>>>1:c[z>>2]|0)|0)){if(G){N=C>>>1;O=C>>>1}else{C=c[z>>2]|0;N=C;O=C}hA(o,N<<1,0);if((a[p]&1)==0){P=10}else{P=(c[g>>2]&-2)-1|0}hA(o,P,0);if((a[p]&1)==0){Q=x}else{Q=c[y>>2]|0}c[q>>2]=Q+O;R=Q}else{R=m}C=B+12|0;G=c[C>>2]|0;S=B+16|0;if((G|0)==(c[S>>2]|0)){T=c3[c[(c[B>>2]|0)+36>>2]&255](B)|0}else{T=c[G>>2]|0}if((jI(T,v,R,q,t,A,n,l,s,u)|0)!=0){K=R;L=I;M=J;break}G=c[C>>2]|0;if((G|0)==(c[S>>2]|0)){S=c[(c[B>>2]|0)+40>>2]|0;c3[S&255](B)|0;m=R;w=B;continue}else{c[C>>2]=G+4;m=R;w=B;continue}}w=d[n]|0;if((w&1|0)==0){U=w>>>1}else{U=c[n+4>>2]|0}do{if((U|0)!=0){w=c[s>>2]|0;if((w-r|0)>=160){break}R=c[t>>2]|0;c[s>>2]=w+4;c[w>>2]=R}}while(0);c[k>>2]=nQ(K,c[q>>2]|0,j,v)|0;lD(n,l,c[s>>2]|0,j);do{if(E){V=0}else{s=c[B+12>>2]|0;if((s|0)==(c[B+16>>2]|0)){W=c3[c[(c[B>>2]|0)+36>>2]&255](B)|0}else{W=c[s>>2]|0}if((W|0)!=-1){V=B;break}c[h>>2]=0;V=0}}while(0);h=(V|0)==0;do{if(M){F=3768}else{B=c[L+12>>2]|0;if((B|0)==(c[L+16>>2]|0)){X=c3[c[(c[L>>2]|0)+36>>2]&255](L)|0}else{X=c[B>>2]|0}if((X|0)==-1){c[f>>2]=0;F=3768;break}if(!(h^(L|0)==0)){break}Y=b|0;c[Y>>2]=V;hy(o);hy(n);i=e;return}}while(0);do{if((F|0)==3768){if(h){break}Y=b|0;c[Y>>2]=V;hy(o);hy(n);i=e;return}}while(0);c[j>>2]=c[j>>2]|2;Y=b|0;c[Y>>2]=V;hy(o);hy(n);i=e;return}function jx(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];jy(a,0,j,k,f,g,h);i=b;return}function jy(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0;e=i;i=i+144|0;l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[l>>2];l=e|0;m=e+104|0;n=e+112|0;o=e+128|0;p=o;q=i;i=i+4|0;i=i+7&-8;r=i;i=i+160|0;s=i;i=i+4|0;i=i+7&-8;t=i;i=i+4|0;i=i+7&-8;u=c[h+4>>2]&74;if((u|0)==64){v=8}else if((u|0)==8){v=16}else if((u|0)==0){v=0}else{v=10}u=l|0;jM(n,h,u,m);oO(p|0,0,12);h=o;hA(o,10,0);if((a[p]&1)==0){l=h+1|0;w=l;x=l;y=o+8|0}else{l=o+8|0;w=c[l>>2]|0;x=h+1|0;y=l}c[q>>2]=w;l=r|0;c[s>>2]=l;c[t>>2]=0;h=f|0;f=g|0;g=o|0;z=o+4|0;A=c[m>>2]|0;m=w;w=c[h>>2]|0;L4499:while(1){do{if((w|0)==0){B=0}else{C=c[w+12>>2]|0;if((C|0)==(c[w+16>>2]|0)){D=c3[c[(c[w>>2]|0)+36>>2]&255](w)|0}else{D=c[C>>2]|0}if((D|0)!=-1){B=w;break}c[h>>2]=0;B=0}}while(0);E=(B|0)==0;C=c[f>>2]|0;do{if((C|0)==0){F=3797}else{G=c[C+12>>2]|0;if((G|0)==(c[C+16>>2]|0)){H=c3[c[(c[C>>2]|0)+36>>2]&255](C)|0}else{H=c[G>>2]|0}if((H|0)==-1){c[f>>2]=0;F=3797;break}else{G=(C|0)==0;if(E^G){I=C;J=G;break}else{K=m;L=C;M=G;break L4499}}}}while(0);if((F|0)==3797){F=0;if(E){K=m;L=0;M=1;break}else{I=0;J=1}}C=d[p]|0;G=(C&1|0)==0;if(((c[q>>2]|0)-m|0)==((G?C>>>1:c[z>>2]|0)|0)){if(G){N=C>>>1;O=C>>>1}else{C=c[z>>2]|0;N=C;O=C}hA(o,N<<1,0);if((a[p]&1)==0){P=10}else{P=(c[g>>2]&-2)-1|0}hA(o,P,0);if((a[p]&1)==0){Q=x}else{Q=c[y>>2]|0}c[q>>2]=Q+O;R=Q}else{R=m}C=B+12|0;G=c[C>>2]|0;S=B+16|0;if((G|0)==(c[S>>2]|0)){T=c3[c[(c[B>>2]|0)+36>>2]&255](B)|0}else{T=c[G>>2]|0}if((jI(T,v,R,q,t,A,n,l,s,u)|0)!=0){K=R;L=I;M=J;break}G=c[C>>2]|0;if((G|0)==(c[S>>2]|0)){S=c[(c[B>>2]|0)+40>>2]|0;c3[S&255](B)|0;m=R;w=B;continue}else{c[C>>2]=G+4;m=R;w=B;continue}}w=d[n]|0;if((w&1|0)==0){U=w>>>1}else{U=c[n+4>>2]|0}do{if((U|0)!=0){w=c[s>>2]|0;if((w-r|0)>=160){break}R=c[t>>2]|0;c[s>>2]=w+4;c[w>>2]=R}}while(0);c[k>>2]=nP(K,c[q>>2]|0,j,v)|0;lD(n,l,c[s>>2]|0,j);do{if(E){V=0}else{s=c[B+12>>2]|0;if((s|0)==(c[B+16>>2]|0)){W=c3[c[(c[B>>2]|0)+36>>2]&255](B)|0}else{W=c[s>>2]|0}if((W|0)!=-1){V=B;break}c[h>>2]=0;V=0}}while(0);h=(V|0)==0;do{if(M){F=3839}else{B=c[L+12>>2]|0;if((B|0)==(c[L+16>>2]|0)){X=c3[c[(c[L>>2]|0)+36>>2]&255](L)|0}else{X=c[B>>2]|0}if((X|0)==-1){c[f>>2]=0;F=3839;break}if(!(h^(L|0)==0)){break}Y=b|0;c[Y>>2]=V;hy(o);hy(n);i=e;return}}while(0);do{if((F|0)==3839){if(h){break}Y=b|0;c[Y>>2]=V;hy(o);hy(n);i=e;return}}while(0);c[j>>2]=c[j>>2]|2;Y=b|0;c[Y>>2]=V;hy(o);hy(n);i=e;return}function jz(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];jA(a,0,j,k,f,g,h);i=b;return}function jA(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0;e=i;i=i+144|0;l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[l>>2];l=e|0;m=e+104|0;n=e+112|0;o=e+128|0;p=o;q=i;i=i+4|0;i=i+7&-8;r=i;i=i+160|0;s=i;i=i+4|0;i=i+7&-8;t=i;i=i+4|0;i=i+7&-8;u=c[h+4>>2]&74;if((u|0)==64){v=8}else if((u|0)==8){v=16}else if((u|0)==0){v=0}else{v=10}u=l|0;jM(n,h,u,m);oO(p|0,0,12);h=o;hA(o,10,0);if((a[p]&1)==0){l=h+1|0;w=l;x=l;y=o+8|0}else{l=o+8|0;w=c[l>>2]|0;x=h+1|0;y=l}c[q>>2]=w;l=r|0;c[s>>2]=l;c[t>>2]=0;h=f|0;f=g|0;g=o|0;z=o+4|0;A=c[m>>2]|0;m=w;w=c[h>>2]|0;L4589:while(1){do{if((w|0)==0){B=0}else{C=c[w+12>>2]|0;if((C|0)==(c[w+16>>2]|0)){D=c3[c[(c[w>>2]|0)+36>>2]&255](w)|0}else{D=c[C>>2]|0}if((D|0)!=-1){B=w;break}c[h>>2]=0;B=0}}while(0);E=(B|0)==0;C=c[f>>2]|0;do{if((C|0)==0){F=3868}else{G=c[C+12>>2]|0;if((G|0)==(c[C+16>>2]|0)){H=c3[c[(c[C>>2]|0)+36>>2]&255](C)|0}else{H=c[G>>2]|0}if((H|0)==-1){c[f>>2]=0;F=3868;break}else{G=(C|0)==0;if(E^G){I=C;J=G;break}else{L=m;M=C;N=G;break L4589}}}}while(0);if((F|0)==3868){F=0;if(E){L=m;M=0;N=1;break}else{I=0;J=1}}C=d[p]|0;G=(C&1|0)==0;if(((c[q>>2]|0)-m|0)==((G?C>>>1:c[z>>2]|0)|0)){if(G){O=C>>>1;P=C>>>1}else{C=c[z>>2]|0;O=C;P=C}hA(o,O<<1,0);if((a[p]&1)==0){Q=10}else{Q=(c[g>>2]&-2)-1|0}hA(o,Q,0);if((a[p]&1)==0){R=x}else{R=c[y>>2]|0}c[q>>2]=R+P;S=R}else{S=m}C=B+12|0;G=c[C>>2]|0;T=B+16|0;if((G|0)==(c[T>>2]|0)){U=c3[c[(c[B>>2]|0)+36>>2]&255](B)|0}else{U=c[G>>2]|0}if((jI(U,v,S,q,t,A,n,l,s,u)|0)!=0){L=S;M=I;N=J;break}G=c[C>>2]|0;if((G|0)==(c[T>>2]|0)){T=c[(c[B>>2]|0)+40>>2]|0;c3[T&255](B)|0;m=S;w=B;continue}else{c[C>>2]=G+4;m=S;w=B;continue}}w=d[n]|0;if((w&1|0)==0){V=w>>>1}else{V=c[n+4>>2]|0}do{if((V|0)!=0){w=c[s>>2]|0;if((w-r|0)>=160){break}S=c[t>>2]|0;c[s>>2]=w+4;c[w>>2]=S}}while(0);t=nO(L,c[q>>2]|0,j,v)|0;c[k>>2]=t;c[k+4>>2]=K;lD(n,l,c[s>>2]|0,j);do{if(E){W=0}else{s=c[B+12>>2]|0;if((s|0)==(c[B+16>>2]|0)){X=c3[c[(c[B>>2]|0)+36>>2]&255](B)|0}else{X=c[s>>2]|0}if((X|0)!=-1){W=B;break}c[h>>2]=0;W=0}}while(0);h=(W|0)==0;do{if(N){F=3910}else{B=c[M+12>>2]|0;if((B|0)==(c[M+16>>2]|0)){Y=c3[c[(c[M>>2]|0)+36>>2]&255](M)|0}else{Y=c[B>>2]|0}if((Y|0)==-1){c[f>>2]=0;F=3910;break}if(!(h^(M|0)==0)){break}Z=b|0;c[Z>>2]=W;hy(o);hy(n);i=e;return}}while(0);do{if((F|0)==3910){if(h){break}Z=b|0;c[Z>>2]=W;hy(o);hy(n);i=e;return}}while(0);c[j>>2]=c[j>>2]|2;Z=b|0;c[Z>>2]=W;hy(o);hy(n);i=e;return}function jB(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];jC(a,0,j,k,f,g,h);i=b;return}function jC(b,e,f,h,j,k,l){b=b|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0;e=i;i=i+176|0;m=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[m>>2];m=h;h=i;i=i+4|0;i=i+7&-8;c[h>>2]=c[m>>2];m=e+128|0;n=e+136|0;o=e+144|0;p=e+160|0;q=p;r=i;i=i+4|0;i=i+7&-8;s=i;i=i+160|0;t=i;i=i+4|0;i=i+7&-8;u=i;i=i+4|0;i=i+7&-8;v=i;i=i+1|0;i=i+7&-8;w=i;i=i+1|0;i=i+7&-8;x=e|0;jN(o,j,x,m,n);oO(q|0,0,12);j=p;hA(p,10,0);if((a[q]&1)==0){y=j+1|0;z=y;A=y;B=p+8|0}else{y=p+8|0;z=c[y>>2]|0;A=j+1|0;B=y}c[r>>2]=z;y=s|0;c[t>>2]=y;c[u>>2]=0;a[v]=1;a[w]=69;j=f|0;f=h|0;h=p|0;C=p+4|0;D=c[m>>2]|0;m=c[n>>2]|0;n=z;z=c[j>>2]|0;L4674:while(1){do{if((z|0)==0){E=0}else{F=c[z+12>>2]|0;if((F|0)==(c[z+16>>2]|0)){G=c3[c[(c[z>>2]|0)+36>>2]&255](z)|0}else{G=c[F>>2]|0}if((G|0)!=-1){E=z;break}c[j>>2]=0;E=0}}while(0);H=(E|0)==0;F=c[f>>2]|0;do{if((F|0)==0){I=3935}else{J=c[F+12>>2]|0;if((J|0)==(c[F+16>>2]|0)){K=c3[c[(c[F>>2]|0)+36>>2]&255](F)|0}else{K=c[J>>2]|0}if((K|0)==-1){c[f>>2]=0;I=3935;break}else{J=(F|0)==0;if(H^J){L=F;M=J;break}else{N=n;O=F;P=J;break L4674}}}}while(0);if((I|0)==3935){I=0;if(H){N=n;O=0;P=1;break}else{L=0;M=1}}F=d[q]|0;J=(F&1|0)==0;if(((c[r>>2]|0)-n|0)==((J?F>>>1:c[C>>2]|0)|0)){if(J){Q=F>>>1;R=F>>>1}else{F=c[C>>2]|0;Q=F;R=F}hA(p,Q<<1,0);if((a[q]&1)==0){S=10}else{S=(c[h>>2]&-2)-1|0}hA(p,S,0);if((a[q]&1)==0){T=A}else{T=c[B>>2]|0}c[r>>2]=T+R;U=T}else{U=n}F=E+12|0;J=c[F>>2]|0;V=E+16|0;if((J|0)==(c[V>>2]|0)){W=c3[c[(c[E>>2]|0)+36>>2]&255](E)|0}else{W=c[J>>2]|0}if((jO(W,v,w,U,r,D,m,o,y,t,u,x)|0)!=0){N=U;O=L;P=M;break}J=c[F>>2]|0;if((J|0)==(c[V>>2]|0)){V=c[(c[E>>2]|0)+40>>2]|0;c3[V&255](E)|0;n=U;z=E;continue}else{c[F>>2]=J+4;n=U;z=E;continue}}z=d[o]|0;if((z&1|0)==0){X=z>>>1}else{X=c[o+4>>2]|0}do{if((X|0)!=0){if((a[v]&1)==0){break}z=c[t>>2]|0;if((z-s|0)>=160){break}U=c[u>>2]|0;c[t>>2]=z+4;c[z>>2]=U}}while(0);g[l>>2]=+nN(N,c[r>>2]|0,k);lD(o,y,c[t>>2]|0,k);do{if(H){Y=0}else{t=c[E+12>>2]|0;if((t|0)==(c[E+16>>2]|0)){Z=c3[c[(c[E>>2]|0)+36>>2]&255](E)|0}else{Z=c[t>>2]|0}if((Z|0)!=-1){Y=E;break}c[j>>2]=0;Y=0}}while(0);j=(Y|0)==0;do{if(P){I=3978}else{E=c[O+12>>2]|0;if((E|0)==(c[O+16>>2]|0)){_=c3[c[(c[O>>2]|0)+36>>2]&255](O)|0}else{_=c[E>>2]|0}if((_|0)==-1){c[f>>2]=0;I=3978;break}if(!(j^(O|0)==0)){break}$=b|0;c[$>>2]=Y;hy(p);hy(o);i=e;return}}while(0);do{if((I|0)==3978){if(j){break}$=b|0;c[$>>2]=Y;hy(p);hy(o);i=e;return}}while(0);c[k>>2]=c[k>>2]|2;$=b|0;c[$>>2]=Y;hy(p);hy(o);i=e;return}function jD(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];jE(a,0,j,k,f,g,h);i=b;return}function jE(b,e,f,g,j,k,l){b=b|0;e=e|0;f=f|0;g=g|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0;e=i;i=i+176|0;m=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[m>>2];m=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[m>>2];m=e+128|0;n=e+136|0;o=e+144|0;p=e+160|0;q=p;r=i;i=i+4|0;i=i+7&-8;s=i;i=i+160|0;t=i;i=i+4|0;i=i+7&-8;u=i;i=i+4|0;i=i+7&-8;v=i;i=i+1|0;i=i+7&-8;w=i;i=i+1|0;i=i+7&-8;x=e|0;jN(o,j,x,m,n);oO(q|0,0,12);j=p;hA(p,10,0);if((a[q]&1)==0){y=j+1|0;z=y;A=y;B=p+8|0}else{y=p+8|0;z=c[y>>2]|0;A=j+1|0;B=y}c[r>>2]=z;y=s|0;c[t>>2]=y;c[u>>2]=0;a[v]=1;a[w]=69;j=f|0;f=g|0;g=p|0;C=p+4|0;D=c[m>>2]|0;m=c[n>>2]|0;n=z;z=c[j>>2]|0;L4760:while(1){do{if((z|0)==0){E=0}else{F=c[z+12>>2]|0;if((F|0)==(c[z+16>>2]|0)){G=c3[c[(c[z>>2]|0)+36>>2]&255](z)|0}else{G=c[F>>2]|0}if((G|0)!=-1){E=z;break}c[j>>2]=0;E=0}}while(0);H=(E|0)==0;F=c[f>>2]|0;do{if((F|0)==0){I=4003}else{J=c[F+12>>2]|0;if((J|0)==(c[F+16>>2]|0)){K=c3[c[(c[F>>2]|0)+36>>2]&255](F)|0}else{K=c[J>>2]|0}if((K|0)==-1){c[f>>2]=0;I=4003;break}else{J=(F|0)==0;if(H^J){L=F;M=J;break}else{N=n;O=F;P=J;break L4760}}}}while(0);if((I|0)==4003){I=0;if(H){N=n;O=0;P=1;break}else{L=0;M=1}}F=d[q]|0;J=(F&1|0)==0;if(((c[r>>2]|0)-n|0)==((J?F>>>1:c[C>>2]|0)|0)){if(J){Q=F>>>1;R=F>>>1}else{F=c[C>>2]|0;Q=F;R=F}hA(p,Q<<1,0);if((a[q]&1)==0){S=10}else{S=(c[g>>2]&-2)-1|0}hA(p,S,0);if((a[q]&1)==0){T=A}else{T=c[B>>2]|0}c[r>>2]=T+R;U=T}else{U=n}F=E+12|0;J=c[F>>2]|0;V=E+16|0;if((J|0)==(c[V>>2]|0)){W=c3[c[(c[E>>2]|0)+36>>2]&255](E)|0}else{W=c[J>>2]|0}if((jO(W,v,w,U,r,D,m,o,y,t,u,x)|0)!=0){N=U;O=L;P=M;break}J=c[F>>2]|0;if((J|0)==(c[V>>2]|0)){V=c[(c[E>>2]|0)+40>>2]|0;c3[V&255](E)|0;n=U;z=E;continue}else{c[F>>2]=J+4;n=U;z=E;continue}}z=d[o]|0;if((z&1|0)==0){X=z>>>1}else{X=c[o+4>>2]|0}do{if((X|0)!=0){if((a[v]&1)==0){break}z=c[t>>2]|0;if((z-s|0)>=160){break}U=c[u>>2]|0;c[t>>2]=z+4;c[z>>2]=U}}while(0);h[l>>3]=+nM(N,c[r>>2]|0,k);lD(o,y,c[t>>2]|0,k);do{if(H){Y=0}else{t=c[E+12>>2]|0;if((t|0)==(c[E+16>>2]|0)){Z=c3[c[(c[E>>2]|0)+36>>2]&255](E)|0}else{Z=c[t>>2]|0}if((Z|0)!=-1){Y=E;break}c[j>>2]=0;Y=0}}while(0);j=(Y|0)==0;do{if(P){I=4046}else{E=c[O+12>>2]|0;if((E|0)==(c[O+16>>2]|0)){_=c3[c[(c[O>>2]|0)+36>>2]&255](O)|0}else{_=c[E>>2]|0}if((_|0)==-1){c[f>>2]=0;I=4046;break}if(!(j^(O|0)==0)){break}$=b|0;c[$>>2]=Y;hy(p);hy(o);i=e;return}}while(0);do{if((I|0)==4046){if(j){break}$=b|0;c[$>>2]=Y;hy(p);hy(o);i=e;return}}while(0);c[k>>2]=c[k>>2]|2;$=b|0;c[$>>2]=Y;hy(p);hy(o);i=e;return}function jF(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];jG(a,0,j,k,f,g,h);i=b;return}function jG(b,e,f,g,j,k,l){b=b|0;e=e|0;f=f|0;g=g|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0;e=i;i=i+176|0;m=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[m>>2];m=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[m>>2];m=e+128|0;n=e+136|0;o=e+144|0;p=e+160|0;q=p;r=i;i=i+4|0;i=i+7&-8;s=i;i=i+160|0;t=i;i=i+4|0;i=i+7&-8;u=i;i=i+4|0;i=i+7&-8;v=i;i=i+1|0;i=i+7&-8;w=i;i=i+1|0;i=i+7&-8;x=e|0;jN(o,j,x,m,n);oO(q|0,0,12);j=p;hA(p,10,0);if((a[q]&1)==0){y=j+1|0;z=y;A=y;B=p+8|0}else{y=p+8|0;z=c[y>>2]|0;A=j+1|0;B=y}c[r>>2]=z;y=s|0;c[t>>2]=y;c[u>>2]=0;a[v]=1;a[w]=69;j=f|0;f=g|0;g=p|0;C=p+4|0;D=c[m>>2]|0;m=c[n>>2]|0;n=z;z=c[j>>2]|0;L4846:while(1){do{if((z|0)==0){E=0}else{F=c[z+12>>2]|0;if((F|0)==(c[z+16>>2]|0)){G=c3[c[(c[z>>2]|0)+36>>2]&255](z)|0}else{G=c[F>>2]|0}if((G|0)!=-1){E=z;break}c[j>>2]=0;E=0}}while(0);H=(E|0)==0;F=c[f>>2]|0;do{if((F|0)==0){I=4071}else{J=c[F+12>>2]|0;if((J|0)==(c[F+16>>2]|0)){K=c3[c[(c[F>>2]|0)+36>>2]&255](F)|0}else{K=c[J>>2]|0}if((K|0)==-1){c[f>>2]=0;I=4071;break}else{J=(F|0)==0;if(H^J){L=F;M=J;break}else{N=n;O=F;P=J;break L4846}}}}while(0);if((I|0)==4071){I=0;if(H){N=n;O=0;P=1;break}else{L=0;M=1}}F=d[q]|0;J=(F&1|0)==0;if(((c[r>>2]|0)-n|0)==((J?F>>>1:c[C>>2]|0)|0)){if(J){Q=F>>>1;R=F>>>1}else{F=c[C>>2]|0;Q=F;R=F}hA(p,Q<<1,0);if((a[q]&1)==0){S=10}else{S=(c[g>>2]&-2)-1|0}hA(p,S,0);if((a[q]&1)==0){T=A}else{T=c[B>>2]|0}c[r>>2]=T+R;U=T}else{U=n}F=E+12|0;J=c[F>>2]|0;V=E+16|0;if((J|0)==(c[V>>2]|0)){W=c3[c[(c[E>>2]|0)+36>>2]&255](E)|0}else{W=c[J>>2]|0}if((jO(W,v,w,U,r,D,m,o,y,t,u,x)|0)!=0){N=U;O=L;P=M;break}J=c[F>>2]|0;if((J|0)==(c[V>>2]|0)){V=c[(c[E>>2]|0)+40>>2]|0;c3[V&255](E)|0;n=U;z=E;continue}else{c[F>>2]=J+4;n=U;z=E;continue}}z=d[o]|0;if((z&1|0)==0){X=z>>>1}else{X=c[o+4>>2]|0}do{if((X|0)!=0){if((a[v]&1)==0){break}z=c[t>>2]|0;if((z-s|0)>=160){break}U=c[u>>2]|0;c[t>>2]=z+4;c[z>>2]=U}}while(0);h[l>>3]=+nL(N,c[r>>2]|0,k);lD(o,y,c[t>>2]|0,k);do{if(H){Y=0}else{t=c[E+12>>2]|0;if((t|0)==(c[E+16>>2]|0)){Z=c3[c[(c[E>>2]|0)+36>>2]&255](E)|0}else{Z=c[t>>2]|0}if((Z|0)!=-1){Y=E;break}c[j>>2]=0;Y=0}}while(0);j=(Y|0)==0;do{if(P){I=4114}else{E=c[O+12>>2]|0;if((E|0)==(c[O+16>>2]|0)){_=c3[c[(c[O>>2]|0)+36>>2]&255](O)|0}else{_=c[E>>2]|0}if((_|0)==-1){c[f>>2]=0;I=4114;break}if(!(j^(O|0)==0)){break}$=b|0;c[$>>2]=Y;hy(p);hy(o);i=e;return}}while(0);do{if((I|0)==4114){if(j){break}$=b|0;c[$>>2]=Y;hy(p);hy(o);i=e;return}}while(0);c[k>>2]=c[k>>2]|2;$=b|0;c[$>>2]=Y;hy(p);hy(o);i=e;return}function jH(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0;e=i;i=i+136|0;l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[l>>2];l=e|0;m=e+16|0;n=e+120|0;o=i;i=i+4|0;i=i+7&-8;p=i;i=i+12|0;i=i+7&-8;q=i;i=i+4|0;i=i+7&-8;r=i;i=i+160|0;s=i;i=i+4|0;i=i+7&-8;t=i;i=i+4|0;i=i+7&-8;oO(n|0,0,12);u=p;hS(o,h);h=o|0;o=c[h>>2]|0;if((c[38270]|0)!=-1){c[l>>2]=153080;c[l+4>>2]=14;c[l+8>>2]=0;ht(153080,l,114)}l=(c[38271]|0)-1|0;v=c[o+8>>2]|0;do{if((c[o+12>>2]|0)-v>>2>>>0>l>>>0){w=c[v+(l<<2)>>2]|0;if((w|0)==0){break}x=w;y=m|0;z=c[(c[w>>2]|0)+48>>2]|0;c5[z&15](x,144424,144450,y)|0;x=c[h>>2]|0;g9(x)|0;oO(u|0,0,12);x=p;hA(p,10,0);if((a[u]&1)==0){z=x+1|0;A=z;B=z;C=p+8|0}else{z=p+8|0;A=c[z>>2]|0;B=x+1|0;C=z}c[q>>2]=A;z=r|0;c[s>>2]=z;c[t>>2]=0;x=f|0;w=g|0;D=p|0;E=p+4|0;F=A;G=c[x>>2]|0;L4939:while(1){do{if((G|0)==0){H=0}else{I=c[G+12>>2]|0;if((I|0)==(c[G+16>>2]|0)){J=c3[c[(c[G>>2]|0)+36>>2]&255](G)|0}else{J=c[I>>2]|0}if((J|0)!=-1){H=G;break}c[x>>2]=0;H=0}}while(0);I=(H|0)==0;K=c[w>>2]|0;do{if((K|0)==0){L=4146}else{M=c[K+12>>2]|0;if((M|0)==(c[K+16>>2]|0)){N=c3[c[(c[K>>2]|0)+36>>2]&255](K)|0}else{N=c[M>>2]|0}if((N|0)==-1){c[w>>2]=0;L=4146;break}else{if(I^(K|0)==0){break}else{O=F;break L4939}}}}while(0);if((L|0)==4146){L=0;if(I){O=F;break}}K=d[u]|0;M=(K&1|0)==0;if(((c[q>>2]|0)-F|0)==((M?K>>>1:c[E>>2]|0)|0)){if(M){P=K>>>1;Q=K>>>1}else{K=c[E>>2]|0;P=K;Q=K}hA(p,P<<1,0);if((a[u]&1)==0){R=10}else{R=(c[D>>2]&-2)-1|0}hA(p,R,0);if((a[u]&1)==0){S=B}else{S=c[C>>2]|0}c[q>>2]=S+Q;T=S}else{T=F}K=H+12|0;M=c[K>>2]|0;U=H+16|0;if((M|0)==(c[U>>2]|0)){V=c3[c[(c[H>>2]|0)+36>>2]&255](H)|0}else{V=c[M>>2]|0}if((jI(V,16,T,q,t,0,n,z,s,y)|0)!=0){O=T;break}M=c[K>>2]|0;if((M|0)==(c[U>>2]|0)){U=c[(c[H>>2]|0)+40>>2]|0;c3[U&255](H)|0;F=T;G=H;continue}else{c[K>>2]=M+4;F=T;G=H;continue}}a[O+3|0]=0;do{if((a[154480]|0)==0){if((bD(154480)|0)==0){break}c[36886]=a4(2147483647,134952,0)|0}}while(0);G=jk(O,c[36886]|0,134480,(F=i,i=i+8|0,c[F>>2]=k,F)|0)|0;i=F;if((G|0)!=1){c[j>>2]=4}G=c[x>>2]|0;do{if((G|0)==0){W=0}else{F=c[G+12>>2]|0;if((F|0)==(c[G+16>>2]|0)){X=c3[c[(c[G>>2]|0)+36>>2]&255](G)|0}else{X=c[F>>2]|0}if((X|0)!=-1){W=G;break}c[x>>2]=0;W=0}}while(0);x=(W|0)==0;G=c[w>>2]|0;do{if((G|0)==0){L=4191}else{F=c[G+12>>2]|0;if((F|0)==(c[G+16>>2]|0)){Y=c3[c[(c[G>>2]|0)+36>>2]&255](G)|0}else{Y=c[F>>2]|0}if((Y|0)==-1){c[w>>2]=0;L=4191;break}if(!(x^(G|0)==0)){break}Z=b|0;c[Z>>2]=W;hy(p);hy(n);i=e;return}}while(0);do{if((L|0)==4191){if(x){break}Z=b|0;c[Z>>2]=W;hy(p);hy(n);i=e;return}}while(0);c[j>>2]=c[j>>2]|2;Z=b|0;c[Z>>2]=W;hy(p);hy(n);i=e;return}}while(0);e=cI(4)|0;od(e);bT(e|0,142880,164)}function jI(b,e,f,g,h,i,j,k,l,m){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0;n=c[g>>2]|0;o=(n|0)==(f|0);do{if(o){p=(c[m+96>>2]|0)==(b|0);if(!p){if((c[m+100>>2]|0)!=(b|0)){break}}c[g>>2]=f+1;a[f]=p?43:45;c[h>>2]=0;q=0;return q|0}}while(0);p=d[j]|0;if((p&1|0)==0){r=p>>>1}else{r=c[j+4>>2]|0}if((r|0)!=0&(b|0)==(i|0)){i=c[l>>2]|0;if((i-k|0)>=160){q=0;return q|0}k=c[h>>2]|0;c[l>>2]=i+4;c[i>>2]=k;c[h>>2]=0;q=0;return q|0}k=m+104|0;i=m;while(1){if((i|0)==(k|0)){s=k;break}if((c[i>>2]|0)==(b|0)){s=i;break}else{i=i+4|0}}i=s-m|0;m=i>>2;if((i|0)>92){q=-1;return q|0}do{if((e|0)==16){if((i|0)<88){break}if(o){q=-1;return q|0}if((n-f|0)>=3){q=-1;return q|0}if((a[n-1|0]|0)!=48){q=-1;return q|0}c[h>>2]=0;s=a[144424+m|0]|0;b=c[g>>2]|0;c[g>>2]=b+1;a[b]=s;q=0;return q|0}else if((e|0)==8|(e|0)==10){if((m|0)<(e|0)){break}else{q=-1}return q|0}}while(0);e=a[144424+m|0]|0;c[g>>2]=n+1;a[n]=e;c[h>>2]=(c[h>>2]|0)+1;q=0;return q|0}function jJ(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;g=i;i=i+40|0;h=g|0;j=g+16|0;k=g+32|0;hS(k,d);d=k|0;k=c[d>>2]|0;if((c[38272]|0)!=-1){c[j>>2]=153088;c[j+4>>2]=14;c[j+8>>2]=0;ht(153088,j,114)}j=(c[38273]|0)-1|0;l=c[k+8>>2]|0;do{if((c[k+12>>2]|0)-l>>2>>>0>j>>>0){m=c[l+(j<<2)>>2]|0;if((m|0)==0){break}n=m;o=c[(c[m>>2]|0)+32>>2]|0;c5[o&15](n,144424,144450,e)|0;n=c[d>>2]|0;if((c[38176]|0)!=-1){c[h>>2]=152704;c[h+4>>2]=14;c[h+8>>2]=0;ht(152704,h,114)}o=(c[38177]|0)-1|0;m=c[n+8>>2]|0;do{if((c[n+12>>2]|0)-m>>2>>>0>o>>>0){p=c[m+(o<<2)>>2]|0;if((p|0)==0){break}q=p;a[f]=c3[c[(c[p>>2]|0)+16>>2]&255](q)|0;c1[c[(c[p>>2]|0)+20>>2]&127](b,q);q=c[d>>2]|0;g9(q)|0;i=g;return}}while(0);o=cI(4)|0;od(o);bT(o|0,142880,164)}}while(0);g=cI(4)|0;od(g);bT(g|0,142880,164)}function jK(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;h=i;i=i+40|0;j=h|0;k=h+16|0;l=h+32|0;hS(l,d);d=l|0;l=c[d>>2]|0;if((c[38272]|0)!=-1){c[k>>2]=153088;c[k+4>>2]=14;c[k+8>>2]=0;ht(153088,k,114)}k=(c[38273]|0)-1|0;m=c[l+8>>2]|0;do{if((c[l+12>>2]|0)-m>>2>>>0>k>>>0){n=c[m+(k<<2)>>2]|0;if((n|0)==0){break}o=n;p=c[(c[n>>2]|0)+32>>2]|0;c5[p&15](o,144424,144456,e)|0;o=c[d>>2]|0;if((c[38176]|0)!=-1){c[j>>2]=152704;c[j+4>>2]=14;c[j+8>>2]=0;ht(152704,j,114)}p=(c[38177]|0)-1|0;n=c[o+8>>2]|0;do{if((c[o+12>>2]|0)-n>>2>>>0>p>>>0){q=c[n+(p<<2)>>2]|0;if((q|0)==0){break}r=q;s=q;a[f]=c3[c[(c[s>>2]|0)+12>>2]&255](r)|0;a[g]=c3[c[(c[s>>2]|0)+16>>2]&255](r)|0;c1[c[(c[q>>2]|0)+20>>2]&127](b,r);r=c[d>>2]|0;g9(r)|0;i=h;return}}while(0);p=cI(4)|0;od(p);bT(p|0,142880,164)}}while(0);h=cI(4)|0;od(h);bT(h|0,142880,164)}function jL(b,e,f,g,h,i,j,k,l,m,n,o){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0,q=0,r=0,s=0,t=0;if(b<<24>>24==i<<24>>24){if((a[e]&1)==0){p=-1;return p|0}a[e]=0;i=c[h>>2]|0;c[h>>2]=i+1;a[i]=46;i=d[k]|0;if((i&1|0)==0){q=i>>>1}else{q=c[k+4>>2]|0}if((q|0)==0){p=0;return p|0}q=c[m>>2]|0;if((q-l|0)>=160){p=0;return p|0}i=c[n>>2]|0;c[m>>2]=q+4;c[q>>2]=i;p=0;return p|0}do{if(b<<24>>24==j<<24>>24){i=d[k]|0;if((i&1|0)==0){r=i>>>1}else{r=c[k+4>>2]|0}if((r|0)==0){break}if((a[e]&1)==0){p=-1;return p|0}i=c[m>>2]|0;if((i-l|0)>=160){p=0;return p|0}q=c[n>>2]|0;c[m>>2]=i+4;c[i>>2]=q;c[n>>2]=0;p=0;return p|0}}while(0);r=o+32|0;j=o;while(1){if((j|0)==(r|0)){s=r;break}if((a[j]|0)==b<<24>>24){s=j;break}else{j=j+1|0}}j=s-o|0;if((j|0)>31){p=-1;return p|0}o=a[144424+j|0]|0;if((j|0)==22|(j|0)==23){a[f]=80;s=c[h>>2]|0;c[h>>2]=s+1;a[s]=o;p=0;return p|0}else if((j|0)==25|(j|0)==24){s=c[h>>2]|0;do{if((s|0)!=(g|0)){if((a[s-1|0]&95|0)==(a[f]&127|0)){break}else{p=-1}return p|0}}while(0);c[h>>2]=s+1;a[s]=o;p=0;return p|0}else{s=a[f]|0;do{if((o&95|0)==(s<<24>>24|0)){a[f]=s|-128;if((a[e]&1)==0){break}a[e]=0;g=d[k]|0;if((g&1|0)==0){t=g>>>1}else{t=c[k+4>>2]|0}if((t|0)==0){break}g=c[m>>2]|0;if((g-l|0)>=160){break}b=c[n>>2]|0;c[m>>2]=g+4;c[g>>2]=b}}while(0);m=c[h>>2]|0;c[h>>2]=m+1;a[m]=o;if((j|0)>21){p=0;return p|0}c[n>>2]=(c[n>>2]|0)+1;p=0;return p|0}return 0}function jM(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;f=i;i=i+40|0;g=f|0;h=f+16|0;j=f+32|0;hS(j,b);b=j|0;j=c[b>>2]|0;if((c[38270]|0)!=-1){c[h>>2]=153080;c[h+4>>2]=14;c[h+8>>2]=0;ht(153080,h,114)}h=(c[38271]|0)-1|0;k=c[j+8>>2]|0;do{if((c[j+12>>2]|0)-k>>2>>>0>h>>>0){l=c[k+(h<<2)>>2]|0;if((l|0)==0){break}m=l;n=c[(c[l>>2]|0)+48>>2]|0;c5[n&15](m,144424,144450,d)|0;m=c[b>>2]|0;if((c[38174]|0)!=-1){c[g>>2]=152696;c[g+4>>2]=14;c[g+8>>2]=0;ht(152696,g,114)}n=(c[38175]|0)-1|0;l=c[m+8>>2]|0;do{if((c[m+12>>2]|0)-l>>2>>>0>n>>>0){o=c[l+(n<<2)>>2]|0;if((o|0)==0){break}p=o;c[e>>2]=c3[c[(c[o>>2]|0)+16>>2]&255](p)|0;c1[c[(c[o>>2]|0)+20>>2]&127](a,p);p=c[b>>2]|0;g9(p)|0;i=f;return}}while(0);n=cI(4)|0;od(n);bT(n|0,142880,164)}}while(0);f=cI(4)|0;od(f);bT(f|0,142880,164)}function jN(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;g=i;i=i+40|0;h=g|0;j=g+16|0;k=g+32|0;hS(k,b);b=k|0;k=c[b>>2]|0;if((c[38270]|0)!=-1){c[j>>2]=153080;c[j+4>>2]=14;c[j+8>>2]=0;ht(153080,j,114)}j=(c[38271]|0)-1|0;l=c[k+8>>2]|0;do{if((c[k+12>>2]|0)-l>>2>>>0>j>>>0){m=c[l+(j<<2)>>2]|0;if((m|0)==0){break}n=m;o=c[(c[m>>2]|0)+48>>2]|0;c5[o&15](n,144424,144456,d)|0;n=c[b>>2]|0;if((c[38174]|0)!=-1){c[h>>2]=152696;c[h+4>>2]=14;c[h+8>>2]=0;ht(152696,h,114)}o=(c[38175]|0)-1|0;m=c[n+8>>2]|0;do{if((c[n+12>>2]|0)-m>>2>>>0>o>>>0){p=c[m+(o<<2)>>2]|0;if((p|0)==0){break}q=p;r=p;c[e>>2]=c3[c[(c[r>>2]|0)+12>>2]&255](q)|0;c[f>>2]=c3[c[(c[r>>2]|0)+16>>2]&255](q)|0;c1[c[(c[p>>2]|0)+20>>2]&127](a,q);q=c[b>>2]|0;g9(q)|0;i=g;return}}while(0);o=cI(4)|0;od(o);bT(o|0,142880,164)}}while(0);g=cI(4)|0;od(g);bT(g|0,142880,164)}function jO(b,e,f,g,h,i,j,k,l,m,n,o){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0,q=0,r=0,s=0,t=0;if((b|0)==(i|0)){if((a[e]&1)==0){p=-1;return p|0}a[e]=0;i=c[h>>2]|0;c[h>>2]=i+1;a[i]=46;i=d[k]|0;if((i&1|0)==0){q=i>>>1}else{q=c[k+4>>2]|0}if((q|0)==0){p=0;return p|0}q=c[m>>2]|0;if((q-l|0)>=160){p=0;return p|0}i=c[n>>2]|0;c[m>>2]=q+4;c[q>>2]=i;p=0;return p|0}do{if((b|0)==(j|0)){i=d[k]|0;if((i&1|0)==0){r=i>>>1}else{r=c[k+4>>2]|0}if((r|0)==0){break}if((a[e]&1)==0){p=-1;return p|0}i=c[m>>2]|0;if((i-l|0)>=160){p=0;return p|0}q=c[n>>2]|0;c[m>>2]=i+4;c[i>>2]=q;c[n>>2]=0;p=0;return p|0}}while(0);r=o+128|0;j=o;while(1){if((j|0)==(r|0)){s=r;break}if((c[j>>2]|0)==(b|0)){s=j;break}else{j=j+4|0}}j=s-o|0;o=j>>2;if((j|0)>124){p=-1;return p|0}s=a[144424+o|0]|0;do{if((o|0)==22|(o|0)==23){a[f]=80}else if((o|0)==25|(o|0)==24){b=c[h>>2]|0;do{if((b|0)!=(g|0)){if((a[b-1|0]&95|0)==(a[f]&127|0)){break}else{p=-1}return p|0}}while(0);c[h>>2]=b+1;a[b]=s;p=0;return p|0}else{r=a[f]|0;if((s&95|0)!=(r<<24>>24|0)){break}a[f]=r|-128;if((a[e]&1)==0){break}a[e]=0;r=d[k]|0;if((r&1|0)==0){t=r>>>1}else{t=c[k+4>>2]|0}if((t|0)==0){break}r=c[m>>2]|0;if((r-l|0)>=160){break}q=c[n>>2]|0;c[m>>2]=r+4;c[r>>2]=q}}while(0);m=c[h>>2]|0;c[h>>2]=m+1;a[m]=s;if((j|0)>84){p=0;return p|0}c[n>>2]=(c[n>>2]|0)+1;p=0;return p|0}function jP(a){a=a|0;g7(a|0);oF(a);return}function jQ(a){a=a|0;g7(a|0);return}function jR(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;j=i;i=i+48|0;k=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[k>>2];k=j|0;l=j+16|0;m=j+24|0;n=j+32|0;if((c[f+4>>2]&1|0)==0){o=c[(c[d>>2]|0)+24>>2]|0;c[l>>2]=c[e>>2];c9[o&63](b,d,l,f,g,h&1);i=j;return}hS(m,f);f=m|0;m=c[f>>2]|0;if((c[38176]|0)!=-1){c[k>>2]=152704;c[k+4>>2]=14;c[k+8>>2]=0;ht(152704,k,114)}k=(c[38177]|0)-1|0;g=c[m+8>>2]|0;do{if((c[m+12>>2]|0)-g>>2>>>0>k>>>0){l=c[g+(k<<2)>>2]|0;if((l|0)==0){break}d=l;o=c[f>>2]|0;g9(o)|0;o=c[l>>2]|0;if(h){c1[c[o+24>>2]&127](n,d)}else{c1[c[o+28>>2]&127](n,d)}d=n;o=n;l=a[o]|0;if((l&1)==0){p=d+1|0;q=p;r=p;s=n+8|0}else{p=n+8|0;q=c[p>>2]|0;r=d+1|0;s=p}p=e|0;d=n+4|0;t=q;u=l;while(1){if((u&1)==0){v=r}else{v=c[s>>2]|0}l=u&255;if((t|0)==(v+((l&1|0)==0?l>>>1:c[d>>2]|0)|0)){break}l=a[t]|0;w=c[p>>2]|0;do{if((w|0)!=0){x=w+24|0;y=c[x>>2]|0;if((y|0)!=(c[w+28>>2]|0)){c[x>>2]=y+1;a[y]=l;break}if((df[c[(c[w>>2]|0)+52>>2]&31](w,l&255)|0)!=-1){break}c[p>>2]=0}}while(0);t=t+1|0;u=a[o]|0}c[b>>2]=c[p>>2];hy(n);i=j;return}}while(0);j=cI(4)|0;od(j);bT(j|0,142880,164)}function jS(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;d=i;i=i+80|0;j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=d|0;k=d+8|0;l=d+24|0;m=d+48|0;n=d+56|0;o=d+64|0;p=d+72|0;q=j|0;a[q]=a[136448]|0;a[q+1|0]=a[136449]|0;a[q+2|0]=a[136450]|0;a[q+3|0]=a[136451]|0;a[q+4|0]=a[136452]|0;a[q+5|0]=a[136453]|0;r=j+1|0;s=f+4|0;t=c[s>>2]|0;if((t&2048|0)==0){u=r}else{a[r]=43;u=j+2|0}if((t&512|0)==0){v=u}else{a[u]=35;v=u+1|0}a[v]=108;u=v+1|0;v=t&74;do{if((v|0)==8){if((t&16384|0)==0){a[u]=120;break}else{a[u]=88;break}}else if((v|0)==64){a[u]=111}else{a[u]=100}}while(0);u=k|0;do{if((a[154480]|0)==0){if((bD(154480)|0)==0){break}c[36886]=a4(2147483647,134952,0)|0}}while(0);v=jT(u,12,c[36886]|0,q,(q=i,i=i+8|0,c[q>>2]=h,q)|0)|0;i=q;q=k+v|0;h=c[s>>2]&176;do{if((h|0)==32){w=q}else if((h|0)==16){s=a[u]|0;if((s<<24>>24|0)==45|(s<<24>>24|0)==43){w=k+1|0;break}if(!((v|0)>1&s<<24>>24==48)){x=4454;break}s=a[k+1|0]|0;if(!((s<<24>>24|0)==120|(s<<24>>24|0)==88)){x=4454;break}w=k+2|0}else{x=4454}}while(0);if((x|0)==4454){w=u}x=l|0;hS(o,f);jU(u,w,q,x,m,n,o);g9(c[o>>2]|0)|0;c[p>>2]=c[e>>2];jV(b,p,x,c[m>>2]|0,c[n>>2]|0,f,g);i=d;return}function jT(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;g=i;i=i+16|0;h=g|0;j=h;c[j>>2]=f;c[j+4>>2]=0;j=cr(d|0)|0;d=cs(a|0,b|0,e|0,h|0)|0;if((j|0)==0){i=g;return d|0}cr(j|0)|0;i=g;return d|0}function jU(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0;l=i;i=i+48|0;m=l|0;n=l+16|0;o=l+32|0;p=k|0;k=c[p>>2]|0;if((c[38272]|0)!=-1){c[n>>2]=153088;c[n+4>>2]=14;c[n+8>>2]=0;ht(153088,n,114)}n=(c[38273]|0)-1|0;q=c[k+8>>2]|0;if((c[k+12>>2]|0)-q>>2>>>0<=n>>>0){r=cI(4)|0;s=r;od(s);bT(r|0,142880,164)}k=c[q+(n<<2)>>2]|0;if((k|0)==0){r=cI(4)|0;s=r;od(s);bT(r|0,142880,164)}r=k;s=c[p>>2]|0;if((c[38176]|0)!=-1){c[m>>2]=152704;c[m+4>>2]=14;c[m+8>>2]=0;ht(152704,m,114)}m=(c[38177]|0)-1|0;p=c[s+8>>2]|0;if((c[s+12>>2]|0)-p>>2>>>0<=m>>>0){t=cI(4)|0;u=t;od(u);bT(t|0,142880,164)}s=c[p+(m<<2)>>2]|0;if((s|0)==0){t=cI(4)|0;u=t;od(u);bT(t|0,142880,164)}t=s;c1[c[(c[s>>2]|0)+20>>2]&127](o,t);u=o;m=o;p=d[m]|0;if((p&1|0)==0){v=p>>>1}else{v=c[o+4>>2]|0}do{if((v|0)==0){p=c[(c[k>>2]|0)+32>>2]|0;c5[p&15](r,b,f,g)|0;c[j>>2]=g+(f-b)}else{c[j>>2]=g;p=a[b]|0;if((p<<24>>24|0)==45|(p<<24>>24|0)==43){n=df[c[(c[k>>2]|0)+28>>2]&31](r,p)|0;p=c[j>>2]|0;c[j>>2]=p+1;a[p]=n;w=b+1|0}else{w=b}do{if((f-w|0)>1){if((a[w]|0)!=48){x=w;break}n=w+1|0;p=a[n]|0;if(!((p<<24>>24|0)==120|(p<<24>>24|0)==88)){x=w;break}p=k;q=df[c[(c[p>>2]|0)+28>>2]&31](r,48)|0;y=c[j>>2]|0;c[j>>2]=y+1;a[y]=q;q=df[c[(c[p>>2]|0)+28>>2]&31](r,a[n]|0)|0;n=c[j>>2]|0;c[j>>2]=n+1;a[n]=q;x=w+2|0}else{x=w}}while(0);do{if((x|0)!=(f|0)){q=f-1|0;if(x>>>0<q>>>0){z=x;A=q}else{break}do{q=a[z]|0;a[z]=a[A]|0;a[A]=q;z=z+1|0;A=A-1|0;}while(z>>>0<A>>>0)}}while(0);q=c3[c[(c[s>>2]|0)+16>>2]&255](t)|0;if(x>>>0<f>>>0){n=u+1|0;p=k;y=o+4|0;B=o+8|0;C=0;D=0;E=x;while(1){F=(a[m]&1)==0;do{if((a[(F?n:c[B>>2]|0)+D|0]|0)==0){G=D;H=C}else{if((C|0)!=(a[(F?n:c[B>>2]|0)+D|0]|0)){G=D;H=C;break}I=c[j>>2]|0;c[j>>2]=I+1;a[I]=q;I=d[m]|0;G=(D>>>0<(((I&1|0)==0?I>>>1:c[y>>2]|0)-1|0)>>>0)+D|0;H=0}}while(0);F=df[c[(c[p>>2]|0)+28>>2]&31](r,a[E]|0)|0;I=c[j>>2]|0;c[j>>2]=I+1;a[I]=F;F=E+1|0;if(F>>>0<f>>>0){C=H+1|0;D=G;E=F}else{break}}}E=g+(x-b)|0;D=c[j>>2]|0;if((E|0)==(D|0)){break}C=D-1|0;if(E>>>0<C>>>0){J=E;K=C}else{break}do{C=a[J]|0;a[J]=a[K]|0;a[K]=C;J=J+1|0;K=K-1|0;}while(J>>>0<K>>>0)}}while(0);if((e|0)==(f|0)){L=c[j>>2]|0;c[h>>2]=L;hy(o);i=l;return}else{L=g+(e-b)|0;c[h>>2]=L;hy(o);i=l;return}}function jV(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;k=i;i=i+16|0;l=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[l>>2];l=k|0;m=d|0;d=c[m>>2]|0;if((d|0)==0){c[b>>2]=0;i=k;return}n=g;g=e;o=n-g|0;p=h+12|0;h=c[p>>2]|0;q=(h|0)>(o|0)?h-o|0:0;o=f;h=o-g|0;do{if((h|0)>0){if((c6[c[(c[d>>2]|0)+48>>2]&63](d,e,h)|0)==(h|0)){break}c[m>>2]=0;c[b>>2]=0;i=k;return}}while(0);do{if((q|0)>0){hx(l,q,j);if((a[l]&1)==0){r=l+1|0}else{r=c[l+8>>2]|0}if((c6[c[(c[d>>2]|0)+48>>2]&63](d,r,q)|0)==(q|0)){hy(l);break}c[m>>2]=0;c[b>>2]=0;hy(l);i=k;return}}while(0);l=n-o|0;do{if((l|0)>0){if((c6[c[(c[d>>2]|0)+48>>2]&63](d,f,l)|0)==(l|0)){break}c[m>>2]=0;c[b>>2]=0;i=k;return}}while(0);c[p>>2]=0;c[b>>2]=d;i=k;return}function jW(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;d=i;i=i+112|0;k=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[k>>2];k=d|0;l=d+8|0;m=d+32|0;n=d+80|0;o=d+88|0;p=d+96|0;q=d+104|0;c[k>>2]=37;c[k+4>>2]=0;r=k;k=r+1|0;s=f+4|0;t=c[s>>2]|0;if((t&2048|0)==0){u=k}else{a[k]=43;u=r+2|0}if((t&512|0)==0){v=u}else{a[u]=35;v=u+1|0}a[v]=108;a[v+1|0]=108;u=v+2|0;v=t&74;do{if((v|0)==8){if((t&16384|0)==0){a[u]=120;break}else{a[u]=88;break}}else if((v|0)==64){a[u]=111}else{a[u]=100}}while(0);u=l|0;do{if((a[154480]|0)==0){if((bD(154480)|0)==0){break}c[36886]=a4(2147483647,134952,0)|0}}while(0);v=jT(u,22,c[36886]|0,r,(r=i,i=i+16|0,c[r>>2]=h,c[r+8>>2]=j,r)|0)|0;i=r;r=l+v|0;j=c[s>>2]&176;do{if((j|0)==32){w=r}else if((j|0)==16){s=a[u]|0;if((s<<24>>24|0)==45|(s<<24>>24|0)==43){w=l+1|0;break}if(!((v|0)>1&s<<24>>24==48)){x=4561;break}s=a[l+1|0]|0;if(!((s<<24>>24|0)==120|(s<<24>>24|0)==88)){x=4561;break}w=l+2|0}else{x=4561}}while(0);if((x|0)==4561){w=u}x=m|0;hS(p,f);jU(u,w,r,x,n,o,p);g9(c[p>>2]|0)|0;c[q>>2]=c[e>>2];jV(b,q,x,c[n>>2]|0,c[o>>2]|0,f,g);i=d;return}function jX(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;d=i;i=i+80|0;j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=d|0;k=d+8|0;l=d+24|0;m=d+48|0;n=d+56|0;o=d+64|0;p=d+72|0;q=j|0;a[q]=a[136448]|0;a[q+1|0]=a[136449]|0;a[q+2|0]=a[136450]|0;a[q+3|0]=a[136451]|0;a[q+4|0]=a[136452]|0;a[q+5|0]=a[136453]|0;r=j+1|0;s=f+4|0;t=c[s>>2]|0;if((t&2048|0)==0){u=r}else{a[r]=43;u=j+2|0}if((t&512|0)==0){v=u}else{a[u]=35;v=u+1|0}a[v]=108;u=v+1|0;v=t&74;do{if((v|0)==8){if((t&16384|0)==0){a[u]=120;break}else{a[u]=88;break}}else if((v|0)==64){a[u]=111}else{a[u]=117}}while(0);u=k|0;do{if((a[154480]|0)==0){if((bD(154480)|0)==0){break}c[36886]=a4(2147483647,134952,0)|0}}while(0);v=jT(u,12,c[36886]|0,q,(q=i,i=i+8|0,c[q>>2]=h,q)|0)|0;i=q;q=k+v|0;h=c[s>>2]&176;do{if((h|0)==16){s=a[u]|0;if((s<<24>>24|0)==45|(s<<24>>24|0)==43){w=k+1|0;break}if(!((v|0)>1&s<<24>>24==48)){x=4586;break}s=a[k+1|0]|0;if(!((s<<24>>24|0)==120|(s<<24>>24|0)==88)){x=4586;break}w=k+2|0}else if((h|0)==32){w=q}else{x=4586}}while(0);if((x|0)==4586){w=u}x=l|0;hS(o,f);jU(u,w,q,x,m,n,o);g9(c[o>>2]|0)|0;c[p>>2]=c[e>>2];jV(b,p,x,c[m>>2]|0,c[n>>2]|0,f,g);i=d;return}function jY(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;d=i;i=i+112|0;k=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[k>>2];k=d|0;l=d+8|0;m=d+32|0;n=d+80|0;o=d+88|0;p=d+96|0;q=d+104|0;c[k>>2]=37;c[k+4>>2]=0;r=k;k=r+1|0;s=f+4|0;t=c[s>>2]|0;if((t&2048|0)==0){u=k}else{a[k]=43;u=r+2|0}if((t&512|0)==0){v=u}else{a[u]=35;v=u+1|0}a[v]=108;a[v+1|0]=108;u=v+2|0;v=t&74;do{if((v|0)==8){if((t&16384|0)==0){a[u]=120;break}else{a[u]=88;break}}else if((v|0)==64){a[u]=111}else{a[u]=117}}while(0);u=l|0;do{if((a[154480]|0)==0){if((bD(154480)|0)==0){break}c[36886]=a4(2147483647,134952,0)|0}}while(0);v=jT(u,23,c[36886]|0,r,(r=i,i=i+16|0,c[r>>2]=h,c[r+8>>2]=j,r)|0)|0;i=r;r=l+v|0;j=c[s>>2]&176;do{if((j|0)==16){s=a[u]|0;if((s<<24>>24|0)==45|(s<<24>>24|0)==43){w=l+1|0;break}if(!((v|0)>1&s<<24>>24==48)){x=4611;break}s=a[l+1|0]|0;if(!((s<<24>>24|0)==120|(s<<24>>24|0)==88)){x=4611;break}w=l+2|0}else if((j|0)==32){w=r}else{x=4611}}while(0);if((x|0)==4611){w=u}x=m|0;hS(p,f);jU(u,w,r,x,n,o,p);g9(c[p>>2]|0)|0;c[q>>2]=c[e>>2];jV(b,q,x,c[n>>2]|0,c[o>>2]|0,f,g);i=d;return}function jZ(b,d,e,f,g,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=+j;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;d=i;i=i+152|0;k=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[k>>2];k=d|0;l=d+8|0;m=d+40|0;n=d+48|0;o=d+112|0;p=d+120|0;q=d+128|0;r=d+136|0;s=d+144|0;c[k>>2]=37;c[k+4>>2]=0;t=k;k=t+1|0;u=f+4|0;v=c[u>>2]|0;if((v&2048|0)==0){w=k}else{a[k]=43;w=t+2|0}if((v&1024|0)==0){x=w}else{a[w]=35;x=w+1|0}w=v&260;k=v>>>14;do{if((w|0)==260){if((k&1|0)==0){a[x]=97;y=0;break}else{a[x]=65;y=0;break}}else{a[x]=46;v=x+2|0;a[x+1|0]=42;if((w|0)==4){if((k&1|0)==0){a[v]=102;y=1;break}else{a[v]=70;y=1;break}}else if((w|0)==256){if((k&1|0)==0){a[v]=101;y=1;break}else{a[v]=69;y=1;break}}else{if((k&1|0)==0){a[v]=103;y=1;break}else{a[v]=71;y=1;break}}}}while(0);k=l|0;c[m>>2]=k;do{if((a[154480]|0)==0){if((bD(154480)|0)==0){break}c[36886]=a4(2147483647,134952,0)|0}}while(0);l=c[36886]|0;if(y){w=jT(k,30,l,t,(z=i,i=i+16|0,c[z>>2]=c[f+8>>2],h[z+8>>3]=j,z)|0)|0;i=z;A=w}else{w=jT(k,30,l,t,(z=i,i=i+8|0,h[z>>3]=j,z)|0)|0;i=z;A=w}do{if((A|0)>29){w=(a[154480]|0)==0;if(y){do{if(w){if((bD(154480)|0)==0){break}c[36886]=a4(2147483647,134952,0)|0}}while(0);l=j_(m,c[36886]|0,t,(z=i,i=i+16|0,c[z>>2]=c[f+8>>2],h[z+8>>3]=j,z)|0)|0;i=z;B=l}else{do{if(w){if((bD(154480)|0)==0){break}c[36886]=a4(2147483647,134952,0)|0}}while(0);w=j_(m,c[36886]|0,t,(z=i,i=i+16|0,c[z>>2]=c[f+8>>2],h[z+8>>3]=j,z)|0)|0;i=z;B=w}w=c[m>>2]|0;if((w|0)!=0){C=B;D=w;E=w;break}oK();w=c[m>>2]|0;C=B;D=w;E=w}else{C=A;D=0;E=c[m>>2]|0}}while(0);A=E+C|0;B=c[u>>2]&176;do{if((B|0)==16){u=a[E]|0;if((u<<24>>24|0)==45|(u<<24>>24|0)==43){F=E+1|0;break}if(!((C|0)>1&u<<24>>24==48)){G=4667;break}u=a[E+1|0]|0;if(!((u<<24>>24|0)==120|(u<<24>>24|0)==88)){G=4667;break}F=E+2|0}else if((B|0)==32){F=A}else{G=4667}}while(0);if((G|0)==4667){F=E}do{if((E|0)==(k|0)){H=n|0;I=0;J=k}else{G=oy(C<<1)|0;if((G|0)!=0){H=G;I=G;J=E;break}oK();H=0;I=0;J=c[m>>2]|0}}while(0);hS(q,f);j$(J,F,A,H,o,p,q);g9(c[q>>2]|0)|0;q=e|0;c[s>>2]=c[q>>2];jV(r,s,H,c[o>>2]|0,c[p>>2]|0,f,g);g=c[r>>2]|0;c[q>>2]=g;c[b>>2]=g;if((I|0)!=0){oz(I)}if((D|0)==0){i=d;return}oz(D);i=d;return}function j_(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;i=i+16|0;g=f|0;h=g;c[h>>2]=e;c[h+4>>2]=0;h=cr(b|0)|0;b=cN(a|0,d|0,g|0)|0;if((h|0)==0){i=f;return b|0}cr(h|0)|0;i=f;return b|0}function j$(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0;l=i;i=i+48|0;m=l|0;n=l+16|0;o=l+32|0;p=k|0;k=c[p>>2]|0;if((c[38272]|0)!=-1){c[n>>2]=153088;c[n+4>>2]=14;c[n+8>>2]=0;ht(153088,n,114)}n=(c[38273]|0)-1|0;q=c[k+8>>2]|0;if((c[k+12>>2]|0)-q>>2>>>0<=n>>>0){r=cI(4)|0;s=r;od(s);bT(r|0,142880,164)}k=c[q+(n<<2)>>2]|0;if((k|0)==0){r=cI(4)|0;s=r;od(s);bT(r|0,142880,164)}r=k;s=c[p>>2]|0;if((c[38176]|0)!=-1){c[m>>2]=152704;c[m+4>>2]=14;c[m+8>>2]=0;ht(152704,m,114)}m=(c[38177]|0)-1|0;p=c[s+8>>2]|0;if((c[s+12>>2]|0)-p>>2>>>0<=m>>>0){t=cI(4)|0;u=t;od(u);bT(t|0,142880,164)}s=c[p+(m<<2)>>2]|0;if((s|0)==0){t=cI(4)|0;u=t;od(u);bT(t|0,142880,164)}t=s;c1[c[(c[s>>2]|0)+20>>2]&127](o,t);c[j>>2]=g;u=a[b]|0;if((u<<24>>24|0)==45|(u<<24>>24|0)==43){m=df[c[(c[k>>2]|0)+28>>2]&31](r,u)|0;u=c[j>>2]|0;c[j>>2]=u+1;a[u]=m;v=b+1|0}else{v=b}m=f;L5639:do{if((m-v|0)>1){if((a[v]|0)!=48){w=v;x=4733;break}u=v+1|0;p=a[u]|0;if(!((p<<24>>24|0)==120|(p<<24>>24|0)==88)){w=v;x=4733;break}p=k;n=df[c[(c[p>>2]|0)+28>>2]&31](r,48)|0;q=c[j>>2]|0;c[j>>2]=q+1;a[q]=n;n=v+2|0;q=df[c[(c[p>>2]|0)+28>>2]&31](r,a[u]|0)|0;u=c[j>>2]|0;c[j>>2]=u+1;a[u]=q;q=n;while(1){if(q>>>0>=f>>>0){y=q;z=n;break L5639}u=a[q]|0;do{if((a[154480]|0)==0){if((bD(154480)|0)==0){break}c[36886]=a4(2147483647,134952,0)|0}}while(0);if((aT(u<<24>>24|0,c[36886]|0)|0)==0){y=q;z=n;break}else{q=q+1|0}}}else{w=v;x=4733}}while(0);L5654:do{if((x|0)==4733){while(1){x=0;if(w>>>0>=f>>>0){y=w;z=v;break L5654}q=a[w]|0;do{if((a[154480]|0)==0){if((bD(154480)|0)==0){break}c[36886]=a4(2147483647,134952,0)|0}}while(0);if((cz(q<<24>>24|0,c[36886]|0)|0)==0){y=w;z=v;break}else{w=w+1|0;x=4733}}}}while(0);x=o;w=o;v=d[w]|0;if((v&1|0)==0){A=v>>>1}else{A=c[o+4>>2]|0}do{if((A|0)==0){v=c[j>>2]|0;u=c[(c[k>>2]|0)+32>>2]|0;c5[u&15](r,z,y,v)|0;c[j>>2]=(c[j>>2]|0)+(y-z)}else{do{if((z|0)!=(y|0)){v=y-1|0;if(z>>>0<v>>>0){B=z;C=v}else{break}do{v=a[B]|0;a[B]=a[C]|0;a[C]=v;B=B+1|0;C=C-1|0;}while(B>>>0<C>>>0)}}while(0);q=c3[c[(c[s>>2]|0)+16>>2]&255](t)|0;if(z>>>0<y>>>0){v=x+1|0;u=o+4|0;n=o+8|0;p=k;D=0;E=0;F=z;while(1){G=(a[w]&1)==0;do{if((a[(G?v:c[n>>2]|0)+E|0]|0)>0){if((D|0)!=(a[(G?v:c[n>>2]|0)+E|0]|0)){H=E;I=D;break}J=c[j>>2]|0;c[j>>2]=J+1;a[J]=q;J=d[w]|0;H=(E>>>0<(((J&1|0)==0?J>>>1:c[u>>2]|0)-1|0)>>>0)+E|0;I=0}else{H=E;I=D}}while(0);G=df[c[(c[p>>2]|0)+28>>2]&31](r,a[F]|0)|0;J=c[j>>2]|0;c[j>>2]=J+1;a[J]=G;G=F+1|0;if(G>>>0<y>>>0){D=I+1|0;E=H;F=G}else{break}}}F=g+(z-b)|0;E=c[j>>2]|0;if((F|0)==(E|0)){break}D=E-1|0;if(F>>>0<D>>>0){K=F;L=D}else{break}do{D=a[K]|0;a[K]=a[L]|0;a[L]=D;K=K+1|0;L=L-1|0;}while(K>>>0<L>>>0)}}while(0);L5693:do{if(y>>>0<f>>>0){L=k;K=y;while(1){z=a[K]|0;if(z<<24>>24==46){break}H=df[c[(c[L>>2]|0)+28>>2]&31](r,z)|0;z=c[j>>2]|0;c[j>>2]=z+1;a[z]=H;H=K+1|0;if(H>>>0<f>>>0){K=H}else{M=H;break L5693}}L=c3[c[(c[s>>2]|0)+12>>2]&255](t)|0;H=c[j>>2]|0;c[j>>2]=H+1;a[H]=L;M=K+1|0}else{M=y}}while(0);c5[c[(c[k>>2]|0)+32>>2]&15](r,M,f,c[j>>2]|0)|0;r=(c[j>>2]|0)+(m-M)|0;c[j>>2]=r;if((e|0)==(f|0)){N=r;c[h>>2]=N;hy(o);i=l;return}N=g+(e-b)|0;c[h>>2]=N;hy(o);i=l;return}function j0(b,d,e,f,g,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=+j;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;d=i;i=i+152|0;k=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[k>>2];k=d|0;l=d+8|0;m=d+40|0;n=d+48|0;o=d+112|0;p=d+120|0;q=d+128|0;r=d+136|0;s=d+144|0;c[k>>2]=37;c[k+4>>2]=0;t=k;k=t+1|0;u=f+4|0;v=c[u>>2]|0;if((v&2048|0)==0){w=k}else{a[k]=43;w=t+2|0}if((v&1024|0)==0){x=w}else{a[w]=35;x=w+1|0}w=v&260;k=v>>>14;do{if((w|0)==260){a[x]=76;v=x+1|0;if((k&1|0)==0){a[v]=97;y=0;break}else{a[v]=65;y=0;break}}else{a[x]=46;a[x+1|0]=42;a[x+2|0]=76;v=x+3|0;if((w|0)==256){if((k&1|0)==0){a[v]=101;y=1;break}else{a[v]=69;y=1;break}}else if((w|0)==4){if((k&1|0)==0){a[v]=102;y=1;break}else{a[v]=70;y=1;break}}else{if((k&1|0)==0){a[v]=103;y=1;break}else{a[v]=71;y=1;break}}}}while(0);k=l|0;c[m>>2]=k;do{if((a[154480]|0)==0){if((bD(154480)|0)==0){break}c[36886]=a4(2147483647,134952,0)|0}}while(0);l=c[36886]|0;if(y){w=jT(k,30,l,t,(z=i,i=i+16|0,c[z>>2]=c[f+8>>2],h[z+8>>3]=j,z)|0)|0;i=z;A=w}else{w=jT(k,30,l,t,(z=i,i=i+8|0,h[z>>3]=j,z)|0)|0;i=z;A=w}do{if((A|0)>29){w=(a[154480]|0)==0;if(y){do{if(w){if((bD(154480)|0)==0){break}c[36886]=a4(2147483647,134952,0)|0}}while(0);l=j_(m,c[36886]|0,t,(z=i,i=i+16|0,c[z>>2]=c[f+8>>2],h[z+8>>3]=j,z)|0)|0;i=z;B=l}else{do{if(w){if((bD(154480)|0)==0){break}c[36886]=a4(2147483647,134952,0)|0}}while(0);w=j_(m,c[36886]|0,t,(z=i,i=i+8|0,h[z>>3]=j,z)|0)|0;i=z;B=w}w=c[m>>2]|0;if((w|0)!=0){C=B;D=w;E=w;break}oK();w=c[m>>2]|0;C=B;D=w;E=w}else{C=A;D=0;E=c[m>>2]|0}}while(0);A=E+C|0;B=c[u>>2]&176;do{if((B|0)==32){F=A}else if((B|0)==16){u=a[E]|0;if((u<<24>>24|0)==45|(u<<24>>24|0)==43){F=E+1|0;break}if(!((C|0)>1&u<<24>>24==48)){G=4830;break}u=a[E+1|0]|0;if(!((u<<24>>24|0)==120|(u<<24>>24|0)==88)){G=4830;break}F=E+2|0}else{G=4830}}while(0);if((G|0)==4830){F=E}do{if((E|0)==(k|0)){H=n|0;I=0;J=k}else{G=oy(C<<1)|0;if((G|0)!=0){H=G;I=G;J=E;break}oK();H=0;I=0;J=c[m>>2]|0}}while(0);hS(q,f);j$(J,F,A,H,o,p,q);g9(c[q>>2]|0)|0;q=e|0;c[s>>2]=c[q>>2];jV(r,s,H,c[o>>2]|0,c[p>>2]|0,f,g);g=c[r>>2]|0;c[q>>2]=g;c[b>>2]=g;if((I|0)!=0){oz(I)}if((D|0)==0){i=d;return}oz(D);i=d;return}function j1(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;d=i;i=i+104|0;j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=d|0;k=d+24|0;l=d+48|0;m=d+88|0;n=d+96|0;o=d+16|0;a[o]=a[136456]|0;a[o+1|0]=a[136457]|0;a[o+2|0]=a[136458]|0;a[o+3|0]=a[136459]|0;a[o+4|0]=a[136460]|0;a[o+5|0]=a[136461]|0;p=k|0;do{if((a[154480]|0)==0){if((bD(154480)|0)==0){break}c[36886]=a4(2147483647,134952,0)|0}}while(0);q=jT(p,20,c[36886]|0,o,(o=i,i=i+8|0,c[o>>2]=h,o)|0)|0;i=o;o=k+q|0;h=c[f+4>>2]&176;do{if((h|0)==32){r=o}else if((h|0)==16){s=a[p]|0;if((s<<24>>24|0)==45|(s<<24>>24|0)==43){r=k+1|0;break}if(!((q|0)>1&s<<24>>24==48)){t=4863;break}s=a[k+1|0]|0;if(!((s<<24>>24|0)==120|(s<<24>>24|0)==88)){t=4863;break}r=k+2|0}else{t=4863}}while(0);if((t|0)==4863){r=p}hS(m,f);t=m|0;m=c[t>>2]|0;if((c[38272]|0)!=-1){c[j>>2]=153088;c[j+4>>2]=14;c[j+8>>2]=0;ht(153088,j,114)}j=(c[38273]|0)-1|0;h=c[m+8>>2]|0;do{if((c[m+12>>2]|0)-h>>2>>>0>j>>>0){s=c[h+(j<<2)>>2]|0;if((s|0)==0){break}u=s;v=c[t>>2]|0;g9(v)|0;v=l|0;w=c[(c[s>>2]|0)+32>>2]|0;c5[w&15](u,p,o,v)|0;u=l+q|0;if((r|0)==(o|0)){x=u;y=e|0;z=c[y>>2]|0;A=n|0;c[A>>2]=z;jV(b,n,v,x,u,f,g);i=d;return}x=l+(r-k)|0;y=e|0;z=c[y>>2]|0;A=n|0;c[A>>2]=z;jV(b,n,v,x,u,f,g);i=d;return}}while(0);d=cI(4)|0;od(d);bT(d|0,142880,164)}function j2(a){a=a|0;g7(a|0);oF(a);return}function j3(a){a=a|0;g7(a|0);return}function j4(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;j=i;i=i+48|0;k=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[k>>2];k=j|0;l=j+16|0;m=j+24|0;n=j+32|0;if((c[f+4>>2]&1|0)==0){o=c[(c[d>>2]|0)+24>>2]|0;c[l>>2]=c[e>>2];c9[o&63](b,d,l,f,g,h&1);i=j;return}hS(m,f);f=m|0;m=c[f>>2]|0;if((c[38174]|0)!=-1){c[k>>2]=152696;c[k+4>>2]=14;c[k+8>>2]=0;ht(152696,k,114)}k=(c[38175]|0)-1|0;g=c[m+8>>2]|0;do{if((c[m+12>>2]|0)-g>>2>>>0>k>>>0){l=c[g+(k<<2)>>2]|0;if((l|0)==0){break}d=l;o=c[f>>2]|0;g9(o)|0;o=c[l>>2]|0;if(h){c1[c[o+24>>2]&127](n,d)}else{c1[c[o+28>>2]&127](n,d)}d=n;o=a[d]|0;if((o&1)==0){l=n+4|0;p=l;q=l;r=n+8|0}else{l=n+8|0;p=c[l>>2]|0;q=n+4|0;r=l}l=e|0;s=p;t=o;while(1){if((t&1)==0){u=q}else{u=c[r>>2]|0}o=t&255;if((o&1|0)==0){v=o>>>1}else{v=c[q>>2]|0}if((s|0)==(u+(v<<2)|0)){break}o=c[s>>2]|0;w=c[l>>2]|0;do{if((w|0)!=0){x=w+24|0;y=c[x>>2]|0;if((y|0)==(c[w+28>>2]|0)){z=df[c[(c[w>>2]|0)+52>>2]&31](w,o)|0}else{c[x>>2]=y+4;c[y>>2]=o;z=o}if((z|0)!=-1){break}c[l>>2]=0}}while(0);s=s+4|0;t=a[d]|0}c[b>>2]=c[l>>2];hJ(n);i=j;return}}while(0);j=cI(4)|0;od(j);bT(j|0,142880,164)}function j5(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;d=i;i=i+144|0;j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=d|0;k=d+8|0;l=d+24|0;m=d+112|0;n=d+120|0;o=d+128|0;p=d+136|0;q=j|0;a[q]=a[136448]|0;a[q+1|0]=a[136449]|0;a[q+2|0]=a[136450]|0;a[q+3|0]=a[136451]|0;a[q+4|0]=a[136452]|0;a[q+5|0]=a[136453]|0;r=j+1|0;s=f+4|0;t=c[s>>2]|0;if((t&2048|0)==0){u=r}else{a[r]=43;u=j+2|0}if((t&512|0)==0){v=u}else{a[u]=35;v=u+1|0}a[v]=108;u=v+1|0;v=t&74;do{if((v|0)==8){if((t&16384|0)==0){a[u]=120;break}else{a[u]=88;break}}else if((v|0)==64){a[u]=111}else{a[u]=100}}while(0);u=k|0;do{if((a[154480]|0)==0){if((bD(154480)|0)==0){break}c[36886]=a4(2147483647,134952,0)|0}}while(0);v=jT(u,12,c[36886]|0,q,(q=i,i=i+8|0,c[q>>2]=h,q)|0)|0;i=q;q=k+v|0;h=c[s>>2]&176;do{if((h|0)==16){s=a[u]|0;if((s<<24>>24|0)==45|(s<<24>>24|0)==43){w=k+1|0;break}if(!((v|0)>1&s<<24>>24==48)){x=4934;break}s=a[k+1|0]|0;if(!((s<<24>>24|0)==120|(s<<24>>24|0)==88)){x=4934;break}w=k+2|0}else if((h|0)==32){w=q}else{x=4934}}while(0);if((x|0)==4934){w=u}x=l|0;hS(o,f);j6(u,w,q,x,m,n,o);g9(c[o>>2]|0)|0;c[p>>2]=c[e>>2];j7(b,p,x,c[m>>2]|0,c[n>>2]|0,f,g);i=d;return}function j6(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0;l=i;i=i+48|0;m=l|0;n=l+16|0;o=l+32|0;p=k|0;k=c[p>>2]|0;if((c[38270]|0)!=-1){c[n>>2]=153080;c[n+4>>2]=14;c[n+8>>2]=0;ht(153080,n,114)}n=(c[38271]|0)-1|0;q=c[k+8>>2]|0;if((c[k+12>>2]|0)-q>>2>>>0<=n>>>0){r=cI(4)|0;s=r;od(s);bT(r|0,142880,164)}k=c[q+(n<<2)>>2]|0;if((k|0)==0){r=cI(4)|0;s=r;od(s);bT(r|0,142880,164)}r=k;s=c[p>>2]|0;if((c[38174]|0)!=-1){c[m>>2]=152696;c[m+4>>2]=14;c[m+8>>2]=0;ht(152696,m,114)}m=(c[38175]|0)-1|0;p=c[s+8>>2]|0;if((c[s+12>>2]|0)-p>>2>>>0<=m>>>0){t=cI(4)|0;u=t;od(u);bT(t|0,142880,164)}s=c[p+(m<<2)>>2]|0;if((s|0)==0){t=cI(4)|0;u=t;od(u);bT(t|0,142880,164)}t=s;c1[c[(c[s>>2]|0)+20>>2]&127](o,t);u=o;m=o;p=d[m]|0;if((p&1|0)==0){v=p>>>1}else{v=c[o+4>>2]|0}do{if((v|0)==0){p=c[(c[k>>2]|0)+48>>2]|0;c5[p&15](r,b,f,g)|0;c[j>>2]=g+(f-b<<2)}else{c[j>>2]=g;p=a[b]|0;if((p<<24>>24|0)==45|(p<<24>>24|0)==43){n=df[c[(c[k>>2]|0)+44>>2]&31](r,p)|0;p=c[j>>2]|0;c[j>>2]=p+4;c[p>>2]=n;w=b+1|0}else{w=b}do{if((f-w|0)>1){if((a[w]|0)!=48){x=w;break}n=w+1|0;p=a[n]|0;if(!((p<<24>>24|0)==120|(p<<24>>24|0)==88)){x=w;bre