
// minifier: path aliases

enyo.path.addPaths({layout: "D://Dropbox/Text Editor/enyo/../lib/layout/", onyx: "D://Dropbox/Text Editor/enyo/../lib/onyx/", onyx: "D://Dropbox/Text Editor/enyo/../lib/onyx/source/", Strings: "source/Strings/", Editor: "source/Editor/", FileIO: "source/FileIO/", ColorPicker: "source/ColorPicker/"});

// FittableLayout.js

enyo.kind({
name: "enyo.FittableLayout",
kind: "Layout",
calcFitIndex: function() {
for (var e = 0, t = this.container.children, n; n = t[e]; e++) if (n.fit && n.showing) return e;
},
getFitControl: function() {
var e = this.container.children, t = e[this.fitIndex];
return t && t.fit && t.showing || (this.fitIndex = this.calcFitIndex(), t = e[this.fitIndex]), t;
},
getLastControl: function() {
var e = this.container.children, t = e.length - 1, n = e[t];
while ((n = e[t]) && !n.showing) t--;
return n;
},
_reflow: function(e, t, n, r) {
this.container.addRemoveClass("enyo-stretch", !this.container.noStretch);
var i = this.getFitControl();
if (!i) return;
var s = 0, o = 0, u = 0, a, f = this.container.hasNode();
f && (a = enyo.dom.calcPaddingExtents(f), s = f[t] - (a[n] + a[r]));
var l = i.getBounds();
o = l[n] - (a && a[n] || 0);
var c = this.getLastControl();
if (c) {
var h = enyo.dom.getComputedBoxValue(c.hasNode(), "margin", r) || 0;
if (c != i) {
var p = c.getBounds(), d = l[n] + l[e], v = p[n] + p[e] + h;
u = v - d;
} else u = h;
}
var m = s - (o + u);
i.applyStyle(e, m + "px");
},
reflow: function() {
this.orient == "h" ? this._reflow("width", "clientWidth", "left", "right") : this._reflow("height", "clientHeight", "top", "bottom");
}
}), enyo.kind({
name: "enyo.FittableColumnsLayout",
kind: "FittableLayout",
orient: "h",
layoutClass: "enyo-fittable-columns-layout"
}), enyo.kind({
name: "enyo.FittableRowsLayout",
kind: "FittableLayout",
layoutClass: "enyo-fittable-rows-layout",
orient: "v"
});

// FittableRows.js

enyo.kind({
name: "enyo.FittableRows",
layoutKind: "FittableRowsLayout",
noStretch: !1
});

// FittableColumns.js

enyo.kind({
name: "enyo.FittableColumns",
layoutKind: "FittableColumnsLayout",
noStretch: !1
});

// FlyweightRepeater.js

enyo.kind({
name: "enyo.FlyweightRepeater",
published: {
count: 0,
noSelect: !1,
multiSelect: !1,
toggleSelected: !1,
clientClasses: "",
clientStyle: "",
rowOffset: 0
},
events: {
onSetupItem: "",
onRenderRow: ""
},
bottomUp: !1,
components: [ {
kind: "Selection",
onSelect: "selectDeselect",
onDeselect: "selectDeselect"
}, {
name: "client"
} ],
create: function() {
this.inherited(arguments), this.noSelectChanged(), this.multiSelectChanged(), this.clientClassesChanged(), this.clientStyleChanged();
},
noSelectChanged: function() {
this.noSelect && this.$.selection.clear();
},
multiSelectChanged: function() {
this.$.selection.setMulti(this.multiSelect);
},
clientClassesChanged: function() {
this.$.client.setClasses(this.clientClasses);
},
clientStyleChanged: function() {
this.$.client.setStyle(this.clientStyle);
},
setupItem: function(e) {
this.doSetupItem({
index: e,
selected: this.isSelected(e)
});
},
generateChildHtml: function() {
var e = "";
this.index = null;
for (var t = 0, n = 0; t < this.count; t++) n = this.rowOffset + (this.bottomUp ? this.count - t - 1 : t), this.setupItem(n), this.$.client.setAttribute("data-enyo-index", n), e += this.inherited(arguments), this.$.client.teardownRender();
return e;
},
previewDomEvent: function(e) {
var t = this.index = this.rowForEvent(e);
e.rowIndex = e.index = t, e.flyweight = this;
},
decorateEvent: function(e, t, n) {
var r = t && t.index != null ? t.index : this.index;
t && r != null && (t.index = r, t.flyweight = this), this.inherited(arguments);
},
tap: function(e, t) {
if (this.noSelect || t.index === -1) return;
this.toggleSelected ? this.$.selection.toggle(t.index) : this.$.selection.select(t.index);
},
selectDeselect: function(e, t) {
this.renderRow(t.key);
},
getSelection: function() {
return this.$.selection;
},
isSelected: function(e) {
return this.getSelection().isSelected(e);
},
renderRow: function(e) {
if (e < this.rowOffset || e >= this.count + this.rowOffset) return;
this.setupItem(e);
var t = this.fetchRowNode(e);
t && (enyo.dom.setInnerHtml(t, this.$.client.generateChildHtml()), this.$.client.teardownChildren(), this.doRenderRow({
rowIndex: e
}));
},
fetchRowNode: function(e) {
if (this.hasNode()) return this.node.querySelector('[data-enyo-index="' + e + '"]');
},
rowForEvent: function(e) {
if (!this.hasNode()) return -1;
var t = e.target;
while (t && t !== this.node) {
var n = t.getAttribute && t.getAttribute("data-enyo-index");
if (n !== null) return Number(n);
t = t.parentNode;
}
return -1;
},
prepareRow: function(e) {
if (e < 0 || e >= this.count) return;
this.setupItem(e);
var t = this.fetchRowNode(e);
enyo.FlyweightRepeater.claimNode(this.$.client, t);
},
lockRow: function() {
this.$.client.teardownChildren();
},
performOnRow: function(e, t, n) {
if (e < 0 || e >= this.count) return;
t && (this.prepareRow(e), enyo.call(n || null, t), this.lockRow());
},
statics: {
claimNode: function(e, t) {
var n;
t && (t.id !== e.id ? n = t.querySelector("#" + e.id) : n = t), e.generated = Boolean(n || !e.tag), e.node = n, e.node && e.rendered();
for (var r = 0, i = e.children, s; s = i[r]; r++) this.claimNode(s, t);
}
}
});

// List.js

enyo.kind({
name: "enyo.List",
kind: "Scroller",
classes: "enyo-list",
published: {
count: 0,
rowsPerPage: 50,
bottomUp: !1,
noSelect: !1,
multiSelect: !1,
toggleSelected: !1,
fixedHeight: !1,
reorderable: !1,
centerReorderContainer: !0,
reorderComponents: [],
pinnedReorderComponents: [],
swipeableComponents: [],
enableSwipe: !1,
persistSwipeableItem: !1
},
events: {
onSetupItem: "",
onSetupReorderComponents: "",
onSetupPinnedReorderComponents: "",
onReorder: "",
onSetupSwipeItem: "",
onSwipeDrag: "",
onSwipe: "",
onSwipeComplete: ""
},
handlers: {
onAnimateFinish: "animateFinish",
onRenderRow: "rowRendered",
ondragstart: "dragstart",
ondrag: "drag",
ondragfinish: "dragfinish",
onup: "up",
onholdpulse: "holdpulse"
},
rowHeight: 0,
listTools: [ {
name: "port",
classes: "enyo-list-port enyo-border-box",
components: [ {
name: "generator",
kind: "FlyweightRepeater",
canGenerate: !1,
components: [ {
tag: null,
name: "client"
} ]
}, {
name: "holdingarea",
allowHtml: !0,
classes: "enyo-list-holdingarea"
}, {
name: "page0",
allowHtml: !0,
classes: "enyo-list-page"
}, {
name: "page1",
allowHtml: !0,
classes: "enyo-list-page"
}, {
name: "placeholder"
}, {
name: "swipeableComponents",
style: "position:absolute; display:block; top:-1000px; left:0;"
} ]
} ],
reorderHoldTimeMS: 600,
draggingRowIndex: -1,
draggingRowNode: null,
placeholderRowIndex: -1,
dragToScrollThreshold: .1,
prevScrollTop: 0,
autoScrollTimeoutMS: 20,
autoScrollTimeout: null,
autoscrollPageY: 0,
pinnedReorderMode: !1,
initialPinPosition: -1,
itemMoved: !1,
currentPageNumber: -1,
completeReorderTimeout: null,
swipeIndex: null,
swipeDirection: null,
persistentItemVisible: !1,
persistentItemOrigin: null,
swipeComplete: !1,
completeSwipeTimeout: null,
completeSwipeDelayMS: 500,
normalSwipeSpeedMS: 200,
fastSwipeSpeedMS: 100,
percentageDraggedThreshold: .2,
importProps: function(e) {
e && e.reorderable && (this.touch = !0), this.inherited(arguments);
},
create: function() {
this.pageHeights = [], this.inherited(arguments), this.getStrategy().translateOptimized = !0, this.bottomUpChanged(), this.noSelectChanged(), this.multiSelectChanged(), this.toggleSelectedChanged(), this.$.generator.setRowOffset(0), this.$.generator.setCount(this.count);
},
initComponents: function() {
this.createReorderTools(), this.inherited(arguments), this.createSwipeableComponents();
},
createReorderTools: function() {
this.createComponent({
name: "reorderContainer",
classes: "enyo-list-reorder-container",
ondown: "sendToStrategy",
ondrag: "sendToStrategy",
ondragstart: "sendToStrategy",
ondragfinish: "sendToStrategy",
onflick: "sendToStrategy"
});
},
createStrategy: function() {
this.controlParentName = "strategy", this.inherited(arguments), this.createChrome(this.listTools), this.controlParentName = "client", this.discoverControlParent();
},
createSwipeableComponents: function() {
for (var e = 0; e < this.swipeableComponents.length; e++) this.$.swipeableComponents.createComponent(this.swipeableComponents[e], {
owner: this.owner
});
},
rendered: function() {
this.inherited(arguments), this.$.generator.node = this.$.port.hasNode(), this.$.generator.generated = !0, this.reset();
},
resizeHandler: function() {
this.inherited(arguments), this.refresh();
},
bottomUpChanged: function() {
this.$.generator.bottomUp = this.bottomUp, this.$.page0.applyStyle(this.pageBound, null), this.$.page1.applyStyle(this.pageBound, null), this.pageBound = this.bottomUp ? "bottom" : "top", this.hasNode() && this.reset();
},
noSelectChanged: function() {
this.$.generator.setNoSelect(this.noSelect);
},
multiSelectChanged: function() {
this.$.generator.setMultiSelect(this.multiSelect);
},
toggleSelectedChanged: function() {
this.$.generator.setToggleSelected(this.toggleSelected);
},
countChanged: function() {
this.hasNode() && this.updateMetrics();
},
sendToStrategy: function(e, t) {
this.$.strategy.dispatchEvent("on" + t.type, t, e);
},
updateMetrics: function() {
this.defaultPageHeight = this.rowsPerPage * (this.rowHeight || 100), this.pageCount = Math.ceil(this.count / this.rowsPerPage), this.portSize = 0;
for (var e = 0; e < this.pageCount; e++) this.portSize += this.getPageHeight(e);
this.adjustPortSize();
},
holdpulse: function(e, t) {
if (!this.getReorderable() || this.isReordering()) return;
if (t.holdTime >= this.reorderHoldTimeMS && this.shouldStartReordering(e, t)) return t.preventDefault(), this.startReordering(t), !1;
},
dragstart: function(e, t) {
if (this.isReordering()) return !0;
if (this.isSwipeable()) return this.swipeDragStart(e, t);
},
drag: function(e, t) {
if (this.shouldDoReorderDrag(t)) return t.preventDefault(), this.reorderDrag(t), !0;
if (this.isSwipeable()) return t.preventDefault(), this.swipeDrag(e, t), !0;
},
dragfinish: function(e, t) {
this.isReordering() ? this.finishReordering(e, t) : this.isSwipeable() && this.swipeDragFinish(e, t);
},
up: function(e, t) {
this.isReordering() && this.finishReordering(e, t);
},
generatePage: function(e, t) {
this.page = e;
var n = this.rowsPerPage * this.page;
this.$.generator.setRowOffset(n);
var r = Math.min(this.count - n, this.rowsPerPage);
this.$.generator.setCount(r);
var i = this.$.generator.generateChildHtml();
t.setContent(i), this.getReorderable() && this.draggingRowIndex > -1 && this.hideReorderingRow();
var s = t.getBounds().height;
!this.rowHeight && s > 0 && (this.rowHeight = Math.floor(s / r), this.updateMetrics());
if (!this.fixedHeight) {
var o = this.getPageHeight(e);
this.pageHeights[e] = s, this.portSize += s - o;
}
},
pageForRow: function(e) {
return Math.floor(e / this.rowsPerPage);
},
preserveDraggingRowNode: function(e) {
this.draggingRowNode && this.pageForRow(this.draggingRowIndex) === e && (this.$.holdingarea.hasNode().appendChild(this.draggingRowNode), this.draggingRowNode = null, this.removedInitialPage = !0);
},
update: function(e) {
var t = !1, n = this.positionToPageInfo(e), r = n.pos + this.scrollerHeight / 2, i = Math.floor(r / Math.max(n.height, this.scrollerHeight) + .5) + n.no, s = i % 2 === 0 ? i : i - 1;
this.p0 != s && this.isPageInRange(s) && (this.preserveDraggingRowNode(this.p0), this.generatePage(s, this.$.page0), this.positionPage(s, this.$.page0), this.p0 = s, t = !0, this.p0RowBounds = this.getPageRowHeights(this.$.page0)), s = i % 2 === 0 ? Math.max(1, i - 1) : i, this.p1 != s && this.isPageInRange(s) && (this.preserveDraggingRowNode(this.p1), this.generatePage(s, this.$.page1), this.positionPage(s, this.$.page1), this.p1 = s, t = !0, this.p1RowBounds = this.getPageRowHeights(this.$.page1)), t && (this.$.generator.setRowOffset(0), this.$.generator.setCount(this.count), this.fixedHeight || (this.adjustBottomPage(), this.adjustPortSize()));
},
getPageRowHeights: function(e) {
var t = {}, n = e.hasNode().querySelectorAll("div[data-enyo-index]");
for (var r = 0, i, s; r < n.length; r++) i = n[r].getAttribute("data-enyo-index"), i !== null && (s = enyo.dom.getBounds(n[r]), t[parseInt(i, 10)] = {
height: s.height,
width: s.width
});
return t;
},
updateRowBounds: function(e) {
this.p0RowBounds[e] ? this.updateRowBoundsAtIndex(e, this.p0RowBounds, this.$.page0) : this.p1RowBounds[e] && this.updateRowBoundsAtIndex(e, this.p1RowBounds, this.$.page1);
},
updateRowBoundsAtIndex: function(e, t, n) {
var r = n.hasNode().querySelector('div[data-enyo-index="' + e + '"]'), i = enyo.dom.getBounds(r);
t[e].height = i.height, t[e].width = i.width;
},
updateForPosition: function(e) {
this.update(this.calcPos(e));
},
calcPos: function(e) {
return this.bottomUp ? this.portSize - this.scrollerHeight - e : e;
},
adjustBottomPage: function() {
var e = this.p0 >= this.p1 ? this.$.page0 : this.$.page1;
this.positionPage(e.pageNo, e);
},
adjustPortSize: function() {
this.scrollerHeight = this.getBounds().height;
var e = Math.max(this.scrollerHeight, this.portSize);
this.$.port.applyStyle("height", e + "px");
},
positionPage: function(e, t) {
t.pageNo = e;
var n = this.pageToPosition(e);
t.applyStyle(this.pageBound, n + "px");
},
pageToPosition: function(e) {
var t = 0, n = e;
while (n > 0) n--, t += this.getPageHeight(n);
return t;
},
positionToPageInfo: function(e) {
var t = -1, n = this.calcPos(e), r = this.defaultPageHeight;
while (n >= 0) t++, r = this.getPageHeight(t), n -= r;
return t = Math.max(t, 0), {
no: t,
height: r,
pos: n + r,
startRow: t * this.rowsPerPage,
endRow: Math.min((t + 1) * this.rowsPerPage - 1, this.count - 1)
};
},
isPageInRange: function(e) {
return e == Math.max(0, Math.min(this.pageCount - 1, e));
},
getPageHeight: function(e) {
var t = this.pageHeights[e];
if (!t) {
var n = this.rowsPerPage * e, r = Math.min(this.count - n, this.rowsPerPage);
t = this.defaultPageHeight * (r / this.rowsPerPage);
}
return Math.max(1, t);
},
invalidatePages: function() {
this.p0 = this.p1 = null, this.p0RowBounds = {}, this.p1RowBounds = {}, this.$.page0.setContent(""), this.$.page1.setContent("");
},
invalidateMetrics: function() {
this.pageHeights = [], this.rowHeight = 0, this.updateMetrics();
},
scroll: function(e, t) {
var n = this.inherited(arguments), r = this.getScrollTop();
return this.lastPos === r ? n : (this.lastPos = r, this.update(r), this.pinnedReorderMode && this.reorderScroll(e, t), n);
},
setScrollTop: function(e) {
this.update(e), this.inherited(arguments), this.twiddle();
},
getScrollPosition: function() {
return this.calcPos(this.getScrollTop());
},
setScrollPosition: function(e) {
this.setScrollTop(this.calcPos(e));
},
scrollToBottom: function() {
this.update(this.getScrollBounds().maxTop), this.inherited(arguments);
},
scrollToRow: function(e) {
var t = this.pageForRow(e), n = e % this.rowsPerPage, r = this.pageToPosition(t);
this.updateForPosition(r), r = this.pageToPosition(t), this.setScrollPosition(r);
if (t == this.p0 || t == this.p1) {
var i = this.$.generator.fetchRowNode(e);
if (i) {
var s = i.offsetTop;
this.bottomUp && (s = this.getPageHeight(t) - i.offsetHeight - s);
var o = this.getScrollPosition() + s;
this.setScrollPosition(o);
}
}
},
scrollToStart: function() {
this[this.bottomUp ? "scrollToBottom" : "scrollToTop"]();
},
scrollToEnd: function() {
this[this.bottomUp ? "scrollToTop" : "scrollToBottom"]();
},
refresh: function() {
this.invalidatePages(), this.update(this.getScrollTop()), this.stabilize(), enyo.platform.android === 4 && this.twiddle();
},
reset: function() {
this.getSelection().clear(), this.invalidateMetrics(), this.invalidatePages(), this.stabilize(), this.scrollToStart();
},
getSelection: function() {
return this.$.generator.getSelection();
},
select: function(e, t) {
return this.getSelection().select(e, t);
},
deselect: function(e) {
return this.getSelection().deselect(e);
},
isSelected: function(e) {
return this.$.generator.isSelected(e);
},
renderRow: function(e) {
this.$.generator.renderRow(e);
},
rowRendered: function(e, t) {
this.updateRowBounds(t.rowIndex);
},
prepareRow: function(e) {
this.$.generator.prepareRow(e);
},
lockRow: function() {
this.$.generator.lockRow();
},
performOnRow: function(e, t, n) {
this.$.generator.performOnRow(e, t, n);
},
animateFinish: function(e) {
return this.twiddle(), !0;
},
twiddle: function() {
var e = this.getStrategy();
enyo.call(e, "twiddle");
},
pageForPageNumber: function(e, t) {
return e % 2 === 0 ? !t || e === this.p0 ? this.$.page0 : null : !t || e === this.p1 ? this.$.page1 : null;
},
shouldStartReordering: function(e, t) {
return !!this.getReorderable() && t.rowIndex >= 0 && !this.pinnedReorderMode && e === this.$.strategy && t.index >= 0 ? !0 : !1;
},
startReordering: function(e) {
this.$.strategy.listReordering = !0, this.buildReorderContainer(), this.doSetupReorderComponents(e), this.styleReorderContainer(e), this.draggingRowIndex = this.placeholderRowIndex = e.rowIndex, this.draggingRowNode = e.target, this.removedInitialPage = !1, this.itemMoved = !1, this.initialPageNumber = this.currentPageNumber = this.pageForRow(e.rowIndex), this.prevScrollTop = this.getScrollTop(), this.replaceNodeWithPlaceholder(e.rowIndex);
},
buildReorderContainer: function() {
this.$.reorderContainer.destroyClientControls();
for (var e = 0; e < this.reorderComponents.length; e++) this.$.reorderContainer.createComponent(this.reorderComponents[e], {
owner: this.owner
});
this.$.reorderContainer.render();
},
styleReorderContainer: function(e) {
this.setItemPosition(this.$.reorderContainer, e.rowIndex), this.setItemBounds(this.$.reorderContainer, e.rowIndex), this.$.reorderContainer.setShowing(!0), this.centerReorderContainer && this.centerReorderContainerOnPointer(e);
},
appendNodeToReorderContainer: function(e) {
this.$.reorderContainer.createComponent({
allowHtml: !0,
content: e.innerHTML
}).render();
},
centerReorderContainerOnPointer: function(e) {
var t = enyo.dom.calcNodePosition(this.hasNode()), n = e.pageX - t.left - parseInt(this.$.reorderContainer.domStyles.width, 10) / 2, r = e.pageY - t.top + this.getScrollTop() - parseInt(this.$.reorderContainer.domStyles.height, 10) / 2;
this.getStrategyKind() != "ScrollStrategy" && (n -= this.getScrollLeft(), r -= this.getScrollTop()), this.positionReorderContainer(n, r);
},
positionReorderContainer: function(e, t) {
this.$.reorderContainer.addClass("enyo-animatedTopAndLeft"), this.$.reorderContainer.addStyles("left:" + e + "px;top:" + t + "px;"), this.setPositionReorderContainerTimeout();
},
setPositionReorderContainerTimeout: function() {
this.clearPositionReorderContainerTimeout(), this.positionReorderContainerTimeout = setTimeout(enyo.bind(this, function() {
this.$.reorderContainer.removeClass("enyo-animatedTopAndLeft"), this.clearPositionReorderContainerTimeout();
}), 100);
},
clearPositionReorderContainerTimeout: function() {
this.positionReorderContainerTimeout && (clearTimeout(this.positionReorderContainerTimeout), this.positionReorderContainerTimeout = null);
},
shouldDoReorderDrag: function() {
return !this.getReorderable() || this.draggingRowIndex < 0 || this.pinnedReorderMode ? !1 : !0;
},
reorderDrag: function(e) {
this.positionReorderNode(e), this.checkForAutoScroll(e), this.updatePlaceholderPosition(e.pageY);
},
updatePlaceholderPosition: function(e) {
var t = this.getRowIndexFromCoordinate(e);
t !== -1 && (t >= this.placeholderRowIndex ? this.movePlaceholderToIndex(Math.min(this.count, t + 1)) : this.movePlaceholderToIndex(t));
},
positionReorderNode: function(e) {
var t = this.$.reorderContainer.getBounds(), n = t.left + e.ddx, r = t.top + e.ddy;
r = this.getStrategyKind() == "ScrollStrategy" ? r + (this.getScrollTop() - this.prevScrollTop) : r, this.$.reorderContainer.addStyles("top: " + r + "px ; left: " + n + "px"), this.prevScrollTop = this.getScrollTop();
},
checkForAutoScroll: function(e) {
var t = enyo.dom.calcNodePosition(this.hasNode()), n = this.getBounds(), r;
this.autoscrollPageY = e.pageY, e.pageY - t.top < n.height * this.dragToScrollThreshold ? (r = 100 * (1 - (e.pageY - t.top) / (n.height * this.dragToScrollThreshold)), this.scrollDistance = -1 * r) : e.pageY - t.top > n.height * (1 - this.dragToScrollThreshold) ? (r = 100 * ((e.pageY - t.top - n.height * (1 - this.dragToScrollThreshold)) / (n.height - n.height * (1 - this.dragToScrollThreshold))), this.scrollDistance = 1 * r) : this.scrollDistance = 0, this.scrollDistance === 0 ? this.stopAutoScrolling() : this.autoScrollTimeout || this.startAutoScrolling();
},
stopAutoScrolling: function() {
this.autoScrollTimeout && (clearTimeout(this.autoScrollTimeout), this.autoScrollTimeout = null);
},
startAutoScrolling: function() {
this.autoScrollTimeout = setInterval(enyo.bind(this, this.autoScroll), this.autoScrollTimeoutMS);
},
autoScroll: function() {
this.scrollDistance === 0 ? this.stopAutoScrolling() : this.autoScrollTimeout || this.startAutoScrolling(), this.setScrollPosition(this.getScrollPosition() + this.scrollDistance), this.positionReorderNode({
ddx: 0,
ddy: 0
}), this.updatePlaceholderPosition(this.autoscrollPageY);
},
movePlaceholderToIndex: function(e) {
var t, n;
if (e < 0) return;
e >= this.count ? (t = null, n = this.pageForPageNumber(this.pageForRow(this.count - 1)).hasNode()) : (t = this.$.generator.fetchRowNode(e), n = t.parentNode);
var r = this.pageForRow(e);
r >= this.pageCount && (r = this.currentPageNumber), n.insertBefore(this.placeholderNode, t), this.currentPageNumber !== r && (this.updatePageHeight(this.currentPageNumber), this.updatePageHeight(r), this.updatePagePositions(r)), this.placeholderRowIndex = e, this.currentPageNumber = r, this.itemMoved = !0;
},
finishReordering: function(e, t) {
if (!this.isReordering() || this.pinnedReorderMode || this.completeReorderTimeout) return;
return this.stopAutoScrolling(), this.$.strategy.listReordering = !1, this.moveReorderedContainerToDroppedPosition(t), this.completeReorderTimeout = setTimeout(enyo.bind(this, this.completeFinishReordering, t), 100), t.preventDefault(), !0;
},
moveReorderedContainerToDroppedPosition: function() {
var e = this.getRelativeOffset(this.placeholderNode, this.hasNode()), t = this.getStrategyKind() == "ScrollStrategy" ? e.top : e.top - this.getScrollTop(), n = e.left - this.getScrollLeft();
this.positionReorderContainer(n, t);
},
completeFinishReordering: function(e) {
this.completeReorderTimeout = null, this.placeholderRowIndex > this.draggingRowIndex && (this.placeholderRowIndex = Math.max(0, this.placeholderRowIndex - 1));
if (this.draggingRowIndex == this.placeholderRowIndex && this.pinnedReorderComponents.length && !this.pinnedReorderMode && !this.itemMoved) {
this.beginPinnedReorder(e);
return;
}
this.removeDraggingRowNode(), this.removePlaceholderNode(), this.emptyAndHideReorderContainer(), this.pinnedReorderMode = !1, this.reorderRows(e), this.draggingRowIndex = this.placeholderRowIndex = -1, this.refresh();
},
beginPinnedReorder: function(e) {
this.buildPinnedReorderContainer(), this.doSetupPinnedReorderComponents(enyo.mixin(e, {
index: this.draggingRowIndex
})), this.pinnedReorderMode = !0, this.initialPinPosition = e.pageY;
},
emptyAndHideReorderContainer: function() {
this.$.reorderContainer.destroyComponents(), this.$.reorderContainer.setShowing(!1);
},
buildPinnedReorderContainer: function() {
this.$.reorderContainer.destroyClientControls();
for (var e = 0; e < this.pinnedReorderComponents.length; e++) this.$.reorderContainer.createComponent(this.pinnedReorderComponents[e], {
owner: this.owner
});
this.$.reorderContainer.render();
},
reorderRows: function(e) {
this.doReorder(this.makeReorderEvent(e)), this.positionReorderedNode(), this.updateListIndices();
},
makeReorderEvent: function(e) {
return e.reorderFrom = this.draggingRowIndex, e.reorderTo = this.placeholderRowIndex, e;
},
positionReorderedNode: function() {
if (!this.removedInitialPage) {
var e = this.$.generator.fetchRowNode(this.placeholderRowIndex);
e && (e.parentNode.insertBefore(this.hiddenNode, e), this.showNode(this.hiddenNode)), this.hiddenNode = null;
if (this.currentPageNumber != this.initialPageNumber) {
var t, n, r = this.pageForPageNumber(this.currentPageNumber), i = this.pageForPageNumber(this.currentPageNumber + 1);
this.initialPageNumber < this.currentPageNumber ? (t = r.hasNode().firstChild, i.hasNode().appendChild(t)) : (t = r.hasNode().lastChild, n = i.hasNode().firstChild, i.hasNode().insertBefore(t, n)), this.correctPageHeights(), this.updatePagePositions(this.initialPageNumber);
}
}
},
updateListIndices: function() {
if (this.shouldDoRefresh()) {
this.refresh(), this.correctPageHeights();
return;
}
var e = Math.min(this.draggingRowIndex, this.placeholderRowIndex), t = Math.max(this.draggingRowIndex, this.placeholderRowIndex), n = this.draggingRowIndex - this.placeholderRowIndex > 0 ? 1 : -1, r, i, s, o;
if (n === 1) {
r = this.$.generator.fetchRowNode(this.draggingRowIndex), r && r.setAttribute("data-enyo-index", "reordered");
for (i = t - 1, s = t; i >= e; i--) {
r = this.$.generator.fetchRowNode(i);
if (!r) continue;
o = parseInt(r.getAttribute("data-enyo-index"), 10), s = o + 1, r.setAttribute("data-enyo-index", s);
}
r = this.hasNode().querySelector('[data-enyo-index="reordered"]'), r.setAttribute("data-enyo-index", this.placeholderRowIndex);
} else {
r = this.$.generator.fetchRowNode(this.draggingRowIndex), r && r.setAttribute("data-enyo-index", this.placeholderRowIndex);
for (i = e + 1, s = e; i <= t; i++) {
r = this.$.generator.fetchRowNode(i);
if (!r) continue;
o = parseInt(r.getAttribute("data-enyo-index"), 10), s = o - 1, r.setAttribute("data-enyo-index", s);
}
}
},
shouldDoRefresh: function() {
return Math.abs(this.initialPageNumber - this.currentPageNumber) > 1;
},
getNodeStyle: function(e) {
var t = this.$.generator.fetchRowNode(e);
if (!t) return;
var n = this.getRelativeOffset(t, this.hasNode()), r = enyo.dom.getBounds(t);
return {
h: r.height,
w: r.width,
left: n.left,
top: n.top
};
},
getRelativeOffset: function(e, t) {
var n = {
top: 0,
left: 0
};
if (e !== t && e.parentNode) do n.top += e.offsetTop || 0, n.left += e.offsetLeft || 0, e = e.offsetParent; while (e && e !== t);
return n;
},
replaceNodeWithPlaceholder: function(e) {
var t = this.$.generator.fetchRowNode(e);
if (!t) {
enyo.log("No node - " + e);
return;
}
this.placeholderNode = this.createPlaceholderNode(t), this.hiddenNode = this.hideNode(t);
var n = this.pageForPageNumber(this.currentPageNumber);
n.hasNode().insertBefore(this.placeholderNode, this.hiddenNode);
},
createPlaceholderNode: function(e) {
var t = this.$.placeholder.hasNode().cloneNode(!0), n = enyo.dom.getBounds(e);
return t.style.height = n.height + "px", t.style.width = n.width + "px", t;
},
removePlaceholderNode: function() {
this.removeNode(this.placeholderNode), this.placeholderNode = null;
},
removeDraggingRowNode: function() {
this.draggingRowNode = null;
var e = this.$.holdingarea.hasNode();
e.innerHTML = "";
},
removeNode: function(e) {
if (!e || !e.parentNode) return;
e.parentNode.removeChild(e);
},
updatePageHeight: function(e) {
if (e < 0) return;
var t = this.pageForPageNumber(e, !0);
if (t) {
var n = this.pageHeights[e], r = Math.max(1, t.getBounds().height);
this.pageHeights[e] = r, this.portSize += r - n;
}
},
updatePagePositions: function(e) {
this.positionPage(this.currentPageNumber, this.pageForPageNumber(this.currentPageNumber)), this.positionPage(e, this.pageForPageNumber(e));
},
correctPageHeights: function() {
this.updatePageHeight(this.currentPageNumber), this.initialPageNumber != this.currentPageNumber && this.updatePageHeight(this.initialPageNumber);
},
hideNode: function(e) {
return e.style.display = "none", e;
},
showNode: function(e) {
return e.style.display = "block", e;
},
dropPinnedRow: function(e) {
this.moveReorderedContainerToDroppedPosition(e), this.completeReorderTimeout = setTimeout(enyo.bind(this, this.completeFinishReordering, e), 100);
return;
},
cancelPinnedMode: function(e) {
this.placeholderRowIndex = this.draggingRowIndex, this.dropPinnedRow(e);
},
getRowIndexFromCoordinate: function(e) {
var t = this.getScrollTop() + e - enyo.dom.calcNodePosition(this.hasNode()).top;
if (t < 0) return -1;
var n = this.positionToPageInfo(t), r = n.no == this.p0 ? this.p0RowBounds : this.p1RowBounds;
if (!r) return this.count;
var i = n.pos, s = this.placeholderNode ? enyo.dom.getBounds(this.placeholderNode).height : 0, o = 0;
for (var u = n.startRow; u <= n.endRow; ++u) {
if (u === this.placeholderRowIndex) {
o += s;
if (o >= i) return -1;
}
if (u !== this.draggingRowIndex) {
o += r[u].height;
if (o >= i) return u;
}
}
return u;
},
getIndexPosition: function(e) {
return enyo.dom.calcNodePosition(this.$.generator.fetchRowNode(e));
},
setItemPosition: function(e, t) {
var n = this.getNodeStyle(t), r = this.getStrategyKind() == "ScrollStrategy" ? n.top : n.top - this.getScrollTop(), i = "top:" + r + "px; left:" + n.left + "px;";
e.addStyles(i);
},
setItemBounds: function(e, t) {
var n = this.getNodeStyle(t), r = "width:" + n.w + "px; height:" + n.h + "px;";
e.addStyles(r);
},
reorderScroll: function(e, t) {
this.getStrategyKind() == "ScrollStrategy" && this.$.reorderContainer.addStyles("top:" + (this.initialPinPosition + this.getScrollTop() - this.rowHeight) + "px;"), this.updatePlaceholderPosition(this.initialPinPosition);
},
hideReorderingRow: function() {
var e = this.hasNode().querySelector('[data-enyo-index="' + this.draggingRowIndex + '"]');
e && (this.hiddenNode = this.hideNode(e));
},
isReordering: function() {
return this.draggingRowIndex > -1;
},
isSwiping: function() {
return this.swipeIndex != null && !this.swipeComplete && this.swipeDirection != null;
},
swipeDragStart: function(e, t) {
return t.index == null || t.vertical ? !0 : (this.completeSwipeTimeout && this.completeSwipe(t), this.swipeComplete = !1, this.swipeIndex != t.index && (this.clearSwipeables(), this.swipeIndex = t.index), this.swipeDirection = t.xDirection, this.persistentItemVisible || this.startSwipe(t), this.draggedXDistance = 0, this.draggedYDistance = 0, !0);
},
swipeDrag: function(e, t) {
return this.persistentItemVisible ? (this.dragPersistentItem(t), this.preventDragPropagation) : this.isSwiping() ? (this.dragSwipeableComponents(this.calcNewDragPosition(t.ddx)), this.draggedXDistance = t.dx, this.draggedYDistance = t.dy, !0) : !1;
},
swipeDragFinish: function(e, t) {
if (this.persistentItemVisible) this.dragFinishPersistentItem(t); else {
if (!this.isSwiping()) return !1;
var n = this.calcPercentageDragged(this.draggedXDistance);
n > this.percentageDraggedThreshold && t.xDirection === this.swipeDirection ? this.swipe(this.fastSwipeSpeedMS) : this.backOutSwipe(t);
}
return this.preventDragPropagation;
},
isSwipeable: function() {
return this.enableSwipe && this.$.swipeableComponents.controls.length !== 0 && !this.isReordering() && !this.pinnedReorderMode;
},
positionSwipeableContainer: function(e, t) {
var n = this.$.generator.fetchRowNode(e);
if (!n) return;
var r = this.getRelativeOffset(n, this.hasNode()), i = enyo.dom.getBounds(n), s = t == 1 ? -1 * i.width : i.width;
this.$.swipeableComponents.addStyles("top: " + r.top + "px; left: " + s + "px; height: " + i.height + "px; width: " + i.width + "px;");
},
calcNewDragPosition: function(e) {
var t = this.$.swipeableComponents.getBounds(), n = t.left, r = this.$.swipeableComponents.getBounds(), i = this.swipeDirection == 1 ? 0 : -1 * r.width, s = this.swipeDirection == 1 ? n + e > i ? i : n + e : n + e < i ? i : n + e;
return s;
},
dragSwipeableComponents: function(e) {
this.$.swipeableComponents.applyStyle("left", e + "px");
},
startSwipe: function(e) {
e.index = this.swipeIndex, this.positionSwipeableContainer(this.swipeIndex, e.xDirection), this.$.swipeableComponents.setShowing(!0), this.setPersistentItemOrigin(e.xDirection), this.doSetupSwipeItem(e);
},
dragPersistentItem: function(e) {
var t = 0, n = this.persistentItemOrigin == "right" ? Math.max(t, t + e.dx) : Math.min(t, t + e.dx);
this.$.swipeableComponents.applyStyle("left", n + "px");
},
dragFinishPersistentItem: function(e) {
var t = this.calcPercentageDragged(e.dx) > .2, n = e.dx > 0 ? "right" : e.dx < 0 ? "left" : null;
this.persistentItemOrigin == n ? t ? this.slideAwayItem() : this.bounceItem(e) : this.bounceItem(e);
},
setPersistentItemOrigin: function(e) {
this.persistentItemOrigin = e == 1 ? "left" : "right";
},
calcPercentageDragged: function(e) {
return Math.abs(e / this.$.swipeableComponents.getBounds().width);
},
swipe: function(e) {
this.swipeComplete = !0, this.animateSwipe(0, e);
},
backOutSwipe: function(e) {
var t = this.$.swipeableComponents.getBounds(), n = this.swipeDirection == 1 ? -1 * t.width : t.width;
this.animateSwipe(n, this.fastSwipeSpeedMS), this.swipeDirection = null;
},
bounceItem: function(e) {
var t = this.$.swipeableComponents.getBounds();
t.left != t.width && this.animateSwipe(0, this.normalSwipeSpeedMS);
},
slideAwayItem: function() {
var e = this.$.swipeableComponents, t = e.getBounds().width, n = this.persistentItemOrigin == "left" ? -1 * t : t;
this.animateSwipe(n, this.normalSwipeSpeedMS), this.persistentItemVisible = !1, this.setPersistSwipeableItem(!1);
},
clearSwipeables: function() {
this.$.swipeableComponents.setShowing(!1), this.persistentItemVisible = !1, this.setPersistSwipeableItem(!1);
},
completeSwipe: function(e) {
this.completeSwipeTimeout && (clearTimeout(this.completeSwipeTimeout), this.completeSwipeTimeout = null), this.getPersistSwipeableItem() ? this.persistentItemVisible = !0 : (this.$.swipeableComponents.setShowing(!1), this.swipeComplete && this.doSwipeComplete({
index: this.swipeIndex,
xDirection: this.swipeDirection
})), this.swipeIndex = null, this.swipeDirection = null;
},
animateSwipe: function(e, t) {
var n = enyo.now(), r = 0, i = this.$.swipeableComponents, s = parseInt(i.domStyles.left, 10), o = e - s;
this.stopAnimateSwipe();
var u = enyo.bind(this, function() {
var e = enyo.now() - n, r = e / t, a = s + o * Math.min(r, 1);
i.applyStyle("left", a + "px"), this.job = enyo.requestAnimationFrame(u), e / t >= 1 && (this.stopAnimateSwipe(), this.completeSwipeTimeout = setTimeout(enyo.bind(this, function() {
this.completeSwipe();
}), this.completeSwipeDelayMS));
});
this.job = enyo.requestAnimationFrame(u);
},
stopAnimateSwipe: function() {
this.job && (this.job = enyo.cancelRequestAnimationFrame(this.job));
}
});

// PulldownList.js

enyo.kind({
name: "enyo.PulldownList",
kind: "List",
touch: !0,
pully: null,
pulldownTools: [ {
name: "pulldown",
classes: "enyo-list-pulldown",
components: [ {
name: "puller",
kind: "Puller"
} ]
} ],
events: {
onPullStart: "",
onPullCancel: "",
onPull: "",
onPullRelease: "",
onPullComplete: ""
},
handlers: {
onScrollStart: "scrollStartHandler",
onScrollStop: "scrollStopHandler",
ondragfinish: "dragfinish"
},
pullingMessage: "Pull down to refresh...",
pulledMessage: "Release to refresh...",
loadingMessage: "Loading...",
pullingIconClass: "enyo-puller-arrow enyo-puller-arrow-down",
pulledIconClass: "enyo-puller-arrow enyo-puller-arrow-up",
loadingIconClass: "",
create: function() {
var e = {
kind: "Puller",
showing: !1,
text: this.loadingMessage,
iconClass: this.loadingIconClass,
onCreate: "setPully"
};
this.listTools.splice(0, 0, e), this.inherited(arguments), this.setPulling();
},
initComponents: function() {
this.createChrome(this.pulldownTools), this.accel = enyo.dom.canAccelerate(), this.translation = this.accel ? "translate3d" : "translate", this.strategyKind = this.resetStrategyKind(), this.inherited(arguments);
},
resetStrategyKind: function() {
return enyo.platform.android >= 3 ? "TranslateScrollStrategy" : "TouchScrollStrategy";
},
setPully: function(e, t) {
this.pully = t.originator;
},
scrollStartHandler: function() {
this.firedPullStart = !1, this.firedPull = !1, this.firedPullCancel = !1;
},
scroll: function(e, t) {
var n = this.inherited(arguments);
this.completingPull && this.pully.setShowing(!1);
var r = this.getStrategy().$.scrollMath || this.getStrategy(), i = -1 * this.getScrollTop();
return r.isInOverScroll() && i > 0 && (enyo.dom.transformValue(this.$.pulldown, this.translation, "0," + i + "px" + (this.accel ? ",0" : "")), this.firedPullStart || (this.firedPullStart = !0, this.pullStart(), this.pullHeight = this.$.pulldown.getBounds().height), i > this.pullHeight && !this.firedPull && (this.firedPull = !0, this.firedPullCancel = !1, this.pull()), this.firedPull && !this.firedPullCancel && i < this.pullHeight && (this.firedPullCancel = !0, this.firedPull = !1, this.pullCancel())), n;
},
scrollStopHandler: function() {
this.completingPull && (this.completingPull = !1, this.doPullComplete());
},
dragfinish: function() {
if (this.firedPull) {
var e = this.getStrategy().$.scrollMath || this.getStrategy();
e.setScrollY(-1 * this.getScrollTop() - this.pullHeight), this.pullRelease();
}
},
completePull: function() {
this.completingPull = !0;
var e = this.getStrategy().$.scrollMath || this.getStrategy();
e.setScrollY(this.pullHeight), e.start();
},
pullStart: function() {
this.setPulling(), this.pully.setShowing(!1), this.$.puller.setShowing(!0), this.doPullStart();
},
pull: function() {
this.setPulled(), this.doPull();
},
pullCancel: function() {
this.setPulling(), this.doPullCancel();
},
pullRelease: function() {
this.$.puller.setShowing(!1), this.pully.setShowing(!0), this.doPullRelease();
},
setPulling: function() {
this.$.puller.setText(this.pullingMessage), this.$.puller.setIconClass(this.pullingIconClass);
},
setPulled: function() {
this.$.puller.setText(this.pulledMessage), this.$.puller.setIconClass(this.pulledIconClass);
}
}), enyo.kind({
name: "enyo.Puller",
classes: "enyo-puller",
published: {
text: "",
iconClass: ""
},
events: {
onCreate: ""
},
components: [ {
name: "icon"
}, {
name: "text",
tag: "span",
classes: "enyo-puller-text"
} ],
create: function() {
this.inherited(arguments), this.doCreate(), this.textChanged(), this.iconClassChanged();
},
textChanged: function() {
this.$.text.setContent(this.text);
},
iconClassChanged: function() {
this.$.icon.setClasses(this.iconClass);
}
});

// AroundList.js

enyo.kind({
name: "enyo.AroundList",
kind: "enyo.List",
listTools: [ {
name: "port",
classes: "enyo-list-port enyo-border-box",
components: [ {
name: "aboveClient"
}, {
name: "generator",
kind: "FlyweightRepeater",
canGenerate: !1,
components: [ {
tag: null,
name: "client"
} ]
}, {
name: "holdingarea",
allowHtml: !0,
classes: "enyo-list-holdingarea"
}, {
name: "page0",
allowHtml: !0,
classes: "enyo-list-page"
}, {
name: "page1",
allowHtml: !0,
classes: "enyo-list-page"
}, {
name: "belowClient"
}, {
name: "placeholder"
}, {
name: "swipeableComponents",
style: "position:absolute; display:block; top:-1000px; left:0px;"
} ]
} ],
aboveComponents: null,
initComponents: function() {
this.inherited(arguments), this.aboveComponents && this.$.aboveClient.createComponents(this.aboveComponents, {
owner: this.owner
}), this.belowComponents && this.$.belowClient.createComponents(this.belowComponents, {
owner: this.owner
});
},
updateMetrics: function() {
this.defaultPageHeight = this.rowsPerPage * (this.rowHeight || 100), this.pageCount = Math.ceil(this.count / this.rowsPerPage), this.aboveHeight = this.$.aboveClient.getBounds().height, this.belowHeight = this.$.belowClient.getBounds().height, this.portSize = this.aboveHeight + this.belowHeight;
for (var e = 0; e < this.pageCount; e++) this.portSize += this.getPageHeight(e);
this.adjustPortSize();
},
positionPage: function(e, t) {
t.pageNo = e;
var n = this.pageToPosition(e), r = this.bottomUp ? this.belowHeight : this.aboveHeight;
n += r, t.applyStyle(this.pageBound, n + "px");
},
scrollToContentStart: function() {
var e = this.bottomUp ? this.belowHeight : this.aboveHeight;
this.setScrollPosition(e);
}
});

// Slideable.js

enyo.kind({
name: "enyo.Slideable",
kind: "Control",
published: {
axis: "h",
value: 0,
unit: "px",
min: 0,
max: 0,
accelerated: "auto",
overMoving: !0,
draggable: !0
},
events: {
onAnimateFinish: "",
onChange: ""
},
preventDragPropagation: !1,
tools: [ {
kind: "Animator",
onStep: "animatorStep",
onEnd: "animatorComplete"
} ],
handlers: {
ondragstart: "dragstart",
ondrag: "drag",
ondragfinish: "dragfinish"
},
kDragScalar: 1,
dragEventProp: "dx",
unitModifier: !1,
canTransform: !1,
create: function() {
this.inherited(arguments), this.acceleratedChanged(), this.transformChanged(), this.axisChanged(), this.valueChanged(), this.addClass("enyo-slideable");
},
initComponents: function() {
this.createComponents(this.tools), this.inherited(arguments);
},
rendered: function() {
this.inherited(arguments), this.canModifyUnit(), this.updateDragScalar();
},
resizeHandler: function() {
this.inherited(arguments), this.updateDragScalar();
},
canModifyUnit: function() {
if (!this.canTransform) {
var e = this.getInitialStyleValue(this.hasNode(), this.boundary);
e.match(/px/i) && this.unit === "%" && (this.unitModifier = this.getBounds()[this.dimension]);
}
},
getInitialStyleValue: function(e, t) {
var n = enyo.dom.getComputedStyle(e);
return n ? n.getPropertyValue(t) : e && e.currentStyle ? e.currentStyle[t] : "0";
},
updateBounds: function(e, t) {
var n = {};
n[this.boundary] = e, this.setBounds(n, this.unit), this.setInlineStyles(e, t);
},
updateDragScalar: function() {
if (this.unit == "%") {
var e = this.getBounds()[this.dimension];
this.kDragScalar = e ? 100 / e : 1, this.canTransform || this.updateBounds(this.value, 100);
}
},
transformChanged: function() {
this.canTransform = enyo.dom.canTransform();
},
acceleratedChanged: function() {
enyo.platform.android > 2 || enyo.dom.accelerate(this, this.accelerated);
},
axisChanged: function() {
var e = this.axis == "h";
this.dragMoveProp = e ? "dx" : "dy", this.shouldDragProp = e ? "horizontal" : "vertical", this.transform = e ? "translateX" : "translateY", this.dimension = e ? "width" : "height", this.boundary = e ? "left" : "top";
},
setInlineStyles: function(e, t) {
var n = {};
this.unitModifier ? (n[this.boundary] = this.percentToPixels(e, this.unitModifier), n[this.dimension] = this.unitModifier, this.setBounds(n)) : (t ? n[this.dimension] = t : n[this.boundary] = e, this.setBounds(n, this.unit));
},
valueChanged: function(e) {
var t = this.value;
this.isOob(t) && !this.isAnimating() && (this.value = this.overMoving ? this.dampValue(t) : this.clampValue(t)), enyo.platform.android > 2 && (this.value ? (e === 0 || e === undefined) && enyo.dom.accelerate(this, this.accelerated) : enyo.dom.accelerate(this, !1)), this.canTransform ? enyo.dom.transformValue(this, this.transform, this.value + this.unit) : this.setInlineStyles(this.value, !1), this.doChange();
},
getAnimator: function() {
return this.$.animator;
},
isAtMin: function() {
return this.value <= this.calcMin();
},
isAtMax: function() {
return this.value >= this.calcMax();
},
calcMin: function() {
return this.min;
},
calcMax: function() {
return this.max;
},
clampValue: function(e) {
var t = this.calcMin(), n = this.calcMax();
return Math.max(t, Math.min(e, n));
},
dampValue: function(e) {
return this.dampBound(this.dampBound(e, this.min, 1), this.max, -1);
},
dampBound: function(e, t, n) {
var r = e;
return r * n < t * n && (r = t + (r - t) / 4), r;
},
percentToPixels: function(e, t) {
return Math.floor(t / 100 * e);
},
pixelsToPercent: function(e) {
var t = this.unitModifier ? this.getBounds()[this.dimension] : this.container.getBounds()[this.dimension];
return e / t * 100;
},
shouldDrag: function(e) {
return this.draggable && e[this.shouldDragProp];
},
isOob: function(e) {
return e > this.calcMax() || e < this.calcMin();
},
dragstart: function(e, t) {
if (this.shouldDrag(t)) return t.preventDefault(), this.$.animator.stop(), t.dragInfo = {}, this.dragging = !0, this.drag0 = this.value, this.dragd0 = 0, this.preventDragPropagation;
},
drag: function(e, t) {
if (this.dragging) {
t.preventDefault();
var n = this.canTransform ? t[this.dragMoveProp] * this.kDragScalar : this.pixelsToPercent(t[this.dragMoveProp]), r = this.drag0 + n, i = n - this.dragd0;
return this.dragd0 = n, i && (t.dragInfo.minimizing = i < 0), this.setValue(r), this.preventDragPropagation;
}
},
dragfinish: function(e, t) {
if (this.dragging) return this.dragging = !1, this.completeDrag(t), t.preventTap(), this.preventDragPropagation;
},
completeDrag: function(e) {
this.value !== this.calcMax() && this.value != this.calcMin() && this.animateToMinMax(e.dragInfo.minimizing);
},
isAnimating: function() {
return this.$.animator.isAnimating();
},
play: function(e, t) {
this.$.animator.play({
startValue: e,
endValue: t,
node: this.hasNode()
});
},
animateTo: function(e) {
this.play(this.value, e);
},
animateToMin: function() {
this.animateTo(this.calcMin());
},
animateToMax: function() {
this.animateTo(this.calcMax());
},
animateToMinMax: function(e) {
e ? this.animateToMin() : this.animateToMax();
},
animatorStep: function(e) {
return this.setValue(e.value), !0;
},
animatorComplete: function(e) {
return this.doAnimateFinish(e), !0;
},
toggleMinMax: function() {
this.animateToMinMax(!this.isAtMin());
}
});

// Arranger.js

enyo.kind({
name: "enyo.Arranger",
kind: "Layout",
layoutClass: "enyo-arranger",
accelerated: "auto",
dragProp: "ddx",
dragDirectionProp: "xDirection",
canDragProp: "horizontal",
incrementalPoints: !1,
destroy: function() {
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) n._arranger = null;
this.inherited(arguments);
},
arrange: function(e, t) {},
size: function() {},
start: function() {
var e = this.container.fromIndex, t = this.container.toIndex, n = this.container.transitionPoints = [ e ];
if (this.incrementalPoints) {
var r = Math.abs(t - e) - 2, i = e;
while (r >= 0) i += t < e ? -1 : 1, n.push(i), r--;
}
n.push(this.container.toIndex);
},
finish: function() {},
calcArrangementDifference: function(e, t, n, r) {},
canDragEvent: function(e) {
return e[this.canDragProp];
},
calcDragDirection: function(e) {
return e[this.dragDirectionProp];
},
calcDrag: function(e) {
return e[this.dragProp];
},
drag: function(e, t, n, r, i) {
var s = this.measureArrangementDelta(-e, t, n, r, i);
return s;
},
measureArrangementDelta: function(e, t, n, r, i) {
var s = this.calcArrangementDifference(t, n, r, i), o = s ? e / Math.abs(s) : 0;
return o *= this.container.fromIndex > this.container.toIndex ? -1 : 1, o;
},
_arrange: function(e) {
this.containerBounds || this.reflow();
var t = this.getOrderedControls(e);
this.arrange(t, e);
},
arrangeControl: function(e, t) {
e._arranger = enyo.mixin(e._arranger || {}, t);
},
flow: function() {
this.c$ = [].concat(this.container.getPanels()), this.controlsIndex = 0;
for (var e = 0, t = this.container.getPanels(), n; n = t[e]; e++) {
enyo.dom.accelerate(n, this.accelerated);
if (enyo.platform.safari) {
var r = n.children;
for (var i = 0, s; s = r[i]; i++) enyo.dom.accelerate(s, this.accelerated);
}
}
},
reflow: function() {
var e = this.container.hasNode();
this.containerBounds = e ? {
width: e.clientWidth,
height: e.clientHeight
} : {}, this.size();
},
flowArrangement: function() {
var e = this.container.arrangement;
if (e) for (var t = 0, n = this.container.getPanels(), r; r = n[t]; t++) this.flowControl(r, e[t]);
},
flowControl: function(e, t) {
enyo.Arranger.positionControl(e, t);
var n = t.opacity;
n != null && enyo.Arranger.opacifyControl(e, n);
},
getOrderedControls: function(e) {
var t = Math.floor(e), n = t - this.controlsIndex, r = n > 0, i = this.c$ || [];
for (var s = 0; s < Math.abs(n); s++) r ? i.push(i.shift()) : i.unshift(i.pop());
return this.controlsIndex = t, i;
},
statics: {
positionControl: function(e, t, n) {
var r = n || "px";
if (!this.updating) if (enyo.dom.canTransform() && !enyo.platform.android && enyo.platform.ie !== 10) {
var i = t.left, s = t.top;
i = enyo.isString(i) ? i : i && i + r, s = enyo.isString(s) ? s : s && s + r, enyo.dom.transform(e, {
translateX: i || null,
translateY: s || null
});
} else e.setBounds(t, n);
},
opacifyControl: function(e, t) {
var n = t;
n = n > .99 ? 1 : n < .01 ? 0 : n, enyo.platform.ie < 9 ? e.applyStyle("filter", "progid:DXImageTransform.Microsoft.Alpha(Opacity=" + n * 100 + ")") : e.applyStyle("opacity", n);
}
}
});

// CardArranger.js

enyo.kind({
name: "enyo.CardArranger",
kind: "Arranger",
layoutClass: "enyo-arranger enyo-arranger-fit",
calcArrangementDifference: function(e, t, n, r) {
return this.containerBounds.width;
},
arrange: function(e, t) {
for (var n = 0, r, i, s; r = e[n]; n++) s = n === 0 ? 1 : 0, this.arrangeControl(r, {
opacity: s
});
},
start: function() {
this.inherited(arguments);
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) {
var r = n.showing;
n.setShowing(t == this.container.fromIndex || t == this.container.toIndex), n.showing && !r && n.resized();
}
},
finish: function() {
this.inherited(arguments);
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) n.setShowing(t == this.container.toIndex);
},
destroy: function() {
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) enyo.Arranger.opacifyControl(n, 1), n.showing || n.setShowing(!0);
this.inherited(arguments);
}
});

// CardSlideInArranger.js

enyo.kind({
name: "enyo.CardSlideInArranger",
kind: "CardArranger",
start: function() {
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) {
var r = n.showing;
n.setShowing(t == this.container.fromIndex || t == this.container.toIndex), n.showing && !r && n.resized();
}
var i = this.container.fromIndex;
t = this.container.toIndex, this.container.transitionPoints = [ t + "." + i + ".s", t + "." + i + ".f" ];
},
finish: function() {
this.inherited(arguments);
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) n.setShowing(t == this.container.toIndex);
},
arrange: function(e, t) {
var n = t.split("."), r = n[0], i = n[1], s = n[2] == "s", o = this.containerBounds.width;
for (var u = 0, a = this.container.getPanels(), f, l; f = a[u]; u++) l = o, i == u && (l = s ? 0 : -o), r == u && (l = s ? o : 0), i == u && i == r && (l = 0), this.arrangeControl(f, {
left: l
});
},
destroy: function() {
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) enyo.Arranger.positionControl(n, {
left: null
});
this.inherited(arguments);
}
});

// CarouselArranger.js

enyo.kind({
name: "enyo.CarouselArranger",
kind: "Arranger",
size: function() {
var e = this.container.getPanels(), t = this.containerPadding = this.container.hasNode() ? enyo.dom.calcPaddingExtents(this.container.node) : {}, n = this.containerBounds, r, i, s, o, u;
n.height -= t.top + t.bottom, n.width -= t.left + t.right;
var a;
for (r = 0, s = 0; u = e[r]; r++) o = enyo.dom.calcMarginExtents(u.hasNode()), u.width = u.getBounds().width, u.marginWidth = o.right + o.left, s += (u.fit ? 0 : u.width) + u.marginWidth, u.fit && (a = u);
if (a) {
var f = n.width - s;
a.width = f >= 0 ? f : a.width;
}
for (r = 0, i = t.left; u = e[r]; r++) u.setBounds({
top: t.top,
bottom: t.bottom,
width: u.fit ? u.width : null
});
},
arrange: function(e, t) {
this.container.wrap ? this.arrangeWrap(e, t) : this.arrangeNoWrap(e, t);
},
arrangeNoWrap: function(e, t) {
var n, r, i, s, o = this.container.getPanels(), u = this.container.clamp(t), a = this.containerBounds.width;
for (n = u, i = 0; s = o[n]; n++) {
i += s.width + s.marginWidth;
if (i > a) break;
}
var f = a - i, l = 0;
if (f > 0) {
var c = u;
for (n = u - 1, r = 0; s = o[n]; n--) {
r += s.width + s.marginWidth;
if (f - r <= 0) {
l = f - r, u = n;
break;
}
}
}
var h, p;
for (n = 0, p = this.containerPadding.left + l; s = o[n]; n++) h = s.width + s.marginWidth, n < u ? this.arrangeControl(s, {
left: -h
}) : (this.arrangeControl(s, {
left: Math.floor(p)
}), p += h);
},
arrangeWrap: function(e, t) {
for (var n = 0, r = this.containerPadding.left, i, s; s = e[n]; n++) this.arrangeControl(s, {
left: r
}), r += s.width + s.marginWidth;
},
calcArrangementDifference: function(e, t, n, r) {
var i = Math.abs(e % this.c$.length);
return t[i].left - r[i].left;
},
destroy: function() {
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) enyo.Arranger.positionControl(n, {
left: null,
top: null
}), n.applyStyle("top", null), n.applyStyle("bottom", null), n.applyStyle("left", null), n.applyStyle("width", null);
this.inherited(arguments);
}
});

// CollapsingArranger.js

enyo.kind({
name: "enyo.CollapsingArranger",
kind: "CarouselArranger",
peekWidth: 0,
size: function() {
this.clearLastSize(), this.inherited(arguments);
},
clearLastSize: function() {
for (var e = 0, t = this.container.getPanels(), n; n = t[e]; e++) n._fit && e != t.length - 1 && (n.applyStyle("width", null), n._fit = null);
},
constructor: function() {
this.inherited(arguments), this.peekWidth = this.container.peekWidth != null ? this.container.peekWidth : this.peekWidth;
},
arrange: function(e, t) {
var n = this.container.getPanels();
for (var r = 0, i = this.containerPadding.left, s, o, u = 0; o = n[r]; r++) o.getShowing() ? (this.arrangeControl(o, {
left: i + u * this.peekWidth
}), r >= t && (i += o.width + o.marginWidth - this.peekWidth), u++) : (this.arrangeControl(o, {
left: i
}), r >= t && (i += o.width + o.marginWidth)), r == n.length - 1 && t < 0 && this.arrangeControl(o, {
left: i - t
});
},
calcArrangementDifference: function(e, t, n, r) {
var i = this.container.getPanels().length - 1;
return Math.abs(r[i].left - t[i].left);
},
flowControl: function(e, t) {
this.inherited(arguments);
if (this.container.realtimeFit) {
var n = this.container.getPanels(), r = n.length - 1, i = n[r];
e == i && this.fitControl(e, t.left);
}
},
finish: function() {
this.inherited(arguments);
if (!this.container.realtimeFit && this.containerBounds) {
var e = this.container.getPanels(), t = this.container.arrangement, n = e.length - 1, r = e[n];
this.fitControl(r, t[n].left);
}
},
fitControl: function(e, t) {
e._fit = !0, e.applyStyle("width", this.containerBounds.width - t + "px"), e.resized();
}
});

// DockRightArranger.js

enyo.kind({
name: "enyo.DockRightArranger",
kind: "Arranger",
basePanel: !1,
overlap: 0,
layoutWidth: 0,
constructor: function() {
this.inherited(arguments), this.overlap = this.container.overlap != null ? this.container.overlap : this.overlap, this.layoutWidth = this.container.layoutWidth != null ? this.container.layoutWidth : this.layoutWidth;
},
size: function() {
var e = this.container.getPanels(), t = this.containerPadding = this.container.hasNode() ? enyo.dom.calcPaddingExtents(this.container.node) : {}, n = this.containerBounds, r, i, s;
n.width -= t.left + t.right;
var o = n.width, u = e.length;
this.container.transitionPositions = {};
for (r = 0; s = e[r]; r++) s.width = r === 0 && this.container.basePanel ? o : s.getBounds().width;
for (r = 0; s = e[r]; r++) {
r === 0 && this.container.basePanel && s.setBounds({
width: o
}), s.setBounds({
top: t.top,
bottom: t.bottom
});
for (j = 0; s = e[j]; j++) {
var a;
if (r === 0 && this.container.basePanel) a = 0; else if (j < r) a = o; else {
if (r !== j) break;
var f = o > this.layoutWidth ? this.overlap : 0;
a = o - e[r].width + f;
}
this.container.transitionPositions[r + "." + j] = a;
}
if (j < u) {
var l = !1;
for (k = r + 1; k < u; k++) {
var f = 0;
if (l) f = 0; else if (e[r].width + e[k].width - this.overlap > o) f = 0, l = !0; else {
f = e[r].width - this.overlap;
for (i = r; i < k; i++) {
var c = f + e[i + 1].width - this.overlap;
if (!(c < o)) {
f = o;
break;
}
f = c;
}
f = o - f;
}
this.container.transitionPositions[r + "." + k] = f;
}
}
}
},
arrange: function(e, t) {
var n, r, i = this.container.getPanels(), s = this.container.clamp(t);
for (n = 0; r = i[n]; n++) {
var o = this.container.transitionPositions[n + "." + s];
this.arrangeControl(r, {
left: o
});
}
},
calcArrangementDifference: function(e, t, n, r) {
var i = this.container.getPanels(), s = e < n ? i[n].width : i[e].width;
return s;
},
destroy: function() {
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) enyo.Arranger.positionControl(n, {
left: null,
top: null
}), n.applyStyle("top", null), n.applyStyle("bottom", null), n.applyStyle("left", null), n.applyStyle("width", null);
this.inherited(arguments);
}
});

// OtherArrangers.js

enyo.kind({
name: "enyo.LeftRightArranger",
kind: "Arranger",
margin: 40,
axisSize: "width",
offAxisSize: "height",
axisPosition: "left",
constructor: function() {
this.inherited(arguments), this.margin = this.container.margin != null ? this.container.margin : this.margin;
},
size: function() {
var e = this.container.getPanels(), t = this.containerBounds[this.axisSize], n = t - this.margin - this.margin;
for (var r = 0, i, s; s = e[r]; r++) i = {}, i[this.axisSize] = n, i[this.offAxisSize] = "100%", s.setBounds(i);
},
start: function() {
this.inherited(arguments);
var e = this.container.fromIndex, t = this.container.toIndex, n = this.getOrderedControls(t), r = Math.floor(n.length / 2);
for (var i = 0, s; s = n[i]; i++) e > t ? i == n.length - r ? s.applyStyle("z-index", 0) : s.applyStyle("z-index", 1) : i == n.length - 1 - r ? s.applyStyle("z-index", 0) : s.applyStyle("z-index", 1);
},
arrange: function(e, t) {
var n, r, i, s;
if (this.container.getPanels().length == 1) {
s = {}, s[this.axisPosition] = this.margin, this.arrangeControl(this.container.getPanels()[0], s);
return;
}
var o = Math.floor(this.container.getPanels().length / 2), u = this.getOrderedControls(Math.floor(t) - o), a = this.containerBounds[this.axisSize] - this.margin - this.margin, f = this.margin - a * o;
for (n = 0; r = u[n]; n++) s = {}, s[this.axisPosition] = f, this.arrangeControl(r, s), f += a;
},
calcArrangementDifference: function(e, t, n, r) {
if (this.container.getPanels().length == 1) return 0;
var i = Math.abs(e % this.c$.length);
return t[i][this.axisPosition] - r[i][this.axisPosition];
},
destroy: function() {
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) enyo.Arranger.positionControl(n, {
left: null,
top: null
}), enyo.Arranger.opacifyControl(n, 1), n.applyStyle("left", null), n.applyStyle("top", null), n.applyStyle("height", null), n.applyStyle("width", null);
this.inherited(arguments);
}
}), enyo.kind({
name: "enyo.TopBottomArranger",
kind: "LeftRightArranger",
dragProp: "ddy",
dragDirectionProp: "yDirection",
canDragProp: "vertical",
axisSize: "height",
offAxisSize: "width",
axisPosition: "top"
}), enyo.kind({
name: "enyo.SpiralArranger",
kind: "Arranger",
incrementalPoints: !0,
inc: 20,
size: function() {
var e = this.container.getPanels(), t = this.containerBounds, n = this.controlWidth = t.width / 3, r = this.controlHeight = t.height / 3;
for (var i = 0, s; s = e[i]; i++) s.setBounds({
width: n,
height: r
});
},
arrange: function(e, t) {
var n = this.inc;
for (var r = 0, i = e.length, s; s = e[r]; r++) {
var o = Math.cos(r / i * 2 * Math.PI) * r * n + this.controlWidth, u = Math.sin(r / i * 2 * Math.PI) * r * n + this.controlHeight;
this.arrangeControl(s, {
left: o,
top: u
});
}
},
start: function() {
this.inherited(arguments);
var e = this.getOrderedControls(this.container.toIndex);
for (var t = 0, n; n = e[t]; t++) n.applyStyle("z-index", e.length - t);
},
calcArrangementDifference: function(e, t, n, r) {
return this.controlWidth;
},
destroy: function() {
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) n.applyStyle("z-index", null), enyo.Arranger.positionControl(n, {
left: null,
top: null
}), n.applyStyle("left", null), n.applyStyle("top", null), n.applyStyle("height", null), n.applyStyle("width", null);
this.inherited(arguments);
}
}), enyo.kind({
name: "enyo.GridArranger",
kind: "Arranger",
incrementalPoints: !0,
colWidth: 100,
colHeight: 100,
size: function() {
var e = this.container.getPanels(), t = this.colWidth, n = this.colHeight;
for (var r = 0, i; i = e[r]; r++) i.setBounds({
width: t,
height: n
});
},
arrange: function(e, t) {
var n = this.colWidth, r = this.colHeight, i = Math.max(1, Math.floor(this.containerBounds.width / n)), s;
for (var o = 0, u = 0; u < e.length; o++) for (var a = 0; a < i && (s = e[u]); a++, u++) this.arrangeControl(s, {
left: n * a,
top: r * o
});
},
flowControl: function(e, t) {
this.inherited(arguments), enyo.Arranger.opacifyControl(e, t.top % this.colHeight !== 0 ? .25 : 1);
},
calcArrangementDifference: function(e, t, n, r) {
return this.colWidth;
},
destroy: function() {
var e = this.container.getPanels();
for (var t = 0, n; n = e[t]; t++) enyo.Arranger.positionControl(n, {
left: null,
top: null
}), n.applyStyle("left", null), n.applyStyle("top", null), n.applyStyle("height", null), n.applyStyle("width", null);
this.inherited(arguments);
}
});

// Panels.js

enyo.kind({
name: "enyo.Panels",
classes: "enyo-panels",
published: {
index: 0,
draggable: !0,
animate: !0,
wrap: !1,
arrangerKind: "CardArranger",
narrowFit: !0
},
events: {
onTransitionStart: "",
onTransitionFinish: ""
},
handlers: {
ondragstart: "dragstart",
ondrag: "drag",
ondragfinish: "dragfinish",
onscroll: "domScroll"
},
tools: [ {
kind: "Animator",
onStep: "step",
onEnd: "completed"
} ],
fraction: 0,
create: function() {
this.transitionPoints = [], this.inherited(arguments), this.arrangerKindChanged(), this.narrowFitChanged(), this.indexChanged();
},
rendered: function() {
this.inherited(arguments), enyo.makeBubble(this, "scroll");
},
domScroll: function(e, t) {
this.hasNode() && this.node.scrollLeft > 0 && (this.node.scrollLeft = 0);
},
initComponents: function() {
this.createChrome(this.tools), this.inherited(arguments);
},
arrangerKindChanged: function() {
this.setLayoutKind(this.arrangerKind);
},
narrowFitChanged: function() {
this.addRemoveClass("enyo-panels-fit-narrow", this.narrowFit);
},
destroy: function() {
this.destroying = !0, this.inherited(arguments);
},
removeControl: function(e) {
this.inherited(arguments), this.destroying && this.controls.length > 0 && this.isPanel(e) && (this.setIndex(Math.max(this.index - 1, 0)), this.flow(), this.reflow());
},
isPanel: function() {
return !0;
},
flow: function() {
this.arrangements = [], this.inherited(arguments);
},
reflow: function() {
this.arrangements = [], this.inherited(arguments), this.refresh();
},
getPanels: function() {
var e = this.controlParent || this;
return e.children;
},
getActive: function() {
var e = this.getPanels(), t = this.index % e.length;
return t < 0 && (t += e.length), e[t];
},
getAnimator: function() {
return this.$.animator;
},
setIndex: function(e) {
this.setPropertyValue("index", e, "indexChanged");
},
setIndexDirect: function(e) {
this.setIndex(e), this.completed();
},
previous: function() {
this.setIndex(this.index - 1);
},
next: function() {
this.setIndex(this.index + 1);
},
clamp: function(e) {
var t = this.getPanels().length - 1;
return this.wrap ? e : Math.max(0, Math.min(e, t));
},
indexChanged: function(e) {
this.lastIndex = e, this.index = this.clamp(this.index), !this.dragging && this.$.animator && (this.$.animator.isAnimating() && this.completed(), this.$.animator.stop(), this.hasNode() && (this.animate ? (this.startTransition(), this.$.animator.play({
startValue: this.fraction
})) : this.refresh()));
},
step: function(e) {
this.fraction = e.value, this.stepTransition();
},
completed: function() {
this.$.animator.isAnimating() && this.$.animator.stop(), this.fraction = 1, this.stepTransition(), this.finishTransition();
},
dragstart: function(e, t) {
if (this.draggable && this.layout && this.layout.canDragEvent(t)) return t.preventDefault(), this.dragstartTransition(t), this.dragging = !0, this.$.animator.stop(), !0;
},
drag: function(e, t) {
this.dragging && (t.preventDefault(), this.dragTransition(t));
},
dragfinish: function(e, t) {
this.dragging && (this.dragging = !1, t.preventTap(), this.dragfinishTransition(t));
},
dragstartTransition: function(e) {
if (!this.$.animator.isAnimating()) {
var t = this.fromIndex = this.index;
this.toIndex = t - (this.layout ? this.layout.calcDragDirection(e) : 0);
} else this.verifyDragTransition(e);
this.fromIndex = this.clamp(this.fromIndex), this.toIndex = this.clamp(this.toIndex), this.fireTransitionStart(), this.layout && this.layout.start();
},
dragTransition: function(e) {
var t = this.layout ? this.layout.calcDrag(e) : 0, n = this.transitionPoints, r = n[0], i = n[n.length - 1], s = this.fetchArrangement(r), o = this.fetchArrangement(i), u = this.layout ? this.layout.drag(t, r, s, i, o) : 0, a = t && !u;
a, this.fraction += u;
var f = this.fraction;
if (f > 1 || f < 0 || a) (f > 0 || a) && this.dragfinishTransition(e), this.dragstartTransition(e), this.fraction = 0;
this.stepTransition();
},
dragfinishTransition: function(e) {
this.verifyDragTransition(e), this.setIndex(this.toIndex), this.dragging && this.fireTransitionFinish();
},
verifyDragTransition: function(e) {
var t = this.layout ? this.layout.calcDragDirection(e) : 0, n = Math.min(this.fromIndex, this.toIndex), r = Math.max(this.fromIndex, this.toIndex);
if (t > 0) {
var i = n;
n = r, r = i;
}
n != this.fromIndex && (this.fraction = 1 - this.fraction), this.fromIndex = n, this.toIndex = r;
},
refresh: function() {
this.$.animator && this.$.animator.isAnimating() && this.$.animator.stop(), this.startTransition(), this.fraction = 1, this.stepTransition(), this.finishTransition();
},
startTransition: function() {
this.fromIndex = this.fromIndex != null ? this.fromIndex : this.lastIndex || 0, this.toIndex = this.toIndex != null ? this.toIndex : this.index, this.layout && this.layout.start(), this.fireTransitionStart();
},
finishTransition: function() {
this.layout && this.layout.finish(), this.transitionPoints = [], this.fraction = 0, this.fromIndex = this.toIndex = null, this.fireTransitionFinish();
},
fireTransitionStart: function() {
var e = this.startTransitionInfo;
this.hasNode() && (!e || e.fromIndex != this.fromIndex || e.toIndex != this.toIndex) && (this.startTransitionInfo = {
fromIndex: this.fromIndex,
toIndex: this.toIndex
}, this.doTransitionStart(enyo.clone(this.startTransitionInfo)));
},
fireTransitionFinish: function() {
var e = this.finishTransitionInfo;
this.hasNode() && (!e || e.fromIndex != this.lastIndex || e.toIndex != this.index) && (this.finishTransitionInfo = {
fromIndex: this.lastIndex,
toIndex: this.index
}, this.doTransitionFinish(enyo.clone(this.finishTransitionInfo))), this.lastIndex = this.index;
},
stepTransition: function() {
if (this.hasNode()) {
var e = this.transitionPoints, t = (this.fraction || 0) * (e.length - 1), n = Math.floor(t);
t -= n;
var r = e[n], i = e[n + 1], s = this.fetchArrangement(r), o = this.fetchArrangement(i);
this.arrangement = s && o ? enyo.Panels.lerp(s, o, t) : s || o, this.arrangement && this.layout && this.layout.flowArrangement();
}
},
fetchArrangement: function(e) {
return e != null && !this.arrangements[e] && this.layout && (this.layout._arrange(e), this.arrangements[e] = this.readArrangement(this.getPanels())), this.arrangements[e];
},
readArrangement: function(e) {
var t = [];
for (var n = 0, r = e, i; i = r[n]; n++) t.push(enyo.clone(i._arranger));
return t;
},
statics: {
isScreenNarrow: function() {
return enyo.dom.getWindowWidth() <= 800;
},
lerp: function(e, t, n) {
var r = [];
for (var i = 0, s = enyo.keys(e), o; o = s[i]; i++) r.push(this.lerpObject(e[o], t[o], n));
return r;
},
lerpObject: function(e, t, n) {
var r = enyo.clone(e), i, s;
if (t) for (var o in e) i = e[o], s = t[o], i != s && (r[o] = i - (i - s) * n);
return r;
}
}
});

// Node.js

enyo.kind({
name: "enyo.Node",
published: {
expandable: !1,
expanded: !1,
icon: "",
onlyIconExpands: !1,
selected: !1
},
style: "padding: 0 0 0 16px;",
content: "Node",
defaultKind: "Node",
classes: "enyo-node",
components: [ {
name: "icon",
kind: "Image",
showing: !1
}, {
kind: "Control",
name: "caption",
Xtag: "span",
style: "display: inline-block; padding: 4px;",
allowHtml: !0
}, {
kind: "Control",
name: "extra",
tag: "span",
allowHtml: !0
} ],
childClient: [ {
kind: "Control",
name: "box",
classes: "enyo-node-box",
Xstyle: "border: 1px solid orange;",
components: [ {
kind: "Control",
name: "client",
classes: "enyo-node-client",
Xstyle: "border: 1px solid lightblue;"
} ]
} ],
handlers: {
ondblclick: "dblclick"
},
events: {
onNodeTap: "nodeTap",
onNodeDblClick: "nodeDblClick",
onExpand: "nodeExpand",
onDestroyed: "nodeDestroyed"
},
create: function() {
this.inherited(arguments), this.selectedChanged(), this.iconChanged();
},
destroy: function() {
this.doDestroyed(), this.inherited(arguments);
},
initComponents: function() {
this.expandable && (this.kindComponents = this.kindComponents.concat(this.childClient)), this.inherited(arguments);
},
contentChanged: function() {
this.$.caption.setContent(this.content);
},
iconChanged: function() {
this.$.icon.setSrc(this.icon), this.$.icon.setShowing(Boolean(this.icon));
},
selectedChanged: function() {
this.addRemoveClass("enyo-selected", this.selected);
},
rendered: function() {
this.inherited(arguments), this.expandable && !this.expanded && this.quickCollapse();
},
addNodes: function(e) {
this.destroyClientControls();
for (var t = 0, n; n = e[t]; t++) this.createComponent(n);
this.$.client.render();
},
addTextNodes: function(e) {
this.destroyClientControls();
for (var t = 0, n; n = e[t]; t++) this.createComponent({
content: n
});
this.$.client.render();
},
tap: function(e, t) {
return this.onlyIconExpands ? t.target == this.$.icon.hasNode() ? this.toggleExpanded() : this.doNodeTap() : (this.toggleExpanded(), this.doNodeTap()), !0;
},
dblclick: function(e, t) {
return this.doNodeDblClick(), !0;
},
toggleExpanded: function() {
this.setExpanded(!this.expanded);
},
quickCollapse: function() {
this.removeClass("enyo-animate"), this.$.box.applyStyle("height", "0");
var e = this.$.client.getBounds().height;
this.$.client.setBounds({
top: -e
});
},
_expand: function() {
this.addClass("enyo-animate");
var e = this.$.client.getBounds().height;
this.$.box.setBounds({
height: e
}), this.$.client.setBounds({
top: 0
}), setTimeout(enyo.bind(this, function() {
this.expanded && (this.removeClass("enyo-animate"), this.$.box.applyStyle("height", "auto"));
}), 225);
},
_collapse: function() {
this.removeClass("enyo-animate");
var e = this.$.client.getBounds().height;
this.$.box.setBounds({
height: e
}), setTimeout(enyo.bind(this, function() {
this.addClass("enyo-animate"), this.$.box.applyStyle("height", "0"), this.$.client.setBounds({
top: -e
});
}), 25);
},
expandedChanged: function(e) {
if (!this.expandable) this.expanded = !1; else {
var t = {
expanded: this.expanded
};
this.doExpand(t), t.wait || this.effectExpanded();
}
},
effectExpanded: function() {
this.$.client && (this.expanded ? this._expand() : this._collapse());
}
});

// ImageViewPin.js

enyo.kind({
name: "enyo.ImageViewPin",
kind: "enyo.Control",
published: {
highlightAnchorPoint: !1,
anchor: {
top: 0,
left: 0
},
position: {
top: 0,
left: 0
}
},
style: "position:absolute;z-index:1000;width:0px;height:0px;",
handlers: {
onPositionPin: "reAnchor"
},
create: function() {
this.inherited(arguments), this.styleClientControls(), this.positionClientControls(), this.highlightAnchorPointChanged(), this.anchorChanged();
},
styleClientControls: function() {
var e = this.getClientControls();
for (var t = 0; t < e.length; t++) e[t].applyStyle("position", "absolute");
},
positionClientControls: function() {
var e = this.getClientControls();
for (var t = 0; t < e.length; t++) for (var n in this.position) e[t].applyStyle(n, this.position[n] + "px");
},
highlightAnchorPointChanged: function() {
this.addRemoveClass("pinDebug", this.highlightAnchorPoint);
},
anchorChanged: function() {
var e = null, t = null;
for (t in this.anchor) {
e = this.anchor[t].toString().match(/^(\d+(?:\.\d+)?)(.*)$/);
if (!e) continue;
this.anchor[t + "Coords"] = {
value: e[1],
units: e[2] || "px"
};
}
},
reAnchor: function(e, t) {
var n = t.scale, r = t.bounds, i = this.anchor.right ? this.anchor.rightCoords.units == "px" ? r.width + r.x - this.anchor.rightCoords.value * n : r.width * (100 - this.anchor.rightCoords.value) / 100 + r.x : this.anchor.leftCoords.units == "px" ? this.anchor.leftCoords.value * n + r.x : r.width * this.anchor.leftCoords.value / 100 + r.x, s = this.anchor.bottom ? this.anchor.bottomCoords.units == "px" ? r.height + r.y - this.anchor.bottomCoords.value * n : r.height * (100 - this.anchor.bottomCoords.value) / 100 + r.y : this.anchor.topCoords.units == "px" ? this.anchor.topCoords.value * n + r.y : r.height * this.anchor.topCoords.value / 100 + r.y;
this.applyStyle("left", i + "px"), this.applyStyle("top", s + "px");
}
});

// ImageView.js

enyo.kind({
name: "enyo.ImageView",
kind: enyo.Scroller,
touchOverscroll: !1,
thumb: !1,
animate: !0,
verticalDragPropagation: !0,
horizontalDragPropagation: !0,
published: {
scale: "auto",
disableZoom: !1,
src: undefined
},
events: {
onZoom: ""
},
touch: !0,
preventDragPropagation: !1,
handlers: {
ondragstart: "dragPropagation"
},
components: [ {
name: "animator",
kind: "Animator",
onStep: "zoomAnimationStep",
onEnd: "zoomAnimationEnd"
}, {
name: "viewport",
style: "overflow:hidden;min-height:100%;min-width:100%;",
classes: "enyo-fit",
ongesturechange: "gestureTransform",
ongestureend: "saveState",
ontap: "singleTap",
ondblclick: "doubleClick",
onmousewheel: "mousewheel",
components: [ {
kind: "Image",
ondown: "down"
} ]
} ],
create: function() {
this.inherited(arguments), this.canTransform = enyo.dom.canTransform(), this.canTransform || this.$.image.applyStyle("position", "relative"), this.canAccelerate = enyo.dom.canAccelerate(), this.bufferImage = new Image, this.bufferImage.onload = enyo.bind(this, "imageLoaded"), this.bufferImage.onerror = enyo.bind(this, "imageError"), this.srcChanged(), this.getStrategy().setDragDuringGesture(!1), this.getStrategy().$.scrollMath && this.getStrategy().$.scrollMath.start();
},
down: function(e, t) {
t.preventDefault();
},
dragPropagation: function(e, t) {
var n = this.getStrategy().getScrollBounds(), r = n.top === 0 && t.dy > 0 || n.top >= n.maxTop - 2 && t.dy < 0, i = n.left === 0 && t.dx > 0 || n.left >= n.maxLeft - 2 && t.dx < 0;
return !(r && this.verticalDragPropagation || i && this.horizontalDragPropagation);
},
mousewheel: function(e, t) {
t.pageX |= t.clientX + t.target.scrollLeft, t.pageY |= t.clientY + t.target.scrollTop;
var n = (this.maxScale - this.minScale) / 10, r = this.scale;
if (t.wheelDelta > 0 || t.detail < 0) this.scale = this.limitScale(this.scale + n); else if (t.wheelDelta < 0 || t.detail > 0) this.scale = this.limitScale(this.scale - n);
return this.eventPt = this.calcEventLocation(t), this.transformImage(this.scale), r != this.scale && this.doZoom({
scale: this.scale
}), this.ratioX = this.ratioY = null, t.preventDefault(), !0;
},
srcChanged: function() {
this.src && this.src.length > 0 && this.bufferImage && this.src != this.bufferImage.src && (this.bufferImage.src = this.src);
},
imageLoaded: function(e) {
this.originalWidth = this.bufferImage.width, this.originalHeight = this.bufferImage.height, this.scaleChanged(), this.$.image.setSrc(this.bufferImage.src), enyo.dom.transformValue(this.getStrategy().$.client, "translate3d", "0px, 0px, 0"), this.positionClientControls(this.scale), this.alignImage();
},
resizeHandler: function() {
this.inherited(arguments), this.$.image.src && this.scaleChanged();
},
scaleChanged: function() {
var e = this.hasNode();
if (e) {
this.containerWidth = e.clientWidth, this.containerHeight = e.clientHeight;
var t = this.containerWidth / this.originalWidth, n = this.containerHeight / this.originalHeight;
this.minScale = Math.min(t, n), this.maxScale = this.minScale * 3 < 1 ? 1 : this.minScale * 3, this.scale == "auto" ? this.scale = this.minScale : this.scale == "width" ? this.scale = t : this.scale == "height" ? this.scale = n : this.scale == "fit" ? (this.fitAlignment = "center", this.scale = Math.max(t, n)) : (this.maxScale = Math.max(this.maxScale, this.scale), this.scale = this.limitScale(this.scale));
}
this.eventPt = this.calcEventLocation(), this.transformImage(this.scale);
},
imageError: function(e) {
enyo.error("Error loading image: " + this.src), this.bubble("onerror", e);
},
alignImage: function() {
if (this.fitAlignment && this.fitAlignment === "center") {
var e = this.getScrollBounds();
this.setScrollLeft(e.maxLeft / 2), this.setScrollTop(e.maxTop / 2);
}
},
gestureTransform: function(e, t) {
this.eventPt = this.calcEventLocation(t), this.transformImage(this.limitScale(this.scale * t.scale));
},
calcEventLocation: function(e) {
var t = {
x: 0,
y: 0
};
if (e && this.hasNode()) {
var n = this.node.getBoundingClientRect();
t.x = Math.round(e.pageX - n.left - this.imageBounds.x), t.x = Math.max(0, Math.min(this.imageBounds.width, t.x)), t.y = Math.round(e.pageY - n.top - this.imageBounds.y), t.y = Math.max(0, Math.min(this.imageBounds.height, t.y));
}
return t;
},
transformImage: function(e) {
this.tapped = !1;
var t = this.imageBounds || this.innerImageBounds(e);
this.imageBounds = this.innerImageBounds(e), this.scale > this.minScale ? this.$.viewport.applyStyle("cursor", "move") : this.$.viewport.applyStyle("cursor", null), this.$.viewport.setBounds({
width: this.imageBounds.width + "px",
height: this.imageBounds.height + "px"
}), this.ratioX = this.ratioX || (this.eventPt.x + this.getScrollLeft()) / t.width, this.ratioY = this.ratioY || (this.eventPt.y + this.getScrollTop()) / t.height;
var n, r;
this.$.animator.ratioLock ? (n = this.$.animator.ratioLock.x * this.imageBounds.width - this.containerWidth / 2, r = this.$.animator.ratioLock.y * this.imageBounds.height - this.containerHeight / 2) : (n = this.ratioX * this.imageBounds.width - this.eventPt.x, r = this.ratioY * this.imageBounds.height - this.eventPt.y), n = Math.max(0, Math.min(this.imageBounds.width - this.containerWidth, n)), r = Math.max(0, Math.min(this.imageBounds.height - this.containerHeight, r));
if (this.canTransform) {
var i = {
scale: e
};
this.canAccelerate ? i = enyo.mixin({
translate3d: Math.round(this.imageBounds.left) + "px, " + Math.round(this.imageBounds.top) + "px, 0px"
}, i) : i = enyo.mixin({
translate: this.imageBounds.left + "px, " + this.imageBounds.top + "px"
}, i), enyo.dom.transform(this.$.image, i);
} else this.$.image.setBounds({
width: this.imageBounds.width + "px",
height: this.imageBounds.height + "px",
left: this.imageBounds.left + "px",
top: this.imageBounds.top + "px"
});
this.setScrollLeft(n), this.setScrollTop(r), this.positionClientControls(e);
},
limitScale: function(e) {
return this.disableZoom ? e = this.scale : e > this.maxScale ? e = this.maxScale : e < this.minScale && (e = this.minScale), e;
},
innerImageBounds: function(e) {
var t = this.originalWidth * e, n = this.originalHeight * e, r = {
x: 0,
y: 0,
transX: 0,
transY: 0
};
return t < this.containerWidth && (r.x += (this.containerWidth - t) / 2), n < this.containerHeight && (r.y += (this.containerHeight - n) / 2), this.canTransform && (r.transX -= (this.originalWidth - t) / 2, r.transY -= (this.originalHeight - n) / 2), {
left: r.x + r.transX,
top: r.y + r.transY,
width: t,
height: n,
x: r.x,
y: r.y
};
},
saveState: function(e, t) {
var n = this.scale;
this.scale *= t.scale, this.scale = this.limitScale(this.scale), n != this.scale && this.doZoom({
scale: this.scale
}), this.ratioX = this.ratioY = null;
},
doubleClick: function(e, t) {
enyo.platform.ie == 8 && (this.tapped = !0, t.pageX = t.clientX + t.target.scrollLeft, t.pageY = t.clientY + t.target.scrollTop, this.singleTap(e, t), t.preventDefault());
},
singleTap: function(e, t) {
setTimeout(enyo.bind(this, function() {
this.tapped = !1;
}), 300), this.tapped ? (this.tapped = !1, this.smartZoom(e, t)) : this.tapped = !0;
},
smartZoom: function(e, t) {
var n = this.hasNode(), r = this.$.image.hasNode();
if (n && r && this.hasNode() && !this.disableZoom) {
var i = this.scale;
this.scale != this.minScale ? this.scale = this.minScale : this.scale = this.maxScale, this.eventPt = this.calcEventLocation(t);
if (this.animate) {
var s = {
x: (this.eventPt.x + this.getScrollLeft()) / this.imageBounds.width,
y: (this.eventPt.y + this.getScrollTop()) / this.imageBounds.height
};
this.$.animator.play({
duration: 350,
ratioLock: s,
baseScale: i,
deltaScale: this.scale - i
});
} else this.transformImage(this.scale), this.doZoom({
scale: this.scale
});
}
},
zoomAnimationStep: function(e, t) {
var n = this.$.animator.baseScale + this.$.animator.deltaScale * this.$.animator.value;
this.transformImage(n);
},
zoomAnimationEnd: function(e, t) {
this.doZoom({
scale: this.scale
}), this.$.animator.ratioLock = undefined;
},
positionClientControls: function(e) {
this.waterfallDown("onPositionPin", {
scale: e,
bounds: this.imageBounds
});
}
});

// ImageCarousel.js

enyo.kind({
name: "enyo.ImageCarousel",
kind: enyo.Panels,
arrangerKind: "enyo.CarouselArranger",
defaultScale: "auto",
disableZoom: !1,
lowMemory: !1,
published: {
images: []
},
handlers: {
onTransitionStart: "transitionStart",
onTransitionFinish: "transitionFinish"
},
create: function() {
this.inherited(arguments), this.imageCount = this.images.length, this.images.length > 0 && (this.initContainers(), this.loadNearby());
},
initContainers: function() {
for (var e = 0; e < this.images.length; e++) this.$["container" + e] || (this.createComponent({
name: "container" + e,
style: "height:100%; width:100%;"
}), this.$["container" + e].render());
for (e = this.images.length; e < this.imageCount; e++) this.$["image" + e] && this.$["image" + e].destroy(), this.$["container" + e].destroy();
this.imageCount = this.images.length;
},
loadNearby: function() {
var e = this.getBufferRange();
for (var t in e) this.loadImageView(e[t]);
},
getBufferRange: function() {
var e = [];
if (this.layout.containerBounds) {
var t = 1, n = this.layout.containerBounds, r, i, s, o, u, a;
o = this.index - 1, u = 0, a = n.width * t;
while (o >= 0 && u <= a) s = this.$["container" + o], u += s.width + s.marginWidth, e.unshift(o), o--;
o = this.index, u = 0, a = n.width * (t + 1);
while (o < this.images.length && u <= a) s = this.$["container" + o], u += s.width + s.marginWidth, e.push(o), o++;
}
return e;
},
reflow: function() {
this.inherited(arguments), this.loadNearby();
},
loadImageView: function(e) {
return this.wrap && (e = (e % this.images.length + this.images.length) % this.images.length), e >= 0 && e <= this.images.length - 1 && (this.$["image" + e] ? this.$["image" + e].src != this.images[e] && (this.$["image" + e].setSrc(this.images[e]), this.$["image" + e].setScale(this.defaultScale), this.$["image" + e].setDisableZoom(this.disableZoom)) : (this.$["container" + e].createComponent({
name: "image" + e,
kind: "ImageView",
scale: this.defaultScale,
disableZoom: this.disableZoom,
src: this.images[e],
verticalDragPropagation: !1,
style: "height:100%; width:100%;"
}, {
owner: this
}), this.$["image" + e].render())), this.$["image" + e];
},
setImages: function(e) {
this.setPropertyValue("images", e, "imagesChanged");
},
imagesChanged: function() {
this.initContainers(), this.loadNearby();
},
indexChanged: function() {
this.loadNearby(), this.lowMemory && this.cleanupMemory(), this.inherited(arguments);
},
transitionStart: function(e, t) {
if (t.fromIndex == t.toIndex) return !0;
},
transitionFinish: function(e, t) {
this.loadNearby(), this.lowMemory && this.cleanupMemory();
},
getActiveImage: function() {
return this.getImageByIndex(this.index);
},
getImageByIndex: function(e) {
return this.$["image" + e] || this.loadImageView(e);
},
cleanupMemory: function() {
var e = getBufferRange();
for (var t = 0; t < this.images.length; t++) enyo.indexOf(t, e) === -1 && this.$["image" + t] && this.$["image" + t].destroy();
}
});

// Icon.js

enyo.kind({
name: "onyx.Icon",
published: {
src: "",
disabled: !1
},
classes: "onyx-icon",
create: function() {
this.inherited(arguments), this.src && this.srcChanged(), this.disabledChanged();
},
disabledChanged: function() {
this.addRemoveClass("disabled", this.disabled);
},
srcChanged: function() {
this.applyStyle("background-image", "url(" + enyo.path.rewrite(this.src) + ")");
}
});

// Button.js

enyo.kind({
name: "onyx.Button",
kind: "enyo.Button",
classes: "onyx-button enyo-unselectable",
create: function() {
enyo.platform.firefoxOS && (this.handlers.ondown = "down", this.handlers.onleave = "leave"), this.inherited(arguments);
},
down: function(e, t) {
this.addClass("pressed");
},
leave: function(e, t) {
this.removeClass("pressed");
}
});

// IconButton.js

enyo.kind({
name: "onyx.IconButton",
kind: "onyx.Icon",
published: {
active: !1
},
classes: "onyx-icon-button",
create: function() {
enyo.platform.firefoxOS && (this.handlers.ondown = "down", this.handlers.onleave = "leave"), this.inherited(arguments);
},
down: function(e, t) {
this.addClass("pressed");
},
leave: function(e, t) {
this.removeClass("pressed");
},
rendered: function() {
this.inherited(arguments), this.activeChanged();
},
tap: function() {
if (this.disabled) return !0;
this.setActive(!0);
},
activeChanged: function() {
this.bubble("onActivate");
}
});

// Checkbox.js

enyo.kind({
name: "onyx.Checkbox",
classes: "onyx-checkbox",
kind: enyo.Checkbox,
tag: "div",
handlers: {
onclick: ""
},
tap: function(e, t) {
return this.disabled || (this.setChecked(!this.getChecked()), this.bubble("onchange")), !this.disabled;
},
dragstart: function() {}
});

// Drawer.js

enyo.kind({
name: "onyx.Drawer",
published: {
open: !0,
orient: "v",
animated: !0
},
style: "overflow: hidden; position: relative;",
tools: [ {
kind: "Animator",
onStep: "animatorStep",
onEnd: "animatorEnd"
}, {
name: "client",
style: "position: relative;",
classes: "enyo-border-box"
} ],
create: function() {
this.inherited(arguments), this.animatedChanged(), this.openChanged();
},
initComponents: function() {
this.createChrome(this.tools), this.inherited(arguments);
},
animatedChanged: function() {
!this.animated && this.hasNode() && this.$.animator.isAnimating() && (this.$.animator.stop(), this.animatorEnd());
},
openChanged: function() {
this.$.client.show();
if (this.hasNode()) if (this.$.animator.isAnimating()) this.$.animator.reverse(); else {
var e = this.orient == "v", t = e ? "height" : "width", n = e ? "top" : "left";
this.applyStyle(t, null);
var r = this.hasNode()[e ? "scrollHeight" : "scrollWidth"];
this.animated ? this.$.animator.play({
startValue: this.open ? 0 : r,
endValue: this.open ? r : 0,
dimension: t,
position: n
}) : this.animatorEnd();
} else this.$.client.setShowing(this.open);
},
animatorStep: function(e) {
if (this.hasNode()) {
var t = e.dimension;
this.node.style[t] = this.domStyles[t] = e.value + "px";
}
var n = this.$.client.hasNode();
if (n) {
var r = e.position, i = this.open ? e.endValue : e.startValue;
n.style[r] = this.$.client.domStyles[r] = e.value - i + "px";
}
this.container && this.container.resized();
},
animatorEnd: function() {
if (!this.open) this.$.client.hide(); else {
this.$.client.domCssText = enyo.Control.domStylesToCssText(this.$.client.domStyles);
var e = this.orient == "v", t = e ? "height" : "width", n = e ? "top" : "left", r = this.$.client.hasNode();
r && (r.style[n] = this.$.client.domStyles[n] = null), this.node && (this.node.style[t] = this.domStyles[t] = null);
}
this.container && this.container.resized();
}
});

// Grabber.js

enyo.kind({
name: "onyx.Grabber",
classes: "onyx-grabber"
});

// Groupbox.js

enyo.kind({
name: "onyx.Groupbox",
classes: "onyx-groupbox"
}), enyo.kind({
name: "onyx.GroupboxHeader",
classes: "onyx-groupbox-header"
});

// Input.js

enyo.kind({
name: "onyx.Input",
kind: "enyo.Input",
classes: "onyx-input"
});

// Popup.js

enyo.kind({
name: "onyx.Popup",
kind: "Popup",
classes: "onyx-popup",
published: {
scrimWhenModal: !0,
scrim: !1,
scrimClassName: ""
},
statics: {
count: 0
},
defaultZ: 120,
showingChanged: function() {
this.showing ? (onyx.Popup.count++, this.applyZIndex()) : onyx.Popup.count > 0 && onyx.Popup.count--, this.showHideScrim(this.showing), this.inherited(arguments);
},
showHideScrim: function(e) {
if (this.floating && (this.scrim || this.modal && this.scrimWhenModal)) {
var t = this.getScrim();
if (e) {
var n = this.getScrimZIndex();
this._scrimZ = n, t.showAtZIndex(n);
} else t.hideAtZIndex(this._scrimZ);
enyo.call(t, "addRemoveClass", [ this.scrimClassName, t.showing ]);
}
},
getScrimZIndex: function() {
return this.findZIndex() - 1;
},
getScrim: function() {
return this.modal && this.scrimWhenModal && !this.scrim ? onyx.scrimTransparent.make() : onyx.scrim.make();
},
applyZIndex: function() {
this._zIndex = onyx.Popup.count * 2 + this.findZIndex() + 1, this.applyStyle("z-index", this._zIndex);
},
findZIndex: function() {
var e = this.defaultZ;
return this._zIndex ? e = this._zIndex : this.hasNode() && (e = Number(enyo.dom.getComputedStyleValue(this.node, "z-index")) || e), this._zIndex = e;
}
});

// TextArea.js

enyo.kind({
name: "onyx.TextArea",
kind: "enyo.TextArea",
classes: "onyx-textarea"
});

// RichText.js

enyo.kind({
name: "onyx.RichText",
kind: "enyo.RichText",
classes: "onyx-richtext"
});

// InputDecorator.js

enyo.kind({
name: "onyx.InputDecorator",
kind: "enyo.ToolDecorator",
tag: "label",
classes: "onyx-input-decorator",
published: {
alwaysLooksFocused: !1
},
handlers: {
onDisabledChange: "disabledChange",
onfocus: "receiveFocus",
onblur: "receiveBlur"
},
create: function() {
this.inherited(arguments), this.updateFocus(!1);
},
alwaysLooksFocusedChanged: function(e) {
this.updateFocus(this.focus);
},
updateFocus: function(e) {
this.focused = e, this.addRemoveClass("onyx-focused", this.alwaysLooksFocused || this.focused);
},
receiveFocus: function() {
this.updateFocus(!0);
},
receiveBlur: function() {
this.updateFocus(!1);
},
disabledChange: function(e, t) {
this.addRemoveClass("onyx-disabled", t.originator.disabled);
}
});

// Tooltip.js

enyo.kind({
name: "onyx.Tooltip",
kind: "onyx.Popup",
classes: "onyx-tooltip below left-arrow",
autoDismiss: !1,
showDelay: 500,
defaultLeft: -6,
handlers: {
onRequestShowTooltip: "requestShow",
onRequestHideTooltip: "requestHide"
},
requestShow: function() {
return this.showJob = setTimeout(enyo.bind(this, "show"), this.showDelay), !0;
},
cancelShow: function() {
clearTimeout(this.showJob);
},
requestHide: function() {
return this.cancelShow(), this.inherited(arguments);
},
showingChanged: function() {
this.cancelShow(), this.adjustPosition(!0), this.inherited(arguments);
},
applyPosition: function(e) {
var t = "";
for (var n in e) t += n + ":" + e[n] + (isNaN(e[n]) ? "; " : "px; ");
this.addStyles(t);
},
adjustPosition: function(e) {
if (this.showing && this.hasNode()) {
var t = this.node.getBoundingClientRect();
t.top + t.height > window.innerHeight ? (this.addRemoveClass("below", !1), this.addRemoveClass("above", !0)) : (this.addRemoveClass("above", !1), this.addRemoveClass("below", !0)), t.left + t.width > window.innerWidth && (this.applyPosition({
"margin-left": -t.width,
bottom: "auto"
}), this.addRemoveClass("left-arrow", !1), this.addRemoveClass("right-arrow", !0));
}
},
resizeHandler: function() {
this.applyPosition({
"margin-left": this.defaultLeft,
bottom: "auto"
}), this.addRemoveClass("left-arrow", !0), this.addRemoveClass("right-arrow", !1), this.adjustPosition(!0), this.inherited(arguments);
}
});

// TooltipDecorator.js

enyo.kind({
name: "onyx.TooltipDecorator",
defaultKind: "onyx.Button",
classes: "onyx-popup-decorator",
handlers: {
onenter: "enter",
onleave: "leave"
},
enter: function() {
this.requestShowTooltip();
},
leave: function() {
this.requestHideTooltip();
},
tap: function() {
this.requestHideTooltip();
},
requestShowTooltip: function() {
this.waterfallDown("onRequestShowTooltip");
},
requestHideTooltip: function() {
this.waterfallDown("onRequestHideTooltip");
}
});

// MenuDecorator.js

enyo.kind({
name: "onyx.MenuDecorator",
kind: "onyx.TooltipDecorator",
defaultKind: "onyx.Button",
classes: "onyx-popup-decorator enyo-unselectable",
handlers: {
onActivate: "activated",
onHide: "menuHidden"
},
activated: function(e, t) {
this.requestHideTooltip(), t.originator.active && (this.menuActive = !0, this.activator = t.originator, this.activator.addClass("active"), this.requestShowMenu());
},
requestShowMenu: function() {
this.waterfallDown("onRequestShowMenu", {
activator: this.activator
});
},
requestHideMenu: function() {
this.waterfallDown("onRequestHideMenu");
},
menuHidden: function() {
this.menuActive = !1, this.activator && (this.activator.setActive(!1), this.activator.removeClass("active"));
},
enter: function(e) {
this.menuActive || this.inherited(arguments);
},
leave: function(e, t) {
this.menuActive || this.inherited(arguments);
}
});

// Menu.js

enyo.kind({
name: "onyx.Menu",
kind: "onyx.Popup",
modal: !0,
defaultKind: "onyx.MenuItem",
classes: "onyx-menu",
published: {
maxHeight: 200,
scrolling: !0
},
handlers: {
onActivate: "itemActivated",
onRequestShowMenu: "requestMenuShow",
onRequestHideMenu: "requestHide"
},
childComponents: [ {
name: "client",
kind: "enyo.Scroller",
strategyKind: "TouchScrollStrategy"
} ],
showOnTop: !1,
scrollerName: "client",
create: function() {
this.inherited(arguments), this.maxHeightChanged();
},
initComponents: function() {
this.scrolling && this.createComponents(this.childComponents, {
isChrome: !0
}), this.inherited(arguments);
},
getScroller: function() {
return this.$[this.scrollerName];
},
maxHeightChanged: function() {
this.scrolling && this.getScroller().setMaxHeight(this.maxHeight + "px");
},
itemActivated: function(e, t) {
return t.originator.setActive(!1), !0;
},
showingChanged: function() {
this.inherited(arguments), this.scrolling && this.getScroller().setShowing(this.showing), this.adjustPosition(!0);
},
requestMenuShow: function(e, t) {
if (this.floating) {
var n = t.activator.hasNode();
if (n) {
var r = this.activatorOffset = this.getPageOffset(n);
this.applyPosition({
top: r.top + (this.showOnTop ? 0 : r.height),
left: r.left,
width: r.width
});
}
}
return this.show(), !0;
},
applyPosition: function(e) {
var t = "";
for (var n in e) t += n + ":" + e[n] + (isNaN(e[n]) ? "; " : "px; ");
this.addStyles(t);
},
getPageOffset: function(e) {
var t = e.getBoundingClientRect(), n = window.pageYOffset === undefined ? document.documentElement.scrollTop : window.pageYOffset, r = window.pageXOffset === undefined ? document.documentElement.scrollLeft : window.pageXOffset, i = t.height === undefined ? t.bottom - t.top : t.height, s = t.width === undefined ? t.right - t.left : t.width;
return {
top: t.top + n,
left: t.left + r,
height: i,
width: s
};
},
adjustPosition: function() {
if (this.showing && this.hasNode()) {
this.scrolling && !this.showOnTop && this.getScroller().setMaxHeight(this.maxHeight + "px"), this.removeClass("onyx-menu-up"), this.floating || this.applyPosition({
left: "auto"
});
var e = this.node.getBoundingClientRect(), t = e.height === undefined ? e.bottom - e.top : e.height, n = window.innerHeight === undefined ? document.documentElement.clientHeight : window.innerHeight, r = window.innerWidth === undefined ? document.documentElement.clientWidth : window.innerWidth;
this.menuUp = e.top + t > n && n - e.bottom < e.top - t, this.addRemoveClass("onyx-menu-up", this.menuUp);
if (this.floating) {
var i = this.activatorOffset;
this.menuUp ? this.applyPosition({
top: i.top - t + (this.showOnTop ? i.height : 0),
bottom: "auto"
}) : e.top < i.top && i.top + (this.showOnTop ? 0 : i.height) + t < n && this.applyPosition({
top: i.top + (this.showOnTop ? 0 : i.height),
bottom: "auto"
});
}
e.right > r && (this.floating ? this.applyPosition({
left: r - e.width
}) : this.applyPosition({
left: -(e.right - r)
})), e.left < 0 && (this.floating ? this.applyPosition({
left: 0,
right: "auto"
}) : this.getComputedStyleValue("right") == "auto" ? this.applyPosition({
left: -e.left
}) : this.applyPosition({
right: e.left
}));
if (this.scrolling && !this.showOnTop) {
e = this.node.getBoundingClientRect();
var s;
this.menuUp ? s = this.maxHeight < e.bottom ? this.maxHeight : e.bottom : s = e.top + this.maxHeight < n ? this.maxHeight : n - e.top, this.getScroller().setMaxHeight(s + "px");
}
}
},
resizeHandler: function() {
this.inherited(arguments), this.adjustPosition();
},
requestHide: function() {
this.setShowing(!1);
}
});

// MenuItem.js

enyo.kind({
name: "onyx.MenuItem",
kind: "enyo.Button",
events: {
onSelect: "",
onItemContentChange: ""
},
classes: "onyx-menu-item",
tag: "div",
create: function() {
this.inherited(arguments), this.active && this.bubble("onActivate");
},
tap: function(e) {
this.inherited(arguments), this.bubble("onRequestHideMenu"), this.doSelect({
selected: this,
content: this.content
});
},
contentChanged: function(e) {
this.inherited(arguments), this.doItemContentChange({
content: this.content
});
}
});

// PickerDecorator.js

enyo.kind({
name: "onyx.PickerDecorator",
kind: "onyx.MenuDecorator",
classes: "onyx-picker-decorator",
defaultKind: "onyx.PickerButton",
handlers: {
onChange: "change"
},
change: function(e, t) {
this.waterfallDown("onChange", t);
}
});

// PickerButton.js

enyo.kind({
name: "onyx.PickerButton",
kind: "onyx.Button",
handlers: {
onChange: "change"
},
change: function(e, t) {
t.content !== undefined && this.setContent(t.content);
}
});

// Picker.js

enyo.kind({
name: "onyx.Picker",
kind: "onyx.Menu",
classes: "onyx-picker enyo-unselectable",
published: {
selected: null
},
events: {
onChange: ""
},
handlers: {
onItemContentChange: "itemContentChange"
},
floating: !0,
showOnTop: !0,
initComponents: function() {
this.setScrolling(!0), this.inherited(arguments);
},
showingChanged: function() {
this.getScroller().setShowing(this.showing), this.inherited(arguments), this.showing && this.selected && this.scrollToSelected();
},
scrollToSelected: function() {
this.getScroller().scrollToControl(this.selected, !this.menuUp);
},
itemActivated: function(e, t) {
return this.processActivatedItem(t.originator), this.inherited(arguments);
},
processActivatedItem: function(e) {
e.active && this.setSelected(e);
},
selectedChanged: function(e) {
e && e.removeClass("selected"), this.selected && (this.selected.addClass("selected"), this.doChange({
selected: this.selected,
content: this.selected.content
}));
},
itemContentChange: function(e, t) {
t.originator == this.selected && this.doChange({
selected: this.selected,
content: this.selected.content
});
},
resizeHandler: function() {
this.inherited(arguments), this.adjustPosition();
}
});

// FlyweightPicker.js

enyo.kind({
name: "onyx.FlyweightPicker",
kind: "onyx.Picker",
classes: "onyx-flyweight-picker",
published: {
count: 0
},
events: {
onSetupItem: "",
onSelect: ""
},
handlers: {
onSelect: "itemSelect"
},
components: [ {
name: "scroller",
kind: "enyo.Scroller",
strategyKind: "TouchScrollStrategy",
components: [ {
name: "flyweight",
kind: "FlyweightRepeater",
noSelect: !0,
ontap: "itemTap"
} ]
} ],
scrollerName: "scroller",
initComponents: function() {
this.controlParentName = "flyweight", this.inherited(arguments), this.$.flyweight.$.client.children[0].setActive(!0);
},
create: function() {
this.inherited(arguments), this.countChanged();
},
rendered: function() {
this.inherited(arguments), this.selectedChanged();
},
scrollToSelected: function() {
var e = this.$.flyweight.fetchRowNode(this.selected);
this.getScroller().scrollToNode(e, !this.menuUp);
},
countChanged: function() {
this.$.flyweight.count = this.count;
},
processActivatedItem: function(e) {
this.item = e;
},
selectedChanged: function(e) {
if (!this.item) return;
e != null && (this.item.removeClass("selected"), this.$.flyweight.renderRow(e));
var t;
this.selected != null && (this.item.addClass("selected"), this.$.flyweight.renderRow(this.selected), this.item.removeClass("selected"), t = this.$.flyweight.fetchRowNode(this.selected)), this.doChange({
selected: this.selected,
content: t && t.textContent || this.item.content
});
},
itemTap: function(e, t) {
this.setSelected(t.rowIndex), this.doSelect({
selected: this.item,
content: this.item.content
});
},
itemSelect: function(e, t) {
if (t.originator != this) return !0;
}
});

// DatePicker.js

enyo.kind({
name: "onyx.DatePicker",
classes: "onyx-toolbar-inline",
published: {
disabled: !1,
locale: "en_us",
dayHidden: !1,
monthHidden: !1,
yearHidden: !1,
minYear: 1900,
maxYear: 2099,
value: null
},
events: {
onSelect: ""
},
create: function() {
this.inherited(arguments), enyo.g11n && (this.locale = enyo.g11n.currentLocale().getLocale()), this.initDefaults();
},
initDefaults: function() {
var e = [ "JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC" ];
enyo.g11n && (this._tf = new enyo.g11n.Fmts({
locale: this.locale
}), e = this._tf.getMonthFields()), this.setupPickers(this._tf ? this._tf.getDateFieldOrder() : "mdy"), this.dayHiddenChanged(), this.monthHiddenChanged(), this.yearHiddenChanged();
var t = this.value = this.value || new Date;
for (var n = 0, r; r = e[n]; n++) this.$.monthPicker.createComponent({
content: r,
value: n,
active: n == t.getMonth()
});
var i = t.getFullYear();
this.$.yearPicker.setSelected(i - this.minYear);
for (n = 1; n <= this.monthLength(t.getYear(), t.getMonth()); n++) this.$.dayPicker.createComponent({
content: n,
value: n,
active: n == t.getDate()
});
},
monthLength: function(e, t) {
return 32 - (new Date(e, t, 32)).getDate();
},
setupYear: function(e, t) {
this.$.year.setContent(this.minYear + t.index);
},
setupPickers: function(e) {
var t = e.split(""), n, r, i;
for (r = 0, i = t.length; r < i; r++) {
n = t[r];
switch (n) {
case "d":
this.createDay();
break;
case "m":
this.createMonth();
break;
case "y":
this.createYear();
break;
default:
}
}
},
createYear: function() {
var e = this.maxYear - this.minYear;
this.createComponent({
kind: "onyx.PickerDecorator",
onSelect: "updateYear",
components: [ {
classes: "onyx-datepicker-year",
name: "yearPickerButton",
disabled: this.disabled
}, {
name: "yearPicker",
kind: "onyx.FlyweightPicker",
count: ++e,
onSetupItem: "setupYear",
components: [ {
name: "year"
} ]
} ]
});
},
createMonth: function() {
this.createComponent({
kind: "onyx.PickerDecorator",
onSelect: "updateMonth",
components: [ {
classes: "onyx-datepicker-month",
name: "monthPickerButton",
disabled: this.disabled
}, {
name: "monthPicker",
kind: "onyx.Picker"
} ]
});
},
createDay: function() {
this.createComponent({
kind: "onyx.PickerDecorator",
onSelect: "updateDay",
components: [ {
classes: "onyx-datepicker-day",
name: "dayPickerButton",
disabled: this.disabled
}, {
name: "dayPicker",
kind: "onyx.Picker"
} ]
});
},
localeChanged: function() {
this.refresh();
},
dayHiddenChanged: function() {
this.$.dayPicker.getParent().setShowing(this.dayHidden ? !1 : !0);
},
monthHiddenChanged: function() {
this.$.monthPicker.getParent().setShowing(this.monthHidden ? !1 : !0);
},
yearHiddenChanged: function() {
this.$.yearPicker.getParent().setShowing(this.yearHidden ? !1 : !0);
},
minYearChanged: function() {
this.refresh();
},
maxYearChanged: function() {
this.refresh();
},
valueChanged: function() {
this.refresh();
},
disabledChanged: function() {
this.$.yearPickerButton.setDisabled(this.disabled), this.$.monthPickerButton.setDisabled(this.disabled), this.$.dayPickerButton.setDisabled(this.disabled);
},
updateDay: function(e, t) {
var n = this.calcDate(this.value.getFullYear(), this.value.getMonth(), t.selected.value);
return this.doSelect({
name: this.name,
value: n
}), this.setValue(n), !0;
},
updateMonth: function(e, t) {
var n = this.calcDate(this.value.getFullYear(), t.selected.value, this.value.getDate());
return this.doSelect({
name: this.name,
value: n
}), this.setValue(n), !0;
},
updateYear: function(e, t) {
if (t.originator.selected != -1) {
var n = this.calcDate(this.minYear + t.originator.selected, this.value.getMonth(), this.value.getDate());
this.doSelect({
name: this.name,
value: n
}), this.setValue(n);
}
return !0;
},
calcDate: function(e, t, n) {
return new Date(e, t, n, this.value.getHours(), this.value.getMinutes(), this.value.getSeconds(), this.value.getMilliseconds());
},
refresh: function() {
this.destroyClientControls(), this.initDefaults(), this.render();
}
});

// TimePicker.js

enyo.kind({
name: "onyx.TimePicker",
classes: "onyx-toolbar-inline",
published: {
disabled: !1,
locale: "en_us",
is24HrMode: null,
value: null
},
events: {
onSelect: ""
},
create: function() {
this.inherited(arguments), enyo.g11n && (this.locale = enyo.g11n.currentLocale().getLocale()), this.initDefaults();
},
initDefaults: function() {
var e = "AM", t = "PM";
this.is24HrMode == null && (this.is24HrMode = !1), enyo.g11n && (this._tf = new enyo.g11n.Fmts({
locale: this.locale
}), e = this._tf.getAmCaption(), t = this._tf.getPmCaption(), this.is24HrMode == null && (this.is24HrMode = !this._tf.isAmPm())), this.setupPickers(this._tf ? this._tf.getTimeFieldOrder() : "hma");
var n = this.value = this.value || new Date, r;
if (!this.is24HrMode) {
var i = n.getHours();
i = i === 0 ? 12 : i;
for (r = 1; r <= 12; r++) this.$.hourPicker.createComponent({
content: r,
value: r,
active: r == (i > 12 ? i % 12 : i)
});
} else for (r = 0; r < 24; r++) this.$.hourPicker.createComponent({
content: r,
value: r,
active: r == n.getHours()
});
for (r = 0; r <= 59; r++) this.$.minutePicker.createComponent({
content: r < 10 ? "0" + r : r,
value: r,
active: r == n.getMinutes()
});
n.getHours() >= 12 ? this.$.ampmPicker.createComponents([ {
content: e
}, {
content: t,
active: !0
} ]) : this.$.ampmPicker.createComponents([ {
content: e,
active: !0
}, {
content: t
} ]), this.$.ampmPicker.getParent().setShowing(!this.is24HrMode);
},
setupPickers: function(e) {
var t = e.split(""), n, r, i;
for (r = 0, i = t.length; r < i; r++) {
n = t[r];
switch (n) {
case "h":
this.createHour();
break;
case "m":
this.createMinute();
break;
case "a":
this.createAmPm();
break;
default:
}
}
},
createHour: function() {
this.createComponent({
kind: "onyx.PickerDecorator",
onSelect: "updateHour",
components: [ {
classes: "onyx-timepicker-hour",
name: "hourPickerButton",
disabled: this.disabled
}, {
name: "hourPicker",
kind: "onyx.Picker"
} ]
});
},
createMinute: function() {
this.createComponent({
kind: "onyx.PickerDecorator",
onSelect: "updateMinute",
components: [ {
classes: "onyx-timepicker-minute",
name: "minutePickerButton",
disabled: this.disabled
}, {
name: "minutePicker",
kind: "onyx.Picker"
} ]
});
},
createAmPm: function() {
this.createComponent({
kind: "onyx.PickerDecorator",
onSelect: "updateAmPm",
components: [ {
classes: "onyx-timepicker-ampm",
name: "ampmPickerButton",
disabled: this.disabled
}, {
name: "ampmPicker",
kind: "onyx.Picker"
} ]
});
},
disabledChanged: function() {
this.$.hourPickerButton.setDisabled(this.disabled), this.$.minutePickerButton.setDisabled(this.disabled), this.$.ampmPickerButton.setDisabled(this.disabled);
},
localeChanged: function() {
this.is24HrMode = null, this.refresh();
},
is24HrModeChanged: function() {
this.refresh();
},
valueChanged: function() {
this.refresh();
},
updateHour: function(e, t) {
var n = t.selected.value;
if (!this.is24HrMode) {
var r = this.$.ampmPicker.getParent().controlAtIndex(0).content;
n = n + (n == 12 ? -12 : 0) + (this.isAm(r) ? 0 : 12);
}
return this.value = this.calcTime(n, this.value.getMinutes()), this.doSelect({
name: this.name,
value: this.value
}), !0;
},
updateMinute: function(e, t) {
return this.value = this.calcTime(this.value.getHours(), t.selected.value), this.doSelect({
name: this.name,
value: this.value
}), !0;
},
updateAmPm: function(e, t) {
var n = this.value.getHours();
return this.is24HrMode || (n += n > 11 ? this.isAm(t.content) ? -12 : 0 : this.isAm(t.content) ? 0 : 12), this.value = this.calcTime(n, this.value.getMinutes()), this.doSelect({
name: this.name,
value: this.value
}), !0;
},
calcTime: function(e, t) {
return new Date(this.value.getFullYear(), this.value.getMonth(), this.value.getDate(), e, t, this.value.getSeconds(), this.value.getMilliseconds());
},
isAm: function(e) {
var t, n, r;
try {
t = this._tf.getAmCaption(), n = this._tf.getPmCaption();
} catch (i) {
t = "AM", n = "PM";
}
return e == t ? !0 : !1;
},
refresh: function() {
this.destroyClientControls(), this.initDefaults(), this.render();
}
});

// RadioButton.js

enyo.kind({
name: "onyx.RadioButton",
kind: "Button",
classes: "onyx-radiobutton"
});

// RadioGroup.js

enyo.kind({
name: "onyx.RadioGroup",
kind: "Group",
defaultKind: "onyx.RadioButton",
highlander: !0
});

// ToggleButton.js

enyo.kind({
name: "onyx.ToggleButton",
classes: "onyx-toggle-button",
published: {
active: !1,
value: !1,
onContent: "On",
offContent: "Off",
disabled: !1
},
events: {
onChange: ""
},
handlers: {
ondragstart: "dragstart",
ondrag: "drag",
ondragfinish: "dragfinish"
},
components: [ {
name: "contentOn",
classes: "onyx-toggle-content on"
}, {
name: "contentOff",
classes: "onyx-toggle-content off"
}, {
classes: "onyx-toggle-button-knob"
} ],
create: function() {
this.inherited(arguments), this.value = Boolean(this.value || this.active), this.onContentChanged(), this.offContentChanged(), this.disabledChanged();
},
rendered: function() {
this.inherited(arguments), this.updateVisualState();
},
updateVisualState: function() {
this.addRemoveClass("off", !this.value), this.$.contentOn.setShowing(this.value), this.$.contentOff.setShowing(!this.value), this.setActive(this.value);
},
valueChanged: function() {
this.updateVisualState(), this.doChange({
value: this.value
});
},
activeChanged: function() {
this.setValue(this.active), this.bubble("onActivate");
},
onContentChanged: function() {
this.$.contentOn.setContent(this.onContent || ""), this.$.contentOn.addRemoveClass("empty", !this.onContent);
},
offContentChanged: function() {
this.$.contentOff.setContent(this.offContent || ""), this.$.contentOff.addRemoveClass("empty", !this.onContent);
},
disabledChanged: function() {
this.addRemoveClass("disabled", this.disabled);
},
updateValue: function(e) {
this.disabled || this.setValue(e);
},
tap: function() {
this.updateValue(!this.value);
},
dragstart: function(e, t) {
if (t.horizontal) return t.preventDefault(), this.dragging = !0, this.dragged = !1, !0;
},
drag: function(e, t) {
if (this.dragging) {
var n = t.dx;
return Math.abs(n) > 10 && (this.updateValue(n > 0), this.dragged = !0), !0;
}
},
dragfinish: function(e, t) {
this.dragging = !1, this.dragged && t.preventTap();
}
});

// ToggleIconButton.js

enyo.kind({
name: "onyx.ToggleIconButton",
kind: "onyx.Icon",
published: {
active: !1,
value: !1
},
events: {
onChange: ""
},
classes: "onyx-icon-button onyx-icon-toggle",
activeChanged: function() {
this.addRemoveClass("active", this.value), this.bubble("onActivate");
},
updateValue: function(e) {
this.disabled || (this.setValue(e), this.doChange({
value: this.value
}));
},
tap: function() {
this.updateValue(!this.value);
},
valueChanged: function() {
this.setActive(this.value);
},
create: function() {
this.inherited(arguments), this.value = Boolean(this.value || this.active);
},
rendered: function() {
this.inherited(arguments), this.valueChanged(), this.removeClass("onyx-icon");
}
});

// Toolbar.js

enyo.kind({
name: "onyx.Toolbar",
classes: "onyx onyx-toolbar onyx-toolbar-inline",
create: function() {
this.inherited(arguments), this.hasClass("onyx-menu-toolbar") && enyo.platform.android >= 4 && this.applyStyle("position", "static");
}
});

// Tooltip.js

enyo.kind({
name: "onyx.Tooltip",
kind: "onyx.Popup",
classes: "onyx-tooltip below left-arrow",
autoDismiss: !1,
showDelay: 500,
defaultLeft: -6,
handlers: {
onRequestShowTooltip: "requestShow",
onRequestHideTooltip: "requestHide"
},
requestShow: function() {
return this.showJob = setTimeout(enyo.bind(this, "show"), this.showDelay), !0;
},
cancelShow: function() {
clearTimeout(this.showJob);
},
requestHide: function() {
return this.cancelShow(), this.inherited(arguments);
},
showingChanged: function() {
this.cancelShow(), this.adjustPosition(!0), this.inherited(arguments);
},
applyPosition: function(e) {
var t = "";
for (var n in e) t += n + ":" + e[n] + (isNaN(e[n]) ? "; " : "px; ");
this.addStyles(t);
},
adjustPosition: function(e) {
if (this.showing && this.hasNode()) {
var t = this.node.getBoundingClientRect();
t.top + t.height > window.innerHeight ? (this.addRemoveClass("below", !1), this.addRemoveClass("above", !0)) : (this.addRemoveClass("above", !1), this.addRemoveClass("below", !0)), t.left + t.width > window.innerWidth && (this.applyPosition({
"margin-left": -t.width,
bottom: "auto"
}), this.addRemoveClass("left-arrow", !1), this.addRemoveClass("right-arrow", !0));
}
},
resizeHandler: function() {
this.applyPosition({
"margin-left": this.defaultLeft,
bottom: "auto"
}), this.addRemoveClass("left-arrow", !0), this.addRemoveClass("right-arrow", !1), this.adjustPosition(!0), this.inherited(arguments);
}
});

// TooltipDecorator.js

enyo.kind({
name: "onyx.TooltipDecorator",
defaultKind: "onyx.Button",
classes: "onyx-popup-decorator",
handlers: {
onenter: "enter",
onleave: "leave"
},
enter: function() {
this.requestShowTooltip();
},
leave: function() {
this.requestHideTooltip();
},
tap: function() {
this.requestHideTooltip();
},
requestShowTooltip: function() {
this.waterfallDown("onRequestShowTooltip");
},
requestHideTooltip: function() {
this.waterfallDown("onRequestHideTooltip");
}
});

// ProgressBar.js

enyo.kind({
name: "onyx.ProgressBar",
classes: "onyx-progress-bar",
published: {
progress: 0,
min: 0,
max: 100,
barClasses: "",
showStripes: !0,
animateStripes: !0,
increment: 0
},
events: {
onAnimateProgressFinish: ""
},
components: [ {
name: "progressAnimator",
kind: "Animator",
onStep: "progressAnimatorStep",
onEnd: "progressAnimatorComplete"
}, {
name: "bar",
classes: "onyx-progress-bar-bar"
} ],
create: function() {
this.inherited(arguments), this.progressChanged(), this.barClassesChanged(), this.showStripesChanged(), this.animateStripesChanged();
},
barClassesChanged: function(e) {
this.$.bar.removeClass(e), this.$.bar.addClass(this.barClasses);
},
showStripesChanged: function() {
this.$.bar.addRemoveClass("striped", this.showStripes);
},
animateStripesChanged: function() {
this.$.bar.addRemoveClass("animated", this.animateStripes);
},
progressChanged: function() {
this.progress = this.clampValue(this.min, this.max, this.progress);
var e = this.calcPercent(this.progress);
this.updateBarPosition(e);
},
calcIncrement: function(e) {
return Math.round(e / this.increment) * this.increment;
},
clampValue: function(e, t, n) {
return Math.max(e, Math.min(n, t));
},
calcRatio: function(e) {
return (e - this.min) / (this.max - this.min);
},
calcPercent: function(e) {
return this.calcRatio(e) * 100;
},
updateBarPosition: function(e) {
this.$.bar.applyStyle("width", e + "%");
},
animateProgressTo: function(e) {
this.$.progressAnimator.play({
startValue: this.progress,
endValue: e,
node: this.hasNode()
});
},
progressAnimatorStep: function(e) {
return this.setProgress(e.value), !0;
},
progressAnimatorComplete: function(e) {
return this.doAnimateProgressFinish(e), !0;
}
});

// ProgressButton.js

enyo.kind({
name: "onyx.ProgressButton",
kind: "onyx.ProgressBar",
classes: "onyx-progress-button",
events: {
onCancel: ""
},
components: [ {
name: "progressAnimator",
kind: "Animator",
onStep: "progressAnimatorStep",
onEnd: "progressAnimatorComplete"
}, {
name: "bar",
classes: "onyx-progress-bar-bar onyx-progress-button-bar"
}, {
name: "client",
classes: "onyx-progress-button-client"
}, {
kind: "onyx.Icon",
src: "$lib/onyx/images/progress-button-cancel.png",
classes: "onyx-progress-button-icon",
ontap: "cancelTap"
} ],
cancelTap: function() {
this.doCancel();
}
});

// Scrim.js

enyo.kind({
name: "onyx.Scrim",
showing: !1,
classes: "onyx-scrim enyo-fit",
floating: !1,
create: function() {
this.inherited(arguments), this.zStack = [], this.floating && this.setParent(enyo.floatingLayer);
},
showingChanged: function() {
this.floating && this.showing && !this.hasNode() && this.render(), this.inherited(arguments);
},
addZIndex: function(e) {
enyo.indexOf(e, this.zStack) < 0 && this.zStack.push(e);
},
removeZIndex: function(e) {
enyo.remove(e, this.zStack);
},
showAtZIndex: function(e) {
this.addZIndex(e), e !== undefined && this.setZIndex(e), this.show();
},
hideAtZIndex: function(e) {
this.removeZIndex(e);
if (!this.zStack.length) this.hide(); else {
var t = this.zStack[this.zStack.length - 1];
this.setZIndex(t);
}
},
setZIndex: function(e) {
this.zIndex = e, this.applyStyle("z-index", e);
},
make: function() {
return this;
}
}), enyo.kind({
name: "onyx.scrimSingleton",
kind: null,
constructor: function(e, t) {
this.instanceName = e, enyo.setObject(this.instanceName, this), this.props = t || {};
},
make: function() {
var e = new onyx.Scrim(this.props);
return enyo.setObject(this.instanceName, e), e;
},
showAtZIndex: function(e) {
var t = this.make();
t.showAtZIndex(e);
},
hideAtZIndex: enyo.nop,
show: function() {
var e = this.make();
e.show();
}
}), new onyx.scrimSingleton("onyx.scrim", {
floating: !0,
classes: "onyx-scrim-translucent"
}), new onyx.scrimSingleton("onyx.scrimTransparent", {
floating: !0,
classes: "onyx-scrim-transparent"
});

// Slider.js

enyo.kind({
name: "onyx.Slider",
kind: "onyx.ProgressBar",
classes: "onyx-slider",
published: {
value: 0,
lockBar: !0,
tappable: !0
},
events: {
onChange: "",
onChanging: "",
onAnimateFinish: ""
},
showStripes: !1,
handlers: {
ondragstart: "dragstart",
ondrag: "drag",
ondragfinish: "dragfinish"
},
moreComponents: [ {
kind: "Animator",
onStep: "animatorStep",
onEnd: "animatorComplete"
}, {
classes: "onyx-slider-taparea"
}, {
name: "knob",
classes: "onyx-slider-knob"
} ],
create: function() {
this.inherited(arguments), enyo.platform.firefoxOS && (this.moreComponents[2].ondown = "down", this.moreComponents[2].onleave = "leave"), this.createComponents(this.moreComponents), this.valueChanged();
},
valueChanged: function() {
this.value = this.clampValue(this.min, this.max, this.value);
var e = this.calcPercent(this.value);
this.updateKnobPosition(e), this.lockBar && this.setProgress(this.value);
},
updateKnobPosition: function(e) {
this.$.knob.applyStyle("left", e + "%");
},
calcKnobPosition: function(e) {
var t = e.clientX - this.hasNode().getBoundingClientRect().left;
return t / this.getBounds().width * (this.max - this.min) + this.min;
},
dragstart: function(e, t) {
if (t.horizontal) return t.preventDefault(), this.dragging = !0, !0;
},
drag: function(e, t) {
if (this.dragging) {
var n = this.calcKnobPosition(t);
return n = this.increment ? this.calcIncrement(n) : n, this.setValue(n), this.doChanging({
value: this.value
}), !0;
}
},
dragfinish: function(e, t) {
return this.dragging = !1, t.preventTap(), this.doChange({
value: this.value
}), !0;
},
tap: function(e, t) {
if (this.tappable) {
var n = this.calcKnobPosition(t);
return n = this.increment ? this.calcIncrement(n) : n, this.tapped = !0, this.animateTo(n), !0;
}
},
down: function(e, t) {
this.addClass("pressed");
},
leave: function(e, t) {
this.removeClass("pressed");
},
animateTo: function(e) {
this.$.animator.play({
startValue: this.value,
endValue: e,
node: this.hasNode()
});
},
animatorStep: function(e) {
return this.setValue(e.value), !0;
},
animatorComplete: function(e) {
return this.tapped && (this.tapped = !1, this.doChange({
value: this.value
})), this.doAnimateFinish(e), !0;
}
});

// RangeSlider.js

enyo.kind({
name: "onyx.RangeSlider",
kind: "onyx.ProgressBar",
classes: "onyx-slider",
published: {
rangeMin: 0,
rangeMax: 100,
rangeStart: 0,
rangeEnd: 100,
beginValue: 0,
endValue: 0
},
events: {
onChange: "",
onChanging: ""
},
showStripes: !1,
showLabels: !1,
handlers: {
ondragstart: "dragstart",
ondrag: "drag",
ondragfinish: "dragfinish",
ondown: "down"
},
moreComponents: [ {
name: "startKnob",
classes: "onyx-slider-knob"
}, {
name: "endKnob",
classes: "onyx-slider-knob onyx-range-slider-knob"
} ],
create: function() {
this.inherited(arguments), this.createComponents(this.moreComponents), this.initControls();
},
rendered: function() {
this.inherited(arguments);
var e = this.calcPercent(this.beginValue);
this.updateBarPosition(e);
},
initControls: function() {
this.$.bar.applyStyle("position", "relative"), this.refreshRangeSlider(), this.showLabels && (this.$.startKnob.createComponent({
name: "startLabel",
kind: "onyx.RangeSliderKnobLabel"
}), this.$.endKnob.createComponent({
name: "endLabel",
kind: "onyx.RangeSliderKnobLabel"
}));
},
refreshRangeSlider: function() {
this.beginValue = this.calcKnobPercent(this.rangeStart), this.endValue = this.calcKnobPercent(this.rangeEnd), this.beginValueChanged(), this.endValueChanged();
},
calcKnobRatio: function(e) {
return (e - this.rangeMin) / (this.rangeMax - this.rangeMin);
},
calcKnobPercent: function(e) {
return this.calcKnobRatio(e) * 100;
},
beginValueChanged: function(e) {
if (e === undefined) {
var t = this.calcPercent(this.beginValue);
this.updateKnobPosition(t, this.$.startKnob);
}
},
endValueChanged: function(e) {
if (e === undefined) {
var t = this.calcPercent(this.endValue);
this.updateKnobPosition(t, this.$.endKnob);
}
},
calcKnobPosition: function(e) {
var t = e.clientX - this.hasNode().getBoundingClientRect().left;
return t / this.getBounds().width * (this.max - this.min) + this.min;
},
updateKnobPosition: function(e, t) {
t.applyStyle("left", e + "%"), this.updateBarPosition();
},
updateBarPosition: function() {
if (this.$.startKnob !== undefined && this.$.endKnob !== undefined) {
var e = this.calcKnobPercent(this.rangeStart), t = this.calcKnobPercent(this.rangeEnd) - e;
this.$.bar.applyStyle("left", e + "%"), this.$.bar.applyStyle("width", t + "%");
}
},
calcRangeRatio: function(e) {
return e / 100 * (this.rangeMax - this.rangeMin) + this.rangeMin - this.increment / 2;
},
swapZIndex: function(e) {
e === "startKnob" ? (this.$.startKnob.applyStyle("z-index", 1), this.$.endKnob.applyStyle("z-index", 0)) : e === "endKnob" && (this.$.startKnob.applyStyle("z-index", 0), this.$.endKnob.applyStyle("z-index", 1));
},
down: function(e, t) {
this.swapZIndex(e.name);
},
dragstart: function(e, t) {
if (t.horizontal) return t.preventDefault(), this.dragging = !0, !0;
},
drag: function(e, t) {
if (this.dragging) {
var n = this.calcKnobPosition(t), r, i, s;
if (e.name === "startKnob" && n >= 0) {
if (!(n <= this.endValue && t.xDirection === -1 || n <= this.endValue)) return this.drag(this.$.endKnob, t);
this.setBeginValue(n), r = this.calcRangeRatio(this.beginValue), i = this.increment ? this.calcIncrement(r + .5 * this.increment) : r, s = this.calcKnobPercent(i), this.updateKnobPosition(s, this.$.startKnob), this.setRangeStart(i), this.doChanging({
value: i
});
} else if (e.name === "endKnob" && n <= 100) {
if (!(n >= this.beginValue && t.xDirection === 1 || n >= this.beginValue)) return this.drag(this.$.startKnob, t);
this.setEndValue(n), r = this.calcRangeRatio(this.endValue), i = this.increment ? this.calcIncrement(r + .5 * this.increment) : r, s = this.calcKnobPercent(i), this.updateKnobPosition(s, this.$.endKnob), this.setRangeEnd(i), this.doChanging({
value: i
});
}
return !0;
}
},
dragfinish: function(e, t) {
this.dragging = !1, t.preventTap();
var n;
return e.name === "startKnob" ? (n = this.calcRangeRatio(this.beginValue), this.doChange({
value: n,
startChanged: !0
})) : e.name === "endKnob" && (n = this.calcRangeRatio(this.endValue), this.doChange({
value: n,
startChanged: !1
})), !0;
},
rangeMinChanged: function() {
this.refreshRangeSlider();
},
rangeMaxChanged: function() {
this.refreshRangeSlider();
},
rangeStartChanged: function() {
this.refreshRangeSlider();
},
rangeEndChanged: function() {
this.refreshRangeSlider();
},
setStartLabel: function(e) {
this.$.startKnob.waterfallDown("onSetLabel", e);
},
setEndLabel: function(e) {
this.$.endKnob.waterfallDown("onSetLabel", e);
}
}), enyo.kind({
name: "onyx.RangeSliderKnobLabel",
classes: "onyx-range-slider-label",
handlers: {
onSetLabel: "setLabel"
},
setLabel: function(e, t) {
this.setContent(t);
}
});

// Item.js

enyo.kind({
name: "onyx.Item",
classes: "onyx-item",
tapHighlight: !0,
handlers: {
onhold: "hold",
onrelease: "release"
},
hold: function(e, t) {
this.tapHighlight && onyx.Item.addRemoveFlyweightClass(this.controlParent || this, "onyx-highlight", !0, t);
},
release: function(e, t) {
this.tapHighlight && onyx.Item.addRemoveFlyweightClass(this.controlParent || this, "onyx-highlight", !1, t);
},
statics: {
addRemoveFlyweightClass: function(e, t, n, r, i) {
var s = r.flyweight;
if (s) {
var o = i !== undefined ? i : r.index;
s.performOnRow(o, function() {
e.addRemoveClass(t, n);
});
}
}
}
});

// Spinner.js

enyo.kind({
name: "onyx.Spinner",
classes: "onyx-spinner",
stop: function() {
this.setShowing(!1);
},
start: function() {
this.setShowing(!0);
},
toggle: function() {
this.setShowing(!this.getShowing());
}
});

// MoreToolbar.js

enyo.kind({
name: "onyx.MoreToolbar",
classes: "onyx-toolbar onyx-more-toolbar",
menuClass: "",
movedClass: "",
layoutKind: "FittableColumnsLayout",
noStretch: !0,
handlers: {
onHide: "reflow"
},
published: {
clientLayoutKind: "FittableColumnsLayout"
},
tools: [ {
name: "client",
noStretch: !0,
fit: !0,
classes: "onyx-toolbar-inline"
}, {
name: "nard",
kind: "onyx.MenuDecorator",
showing: !1,
onActivate: "activated",
components: [ {
kind: "onyx.IconButton",
classes: "onyx-more-button"
}, {
name: "menu",
kind: "onyx.Menu",
scrolling: !1,
classes: "onyx-more-menu"
} ]
} ],
initComponents: function() {
this.menuClass && this.menuClass.length > 0 && !this.$.menu.hasClass(this.menuClass) && this.$.menu.addClass(this.menuClass), this.createChrome(this.tools), this.inherited(arguments), this.$.client.setLayoutKind(this.clientLayoutKind);
},
clientLayoutKindChanged: function() {
this.$.client.setLayoutKind(this.clientLayoutKind);
},
reflow: function() {
this.inherited(arguments), this.isContentOverflowing() ? (this.$.nard.show(), this.popItem() && this.reflow()) : this.tryPushItem() ? this.reflow() : this.$.menu.children.length || (this.$.nard.hide(), this.$.menu.hide());
},
activated: function(e, t) {
this.addRemoveClass("active", t.originator.active);
},
popItem: function() {
var e = this.findCollapsibleItem();
if (e) {
this.movedClass && this.movedClass.length > 0 && !e.hasClass(this.movedClass) && e.addClass(this.movedClass), this.$.menu.addChild(e, null);
var t = this.$.menu.hasNode();
return t && e.hasNode() && e.insertNodeInParent(t), !0;
}
},
pushItem: function() {
var e = this.$.menu.children, t = e[0];
if (t) {
this.movedClass && this.movedClass.length > 0 && t.hasClass(this.movedClass) && t.removeClass(this.movedClass), this.$.client.addChild(t);
var n = this.$.client.hasNode();
if (n && t.hasNode()) {
var r, i;
for (var s = 0; s < this.$.client.children.length; s++) {
var o = this.$.client.children[s];
if (o.toolbarIndex !== undefined && o.toolbarIndex != s) {
r = o, i = s;
break;
}
}
if (r && r.hasNode()) {
t.insertNodeInParent(n, r.node);
var u = this.$.client.children.pop();
this.$.client.children.splice(i, 0, u);
} else t.appendNodeToParent(n);
}
return !0;
}
},
tryPushItem: function() {
if (this.pushItem()) {
if (!this.isContentOverflowing()) return !0;
this.popItem();
}
},
isContentOverflowing: function() {
if (this.$.client.hasNode()) {
var e = this.$.client.children, t = e[e.length - 1].hasNode();
if (t) return this.$.client.reflow(), t.offsetLeft + t.offsetWidth > this.$.client.node.clientWidth;
}
},
findCollapsibleItem: function() {
var e = this.$.client.children;
for (var t = e.length - 1; c = e[t]; t--) {
if (!c.unmoveable) return c;
c.toolbarIndex === undefined && (c.toolbarIndex = t);
}
}
});

// IntegerPicker.js

enyo.kind({
name: "onyx.IntegerPicker",
kind: "onyx.Picker",
published: {
value: 0,
min: 0,
max: 9
},
create: function() {
this.inherited(arguments), this.rangeChanged();
},
minChanged: function() {
this.destroyClientControls(), this.rangeChanged(), this.render();
},
maxChanged: function() {
this.destroyClientControls(), this.rangeChanged(), this.render();
},
rangeChanged: function() {
for (var e = this.min; e <= this.max; e++) this.createComponent({
content: e,
active: e === this.value ? !0 : !1
});
},
valueChanged: function(e) {
var t = this.getClientControls(), n = t.length;
this.value = this.value >= this.min && this.value <= this.max ? this.value : this.min;
for (var r = 0; r < n; r++) if (this.value === parseInt(t[r].content)) {
this.setSelected(t[r]);
break;
}
},
selectedChanged: function(e) {
e && e.removeClass("selected"), this.selected && (this.selected.addClass("selected"), this.doChange({
selected: this.selected,
content: this.selected.content
})), this.value = parseInt(this.selected.content);
}
});

// ContextualPopup.js

enyo.kind({
name: "onyx.ContextualPopup",
kind: "enyo.Popup",
modal: !0,
autoDismiss: !0,
floating: !1,
classes: "onyx-contextual-popup enyo-unselectable",
published: {
maxHeight: 100,
scrolling: !0,
title: undefined,
actionButtons: []
},
vertFlushMargin: 60,
horizFlushMargin: 50,
widePopup: 200,
longPopup: 200,
horizBuffer: 16,
events: {
onTap: ""
},
handlers: {
onActivate: "itemActivated",
onRequestShowMenu: "requestShow",
onRequestHideMenu: "requestHide"
},
components: [ {
name: "title",
classes: "onyx-contextual-popup-title"
}, {
classes: "onyx-contextual-popup-scroller",
components: [ {
name: "client",
kind: "enyo.Scroller",
vertical: "auto",
classes: "enyo-unselectable",
thumb: !1,
strategyKind: "TouchScrollStrategy"
} ]
}, {
name: "actionButtons",
classes: "onyx-contextual-popup-action-buttons"
} ],
scrollerName: "client",
create: function() {
this.inherited(arguments), this.maxHeightChanged(), this.titleChanged(), this.actionButtonsChanged();
},
getScroller: function() {
return this.$[this.scrollerName];
},
titleChanged: function() {
this.$.title.setContent(this.title);
},
actionButtonsChanged: function() {
for (var e = 0; e < this.actionButtons.length; e++) this.$.actionButtons.createComponent({
kind: "onyx.Button",
content: this.actionButtons[e].content,
classes: this.actionButtons[e].classes + " onyx-contextual-popup-action-button",
name: this.actionButtons[e].name ? this.actionButtons[e].name : "ActionButton" + e,
index: e,
tap: enyo.bind(this, this.tapHandler)
});
},
tapHandler: function(e, t) {
return t.actionButton = !0, t.popup = this, this.bubble("ontap", t), !0;
},
maxHeightChanged: function() {
this.scrolling && this.getScroller().setMaxHeight(this.maxHeight + "px");
},
itemActivated: function(e, t) {
return t.originator.setActive(!1), !0;
},
showingChanged: function() {
this.inherited(arguments), this.scrolling && this.getScroller().setShowing(this.showing), this.adjustPosition();
},
requestShow: function(e, t) {
var n = t.activator.hasNode();
return n && (this.activatorOffset = this.getPageOffset(n)), this.show(), !0;
},
applyPosition: function(e) {
var t = "";
for (var n in e) t += n + ":" + e[n] + (isNaN(e[n]) ? "; " : "px; ");
this.addStyles(t);
},
getPageOffset: function(e) {
var t = this.getBoundingRect(e), n = window.pageYOffset === undefined ? document.documentElement.scrollTop : window.pageYOffset, r = window.pageXOffset === undefined ? document.documentElement.scrollLeft : window.pageXOffset, i = t.height === undefined ? t.bottom - t.top : t.height, s = t.width === undefined ? t.right - t.left : t.width;
return {
top: t.top + n,
left: t.left + r,
height: i,
width: s
};
},
adjustPosition: function() {
if (this.showing && this.hasNode()) {
this.resetPositioning();
var e = this.getViewWidth(), t = this.getViewHeight(), n = this.vertFlushMargin, r = t - this.vertFlushMargin, i = this.horizFlushMargin, s = e - this.horizFlushMargin;
if (this.activatorOffset.top + this.activatorOffset.height < n || this.activatorOffset.top > r) {
if (this.applyVerticalFlushPositioning(i, s)) return;
if (this.applyHorizontalFlushPositioning(i, s)) return;
if (this.applyVerticalPositioning()) return;
} else if (this.activatorOffset.left + this.activatorOffset.width < i || this.activatorOffset.left > s) if (this.applyHorizontalPositioning()) return;
var o = this.getBoundingRect(this.node);
if (o.width > this.widePopup) {
if (this.applyVerticalPositioning()) return;
} else if (o.height > this.longPopup && this.applyHorizontalPositioning()) return;
if (this.applyVerticalPositioning()) return;
if (this.applyHorizontalPositioning()) return;
}
},
initVerticalPositioning: function() {
this.resetPositioning(), this.addClass("vertical");
var e = this.getBoundingRect(this.node), t = this.getViewHeight();
return this.floating ? this.activatorOffset.top < t / 2 ? (this.applyPosition({
top: this.activatorOffset.top + this.activatorOffset.height,
bottom: "auto"
}), this.addClass("below")) : (this.applyPosition({
top: this.activatorOffset.top - e.height,
bottom: "auto"
}), this.addClass("above")) : e.top + e.height > t && t - e.bottom < e.top - e.height ? this.addClass("above") : this.addClass("below"), e = this.getBoundingRect(this.node), e.top + e.height > t || e.top < 0 ? !1 : !0;
},
applyVerticalPositioning: function() {
if (!this.initVerticalPositioning()) return !1;
var e = this.getBoundingRect(this.node), t = this.getViewWidth();
if (this.floating) {
var n = this.activatorOffset.left + this.activatorOffset.width / 2 - e.width / 2;
n + e.width > t ? (this.applyPosition({
left: this.activatorOffset.left + this.activatorOffset.width - e.width
}), this.addClass("left")) : n < 0 ? (this.applyPosition({
left: this.activatorOffset.left
}), this.addClass("right")) : this.applyPosition({
left: n
});
} else {
var r = this.activatorOffset.left + this.activatorOffset.width / 2 - e.left - e.width / 2;
e.right + r > t ? (this.applyPosition({
left: this.activatorOffset.left + this.activatorOffset.width - e.right
}), this.addRemoveClass("left", !0)) : e.left + r < 0 ? this.addRemoveClass("right", !0) : this.applyPosition({
left: r
});
}
return !0;
},
applyVerticalFlushPositioning: function(e, t) {
if (!this.initVerticalPositioning()) return !1;
var n = this.getBoundingRect(this.node), r = this.getViewWidth();
return this.activatorOffset.left + this.activatorOffset.width / 2 < e ? (this.activatorOffset.left + this.activatorOffset.width / 2 < this.horizBuffer ? this.applyPosition({
left: this.horizBuffer + (this.floating ? 0 : -n.left)
}) : this.applyPosition({
left: this.activatorOffset.width / 2 + (this.floating ? this.activatorOffset.left : 0)
}), this.addClass("right"), this.addClass("corner"), !0) : this.activatorOffset.left + this.activatorOffset.width / 2 > t ? (this.activatorOffset.left + this.activatorOffset.width / 2 > r - this.horizBuffer ? this.applyPosition({
left: r - this.horizBuffer - n.right
}) : this.applyPosition({
left: this.activatorOffset.left + this.activatorOffset.width / 2 - n.right
}), this.addClass("left"), this.addClass("corner"), !0) : !1;
},
initHorizontalPositioning: function() {
this.resetPositioning();
var e = this.getBoundingRect(this.node), t = this.getViewWidth();
return this.floating ? this.activatorOffset.left + this.activatorOffset.width < t / 2 ? (this.applyPosition({
left: this.activatorOffset.left + this.activatorOffset.width
}), this.addRemoveClass("left", !0)) : (this.applyPosition({
left: this.activatorOffset.left - e.width
}), this.addRemoveClass("right", !0)) : this.activatorOffset.left - e.width > 0 ? (this.applyPosition({
left: this.activatorOffset.left - e.left - e.width
}), this.addRemoveClass("right", !0)) : (this.applyPosition({
left: this.activatorOffset.width
}), this.addRemoveClass("left", !0)), this.addRemoveClass("horizontal", !0), e = this.getBoundingRect(this.node), e.left < 0 || e.left + e.width > t ? !1 : !0;
},
applyHorizontalPositioning: function() {
if (!this.initHorizontalPositioning()) return !1;
var e = this.getBoundingRect(this.node), t = this.getViewHeight(), n = this.activatorOffset.top + this.activatorOffset.height / 2;
return this.floating ? n >= t / 2 - .05 * t && n <= t / 2 + .05 * t ? this.applyPosition({
top: this.activatorOffset.top + this.activatorOffset.height / 2 - e.height / 2,
bottom: "auto"
}) : this.activatorOffset.top + this.activatorOffset.height < t / 2 ? (this.applyPosition({
top: this.activatorOffset.top - this.activatorOffset.height,
bottom: "auto"
}), this.addRemoveClass("high", !0)) : (this.applyPosition({
top: this.activatorOffset.top - e.height + this.activatorOffset.height * 2,
bottom: "auto"
}), this.addRemoveClass("low", !0)) : n >= t / 2 - .05 * t && n <= t / 2 + .05 * t ? this.applyPosition({
top: (this.activatorOffset.height - e.height) / 2
}) : this.activatorOffset.top + this.activatorOffset.height < t / 2 ? (this.applyPosition({
top: -this.activatorOffset.height
}), this.addRemoveClass("high", !0)) : (this.applyPosition({
top: e.top - e.height - this.activatorOffset.top + this.activatorOffset.height
}), this.addRemoveClass("low", !0)), !0;
},
applyHorizontalFlushPositioning: function(e, t) {
if (!this.initHorizontalPositioning()) return !1;
var n = this.getBoundingRect(this.node), r = this.getViewWidth();
return this.floating ? this.activatorOffset.top < innerHeight / 2 ? (this.applyPosition({
top: this.activatorOffset.top + this.activatorOffset.height / 2
}), this.addRemoveClass("high", !0)) : (this.applyPosition({
top: this.activatorOffset.top + this.activatorOffset.height / 2 - n.height
}), this.addRemoveClass("low", !0)) : n.top + n.height > innerHeight && innerHeight - n.bottom < n.top - n.height ? (this.applyPosition({
top: n.top - n.height - this.activatorOffset.top - this.activatorOffset.height / 2
}), this.addRemoveClass("low", !0)) : (this.applyPosition({
top: this.activatorOffset.height / 2
}), this.addRemoveClass("high", !0)), this.activatorOffset.left + this.activatorOffset.width < e ? (this.addClass("left"), this.addClass("corner"), !0) : this.activatorOffset.left > t ? (this.addClass("right"), this.addClass("corner"), !0) : !1;
},
getBoundingRect: function(e) {
var t = e.getBoundingClientRect();
return !t.width || !t.height ? {
left: t.left,
right: t.right,
top: t.top,
bottom: t.bottom,
width: t.right - t.left,
height: t.bottom - t.top
} : t;
},
getViewHeight: function() {
return window.innerHeight === undefined ? document.documentElement.clientHeight : window.innerHeight;
},
getViewWidth: function() {
return window.innerWidth === undefined ? document.documentElement.clientWidth : window.innerWidth;
},
resetPositioning: function() {
this.removeClass("right"), this.removeClass("left"), this.removeClass("high"), this.removeClass("low"), this.removeClass("corner"), this.removeClass("below"), this.removeClass("above"), this.removeClass("vertical"), this.removeClass("horizontal"), this.applyPosition({
left: "auto"
}), this.applyPosition({
top: "auto"
});
},
resizeHandler: function() {
this.inherited(arguments), this.adjustPosition();
},
requestHide: function() {
this.setShowing(!1);
}
});

// Language.js

_LANGUAGE = null, setLanguage = function(e) {
if (e !== undefined && e.length == 2) return _LANGUAGE = e, console.log("Language: " + _LANGUAGE), _LANGUAGE;
var t = window.navigator.userLanguage || window.navigator.language;
return t !== undefined && t != null ? (t = t.substring(0, 2), _LANGUAGE = t, console.log("Language: " + _LANGUAGE), _LANGUAGE) : _LANGUAGE;
}, getLanguage = function() {
return _LANGUAGE;
}, _L = function(e, t, n) {
_LANGUAGE == null && setLanguage();
var r = _STRINGS[e];
if (r === undefined) return enyo.error("Language string error: " + e + ", " + t), "---";
r = r[t];
if (r === undefined) return enyo.error("Language string error: " + e + ", " + t), "---";
r = r[_LANGUAGE];
if (r === undefined || r == null || r == "") r = _STRINGS[e][t].en;
if (n) if (typeof n == "string") r = r.replace("<?>", n); else for (var i = 0; i < n.length; i++) r = r.replace("<?>", n[i]);
return r;
};

// Strings.js

_STRINGS = {
Editor: {
Thanks: {
en: "Thank you!",
de: "Vielen Dank!"
},
Yes: {
en: "Yes",
de: "Ja"
},
No: {
en: "No",
de: "Nein"
},
Advertisement: {
en: "Advertisement",
de: "Werbung"
},
PleaseWait: {
en: "Please wait...",
de: "Bitte warten..."
},
AboutLabel: {
en: "About...",
de: "\u00dcber..."
},
PreferencesLabel: {
en: "Preferences...",
de: "Einstellungen..."
},
ExitLabel: {
en: "Exit",
de: "Beenden"
},
NewFileLabel: {
en: "New file",
de: "Neue Datei"
},
OpenFileLabel: {
en: "Open file...",
de: "Datei \u00f6ffnen..."
},
CloseLabel: {
en: "Close",
de: "Schlie\u00dfen"
},
SaveFileAsLabel: {
en: "Save as...",
de: "Speichern unter..."
},
SaveFileLabel: {
en: "Save",
de: "Speichern"
},
DeleteLabel: {
en: "Delete file",
de: "Datei l\u00f6schen"
},
ManualLabel: {
en: "Manual...",
de: "Anleitung..."
},
NameOfUntitledFiles: {
en: "Untitled",
de: "Unbenannt"
},
PathNameOfUntitledFiles: {
en: "Untitled_documents/",
de: "Unbenannte_Textdateien/"
},
OverrideQuestion: {
en: "This file already exists. Do you want to overwrite it?",
de: "Diese Datei existiert bereits. M\u00f6chten Sie die Datei \u00fcberschreiben?"
},
FileUnsavedCloseAnywayQuestion: {
en: "Do you want to discard the changes you made? Tap cancel to return to your file...",
de: "M\u00f6chten Sie die \u00c4nderungen verwerfen? Klicken Sie 'Abbrechen', um zu Ihrer Datei zur\u00fcckzukehren..."
},
DeleteFileQuestion: {
en: "Are you sure that you want to delete this file?",
de: "M\u00f6chten Sie diese Datei wirklich l\u00f6schen?"
},
UndoLabel: {
en: "Undo",
de: "R\u00fcckg\u00e4ngig"
},
RedoLabel: {
en: "Redo",
de: "Wiederholen"
},
CutLabel: {
en: "Cut",
de: "Ausschneiden"
},
CopyLabel: {
en: "Copy",
de: "Kopieren"
},
PasteLabel: {
en: "Paste",
de: "Einf\u00fcgen"
},
SelectAllLabel: {
en: "Select all",
de: "Alles markieren"
},
SpecialCharLabel: {
en: "Special character...",
de: "Sonderzeichen..."
}
},
FileIO: {
FileWriteSuccess: {
en: "File successfully written",
de: "Ihre Datei wurde erfolgreich geschrieben"
},
FileAlreadyExists: {
en: "A file with this name already exists",
de: "Eine Datei mit diesem Namen existiert bereits"
},
FilePermissionDenied: {
en: "Permission denied - please grant the app permission to read and write files",
de: "Zugriff verweigert - bitte garantieren Sie der Anwendung Lese-Schreibe-Rechte"
},
FileWriteError: {
en: "File could not be written",
de: "Die Datei konnte nicht geschrieben werden"
},
InvalidFileName: {
en: "Invalid file name",
de: "Ung\u00fcltiger Dateiname"
},
FileReadSuccess: {
en: "File was successfully read",
de: "Datei wurde erfolgreich gelesen"
},
FileReadFailure: {
en: "File could not be read",
de: "Datei konnte nicht gelesen werden"
},
FileNotFound: {
en: "File could not be found",
de: "Datei konnte nicht gefunden werden"
},
FileDeleteSuccess: {
en: "File was successfully deleted",
de: "Datei wurde erfolgreich gel\u00f6scht"
},
FileDeleteFailure: {
en: "File could not be deleted",
de: "Datei konnte nicht gel\u00f6scht werden"
}
},
SearchReplacePopup: {
SearchReplacePopupLabel: {
en: "Find/Replace...",
de: "Suchen/Ersetzen..."
},
SearchLabel: {
en: "Find...",
de: "Suchen..."
},
ReplaceLabel: {
en: "Replace...",
de: "Ersetzen..."
},
FindNextLabel: {
en: "Find next occurrence",
de: "N\u00e4chstes Vorkommen finden"
},
ReplaceNextLabel: {
en: "Replace next occurrence",
de: "N\u00e4chstes Vorkommen ersetzen"
},
ReplaceAllLabel: {
en: "Replace all occurrences",
de: "Alle Vorkommen ersetzen"
},
CaseInsensitiveLabel: {
en: "Ignore case sensitivity",
de: "Gro\u00df-/Kleinsch. ignorieren"
},
SearchAgainFromStartQuestion: {
en: 'Next occurrence of "<?>" not found. Continue search from start of file?',
de: 'N\u00e4chstes Vorkommen von "<?>"  wurde nicht gefunden. Suche erneut vom Dateianfang beginnen?'
},
SearchSuccess: {
en: 'Next occurrence of "<?>" was found and marked.',
de: 'Das n\u00e4chste Vorkommen von "<?>" wurde gefunden und markiert.'
},
ReplaceSuccess: {
en: 'Next occurrence of "<?>" was found and replaced by "<?>".',
de: 'Das n\u00e4chste Vorkommen von "<?>" wurde gefunden und ersetzt durch "<?>".'
},
ReplaceAllSuccess: {
en: 'All occurrences of "<?>" were replaced by "<?>".',
de: 'Alle Vorkommen von "<?>" wurden durch "<?>" ersetzt.'
},
NoOccurrenceFound: {
en: 'No occurrence of "<?>" found.',
de: 'Kein Vorkommen von "<?>" gefunden.'
}
},
FilePicker: {
FilePickerLabel: {
en: "Please pick a file...",
de: "Datei ausw\u00e4hlen..."
},
PickedAFolder: {
en: "You picked a folder, not a file. Please go back and pick the file you want to open...",
de: "Sie haben einen Ordner ausgew\u00e4hlt, keine Datei. Bitte gehen Sie zur\u00fcck und w\u00e4hlen Sie die Datei aus, welche Sie \u00f6ffnen m\u00f6chten..."
},
FolderPickerLabel: {
en: "Please pick a folder...",
de: "Verzeichnis ausw\u00e4hlen..."
},
NewFolderPrompt: {
en: "Please name your new folder:",
de: "Bitte geben Sie einen Namen f\u00fcr den neuen Ordner ein:"
},
NewFolderLabel: {
en: "New Folder",
de: "Neuer Ordner"
},
OnlyNotEmptyFoldersInfo: {
en: "Please note: Currently, the app ignores empty folders due to a limitation in the operating system. We're looking forward to change this in a upcoming version. At the moment we can't give you further informations about the issue.",
de: "Bemerkung: Derzeit ignoriert die Anwendung leere Ordner. Wir versuchen dies in einer kommenden Version zu \u00e4ndern, k\u00f6nnen Ihnen im Moment aber keine genaueren Details nennen."
}
},
SaveAsPopup: {
FileNameLabel: {
en: "Name your file...",
de: "Ihr Dateiname..."
}
},
EditorPrefs: {
TextDisplayLabel: {
en: "Text display settings",
de: "Anzeigeoptionen"
},
TextDisplayHeadLabel: {
en: "Font, colors and line wrapping",
de: "Schrift, Farben und Zeilenumbruch"
},
ExampleText: {
en: "This is an example text. Change the text display options and you'll see the change here!",
de: "Dies ist ein Beispieltext. \u00c4ndern Sie die Anzeigeoptionen und schauen Sie sich die \u00c4nderung hier als Vorschau an..."
},
ForegroundColor: {
en: "Font color",
de: "Schriftfarbe"
},
BackgroundColor: {
en: "Background color",
de: "Hintergrundfarbe"
},
WrappingLabel: {
en: "Automatic line wrapping",
de: "Automatischer Zeilenumbruch"
},
AutoBackupLabel: {
en: "Automatic backup",
de: "Automatisches Backup"
},
AutoBackupInfoText: {
en: "Here you can turn on / off the automatic backup function. If the autmatic backup is activated, the product saves a copy of every opened file to the backup folder on your memory card. Hint: If you handle important files, please consider to make backups on external spaces as well.",
de: "Hier k\u00f6nnen Sie die automatische Backup-Funktion an- bzw. ausschalten. Ist das automatische Backup angeschaltet, so wird jedes Mal beim \u00d6ffnen einer Datei eine Kopie im Backup-Ordner auf Ihrer SD-Karte gespeichert. Tipp: Sollten Sie wichtige Dateien handhaben, denken Sie ggf. \u00fcber eine externe Backup-L\u00f6sung nach."
},
AutoBackupOverride: {
en: "Overwrite existing backup",
de: "\u00dcberschreibe existierendes Backup"
},
AutoBackupClearLabel: {
en: "Clear backup folder",
de: "Backup-Ordner l\u00f6schen"
},
AutoBackupClearInfo: {
en: "This will delete the backup folder with all it's content. Are you sure?",
de: "Dies l\u00f6scht Ihren ganzen Backup-Ordner mit allen Inhalten. Sind Sie sich sicher?"
}
},
About: {
EULAinfo: {
en: "By using the app you agree with the end-user license agreement (EULA). Please scroll down and read it carefully before using the app...",
de: "Durch die Benutzung der Software stimmen Sie der End-User License Agreement (EULA) zu. Scrollen Sie nach unten und lesen Sie die EULA sorgf\u00e4ltig (nur in Englisch verf\u00fcgbar)..."
},
GeneralInfoLabel: {
en: "General information",
de: "Allgemeine Informationen"
},
ThanksText: {
en: "Dear customer, thank you for downloading this application. This is the final version of Text Editor. Please keep in mind that the development and support was discontinued. I hope you enjoy the app on your Firefox OS phone. If you're a developer and want to continue the development, please contact me.",
de: "Lieber Kunde, vielen Dank f\u00fcr den Download. This ist die letzte Version von Text Editor. Bitte beachten Sie, dass die Entwicklung und der Support bereits eingestellt wurde. Ich hoffe Sie finden die App n\u00fctzlich f\u00fcr Ihr Firefox OS Telefon. Wenn Sie ein Entwickler sind und die App weiterentwicklen m\u00f6chten, kontaktieren Sie mich bitte."
},
DevAndContactLabel: {
en: "Developer and contact",
de: "Entwickler und Kontakt"
},
EmailButton: {
en: "Contact via email",
de: "Kontaktaufnahme \u00fcber E-Mail"
},
Issue: {
en: "Please describe your issue: ",
de: "Bitte beschreiben Sie Ihr Anliegen: "
}
}
};

// Storage.js

enyo.getCookie = function(e) {
try {
var t;
typeof e == "string" && (t = localStorage.getItem(e));
if (typeof t == "string") {
var n;
try {
n = JSON.parse(t);
} catch (r) {
n = t;
}
return n;
}
if (typeof t == "object" && t !== null) throw enyo.log("OBJECT: " + t), "ERROR [Storage.get]: getItem returned an object. Should be a string.";
if (typeof t == "undefined" || t === null) return undefined;
} catch (r) {
enyo.log(r);
}
}, enyo.setCookie = function(e, t) {
try {
typeof e == "string" && (typeof t == "object" ? localStorage.setItem(e, JSON.stringify(t)) : (typeof t == "string" || typeof t == "boolean") && localStorage.setItem(e, t));
} catch (n) {
enyo.log(n);
}
};

// Editor.js

enyo.kind({
name: "Editor",
kind: "FittableRows",
fit: !0,
handlers: {
onFilePick: "readFile",
onReadSuccess: "openFile",
onReadError: "handleStandardIOError",
onWriteSuccess: "handleWriteSuccess",
onWriteError: "handleWriteError",
onDeleteSuccess: "handleDeleteSuccess",
onDeleteError: "handleStandardIOError",
onSaveAsFile: "handleSaveAsFile",
onTextChange: "handleTextChange",
onRequestStyleUpdate: "handleRequestStyleUpdate",
onSaveFileRequest: "saveFileSilently",
onInsertCharAtCursor: "handleInsertCharAtCursor",
onSearchRequest: "handleSearchRequest",
onReplaceRequest: "handleReplaceRequest",
onReplaceAllRequest: "handleReplaceAllRequest"
},
events: {
onGotoWindowRequest: ""
},
components: [ {
kind: "FileIO",
name: "fileIO"
}, {
kind: "SpecialCharPopup",
name: "specialCharPopup"
}, {
kind: "SearchReplacePopup",
name: "searchReplacePopup"
}, {
kind: "onyx.Toolbar",
name: "menu",
onclick: "closeAd",
show: !0,
classes: "menu-toolbar",
components: [ {
kind: "onyx.MenuDecorator",
components: [ {
kind: "onyx.IconButton",
src: "assets/icons/home.png"
}, {
kind: "onyx.Menu",
classes: "menu-dropdown",
maxHeight: 320,
maxWidth: 304,
components: [ {
ontap: "gotoPreferences",
content: _L("Editor", "PreferencesLabel")
}, {
ontap: "gotoWebpage",
content: _L("Editor", "ManualLabel"),
url: "http://apps.tamoggemon.com/app/text-editor/manual/"
}, {
ontap: "about",
content: _L("Editor", "AboutLabel")
}, {
classes: "onyx-menu-divider"
}, {
ontap: "exitApp",
content: _L("Editor", "ExitLabel")
}, {
classes: "onyx-menu-divider"
}, {
ontap: "gotoWebpage",
allowHtml: !0,
content: "<i style='font-size:8pt'>" + _L("Editor", "Advertisement") + "</i><br><img src='assets/advertisement.png'/>",
url: "http://www.youtube.com/watch?v=uGGN5ZJ0LiE"
} ]
} ]
}, {
kind: "onyx.MenuDecorator",
components: [ {
kind: "onyx.IconButton",
src: "assets/icons/filemenu.png"
}, {
kind: "onyx.Menu",
classes: "menu-dropdown",
maxHeight: 320,
components: [ {
ontap: "newFile",
content: _L("Editor", "NewFileLabel")
}, {
ontap: "openFilePicker",
content: _L("Editor", "OpenFileLabel")
}, {
classes: "onyx-menu-divider"
}, {
ontap: "closeFile",
content: _L("Editor", "CloseLabel")
}, {
ontap: "deleteFile",
content: _L("Editor", "DeleteLabel")
}, {
classes: "onyx-menu-divider"
}, {
ontap: "saveFileSilently",
content: _L("Editor", "SaveFileLabel")
}, {
ontap: "saveAsFile",
content: _L("Editor", "SaveFileAsLabel")
} ]
} ]
}, {
kind: "onyx.MenuDecorator",
components: [ {
kind: "onyx.IconButton",
src: "assets/icons/extras.png"
}, {
kind: "onyx.Menu",
classes: "menu-dropdown",
components: [ {
content: _L("Editor", "UndoLabel"),
ontap: "singleFileFunctionCmd",
cmd: "undo"
}, {
content: _L("Editor", "RedoLabel"),
ontap: "singleFileFunctionCmd",
cmd: "redo"
}, {
classes: "onyx-menu-divider"
}, {
content: _L("Editor", "SpecialCharLabel"),
popup: "specialCharPopup",
ontap: "showPopup"
}, {
content: _L("SearchReplacePopup", "SearchReplacePopupLabel"),
ontap: "showSearchReplacePopup"
} ]
} ]
}, {
kind: "onyx.MenuDecorator",
onSelect: "fileMenuTabSelect",
maxHeight: 320,
components: [ {
name: "fileMenuTabHead",
content: "<empty>",
allowHtml: !0,
style: "padding-left:7px; padding-right:11px;"
}, {
kind: "onyx.Menu",
name: "fileMenuTab",
classes: "menu-dropdown",
components: []
} ]
} ]
}, {
tag: "img",
src: "assets/icons/menuToggler.png",
style: "position:fixed; top:0px; right:0px; z-index:20;",
ontap: "toggleMenu"
}, {
kind: "Panels",
name: "panelFiles",
fit: !0,
realtimeFit: !0,
draggable: !1,
classes: "enyo-border-box",
style: "z-index:10;",
components: []
} ],
test: function() {},
showSearchReplacePopup: function() {
var e = this.$.panelFiles.getActive();
e.applyTextStyle("white-space", "pre"), e.unnaturalScrollToZero = "off";
var t = e.getCursorPosition();
this.$.searchReplacePopup.setCursorPos(t.start), this.$.searchReplacePopup.setSelectionLength(t.length), this.$.searchReplacePopup.setFile(e), this.$.searchReplacePopup.show();
},
handleSearchRequest: function(e, t) {
var n = this.$.panelFiles.getActive();
n.setCursorPosition(t.cursorPos, t.selectionLength), n.applyTextStyle("white-space", enyo.getCookie("_prefs_line-wrapping")), this.callSearchAndSelectProperly(t, n, _L("SearchReplacePopup", "SearchSuccess", t.searchStr));
},
handleReplaceRequest: function(e, t) {
var n = this.$.panelFiles.getActive();
n.setCursorPosition(t.cursorPos, t.selectionLength), n.applyTextStyle("white-space", enyo.getCookie("_prefs_line-wrapping")), this.callSearchAndSelectProperly(t, n);
var r = window.getSelection();
r.getRangeAt(0).toString().indexOf(t.searchStr) != -1 && (n.insertAtCursor(t.replaceStr), n.modifySelectionLoop(r, "extend", "backward", t.replaceStr.length), (new Banner).showBanner(_L("SearchReplacePopup", "ReplaceSuccess", [ t.searchStr, t.replaceStr ])));
},
callSearchAndSelectProperly: function(e, t, n) {
var r = t.searchAndSelect(e.searchStr, e.caseInsensitive);
r ? (t.insertAtCursor("", !0), typeof n == "string" && (new Banner).showBanner(n)) : (new Dialog).ask(_L("SearchReplacePopup", "SearchAgainFromStartQuestion", e.searchStr), function() {
t.moveCursorToStart();
var r = t.searchAndSelect(e.searchStr, e.caseInsensitive);
r == 0 ? (new Dialog).showMessage(_L("SearchReplacePopup", "NoOccurrenceFound", e.searchStr)) : (t.insertAtCursor("", !0), typeof n == "string" && (new Banner).showBanner(n));
}.bind(this), function() {}), this.unnaturalScrollToZero = -1;
},
handleReplaceAllRequest: function(e, t) {
var n = this.$.panelFiles.getActive();
n.replaceAll(t.searchStr, t.replaceStr, t.caseInsensitive), n.applyTextStyle("white-space", enyo.getCookie("_prefs_line-wrapping")), n.unnaturalScrollToZero = -1;
},
singleFileFunctionCmd: function(e) {
var t = this.$.panelFiles.getActive();
t.execCommand(e.cmd);
},
alert: function(e) {
(new Dialog).showMessage(e.text);
},
handleInsertCharAtCursor: function(e, t) {
var n = this.$.panelFiles.getActive();
n.insertAtCursor(t.chari, t.scrollToCursor);
},
gotoPreferences: function() {
this.doGotoWindowRequest({
name: "preferences"
});
},
about: function() {
this.doGotoWindowRequest({
name: "about"
});
},
gotoWebpage: function(e) {
window.open(e.url, "_blank");
},
toggleMenu: function() {
var e = this.$.menu;
e.show = !e.show;
if (!e.show) {
e.applyStyle("display", "none");
var t = this.$.panelFiles.getActive();
} else e.applyStyle("display", "block");
},
exitApp: function() {
window.close();
},
fileMenuTabSelect: function(e, t) {
this.$.panelFiles.setIndex(t.originator.fileIndex), this.$.fileMenuTabHead.setContent(t.originator.content);
},
showPopup: function(e) {
var t = this.$[e.popup];
t && t.show();
},
create: function(e) {
this.inherited(arguments), this.newFile(""), this.setBackgroundOfEditorPanel();
},
saveFile: function() {
var e = this.$.panelFiles.getActive(), t = e.getText();
this.$.fileIO.writeFile(e.getFilePath(), e.getFileName(), e.getFileExt(), [ t ], e.getFileMIME());
},
saveFileSilently: function() {
var e = this.$.panelFiles.getActive();
this.$.fileIO.overrideFile(e.getFilePath(), e.getFileName(), e.getFileExt(), [ e.getText() ], e.getFileMIME(), e.getStorageType());
},
saveAsFile: function() {
var e = this.$.panelFiles.getActive();
this.createComponent({
kind: "SaveAsPopup",
name: "saveAsPopup",
fileName: e.getFileName(),
fileExt: e.getFileExt(),
filePath: e.getFilePath(),
file: e
}, {
owner: this
}), this.showPopup({
popup: "saveAsPopup"
});
},
handleSaveAsFile: function(e, t) {
this.saveFile();
},
openFilePicker: function() {
this.createComponent({
kind: "FilePicker",
name: "filePickerPopup"
}), this.showPopup({
popup: "filePickerPopup"
});
},
readFile: function(e, t) {
var n = this.$.fileIO.readTextFile(t.path);
},
openFile: function(e, t) {
this.newFile(t.content, t.uri, t.storageType);
var n = enyo.getCookie("_prefs_backup_active"), r = enyo.getCookie("_prefs_backup_override");
if (n) {
var i = this.$.fileIO.divideUri(t.uri);
if (r == 0 || r == "false") {
var s = new Date;
i.fileName += "_" + s.toDateString() + "_" + s.getTime(), i.fileName = i.fileName.replace(/\s/g, "_"), i.fileName = i.fileName.replace(/":"/g, "_"), i.fileName = i.fileName.replace(/\//g, "_");
}
this.$.fileIO.overrideFile(".backups/editor/" + i.filePath, i.fileName, i.fileExt, [ t.content ], "text/plain", t.storageType);
}
},
newFile: function(e, t, n) {
if (e === undefined || typeof e == "object") e = "";
if (t === undefined || typeof t == "object") var r = {
kind: "Editor.File",
fileName: _L("Editor", "NameOfUntitledFiles"),
fileExt: "txt",
filePath: _L("Editor", "PathNameOfUntitledFiles"),
fileMIME: "text/plain",
content: e,
storageType: "sdcard"
}; else var i = this.$.fileIO.divideUri(t), r = {
kind: "Editor.File",
fileName: i.fileName,
fileExt: i.fileExt,
filePath: i.filePath,
fileMIME: "text/plain",
storageType: n,
content: e
};
var s = new Date, o = this.$.panelFiles.getPanels().length, u = this.$.fileIO.createFilename(r.fileName, r.fileExt), a = {
content: this.createTabName(this.$.fileMenuTab.getComponents().length - 1, u),
fileIndex: o,
classes: "one-line",
allowHtml: !0
}, f = this.$.panelFiles, l = f.createComponent(r), c = this.$.fileMenuTab.createComponent(a);
l.render(), c.render(), f.setIndex(o), this.$.fileMenuTabHead.setContent(a.content);
},
setStyleOfFile: function(e) {
e === undefined && (e = this.$.panelFiles.getActive()), e.reloadStyle();
},
setStyleOfAllFiles: function() {
var e = this.$.panelFiles.getPanels();
for (var t = 0; t < e.length; t++) this.setStyleOfFile(e[t]);
this.setBackgroundOfEditorPanel();
},
setBackgroundOfEditorPanel: function() {
enyo.getCookie("_prefs_font-bg-color") !== undefined && this.applyStyle("background-color", enyo.getCookie("_prefs_font-bg-color"));
},
handleRequestStyleUpdate: function(e, t) {
this.setStyleOfFile(t.instance);
},
createTabName: function(e, t, n) {
var r = "grey";
return n !== undefined && n == 1 && (r = "orange"), "<span style='color:" + r + "'>" + (e + 1) + ".</span> " + t;
},
handleWriteSuccess: function(e, t) {
this.refreshFileTab();
},
getMenuTabComponentByPanelIndex: function(e, t) {
for (var n = 0; n < e.length; n++) if (e[n].fileIndex == t) return {
component: e[n],
index: n
};
return {
component: e[e.length - 1],
index: e.length - 1
};
},
deleteFile: function(e) {
var t = this.$.panelFiles.getActive();
e == 1 ? (this.$.fileIO.deleteFile(this.$.fileIO.createStorageLocation(t.getFilePath(), t.getFileName(), t.getFileExt()), t.getStorageType()), this.closeFile()) : new ConfirmDialog({
message: _L("Editor", "DeleteFileQuestion"),
okCallback: function() {
this.deleteFile(!0);
}.bind(this),
cancelCallback: function() {}
});
},
handleDeleteSuccess: function(e, t) {
alert(t.message);
},
refreshFileTab: function(e) {
var t = this.$.panelFiles.getActive();
e ? t.setUnsaved(!0) : t.setUnsaved(!1);
var n = this.$.panelFiles.getIndex(), r = this.$.fileMenuTab.getComponents(), i = this.createTabName(n, this.$.fileIO.createFilename(t.getFileName(), t.getFileExt()), e), s = this.getMenuTabComponentByPanelIndex(r, n);
s.component.setContent(i), this.$.fileMenuTabHead.setContent(i);
},
closeFile: function(e, t, n) {
var r = this.$.panelFiles.getActive();
n === undefined && (n = !1);
if (r.getUnsaved() == 1 && n == 0) {
new ConfirmDialog({
message: _L("Editor", "FileUnsavedCloseAnywayQuestion"),
okCallback: function() {
this.closeFile("", "", !0);
}.bind(this),
cancelCallback: function() {}
});
return;
}
var i = this.$.panelFiles.getIndex(), s = this.$.fileMenuTab.getComponents(), o = this.getMenuTabComponentByPanelIndex(s, i);
o.component.destroy(), r.clean(), s.splice(o.index, 1);
var u = this.$.panelFiles.getComponents();
for (var a = o.index; a < s.length; a++) u[a + 1] !== undefined && s[a].setContent(this.createTabName(a - 1, this.$.fileIO.createFilename(u[a + 1].getFileName(), u[a + 1].getFileExt()), u[a + 1].getUnsaved()));
this.$.panelFiles.setIndex(0), this.refreshFileTab();
},
handleTextChange: function(e, t) {
this.refreshFileTab(!0), this.$.panelFiles.getActive().setUnsaved(!0);
},
handleWriteError: function(e, t) {
if (t.error == "NoModificationAllowedError") {
var n = function() {
var e = this.$.panelFiles.getActive(), t = e.getText();
this.$.fileIO.overrideFile(e.getFilePath(), e.getFileName(), e.getFileExt(), [ t ], e.getFileMIME());
}.bind(this);
new ConfirmDialog({
message: _L("Editor", "OverrideQuestion"),
okCallback: n,
cancelCallback: function() {}
});
} else alert(t.message);
},
handleStandardIOError: function(e, t) {
alert("Error: " + t.message);
}
});

// File.js

enyo.kind({
name: "Editor.File",
kind: "Scroller",
strategyKind: "ScrollStrategy",
style: "background-color:white;",
plainNewLineStr: "\r\n",
htmlNewLineStr: "<br>",
plainTabStr: "	",
htmlTabStr: "   ",
lastClickPosY: 0,
unnaturalScrollToZero: -1,
published: {
fileName: "",
fileExt: "txt",
filePath: "",
storageType: "sdcard",
fileMIME: "text/plain",
content: "",
unsaved: !1
},
events: {
onTextChange: "",
onRequestStyleUpdate: "",
onSaveFileRequest: ""
},
handlers: {
onclick: "handleOnClick"
},
components: [ {
name: "textField",
kind: "enyo.RichText",
classes: "editor-file-textarea editor-file-default-text-style",
allowHtml: !0,
defaultFocus: !0,
value: "",
oninput: "doTextChange",
onkeyup: "handleKeyUp",
onkeydown: "handleKeyDown",
onfocus: "gotFocus"
} ],
scroll: function(e, t) {
this.inherited(arguments);
if (this.unnaturalScrollToZero == "off") return;
this.preventUnnaturalScrollToZero();
},
preventUnnaturalScrollToZero: function() {
if (this.unnaturalScrollToZero == "off") return;
this.unnaturalScrollToZero != -1 && (this.lastClickPosY > 100 ? this.unnaturalScrollToZero += this.lastClickPosY - 100 : this.unnaturalScrollToZero -= 100 - this.lastClickPosY, this.setScrollTop(this.unnaturalScrollToZero)), this.unnaturalScrollToZero = -1;
},
handleOnClick: function(e, t) {
if (this.unnaturalScrollToZero == "off") return;
this.lastClickPosY = t.pageY;
},
gotFocus: function() {
if (this.unnaturalScrollToZero == "off") return;
this.getScrollTop() != 0 && (this.unnaturalScrollToZero = this.getScrollTop());
},
handleKeyDown: function(e, t) {
this.onNextKeyUp = undefined, this.pressedKey == 32 && t.keyCode == 8 ? this.onNextKeyUp = function() {
this.insertAtCursor(this.htmlTabStr + " ");
} : this.pressedKey == 83 && t.keyCode == 8 ? this.onNextKeyUp = function() {
this.doSaveFileRequest();
} : t.keyCode == 13 && this.$.textField.insertAtCursor("&zwnj;"), this.pressedKey = t.keyCode;
},
handleKeyUp: function(e, t) {
this.onNextKeyUp !== undefined && (this.onNextKeyUp(), this.onNextKeyUp = undefined), this.pressedKey = null;
},
clean: function() {
this.setFileName(_L("Editor", "NameOfUntitledFiles")), this.setFileExt("txt"), this.setFilePath(_L("Editor", "PathNameOfUntitledFiles")), this.setFileMIME("text/plain"), this.setContent(""), this.setText(""), this.setStorageType("sdcard"), this.setUnsaved(!1);
},
reloadStyle: function(e, t) {
var n = [ {
name: "font-family",
value: enyo.getCookie("_prefs_font-family")
}, {
name: "font-size",
value: enyo.getCookie("_prefs_font-size")
}, {
name: "font-weight",
value: enyo.getCookie("_prefs_font-weight")
}, {
name: "font-style",
value: enyo.getCookie("_prefs_font-italic")
}, {
name: "color",
value: enyo.getCookie("_prefs_font-color")
}, {
name: "white-space",
value: enyo.getCookie("_prefs_line-wrapping")
} ];
for (var r = 0; r < n.length; r++) n[r].value !== undefined && this.$.textField.applyStyle(n[r].name, n[r].value);
enyo.getCookie("_prefs_font-bg-color") !== undefined && this.applyStyle("background-color", enyo.getCookie("_prefs_font-bg-color"));
},
applyTextStyle: function(e, t) {
this.$.textField.applyStyle(e, t);
},
rendered: function(e) {
this.inherited(arguments), this.setText(this.getContent()), this.doRequestStyleUpdate({
instance: this
});
},
getHtmlNewLineStr: function() {
return this.htmlNewLineStr;
},
setText: function(e) {
if (e !== undefined) {
e = e.replace(/&/g, "&amp;"), e = e.replace(/</g, "&lt;"), e = e.replace(/>/g, "&gt;"), e = e.replace(/\"/g, "&quot;"), e = e.replace(/\'/g, "&apos;"), e.indexOf("\r\n") != -1 ? this.plainNewLineStr = "\r\n" : e.indexOf("\n") != -1 ? this.plainNewLineStr = "\n" : e.indexOf("\r") != -1 && (this.plainNewLineStr = "\r");
var t = new RegExp(this.plainNewLineStr, "g");
e = e.replace(t, this.htmlNewLineStr), t = new RegExp(this.plainTabStr, "g"), e = e.replace(t, this.htmlTabStr), this.setHtmlText(e);
}
},
getText: function() {
var e = this.getHtmlText(), t = new RegExp(this.htmlNewLineStr, "g");
return e = e.replace(t, this.plainNewLineStr), t = new RegExp(this.htmlTabStr, "g"), e = e.replace(t, this.plainTabStr), e = e.replace(/&lt;/g, "<"), e = e.replace(/&gt;/g, ">"), e = e.replace(/&quot;/g, '"'), e = e.replace(/&apos;/g, "'"), e = e.replace(/&amp;/g, "&"), e;
},
setHtmlText: function(e) {
e !== undefined && this.$.textField.setValue(e);
},
getHtmlText: function(e) {
return this.$.textField.getValue();
},
focus: function() {
return this.$.textField.node.focus();
},
scrollToCursor: function(e) {
e.modify("extend", "backward", "character"), e.modify("extend", "forward", "character");
},
insertAtCursor: function(e, t) {
this.focus();
var n = window.getSelection();
e != "" && (this.$.textField.insertAtCursor("_"), n.modify("extend", "backward", "character"), this.$.textField.insertAtCursor(e));
if (t) {
this.unnaturalScrollToZero = this.getScrollTop();
var r = this.getBounds().height, i = 0;
stcInterval !== undefined && (enyo.log(stcInterval + " were not closed properly" + typeof stcInterval), clearInterval(stcInterval)), stcInterval = setInterval(function(e, t) {
if (t > this.getBounds().height || i > 6) clearInterval(stcInterval), stcInterval = undefined, setTimeout(function(e) {
this.scrollToCursor(e);
}.bind(this), 100, e);
i++;
}.bind(this), 175, n, r);
}
},
execCommand: function(e, t, n) {
this.focus(), document.execCommand(e, t, n), (e == "redo" || e == "undo") && document.execCommand(e, t, n);
},
searchAndSelect: function(e, t) {
this.focus();
var n = window.getSelection();
n.collapseToEnd();
for (var r = 0; r <= this.getHtmlText().length; r++) {
n.modify("extend", "forward", "character");
if (this.search(n.toString(), e, t) != -1) return n.collapseToEnd(), this.modifySelectionLoop(n, "extend", "backward", e.length), !0;
}
return n.collapseToEnd(), !1;
},
replaceAll: function(e, t, n) {
var r = this.getText().split("searchStr");
if (n) var i = "ig"; else var i = "g";
var s = new RegExp(e, i), o = this.getText();
if (o.search(s) == -1) return (new Dialog).showMessage(_L("SearchReplacePopup", "NoOccurrenceFound", e)), !1;
this.insertAtCursor("&zwnj;"), this.setText(o.replace(s, t)), (new Dialog).showMessage(_L("SearchReplacePopup", "ReplaceAllSuccess", [ e, t ]));
},
search: function(e, t, n) {
return n ? e.search(new RegExp(t, "i")) : e.indexOf(t);
},
modifySelectionLoop: function(e, t, n, r) {
for (var i = 0; i < r; i++) e.modify(t, n, "character");
},
moveCursorToStart: function() {
this.focus(), window.getSelection().collapseToStart();
var e = this.getText().split(this.plainNewLineStr);
for (var t = 0; t <= e.length + 1; t++) this.$.textField.modifySelection("move", "backward", "line");
},
setCursorPosition: function(e, t, n) {
this.focus(), n && this.moveCursorToStart(), window.getSelection().collapseToStart();
for (var r = 0; r <= this.$.textField.getValue().length + 1; r++) {
this.$.textField.modifySelection("extend", "forward", "character");
if (window.getSelection().getRangeAt(0).toString().length == e) {
window.getSelection().collapseToEnd();
break;
}
}
if (t === undefined || t == 0) return;
for (var r = 0; r <= this.$.textField.getValue().length + 1; r++) {
this.$.textField.modifySelection("extend", "forward", "character");
if (window.getSelection().getRangeAt(0).toString().length == t) break;
}
},
getCursorPosition: function() {
this.focus();
var e = window.getSelection().getRangeAt(0).toString().length;
window.getSelection().collapseToStart();
var t = this.getText().split(this.plainNewLineStr);
for (var n = 0; n <= t.length + 1; n++) this.$.textField.modifySelection("extend", "backward", "lineboundary"), this.$.textField.modifySelection("extend", "backward", "character");
var r = window.getSelection().getRangeAt(0).toString().length;
return window.getSelection().collapseToStart(), {
start: r,
end: r + e,
length: e
};
}
}), stcInterval = undefined;

// SpecialCharPopup.js

enyo.kind({
name: "SpecialCharPopup",
kind: "onyx.Popup",
centered: !0,
floating: !0,
scrim: !0,
classes: "special-char-popup",
events: {
onInsertCharAtCursor: ""
},
components: [ {
kind: "Scroller",
classes: "enyo-fit",
components: [ {
kind: "onyx.Button",
content: "   ",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2022",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2026",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2794",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2798",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2799",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u279a",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u279b",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u279c",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u279d",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u279e",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u279f",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27a0",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27a1",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27a2",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27a3",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27a4",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27a5",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27a6",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27a7",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27a8",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27a9",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27aa",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27ab",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27ac",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27ad",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27ae",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27af",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27b1",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27b2",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27b3",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27b4",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27b5",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27b6",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27b7",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27b8",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27b9",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27ba",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27bb",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27bc",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27bd",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u27be",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u25ca",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2660",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2663",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2665",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2666",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2764",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2765",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2701",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2702",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2703",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2704",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2706",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2707",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2708",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2709",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u270c",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u270d",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u270e",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u270f",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2710",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2711",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2712",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2713",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2714",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2715",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2716",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2717",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2718",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2719",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u271a",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u271b",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u271c",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u271d",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u271e",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u271f",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2720",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2721",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2722",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2723",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2724",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2725",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2726",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2727",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2729",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u272a",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u272b",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u272c",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u272d",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u272e",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u272f",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2730",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2731",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2732",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2733",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2734",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2735",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2736",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2737",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2738",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2739",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u273a",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u273b",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u273c",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u273d",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u273e",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u273f",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2740",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2741",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2742",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2743",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2744",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2745",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2746",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2747",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2748",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2749",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u274a",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u274b",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2776",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2777",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2778",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2779",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u277a",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u277b",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u277c",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u277d",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u277e",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u277f",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2780",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2781",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2782",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2783",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2784",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2785",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2786",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2787",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2788",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2789",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u278a",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u278b",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u278c",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u278d",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u278e",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u278f",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2790",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2791",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2792",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2793",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u02c7",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u02d8",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0141",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00a4",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0104",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00a6",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00a7",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00a8",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00a9",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u015e",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00ab",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00ac",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00ad",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00ae",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u017b",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00b0",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00b1",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u02db",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0142",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00b4",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00b5",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00b6",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00b7",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00b8",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0105",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u015f",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00bb",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u013d",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u02dd",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u013e",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u017c",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0154",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00c1",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00c2",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0102",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00c4",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0139",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0106",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00c7",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u010c",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00c9",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0118",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00cb",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u011a",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00cd",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00ce",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u010e",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0110",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0143",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0147",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00d3",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00d4",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0150",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00d6",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00d7",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00c4\u00a7",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0158",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u016e",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00da",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0170",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00dc",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00dd",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0162",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00df",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0155",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00e1",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00e2",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0103",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00e4",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u013a",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0107",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00e7",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u010d",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00e9",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0119",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00eb",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u011b",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00ed",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00ee",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u010f",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0111",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0144",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0148",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00f3",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00f4",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0151",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00f6",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00f7",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0159",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u016f",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00fa",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0171",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00fc",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u00fd",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0163",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u02d9",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0192",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0391",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0392",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0393",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0394",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0395",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0396",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0397",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0398",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0399",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u039a",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u039b",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u039c",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u039d",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u039e",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u039f",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03a0",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03a1",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03a3",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03a4",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03a5",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03a6",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03a7",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03a8",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03a9",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03b1",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03b2",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03b3",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03b4",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03b5",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03b6",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03b7",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03b8",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03b9",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03ba",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03bb",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03bc",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03bd",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03be",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03bf",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03c0",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03c1",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03c2",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03c3",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03c4",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03c5",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03c6",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03c7",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03c8",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03c9",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03d1",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03d2",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u03d6",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2032",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2033",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u203e",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2044",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2118",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2111",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u211c",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2122",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2135",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2190",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2191",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2192",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2193",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2194",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u21b5",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u21d0",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u21d1",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u21d2",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u21d3",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u21d4",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2200",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2202",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2203",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2205",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2207",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2208",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2209",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u220b",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u220f",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2211",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2212",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2217",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u221a",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u221d",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u221e",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2220",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2227",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2228",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2229",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u222a",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u222b",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2234",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u223c",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2245",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2248",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2260",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2261",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2264",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2265",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2282",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2283",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2284",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2286",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2287",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2295",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2297",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u22a5",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u22c5",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2308",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2309",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u230a",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u230b",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2329",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u232a",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "&",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "<",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: ">",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0152",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0153",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0160",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0161",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u0178",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u02c6",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u02dc",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2002",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2003",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2009",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2013",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2014",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2018",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2019",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u201a",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u201c",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u201d",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u201e",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2020",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2021",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2030",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2039",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u203a",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u20ac",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u274d",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u274f",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2750",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2751",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2752",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2756",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2758",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2759",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u275a",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u275b",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u275c",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u275d",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u275e",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2761",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2762",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2763",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2766",
ontap: "insertChar",
classes: "special-char-button"
}, {
kind: "onyx.Button",
content: "\u2767",
ontap: "insertChar",
classes: "special-char-button"
} ]
} ],
create: function(e) {
this.inherited(arguments);
},
insertChar: function(e, t) {
this.hide(), this.doInsertCharAtCursor({
chari: e.content,
scrollToCursor: !0
});
}
});

// SearchReplacePopup.js

enyo.kind({
name: "SearchReplacePopup",
kind: "onyx.Popup",
centered: !0,
floating: !0,
scrim: !0,
style: "height:244px; width:260px;",
published: {
cursorPos: 0,
selectionLength: 0,
file: ""
},
events: {
onSearchRequest: "",
onReplaceRequest: "",
onReplaceAllRequest: ""
},
handlers: {
onShow: "handleOnShow",
onHide: "handleOnHide"
},
components: [ {
kind: "onyx.InputDecorator",
alwaysLooksFocused: !0,
style: "width:242px; height:18px;",
components: [ {
kind: "onyx.Input",
name: "searchStrInput",
placeholder: _L("SearchReplacePopup", "SearchLabel")
} ]
}, {
kind: "onyx.InputDecorator",
alwaysLooksFocused: !0,
style: "margin-top:4px; width:242px; height:18px;",
components: [ {
kind: "onyx.Input",
name: "replaceStrInput",
placeholder: _L("SearchReplacePopup", "ReplaceLabel")
} ]
}, {
style: "padding-top:8px; height:32px;",
components: [ {
kind: "onyx.Checkbox",
name: "caseInsensitive",
checked: !0,
style: "float:left;"
}, {
content: _L("SearchReplacePopup", "CaseInsensitiveLabel"),
style: "float:left; position:relative; left:8px; top:6px;"
} ]
}, {
kind: "onyx.Button",
fireEvent: "doSearchRequest",
content: _L("SearchReplacePopup", "FindNextLabel"),
style: "margin-top:18px; width:100%;",
ontap: "handleButton"
}, {
kind: "onyx.Button",
fireEvent: "doReplaceRequest",
content: _L("SearchReplacePopup", "ReplaceNextLabel"),
style: "margin-top:4px; width:100%;",
ontap: "handleButton"
}, {
kind: "onyx.Button",
fireEvent: "doReplaceAllRequest",
content: _L("SearchReplacePopup", "ReplaceAllLabel"),
style: "margin-top:4px; width:100%;",
ontap: "handleButton"
} ],
handleOnShow: function() {
this.$.searchStrInput.node.focus(), this.virgin = !0;
},
handleOnHide: function() {
this.virgin == 1 && (file.applyTextStyle("white-space", enyo.getCookie("_prefs_line-wrapping")), file.unnaturalScrollToZero = -1);
},
handleButton: function(e, t) {
this.$.searchStrInput.getValue() != "" ? (this.virgin = !1, this.hide(), this[e.fireEvent]({
searchStr: this.$.searchStrInput.getValue(),
replaceStr: this.$.replaceStrInput.getValue(),
caseInsensitive: this.$.caseInsensitive.getValue(),
cursorPos: this.getCursorPos(),
selectionLength: this.getSelectionLength()
})) : this.hide();
}
});

// About.js

enyo.kind({
name: "Editor.About",
kind: "FittableRows",
fit: !0,
style: "background-color: #E0E0E0;",
events: {
onBack: ""
},
components: [ {
kind: "onyx.Toolbar",
name: "menu",
show: !0,
classes: "menu-toolbar",
components: [ {
kind: "onyx.IconButton",
src: "assets/icons/back.png",
ontap: "goBack",
classes: "toolbar-back-button"
}, {
classes: "after-toolbar-back-button",
components: [ {
name: "head",
content: "About...",
style: "font-size:13pt; font-weight:bold;"
}, {
name: "subhead",
content: "...",
style: "font-size:8pt; color:orange;"
} ]
} ]
}, {
kind: "Scroller",
fit: !0,
components: [ {
style: "color:red; font-size:9pt; padding:8px;",
content: _L("About", "EULAinfo")
}, {
kind: "onyx.Button",
content: "OK",
ontap: "goBack",
style: "margin:8px; width:100px;"
}, {
kind: "onyx.Button",
content: _L("Editor", "ExitLabel"),
ontap: "exit",
style: "margin:8px; width:100px;"
}, {
kind: "onyx.Groupbox",
style: "padding:8px;",
components: [ {
kind: "onyx.GroupboxHeader",
content: _L("About", "GeneralInfoLabel")
}, {
style: "padding: 8px;",
content: _L("About", "ThanksText")
} ]
}, {
kind: "onyx.Groupbox",
style: "padding:8px;",
components: [ {
kind: "onyx.GroupboxHeader",
content: _L("About", "DevAndContactLabel")
}, {
style: "padding:8px;",
allowHtml: !0,
content: "Simon Pfundstein with support of Tamoggemon Holding k.s., 2013"
}, {
allowHtml: !0,
content: "<center><i>support discontinued</i></center>"
}, {
kind: "onyx.Button",
name: "mailButton",
content: _L("About", "EmailButton"),
ontap: "gotoWebpage",
url: "mailto:simpfu@tamoggemon.com",
style: "width:100%"
} ]
}, {
kind: "onyx.Groupbox",
style: "padding:8px;",
components: [ {
kind: "onyx.GroupboxHeader",
content: "END-USER LICENSE AGREEMENT"
}, {
content: "No EULA found. This is a mistake. Please contact the developer!",
name: "eulaText",
style: "padding: 8px;",
allowHtml: !0
} ]
}, {
kind: "onyx.Groupbox",
style: "padding:8px;",
components: [ {
kind: "onyx.GroupboxHeader",
content: "VERSION HISTORY"
}, {
style: "padding:8px;",
allowHtml: !0,
content: "<br>v.1.1.0:<br>\u2003\u2022 End of life notice<br>v.1.0.2:<br>\u2003\u2022 First full version<span style='color:grey;'><br>v.1.0.1:<br>\u2003\u2022 Minor changes regarding advertising<br>v.1.0.0:<br>\u2003\u2022 First final version.<br>v.0.0.9:<br>\u2003\u2022 Extended Beta Phase<br>v.0.0.8:<br>\u2003\u2022 Undo and redo function added<br>\u2003\u2022 Special characters picker added<br>\u2003\u2022 Search/replace function added<br>\u2003\u2022 BUG 'loss of scroller-position' fixed<br>v.0.0.7:<br>\u2003\u2022 Initial release </span>"
} ]
}, {
style: "font-size:8pt; color:grey; padding:8px;",
content: "SHOW COPYRIGHT INFORMATION >>",
ontap: "showCopyrightInfo"
}, {
style: "font-size:8pt; color:grey; padding:8px; display:none;",
allowHtml: !0,
name: "copyrightInfo",
content: "COPYRIGHT INFORMATION<br>This application is (C) Copyright Simon Pfundstein 2013.This application uses the following frameworks, components and media from independent developers:  \u2022 Enyo and related enyo libraries (http://enyojs.com), Apache 2.0 licensed;  \u2022 Icons from Icojam (Onebit and Blueberry), http://www.icojam.com/blog/?p=177, http://www.icojam.com/blog/?p=259;  \u2022 Edited ColorPicker component by MachiApps (http://enyojs.com/gallery/#MachiApps.ColorPicker), Copyright (c) 2012, MachiApps, license: 'Redistribution and use in source and binary forms, with or without modification, are permitted provided that  the following conditions are met:  Redistributions of source code must retain the above copyright notice, this list of conditions and the  following disclaimer. Redistributions in binary form must reproduce the above copyright notice, this list  of conditions and the following disclaimer in the documentation and/or other materials provided with the  distribution. THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY EXPRESS  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS  BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.';"
}, {
kind: "onyx.Button",
content: "OK",
ontap: "goBack",
style: "margin:8px; width:100px;"
}, {
kind: "onyx.Button",
content: _L("Editor", "ExitLabel"),
ontap: "exit",
style: "margin:8px; width:100px;"
} ]
}, {
name: "appInfo",
kind: "WebService",
url: "manifest.webapp",
callbackName: "callback",
onResponse: "appInfoSuccess"
}, {
name: "eula",
kind: "WebService",
url: "assets/eula.html",
onResponse: "eulaSuccess"
} ],
exit: function() {
window.close();
},
gotoWebpage: function(e) {
window.open(e.url, "_blank");
},
eulaSuccess: function(e, t) {
this.$.eulaText.setContent(t.data);
},
appInfoSuccess: function(e, t) {
var n = t.data;
this.$.head.setContent(n.name + " v." + n.version), this.$.subhead.setContent("\u2730 " + n.edition + " \u2730");
var r = _L("About", "Issue") + "\n\n\n\n\n_______\nApp: " + n.name + " v." + n.version + ", " + n.edition + "\nSystem: " + navigator.userAgent + "\nDisplay: " + screen.width + "x" + screen.height + "px, radio: " + window.devicePixelRatio + ".";
this.$.mailButton.url = "mailto:contact@tamoggemon.com?subject=" + n.name + " Support" + "&body=" + encodeURIComponent(r);
},
create: function(e) {
this.inherited(arguments), this.$.eula.send({
jsonp: !1
}), this.$.appInfo.send({
jsonp: !0
});
},
goBack: function() {
this.doBack();
},
showCopyrightInfo: function(e) {
e.hide(), this.$.copyrightInfo.applyStyle("display", "block");
}
});

// TextDisplay.js

enyo.kind({
name: "EditorPreferences.TextDisplay",
kind: "Scroller",
fit: !0,
events: {
onTextDisplayChange: ""
},
handlers: {
ontap: "handleAnyChange",
onSelect: "handleAnyChange"
},
components: [ {
kind: "onyx.Groupbox",
style: "max-width:480px;",
components: [ {
kind: "onyx.GroupboxHeader",
content: _L("EditorPrefs", "TextDisplayHeadLabel")
}, {
style: "padding: 8px;",
components: [ {
kind: "onyx.PickerDecorator",
style: "display:inline;",
onSelect: "handleFontTypeChange",
components: [ {
kind: "onyx.PickerButton",
content: "< FONT >",
style: "width:142px;",
classes: "one-line"
}, {
kind: "onyx.Picker",
name: "fontPicker",
components: []
} ]
}, {
kind: "onyx.PickerDecorator",
style: "display:inline;",
onSelect: "handleFontSizeChange",
components: [ {}, {
kind: "onyx.IntegerPicker",
name: "fontSizePicker",
min: 6,
max: 76,
value: 16
} ]
}, {
kind: "onyx.PickerButton",
name: "fontWeightToggler",
style: "height:42px;width:46px;",
content: "B",
value: "normal",
ontap: "toggleFontWeight"
}, {
kind: "onyx.PickerButton",
name: "fontItalicToggler",
style: "height:42px;width:46px;",
content: "i",
value: "normal",
ontap: "toggleFontItalic"
} ]
}, {
components: [ {
style: "left:10px; top:6px; display:inline; position:relative;",
content: _L("EditorPrefs", "ForegroundColor")
}, {
name: "foregroundColorPicker",
kind: "onyx.PickerButton",
popup: "foregroundColorPickerPopup",
ontap: "showPopup",
style: "background-color: black; margin:8px; height:42px; width:46px; position:relative; left:20px;"
} ]
}, {
components: [ {
style: "left:10px; top:6px; display:inline; position:relative;",
content: _L("EditorPrefs", "BackgroundColor")
}, {
name: "backgroundColorPicker",
kind: "onyx.PickerButton",
popup: "backgroundColorPickerPopup",
ontap: "showPopup",
style: "background-color: white; margin:8px; height:42px; width:46px; position:relative; left:20px;"
} ]
}, {
components: [ {
style: "left:10px; top:2px; display:inline; position:relative; margin-right:20px;",
content: _L("EditorPrefs", "WrappingLabel")
}, {
kind: "onyx.ToggleButton",
onChange: "toggleLineWrapping",
value: !0,
name: "lineWrappingToggler",
style: "margin:8px;"
} ]
}, {
name: "exampleText",
kind: "Editor.File",
style: "background-color:white; max-height:" + (window.innerHeight - 120) + "px",
content: _L("EditorPrefs", "ExampleText")
} ]
}, {
tag: "br"
}, {
kind: "ColorPickerPopup",
name: "foregroundColorPickerPopup",
onColorPicked: "handleForegroundColorPick"
}, {
kind: "ColorPickerPopup",
name: "backgroundColorPickerPopup",
onColorPicked: "handleBackgroundColorPick"
} ],
showPopup: function(e) {
var t = this.$[e.popup];
t && t.show();
},
rendered: function(e) {
this.inherited(arguments), this.setupWidgets();
},
setupWidgets: function() {
this.setupFontFamily(), this.setupFontSize(), this.setupFontWeight(), this.setupFontItalic(), this.setForegroundColor(), this.setBackgroundColor(), this.setLineWrappingToggler(), this.setStyleOfExampleText();
},
toggleLineWrapping: function(e, t) {
t.value ? enyo.setCookie("_prefs_line-wrapping", "pre-wrap") : enyo.setCookie("_prefs_line-wrapping", "pre"), this.doTextDisplayChange(), this.handleAnyChange();
},
setLineWrappingToggler: function() {
var e = enyo.getCookie("_prefs_line-wrapping");
e == "pre" ? this.$.lineWrappingToggler.setValue(!1) : this.$.lineWrappingToggler.setValue(!0);
},
handleBackgroundColorPick: function(e, t) {
if (t.color == undefined) return;
enyo.setCookie("_prefs_font-bg-color", t.color), this.setBackgroundColor();
},
setBackgroundColor: function() {
var e = enyo.getCookie("_prefs_font-bg-color");
e === undefined && (e = "white"), this.$.backgroundColorPicker.applyStyle("background-color", e), this.$.exampleText.applyStyle("background-color", e);
},
handleForegroundColorPick: function(e, t) {
if (t.color == undefined) return;
enyo.setCookie("_prefs_font-color", t.color), this.setForegroundColor();
},
setForegroundColor: function() {
var e = enyo.getCookie("_prefs_font-color");
e === undefined && (e = "black"), this.$.foregroundColorPicker.applyStyle("background-color", e);
},
toggleFontItalic: function(e, t) {
if (this.$.fontItalicToggler.value == "normal") var n = "italic"; else var n = "normal";
enyo.setCookie("_prefs_font-italic", n), this.setupFontItalic();
},
setupFontItalic: function() {
var e = enyo.getCookie("_prefs_font-italic");
e === undefined && (e = "normal"), this.$.fontItalicToggler.value = e, this.$.fontItalicToggler.applyStyle("font-style", e);
},
toggleFontWeight: function(e, t) {
if (this.$.fontWeightToggler.value == "normal") var n = "bold"; else var n = "normal";
enyo.setCookie("_prefs_font-weight", n), this.setupFontWeight();
},
setupFontWeight: function() {
var e = enyo.getCookie("_prefs_font-weight");
e === undefined && (e = "normal"), this.$.fontWeightToggler.value = e, this.$.fontWeightToggler.applyStyle("font-weight", e);
},
setupFontSize: function() {
var e = enyo.getCookie("_prefs_font-size");
e !== undefined && this.$.fontSizePicker.setValue(Number(e.replace("pt", "")));
},
setupFontFamily: function() {
var e = [], t = [ "Times New Roman", "Comic Sans MS", "Calibri", "Courier New", "Arial", "Verdana", "Georgia" ];
for (var n = 0; n < t.length; n++) e[n] = {
content: t[n],
name: '"' + t[n] + '"',
style: "font-family:'" + t[n] + "'",
active: this.isActiveFontType(t[n], "Times New Roman")
};
this.$.fontPicker.createComponents(e);
},
isActiveFontType: function(e, t) {
var n = enyo.getCookie("_prefs_font-family");
return n === undefined && t !== undefined && e == t ? !0 : n === undefined ? !1 : (n = n.replace(/\"/g, ""), n == e ? !0 : !1);
},
setStyleOfExampleText: function() {
var e = this.$.exampleText;
e.applyStyle("padding", "8px"), e.reloadStyle();
},
handleFontTypeChange: function(e, t) {
enyo.log('New fonty  family: "' + t.content + '"'), enyo.setCookie("_prefs_font-family", '"' + t.content + '"');
},
handleFontSizeChange: function(e, t) {
enyo.log("New font size: " + t.content + "pt"), enyo.setCookie("_prefs_font-size", t.content + "pt");
},
handleAnyChange: function(e, t) {
this.setStyleOfExampleText(), this.doTextDisplayChange();
}
});

// Backup.js

enyo.kind({
name: "EditorPreferences.Backup",
kind: "Scroller",
fit: !0,
components: [ {
kind: "onyx.Groupbox",
style: "max-width:480px;",
components: [ {
kind: "onyx.GroupboxHeader",
content: _L("EditorPrefs", "AutoBackupLabel")
}, {
style: "padding: 8px;",
content: _L("EditorPrefs", "AutoBackupInfoText")
}, {
components: [ {
style: "left:10px; top:2px; display:inline; position:relative; margin-right:20px;",
content: _L("EditorPrefs", "AutoBackupLabel")
}, {
kind: "onyx.ToggleButton",
onChange: "handleBackupActiveChange",
value: !1,
name: "backupActiveToggler",
style: "margin:8px;"
} ]
}, {
style: "padding:8px; height:32px;",
components: [ {
kind: "onyx.Checkbox",
name: "backupOverrideToggler",
onchange: "handleBackupOverrideChange",
checked: !0,
style: "display:inline; float:left; "
}, {
content: _L("EditorPrefs", "AutoBackupOverride"),
style: "display:inline; float:left; position:relative; left:8px; top:6px;"
} ]
}, {
kind: "onyx.Button",
content: _L("EditorPrefs", "AutoBackupClearLabel"),
ontap: "clearBackupFolder",
style: "width:100%"
} ]
}, {
kind: "FileIO",
name: "fileIO"
} ],
rendered: function(e) {
this.inherited(arguments), this.setupWidgets();
},
setupWidgets: function() {
this.setBackupActiveToggler(), this.setBackupOverrideToggler();
},
clearBackupFolder: function() {
new ConfirmDialog({
message: _L("EditorPrefs", "AutoBackupClearInfo"),
okCallback: function() {
this.$.fileIO.deleteFile(".backups/editor", "sdcard");
}.bind(this),
cancelCallback: function() {}
});
},
handleBackupActiveChange: function(e, t) {
enyo.setCookie("_prefs_backup_active", e.getValue());
},
handleBackupOverrideChange: function(e, t) {
enyo.setCookie("_prefs_backup_override", e.getValue());
},
setBackupOverrideToggler: function() {
var e = enyo.getCookie("_prefs_backup_override");
e === undefined || e == "true" ? this.$.backupOverrideToggler.setValue(!0) : this.$.backupOverrideToggler.setValue(!1);
},
setBackupActiveToggler: function() {
var e = enyo.getCookie("_prefs_backup_active");
e === undefined || e == "false" ? this.$.backupActiveToggler.setValue(!1) : this.$.backupActiveToggler.setValue(!0);
}
});

// Preferences.js

enyo.kind({
name: "Editor.Preferences",
kind: "FittableRows",
fit: !0,
style: "background-color: #E0E0E0;",
events: {
onBack: "",
onTextDisplayChange: ""
},
components: [ {
kind: "onyx.Toolbar",
name: "menu",
show: !0,
classes: "menu-toolbar",
components: [ {
kind: "onyx.IconButton",
src: "assets/icons/back.png",
ontap: "goBack",
classes: "toolbar-back-button"
}, {
kind: "onyx.MenuDecorator",
onSelect: "handlePrefsTabSelect",
classes: "after-toolbar-back-button",
maxHeight: 320,
components: [ {
name: "prefsTabTitle",
content: _L("EditorPrefs", "TextDisplayLabel"),
allowHtml: !0,
style: "padding-left:7px; padding-right:11px;"
}, {
kind: "onyx.Menu",
name: "prefsTabMenu",
classes: "menu-dropdown",
components: [ {
content: _L("EditorPrefs", "TextDisplayLabel")
}, {
content: _L("EditorPrefs", "AutoBackupLabel")
} ]
} ]
} ]
}, {
kind: "Panels",
name: "prefsPanels",
fit: !0,
realtimeFit: !0,
draggable: !1,
classes: "enyo-border-box",
style: "margin:6px;",
components: [ {
kind: "EditorPreferences.TextDisplay"
}, {
kind: "EditorPreferences.Backup"
} ]
} ],
handlePrefsTabSelect: function(e, t) {
this.$.prefsTabTitle.setContent(t.content);
switch (t.content) {
case _L("EditorPrefs", "TextDisplayLabel"):
this.$.prefsPanels.setIndex(0);
return;
case _L("EditorPrefs", "AutoBackupLabel"):
this.$.prefsPanels.setIndex(1);
return;
}
enyo.log("Preferences not found?");
},
create: function(e) {
this.inherited(arguments);
},
goBack: function() {
this.doBack();
}
});

// FileIO.js

enyo.kind({
name: "FileIO",
events: {
onReadSuccess: "",
onReadError: "",
onWriteSuccess: "",
onWriteError: "",
onDeleteSuccess: "",
onDeleteError: ""
},
create: function(e) {
this.inherited(arguments);
},
writeFile: function(e, t, n, r, i, s) {
if (t == "" || t == undefined || t == null) {
this.FileIO.doWriteError({
message: _L("FileIO", "FileWriteError"),
error: _L("FileIO", "InvalidFileName")
});
return;
}
var o = new Blob(r, {
type: i
});
s === undefined && (s = "sdcard");
var u = navigator.getDeviceStorage(s), a = u.addNamed(o, this.createStorageLocation(e, t, n));
a.FileIO = this, a.onsuccess = this.writeFileSuccess, a.onerror = this.writeFileError;
},
writeFileSuccess: function() {
enyo.log("writeFile success, result:  '" + this.result + "'"), this.FileIO.doWriteSuccess({
message: _L("FileIO", "FileWriteSuccess")
});
},
writeFileError: function() {
enyo.log("writeFile failure, error name: " + this.error.name), this.error.name == "NoModificationAllowedError" ? (enyo.log("A file with this name already exists"), this.FileIO.doWriteError({
message: _L("FileIO", "FileAlreadyExists"),
error: this.error.name
})) : this.error.name == "SecurityError" ? (enyo.log("SecurityError: The user must give the app permission to write files..."), this.FileIO.doWriteError({
message: _L("FileIO", "FilePermissionDenied"),
error: this.error.name
})) : this.FileIO.doWriteError({
message: _L("FileIO", "FileWriteError") + " " + this.error.name,
error: this.error.name
});
},
readTextFile: function(e, t) {
t === undefined && (t = "sdcard");
var n = navigator.getDeviceStorage(t), r = n.get(e);
r.FileIO = this, r.uri = e, r.storageType = t, r.onsuccess = this.readTextFileSuccess, r.onerror = this.readTextFileError;
},
readTextFileSuccess: function() {
var e = this.result, t = new FileReader;
t.readAsText(e), t.FileIOinstance = this.FileIO, t.uri = this.uri, t.storageType = this.storageType, t.onload = this.FileIO.readTextContentResult, t.onerror = this.FileIO.readTextContentResultFailure;
},
readTextContentResult: function(e) {
var t = e.target.result;
this.FileIOinstance.doReadSuccess({
message: _L("FileIO", "FileReadSuccess"),
content: t,
storageType: this.storageType,
uri: this.uri
});
},
readTextContentResultFailure: function(e) {
this.FileIO.doWriteError({
message: _L("FileIO", "FileReadFailure"),
error: e.error.name
});
},
readTextFileError: function() {
enyo.log("Failure to get the file. Error: " + this.error.name), this.error.name == "SecurityError" ? (enyo.log("SecurityError: The user must give the app permission to write files..."), this.FileIO.doWriteError({
message: _L("FileIO", "FilePermissionDenied"),
error: this.error.name
})) : this.error.name == "NotFoundError" ? (enyo.log("NotFoundError: This file does not exist: " + this.uri), this.FileIO.doWriteError({
message: _L("FileIO", "FileNotFound"),
error: this.error.name
})) : this.FileIO.doWriteError({
message: _L("FileIO", "FileReadFailure"),
error: this.error.name
});
},
deleteFile: function(e, t) {
t === undefined && (t = "sdcard");
var n = navigator.getDeviceStorage(t), r = n["delete"](e);
r.FileIO = this, r.uri = e, r.onsuccess = function() {
enyo.log("deviceStorage.delete() success. File:  '" + this.result + "'"), this.FileIO.doDeleteSuccess({
message: _L("FileIO", "FileDeleteSuccess")
});
}, r.onerror = function() {
enyo.log("deviceStorage.delete() failed, error: " + this.error.name), this.error.name == "SecurityError" ? (enyo.log("SecurityError: The user must give the app permission to write files..."), this.FileIO.doDeleteError({
message: _L("FileIO", "FilePermissionDenied"),
error: this.error.name
})) : this.error.name == "NotFoundError" ? (enyo.log("NotFoundError: This file does not exist: " + e), this.FileIO.doDeleteError({
message: _L("FileIO", "FileNotFound"),
error: this.error.name
})) : this.FileIO.doDeleteError({
message: _L("FileIO", "FileDeleteFailure") + " " + this.error.name,
error: this.error.name
});
};
},
createStorageLocation: function(e, t, n) {
return e + this.createFilename(t, n);
},
createFilename: function(e, t) {
var n = "";
return t == "" ? n = e : n = e + "." + t, n;
},
overrideFile: function(e, t, n, r, i, s) {
s === undefined && (s = "sdcard");
var o = navigator.getDeviceStorage(s), u = o["delete"](this.createStorageLocation(e, t, n)), a = {
path: e,
name: t,
ext: n,
cont: r,
type: i,
dS: s
};
u.para = a, u.FileIO = this, u.onsuccess = function() {
var e = this.para;
this.FileIO.writeFile(e.path, e.name, e.ext, e.cont, e.type, e.dS);
};
},
divideUri: function(e) {
var t = e.lastIndexOf("/"), n = e.lastIndexOf(".");
return n == -1 && (n = e.length), {
fileName: e.substring(t + 1, n),
fileExt: e.substring(n + 1, e.length),
filePath: e.substring(0, t + 1)
};
}
});

// FileSystemOperations.js

enyo.kind({
name: "FileSystemOperations",
events: {
onDirSuccess: "",
onDirError: ""
},
create: function(e) {
this.inherited(arguments);
},
dir: function(e, t) {
t === undefined && (t = "sdcard");
var n = navigator.getDeviceStorage(t), r = n.enumerate(e);
r.FSO = this, r.resultObjects = [], r.onsuccess = this.dirSuccess, r.onerror = this.dirError;
},
dirSuccess: function() {
var e = this.result;
if (e == null) {
this.FSO.doDirSuccess({
resultObjects: this.resultObjects
});
return;
}
this.resultObjects[this.resultObjects.length] = e, this.continue();
},
dirError: function() {
enyo.log("dir error, name: " + this.error.name), this.FSO.doDirSuccess({
error: this.error.name
}), this.FSO.checkIfSecurityError(this.error.name);
},
checkIfSecurityError: function(e) {
e == "SecurityError" && alert("Error: Permission denied.");
}
});

// FolderPicker.js

enyo.kind({
name: "FolderPicker",
kind: "onyx.Popup",
centered: !0,
floating: !0,
scrim: !0,
classes: "folderpicker-popup",
selectedNode: undefined,
showFiles: !0,
published: {
showFiles: !1
},
handlers: {
onHide: "onHide",
onCallForHide: "hidePopup"
},
events: {
onFolderPick: "",
onFilePick: ""
},
components: [ {
name: "header",
style: "font-weight:bold; display:inline;"
}, {
kind: "CompactLineMenu",
onButtonTap: "doCallback",
componentsList: [ {
kind: "onyx.IconButton",
src: "assets/icons/exit.png",
style: "float:right;",
callback: "hidePopup"
}, {
kind: "onyx.IconButton",
src: "assets/icons/refresh.png",
style: "float:right;",
callback: "refresh"
} ]
}, {
classes: "enyo-fit",
style: "margin-top:32px; margin-bottom:52px;",
components: [ {
name: "spaceForTrees",
classes: "enyo-fit"
} ]
}, {
style: "position:absolute; right:6px; bottom:6px; display:inline;",
components: [ {
kind: "onyx.Button",
content: "OK",
classes: "onyx-affirmative filepicker-popup-button",
ontap: "pickTap"
} ]
} ],
doCallback: function(e, t) {
enyo.log(t.callback), this[t.callback]();
},
create: function(e) {
this.inherited(arguments), this.getShowFiles() == 1 ? this.$.header.setContent(_L("FilePicker", "FilePickerLabel")) : this.$.header.setContent(_L("FilePicker", "FolderPickerLabel")), this.$.spaceForTrees.createComponent({
kind: "Trees",
name: "trees",
showFiles: this.getShowFiles()
}, {
owner: this
}), this.render();
},
refresh: function() {
this.$.trees.refresh();
},
pickTap: function() {
this.$.trees.pickTap();
},
hidePopup: function() {
this.hide();
},
onHide: function() {
this.destroy();
}
});

// SaveAsPopup.js

enyo.kind({
name: "SaveAsPopup",
kind: "onyx.Popup",
centered: !0,
floating: !0,
scrim: !0,
classes: "folderpicker-popup",
selectedNode: undefined,
showFiles: !0,
published: {
showFiles: !0,
fileName: "",
fileExt: "",
filePath: "",
file: {}
},
handlers: {
onHide: "onHide",
onCallForHide: "hidePopup",
onSelect: "handleNodeSelect",
onTreesReady: "navigateToFolder"
},
events: {
onSaveAsFile: ""
},
components: [ {
name: "header",
style: "font-weight:bold; display:inline;"
}, {
kind: "CompactLineMenu",
onButtonTap: "doCallback",
componentsList: [ {
kind: "onyx.IconButton",
src: "assets/icons/exit.png",
style: "float:right;",
callback: "hidePopup"
}, {
kind: "onyx.IconButton",
src: "assets/icons/info.png",
style: "float:right;",
callback: "info"
}, {
kind: "onyx.IconButton",
src: "assets/icons/refresh.png",
style: "float:right;",
callback: "refresh"
} ]
}, {
style: "margin-top:18px; width:100%;",
components: [ {
kind: "onyx.InputDecorator",
alwaysLooksFocused: !0,
style: "height:18px; width:71%; margin-right:2px;",
components: [ {
kind: "onyx.Input",
placeholder: _L("SaveAsPopup", "FileNameLabel"),
style: "width: 100%;",
name: "fileNameField"
} ]
}, {
kind: "onyx.InputDecorator",
alwaysLooksFocused: !0,
style: "height:18px; width:15%; min-width: 38px; max-width: 80px;",
components: [ {
kind: "onyx.Input",
placeholder: "Type",
style: "width: 100%;",
name: "fileExtField"
} ]
} ]
}, {
classes: "enyo-fit",
style: "margin-top:80px; margin-bottom:52px;",
components: [ {
name: "spaceForTrees",
classes: "enyo-fit"
} ]
}, {
style: "position:absolute; right:6px; bottom:6px; display:inline;",
components: [ {
kind: "onyx.IconButton",
src: "assets/icons/addFolder.png",
style: "margin-right:12px;",
ontap: "addNode"
}, {
kind: "onyx.Button",
content: "OK",
classes: "onyx-affirmative filepicker-popup-button",
ontap: "pickTap"
} ]
} ],
doCallback: function(e, t) {
enyo.log(t.callback), this[t.callback]();
},
create: function(e) {
this.inherited(arguments), this.$.header.setContent(_L("Editor", "SaveFileAsLabel")), this.$.spaceForTrees.createComponent({
kind: "Trees",
name: "trees",
showFiles: this.getShowFiles()
}, {
owner: this
}), this.$.spaceForTrees.render(), this.$.fileNameField.setValue(this.getFileName()), this.$.fileExtField.setValue(this.getFileExt());
},
info: function() {
alert(_L("FilePicker", "OnlyNotEmptyFoldersInfo"));
},
navigateToFolder: function() {
try {
var e = this.getFile().getStorageType(), t = this.$.trees.getComponents(), n = undefined;
for (var r = 0; r < t.length; r++) if (typeof t[r].getStorageType == "function" && t[r].getStorageType() == e) {
n = t[r];
break;
}
var i = n.getTreeComponents();
this.navigateAFolderDeeper(i, this.getFile().getFilePath());
} catch (s) {
enyo.log("Try to navigate to files path; exception: " + s);
}
},
navigateAFolderDeeper: function(e, t) {
for (var n = 0; n < e.length; n++) {
var r = t.indexOf("/") + 1, i = t.substring(0, r);
enyo.log(i);
if (e[n].content == i) {
e[n].tap();
var s = e[n].components;
if (s !== undefined) {
t = t.replace(i, "");
if (t == "") return;
this.navigateAFolderDeeper(s, t);
}
break;
}
}
},
addNode: function() {
this.$.trees.addNode();
},
refresh: function() {
this.$.trees.refresh();
},
handleNodeSelect: function(e, t) {
if (t.nodeContent == undefined) return;
if (!t.nodeContent.folder) {
var n = t.nodeContent, r = n.name.lastIndexOf(".");
r == -1 && (r = n.name.length);
var i = n.name.substring(0, r), s = n.name.substring(r, n.name.length);
this.$.fileNameField.setValue(i), this.$.fileExtField.setValue(s);
}
},
pickTap: function() {
if (this.$.fileNameField.getValue() == "") {
alert(_L("FileIO", "InvalidFileName"));
return;
}
var e = this.getFile(), t = this.$.trees.getSelectedNode();
if (t !== undefined) {
var n = t.path.lastIndexOf("/") + 1;
t.folder || (t.path = t.path.substring(0, n)), n == 0 && (t.path = ""), e.setFilePath(t.path);
}
e.setFileName(this.$.fileNameField.getValue()), e.setFileExt(this.$.fileExtField.getValue().replace(".", "")), this.doSaveAsFile(), this.hide();
},
hidePopup: function() {
this.hide();
},
onHide: function() {
this.destroy();
}
});

// FilePicker.js

enyo.kind({
name: "FilePicker",
kind: "FolderPicker",
showFiles: !0,
events: {
onFilePick: ""
}
});

// Trees.js

enyo.kind({
name: "Trees",
selectedNode: undefined,
kind: "Scroller",
style: "height: 100%; width:100%; margin-bottom:10px; margin-top:10px;",
published: {
showFiles: !1
},
handlers: {
onSelect: "setSelectedNode",
onTreeReady: "checkTreesReady"
},
events: {
onFolderPick: "",
onFilePick: "",
onCallForHide: "",
onSelect: "",
onTreesReady: ""
},
checkTreesReady: function() {
this.doTreesReady();
},
create: function(e) {
this.inherited(arguments), this.createComponents([ {
kind: "TreeNode",
name: "tree",
storageType: "sdcard",
showFiles: this.getShowFiles()
} ]), this.render();
},
setSelectedNode: function(e, t) {
t.nodeContent !== undefined && (this.selectedNode = t.nodeContent);
},
getSelectedNode: function() {
return this.selectedNode;
},
addNode: function() {
var e = prompt(_L("FilePicker", "NewFolderPrompt"), _L("FilePicker", "NewFolderLabel")) + "/", t = this.getComponents();
for (var n = 0; n < t.length; n++) if (t[n].storageType == this.selectedNode.storage) {
var r = this.selectedNode, i = t[n].addFolder({
path: r.path,
icon: "assets/tree/folder.png",
content: e,
expandable: !0,
expanded: !1,
components: []
});
i.tap();
return;
}
},
refresh: function() {
var e = this.getComponents();
for (var t = 0; t < e.length; t++) e[t] == "TreeNode" && e[t].refresh();
},
pickTap: function() {
var e = this.selectedNode;
if (e === undefined) {
enyo.log("No node selected or error");
return;
}
if (this.getShowFiles() == 0) {
this.doFolderPick(e), this.doCallForHide();
return;
}
e.folder ? alert(_L("FilePicker", "PickedAFolder")) : (this.doFilePick(e), this.doCallForHide());
}
});

// TreeNode.js

enyo.kind({
name: "TreeNode",
published: {
selected: "",
storageType: "",
showFiles: !0,
allFiles: []
},
events: {
onSelect: "",
onTreeReady: ""
},
handlers: {
onTreeReady: "handleTreeIsReady"
},
components: [ {
kind: "FileSystemOperations",
name: "FOS",
onDirSuccess: "dirSuccess",
onDirError: "dirError"
}, {
kind: "Selection",
onSelect: "select",
onDeselect: "deselect"
}, {
name: "tree",
style: "width:200px",
kind: "Node",
path: "",
isRoot: !0,
icon: "assets/tree/folder-open.png",
content: "Please wait...",
expandable: !0,
expanded: !0,
onNodeTap: "nodeTap"
} ],
getTreeComponents: function(e) {
return this.$.tree.getComponents();
},
addFolder: function(e) {
var t = this.getSelected(), n = t.createComponent(e);
return t.render(), n;
},
create: function(e) {
this.inherited(arguments), this.$.FOS.dir("", this.getStorageType());
},
handleTreeIsReady: function() {
this.$.tree.setContent(this.getStorageType());
},
refresh: function() {
this.$.tree.components = [], this.$.tree.render(), this.$.FOS.dir("", this.getStorageType());
},
dirSuccess: function(e, t) {
this.setAllFiles(t.resultObjects), this.$.tree.addNodes(this.getNodes("", !0)), this.doTreeReady();
},
dirError: function(e, t) {
alert(t.error);
},
getNodes: function(e, t) {
var n = [], r = [], i = this.getAllFiles();
if (i === undefined) return enyo.log("No files found in '" + e + "'"), !1;
var s = "?";
for (var o = 0; o <= i.length - 1; o++) {
e != "" ? i[o].name.indexOf(e) != -1 ? r[o] = {
name: i[o].name.replace(e, ""),
size: i[o].size,
type: i[o].type,
lastModifiedDate: i[o].lastModifiedDate
} : r[o] = "" : r = i;
if (r[o] !== undefined && r[o] != "") if (r[o].name.indexOf("/") == -1) this.getShowFiles() == 1 && (n[n.length] = {
path: e,
icon: "assets/tree/file.png",
content: r[o].name
}); else {
var u = r[o].name.substring(0, r[o].name.indexOf("/") + 1);
if (s != u) {
s = u;
var a = [];
t !== undefined ? t && (a = this.getNodes(e + u, !1)) : t, n[n.length] = {
path: e,
icon: "assets/tree/folder.png",
content: u,
expandable: !0,
expanded: !1,
lazyLoaded: t,
components: a
};
}
}
}
return n;
},
nodeTap: function(e, t) {
var n = t.originator;
this.$.selection.select(n.id, n), n.components !== undefined && n.setIcon("assets/tree/" + (n.expanded ? "folder-open.png" : "folder.png")), enyo.log("Node tap: " + n.content + ", " + n.path);
if (n.lazyLoaded !== undefined && !n.lazyLoaded) {
n.lazyLoaded = !0, n.createComponents(this.getNodes(n.path + n.content, !0)), n.render();
return;
}
},
select: function(e, t) {
this.setSelected(t.data), t.data.$.caption.applyStyle("background-color", "rgba(0,0,0,0.4)");
var n = this.$.tree.getBounds().width;
n += 25, this.$.tree.applyStyle("width", n + "px"), this.doSelect({
nodeContent: this.getNodeContent()
});
},
deselect: function(e, t) {
t.data.$.caption !== undefined && t.data.$.caption.applyStyle("background-color", null);
},
getNodeContent: function() {
var e = function() {
return this.getSelected().expandable === undefined ? !1 : this.getSelected().expandable;
}.bind(this), t = {
storage: this.getStorageType(),
path: this.getSelected().path + this.getSelected().content,
folder: e(),
name: this.getSelected().content,
root: this.getSelected().path == "" && this.getSelected().content == "sdcard"
};
return enyo.log("Node content: " + JSON.stringify(t)), t;
}
});

// ColorPicker.js

enyo.kind({
name: "DefaultColorsBox",
published: {
color: ""
},
events: {
onSelect: ""
},
components: [ {
classes: "onyx-groupbox",
ontap: "colorTapped",
components: [ {
name: "colorBox",
style: "height: 24px; border: 1px solid Black; margin: 5px;"
} ]
} ],
create: function() {
this.inherited(arguments), this.colorChanged();
},
setColor: function(e) {
this.color = e, this.colorChanged();
},
colorChanged: function() {
this.$.colorBox.applyStyle("background-color", "#" + this.color);
},
colorTapped: function() {
this.bubble("onSelect", {
color: this.color
});
}
}), enyo.kind({
name: "DefaultColorsBoxes",
components: [ {
kind: "FittableColumns",
components: [ {
style: "width: 5%;"
}, {
kind: "FittableRows",
style: "width: 10%;",
defaultKind: "DefaultColorsBox",
components: [ {
color: "000000"
}, {
color: "222222"
}, {
color: "444444"
}, {
color: "666666"
}, {
color: "888888"
}, {
color: "AAAAAA"
}, {
color: "CCCCCC"
}, {
color: "FFFFFF"
} ]
}, {
kind: "FittableRows",
style: "width: 10%;",
defaultKind: "DefaultColorsBox",
components: [ {
color: "220000"
}, {
color: "440000"
}, {
color: "880000"
}, {
color: "BB0000"
}, {
color: "FF0000"
}, {
color: "FE2E2E"
}, {
color: "F78181"
}, {
color: "F6CECE"
} ]
}, {
kind: "FittableRows",
style: "width: 10%;",
defaultKind: "DefaultColorsBox",
components: [ {
color: "002200"
}, {
color: "004400"
}, {
color: "008800"
}, {
color: "00BB00"
}, {
color: "00FF00"
}, {
color: "2EFF2E"
}, {
color: "81FF81"
}, {
color: "CEF6CE"
} ]
}, {
kind: "FittableRows",
style: "width: 10%;",
defaultKind: "DefaultColorsBox",
components: [ {
color: "000022"
}, {
color: "000044"
}, {
color: "000088"
}, {
color: "0000BB"
}, {
color: "0000FF"
}, {
color: "2E2EFF"
}, {
color: "8181FF"
}, {
color: "CECEF6"
} ]
}, {
kind: "FittableRows",
style: "width: 10%;",
defaultKind: "DefaultColorsBox",
components: [ {
color: "220022"
}, {
color: "440044"
}, {
color: "880088"
}, {
color: "BB00BB"
}, {
color: "FF00FF"
}, {
color: "FF2EFF"
}, {
color: "FF81FF"
}, {
color: "F6CEF6"
} ]
}, {
kind: "FittableRows",
style: "width: 10%;",
defaultKind: "DefaultColorsBox",
components: [ {
color: "002222"
}, {
color: "004444"
}, {
color: "008888"
}, {
color: "00BBBB"
}, {
color: "00FFFF"
}, {
color: "2EFFFF"
}, {
color: "81FFFF"
}, {
color: "CEF6F6"
} ]
}, {
kind: "FittableRows",
style: "width: 10%;",
defaultKind: "DefaultColorsBox",
components: [ {
color: "222200"
}, {
color: "444400"
}, {
color: "888800"
}, {
color: "BBBB00"
}, {
color: "FFFF00"
}, {
color: "FFFF2E"
}, {
color: "FFFF81"
}, {
color: "F6F6CE"
} ]
}, {
kind: "FittableRows",
style: "width: 10%;",
defaultKind: "DefaultColorsBox",
components: [ {
color: "3B240B"
}, {
color: "61380B"
}, {
color: "B45F04"
}, {
color: "FF8000"
}, {
color: "FE9A2E"
}, {
color: "FAAC58"
}, {
color: "F7BE81"
}, {
color: "F5D0A9"
} ]
}, {
kind: "FittableRows",
style: "width: 10%;",
defaultKind: "DefaultColorsBox",
components: [ {
color: "3B0B17"
}, {
color: "610B21"
}, {
color: "8A0829"
}, {
color: "DF013A"
}, {
color: "FF0040"
}, {
color: "FA5882"
}, {
color: "F7819F"
}, {
color: "F5A9BC"
} ]
}, {
style: "width: 5%;"
} ]
} ]
}), enyo.kind({
name: "ColorPicker",
kind: "Control",
published: {
red: "A0",
blue: "A0",
green: "A0",
color: ""
},
events: {
onColorPick: "",
onColorSlide: "",
onHideCommand: ""
},
handlers: {
onSelect: "colorTapped"
},
components: [ {
kind: "DefaultColorsBoxes"
}, {
kind: "onyx.Slider",
name: "redSlider",
barClasses: "red-progress-bar",
onChanging: "redSliding",
onChange: "redChanged",
style: "vertical-align:middle; height:10px;"
}, {
style: "height: 10px"
}, {
kind: "onyx.Slider",
name: "greenSlider",
barClasses: "green-progress-bar",
onChanging: "greenSliding",
onChange: "greenChanged",
style: "vertical-align:middle; height:10px;"
}, {
style: "height: 10px"
}, {
kind: "onyx.Slider",
name: "blueSlider",
barClasses: "blue-progress-bar",
onChanging: "blueSliding",
onChange: "blueChanged",
style: "vertical-align:middle; height:10px;"
}, {
style: "height: 5px"
}, {
classes: "onyx-groupbox",
style: "background-color:red;",
components: [ {
name: "colorBox",
ontap: "bubbleOk",
style: "border: 3px solid Black; margin-top:7px; margin-right:16px; float:right; width: 120px; text-align: center; text-shadow: 0px 0px 7px rgba(0, 0, 0, 1); padding-top:7px; padding-bottom:7px;",
content: "OK"
} ]
} ],
create: function() {
this.inherited(arguments), this.updateColor(), this.updateProgresses();
},
bubbleOk: function() {
this.mainColorPicked(), this.doHideCommand();
},
colorTapped: function(e, t) {
return this.red = t.color.substr(0, 2), this.green = t.color.substr(2, 2), this.blue = t.color.substr(4, 2), this.updateProgresses(), this.updateColor(), this.doColorPick(), !0;
},
updateProgresses: function() {
var e = Math.floor(parseInt(this.red, 16) * 100 / 255), t = Math.floor(parseInt(this.blue, 16) * 100 / 255), n = Math.floor(parseInt(this.green, 16) * 100 / 255);
this.$.redSlider.setValue(e), this.$.greenSlider.setValue(n), this.$.blueSlider.setValue(t);
},
mainColorPicked: function() {
color = this.color, console.log("color picked: " + this.color), this.doColorPick();
},
updateColor: function() {
var e = "#" + (this.red + this.green + this.blue).toUpperCase();
this.$.colorBox.applyStyle("background-color", e), this.color = e;
},
redChanged: function(e, t) {
var n = Math.floor(t.value * 255 / 100), r = n.toString(16);
r.length == 1 && (r = "0" + r), this.red = r, this.updateColor();
},
greenChanged: function(e, t) {
var n = Math.floor(t.value * 255 / 100), r = n.toString(16);
r.length == 1 && (r = "0" + r), this.green = r, this.updateColor();
},
blueChanged: function(e, t) {
var n = Math.floor(t.value * 255 / 100), r = n.toString(16);
r.length == 1 && (r = "0" + r), this.blue = r, this.updateColor();
},
redSliding: function(e, t) {
var n = Math.floor(t.value * 255 / 100), r = n.toString(16);
r.length == 1 && (r = "0" + r), this.red = r, this.updateColor(), this.doColorSlide();
},
greenSliding: function(e, t) {
var n = Math.floor(t.value * 255 / 100), r = n.toString(16);
r.length == 1 && (r = "0" + r), this.green = r, this.updateColor(), this.doColorSlide();
},
blueSliding: function(e, t) {
var n = Math.floor(t.value * 255 / 100), r = n.toString(16);
r.length == 1 && (r = "0" + r), this.blue = r, this.updateColor(), this.doColorSlide();
}
});

// ColorPickerPopup.js

enyo.kind({
name: "ColorPickerPopup",
kind: "onyx.Popup",
centered: !0,
floating: !0,
scrim: !0,
color: undefined,
classes: "colorpicker-popup",
handlers: {
onHide: "onHide",
onColorPick: "colorChange",
onHideCommand: "hidePopup"
},
events: {
onColorPicked: ""
},
components: [ {
name: "scroller",
kind: "Scroller",
style: "height:100%; width:100%; margin-bottom:6px;",
components: [ {
kind: "ColorPicker",
name: "colorPicker"
} ]
} ],
create: function(e) {
this.inherited(arguments);
},
hidePopup: function() {
this.hide();
},
colorChange: function(e, t) {
enyo.log("Bubble color up: " + this.$.colorPicker.getColor()), this.doColorPicked({
color: this.$.colorPicker.getColor()
});
}
});

// EditorApp.js

enyo.kind({
kind: "Panels",
name: "EditorApp",
fit: !0,
realtimeFit: !0,
draggable: !1,
animate: !1,
classes: "enyo-border-box",
previousPanel: [ "Editor" ],
handlers: {
onGotoWindowRequest: "gotoPanel",
onBack: "goBack",
onTextDisplayChange: "handleTextDisplayChange"
},
components: [ {
kind: "Editor",
name: "editor"
}, {
kind: "Editor.Preferences"
}, {
kind: "Editor.About"
}, {
kind: "VersionInfo",
name: "versionInfo"
} ],
gotoPanel: function(e, t) {
var n = 0;
switch (t.name) {
case "editor":
n = 0;
break;
case "preferences":
n = 1;
break;
case "about":
n = 2;
break;
case "versionInfo":
n = 3;
}
this.previousPanel[this.previousPanel.length] = this.index, this.setIndex(n);
},
goBack: function() {
enyo.log("Go back...");
var e = this.previousPanel.length - 1;
this.setIndex(this.previousPanel[e]), this.previousPanel.length = e;
},
handleTextDisplayChange: function() {
enyo.log("handle event: style change..."), this.$.editor.setStyleOfAllFiles();
},
rendered: function(e) {
this.inherited(arguments);
var t = enyo.getCookie("_first_use");
t === undefined ? (enyo.setCookie("_first_use", !1), this.gotoPanel("", {
name: "about"
})) : this.setIndex(0);
}
});

// CompactLineMenu.js

enyo.kind({
name: "CompactLineMenu",
style: "position: absolute; top: 2px; height: 32px; min-width: 32px; right: 2px;",
events: {
onButtonTap: ""
},
published: {
exit: !1
},
create: function(e) {
this.inherited(arguments), this.setUp();
},
setUp: function() {
var e = this.componentsList;
if (e === undefined) return;
for (var t = 0; t < e.length; t++) e[t].ontap = "callForButtonTap", e[t].style += "margin-right:4px;", this.createComponent(e[t]);
this.render();
},
callForButtonTap: function(e) {
this.doButtonTap({
callback: e.callback
});
}
});

// Dialogs.js

enyo.kind({
name: "Dialog",
kind: "onyx.Popup",
centered: !0,
floating: !0,
scrim: !0,
style: "max-height:128px; min-height:20px; width:260px;",
okCallbackFunc: function() {},
cancelCallbackFunc: function() {},
components: [ {
kind: "Scroller",
maxHeight: "86px",
style: "margin-bottom: 48px;",
components: [ {
content: "",
name: "msg",
allowHtml: !0,
style: "font-size:14pt;padding-right:8px;"
} ]
}, {
kind: "onyx.Button",
content: "Cancel",
name: "cancelButton",
style: "position:absolute;bottom:8px;width:125px;",
ontap: "cancel"
}, {
kind: "onyx.Button",
content: "OK",
name: "okButton",
style: "position:absolute;bottom:8px;right:6px;width:125px;",
ontap: "ok"
} ],
showMessage: function(e, t) {
this.show(), this.$.cancelButton.hide(), this.$.msg.setContent(e), t && (this.okCallbackFunc = t);
},
ask: function(e, t, n) {
this.show(), this.$.msg.setContent(e), this.okCallbackFunc = t, this.cancelCallbackFunc = n;
},
cancel: function() {
this.hide(), this.cancelCallbackFunc(), this.destroy();
},
ok: function() {
this.hide(), this.okCallbackFunc(), this.destroy();
}
}), enyo.kind({
name: "Banner",
kind: "onyx.Popup",
centered: !0,
floating: !0,
style: "max-height:128px; min-height:20px; width:260px;",
okCallbackFunc: function() {},
cancelCallbackFunc: function() {},
components: [ {
kind: "Scroller",
maxHeight: "120px",
components: [ {
content: "",
name: "msg",
allowHtml: !0,
style: "font-size:14pt;padding-right:8px;"
} ]
} ],
showBanner: function(e) {
this.show(), this.$.msg.setContent(e), setTimeout(function() {
this.hide(), this.destroy();
}.bind(this), 3e3);
}
}), enyo.kind({
name: "ConfirmDialog",
published: {
message: "",
okCallback: "",
cancelCallback: ""
},
create: function(e) {
var t = confirm(this.getMessage());
t == 1 ? this.getOkCallback()() : this.getCancelCallback()();
}
});

// App.js

function requestPOST(e, t, n, r) {
var i;
window.XMLHttpRequest ? i = new XMLHttpRequest : i = new ActiveXObject("Microsoft.XMLHTTP"), i.open("POST", e, !0), i.setRequestHeader("Content-type", t), i.send(n), i.onreadystatechange = function() {
console.log("readyState: " + i.readyState + ", HTTP Status: " + i.status), i.readyState == 4 && i.status == 200 && r !== undefined && r(i.responseText);
};
}

enyo.kind({
name: "App",
kind: "EditorApp"
});

// Start.js

window.onload = function() {
var e = (new App).renderInto(document.body);
};

var debug = location.pathname.indexOf("debug") != -1;

debug || (console.log = function(e) {}, enyo.log = function(e) {});
