// Put event listeners into place
$(document).ready(function() {
	// Grab elements, create settings, etc.
	var video = document.getElementById("video"),
		videoObj = { "video": true, "audio": false },
		errBack = function(error) {
			alert("Video capture error: ", error.code); 
		};

	// Put video listeners into place
	if(navigator.getUserMedia) { // Standard
		navigator.getUserMedia(videoObj, function(stream) {
			video.src = stream;
			video.play();
		}, errBack);
	} else if(navigator.webkitGetUserMedia) { // WebKit-prefixed
		navigator.webkitGetUserMedia(videoObj, function(stream){
			video.src = window.webkitURL.createObjectURL(stream);
			video.play();
		}, errBack);
	}
	else if(navigator.mozGetUserMedia) { // Firefox-prefixed
		navigator.mozGetUserMedia(videoObj, function(stream){
			video.src = window.URL.createObjectURL(stream);
			video.play();
		}, errBack);
	}
	
	var allContacts = navigator.mozContacts.getAll({sortBy: "familyName", sortOrder: "descending"});
	var contactData = [];
	
	allContacts.onsuccess = function(event) {
		var cursor = event.target;
		if (cursor.result) {
			var name = cursor.result.givenName[0] + " " + cursor.result.familyName[0];
			$.each(cursor.result.tel,function(){
				var con = {};
				con.label = this.value;
				con.category = name;
				contactData.push(con);
			});
			cursor.continue();
		} else {
			console.log("No more contacts");
		}
	}

	allContacts.onerror = function() {
		console.warn("Something went terribly wrong! :(");
	}
	
	$.widget("custom.catcomplete", $.ui.autocomplete, {
		_renderMenu: function(ul, items) {
			var that = this, currentCategory = "";
			$.each(items, function(index, item) {
				if (item.category != currentCategory) {
					ul.append( "<li class='ui-autocomplete-category'>" + item.category + "</li>" );
					currentCategory = item.category;
				}
				that._renderItemData( ul, item );
			});
		}
	});
	
	function split( val ) {
      return val.split( /,\s*/ );
    }
    function extractLast( term ) {
      return split(term).pop();
    }
	
	$("#to").bind("focus", function(event){
		$("#message").fadeOut(500,function(){});
		$("#send").fadeOut(500,function(){});
	});
	
	$("#to").bind("blur", function(event){
		$("#message").fadeIn(500,function(){});
		$("#send").fadeIn(500,function(){});
	});
	
	$("#message").bind("focus", function(event){
		$("#to").fadeOut(500,function(){});
		$("#send").fadeOut(500,function(){});
	});
	
	$("#message").bind("blur", function(event){
		$("#to").fadeIn(500,function(){});
		$("#send").fadeIn(500,function(){});
	});
	
	$("#to").bind("keydown", function(event) {
        if(event.keyCode === $.ui.keyCode.TAB && $( this ).data("ui-autocomplete").menu.active) {
          event.preventDefault();
        }
	})
	.catcomplete({
		delay: 0,
		source: function( request, response ) {
          // delegate back to autocomplete, but extract the last term
          response($.ui.autocomplete.filter(contactData, extractLast(request.term)));
        },
		focus: function() {
			// prevent value inserted on focus
			return false;
        },
        select: function( event, ui ) {
			var terms = split(this.value);
			// remove the current input
			terms.pop();
			// add the selected item
			if($.inArray(ui.item.value, terms)==-1){
				terms.push(ui.item.value);
			}
			// add placeholder to get the comma-and-space at the end
			terms.push( "" );
			this.value = terms.join(", ");
			return false;
        }
    });
	
	$("#send").click(function(){
		var message = $("#message").val();
		var numbers = split($("#to").val());
		
		if(message!="" && number!=""){
			var request, msg, pos, size, i,
			info = navigator.mobileMessage.getSegmentInfoForText(message);
			$.each(numbers, function(index, value) {
				for (i = 0; i < info.segments; i++) {
					pos  = i * info.charsPerSegment;
					size = i < info.segments - 1 
					   ? info.charsPerSegment 
					   : info.charsAvailableInLastSegment;
					msg = message.substr(pos, size);
					requests = navigator.mozMobileMessage.send(value, msg);
					requests.forEach(function (request) {
						request.onsuccess = function () {
							alert('The SMS has been sent to ' + this.result.receiver)
						}
						request.onerror = function () {
							alert('Something goes wrong: ' + this.error)
						}
					});
				}
			});
		} else{
			alert("Please fill all fields.");
		}
	});
});