// setting up * namespaces *
var Krossware = {};
Krossware.TheDailyStar = {};
Krossware.TheDailyStar.urls = {

};

Krossware.TheDailyStar.httpClient = {

	fetchURL: function(url, onload, onerror) {
		var request = new XMLHttpRequest({mozSystem:true});
		request.onload = function() {
			onload(this.responseText);
		};
		request.onerror = onerror;
		request.open("get", url, true);
		request.send();
	},

	getJSONfromXML: function(url, onload, onerror) {
		this.fetchURL(url, function(data) {
			var x2js = new X2JS();
			onload(x2js.xml_str2json(data));
		}, onerror);
	}

};

Krossware.TheDailyStar.core = {

	getCategories: function(onsuccess, onerror) {
		Krossware.TheDailyStar.httpClient.getJSONfromXML("http://bd.thedailystar.net/front/rsscategory/",
			function(data) {
				var category_objects = data.rss.channel.item;
				localforage.setItem('categories', category_objects);
				onsuccess(category_objects);
		}, onerror);
	},

	getNewsItemsfromCategory: function(id, onsuccess, onerror) {
		Krossware.TheDailyStar.httpClient.getJSONfromXML("http://bd.thedailystar.net/front/rsscategory/categorydetails?cat=" + id,
			function(d) {
				onsuccess(d);
		}, onerror);
	},

	getNewsItem: function(id, onsuccess, onerror) {
		Krossware.TheDailyStar.httpClient.getJSONfromXML("http://bd.thedailystar.net/front/rsscategory/newsdetails?newsid=" + id,
			function(d) {
				onsuccess(d);
		}, onerror);
	}

};

Krossware.TheDailyStar.favoritesManager = {
	init: function(callback) {
		localforage.getItem('favorites', function(data) {
			if(data == null) {
				localforage.setItem('favorites', []);
			}
			callback();
		});

	},
	add: function(obj, callback) {
        localforage.getItem('favorites', function(data) {
//            console.log(obj);
            var duplicate = false;
            try {
                for (var i = 0; i < data.length; i++) {
                    if(data[i].id == obj.id) duplicate = true;
                }
            } catch(e){}

            console.log(duplicate);
            if(!duplicate) data.push(obj);
            console.log(data);
            localforage.setItem('favorites', data, callback);
        });
	},
	remove: function(obj, callback) {
		localforage.getItem('favorites', function(data) {
			if(data != null) {
				data.splice(data.indexOf(obj), 1);
				localforage.setItem('favorites', data, callback);
			}
		});
	},
	getAll: function(callback) {
		localforage.getItem('favorites', function(data) {
			callback(data);
		});
	},
    trigger: function(render_data) {

    }
};

Krossware.TheDailyStar.categoryManager = {
	init: function(callback) {
		localforage.getItem('categories', function(data) {
			if(data == null) {
				localforage.setItem('categories', ["0", "2", "72", "79"]);
			}
			callback();
		});

	},
	add: function(id, onsuccess, onerror) {
		localforage.getItem('categories', function(data) {
			if(data.length < 7) {
                data.push(id);
                var uniqueArray = data.filter(function(elem, pos) {
                    return data.indexOf(elem) == pos;
                });

                uniqueArray.sort();
                localforage.setItem('categories', uniqueArray);
            }
            else {
                onerror();
            }
		});
	},
	remove: function(id) {
		localforage.getItem('categories', function(data) {
			if(data != null) {
				data.splice(data.indexOf(id), 1);
				data.sort();
				localforage.setItem('categories', data);
			}
		});
	},
	trigger: function(el, onsuccess, onerror) {
                if(el.checked) {
                    Krossware.TheDailyStar.categoryManager.add(el.getAttribute('data-id'), onsuccess, function() {
                        this.checked = false;
                        onerror();
                    });
                }
                else {
                    Krossware.TheDailyStar.categoryManager.remove(el.getAttribute('data-id'));
                }
//            console.log(el.checked + " " + el.getAttribute('data-id'));
	},
	getAll: function(callback) {
		localforage.getItem('categories', function(data) {
			callback(data);
		});
	}
};