
Krossware.common.homeURL = 'http://krossware.com';
Krossware.TheDailyStar.urls.baseURL = 'http://bd.thedailystar.net/front/';

Krossware.TheDailyStar.getMenuItemList = function() {
	var xmlRequest = new XMLHttpRequest({mozSystem: true});
	
	xmlRequest.addEventListener('error', function() {
	    localforage.getItem('mainmenu', function(response) {
	    	if(response !== null) {
	    		Krossware.TheDailyStar.__populateMainMenu__(response);
	    	}
	    	else {
	    		alert('No Internet');
	    	}
	    });
	});
	
	xmlRequest.addEventListener('readystatechange', function() {
		if (xmlRequest.readyState == 4) /* readyState 4 means loading done */ {
			var textStuff = this.responseText;
			var kParser = new DOMParser();
			var xmlDom = kParser.parseFromString(textStuff, "text/xml");
			var menuItems = xmlDom.querySelectorAll('rss channel item');

			if (menuItems.length == 0) {
				xmlRequest.dispatchEvent('error');
			}
			else {
				Krossware.TheDailyStar.__populateMainMenu__(menuItems);
			}

			
		}
	});
	
	xmlRequest.open("get", Krossware.TheDailyStar.urls.baseURL + 'rsscategory/', true);
	xmlRequest.send();
};

Krossware.TheDailyStar.getNewsItemList = function(cat_id) {
	var xmlRequest = new XMLHttpRequest({mozSystem:true});
	xmlRequest.addEventListener('readystatechange', function() {
		if(xmlRequest.readyState == 4) {
			var textStuff = this.responseText;
			var kParser = new DOMParser();
			var xmlDom = kParser.parseFromString(textStuff, "text/xml");
			var newsItems = xmlDom.querySelectorAll('rss channel item');

			var newsItemsAll = [];
			for (var i = newsItems.length - 1; i >= 0; i--) {
				var newsObj = {};	

				newsObj.title = newsItems[i].querySelector('title').textContent;
				newsObj.description = newsItems[i].querySelector('description').textContent;
				newsObj.author = newsItems[i].querySelector('author').textContent;
				newsObj.color = newsItems[i].querySelector('color').textContent;
				newsItemsAll.push(newsObj);

				var el = document.createElement('li');
				el.textContent = newsItems[i].querySelector('title').textContent;;
				document.getElementById('mainmenu').appendChild(el);

				// XXX: add UI Mechanism

			}
		}
	});
	xmlRequest.open("get", Krossware.TheDailyStar.urls.baseURL + 'rsscategory/categorydetails?cat=' + cat_id, true);
	xmlRequest.send();
};

Krossware.TheDailyStar.getNewsItem = function(news_id) {
	var xmlRequest = new XMLHttpRequest({mozSystem:true});
	xmlRequest.onload = function() {
		var textStuff = this.responseText;
		var kParser = new DOMParser();
		var xmlDom = kParser.parseFromString(textStuff, "text/xml");
		var newsStuff = xmlDom.querySelector('rss channel item');

		var newsObj = {};

		newsObj.title = he.decode(newsStuff.querySelector('title').textContent);
		newsObj.description = he.decode(newsStuff.querySelector('description').textContent);
		newsObj.link = he.decode(newsStuff.querySelector('link').textContent);
		newsObj.media = newsStuff.querySelector('media');

		Krossware.TheDailyStar.ui.populateNewsItem(newsObj);
		
	};
	xmlRequest.open("get", Krossware.TheDailyStar.urls.baseURL + "rsscategory/newsdetails?newsid=" + news_id);
	xmlRequest.send();
};

Krossware.TheDailyStar.__populateMainMenu__ = function(menuItems) {
	var menuItemsAll = [];

	for (var i = 0; i < menuItems.length; i++) {
		var menuObj = {};
		menuObj.title = menuItems[i].querySelector('title').textContent;
		menuObj.link = menuItems[i].querySelector('link').textContent;
		menuObj.description = menuItems[i].querySelector('description').textContent;
		menuObj.color = menuItems[i].querySelector('color').textContent;
		menuObj.display = menuItems[i].querySelector('display').textContent;
		menuObj.id = /.*cat=(\d+)/g.exec(menuItems[i].querySelector('link').textContent)[1];

		menuItemsAll.push(menuObj);
	}

	localforage.setItem('mainmenu', menuItemsAll);
	Krossware.TheDailyStar.ui.populateMainMenu(menuItemsAll);

};

