Krossware.TheDailyStar.ui = {
    sharer: {
        facebook: function(url) {
            var openURL = new MozActivity({
                name: "view",
                data: {
                    type: "url",
                    url: 'https://www.facebook.com/sharer/sharer.php?u=' + encodeURIComponent(url)
                }
            });
            document.getElementById('share_dialog').style.display = "none";
        },
        twitter: function(url) {
            var openURL = new MozActivity({
                name: "view",
                data: {
                    type: "url",
                    url: 'https://twitter.com/intent/tweet?url=' + encodeURIComponent(url)
                }
            });
            document.getElementById('share_dialog').style.display = "none";
        },
        plus: function(url) {
            var openURL = new MozActivity({
                name: "view",
                data: {
                    type: "url",
                    url: 'https://plus.google.com/share?url=' + encodeURIComponent(url)
                }
            });
            document.getElementById('share_dialog').style.display = "none";
        },
    },

    indexPage: {

        populate: function() {
            var sections = [];
            Krossware.TheDailyStar.categoryManager.getAll(function(cats_enabled) {
                Krossware.TheDailyStar.core.getCategories(function(cats_all) {

                    if (cats_enabled.indexOf("0") > -1) {
                        Krossware.TheDailyStar.ui.indexPage.render_section(0, true, function() {
                            for (var j = 0; j < cats_all.length; j++) {
                                for (var i = 0; i < cats_enabled.length; i++) {
                                    if (cats_all[j].link._id == cats_enabled[i]) {
                                        sections.push(parseInt(cats_enabled[i].id));
                                    }
                                }
                            }
                            sections.sort();

                            for (i = sections.length - 1; i > 0; i--) {
                                Krossware.TheDailyStar.ui.indexPage.render_section(cats_enabled[i], true, function() {
                                    var le_elements = document.querySelectorAll(".news_item_t");

                                    for (var i = le_elements.length - 1; i >= 0; i--) {
                                        le_elements[i].addEventListener('click', function() {
                                            Krossware.TheDailyStar.ui.populateDetails(this.getAttribute('data-id'), function() {
                                                Krossware.TheDailyStar.ui.showPage(document.getElementById('details_page'));
                                            })
                                        })
                                    }
                                });
                            }


                            if (!(document.getElementById('initial_loading_page').style.display == "none")) {
                                Krossware.TheDailyStar.ui.showPage(document.getElementById('index_page'));
                            }
                        })
                    } else {
                        for (var j = 0; j < cats_all.length; j++) {
                            for (var i = 0; i < cats_enabled.length; i++) {
                                if (cats_all[j].link._id == cats_enabled[i]) {
                                    sections.push(parseInt(cats_enabled[i].id));
                                }
                            }
                        }
                        sections.sort();

                        for (i = sections.length - 1; i >= 0; i--) {
                            Krossware.TheDailyStar.ui.indexPage.render_section(cats_enabled[i], true, function() {
                                var le_elements = document.querySelectorAll(".news_item_t");

                                for (var i = le_elements.length - 1; i >= 0; i--) {
                                    le_elements[i].addEventListener('click', function() {
                                        Krossware.TheDailyStar.ui.populateDetails(this.getAttribute('data-id'), function() {
                                            Krossware.TheDailyStar.ui.showPage(document.getElementById('details_page'));
                                        })
                                    })
                                }
                            });
                        }


                        if (!(document.getElementById('initial_loading_page').style.display == "none")) {
                            Krossware.TheDailyStar.ui.showPage(document.getElementById('index_page'));
                        }
                    }

                });
            });


        },

        render_section: function(id, vertical, callback) {
            Krossware.TheDailyStar.core.getCategories(function(categories) {
                Krossware.TheDailyStar.core.getNewsItemsfromCategory(id, function(data) {
                    var items = data.rss.channel.item;
                    if (items instanceof Array) {
                        var mastdiv = document.createElement("div");
                        var section_info = {};
                        for (var i = categories.length - 1; i >= 0; i--) {
                            if (categories[i].link._id == id) {
                                section_info.name = he.decode(categories[i].title.__cdata);
                                section_info.id = id;
                                section_info.color = categories[i].color;
                            }
                        };
                        var sectiondiv = document.createElement('div');
                        sectiondiv.innerHTML = Krossware.TheDailyStar.ui.render.sectionHeader(section_info);
                        document.getElementById('index_page').appendChild(sectiondiv);
                        for (var i = 0; i < items.length; i++) {
                            var node_data = "";
                            try {
                                if (items[i].media[0])
                                    node_data = {
                                        photo: items[i].media[0]._url,
                                        title: he.decode(items[i].title.__cdata),
                                        id: items[i].link._id
                                    };
                                else if (items[i].media)
                                    node_data = {
                                        photo: items[i].media._url,
                                        title: he.decode(items[i].title.__cdata),
                                        id: items[i].link._id
                                    };
                            } catch (e) {
                                node_data = {
                                    photo: "/img/loading.png",
                                    title: he.decode(items[i].title.__cdata),
                                    id: items[i].link._id
                                };
                            }
                            lediv = document.createElement('div');
                            if (node_data) {
                                if (vertical) {
                                    mastdiv.classList.add('horizontal_scroll');
                                    lediv.innerHTML = Krossware.TheDailyStar.ui.render.horizontalMenuItem(node_data);
                                } else {
                                    mastdiv.classList.add('vertical_scroll');
                                    lediv.innerHTML = Krossware.TheDailyStar.ui.render.verticalMenuItem(node_data);
                                }
                                mastdiv.appendChild(lediv);
                            }
                        }

                        document.getElementById('index_page').appendChild(mastdiv);
                    }

                    try {
                        callback();
                    } catch (e) {}



                });
            })
        }
    },

    share: function() {
        document.getElementById('share_dialog').style.display = "block";
    },

    populateDetails: function(id, callback) {
        Krossware.TheDailyStar.core.getNewsItem(id, function(data) {
            var el = document.getElementById('newsdetails');

            data = data.rss.channel.item;

            el.setAttribute('data-link', data.link.__text);
//            console.log(data);
            var image;
            try {
                if (data.media[0])
                    image = data.media[0]._url;
                else if (data.media)
                    image = data.media._url;
            } catch (e) {
                image = "";
            }
            var render_data = {
                id: he.decode(data.link._id),
                date: he.decode(data.date),
                title: he.decode(data.title.__cdata),
                photo: image,
                description: he.decode(data.description.__cdata)
                //                    bookmarked: bookmarked.toString()
            };
            el.innerHTML = Krossware.TheDailyStar.ui.render.newsDetailItem(render_data);

            console.log(data.link.__text);
            //
            var back_button = document.getElementById('btn-back');
            try {
                var share_button = document.getElementById('btn-share');
                share_button.addEventListener('click', function() {
                    Krossware.TheDailyStar.ui.share();
                });
            } catch (e) {}
            back_button.addEventListener('click', function() {
                //                        console.log("back pressed");
                Krossware.TheDailyStar.ui.showPage(document.getElementById('index_page'));
            });

            callback();

        });
    },

    populateCategories: function() {
        var onsuccess = function(menuItemsAll) {

            var el_mainmenu = document.getElementById('div_check_box_t');

            while (el_mainmenu.firstChild) {
                el_mainmenu.removeChild(el_mainmenu.firstChild);
            }

            var mastdiv = document.createElement('div');

            Krossware.TheDailyStar.categoryManager.getAll(function(data) {
                console.log("state1");
                for (var i = 0; i <= menuItemsAll.length - 1; i++) {
                    var div = document.createElement('div');
                    var checked = false;
                    for (var j = data.length - 1; j >= 0; j--) {
                        if (data[j] == menuItemsAll[i].link._id) {
                            checked = true;
                        }
                    };
                    if (checked) {
                        div.innerHTML = Krossware.TheDailyStar.ui.render.menuItem({
                            name: menuItemsAll[i].title.__cdata,
                            id: menuItemsAll[i].link._id,
                            checked: "checked"
                        });
                    } else {
                        div.innerHTML = Krossware.TheDailyStar.ui.render.menuItem({
                            name: menuItemsAll[i].title.__cdata,
                            id: menuItemsAll[i].link._id,
                            checked: ""
                        });
                    }
                    mastdiv.appendChild(div);
                    console.log("shitshit");
                }

                var ells = document.querySelectorAll("#div_check_box_t input");

                for (var i = ells.length - 1; i >= 0; i--) {
                    ells[i].addEventListener("click", function() {
                        Krossware.TheDailyStar.categoryManager.trigger(this, function() {}, function() {

                            alert("Upto 7 categories can be selected");
                        });
                        //                        console.log(this.checked);
                    });
                }
            });

            document.getElementById('div_check_box_t').appendChild(mastdiv);

        };
        var onerror = function() {

            alert("Connection error occured");

        };

        Krossware.TheDailyStar.core.getCategories(onsuccess, onerror);
    },

    toggleMenu: function() {
        var view = document.getElementById("option");
        var box = document.getElementById('box_align');
        if (view.style.display == "none") {
            // view.style.display = "block";
            view.style.display = "block";
            box.style.zIndex = "1000";

        } else {
            // view.style.display = "none";
            view.style.display = "none";
            box.style.zIndex = "-1000";
        }
    },

    showPage: function(el) {
        var els = document.querySelectorAll(".one_page");
        for (i = 0; i < els.length; i++) {
            els[i].style.display = "none";
        }
        el.style.display = "block";
        var event = new CustomEvent('TDSPageChange', {
            'detail': el
        });
        document.dispatchEvent(event);
    },

    addListeners: function() {

        // add event listeners

        document.getElementById('facebook-button').addEventListener('click', function() {
            var url = document.getElementById("newsdetails").getAttribute('data-link'); //get url somehow
            Krossware.TheDailyStar.ui.sharer.facebook(url);
        });

        document.getElementById('twitter-button').addEventListener('click', function() {
            var url = document.getElementById("newsdetails").getAttribute('data-link');
            Krossware.TheDailyStar.ui.sharer.twitter(url);
        });

        document.getElementById('plus-button').addEventListener('click', function() {
            var url = document.getElementById("newsdetails").getAttribute('data-link');
            Krossware.TheDailyStar.ui.sharer.plus(url);
        });

        document.addEventListener("TDSPageChange", function(e) {

            console.log("shitsssssss");
            if (document.getElementById('index_page') == e.detail) {
                document.getElementById("reload").src = 'img/action_refresh.png';
            } else {
                document.getElementById("reload").src = 'img/action_home.png';
            }
            window.location = e.detail.firstChild.getAttribute("#" + 'name');
        });

        document.getElementById('action_button').addEventListener('click', Krossware.TheDailyStar.ui.toggleMenu);
        document.getElementById('reload').addEventListener('click', function() {
            Krossware.TheDailyStar.ui.showPage(document.getElementById("initial_loading_page"));
            document.getElementById('index_page').innerHTML = "";
            Krossware.TheDailyStar.ui.indexPage.populate();
        });

        document.getElementById('help_button').addEventListener('click', function() {
            Krossware.TheDailyStar.ui.showPage(document.getElementById('help_about'));
            Krossware.TheDailyStar.ui.toggleMenu();
        });

        //        document.getElementById('favourite_button').addEventListener('click', function() {
        //            Krossware.TheDailyStar.ui.showPage(document.getElementById('favourite'));
        //            Krossware.TheDailyStar.ui.toggleMenu();
        //        });

        document.getElementById('category_button').addEventListener('click', function() {
            Krossware.TheDailyStar.ui.showPage(document.getElementById('div_check_box'));
            Krossware.TheDailyStar.ui.toggleMenu();
        });
        document.getElementById('help_box').addEventListener('click', function() {
            document.getElementById('about').style.visibility = "hidden";
            document.getElementById('help_content').style.visibility = "visible";
        });
        document.getElementById('about_box').addEventListener('click', function() {
            document.getElementById('help_content').style.visibility = "hidden";
            document.getElementById('about').style.visibility = "visible";
        });
    },

    showHome: function() {
        Krossware.TheDailyStar.ui.showPage(document.getElementById('index_page')); // XXX: TO BE CHANGED
    },

    changeHeaderColor: function(color) {
        document.getElementById('red').style.backgroundColor = color;
        document.getElementById('option').style.backgroundColor = color;
    }

};

Krossware.TheDailyStar.ui.render = {
    newsListItem: function(news) {
        var template =
            '<div class="list"> \
			<a class="news" href="#"> \
				<table> \
					<tr> \
						<td><img class="news_image" src="{{ image }}"></td> \
						<td><h3 class="news_title">{{ title }}</h3></td> \
					</tr> \
				</table> \
			</a> \
		</div>';

        return Mustache.render(template, news);
    },
    menuItem: function(item) {

        /*
         item.name
         item.id
         */

        var template =
            '<table width="100%"> \
				<tbody><tr> \
					<td> \
						<h3 class="checkbox_label">{{name}}</h3> \
					</td> \
					<td align="right"> \
						<label class="pack-switch"> \
	  				<input type="checkbox" {{checked}} class="menu-check-box" data-id="{{id}}"> \
	  			<span></span> \
					</label></td> \
				</tr> \
			</tbody></table> \
			<div style="border-bottom: 1px #CCC solid; margin-left: 5px; margin-right: 5px"></div>';


        return Mustache.render(template, item);
    },
    newsDetailItem: function(news) {

        if (news.photo != "" && news.photo != null) {
            var template =
                '<tr><td><h3 id="publish">{{ date }}</h3></td></tr> \
                <tr><td align="center"><h3 id="news_title">{{ title }}</h3></td></tr> \
                <tr><td align="center"><img src="{{ photo }}" id="news_photo"/></td></tr> \
                <tr><td><p id="news_details" style="text-align: justify;">{{ description }}</p></td></tr>\
                <input type="hidden" id="isBookmarked" value="false">';
        } else {
            var template =
                '<tr><td><h3 id="publish">{{ date }}</h3></td></tr> \
                <tr><td align="center"><h3 id="news_title">{{ title }}</h3></td></tr> \
                <tr><td><p id="news_details" style="text-align: justify;">{{ description }}</p></td></tr>';
        }

        return Mustache.render(template, news);
    },
    sectionHeader: function(section) {

        /*
         section.id
         section.name
         section.color
         */

        var template =
            '<div data-id="{{ id }}" class="section_header" style="border-top: 5px {{color}} solid;"> \
		<h2 class="section_header_title" style="color: {{color}}">{{name}}</h2> \
		<img src="img/ribbon_arrow.png" align="right" id="arrow"/> \
		</div>';

        return Mustache.render(template, section);
    },
    horizontalMenuItem: function(item) {

        /*
         item.id
         item.title
         item.photo
         */

        var template =
            '<div class="news_item_t list" data-id="{{id}}"> \
				<a class="news" href="#"> \
					<table> \
						<tr> \
						<td><img class="news_image" src="{{photo}}"></td> \
						<td><h3 class="news_title">{{title}}</h3></td> \
						</tr> \
					</table> \
				</a> \
			</div>';

        return Mustache.render(template, item);
    },
    verticalMenuItem: function(item) {

        /*
         item.id
         item.title
         item.photo
         */

        var template =
            '<div data-id="{{id}}" class="news_item_t vertical_item"> \
				<img src="{{photo}}" class="slider_photo"/> \
				<h3 class="slider_title">{{title}}</h3> \
			</div>';

        return Mustache.render(template, item);
    },
    favoritesItem: function(item) {

        /*
         item.title
         item.date
         */

        var template = '<table style="border-bottom: 1px #CCC solid; float: left; width: 95%; margin-left: 5px;"> \
            <tr> \
            <td> \
                <h3 class="fav_news_title">{{ title }}</h3> \
                <h3 class="fav_news_date">{{ date }}</h3> \
            </td> \
            <td> \
            <img src"img/remove.png" style="height: 35px;" align="right"/> \
            </td> \
        </tr> \
        </table>';

        return Mustache.render(template, item);
    }
};