function sleep(milliseconds) {
  var start = new Date().getTime();
  for (var i = 0; i < 1e7; i++) {
    if ((new Date().getTime() - start) > milliseconds){
      break;
    }
  }
}

Krossware.TheDailyStar.ui.populateMainMenu = function(menuItemsAll) {

	/*

		This method is triggered when the Main Menu needs to be
		populated (sidebar menu)

		menuItemsAll is a list containing the menuObjs. A menuObj
		consists of the following properties.

		* title
		* link
		* description 
		* color
		* display
		* id

		example: menuItemsAll[0].title

	*/

	var el_mainmenu = document.getElementById('div_check_box_t');

	while (el_mainmenu.firstChild) {
	    el_mainmenu.removeChild(el_mainmenu.firstChild);
	}

	var mastdiv = document.createElement('div');

	Krossware.TheDailyStar.categoryManager.getAll(function(data) {
		console.log("state1");
		for (var i = 0; i <= menuItemsAll.length - 1; i++) {
			var div = document.createElement('div');
			var checked = false;
			for (var j = data.length - 1; j >= 0; j--) {
				if(data[j] == menuItemsAll[i].id) {
					checked = true;
				}
			};
			if(checked) {
				div.innerHTML = Krossware.TheDailyStar.ui.render.menuItem({name:menuItemsAll[i].title, id: menuItemsAll[i].id, checked: "checked"});
			}
			else {
				div.innerHTML = Krossware.TheDailyStar.ui.render.menuItem({name:menuItemsAll[i].title, id: menuItemsAll[i].id, checked: ""});
			}
			mastdiv.appendChild(div);
			console.log("shitshit");
		};

		var ells = document.querySelectorAll("#div_check_box_t input");

		for (var i = ells.length - 1; i >= 0; i--) {
			ells[i].addEventListener("click", Krossware.TheDailyStar.categoryManager.trigger)
		};

	});

	document.getElementById('div_check_box_t').appendChild(mastdiv);

	// Krossware.TheDailyStar.categoryManager.getAll(function(data) {
	// 	var els = document.querySelectorAll('#div_check_box_t .menu-check-box');
		
	// 	for (var i = els.length - 1; i >= 0; i--) {
	// 		els[i].addEventListener('click', Krossware.TheDailyStar.categoryManager.trigger(els[i]));
	// 		for (var j = data.length - 1; j >= 0; j--) {
	// 			if(els[i].getAttribute('data-id') == data[j]) {
	// 				console.log(els[i]);
	// 				els[i].checked = true;
	// 			}
	// 		}
	// 	}
	// });

	var loadComplete = new Event('TDSMenuItemLoadComplete');
	document.dispatchEvent(loadComplete);

};

Krossware.TheDailyStar.ui.populateNewsItem = function(newsItem) {

	/*

		This method is triggered when a news item is requested.

		newsItem has the following properties

		* title
		* description

		example: newsItem.title

	*/

	console.log(newsItem);

};

Krossware.TheDailyStar.ui.toggleMenu = function() {
	var view = document.getElementById("option");
	var box = document.getElementById('box_align');
	if(view.style.visibility == "hidden") {
		// view.style.display = "block";
		view.style.visibility = "visible";
		box.style.zIndex = "1000";

	}
	else {
		// view.style.display = "none";
		view.style.visibility = "hidden";
		box.style.zIndex = "-1000";
	}
};

Krossware.TheDailyStar.ui.showPage = function(el) {
	var els = document.querySelectorAll(".one_page");
	for (i = 0; i < els.length; i++) {
		els[i].style.visibility = "hidden";
	}
	el.style.visibility = "visible";
	el.classList.add('animateone');
	var event = new CustomEvent('TDSPageChange', { 'detail': el });
	document.dispatchEvent(event);
};

// Krossware.TheDailyStar.ui.showPage = function() {
// var ctgr = document.getElementById("div_check_box");
// ctgr.style.visibility = "visible";
// }

Krossware.TheDailyStar.ui.showHome = function() {
	Krossware.TheDailyStar.ui.showPage(document.getElementById('index_page')); // XXX: TO BE CHANGED
}

document.addEventListener('TDSPageChange', function(e) {
	var top_bar = document.getElementById("red");
	var reload_button = document.getElementById("reload");
	var details_page = document.getElementById("details_page");

	//set overflow display off if necessary ( for initial loading page )

	if(e.detail == document.getElementById('initial_loading_page')) {
		document.getElementsByTagName('body')[0].classList.add('no_overflow');
	}
	else {
		document.getElementsByTagName('body')[0].classList.remove('no_overflow');
	}

	if(e.detail == document.getElementById('div_check_box')) {
		top_bar.style.backgroundColor = "#333";
	}
	else if(e.detail == document.getElementById('index_page')) {
		top_bar.style.backgroundColor = "#D61217";
	}
	
	if(document.getElementById('index_page') == e.detail) {
		reload_button.src = 'img/action_refresh.png';
	}
	else {
		reload_button.src = 'img/action_home.png';
	}
});

Krossware.TheDailyStar.ui.addListeners = function() {

	// add event listeners

	document.getElementById('action_button').addEventListener('click', Krossware.TheDailyStar.ui.toggleMenu);
	document.getElementById('reload').addEventListener('click', Krossware.TheDailyStar.ui.showHome);

	var forEach = Array.prototype.forEach,
	    $$ = document.querySelectorAll.bind(document);  
	forEach.call($$('.news'), function(v) {
	  v.addEventListener('click', function(e) {
	    Krossware.TheDailyStar.ui.showPage(document.getElementById('details_page'));  
	  }, false);
	});
 
	document.getElementById('category_button').addEventListener('click', function() {
		Krossware.TheDailyStar.ui.showPage(document.getElementById('div_check_box'));
		Krossware.TheDailyStar.ui.toggleMenu();
	});


	
};

