/*
document.getElementById("playAudio").addEventListener('click', function(event) {

//need to trigger this whole thing on a click
	event.preventDefault();
*/	
function playingHighlighting(audioFile, soundsArray, pageElement) {
	console.log(audioFile)
	console.log(soundsArray)
	console.log(pageElement)
	if(typeof(audio)!="undefined") {
		audio.pause();
	}
	audio = new Audio(audioFile);

	audio.addEventListener("loadedmetadata", function() {

		window.track = audio.addTextTrack("metadata", "sprite track", "en");
		track.mode = "hidden";

		for (var i = 0; i < soundsArray.length; ++i) {
			var sound = soundsArray[i];
			var cue = new(window.VTTCue || window.TextTrackCue)(sound.startTime, sound.endTime, sound.id); // change in spec
			cue.id = sound.id;
			track.addCue(cue);
		}

		audio.addEventListener("timeupdate", function(event) {
			if(event.target.currentTime >= currentlySelectedWord.endTime) {
				goToNextWord();
			}
		});

		audio.addEventListener("ended", function(event) {
			if(activePage < 12) {
				moveToPage(activePage + 1);
			}
		});

		function goToNextWord() {
			currentlySelectedIndex++;
			currentlySelectedWord = soundsArray[currentlySelectedIndex];
			updateHighlight();
		}

		function updateHighlight() {
			var prevIndex = currentlySelectedIndex - 1;
			var prevWordId = 'word'+prevIndex;
			var nextWordId = 'word'+currentlySelectedIndex;
			pageElement.querySelector('#'+nextWordId).classList.toggle('highlighted', true);
			pageElement.querySelector('#'+prevWordId).classList.toggle('highlighted', false);
		}

		currentlySelectedIndex = 0;
		currentlySelectedWord = soundsArray[currentlySelectedIndex];
		pageElement.querySelector('#word0').classList.toggle('highlighted', true);

	});

	audio.play();
}
