// DOMContentLoaded is fired once the document has been loaded and parsed,
// but without waiting for other external resources to load (css/images/etc)
// That makes the app more responsive and perceived as faster.
// https://developer.mozilla.org/Web/Reference/Events/DOMContentLoaded
window.addEventListener('DOMContentLoaded', function() {
  'use strict';

    var i = 0;
    var whoosh = document.getElementById("whoosh");
    var bgmusic = document.getElementById("bgmusic");
    
    var valaszarray = ["Igen","Nem","Talán","Természetesen","Néha","Kizárt","Ez nyilvánvaló","Pontosan","Ezt kérdezd meg később","Úgy gondolom igen","Teljes mértékben","Valószínűleg","Nem hiszem","Nem tartom jó ötletnek","Nem valószínű","Nem hangzik túl jól","Nem helyes","Ezt nem tudom megjósolni"];
    $("#valaszkeres").click(function(){
      var kerdes = $("#kerdes").val();
      if(kerdes=="")
        return;
      whoosh.play();
      if(!kerdes.endsWith("?"))
        kerdes = kerdes+"?";
      $("#kerdes").val("");
      var valasz = valaszarray[Math.floor(Math.random()*valaszarray.length)];
      $("#valaszok").prepend("<b>"+i+". "+kerdes+"</b><br>"+valasz+"<br>");
      
      
      i=i+1;
    });

    $("#hangok").click(function(){
      if(whoosh.volume>0)
      {
        $(this).html("Hangok be");
        whoosh.volume = 0;
      }
      else
      {
        $(this).html("Hangok ki");
        whoosh.volume = 1;
      }
    });

    $("#zene").click(function(){
      if(bgmusic.volume>0)
      {
        $(this).html("Zene be");
        bgmusic.volume = 0;
      }
      else
      {
        $(this).html("Zene ki");
        bgmusic.volume = 1;
      }
    });
});
