(function( $, undefined ) {

$.fn.controlgroup = function( options ) {
	function flipClasses( els, flCorners  ) {
		els.removeClass( "ui-btn-corner-all ui-corner-top ui-corner-bottom ui-corner-left ui-corner-right ui-controlgroup-last ui-shadow" )
			.eq( 0 ).addClass( flCorners[ 0 ] )
			.end()
			.last().addClass( flCorners[ 1 ] ).addClass( "ui-controlgroup-last" );
	}

	return this.each(function() {
		var $el = $( this ),
			o = $.extend({
						direction:  $.mobile.getAttrFixed( $el[0], "data-"+ $.mobile.ns + "type" ) || "vertical",
						shadow: false,
						excludeInvisible: true,
						mini: $.mobile.getAttrFixed( $el[0], "data-"+ $.mobile.ns + "mini" )
					}, options ),
			grouplegend = $el.children( "legend" ),
			groupheading = $el.children( ".ui-controlgroup-label" ),
			groupcontrols = $el.children( ".ui-controlgroup-controls" ),
			flCorners = o.direction === "horizontal" ? [ "ui-corner-left", "ui-corner-right" ] : [ "ui-corner-top", "ui-corner-bottom" ],
			type = $el.find( "input" ).first().attr( "type" );

		// First unwrap the controls if the controlgroup was already enhanced
		if ( groupcontrols.length ) {
			groupcontrols.contents().unwrap();
		}
		$el.wrapInner( "<div class='ui-controlgroup-controls'></div>" );

		if ( grouplegend.length ) {
			// Replace legend with more stylable replacement div
			$( "<div role='heading' class='ui-controlgroup-label'>" + grouplegend.html() + "</div>" ).insertBefore( $el.children( 0 ) );
			grouplegend.remove();
		} else if ( groupheading.length ) {
			// Just move the heading if the controlgroup was already enhanced
			$el.prepend( groupheading );
		}

		$el.addClass( "ui-corner-all ui-controlgroup ui-controlgroup-" + o.direction );

		flipClasses( $el.find( ".ui-btn" + ( o.excludeInvisible ? ":visible" : "" ) ).not( '.ui-slider-handle' ), flCorners );
		flipClasses( $el.find( ".ui-btn-inner" ), flCorners );

		if ( o.shadow ) {
			$el.addClass( "ui-shadow" );
		}

		if ( o.mini ) {
			$el.addClass( "ui-mini" );
		}

	});
};

// The pagecreate handler for controlgroup is in jquery.mobile.init because of the soft-dependency on the wrapped widgets

})(jQuery);
