(function( $, window ) {

	// This fix addresses an iOS bug, so return early if the UA claims it's something else.
	if ( !(/iPhone|iPad|iPod/.test( navigator.platform ) && navigator.userAgent.indexOf( "AppleWebKit" ) > -1 ) ) {
		return;
	}

  var zoom = $.mobile.zoom,
		evt, x, y, z, aig;

  function checkTilt( e ) {
		evt = e.originalEvent;
		aig = evt.accelerationIncludingGravity;

		x = Math.abs( aig.x );
		y = Math.abs( aig.y );
		z = Math.abs( aig.z );

		// If portrait orientation and in one of the danger zones
    if ( !window.orientation && ( x > 7 || ( ( z > 6 && y < 8 || z < 8 && y > 6 ) && x > 5 ) ) ) {
			if ( zoom.enabled ) {
				zoom.disable();
			}
    }	else if ( !zoom.enabled ) {
			zoom.enable();
    }
  }

  $.mobile.$window
		.bind( "orientationchange.iosorientationfix", zoom.enable )
		.bind( "devicemotion.iosorientationfix", checkTilt );

}( jQuery, this ));
