// model 
var model = Backbone.Model.extend({id:'',title:'',date:'',detail:''});

//collection
var tasksCollection = Backbone.Collection.extend({
 model:model,
 comparator: function(item) {
        return item.get('id');
    },
 initialize:function(){
   this.reload();    
  this.on('add',function(){
      
      $.jStorage.set('things-TODO-list',this.models);
  });
  this.on('remove',function(r){
     $.jStorage.set('things-TODO-list',this.models);
  });
 },
 reload:function(){
    this.reset();
 var arrayObject = $.jStorage.get('things-TODO-list');
   if(arrayObject && arrayObject.length > 0) {
    this.add(arrayObject);

   }
 },
 searchNdelete:function(obj){
   result = this.findWhere(obj);
     
    this.remove([result]); 
	 
 },
search:function(obj){
   result = this.findWhere(obj);
    
     return result; 
 }

});

var liView = Backbone.View.extend({
     el:'#tasklist',
     collection:function(){
    	 var tasks = new tasksCollection();
         return tasks;
     },
	 
    render:function(e){
      
       var today_tasks ;
			var over_due ;
			  var coming_up;
			  var template ='';
			  var tasksList = new tasksCollection();  
      _.each(tasksList.models,function(x,y,z){
	    	  var today = new Date();
              var dd = today.getDate();
              var mm = today.getMonth()+1; 
              var yyyy = today.getFullYear(); 
		      var d = mm+"/"+dd+"/"+yyyy;
	         
            if (x.toJSON().date == d){
			
			    
			     if(!today_tasks){
				 today_tasks = ''
				 today_tasks += _.template($('#divider').html(),{section_title:"Today's Tasks"});
				  
				 }
			   	 today_tasks += _.template($('#item').html(),x.toJSON());
				
				           
	        }else if(d > x.toJSON().date){
			
			  if(!over_due){
			  over_due = ''
			  over_due += _.template($('#divider').html(),{section_title:"Over Due Tasks"});
			  
	          }    
	             over_due += _.template($('#item').html(),x.toJSON());	 
	            
			}else if(d < x.toJSON().date){
			
			       if(!coming_up){
				   coming_up = ''
			     coming_up += _.template($('#divider').html(),{section_title:"Due Tasks"});
				
	              }
	             coming_up += _.template($('#item').html(),x.toJSON());
	            
			}
	  });
	 
 	 $(this.el).append(today_tasks); 
	  $(this.el).append(over_due); 
	   $(this.el).append(coming_up); 
	 $(this.el).listview('refresh');
	  
	
    },
    reset:function(e){
      $(this.el).find('li').remove();

    },
events:{
'click a#remove':'remove',
'click a#detail':'detail'
},
detail :function(e){

var id = parseInt($(e.currentTarget).parent().parent().parent().attr('id'));
//console.log($(e.currentTarget).parent());

     if(id){
       var task = this.collection().search({id:id});
	   
       var d = new detail();
       d.task = task;
      vest.trigger("show_detail");
//$.mobile.changePage("#detail",{ role: "dialog" })	
   $.mobile.changePage("#detail")	
   }
},
remove:function(e){
 
  console.log("test");
  var id = parseInt($(e.currentTarget).parent().attr('id'));
   
   if(id){
   var tasksList = new tasksCollection();
   tasksList.searchNdelete({id:id});
   //console.log(tasksList.length+" after delete");
   //$(e.currentTarget).parent().remove();
   this.reset();
   this.render();
   $(this.el).listview('refresh');     
   }

}

});




var container = Backbone.View.extend({
   //template:_.template($('#main').html(),{}),
   el:'#container',   
   taskList:[],
   collection:function(){
    
    return tasks;
  },
   initialize:function(){
            this.localStorage();
            this.refresh();
            vest.container = this;
			vest.on('refresh_container',function(){this.container.refresh();})
   },
   refresh:function(){
	   if(!this.l){
		   this.l = new liView();
	   }
       var l = this.l;
       l.reset();
       l.render();
	   $(l.el).listview('refresh');
	   
    },
   localStorage:function(){
   t = this.collection();
   if(t.models && t.models.length > 0){
      this.taskList = t.models;     
    }
    },
});

var about = Backbone.View.extend({
       el:'body',
	   initialize:function(e){
	        this.render();
	   },	      
      render:function(e){
      var template='';  
      template = _.template($('#about').html(),{});      
      $(this.el).append(template);
       
    }
});


var detail = Backbone.View.extend({
       el:'body',
       initialize:function(){
    	   vest.detail_view = this;
    	   vest.on('show_detail',function(){ this.detail_view.update(); });
    	   this.task = new model({title:'',date:'',detail:''});
    	   this.render();
       },	   	   
      render:function(e){
      	  
      var template=''; 
      
      template += _.template($('script#detail').html(),this.task.toJSON());
      
      $(this.el).append(template);       
     },
     update:function(){
    	$('div#detail').find('b.title').text(this.task.get('title'));
    	$('div#detail').find('b.date').text(this.task.get('date'));
    	$('div#detail').find('b.detail').text(this.task.get('detail'));
    }
	 
});

var add = Backbone.View.extend({
   //template:_.template($('#main').html(),{}),
   el:'body',
   initialize:function(){
            this.render();
   },   
   events:{
   'click input[type=button]':'addtask',
   'dblclick input[name=title]':'addtask'
   },
   collection:function(){
     var tasks = new tasksCollection();   
    return tasks;
  },
   addtask:function(e){
      var v = $.trim($('input#task').val());
	  var d = $.trim($('input#taskdate').val());
	  var detail = $.trim($('textarea#taskdetails').val());
	  if(d.length > 0){
	   	    // validate the date 
	     if(!this.validateDate("MM/nn/yyyy", d)){
		 
	         var today = new Date();
             var dd = today.getDate();
             var mm = today.getMonth()+1; 
             var yyyy = today.getFullYear(); 
		     d = mm+"/"+dd+"/"+yyyy;	  
	   }
	   
	  }else{
	  
	  var today = new Date();
        var dd = today.getDate();
        var mm = today.getMonth()+1; 
        var yyyy = today.getFullYear(); 
		d = mm+"/"+dd+"/"+yyyy;	  
	  }
      
      if(v.length > 0){
	    
         $('input#task').val('')
		 
		  var tasksList = new tasksCollection();  
		  var last = tasksList.sort().at(tasksList.length-1)
		  
		  if(last){
		  last = last.id;
		  }else{
		  last = 0; 
		  }
          
		  var m = new model({id:last+1,title:v,date:d,detail:detail});
          tasksList.add(m);
		  
		  
		  this.refresh();
		  $.mobile.changePage('#container');
		  
          //this.localStorage();
          
         
       }
       else
       {
           alert("please enter a valid title");
       }
        
   },
   validateDate:function(match,string){
   
    var reg = new RegExp("^"+match.replace(/[mdny]/ig,"\\d")+"$");
    return reg.test(string);   
   },
   refresh:function(){
       
       vest.trigger('refresh_container');
	   
    },
   render:function(e){
   		var form = _.template($('#add').html());
		$(this.el).append(form);        
   },

});














$(function(){


var c = new container();

var ab = new about();

var ad = new add();
var d = new detail();
});

var tasks = new tasksCollection();
//var li = new liView({el:$('#tasklist')});
var vest = {}
_.extend(vest,Backbone.Events);

