var $field;
var $context;
var $round = 0;
var $won;
var $lost;

var $items = ["","","","","","","","",""];

function drawLine(posx,posy,endx,endy,tip,color,width) {
	$context.lineWidth = width;
	$context.lineCap = tip;
	$context.strokeStyle = color;
	$context.beginPath();
    $context.moveTo(posx, posy);
    $context.lineTo(endx, endy);
    $context.stroke();
}

function new_game() {
	$("#new_game").css({"display":"none"});
	$round = 0;
	$items = ["","","","","","","","",""];
	$context.fillStyle="#F0F0F0";
	$context.fillRect(0,0,320,480);
	drawLine(115,75,115,345,"round","#242424",10);
	drawLine(205,75,205,345,"round","#242424",10);
	drawLine(25,165,295,165,"round","#242424",10);
	drawLine(25,255,295,255,"round","#242424",10);
	$("#field").click(function(params){getClick(params);});
}

$(document).ready(function() {
	if($won == null) window.localStorage.setItem("won",0);
	if($lost == null) window.localStorage.setItem("lost",0);
	$won = window.localStorage.getItem("won");
	$lost = window.localStorage.getItem("lost");
	$("#won_num").text($won);
	$("#lost_num").text($lost);
	$context = document.getElementById("field").getContext("2d");
	new_game();
});

function checkState($val) {
	var flag = 0;
	if($items[0] == $val && $items[1] == $val && $items[2] == $val) flag = 1;
	if($items[3] == $val && $items[4] == $val && $items[5] == $val) flag = 1;
	if($items[6] == $val && $items[7] == $val && $items[8] == $val) flag = 1;
	if($items[0] == $val && $items[3] == $val && $items[6] == $val) flag = 1;
	if($items[1] == $val && $items[4] == $val && $items[7] == $val) flag = 1;
	if($items[2] == $val && $items[5] == $val && $items[8] == $val) flag = 1;
	if($items[0] == $val && $items[4] == $val && $items[8] == $val) flag = 1;
	if($items[6] == $val && $items[4] == $val && $items[2] == $val) flag = 1;
	return flag;
}

function isavailable(place) {
	if($items[place] == "") return 1;
	else return 0;
}

function ComputerMove($val) {
	var place = Math.floor((Math.random()*9));
	if($round == 1) { while(!isavailable(place)) place = Math.floor((Math.random()*9)); placeComputer(place); }
	else 
		if($round != 5) {
			var flag = 0;
			if($items[0] == $val && ($items[1] == $val || $items[3] == $val || $items[4] == $val)) {
				if($items[1] == $val && !flag && isavailable(2)) { placeComputer(2); flag = 1; }
				if($items[3] == $val && !flag && isavailable(6)) { placeComputer(6); flag = 1; }
				if($items[4] == $val && !flag && isavailable(8)) { placeComputer(8); flag = 1; }
			}
			if($items[1] == $val && ($items[2] == $val || $items[4] == $val)) {
				if($items[2] == $val && !flag && isavailable(0)) { placeComputer(0); flag = 1; }
				if($items[4] == $val && !flag && isavailable(7)) { placeComputer(7); flag = 1; }
			}
			if($items[2] == $val && ($items[5] == $val || $items[4] == $val)) {
				if($items[5] == $val && !flag && isavailable(8)) { placeComputer(8); flag = 1; }
				if($items[4] == $val && !flag && isavailable(6)) { placeComputer(6); flag = 1; }
			}
			if($items[3] == $val && ($items[6] == $val || $items[4] == $val)) {
				if($items[6] == $val && !flag && isavailable(0)) { placeComputer(0); flag = 1; }
				if($items[4] == $val && !flag && isavailable(5)) { placeComputer(5); flag = 1; }
			}
			if($items[4] == $val && ($items[5] == $val || $items[7] == $val)) {
				if($items[5] == $val && !flag && isavailable(3)) { placeComputer(3); flag = 1; }
				if($items[7] == $val && !flag && isavailable(1)) { placeComputer(1); flag = 1; }
			}
			if($items[5] == $val && $items[8] == $val) {
				if(isavailable(2) && !flag) { placeComputer(2); flag = 1; }
			}
			if($items[0] == $val && ($items[6] == $val || $items[8] == $val || $items[2] == $val)) {
				if($items[6] == $val && !flag && isavailable(3)) { placeComputer(3); flag = 1; }
				if($items[8] == $val && !flag && isavailable(4)) { placeComputer(4); flag = 1; }
				if($items[2] == $val && !flag && isavailable(1)) { placeComputer(1); flag = 1; }
			}
			if($items[2] == $val && ($items[6] == $val || $items[8] == $val)) {
				if($items[6] == $val && !flag && isavailable(3)) { placeComputer(3); flag = 1; }
				if($items[8] == $val && !flag && isavailable(5)) { placeComputer(5); flag = 1; }
			}
			if($items[6] == $val && $items[8] == $val) {
				if(isavailable(7) && !flag) { placeComputer(7); flag = 1; }
			}
			if(!flag && $val != "O")
				ComputerMove("O"); 
			if(!flag && $val == "O") {
				place = Math.floor((Math.random()*9));
				while(!isavailable(place)) place = Math.floor((Math.random()*9));
				placeComputer(place);
			}
			if(checkState("O")) { 
				$lost++;
				$("#new_game").show(); 
				$("#field").unbind("click"); 
				$("#lost_num").text($lost);
				window.localStorage.setItem("lost",$lost);
			} 	
		}
		else {
			if(checkState("X")) $won++;
			if(checkState("O")) $lost++;
			$("#new_game").show(); 
			$("#field").unbind("click");
			$("#won_num").text($won);
			$("#lost_num").text($lost);
			window.localStorage.setItem("won",$won);
			window.localStorage.setItem("lost",$lost);
		}		
}

function placeComputer(index) {
	switch(index) {
		case 0:{ $context.fillText("O",35,145); $items[index] = "O"; break; }
		case 1:{ $context.fillText("O",127,145); $items[index] = "O"; break; }
		case 2:{ $context.fillText("O",220,145); $items[index] = "O"; break; }
		case 3:{ $context.fillText("O",35,240); $items[index] = "O"; break; }
		case 4:{ $context.fillText("O",127,240); $items[index] = "O"; break; }
		case 5:{ $context.fillText("O",220,240); $items[index] = "O"; break; }
		case 6:{ $context.fillText("O",35,335); $items[index] = "O"; break; }
		case 7:{ $context.fillText("O",127,335); $items[index] = "O"; break; }
		case 8:{ $context.fillText("O",220,335); $items[index] = "O"; break; }
	}
} 

function triggerClick(field) {
	$context.font = "84px Arial";
	$context.fillStyle = "#242424";
	switch(field) {
		case 1:{ if($items[0] == "" && $items[0] != "O") { $context.fillText("X",40,145); $items[0] = "X"; $round++; } break; }
		case 2:{ if($items[1] == "" && $items[1] != "O") { $context.fillText("X",132,145); $items[1] = "X"; $round++; } break; }
		case 3:{ if($items[2] == "" && $items[2] != "O") { $context.fillText("X",225,145); $items[2] = "X"; $round++; } break; }
		case 4:{ if($items[3] == "" && $items[3] != "O") { $context.fillText("X",40,240); $items[3] = "X"; $round++; } break; }
		case 5:{ if($items[4] == "" && $items[4] != "O") { $context.fillText("X",132,240); $items[4] = "X"; $round++; } break; }
		case 6:{ if($items[5] == "" && $items[5] != "O") { $context.fillText("X",225,240); $items[5] = "X"; $round++; } break; }
		case 7:{ if($items[6] == "" && $items[6] != "O") { $context.fillText("X",40,335); $items[6] = "X"; $round++; } break; }
		case 8:{ if($items[7] == "" && $items[7] != "O") { $context.fillText("X",132,335); $items[7] = "X"; $round++; } break; }
		case 9:{ if($items[8] == "" && $items[8] != "O") { $context.fillText("X",225,335); $items[8] = "X"; $round++; } break; }
	}
	if(!checkState("X"))
		ComputerMove("X");
	else {
		$won++;
		$("#new_game").show();
		$("#field").unbind("click");
		$("#won_num").text($won);
		window.localStorage.setItem("won",$won);
	}
}

function getClick(params) {
	if(params.clientX > 25 && params.clientX < 115) {
		if(params.clientY > 75 && params.clientY < 165) triggerClick(1);
		if(params.clientY > 165 && params.clientY < 255) triggerClick(4);
		if(params.clientY > 255 && params.clientY < 345) triggerClick(7);
	}
	if(params.clientX > 115 && params.clientX < 205) {
		if(params.clientY > 75 && params.clientY < 165) triggerClick(2);
		if(params.clientY > 165 && params.clientY < 255) triggerClick(5);
		if(params.clientY > 255 && params.clientY < 345) triggerClick(8);
	}
	if(params.clientX > 205 && params.clientX < 295) {
		if(params.clientY > 75 && params.clientY < 165) triggerClick(3);
		if(params.clientY > 165 && params.clientY < 255) triggerClick(6);
		if(params.clientY > 255 && params.clientY < 345) triggerClick(9);
	}
}