var grid;
var time;
var wins;
var loses;
var grid_h;
var grid_w;
var load_grid;//if true load old grid

//-----------------------------------------------------------------------
function init()
{
 loadGameState();

 grid = new Array(grid_h);
 for (var i = 0; i < grid_h; i++) 
 {
  grid[i] = new Array(grid_w);
  for (var j = 0; j < grid_w; j++) 
   grid[i][j] = 0;
 }
 
 if(load_grid==1)
 {
  loadGrid();
  drawGrid();
 }
 
 time=0; 
 document.getElementById('scorer').innerHTML='Wins '+wins+' - Loses '+loses;
 window.setInterval(function(){timethis()}, 1000);//start timer func
}

//-----------------------------------------------------------------------
function count_empty_quads()//count empty quands on the grid
{
var empty = 0;
 for (var i = 0; i < grid_h; i++) 
 for (var j = 0; j < grid_w; j++) 
 {
  if(grid[i][j] == 0)
  empty++;
 }

 return(empty);
}

//-----------------------------------------------------------------------
function get_rand_empty_quad()//return a random empty quad
{
 var i= Math.floor((Math.random() * grid_h) );
 var j= Math.floor((Math.random() * grid_w) );

  if(grid[i][j] == 0)
   return{i:i,j:j};
 
  return(get_rand_empty_quad());   
}

//-----------------------------------------------------------------------
function check_wining(who)//check if you won ( 0 none / 1 you / 2 cpu)
{var c;

//per line
 for (var i = 0; i < grid_h; i++)
 {
  c = 0;
  for (var j = 0; j < grid_w; j++) 
  {
   if(grid[i][j] == who)
   c++;

   if(c==grid_w)
    return true; 
  }
 }
 
//per col
 for (var j = 0; j < grid_h; j++) 
 {
  c = 0;
  for (var i = 0; i < grid_w; i++) 
  {
   if(grid[i][j] == who)
   c++;
   
   if(c==grid_w)
    return true; 
  }
 }
 
 //diagonal 1
  c = 0;
  for (var i = 0; i < grid_w; i++) 
  {
   if(grid[i][i] == who)
   c++;
   
   if(c==grid_w)
    return true; 
  }
 
  //diagonal 2
  c = 0;
  for (var i = 0; i < grid_w; i++) 
  {
   if(grid[i][grid_w-i-1] == who)
   c++;
   
   if(c==grid_w)
    return true; 
  }
  
return false;
}
//-----------------------------------------------------------------------
function print_msg(msg)
{
document.body.innerHTML +='<div id="youwon"></div><div id="youwon_box"><p id="msg" class="font-size-0"></p><a href="game'+grid_w+'x'+grid_h+'.html"><p id="bt" class="font-size-0">Play again</p></a></div>';
document.getElementById('msg').innerHTML=msg;
}
//-----------------------------------------------------------------------
function circle_w(id)//player click
{
 var elem = document.getElementById(id);

 var d= id.substr(4);
 d = parseInt(d);
 var i = Math.floor(d/grid_w);
 var j = d%grid_w;
	
 if(grid[i][j] != 0)
 return;
 
 elem.innerHTML = "<div id='circlew'></div>";
 grid[i][j] = 1;	
 saveGrid();	 
	 	 
 if(check_wining(1))
 {
  print_msg('You win :)');
  wins++;
  saveGameState();
  clearGrid();
  return;
 }
	 
 cpu_click();
 saveGrid();
 
 if(check_wining(2))
 {
  print_msg('You lose :(');
  loses++;
  saveGameState();
  clearGrid();
  return;
 }	
   
 if(count_empty_quads()==0)
 {
  print_msg('Draw game');
  clearGrid();
  return;
 }
}

//-----------------------------------------------------------------------
function cpu_click()//emulate a cpu AI click
{
 var A = get_rand_empty_quad();//replace with AI

 if(grid[A.i][A.j] == 0)
 {
  grid[A.i][A.j] = 2;
  var elem = document.getElementById("quad"+(A.i*grid_w+A.j));
  if(typeof elem !== 'undefined' && elem !== null) 
  {
    elem.innerHTML = "<div id='circleb'></div>";
  }
 } 
}