//-----------------------------------------------------------------------
function find_empty_quad(type,r)
{
 for (var i = 0; i < grid_w; i++)
 {
 if(type==1)
  if(grid[r][i]==0)
  return(i);
  
  if(type==2)
  if(grid[i][r]==0)
  return(i);
 }
 return(-1);
}
//-----------------------------------------------------------------------
function find_empty_quad_lat(type)
{
 for (var i = 0; i < grid_h; i++)
 {
 if(type==1)//lat 1
 if(grid[i][i]==0)
 return(i);
 
 if(type==2)//lat 2
 if(grid[i][3-i]==0)
 return(i);
 }
 
 return(-1);
}
//-----------------------------------------------------------------------
function count_player_circles(player,type,r)
{
 var po=0;
 for (var i = 0; i < grid_w; i++)
 {
  if(type==1)//rows
  if(grid[r][i]==player)
  po++;

  if(type==2)//cols
  if(grid[i][r]==player)
  po++;
 }
 return(po);
}
//-----------------------------------------------------------------------
function count_player_circles_lat(player,type)
{
 var po=0;
 for (var i = 0; i < grid_h; i++)
 {
  if(type==1)
  if(grid[i][i]==player)
  po++;
  
  if(type==2)
  if(grid[i][3-i]==player)
  po++;
 }
 return(po);
}

//-----------------------------------------------------------------------
function cpu_play(i,j)
{
 if(grid[i][j] == 0)
 {
  var elem = document.getElementById("quad"+(i*grid_w+j));
  if(typeof elem !== 'undefined' && elem !== null)
  {
   elem.innerHTML = "<div id='circleb'></div>";
   grid[i][j] = 2;
   return(true);
  }
 }
 return(false);
}

//---------------------------------------------------------------------
function make_move(who)
{
var p;
var max = 3;//max critical aligned circles
  //count lines
  for (var i = 0; i < grid_h; i++)
  {
   if(count_player_circles(who,1,i)==max)
   {
    p = find_empty_quad(1,i);
	if(p>=0)
	{
     cpu_play(i,p)
     return(true);
	}
   }
  }

  //count cols
  for (var i = 0; i < grid_w; i++)
  {
   if(count_player_circles(who,2,i)==max)
   {
    p = find_empty_quad(2,i);
	if(p>=0)
	{
     cpu_play(p,i)
     return(true);
	}
   }
  }
  
  //lateral1
  if(count_player_circles_lat(who,1)==max)
  {
    p = find_empty_quad_lat(1); 
  	if(p>=0)
	{
     cpu_play(p,p);
     return(true);
	}
  }

  //lateral2
  if(count_player_circles_lat(who,2)==max)
  {
    p = find_empty_quad_lat(2); 
  	if(p>=0)
	{
     cpu_play(p,2-p);
     return(true);
	}
  }

return(false);
}

//-----------------------------------------------------------------------
function cpu_click()//emulate a cpu AI click
{
var human = 1;//human
var bot = 2;//the pc

//---------attack
if(make_move(bot))
return;

//---------defence
if(make_move(human))
return;

//---------go random
var A = get_rand_empty_quad();
cpu_play(A.i,A.j); 
}