var $hxClasses = $hxClasses || {},$estr = function() { return js.Boot.__string_rec(this,''); };
function $extend(from, fields) {
	function inherit() {}; inherit.prototype = from; var proto = new inherit();
	for (var name in fields) proto[name] = fields[name];
	return proto;
}
var EReg = $hxClasses["EReg"] = function(r,opt) {
	opt = opt.split("u").join("");
	this.r = new RegExp(r,opt);
};
EReg.__name__ = ["EReg"];
EReg.prototype = {
	customReplace: function(s,f) {
		var buf = new StringBuf();
		while(true) {
			if(!this.match(s)) break;
			buf.b += Std.string(this.matchedLeft());
			buf.b += Std.string(f(this));
			s = this.matchedRight();
		}
		buf.b += Std.string(s);
		return buf.b;
	}
	,replace: function(s,by) {
		return s.replace(this.r,by);
	}
	,split: function(s) {
		var d = "#__delim__#";
		return s.replace(this.r,d).split(d);
	}
	,matchedPos: function() {
		if(this.r.m == null) throw "No string matched";
		return { pos : this.r.m.index, len : this.r.m[0].length};
	}
	,matchedRight: function() {
		if(this.r.m == null) throw "No string matched";
		var sz = this.r.m.index + this.r.m[0].length;
		return this.r.s.substr(sz,this.r.s.length - sz);
	}
	,matchedLeft: function() {
		if(this.r.m == null) throw "No string matched";
		return this.r.s.substr(0,this.r.m.index);
	}
	,matched: function(n) {
		return this.r.m != null && n >= 0 && n < this.r.m.length?this.r.m[n]:(function($this) {
			var $r;
			throw "EReg::matched";
			return $r;
		}(this));
	}
	,match: function(s) {
		if(this.r.global) this.r.lastIndex = 0;
		this.r.m = this.r.exec(s);
		this.r.s = s;
		return this.r.m != null;
	}
	,r: null
	,__class__: EReg
}
var Hash = $hxClasses["Hash"] = function() {
	this.h = { };
};
Hash.__name__ = ["Hash"];
Hash.prototype = {
	toString: function() {
		var s = new StringBuf();
		s.b += Std.string("{");
		var it = this.keys();
		while( it.hasNext() ) {
			var i = it.next();
			s.b += Std.string(i);
			s.b += Std.string(" => ");
			s.b += Std.string(Std.string(this.get(i)));
			if(it.hasNext()) s.b += Std.string(", ");
		}
		s.b += Std.string("}");
		return s.b;
	}
	,iterator: function() {
		return { ref : this.h, it : this.keys(), hasNext : function() {
			return this.it.hasNext();
		}, next : function() {
			var i = this.it.next();
			return this.ref["$" + i];
		}};
	}
	,keys: function() {
		var a = [];
		for( var key in this.h ) {
		if(this.h.hasOwnProperty(key)) a.push(key.substr(1));
		}
		return HxOverrides.iter(a);
	}
	,remove: function(key) {
		key = "$" + key;
		if(!this.h.hasOwnProperty(key)) return false;
		delete(this.h[key]);
		return true;
	}
	,exists: function(key) {
		return this.h.hasOwnProperty("$" + key);
	}
	,get: function(key) {
		return this.h["$" + key];
	}
	,set: function(key,value) {
		this.h["$" + key] = value;
	}
	,h: null
	,__class__: Hash
}
var HxOverrides = $hxClasses["HxOverrides"] = function() { }
HxOverrides.__name__ = ["HxOverrides"];
HxOverrides.dateStr = function(date) {
	var m = date.getMonth() + 1;
	var d = date.getDate();
	var h = date.getHours();
	var mi = date.getMinutes();
	var s = date.getSeconds();
	return date.getFullYear() + "-" + (m < 10?"0" + m:"" + m) + "-" + (d < 10?"0" + d:"" + d) + " " + (h < 10?"0" + h:"" + h) + ":" + (mi < 10?"0" + mi:"" + mi) + ":" + (s < 10?"0" + s:"" + s);
}
HxOverrides.strDate = function(s) {
	switch(s.length) {
	case 8:
		var k = s.split(":");
		var d = new Date();
		d.setTime(0);
		d.setUTCHours(k[0]);
		d.setUTCMinutes(k[1]);
		d.setUTCSeconds(k[2]);
		return d;
	case 10:
		var k = s.split("-");
		return new Date(k[0],k[1] - 1,k[2],0,0,0);
	case 19:
		var k = s.split(" ");
		var y = k[0].split("-");
		var t = k[1].split(":");
		return new Date(y[0],y[1] - 1,y[2],t[0],t[1],t[2]);
	default:
		throw "Invalid date format : " + s;
	}
}
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) return undefined;
	return x;
}
HxOverrides.substr = function(s,pos,len) {
	if(pos != null && pos != 0 && len != null && len < 0) return "";
	if(len == null) len = s.length;
	if(pos < 0) {
		pos = s.length + pos;
		if(pos < 0) pos = 0;
	} else if(len < 0) len = s.length + len - pos;
	return s.substr(pos,len);
}
HxOverrides.remove = function(a,obj) {
	var i = 0;
	var l = a.length;
	while(i < l) {
		if(a[i] == obj) {
			a.splice(i,1);
			return true;
		}
		i++;
	}
	return false;
}
HxOverrides.iter = function(a) {
	return { cur : 0, arr : a, hasNext : function() {
		return this.cur < this.arr.length;
	}, next : function() {
		return this.arr[this.cur++];
	}};
}
var IntIter = $hxClasses["IntIter"] = function(min,max) {
	this.min = min;
	this.max = max;
};
IntIter.__name__ = ["IntIter"];
IntIter.prototype = {
	next: function() {
		return this.min++;
	}
	,hasNext: function() {
		return this.min < this.max;
	}
	,max: null
	,min: null
	,__class__: IntIter
}
var Lambda = $hxClasses["Lambda"] = function() { }
Lambda.__name__ = ["Lambda"];
Lambda.array = function(it) {
	var a = new Array();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var i = $it0.next();
		a.push(i);
	}
	return a;
}
Lambda.list = function(it) {
	var l = new List();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var i = $it0.next();
		l.add(i);
	}
	return l;
}
Lambda.map = function(it,f) {
	var l = new List();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		l.add(f(x));
	}
	return l;
}
Lambda.mapi = function(it,f) {
	var l = new List();
	var i = 0;
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		l.add(f(i++,x));
	}
	return l;
}
Lambda.has = function(it,elt,cmp) {
	if(cmp == null) {
		var $it0 = $iterator(it)();
		while( $it0.hasNext() ) {
			var x = $it0.next();
			if(x == elt) return true;
		}
	} else {
		var $it1 = $iterator(it)();
		while( $it1.hasNext() ) {
			var x = $it1.next();
			if(cmp(x,elt)) return true;
		}
	}
	return false;
}
Lambda.exists = function(it,f) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		if(f(x)) return true;
	}
	return false;
}
Lambda.foreach = function(it,f) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		if(!f(x)) return false;
	}
	return true;
}
Lambda.iter = function(it,f) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		f(x);
	}
}
Lambda.filter = function(it,f) {
	var l = new List();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		if(f(x)) l.add(x);
	}
	return l;
}
Lambda.fold = function(it,f,first) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		first = f(x,first);
	}
	return first;
}
Lambda.count = function(it,pred) {
	var n = 0;
	if(pred == null) {
		var $it0 = $iterator(it)();
		while( $it0.hasNext() ) {
			var _ = $it0.next();
			n++;
		}
	} else {
		var $it1 = $iterator(it)();
		while( $it1.hasNext() ) {
			var x = $it1.next();
			if(pred(x)) n++;
		}
	}
	return n;
}
Lambda.empty = function(it) {
	return !$iterator(it)().hasNext();
}
Lambda.indexOf = function(it,v) {
	var i = 0;
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var v2 = $it0.next();
		if(v == v2) return i;
		i++;
	}
	return -1;
}
Lambda.concat = function(a,b) {
	var l = new List();
	var $it0 = $iterator(a)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		l.add(x);
	}
	var $it1 = $iterator(b)();
	while( $it1.hasNext() ) {
		var x = $it1.next();
		l.add(x);
	}
	return l;
}
var List = $hxClasses["List"] = function() {
	this.length = 0;
};
List.__name__ = ["List"];
List.prototype = {
	map: function(f) {
		var b = new List();
		var l = this.h;
		while(l != null) {
			var v = l[0];
			l = l[1];
			b.add(f(v));
		}
		return b;
	}
	,filter: function(f) {
		var l2 = new List();
		var l = this.h;
		while(l != null) {
			var v = l[0];
			l = l[1];
			if(f(v)) l2.add(v);
		}
		return l2;
	}
	,join: function(sep) {
		var s = new StringBuf();
		var first = true;
		var l = this.h;
		while(l != null) {
			if(first) first = false; else s.b += Std.string(sep);
			s.b += Std.string(l[0]);
			l = l[1];
		}
		return s.b;
	}
	,toString: function() {
		var s = new StringBuf();
		var first = true;
		var l = this.h;
		s.b += Std.string("{");
		while(l != null) {
			if(first) first = false; else s.b += Std.string(", ");
			s.b += Std.string(Std.string(l[0]));
			l = l[1];
		}
		s.b += Std.string("}");
		return s.b;
	}
	,iterator: function() {
		return { h : this.h, hasNext : function() {
			return this.h != null;
		}, next : function() {
			if(this.h == null) return null;
			var x = this.h[0];
			this.h = this.h[1];
			return x;
		}};
	}
	,remove: function(v) {
		var prev = null;
		var l = this.h;
		while(l != null) {
			if(l[0] == v) {
				if(prev == null) this.h = l[1]; else prev[1] = l[1];
				if(this.q == l) this.q = prev;
				this.length--;
				return true;
			}
			prev = l;
			l = l[1];
		}
		return false;
	}
	,clear: function() {
		this.h = null;
		this.q = null;
		this.length = 0;
	}
	,isEmpty: function() {
		return this.h == null;
	}
	,pop: function() {
		if(this.h == null) return null;
		var x = this.h[0];
		this.h = this.h[1];
		if(this.h == null) this.q = null;
		this.length--;
		return x;
	}
	,last: function() {
		return this.q == null?null:this.q[0];
	}
	,first: function() {
		return this.h == null?null:this.h[0];
	}
	,push: function(item) {
		var x = [item,this.h];
		this.h = x;
		if(this.q == null) this.q = x;
		this.length++;
	}
	,add: function(item) {
		var x = [item];
		if(this.h == null) this.h = x; else this.q[1] = x;
		this.q = x;
		this.length++;
	}
	,length: null
	,q: null
	,h: null
	,__class__: List
}
var Reflect = $hxClasses["Reflect"] = function() { }
Reflect.__name__ = ["Reflect"];
Reflect.hasField = function(o,field) {
	return Object.prototype.hasOwnProperty.call(o,field);
}
Reflect.field = function(o,field) {
	var v = null;
	try {
		v = o[field];
	} catch( e ) {
	}
	return v;
}
Reflect.setField = function(o,field,value) {
	o[field] = value;
}
Reflect.getProperty = function(o,field) {
	var tmp;
	return o == null?null:o.__properties__ && (tmp = o.__properties__["get_" + field])?o[tmp]():o[field];
}
Reflect.setProperty = function(o,field,value) {
	var tmp;
	if(o.__properties__ && (tmp = o.__properties__["set_" + field])) o[tmp](value); else o[field] = value;
}
Reflect.callMethod = function(o,func,args) {
	return func.apply(o,args);
}
Reflect.fields = function(o) {
	var a = [];
	if(o != null) {
		var hasOwnProperty = Object.prototype.hasOwnProperty;
		for( var f in o ) {
		if(hasOwnProperty.call(o,f)) a.push(f);
		}
	}
	return a;
}
Reflect.isFunction = function(f) {
	return typeof(f) == "function" && !(f.__name__ || f.__ename__);
}
Reflect.compare = function(a,b) {
	return a == b?0:a > b?1:-1;
}
Reflect.compareMethods = function(f1,f2) {
	if(f1 == f2) return true;
	if(!Reflect.isFunction(f1) || !Reflect.isFunction(f2)) return false;
	return f1.scope == f2.scope && f1.method == f2.method && f1.method != null;
}
Reflect.isObject = function(v) {
	if(v == null) return false;
	var t = typeof(v);
	return t == "string" || t == "object" && !v.__enum__ || t == "function" && (v.__name__ || v.__ename__);
}
Reflect.deleteField = function(o,f) {
	if(!Reflect.hasField(o,f)) return false;
	delete(o[f]);
	return true;
}
Reflect.copy = function(o) {
	var o2 = { };
	var _g = 0, _g1 = Reflect.fields(o);
	while(_g < _g1.length) {
		var f = _g1[_g];
		++_g;
		o2[f] = Reflect.field(o,f);
	}
	return o2;
}
Reflect.makeVarArgs = function(f) {
	return function() {
		var a = Array.prototype.slice.call(arguments);
		return f(a);
	};
}
var Std = $hxClasses["Std"] = function() { }
Std.__name__ = ["Std"];
Std["is"] = function(v,t) {
	return js.Boot.__instanceof(v,t);
}
Std.string = function(s) {
	return js.Boot.__string_rec(s,"");
}
Std["int"] = function(x) {
	return x | 0;
}
Std.parseInt = function(x) {
	var v = parseInt(x,10);
	if(v == 0 && (HxOverrides.cca(x,1) == 120 || HxOverrides.cca(x,1) == 88)) v = parseInt(x);
	if(isNaN(v)) return null;
	return v;
}
Std.parseFloat = function(x) {
	return parseFloat(x);
}
Std.random = function(x) {
	return Math.floor(Math.random() * x);
}
var StringBuf = $hxClasses["StringBuf"] = function() {
	this.b = "";
};
StringBuf.__name__ = ["StringBuf"];
StringBuf.prototype = {
	toString: function() {
		return this.b;
	}
	,addSub: function(s,pos,len) {
		this.b += HxOverrides.substr(s,pos,len);
	}
	,addChar: function(c) {
		this.b += String.fromCharCode(c);
	}
	,add: function(x) {
		this.b += Std.string(x);
	}
	,b: null
	,__class__: StringBuf
}
var StringTools = $hxClasses["StringTools"] = function() { }
StringTools.__name__ = ["StringTools"];
StringTools.urlEncode = function(s) {
	return encodeURIComponent(s);
}
StringTools.urlDecode = function(s) {
	return decodeURIComponent(s.split("+").join(" "));
}
StringTools.htmlEscape = function(s) {
	return s.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;");
}
StringTools.htmlUnescape = function(s) {
	return s.split("&gt;").join(">").split("&lt;").join("<").split("&amp;").join("&");
}
StringTools.startsWith = function(s,start) {
	return s.length >= start.length && HxOverrides.substr(s,0,start.length) == start;
}
StringTools.endsWith = function(s,end) {
	var elen = end.length;
	var slen = s.length;
	return slen >= elen && HxOverrides.substr(s,slen - elen,elen) == end;
}
StringTools.isSpace = function(s,pos) {
	var c = HxOverrides.cca(s,pos);
	return c >= 9 && c <= 13 || c == 32;
}
StringTools.ltrim = function(s) {
	var l = s.length;
	var r = 0;
	while(r < l && StringTools.isSpace(s,r)) r++;
	if(r > 0) return HxOverrides.substr(s,r,l - r); else return s;
}
StringTools.rtrim = function(s) {
	var l = s.length;
	var r = 0;
	while(r < l && StringTools.isSpace(s,l - r - 1)) r++;
	if(r > 0) return HxOverrides.substr(s,0,l - r); else return s;
}
StringTools.trim = function(s) {
	return StringTools.ltrim(StringTools.rtrim(s));
}
StringTools.rpad = function(s,c,l) {
	var sl = s.length;
	var cl = c.length;
	while(sl < l) if(l - sl < cl) {
		s += HxOverrides.substr(c,0,l - sl);
		sl = l;
	} else {
		s += c;
		sl += cl;
	}
	return s;
}
StringTools.lpad = function(s,c,l) {
	var ns = "";
	var sl = s.length;
	if(sl >= l) return s;
	var cl = c.length;
	while(sl < l) if(l - sl < cl) {
		ns += HxOverrides.substr(c,0,l - sl);
		sl = l;
	} else {
		ns += c;
		sl += cl;
	}
	return ns + s;
}
StringTools.replace = function(s,sub,by) {
	return s.split(sub).join(by);
}
StringTools.hex = function(n,digits) {
	var s = "";
	var hexChars = "0123456789ABCDEF";
	do {
		s = hexChars.charAt(n & 15) + s;
		n >>>= 4;
	} while(n > 0);
	if(digits != null) while(s.length < digits) s = "0" + s;
	return s;
}
StringTools.fastCodeAt = function(s,index) {
	return s.charCodeAt(index);
}
StringTools.isEOF = function(c) {
	return c != c;
}
var ValueType = $hxClasses["ValueType"] = { __ename__ : ["ValueType"], __constructs__ : ["TNull","TInt","TFloat","TBool","TObject","TFunction","TClass","TEnum","TUnknown"] }
ValueType.TNull = ["TNull",0];
ValueType.TNull.toString = $estr;
ValueType.TNull.__enum__ = ValueType;
ValueType.TInt = ["TInt",1];
ValueType.TInt.toString = $estr;
ValueType.TInt.__enum__ = ValueType;
ValueType.TFloat = ["TFloat",2];
ValueType.TFloat.toString = $estr;
ValueType.TFloat.__enum__ = ValueType;
ValueType.TBool = ["TBool",3];
ValueType.TBool.toString = $estr;
ValueType.TBool.__enum__ = ValueType;
ValueType.TObject = ["TObject",4];
ValueType.TObject.toString = $estr;
ValueType.TObject.__enum__ = ValueType;
ValueType.TFunction = ["TFunction",5];
ValueType.TFunction.toString = $estr;
ValueType.TFunction.__enum__ = ValueType;
ValueType.TClass = function(c) { var $x = ["TClass",6,c]; $x.__enum__ = ValueType; $x.toString = $estr; return $x; }
ValueType.TEnum = function(e) { var $x = ["TEnum",7,e]; $x.__enum__ = ValueType; $x.toString = $estr; return $x; }
ValueType.TUnknown = ["TUnknown",8];
ValueType.TUnknown.toString = $estr;
ValueType.TUnknown.__enum__ = ValueType;
var Type = $hxClasses["Type"] = function() { }
Type.__name__ = ["Type"];
Type.getClass = function(o) {
	if(o == null) return null;
	return o.__class__;
}
Type.getEnum = function(o) {
	if(o == null) return null;
	return o.__enum__;
}
Type.getSuperClass = function(c) {
	return c.__super__;
}
Type.getClassName = function(c) {
	var a = c.__name__;
	return a.join(".");
}
Type.getEnumName = function(e) {
	var a = e.__ename__;
	return a.join(".");
}
Type.resolveClass = function(name) {
	var cl = $hxClasses[name];
	if(cl == null || !cl.__name__) return null;
	return cl;
}
Type.resolveEnum = function(name) {
	var e = $hxClasses[name];
	if(e == null || !e.__ename__) return null;
	return e;
}
Type.createInstance = function(cl,args) {
	switch(args.length) {
	case 0:
		return new cl();
	case 1:
		return new cl(args[0]);
	case 2:
		return new cl(args[0],args[1]);
	case 3:
		return new cl(args[0],args[1],args[2]);
	case 4:
		return new cl(args[0],args[1],args[2],args[3]);
	case 5:
		return new cl(args[0],args[1],args[2],args[3],args[4]);
	case 6:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5]);
	case 7:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6]);
	case 8:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7]);
	default:
		throw "Too many arguments";
	}
	return null;
}
Type.createEmptyInstance = function(cl) {
	function empty() {}; empty.prototype = cl.prototype;
	return new empty();
}
Type.createEnum = function(e,constr,params) {
	var f = Reflect.field(e,constr);
	if(f == null) throw "No such constructor " + constr;
	if(Reflect.isFunction(f)) {
		if(params == null) throw "Constructor " + constr + " need parameters";
		return f.apply(e,params);
	}
	if(params != null && params.length != 0) throw "Constructor " + constr + " does not need parameters";
	return f;
}
Type.createEnumIndex = function(e,index,params) {
	var c = e.__constructs__[index];
	if(c == null) throw index + " is not a valid enum constructor index";
	return Type.createEnum(e,c,params);
}
Type.getInstanceFields = function(c) {
	var a = [];
	for(var i in c.prototype) a.push(i);
	HxOverrides.remove(a,"__class__");
	HxOverrides.remove(a,"__properties__");
	return a;
}
Type.getClassFields = function(c) {
	var a = Reflect.fields(c);
	HxOverrides.remove(a,"__name__");
	HxOverrides.remove(a,"__interfaces__");
	HxOverrides.remove(a,"__properties__");
	HxOverrides.remove(a,"__super__");
	HxOverrides.remove(a,"prototype");
	return a;
}
Type.getEnumConstructs = function(e) {
	var a = e.__constructs__;
	return a.slice();
}
Type["typeof"] = function(v) {
	switch(typeof(v)) {
	case "boolean":
		return ValueType.TBool;
	case "string":
		return ValueType.TClass(String);
	case "number":
		if(Math.ceil(v) == v % 2147483648.0) return ValueType.TInt;
		return ValueType.TFloat;
	case "object":
		if(v == null) return ValueType.TNull;
		var e = v.__enum__;
		if(e != null) return ValueType.TEnum(e);
		var c = v.__class__;
		if(c != null) return ValueType.TClass(c);
		return ValueType.TObject;
	case "function":
		if(v.__name__ || v.__ename__) return ValueType.TObject;
		return ValueType.TFunction;
	case "undefined":
		return ValueType.TNull;
	default:
		return ValueType.TUnknown;
	}
}
Type.enumEq = function(a,b) {
	if(a == b) return true;
	try {
		if(a[0] != b[0]) return false;
		var _g1 = 2, _g = a.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(!Type.enumEq(a[i],b[i])) return false;
		}
		var e = a.__enum__;
		if(e != b.__enum__ || e == null) return false;
	} catch( e ) {
		return false;
	}
	return true;
}
Type.enumConstructor = function(e) {
	return e[0];
}
Type.enumParameters = function(e) {
	return e.slice(2);
}
Type.enumIndex = function(e) {
	return e[1];
}
Type.allEnums = function(e) {
	var all = [];
	var cst = e.__constructs__;
	var _g = 0;
	while(_g < cst.length) {
		var c = cst[_g];
		++_g;
		var v = Reflect.field(e,c);
		if(!Reflect.isFunction(v)) all.push(v);
	}
	return all;
}
var co = co || {}
if(!co.doubleduck) co.doubleduck = {}
co.doubleduck.BaseAssets = $hxClasses["co.doubleduck.BaseAssets"] = function() {
};
co.doubleduck.BaseAssets.__name__ = ["co","doubleduck","BaseAssets"];
co.doubleduck.BaseAssets._localizedAssets = null;
co.doubleduck.BaseAssets.loader = function() {
	if(co.doubleduck.BaseAssets._loader == null) {
		co.doubleduck.BaseAssets._loader = new createjs.LoadQueue(true);
		co.doubleduck.BaseAssets._loader.installPlugin(createjs.LoadQueue.SOUND);
		co.doubleduck.BaseAssets._loader.onFileLoad = co.doubleduck.BaseAssets.handleFileLoaded;
		co.doubleduck.BaseAssets._loader.onError = co.doubleduck.BaseAssets.handleLoadError;
		co.doubleduck.BaseAssets._loader.setMaxConnections(10);
	}
	return co.doubleduck.BaseAssets._loader;
}
co.doubleduck.BaseAssets.loadAndCall = function(uri,callbackFunc) {
	co.doubleduck.BaseAssets.loader().loadFile(uri);
	co.doubleduck.BaseAssets._loadCallbacks[uri] = callbackFunc;
}
co.doubleduck.BaseAssets.finishLoading = function(manifest,sounds) {
	if(co.doubleduck.SoundManager.available) {
		var _g1 = 0, _g = sounds.length;
		while(_g1 < _g) {
			var currSound = _g1++;
			manifest.push(sounds[currSound] + co.doubleduck.SoundManager.EXTENSION);
			co.doubleduck.SoundManager.initSound(sounds[currSound]);
		}
	}
	if(co.doubleduck.BaseAssets._useLocalStorage) co.doubleduck.BaseAssets.loadFromLocalStorage(manifest);
	if(manifest.length == 0) {
		if(co.doubleduck.BaseAssets.onLoadAll != null) co.doubleduck.BaseAssets.onLoadAll();
	}
	if(co.doubleduck.BaseGame.isLocalized && co.doubleduck.BaseAssets._localizedAssets != null) {
		var _g1 = 0, _g = manifest.length;
		while(_g1 < _g) {
			var itemIndex = _g1++;
			var currItem = manifest[itemIndex];
			currItem = co.doubleduck.BaseAssets.getLocalisedImage(currItem);
			manifest[itemIndex] = currItem;
		}
	}
	co.doubleduck.BaseAssets.loader().onProgress = co.doubleduck.BaseAssets.handleProgress;
	co.doubleduck.BaseAssets.loader().onFileLoad = co.doubleduck.BaseAssets.manifestFileLoad;
	co.doubleduck.BaseAssets.loader().loadManifest(manifest);
	co.doubleduck.BaseAssets.loader().load();
}
co.doubleduck.BaseAssets.loadAll = function(manifest,sounds) {
	manifest[manifest.length] = "images/duckling/orientation_error_port.png";
	manifest[manifest.length] = "images/duckling/orientation_error_land.png";
	manifest[manifest.length] = "images/duckling/page_marker.png";
}
co.doubleduck.BaseAssets.setLocalizedAssets = function(assets) {
	co.doubleduck.BaseAssets._localizedAssets = assets;
}
co.doubleduck.BaseAssets.audioLoaded = function(event) {
	co.doubleduck.BaseAssets._cacheData[event.item.src] = event;
}
co.doubleduck.BaseAssets.manifestFileLoad = function(event) {
	if(co.doubleduck.BaseAssets._useLocalStorage && event != null) {
		var utils = new ddjsutils();
		try {
			var fileName = event.item.src;
			if(HxOverrides.substr(fileName,fileName.length - 3,null) == "jpg") return;
			co.doubleduck.BasePersistence.setValue(event.item.src,utils.getBase64Image(event.result));
		} catch( err ) {
		}
	}
}
co.doubleduck.BaseAssets.loadFromLocalStorage = function(manifest) {
	var entriesToRemove = new Array();
	var _g1 = 0, _g = manifest.length;
	while(_g1 < _g) {
		var i = _g1++;
		var entry = manifest[i];
		var value = co.doubleduck.BasePersistence.getValue(entry);
		if(value != null) {
			var bmp = new createjs.Bitmap("data:image/png;base64," + value);
			co.doubleduck.BaseAssets._cacheData[entry] = bmp.image;
			entriesToRemove.push(manifest[i]);
		}
	}
	var _g1 = 0, _g = entriesToRemove.length;
	while(_g1 < _g) {
		var j = _g1++;
		HxOverrides.remove(manifest,entriesToRemove[j]);
	}
}
co.doubleduck.BaseAssets.handleProgress = function(event) {
	co.doubleduck.BaseAssets.loaded = event.loaded;
	if(event.loaded == event.total) {
		co.doubleduck.BaseAssets.loader().onProgress = null;
		co.doubleduck.BaseAssets.onLoadAll();
	}
}
co.doubleduck.BaseAssets.handleLoadError = function(event) {
}
co.doubleduck.BaseAssets.handleFileLoaded = function(event) {
	if(event != null) {
		co.doubleduck.BaseAssets._cacheData[event.item.src] = event.result;
		var callbackFunc = Reflect.field(co.doubleduck.BaseAssets._loadCallbacks,event.item.src);
		if(callbackFunc != null) callbackFunc();
	}
}
co.doubleduck.BaseAssets.getAsset = function(uri) {
	var cache = Reflect.field(co.doubleduck.BaseAssets._cacheData,uri);
	if(cache == null) {
		if(co.doubleduck.BaseAssets.loader().getResult(uri) != null) {
			cache = co.doubleduck.BaseAssets.loader().getResult(uri);
			co.doubleduck.BaseAssets._cacheData[uri] = cache;
		}
	}
	return cache;
}
co.doubleduck.BaseAssets.getLocalisedImage = function(image) {
	var currItem = image;
	if(co.doubleduck.BaseAssets._localizedAssets != null && Lambda.indexOf(co.doubleduck.BaseAssets._localizedAssets,currItem) != -1) {
		var delim = ".png";
		var delimIndex = currItem.indexOf(delim);
		var localisedItem = HxOverrides.substr(currItem,0,delimIndex);
		localisedItem += "-" + co.doubleduck.BaseGame.activeLocale + ".png";
		return localisedItem;
	}
	return currItem;
}
co.doubleduck.BaseAssets.getRawImage = function(uri) {
	uri = co.doubleduck.BaseAssets.getLocalisedImage(uri);
	var cache = co.doubleduck.BaseAssets.getAsset(uri);
	if(cache == null) {
		var bmp = new createjs.Bitmap(uri);
		co.doubleduck.BaseAssets._cacheData[uri] = bmp.image;
		cache = bmp.image;
		null;
	}
	return cache;
}
co.doubleduck.BaseAssets.getImage = function(uri,mouseEnabled) {
	if(mouseEnabled == null) mouseEnabled = false;
	var result = new createjs.Bitmap(co.doubleduck.BaseAssets.getRawImage(uri));
	result.mouseEnabled = mouseEnabled;
	return result;
}
co.doubleduck.BaseAssets.prototype = {
	__class__: co.doubleduck.BaseAssets
}
co.doubleduck.Assets = $hxClasses["co.doubleduck.Assets"] = function() {
	co.doubleduck.BaseAssets.call(this);
};
co.doubleduck.Assets.__name__ = ["co","doubleduck","Assets"];
co.doubleduck.Assets.loadAll = function() {
	var manifest = new Array();
	var sounds = new Array();
	co.doubleduck.BaseAssets.loadAll(manifest,sounds);
	var localisedAssets = [];
	sounds.push("sound/button");
	sounds.push("sound/letterSelect1");
	sounds.push("sound/letterSelect2");
	sounds.push("sound/lossMusic");
	sounds.push("sound/menuMusic");
	sounds.push("sound/victoryMusic");
	sounds.push("sound/volcanoErrupt");
	sounds.push("sound/wordAccepted");
	sounds.push("sound/wordRejected");
	manifest.push("images/menu/bg.png");
	manifest.push("images/menu/help.png");
	var _g1 = 0, _g = co.doubleduck.DataLoader.getInstance().getAllOpponents().length;
	while(_g1 < _g) {
		var i = _g1++;
		manifest.push("images/menu/opponents/opp" + (i + 1) + "_off.png");
		manifest.push("images/menu/opponents/opp" + (i + 1) + "_on.png");
		manifest.push("images/menu/opponents/opp" + (i + 1) + "_info.png");
		localisedAssets = localisedAssets.concat(["images/menu/opponents/opp" + (i + 1) + "_info.png"]);
	}
	manifest.push("images/menu/play.png");
	manifest.push("images/menu/right_arr.png");
	manifest.push("images/menu/sound.png");
	manifest.push("images/menu/help/gotit.png");
	manifest.push("images/menu/help/help_screen.png");
	manifest.push("images/menu/victories.png");
	manifest.push("images/menu/defeated.png");
	localisedAssets = localisedAssets.concat(["images/menu/defeated.png","images/menu/play.png","images/menu/victories.png","images/menu/help/gotit.png","images/menu/help/help_screen.png"]);
	var _g = 97;
	while(_g < 123) {
		var i = _g++;
		var $char = String.fromCharCode(i);
		manifest.push("images/session/letters/" + $char + ".png");
	}
	manifest.push("images/session/bg1.png");
	manifest.push("images/session/bg2.png");
	manifest.push("images/session/grass1.png");
	manifest.push("images/session/grass2.png");
	manifest.push("images/session/board.png");
	manifest.push("images/session/volcano.png");
	manifest.push("images/session/volcano_bg.png");
	manifest.push("images/session/lava.png");
	manifest.push("images/session/eruption2.png");
	manifest.push("images/session/eruption1.png");
	manifest.push("images/session/smoke_l.png");
	manifest.push("images/session/smoke_r.png");
	manifest.push("images/session/great.png");
	manifest.push("images/session/good.png");
	manifest.push("images/session/awesome.png");
	manifest.push("images/session/fantastic.png");
	manifest.push("images/session/again.png");
	manifest.push("images/session/x.png");
	localisedAssets = localisedAssets.concat(["images/session/great.png","images/session/good.png","images/session/awesome.png","images/session/fantastic.png","images/session/again.png"]);
	manifest.push("images/session/go.png");
	manifest.push("images/session/clear.png");
	manifest.push("images/session/shuffle.png");
	manifest.push("images/session/timer.png");
	manifest.push("images/session/score.png");
	manifest.push("images/session/quit.png");
	localisedAssets = localisedAssets.concat(["images/session/score.png","images/session/quit.png","images/session/go.png"]);
	var _g1 = 0, _g = co.doubleduck.DataLoader.getInstance().getAllOpponents().length;
	while(_g1 < _g) {
		var i = _g1++;
		manifest.push("images/session/avatars/" + (i + 1) + ".png");
	}
	manifest.push("images/session/finish/finish.png");
	manifest.push("images/session/finish/lose.png");
	manifest.push("images/session/finish/win.png");
	manifest.push("images/session/finish/menu.png");
	manifest.push("images/session/finish/next.png");
	manifest.push("images/session/finish/retry.png");
	manifest.push("images/endgame/endgame.png");
	localisedAssets = localisedAssets.concat(["images/endgame/endgame.png","images/session/finish/finish.png","images/session/finish/lose.png","images/session/finish/next.png","images/session/finish/win.png"]);
	manifest.push("images/splash/sky.png");
	manifest.push("images/splash/sky2.png");
	manifest.push("images/splash/sea.png");
	manifest.push("images/splash/sea2.png");
	manifest.push("images/splash/mountain.png");
	manifest.push("images/splash/mountain2.png");
	manifest.push("images/splash/island.png");
	manifest.push("images/splash/island2.png");
	manifest.push("images/splash/clouds.png");
	manifest.push("images/splash/smoke.png");
	manifest.push("images/splash/eruption.png");
	manifest.push("images/splash/t1.png");
	manifest.push("images/splash/t2.png");
	manifest.push("images/splash/e.png");
	manifest.push("images/splash/x.png");
	manifest.push("images/splash/logo.png");
	manifest.push("images/splash/tap.png");
	localisedAssets.push("images/splash/tap.png");
	var _g = 0;
	while(_g < 10) {
		var num = _g++;
		manifest.push("images/session/numbers/" + num + ".png");
		manifest.push("images/session/numbers_big/" + num + ".png");
	}
	manifest.push("images/session/numbers/comma.png");
	manifest.push("images/session/numbers_big/comma.png");
	co.doubleduck.BaseAssets.setLocalizedAssets(localisedAssets);
	co.doubleduck.BaseAssets.finishLoading(manifest,sounds);
}
co.doubleduck.Assets.__super__ = co.doubleduck.BaseAssets;
co.doubleduck.Assets.prototype = $extend(co.doubleduck.BaseAssets.prototype,{
	__class__: co.doubleduck.Assets
});
co.doubleduck.BaseGame = $hxClasses["co.doubleduck.BaseGame"] = function(stage) {
	this._waitingToStart = false;
	this._orientError = null;
	this._prevWinSize = new createjs.Rectangle(0,0,1,1);
	if(co.doubleduck.BaseGame._wantLandscape) {
		co.doubleduck.BaseGame.MAX_HEIGHT = 320;
		co.doubleduck.BaseGame.MAX_WIDTH = 570;
	} else {
		co.doubleduck.BaseGame.MAX_HEIGHT = 570;
		co.doubleduck.BaseGame.MAX_WIDTH = 320;
	}
	if(co.doubleduck.BaseGame.DEBUG) co.doubleduck.BasePersistence.clearAll();
	var isGS3Stock = /Android 4.0.4/.test(navigator.userAgent);
	isGS3Stock = isGS3Stock && /GT-I9300/.test(navigator.userAgent);
	isGS3Stock = isGS3Stock && !/Chrome/.test(navigator.userAgent);
	if(isGS3Stock) {
		var loc = window.location.href;
		if(loc.lastIndexOf("index.html") != -1) loc = HxOverrides.substr(loc,0,loc.lastIndexOf("index.html"));
		loc += "error.html";
		window.location.href=loc;
		return;
	}
	co.doubleduck.Persistence.initGameData();
	co.doubleduck.BaseGame._stage = stage;
	co.doubleduck.BaseGame._stage.onTick = $bind(this,this.handleStageTick);
	co.doubleduck.BaseGame._viewport = new createjs.Rectangle(0,0,1,1);
	co.doubleduck.BaseGame.hammer = new Hammer(js.Lib.document.getElementById("stageCanvas"));
	viewporter.preventPageScroll = true;
	viewporter.change($bind(this,this.handleViewportChanged));
	if(viewporter.ACTIVE) {
		viewporter.preventPageScroll = true;
		viewporter.change($bind(this,this.handleViewportChanged));
		if(co.doubleduck.BaseGame._wantLandscape != viewporter.isLandscape()) {
			if(co.doubleduck.BaseGame._wantLandscape) co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.ORIENT_LAND_URI,$bind(this,this.waitForOrientation)); else co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.ORIENT_PORT_URI,$bind(this,this.waitForOrientation));
		} else co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOGO_URI,$bind(this,this.loadBarFill));
	} else co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOGO_URI,$bind(this,this.loadBarFill));
};
co.doubleduck.BaseGame.__name__ = ["co","doubleduck","BaseGame"];
co.doubleduck.BaseGame._stage = null;
co.doubleduck.BaseGame._wantLandscape = null;
co.doubleduck.BaseGame.MAX_HEIGHT = null;
co.doubleduck.BaseGame.MAX_WIDTH = null;
co.doubleduck.BaseGame.activeLocale = null;
co.doubleduck.BaseGame.availableLocales = null;
co.doubleduck.BaseGame.defaultLocale = null;
co.doubleduck.BaseGame.hammer = null;
co.doubleduck.BaseGame.getViewport = function() {
	return co.doubleduck.BaseGame._viewport;
}
co.doubleduck.BaseGame.getScreenSize = function() {
	if(co.doubleduck.BaseGame._wantLandscape) return new createjs.Rectangle(0,0,Math.floor(co.doubleduck.BaseGame._viewport.width / co.doubleduck.BaseGame._scale),co.doubleduck.BaseGame.MAX_HEIGHT); else return new createjs.Rectangle(0,0,co.doubleduck.BaseGame.MAX_WIDTH,Math.floor(co.doubleduck.BaseGame._viewport.height / co.doubleduck.BaseGame._scale));
}
co.doubleduck.BaseGame.getScale = function() {
	return co.doubleduck.BaseGame._scale;
}
co.doubleduck.BaseGame.getStage = function() {
	return co.doubleduck.BaseGame._stage;
}
co.doubleduck.BaseGame.prototype = {
	setScale: function() {
		var fixedVal = co.doubleduck.BaseGame._viewport.width;
		var varVal = co.doubleduck.BaseGame._viewport.height;
		var idealFixed = co.doubleduck.BaseGame.MAX_WIDTH;
		var idealVar = co.doubleduck.BaseGame.MAX_HEIGHT;
		if(co.doubleduck.BaseGame._wantLandscape) {
			fixedVal = co.doubleduck.BaseGame._viewport.height;
			varVal = co.doubleduck.BaseGame._viewport.width;
			idealFixed = co.doubleduck.BaseGame.MAX_HEIGHT;
			idealVar = co.doubleduck.BaseGame.MAX_WIDTH;
		}
		var regScale = varVal / idealVar;
		if(fixedVal >= varVal) co.doubleduck.BaseGame._scale = regScale; else if(idealFixed * regScale < fixedVal) co.doubleduck.BaseGame._scale = fixedVal / idealFixed; else co.doubleduck.BaseGame._scale = regScale;
	}
	,handleViewportChanged: function() {
		if(co.doubleduck.BaseGame._wantLandscape != viewporter.isLandscape()) {
			if(this._orientError == null) {
				var err = co.doubleduck.BaseGame.ORIENT_PORT_URI;
				if(co.doubleduck.BaseGame._wantLandscape) err = co.doubleduck.BaseGame.ORIENT_LAND_URI;
				this._orientError = co.doubleduck.BaseAssets.getImage(err);
				this._orientError.regX = this._orientError.image.width / 2;
				this._orientError.regY = this._orientError.image.height / 2;
				this._orientError.x = co.doubleduck.BaseGame._viewport.height / 2;
				this._orientError.y = co.doubleduck.BaseGame._viewport.width / 2;
				co.doubleduck.BaseGame._stage.addChildAt(this._orientError,co.doubleduck.BaseGame._stage.getNumChildren());
				co.doubleduck.BaseGame._stage.update();
			}
		} else if(this._orientError != null) {
			co.doubleduck.BaseGame._stage.removeChild(this._orientError);
			this._orientError = null;
			if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame._stage.update();
			if(this._waitingToStart) {
				this._waitingToStart = false;
				co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOGO_URI,$bind(this,this.loadBarFill));
			}
		}
	}
	,focused: function() {
		co.doubleduck.SoundManager.unmute();
	}
	,blured: function(e) {
		co.doubleduck.SoundManager.mute();
	}
	,handleResize: function(e) {
		var isFirefox = /Firefox/.test(navigator.userAgent);
		var isAndroid = /Android/.test(navigator.userAgent);
		var screenW = js.Lib.window.innerWidth;
		var screenH = js.Lib.window.innerHeight;
		co.doubleduck.BaseGame._stage.canvas.width = screenW;
		co.doubleduck.BaseGame._stage.canvas.height = screenH;
		var shouldResize = co.doubleduck.BaseGame._wantLandscape == viewporter.isLandscape() || !viewporter.ACTIVE;
		if(shouldResize) {
			if(isFirefox) {
				screenH = Math.floor(co.doubleduck.Main.getFFHeight());
				var ffEstimate = Math.ceil((js.Lib.window.screen.height - 110) * (screenW / js.Lib.window.screen.width));
				if(!isAndroid) ffEstimate = Math.ceil(js.Lib.window.screen.height * (screenW / js.Lib.window.screen.width));
				if(ffEstimate < screenH) screenH = Math.floor(ffEstimate);
			}
			var wrongSize = screenH < screenW;
			if(co.doubleduck.BaseGame._wantLandscape) wrongSize = screenH > screenW;
			if(!viewporter.ACTIVE || !wrongSize) {
				co.doubleduck.BaseGame._viewport.width = screenW;
				co.doubleduck.BaseGame._viewport.height = screenH;
				this.setScale();
			}
			if(this._orientError != null && isFirefox) this.handleViewportChanged();
		} else if(isFirefox) this.handleViewportChanged();
		if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame._stage.update();
	}
	,handleBackToMenu: function() {
		this._session.destroy();
		co.doubleduck.BaseGame._stage.removeChild(this._session);
		this._session = null;
		this._menu = new co.doubleduck.Menu();
		co.doubleduck.BaseGame._stage.addChildAt(this._menu,0);
		this._menu.onPlayClick = $bind(this,this.handlePlayClick);
	}
	,handleRestart: function(properties) {
		this._session.destroy();
		co.doubleduck.BaseGame._stage.removeChild(this._session);
		this._session = null;
		this.startSession(properties);
	}
	,handleSessionEnd: function() {
	}
	,handlePlayClick: function(properties) {
		co.doubleduck.BaseGame._stage.removeChild(this._menu);
		this.startSession(properties);
		this._menu.destroy();
		this._menu = null;
	}
	,startSession: function(properties) {
		this._session = new co.doubleduck.Session(properties);
		this._session.onBackToMenu = $bind(this,this.handleBackToMenu);
		this._session.onRestart = $bind(this,this.handleRestart);
		this._session.onSessionEnd = $bind(this,this.handleSessionEnd);
		co.doubleduck.BaseGame._stage.addChild(this._session);
	}
	,showMenu: function() {
		this._menu = new co.doubleduck.Menu();
		co.doubleduck.BaseGame._stage.addChildAt(this._menu,0);
		this._menu.onPlayClick = $bind(this,this.handlePlayClick);
	}
	,alphaFade: function(fadeElement) {
		if(fadeElement != null && js.Boot.__instanceof(fadeElement,createjs.Bitmap)) this._fadedText = fadeElement; else if(this._fadedText == null) return;
		if(this._fadedText.alpha == 0) createjs.Tween.get(this._fadedText).to({ alpha : 1},750).call($bind(this,this.alphaFade)); else if(this._fadedText.alpha == 1) createjs.Tween.get(this._fadedText).to({ alpha : 0},1500).call($bind(this,this.alphaFade));
	}
	,showGameSplash: function() {
	}
	,splashEnded: function() {
		js.Lib.document.body.bgColor = "#000000";
		co.doubleduck.BaseGame._stage.removeChild(this._splash);
		this._splash = null;
		js.Lib.window.onresize = $bind(this,this.handleResize);
		this.handleResize(null);
		this.showGameSplash();
	}
	,handleDoneLoading: function() {
		createjs.Tween.get(this._splash).wait(200).to({ alpha : 0},800).call($bind(this,this.splashEnded));
		co.doubleduck.BaseGame._stage.removeChild(this._loadingBar);
		co.doubleduck.BaseGame._stage.removeChild(this._loadingStroke);
	}
	,updateLoading: function() {
		if(co.doubleduck.BaseAssets.loaded != 1) {
			this._loadingBar.visible = true;
			var percent = co.doubleduck.BaseAssets.loaded;
			var barMask = new createjs.Shape();
			barMask.graphics.beginFill("#00000000");
			barMask.graphics.drawRect(this._loadingBar.x - this._loadingBar.image.width / 2,this._loadingBar.y,this._loadingBar.image.width * percent | 0,this._loadingBar.image.height);
			barMask.graphics.endFill();
			this._loadingBar.mask = barMask;
			co.doubleduck.Utils.waitAndCall(this,10,$bind(this,this.updateLoading));
		}
	}
	,exitFocus: function() {
		var hidden = document.mozHidden;
		if(hidden) co.doubleduck.SoundManager.mute(false); else if(!co.doubleduck.SoundManager.getPersistedMute()) co.doubleduck.SoundManager.unmute(false);
	}
	,showSplash: function() {
		if(viewporter.ACTIVE) js.Lib.document.body.bgColor = "#00A99D"; else js.Lib.document.body.bgColor = "#D94D00";
		this._splash = co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.LOGO_URI);
		this._splash.regX = this._splash.image.width / 2;
		this._splash.x = js.Lib.window.innerWidth / 2;
		if(co.doubleduck.BaseGame._wantLandscape) this._splash.y = 20; else this._splash.y = 90;
		co.doubleduck.BaseGame._stage.addChild(this._splash);
		this._loadingStroke = co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.LOAD_STROKE_URI);
		this._loadingStroke.regX = this._loadingStroke.image.width / 2;
		co.doubleduck.BaseGame._stage.addChildAt(this._loadingStroke,0);
		this._loadingBar = co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.LOAD_FILL_URI);
		this._loadingBar.regX = this._loadingBar.image.width / 2;
		co.doubleduck.BaseGame._stage.addChildAt(this._loadingBar,1);
		this._loadingBar.x = js.Lib.window.innerWidth / 2;
		this._loadingBar.y = this._splash.y + 192;
		this._loadingStroke.x = this._loadingBar.x;
		this._loadingStroke.y = this._loadingBar.y;
		this._loadingBar.visible = false;
		this.updateLoading();
		co.doubleduck.BaseGame._stage.canvas.width = js.Lib.window.innerWidth;
		co.doubleduck.BaseGame._stage.canvas.height = js.Lib.window.innerHeight;
		co.doubleduck.BaseAssets.onLoadAll = $bind(this,this.handleDoneLoading);
		co.doubleduck.Assets.loadAll();
	}
	,loadLocale: function() {
		if(co.doubleduck.BaseGame.isLocalized) {
			var lang = navigator.language;
			lang = HxOverrides.substr(lang.toLowerCase(),0,2);
			if(co.doubleduck.BaseGame.availableLocales != null && co.doubleduck.BaseGame.availableLocales.length > 0) {
				if(Lambda.indexOf(co.doubleduck.BaseGame.availableLocales,lang) != -1) {
					co.doubleduck.BaseGame.activeLocale = lang;
					this.showSplash();
					return;
				} else {
					co.doubleduck.BaseGame.activeLocale = co.doubleduck.BaseGame.defaultLocale;
					this.showSplash();
					return;
				}
			} else {
				co.doubleduck.BaseGame.activeLocale = co.doubleduck.BaseGame.defaultLocale;
				if(co.doubleduck.BaseGame.defaultLocale == null) throw "DDException: default locale not set";
			}
		}
		this.showSplash();
	}
	,waitForOrientation: function() {
		this._waitingToStart = true;
		if(this._orientError == null) {
			this._orientError = this.getErrorImage();
			this._orientError.regX = this._orientError.image.width / 2;
			this._orientError.regY = this._orientError.image.height / 2;
			this._orientError.x = js.Lib.window.innerWidth / 2;
			this._orientError.y = js.Lib.window.innerHeight / 2;
			co.doubleduck.BaseGame._stage.addChildAt(this._orientError,co.doubleduck.BaseGame._stage.getNumChildren());
		}
	}
	,getErrorImage: function() {
		if(co.doubleduck.BaseGame._wantLandscape) return co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.ORIENT_LAND_URI); else return co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.ORIENT_PORT_URI);
	}
	,loadBarStroke: function() {
		co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOAD_STROKE_URI,$bind(this,this.loadLocale));
	}
	,loadBarFill: function() {
		co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOAD_FILL_URI,$bind(this,this.loadBarStroke));
	}
	,handleStageTick: function() {
		if(js.Lib.window.innerWidth != this._prevWinSize.width || js.Lib.window.innerHeight != this._prevWinSize.height) {
			this._prevWinSize.width = js.Lib.window.innerWidth;
			this._prevWinSize.height = js.Lib.window.innerHeight;
			this.handleResize(null);
		}
	}
	,_prevWinSize: null
	,_fadedText: null
	,_loadingStroke: null
	,_loadingBar: null
	,_waitingToStart: null
	,_orientError: null
	,_session: null
	,_menu: null
	,_splash: null
	,__class__: co.doubleduck.BaseGame
}
co.doubleduck.BaseMenu = $hxClasses["co.doubleduck.BaseMenu"] = function() {
	createjs.Container.call(this);
};
co.doubleduck.BaseMenu.__name__ = ["co","doubleduck","BaseMenu"];
co.doubleduck.BaseMenu.__super__ = createjs.Container;
co.doubleduck.BaseMenu.prototype = $extend(createjs.Container.prototype,{
	destroy: function() {
		this.onPlayClick = null;
	}
	,onPlayClick: null
	,__class__: co.doubleduck.BaseMenu
});
co.doubleduck.BasePersistence = $hxClasses["co.doubleduck.BasePersistence"] = function() { }
co.doubleduck.BasePersistence.__name__ = ["co","doubleduck","BasePersistence"];
co.doubleduck.BasePersistence.localStorageSupported = function() {
	var result = null;
	try {
		localStorage.setItem("test","test");
		localStorage.removeItem("test");
		result = true;
	} catch( e ) {
		result = false;
	}
	return result;
}
co.doubleduck.BasePersistence.getValue = function(key) {
	if(!co.doubleduck.BasePersistence.available) return "0";
	var val = localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key];
	return val;
}
co.doubleduck.BasePersistence.setValue = function(key,value) {
	if(!co.doubleduck.BasePersistence.available) return;
	localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key] = value;
}
co.doubleduck.BasePersistence.clearAll = function() {
	if(!co.doubleduck.BasePersistence.available) return;
	localStorage.clear();
}
co.doubleduck.BasePersistence.initVar = function(initedVar,defaultVal) {
	if(defaultVal == null) defaultVal = "0";
	var value = co.doubleduck.BasePersistence.getValue(initedVar);
	if(value == null) try {
		co.doubleduck.BasePersistence.setValue(initedVar,defaultVal);
	} catch( e ) {
		co.doubleduck.BasePersistence.available = false;
	}
}
co.doubleduck.BasePersistence.getDynamicValue = function(key) {
	if(!co.doubleduck.BasePersistence.available) return { };
	var val = localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key];
	return val;
}
co.doubleduck.BasePersistence.setDynamicValue = function(key,value) {
	if(!co.doubleduck.BasePersistence.available) return;
	localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key] = value;
}
co.doubleduck.BasePersistence.initDynamicVar = function(initedVar,defaultVal) {
	var value = co.doubleduck.BasePersistence.getDynamicValue(initedVar);
	if(value == null) try {
		co.doubleduck.BasePersistence.setDynamicValue(initedVar,defaultVal);
	} catch( e ) {
		co.doubleduck.BasePersistence.available = false;
	}
}
co.doubleduck.BasePersistence.printAll = function() {
	var ls = localStorage;
	var localStorageLength = ls.length;
	var _g = 0;
	while(_g < localStorageLength) {
		var entry = _g++;
		null;
	}
}
co.doubleduck.BaseSession = $hxClasses["co.doubleduck.BaseSession"] = function() {
	createjs.Container.call(this);
};
co.doubleduck.BaseSession.__name__ = ["co","doubleduck","BaseSession"];
co.doubleduck.BaseSession.__super__ = createjs.Container;
co.doubleduck.BaseSession.prototype = $extend(createjs.Container.prototype,{
	destroy: function() {
		createjs.Ticker.removeListener(this);
		this.onRestart = null;
		this.onBackToMenu = null;
		this.onSessionEnd = null;
		this.onNextLevel = null;
	}
	,sessionEnded: function() {
		if(this.onSessionEnd != null) {
			createjs.Ticker.setPaused(false);
			this.onSessionEnd();
		}
	}
	,handleReplayClick: function(properties) {
		if(this.onRestart != null) {
			createjs.Ticker.setPaused(false);
			this.onRestart(properties);
		}
	}
	,handleMenuClick: function() {
		if(this.onBackToMenu != null) {
			createjs.Ticker.setPaused(false);
			this.onBackToMenu();
		}
	}
	,_replayBtn: null
	,_menuBtn: null
	,onNextLevel: null
	,onBackToMenu: null
	,onSessionEnd: null
	,onRestart: null
	,__class__: co.doubleduck.BaseSession
});
co.doubleduck.LabeledContainer = $hxClasses["co.doubleduck.LabeledContainer"] = function(bmp) {
	createjs.Container.call(this);
	this._bitmap = bmp;
	if(this._bitmap != null) {
		if(js.Boot.__instanceof(this._bitmap,createjs.Bitmap)) {
			this._bmp = this._bitmap;
			this.image = this._bmp.image;
		} else if(js.Boot.__instanceof(this._bitmap,createjs.BitmapAnimation)) {
			this.anim = this._bitmap;
			this.image = { width : this.anim.spriteSheet._frameWidth, height : this.anim.spriteSheet._frameHeight};
		}
	}
};
co.doubleduck.LabeledContainer.__name__ = ["co","doubleduck","LabeledContainer"];
co.doubleduck.LabeledContainer.__super__ = createjs.Container;
co.doubleduck.LabeledContainer.prototype = $extend(createjs.Container.prototype,{
	getLabel: function() {
		return this._label;
	}
	,addBitmap: function() {
		this.addChild(this._bitmap);
	}
	,addCenteredBitmap: function() {
		this._bitmap.regX = this.image.width / 2;
		this._bitmap.regY = this.image.height / 2;
		this._bitmap.x = this.image.width / 2;
		this._bitmap.y = this.image.height / 2;
		this.addChild(this._bitmap);
	}
	,addBitmapLabel: function(label,fontType,padding,centered) {
		if(centered == null) centered = true;
		if(padding == null) padding = 0;
		if(fontType == null) fontType = "";
		if(this._bitmapText != null) this.removeChild(this._bitmapText);
		var fontHelper = new co.doubleduck.FontHelper(fontType);
		this._bitmapText = fontHelper.getNumber(Std.parseInt(label),1,true,null,padding,centered);
		if(this.image != null) {
			this._bitmapText.x = this.image.width / 2;
			this._bitmapText.y = this.image.height / 2;
		}
		this._label = label;
		this.addChild(this._bitmapText);
	}
	,scaleBitmapFont: function(scale) {
		this._bitmapText.scaleX = this._bitmapText.scaleY = scale;
	}
	,shiftLabel: function(shiftX,shiftY) {
		this._bitmapText.x *= shiftX;
		this._bitmapText.y *= shiftY;
	}
	,setBitmapLabelY: function(ly) {
		this._bitmapText.y = ly;
	}
	,setBitmapLabelX: function(lx) {
		this._bitmapText.x = lx;
	}
	,getBitmapLabelWidth: function() {
		var maxWidth = 0;
		var _g1 = 0, _g = this._bitmapText.getNumChildren();
		while(_g1 < _g) {
			var digit = _g1++;
			var currentDigit = js.Boot.__cast(this._bitmapText.getChildAt(digit) , createjs.Bitmap);
			var endsAt = currentDigit.x + currentDigit.image.width;
			if(endsAt > maxWidth) maxWidth = endsAt;
		}
		return maxWidth;
	}
	,setLabelY: function(ly) {
		this._text.y = ly;
	}
	,setLabelX: function(lx) {
		this._text.x = lx;
	}
	,addLabel: function(label,color) {
		if(color == null) color = "#000000";
		if(this._text != null) this.removeChild(this._text);
		this._label = label;
		this._text = new createjs.Text(label,"bold 22px Arial",color);
		this._text.regY = this._text.getMeasuredHeight() / 2;
		this._text.textAlign = "center";
		if(this._bitmap != null) {
			this._text.x = this._bitmap.x;
			this._text.y = this._bitmap.y;
		}
		this.addChild(this._text);
	}
	,changeText: function(txt) {
	}
	,_bitmapText: null
	,_text: null
	,_bmp: null
	,_bitmap: null
	,_label: null
	,anim: null
	,image: null
	,__class__: co.doubleduck.LabeledContainer
});
co.doubleduck.Button = $hxClasses["co.doubleduck.Button"] = function(bmp,pauseAffected,clickType,clickSound) {
	if(clickType == null) clickType = 2;
	if(pauseAffected == null) pauseAffected = true;
	this._lastClickTime = 0;
	co.doubleduck.LabeledContainer.call(this,bmp);
	if(clickSound == null && co.doubleduck.Button._defaultSound != null) this._clickSound = co.doubleduck.Button._defaultSound; else this._clickSound = clickSound;
	this._bitmap.mouseEnabled = true;
	this._clickType = clickType;
	this._pauseAffected = pauseAffected;
	if(clickType == co.doubleduck.Button.CLICK_TYPE_TOGGLE) {
		var initObject = { };
		var size = this.image.width / 2;
		initObject.images = [this.image];
		initObject.frames = { width : size, height : this.image.height, regX : size / 2, regY : this.image.height / 2};
		this._states = new createjs.BitmapAnimation(new createjs.SpriteSheet(initObject));
		this._states.gotoAndStop(0);
		this.onClick = $bind(this,this.handleToggle);
		this.addChild(this._states);
	} else this.addCenteredBitmap();
	this.onPress = $bind(this,this.handlePress);
};
co.doubleduck.Button.__name__ = ["co","doubleduck","Button"];
co.doubleduck.Button.setDefaultSound = function(sound) {
	co.doubleduck.Button._defaultSound = sound;
}
co.doubleduck.Button.__super__ = co.doubleduck.LabeledContainer;
co.doubleduck.Button.prototype = $extend(co.doubleduck.LabeledContainer.prototype,{
	handleEndPressTint: function() {
		co.doubleduck.Utils.tintBitmap(this._bmp,1,1,1,1);
		if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame.getStage().update();
	}
	,setToggle: function(flag) {
		if(flag) this._states.gotoAndStop(0); else this._states.gotoAndStop(1);
	}
	,handleToggle: function(e) {
		if(this.onToggle == null) return;
		if(this._lastClickPos == null) this._lastClickPos = new createjs.Point(0,0);
		if((this._lastClickPos.x < e.stageX + 1 || this._lastClickPos.x > e.stageX + 1) && (this._lastClickPos.y < e.stageY + 1 || this._lastClickPos.y > e.stageY + 1)) {
			var now = createjs.Ticker.getTime(true);
			if(now < this._lastClickTime + 500) return;
		}
		this._lastClickPos.x = e.stageX;
		this._lastClickPos.y = e.stageY;
		this._lastClickTime = createjs.Ticker.getTime(true);
		this._states.gotoAndStop(1 - this._states.currentFrame);
		this.onToggle();
	}
	,handlePress: function(event) {
		if(createjs.Ticker.getPaused() && this._pauseAffected) return;
		if(this._clickType == co.doubleduck.Button.CLICK_TYPE_HOLD) {
			if(this.onHoldStart != null) {
				this.onHoldStart();
				event.onMouseUp = this.onHoldFinish;
			}
		}
		if(this.onClick != null) {
			if(this._clickSound != null) co.doubleduck.SoundManager.playEffect(this._clickSound);
			switch(this._clickType) {
			case co.doubleduck.Button.CLICK_TYPE_TINT:
				if(this._bmp != null) {
					co.doubleduck.Utils.tintBitmap(this._bmp,0.55,0.55,0.55,1);
					var tween = createjs.Tween.get(this._bmp);
					tween.ignoreGlobalPause = true;
					tween.wait(200).call($bind(this,this.handleEndPressTint));
					if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame.getStage().update();
				}
				break;
			case co.doubleduck.Button.CLICK_TYPE_JUICY:
				this._juiceTween = createjs.Tween.get(this._bitmap);
				this._juiceTween.ignoreGlobalPause = true;
				var startScaleX = this._bitmap.scaleX;
				var startScaleY = this._bitmap.scaleY;
				this._bitmap.scaleX = startScaleX * 1.25;
				this._bitmap.scaleY = startScaleY * 0.75;
				this._juiceTween.to({ scaleX : startScaleX, scaleY : startScaleY},500,createjs.Ease.elasticOut);
				break;
			case co.doubleduck.Button.CLICK_TYPE_SCALE:
				this._juiceTween = createjs.Tween.get(this._bitmap);
				this._juiceTween.ignoreGlobalPause = true;
				var startScaleX = this._bitmap.scaleX;
				var startScaleY = this._bitmap.scaleY;
				this._bitmap.scaleX = startScaleX * 1.18;
				this._bitmap.scaleY = startScaleY * 1.18;
				this._juiceTween.to({ scaleX : startScaleX, scaleY : startScaleY},200,createjs.Ease.elasticOut);
				break;
			case co.doubleduck.Button.CLICK_TYPE_TOGGLE:
				break;
			case co.doubleduck.Button.CLICK_TYPE_NONE:
				break;
			case co.doubleduck.Button.CLICK_TYPE_HOLD:
				throw "Use onHoldStart with CLICK_TYPE_HOLD, not onClick";
				break;
			}
		}
	}
	,setNoSound: function() {
		this._clickSound = null;
	}
	,_lastClickPos: null
	,_lastClickTime: null
	,_clickSound: null
	,_juiceTween: null
	,_clickType: null
	,_pauseAffected: null
	,_states: null
	,onHoldFinish: null
	,onHoldStart: null
	,onToggle: null
	,__class__: co.doubleduck.Button
});
co.doubleduck.DataLoader = $hxClasses["co.doubleduck.DataLoader"] = function() {
	this._wordsDB = new WordsDB();
	this._gameplayDB = new GameplayDB();
};
co.doubleduck.DataLoader.__name__ = ["co","doubleduck","DataLoader"];
co.doubleduck.DataLoader._instance = null;
co.doubleduck.DataLoader.getInstance = function() {
	if(co.doubleduck.DataLoader._instance == null) co.doubleduck.DataLoader._instance = new co.doubleduck.DataLoader();
	return co.doubleduck.DataLoader._instance;
}
co.doubleduck.DataLoader.prototype = {
	getAllGameplayData: function() {
		return this._gameplayDB.getGameplayData();
	}
	,getSessionTime: function() {
		return this._gameplayDB.getGameplayData().sessionTime | 0;
	}
	,destroy: function() {
		co.doubleduck.DataLoader._instance = null;
	}
	,getOpponentById: function(id) {
		var opponents = this.getAllOpponents();
		var _g1 = 0, _g = opponents.length;
		while(_g1 < _g) {
			var oppIndex = _g1++;
			var opponent = opponents[oppIndex];
			if((opponent.id | 0) == id) return opponent;
		}
		return null;
	}
	,getAllOpponents: function() {
		return this._gameplayDB.getGameplayData().opponents;
	}
	,getAllLetterValues: function() {
		return this._gameplayDB.getGameplayData().letterValues;
	}
	,getIndexesBySequence: function(seq) {
		var dataArr = this._wordsDB.getWordsData().words;
		var _g = 0;
		while(_g < dataArr.length) {
			var data = dataArr[_g];
			++_g;
			if(seq == data.sequence) return data.indexes;
		}
		return null;
	}
	,getWordsBySequence: function(seq) {
		var dataArr = this._wordsDB.getWordsData().words;
		var _g = 0;
		while(_g < dataArr.length) {
			var data = dataArr[_g];
			++_g;
			if(seq == data.sequence) return data.words;
		}
		return null;
	}
	,getAllSequences: function() {
		var ret = [];
		var dataArr = this._wordsDB.getWordsData().words;
		var _g = 0;
		while(_g < dataArr.length) {
			var data = dataArr[_g];
			++_g;
			var seq = data.sequence;
			ret.push(seq);
		}
		return ret;
	}
	,_gameplayDB: null
	,_wordsDB: null
	,__class__: co.doubleduck.DataLoader
}
co.doubleduck.FontHelper = $hxClasses["co.doubleduck.FontHelper"] = function(type) {
	this._fontType = type;
};
co.doubleduck.FontHelper.__name__ = ["co","doubleduck","FontHelper"];
co.doubleduck.FontHelper.prototype = {
	getNumber: function(num,scale,forceContainer,dims,padding,centered) {
		if(centered == null) centered = true;
		if(padding == null) padding = 0;
		if(forceContainer == null) forceContainer = false;
		if(scale == null) scale = 1;
		if(num >= 0 && num < 10) {
			var result = new createjs.Container();
			var bmp = this.getDigit(num);
			bmp.scaleX = bmp.scaleY = scale;
			result.addChild(bmp);
			if(centered) {
				result.regX = bmp.image.width / 2;
				result.regY = bmp.image.height / 2;
			}
			if(forceContainer) {
				if(dims != null) {
					dims.width = bmp.image.width;
					dims.height = bmp.image.height;
				}
				return result;
			} else return bmp;
		} else {
			var result = new createjs.Container();
			var numString = "" + num;
			var digits = new Array();
			var totalWidth = 0;
			digits[digits.length] = this.getDigit(Std.parseInt(HxOverrides.substr(numString,0,1)));
			digits[0].scaleX = digits[0].scaleY = scale;
			result.addChild(digits[0]);
			totalWidth += digits[0].image.width * scale;
			if(numString.length == 4 || numString.length == 7) {
				this._lastComma = this.getComma();
				this._lastComma.scaleX = this._lastComma.scaleY = scale;
				this._lastComma.x = digits[0].x + digits[0].image.width + padding;
				result.addChild(this._lastComma);
				totalWidth += this._lastComma.image.width * scale;
			}
			var _g1 = 1, _g = numString.length;
			while(_g1 < _g) {
				var i = _g1++;
				var index = digits.length;
				digits[index] = this.getDigit(Std.parseInt(HxOverrides.substr(numString,i,1)));
				if(numString.length - i == 3 || numString.length - i == 6) digits[index].x = this._lastComma.x + this._lastComma.image.width + padding; else digits[index].x = digits[index - 1].x + digits[index - 1].image.width + padding;
				digits[index].scaleX = digits[index].scaleY = scale;
				result.addChild(digits[index]);
				totalWidth += digits[index].image.width * scale + padding;
				if(numString.length - i == 4 || numString.length - i == 7) {
					this._lastComma = this.getComma();
					this._lastComma.scaleX = this._lastComma.scaleY = scale;
					this._lastComma.x = digits[index].x + digits[index].image.width + padding;
					result.addChild(this._lastComma);
					totalWidth += this._lastComma.image.width * scale + padding;
				}
			}
			if(centered) {
				result.regX = totalWidth / 2;
				result.regY = digits[0].image.height / 2;
			}
			if(dims != null) {
				dims.width = totalWidth;
				dims.height = digits[0].image.height;
			}
			return result;
		}
	}
	,getDigit: function(digit) {
		var digit1 = co.doubleduck.BaseAssets.getImage(this._fontType + digit + ".png");
		return digit1;
	}
	,getComma: function() {
		return co.doubleduck.BaseAssets.getImage(this._fontType + "comma.png");
	}
	,_fontType: null
	,_lastComma: null
	,__class__: co.doubleduck.FontHelper
}
co.doubleduck.Game = $hxClasses["co.doubleduck.Game"] = function(stage) {
	co.doubleduck.BaseGame._wantLandscape = false;
	co.doubleduck.BaseGame.isLocalized = true;
	co.doubleduck.BaseGame.defaultLocale = "en";
	co.doubleduck.BaseGame.availableLocales = ["en","es"];
	co.doubleduck.BaseGame.call(this,stage);
	co.doubleduck.Button.setDefaultSound("sound/button");
};
co.doubleduck.Game.__name__ = ["co","doubleduck","Game"];
co.doubleduck.Game.__super__ = co.doubleduck.BaseGame;
co.doubleduck.Game.prototype = $extend(co.doubleduck.BaseGame.prototype,{
	handleSplashClick: function(e) {
		e.target.onClick = null;
		co.doubleduck.BaseGame.getStage().removeChild(this._gameSplash);
		this.showMenu();
	}
	,handleSplashEnd: function() {
		this._gameSplash.mouseEnabled = true;
	}
	,showGameSplash: function() {
		co.doubleduck.BaseGame.getStage().scaleX = co.doubleduck.BaseGame.getStage().scaleY = co.doubleduck.BaseGame.getScale();
		co.doubleduck.BaseGame.prototype.showGameSplash.call(this);
		this._gameSplash = new co.doubleduck.Splash();
		this._gameSplash.onClick = $bind(this,this.handleSplashClick);
		co.doubleduck.BaseGame.getStage().addChild(this._gameSplash);
		this._gameSplash.onSplashEnd = $bind(this,this.handleSplashEnd);
		this._gameSplash.mouseEnabled = false;
	}
	,_gameSplash: null
	,__class__: co.doubleduck.Game
});
co.doubleduck.LetterBox = $hxClasses["co.doubleduck.LetterBox"] = function(sequence) {
	createjs.Container.call(this);
	this._sequence = sequence;
	this._activeSequence = [];
	this.addLetters();
	this._inTheZen = false;
	this.checkLetterValidity();
	var _g = 0, _g1 = this._lettersBank;
	while(_g < _g1.length) {
		var letter = _g1[_g];
		++_g;
		letter.y += 100;
		letter.x += -50 + Std.random(100);
	}
	this.shuffle();
};
co.doubleduck.LetterBox.__name__ = ["co","doubleduck","LetterBox"];
co.doubleduck.LetterBox._instance = null;
co.doubleduck.LetterBox.getInstance = function(sequence) {
	if(sequence == null) sequence = "";
	if(co.doubleduck.LetterBox._instance == null) {
		if(sequence == "") throw "ERROR! can't initialize LetterBox without sequence.";
		co.doubleduck.LetterBox._instance = new co.doubleduck.LetterBox(sequence);
	}
	return co.doubleduck.LetterBox._instance;
}
co.doubleduck.LetterBox.__super__ = createjs.Container;
co.doubleduck.LetterBox.prototype = $extend(createjs.Container.prototype,{
	getActiveSequenceCount: function() {
		if(this._activeSequence != null) return this._activeSequence.length;
		return 0;
	}
	,setInTheZen: function(flag) {
		this._inTheZen = flag;
		if(!flag) {
			var _g = 0, _g1 = this._allLetters;
			while(_g < _g1.length) {
				var btn = _g1[_g];
				++_g;
				btn.alpha = 1;
				btn.mouseEnabled = true;
			}
		} else this.checkLetterValidity();
	}
	,clear: function() {
		while(this._activeSequence.length > 0) {
			var currButton = this._activeSequence[0];
			this.swapSequences(currButton);
		}
		this.organizeLetters(20);
		this.checkLetterValidity();
	}
	,shuffle: function() {
		var cols = [];
		var _g1 = 0, _g = this._sequence.length;
		while(_g1 < _g) {
			var num = _g1++;
			cols.push(num);
		}
		co.doubleduck.Utils.shuffleArray(cols);
		var _g1 = 0, _g = this._allLetters.length;
		while(_g1 < _g) {
			var buttonIndex = _g1++;
			this._allLetters[buttonIndex].setOrigCol(cols[buttonIndex]);
		}
		this.organizeLetters();
	}
	,getWord: function() {
		var ret = "";
		var _g = 0, _g1 = this._activeSequence;
		while(_g < _g1.length) {
			var $char = _g1[_g];
			++_g;
			ret += $char.getLetter();
		}
		return ret;
	}
	,destroy: function() {
		co.doubleduck.LetterBox._instance = null;
	}
	,swapSequences: function(btn) {
		var arrFrom;
		var arrTo;
		var toActive = false;
		if(Lambda.indexOf(this._lettersBank,btn) != -1) {
			arrFrom = this._lettersBank;
			arrTo = this._activeSequence;
			toActive = true;
		} else {
			arrTo = this._lettersBank;
			arrFrom = this._activeSequence;
		}
		HxOverrides.remove(arrFrom,btn);
		arrTo.push(btn);
		return toActive;
	}
	,organizeLetters: function(delay) {
		if(delay == null) delay = 0;
		var centerIndex = (this._activeSequence.length - 1) / 2;
		var _g1 = 0, _g = this._activeSequence.length;
		while(_g1 < _g) {
			var seqButtonIndex = _g1++;
			var centerX = co.doubleduck.BaseGame.getScreenSize().width / 2;
			var seqButton = this._activeSequence[seqButtonIndex];
			createjs.Tween.removeTweens(seqButton);
			var deltaIndex = seqButtonIndex - centerIndex;
			var destX = centerX + seqButton.image.width * deltaIndex;
			destX -= seqButton.image.width / 2;
			var destY = co.doubleduck.BaseGame.getScreenSize().height * co.doubleduck.LetterBox.SEQUENCE_POS;
			var distance = co.doubleduck.Utils.getDistance(new createjs.Point(seqButton.x,seqButton.y),new createjs.Point(destX,destY));
			var time = distance / co.doubleduck.LetterBox.PIXELS_PER_SEC * 1000;
			if(time < co.doubleduck.LetterBox.MIN_TWEEN_TIME) time = co.doubleduck.LetterBox.MIN_TWEEN_TIME;
			if(distance > 0) {
				seqButton.setTweening(true);
				createjs.Tween.get(seqButton).wait(seqButtonIndex * delay).to({ x : destX, y : destY},time,createjs.Ease.sineOut).call($bind(seqButton,seqButton.setTweening),[false]);
			}
		}
		var _g1 = 0, _g = this._lettersBank.length;
		while(_g1 < _g) {
			var bankButtonIndex = _g1++;
			var bankButton = this._lettersBank[bankButtonIndex];
			createjs.Tween.removeTweens(bankButton);
			var destX = 5 + (bankButton.image.width + 2) * bankButton.getOrigCol();
			var destY = co.doubleduck.BaseGame.getScreenSize().height * (co.doubleduck.LetterBox.BANK_POS + co.doubleduck.LetterBox.BANKS_LOC_Y[bankButton.getOrigCol()]);
			var distance = co.doubleduck.Utils.getDistance(new createjs.Point(bankButton.x,bankButton.y),new createjs.Point(destX,destY));
			var time = distance / co.doubleduck.LetterBox.PIXELS_PER_SEC * 1000;
			if(time < co.doubleduck.LetterBox.MIN_TWEEN_TIME) time = co.doubleduck.LetterBox.MIN_TWEEN_TIME;
			if(distance > 0) {
				bankButton.setTweening(true);
				createjs.Tween.get(bankButton).wait(bankButtonIndex * delay).to({ x : destX, y : destY},time,createjs.Ease.sineOut).call($bind(bankButton,bankButton.setTweening),[false]);
			}
		}
	}
	,handleBtnClick: function(e) {
		var type = Std.random(2) + 1;
		co.doubleduck.SoundManager.playEffect("sound/letterSelect" + type);
		var buttonClicked = e.target;
		this.swapSequences(buttonClicked);
		this.organizeLetters();
		this.checkLetterValidity();
		if(this.onUpdate != null) this.onUpdate();
	}
	,addLetters: function() {
		this._lettersBank = [];
		var _g1 = 0, _g = this._sequence.length;
		while(_g1 < _g) {
			var charIndex = _g1++;
			var letter = this._sequence.charAt(charIndex);
			var btn = new co.doubleduck.LetterButton(letter);
			btn.setOrigCol(charIndex);
			btn.onPress = $bind(this,this.handleBtnClick);
			this._lettersBank.push(btn);
			this.addChild(btn);
			btn.x = 5 + (btn.image.width + 2) * btn.getOrigCol();
			btn.y = co.doubleduck.BaseGame.getScreenSize().height * (co.doubleduck.LetterBox.BANK_POS + co.doubleduck.LetterBox.BANKS_LOC_Y[charIndex]);
		}
		this._allLetters = this._lettersBank.slice();
	}
	,checkLetterValidity: function() {
		if(!this._inTheZen) return;
		var seq = this.getWord();
		var _g = 0, _g1 = this._lettersBank;
		while(_g < _g1.length) {
			var letter = _g1[_g];
			++_g;
			if(!co.doubleduck.Solver.getInstance().isLetterPossible(letter.getLetter(),seq)) {
				letter.alpha = 0.3;
				letter.mouseEnabled = false;
			} else {
				letter.alpha = 1;
				letter.mouseEnabled = true;
			}
		}
	}
	,_inTheZen: null
	,_allLetters: null
	,_activeSequence: null
	,_lettersBank: null
	,_sequence: null
	,onUpdate: null
	,__class__: co.doubleduck.LetterBox
});
co.doubleduck.LetterButton = $hxClasses["co.doubleduck.LetterButton"] = function(letter) {
	this._letter = letter;
	this._value = co.doubleduck.Solver.getInstance().getCharValue(letter);
	createjs.Bitmap.call(this,co.doubleduck.BaseAssets.getRawImage("images/session/letters/" + letter + ".png"));
	this.mouseEnabled = true;
	this._isTweening = false;
};
co.doubleduck.LetterButton.__name__ = ["co","doubleduck","LetterButton"];
co.doubleduck.LetterButton.__super__ = createjs.Bitmap;
co.doubleduck.LetterButton.prototype = $extend(createjs.Bitmap.prototype,{
	isTweening: function() {
		return this._isTweening;
	}
	,setTweening: function(flag) {
		this._isTweening = flag;
		this.mouseEnabled = !flag;
	}
	,getOrigCol: function() {
		return this._origCol;
	}
	,setOrigCol: function(col) {
		this._origCol = col;
	}
	,getLetter: function() {
		return this._letter;
	}
	,getValue: function() {
		return this._value;
	}
	,_isTweening: null
	,_origCol: null
	,_letter: null
	,_value: null
	,__class__: co.doubleduck.LetterButton
});
co.doubleduck.Main = $hxClasses["co.doubleduck.Main"] = function() { }
co.doubleduck.Main.__name__ = ["co","doubleduck","Main"];
co.doubleduck.Main._stage = null;
co.doubleduck.Main._game = null;
co.doubleduck.Main._ffHeight = null;
co.doubleduck.Main.main = function() {
	co.doubleduck.Main.testFFHeight();
	createjs.Ticker.useRAF = true;
	createjs.Ticker.setFPS(60);
	co.doubleduck.Main._stage = new createjs.Stage(js.Lib.document.getElementById("stageCanvas"));
	co.doubleduck.Main._game = new co.doubleduck.Game(co.doubleduck.Main._stage);
	createjs.Ticker.addListener(co.doubleduck.Main._stage);
	createjs.Touch.enable(co.doubleduck.Main._stage,true,false);
}
co.doubleduck.Main.testFFHeight = function() {
	var isAplicable = /Firefox/.test(navigator.userAgent);
	if(isAplicable && viewporter.ACTIVE) co.doubleduck.Main._ffHeight = js.Lib.window.innerHeight;
}
co.doubleduck.Main.getFFHeight = function() {
	return co.doubleduck.Main._ffHeight;
}
co.doubleduck.Menu = $hxClasses["co.doubleduck.Menu"] = function() {
	this._justUnlocked = false;
	this._isSweeping = false;
	co.doubleduck.BaseMenu.call(this);
	if(co.doubleduck.Menu._fonter == null) co.doubleduck.Menu._fonter = new co.doubleduck.FontHelper("images/session/numbers/");
	this._justUnlocked = co.doubleduck.Session.hasJustUnlocked();
	this._opponentArray = new Array();
	this._locksArray = new Array();
	this._background = co.doubleduck.BaseAssets.getImage("images/menu/bg.png");
	this._background.regX = this._background.image.width / 2;
	this._background.regY = this._background.image.height / 2;
	this._background.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
	this._background.y = co.doubleduck.BaseGame.getScreenSize().height / 2;
	this.addChild(this._background);
	this._selectRight = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/right_arr.png"));
	this._selectRight.regX = this._selectRight.image.width;
	this._selectRight.regY = this._selectRight.image.height / 2;
	this._selectLeft = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/right_arr.png"));
	this._selectLeft.scaleX *= -1;
	this._selectLeft.regX = this._selectLeft.image.width;
	this._selectLeft.regY = this._selectLeft.image.height / 2;
	this._selectRight.x = co.doubleduck.BaseGame.getScreenSize().width - 10;
	this._selectRight.y = co.doubleduck.BaseGame.getScreenSize().height * 0.5;
	this._selectLeft.x = 10;
	this._selectLeft.y = this._selectRight.y;
	if(!this._justUnlocked) {
		this._selectRight.onClick = $bind(this,this.handleNextOpponent);
		this._selectLeft.onClick = $bind(this,this.handlePrevOpponent);
	}
	this._opponentsRow = new createjs.Container();
	this._opponentsRow.x = co.doubleduck.BaseGame.getScreenSize().width * 0.5;
	this._opponentsRow.y = co.doubleduck.BaseGame.getScreenSize().height * 0.5;
	this.addChild(this._opponentsRow);
	this._movingInfo = new createjs.Container();
	this._movingInfo.x = this._opponentsRow.x;
	this._movingInfo.y = this._opponentsRow.y;
	this.addChild(this._movingInfo);
	this._chosenOpponentId = 0;
	var _g1 = 0, _g = co.doubleduck.DataLoader.getInstance().getAllOpponents().length;
	while(_g1 < _g) {
		var i = _g1++;
		this.loadOpponentImage(i);
	}
	this._buttonsLayer = new createjs.Container();
	this._victories = new createjs.Container();
	this.addChild(this._victories);
	var vicLabel = co.doubleduck.BaseAssets.getImage("images/menu/victories.png");
	vicLabel.regX = vicLabel.image.width / 2;
	vicLabel.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
	this._victories.addChild(vicLabel);
	this._vicDefeated = co.doubleduck.BaseAssets.getImage("images/menu/defeated.png");
	this._vicDefeated.regX = this._vicDefeated.image.width / 2;
	this._vicDefeated.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
	this._victories.addChild(this._vicDefeated);
	this.loadVictories();
	var opponentToTarget = this.getUnlockedOpp() - 1;
	if(co.doubleduck.Session.getLastOpponentId() != -1) opponentToTarget = co.doubleduck.Session.getLastOpponentId() - 1;
	this.targetOpponent(opponentToTarget,true);
	if(this._justUnlocked) this.targetOpponent(opponentToTarget + 1);
	this.addChild(this._selectLeft);
	this.addChild(this._selectRight);
	this._helpBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/help.png"));
	this._helpBtn.regX = 0;
	this._helpBtn.regY = this._helpBtn.image.height / 2;
	this._helpBtn.x = -co.doubleduck.BaseGame.getScreenSize().width * 0.45;
	this._helpBtn.y = 10;
	this._helpBtn.onClick = $bind(this,this.showHelpMenu);
	this._buttonsLayer.addChild(this._helpBtn);
	if(co.doubleduck.SoundManager.available) {
		this._muteButton = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/sound.png"),true,co.doubleduck.Button.CLICK_TYPE_TOGGLE);
		this._muteButton.x = this._helpBtn.x + this._helpBtn.image.width * 1.6;
		this._muteButton.y = this._helpBtn.y;
		this._muteButton.setToggle(!co.doubleduck.SoundManager.isMuted());
		this._muteButton.onToggle = co.doubleduck.SoundManager.toggleMute;
		this._buttonsLayer.addChild(this._muteButton);
	}
	this._playButton = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/play.png"));
	this._playButton.onClick = $bind(this,this.handlePlaySession);
	this._playButton.regX = this._playButton.image.width / 2;
	this._playButton.regY = this._playButton.image.height / 2;
	this._playButton.x = co.doubleduck.BaseGame.getScreenSize().width * 0.2;
	this._playButton.y = this._helpBtn.y;
	this._buttonsLayer.addChild(this._playButton);
	this._buttonsLayer.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
	this._buttonsLayer.y = co.doubleduck.BaseGame.getScreenSize().height * 0.88;
	this.addChild(this._buttonsLayer);
	this._uiOverlay = new createjs.Shape();
	this._uiOverlay.graphics.beginFill("#000000");
	this._uiOverlay.graphics.drawRect(-30,-30,co.doubleduck.BaseGame.getScreenSize().width + 60,co.doubleduck.BaseGame.getScreenSize().height + 60);
	this._uiOverlay.graphics.endFill();
	this._uiOverlay.alpha = 0;
	this.addChild(this._uiOverlay);
	this._helpScreen = new co.doubleduck.PagedHelp("images/menu/help/help_screen.png",null,"images/menu/help/gotit.png",new Array());
	this._helpScreen.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
	this._helpScreen.y = co.doubleduck.BaseGame.getScreenSize().height * 0.45;
	this._helpScreen.alpha = 0;
	this._helpScreen.onGotIt = $bind(this,this.closeHelp);
	this._helpScreen.setButtonsPos(0.6,0.9);
	this.addChild(this._helpScreen);
	if(!this._justUnlocked) co.doubleduck.BaseGame.hammer.onswipe = $bind(this,this.handleSwipe);
	this._bgMusic = co.doubleduck.SoundManager.playMusic("sound/menuMusic");
	this.addChild(co.doubleduck.Transition.getInstance());
	co.doubleduck.Transition.transitionIn();
};
co.doubleduck.Menu.__name__ = ["co","doubleduck","Menu"];
co.doubleduck.Menu._fonter = null;
co.doubleduck.Menu.__super__ = co.doubleduck.BaseMenu;
co.doubleduck.Menu.prototype = $extend(co.doubleduck.BaseMenu.prototype,{
	switchToSession: function() {
		var params = { };
		params.level = this._chosenOpponentId + 1;
		if(this.onPlayClick != null) this.onPlayClick(params);
	}
	,handlePlaySession: function() {
		if(this._uiOverlay.alpha > 0) return;
		this._uiOverlay.alpha = 0.01;
		if(this._locksArray[this._chosenOpponentId] == false) {
			co.doubleduck.BaseGame.hammer.onswipe = null;
			co.doubleduck.Transition.transitionOut($bind(this,this.switchToSession));
		}
	}
	,setArrowsVisibility: function() {
		if(this._playButton != null) this._playButton.visible = this.isOppLocked(this._chosenOpponentId + 1);
		if(this._chosenOpponentId > 0) this._selectLeft.visible = true; else this._selectLeft.visible = false;
		if(this._chosenOpponentId + 1 < co.doubleduck.DataLoader.getInstance().getAllOpponents().length) this._selectRight.visible = true; else this._selectRight.visible = false;
	}
	,handlePrevOpponent: function() {
		if(this._chosenOpponentId > 0) this.targetOpponent(this._chosenOpponentId - 1);
		this.setArrowsVisibility();
	}
	,handleNextOpponent: function() {
		if(this._chosenOpponentId + 1 < co.doubleduck.DataLoader.getInstance().getAllOpponents().length) this.targetOpponent(this._chosenOpponentId + 1);
		this.setArrowsVisibility();
	}
	,destroy: function() {
		co.doubleduck.BaseMenu.prototype.destroy.call(this);
		if(this._bgMusic != null) this._bgMusic.stop();
		if(this._isSweeping) this.onTick = null;
	}
	,handleTick: function(elapsed) {
		if(this._opponentsRow.x == this._targetPos) {
			this.onTick = null;
			this._isSweeping = false;
			return;
		}
		var delta = co.doubleduck.Menu.SCROLL_EASE * elapsed;
		delta = Math.min(delta,0.2);
		delta *= this._targetPos - this._opponentsRow.x;
		this._opponentsRow.x += delta;
		var delta2 = co.doubleduck.Menu.SCROLL_EASE * 2 * elapsed;
		delta2 = Math.min(delta2,0.2);
		delta2 *= this._targetPos - this._movingInfo.x;
		this._movingInfo.x += delta2;
		if(Math.abs(delta) < 0.1) {
			this._opponentArray[this._chosenOpponentId].onClick = $bind(this,this.handlePlaySession);
			this._movingInfo.x = this._opponentsRow.x = this._targetPos;
			this.onTick = null;
			this._isSweeping = false;
			if(this._justUnlocked) {
				this._justUnlocked = false;
				co.doubleduck.BaseGame.hammer.onswipe = $bind(this,this.handleSwipe);
				this._selectRight.onClick = $bind(this,this.handleNextOpponent);
				this._selectLeft.onClick = $bind(this,this.handlePrevOpponent);
			}
		}
	}
	,targetOpponent: function(id,force) {
		if(force == null) force = false;
		this._opponentArray[this._chosenOpponentId].onClick = null;
		this._chosenOpponentId = id;
		this._targetPos = -(co.doubleduck.BaseGame.getScreenSize().width * (this._chosenOpponentId - 0.5));
		this.setArrowsVisibility();
		this.loadVictories();
		if(force) {
			this._isSweeping = false;
			this._movingInfo.x = this._opponentsRow.x = this._targetPos;
			this._opponentArray[this._chosenOpponentId].onClick = $bind(this,this.handlePlaySession);
		} else {
			this._isSweeping = true;
			this.onTick = $bind(this,this.handleTick);
		}
	}
	,getUnlockedOpp: function() {
		var opps = co.doubleduck.DataLoader.getInstance().getAllOpponents().length;
		var _g = 0;
		while(_g < opps) {
			var i = _g++;
			if(this.isOppLocked(opps - i)) return opps - i;
		}
		return 1;
	}
	,isOppLocked: function(id) {
		if(id == 1) return true;
		return co.doubleduck.Persistence.getVictories(id - 1) >= co.doubleduck.DataLoader.getInstance().getOpponentById(id - 1).requiredWins;
	}
	,loadOpponentImage: function(id) {
		var uriImage;
		if(!this.isOppLocked(id + 1)) {
			this._locksArray[id] = true;
			uriImage = "images/menu/opponents/opp" + (id + 1) + "_off.png";
		} else {
			this._locksArray[id] = false;
			uriImage = "images/menu/opponents/opp" + (id + 1) + "_on.png";
		}
		this._opponentArray[id] = co.doubleduck.BaseAssets.getImage(uriImage,true);
		this._opponentArray[id].regX = this._opponentArray[id].image.width / 2;
		this._opponentArray[id].regY = this._opponentArray[id].image.height / 2;
		this._opponentArray[id].x = id * co.doubleduck.BaseGame.getScreenSize().width;
		this._opponentArray[id].x += 45;
		this._opponentArray[id].y = 0;
		this._opponentsRow.addChild(this._opponentArray[id]);
		var info = co.doubleduck.BaseAssets.getImage("images/menu/opponents/opp" + (id + 1) + "_info.png");
		info.regX = info.image.width / 2;
		info.regY = info.image.height / 2;
		info.x = id * co.doubleduck.BaseGame.getScreenSize().width;
		info.x -= 45;
		info.y = -90;
		this._movingInfo.addChild(info);
	}
	,handleSwipe: function(event) {
		if(event.direction == "left") this.handleNextOpponent(); else if(event.direction == "right") this.handlePrevOpponent();
	}
	,removeEase: function(t) {
		if(t <= 0) return 0; else if(t >= 1) return 1;
		return 1.4 * t * t - 0.4 * t;
	}
	,loadVictories: function() {
		if(this._vicCurr != null) {
			this._victories.removeChild(this._vicCurr);
			this._vicCurr = null;
		}
		if(this._vicMax != null) {
			this._victories.removeChild(this._vicMax);
			this._vicMax = null;
		}
		var curr = co.doubleduck.Persistence.getVictories(this._chosenOpponentId + 1);
		var max = co.doubleduck.DataLoader.getInstance().getOpponentById(this._chosenOpponentId + 1).requiredWins;
		if(curr >= max) {
			curr = max;
			this._vicDefeated.visible = true;
		} else this._vicDefeated.visible = false;
		this._vicCurr = co.doubleduck.Menu._fonter.getDigit(curr);
		this._vicCurr.x = co.doubleduck.BaseGame.getScreenSize().width * 0.61;
		this._vicCurr.y = 2;
		this._victories.addChildAt(this._vicCurr,this._victories.getChildIndex(this._vicDefeated));
		this._vicMax = co.doubleduck.Menu._fonter.getDigit(max);
		this._vicMax.x = co.doubleduck.BaseGame.getScreenSize().width * 0.724;
		this._vicMax.y = 12;
		this._victories.addChildAt(this._vicMax,this._victories.getChildIndex(this._vicDefeated));
	}
	,toggleOverlay: function(flag) {
		var targetAlpha = 0;
		if(flag) targetAlpha = 0.65;
		createjs.Tween.removeTweens(this._uiOverlay);
		createjs.Tween.get(this._uiOverlay).to({ alpha : targetAlpha},300);
		if(this._muteButton != null) this._muteButton.mouseEnabled = !flag;
		this._buttonsLayer.mouseEnabled = !flag;
		if(flag) {
			this._helpBtn.onClick = null;
			this._selectRight.visible = this._selectLeft.visible = false;
		} else {
			this._helpBtn.onClick = $bind(this,this.showHelpMenu);
			this.setArrowsVisibility();
		}
	}
	,closeHelp: function() {
		if(!this._justUnlocked) co.doubleduck.BaseGame.hammer.onswipe = $bind(this,this.handleSwipe);
		this.toggleOverlay(false);
		createjs.Tween.removeTweens(this._helpScreen);
		createjs.Tween.removeTweens(this._helpBtn);
		createjs.Tween.get(this._helpScreen).to({ alpha : 0},600);
		this._helpBtn.alpha = 1;
	}
	,showHelpMenu: function() {
		co.doubleduck.BaseGame.hammer.onswipe = null;
		this.toggleOverlay(true);
		createjs.Tween.get(this._helpScreen).to({ alpha : 1},1000,createjs.Ease.sineOut);
		createjs.Tween.get(this._helpBtn).to({ alpha : 0},1000,createjs.Ease.sineOut);
		this._helpScreen.visible = true;
	}
	,_helpScreen: null
	,_uiOverlay: null
	,_justUnlocked: null
	,_opponentsRow: null
	,_targetPos: null
	,_isSweeping: null
	,_vicDefeated: null
	,_vicMax: null
	,_vicCurr: null
	,_victories: null
	,_movingInfo: null
	,_buttonsLayer: null
	,_helpBtn: null
	,_bgMusic: null
	,_muteButton: null
	,_playLocked: null
	,_playButton: null
	,_selectLeft: null
	,_selectRight: null
	,_chosenOpponentId: null
	,_locksArray: null
	,_opponentArray: null
	,_background: null
	,__class__: co.doubleduck.Menu
});
co.doubleduck.Opponent = $hxClasses["co.doubleduck.Opponent"] = function(id) {
	this._score = 0;
	createjs.Container.call(this);
	this._guessedWords = [];
	this._id = id;
	this._vocabulary = co.doubleduck.DataLoader.getInstance().getOpponentById(id).vocabulary;
	this._time = 0;
	this.distributeTime();
	this._image = co.doubleduck.BaseAssets.getImage("images/session/avatars/" + id + ".png");
	this.addChild(this._image);
};
co.doubleduck.Opponent.__name__ = ["co","doubleduck","Opponent"];
co.doubleduck.Opponent.__super__ = createjs.Container;
co.doubleduck.Opponent.prototype = $extend(createjs.Container.prototype,{
	forceGuessWord: function() {
		var word = co.doubleduck.Solver.getInstance().getRandomWord();
		this.updateScore(co.doubleduck.Solver.getInstance().getWordValue(word));
		if(this.onGuess != null) this.onGuess(word);
	}
	,getScore: function() {
		return this._score;
	}
	,destroy: function() {
		this.disable();
	}
	,updateScore: function(update) {
		this._score += update;
	}
	,tick: function(elapsed) {
		if(this._answerTimes.length > 0) {
			this._time += elapsed / 1000;
			if(this._time >= this._answerTimes[0]) {
				this.guessWord();
				this._answerTimes.shift();
			}
		}
	}
	,distributeTime: function() {
		this._answerTimes = [];
		var numWords = co.doubleduck.Solver.getInstance().getAllWords().length;
		var numWordsToGuess = numWords * this._vocabulary | 0;
		if(numWordsToGuess <= 0) numWordsToGuess = 1;
		var totalTime = co.doubleduck.DataLoader.getInstance().getSessionTime() - 2;
		var timeRemaining = totalTime;
		var _g = 0;
		while(_g < numWordsToGuess) {
			var i = _g++;
			var n = numWordsToGuess - i;
			var baseDivision = timeRemaining / n;
			var randTime = Math.random() * baseDivision + baseDivision / 2;
			timeRemaining -= randTime;
			var timeUntil = 0;
			if(this._answerTimes.length > 0) timeUntil = this._answerTimes[this._answerTimes.length - 1];
			this._answerTimes.push(randTime + timeUntil);
		}
	}
	,getRandomWord: function() {
		if(this._guessedWords.length == co.doubleduck.Solver.getInstance().getAllWords().length) return null;
		var ret = co.doubleduck.Solver.getInstance().getRandomWord();
		while(Lambda.indexOf(this._guessedWords,ret) != -1) ret = co.doubleduck.Solver.getInstance().getRandomWord();
		this._guessedWords.push(ret);
		return ret;
	}
	,guessWord: function() {
		var word = this.getRandomWord();
		if(word == null) return;
		this.updateScore(co.doubleduck.Solver.getInstance().getWordValue(word));
		if(this.onGuess != null) this.onGuess(word);
		null;
	}
	,disable: function() {
		this.onTick = null;
	}
	,enable: function() {
		this.onTick = $bind(this,this.tick);
	}
	,getHeight: function() {
		return this._image.image.height;
	}
	,getWidth: function() {
		return this._image.image.width;
	}
	,_guessedWords: null
	,_image: null
	,_time: null
	,_answerTimes: null
	,_vocabulary: null
	,_id: null
	,_score: null
	,onGuess: null
	,__class__: co.doubleduck.Opponent
});
co.doubleduck.PagedHelp = $hxClasses["co.doubleduck.PagedHelp"] = function(backUri,nextBtnUri,gotItBtnUri,pages) {
	createjs.Container.call(this);
	this._background = co.doubleduck.BaseAssets.getImage(backUri);
	this.addChild(this._background);
	this.regX = this._background.image.width / 2;
	this.regY = this._background.image.height / 2;
	this._contentLayer = new createjs.Container();
	if(pages.length > 0) {
		var _g1 = 0, _g = pages.length;
		while(_g1 < _g) {
			var i = _g1++;
			this.addPage(pages[i],i);
		}
		this.addChild(this._contentLayer);
		this._pagesCount = pages.length;
		this._mask = new createjs.Shape();
		this._mask.graphics.beginFill("#000000");
		this._mask.graphics.drawRect(20,20,this._background.image.width - 40,this._background.image.height - 40);
		this._mask.graphics.endFill();
		this._contentLayer.mask = this._mask;
	} else this._pagesCount = 0;
	if(nextBtnUri != null && nextBtnUri != "") {
		this._nextBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage(nextBtnUri),true,co.doubleduck.Button.CLICK_TYPE_SCALE);
		this._nextBtn.regX = this._nextBtn.image.width / 2;
		this._nextBtn.regY = this._nextBtn.image.height / 2;
		this._nextBtn.onClick = $bind(this,this.handleNextClick);
		this.addChild(this._nextBtn);
	}
	this._gotItBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage(gotItBtnUri),true,co.doubleduck.Button.CLICK_TYPE_SCALE);
	this._gotItBtn.regX = this._gotItBtn.image.width / 2;
	this._gotItBtn.regY = this._gotItBtn.image.height / 2;
	this._gotItBtn.onClick = $bind(this,this.handleGotItClick);
	this.addChild(this._gotItBtn);
	this.setButtonsPos();
	this._currPage = 0;
	this.enableSwipe();
	this.addPageMarkers();
	this.setButtonsVis();
};
co.doubleduck.PagedHelp.__name__ = ["co","doubleduck","PagedHelp"];
co.doubleduck.PagedHelp.__super__ = createjs.Container;
co.doubleduck.PagedHelp.prototype = $extend(createjs.Container.prototype,{
	createPageMarker: function() {
		var img = co.doubleduck.BaseAssets.getRawImage("images/duckling/page_marker.png");
		var initObject = { };
		initObject.images = [img];
		initObject.frames = { width : 16, height : 18};
		initObject.animations = { };
		initObject.animations.idle = { frames : 0, frequency : 20};
		initObject.animations.active = { frames : 1, frequency : 20};
		var pageMarker = new createjs.BitmapAnimation(new createjs.SpriteSheet(initObject));
		pageMarker.gotoAndStop("idle");
		return pageMarker;
	}
	,handleNextClick: function() {
		this._currPage++;
		if(this._currPage >= this._pagesCount) {
			this._currPage = this._pagesCount - 1;
			return;
		}
		this._pageMarkers[this._currPage - 1].gotoAndStop("idle");
		this._pageMarkers[this._currPage].gotoAndStop("active");
		createjs.Tween.get(this._contentLayer).to({ x : -1 * this._background.image.width * this._currPage},200,createjs.Ease.sineOut);
		this.setButtonsVis();
	}
	,handlePrevClick: function() {
		this._currPage--;
		if(this._currPage < 0) {
			this._currPage = 0;
			return;
		}
		this._pageMarkers[this._currPage + 1].gotoAndStop("idle");
		this._pageMarkers[this._currPage].gotoAndStop("active");
		createjs.Tween.get(this._contentLayer).to({ x : -1 * this._background.image.width * this._currPage},200,createjs.Ease.sineOut);
		this.setButtonsVis();
	}
	,setButtonsVis: function() {
		if(this._pagesCount == 0) {
			this._gotItBtn.visible = true;
			return;
		}
		if(this._currPage == this._pagesCount - 1) {
			this._gotItBtn.visible = true;
			this._nextBtn.visible = false;
		} else {
			this._gotItBtn.visible = false;
			this._nextBtn.visible = true;
		}
	}
	,handleSwipe: function(event) {
		if(event.direction == "left") this.handleNextClick(); else if(event.direction == "right") this.handlePrevClick();
	}
	,handleGotItClick: function() {
		if(this.onGotIt != null) this.onGotIt();
	}
	,addPageMarkers: function() {
		if(this._pagesCount == 0) return;
		this._pageMarkers = new Array();
		var totalWidth = 0;
		this._markersLayer = new createjs.Container();
		var _g1 = 0, _g = this._pagesCount;
		while(_g1 < _g) {
			var currPage = _g1++;
			var pageMarker = this.createPageMarker();
			this._pageMarkers.push(pageMarker);
			if(currPage != 0) {
				pageMarker.x = this._pageMarkers[currPage - 1].x + this._pageMarkers[currPage - 1].spriteSheet._frameWidth + 5;
				totalWidth += 5;
			}
			totalWidth += pageMarker.spriteSheet._frameWidth;
			this._markersLayer.addChild(pageMarker);
		}
		this._markersLayer.y = this._background.image.height * 0.80;
		this._markersLayer.x = this._background.image.width / 2;
		this._markersLayer.regX = totalWidth / 2;
		this.addChild(this._markersLayer);
		this._pageMarkers[0].gotoAndStop("active");
	}
	,addPage: function(pageUri,index) {
		var page = co.doubleduck.BaseAssets.getImage(pageUri);
		page.x += this._background.image.width * index;
		this._contentLayer.addChild(page);
	}
	,goToPage: function(page) {
		this._pageMarkers[this._currPage].gotoAndStop("idle");
		this._currPage = page;
		this._pageMarkers[this._currPage].gotoAndStop("active");
		this._contentLayer.x = -1 * this._background.image.width * this._currPage;
		this.setButtonsVis();
	}
	,changeContentMask: function(topPad,bottomPad,leftPad,rightPad) {
		this._mask.graphics.clear();
		this._mask.graphics.beginFill("#000000");
		this._mask.graphics.drawRect(leftPad,topPad,this._background.image.width - (rightPad + leftPad),this._background.image.height - (bottomPad + topPad));
		this._mask.graphics.endFill();
	}
	,rewindPages: function() {
		this.goToPage(0);
	}
	,enableSwipe: function() {
		co.doubleduck.BaseGame.hammer.onswipe = $bind(this,this.handleSwipe);
	}
	,setMarkersPos: function(percentY,percentX) {
		if(percentX == null) percentX = 0.5;
		this._markersLayer.y = this._background.image.height * percentY;
		this._markersLayer.x = this._background.image.width * percentX;
	}
	,setButtonsPos: function(percentX,percentY) {
		if(percentY == null) percentY = 0.5;
		if(percentX == null) percentX = 0.5;
		if(this._nextBtn != null) {
			this._nextBtn.x = this._background.image.width * percentX;
			this._nextBtn.y = this._background.image.height * percentY;
		}
		this._gotItBtn.x = this._background.image.width * percentX;
		this._gotItBtn.y = this._background.image.height * percentY;
	}
	,_currPage: null
	,_pagesCount: null
	,_gotItBtn: null
	,_nextBtn: null
	,_pageMarkers: null
	,_markersLayer: null
	,_mask: null
	,_contentLayer: null
	,_background: null
	,onGotIt: null
	,__class__: co.doubleduck.PagedHelp
});
co.doubleduck.Persistence = $hxClasses["co.doubleduck.Persistence"] = function() { }
co.doubleduck.Persistence.__name__ = ["co","doubleduck","Persistence"];
co.doubleduck.Persistence.initGameData = function() {
	co.doubleduck.BasePersistence.GAME_PREFIX = "TIKI_";
	if(!co.doubleduck.BasePersistence.available) return;
	var numEnemies = co.doubleduck.DataLoader.getInstance().getAllOpponents().length;
	var _g1 = 1, _g = numEnemies + 1;
	while(_g1 < _g) {
		var enemy = _g1++;
		co.doubleduck.BasePersistence.initVar("enemy" + enemy,"0");
	}
}
co.doubleduck.Persistence.getVictories = function(enemyId) {
	return Std.parseInt(co.doubleduck.BasePersistence.getValue("enemy" + enemyId));
}
co.doubleduck.Persistence.setVictories = function(enemyId,victories) {
	co.doubleduck.BasePersistence.setValue("enemy" + enemyId,"" + victories);
}
co.doubleduck.Persistence.__super__ = co.doubleduck.BasePersistence;
co.doubleduck.Persistence.prototype = $extend(co.doubleduck.BasePersistence.prototype,{
	__class__: co.doubleduck.Persistence
});
co.doubleduck.ResultEmitter = $hxClasses["co.doubleduck.ResultEmitter"] = function() {
	createjs.Container.call(this);
	this._successImages = ["images/session/great.png"];
	this._failImages = ["images/session/x.png"];
	this._duplicateImages = ["images/session/again.png"];
};
co.doubleduck.ResultEmitter.__name__ = ["co","doubleduck","ResultEmitter"];
co.doubleduck.ResultEmitter._instance = null;
co.doubleduck.ResultEmitter.getInstance = function() {
	if(co.doubleduck.ResultEmitter._instance == null) co.doubleduck.ResultEmitter._instance = new co.doubleduck.ResultEmitter();
	return co.doubleduck.ResultEmitter._instance;
}
co.doubleduck.ResultEmitter.__super__ = createjs.Container;
co.doubleduck.ResultEmitter.prototype = $extend(createjs.Container.prototype,{
	removeItem: function(item) {
		this.removeChild(item);
		item = null;
	}
	,fadeOut: function(d,time) {
		if(time == null) time = 300;
		createjs.Tween.removeTweens(d);
		return createjs.Tween.get(d).to({ alpha : 0},time,createjs.Ease.sineOut).call($bind(this,this.removeItem),[d]);
	}
	,fadeIn: function(d,time) {
		if(time == null) time = 300;
		d.alpha = 0;
		return createjs.Tween.get(d).to({ alpha : 1},time,createjs.Ease.sineOut);
	}
	,displayResult: function(url) {
		var locX = co.doubleduck.BaseGame.getScreenSize().width / 2;
		var locY = co.doubleduck.BaseGame.getScreenSize().height * 0.3;
		var result = co.doubleduck.Utils.getCenteredImage(url);
		this.addChild(result);
		result.x = locX;
		result.y = locY;
		this.fadeIn(result).wait(700).call($bind(this,this.fadeOut),[result]);
	}
	,destroy: function() {
		co.doubleduck.ResultEmitter._instance = null;
		this._successImages = null;
		this._failImages = null;
		this._duplicateImages = null;
	}
	,emitDuplicate: function() {
		if(this._duplicateImages.length > 0) {
			var randWord = this._duplicateImages[Std.random(this._successImages.length)];
			this.displayResult(randWord);
		}
	}
	,emitFail: function() {
		if(this._failImages.length > 0) {
			var randWord = this._failImages[Std.random(this._successImages.length)];
			this.displayResult(randWord);
		}
	}
	,emitSuccess: function(length) {
		var word = "";
		if(this._successImages.length > 0) {
			if(length == 3) word = "images/session/good.png"; else if(length == 4) word = "images/session/great.png"; else if(length == 5) word = "images/session/awesome.png"; else word = "images/session/fantastic.png";
			this.displayResult(word);
		}
	}
	,_duplicateImages: null
	,_failImages: null
	,_successImages: null
	,__class__: co.doubleduck.ResultEmitter
});
co.doubleduck.Session = $hxClasses["co.doubleduck.Session"] = function(properties) {
	co.doubleduck.BaseSession.call(this);
	this._volcano = new co.doubleduck.Volcano();
	this._volcano.onEruption = $bind(this,this.handleVolcanoEruption);
	this._volcano.onEruptionEnd = $bind(this,this.handleVolcanoEruptionEnd);
	this.addChild(this._volcano);
	this._opponentId = properties.level;
	co.doubleduck.Session._lastOpponentId = this._opponentId;
	this.initSession();
	this.addChild(this._letterBox);
	this._volcano.enable();
	this._remainingSecs = co.doubleduck.DataLoader.getInstance().getSessionTime();
	co.doubleduck.Utils.waitAndCall(this,1000,$bind(this,this.doCountdown));
	this.addUI();
	this._userScore = 0;
	this._opponent = new co.doubleduck.Opponent(this._opponentId);
	this._hud.setOpponent(this._opponent);
	this._hud.setRemainingSecs(this._remainingSecs);
	this._opponent.enable();
	this._opponent.onGuess = $bind(this,this.handleOpponentGuess);
	this._hud.setScore(0,0);
	this._hud.onQuitClick = $bind(this,this.handleMenu);
	this.addChild(co.doubleduck.Transition.getInstance());
	co.doubleduck.Transition.transitionIn();
};
co.doubleduck.Session.__name__ = ["co","doubleduck","Session"];
co.doubleduck.Session._lastOpponentId = null;
co.doubleduck.Session._justUnlocked = null;
co.doubleduck.Session.getLastOpponentId = function() {
	if(co.doubleduck.Session._lastOpponentId == null) return -1;
	return co.doubleduck.Session._lastOpponentId;
}
co.doubleduck.Session.hasJustUnlocked = function() {
	if(co.doubleduck.Session._justUnlocked == null) co.doubleduck.Session._justUnlocked = false;
	var ret = co.doubleduck.Session._justUnlocked;
	co.doubleduck.Session._justUnlocked = false;
	return ret;
}
co.doubleduck.Session.__super__ = co.doubleduck.BaseSession;
co.doubleduck.Session.prototype = $extend(co.doubleduck.BaseSession.prototype,{
	destroy: function() {
		createjs.Tween.removeTweens(this);
		this._volcano.disable();
		this._opponent.disable();
		this._solver.destroy();
		this._letterBox.destroy();
		this._resultEmitter.destroy();
		co.doubleduck.ui.EndModal.destroy();
	}
	,initSession: function() {
		var allSequences = co.doubleduck.DataLoader.getInstance().getAllSequences();
		var randSeq = allSequences[Std.random(allSequences.length)];
		this._currSequence = randSeq;
		this._solver = co.doubleduck.Solver.getInstance(this._currSequence);
		this._letterBox = co.doubleduck.LetterBox.getInstance(this._currSequence);
		this._letterBox.onUpdate = $bind(this,this.handleLetterboxUpdated);
	}
	,handleVolcanoEruptionEnd: function() {
		this._letterBox.setInTheZen(false);
	}
	,handleVolcanoEruption: function() {
		this._letterBox.setInTheZen(true);
		co.doubleduck.SoundManager.playEffect("sound/volcanoErrupt");
	}
	,handleGoClick: function(e) {
		var word = this._letterBox.getWord();
		var result = co.doubleduck.Solver.getInstance().validateWord(word);
		if(result == co.doubleduck.Result.CORRECT) {
			var score = co.doubleduck.Solver.getInstance().getWordValue(word) * this._volcano.getMultiplier();
			this._volcano.addScore(score);
			co.doubleduck.Solver.getInstance().addToUsedWords(word);
			this._letterBox.clear();
			this._userScore += score;
			this._hud.setScore(this._userScore,-1,true);
			this._resultEmitter.emitSuccess(word.length);
			co.doubleduck.SoundManager.playEffect("sound/wordAccepted");
			this.toggleGoBtn(false);
		} else if(result == co.doubleduck.Result.INCORRECT) {
			this._resultEmitter.emitFail();
			co.doubleduck.SoundManager.playEffect("sound/wordRejected");
		} else {
			if(word.length > 0) {
				this._letterBox.clear();
				this._resultEmitter.emitDuplicate();
			}
			co.doubleduck.SoundManager.playEffect("sound/wordRejected");
		}
	}
	,toggleGoBtn: function(active) {
		if(active) {
			this._goBtn.mouseEnabled = true;
			this._goBtn.alpha = 1;
		} else {
			this._goBtn.mouseEnabled = false;
			this._goBtn.alpha = 0.5;
		}
	}
	,handleLetterboxUpdated: function() {
		var numLetters = this._letterBox.getActiveSequenceCount();
		if(numLetters < 3) this.toggleGoBtn(false); else this.toggleGoBtn(true);
	}
	,handleShuffleClicked: function(e) {
		this._letterBox.shuffle();
	}
	,handleClearClicked: function(e) {
		this._letterBox.clear();
		this.toggleGoBtn(false);
	}
	,enableUI: function() {
		this._shuffleBtn.mouseEnabled = false;
		this._clearBtn.mouseEnabled = false;
		this._goBtn.mouseEnabled = false;
	}
	,disableUI: function() {
		this._shuffleBtn.mouseEnabled = false;
		this._clearBtn.mouseEnabled = false;
		this._goBtn.mouseEnabled = false;
	}
	,addUI: function() {
		var padding = co.doubleduck.BaseGame.getScreenSize().width * 0.02;
		this._goBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/go.png"));
		co.doubleduck.Utils.setCenterReg(this._goBtn);
		this._goBtn.onClick = $bind(this,this.handleGoClick);
		this.addChild(this._goBtn);
		this._goBtn.y = co.doubleduck.BaseGame.getScreenSize().height * 0.94;
		this._goBtn.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		this.toggleGoBtn(false);
		this._clearBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/clear.png"));
		this._clearBtn.regX = this._clearBtn.image.width;
		this._clearBtn.regY = this._clearBtn.image.height / 2;
		this._clearBtn.x = this._goBtn.x - this._goBtn.image.width / 2 - padding;
		this._clearBtn.y = this._goBtn.y;
		this.addChild(this._clearBtn);
		this._clearBtn.onClick = $bind(this,this.handleClearClicked);
		this._shuffleBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/shuffle.png"));
		this._shuffleBtn.regY = this._shuffleBtn.image.height / 2;
		this._shuffleBtn.y = this._goBtn.y;
		this._shuffleBtn.x = this._goBtn.x + this._goBtn.image.width / 2 + padding;
		this.addChild(this._shuffleBtn);
		this._shuffleBtn.onClick = $bind(this,this.handleShuffleClicked);
		this._hud = new co.doubleduck.ui.HUD();
		this.addChild(this._hud);
		this._resultEmitter = co.doubleduck.ResultEmitter.getInstance();
		this.addChild(this._resultEmitter);
	}
	,next: function() {
		if(this.onRestart != null) this.onRestart({ level : this._opponentId});
	}
	,menu: function() {
		if(this.onBackToMenu != null) this.onBackToMenu();
	}
	,retry: function() {
		if(this.onRestart != null) this.onRestart({ level : this._opponentId});
	}
	,handleNext: function() {
		this.addChild(co.doubleduck.Transition.getInstance());
		co.doubleduck.Transition.transitionOut($bind(this,this.next));
	}
	,handleMenu: function() {
		this.addChild(co.doubleduck.Transition.getInstance());
		co.doubleduck.Transition.transitionOut($bind(this,this.menu));
	}
	,handleRetry: function() {
		this.addChild(co.doubleduck.Transition.getInstance());
		co.doubleduck.Transition.transitionOut($bind(this,this.retry));
	}
	,timesUp: function() {
		this.disableUI();
		this._letterBox.mouseEnabled = false;
		this._opponent.disable();
		this._volcano.disable();
		if(this._userScore == this._opponent.getScore()) this._opponent.forceGuessWord();
		if(this._userScore >= this._opponent.getScore()) {
			co.doubleduck.Persistence.setVictories(this._opponentId,co.doubleduck.Persistence.getVictories(this._opponentId) + 1);
			if(co.doubleduck.Persistence.getVictories(this._opponentId) == (co.doubleduck.DataLoader.getInstance().getOpponentById(this._opponentId).requiredWins | 0) && this._opponentId != co.doubleduck.DataLoader.getInstance().getAllOpponents().length) co.doubleduck.Session._justUnlocked = true;
			co.doubleduck.SoundManager.playEffect("sound/victoryMusic");
		} else co.doubleduck.SoundManager.playEffect("sound/lossMusic");
		var endModal = co.doubleduck.ui.EndModal.getInstance(this._userScore,this._opponent.getScore(),this._opponentId);
		this.addChild(endModal);
		endModal.onRetryClick = $bind(this,this.handleRetry);
		endModal.onNextClick = $bind(this,this.handleNext);
		endModal.onMenuClick = $bind(this,this.handleMenu);
		endModal.animateIn();
	}
	,doCountdown: function() {
		this._remainingSecs -= 1;
		if(this._remainingSecs == 0) this.timesUp(); else co.doubleduck.Utils.waitAndCall(this,1000,$bind(this,this.doCountdown));
		this._hud.setRemainingSecs(this._remainingSecs);
	}
	,handleOpponentGuess: function(word) {
		var oppScore = this._opponent.getScore();
		this._hud.setScore(-1,oppScore,true);
	}
	,_resultEmitter: null
	,_hud: null
	,_shuffleBtn: null
	,_clearBtn: null
	,_goBtn: null
	,_userScore: null
	,_remainingSecs: null
	,_opponentId: null
	,_currSequence: null
	,_volcano: null
	,_letterBox: null
	,_opponent: null
	,_solver: null
	,__class__: co.doubleduck.Session
});
co.doubleduck.Solver = $hxClasses["co.doubleduck.Solver"] = function(sequence) {
	this._sequence = sequence;
	this._values = co.doubleduck.DataLoader.getInstance().getAllLetterValues();
	this._bank = co.doubleduck.DataLoader.getInstance().getWordsBySequence(sequence);
	this._indexes = co.doubleduck.DataLoader.getInstance().getIndexesBySequence(sequence);
	this._guessedWords = [];
};
co.doubleduck.Solver.__name__ = ["co","doubleduck","Solver"];
co.doubleduck.Solver._instance = null;
co.doubleduck.Solver.getInstance = function(seq) {
	if(seq == null) seq = "";
	if(co.doubleduck.Solver._instance == null) {
		if(seq == "") throw "ERROR! can't initialize Solver without sequence.";
		co.doubleduck.Solver._instance = new co.doubleduck.Solver(seq);
	}
	return co.doubleduck.Solver._instance;
}
co.doubleduck.Solver.prototype = {
	isLetterPossible: function(letter,part) {
		if(part == null) part = "";
		var index = this.getCharIndex(letter);
		var firstLetter = letter;
		if(part == "") index = this._indexes[this.getCharIndex(letter)]; else {
			index = this._indexes[this.getCharIndex(part.charAt(0))];
			firstLetter = part.charAt(0);
		}
		if(index == -1) return false;
		var _g1 = index, _g = this._bank.length;
		while(_g1 < _g) {
			var i = _g1++;
			var word = this._bank[i];
			if(word.charAt(0) != firstLetter) break;
			if(word.length <= part.length) continue;
			if(Lambda.indexOf(this._guessedWords,word) != -1) continue;
			var currWordPart = HxOverrides.substr(word,0,part.length);
			if(currWordPart == part) {
				if(word.charAt(part.length) == letter) return true;
			}
		}
		return false;
	}
	,getAllWords: function() {
		return this._bank;
	}
	,getCharValue: function($char) {
		return this._values[this.getCharIndex($char)];
	}
	,addToUsedWords: function(word) {
		this._guessedWords.push(word);
	}
	,getWordValue: function(word) {
		var ret = 0;
		var _g1 = 0, _g = word.length;
		while(_g1 < _g) {
			var i = _g1++;
			var $char = word.charAt(i);
			ret += this.getCharValue($char);
		}
		return ret * word.length;
	}
	,validateWord: function(word) {
		if(Lambda.indexOf(this._guessedWords,word) != -1) return co.doubleduck.Result.REPEATED;
		if(!this.isWord(word)) return co.doubleduck.Result.INCORRECT;
		return co.doubleduck.Result.CORRECT;
	}
	,isWord: function(searchedWord) {
		var firstChar = searchedWord.charAt(0);
		var startIndex = this._indexes[this.getCharIndex(firstChar)];
		if(startIndex == -1) return false;
		var _g1 = startIndex, _g = this._bank.length;
		while(_g1 < _g) {
			var charIndex = _g1++;
			var word = this._bank[charIndex];
			if(word.charAt(0) != firstChar) return false;
			if(word == searchedWord) return true;
		}
		return false;
	}
	,getRandomWord: function() {
		return this._bank[Std.random(this._bank.length)];
	}
	,destroy: function() {
		co.doubleduck.Solver._instance = null;
	}
	,getCharIndex: function($char) {
		return HxOverrides.cca($char.toLowerCase(),0) - 97;
	}
	,_guessedWords: null
	,_values: null
	,_sequence: null
	,_indexes: null
	,_bank: null
	,__class__: co.doubleduck.Solver
}
co.doubleduck.Result = $hxClasses["co.doubleduck.Result"] = { __ename__ : ["co","doubleduck","Result"], __constructs__ : ["CORRECT","INCORRECT","REPEATED"] }
co.doubleduck.Result.CORRECT = ["CORRECT",0];
co.doubleduck.Result.CORRECT.toString = $estr;
co.doubleduck.Result.CORRECT.__enum__ = co.doubleduck.Result;
co.doubleduck.Result.INCORRECT = ["INCORRECT",1];
co.doubleduck.Result.INCORRECT.toString = $estr;
co.doubleduck.Result.INCORRECT.__enum__ = co.doubleduck.Result;
co.doubleduck.Result.REPEATED = ["REPEATED",2];
co.doubleduck.Result.REPEATED.toString = $estr;
co.doubleduck.Result.REPEATED.__enum__ = co.doubleduck.Result;
co.doubleduck.SoundType = $hxClasses["co.doubleduck.SoundType"] = { __ename__ : ["co","doubleduck","SoundType"], __constructs__ : ["WEB_AUDIO","AUDIO_FX","AUDIO_NO_OVERLAP","HOWLER","NONE"] }
co.doubleduck.SoundType.WEB_AUDIO = ["WEB_AUDIO",0];
co.doubleduck.SoundType.WEB_AUDIO.toString = $estr;
co.doubleduck.SoundType.WEB_AUDIO.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.AUDIO_FX = ["AUDIO_FX",1];
co.doubleduck.SoundType.AUDIO_FX.toString = $estr;
co.doubleduck.SoundType.AUDIO_FX.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.AUDIO_NO_OVERLAP = ["AUDIO_NO_OVERLAP",2];
co.doubleduck.SoundType.AUDIO_NO_OVERLAP.toString = $estr;
co.doubleduck.SoundType.AUDIO_NO_OVERLAP.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.HOWLER = ["HOWLER",3];
co.doubleduck.SoundType.HOWLER.toString = $estr;
co.doubleduck.SoundType.HOWLER.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.NONE = ["NONE",4];
co.doubleduck.SoundType.NONE.toString = $estr;
co.doubleduck.SoundType.NONE.__enum__ = co.doubleduck.SoundType;
if(!co.doubleduck.audio) co.doubleduck.audio = {}
co.doubleduck.audio.AudioAPI = $hxClasses["co.doubleduck.audio.AudioAPI"] = function() { }
co.doubleduck.audio.AudioAPI.__name__ = ["co","doubleduck","audio","AudioAPI"];
co.doubleduck.audio.AudioAPI.prototype = {
	setVolume: null
	,pause: null
	,stop: null
	,playMusic: null
	,playEffect: null
	,init: null
	,__class__: co.doubleduck.audio.AudioAPI
}
co.doubleduck.audio.WebAudioAPI = $hxClasses["co.doubleduck.audio.WebAudioAPI"] = function(src) {
	this._src = src;
	this.loadAudioFile(this._src);
};
co.doubleduck.audio.WebAudioAPI.__name__ = ["co","doubleduck","audio","WebAudioAPI"];
co.doubleduck.audio.WebAudioAPI.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.WebAudioAPI.context = null;
co.doubleduck.audio.WebAudioAPI.webAudioInit = function() {
	co.doubleduck.audio.WebAudioAPI.context = new webkitAudioContext();
}
co.doubleduck.audio.WebAudioAPI.saveBuffer = function(buffer,name) {
	co.doubleduck.audio.WebAudioAPI._buffers[name] = buffer;
}
co.doubleduck.audio.WebAudioAPI.decodeError = function() {
	null;
}
co.doubleduck.audio.WebAudioAPI.prototype = {
	setVolume: function(volume) {
		if(this._gainNode != null) this._gainNode.gain.value = volume;
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		if(this._source != null) this._source.noteOff(0);
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
		this.playBuffer(this._src,loop);
		this.setVolume(volume);
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		this.playBuffer(this._src,loop);
		this.setVolume(volume);
	}
	,playBuffer: function(name,loop) {
		if(loop == null) loop = false;
		if(this._gainNode == null) {
			this._gainNode = co.doubleduck.audio.WebAudioAPI.context.createGainNode();
			this._gainNode.connect(co.doubleduck.audio.WebAudioAPI.context.destination);
		}
		this._buffer = Reflect.getProperty(co.doubleduck.audio.WebAudioAPI._buffers,this._src);
		if(this._buffer == null) return;
		this._source = co.doubleduck.audio.WebAudioAPI.context.createBufferSource();
		this._source.buffer = this._buffer;
		this._source.loop = loop;
		this._source.connect(this._gainNode);
		this._source.noteOn(0);
	}
	,loadAudioFile: function(src) {
		var request = new XMLHttpRequest();
		request.open("get",src,true);
		request.responseType = "arraybuffer";
		request.onload = function() { co.doubleduck.audio.WebAudioAPI.context.decodeAudioData(request.response, function(decodedBuffer) { buffer = decodedBuffer; co.doubleduck.audio.WebAudioAPI.saveBuffer(buffer,src); }, co.doubleduck.audio.WebAudioAPI.decodeError) }
		request.send();
	}
	,init: function() {
	}
	,_source: null
	,_gainNode: null
	,_buffer: null
	,_src: null
	,__class__: co.doubleduck.audio.WebAudioAPI
}
co.doubleduck.SoundManager = $hxClasses["co.doubleduck.SoundManager"] = function() {
};
co.doubleduck.SoundManager.__name__ = ["co","doubleduck","SoundManager"];
co.doubleduck.SoundManager.engineType = null;
co.doubleduck.SoundManager.EXTENSION = null;
co.doubleduck.SoundManager.getPersistedMute = function() {
	var mute = co.doubleduck.BasePersistence.getValue("mute");
	if(mute == "0") {
		mute = "false";
		co.doubleduck.SoundManager.setPersistedMute(false);
	}
	return mute == "true";
}
co.doubleduck.SoundManager.setPersistedMute = function(mute) {
	var val = "true";
	if(!mute) val = "false";
	co.doubleduck.BasePersistence.setValue("mute",val);
}
co.doubleduck.SoundManager.isSoundAvailable = function() {
	var isFirefox = /Firefox/.test(navigator.userAgent);
	var isChrome = /Chrome/.test(navigator.userAgent);
	var isMobile = /Mobile/.test(navigator.userAgent);
	var isAndroid = /Android/.test(navigator.userAgent);
	var isAndroid4 = /Android 4/.test(navigator.userAgent);
	var isSafari = /Safari/.test(navigator.userAgent);
	var agent = navigator.userAgent;
	var reg = new EReg("iPhone OS 6","");
	var isIOS6 = reg.match(agent) && isSafari && isMobile;
	var isIpad = /iPad/.test(navigator.userAgent);
	isIpad = isIpad && /OS 6/.test(navigator.userAgent);
	isIOS6 = isIOS6 || isIpad;
	if(isFirefox) {
		co.doubleduck.SoundManager.engineType = co.doubleduck.SoundType.AUDIO_FX;
		co.doubleduck.SoundManager.EXTENSION = ".ogg";
		return true;
	}
	if(isChrome && (!isAndroid && !isMobile)) {
		co.doubleduck.SoundManager.engineType = co.doubleduck.SoundType.WEB_AUDIO;
		co.doubleduck.audio.WebAudioAPI.webAudioInit();
		co.doubleduck.SoundManager.EXTENSION = ".ogg";
		return true;
	}
	co.doubleduck.SoundManager.engineType = co.doubleduck.SoundType.NONE;
	co.doubleduck.BasePersistence.initVar("mute");
	return false;
}
co.doubleduck.SoundManager.mute = function(persisted) {
	if(persisted == null) persisted = true;
	if(!co.doubleduck.SoundManager.available) return;
	co.doubleduck.SoundManager._muted = true;
	var _g1 = 0, _g = Reflect.fields(co.doubleduck.SoundManager._cache).length;
	while(_g1 < _g) {
		var currSound = _g1++;
		var mySound = Reflect.getProperty(co.doubleduck.SoundManager._cache,Reflect.fields(co.doubleduck.SoundManager._cache)[currSound]);
		if(mySound != null) mySound.setVolume(0);
	}
	if(persisted) co.doubleduck.SoundManager.setPersistedMute(co.doubleduck.SoundManager._muted);
}
co.doubleduck.SoundManager.unmute = function(persisted) {
	if(persisted == null) persisted = true;
	if(!co.doubleduck.SoundManager.available) return;
	co.doubleduck.SoundManager._muted = false;
	try {
		var _g1 = 0, _g = Reflect.fields(co.doubleduck.SoundManager._cache).length;
		while(_g1 < _g) {
			var currSound = _g1++;
			var mySound = Reflect.getProperty(co.doubleduck.SoundManager._cache,Reflect.fields(co.doubleduck.SoundManager._cache)[currSound]);
			if(mySound != null) mySound.setVolume(1);
		}
	} catch( e ) {
		null;
	}
	if(persisted) co.doubleduck.SoundManager.setPersistedMute(co.doubleduck.SoundManager._muted);
}
co.doubleduck.SoundManager.toggleMute = function() {
	if(co.doubleduck.SoundManager._muted) co.doubleduck.SoundManager.unmute(); else co.doubleduck.SoundManager.mute();
}
co.doubleduck.SoundManager.isMuted = function() {
	co.doubleduck.SoundManager._muted = co.doubleduck.SoundManager.getPersistedMute();
	return co.doubleduck.SoundManager._muted;
}
co.doubleduck.SoundManager.getAudioInstance = function(src) {
	if(!co.doubleduck.SoundManager.available) return new co.doubleduck.audio.DummyAudioAPI();
	src += co.doubleduck.SoundManager.EXTENSION;
	var audio = Reflect.getProperty(co.doubleduck.SoundManager._cache,src);
	if(audio == null) {
		switch( (co.doubleduck.SoundManager.engineType)[1] ) {
		case 1:
			audio = new co.doubleduck.audio.AudioFX(src);
			break;
		case 0:
			audio = new co.doubleduck.audio.WebAudioAPI(src);
			break;
		case 2:
			audio = new co.doubleduck.audio.NonOverlappingAudio(src);
			break;
		case 3:
			audio = new co.doubleduck.audio.HowlerAudio(src);
			break;
		case 4:
			return new co.doubleduck.audio.DummyAudioAPI();
		}
		Reflect.setProperty(co.doubleduck.SoundManager._cache,src,audio);
	}
	return audio;
}
co.doubleduck.SoundManager.playEffect = function(src,volume,optional) {
	if(optional == null) optional = false;
	if(volume == null) volume = 1;
	if(optional && co.doubleduck.SoundManager.engineType == co.doubleduck.SoundType.AUDIO_NO_OVERLAP) return new co.doubleduck.audio.DummyAudioAPI();
	var audio = co.doubleduck.SoundManager.getAudioInstance(src);
	var playVolume = volume;
	if(co.doubleduck.SoundManager._muted) playVolume = 0;
	audio.playEffect(playVolume);
	return audio;
}
co.doubleduck.SoundManager.playMusic = function(src,volume,loop) {
	if(loop == null) loop = true;
	if(volume == null) volume = 1;
	var audio = co.doubleduck.SoundManager.getAudioInstance(src);
	var playVolume = volume;
	if(co.doubleduck.SoundManager._muted) playVolume = 0;
	audio.playMusic(playVolume,loop);
	return audio;
}
co.doubleduck.SoundManager.initSound = function(src) {
	co.doubleduck.SoundManager.getAudioInstance(src);
}
co.doubleduck.SoundManager.prototype = {
	__class__: co.doubleduck.SoundManager
}
co.doubleduck.Splash = $hxClasses["co.doubleduck.Splash"] = function() {
	createjs.Container.call(this);
	this._locations = new Hash();
	this._sea = co.doubleduck.BaseAssets.getImage("images/splash/sea.png");
	this._sky = co.doubleduck.BaseAssets.getImage("images/splash/sky.png");
	this._clouds = co.doubleduck.BaseAssets.getImage("images/splash/clouds.png");
	this._mountain = co.doubleduck.BaseAssets.getImage("images/splash/mountain.png");
	this._island = co.doubleduck.BaseAssets.getImage("images/splash/island.png");
	this._lava = co.doubleduck.BaseAssets.getImage("images/splash/eruption.png");
	this._smoke = co.doubleduck.BaseAssets.getImage("images/splash/smoke.png");
	this._tapToPlay = co.doubleduck.BaseAssets.getImage("images/splash/tap.png");
	this._logoContainer = new createjs.Container();
	this._tiki = co.doubleduck.BaseAssets.getImage("images/splash/logo.png");
	this._t1 = co.doubleduck.BaseAssets.getImage("images/splash/t1.png");
	this._t2 = co.doubleduck.BaseAssets.getImage("images/splash/t2.png");
	this._e = co.doubleduck.BaseAssets.getImage("images/splash/e.png");
	this._x = co.doubleduck.BaseAssets.getImage("images/splash/x.png");
	this.placeGraphics();
	this.startAnimation();
};
co.doubleduck.Splash.__name__ = ["co","doubleduck","Splash"];
co.doubleduck.Splash.__super__ = createjs.Container;
co.doubleduck.Splash.prototype = $extend(createjs.Container.prototype,{
	flashBang: function() {
		var overlay = co.doubleduck.Utils.getRectangle(new createjs.Rectangle(0,0,co.doubleduck.BaseGame.getScreenSize().width,co.doubleduck.BaseGame.getScreenSize().height),"#FFFFFF");
		this.addChild(overlay);
		createjs.Tween.get(overlay).wait(100).to({ alpha : 0},400,createjs.Ease.sineOut).call($bind(this,this.removeChild),[overlay]);
	}
	,shake: function(obj,shakes,cb) {
		if(shakes == 0) {
			if(cb != null) cb();
			return;
		}
		var delta = 3;
		createjs.Tween.get(obj).to({ x : obj.x + (delta - Std.random(delta * 2)), y : obj.y + (delta - Std.random(delta * 2))},25).to({ x : obj.x, y : obj.y},25).call($bind(this,this.shake),[obj,shakes - 1,cb]);
	}
	,replaceSimilarObjects: function(target,ref) {
		target.regX = ref.regX;
		target.regY = ref.regY;
		target.y = ref.y;
		target.x = ref.x;
		target.scaleX = ref.scaleX;
		target.scaleY = ref.scaleY;
		target.mouseEnabled = ref.mouseEnabled;
		this.addChildAt(target,this.getChildIndex(ref));
		this.removeChild(ref);
	}
	,changeColors: function() {
		var mountain2 = co.doubleduck.BaseAssets.getImage("images/splash/mountain2.png");
		var sea2 = co.doubleduck.BaseAssets.getImage("images/splash/sea2.png");
		var sky2 = co.doubleduck.BaseAssets.getImage("images/splash/sky2.png");
		var island2 = co.doubleduck.BaseAssets.getImage("images/splash/island2.png");
		this.replaceSimilarObjects(island2,this._island);
		this.replaceSimilarObjects(mountain2,this._mountain);
		this.replaceSimilarObjects(sky2,this._sky);
		this.replaceSimilarObjects(sea2,this._sea);
		this.removeChild(this._clouds);
		this._mountain = mountain2;
		this._sky = sky2;
		this._sea = sea2;
		this._island = island2;
	}
	,alphaFlicker: function(obj) {
		createjs.Tween.get(obj).to({ alpha : 0},800,createjs.Ease.sineIn).to({ alpha : 1},800,createjs.Ease.sineOut).call($bind(this,this.alphaFlicker),[obj]);
	}
	,showTapToPlay: function() {
		this.addChild(this._tapToPlay);
		this._tapToPlay.alpha = 0;
		this.alphaFlicker(this._tapToPlay);
		co.doubleduck.Utils.setCenterReg(this._tapToPlay);
		this._tapToPlay.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		this._tapToPlay.y = this._sea.y + 50;
		this.endSplash();
	}
	,replaceIndexZ: function(target,dest) {
		var parent = target.parent;
		parent.addChildAt(target,parent.getChildIndex(dest));
	}
	,showLogo: function() {
		this._logoContainer.addChild(this._tiki);
		this._logoContainer.addChild(this._t1);
		this._logoContainer.addChild(this._e);
		this._logoContainer.addChild(this._x);
		this._logoContainer.addChild(this._t2);
		this.addChild(this._logoContainer);
		this._logoContainer.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		this._logoContainer.y = 25;
		var letters = [this._t1,this._e,this._x,this._t2];
		var _g = 0;
		while(_g < letters.length) {
			var l = letters[_g];
			++_g;
			l.y = co.doubleduck.BaseGame.getScreenSize().height;
		}
		this._tiki.y = this._logoContainer.globalToLocal(0,-300).y;
		this._logoContainer.regX = this._tiki.image.width / 2;
		var pos = this.localToLocal(this._smoke.x,this._smoke.y,this._logoContainer);
		this._logoContainer.addChildAt(this._smoke,0);
		this._smoke.x = pos.x;
		this._smoke.y = pos.y;
		createjs.Tween.get(this._tiki).to({ y : 50},250,createjs.Ease.sineOut).to({ y : 0},200,createjs.Ease.sineOut);
		var _g1 = 0, _g = letters.length;
		while(_g1 < _g) {
			var i = _g1++;
			var block = letters[i];
			createjs.Tween.get(block).wait(350 + 150 * i).to({ y : -50},400,createjs.Ease.sineOut).to({ y : 0},200,createjs.Ease.sineOut);
			if(i == letters.length - 1) co.doubleduck.Utils.waitAndCall(null,350 + 150 * i + 200,$bind(this,this.showTapToPlay));
		}
	}
	,continueEruption: function() {
		this.addChildAt(this._lava,this.getChildIndex(this._mountain));
		this._lava.y = this._mountain.y - this._mountain.image.height - this._lava.image.height + 15;
		this._lava.x = this._mountain.x - this._lava.image.width / 2 + 15;
		this.addChildAt(this._smoke,this.getChildIndex(this._mountain));
		co.doubleduck.Utils.setCenterReg(this._smoke);
		this._smoke.x = this._mountain.x + 5;
		this._smoke.y = this._mountain.y - this._mountain.image.height - 26;
		this._smoke.scaleX = this._smoke.scaleY = 0.7;
		this._smoke.alpha = 0;
		createjs.Tween.get(this._smoke).to({ scaleX : 1, scaleY : 1, alpha : 1},500,createjs.Ease.sineOut).call($bind(this,this.showLogo));
		createjs.Tween.get(this._mountain).to({ scaleX : 1, scaleY : 1},300,createjs.Ease.sineOut);
		this._lava.y += 50;
		createjs.Tween.get(this._lava).to({ y : this._lava.y - 50},400,createjs.Ease.sineOut);
	}
	,volcanoDistort: function() {
		createjs.Tween.get(this._mountain).to({ scaleX : 1.2, scaleY : 0.5},300,createjs.Ease.sineOut).wait(200).to({ scaleX : 0.7, scaleY : 1.3},100,createjs.Ease.sineOut).call($bind(this,this.flashBang)).call($bind(this,this.changeColors)).call($bind(this,this.continueEruption));
	}
	,volcanoShake: function() {
		this.shake(this._mountain,10,$bind(this,this.volcanoDistort));
	}
	,moveInIsland: function() {
		createjs.Tween.get(this._island).to({ y : this._locations.get("island").y},1000,createjs.Ease.sineOut);
		createjs.Tween.get(this._mountain).to({ y : this._locations.get("mountain").y},1000,createjs.Ease.sineOut).wait(500).call($bind(this,this.volcanoShake));
	}
	,startAnimation: function() {
		co.doubleduck.Utils.waitAndCall(null,100,$bind(this,this.moveInIsland));
		createjs.Tween.get(this._clouds).to({ y : this._locations.get("clouds").y},1200,createjs.Ease.sineOut);
	}
	,endSplash: function() {
		if(this.onSplashEnd != null) this.onSplashEnd();
	}
	,placeGraphics: function() {
		co.doubleduck.Utils.setCenterReg(this._sky);
		this._sky.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		this._sky.y = co.doubleduck.BaseGame.getScreenSize().height / 2;
		this._sky.mouseEnabled = true;
		this.addChild(this._sky);
		this._sea.y = this._sky.y + this._sky.image.height / 2 - this._sea.image.height;
		this.addChild(this._clouds);
		this._locations.set("clouds",new createjs.Point(0,-100));
		this._clouds.alpha = 0.8;
		this.addChild(this._mountain);
		this._mountain.regY = this._mountain.image.height;
		this._mountain.regX = this._mountain.image.width / 2;
		this._mountain.x += this._mountain.image.width / 2;
		this._locations.set("mountain",new createjs.Point(0,this._sea.y + this._sea.image.height - this._island.image.height + this._mountain.image.height));
		this._mountain.y = this._locations.get("mountain").y + 300;
		this._locations.set("island",new createjs.Point(0,this._sea.y + this._sea.image.height - this._island.image.height));
		this.addChild(this._island);
		this._island.y = this._locations.get("island").y + 300 - 50;
		this.addChild(this._sea);
	}
	,_locations: null
	,_x: null
	,_e: null
	,_t2: null
	,_t1: null
	,_tiki: null
	,_logoContainer: null
	,_tapToPlay: null
	,_smoke: null
	,_lava: null
	,_island: null
	,_mountain: null
	,_clouds: null
	,_sky: null
	,_sea: null
	,onSplashEnd: null
	,__class__: co.doubleduck.Splash
});
co.doubleduck.Transition = $hxClasses["co.doubleduck.Transition"] = function() {
	createjs.Container.call(this);
	if(co.doubleduck.Transition._allowInstantiation == false) return;
	this.name = "Transition";
	this._blackOverlay = new createjs.Shape();
	this._blackOverlay.graphics.beginFill("#000000");
	this._blackOverlay.graphics.drawRect(0,0,co.doubleduck.BaseGame.getScreenSize().width,co.doubleduck.BaseGame.getScreenSize().height);
	this._blackOverlay.graphics.endFill();
	this.addChild(this._blackOverlay);
	this._blackOverlay.alpha = 0;
};
co.doubleduck.Transition.__name__ = ["co","doubleduck","Transition"];
co.doubleduck.Transition._instance = null;
co.doubleduck.Transition.getInstance = function() {
	co.doubleduck.Transition._allowInstantiation = true;
	if(co.doubleduck.Transition._instance != null) return co.doubleduck.Transition._instance;
	var instance = new co.doubleduck.Transition();
	co.doubleduck.Transition._instance = instance;
	return instance;
}
co.doubleduck.Transition.transitionIn = function() {
	if(co.doubleduck.Transition._instance == null) return;
	co.doubleduck.Transition._instance._blackOverlay.alpha = 1;
	createjs.Tween.get(co.doubleduck.Transition._instance._blackOverlay).to({ alpha : 0},1000);
}
co.doubleduck.Transition.transitionOut = function(handler,params) {
	if(co.doubleduck.Transition._instance == null) return;
	co.doubleduck.Transition._instance._blackOverlay.alpha = 0;
	createjs.Tween.get(co.doubleduck.Transition._instance._blackOverlay).to({ alpha : 1},500).call(handler,params);
}
co.doubleduck.Transition.__super__ = createjs.Container;
co.doubleduck.Transition.prototype = $extend(createjs.Container.prototype,{
	_blackOverlay: null
	,__class__: co.doubleduck.Transition
});
co.doubleduck.Utils = $hxClasses["co.doubleduck.Utils"] = function() { }
co.doubleduck.Utils.__name__ = ["co","doubleduck","Utils"];
co.doubleduck.Utils.dateDeltaInDays = function(day1,day2) {
	var delta = Math.abs(day2.getTime() - day1.getTime());
	return delta / 86400000;
}
co.doubleduck.Utils.getTodayDate = function() {
	var newDate = new Date();
	return HxOverrides.dateStr(newDate);
}
co.doubleduck.Utils.getHour = function() {
	var newDate = new Date();
	return newDate.getHours();
}
co.doubleduck.Utils.rectOverlap = function(r1,r2) {
	var r1TopLeft = new createjs.Point(r1.x,r1.y);
	var r1BottomRight = new createjs.Point(r1.x + r1.width,r1.y + r1.height);
	var r1TopRight = new createjs.Point(r1.x + r1.width,r1.y);
	var r1BottomLeft = new createjs.Point(r1.x,r1.y + r1.height);
	var r2TopLeft = new createjs.Point(r2.x,r2.y);
	var r2BottomRight = new createjs.Point(r2.x + r2.width,r2.y + r2.height);
	var r2TopRight = new createjs.Point(r2.x + r2.width,r2.y);
	var r2BottomLeft = new createjs.Point(r2.x,r2.y + r2.height);
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1BottomLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2BottomLeft)) return true;
	return false;
}
co.doubleduck.Utils.overlap = function(obj1,obj1Width,obj1Height,obj2,obj2Width,obj2Height) {
	var o1TopLeft = new createjs.Point(obj1.x - obj1.regX * co.doubleduck.BaseGame.getScale(),obj1.y - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o1BottomRight = new createjs.Point(o1TopLeft.x - obj1.regX * co.doubleduck.BaseGame.getScale() + obj1Width * co.doubleduck.BaseGame.getScale(),o1TopLeft.y + obj1Height * co.doubleduck.BaseGame.getScale() - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o1TopRight = new createjs.Point(o1BottomRight.x - obj1.regX * co.doubleduck.BaseGame.getScale(),o1TopLeft.y - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o1BottomLeft = new createjs.Point(o1TopLeft.x - obj1.regX * co.doubleduck.BaseGame.getScale(),o1BottomRight.y - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o2TopLeft = new createjs.Point(obj2.x - obj2.regX * co.doubleduck.BaseGame.getScale(),obj2.y - obj2.regY * co.doubleduck.BaseGame.getScale());
	var o2BottomRight = new createjs.Point(o2TopLeft.x + obj2Width * co.doubleduck.BaseGame.getScale() - obj2.regX * co.doubleduck.BaseGame.getScale(),o2TopLeft.y + obj2Height * co.doubleduck.BaseGame.getScale() - obj2.regY * co.doubleduck.BaseGame.getScale());
	var o2TopRight = new createjs.Point(o2BottomRight.x - obj2.regX * co.doubleduck.BaseGame.getScale(),o2TopLeft.y - obj2.regY * co.doubleduck.BaseGame.getScale());
	var o2BottomLeft = new createjs.Point(o2TopLeft.x - obj2.regX * co.doubleduck.BaseGame.getScale(),o2BottomRight.y - obj2.regY * co.doubleduck.BaseGame.getScale());
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1BottomLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2BottomLeft)) return true;
	return false;
}
co.doubleduck.Utils.rectContainPoint = function(rectTopLeft,rectBottomRight,point) {
	return point.x >= rectTopLeft.x && point.x <= rectBottomRight.x && point.y >= rectTopLeft.y && point.y <= rectBottomRight.y;
}
co.doubleduck.Utils.objectContains = function(dyn,memberName) {
	return Reflect.hasField(dyn,memberName);
}
co.doubleduck.Utils.contains = function(arr,obj) {
	var _g = 0;
	while(_g < arr.length) {
		var element = arr[_g];
		++_g;
		if(element == obj) return true;
	}
	return false;
}
co.doubleduck.Utils.isMobileFirefox = function() {
	var isFirefox = /Firefox/.test(navigator.userAgent);
	return isFirefox && viewporter.ACTIVE;
}
co.doubleduck.Utils.get = function(x,y,tiles,columns) {
	return tiles[columns * y + x];
}
co.doubleduck.Utils.getBitmapLabel = function(label,fontType,padding) {
	if(padding == null) padding = 0;
	if(fontType == null) fontType = "";
	var fontHelper = new co.doubleduck.FontHelper(fontType);
	var bitmapText = fontHelper.getNumber(Std.parseInt(label),1,true,null,padding);
	return bitmapText;
}
co.doubleduck.Utils.concatWithoutDuplicates = function(array,otherArray) {
	var _g = 0;
	while(_g < otherArray.length) {
		var element = otherArray[_g];
		++_g;
		co.doubleduck.Utils.addToArrayWithoutDuplicates(array,element);
	}
	return array;
}
co.doubleduck.Utils.addToArrayWithoutDuplicates = function(array,element) {
	var _g = 0;
	while(_g < array.length) {
		var currElement = array[_g];
		++_g;
		if(currElement == element) return array;
	}
	array.push(element);
	return array;
}
co.doubleduck.Utils.getImageData = function(image) {
	var ctx = co.doubleduck.Utils.getCanvasContext();
	var img = co.doubleduck.BaseAssets.getImage(image);
	ctx.drawImage(img.image,0,0);
	return ctx.getImageData(0,0,img.image.width,img.image.height);
}
co.doubleduck.Utils.getCanvasContext = function() {
	var dom = js.Lib.document.createElement("Canvas");
	var canvas = dom;
	return canvas.getContext("2d");
}
co.doubleduck.Utils.joinArrays = function(a1,a2) {
	var arr = a1.slice();
	var _g = 0;
	while(_g < a2.length) {
		var el = a2[_g];
		++_g;
		arr.push(el);
	}
	return arr;
}
co.doubleduck.Utils.getRandomElement = function(arr) {
	return arr[Std.random(arr.length)];
}
co.doubleduck.Utils.splitArray = function(arr,parts) {
	var arrs = new Array();
	var _g = 0;
	while(_g < parts) {
		var p = _g++;
		arrs.push(new Array());
	}
	var currArr = 0;
	while(arr.length > 0) {
		arrs[currArr].push(arr.pop());
		currArr++;
		currArr %= parts;
	}
	return arrs;
}
co.doubleduck.Utils.map = function(value,aMin,aMax,bMin,bMax) {
	if(bMax == null) bMax = 1;
	if(bMin == null) bMin = 0;
	if(value <= aMin) return bMin;
	if(value >= aMax) return bMax;
	return (value - aMin) * (bMax - bMin) / (aMax - aMin) + bMin;
}
co.doubleduck.Utils.waitAndCall = function(parent,delay,func,args) {
	createjs.Tween.get(parent).wait(delay).call(func,args);
}
co.doubleduck.Utils.tintBitmap = function(src,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier) {
	var colorFilter = new createjs.ColorFilter(redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
	src.cache(src.x,src.y,src.image.width,src.image.height);
	src.filters = [colorFilter];
	src.updateCache();
}
co.doubleduck.Utils.containBitmaps = function(bitmapList,spacing,isRow,dims) {
	if(isRow == null) isRow = true;
	if(spacing == null) spacing = 0;
	var totalWidth = 0;
	var totalHeight = 0;
	var result = new createjs.Container();
	var _g1 = 0, _g = bitmapList.length;
	while(_g1 < _g) {
		var currBitmap = _g1++;
		var bmp = bitmapList[currBitmap];
		bmp.regY = bmp.image.height / 2;
		if(currBitmap != 0) {
			if(isRow) {
				bmp.x = bitmapList[currBitmap - 1].x + bitmapList[currBitmap - 1].image.width + spacing;
				if(bmp.image.height > totalHeight) totalHeight = bmp.image.height;
				totalWidth += bmp.image.width + spacing;
			} else {
				bmp.y = bitmapList[currBitmap - 1].y + bitmapList[currBitmap - 1].image.height + spacing;
				if(bmp.image.width > totalWidth) totalWidth = bmp.image.width;
				totalHeight += bmp.image.height + spacing;
			}
		} else {
			totalWidth = bmp.image.width;
			totalHeight = bmp.image.height;
		}
		result.addChild(bmp);
	}
	result.regX = totalWidth / 2;
	result.regY = totalHeight / 2;
	if(dims != null) {
		dims.width = totalWidth;
		dims.height = totalHeight;
	}
	return result;
}
co.doubleduck.Utils.getCenteredImage = function(name,scaleToGame) {
	if(scaleToGame == null) scaleToGame = false;
	var img = co.doubleduck.BaseAssets.getImage(name);
	img.regX = img.image.width / 2;
	img.regY = img.image.height / 2;
	if(scaleToGame) img.scaleX = img.scaleY = co.doubleduck.BaseGame.getScale();
	return img;
}
co.doubleduck.Utils.setCenterReg = function(bmp) {
	bmp.regX = bmp.image.width / 2;
	bmp.regY = bmp.image.height / 2;
}
co.doubleduck.Utils.shuffleArray = function(arr) {
	var tmp, j, i = arr.length;
	while(i > 0) {
		j = Math.random() * i | 0;
		tmp = arr[--i];
		arr[i] = arr[j];
		arr[j] = tmp;
	}
}
co.doubleduck.Utils.scaleObject = function(obj) {
	obj.scaleX = obj.scaleY = co.doubleduck.BaseGame.getScale();
}
co.doubleduck.Utils.getRectangle = function(rect,color) {
	var ret = new createjs.Shape();
	ret.graphics.beginFill(color);
	ret.graphics.drawRect(rect.x,rect.y,rect.width,rect.height);
	ret.graphics.endFill();
	return ret;
}
co.doubleduck.Utils.getDistance = function(p1,p2) {
	var distX = p1.x - p2.x;
	var distY = p1.y - p2.y;
	var dist = Math.sqrt(distX * distX + distY * distY);
	return dist;
}
co.doubleduck.Utils.average = function(arr) {
	var sum = 0;
	var _g = 0;
	while(_g < arr.length) {
		var i = arr[_g];
		++_g;
		sum += i;
	}
	return sum / arr.length;
}
co.doubleduck.Utils.radToDeg = function(rad) {
	return rad * 180 / Math.PI;
}
co.doubleduck.Utils.degToRad = function(deg) {
	return deg * Math.PI / 180;
}
co.doubleduck.Utils.sign = function(num) {
	if(num < 0) return -1; else if(num > 0) return 1;
	return 0;
}
co.doubleduck.Utils.loadSpriteSheet = function(imgPath,numberOfFrames,animName,animFrequency,centerReg) {
	if(centerReg == null) centerReg = true;
	if(animFrequency == null) animFrequency = 1;
	var ret;
	var data = { };
	var img = co.doubleduck.BaseAssets.getRawImage(imgPath);
	var numFrames = numberOfFrames;
	var imageHeight = 0;
	var imageWidth = 0;
	if(img.width > img.height) {
		imageWidth = img.width / numFrames;
		imageHeight = img.height;
	} else {
		imageHeight = img.height / numFrames;
		imageWidth = img.width;
	}
	if(centerReg) data.frames = { width : imageWidth, height : imageHeight, regX : imageWidth / 2, regY : imageHeight / 2}; else data.frames = { width : imageWidth, height : imageHeight};
	data.images = [img];
	data.animations = { };
	var framesArr = [];
	var _g = 0;
	while(_g < numFrames) {
		var i = _g++;
		framesArr.push(i);
	}
	data[animName] = { frames : framesArr, frequency : 5};
	ret = new createjs.SpriteSheet(data);
	return ret;
}
co.doubleduck.Volcano = $hxClasses["co.doubleduck.Volcano"] = function() {
	createjs.Container.call(this);
	this._multiplier = co.doubleduck.DataLoader.getInstance().getAllGameplayData().volcanoMultiplier;
	this._scoreLimit = co.doubleduck.DataLoader.getInstance().getAllGameplayData().volcanoLimit | 0;
	this._decay = co.doubleduck.DataLoader.getInstance().getAllGameplayData().volcanoDecay;
	this._eruptionTime = co.doubleduck.DataLoader.getInstance().getAllGameplayData().volcanoTime;
	this._isErupting = false;
	this._shakes = [];
	this._background = co.doubleduck.Utils.getCenteredImage("images/session/bg1.png");
	this._backgroundBonanza = co.doubleduck.Utils.getCenteredImage("images/session/bg2.png");
	this._background.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
	this._background.y = co.doubleduck.BaseGame.getScreenSize().height / 2;
	this._backgroundBonanza.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
	this._backgroundBonanza.y = co.doubleduck.BaseGame.getScreenSize().height / 2;
	this.addChild(this._background);
	this.addChild(this._backgroundBonanza);
	this._grass = co.doubleduck.BaseAssets.getImage("images/session/grass1.png");
	this._grassBonanza = co.doubleduck.BaseAssets.getImage("images/session/grass2.png");
	this._grass.y = this._background.y + this._background.image.height / 2 - this._grass.image.height;
	this._grassBonanza.y = this._background.y + this._background.image.height / 2 - this._grass.image.height;
	this._volcanoContainer = new createjs.Container();
	this._volcanoBack = co.doubleduck.BaseAssets.getImage("images/session/volcano_bg.png");
	this._volcanoFront = co.doubleduck.BaseAssets.getImage("images/session/volcano.png");
	this._lavaEruptionBg = co.doubleduck.BaseAssets.getImage("images/session/eruption2.png");
	this._lavaEruption = co.doubleduck.BaseAssets.getImage("images/session/eruption1.png");
	this._lava = co.doubleduck.BaseAssets.getImage("images/session/lava.png");
	this._volcanoContainer.addChild(this._volcanoBack);
	this._volcanoContainer.addChild(this._lava);
	this._volcanoContainer.addChild(this._lavaEruptionBg);
	this._volcanoContainer.addChild(this._lavaEruption);
	this._volcanoContainer.addChild(this._volcanoFront);
	this._volcanoFront.regX = this._volcanoFront.image.width / 2;
	this._volcanoFront.x = this._volcanoBack.x + this._volcanoBack.image.width / 2;
	this._lavaEruption.y = -this._lavaEruption.image.height + this._volcanoBack.image.height;
	this._volcanoContainer.regX = this._volcanoBack.image.width / 2;
	this._volcanoContainer.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
	this._volcanoContainer.y = this._grass.y - this._volcanoBack.image.height + this._grass.image.height / 2 - 14;
	this.addChild(this._volcanoContainer);
	this._volcanoContainer.regY = this._volcanoBack.image.height;
	this._volcanoContainer.y += this._volcanoBack.image.height;
	this._lavaMask = co.doubleduck.Utils.getRectangle(new createjs.Rectangle(0,0,this._lava.image.width,this._lava.image.height),"#000000");
	this._lavaMask.regY = this._lava.image.height;
	this._lavaMask.y += this._lava.image.height;
	this._lava.mask = this._lavaMask;
	this._lavaMask.scaleY = 0.01;
	this.addChild(this._grass);
	this.addChild(this._grassBonanza);
	this._smokeLeft = co.doubleduck.BaseAssets.getImage("images/session/smoke_l.png");
	this._smokeRight = co.doubleduck.BaseAssets.getImage("images/session/smoke_r.png");
	this._smokeRight.y -= 20;
	this._smokeLeft.y -= 20;
	this._smokeLeft.x -= this._smokeLeft.image.width;
	this._smokeRight.regX = this._smokeRight.image.width;
	this._smokeRight.x = co.doubleduck.BaseGame.getScreenSize().width + this._smokeRight.image.width;
	this.addChild(this._smokeRight);
	this.addChild(this._smokeLeft);
	this.setNeutralOn(true);
	this.setLavaEruptionOn(false);
	this.setBonanzaOn(false);
	var board = co.doubleduck.BaseAssets.getImage("images/session/board.png");
	this.addChild(board);
	board.y = co.doubleduck.BaseGame.getScreenSize().height - board.image.height;
};
co.doubleduck.Volcano.__name__ = ["co","doubleduck","Volcano"];
co.doubleduck.Volcano.__super__ = createjs.Container;
co.doubleduck.Volcano.prototype = $extend(createjs.Container.prototype,{
	destroy: function() {
		this.disable();
	}
	,updateMask: function() {
		if(this._progression == 0) this._progression = 0.01;
		this._lavaMask.scaleY = this._progression;
	}
	,moveSmoke: function(smoke) {
		if(!smoke.visible) return;
		createjs.Tween.get(smoke).to({ y : smoke.y - 10},500,createjs.Ease.sineOut).to({ y : smoke.y},500,createjs.Ease.sineOut).call($bind(this,this.moveSmoke),[smoke]);
	}
	,bringSmoke: function() {
		var baseTime = this._eruptionTime * 1000;
		this._smokeRight.x = co.doubleduck.BaseGame.getScreenSize().width + this._smokeRight.image.width;
		this._smokeLeft.x = -this._smokeLeft.image.width;
		createjs.Tween.removeTweens(this._smokeLeft);
		createjs.Tween.removeTweens(this._smokeRight);
		createjs.Tween.get(this._smokeLeft).to({ x : -20},300,createjs.Ease.sineOut).call($bind(this,this.moveSmoke),[this._smokeLeft]).wait(Math.floor(baseTime * 0.8)).to({ x : this._smokeLeft.x},baseTime * 0.5,createjs.Ease.sineOut);
		createjs.Tween.get(this._smokeRight).to({ x : co.doubleduck.BaseGame.getScreenSize().width},300,createjs.Ease.sineOut).wait(200).call($bind(this,this.moveSmoke),[this._smokeRight]).wait(Math.floor(baseTime * 0.8)).to({ x : this._smokeRight.x},baseTime * 0.5,createjs.Ease.sineOut);
	}
	,flashBang: function() {
		var overlay = co.doubleduck.Utils.getRectangle(new createjs.Rectangle(0,0,co.doubleduck.BaseGame.getScreenSize().width,co.doubleduck.BaseGame.getScreenSize().height),"#FFFFFF");
		this.addChild(overlay);
		createjs.Tween.get(overlay).wait(100).to({ alpha : 0},400,createjs.Ease.sineOut).call($bind(this,this.removeChild),[overlay]);
	}
	,setNeutralOn: function(flag) {
		this._background.visible = flag;
		this._grass.visible = flag;
	}
	,setLavaEruptionOn: function(flag) {
		this._lavaEruption.visible = flag;
		this._lavaEruptionBg.visible = flag;
		this._smokeLeft.visible = flag;
		this._smokeRight.visible = flag;
	}
	,setBonanzaOn: function(flag) {
		this._backgroundBonanza.visible = flag;
		this._grassBonanza.visible = flag;
	}
	,handleEruptionEnd: function() {
		if(this.onEruptionEnd != null) this.onEruptionEnd();
		this._eruptionStamp = 0;
		this._isErupting = false;
		this.setNeutralOn(true);
		var arr = [this._backgroundBonanza,this._grassBonanza,this._lavaEruption,this._lavaEruptionBg,this._smokeLeft,this._smokeRight];
		var _g = 0;
		while(_g < arr.length) {
			var obj = arr[_g];
			++_g;
			createjs.Tween.get(obj).to({ alpha : 0},500,createjs.Ease.sineIn).call($bind(this,this.setBonanzaOn),[false]).call($bind(this,this.setLavaEruptionOn),[false]).to({ alpha : 1},0);
		}
	}
	,animateLava: function() {
		if(this._lavaEruption.visible == true) createjs.Tween.get(this._lavaEruption).to({ y : this._lavaEruption.y + 50},0).wait(60).to({ y : this._lavaEruption.y},0).wait(60).call($bind(this,this.animateLava)); else createjs.Tween.removeTweens(this._lavaEruption);
	}
	,erupt: function() {
		this.setBonanzaOn(true);
		this.setLavaEruptionOn(true);
		this.setNeutralOn(false);
		this._progression = 0;
		this.animateLava();
		this.bringSmoke();
		createjs.Tween.get(this._volcanoContainer).to({ scaleX : 1, scaleY : 1},300,createjs.Ease.sineOut);
	}
	,handleEruption: function() {
		if(this.onEruption != null) this.onEruption();
		this._eruptionStamp = this._eruptionTime;
		this._isErupting = true;
		createjs.Tween.get(this._volcanoContainer).to({ scaleX : 1.3, scaleY : 0.6},200,createjs.Ease.sineOut).wait(100).to({ scaleX : 0.9, scaleY : 1.2},150,createjs.Ease.sineOut).call($bind(this,this.flashBang)).call($bind(this,this.erupt));
	}
	,stopShake: function(obj) {
		if(Lambda.indexOf(this._shakes,this._volcanoContainer) != -1) HxOverrides.remove(this._shakes,obj);
	}
	,shake: function(obj,forceShake) {
		if(forceShake == null) forceShake = false;
		if(!forceShake) {
			if(Lambda.indexOf(this._shakes,obj) != -1) return;
			this._shakes.push(obj);
		}
		if(Lambda.indexOf(this._shakes,obj) != -1) {
			var delta = 3;
			createjs.Tween.get(obj).to({ x : obj.x + (delta - Std.random(delta * 2)), y : obj.y + (delta - Std.random(delta * 2))},25).to({ x : obj.x, y : obj.y},25).call($bind(this,this.shake),[obj,true]);
		}
	}
	,handleTick: function(elapsed) {
		this._progression -= elapsed / 1000 * (this._decay * this._scoreLimit);
		if(this._progression < 0) this._progression = 0;
		if(this._progression >= 0.6) {
			this.shake(this._volcanoContainer);
			if(this._progression >= 1) {
				if(!this._isErupting) this.handleEruption();
			}
		} else this.stopShake(this._volcanoContainer);
		if(this._isErupting) {
			this._eruptionStamp -= elapsed / 1000;
			if(this._eruptionStamp < 0) this.handleEruptionEnd();
		}
		this.updateMask();
	}
	,addScore: function(score) {
		if(!this._isErupting) {
			var prog = score / this._scoreLimit;
			this._progression += prog;
		}
	}
	,getMultiplier: function() {
		if(this._isErupting) return this._multiplier; else return 1;
	}
	,disable: function() {
		this.onTick = null;
		createjs.Tween.removeTweens(this._volcanoContainer);
		createjs.Tween.removeTweens(this._lavaEruption);
	}
	,enable: function() {
		this.onTick = $bind(this,this.handleTick);
	}
	,onEruptionEnd: null
	,onEruption: null
	,_shakes: null
	,_eruptionStamp: null
	,_eruptionTime: null
	,_decay: null
	,_scoreLimit: null
	,_isErupting: null
	,_progression: null
	,_multiplier: null
	,_smokeLeft: null
	,_smokeRight: null
	,_lavaEruptionBg: null
	,_lavaEruption: null
	,_volcanoContainer: null
	,_lavaMask: null
	,_volcanoBack: null
	,_lava: null
	,_volcanoFront: null
	,_grassBonanza: null
	,_grass: null
	,_backgroundBonanza: null
	,_background: null
	,__class__: co.doubleduck.Volcano
});
co.doubleduck.audio.AudioFX = $hxClasses["co.doubleduck.audio.AudioFX"] = function(src) {
	this._jsAudio = null;
	this._src = src;
	this._loop = false;
	this._volume = 1;
};
co.doubleduck.audio.AudioFX.__name__ = ["co","doubleduck","audio","AudioFX"];
co.doubleduck.audio.AudioFX.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.AudioFX._currentlyPlaying = null;
co.doubleduck.audio.AudioFX.prototype = {
	setVolume: function(volume) {
		this._volume = volume;
		if(this._jsAudio != null) this._jsAudio.setVolume(volume);
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		this._jsAudio.stop();
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop,co.doubleduck.SoundManager.audioPoolSize);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,load: function(isLoop,pool) {
		if(pool == null) pool = 1;
		var pathNoExtension = this._src;
		this._jsAudio = AudioFX(pathNoExtension, { loop: isLoop, pool: pool });
	}
	,init: function() {
	}
	,_volume: null
	,_loop: null
	,_jsAudio: null
	,_src: null
	,__class__: co.doubleduck.audio.AudioFX
}
co.doubleduck.audio.DummyAudioAPI = $hxClasses["co.doubleduck.audio.DummyAudioAPI"] = function() {
};
co.doubleduck.audio.DummyAudioAPI.__name__ = ["co","doubleduck","audio","DummyAudioAPI"];
co.doubleduck.audio.DummyAudioAPI.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.DummyAudioAPI.prototype = {
	setVolume: function(volume) {
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
	}
	,init: function() {
	}
	,__class__: co.doubleduck.audio.DummyAudioAPI
}
co.doubleduck.audio.HowlerAudio = $hxClasses["co.doubleduck.audio.HowlerAudio"] = function(src) {
	this._jsAudio = null;
	this._src = src;
	this._loop = false;
	this._volume = 1;
};
co.doubleduck.audio.HowlerAudio.__name__ = ["co","doubleduck","audio","HowlerAudio"];
co.doubleduck.audio.HowlerAudio.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.HowlerAudio._currentlyPlaying = null;
co.doubleduck.audio.HowlerAudio.prototype = {
	setVolume: function(volume) {
		this._volume = volume;
		if(this._jsAudio != null) this._jsAudio.volume = volume;
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		this._jsAudio.stop();
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop,1);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,load: function(isLoop,pool) {
		if(pool == null) pool = 1;
		var pathNoExtension = this._src;
		var myUrls = new Array();
		myUrls.push(this._src + ".mp3");
		myUrls.push(this._src + ".ogg");
		this._jsAudio = new Howl({urls: myUrls, loop: false});
	}
	,init: function() {
	}
	,_volume: null
	,_loop: null
	,_jsAudio: null
	,_src: null
	,__class__: co.doubleduck.audio.HowlerAudio
}
co.doubleduck.audio.NonOverlappingAudio = $hxClasses["co.doubleduck.audio.NonOverlappingAudio"] = function(src) {
	this._src = src;
	this.load();
	this._isMusic = false;
};
co.doubleduck.audio.NonOverlappingAudio.__name__ = ["co","doubleduck","audio","NonOverlappingAudio"];
co.doubleduck.audio.NonOverlappingAudio.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying = null;
co.doubleduck.audio.NonOverlappingAudio.prototype = {
	getSrc: function() {
		return this._src;
	}
	,audio: function() {
		return this._audio;
	}
	,setVolume: function(volume) {
		if(this._audio != null) this._audio.volume = volume;
	}
	,pause: function() {
		if(this._audio != null) this._audio.pause();
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		if(this._isMusic) co.doubleduck.audio.NonOverlappingAudio._musicPlaying = false;
		if(this._audio != null) {
			this._audio.removeEventListener("ended",$bind(this,this.handleEnded));
			this._audio.currentTime = 0;
			this._audio.pause();
		}
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(volume == null) volume = 1;
		if(co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying != null) co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying.stop();
		this._isMusic = true;
		co.doubleduck.audio.NonOverlappingAudio._musicPlaying = true;
		this._audio.play();
		this._audio.volume = volume;
		this._audio.loop = loop;
		if(!loop) this._audio.addEventListener("ended",$bind(this,this.stop));
	}
	,handleEnded: function() {
		this._audio.removeEventListener("ended",$bind(this,this.handleEnded));
		this._audio.currentTime = 0;
	}
	,handleTimeUpdate: function() {
		if(this._audio.currentTime >= this._audio.duration - 0.3) this.stop();
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		if(co.doubleduck.audio.NonOverlappingAudio._musicPlaying) return;
		if(overrideOtherEffects && co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying != null) co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying.stop();
		this._audio.play();
		this._audio.volume = volume;
		this._audio.loop = loop;
		if(!loop) this._audio.addEventListener("ended",$bind(this,this.stop));
		co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying = this;
	}
	,handleError: function() {
	}
	,handleCanPlay: function() {
	}
	,load: function() {
		this._audio = new Audio();
		this._audio.src = this._src;
		this._audio.initialTime = 0;
		this._audio.addEventListener("canplaythrough",$bind(this,this.handleCanPlay));
		this._audio.addEventListener("onerror",$bind(this,this.handleError));
	}
	,init: function() {
	}
	,_isMusic: null
	,_audio: null
	,_src: null
	,__class__: co.doubleduck.audio.NonOverlappingAudio
}
if(!co.doubleduck.ui) co.doubleduck.ui = {}
co.doubleduck.ui.EndModal = $hxClasses["co.doubleduck.ui.EndModal"] = function(playerScore,opponentScore,opponentId) {
	createjs.Container.call(this);
	this._duration = 500;
	this._modal = new createjs.Container();
	this._opponentId = opponentId;
	this._isFinalBattle = false;
	if(playerScore < opponentScore) this._hasWon = false; else this._hasWon = true;
	if(this._hasWon && this.isLastBattle() && this._opponentId == co.doubleduck.DataLoader.getInstance().getAllOpponents().length) this._isFinalBattle = true;
	this.initGraphics();
	this._font = new co.doubleduck.FontHelper("images/session/numbers/");
	this._fontBig = new co.doubleduck.FontHelper("images/session/numbers_big/");
	if(this._hasWon) {
		this._playerScore = this.getScoreText(playerScore,true,true);
		this._opponentScore = this.getScoreText(opponentScore,false,false);
	} else {
		this._playerScore = this.getScoreText(playerScore,false,true);
		this._opponentScore = this.getScoreText(opponentScore,true,false);
	}
	this._modal.addChild(this._playerScore);
	this._modal.addChild(this._opponentScore);
};
co.doubleduck.ui.EndModal.__name__ = ["co","doubleduck","ui","EndModal"];
co.doubleduck.ui.EndModal._instance = null;
co.doubleduck.ui.EndModal.getInstance = function(playerScore,opponentScore,opponentId) {
	if(co.doubleduck.ui.EndModal._instance == null) co.doubleduck.ui.EndModal._instance = new co.doubleduck.ui.EndModal(playerScore,opponentScore,opponentId);
	return co.doubleduck.ui.EndModal._instance;
}
co.doubleduck.ui.EndModal.destroy = function() {
	co.doubleduck.ui.EndModal._instance = null;
}
co.doubleduck.ui.EndModal.__super__ = createjs.Container;
co.doubleduck.ui.EndModal.prototype = $extend(createjs.Container.prototype,{
	isLastBattle: function() {
		return co.doubleduck.Persistence.getVictories(this._opponentId) == (co.doubleduck.DataLoader.getInstance().getOpponentById(this._opponentId).requiredWins | 0);
	}
	,darkenScreen: function() {
		this._overlay = co.doubleduck.Utils.getRectangle(new createjs.Rectangle(0,0,co.doubleduck.BaseGame.getScreenSize().width,co.doubleduck.BaseGame.getScreenSize().height),"#000000");
		this.addChild(this._overlay);
		this._overlay.alpha = 0;
		createjs.Tween.get(this._overlay).to({ alpha : 0.8},this._duration);
	}
	,dropModal: function() {
		this.addChild(this._modal);
		createjs.Tween.get(this._modal).to({ y : co.doubleduck.BaseGame.getScreenSize().height / 2 + 25},this._duration,createjs.Ease.sineOut).to({ y : co.doubleduck.BaseGame.getScreenSize().height / 2 - 5},this._duration / 2,createjs.Ease.sineOut);
	}
	,handleNextClicked: function(e) {
		e.target.onClick = null;
		if(this.onNextClick != null) this.onNextClick();
	}
	,handleRetryClicked: function(e) {
		e.target.onClick = null;
		if(this.onRetryClick != null) this.onRetryClick();
	}
	,handleMenuClicked: function(e) {
		e.target.onClick = null;
		if(this.onMenuClick != null) this.onMenuClick();
	}
	,initGraphics: function() {
		this._modalBackground = co.doubleduck.BaseAssets.getImage("images/session/finish/finish.png");
		if(this._hasWon) this._message = co.doubleduck.BaseAssets.getImage("images/session/finish/win.png"); else this._message = co.doubleduck.BaseAssets.getImage("images/session/finish/lose.png");
		this._modal.addChild(this._modalBackground);
		this._modal.addChild(this._message);
		this._modal.regX = this._modalBackground.image.width / 2;
		this._modal.regY = this._modalBackground.image.height / 2;
		this._modal.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		this._modal.y = co.doubleduck.BaseGame.getScreenSize().height / 2;
		co.doubleduck.Utils.setCenterReg(this._message);
		this._message.x = this._modalBackground.image.width / 2;
		this._message.y = 110;
		this._retryBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/finish/retry.png"));
		this._retryBtn.onClick = $bind(this,this.handleRetryClicked);
		this._menuBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/finish/menu.png"));
		this._menuBtn.onClick = $bind(this,this.handleMenuClicked);
		this._nextBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/finish/next.png"));
		this._nextBtn.onClick = $bind(this,this.handleNextClicked);
		var btnArr;
		if(this._hasWon) {
			if(this.isLastBattle()) btnArr = [this._menuBtn]; else btnArr = [this._menuBtn,this._nextBtn];
		} else btnArr = [this._menuBtn,this._retryBtn];
		this._buttonContainer = co.doubleduck.Utils.containBitmaps(btnArr,10);
		this._modal.addChild(this._buttonContainer);
		this._buttonContainer.x = this._modalBackground.image.width / 2;
		this._buttonContainer.y = this._modalBackground.image.height + 5;
	}
	,getScoreText: function(score,bigFont,isPlayer) {
		var dims = new createjs.Rectangle(0,0,0,0);
		var scoreText;
		if(!bigFont) scoreText = this._font.getNumber(score,1,true,dims,-4); else scoreText = this._fontBig.getNumber(score,1,true,dims,-4);
		if(isPlayer) {
			scoreText.x = this._modalBackground.image.width / 2;
			scoreText.y = 208;
		} else {
			scoreText.x = this._modalBackground.image.width / 2;
			scoreText.y = 280;
		}
		return scoreText;
	}
	,showFinalMessage: function() {
		var finalMessage = co.doubleduck.BaseAssets.getImage("images/endgame/endgame.png");
		co.doubleduck.Utils.setCenterReg(finalMessage);
		this.addChild(finalMessage);
		finalMessage.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		finalMessage.y = co.doubleduck.BaseGame.getScreenSize().height / 2;
		finalMessage.alpha = 0;
		this._menuBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/finish/menu.png"));
		this._menuBtn.onClick = $bind(this,this.handleMenuClicked);
		this.addChild(this._menuBtn);
		this._menuBtn.regX = this._menuBtn.image.width / 2;
		this._menuBtn.regY = this._menuBtn.image.height / 2;
		this._menuBtn.x = co.doubleduck.BaseGame.getScreenSize().width - this._menuBtn.image.height;
		this._menuBtn.y = co.doubleduck.BaseGame.getScreenSize().height - this._menuBtn.image.height;
		this._menuBtn.alpha = 0;
		createjs.Tween.get(finalMessage).to({ alpha : 1},this._duration);
		createjs.Tween.get(this._menuBtn).wait(500).to({ alpha : 1},this._duration);
	}
	,animateIn: function() {
		if(!this._isFinalBattle) {
			this._modal.y = -co.doubleduck.BaseGame.getScreenSize().height;
			this.darkenScreen();
			co.doubleduck.Utils.waitAndCall(null,this._duration,$bind(this,this.dropModal));
		} else {
			this._modal.y = -co.doubleduck.BaseGame.getScreenSize().height;
			this.darkenScreen();
			co.doubleduck.Utils.waitAndCall(null,this._duration,$bind(this,this.dropModal));
			this._buttonContainer.visible = false;
			co.doubleduck.Utils.waitAndCall(null,3500,$bind(this,this.showFinalMessage));
		}
	}
	,onNextClick: null
	,onMenuClick: null
	,onRetryClick: null
	,_isFinalBattle: null
	,_opponentId: null
	,_hasWon: null
	,_duration: null
	,_fontBig: null
	,_font: null
	,_opponentScore: null
	,_playerScore: null
	,_nextBtn: null
	,_menuBtn: null
	,_retryBtn: null
	,_message: null
	,_modalBackground: null
	,_buttonContainer: null
	,_overlay: null
	,_modal: null
	,__class__: co.doubleduck.ui.EndModal
});
co.doubleduck.ui.HUD = $hxClasses["co.doubleduck.ui.HUD"] = function() {
	createjs.Container.call(this);
	this.construct();
	this._font = new co.doubleduck.FontHelper("images/session/numbers/");
	this._fontBig = new co.doubleduck.FontHelper("images/session/numbers_big/");
};
co.doubleduck.ui.HUD.__name__ = ["co","doubleduck","ui","HUD"];
co.doubleduck.ui.HUD.__super__ = createjs.Container;
co.doubleduck.ui.HUD.prototype = $extend(createjs.Container.prototype,{
	setEnemyScore: function(score,tween,small) {
		if(small == null) small = true;
		if(tween == null) tween = false;
		if(this._enemyScoreValue != null) {
			this.removeChild(this._enemyScoreValue);
			this._enemyScoreValue = null;
		}
		var dims = new createjs.Rectangle(0,0,0,0);
		if(small) this._enemyScoreValue = this._font.getNumber(score,1,true,dims,-4); else {
			this._enemyScoreValue = this._fontBig.getNumber(score,1,true,dims,-6);
			this._enemyScoreValue.scaleY = this._enemyScoreValue.scaleX = 0.9;
		}
		this._enemyScoreValue.x = this._opponent.x - this._opponent.getWidth() * 0.97 + dims.width / 2;
		this._enemyScoreValue.x += 13;
		this._enemyScoreValue.y = this._opponent.y + this._opponent.getHeight() * 0.75;
		this._enemyScoreValue.y += 7;
		this.addChild(this._enemyScoreValue);
		if(tween) {
			this._enemyScoreValue.scaleX = this._enemyScoreValue.scaleY = 1.8;
			createjs.Tween.get(this._enemyScoreValue).to({ scaleX : 0.9, scaleY : 0.9},300,createjs.Ease.sineOut);
		}
	}
	,setRemainingSecs: function(secs) {
		if(this._timerValue != null) {
			this.removeChild(this._timerValue);
			this._timerValue = null;
		}
		this._timerValue = this._font.getNumber(secs,1,true,null,-5);
		this._timerValue.x = this._timerBg.x - 15;
		this._timerValue.y = this._timerBg.y;
		this.addChild(this._timerValue);
	}
	,setUserScore: function(score,tween,small) {
		if(small == null) small = true;
		if(tween == null) tween = false;
		if(this._scoreValue != null) {
			this.removeChild(this._scoreValue);
			this._scoreValue = null;
		}
		var dims = new createjs.Rectangle(0,0,0,0);
		if(small) this._scoreValue = this._font.getNumber(score,1,true,dims,-4); else {
			this._scoreValue = this._fontBig.getNumber(score,1,true,dims,-6);
			this._scoreValue.scaleY = this._enemyScoreValue.scaleX = 0.9;
		}
		this._scoreValue.x = this._scoreBg.x + this._scoreBg.image.width * 0.9 - dims.width / 2;
		this._scoreValue.y = this._scoreBg.y + this._scoreBg.image.height * 0.78;
		this._scoreValue.y += 7;
		this.addChild(this._scoreValue);
		if(tween) {
			this._scoreValue.scaleX = this._scoreValue.scaleY = 1.8;
			createjs.Tween.get(this._scoreValue).to({ scaleX : 0.9, scaleY : 0.9},300,createjs.Ease.sineOut);
		}
	}
	,setScore: function(userScore,enemyScore,tween) {
		if(tween == null) tween = false;
		if(enemyScore == null) enemyScore = -1;
		if(userScore == null) userScore = -1;
		var tweenUser = false;
		var tweenEnemy = false;
		if(userScore != -1) {
			this._userScore = userScore;
			tweenUser = tween;
		}
		if(enemyScore != -1) {
			this._enemyScore = enemyScore;
			tweenEnemy = tween;
		}
		if(this._userScore == this._enemyScore) {
			this.setUserScore(this._userScore,tweenUser,true);
			this.setEnemyScore(this._enemyScore,tweenEnemy,true);
		} else if(this._userScore > this._enemyScore) {
			this.setUserScore(this._userScore,tweenUser,false);
			this.setEnemyScore(this._enemyScore,tweenEnemy,true);
		} else {
			this.setUserScore(this._userScore,tweenUser,true);
			this.setEnemyScore(this._enemyScore,tweenEnemy,false);
		}
	}
	,setOpponent: function(opp) {
		this._opponent = opp;
		this.addChild(this._opponent);
		this._opponent.regX = this._opponent.getWidth();
		this._opponent.regY = 0;
		this._opponent.x = co.doubleduck.BaseGame.getScreenSize().width;
		this.fadeIn(this._opponent);
	}
	,fadeIn: function(obj,time) {
		if(time == null) time = 500;
		obj.alpha = 0;
		createjs.Tween.get(obj).to({ alpha : 1},time,createjs.Ease.sineOut);
	}
	,handleQuitClick: function(e) {
		if(this.onQuitClick != null) {
			e.target.onClick = null;
			this.onQuitClick();
		}
	}
	,construct: function() {
		this._timerBg = co.doubleduck.Utils.getCenteredImage("images/session/timer.png");
		this._timerBg.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		this._timerBg.y = this._timerBg.image.height / 2;
		this.addChild(this._timerBg);
		this._scoreBg = co.doubleduck.BaseAssets.getImage("images/session/score.png");
		this.addChild(this._scoreBg);
		var quitBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/quit.png"));
		this.addChild(quitBtn);
		quitBtn.x = 5;
		quitBtn.y = 5;
		quitBtn.onClick = $bind(this,this.handleQuitClick);
		this.fadeIn(this._timerBg);
		this.fadeIn(this._scoreBg);
	}
	,onQuitClick: null
	,_userScore: null
	,_enemyScore: null
	,_opponent: null
	,_enemyScoreValue: null
	,_scoreValue: null
	,_scoreBg: null
	,_fontBig: null
	,_font: null
	,_timerValue: null
	,_timerBg: null
	,__class__: co.doubleduck.ui.HUD
});
var haxe = haxe || {}
haxe.Log = $hxClasses["haxe.Log"] = function() { }
haxe.Log.__name__ = ["haxe","Log"];
haxe.Log.trace = function(v,infos) {
	js.Boot.__trace(v,infos);
}
haxe.Log.clear = function() {
	js.Boot.__clear_trace();
}
haxe.Public = $hxClasses["haxe.Public"] = function() { }
haxe.Public.__name__ = ["haxe","Public"];
haxe.StackItem = $hxClasses["haxe.StackItem"] = { __ename__ : ["haxe","StackItem"], __constructs__ : ["CFunction","Module","FilePos","Method","Lambda"] }
haxe.StackItem.CFunction = ["CFunction",0];
haxe.StackItem.CFunction.toString = $estr;
haxe.StackItem.CFunction.__enum__ = haxe.StackItem;
haxe.StackItem.Module = function(m) { var $x = ["Module",1,m]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.StackItem.FilePos = function(s,file,line) { var $x = ["FilePos",2,s,file,line]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.StackItem.Method = function(classname,method) { var $x = ["Method",3,classname,method]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.StackItem.Lambda = function(v) { var $x = ["Lambda",4,v]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.Stack = $hxClasses["haxe.Stack"] = function() { }
haxe.Stack.__name__ = ["haxe","Stack"];
haxe.Stack.callStack = function() {
	var oldValue = Error.prepareStackTrace;
	Error.prepareStackTrace = function(error,callsites) {
		var stack = [];
		var _g = 0;
		while(_g < callsites.length) {
			var site = callsites[_g];
			++_g;
			var method = null;
			var fullName = site.getFunctionName();
			if(fullName != null) {
				var idx = fullName.lastIndexOf(".");
				if(idx >= 0) {
					var className = HxOverrides.substr(fullName,0,idx);
					var methodName = HxOverrides.substr(fullName,idx + 1,null);
					method = haxe.StackItem.Method(className,methodName);
				}
			}
			stack.push(haxe.StackItem.FilePos(method,site.getFileName(),site.getLineNumber()));
		}
		return stack;
	};
	var a = haxe.Stack.makeStack(new Error().stack);
	a.shift();
	Error.prepareStackTrace = oldValue;
	return a;
}
haxe.Stack.exceptionStack = function() {
	return [];
}
haxe.Stack.toString = function(stack) {
	var b = new StringBuf();
	var _g = 0;
	while(_g < stack.length) {
		var s = stack[_g];
		++_g;
		b.b += Std.string("\nCalled from ");
		haxe.Stack.itemToString(b,s);
	}
	return b.b;
}
haxe.Stack.itemToString = function(b,s) {
	var $e = (s);
	switch( $e[1] ) {
	case 0:
		b.b += Std.string("a C function");
		break;
	case 1:
		var m = $e[2];
		b.b += Std.string("module ");
		b.b += Std.string(m);
		break;
	case 2:
		var line = $e[4], file = $e[3], s1 = $e[2];
		if(s1 != null) {
			haxe.Stack.itemToString(b,s1);
			b.b += Std.string(" (");
		}
		b.b += Std.string(file);
		b.b += Std.string(" line ");
		b.b += Std.string(line);
		if(s1 != null) b.b += Std.string(")");
		break;
	case 3:
		var meth = $e[3], cname = $e[2];
		b.b += Std.string(cname);
		b.b += Std.string(".");
		b.b += Std.string(meth);
		break;
	case 4:
		var n = $e[2];
		b.b += Std.string("local function #");
		b.b += Std.string(n);
		break;
	}
}
haxe.Stack.makeStack = function(s) {
	if(typeof(s) == "string") {
		var stack = s.split("\n");
		var m = [];
		var _g = 0;
		while(_g < stack.length) {
			var line = stack[_g];
			++_g;
			m.push(haxe.StackItem.Module(line));
		}
		return m;
	} else return s;
}
if(!haxe.unit) haxe.unit = {}
haxe.unit.TestCase = $hxClasses["haxe.unit.TestCase"] = function() {
};
haxe.unit.TestCase.__name__ = ["haxe","unit","TestCase"];
haxe.unit.TestCase.__interfaces__ = [haxe.Public];
haxe.unit.TestCase.prototype = {
	assertEquals: function(expected,actual,c) {
		this.currentTest.done = true;
		if(actual != expected) {
			this.currentTest.success = false;
			this.currentTest.error = "expected '" + Std.string(expected) + "' but was '" + Std.string(actual) + "'";
			this.currentTest.posInfos = c;
			throw this.currentTest;
		}
	}
	,assertFalse: function(b,c) {
		this.currentTest.done = true;
		if(b == true) {
			this.currentTest.success = false;
			this.currentTest.error = "expected false but was true";
			this.currentTest.posInfos = c;
			throw this.currentTest;
		}
	}
	,assertTrue: function(b,c) {
		this.currentTest.done = true;
		if(b == false) {
			this.currentTest.success = false;
			this.currentTest.error = "expected true but was false";
			this.currentTest.posInfos = c;
			throw this.currentTest;
		}
	}
	,print: function(v) {
		haxe.unit.TestRunner.print(v);
	}
	,tearDown: function() {
	}
	,setup: function() {
	}
	,currentTest: null
	,__class__: haxe.unit.TestCase
}
haxe.unit.TestResult = $hxClasses["haxe.unit.TestResult"] = function() {
	this.m_tests = new List();
	this.success = true;
};
haxe.unit.TestResult.__name__ = ["haxe","unit","TestResult"];
haxe.unit.TestResult.prototype = {
	toString: function() {
		var buf = new StringBuf();
		var failures = 0;
		var $it0 = this.m_tests.iterator();
		while( $it0.hasNext() ) {
			var test = $it0.next();
			if(test.success == false) {
				buf.b += Std.string("* ");
				buf.b += Std.string(test.classname);
				buf.b += Std.string("::");
				buf.b += Std.string(test.method);
				buf.b += Std.string("()");
				buf.b += Std.string("\n");
				buf.b += Std.string("ERR: ");
				if(test.posInfos != null) {
					buf.b += Std.string(test.posInfos.fileName);
					buf.b += Std.string(":");
					buf.b += Std.string(test.posInfos.lineNumber);
					buf.b += Std.string("(");
					buf.b += Std.string(test.posInfos.className);
					buf.b += Std.string(".");
					buf.b += Std.string(test.posInfos.methodName);
					buf.b += Std.string(") - ");
				}
				buf.b += Std.string(test.error);
				buf.b += Std.string("\n");
				if(test.backtrace != null) {
					buf.b += Std.string(test.backtrace);
					buf.b += Std.string("\n");
				}
				buf.b += Std.string("\n");
				failures++;
			}
		}
		buf.b += Std.string("\n");
		if(failures == 0) buf.b += Std.string("OK "); else buf.b += Std.string("FAILED ");
		buf.b += Std.string(this.m_tests.length);
		buf.b += Std.string(" tests, ");
		buf.b += Std.string(failures);
		buf.b += Std.string(" failed, ");
		buf.b += Std.string(this.m_tests.length - failures);
		buf.b += Std.string(" success");
		buf.b += Std.string("\n");
		return buf.b;
	}
	,add: function(t) {
		this.m_tests.add(t);
		if(!t.success) this.success = false;
	}
	,success: null
	,m_tests: null
	,__class__: haxe.unit.TestResult
}
haxe.unit.TestRunner = $hxClasses["haxe.unit.TestRunner"] = function() {
	this.result = new haxe.unit.TestResult();
	this.cases = new List();
};
haxe.unit.TestRunner.__name__ = ["haxe","unit","TestRunner"];
haxe.unit.TestRunner.print = function(v) {
	var msg = StringTools.htmlEscape(js.Boot.__string_rec(v,"")).split("\n").join("<br/>");
	var d = document.getElementById("haxe:trace");
	if(d == null) alert("haxe:trace element not found"); else d.innerHTML += msg;
}
haxe.unit.TestRunner.customTrace = function(v,p) {
	haxe.unit.TestRunner.print(p.fileName + ":" + p.lineNumber + ": " + Std.string(v) + "\n");
}
haxe.unit.TestRunner.prototype = {
	runCase: function(t) {
		var old = haxe.Log.trace;
		haxe.Log.trace = haxe.unit.TestRunner.customTrace;
		var cl = Type.getClass(t);
		var fields = Type.getInstanceFields(cl);
		haxe.unit.TestRunner.print("Class: " + Type.getClassName(cl) + " ");
		var _g = 0;
		while(_g < fields.length) {
			var f = fields[_g];
			++_g;
			var fname = f;
			var field = Reflect.field(t,f);
			if(StringTools.startsWith(fname,"test") && Reflect.isFunction(field)) {
				t.currentTest = new haxe.unit.TestStatus();
				t.currentTest.classname = Type.getClassName(cl);
				t.currentTest.method = fname;
				t.setup();
				try {
					field.apply(t,new Array());
					if(t.currentTest.done) {
						t.currentTest.success = true;
						haxe.unit.TestRunner.print(".");
					} else {
						t.currentTest.success = false;
						t.currentTest.error = "(warning) no assert";
						haxe.unit.TestRunner.print("W");
					}
				} catch( $e0 ) {
					if( js.Boot.__instanceof($e0,haxe.unit.TestStatus) ) {
						var e = $e0;
						haxe.unit.TestRunner.print("F");
						t.currentTest.backtrace = haxe.Stack.toString(haxe.Stack.exceptionStack());
					} else {
					var e = $e0;
					haxe.unit.TestRunner.print("E");
					if(e.message != null) t.currentTest.error = "exception thrown : " + Std.string(e) + " [" + Std.string(e.message) + "]"; else t.currentTest.error = "exception thrown : " + Std.string(e);
					t.currentTest.backtrace = haxe.Stack.toString(haxe.Stack.exceptionStack());
					}
				}
				this.result.add(t.currentTest);
				t.tearDown();
			}
		}
		haxe.unit.TestRunner.print("\n");
		haxe.Log.trace = old;
	}
	,run: function() {
		this.result = new haxe.unit.TestResult();
		var $it0 = this.cases.iterator();
		while( $it0.hasNext() ) {
			var c = $it0.next();
			this.runCase(c);
		}
		haxe.unit.TestRunner.print(this.result.toString());
		return this.result.success;
	}
	,add: function(c) {
		this.cases.add(c);
	}
	,cases: null
	,result: null
	,__class__: haxe.unit.TestRunner
}
haxe.unit.TestStatus = $hxClasses["haxe.unit.TestStatus"] = function() {
	this.done = false;
	this.success = false;
};
haxe.unit.TestStatus.__name__ = ["haxe","unit","TestStatus"];
haxe.unit.TestStatus.prototype = {
	backtrace: null
	,posInfos: null
	,classname: null
	,method: null
	,error: null
	,success: null
	,done: null
	,__class__: haxe.unit.TestStatus
}
var js = js || {}
js.Boot = $hxClasses["js.Boot"] = function() { }
js.Boot.__name__ = ["js","Boot"];
js.Boot.__unhtml = function(s) {
	return s.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;");
}
js.Boot.__trace = function(v,i) {
	var msg = i != null?i.fileName + ":" + i.lineNumber + ": ":"";
	msg += js.Boot.__string_rec(v,"");
	var d;
	if(typeof(document) != "undefined" && (d = document.getElementById("haxe:trace")) != null) d.innerHTML += js.Boot.__unhtml(msg) + "<br/>"; else if(typeof(console) != "undefined" && console.log != null) console.log(msg);
}
js.Boot.__clear_trace = function() {
	var d = document.getElementById("haxe:trace");
	if(d != null) d.innerHTML = "";
}
js.Boot.isClass = function(o) {
	return o.__name__;
}
js.Boot.isEnum = function(e) {
	return e.__ename__;
}
js.Boot.getClass = function(o) {
	return o.__class__;
}
js.Boot.__string_rec = function(o,s) {
	if(o == null) return "null";
	if(s.length >= 5) return "<...>";
	var t = typeof(o);
	if(t == "function" && (o.__name__ || o.__ename__)) t = "object";
	switch(t) {
	case "object":
		if(o instanceof Array) {
			if(o.__enum__) {
				if(o.length == 2) return o[0];
				var str = o[0] + "(";
				s += "\t";
				var _g1 = 2, _g = o.length;
				while(_g1 < _g) {
					var i = _g1++;
					if(i != 2) str += "," + js.Boot.__string_rec(o[i],s); else str += js.Boot.__string_rec(o[i],s);
				}
				return str + ")";
			}
			var l = o.length;
			var i;
			var str = "[";
			s += "\t";
			var _g = 0;
			while(_g < l) {
				var i1 = _g++;
				str += (i1 > 0?",":"") + js.Boot.__string_rec(o[i1],s);
			}
			str += "]";
			return str;
		}
		var tostr;
		try {
			tostr = o.toString;
		} catch( e ) {
			return "???";
		}
		if(tostr != null && tostr != Object.toString) {
			var s2 = o.toString();
			if(s2 != "[object Object]") return s2;
		}
		var k = null;
		var str = "{\n";
		s += "\t";
		var hasp = o.hasOwnProperty != null;
		for( var k in o ) { ;
		if(hasp && !o.hasOwnProperty(k)) {
			continue;
		}
		if(k == "prototype" || k == "__class__" || k == "__super__" || k == "__interfaces__" || k == "__properties__") {
			continue;
		}
		if(str.length != 2) str += ", \n";
		str += s + k + " : " + js.Boot.__string_rec(o[k],s);
		}
		s = s.substring(1);
		str += "\n" + s + "}";
		return str;
	case "function":
		return "<function>";
	case "string":
		return o;
	default:
		return String(o);
	}
}
js.Boot.__interfLoop = function(cc,cl) {
	if(cc == null) return false;
	if(cc == cl) return true;
	var intf = cc.__interfaces__;
	if(intf != null) {
		var _g1 = 0, _g = intf.length;
		while(_g1 < _g) {
			var i = _g1++;
			var i1 = intf[i];
			if(i1 == cl || js.Boot.__interfLoop(i1,cl)) return true;
		}
	}
	return js.Boot.__interfLoop(cc.__super__,cl);
}
js.Boot.__instanceof = function(o,cl) {
	try {
		if(o instanceof cl) {
			if(cl == Array) return o.__enum__ == null;
			return true;
		}
		if(js.Boot.__interfLoop(o.__class__,cl)) return true;
	} catch( e ) {
		if(cl == null) return false;
	}
	switch(cl) {
	case Int:
		return Math.ceil(o%2147483648.0) === o;
	case Float:
		return typeof(o) == "number";
	case Bool:
		return o === true || o === false;
	case String:
		return typeof(o) == "string";
	case Dynamic:
		return true;
	default:
		if(o == null) return false;
		if(cl == Class && o.__name__ != null) return true; else null;
		if(cl == Enum && o.__ename__ != null) return true; else null;
		return o.__enum__ == cl;
	}
}
js.Boot.__cast = function(o,t) {
	if(js.Boot.__instanceof(o,t)) return o; else throw "Cannot cast " + Std.string(o) + " to " + Std.string(t);
}
js.Lib = $hxClasses["js.Lib"] = function() { }
js.Lib.__name__ = ["js","Lib"];
js.Lib.document = null;
js.Lib.window = null;
js.Lib.debug = function() {
	debugger;
}
js.Lib.alert = function(v) {
	alert(js.Boot.__string_rec(v,""));
}
js.Lib.eval = function(code) {
	return eval(code);
}
js.Lib.setErrorHandler = function(f) {
	js.Lib.onerror = f;
}
function $iterator(o) { if( o instanceof Array ) return function() { return HxOverrides.iter(o); }; return typeof(o.iterator) == 'function' ? $bind(o,o.iterator) : o.iterator; };
var $_;
function $bind(o,m) { var f = function(){ return f.method.apply(f.scope, arguments); }; f.scope = o; f.method = m; return f; };
if(Array.prototype.indexOf) HxOverrides.remove = function(a,o) {
	var i = a.indexOf(o);
	if(i == -1) return false;
	a.splice(i,1);
	return true;
}; else null;
Math.__name__ = ["Math"];
Math.NaN = Number.NaN;
Math.NEGATIVE_INFINITY = Number.NEGATIVE_INFINITY;
Math.POSITIVE_INFINITY = Number.POSITIVE_INFINITY;
$hxClasses.Math = Math;
Math.isFinite = function(i) {
	return isFinite(i);
};
Math.isNaN = function(i) {
	return isNaN(i);
};
String.prototype.__class__ = $hxClasses.String = String;
String.__name__ = ["String"];
Array.prototype.__class__ = $hxClasses.Array = Array;
Array.__name__ = ["Array"];
Date.prototype.__class__ = $hxClasses.Date = Date;
Date.__name__ = ["Date"];
var Int = $hxClasses.Int = { __name__ : ["Int"]};
var Dynamic = $hxClasses.Dynamic = { __name__ : ["Dynamic"]};
var Float = $hxClasses.Float = Number;
Float.__name__ = ["Float"];
var Bool = $hxClasses.Bool = Boolean;
Bool.__ename__ = ["Bool"];
var Class = $hxClasses.Class = { __name__ : ["Class"]};
var Enum = { };
var Void = $hxClasses.Void = { __ename__ : ["Void"]};
if(typeof document != "undefined") js.Lib.document = document;
if(typeof window != "undefined") {
	js.Lib.window = window;
	js.Lib.window.onerror = function(msg,url,line) {
		var f = js.Lib.onerror;
		if(f == null) return false;
		return f(msg,[url + ":" + line]);
	};
}
co.doubleduck.BaseAssets.onLoadAll = null;
co.doubleduck.BaseAssets._loader = null;
co.doubleduck.BaseAssets._cacheData = { };
co.doubleduck.BaseAssets._loadCallbacks = { };
co.doubleduck.BaseAssets.loaded = 0;
co.doubleduck.BaseAssets._useLocalStorage = false;
co.doubleduck.BaseGame._viewport = null;
co.doubleduck.BaseGame._scale = 1;
co.doubleduck.BaseGame.DEBUG = false;
co.doubleduck.BaseGame.LOGO_URI = "images/duckling/splash_logo.png";
co.doubleduck.BaseGame.LOAD_STROKE_URI = "images/duckling/loading_stroke.png";
co.doubleduck.BaseGame.LOAD_FILL_URI = "images/duckling/loading_fill.png";
co.doubleduck.BaseGame.ORIENT_PORT_URI = "images/duckling/orientation_error_port.png";
co.doubleduck.BaseGame.ORIENT_LAND_URI = "images/duckling/orientation_error_land.png";
co.doubleduck.BaseGame.isLocalized = false;
co.doubleduck.BasePersistence.GAME_PREFIX = "DUCK";
co.doubleduck.BasePersistence.available = co.doubleduck.BasePersistence.localStorageSupported();
co.doubleduck.Button.CLICK_TYPE_NONE = 0;
co.doubleduck.Button.CLICK_TYPE_TINT = 1;
co.doubleduck.Button.CLICK_TYPE_JUICY = 2;
co.doubleduck.Button.CLICK_TYPE_SCALE = 3;
co.doubleduck.Button.CLICK_TYPE_TOGGLE = 4;
co.doubleduck.Button.CLICK_TYPE_HOLD = 5;
co.doubleduck.Button._defaultSound = null;
co.doubleduck.LetterBox.SEQUENCE_POS = 0.4;
co.doubleduck.LetterBox.BANK_POS = 0.78;
co.doubleduck.LetterBox.PIXELS_PER_SEC = 1000;
co.doubleduck.LetterBox.MIN_TWEEN_TIME = 100;
co.doubleduck.LetterBox.BANKS_LOC_Y = [0,-0.01,-0.02,-0.03,-0.02,-0.01,0];
co.doubleduck.Menu.SCROLL_EASE = 0.005;
co.doubleduck.Menu.ROW_POS = 0.7;
co.doubleduck.Menu.BTN_PADDING = 10;
co.doubleduck.Persistence.WIN_PREFIX = "wins_for_";
co.doubleduck.audio.WebAudioAPI._buffers = { };
co.doubleduck.SoundManager._muted = false;
co.doubleduck.SoundManager._cache = { };
co.doubleduck.SoundManager.audioPoolSize = 2;
co.doubleduck.SoundManager.available = co.doubleduck.SoundManager.isSoundAvailable();
co.doubleduck.Transition._allowInstantiation = false;
co.doubleduck.audio.AudioFX._muted = false;
co.doubleduck.audio.HowlerAudio._muted = false;
co.doubleduck.audio.NonOverlappingAudio._musicPlaying = false;
js.Lib.onerror = null;
co.doubleduck.Main.main();
