var flagPlay = false;
var valTime = 20*60;
var sound = '';

function secondsToHHMMSS(valSeconds) {
    var sec_num = parseInt(valSeconds, 10); // don't forget the second param
    var hours   = Math.floor(sec_num / 3600);
    var minutes = Math.floor((sec_num - (hours * 3600)) / 60);
    var seconds = sec_num - (hours * 3600) - (minutes * 60);

    if (hours   < 10) {hours   = "0"+hours;}
    if (minutes < 10) {minutes = "0"+minutes;}
    if (seconds < 10) {seconds = "0"+seconds;}
    var time    = hours+':'+minutes+':'+seconds;
    return time;
}


function Countdown(options) {
  var timer,
  instance = this,
  seconds = options.seconds || 10,
  updateStatus = options.onUpdateStatus || function () {},
  counterEnd = options.onCounterEnd || function () {};
  counterStop = options.onCounterStop || function () {};
  counterStart = options.onCounterStart || function () {};
  
  function decrementCounter() {
    updateStatus(seconds);
    if (seconds === 0) {
      counterEnd();
      instance.stop();
    }
    seconds--;
  }

  this.reset = function () {
    clearInterval(timer);
	seconds = options.seconds;
  };

  this.start = function () {
    clearInterval(timer);
    timer = 0;
	if (seconds < 0) instance.reset()
	timer = setInterval(decrementCounter, 1000);
	counterStart();
  }; 
  
  this.stop = function () {
    clearInterval(timer);
	counterStop();
  };
  
  this.setSeconds = function(sec) {
	seconds = sec;
  
  }
}



	
$(document).ready(function() {

var trans = new translateObj({
	'defaultLang':'en',
	'autoDetect': true
});
trans.initTranslate();

	$('#viewPort').transition({ scale: '1.2', opacity: 0}).transition({ scale: '1', opacity: 1});
	
	var sound = $('#audioObject')[0];
	
	var myCounter = new Countdown({  
		seconds:valTime,  // number of seconds to count down
		onCounterStart: function() {
			flagPlay = true;
			$('#btnPlayPause').removeClass('textGreen').addClass('textRed').html(trans.echo('parar'));
		},
		onUpdateStatus: function(sec){
			console.log(sec);
			$('#timerDisplay').html(secondsToHHMMSS(sec));
			}, // callback for each second
		onCounterEnd: function(){
			flagPlay = false;
			sound.play();
			alert(trans.echo('pausar la alarma!'));
			sound.pause(); sound.currentTime = 0;
			//myCounter.stop();
			myCounter.setSeconds(valTime);
		}, // final action
		onCounterStop: function(){
			flagPlay = false;
			$('#btnPlayPause').removeClass('textRed').addClass('textGreen').html(trans.echo('iniciar'));
		} // final action
	});


	$('#timerDisplay').html(secondsToHHMMSS(valTime));



	/*App Menu options*/
	$('#btnHelp').click(function(e) {
		e.preventDefault();
		$('#viewPort').transition({ scale: '0.75', opacity: 0}).delay(30).queue(function(){
			location.href = 'help.html';
		});
	});
	
	$('#btnAbout').click(function(e) {
		e.preventDefault();
		$('#viewPort').transition({ scale: '0.75', opacity: 0}).delay(30).queue(function(){
			location.href = 'about.html';
		});
	});

	$('#btnExit').click(function(e) {
		e.preventDefault();
		window.close();
	});
	
	/*Main butoons actions*/
	$('#btnSelectTime').click(function(e){
		e.preventDefault();
		e.stopPropagation();
		$('#selTime').trigger('focus');
	});
	
	$('#btnResetTime').click(function(e){
		e.preventDefault();
		e.stopPropagation();
		myCounter.setSeconds(valTime);
	});	
	
	
	$('#btnPlayPause').click(function(){
		//flagPlay = flagPlay ? false : true;
		if (!flagPlay) {
			myCounter.start();
		} else {
			myCounter.stop();
		}
	});
	
	$('#selTime').change(function() {
		if ($(this).val() == 'setUser') {
			valTime = parseInt(prompt(trans.echo("cuantos minutos?"),"30"));
			if (isNaN(valTime)) valTime = 1;
		} else {
			valTime = $(this).val();
		}
		valTime = valTime * 60;
		myCounter.setSeconds(valTime);
		$('#timerDisplay').html(secondsToHHMMSS(valTime));
	 });
		
	

	
});

(function($) {
	$(document).ready(function() {
		$.slidebars();
	});
}) (jQuery);