// V 1.04 - 29.04.2014
var trec = {
	timerecDbObj:{},
	timerecTaskArr:[],
	globalrate:0,
	projectTitleData:[],
	projectRateData:[],
	csvData:""
};

function initializeDB() {
	
	if (window.indexedDB) {
	  //console.log("IndexedDB support is there");
	}
	else {
	   alert("Indexed DB is not supported.");
	}
 
	// open the database
	var request = indexedDB.open('timeRec_db', 7);
	
	request.onsuccess = function (e) {
	  // e.target.result has the connection to the database
	  trec.timerecDbObj = e.target.result;
	
	  //global variables
	  getTaskArray();
	  getGlobalRate();
	  getProjectData();
	  
	};
	 
	request.onerror = function (e) {
	   //console.log(e);
	   alert("A database error occurred!");
	};
	 
	// this can only create Object stores in a versionchange transaction.
	request.onupgradeneeded = function (e) {
	   // e.target.result holds the connection to database
	   trec.timerecDbObj = e.target.result;
//trec.timerecDbObj.deleteObjectStore("projects");	   
	   if (!trec.timerecDbObj.objectStoreNames.contains("projects")) {
	     //trec.timerecDbObj.deleteObjectStore("projects");
	     var objectStore = trec.timerecDbObj.createObjectStore('projects', { keyPath: 'id', autoIncrement: true });
//	     console.log("Object Store PROJECTS has been created");
		 objectStore.add({title:"sample project", note:"To book your time records minimum one project and one task required!"});
	   }
	   
//trec.timerecDbObj.deleteObjectStore("tasks");	   
	   if (!trec.timerecDbObj.objectStoreNames.contains("tasks")) {
	     //trec.timerecDbObj.deleteObjectStore("projects");
	     var objectStore = trec.timerecDbObj.createObjectStore('tasks', { keyPath: 'id', autoIncrement: true });
	     objectStore.createIndex("title", "title", { unique: false });
//	     console.log("Object Store TASKS has been created");
		 objectStore.add({title:"sample task"});
	   }

//trec.timerecDbObj.deleteObjectStore("records");	   
	   if (!trec.timerecDbObj.objectStoreNames.contains("records")) {
	     //trec.timerecDbObj.deleteObjectStore("projects");
	     var objectStore = trec.timerecDbObj.createObjectStore('records', { keyPath: 'id', autoIncrement: true });
	     objectStore.createIndex("project_id", "project_id", { unique: false });
//	     console.log("Object Store records has been created");
		 
	   }
	   
//trec.timerecDbObj.deleteObjectStore("settings");	   
	   if (!trec.timerecDbObj.objectStoreNames.contains("settings")) {
	     //trec.timerecDbObj.deleteObjectStore("projects");
	     var objectStore = trec.timerecDbObj.createObjectStore('settings', { keyPath: 'id', autoIncrement: true });
	     //objectStore.createIndex("project_id", "project_id", { unique: false });
//	     console.log("Object Store settings has been created");
	     
	     objectStore.add({id:"1", global_hourly_rate:"0"});
	     
	   }
	   
	   
	};
	
	
}

function stringDate() {
    var temp = new Date();
    var dateStr = padStr(temp.getFullYear()) + "-" +
                  padStr(1 + temp.getMonth()) + "-" +
                  padStr(temp.getDate()) + "_" +
                  padStr(temp.getHours()) + "-" +
                  padStr(temp.getMinutes()) + "-" +
                  padStr(temp.getSeconds());
    //console.log(dateStr);
    return dateStr;
}

function padStr(i) {
    return (i < 10) ? "0" + i : "" + i;
}

function exportSD(){
	
	var sdcard = navigator.getDeviceStorage("sdcard");
	
	if(!sdcard){
		alert("no sdcard found!");
		return;
	}
	
	var file   = new Blob([trec.csvData], {type: "text/plain"});
	var fileName = "TimerecExport_" + stringDate() + ".csv";
	var request = sdcard.addNamed(file, fileName);
	
	request.onsuccess = function () {
	  var name = this.result;
	  alert('File "' + name + '" successfully wrote on the sdcard storage area');
	};
	
	// An error typically occur if a file with the same name already exist
	request.onerror = function () {
	  alert('Unable to write the file: ' + this.error);
	};
}


// global geführete Projekt Daten
function getProjectData(){
	
	var transaction_Pa = trec.timerecDbObj.transaction([ 'projects' ]);
	var store_Pa = transaction_Pa.objectStore('projects');
		
  	// open a cursor to retrieve all items from the 'notes' store
	store_Pa.openCursor().onsuccess = function (e) {
		 var cursor = e.target.result;
		 if (cursor) {
		  	var value = cursor.value;
		  	trec.projectTitleData[value.id] = value.title;
		  	trec.projectRateData[value.id] = parseFloat(value.rate);
			cursor.continue();
		 }
	 }; 
}

//global geführte Task Daten
function getTaskArray(){
	
    var transaction = trec.timerecDbObj.transaction([ 'tasks' ]);
	var store = transaction.objectStore('tasks');
		
	store.openCursor().onsuccess = function (e) {
	   var cursor = e.target.result;
	   
	   if (cursor) {
		  	var value = cursor.value;
		//console.dir(value);
		    if(value.rate){
		    	trec. timerecTaskArr[value.id] = value.rate;
		    }	
		 
			cursor.continue();
		 }
	 };
	 
	 transaction.oncomplete = function(event) {
//	 	console.dir(trec. timerecTaskArr);	 
	 	//return taskArr;
	 };	
}

function getGlobalRate(){
	var transaction = trec.timerecDbObj.transaction([ 'settings' ]);
	var store = transaction.objectStore('settings');
	var request = store.get("1");
	request.onsuccess = function (e) {
		var result = e.target.result;
        //console.dir(result);
        trec.globalrate = parseFloat( result.global_hourly_rate );
 	};
}

/*
// DISPLAY ADD NEW TASK FIELD
function addNewTaskWhileBooking(){
	$("#addNewTaskBtn").css("display", "none");
	$("#addNewTask").css("display", "inline");
}
*/



/*
// ADD NEW TASK TO DB AND RETURN ID
function addNewTask(taskTitle){
	
	  var transaction = trec.timerecDbObj.transaction([ 'tasks' ], 'readwrite');
	  var value = {};
	  value.title = taskTitle;
	  var id;
	 	   
	  var store = transaction.objectStore('tasks');
	  var request = store.add(value);

	  request.onsuccess = function (e) {
	  	  //
	  	  id = request.result; // id läst sich nicht zurückgeben da Fkt returnt bevo DB gespeichert
	  	  //console.log('clos:'+id);
	  	  // return id;
	  };

	  request.onerror = function (e) {
	    console.log("Error in saving the task. Reason : " + e.value);
	  };
	  
}
*/

// LIST SELECT FIELDS FOR BOOKING
function listBookingSelects(page, selTask, selPro) {
	
	//Projects Select
	$("#bookProjectList_"+page).html("");
	
    var transaction = trec.timerecDbObj.transaction([ 'projects' ]);
	var store = transaction.objectStore('projects');
	
	store.openCursor().onsuccess = function (e) {
		 var cursor = e.target.result;
		 if (cursor) {
		  	var value = cursor.value;
		  	var sel = selPro == value.id ? " selected='selected' " : "";
			var proElement = $("<option "+sel+" value='" + value.id + "' />").html(value.title);
			
			$("#bookProjectList_"+page).append(proElement).selectmenu('refresh', true);

			cursor.continue();
		 }
	 }; 
	 
	 //Tasks Select
	 $("#bookTaskList_"+page).html("");
	 
	 var transaction_t = trec.timerecDbObj.transaction([ 'tasks' ]);
	 var store_t = transaction_t.objectStore('tasks');
			
	 store_t.index('title').openCursor().onsuccess = function (e) {
		 var cursor_t = e.target.result;
		 if (cursor_t) {
		  	var value_t = cursor_t.value;
		  	var sel = selTask == value_t.id ? " selected='selected' " : "";
			var TaskTitle = $("<option "+sel+" value='" + value_t.id + "' />").html(value_t.title);
			$("#bookTaskList_"+page).append(TaskTitle).selectmenu('refresh', true);
			cursor_t.continue();
		 }
	 };
	 
	 $("#recordNote").val("");
	 
}




// EDIT A PROJECT
function editProject(pid, title, note, rate){
	$("#editProjectNote").val(note); 
	$("#editProjectTitle").val(title);
	$("#editProjectId").val(pid);

	if(rate != undefined && rate > 1){
		$("#editProjectRate").val(rate);
	} else {
		$("#editProjectRate").val("");
	}

	$.mobile.changePage ($("#editProject"));
}

// FILTER PROJECT DETAILS
function projectDetailsSearch(exflag){
	var pid = parseInt( $("#projectDetailsPid").val() );
	var pdStartDate = $("#pdFilterStartDate").val();
	var pdEndDate = $("#pdFilterEndDate").val();
	var task = $("#filterTask").val(); 
	
//console.log("pod:"+pid);	
//console.log("start:"+pdStartDate)	;
//console.log("end:"+pdEndDate)	;

	var sd = new Date(pdStartDate);
	var ed = new Date(pdEndDate);
	//console.log(foo);
	var sds = sd.getTime();
	var eds = ed.getTime() + (24*60*60*1000);// plus 1 Tag
//console.log(batz);

	showProject(pid, sds, eds, task, "detailTable", false, exflag);
}


function projectDetailsFilterClear(){
	$("#pdFilterStartDate").val("");
	$("#pdFilterEndDate").val("");
	$("#filterTask").html("");
	$("#filterTask").append('<option value="">Select task</option>');
	 
	 var transaction_t = trec.timerecDbObj.transaction([ 'tasks' ]);
	 var store_t = transaction_t.objectStore('tasks');
			
	 store_t.index('title').openCursor().onsuccess = function (e) {
		 var cursor_t = e.target.result;
		 if (cursor_t) {
		  	var value_t = cursor_t.value;
			var TaskTitle = $("<option value='" + value_t.id + "' />").html(value_t.title);
			$("#filterTask").append(TaskTitle).selectmenu('refresh', true);
			cursor_t.continue();
		 }
	 };
}



// SHOW PROJECT DETAILS AND BOOKINGS
function showProject(pid, starttime, endtime, taskFilter, scrollTo, scrollToAlt, exportflag){

//pid = 0;

	$(".navprojects").addClass("ui-btn-active");

	trec.csvData = "";
    var showAllProjects = pid == 0 ? true : false ;
    
	$("#viewProjectBookings").html("");
	$("#projectDetailsPid").val(pid);
	
	var selectedTask;
	var projectRate;
	
	//Filter
	if(starttime == 0 || starttime == undefined){
		$("#pdFilterStartDate").val("");
	}
	
	if(endtime == 0 || endtime == undefined){
		$("#pdFilterEndDate").val("");
	}
	
	if(!isNaN( parseInt( taskFilter ) ))	{
		selectedTask = parseInt( taskFilter );	
	}
	
	
	 //Tasks Select für Filter
	 $("#filterTask").html("");
	 $("#filterTask").append('<option value="">Select task</option>');
	 
	 var transaction_t = trec.timerecDbObj.transaction([ 'tasks' ]);
	 var store_t = transaction_t.objectStore('tasks');
			
	 store_t.index('title').openCursor().onsuccess = function (e) {
		 var cursor_t = e.target.result;
		 if (cursor_t) {
		  	var value_t = cursor_t.value;
		  	var sel = selectedTask == value_t.id ? " selected='selected' " : "";
			var TaskTitle = $("<option "+sel+" value='" + value_t.id + "' />").html(value_t.title);
			$("#filterTask").append(TaskTitle).selectmenu('refresh', true);
			cursor_t.continue();
		 }
	 };
	 
	//Records lesen und in Records Array packen
	var transaction = trec.timerecDbObj.transaction([ 'records' ]);
	var store = transaction.objectStore('records');
	var index = store.index("project_id");
	
	if(showAllProjects){
		var keyRange = IDBKeyRange.lowerBound(1);
	} else {
		var keyRange = IDBKeyRange.only(pid+'');//geht nur mit Strings!
	}
	
	var res_array = new Array();
	var sumTimeRec = 0;
	
	index.openCursor(keyRange).onsuccess = function (e) {
		 var cursor = e.target.result;
		 if (cursor) {
		  	var value = cursor.value;
			var filterFlag = true;
  	
		  	if(starttime && value.timestamp < starttime){
		  		filterFlag = false;
		  	}
		  	
		  	if(endtime && value.timestamp > endtime){
		  		filterFlag = false;
		  	}
		  	
		  	if(taskFilter && parseInt( taskFilter ) != value.task_id ){
		  		filterFlag = false;
		  	}
		  	
		  	if(filterFlag){
		  		res_array.push(value);
		  		sumTimeRec += parseInt(value.timerecorded);
		  	}
			
			cursor.continue();
		 }
	 }; 

 	//Records Array verarbeiten
    transaction.oncomplete = function(event) {
    	
    	if(res_array.length == 0){
    		$("#viewProjectBookings").append("<tr><td style='font-weight:bold;text-align:center;'>No records found!</td><tr>");
    	}	

        res_array.sort(compare);
       
        var thisDate = 0;
        var lastDate = 0;
        var lastIdentDate = new Array();
        var totalAmount = 0;
        var dayAmount = new Array();
        var daytime =  new Array();
        
        var j = 0;
        var bookAmount = new Array();
        var bookRate = new Array();
        var fixamount = new Array();
        
        trec.csvData += '"date","project","task","note","time","rate","fix amount" \r\n';
//console.dir(trec.projectRateData); 
//console.log(trec.projectRateData[pid]);       
        for (var i=0, resle = res_array.length; i < resle; i++) {
        	
        	var printRate = "";
        	fixamount[i] = "";
        	var amount = 0;
        	var multHour = res_array[i].timerecorded / 3600;
//console.log(res_array[i].project_id);        	
        	var tempPid = showAllProjects ? res_array[i].project_id : pid;
        	
        	//Stundensatz summieren (global || pro task || pro Projekt)
        	if(parseInt(res_array[i].booknotval) != 1 && !res_array[i].fixamount){
        		
	        	if(res_array[i].task_id && trec.timerecTaskArr[res_array[i].task_id] > 0){
	        		var hRate = kaufm( trec.timerecTaskArr[res_array[i].task_id]);

        			bookAmount[i] = multHour * hRate;
        			totalAmount += bookAmount[i];
        			bookRate[i] = hRate;

	        	} else if(trec.projectRateData[tempPid] > 0){	
	       			bookAmount[i] = multHour * trec.projectRateData[tempPid];
	        		totalAmount += bookAmount[i];	 
	        		bookRate[i] = trec.projectRateData[tempPid];			
	       		} else {
	        		bookAmount[i] = multHour * trec.globalrate;
	        		totalAmount += bookAmount[i];
	        		bookRate[i] = trec.globalrate;
	        	}
        	} else {
        		bookAmount[i] = 0;
        		bookRate[i] = 0;
        	}
        	// fix Budget überschreibt
        	if(parseFloat(res_array[i].fixamount) > 0){
        		totalAmount += parseFloat(res_array[i].fixamount);
        		fixamount[i] = kaufm(parseFloat(res_array[i].fixamount)); 
        		bookAmount[i] = parseFloat(res_array[i].fixamount);
        		bookRate[i] = 0;
        		printRate = "<br><span class='font08 currencL'>&#36;"+fixamount[i]+"<br>fixed</span>";
        	}
        	
        	var tag = res_array[i].recdate;
        	var tt = tag.getDate() < 10 ? "0" + tag.getDate() : tag.getDate();
        	var mm = (tag.getMonth() +1) < 10 ? "0" + (tag.getMonth() +1) : (tag.getMonth() +1);
        	var yyyy = tag.getFullYear();
        	thisDate = tt+mm+yyyy;
        	
        	// Zeit in h:m
        	var timeForm = formatTime(parseInt(res_array[i].timerecorded));
        	
			// wenn Datum unverändert key aufaddieren
			if(lastDate == (tt+mm+yyyy)){
				dayAmount[thisDate] = dayAmount[thisDate] + bookAmount[i];
				daytime[thisDate] = daytime[thisDate] + parseInt(res_array[i].timerecorded);
				var timeFormDT = false;
				var showAmount = false;
			// wenn neues Datum neuer key	
			} else {
				// beim löschen kann das Ident Datum für den Scroll Anker auch gelöscht sein, deshalb den letzten Ident auch registrieren
				j++;			
				lastIdentDate[j] = thisDate;

				dayAmount[thisDate] = bookAmount[i];
				daytime[thisDate] = parseInt(res_array[i].timerecorded);
				// da immer vom vorherigen Durchlauf berechnet wird fällt i=0 raus
				if(i > 0 /*&& i < (res_array.length -1)*/){
					var timeFormDT = formatTime(daytime[lastDate]);
					if(dayAmount[lastDate] > 0){
						var showAmount = "<span class='currenc'> &nbsp;&nbsp;&#36;" + kaufm(dayAmount[lastDate]) + "</span>";
					} else {
						var showAmount = "";
					}
				} 
			}
			
			var proTitel = showAllProjects === true ? "<br><span class='font08'>("+trec.projectTitleData[tempPid]+")</span>" : "";
			
			printRate = bookRate[i] > 0 ? "<br><span class='font08 currencL'>&#36;" + kaufm(bookRate[i]) + "<br>p.hour</span>" : printRate;
			
    		//Abschlusszeile mit Summen
        	if(timeFormDT){
        		$("#viewProjectBookings").append("<tr class='projectdetails_tablerow_2'><td colspan='3'>" + timeFormDT + "<span style='float:right;'>" + showAmount + "</span></td></tr>");
        		$("#viewProjectBookings").append("<tr><td colspan='3'>&nbsp</td></tr>");
        	}
        	//Zeile CSV
        	var timeFormCsv = timeForm+":00";
        	trec.csvData += yyyy+'-'+mm+'-'+tt+',"'+trec.projectTitleData[tempPid]+'","'+res_array[i].task_title+'","'+res_array[i].note+'",'+timeFormCsv+','+kaufm(bookRate[i])+','+fixamount[i]+' \r\n';
    
        	//Eintrag Tabelle
        	var divEl = lastDate == (tt+mm+yyyy) ? "" : "<tr id='" + thisDate + "' class='projectdetails_tablerow_1'><td colspan='3'>"+yyyy+"-"+mm+"-"+tt+"</td></tr>";
        	divEl += "<tr id='recordbar_" + res_array[i].id + "'>";
        	divEl += "<td rowspan='2'>" + timeForm + printRate + "</td>";
        	divEl += "<td>" + res_array[i].task_title + proTitel + "</td>";
      //class, bind click, rel mit json Daten, in bind Fkt mit this auslesen  	
        	divEl += "<td rowspan='2'><a href='#' class='ehDeleteBooking ui-btn ui-icon-delete ui-btn-icon-notext' rel='{\"id\":" + res_array[i].id + ",\"pid\":" + pid + ",\"date\":\"" + thisDate + "\",\"lastIdentDate\":\"" + lastIdentDate[j-1] + "\"}' ></a> <a href='#' class='ehEditBooking ui-btn ui-icon-edit ui-btn-icon-notext' rel='{\"id\":" + res_array[i].id + ", \"date\":\"" + thisDate + "\"}'></a></td>";
        	divEl += "</tr>";
        	divEl += "<tr><td>"+res_array[i].note+"</td><tr>";
        	lastDate = tt+mm+yyyy;
//onclick='editBooking(" + res_array[i].id + ", \"" + thisDate + "\")' 
//onclick='deleteBooking(" + res_array[i].id + "," + pid + ",\"" + thisDate + "\",\"" + lastIdentDate[j-1] + "\" )'       	
        	$("#viewProjectBookings").append(divEl);
        	
			// letzer Durchlauf braucht auch Abschlusszeile
			if(i == (res_array.length -1)){
				if(dayAmount[thisDate] > 0){
					var showAmount = "<span class='currenc'> &#36;" + kaufm(dayAmount[thisDate]) + "</span>";
				} else {
					var showAmount = "";
				}
				
	        	var timeFormDT = formatTime(daytime[thisDate]);
	        	$("#viewProjectBookings").append("<tr class='projectdetails_tablerow_2'><td colspan='3'>" + timeFormDT +  "<span style='float:right;'>" + showAmount + "</span></td></tr>");
	        	$("#viewProjectBookings").append("<tr><td colspan='3'>&nbsp</td></tr>");
			}
        }
//console.log(trec.csvData);         
        // End Summe	
		if(sumTimeRec > 0){
			if(totalAmount > 0){
				var totalAmountK = "<span class='currenc'> &#36;" + kaufm(totalAmount) + "</span>";
			} else {
				var totalAmountK = "";
			}
			$("#viewProjectBookings").append("<tr id='lastTableElement' class='projectdetails_tablerow_2'><td colspan='3'> TOTAL </td></tr>");
			$("#viewProjectBookings").append("<tr id='lastTableElement' class='projectdetails_tablerow_2'><td colspan='3'>" + formatTime(sumTimeRec) + "<span style='float:right;'>" + totalAmountK + "</span></td></tr>");
		}  
		// Scroll Anweisung bei Record add, edit, delete
		if(scrollTo){
			setTimeout(function(){
				if ($("#"+scrollTo).length > 0){
					$.mobile.silentScroll($("#"+scrollTo).offset().top);
				} else if($("#"+scrollToAlt).length > 0){//wenn Datum ganz gelöscht zum davorliegenden
					$.mobile.silentScroll($("#"+scrollToAlt).offset().top);
				}			
			    
			},700);	
		}
		
		$(document).off('click', '.ehEditBooking');	
		$(document).on('click', '.ehEditBooking', function(){
			var para = JSON.parse( $(this).prop('rel') ); 
			editBooking(para.id, para.date);
		});
		
		$(document).off('click', '.ehDeleteBooking');	
		$(document).on('click', '.ehDeleteBooking', function(){
			var para = JSON.parse( $(this).prop('rel') ); //console.dir(para);
			deleteBooking(para.id, para.pid, para.date, para.lastIdentDate);
		});
		
		if(exportflag){
			exportSD();
		}
        
    };
}

// SORT
function compare(a,b){
	return a['timestamp'] - b['timestamp'];
}

// HILFSFUNKTION
function formatTime(timeInSec){
	// Zeit in h:m
	var min =  (timeInSec / 60) % 60;
    var hour = ((timeInSec / 60) - min) / 60;
    min = Math.round(min);
        	
    var hourForm = hour < 10 ? "0"+hour : hour; 
    var minForm = min < 10 ? "0"+min : min;
    var timeForm = hourForm+':'+minForm;
	
	return timeForm;	
	
}

// DIALOG EDIT RECORD
function editBooking(id, ident){
	$.mobile.changePage ($("#editBooking")); // SEITENWECHSEL DIALOG
	
	$("#editIdent").val(ident);
	
	var transaction = trec.timerecDbObj.transaction([ 'records' ]);
	var store = transaction.objectStore('records');
	var ob = store.get(id);
 
	ob.onsuccess = function(e) {
		var result = e.target.result;
		
		listBookingSelects("2", result.task_id, result.project_id);
		
        //console.dir(result);
        var mintotal = result.timerecorded / 60;
        if(mintotal > 59){
        	var hour = Math.floor(mintotal / 60);
        	var min = Math.round( mintotal % 60);
        } else {
        	var hour = 0;
        	var min = Math.round(mintotal);
        }
//console.log("h:"+hour);
//console.log("m:"+min);        
        
        var hdisplay = hour > 9 ? hour : "0"+hour;
        var mdisplay = min > 9 ? min : "0"+min;
		var displayClock = hdisplay+":"+mdisplay;
//console.log("dc:"+displayClock);		
        
        $("#editRecordNote").val(result.note);
        $("#editRecordingId").val(result.id);
        $("#editDate").val(result.recdate);
        $("#editTimestamp").val(result.timestamp);
        $("#editAnAmount").val(result.fixamount);
       	if(result.booknotval == 1){
       		$("#editNotValued").prop("checked",true).checkboxradio('refresh');
       	} else {
       		$("#editNotValued").prop("checked",false).checkboxradio('refresh');
       	}
        
        var sel;
		var proElement;
		var j;
		
		$("#editBookingTimeInput_h").html("");
		$("#editBookingTimeInput_m").html("");
		
		for(var i=0;i<24;i++){
			sel = hour == i ? " selected='selected' " : "";
			j = i < 10 ? "0"+i : i;
			proElement = $("<option "+sel+" value='" + i + "' />").html(j);
			$("#editBookingTimeInput_h").append(proElement);
		}
		for(var i=0;i<60;i++){
			sel = min == i ? " selected='selected' " : "";
			j = i < 10 ? "0"+i : i;
			proElement = $("<option "+sel+" value='" + i + "' />").html(j);
			$("#editBookingTimeInput_m").append(proElement);
		}
		$("#editBookingTimeInput_h").selectmenu('refresh', true);
		$("#editBookingTimeInput_m").selectmenu('refresh', true);	
        
		 
	};
}

// DELETE A SINGLE RECORD
function deleteBooking(id, pid, identDate, lastIdentDate){
	
	$( "#deleteBooking" ).off().click(function() { // bind an popup 
   			var transaction = trec.timerecDbObj.transaction([ 'records' ], 'readwrite');
			var store = transaction.objectStore('records');
			var request = store.delete(id);
			
			request.onsuccess = function () {
			   
			   showProject(pid,false, false, false, identDate, lastIdentDate);
			   $( "#confirmDeleteBooking" ).popup( "close" );
			};
			request.onerror = function (e) {
			   //console.log("Error while deleting record : " + e.value);
			   alert("A database error occurred!");
			};
   	 });
	
	$( "#confirmDeleteBooking" ).popup( "open");
}

//DELETE BOOKINGS IN BATCH
function deleteProBookings(id){
	if(id){
		var transaction = trec.timerecDbObj.transaction([ 'records' ], 'readwrite');
		var store = transaction.objectStore('records');
		var request = store.delete(id);
	}
	
	request.onsuccess = function () {};
	request.onerror = function (e) {
	   //console.log("Error while deleting record : " + e.value);
	   //alert("A database error occurred!");
	};
	
}


// DIALOG DELETE PROJECT
function dialogDeleteProject(id){
	$("#dialogDeleteProjectId").val(id);
	$.mobile.changePage ($("#dialogDeleteProject"));
}


function editTask(tid, title, rate){
console.log(title);	
	$.mobile.changePage($("#edittask"));
	$("#editTaskId").val(tid);
	$("#editTaskTitle").val(title);
//console.log(rate);	
	if (rate != 'undefined' ){
		$("#editTaskRate").val(rate);
	}else {
		$("#editTaskRate").val("");
	}
	
}


function kaufm(x) {
  var k = (Math.round(x * 100) / 100).toString();
  k += (k.indexOf('.') == -1)? '.00' : '00';
  return k.substring(0, k.indexOf('.') + 3);
}


// DELETE A TASK
function delTask(id){
	
	$( "#deleteTask" ).off().click(function() { // bind an popup 
   		var transaction = trec.timerecDbObj.transaction([ 'tasks' ], 'readwrite');
		var store = transaction.objectStore('tasks');
		var request = store.delete(id);
		request.onsuccess = function () {
	 	   $("#taskbar_"+id).remove();
	 	   $( "#confirmDeleteTask" ).popup( "close" );
	 	   getTaskArray();
		};
		request.onerror = function (e) {
	    	//console.log("Error while deleting tasks : " + e.value);
	    	alert("A database error occurred!");
		};
   	});
	
	$( "#confirmDeleteTask" ).popup( "open");	
}

function listProjects(){
			//console.log('project list');
		$("#projectList").html("");
	    var transaction = trec.timerecDbObj.transaction([ 'projects' ]);
		var store = transaction.objectStore('projects');
			
		store.openCursor().onsuccess = function (e) {
			 var cursor = e.target.result;
			 if (cursor) {
			  	var value = cursor.value;
				var proElement = $("<div data-role='collapsible' id='projectbar_" + value.id + "' data-mini='true'/>");
				var h3ProTitle = $("<h3/>").html(value.title + " ");
				var pProLinks = $("<p><a href='#' class='ehDeleteProject ui-btn ui-btn-inline ui-icon-delete ui-btn-icon-notext ui-corner-all' rel='{\"id\" : " + value.id +"}'>delete</a> <a href='#' class='ehEditProject ui-btn ui-btn-inline ui-icon-edit ui-btn-icon-notext ui-corner-all' rel='{\"id\":" + value.id + ",\"title\":\"" + value.title + "\", \"note\":\"" + value.note + "\", \"rate\":\"" + value.rate + "\"}'>edit</a> <a href='#projectview' class='ehShowProject ui-btn ui-btn-inline ui-icon-eye ui-btn-icon-notext ui-corner-all' rel='{\"id\" : " + value.id +"}'>show</a></p>");
				var pProNote = $("<p/>").text(value.note);
// onclick='dialogDeleteProject(" + value.id +")'
//onclick='editProject(" + value.id +",\"" + value.title + "\",\"" + value.note + "\",\"" + value.rate + "\")'	
// onclick='showProject(" + value.id +")'
				proElement.append(h3ProTitle);
				proElement.append(pProLinks);
				proElement.append(pProNote);
				$("#projectList").append(proElement);
					 
				cursor.continue();
			 }
			 $('div[data-role=collapsible]').collapsible({refresh:true});
		 }; 
		 
		 transaction.oncomplete = function(e) {
			
			$(document).off('click', '.ehDeleteProject');	
			$(document).on('click', '.ehDeleteProject', function(){
				var para = JSON.parse( $(this).prop('rel') );
				dialogDeleteProject(para.id);
			});
			
			$(document).off('click', '.ehEditProject');	
			$(document).on('click', '.ehEditProject', function(){
				var para = JSON.parse( $(this).prop('rel') );
				editProject(para.id, para.title, para.note, para.rate);
			});	
					
			$(document).off('click', '.ehShowProject');	
			$(document).on('click', '.ehShowProject', function(){
				var para = JSON.parse( $(this).prop('rel') );
				showProject(para.id);
			});
		 }; 		 
}
	
	// LIST ALL TASKS
	
function listTasks(){	
		$(".navprojects").removeClass("ui-btn-active");
		$("#taskList").html("");
	    var transaction = trec.timerecDbObj.transaction([ 'tasks' ]);
		var store = transaction.objectStore('tasks');
			
		 store.index('title').openCursor().onsuccess = function (e) {
			 var cursor = e.target.result;
			 var showRate = "";
			 if (cursor) {
			  	var value = cursor.value;
			  	if(value.rate > 1){
				  	showRate =  " (Rate: "+ value.rate + ")";
			  	}
				
				var h3TaskTitle = $("<li id='taskbar_" + value.id + "' />").html("<a class='elEdittask' href='#' rel='{\"id\" : " + value.id + ",\"title\" :  \"" + value.title + "\", \"rate\" : \"" + value.rate + "\"}' >" + value.title + showRate + "</a><a href='#' class='elDeletTask ui-btn ui-icon-delete ui-btn-icon-notext' rel='{\"id\" : " + value.id +"}'>del</a>");
				$("#taskList").append(h3TaskTitle);
//onclick='editTask(" + value.id + ",\"" + value.title + "\",\"" + value.rate + "\")' //	onclick='delTask(" + value.id +")'				 
				cursor.continue();
			 }
			 $("#taskList").listview("refresh");
		 };
		 
		 transaction.oncomplete = function(e) {
			
			$(document).off('click', '.elEdittask');	
			$(document).on('click', '.elEdittask', function(){
				var para = JSON.parse( $(this).prop('rel') );
				editTask(para.id, para.title, para.rate);
			});
			
			$(document).off('click', '.elDeletTask');	
			$(document).on('click', '.elDeletTask', function(){
				var para = JSON.parse( $(this).prop('rel') );
				delTask(para.id);
			});			
			
		 }; 
		 
}




$(document).ready(function(){

    initializeDB();
    
    $(".navtasks").click(function(){
    	listTasks();
    });	
    
    $(".navHome").click(function(){
    	$(".navprojects").removeClass("ui-btn-active");
    });    
    
    $("#showAllProBtn").click(function(){
    	showProject(0);
    });
        
    $("#filterExportBtn").click(function(){
    	projectDetailsSearch(true);
    });    
    
    $("#filterClearBtn").click(function(){
    	projectDetailsFilterClear();
    });
    
    $("#filterShowBtn").click(function(){
    	projectDetailsSearch(false);
    });
    
    $("#backProjectList").click(function(){
//    	listProjects();
    });	
    
    $("#clearBtn").click(function(){
    	timerecorder.clear();
    });	
    
    $("#postBtn").click(function(){
    	timerecorder.doEnd();
    });	
    
    $("#bigKnobLink").off("click").click(function(){
    	timerecorder.addStart();
    });
 
    //SAVE EDIT TASK
	$("#saveEditTaskBtn").click(function(){
		var id = $("#editTaskId").val();
		var title = $("#editTaskTitle").val();
		var rate = $("#editTaskRate").val();
		if(id == ""){
	    	alert("Error. Data was not saved!");
	    	return;
	    }

	   if(title.length == 0){
	  	   $("#editTaskTitle").css("background-color", "red");
	  	   return;
	   }	  
	   $("#editTaskTitle").css("background-color", "#fff");	
	
		var transaction = trec.timerecDbObj.transaction([ 'tasks' ], 'readwrite');
			   
		var value = {};
		value.rate = kaufm(rate);
		value.title = title;
		value.id = parseInt(id) ;
	//console.dir(value); return;		   
		var store = transaction.objectStore('tasks');
		var request = store.put(value);
		  
		request.onsuccess = function (e) {
		   listTasks();
		   getTaskArray();
		};
	
		request.onerror = function (e) {
		  //console.log("Error in saving the project. Reason : " + e.value);
		  alert("A database error occurred!");
		};
		$.mobile.changePage ($("#tasks"));
	});    
    
	// DELETE A PROJECT
	$("#delProjectBtn").click(function(){
		var id = parseInt( $("#dialogDeleteProjectId").val() );
		
		// alle Record löschen
		var transactionR = trec.timerecDbObj.transaction([ 'records' ]);
		var storeR = transactionR.objectStore('records');
		var indexR = storeR.index("project_id");
		
		var keyRange = IDBKeyRange.only(id+'');//geht nur mit Strings!
		
		indexR.openCursor(keyRange).onsuccess = function (e) {
			 var cursorR = e.target.result;
			 if (cursorR) {
			  	var valueR = cursorR.value;
				deleteProBookings(valueR.id);
				cursorR.continue();
			 }
		 }; 
	
		
		// Projekt löschen 
		var transaction = trec.timerecDbObj.transaction([ 'projects' ], 'readwrite');
		var store = transaction.objectStore('projects');
		
		var request = store.delete(id);
		
		request.onsuccess = function () {
		   getProjectData();
		   $.mobile.changePage ($("#projects"));
		   $("#projectbar_"+id).remove();
		};
		request.onerror = function (e) {
		   //console.log("Error while deleting project : " + e.value);
		   alert("A database error occurred!");
		};
	});
    
    
	//SAVE SETTINGS
    $("#saveSettingsBtn").click(function(){
		
		var glRate = parseFloat ($("#globalRate").val() );
	//console.log(glRate);	
		if ( isNaN( glRate ) || glRate < 1 ) { 
	    	var glRateF = 0;
		} else {
			var glRateF = kaufm(glRate);
		}
		
		var value = {};
		value.id = "1";
		value.global_hourly_rate = glRateF;
		
		var transaction = trec.timerecDbObj.transaction([ 'settings' ], 'readwrite');
		var store = transaction.objectStore('settings');
		
		var request = store.put(value);
		request.onsuccess = function (e) {
			//
		};
		request.onerror = function (e) {
		   //console.log("Error in saving the record. Reason : " + e.value);
		   alert("A database error occurred!");
		};
		
		transaction.oncomplete = function(e) {
			getGlobalRate();
		};    
		
	});
    
    //SAVE BOOKING
	$("#saveRecordBtn").click(function(){
		
	    var project_id = $("#bookProjectList_1").val();
	    if(isNaN(parseInt( project_id))){
	    	alert("Booking not alowed! Please edit projects first!");
	    	return;
	    }
	    	
	    var record_note = $("#recordNote").val();
	    var timeTotal = $("#totalTimeSec").text();
	//console.log('tt1:'+timeTotal); 	
	    var editClock_h = $("#editRecordedTimeInput_h").val();
	    var editClock_m = $("#editRecordedTimeInput_m").val();
	//console.log(editClock_h);
	//console.log(editClock_m); 
	
		if(parseInt(editClock_h) > 0 ||  parseInt(editClock_m) > 0){
			timeTotal = parseInt(editClock_h)*3600 + parseInt(editClock_m)*60;
		}	   	
			
		/* DISABLED
	    var newTask = $("#addNewTaskInput").val();
	    newTask = newTask.trim();
	    	
	    if(newTask.length > 0 ){
	    	// neuen Task speichern
			var task_title = newTask;
	   		addNewTask(newTask);
	   		// speicher ohne Task id, nur Titel
	    } else {
	    	var task_id = $("#bookTaskList_1").val();
	    	var task_title = $("#bookTaskList_1 option:selected").text();
	    		
	    }*/
	    	
	    var task_id = $("#bookTaskList_1").val();
	    var task_title = $("#bookTaskList_1 option:selected").text();  
	    var bookNotVal = $("#bookNotValued").is(':checked') ? 1 : 0;
	    var fix = $("#bookAnAmount").val();
	    if(!isNaN( parseInt(fix) )){
	    	var fixF = kaufm(fix);
	    } else {
	    	var fixF = "";
	    }
	    
	    if(fixF == 0)fixF = "";
	    	
	    if(isNaN(parseInt(task_id))){
	    	alert("Booking not alowed! Please edit tasks first!");
	    	return;
	    }
	//console.log("b"+bookNotVal);  
	//console.log("f"+fixF);    	
	//return;    	
	    	
	    var transaction = trec.timerecDbObj.transaction([ 'records' ], 'readwrite');
	    var value = {};
		value.project_id = project_id;
		value.task_id = task_id;
		value.note = record_note;
		value.fixamount = fixF;
		value.booknotval = bookNotVal;
		value.task_title = task_title;
		value.timerecorded = timeTotal;
		var rdate = new Date();
		value.recdate = rdate;
		value.timestamp = rdate.getTime();
	//console.dir(value);  
		var store = transaction.objectStore('records');
		var request = store.add(value);
		request.onsuccess = function (e) {
			timerecorder.clear();
		};
		request.onerror = function (e) {
		  //console.log("Error in saving the record. Reason : " + e.value);
		  alert("A database error occurred!");
		};
		
		transaction.oncomplete = function(event) {    
			$.mobile.changePage($("#projectview"));
			showProject(parseInt( project_id ), false, false, false, "lastTableElement");
		};    
	});
    
	// DISPLAY EDIT CLOCK FIELD
	$("#editClockBtn").click(function(){
		$("#bookingClock").css("display", "none");
		$("#editClockBtn").css("display", "none");
		$("#editClock_h").css("display", "inline");
		$("#editClock_m").css("display", "inline");
		
		var clock = $("#bookingClock").html();
	//console.log(clock)	;
		var clock_array = clock.split(":");
	//console.dir(clock_array);
		var hour = parseInt(clock_array[0]);
		var min = parseInt(clock_array[1]);
	//return;
		var sel;
		var proElement;
		var j;
			
		for(var i=0;i<100;i++){
			sel = hour == i ? " selected='selected' " : "";
			j = i < 10 ? "0"+i : i;
			proElement = $("<option "+sel+" value='" + i + "' />").html(j);
			$("#editRecordedTimeInput_h").append(proElement);
		}
		for(var i=0;i<60;i++){
			sel = min == i ? " selected='selected' " : "";
			j = i < 10 ? "0"+i : i;
			proElement = $("<option "+sel+" value='" + i + "' />").html(j);
			$("#editRecordedTimeInput_m").append(proElement);
		}
		$("#editRecordedTimeInput_h").selectmenu('refresh', true);
		$("#editRecordedTimeInput_m").selectmenu('refresh', true);	
	
	});    	
    

    
    // LIST PROJECTS
	$(".navprojects, #backProjectList").click(function(){
		listProjects();
    });
    
	$("#navsettings").click(function(){
		
		var transaction = trec.timerecDbObj.transaction([ 'settings' ]);
		var store = transaction.objectStore('settings');
		
		var request = store.get("1");
		
		request.onsuccess = function (e) {
			var result = e.target.result;
	        $("#globalRate").val(result.global_hourly_rate);
	         
		};
		request.onerror = function (e) {
		   //console.log("Error in listing the settings. Reason : " + e.value);
		   alert("A database error occurred!");
		};
	});
    
    
    
    // UPDATE BOOKING 
    $("#editRecordBtn").click(function(){
    	
    	var ident = $("#editIdent").val();
    	
    	var rec_id = parseInt( $("#editRecordingId").val() );
    	
    	if(rec_id == ""){
    		alert("Error. Data was not saved!");
    		return;
    	}
		
		var editClock_h = $("#editBookingTimeInput_h").val();
    	var editClock_m = $("#editBookingTimeInput_m").val();
//console.log(editClock_h);
//console.log(editClock_m); 
		timeTotal = parseInt(editClock_h)*3600 + parseInt(editClock_m)*60;
//console.log("tt:"+timeTotal);    	
    	
    	var value = {};
    	//var id = rec_id;
    	var recDate = $("#editDate").val();
    	var pid = $("#bookProjectList_2").val();
		value.id = rec_id;
    	value.project_id = pid;
    	value.note = $("#editRecordNote").val();
    	value.timerecorded = timeTotal;
    	value.task_id = $("#bookTaskList_2").val();
    	value.task_title = $("#bookTaskList_2 option:selected").text();
    	value.recdate = new Date(recDate);
        value.timestamp = parseInt( $("#editTimestamp").val() );
        
        var bookNotVal = $("#editNotValued").is(':checked') ? 1 : 0;
        
    	var fix = $("#editAnAmount").val();
	    if(!isNaN( parseInt(fix) )){
	    	var fixF = kaufm(fix);
	    } else {
	    	var fixF = "";
	    }
	    
	    if(fixF == 0)fixF = "";
	    
    	value.fixamount = fixF;
		value.booknotval = bookNotVal;

    	var transaction = trec.timerecDbObj.transaction([ 'records' ], 'readwrite');
		   
	    var store = transaction.objectStore('records');
	    var request = store.put(value);
	    request.onsuccess = function (e) {
		    
	    };
	    request.onerror = function (e) {
	      //console.log("Error in saving the record. Reason : " + e.value);
	      alert("A database error occurred!");
	    };
	    
	    transaction.oncomplete = function(event) {
	    	$.mobile.changePage ($("#projectview"));
	    	showProject(parseInt( pid), false, false, false, ident );
	    };	
    	
    });	
    
    // INIT PROJECT FIELDS
    $("#btnAddProject").click(function(){
    	$("#projectTitle").val("");
        $("#projectNote").val("");
	    $("#projectTitle").focus();
    });
    
    // SAVE A PROJECT
	$("#btnSaveProject").click(function(){
		
	  var projectTitle = $("#projectTitle").val();
	  var projectNote = $("#projectNote").val();
	  
	  var projectRate = parseFloat( $("#projectRate").val() );
	  if ( isNaN( projectRate ) || projectRate < 1) { 
    	var projectRateF = 0;
	  } else {
		var projectRateF = kaufm(projectRate);
	  }

	  if(projectTitle.length == 0){
	  	  $("#projectTitle").css("background-color", "red");
	  	  return;
	  }	  
	  $("#projectTitle").css("background-color", "#fff");
	  	  	
	  var transaction = trec.timerecDbObj.transaction([ 'projects' ], 'readwrite');
		   
	  var value = {};
	  value.title = projectTitle;
	  value.note = projectNote;
	  value.rate = projectRateF;
//console.log(value.rate);	  
		   
	  var store = transaction.objectStore('projects');
	  var request = store.add(value);
	  request.onsuccess = function (e) {
		  listProjects();
		  getProjectData();
	  };
	  request.onerror = function (e) {
	    //console.log("Error in saving the project. Reason : " + e.value);
	    alert("A database error occurred!");
	  };
	  $.mobile.changePage ($("#projects"));
	  
	  $("#projectTitle").val("");
	  $("#projectNote").val("");
	  $("#projectRate").val("");
	  
	});
	
	// SAVE EDIT A PROJECT
	$("#btnEditProject").click(function(){
		
	  var projectRate = parseFloat( $("#editProjectRate").val() );
	  if ( isNaN( projectRate ) || projectRate < 1) { 
    	  var projectRateF = 0;
	  } else {
		  var projectRateF = kaufm(projectRate);
	  }	
		
	  var projectTitle = $("#editProjectTitle").val();
	  var projectNote = $("#editProjectNote").val();
	  var id = parseInt( $("#editProjectId").val() );
//console.log("id:"+id);	  
	  if(id == ""){
    	alert("Error. Data was not saved!");
    	return;
      }

	  if(projectTitle.length == 0){
	  	  $("#editProjectTitle").css("background-color", "red");
	  	  return;
	  }      
	  $("#editProjectTitle").css("background-color", "#fff");
	 
	  var transaction = trec.timerecDbObj.transaction([ 'projects' ], 'readwrite');
		   
	  var value = {};
	  value.rate = projectRateF;
	  value.title = projectTitle;
	  value.note = projectNote;
	  value.id = id;
//console.dir(value); return;		   
	  var store = transaction.objectStore('projects');
	  var request = store.put(value);
	  
	  request.onsuccess = function (e) {
		  listProjects();
		  getProjectData();
	  };

	  request.onerror = function (e) {
	    //console.log("Error in saving the project. Reason : " + e.value);
	    alert("A database error occurred!");
	  };
	  $.mobile.changePage ($("#projects"));
	  
	});
	
	// INIT TASK FIELDS
	$("#btnAddTask").click(function(){
    	$("#taskTitle").val("");
    });
    
    
    // SAVE A TASK
	$("#btnSaveTask").click(function(){
		
	  var taskTitle = $("#taskTitle").val();
	  
	  var taskRate = parseFloat( $("#taskRate").val() );
	  if ( isNaN( taskRate ) || taskRate < 1) { 
    	var taskRateF = 0;
	  } else {
		var taskRateF = kaufm(taskRate);
	  }

	  if(taskTitle.length == 0){
	  	  $("#taskTitle").css("background-color", "red");
	  	  return;
	  }	  
	  $("#taskTitle").css("background-color", "#fff");
	  
	  var transaction = trec.timerecDbObj.transaction([ 'tasks' ], 'readwrite');
		   
	  var value = {};
	  value.title = taskTitle;
	  value.rate = taskRateF;
	 	   
	  var store = transaction.objectStore('tasks');
	  var request = store.add(value);
	  request.onsuccess = function (e) {
		  listTasks();
		  getTaskArray();
	  };
	  request.onerror = function (e) {
	    //console.log("Error in saving the task. Reason : " + e.value);
	    alert("A database error occurred!");
	  };
	  $.mobile.changePage ($("#tasks"));
	  
	  $("#taskTitle").val("");
	  $("#taskRate").val("");
	  
	});

});


// THE TIME RECORDER OBJECT
var timerecorder = {
	
	start:0,
	pause:[],
	pauseRuns:0,
	minute:0,
	hour:0,
	lastPauseStart:0,
	clockIntv:false,
	clockWorker:false,
	clNowtime:0,
	clPauseUntilNow:0,
	clDisplayTime:0,
	clTotalUntilNowMin:0,
	clTotalUntilNowHour:0,
	clHour:0,
	clMin:0,
	
	addStart: function(){
//console.log("S");
			this.clear();

			var time = new Date;
			this.start = time.getTime();

			$("#startBtn").css("display", "none");
			$("#startBtnDis").css("display", "inline");
			
			//$("#pauseBtnDis").css("display", "none");
			//$("#pauseStartBtn").css("display", "inline");
		
			$("#bigKnob").prop("src", "images/timerec_icon_break.png");	
			//$("#redBlinkDot").prop("src", "images/rec_aktiv_blau.gif");
			$("#redB").removeClass("greyBull").addClass("redBull blink");	
	
			$("#bigKnobLink").off("click").click(function(){
				timerecorder.addPause();
			});	 
			//$("#endBtn").css("display", "inline");
			//$("#endBtnDis").css("display", "none");
			
//			$("#clearBtn").css("display", "inline");
			
			// Startzeit auf Display
			var startzeit = (time.getHours() < 10 ? "0" : "") + time.getHours() + ":" + (time.getMinutes() < 10 ? "0" : "") + time.getMinutes();
			$("#startTime").text(startzeit);

			// starten Stoppuhr
			this.startClockCount();			
			
	},
	
	addPause: function(){
//console.log("aP");
			this.stopClockCount();		

			var time = new Date;
			this.lastPauseStart = time.getTime();
			
			var startPause = (time.getHours() < 10 ? "0" : "") + time.getHours() + ":" + (time.getMinutes() < 10 ? "0" : "") + time.getMinutes();
			
			$("#pauseStart").css("display", "inline");
			$("#pauseStartText").css("display", "inline");
			$("#pauseStart").text(startPause);
			
			
			//$("#pauseStartBtn").css("display", "none");
			//$("#pauseStopBtn").css("display", "inline");
			$("#bigKnob").prop("src", "images/timerec_icon_rec.png");
			//$("#redBlinkDot").prop("src", "images/rec_pass_blau.gif");
			$("#redB").removeClass("redBull blink").addClass("greyBull");	

			$("#bigKnobLink").off("click").click(function(){
				timerecorder.stopPause();
			});
		
			$("#totalClock").addClass("blink");
			
	},
	
	stopPause: function(){
			this.startClockCount();	
//console.log("sP");			
			var time = new Date;
			var p = time.getTime() - this.lastPauseStart;
			
			this.pause.push(p);
			this.lastPauseStart = 0;
			
			//$("#pauseStopBtn").css("display", "none");
			//$("#pauseStartBtn").css("display", "inline");
			$("#bigKnob").prop("src", "images/timerec_icon_break.png");
			//$("#redBlinkDot").prop("src", "images/rec_aktiv_blau.gif");
			$("#redB").removeClass("greyBull").addClass("redBull blink");

			$("#bigKnobLink").off("click").click(function(){
				timerecorder.addPause();
			});
			$("#totalClock").removeClass("blink");
			
			var pauseUntilNow = 0;
			for(i=0, paule = this.pause.length; i < paule;i++){
				pauseUntilNow += this.pause[i];
			}
			
			var pauseUntilNowMin = Math.round(pauseUntilNow / 1000 / 60);
			if(pauseUntilNowMin > 59){
				var pauseUntilNowHour = Math.floor(pauseUntilNowMin / 60);
				pauseUntilNowMin = pauseUntilNowMin % 60;
			}
		
			if(pauseUntilNowHour > 0){
				var hour =  pauseUntilNowHour < 10 ? "0"+pauseUntilNowHour : pauseUntilNowHour;
			} else {
				var hour = "00";
			}
			
			var min = pauseUntilNowMin < 10 ? "0"+pauseUntilNowMin : pauseUntilNowMin;
			
			var pauseclock = '(Total ' + hour+':'+min + ')';
			
			$("#pauseTimeTotal").text(pauseclock);
			$("#pauseStart").text("00:00");
			$("#pauseStart").css("display", "none");
			$("#pauseStartText").css("display", "none");
			
			
	},
	
	doEnd: function(){
//console.log("E");		
		$("#bookingClock").css("display", "inline");
		$("#editClockBtn").css("display", "inline");
		$("#editClock_h").css("display", "none");
		$("#editClock_m").css("display", "none");
		
		if(this.lastPauseStart > 0){
			this.stopPause();
			$("#bigKnob").prop("src", "images/timerec_icon_break.png");	
			
			$("#bigKnobLink").off("click").click(function(){
				timerecorder.addPause();
			});	
		}
		
		var pauseTotal = 0;
		for(i=0, paule = this.pause.length; i < paule;i++){
			pauseTotal += this.pause[i];
		}
		
		//$("#pauseBtnDis").css("display", "inline");
		//$("#pauseStartBtn").css("display", "none");
		//$("#pauseStopBtn").css("display", "none");
		
		var time = new Date;
		
		if(this.start > 0){
			var totalTime = time.getTime() - this.start - pauseTotal;
		} else {
			var totalTime = 0;
		}

		var totalUntilNowMin = Math.round(totalTime / 1000 / 60);
		if(totalUntilNowMin > 59){
			var totalUntilNowHour = Math.floor(totalUntilNowMin / 60);
			totalUntilNowMin = totalUntilNowMin % 60;
		}
		
		if(totalUntilNowHour > 0){
			var hour =  totalUntilNowHour < 10 ? "0"+totalUntilNowHour : totalUntilNowHour;
		} else {
			var hour = "00";
		}
			
		var min = totalUntilNowMin < 10 ? "0"+totalUntilNowMin : totalUntilNowMin;
			
		var totalclock = hour+':'+min;
		$("#totalClock").text(totalclock);
		
		var totalTimeSec = totalTime / 1000;
		$("#totalTimeSec").text(totalTimeSec);
		$("#bookingClock").text(totalclock);
		listBookingSelects("1");
		$("#editRecordedTimeInput_h").html("");
		$("#editRecordedTimeInput_m").html("");
		
		$.mobile.changePage ($("#booktime")); 
		$("#bookNotValued").prop("checked",false).checkboxradio('refresh');
		
	},
	
	clear: function() {
//console.log("C");
		if(this.clockWorker){
			this.stopClockCount();
		}

		$("#bigKnob").prop("src", "images/timerec_icon_rec.png");
		//$("#redBlinkDot").prop("src", "images/rec_pass_blau.gif");
		$("#redB").removeClass("redBull blink").addClass("greyBull");
		
		$("#bigKnobLink").off("click").click(function(){
			timerecorder.addStart();
		});	
		$("#totalClock").removeClass("blink");	
			
		this.start=0;
		this.pause= new Array();
		this.pauseRuns=0;
		this.minute=0;
		this.hour=0;
		this.lastPauseStart=0;
		
		clearInterval(this.clockIntv);
		
		$("#totalClock").text("00:00");
		$("#totalTimeSec").text("");
		$("#bookingClock").text("00:00");
		$("#startTime").text("00:00");
		$("#pauseTimeTotal").text("00:00");
		$("#pauseStart").text("00:00");
		
		$("#pauseTimeTotal").text("00:00");
		$("#editRecordedTimeInput").val("");
		
		//$("#pauseBtnDis").css("display", "inline");
		//$("#pauseStartBtn").css("display", "none");
		//$("#pauseStopBtn").css("display", "none");
		
		//$("#startBtn").css("display", "inline");
		//$("#startBtnDis").css("display", "none");
			
		//$("#endBtn").css("display", "none");
		//$("#endBtnDis").css("display", "inline");
//		$("#clearBtn").css("display", "none");
		
		//$("#addNewTaskInput").val("");
		$("#recordNote").text("");
		
		//$("#addNewTaskBtn").css("display", "inline");
		//$("#addNewTask").css("display", "none");
		
		$("#editClockBtn").css("display", "inline");
		$("#editClock_h").css("display", "none");
		$("#editClock_m").css("display", "none");
		$("#pauseStart").css("display", "none");
		$("#pauseStartText").css("display", "none");
		
	},
	/*
	startClock: function() { // aktualisiert die Projekt Zeit
		
		this.clockIntv = setInterval(function(){ // +++ kein THIS in setIntervall +++
			
			// alle Pausen zusammen rechnen
			var pauseUntilNow = 0;
			
			for(i=0, tpaule = timerecorder.pause.length; i < tpaule;i++){
				pauseUntilNow += timerecorder.pause[i];
			}
			// wenn letze pause offen: last pause start ist rechenzeit
			if(timerecorder.lastPauseStart > 0){
				var nowtime = timerecorder.lastPauseStart;
			} else {
				var time = new Date();
				var nowtime = time.getTime();
			}
			// wenn nicht: jetzt ist rechenzeit
			// laufende zeit = rechenzeit - pause - startzeit
			var displayTime = nowtime - pauseUntilNow - timerecorder.start;
//console.log('dis:'+displayTime);	
	
			// umrechnen in hh:mm
			var totalUntilNowMin = Math.round(displayTime / 1000 / 60);
			if(totalUntilNowMin > 59){
				var totalUntilNowHour = Math.floor(totalUntilNowMin / 60);
				totalUntilNowMin = totalUntilNowMin % 60;
			}
			
			if(totalUntilNowHour > 0){
				var hour =  totalUntilNowHour < 10 ? "0"+totalUntilNowHour : totalUntilNowHour;
			} else {
				var hour = "00";
			}
				
			var min = totalUntilNowMin < 10 ? "0"+totalUntilNowMin : totalUntilNowMin;
				
			var totalclock = hour+':'+min;
//console.log('send:'+totalclock);			
			$("#totalClock").text(totalclock);
					
		}, 2000); // refresh 2 Sec
	},
	*/

	startClockCount: function(){
		
		this.clockWorker = new Worker("js/clockthread.js");
		this.clockWorker.onmessage = this.clockWorkerRe;
		
	}, 
	
	stopClockCount: function(){
		
		this.clockWorker.terminate();
		
	},
	
	clockWorkerRe: function(e){ // alle Variablen als Objekt Eigenschaften 
		
		this.clNowtime = e.data[0];
		
		this.clPauseUntilNow = 0;
		for(var i=0, tpaule = timerecorder.pause.length; i < tpaule;i++){
			this.clPauseUntilNow += timerecorder.pause[i];
		}
		this.clDisplayTime = this.clNowtime - this.clPauseUntilNow - timerecorder.start;
		// umrechnen in hh:mm
		this.clTotalUntilNowMin = Math.round(this.clDisplayTime / 1000 / 60);
		if(this.clTotalUntilNowMin > 59){
			this.clTotalUntilNowHour = Math.floor(this.clTotalUntilNowMin / 60);
			this.clTotalUntilNowMin = this.clTotalUntilNowMin % 60;
		}
			
		if(this.clTotalUntilNowHour > 0){
			this.clHour =  this.clTotalUntilNowHour < 10 ? "0"+this.clTotalUntilNowHour : this.clTotalUntilNowHour;
		} else {
			this.clHour = "00";
		}
				
		this.clMin = this.clTotalUntilNowMin < 10 ? "0"+this.clTotalUntilNowMin : this.clTotalUntilNowMin;
				
		$("#totalClock").text(this.clHour+':'+this.clMin);
		
	}
};
