/*
 * jQuery WordClock
 * Version 0.9.3
 * https://github.com/LoonyPandora/jQuery-WordClock
 *
 * Make clocks using words instead of numbers
 * 
 * Copyright (c) 2011 James Aitken (loonypandora.co.uk)
 * Dual licensed under the MIT and GPL licenses.
*/

(function($){

	$.fn.wordclock = function(options) {
        var settings = defaultSettings();
        settings.container = this;

        if (options) { 
            $.extend(settings, options);
        }

        $.each(settings.quanta, function(key, quantum) {
            switch (quantum.toLowerCase()) {
                case 'hours'    : hours(settings);         break;
                case 'minutes'  : minutes(settings);       break;
            }
        });
		
        clearInterval(paintTimer);
        var paintTimer = window.setInterval("paintTimer()", 1000);
    };

})(jQuery);


function paintTimer() {
    $('.current').removeClass('current');

    // Figure out what needs to be lit.
    var d = new Date();

    // Light up the time
    var hour = d.getHours()   % 12,
        min  = d.getMinutes() % 60

    $('.hour'+hour).addClass('current');
    $('.minute'+min).addClass('current');
}

function hours(settings) {
    var p = $('<p/>').appendTo(settings.container).addClass('hours');

    $.each(settings.numbers, function(key, value) {
        if (key > 0 && key <= 12) {
            // 12 is hour zero, but must come after hour 11
            if (key == 12) key = 0;
            $('<span/>').appendTo(p).text(value+' ').addClass('hour'+key);
        }
    });
    
}

function minutes(settings) {
    var p = $('<p/>').appendTo(settings.container).addClass('minutes');

    $('<span/>').appendTo(p).text("O'Clock").addClass('minute0');

    $.each(settings.numbers, function(key, value) {
        if (key > 0 && key <= 9) {
            $('<span/>').appendTo(p).text("O-"+value+' ').addClass('minute'+key);
        } else if (key > 0) {
            $('<span/>').appendTo(p).text(value+' ').addClass('minute'+key);
        }
    });
}

function defaultSettings() {
    return {
        style      : ['slider',   'block-text'],
        direction  : ['vertical', 'horizontal'],
        datetime   : '2013-01-01',
        quanta     : ['hours', 'minutes'], 
        numbers    : [
            'Zero',           'One',            'Two',           'Three',         'Four',
            'Five',           'Six',            'Seven',         'Eight',         'Nine',
            'Ten',            'Eleven',         'Twelve',        'Thirteen',      'Fourteen',
            'Fifteen',        'Sixteen',        'Seventeen',     'Eighteen',      'Nineteen',
            'Twenty',         'Twenty One',     'Twenty Two',    'Twenty Three',  'Twenty Four',
            'Twenty Five',    'Twenty Six',     'Twenty Seven',  'Twenty Eight',  'Twenty Nine',
            'Thirty',         'Thirty One',     'Thirty Two',    'Thirty Three',  'Thirty Four',
            'Thirty Five',    'Thirty Six',     'Thirty Seven',  'Thirty Eight',  'Thirty Nine',
            'Forty',          'Forty One',      'Forty Two',     'Forty Three',   'Forty Four',
            'Forty Five',     'Forty Six',      'Forty Seven',   'Forty Eight',   'Forty-Nine',
            'Fifty',          'Fifty One',      'Fifty Two',     'Fifty Three',   'Fifty Four',
            'Fifty Five',     'Fifty Six',      'Fifty Seven',   'Fifty Eight',   'Fifty Nine'
        ],
    };
}
