var currentFormula = '';
var rollbackFormula = "";
var rollbackProcessFormula = "";
var currentNum = 0;
var totalVar = 0;
var lastVat = 0;
var decimalSet = false;
var inProcess = false;
var aggregateProcess = 0;
var currentProcess = '';
var newProcess = false;
var clearAllStatus = true;
var currentPeople = 1;
var currentTip = 10;

function clear(){
	if (clearAllStatus == true)
		clearAll();
	else
		clearLast();
	
	clearAllStatus = true;
	adjustDisplaySize();
}

function clearAll(){
	currentFormula = '';
	rollbackFormula = '';
	rollbackProcessFormula = '';
	currentProcess = '=';
	totalVar = 0;
	lastVar  = 0;
	aggregateProcess = 0;
	inProcess = false;
	newProcess = false;
	decimalSet = false;
	currentPeople = 1;
	currentTip = 10;
	refreshDisplay();	
};

function clearLast(){
	decimalSet = false;
	totalVar = 0;
	lastVar = totalVar;
	currentFormula = rollbackFormula;
	refreshDisplay();
	$('#r1c1').html('<inner>AC</inner>');	
	
	inProcess = true;
	newProcess = true;
};

function setCurrentVar(number){
	adjustDisplaySize();
	
	totalVar = currentFormula + '' + number;
	if (((+totalVar).toFixed(10)).replace(/^-?\d*\.?|0+$/g, '').length <= 2){
			//totalVar = parseFloat(currentFormula+''+number);
	} else if (((+totalVar).toFixed(10)).replace(/^-?\d*\.?|0+$/g, '').length > 2){
			console.log(totalVar);
			totalVar = parseFloat(totalVar).toFixed(2);	
	}
	
	if (totalVar != 0){
		currentFormula = rollbackFormula + '' + totalVar;
	}
	
	refreshDisplay();
	newProcess = false;
}

function setDecimal(){
	if (decimalSet == false){
		newDecimal = true;
		if (totalVar == '')
			totalVar = 0;
		decimalSet = true;
		totalVar = totalVar + ".";	
		
		currentFormula = rollbackFormula + '' + totalVar;
		refreshDisplay();
	}
}

function setPeople(amount){
	currentPeople += amount;
	if (currentPeople < 1)
		currentPeople = 1;
	refreshDisplay();
}

function setTip(amount){
	currentTip += amount;
	if (currentTip < 0)
		currentTip = 0;
	else if (currentTip > 100)
		currentTip = 100;
	refreshDisplay();
}

function adjustDisplaySize(){
	if (totalVar.toString().length > 10){
		$("#number").css("font-size", "2em");	
		 if (totalVar.toString().length > 17)
			$("#number").css("font-size", "1.2em");	
	} else{
		$("#number").css("font-size", "2.5em");			
	}
	
}

function refreshDisplay(){
	$('#number').html('<infotext>Bill</infotext>' + numberWithCommas(totalVar));
	$('#tip').html('<infotext>Tip</infotext>' +currentTip+"%");
	$('#people').html('<infotext>People</infotext>' +currentPeople);
	
	
	var tippperson = ((totalVar*(currentTip*0.01))/currentPeople);
	var totalpperson = tippperson + (totalVar/currentPeople);
	
	tippperson = tippperson.toFixed(2);
	totalpperson = totalpperson.toFixed(2);
	
	$('#tippperson').html('<infotext>Tip / person</infotext>' + numberWithCommas(tippperson));
	$('#totalpperson').html('<infotext>Total / person</infotext>' + numberWithCommas(totalpperson));
}

function numberWithCommas(x) {
    return x.toString().replace(/\B(?=(?:\d{3})+(?!\d))/g, ",");
}

var isInteger_re     = /^\s*(\+|-)?\d+\s*$/;
function isInteger (s) {
   return String(s).search (isInteger_re) != -1
}

var isDecimal_re     = /^\s*(\+|-)?((\d+(\.\d+)?)|(\.\d+))\s*$/;
function isDecimal (s) {
   return String(s).search (isDecimal_re) != -1
}
