/*
 + Copyright (c) 2009-2014 Handout, Lda. All rights reserved.
 + Handout, Lda - Informação Confidencial e Proprietária. É proibida a alteração, decompilação, desmontagem, contorno ou
 + desabilitação de qualquer mecanismo de protecção; vender, licenciar, alugar, redistribuir ou fornecer a terceiros
 + independentemente de ser a título comercial, gratuito ou isento de qualquer custo.
 + Handout, Lda - Confidential and Proprietary information. It is strictly forbidden for 3rd parties to modify, decompile,
 + disassemble, defeat, disable or circumvent any protection mechanism; to sell, license, lease, rent, redistribute or
 + make accessible to any third party, whether for profit or without charge.
*/


/* --------------------------------------------------- CONFIGURAÇÃO ------------ */
   var __DEBUG  = true;
   var __LOADED = false;		//Já carregou a nova informação?


/* --------------------------------------------------- APP ------------ */
   window.addEventListener("load", appLoaded);
   function appLoaded(){
	  initStage();
	  initEvents();

	  loadSettings();
	  tipChange(parseInt(__PREFS.tipIdx));
	  
	  if(__PREFS.showHelp){
		 __PREFS.showHelp = false;
		   saveSettings();
		   helpShow();
	  }
   }

   
/* --------------------------------------------------- INIT ----------- */
   function initStage(){
	  var tBASE = document.documentElement;
	  if(tBASE.requestFullscreen   ){tBASE.requestFullscreen();}
	  if(tBASE.mozRequestFullscreen){tBASE.mozRequestFullscreen();}
   
	  try{   
		 screen.mozLockOrientation("portrait");
	  } catch(e){}
   }
   function initEvents(){
	 _bind('menu-btn' ,'click', drawerToggle);
	 _bind('val-bill' ,'click', billEdit);
	  
	 _bind('menu', 'click',  menuClicked);
	 _bind('keyb', 'click',  keybClicked);
	 _bind('help', 'click',  helpHide);

	 _bind('tip-wheel'  , 'click', tipSet);
	 _bind('split-wheel', 'click', splitSet);
	  addSwipeListener('tip-panel'  , function(e){tipChange(e.moved);}, 150);
	  addSwipeListener('split-panel', function(e){splitChange(-e.moved);}, 150);    //O movimento é inverso à numeração
	  
	 _bind('prefTax'   , 'click' , function(){
								 editPrep('Edit','TAX value', __PREFS.tax);
						   });
	 _bind('prefBack'  , 'click' , prefHide);
	 _bind('prefList'  , 'click' , prefEditEnd);
	 _bind('prefTip'   , 'change', prefChange);
	 _bind('prefCurr'  , 'change', prefChange);
	 _bind('prefRnd'   , 'change', prefChange);
	 
	 _bind('infoBack'  , 'click', infoHide);
	 _bind('editDone'  , 'click', editSave);
	 _bind('editCancel', 'click', editHide);
   }
   

/* --------------------------------------------------- SETTINGS ----------- */
   function loadSettings() {
	  var tSETTINGS = _dbGet(__app +__vers);
	  if(tSETTINGS != "") {
	   __PREFS = JSON.parse(tSETTINGS);
	  }
   }
   function saveSettings() {
    __PREFS.tipIdx   = parseInt(_class('tip-wheel'  ).substr(1,1));
    __PREFS.splitIdx = parseInt(_class('split-wheel').substr(1,1));
	
	 _dbSet(__app +__vers, JSON.stringify(__PREFS));
	  initSettings();
   }
   function initSettings(){
	  if(__PREFS.tax == '0'){
		  _hide('mnu1');
	  } else {
		  _show('mnu1');
		  _html('val-tax', '(' +__PREFS.tax + '%)');
	  }
	  
	__TIP = __TIPS[__PREFS.tipType];
	 _html("val-perc" ,formatPerc(__TIP[__PREFS.tipIdx] *100));
	
	 _class('tip-wheel'  ,"r" + __PREFS.tipIdx   + " anim200");
	 _class('split-wheel',"r" + __PREFS.splitIdx + " anim200");
   }


/* --------------------------------------------------- DRAWER --------- */
   function drawerToggle(){
	  keybHide();
	  billEditEnd();
	 _toggleClass('main','open');
   }
   

/* --------------------------------------------------- MENU   --------- */
   function menuClicked(event){
	  var tTARGET = _closest(event.target,'li');
	  if(tTARGET == null){
		 return;
	  }
	  
	  var tOPTION = _attr(tTARGET,'data');
	  switch(true){
		 case _hasClass(tTARGET, 'clickable'):
			   menuSelected(_html(tTARGET), tOPTION);
			   break;
			
		 case _hasClass(tTARGET, 'checkable'):
			   var tCHECKED = _toggleClass(tTARGET, 'checked');
			   menuChecked(tOPTION, tCHECKED);
			   break;
	  }
   }
   function menuSelected(pTITLE, pOPTION){
	  switch(pOPTION){
		 case 'preferences':
			   prefShow();
			   break;
			
		 case 'how-to-tip':
			   infoLoad(pTITLE,"i/t.html");
			   break;
			
		 case 'help-me':
			   drawerToggle();
			   setTimeout(helpShow ,200);			   
			   break;
			
		 case 'about':
			   infoLoad(pTITLE,"i/a.html");
			   break;
	  }
	  
   }
   function menuChecked(pOPTION, pCHECKED){
	  switch(pOPTION){
		 case 'add-tax':
			__PREFS.addTax = pCHECKED;
			  break;
			
		 case 'round-values':
			__PREFS.roundVals = pCHECKED;
			   break;
	  }
	  saveSettings();
	  calcValues();
   }
   

/* --------------------------------------------------- TECLADO -------- */
   var _keybCBK = billKeyPress;

   function keybShow(){
	 _addClass('keyb','open');
   }
   function keybHide(){
	 _removeClass('keyb', 'open');
   }
   function keybClicked(event){
	  _keybCBK(event);
   }

/* --------------------------------------------------- TIP / SPLIT ----- */
   function tipSet(event){
	  
   }
   function tipChange(pDIRECTION){
	  billEditEnd();
	  
	  var tCLS = _class('tip-wheel');
	  var tTIP =  parseInt(tCLS.substr(1,1));
	  var tIDX =  tTIP +pDIRECTION;
	  switch(true){
			 case tIDX < 0:
				  tIDX = 0;
				  break;
			   
			 case tIDX > 4:
				  tIDX = 4;
				  break;
	  }
	  
	  if(tIDX == 0){
		 _hide('val-tip');
		 _hide('label-3');
//		 _hide('val-total');
//		 _html('label-4','SPLITTING THE TOTAL');
	  } else {
		 _show('val-tip');
		 _show('label-3');
//		 _show('val-total');
//		 _html('label-4','SPLITTING THE TOTAL OF');
	  }	
    __PREFS.tipIdx = tIDX;
	  saveSettings();
	  
	 _class('tip-wheel','r' + tIDX + ' anim200');			  
	 _html('val-perc',formatPerc(__TIP[tIDX] *100));
	  calcValues();
   }
   function splitSet(){
	  
   }
   function splitChange(pDIRECTION){
	  billEditEnd();
	  
	  var tCLS = _class('split-wheel');
	  var tNUM =  parseInt(tCLS.substr(1,1));
	  var tIDX =  tNUM +pDIRECTION;
	  switch(true){
			 case tIDX < 0:
				  tIDX = 0;
				  break;
			   
			 case tIDX > 9:
				  tIDX = 9;
				  break;
	  }
    __PREFS.splitIdx = tIDX;
	  saveSettings();
	  
	 _class('split-wheel','r' + tIDX + ' anim200');			  
	  calcValues();
   }
   
   
/* --------------------------------------------------- CONTA ---------- */
   var _bill  = '0';
   function billEdit(event){
	 _keybCBK = billKeyPress;
	  if(_hasClass('val-bill', 'edit')){
		 if(event.clientX > _width(event.target) -50){
			_html('val-bill','');
			_bill = 0;
			 return;
		 }
		 billEditEnd();
	  } else {
		_addClass('val-bill','edit');
		_hide("bottom-panel");
	     keybShow();
	  }
   }
   function billEditEnd(){
	 _removeClass('val-bill', 'edit');
	 _show("bottom-panel");
	  keybHide();
   }
   function billEditClear(){
	  _html('val-bill', formatVal(0));
	  _bill = '0';
   }
   function billKeyPress(event){
	  if(!_hasClass('val-bill', 'edit')){
		 return;
	  }
	  
	  var tTARGET = _closest(event.target,'li');
	  if(tTARGET == null || _attr(tTARGET,'item-data') == ' '){
		 return;
	  }
	  
	  var tKEY   = _attr(tTARGET,'item-data');
	  var tVALUE = (typeof(_bill) == 'string') ? _bill : String(_bill);
	  switch(tKEY){
		 case 'E':
		 case 'e':
			   billEditEnd();
			   calcValues();
			   return;
//			   break;

		 case 'D':
		 case 'd':
			   if(tVALUE.length > 1){
			      tVALUE = tVALUE.substr(0, tVALUE.length -1);
			   } else {
			      tVALUE = '';
			   }
			   break;
			
		 case '.':
			   if(tVALUE.indexOf('.') >= 0){
				  return;
			   }
			   if(tVALUE.length == 0){
				  tVALUE = '0.';
			   } else {
				  tVALUE += '.';		  
			   }
			   break;
			
		 default:
			   tVALUE += tKEY;
	  }
	  
	 _bill = tVALUE.replace(/^0/g,'');;
	  if(_bill._startsWith('.')){_bill = '0' +_bill;}
	 _html('val-bill', _bill);
   }
   
/* --------------------------------------------------- CALCULOS -------- */
   function calcValues(){
	  var tVALOR  = parseFloat(_bill,10);
	  if(isNaN(tVALOR)){
		 tVALOR = 0;		 
	  }
	  
	  if(tVALOR == 0){
		_html("val-bill" , formatVal(0));
		_html("val-tip"  , formatVal(0));
		_html("val-total", formatVal(0));
		_html("val-split", formatVal(0));
		 return;
	  }
	  
	  var tTIPidx = parseInt(_class('tip-wheel'  ).substr(1,1));
	  var tSPLidx = parseInt(_class('split-wheel').substr(1,1));
	  
	  var tBASE = tVALOR;
	  if(__PREFS.addTax && __PREFS.tax != '0' && parseInt('0' +__PREFS.tax) != 0){
		   tBASE = roundNum(tVALOR + (tVALOR * (parseFloat(__PREFS.tax) /100) ));
		   if(isNaN(tBASE)){
			  tBASE = tVALOR;
		   }
	  }
	  var tTIPval = roundNum(tBASE * __TIP[tTIPidx]);
	  var tTOTAL  = roundVal(tBASE + tTIPval);
	  var tSPLIT  = roundVal(tTOTAL / tSPLidx);
	
	  tTOTAL  = tSPLIT *tSPLidx;  
//	  tTIPval = (tSPLIT * tSPLidx) - tVALOR;
	  
	 _html("val-bill" ,formatVal(tVALOR));
	 _html("val-tip"  ,formatVal(tTIPval));
	 _html("val-total",formatVal(tTOTAL));
	 _html("val-split",formatVal(tSPLIT));
	 _html("val-perc" ,formatPerc(__TIP[tTIPidx] *100));
   }

   function roundNum(pVALOR){
	  return(parseInt(pVALOR * 100 + .99) / 100);
   }
   function roundVal(pVALOR){
	  if(__PREFS.roundVals){
		   if(__PREFS.roundTo == 0){					// -> 1.00
		        return(parseInt(pVALOR +0.99));
		   } else {										// -> 0.50
				return(parseInt((pVALOR + 0.49)*2)/2);
		   }
	  } else {
		   return(roundNum(pVALOR));
	  }
   }
   function formatVal(pVALOR){
	  var tVALOR = __PREFS.currencyChar + " " + formatNum(parseInt(pVALOR *100 + 0.5) / 100);
	  return(tVALOR.replace('.','<small>.') + '</small>');
   }
   function formatNum(pVALOR){
	  var tVALOR = " " + pVALOR;				//Para converter em String
	  switch(true){
		 case tVALOR.substr(0,1) == ".":
			  tVALOR = "0" + tVALOR;
			  break;
		 case tVALOR.indexOf(".") < 0:
			  tVALOR += ".00";
			  break;
		 case tVALOR.indexOf(".") == tVALOR.length-1:
			  tVALOR += "00";
			  break;
		 case tVALOR.indexOf(".") == tVALOR.length-2:
			  tVALOR += "0";
			  break;
	  }
	  return(tVALOR.substring(1));
   }
   function formatPerc(pVALOR, pHUMANIFY){
	  var tPERC = formatNum(parseInt(pVALOR * 100) / 100);
	  if(tPERC._endsWith(".00")) {tPERC = parseInt(parseInt(pVALOR * 100) / 100)}
	  return(tPERC + "%");
   }
   function formatTax(pVALOR){
	  var tPERC = formatPerc(pVALOR);
	  if(tPERC == "0%") {tPERC = "NO TAX";}
	  return(tPERC);
   }


/* --------------------------------------------------- PREFERENCES ----- */
   var _tax;
   function prefShow(event){
	   holdEvent(event);

	  _html("pref-tax-value", __PREFS.tax);
	   
	  _addClass('preferences', 'show');
	  _replaceClass('main', 'open', 'left');
   }
   function prefHide(event){
	   holdEvent(event);
	   keybHide();
	   calcValues();
	   
	  _removeClass('main', 'left');
	  _removeClass('preferences', 'show');
   }
   function prefChange(event){
	  var tTARGET = event.target;
	  var tVALUE  = _value(tTARGET);
	  var tTYPE   = _attr(tTARGET, 'data');
	  switch(tTYPE){
		 case 'tip-type':
			 __PREFS.tipType = tVALUE;
			   break;
			
		 case 'currency-symbol':
			 __PREFS.currencyChar = tVALUE;
			   break;
			
		 case 'round-to':
			 __PREFS.roundTo = tVALUE;
			   break;
	  }
	  saveSettings();
   }
   function prefEdit(event){
	  holdEvent(event);
	  
	 _keybCBK = prefKeyPress;
	  if(_hasClass('prefTax', 'edit')){
		 if(event.clientX > _width(event.target) -50){
			_html('pref-tax-value','');
			_tax = 0;
			 return;
		 }
		 billEditEnd();
	  } else {
	    _tax = __PREFS.tax;
		_addClass('prefTax','edit');
	     keybShow();
	  }
   }
   function prefEditEnd(){
	 _removeClass('prefTax', 'edit');
	  keybHide();
	  
	__PREFS.tax = _tax;
	  saveSettings();
   }
   function prefKeyPress(event){
	  if(!_hasClass('prefTax', 'edit')){
		 return;
	  }
	  
	  var tTARGET = _closest(event.target,'li');
	  if(tTARGET == null || _attr(tTARGET,'item-data') == ' '){
		 return;
	  }
	  
	  var tKEY   = _attr(tTARGET,'item-data');
	  var tVALUE = (typeof(_tax) == 'string') ? _tax : String(_tax);
	  switch(tKEY){
		 case 'E':
		 case 'e':
			   prefEditEnd();
			   return;
//			   break;

		 case 'D':
		 case 'd':
			   if(tVALUE.length > 1){
			      tVALUE = tVALUE.substr(0, tVALUE.length -1);
			   } else {
			      tVALUE = '';
			   }
			   break;
			
		 case '.':
			   if(tVALUE.indexOf('.') >= 0){
				  return;
			   }
			   if(tVALUE.length == 0){
				  tVALUE = '0.';
			   } else {
				  tVALUE += '.';		  
			   }
			   break;
			
		 default:
			   tVALUE += tKEY;
	  }
	  
	 _tax = tVALUE.replace(/^0/g,'');;
	 _html('pref-tax-value', _tax);
   }
   
   
/* --------------------------------------------------- EDIÇÃO ---------- */
   function editPrep(pTITLE, pLABEL, pVALUE){
	  _html('editTitle', pTITLE);
	  _html('editLabel', pLABEL);
	  _value('editText', pVALUE);
	   editShow();
   }
   function editShow(event){
	   holdEvent(event);
	   
	  _keybCBK = editKeyPress;
	  
	  _tax = __PREFS.tax;
	  _html('editText',_tax);
	   
	  _addClass('edit', 'show');
	  _replaceClass('preferences', 'show', 'left');
	  
	   setTimeout(keybShow, 250);
   }
   function editHide(event){
	   holdEvent(event);
	   
	  _removeClass('edit','show');
	  _replaceClass('preferences', 'left', 'show');
   }
   function editKeyPress(event){
	  var tTARGET = _closest(event.target,'li');
	  if(tTARGET == null || _attr(tTARGET,'item-data') == ' '){
		 return;
	  }
	  
	  var tKEY   = _attr(tTARGET,'item-data');
	  var tVALUE = (typeof(_tax) == 'string') ? _tax : String(_tax);
	  switch(tKEY){
		 case 'E':
		 case 'e':
			   editSave();
			   return;
//			   break;

		 case 'D':
		 case 'd':
			   if(tVALUE.length > 1){
			      tVALUE = tVALUE.substr(0, tVALUE.length -1);
			   } else {
			      tVALUE = '';
			   }
			   break;
			
		 case '.':
			   if(tVALUE.indexOf('.') >= 0){
				  return;
			   }
			   if(tVALUE.length == 0){
				  tVALUE = '0.';
			   } else {
				  tVALUE += '.';		  
			   }
			   break;
			
		 default:
			   tVALUE += tKEY;
	  }
	 
	  if(tVALUE != '0' ){
 	    _tax = tVALUE.replace(/^0/g,'');
	  }
	 _html('editText', _tax);
   }
   function editSave(){
	    if(_tax == '' && isNaN(parseFloat(_tax))){
		   _tax = '0';
		}
	  __PREFS.tax = _tax;
		saveSettings();
		
	   _html("pref-tax-value", _tax);
	    keybHide();
	    editHide();
   }
   
/* --------------------------------------------------- HELP ------------- */
   function helpShow(){
	  _addClass("help","show");
   }
   function helpHide(){
	  _removeClass("help","show");
   }
   
   
/* ---------------------------------------------------- INFO ------------ */
   function infoLoad(pTITL,pURL){
	 if(_html("infoTitle") != pTITL){
		_html("infoTitle" , pTITL);
	  
		_html("infoPanel","");
		_insertPage("infoPanel",pURL);
	 }
	 
	 infoShow();
   }
   function infoShow(){
	  _addClass('info', 'show');
	  _replaceClass('main', 'open', 'left');
   }
   function infoHide(){
	  _removeClass('main', 'left');
	  _removeClass('info', 'show');
   }


/* --------------------------------------------------- DATA ------------ */
   var __app  = "Handout's Tip&Split - v1.1";
   var __vers = '1.1';

   var __TIP  =  [0, 0.05, 0.07, 0.10, 0.15];   
   var __TIPS = [[0, 0.05, 0.07, 0.10, 0.15],
				 [0, 0.05, 0.10, 0.15, 0.20],
				 [0, 0.10, 0.15, 0.20, 0.25],
				 [0, 0.10, 0.20, 0.30, 0.40]];
   var __PREFS = {tipType:1, tipIdx:2, splitIdx:0, addTax:true, tax:"0", roundVals:true, roundTo:0, currencyChar:'$', showHelp:true};


