$(document).ready(function(e){
	$('#task').val('');	
	checkForExistingStorage();
	showDatabaseSize();
});


/******************************/
/********* bindings ***********/
/******************************/

// add task button
$('#addtask').on('click', function(e){
	e.preventDefault();
	addTask();
	generateLocalStorageContent();
});

// add task form
$('.taskform').on('submit', function(e){
	e.preventDefault();
	addTask();
	generateLocalStorageContent();
});

// delete button
$(".container").on("click", "button.delete", function(e){
	e.preventDefault();

	var confirmDelete = confirm(strings.confirmDelete);
	if(!confirmDelete){
		return false;
	}

	$(this).closest('.element').remove();
	generateLocalStorageContent();

	var pendingTasksLen = $('#pendingtasks tbody').children('tr.element').length;
	var completedTasksLen = $('#completedtasks tbody').children('tr.element').length

	if(pendingTasksLen == 0 && completedTasksLen == 0){
		clearDatabase();
		showDatabaseSize();
	}
});

// marking task as finished
$("#pendingtasks").on("change", ".pending", function(e){
	e.preventDefault();
	var elementRow = $(this).closest('.element');
	var elementText = $(elementRow).find('.tasktext').html();
	//var elementTime = $(elementRow).find('.tasktime').html();
	$('#completedtasks tbody').append(generateHTML(true, elementText, getCurrentTime()));
	$(elementRow).remove();
	generateLocalStorageContent();
});

// marking task as pending
$("#completedtasks").on("change", ".completed", function(e){
	e.preventDefault();
	var elementRow = $(this).closest('.element');
	var elementText = $(elementRow).find('.tasktext').html();
	//var elementTime = $(elementRow).find('.tasktime').html();
	$('#pendingtasks tbody').append(generateHTML(false, elementText, getCurrentTime()));
	$(elementRow).remove();
	generateLocalStorageContent();
});

// clear database
$('#clearDatabase').on('click', function(){

	var pendingTasksLen = $('#pendingtasks tbody').children('tr.element').length;
	var completedTasksLen = $('#completedtasks tbody').children('tr.element').length

	if(pendingTasksLen == 0 && completedTasksLen == 0){
		alert(strings.noTasksLeft);
		return false;
	}

	var confirmDelete = confirm(strings.confirmDeleteAllTasks);
	if(!confirmDelete){
		return false;
	}

	$('#pendingtasks tbody').empty();
	$('#completedtasks tbody').empty();
	clearDatabase();
	showDatabaseSize();
});

/******************************/
/********* functions **********/
/******************************/

// adds the entered task to localstorage and adds the generated html to the page
function addTask(){
	var text = $('#task').val().trim();

	if(text == '' || text.length == 0){
		//$('.emptyalert').css('display','block').delay(2000).fadeOut('1000');
		alert(strings.addTask);
		$('#task').val('');
		return;
	}

	if(text.length > 50){
		alert(strings.charsExceeded + text.length);
		return;
	}

	$('#pendingtasks tbody').append(generateHTML(false, text, getCurrentTime()));
	$('#task').val('');
}

// generates the key value object to be saved in localstorage
function generateLocalStorageContent(){
	var unfinishedTasks = [];
	var finishedTasks = [];

	if($('#pendingtasks').find('tr.element').length > 0) {
		$('#pendingtasks tr.element').each(function() {
			var unfinished = {
		 		text : encodeURI($(this).find('.tasktext').html()),
		 		time : encodeURI($(this).find('.tasktime').html())
		 	};
		 	unfinishedTasks.push(unfinished);
		});
	}
	
	if($('#completedtasks').find('tr.element').length > 0) {
		$('#completedtasks tr.element').each(function() {
			var finished = {
		 		text : encodeURI($(this).find('.tasktext').html()),
		 		time : encodeURI($(this).find('.tasktime').html())
		 	};
		 	finishedTasks.push(finished);
		});
	}

	persistTasks('pending', JSON.stringify(unfinishedTasks));
	persistTasks('finished', JSON.stringify(finishedTasks));	
	showDatabaseSize();
}

// saves the given key and its value to localstorage
function persistTasks(key, value){
	if (typeof(Storage) != "undefined") {
	    // Store
	    localStorage.setItem(key, value);
	}
}

// returns the html structure for each task
function generateHTML(completed, task, time){
	if(completed){
		return	"<tr class='element'>"+
					"<td class='span1'><input type='checkbox' class='completed' checked='checked'></td>"+
					"<td class='span10'><div class='tasktext striked'>"+ task +"</div><span class='tasktime'>"+ time +"</span></td>"+
					"<td class='span1'><button class='delete btn btn-danger'><i class='icon-trash icon-white'></i></button></td>"+
				"</tr>";
	} else {
		return	"<tr class='element'>"+
					"<td class='span1'><input type='checkbox' class='pending'></td>"+
					"<td class='span10'><div class='tasktext'>"+ task +"</div><span class='tasktime'>"+ time +"</span></td>"+
					"<td class='span1'><button class='delete btn btn-danger'><i class='icon-trash icon-white'></i></button></td>"+
				"</tr>";	
	}	
}

// checks for the existing values in localstorage and displays them if not empty
function checkForExistingStorage(){

	// get the item from local storage
	var pendingTasks = localStorage.getItem('pending');
	var finishedTasks = localStorage.getItem('finished');

	var pendingTasksArray = JSON.parse(pendingTasks);
	var finishedTasksArray = JSON.parse(finishedTasks);
	
	// pending tasks	
	if(pendingTasksArray != null && pendingTasksArray.length > 0){
		for(var i = 0; i< pendingTasksArray.length; i++){

			var object = pendingTasksArray[i]
			$('#pendingtasks tbody').append(generateHTML(false, decodeURI(object.text), decodeURI(object.time)));
		}
	}

	// finished tasks
	if(finishedTasksArray != null && finishedTasksArray.length > 0){
		for(var i = 0; i< finishedTasksArray.length; i++){

			var object = finishedTasksArray[i]
			$('#completedtasks tbody').append(generateHTML(true, decodeURI(object.text), decodeURI(object.time)));
		}
	}

	$('#task').val('');
}

// display localstorage size
function showDatabaseSize(){
    $('#dbsize').html(localStorageSpace);
}

// clears the keys set in the localstorage
function clearDatabase(){
	localStorage.removeItem('pending');
	localStorage.removeItem('finished');
}

// returns current time string in dd-mm-yyyy hh:mm:ss format
function getCurrentTime(){
	var d = new Date(),
    	time = [d.getDate(), d.getMonth()+1, d.getFullYear()].join('-')+' '+
              	[d.getHours(), d.getMinutes(), d.getSeconds()].join(':');

    return time;
}

// returns localstorage size
var localStorageSpace = function(){
	var allStrings = '';
    
    for(var key in window.localStorage){
    	if(window.localStorage.hasOwnProperty(key)){
                allStrings += window.localStorage[key];
        }
    }
    return allStrings ? (3 + ((allStrings.length*16)/(8*1024))).toFixed(2) + strings.dbSize : strings.emptyDB;
};

// returns all string values used in the app. Like a constants object.
var strings = {
	addTask : 'Add a task.',
	charsExceeded : 'Enter less than 50 characters. You entered ',
	confirmDelete : 'Do you really want to delete this task?',
	noTasksLeft : 'There are no tasks to delete.',
	confirmDeleteAllTasks : 'Do you really want to delete all tasks?',
	emptyDB : 'Empty (0 KB)',
	dbSize : ' KB'
};