function FormClass(
		 elemDialog
		,elemUL
		,imgClearDate
		,elemName
		,elemNote
		,elemDate
		,elemTime
		,elemProgress
		,nameLateType
		,nameRepeatType
		,elemDelete
		,deleteCallBack
		,elemSave
		,saveCallBack) {
	var properties = this;
	properties.elemDialog = elemDialog;
	properties.elemUL = elemUL;
	properties.imgClearDate = imgClearDate;
	properties.elemName = elemName;
	properties.elemNote = elemNote;
	properties.elemDate = elemDate;
	properties.elemTime = elemTime;
	properties.elemProgress = elemProgress;
	properties.nameLateType = nameLateType;
	properties.nameRepeatType = nameRepeatType;
	properties.elemDelete = elemDelete;
	properties.deleteCallBack = deleteCallBack;
	properties.elemSave = elemSave;
	properties.saveCallBack = saveCallBack;
	properties.currentLI = null;
	
	//Initalize Controls
	var $elemDate = $(properties.elemDate);
	$(properties.imgClearDate).css({
		 top: $elemDate.position().top + 2
		,left: ($elemDate.position().left + $elemDate.width()) - ($elemDate.height())
		,height: $elemDate.height()
		,width: $elemDate.height()
	}).on("click", clearDate);
	$(properties.elemDelete).on("click", function() {
		properties.deleteCallBack(properties.currentLI);
		properties.currentLI = null;
		$(properties.elemUL).show();
		$(properties.elemDialog).hide();
	});
	$(properties.elemSave).on("click", function() {
		properties.saveCallBack.call(properties.currentLI, properties.GetControlValues(), true);
		properties.currentLI = null;
		$(properties.elemUL).show();
		$(properties.elemDialog).hide();
	});
	$(properties.elemDate).on("blur", function() {
		if( $(properties.elemTime).val() == "" ) {
			var d = new Date();
			var h = d.getHours();
			var ampm = "AM";
			if( h > 12 ) {
				h -= 12;
				ampm = "PM";
			}
			if(h == 0) {
				h = 12;
			}
			var m = d.getMinutes().toString();
			if(m.length == 1) {
				m = "0" + m;
			}
			var t = h + ":" + m + " " + ampm;
			$(properties.elemTime).val(t).focus();
		}
		if( getRadioByName(properties.nameLateType) === null ) {
			setRadioByName(properties.nameLateType, "expires");
		}
	});
	$(properties.elemTime).on("blur", function() {
		if( $(properties.elemDate).val() == "" ) {
			var date = new Date();
			//FFOS does not respect it's own date settings??!!
			$(properties.elemDate).val( date.toISOString().split("T")[0] ).focus();
		}
		if( getRadioByName(properties.nameLateType) === null ) {
			setRadioByName(properties.nameLateType, "expires");
		}
	});
	properties.elemNote.style.height = (properties.elemNote.offsetHeight + (window.innerHeight - properties.elemDialog.children[0].offsetHeight) - 5) + "px";
	properties.ForceLoadControls = function(id) {
		//alert("ForceLoadControls");
		if( $(properties.elemDialog).is(":visible") ) {
			if(properties.currentLI.getAttribute("data.id") != id.toString()) {
				if( confirm("Save current task?") ) {
					$(properties.elemSave).trigger("click");
				}
			}
		}
		var wantedLI = $("li[data-id=${ID}]".replace(/\${ID}/, id)).get(0);
		properties.LoadControls(wantedLI);
	};
	properties.LoadControls = function(elemImg) {
		console.group("LoadControls");
		console.log("arguments=");
		console.log(arguments);
		try {
			/*
				data = {
					ID
					Name
					isStarred
					isDone
					isRed
					Description
					Date
					Time
					LateExpires
					Progress
					RepeatType
					NotificationID
				}
				properties.elemName
				properties.elemNote
				properties.elemDate
				properties.elemTime
				properties.elemProgress
				properties.nameLateType
				properties.nameRepeatType
				properties.elemDelete
				properties.elemSave
				
				properties.elemDialog
				properties.elemUL
			*/
			properties.currentLI = $(elemImg).closest("li").get(0);
			console.log(properties.currentLI);
			var data = window.taskObject.DeconstructTask(properties.currentLI);
			$(properties.elemName).val(data.Name);
			$(properties.elemNote).val(data.Description);
			$(properties.elemDate).val(data.Date);
			$(properties.elemTime).val(data.Time);
			$(properties.elemProgress).val(data.Progress);
			setRadioByName(properties.nameLateType, data.LateExpires);
			setRadioByName(properties.nameRepeatType, data.RepeatType);
			$(properties.elemDialog).show();
			$(properties.elemUL).hide();
			//Resize things that were not sizable when dialog was invisible
			properties.elemNote.style.height = (properties.elemNote.offsetHeight + (window.innerHeight - properties.elemDialog.children[0].offsetHeight) - 5) + "px";
			var $elemDate = $(properties.elemDate);
			$(properties.imgClearDate).css({
				 top: $elemDate.position().top + 2
				,left: ($elemDate.position().left + $elemDate.width()) - ($elemDate.height())
				,height: $elemDate.height()
				,width: $elemDate.height()
			})
		} catch(ex) {
			console.warn("Crashed in LoadControls");
			console.error(ex);
		}
		console.groupEnd("LoadControls");
	};
	properties.GetControlValues = function() {
		console.group("GetControlValues");
		console.log("arguments=");
		console.log(arguments);
		var returnValue = null;
		try {
			returnValue = ({
							 ID: parseInt($(properties.currentLI).attr("data-id"), 10)
							,Name: $(properties.elemName).val()
							,isStarred: false //???
							,isDone: false //???
							,isRed: false //???
							,Description: $(properties.elemNote).val()
							,Date: $(properties.elemDate).val()
							,Time: $(properties.elemTime).val()
							,LateExpires: getRadioByName(properties.nameLateType)
							,Progress: $(properties.elemProgress).val()
							,RepeatType: getRadioByName(properties.nameRepeatType)
							,NotificationID: null //???
						});
			console.log("returnValue=");
			console.log(returnValue);
		} catch(ex) {
			console.warn("Crashed in GetControlValues");
			console.error(ex);
		}
		console.groupEnd("GetControlValues");
		return returnValue;
	};
	////////////////
	////////////////
	////////////////
	function setRadioByName(name, value) {
		console.group("setRadioByName");
		console.log("arguments=");
		console.log(arguments);
		try {
			if(value === null) {
				$("input:radio[name='${Name}']".replace(/\${Name}/, name)).prop("checked", false);
			} else {
				$("input:radio[name='${Name}'][value='${Value}']".replace(/\${Name}/, name).replace(/\${Value}/, value)).prop("checked", true); //HACK: <strike>double escaped $??</strike> ..now single...
			}
		} catch(ex) {
			console.warn("Crashed in setRadioByName");
			console.error(ex);
		}
		console.groupEnd("setRadioByName");
	}
	function getRadioByName(name) {
		console.group("getRadioByName");
		console.log("arguments=");
		console.log(arguments);
		var returnValue = null;
		try {
			var $radio = $("input:radio[name='${Name}']:checked".replace(/\${Name}/, name));
			if( $radio.length == 0 ) {
				returnValue = null;
			} else {
				returnValue = $radio.val();
			}
			console.log("returnValue=");
			console.log(returnValue);
		} catch(ex) {
			console.warn("Crashed in getRadioByName");
			console.error(ex);
		}
		console.groupEnd("getRadioByName");
		return returnValue;
	}
	function clearDate() {
		console.group("clearDate");
		console.log("arguments=");
		console.log(arguments);
		try {
			$(properties.elemNote).focus();
			$([properties.elemDate,properties.elemTime]).val("");
			$("input:radio[name='consequence']").prop("checked", false);
			setRadioByName(properties.nameLateType, null);
		} catch(ex) {
			console.warn("Crashed in clearDate");
			console.error(ex);
		}
		console.groupEnd("clearDate");
	}
	////////////////
	////////////////
	////////////////
	properties.onSaveTask = function() {
		console.group("onSaveTask");
		console.log("arguments=");
		console.log(arguments);
		try {
			//
		} catch(ex) {
			console.warn("Crashed in onSaveTask");
			console.error(ex);
		}
		console.groupEnd("onSaveTask");
	};
	properties.onDeleteTask = function() {
		console.group("onDeleteTask");
		console.log("arguments=");
		console.log(arguments);
		try {
			//
		} catch(ex) {
			console.warn("Crashed in onDeleteTask");
			console.error(ex);
		}
		console.groupEnd("onDeleteTask");
	};
}