function TaskManagerClass(ulElement, placeholder, onEditCallBack, onForceEditCallBack) {
	var properties = this;
	var taskStorage = "taskData";
	properties.UL = ulElement;
	properties.onEditCallBack = onEditCallBack;
	properties.onForceEditCallBack = onForceEditCallBack;
	properties.placeholder = placeholder;
	/*
		data = {
			ID
			Name
			isStarred
			isDone
			isRed
			Description
			Date
			Time
			LateExpires
			Progress
			RepeatType
			NotificationID
		}
	*/
	var sortableSettings = ({
		 placeholder: properties.placeholder
		,distance: 25
		,update: function(e, ui) {
			console.group("sortable.update");
			console.log("arguments=");
			console.log(arguments);
			try {
				//console.log("before:");
				//console.log(window.localStorage[taskStorage]);
				$("li", properties.UL).each(function(i, li) {
					var data = properties.DeconstructTask(li);
					data["sortOrder"] = i;
					properties.UpdateTask(data, false);
				});
				var database = JSON.parse(window.localStorage[taskStorage]);
				database = database.sort(function(a,b) {
					return a.sortOrder - b.sortOrder;
				})
				window.localStorage[taskStorage] = JSON.stringify(database);
				//console.log("after:");
				//console.log(window.localStorage[taskStorage]);
			} catch(ex) {
				console.warn("Crashed in sortable.update");
				console.error(ex);
			}
			console.groupEnd("sortable.update");
		}
	});
	$(properties.UL).sortable(sortableSettings);
	properties.AddTask = function(label) {
		console.group("AddTask");
		console.log("arguments=");
		console.log(arguments);
		try {
			var database = JSON.parse(window.localStorage[taskStorage]);
			if( database === undefined ) {
				database = [];
			}
			database.push({
				Name: label
			});
			var newID = createTask( database[database.length - 1] );
			console.log( !isNaN(newID), "newID is not a number cannot add task successfully" );
			database[database.length - 1].ID = newID;
			window.localStorage[taskStorage] = JSON.stringify(database);
		} catch(ex) {
			console.warn("Crashed in AddTask");
			console.error(ex);
		}
		console.groupEnd("AddTask");
	};
	properties.DeleteTask = function(liElemOrID) {
		console.group("DeleteTask");
		console.log("arguments=");
		console.log(arguments);
		try {
			var database = JSON.parse(window.localStorage[taskStorage]);
			var id = null;
			if( liElemOrID.tagName ) {
				id = parseInt(liElemOrID.getAttribute("data-id"), 10);
			} else {
				id = parseInt(liElemOrID, 10);
			}
			var foundItem = false;
			for(var i=0; ((i<database.length) && (!foundItem)); i++) {
				if(database[i].ID == id) {
					//TODO: remove next notification
					foundItem = true;
					var data = database.splice(i, 1);
					if(data.NotificationID != null) {
						try {
							navigator.mozAlarms.remove(data.NotificationID);
							data.NotificationID = null;
						} catch(ex2) {
							console.warn("Crashed in DeleteTask::removing notification");
							console.error(ex2);
						}
					}
				}
			}
			$("li[data-id='${ID}']".replace(/\${ID}/, id), properties.UL).remove();
			window.localStorage[taskStorage] = JSON.stringify(database);
		} catch(ex) {
			console.warn("Crashed in DeleteTask");
			console.error(ex);
		}
		console.groupEnd("DeleteTask");
	};
	properties.UpdateTask = function(data, resetNotification) {
		console.group("UpdateTask");
		console.log("arguments=");
		console.log(arguments);
		try {
			var database = JSON.parse(window.localStorage[taskStorage]);
			var foundItem = false;
			for(var i=0; ((i<database.length) && (!foundItem)); i++) {
				if(database[i].ID == data.ID) {
					//TODO: reset next notification
					database[i].Name = data.Name;
					database[i].isStarred = data.isStarred;
					database[i].isDone = data.isDone;
					database[i].isRed = data.isRed;
					database[i].Description = data.Description;
					database[i].Date = data.Date;
					database[i].Time = data.Time;
					database[i].LateExpires = data.LateExpires;
					//console.assert(typeof(data.Progress) == "number"); //fails
					database[i].Progress = parseInt(data.Progress, 10);
					database[i].RepeatType = data.RepeatType;
					database[i].NotificationID = parseInt(data.NotificationID, 10);
					if( data["sortOrder"] != undefined ) {
						database[i].sortOrder = data["sortOrder"];
					}
					//Update DOM
					var li = $("li[data-id='${ID}']".replace(/\${ID}/, data.ID), properties.UL).get(0);
					$(li).toggleClass("late", data.isRed);
					$(".center", li).toggleClass("completed", data.isDone);
					//console.log("updating li: %s", "li[data-id='${ID}']".replace(/\\${ID}/, data.ID));
					//console.log( $("li[data-id='${ID}']".replace(/\\${ID}/, data.ID), properties.UL).get(0) );
					//console.log( $("li[data-id='${ID}']".replace(/\${ID}/, data.ID), properties.UL).get(0) );
					$("div.center", li).html(data.Name);
					//console.log("set progress %s visible %s", database[i].Progress, database[i].Progress > 0);
					$(".progressBarFlexLeft", li).css("flex", "1 1 " + database[i].Progress + "%").toggle( (database[i].Progress > 0) );
					$(".progressBarFlexRight", li).css("flex", "1 1 " + (100 - database[i].Progress) + "%").toggle( (database[i].Progress > 0) );
					//TODO: complete dom (highlights)
					//TODO: call reset alarm here instead of...
					if(resetNotification) {
						if( data.NotificationID != null ) {
							navigator.mozAlarms.remove(data.NotificationID);
						}
						//Set next notification and perhaps date
						properties.SetNextAlarm(data);
					}
					foundItem = true;
				}
			}
			window.localStorage[taskStorage] = JSON.stringify(database);
		} catch(ex) {
			console.warn("Crashed in UpdateTask");
			console.error(ex);
		}
		console.groupEnd("UpdateTask");
	};
	properties.DeconstructTask = function(liElemOrID) {
		console.group("DeconstructTask");
		console.log("arguments=");
		console.log(arguments);
		try {
			var database = JSON.parse(window.localStorage[taskStorage]);
			var id = null;
			if( liElemOrID.tagName ) {
				id = parseInt(liElemOrID.getAttribute("data-id"), 10);
			} else {
				id = parseInt(liElemOrID, 10);
			}
			var foundItem = null;
			for(var i=0; ((i<database.length) && (foundItem == null)); i++) {
				if(database[i].ID == id) {
					foundItem = database[i];
				}
			}
		} catch(ex) {
			console.warn("Crashed in DeconstructTask");
			console.error(ex);
		}
		console.log("DeconstructTask returnValue:");
		console.log(foundItem);
		console.groupEnd("DeconstructTask");
		return foundItem;
	};
	properties.LoadTasksFromMemory = function() {
		console.group("LoadTasksFromMemory");
		console.log("arguments=");
		console.log(arguments);
		try {
			//TODO: clear existing timeing
			$("li", properties.UL).remove();
			if(window.localStorage[taskStorage] == undefined) {
				window.localStorage[taskStorage] = JSON.stringify([]);
				console.groupEnd("LoadTasksFromMemory");
				return;
			} else {
				console.log(window.localStorage[taskStorage]);
				var database = JSON.parse(window.localStorage[taskStorage]);
				for(var i=0; i<database.length; i++) {
					var newID = createTask(database[i]);
					database[i].ID = newID;
				}
				window.localStorage[taskStorage] = JSON.stringify(database);
			}
		} catch(ex) {
			console.warn("Crashed in LoadTasksFromMemory");
			console.error(ex);
		}
		console.groupEnd("LoadTasksFromMemory");
	};
	properties.QueryTasksByName = function(Name) {
		console.group("QueryTasksByName");
		console.log("arguments=");
		console.log(arguments);
		try {
			var database = JSON.parse(window.localStorage[taskStorage]);
			var foundItem = false;
			for(var i=0; ((i<database.length) && (!foundItem)); i++) {
				if(database[i].Name == Name) {
					//TODO: remove next notification
					foundItem = true;
				}
			}
		} catch(ex) {
			console.warn("Crashed in QueryTasksByName");
			console.error(ex);
		}
		console.groupEnd("QueryTasksByName");
		return foundItem;
	};
	properties.ExpireAlarm = function(data) {
		//TODO: should mark alarm and/or reschedule an alarm
		if(navigator.mozAlarms) {
			navigator.mozAlarms.remove( data.NotificationID );
			data.NotificationID = null;
			properties.UpdateTask(data, false);
		}
	};
	properties.SetNextAlarm = function(data) {
		console.group("SetNextAlarm")
		console.log("arguments=");
		console.log(arguments);
		try {
			if( (data.Date) != null && (data.Time != null) && (data.Date.length * data.Time.length > 0) ) {
				var alarmDate = dateAndTimeStringToDateObject(data.Date, data.Time);
				var now = new Date();
				var setAlarmDate = (new Date(alarmDate.getTime())); //Clone not copy
				var setAlarm = true;
				if( (now > alarmDate) && (data.RepeatType != "nonRepeating") && (data.RepeatType != "") && (data.RepeatType != null) ) {
					//find next alarm
					switch(data.RepeatType) {
						default:
						case "nonRepeating":
							setAlarmDate = false;
							break;
						case "hourly":
							//console.warn("Auto-setting next alarm 1 min not 1 hour");
							while(setAlarmDate < now) {
								setAlarmDate.setMinutes(setAlarmDate.getMinutes() + 60);
							}
							console.log(setAlarmDate.toLocaleString());
							break;
						case "daily":
							while(setAlarmDate < now) {
								setAlarmDate.setDate(setAlarmDate.getDate() + 1);
							}
							console.log(setAlarmDate.toLocaleString());
							break;
						case "weekly":
							while(setAlarmDate < now) {
								setAlarmDate.setDate(setAlarmDate.getDate() + 7);
							}
							console.log(setAlarmDate.toLocaleString());
							break;
						case "weekday":
							while(setAlarmDate < now) {
								switch( setAlarmDate.getDay() ) {
									case 0: // Sunday
									case 1: // Monday
									case 2: // Tuesday
									case 3: // Wednesday
									case 4: // Thursday
										setAlarmDate.setDate(setAlarmDate.getDate() + 1);
										break;
									case 5: // Friday
										setAlarmDate.setDate(setAlarmDate.getDate() + 3);
										break;
									case 6: // Saturday
										setAlarmDate.setDate(setAlarmDate.getDate() + 2);
										break;
								}
							}
							break;
						case "preWeekday":
							while(setAlarmDate < now) {
								switch( setAlarmDate.getDay() ) {
									case 0: // Sunday
									case 1: // Monday
									case 2: // Tuesday
									case 3: // Wedday
									case 6: // Saturday
										setAlarmDate.setDate(setAlarmDate.getDate() + 1);
										break;
									case 4: // Thursday
										setAlarmDate.setDate(setAlarmDate.getDate() + 3);
										break;
									case 5: // Friday
										setAlarmDate.setDate(setAlarmDate.getDate() + 2);
										break;
								}
							}
							break;
						case "monthly":
							while(setAlarmDate < now) {
								setAlarmDate.setMonth(setAlarmDate.getMonth() + 1);
							}
							break;
						case "monthlyWeekDay":
							var inFuture = false;
							var loops = 0
							while(!inFuture) {
								while(setAlarmDate < now) {
									setAlarmDate.setMonth(setAlarmDate.getMonth() + 1);
								}
								while( (setAlarmDate.getDate() == 6) || (setAlarmDate.getDate() == 0) ) {
									setAlarmDate.setDate(setAlarmDate.getDate() - 1);
								}
								inFuture = (setAlarmDate < now);
								loops++;
								if(loops > 3) {
									throw "Failed to calculate next month weekDay";
								}
							}
							break;
						case "monthlyFromEnd":
							var daysTillNextMonth = 0;
							var cMonth = setAlarmDate.getMonth();
							while(cMonth == setAlarmDate.getMonth()) {
								setAlarmDate.setDate(setAlarmDate.getDate() + 1);
								daysTillNextMonth++;
							}
							setAlarmDate.setMonth(setAlarmDate.getMonth() + 1);
							setAlarmDate.setDate(setAlarmDate.getDate() - daysTillNextMonth);
							while(setAlarmDate < now) {
								setAlarmDate.setMonth(setAlarmDate.getMonth() + 1);
							}
							break;
					}
					var dateParts = dateObjectToDateAndTimeString(setAlarmDate);
					data.Date = dateParts[0];
					data.Time = dateParts[1];
					properties.UpdateTask(data, false);
				} else if( now > alarmDate ) {
					//Cannot reset alarm
					setAlarm = false;
				}
				if(setAlarm) {
					setNotification(data);
				}
			}
		} catch(ex) {
			console.warn("Crashed in SetNextAlarm");
			console.error(ex);
		}
		console.groupEnd("SetNextAlarm");
	};
	properties.OnAlarm = function(mozAlarm) {
		console.log("## OnAlarm fired ##");
		console.group("OnAlarm");
		console.log("arguments=");
		console.log(arguments);
		try {
			switch(mozAlarm.data.AlarmType) {
				default:
					console.warn("Unknown alarm type caught by Todo");
					throw "Unknown alarm type caught by Todo";
					break;
				case "TodoEvent":
					var notification = new Notification(mozAlarm.data.Title, {
						 body: mozAlarm.data.Body
						,tag: "OnLoadAlert" + mozAlarm.data.AssociateNotificationIDWithTaskID.toString()
						,icon: mozAlarm.data.Icon
						,data: ({
							 TaskID: mozAlarm.data.AssociateNotificationIDWithTaskID
							,NotificationID: null
							,WebURL: window.location.href
						})
					});
					notification.onclick = function() {
						//alert("onclick");
						//Ideally open application here, does not seem possible at the moment
						console.log("notification.clicked");
						console.log("this=");
						console.log(this);
						console.log("arguments=");
						console.log(arguments);
						console.log("hidden data?");
						console.log(arguments[0].originalTarget.data);
						//Close alert
						this.close();
						//Todo: Open task here
						var taskID = arguments[0].originalTarget.data.TaskID;
						properties.onForceEditCallBack.call(this, taskID);
					};
					notification.onshow = function(event) {
						console.log("notification.shown");
						console.log("this=");
						console.log(this);
						console.log("arguments=");
						console.log(arguments);
						console.warn("!! -- Does this fire if Todo is closed?? -- !!");
					};
					notification.onclose = function() {
						console.log("notification.closed");
						console.log("this=");
						console.log(this);
						console.log("arguments=");
						console.log(arguments);
						console.log("need to check for missed notifications which caused un-reset notifications");
					};
					var data = properties.DeconstructTask(mozAlarm.data.AssociateNotificationIDWithTaskID);
					console.log("ExpireType value %s", mozAlarm.data.ExpireType);
					if( mozAlarm.data.ExpireType == "expires" ) {
						data.isDone = true;
					}
					data.isRed = true;
					properties.UpdateTask(
						 data
						,true
					);
					//$("li[data-id='${ID}']".replace(/\${ID}/, mozAlarm.data.AssociateNotificationIDWithTaskID), properties.UL).addClass("late");
					break;
			}
		} catch(ex) {
			console.warn("Crashed in OnAlarm");
			console.error(ex);
		}
		console.groupEnd("OnAlarm");
	};
	////////////////////////////
	////////////////////////////
	////////////////////////////
	function createTask(data) {
		console.group("createTask");
		console.log("arguments=");
		console.log(arguments);
		var returnValue = null;
		try {
			if(data.ID === undefined) {
				//New task just created
				var database = JSON.parse(window.localStorage[taskStorage]);
				var nextID = Array.maxValue(database, "ID", 0) + 1;
				data.ID = nextID;
				//Defaulted task values are set here
				data.isStarred = false;
				data.isDone = false;
				data.isRed = false;
				data.Description = null;
				data.Date = null;
				data.Time = null;
				data.LateExpires = "late";
				data.Progress = 0;
				data.RepeatType = "nonRepeating";
				data.NotificationID = null;
			}
			if( (data.Name == null) || (data.length == 0)  ) {
				throw "Invalid task (no name)";
			} else {
				var liElem = taskDataToDOM(data);
				//TODO: set next notification and/or check for existing validity
				if( data.NotificationID != null ) {
					try {
						//Get date of when alarm should have fired
						var alarmDate = dateAndTimeStringToDateObject(data.Date, data.Time);
						var now = new Date();
						if(alarmDate < now) {
							properties.ExpireAlarm(data);
						}
					} catch(ex) {
						console.warn("Crash in createTask (2)");
						console.error(createTask);
					}
				}
				properties.UL.appendChild(liElem);
				//Append to before first checked
				//HACK: must appendChild first so as to get MutationObserver to work correctly :/
				var completedLis = $("img[src*='checkbox_highlighted']", properties.UL).closest("li").toArray();
				if(completedLis.length > 0) {
					properties.UL.insertBefore(liElem, completedLis[0]);
					setTimeout(function(li, before){
						$(li).insertBefore(before);
					},200,liElem,completedLis[0]);
				}
				returnValue = parseInt(liElem.getAttribute("data-id"), 10);
			}
		} catch(ex) {
			console.warn("Crashed in createTask");
			console.error(ex);
		}
		console.groupEnd("createTask");
		return returnValue;
	}
	function taskDataToDOM(data) {
		/*
			<li data-id>
				<div class="container">
					<div class="left">
						<img src="images/star.svg" height="16em" />
					</div>
					<div class="center">
						111111
					</div>
					<div class="right">
						[]
					</div>
					<div class="clear"></div>
				</div>
			</li>
		*/
		var parentContainer = $("<div>").addClass("container").get(0);
		var li = $(parentContainer).wrap("<li>").parent().attr({
			"data-id": data.ID
		}).toggleClass("late", data.isRed).get(0);
		onAppendMutationObserver(parentContainer, reAdjustWidthOnAppend);
		var progressContainer = $("<div>").addClass("progressBarFlex").get(0);
		var progressLeft = $("<div>").addClass("progressBarFlexLeft").css("flex", "1 1 " + data.Progress + "%").toggle( (data.Progress > 0) ).get(0);
		var progressRight = $("<div>").addClass("progressBarFlexRight").css("flex", "1 1 " + (100 - data.Progress) + "%").toggle( (data.Progress > 0) ).get(0);
		progressContainer.appendChild(progressLeft);
		progressContainer.appendChild(progressRight);
		var l = $("<div>").addClass("left").get(0);
		var m = $("<div>").addClass("center").addClass("task").attr({
			unselectable: "on"
		}).toggleClass("completed", data.isDone).get(0);
		var r = $("<div>").addClass("right").get(0);
		var c = $("<div>").addClass("clear").get(0);
		var star = $("<img>").attr({
			 src:  data.isStarred ? "images/star_highlighted.svg" : "images/star.svg"
			,height: "16em"
		}).get(0);
		star.dataAdditionalAction = startClickReOrderTop;
		var edit = $("<img>").attr({
			 src: "images/edit.svg"
			,height: "16em"
		}).get(0);
		edit.dataAdditionalAction = function() {
			console.log("edit click additional item");
			console.log("expect edit image, then LoadControls");
			console.log(edit);
			setTimeout(toggleImageHighlight.bind(edit, edit), 500);
			setTimeout(onEditCallBack.bind(edit, edit), 400);
			$(edit).closest("li").removeClass("late");
			console.log("/edit click additional item");
		};
		l.appendChild( star );
		l.appendChild( edit );
		m.innerHTML = data.Name;
		var checker = $("<img>").attr({
			 src: data.isDone ? "images/checkbox_highlighted.svg" : "images/checkbox.svg"
			,height: "16em"
		}).get(0);
		checker.dataAdditionalAction = checkClickApplyStrikeOutMoveToBottom;
		progressContainer.dataLeftOf = edit;
		progressContainer.dataRightOf = checker;
		r.appendChild( checker );
		parentContainer.appendChild(progressContainer);
		parentContainer.appendChild(l);
		m.dataLeftOf = edit;
		m.dataRightOf = checker;
		m.consumeMaxWidthOnly = true;
		parentContainer.appendChild(m);
		parentContainer.appendChild(r);
		parentContainer.appendChild(c);
		$([star,edit,checker]).on("click", function(e) {
			//uncomment if local web response design
			//if(!e.metaKey) {
				console.log("star/edit/checker click");
				var onOff = toggleImageHighlight(this);
				if(this.dataAdditionalAction) {
					this.dataAdditionalAction.call(this, onOff);
				}
				var li = $(this).closest("li").get(0);
				var data = properties.DeconstructTask(li);
				data.isStarred = ($("img[src*='star']", li).attr("src").indexOf("_highlighted") >= 0);
				data.isDone = ($("img[src*='checkbox']", li).attr("src").indexOf("_highlighted") >= 0);
				console.log("Icon click Star: %s Done: %s", data.isStarred, data.isDone);
				properties.UpdateTask(data, false);
				//console.log(this);
				console.log("exited star/edit/checker click");
			//}
		});
		return li;
	}
	function startClickReOrderTop(onOff) {
		console.log("startClickReOrderTop");
		if(onOff) {
			//console.log("this=");
			//console.log(this); //img
			//console.log("prepend");
			var li = $(this).closest("li").get(0);
			var insertBefore = "#tasks >li:first";
			var lis = $("#tasks >li").toArray();
			var unbrokenChain = true;
			for(var i=0; (i<lis.length) && (unbrokenChain); i++) {
				if( $("img[src*='star_highlighted']", lis[i]).length == 1 ) {
					if( (i+1) < lis.length ) {
						insertBefore = lis[i+1];
					}
				} else {
					unbrokenChain = false;
				}
			}
			$(li).insertBefore(insertBefore);
			properties.UpdateTask(properties.DeconstructTask(li), false);
		}
	}
	function checkClickApplyStrikeOutMoveToBottom(onOff) {
		var li = $(this).closest("li").get(0);
		var center = $(this).closest(".container").find(".center").get(0);
		if(onOff) {
			$(center).addClass("completed");
			$(li).insertAfter("#tasks >li:last");
		} else {
			$(center).removeClass("completed");
		}
		properties.UpdateTask(properties.DeconstructTask(li), false);
	}
	function toggleImageHighlight(img) {
		var li = $(this).closest("li").get(0);
		switch(img.src.indexOf("highlighted")) {
			case -1:
				img.src = img.src.replace(/\./, "_highlighted.").replace(/\_highlighted_highlighted/g,"_highlighted");
				return true;
			default:
				img.src = img.src.replace("_highlighted", "");
				return false;
		}
		properties.UpdateTask(properties.DeconstructTask(li), false);
	}
	//////////////////////////////
	//////////////////////////////
	//////////////////////////////
	function reAdjustWidthOnAppend(elemNodeList) {
		console.group("reAdjustWidthOnAppend");
		console.log("arguments=");
		console.log(arguments);
		try {
			for(var i=0; i<elemNodeList.length; i++) {
				var elem = elemNodeList[i];
				if(elem.dataLeftOf) {
					if(elem.dataRightOf) {
						console.log(elem);
						console.log("parentWidth: %s", $(elem.parentNode).width());
						console.log("parent");
						console.log(elem.parentNode);
						var left = $(elem.dataLeftOf).position().left + $(elem.dataLeftOf).width();
						var widthToConsume = ($(elem.dataRightOf).position().left - left);
						if( elem.consumeMaxWidthOnly ) {
							console.log("consumeMaxWidthOnly %s", widthToConsume);
							console.log(elem);
							$(elem).css({
								 maxWidth: widthToConsume
								,maxHeight: "1.5em"
								,overflow: "hidden"
							});
						} else {
							$(elem).css({
								 left: left
								,width: widthToConsume
							});
						}
					}
				}
			}
		} catch(ex) {
			console.warn("Crashed in reAdjustWidthOnAppend");
			console.error(ex);
		}
		console.groupEnd("reAdjustWidthOnAppend");
	}
	function onAppendMutationObserver(elem, callback) {
		console.group("onAppendMutationObserver");
		console.log("arguments=");
		console.log(arguments);
		try {
			var mutationObserver = new MutationObserver(function(mutations) {
				mutations.forEach(function(m) {
					if(m.addedNodes.length) {
						//console.log("calling callback on");
						//console.log(m.addedNodes);
						callback(m.addedNodes);
					}
				});
			});
			mutationObserver.observe(elem, {
				childList: true
			});
		} catch (ex) {
			console.warn("Crashed in onAppendMutationObserver");
			console.error(ex);
		}
		console.groupEnd("onAppendMutationObserver");
	}
	function setNotification(data) { //replacing delayFireEvent (contaned)
		console.group("setNotification")
		console.log("arguments=");
		console.log(arguments);
		var date = dateAndTimeStringToDateObject(data.Date, data.Time);
		var now = new Date();
		if( date >= now ) {
			if(navigator.mozAlarms) {
				var request = navigator.mozAlarms.add(date, "honorTimezone", ({
					 AlarmType: "TodoEvent"
					,AssociateNotificationIDWithTaskID: data.ID
					,Title: data.Name
					,Body: data.Description
					,Icon: window.location.href.replace(window.location.pathname, "/images/icon.svg")
					,Repeats: data.RepeatType
					,ExpireType: data.LateExpires
					,DateTime: date
				}));
				request.onsuccess = function() {
					console.log("## setNotification Success! ##");
					//notification is now stoppable with: navigator.mozAlarms.remove( this.result );
					//console.log("this=");
					//console.log(this);
					console.log("Is next varialbe a standard data (expected)");
					console.log(data);
					data.NotificationID = this.result;
					properties.UpdateTask(data, false);
				};
				request.onerror = function () {
					console.log("## setNotification OnError occurred! ##");
					console.log("An error occurred: " + this.error.name);
					console.log(this);
				};
			}
		} else {
			console.log("Date: %s %s", data.Date, data.Time);
			console.warn("setNotification is Crashing")
			throw "setNotification: date occurred in the past";
		}
	}
	//Returns max value in an array of object 
	//call via: Array.maxValue([{a:1},{a:2},{a:2},{a:45}],"a", 1)
	Array.maxValue = function(array, properityName, defaultValue) {
		console.group("Array.maxValue");
		console.log("arguments=");
		console.log(arguments);
		var returnValue = -1;
		try {
			var values = array.map(function (element) {
				if(element[properityName] != undefined) {
					return element[properityName];
				} else {
					return defaultValue;
				}
			});
			if(values.length == 0) {
				values.push(defaultValue);
			}
			returnValue = Math.max.apply(Math, values);
		} catch(ex) {
			console.warn("crashed in Array.maxValue");
			console.error(ex);
		}
		console.groupEnd("Array.maxValue");
		return returnValue;
	};
}