function pad2DigitString(d) {
	if(d.length == 1) {
		d = "0" + d;
	}
	return d;
}
function dateObjectToDateAndTimeString(date) {
	//Saturday, May 23, 2015 10:40:00 PM
	//date.toLocaleString()
	//
	if( date instanceof Date ) {
		var y = date.getFullYear().toString();
		var m = (date.getMonth() + 1).toString();
		var d = date.getDate().toString();
		var h = date.getHours().toString();
		var n = date.getMinutes().toString();
		m = pad2DigitString(m);
		d = pad2DigitString(d);
		n = pad2DigitString(n);
		return ([
			 y + "-" + m + "-" + d
			,h + ":" + n
		]);
	} else {
		throw "Invalid date passed to dateObjectToDateAndTimeString()";
	}
}
function dateAndTimeStringToDateObject(dateString, timeString) {
	var dateFormat = /^([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})$/;
	var timeFormat = /^([0-9]{1,2}):([0-9]{1,2})$/;
	if( dateFormat.test(dateString) && timeFormat.test(timeString) ) {
		var dateValues = dateFormat.exec(dateString);
		var timeValues = timeFormat.exec(timeString);
		return new Date(
			 parseInt(dateValues[1], 10)
			,parseInt(dateValues[2], 10) - 1
			,parseInt(dateValues[3], 10)
			,parseInt(timeValues[1], 10)
			,parseInt(timeValues[2], 10)
		);
	} else {
		return null;
	}
}
function newTask() {
	var newTaskString = $("#addTodo").val();
	if( ! window.taskObject.QueryTasksByName(newTaskString) ) {
		if((newTaskString != null) && (newTaskString.replace(/[\s]/g, "") != "")) {
			window.taskObject.AddTask(newTaskString);
			$("#addTodo").val("");
		}
	}
}
function filterEnter(e) {
	if(e.keyCode == 13) {
		newTask();
		return false;
	} else {
		return true;
	}
}
window.taskObject = null;
$(document).ready(function() {
	console.group("document.ready");
	console.log("arguments=");
	console.log(arguments);
	try {
		var dialog = $("dialog").get(0);
		window.formObject = new FormClass(
			 dialog
			,$("ul").get(0)
			,$("#clearButton").get(0)
			,$("input[type='text']", dialog).get(0)
			,$("textarea").get(0)
			,$("#todoDate").get(0)
			,$("input[type='time']", dialog).get(0)
			,$("input[type='range']", dialog).get(0)
			,"consequence"
			,"reoccur"
			,$("#delete").get(0)
			,null
			,$("#save").get(0)
			,null
		);
		window.taskObject = new TaskManagerClass( $("#tasks").get(0), "sortableDropArea", window.formObject.LoadControls, window.formObject.ForceLoadControls );
		window.formObject.deleteCallBack = window.taskObject.DeleteTask;
		window.formObject.saveCallBack = window.taskObject.UpdateTask;
		var addTodo = $("#addTodo");
		$("#addButton").css({
			 top: addTodo.position().top + 2
			,left: (addTodo.position().left + addTodo.width()) - (addTodo.height())
			,height: addTodo.height()
			,width: addTodo.height()
		}).on("click", newTask);
		var inputTypeDate = $("#todoDate");
		$("#addTodo").on("keypress", filterEnter);
		window.taskObject.LoadTasksFromMemory();
		//Setup Alarm listener
		if(navigator.mozSetMessageHandler) {
			navigator.mozSetMessageHandler("alarm", window.taskObject.OnAlarm);
		}
	} catch(ex) {
		console.warn("Crash in document.ready");
		console.error(ex);
	}
	console.groupEnd("document.ready");
});