function readLocalStore() {
    var tasks = [];
    if (localStorage && localStorage.wunderlist) {
        var tasks2 = JSON.parse(localStorage.wunderlist);
        for (var i = 0; i < tasks2.length; i++) {
            tasks.push({title: tasks2[i].title, done: tasks2[i].done});
        }
    }
    return tasks;
}

function NotificationModel() {
    this.title = 'Mock';
    this.visible = false;
}

var sharedNotificationData = new NotificationModel();

function TaskController($scope, $timeout) {
    $scope.tasks = readLocalStore();
    $scope.notif = sharedNotificationData;
    
    $scope.addTask = function () {
        var taskTitle = $scope.taskTitle;        
        if (_.where($scope.tasks, {title: taskTitle}).length > 0) {
            $scope.notify('Duplicate entry', 2000);
            return;
        }
        $scope.tasks.push({title: taskTitle, done: false});
        $scope.taskTitle = '';
    };
    
    $scope.archiveTasks = function () {
        $scope.tasks = _.filter($scope.tasks, 
                                function (t) { return t.done == false; });
    };
    
    $scope.saveTasks = function () {
        localStorage.wunderlist = JSON.stringify($scope.tasks);
        $scope.notify('Todo is saved', 2000);
    }
    
    $scope.remaining = function() {
        var count = 0;
        for (var i = 0; i < $scope.tasks.length; i++) {
            if ($scope.tasks[i].done == false) count++;
        }
        return count;
    };
    
    $scope.count = function () {
        return $scope.tasks.length;
    };
    
    $scope.hideNotification = function () {        
        $scope.notif.visible = false;
    };
    
    $scope.notify = function (title, delay) {
        $scope.notif.title = title;
        $scope.notif.visible = true;
        $timeout(function () { $scope.hideNotification();}, delay);        
    };
    
}

