$(function() {

  window.track('Open app');
  var todoCollection = new TodoCollection(populateList);

  var allDoneMessages = [
    "You have completed all the tasks, what about adding something new?",
    "You have completed all the tasks, do you have something else to remember?",
    "You have completed all the tasks, why not adding something new?"
  ];
  function setSwipeRightTo(element, callback) {
    var hammertime = new Hammer(element, {direction: Hammer.DIRECTION_HORIZONTAL});

    var activationLength = 43;

    hammertime.on('pan', function(ev) {
      if (ev.isFinal) {
        var distance = $(element).css('margin-left');
        if (parseInt(distance) < activationLength)
          $(element).animate({
              marginLeft: '0px'
          }, 200);
        else{
          $(element).animate({
              marginLeft: element.offsetWidth+'px'
          }, 300, 'swing', function() {
            $(element).hide();
            var id = $(element).data("id");
            callback(id);
          });
        }
      } else {
        if (ev.deltaX <= 0) {
          $(element).css('margin-left', '0px');
        } else {
          $(element).css('margin-left', ev.deltaX + 'px');
          if (ev.deltaX > activationLength)
            $(element).parent().addClass("active");
          else
            $(element).parent().removeClass("active");
        }
      }
    });
  }

  function setCompleted(id) {
    todoCollection.setCompleted(id, function() {
      populateList.call(todoCollection);
    });
    window.track('Complete Task', {'id': id});
  }

  function setDeleted(id) {
    todoCollection.remove(id, function() {
      populateList.call(todoCollection);
    });
    window.track('Delete Task', {'id': id});
  }

  var insertTextbox = $( "#insert" );

  var alreadySentBegin = false;
  insertTextbox.on( "keydown", function(event) {
    var enterKey = 13;
	if (! alreadySentBegin) {
		window.track('Begin writing Task');
		alreadySentBegin = true;
	}

    if(event.which == enterKey && insertTextbox.val() != '') {
      todoCollection.add(insertTextbox.val(), function() {
        populateList.call(todoCollection);
        window.track('Insert Task');
      });
      alreadySentBegin = false;
	  insertTextbox.val("");
    }
  });

  function populateList(){
    $("#userMessage").hide();
    $("#todoList").empty();
    var taskToDo = 0;
    var taskDone = 0;
    var myThis = this;
    this.getAllFromNewest( function(result) {
      result.forEach(function (todo) {
        if (todo.completed != null)
          return;
        taskToDo = taskToDo + 1;
        var line =
          '<div class ="item" data-id="'+todo.created+'" id="todo-' + todo.created + '">'
          + ' <span class="glyphicon glyphicon-chevron-right"></span> '
          + todo.title
          + '</div>';
        $("#todoList").append(line);
        var element = $('#todo-' + todo.created).get(0);
        setSwipeRightTo(element, setCompleted);
      });

      $("#doneList").empty();
      myThis.getAllCompleted( function(result) {
        var previousDate = new Date(0);
        result.forEach(function (todo) {

          var date = new Date(todo.completed);
          var months = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
          if (
            date.getFullYear() != previousDate.getFullYear() ||
            date.getMonth() != previousDate.getMonth() ||
            date.getDate() != previousDate.getDate()
          ) {
            var today = new Date();
            var yesterday = new Date();
            yesterday.setDate(yesterday.getDate() - 1);
            if (  date.getFullYear() == today.getFullYear() &&
                  date.getMonth() == today.getMonth() &&
                  date.getDate() == today.getDate()
              ) {
                var line =
                  '<div class="date" >'
                  + 'Today' + ' <span class="not-important">' + + date.getDate() + " " + months[date.getMonth()] + " " + date.getFullYear() + '</span>'
                  + '</div>';
            } else if (  date.getFullYear() == yesterday.getFullYear() &&
                  date.getMonth() == yesterday.getMonth() &&
                  date.getDate() == yesterday.getDate()
              ) {
                var line =
                  '<div class="date" >'
                  + 'Yesterday' + ' <span class="not-important">' + + date.getDate() + " " + months[date.getMonth()] + " " + date.getFullYear() + '</span>'
                  + '</div>';
              } else {
                var line =
                  '<div class="date" >'
                  + date.getDate() + " " + months[date.getMonth()] + " " + date.getFullYear()
                  + '</div>';
              }
            $("#doneList").append(line);
          }

          taskDone = taskDone + 1;
          var line =
            '<div class ="item" data-id="'+todo.created+'" id="done-' + todo.created + '">'
            + ' <span class="glyphicon glyphicon-chevron-right"></span> '
            + todo.title
            + '</div>';
          $("#doneList").append(line);
          var element = $('#done-' + todo.created).get(0);
          setSwipeRightTo(element, setDeleted);

          previousDate = date;
        });

        if (taskToDo == 0 && taskDone > 0) {
          var allDoneMessage = chooseOne(allDoneMessages);
          $("#userMessage").html("<h3>Yay!</h3><h4>"+ allDoneMessage +"</h4>");
          $("#userMessage").show();
        }
      });

    });
  };

  $("#navigation-done").on('change', function(event) {
    if($('#navigation-done').is(':checked')) {
      $("#done-screen").show();
      $("#done-screen").animate({'left': "0px"}, 500);
    }
  });

  $("#navigation-todo").on('change', function(event) {
    if($('#navigation-todo').is(':checked')) {
      $("#done-screen").animate({'left': "100%"}, 500, function() {
        $("#done-screen").hide();}
      );
    }
  });

  function chooseOne(choices) {
    var index = Math.floor(Math.random() * choices.length);
    return choices[index];
  }

  $(function() {
  	var COOKIE_NAME = 'instructions-already-shown';
  	$instructionAlreadyShown = $.cookie(COOKIE_NAME);
  	if ($instructionAlreadyShown == null) {
      window.track("Instruction begin");
  		$.cookie(COOKIE_NAME, 'yes', { path: '/', expires: 365*3 });
      window.location = "instructions.html"
  	}
  });
});
