var TodoCollection = function TodoCollection(done) {
  var collection= this;
  this.store = new IDBStore({
    storeName: 'Todos',
    dbVersion: 1,
    keyPath: 'created',
    autoIncrement: false,
    indexes: [ { name: 'completed' }]
  }, function () {
    done.call(collection);
  });
}

TodoCollection.prototype = {

  add: function add(sentence, completed) {
    var todo = {created: Date.now(), title: sentence, completed: null};
    this.store.put(todo, completed, this.err);
  },

  setCompleted: function setCompleted(created, completed) {
    var myStore = this.store;
    myStore.get(created, function(todo) {
      todo.completed = Date.now();
      myStore.put(todo, completed, this.err);
    }, this.err);
  },

  getAll: function getAll(completed) {
    this.store.getAll(completed, this.err);
  },

  getAllFromNewest: function getAllFromNewest(completed) {
    this.store.query(completed, {order: 'DESC'});
  },

  getAllCompleted: function getAllCompleted(completed) {
    this.store.query(completed, {index: 'completed', order: 'DESC'});
  },

  remove: function remove(created, completed) {
    this.store.remove(created, completed, this.err);
  },

  clear: function clear(completed) {
    this.store.clear(completed, this.err);
  },

  err: function error(event) {
    console.log("ERROR"+event);
  }

}
