describe('Todo collection', function(){

  beforeEach(function(done){
    var todos = new TodoCollection(
      function() {
        this.clear();
        done();
      }
    );
  });


  it('is empty initially', function(completed){
    var todos = new TodoCollection(
      function() {
        this.getAll(function(result) {
          result.should.have.length(0);
          completed();
        });
      });
  });

  it('can contains todos', function(completed){
    var todos = new TodoCollection(
      function() {
        this.add('a thing to do');
        this.getAll(function(result) {
          result.should.have.length(1);
          completed();
        });
      });
  });

});

describe('Todo', function() {
  var aTodo = null;
  var title = "a thing to do";

  beforeEach(function(done){
    var todos = new TodoCollection(
      function() {
        this.clear();
        this.add(title);
        this.getAll(function(result) {
          aTodo = result[0];
          done();
        });
      }
    );
  });

  it('contains a title', function () {
    aTodo.title.should.equals(title);
  });

  it('contains timestamp of the creation', function () {
    aTodo.created.should.be.not.null;
  });

  it('is initially uncompleted', function () {
    should.not.exist(aTodo.completed);
  });

});
