
// lib/layout/version.js
enyo && enyo.version && (enyo.version.layout = "2.4.0-pre.1");

// lib/layout/contextual/source/ContextualLayout.js
enyo.kind({
    name: "enyo.ContextualLayout",
    kind: "Layout",
    adjustPosition: function() {
        if (this.container.showing && this.container.hasNode()) {
            this.resetPositioning();
            var t = this.getViewWidth(), i = this.getViewHeight(), o = this.container.vertFlushMargin, s = i - this.container.vertFlushMargin, e = this.container.horizFlushMargin, n = t - this.container.horizFlushMargin;
            if (o > this.offset.top + this.offset.height || this.offset.top > s) {
                if (this.applyVerticalFlushPositioning(e, n)) return;
                if (this.applyHorizontalFlushPositioning(e, n)) return;
                if (this.applyVerticalPositioning()) return;
            } else if ((e > this.offset.left + this.offset.width || this.offset.left > n) && this.applyHorizontalPositioning()) return;
            var h = this.getBoundingRect(this.container.node);
            if (h.width > this.container.widePopup) {
                if (this.applyVerticalPositioning()) return;
            } else if (h.height > this.container.longPopup && this.applyHorizontalPositioning()) return;
            if (this.applyVerticalPositioning()) return;
            if (this.applyHorizontalPositioning()) return;
        }
    },
    initVerticalPositioning: function() {
        this.resetPositioning(), this.container.addClass("vertical");
        var t = this.getBoundingRect(this.container.node), i = this.getViewHeight();
        return this.container.floating ? i / 2 > this.offset.top ? (this.applyPosition({
            top: this.offset.top + this.offset.height,
            bottom: "auto"
        }), this.container.addClass("below")) : (this.applyPosition({
            top: this.offset.top - t.height,
            bottom: "auto"
        }), this.container.addClass("above")) : t.top + t.height > i && i - t.bottom < t.top - t.height ? this.container.addClass("above") : this.container.addClass("below"), 
        t = this.getBoundingRect(this.container.node), t.top + t.height > i || 0 > t.top ? !1 : !0;
    },
    applyVerticalPositioning: function() {
        if (!this.initVerticalPositioning()) return !1;
        var t = this.getBoundingRect(this.container.node), i = this.getViewWidth();
        if (this.container.floating) {
            var o = this.offset.left + this.offset.width / 2 - t.width / 2;
            o + t.width > i ? (this.applyPosition({
                left: this.offset.left + this.offset.width - t.width
            }), this.container.addClass("left")) : 0 > o ? (this.applyPosition({
                left: this.offset.left
            }), this.container.addClass("right")) : this.applyPosition({
                left: o
            });
        } else {
            var s = this.offset.left + this.offset.width / 2 - t.left - t.width / 2;
            t.right + s > i ? (this.applyPosition({
                left: this.offset.left + this.offset.width - t.right
            }), this.container.addRemoveClass("left", !0)) : 0 > t.left + s ? this.container.addRemoveClass("right", !0) : this.applyPosition({
                left: s
            });
        }
        return !0;
    },
    applyVerticalFlushPositioning: function(t, i) {
        if (!this.initVerticalPositioning()) return !1;
        var o = this.getBoundingRect(this.container.node), s = this.getViewWidth();
        return t > this.offset.left + this.offset.width / 2 ? (this.offset.left + this.offset.width / 2 < this.container.horizBuffer ? this.applyPosition({
            left: this.container.horizBuffer + (this.container.floating ? 0 : -o.left)
        }) : this.applyPosition({
            left: this.offset.width / 2 + (this.container.floating ? this.offset.left : 0)
        }), this.container.addClass("right"), this.container.addClass("corner"), !0) : this.offset.left + this.offset.width / 2 > i ? (this.offset.left + this.offset.width / 2 > s - this.container.horizBuffer ? this.applyPosition({
            left: s - this.container.horizBuffer - o.right
        }) : this.applyPosition({
            left: this.offset.left + this.offset.width / 2 - o.right
        }), this.container.addClass("left"), this.container.addClass("corner"), !0) : !1;
    },
    initHorizontalPositioning: function() {
        this.resetPositioning();
        var t = this.getBoundingRect(this.container.node), i = this.getViewWidth();
        return this.container.floating ? i / 2 > this.offset.left + this.offset.width ? (this.applyPosition({
            left: this.offset.left + this.offset.width
        }), this.container.addRemoveClass("left", !0)) : (this.applyPosition({
            left: this.offset.left - t.width
        }), this.container.addRemoveClass("right", !0)) : this.offset.left - t.width > 0 ? (this.applyPosition({
            left: this.offset.left - t.left - t.width
        }), this.container.addRemoveClass("right", !0)) : (this.applyPosition({
            left: this.offset.width
        }), this.container.addRemoveClass("left", !0)), this.container.addRemoveClass("horizontal", !0), 
        t = this.getBoundingRect(this.container.node), 0 > t.left || t.left + t.width > i ? !1 : !0;
    },
    applyHorizontalPositioning: function() {
        if (!this.initHorizontalPositioning()) return !1;
        var t = this.getBoundingRect(this.container.node), i = this.getViewHeight(), o = this.offset.top + this.offset.height / 2;
        return this.container.floating ? o >= i / 2 - .05 * i && i / 2 + .05 * i >= o ? this.applyPosition({
            top: this.offset.top + this.offset.height / 2 - t.height / 2,
            bottom: "auto"
        }) : i / 2 > this.offset.top + this.offset.height ? (this.applyPosition({
            top: this.offset.top,
            bottom: "auto"
        }), this.container.addRemoveClass("high", !0)) : (this.applyPosition({
            top: this.offset.top - t.height + 2 * this.offset.height,
            bottom: "auto"
        }), this.container.addRemoveClass("low", !0)) : o >= i / 2 - .05 * i && i / 2 + .05 * i >= o ? this.applyPosition({
            top: (this.offset.height - t.height) / 2
        }) : i / 2 > this.offset.top + this.offset.height ? (this.applyPosition({
            top: -this.offset.height
        }), this.container.addRemoveClass("high", !0)) : (this.applyPosition({
            top: t.top - t.height - this.offset.top + this.offset.height
        }), this.container.addRemoveClass("low", !0)), !0;
    },
    applyHorizontalFlushPositioning: function(t, i) {
        if (!this.initHorizontalPositioning()) return !1;
        var o = this.getBoundingRect(this.container.node), s = this.getViewHeight();
        return this.container.floating ? s / 2 > this.offset.top ? (this.applyPosition({
            top: this.offset.top + this.offset.height / 2
        }), this.container.addRemoveClass("high", !0)) : (this.applyPosition({
            top: this.offset.top + this.offset.height / 2 - o.height
        }), this.container.addRemoveClass("low", !0)) : o.top + o.height > s && s - o.bottom < o.top - o.height ? (this.applyPosition({
            top: o.top - o.height - this.offset.top - this.offset.height / 2
        }), this.container.addRemoveClass("low", !0)) : (this.applyPosition({
            top: this.offset.height / 2
        }), this.container.addRemoveClass("high", !0)), t > this.offset.left + this.offset.width ? (this.container.addClass("left"), 
        this.container.addClass("corner"), !0) : this.offset.left > i ? (this.container.addClass("right"), 
        this.container.addClass("corner"), !0) : !1;
    },
    getBoundingRect: function(t) {
        var i = t.getBoundingClientRect();
        return i.width && i.height ? i : {
            left: i.left,
            right: i.right,
            top: i.top,
            bottom: i.bottom,
            width: i.right - i.left,
            height: i.bottom - i.top
        };
    },
    getViewHeight: function() {
        return void 0 === window.innerHeight ? document.documentElement.clientHeight : window.innerHeight;
    },
    getViewWidth: function() {
        return void 0 === window.innerWidth ? document.documentElement.clientWidth : window.innerWidth;
    },
    applyPosition: function(t) {
        var i = "";
        for (var o in t) i += o + ":" + t[o] + (isNaN(t[o]) ? "; " : "px; ");
        this.container.addStyles(i);
    },
    resetPositioning: function() {
        this.container.removeClass("right"), this.container.removeClass("left"), this.container.removeClass("high"), 
        this.container.removeClass("low"), this.container.removeClass("corner"), this.container.removeClass("below"), 
        this.container.removeClass("above"), this.container.removeClass("vertical"), this.container.removeClass("horizontal"), 
        this.applyPosition({
            left: "auto"
        }), this.applyPosition({
            top: "auto"
        });
    },
    reflow: function() {
        this.offset = this.container.activatorOffset, this.adjustPosition();
    }
});

// lib/layout/fittable/source/FittableLayout.js
enyo.kind({
    name: "enyo.FittableLayout",
    kind: "Layout",
    constructor: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.container.addRemoveClass("force-left-to-right", enyo.Control.prototype.rtl && !this.container.get("rtl"));
        };
    }),
    calcFitIndex: function() {
        var t, i, o = this.container.children;
        for (i = 0; o.length > i; i++) if (t = o[i], t.fit && t.showing) return i;
    },
    getFitControl: function() {
        var t = this.container.children, i = t[this.fitIndex];
        return i && i.fit && i.showing || (this.fitIndex = this.calcFitIndex(), i = t[this.fitIndex]), 
        i;
    },
    shouldReverse: function() {
        return this.container.rtl && "h" === this.orient;
    },
    getFirstChild: function() {
        var t = this.getShowingChildren();
        return this.shouldReverse() ? t[t.length - 1] : t[0];
    },
    getLastChild: function() {
        var t = this.getShowingChildren();
        return this.shouldReverse() ? t[0] : t[t.length - 1];
    },
    getShowingChildren: function() {
        for (var t = [], i = 0, o = this.container.children, e = o.length; e > i; i++) o[i].showing && t.push(o[i]);
        return t;
    },
    _reflow: function(t, i, o, e) {
        this.container.addRemoveClass("enyo-stretch", !this.container.noStretch);
        var s, n, h, a, r, f = this.getFitControl(), l = this.container.hasNode(), d = 0, g = 0, c = 0;
        if (f && l) {
            if (s = enyo.dom.calcPaddingExtents(l), n = f.getBounds(), d = l[i] - (s[o] + s[e]), 
            this.shouldReverse()) {
                a = this.getFirstChild(), c = d - (n[o] + n[t]);
                var p = enyo.dom.getComputedBoxValue(a.hasNode(), "margin", o) || 0;
                if (a == f) g = p; else {
                    var u = a.getBounds(), y = u[o];
                    g = n[o] + p - y;
                }
            } else {
                h = this.getLastChild(), g = n[o] - (s[o] || 0);
                var w = enyo.dom.getComputedBoxValue(h.hasNode(), "margin", e) || 0;
                if (h == f) c = w; else {
                    var v = h.getBounds(), C = n[o] + n[t], m = v[o] + v[t] + w;
                    c = m - C;
                }
            }
            r = d - (g + c), f.applyStyle(t, r + "px");
        }
    },
    reflow: function() {
        "h" == this.orient ? this._reflow("width", "clientWidth", "left", "right") : this._reflow("height", "clientHeight", "top", "bottom");
    }
}), enyo.kind({
    name: "enyo.FittableColumnsLayout",
    kind: "FittableLayout",
    orient: "h",
    layoutClass: "enyo-fittable-columns-layout"
}), enyo.kind({
    name: "enyo.FittableRowsLayout",
    kind: "FittableLayout",
    layoutClass: "enyo-fittable-rows-layout",
    orient: "v"
});

// lib/layout/fittable/source/FittableRows.js
enyo.kind({
    name: "enyo.FittableRows",
    layoutKind: "FittableRowsLayout",
    noStretch: !1
});

// lib/layout/fittable/source/FittableColumns.js
enyo.kind({
    name: "enyo.FittableColumns",
    layoutKind: "FittableColumnsLayout",
    noStretch: !1
});

// lib/layout/fittable/source/FittableHeaderLayout.js
enyo.kind({
    name: "enyo.FittableHeaderLayout",
    kind: "FittableColumnsLayout",
    applyFitSize: enyo.inherit(function(t) {
        return function(i, e, o, n) {
            var s = o - n, h = this.getFitControl();
            0 > s ? (h.applyStyle("padding-left", Math.abs(s) + "px"), h.applyStyle("padding-right", null)) : s > 0 ? (h.applyStyle("padding-left", null), 
            h.applyStyle("padding-right", Math.abs(s) + "px")) : (h.applyStyle("padding-left", null), 
            h.applyStyle("padding-right", null)), t.apply(this, arguments);
        };
    })
});

// lib/layout/list/source/FlyweightRepeater.js
enyo.kind({
    name: "enyo.FlyweightRepeater",
    published: {
        count: 0,
        noSelect: !1,
        multiSelect: !1,
        toggleSelected: !1,
        clientClasses: "",
        clientStyle: "",
        rowOffset: 0,
        orient: "v"
    },
    events: {
        onSetupItem: "",
        onRenderRow: ""
    },
    bottomUp: !1,
    components: [ {
        kind: "Selection",
        onSelect: "selectDeselect",
        onDeselect: "selectDeselect"
    }, {
        name: "client"
    } ],
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.noSelectChanged(), this.multiSelectChanged(), this.clientClassesChanged(), 
            this.clientStyleChanged();
        };
    }),
    noSelectChanged: function() {
        this.noSelect && this.$.selection.clear();
    },
    multiSelectChanged: function() {
        this.$.selection.setMulti(this.multiSelect);
    },
    clientClassesChanged: function() {
        this.$.client.setClasses(this.clientClasses);
    },
    clientStyleChanged: function() {
        this.$.client.setStyle(this.clientStyle);
    },
    setupItem: function(t) {
        this.doSetupItem({
            index: t,
            selected: this.isSelected(t)
        });
    },
    generateChildHtml: enyo.inherit(function(t) {
        return function() {
            var i = "";
            this.index = null;
            for (var e = 0, o = 0; this.count > e; e++) o = this.rowOffset + (this.bottomUp ? this.count - e - 1 : e), 
            this.setupItem(o), this.$.client.setAttribute("data-enyo-index", o), "h" == this.orient && this.$.client.setStyle("display:inline-block;"), 
            i += t.apply(this, arguments), this.$.client.teardownRender();
            return i;
        };
    }),
    previewDomEvent: function(t) {
        var i = this.index = this.rowForEvent(t);
        t.rowIndex = t.index = i, t.flyweight = this;
    },
    decorateEvent: enyo.inherit(function(t) {
        return function(i, e) {
            var o = e && null != e.index ? e.index : this.index;
            e && null != o && (e.index = o, e.flyweight = this), t.apply(this, arguments);
        };
    }),
    tap: function(t, i) {
        this.noSelect || -1 === i.index || (this.toggleSelected ? this.$.selection.toggle(i.index) : this.$.selection.select(i.index));
    },
    selectDeselect: function(t, i) {
        this.renderRow(i.key);
    },
    getSelection: function() {
        return this.$.selection;
    },
    isSelected: function(t) {
        return this.getSelection().isSelected(t);
    },
    renderRow: function(t) {
        if (!(this.rowOffset > t || t >= this.count + this.rowOffset)) {
            this.setupItem(t);
            var i = this.fetchRowNode(t);
            i && (enyo.dom.setInnerHtml(i, this.$.client.generateChildHtml()), this.$.client.teardownChildren(), 
            this.doRenderRow({
                rowIndex: t
            }));
        }
    },
    fetchRowNode: function(t) {
        return this.hasNode() ? this.node.querySelector('[data-enyo-index="' + t + '"]') : void 0;
    },
    rowForEvent: function(t) {
        if (!this.hasNode()) return -1;
        for (var i = t.target; i && i !== this.node; ) {
            var e = i.getAttribute && i.getAttribute("data-enyo-index");
            if (null !== e) return Number(e);
            i = i.parentNode;
        }
        return -1;
    },
    prepareRow: function(t) {
        if (!(this.rowOffset > t || t >= this.count + this.rowOffset)) {
            this.setupItem(t);
            var i = this.fetchRowNode(t);
            enyo.FlyweightRepeater.claimNode(this.$.client, i);
        }
    },
    lockRow: function() {
        this.$.client.teardownChildren();
    },
    performOnRow: function(t, i, e) {
        this.rowOffset > t || t >= this.count + this.rowOffset || i && (this.prepareRow(t), 
        enyo.call(e || null, i), this.lockRow());
    },
    statics: {
        claimNode: function(t, i) {
            var e;
            i && (e = i.id !== t.id ? i.querySelector("#" + t.id) : i), t.generated = Boolean(e || !t.tag), 
            t.node = e, t.node && t.rendered();
            for (var o, n = 0, s = t.children; o = s[n]; n++) this.claimNode(o, i);
        }
    }
});

// lib/layout/list/source/List.js
enyo.kind({
    name: "enyo.List",
    kind: "Scroller",
    classes: "enyo-list",
    published: {
        count: 0,
        rowsPerPage: 50,
        orient: "v",
        bottomUp: !1,
        noSelect: !1,
        multiSelect: !1,
        toggleSelected: !1,
        fixedSize: !1,
        reorderable: !1,
        centerReorderContainer: !0,
        reorderComponents: [],
        pinnedReorderComponents: [],
        swipeableComponents: [],
        enableSwipe: !1,
        persistSwipeableItem: !1
    },
    events: {
        onSetupItem: "",
        onSetupReorderComponents: "",
        onSetupPinnedReorderComponents: "",
        onReorder: "",
        onSetupSwipeItem: "",
        onSwipeDrag: "",
        onSwipe: "",
        onSwipeComplete: ""
    },
    handlers: {
        onAnimateFinish: "animateFinish",
        onRenderRow: "rowRendered",
        ondragstart: "dragstart",
        ondrag: "drag",
        ondragfinish: "dragfinish",
        onup: "up",
        onholdpulse: "holdpulse",
        onflick: "flick"
    },
    rowSize: 0,
    listTools: [ {
        name: "port",
        classes: "enyo-list-port enyo-border-box",
        components: [ {
            name: "generator",
            kind: "FlyweightRepeater",
            canGenerate: !1,
            components: [ {
                tag: null,
                name: "client"
            } ]
        }, {
            name: "holdingarea",
            allowHtml: !0,
            classes: "enyo-list-holdingarea"
        }, {
            name: "page0",
            allowHtml: !0,
            classes: "enyo-list-page"
        }, {
            name: "page1",
            allowHtml: !0,
            classes: "enyo-list-page"
        }, {
            name: "placeholder",
            classes: "enyo-list-placeholder"
        }, {
            name: "swipeableComponents",
            style: "position:absolute; display:block; top:-1000px; left:0;"
        } ]
    } ],
    reorderHoldTimeMS: 600,
    draggingRowIndex: -1,
    initHoldCounter: 3,
    holdCounter: 3,
    holding: !1,
    draggingRowNode: null,
    placeholderRowIndex: -1,
    dragToScrollThreshold: .1,
    prevScrollTop: 0,
    autoScrollTimeoutMS: 20,
    autoScrollTimeout: null,
    autoscrollPageY: 0,
    pinnedReorderMode: !1,
    initialPinPosition: -1,
    itemMoved: !1,
    currentPageNumber: -1,
    completeReorderTimeout: null,
    swipeIndex: null,
    swipeDirection: null,
    persistentItemVisible: !1,
    persistentItemOrigin: null,
    swipeComplete: !1,
    completeSwipeTimeout: null,
    completeSwipeDelayMS: 500,
    normalSwipeSpeedMS: 200,
    fastSwipeSpeedMS: 100,
    percentageDraggedThreshold: .2,
    importProps: enyo.inherit(function(t) {
        return function(e) {
            e && e.reorderable && (this.touch = !0), t.apply(this, arguments);
        };
    }),
    create: enyo.inherit(function(t) {
        return function() {
            this.pageSizes = [], this.orientV = "v" == this.orient, this.vertical = this.orientV ? "default" : "hidden", 
            t.apply(this, arguments), this.$.generator.orient = this.orient, this.getStrategy().translateOptimized = !0, 
            this.$.port.addRemoveClass("horizontal", !this.orientV), this.$.port.addRemoveClass("vertical", this.orientV), 
            this.$.page0.addRemoveClass("vertical", this.orientV), this.$.page1.addRemoveClass("vertical", this.orientV), 
            this.bottomUpChanged(), this.noSelectChanged(), this.multiSelectChanged(), this.toggleSelectedChanged(), 
            this.$.generator.setRowOffset(0), this.$.generator.setCount(this.count);
        };
    }),
    initComponents: enyo.inherit(function(t) {
        return function() {
            this.createReorderTools(), t.apply(this, arguments), this.createSwipeableComponents();
        };
    }),
    createReorderTools: function() {
        this.createComponent({
            name: "reorderContainer",
            classes: "enyo-list-reorder-container",
            ondown: "sendToStrategy",
            ondrag: "sendToStrategy",
            ondragstart: "sendToStrategy",
            ondragfinish: "sendToStrategy",
            onflick: "sendToStrategy"
        });
    },
    createStrategy: enyo.inherit(function(t) {
        return function() {
            this.controlParentName = "strategy", t.apply(this, arguments), this.createChrome(this.listTools), 
            this.controlParentName = "client", this.discoverControlParent();
        };
    }),
    createSwipeableComponents: function() {
        for (var t = 0; this.swipeableComponents.length > t; t++) this.$.swipeableComponents.createComponent(this.swipeableComponents[t], {
            owner: this.owner
        });
    },
    rendered: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.$.generator.node = this.$.port.hasNode(), this.$.generator.generated = !0, 
            this.reset();
        };
    }),
    resizeHandler: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.refresh();
        };
    }),
    bottomUpChanged: function() {
        this.$.generator.bottomUp = this.bottomUp, this.$.page0.applyStyle(this.pageBound, null), 
        this.$.page1.applyStyle(this.pageBound, null), this.pageBound = this.orientV ? this.bottomUp ? "bottom" : "top" : this.rtl ? this.bottomUp ? "left" : "right" : this.bottomUp ? "right" : "left", 
        !this.orientV && this.bottomUp && (this.$.page0.applyStyle("left", "auto"), this.$.page1.applyStyle("left", "auto")), 
        this.hasNode() && this.reset();
    },
    noSelectChanged: function() {
        this.$.generator.setNoSelect(this.noSelect);
    },
    multiSelectChanged: function() {
        this.$.generator.setMultiSelect(this.multiSelect);
    },
    toggleSelectedChanged: function() {
        this.$.generator.setToggleSelected(this.toggleSelected);
    },
    countChanged: function() {
        this.hasNode() && this.updateMetrics();
    },
    sendToStrategy: function(t, e) {
        this.$.strategy.dispatchEvent("on" + e.type, e, t);
    },
    updateMetrics: function() {
        this.defaultPageSize = this.rowsPerPage * (this.rowSize || 100), this.pageCount = Math.ceil(this.count / this.rowsPerPage), 
        this.portSize = 0;
        for (var t = 0; this.pageCount > t; t++) this.portSize += this.getPageSize(t);
        this.adjustPortSize();
    },
    holdpulse: function(t, e) {
        return this.getReorderable() && !this.isReordering() ? e.holdTime >= this.reorderHoldTimeMS && this.shouldStartReordering(t, e) ? (this.startReordering(e), 
        !1) : void 0 : void 0;
    },
    dragstart: function(t, e) {
        return this.isReordering() ? !0 : this.isSwipeable() ? this.swipeDragStart(t, e) : void 0;
    },
    drag: function(t, e) {
        return this.shouldDoReorderDrag(e) ? (e.preventDefault(), this.reorderDrag(e), !0) : this.isSwipeable() ? (e.preventDefault(), 
        this.swipeDrag(t, e), !0) : void 0;
    },
    dragfinish: function(t, e) {
        this.isReordering() ? this.finishReordering(t, e) : this.isSwipeable() && this.swipeDragFinish(t, e);
    },
    up: function(t, e) {
        this.isReordering() && this.finishReordering(t, e);
    },
    generatePage: function(t, e) {
        this.page = t;
        var i = this.rowsPerPage * this.page;
        this.$.generator.setRowOffset(i);
        var o = Math.min(this.count - i, this.rowsPerPage);
        this.$.generator.setCount(o);
        var n = this.$.generator.generateChildHtml();
        e.setContent(n), this.getReorderable() && this.draggingRowIndex > -1 && this.hideReorderingRow();
        var s = e.getBounds(), r = this.orientV ? s.height : s.width;
        if (!this.rowSize && r > 0 && (this.rowSize = Math.floor(r / o), this.updateMetrics()), 
        !this.fixedSize) {
            var h = this.getPageSize(t);
            h != r && r > 0 && (this.pageSizes[t] = r, this.portSize += r - h);
        }
    },
    pageForRow: function(t) {
        return Math.floor(t / this.rowsPerPage);
    },
    preserveDraggingRowNode: function(t) {
        this.draggingRowNode && this.pageForRow(this.draggingRowIndex) === t && (this.$.holdingarea.hasNode().appendChild(this.draggingRowNode), 
        this.draggingRowNode = null, this.removedInitialPage = !0);
    },
    update: function(t) {
        var e = !1, i = this.positionToPageInfo(t), o = i.pos + this.scrollerSize / 2, n = Math.floor(o / Math.max(i.size, this.scrollerSize) + .5) + i.no, s = 0 === n % 2 ? n : n - 1;
        this.p0 != s && this.isPageInRange(s) && (this.preserveDraggingRowNode(this.p0), 
        this.generatePage(s, this.$.page0), this.positionPage(s, this.$.page0), this.p0 = s, 
        e = !0, this.p0RowBounds = this.getPageRowSizes(this.$.page0)), s = 0 === n % 2 ? Math.max(1, n - 1) : n, 
        this.p1 != s && this.isPageInRange(s) && (this.preserveDraggingRowNode(this.p1), 
        this.generatePage(s, this.$.page1), this.positionPage(s, this.$.page1), this.p1 = s, 
        e = !0, this.p1RowBounds = this.getPageRowSizes(this.$.page1)), e && (this.$.generator.setRowOffset(0), 
        this.$.generator.setCount(this.count), this.fixedSize || (this.adjustBottomPage(), 
        this.adjustPortSize()));
    },
    getPageRowSizes: function(t) {
        for (var e, i, o = {}, n = t.hasNode().querySelectorAll("div[data-enyo-index]"), s = 0; n.length > s; s++) e = n[s].getAttribute("data-enyo-index"), 
        null !== e && (i = enyo.dom.getBounds(n[s]), o[parseInt(e, 10)] = {
            height: i.height,
            width: i.width
        });
        return o;
    },
    updateRowBounds: function(t) {
        this.p0RowBounds[t] ? this.updateRowBoundsAtIndex(t, this.p0RowBounds, this.$.page0) : this.p1RowBounds[t] && this.updateRowBoundsAtIndex(t, this.p1RowBounds, this.$.page1);
    },
    updateRowBoundsAtIndex: function(t, e, i) {
        var o = i.hasNode().querySelector('div[data-enyo-index="' + t + '"]'), n = enyo.dom.getBounds(o);
        e[t].height = n.height, e[t].width = n.width;
    },
    updateForPosition: function(t) {
        this.update(this.calcPos(t));
    },
    calcPos: function(t) {
        return this.bottomUp ? this.portSize - this.scrollerSize - t : t;
    },
    adjustBottomPage: function() {
        var t = this.p0 >= this.p1 ? this.$.page0 : this.$.page1;
        this.positionPage(t.pageNo, t);
    },
    adjustPortSize: function() {
        this.scrollerSize = this.orientV ? this.getBounds().height : this.getBounds().width;
        var t = Math.max(this.scrollerSize, this.portSize);
        this.$.port.applyStyle(this.orientV ? "height" : "width", t + "px"), this.orientV || this.$.port.applyStyle("height", this.getBounds().height + "px");
    },
    positionPage: function(t, e) {
        e.pageNo = t;
        var i = this.pageToPosition(t);
        e.applyStyle(this.pageBound, i + "px");
    },
    pageToPosition: function(t) {
        for (var e = 0, i = t; i > 0; ) i--, e += this.getPageSize(i);
        return e;
    },
    positionToPageInfo: function(t) {
        for (var e = -1, i = this.calcPos(t), o = this.defaultPageSize; i >= 0; ) e++, o = this.getPageSize(e), 
        i -= o;
        return e = Math.max(e, 0), {
            no: e,
            size: o,
            pos: i + o,
            startRow: e * this.rowsPerPage,
            endRow: Math.min((e + 1) * this.rowsPerPage - 1, this.count - 1)
        };
    },
    isPageInRange: function(t) {
        return t == Math.max(0, Math.min(this.pageCount - 1, t));
    },
    getPageSize: function(t) {
        var e = this.pageSizes[t];
        if (!e) {
            var i = this.rowsPerPage * t, o = Math.min(this.count - i, this.rowsPerPage);
            e = this.defaultPageSize * (o / this.rowsPerPage);
        }
        return Math.max(1, e);
    },
    invalidatePages: function() {
        this.p0 = this.p1 = null, this.p0RowBounds = {}, this.p1RowBounds = {}, this.$.page0.setContent(""), 
        this.$.page1.setContent("");
    },
    invalidateMetrics: function() {
        this.pageSizes = [], this.rowSize = 0, this.updateMetrics();
    },
    scroll: enyo.inherit(function(t) {
        return function(e, i) {
            var o = t.apply(this, arguments), n = this.orientV ? this.getScrollTop() : this.getScrollLeft();
            return this.lastPos === n ? o : (this.lastPos = n, this.update(n), this.pinnedReorderMode && this.reorderScroll(e, i), 
            o);
        };
    }),
    setScrollTop: enyo.inherit(function(t) {
        return function(e) {
            this.update(e), t.apply(this, arguments), this.twiddle();
        };
    }),
    getScrollPosition: function() {
        return this.calcPos(this[this.orientV ? "getScrollTop" : "getScrollLeft"]());
    },
    setScrollPosition: function(t) {
        this[this.orientV ? "setScrollTop" : "setScrollLeft"](this.calcPos(t));
    },
    scrollToBottom: enyo.inherit(function(t) {
        return function() {
            this.update(this.getScrollBounds().maxTop), t.apply(this, arguments);
        };
    }),
    scrollToRow: function(t) {
        var e = this.pageForRow(t), i = this.pageToPosition(e);
        if (this.updateForPosition(i), i = this.pageToPosition(e), this.setScrollPosition(i), 
        e == this.p0 || e == this.p1) {
            var o = this.$.generator.fetchRowNode(t);
            if (o) {
                var n = this.orientV ? o.offsetTop : o.offsetLeft;
                this.bottomUp && (n = this.getPageSize(e) - (this.orientV ? o.offsetHeight : o.offsetWidth) - n);
                var s = this.getScrollPosition() + n;
                this.setScrollPosition(s);
            }
        }
    },
    scrollToStart: function() {
        this[this.bottomUp ? this.orientV ? "scrollToBottom" : "scrollToRight" : "scrollToTop"]();
    },
    scrollToEnd: function() {
        this[this.bottomUp ? this.orientV ? "scrollToTop" : "scrollToLeft" : this.orientV ? "scrollToBottom" : "scrollToRight"]();
    },
    refresh: function() {
        this.invalidatePages(), this.update(this[this.orientV ? "getScrollTop" : "getScrollLeft"]()), 
        this.stabilize(), 4 === enyo.platform.android && this.twiddle();
    },
    reset: function() {
        this.getSelection().clear(), this.invalidateMetrics(), this.invalidatePages(), this.stabilize(), 
        this.scrollToStart();
    },
    getSelection: function() {
        return this.$.generator.getSelection();
    },
    select: function(t, e) {
        return this.getSelection().select(t, e);
    },
    deselect: function(t) {
        return this.getSelection().deselect(t);
    },
    isSelected: function(t) {
        return this.$.generator.isSelected(t);
    },
    renderRow: function(t) {
        this.$.generator.renderRow(t);
    },
    rowRendered: function(t, e) {
        this.updateRowBounds(e.rowIndex);
    },
    prepareRow: function(t) {
        this.$.generator.prepareRow(t);
    },
    lockRow: function() {
        this.$.generator.lockRow();
    },
    performOnRow: function(t, e, i) {
        this.$.generator.performOnRow(t, e, i);
    },
    animateFinish: function() {
        return this.twiddle(), !0;
    },
    twiddle: function() {
        var t = this.getStrategy();
        enyo.call(t, "twiddle");
    },
    pageForPageNumber: function(t, e) {
        return 0 === t % 2 ? e && t !== this.p0 ? null : this.$.page0 : e && t !== this.p1 ? null : this.$.page1;
    },
    shouldStartReordering: function(t, e) {
        return !this.getReorderable() || null == e.rowIndex || 0 > e.rowIndex || this.pinnedReorderMode || t !== this.$.strategy || null == e.index || 0 > e.index ? !1 : !0;
    },
    startReordering: function(t) {
        this.$.strategy.listReordering = !0, this.buildReorderContainer(), this.doSetupReorderComponents(t), 
        this.styleReorderContainer(t), this.draggingRowIndex = this.placeholderRowIndex = t.rowIndex, 
        this.draggingRowNode = t.target, this.removedInitialPage = !1, this.itemMoved = !1, 
        this.initialPageNumber = this.currentPageNumber = this.pageForRow(t.rowIndex), this.prevScrollTop = this.getScrollTop(), 
        this.replaceNodeWithPlaceholder(t.rowIndex);
    },
    buildReorderContainer: function() {
        this.$.reorderContainer.destroyClientControls();
        for (var t = 0; this.reorderComponents.length > t; t++) this.$.reorderContainer.createComponent(this.reorderComponents[t], {
            owner: this.owner
        });
        this.$.reorderContainer.render();
    },
    styleReorderContainer: function(t) {
        this.setItemPosition(this.$.reorderContainer, t.rowIndex), this.setItemBounds(this.$.reorderContainer, t.rowIndex), 
        this.$.reorderContainer.setShowing(!0), this.centerReorderContainer && this.centerReorderContainerOnPointer(t);
    },
    appendNodeToReorderContainer: function(t) {
        this.$.reorderContainer.createComponent({
            allowHtml: !0,
            content: t.innerHTML
        }).render();
    },
    centerReorderContainerOnPointer: function(t) {
        var e = enyo.dom.calcNodePosition(this.hasNode()), i = t.pageX - e.left - parseInt(this.$.reorderContainer.domStyles.width, 10) / 2, o = t.pageY - e.top + this.getScrollTop() - parseInt(this.$.reorderContainer.domStyles.height, 10) / 2;
        "ScrollStrategy" != this.getStrategyKind() && (i -= this.getScrollLeft(), o -= this.getScrollTop()), 
        this.positionReorderContainer(i, o);
    },
    positionReorderContainer: function(t, e) {
        this.$.reorderContainer.addClass("enyo-animatedTopAndLeft"), this.$.reorderContainer.addStyles("left:" + t + "px;top:" + e + "px;"), 
        this.setPositionReorderContainerTimeout();
    },
    setPositionReorderContainerTimeout: function() {
        this.clearPositionReorderContainerTimeout(), this.positionReorderContainerTimeout = setTimeout(this.bindSafely(function() {
            this.$.reorderContainer.removeClass("enyo-animatedTopAndLeft"), this.clearPositionReorderContainerTimeout();
        }), 100);
    },
    clearPositionReorderContainerTimeout: function() {
        this.positionReorderContainerTimeout && (clearTimeout(this.positionReorderContainerTimeout), 
        this.positionReorderContainerTimeout = null);
    },
    shouldDoReorderDrag: function() {
        return !this.getReorderable() || 0 > this.draggingRowIndex || this.pinnedReorderMode ? !1 : !0;
    },
    reorderDrag: function(t) {
        this.positionReorderNode(t), this.checkForAutoScroll(t), this.updatePlaceholderPosition(t.pageY);
    },
    updatePlaceholderPosition: function(t) {
        var e = this.getRowIndexFromCoordinate(t);
        -1 !== e && (e >= this.placeholderRowIndex ? this.movePlaceholderToIndex(Math.min(this.count, e + 1)) : this.movePlaceholderToIndex(e));
    },
    positionReorderNode: function(t) {
        var e = this.$.reorderContainer.getBounds(), i = e.left + t.ddx, o = e.top + t.ddy;
        o = "ScrollStrategy" == this.getStrategyKind() ? o + (this.getScrollTop() - this.prevScrollTop) : o, 
        this.$.reorderContainer.addStyles("top: " + o + "px ; left: " + i + "px"), this.prevScrollTop = this.getScrollTop();
    },
    checkForAutoScroll: function(t) {
        var e, i = enyo.dom.calcNodePosition(this.hasNode()), o = this.getBounds();
        this.autoscrollPageY = t.pageY, t.pageY - i.top < o.height * this.dragToScrollThreshold ? (e = 100 * (1 - (t.pageY - i.top) / (o.height * this.dragToScrollThreshold)), 
        this.scrollDistance = -1 * e) : t.pageY - i.top > o.height * (1 - this.dragToScrollThreshold) ? (e = 100 * ((t.pageY - i.top - o.height * (1 - this.dragToScrollThreshold)) / (o.height - o.height * (1 - this.dragToScrollThreshold))), 
        this.scrollDistance = 1 * e) : this.scrollDistance = 0, 0 === this.scrollDistance ? this.stopAutoScrolling() : this.autoScrollTimeout || this.startAutoScrolling();
    },
    stopAutoScrolling: function() {
        this.autoScrollTimeout && (clearTimeout(this.autoScrollTimeout), this.autoScrollTimeout = null);
    },
    startAutoScrolling: function() {
        this.autoScrollTimeout = setInterval(this.bindSafely(this.autoScroll), this.autoScrollTimeoutMS);
    },
    autoScroll: function() {
        0 === this.scrollDistance ? this.stopAutoScrolling() : this.autoScrollTimeout || this.startAutoScrolling(), 
        this.setScrollPosition(this.getScrollPosition() + this.scrollDistance), this.positionReorderNode({
            ddx: 0,
            ddy: 0
        }), this.updatePlaceholderPosition(this.autoscrollPageY);
    },
    movePlaceholderToIndex: function(t) {
        var e, i;
        if (!(0 > t)) {
            t >= this.count ? (e = null, i = this.pageForPageNumber(this.pageForRow(this.count - 1)).hasNode()) : (e = this.$.generator.fetchRowNode(t), 
            i = e.parentNode);
            var o = this.pageForRow(t);
            o >= this.pageCount && (o = this.currentPageNumber), i.insertBefore(this.placeholderNode, e), 
            this.currentPageNumber !== o && (this.updatePageSize(this.currentPageNumber), this.updatePageSize(o), 
            this.updatePagePositions(o)), this.placeholderRowIndex = t, this.currentPageNumber = o, 
            this.itemMoved = !0;
        }
    },
    finishReordering: function(t, e) {
        return !this.isReordering() || this.pinnedReorderMode || this.completeReorderTimeout ? void 0 : (this.stopAutoScrolling(), 
        this.$.strategy.listReordering = !1, this.moveReorderedContainerToDroppedPosition(e), 
        this.completeReorderTimeout = setTimeout(this.bindSafely(this.completeFinishReordering, e), 100), 
        e.preventDefault(), !0);
    },
    moveReorderedContainerToDroppedPosition: function() {
        var t = this.getRelativeOffset(this.placeholderNode, this.hasNode()), e = "ScrollStrategy" == this.getStrategyKind() ? t.top : t.top - this.getScrollTop(), i = t.left - this.getScrollLeft();
        this.positionReorderContainer(i, e);
    },
    completeFinishReordering: function(t) {
        return this.completeReorderTimeout = null, this.placeholderRowIndex > this.draggingRowIndex && (this.placeholderRowIndex = Math.max(0, this.placeholderRowIndex - 1)), 
        this.draggingRowIndex != this.placeholderRowIndex || !this.pinnedReorderComponents.length || this.pinnedReorderMode || this.itemMoved ? (this.removeDraggingRowNode(), 
        this.removePlaceholderNode(), this.emptyAndHideReorderContainer(), this.pinnedReorderMode = !1, 
        this.reorderRows(t), this.draggingRowIndex = this.placeholderRowIndex = -1, this.refresh(), 
        void 0) : (this.beginPinnedReorder(t), void 0);
    },
    beginPinnedReorder: function(t) {
        this.buildPinnedReorderContainer(), this.doSetupPinnedReorderComponents(enyo.mixin(t, {
            index: this.draggingRowIndex
        })), this.pinnedReorderMode = !0, this.initialPinPosition = t.pageY;
    },
    emptyAndHideReorderContainer: function() {
        this.$.reorderContainer.destroyComponents(), this.$.reorderContainer.setShowing(!1);
    },
    buildPinnedReorderContainer: function() {
        this.$.reorderContainer.destroyClientControls();
        for (var t = 0; this.pinnedReorderComponents.length > t; t++) this.$.reorderContainer.createComponent(this.pinnedReorderComponents[t], {
            owner: this.owner
        });
        this.$.reorderContainer.render();
    },
    reorderRows: function(t) {
        this.doReorder(this.makeReorderEvent(t)), this.positionReorderedNode(), this.updateListIndices();
    },
    makeReorderEvent: function(t) {
        return t.reorderFrom = this.draggingRowIndex, t.reorderTo = this.placeholderRowIndex, 
        t;
    },
    positionReorderedNode: function() {
        if (!this.removedInitialPage) {
            var t = this.$.generator.fetchRowNode(this.placeholderRowIndex);
            if (t && (t.parentNode.insertBefore(this.hiddenNode, t), this.showNode(this.hiddenNode)), 
            this.hiddenNode = null, this.currentPageNumber != this.initialPageNumber) {
                var e, i, o = this.pageForPageNumber(this.currentPageNumber), n = this.pageForPageNumber(this.currentPageNumber + 1);
                this.initialPageNumber < this.currentPageNumber ? (e = o.hasNode().firstChild, n.hasNode().appendChild(e)) : (e = o.hasNode().lastChild, 
                i = n.hasNode().firstChild, n.hasNode().insertBefore(e, i)), this.correctPageSizes(), 
                this.updatePagePositions(this.initialPageNumber);
            }
        }
    },
    updateListIndices: function() {
        if (this.shouldDoRefresh()) return this.refresh(), this.correctPageSizes(), void 0;
        var t, e, i, o, n = Math.min(this.draggingRowIndex, this.placeholderRowIndex), s = Math.max(this.draggingRowIndex, this.placeholderRowIndex), r = this.draggingRowIndex - this.placeholderRowIndex > 0 ? 1 : -1;
        if (1 === r) {
            for (t = this.$.generator.fetchRowNode(this.draggingRowIndex), t && t.setAttribute("data-enyo-index", "reordered"), 
            e = s - 1, i = s; e >= n; e--) t = this.$.generator.fetchRowNode(e), t && (o = parseInt(t.getAttribute("data-enyo-index"), 10), 
            i = o + 1, t.setAttribute("data-enyo-index", i));
            t = this.hasNode().querySelector('[data-enyo-index="reordered"]'), t.setAttribute("data-enyo-index", this.placeholderRowIndex);
        } else for (t = this.$.generator.fetchRowNode(this.draggingRowIndex), t && t.setAttribute("data-enyo-index", this.placeholderRowIndex), 
        e = n + 1, i = n; s >= e; e++) t = this.$.generator.fetchRowNode(e), t && (o = parseInt(t.getAttribute("data-enyo-index"), 10), 
        i = o - 1, t.setAttribute("data-enyo-index", i));
    },
    shouldDoRefresh: function() {
        return Math.abs(this.initialPageNumber - this.currentPageNumber) > 1;
    },
    getNodeStyle: function(t) {
        var e = this.$.generator.fetchRowNode(t);
        if (e) {
            var i = this.getRelativeOffset(e, this.hasNode()), o = enyo.dom.getBounds(e);
            return {
                h: o.height,
                w: o.width,
                left: i.left,
                top: i.top
            };
        }
    },
    getRelativeOffset: function(t, e) {
        var i = {
            top: 0,
            left: 0
        };
        if (t !== e && t.parentNode) do i.top += t.offsetTop || 0, i.left += t.offsetLeft || 0, 
        t = t.offsetParent; while (t && t !== e);
        return i;
    },
    replaceNodeWithPlaceholder: function(t) {
        var e = this.$.generator.fetchRowNode(t);
        if (!e) return enyo.log("No node - " + t), void 0;
        this.placeholderNode = this.createPlaceholderNode(e), this.hiddenNode = this.hideNode(e);
        var i = this.pageForPageNumber(this.currentPageNumber);
        i.hasNode().insertBefore(this.placeholderNode, this.hiddenNode);
    },
    createPlaceholderNode: function(t) {
        var e = this.$.placeholder.hasNode().cloneNode(!0), i = enyo.dom.getBounds(t);
        return e.style.height = i.height + "px", e.style.width = i.width + "px", e;
    },
    removePlaceholderNode: function() {
        this.removeNode(this.placeholderNode), this.placeholderNode = null;
    },
    removeDraggingRowNode: function() {
        this.draggingRowNode = null;
        var t = this.$.holdingarea.hasNode();
        t.innerHTML = "";
    },
    removeNode: function(t) {
        t && t.parentNode && t.parentNode.removeChild(t);
    },
    updatePageSize: function(t) {
        if (!(0 > t)) {
            var e = this.pageForPageNumber(t, !0);
            if (e) {
                var i = this.pageSizes[t], o = Math.max(1, e.getBounds().height);
                this.pageSizes[t] = o, this.portSize += o - i;
            }
        }
    },
    updatePagePositions: function(t) {
        this.positionPage(this.currentPageNumber, this.pageForPageNumber(this.currentPageNumber)), 
        this.positionPage(t, this.pageForPageNumber(t));
    },
    correctPageSizes: function() {
        var t = this.initialPageNumber % 2;
        this.updatePageSize(this.currentPageNumber, this.$["page" + this.currentPage]), 
        t != this.currentPageNumber && this.updatePageSize(this.initialPageNumber, this.$["page" + t]);
    },
    hideNode: function(t) {
        return t.style.display = "none", t;
    },
    showNode: function(t) {
        return t.style.display = "block", t;
    },
    dropPinnedRow: function(t) {
        this.moveReorderedContainerToDroppedPosition(t), this.completeReorderTimeout = setTimeout(this.bindSafely(this.completeFinishReordering, t), 100);
    },
    cancelPinnedMode: function(t) {
        this.placeholderRowIndex = this.draggingRowIndex, this.dropPinnedRow(t);
    },
    getRowIndexFromCoordinate: function(t) {
        var e = this.getScrollTop() + t - enyo.dom.calcNodePosition(this.hasNode()).top;
        if (0 > e) return -1;
        var i = this.positionToPageInfo(e), o = i.no == this.p0 ? this.p0RowBounds : this.p1RowBounds;
        if (!o) return this.count;
        for (var n = i.pos, s = this.placeholderNode ? enyo.dom.getBounds(this.placeholderNode).height : 0, r = 0, h = i.startRow; i.endRow >= h; ++h) {
            if (h === this.placeholderRowIndex && (r += s, r >= n)) return -1;
            if (h !== this.draggingRowIndex && (r += o[h].height, r >= n)) return h;
        }
        return h;
    },
    getIndexPosition: function(t) {
        return enyo.dom.calcNodePosition(this.$.generator.fetchRowNode(t));
    },
    setItemPosition: function(t, e) {
        var i = this.getNodeStyle(e), o = "ScrollStrategy" == this.getStrategyKind() ? i.top : i.top - this.getScrollTop(), n = "top:" + o + "px; left:" + i.left + "px;";
        t.addStyles(n);
    },
    setItemBounds: function(t, e) {
        var i = this.getNodeStyle(e), o = "width:" + i.w + "px; height:" + i.h + "px;";
        t.addStyles(o);
    },
    reorderScroll: function() {
        "ScrollStrategy" == this.getStrategyKind() && this.$.reorderContainer.addStyles("top:" + (this.initialPinPosition + this.getScrollTop() - this.rowSize) + "px;"), 
        this.updatePlaceholderPosition(this.initialPinPosition);
    },
    hideReorderingRow: function() {
        var t = this.hasNode().querySelector('[data-enyo-index="' + this.draggingRowIndex + '"]');
        t && (this.hiddenNode = this.hideNode(t));
    },
    isReordering: function() {
        return this.draggingRowIndex > -1;
    },
    isSwiping: function() {
        return null != this.swipeIndex && !this.swipeComplete && null != this.swipeDirection;
    },
    swipeDragStart: function(t, e) {
        return null == e.index || e.vertical ? !0 : (this.completeSwipeTimeout && this.completeSwipe(e), 
        this.swipeComplete = !1, this.swipeIndex != e.index && (this.clearSwipeables(), 
        this.swipeIndex = e.index), this.swipeDirection = e.xDirection, this.persistentItemVisible || this.startSwipe(e), 
        this.draggedXDistance = 0, this.draggedYDistance = 0, !0);
    },
    swipeDrag: function(t, e) {
        return this.persistentItemVisible ? (this.dragPersistentItem(e), this.preventDragPropagation) : this.isSwiping() ? (this.dragSwipeableComponents(this.calcNewDragPosition(e.ddx)), 
        this.draggedXDistance = e.dx, this.draggedYDistance = e.dy, !0) : !1;
    },
    swipeDragFinish: function(t, e) {
        if (this.persistentItemVisible) this.dragFinishPersistentItem(e); else {
            if (!this.isSwiping()) return !1;
            var i = this.calcPercentageDragged(this.draggedXDistance);
            i > this.percentageDraggedThreshold && e.xDirection === this.swipeDirection ? this.swipe(this.fastSwipeSpeedMS) : this.backOutSwipe(e);
        }
        return this.preventDragPropagation;
    },
    isSwipeable: function() {
        return this.enableSwipe && 0 !== this.$.swipeableComponents.controls.length && !this.isReordering() && !this.pinnedReorderMode;
    },
    positionSwipeableContainer: function(t, e) {
        var i = this.$.generator.fetchRowNode(t);
        if (i) {
            var o = this.getRelativeOffset(i, this.hasNode()), n = enyo.dom.getBounds(i), s = 1 == e ? -1 * n.width : n.width;
            this.$.swipeableComponents.addStyles("top: " + o.top + "px; left: " + s + "px; height: " + n.height + "px; width: " + n.width + "px;");
        }
    },
    calcNewDragPosition: function(t) {
        var e = this.$.swipeableComponents.getBounds(), i = e.left, o = this.$.swipeableComponents.getBounds(), n = 1 == this.swipeDirection ? 0 : -1 * o.width, s = 1 == this.swipeDirection ? i + t > n ? n : i + t : n > i + t ? n : i + t;
        return s;
    },
    dragSwipeableComponents: function(t) {
        this.$.swipeableComponents.applyStyle("left", t + "px");
    },
    startSwipe: function(t) {
        t.index = this.swipeIndex, this.positionSwipeableContainer(this.swipeIndex, t.xDirection), 
        this.$.swipeableComponents.setShowing(!0), this.setPersistentItemOrigin(t.xDirection), 
        this.doSetupSwipeItem(t);
    },
    dragPersistentItem: function(t) {
        var e = 0, i = "right" == this.persistentItemOrigin ? Math.max(e, e + t.dx) : Math.min(e, e + t.dx);
        this.$.swipeableComponents.applyStyle("left", i + "px");
    },
    dragFinishPersistentItem: function(t) {
        var e = this.calcPercentageDragged(t.dx) > .2, i = t.dx > 0 ? "right" : 0 > t.dx ? "left" : null;
        this.persistentItemOrigin == i ? e ? this.slideAwayItem() : this.bounceItem(t) : this.bounceItem(t);
    },
    setPersistentItemOrigin: function(t) {
        this.persistentItemOrigin = 1 == t ? "left" : "right";
    },
    calcPercentageDragged: function(t) {
        return Math.abs(t / this.$.swipeableComponents.getBounds().width);
    },
    swipe: function(t) {
        this.swipeComplete = !0, this.animateSwipe(0, t);
    },
    backOutSwipe: function() {
        var t = this.$.swipeableComponents.getBounds(), e = 1 == this.swipeDirection ? -1 * t.width : t.width;
        this.animateSwipe(e, this.fastSwipeSpeedMS), this.swipeDirection = null;
    },
    bounceItem: function() {
        var t = this.$.swipeableComponents.getBounds();
        t.left != t.width && this.animateSwipe(0, this.normalSwipeSpeedMS);
    },
    slideAwayItem: function() {
        var t = this.$.swipeableComponents, e = t.getBounds().width, i = "left" == this.persistentItemOrigin ? -1 * e : e;
        this.animateSwipe(i, this.normalSwipeSpeedMS), this.persistentItemVisible = !1, 
        this.setPersistSwipeableItem(!1);
    },
    clearSwipeables: function() {
        this.$.swipeableComponents.setShowing(!1), this.persistentItemVisible = !1, this.setPersistSwipeableItem(!1);
    },
    completeSwipe: function() {
        this.completeSwipeTimeout && (clearTimeout(this.completeSwipeTimeout), this.completeSwipeTimeout = null), 
        this.getPersistSwipeableItem() ? this.swipeComplete && (this.persistentItemVisible = !0) : (this.$.swipeableComponents.setShowing(!1), 
        this.swipeComplete && this.doSwipeComplete({
            index: this.swipeIndex,
            xDirection: this.swipeDirection
        })), this.swipeIndex = null, this.swipeDirection = null;
    },
    animateSwipe: function(t, e) {
        var i = enyo.now(), o = this.$.swipeableComponents, n = parseInt(o.domStyles.left, 10), s = t - n;
        this.stopAnimateSwipe();
        var r = this.bindSafely(function() {
            var t = enyo.now() - i, h = t / e, a = n + s * Math.min(h, 1);
            o.applyStyle("left", a + "px"), this.job = enyo.requestAnimationFrame(r), t / e >= 1 && (this.stopAnimateSwipe(), 
            this.completeSwipeTimeout = setTimeout(this.bindSafely(function() {
                this.completeSwipe();
            }), this.completeSwipeDelayMS));
        });
        this.job = enyo.requestAnimationFrame(r);
    },
    stopAnimateSwipe: function() {
        this.job && (this.job = enyo.cancelRequestAnimationFrame(this.job));
    }
});

// lib/layout/list/source/PulldownList.js
enyo.kind({
    name: "enyo.PulldownList",
    kind: "List",
    touch: !0,
    pully: null,
    pulldownTools: [ {
        name: "pulldown",
        classes: "enyo-list-pulldown",
        components: [ {
            name: "puller",
            kind: "Puller"
        } ]
    } ],
    events: {
        onPullStart: "",
        onPullCancel: "",
        onPull: "",
        onPullRelease: "",
        onPullComplete: ""
    },
    handlers: {
        onScrollStart: "scrollStartHandler",
        onScrollStop: "scrollStopHandler",
        ondragfinish: "dragfinish"
    },
    pullingMessage: "Pull down to refresh...",
    pulledMessage: "Release to refresh...",
    loadingMessage: "Loading...",
    pullingIconClass: "enyo-puller-arrow enyo-puller-arrow-down",
    pulledIconClass: "enyo-puller-arrow enyo-puller-arrow-up",
    loadingIconClass: "",
    create: enyo.inherit(function(t) {
        return function() {
            var e = {
                kind: "Puller",
                showing: !1,
                text: this.loadingMessage,
                iconClass: this.loadingIconClass,
                onCreate: "setPully"
            };
            this.listTools.splice(0, 0, e), t.apply(this, arguments), this.setPulling();
        };
    }),
    initComponents: enyo.inherit(function(t) {
        return function() {
            this.createChrome(this.pulldownTools), this.accel = enyo.dom.canAccelerate(), this.translation = this.accel ? "translate3d" : "translate", 
            this.strategyKind = this.resetStrategyKind(), t.apply(this, arguments);
        };
    }),
    resetStrategyKind: function() {
        return enyo.platform.android >= 3 ? "TranslateScrollStrategy" : "TouchScrollStrategy";
    },
    setPully: function(t, e) {
        this.pully = e.originator;
    },
    scrollStartHandler: function() {
        this.firedPullStart = !1, this.firedPull = !1, this.firedPullCancel = !1;
    },
    scroll: enyo.inherit(function(t) {
        return function() {
            var e = t.apply(this, arguments);
            this.completingPull && this.pully.setShowing(!1);
            var i = this.getStrategy().$.scrollMath || this.getStrategy(), o = -1 * this.getScrollTop();
            return i.isInOverScroll() && o > 0 && (enyo.dom.transformValue(this.$.pulldown, this.translation, "0," + o + "px" + (this.accel ? ",0" : "")), 
            this.firedPullStart || (this.firedPullStart = !0, this.pullStart(), this.pullHeight = this.$.pulldown.getBounds().height), 
            o > this.pullHeight && !this.firedPull && (this.firedPull = !0, this.firedPullCancel = !1, 
            this.pull()), this.firedPull && !this.firedPullCancel && this.pullHeight > o && (this.firedPullCancel = !0, 
            this.firedPull = !1, this.pullCancel())), e;
        };
    }),
    scrollStopHandler: function() {
        this.completingPull && (this.completingPull = !1, this.doPullComplete());
    },
    dragfinish: function() {
        if (this.firedPull) {
            var t = this.getStrategy().$.scrollMath || this.getStrategy();
            t.setScrollY(-1 * this.getScrollTop() - this.pullHeight), this.pullRelease();
        }
    },
    completePull: function() {
        this.completingPull = !0;
        var t = this.getStrategy().$.scrollMath || this.getStrategy();
        t.setScrollY(this.pullHeight), t.start();
    },
    pullStart: function() {
        this.setPulling(), this.pully.setShowing(!1), this.$.puller.setShowing(!0), this.doPullStart();
    },
    pull: function() {
        this.setPulled(), this.doPull();
    },
    pullCancel: function() {
        this.setPulling(), this.doPullCancel();
    },
    pullRelease: function() {
        this.$.puller.setShowing(!1), this.pully.setShowing(!0), this.doPullRelease();
    },
    setPulling: function() {
        this.$.puller.setText(this.pullingMessage), this.$.puller.setIconClass(this.pullingIconClass);
    },
    setPulled: function() {
        this.$.puller.setText(this.pulledMessage), this.$.puller.setIconClass(this.pulledIconClass);
    }
}), enyo.kind({
    name: "enyo.Puller",
    classes: "enyo-puller",
    published: {
        text: "",
        iconClass: ""
    },
    events: {
        onCreate: ""
    },
    components: [ {
        name: "icon"
    }, {
        name: "text",
        tag: "span",
        classes: "enyo-puller-text"
    } ],
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.doCreate(), this.textChanged(), this.iconClassChanged();
        };
    }),
    textChanged: function() {
        this.$.text.setContent(this.text);
    },
    iconClassChanged: function() {
        this.$.icon.setClasses(this.iconClass);
    }
});

// lib/layout/list/source/AroundList.js
enyo.kind({
    name: "enyo.AroundList",
    kind: "enyo.List",
    listTools: [ {
        name: "port",
        classes: "enyo-list-port enyo-border-box",
        components: [ {
            name: "aboveClient"
        }, {
            name: "generator",
            kind: "FlyweightRepeater",
            canGenerate: !1,
            components: [ {
                tag: null,
                name: "client"
            } ]
        }, {
            name: "holdingarea",
            allowHtml: !0,
            classes: "enyo-list-holdingarea"
        }, {
            name: "page0",
            allowHtml: !0,
            classes: "enyo-list-page"
        }, {
            name: "page1",
            allowHtml: !0,
            classes: "enyo-list-page"
        }, {
            name: "belowClient"
        }, {
            name: "placeholder"
        }, {
            name: "swipeableComponents",
            style: "position:absolute; display:block; top:-1000px; left:0px;"
        } ]
    } ],
    aboveComponents: null,
    initComponents: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.aboveComponents && this.$.aboveClient.createComponents(this.aboveComponents, {
                owner: this.owner
            }), this.belowComponents && this.$.belowClient.createComponents(this.belowComponents, {
                owner: this.owner
            });
        };
    }),
    updateMetrics: function() {
        this.defaultPageSize = this.rowsPerPage * (this.rowSize || 100), this.pageCount = Math.ceil(this.count / this.rowsPerPage), 
        this.aboveHeight = this.$.aboveClient.getBounds().height, this.belowHeight = this.$.belowClient.getBounds().height, 
        this.portSize = this.aboveHeight + this.belowHeight;
        for (var t = 0; this.pageCount > t; t++) this.portSize += this.getPageSize(t);
        this.adjustPortSize();
    },
    positionPage: function(t, e) {
        e.pageNo = t;
        var i = this.pageToPosition(t), o = this.bottomUp ? this.belowHeight : this.aboveHeight;
        i += o, e.applyStyle(this.pageBound, i + "px");
    },
    scrollToContentStart: function() {
        var t = this.bottomUp ? this.belowHeight : this.aboveHeight;
        this.setScrollPosition(t);
    }
});

// lib/layout/list/source/GridFlyweightRepeater.js
enyo.kind({
    name: "enyo.GridFlyWeightRepeater",
    kind: "enyo.FlyweightRepeater",
    events: {
        onSizeupItem: ""
    },
    itemsPerRow: 0,
    _itemsFromPreviousPage: 0,
    generateChildHtml: function() {
        return this.itemFluidWidth || this.itemFixedSize ? this._generateChildHtmlEqualSizedItems() : this._generateChildHtmlVariableSizedItems();
    },
    _generateChildHtmlEqualSizedItems: function() {
        var t = this.owner.hasNode().clientWidth, e = this.$.client, i = "", o = 0, n = this.itemWidth, s = this.itemHeight;
        if (this.itemFluidWidth) {
            o = 100 / this.itemsPerRow;
            var r = 0;
            this.itemSpacing >= 0 && (r = (this.itemsPerRow + 1) * this.itemSpacing, o = 100 / this.itemsPerRow - 100 * r / (this.itemsPerRow * t)), 
            n = o / 100 * t, s = n * (this.itemHeight / this.itemWidth);
        }
        for (var h = this.rowOffset; this.rowOffset + this.count > h; h++) e.setAttribute("data-enyo-index", h), 
        this.doSetupItem({
            index: h,
            selected: this.isSelected(h)
        }), this.itemFluidWidth ? e.addStyles("width:" + o + "%;height:" + s + "px;") : e.addStyles("width:" + this.itemWidth + "px;height:" + this.itemHeight + "px;"), 
        this.itemSpacing >= 0 && (e.addStyles("margin-top:" + this.itemSpacing + "px; margin-left:" + this.itemSpacing + "px;"), 
        h % this.itemsPerRow == this.itemsPerRow - 1 ? e.addStyles("margin-right:" + this.itemSpacing + "px;") : e.addStyles("margin-right: 0px;"), 
        h >= this.count - this.itemsPerRow && e.addStyles("margin-bottom:" + this.itemSpacing + "px;")), 
        i += e.generateHtml(), e.teardownRender();
        return i;
    },
    _generateChildHtmlVariableSizedItems: function() {
        this.index = null;
        var t, e, i = null, o = this.$.client, n = this.owner.hasNode().clientWidth, s = 0, r = 0, h = 0, a = 0, l = 0, d = 0, g = 0, p = 0, c = 0, u = this.itemMinWidth / this.itemMinHeight, f = [ {
            index: 0,
            items: []
        } ], m = this.owner.$._dummy_.hasNode();
        0 === this.owner.page && (this._itemsFromPreviousPage = 0);
        var w = this.count + this._itemsFromPreviousPage;
        for (t = 0, e = t + this.rowOffset - this._itemsFromPreviousPage; w > t; t++, e++) {
            p = 0, c = 0, this.doSizeupItem({
                index: e,
                selected: this.isSelected(e)
            }), p = this.itemWidth, c = this.itemHeight, (!p || 0 >= p) && (this.doSetupItem({
                index: e,
                selected: this.isSelected(e)
            }), m.innerHTML = o.generateChildHtml(), p = m.clientWidth, c = m.clientHeight), 
            (!p || 0 >= p) && (p = this.itemMinWidth, c = this.itemMinHeight), (!c || 0 >= c) && (c = this.itemMinHeight), 
            u = p / c, s = Math.min(p, n), this.itemMinWidth && this.itemMinWidth > 0 && (s = Math.max(p, this.itemMinWidth));
            var S = t == w - 1;
            if (h = s / u, r += s, a += h, i = {
                index: e,
                pageIndex: t,
                width: s,
                height: h
            }, f[g].items.push(i), this.normalizeRows && (l = r / f[g].items.length, d = a / f[g].items.length, 
            r >= n || S)) {
                f[g].avgHeight = d, f[g].index = g;
                var y = f[g].items.length, P = (n - r) / y;
                if (this._itemsFromPreviousPage = 0, S && P + l > 1.5 * l) {
                    this._itemsFromPreviousPage = y, f[g] = {
                        avgHeight: 0,
                        index: g,
                        items: []
                    };
                    break;
                }
                this._normalizeRow(f[g]), S || (g++, f[g] = {
                    avgHeight: 0,
                    index: 0,
                    items: []
                }), r = a = d = l = s = h = p = c = 0;
            }
        }
        m.innerHTML = "";
        var R, C = "", v = "";
        for (t = 0; f.length > t; t++) if (R = f[t], R.items && 0 !== R.items.length) for (var b = 0; R.items.length > b; b++) i = R.items[b], 
        this.doSetupItem({
            index: i.index,
            selected: this.isSelected(i.index)
        }), o.setAttribute("data-enyo-index", i.index), o.addStyles("width:" + i.width + "px;height:" + i.height + "px;"), 
        this.itemSpacing >= 0 && o.addStyles("margin-top:" + this.itemSpacing + "px;margin-left:" + this.itemSpacing + "px;"), 
        v = o.generateHtml(), o.teardownRender(), C += v;
        return C;
    },
    _normalizeRow: function(t) {
        if (this.normalizeRows && t.items && 0 !== t.items.length) {
            var e, i, o = this.owner.hasNode().clientWidth, n = 0, s = 0, r = "", h = 0, a = 0, l = 0, d = 0;
            for (i = 0; t.items.length > i; i++) e = t.items[i], h = e.width, a = e.height, 
            s = Math.floor(t.avgHeight / a * h), r += " " + s, e.width = s, e.height = t.avgHeight, 
            n += s, this.itemSpacing >= 0 && (n += this.itemSpacing, i == t.items.length - 1 && (n += this.itemSpacing));
            for (d = o - n, l = o / (o - d), n = 0, s = 0, r = "", i = 0; t.items.length > i; i++) {
                e = t.items[i], h = e.width, a = e.height, s = Math.floor(h * l), r += " " + s;
                var g = Math.floor(a * l);
                e.width = s, e.height = g, n += s, this.itemSpacing >= 0 && (n += this.itemSpacing, 
                i == t.items.length - 1 && (n += this.itemSpacing));
            }
            d = o - n, e = t.items[t.items.length - 1], h = e.width, a = e.height, e.width = h + d, 
            e.height = a;
        }
    }
});

// lib/layout/list/source/GridList.js
enyo.kind({
    name: "enyo.GridList",
    kind: "enyo.List",
    classes: "enyo-gridlist",
    published: {
        itemFluidWidth: !1,
        itemFixedSize: !1,
        itemMinWidth: 160,
        itemMinHeight: 160,
        itemWidth: 160,
        itemHeight: 160,
        itemSpacing: 0,
        normalizeRows: !1
    },
    horizontal: "hidden",
    events: {
        onSizeupItem: ""
    },
    show: function(t) {
        this._calculateItemsPerRow(), this.setCount(t), this.reset();
    },
    create: enyo.inherit(function(t) {
        return function() {
            this._setComponents(), t.apply(this, arguments), this.itemFluidWidthChanged(), this.itemFixedSizeChanged(), 
            this.itemMinWidthChanged(), this.itemMinHeightChanged(), this.itemWidthChanged(), 
            this.itemHeightChanged(), this.itemSpacingChanged(), this.normalizeRowsChanged(), 
            this.$.generator.setClientClasses("enyo-gridlist-row");
        };
    }),
    itemFluidWidthChanged: function() {
        this.$.generator.itemFluidWidth = this.itemFluidWidth, this.setNormalizeRows(!this.itemFluidWidth && !this.itemFixedSize);
    },
    itemFixedSizeChanged: function() {
        this.$.generator.itemFixedSize = this.itemFixedSize, this.setNormalizeRows(!this.itemFluidWidth && !this.itemFixedSize);
    },
    itemWidthChanged: function() {
        this.$.generator.itemWidth = this.itemWidth;
    },
    itemHeightChanged: function() {
        this.$.generator.itemHeight = this.itemHeight;
    },
    itemMinWidthChanged: function() {
        var t = this.hasNode();
        t && (this.itemMinWidth || (this.itemMinWidth = 160), this.itemMinWidth = Math.min(this.itemMinWidth, t.clientWidth)), 
        this.$.generator.itemMinWidth = this.itemMinWidth;
    },
    itemMinHeightChanged: function() {
        var t = this.hasNode();
        t && (this.itemMinHeight || (this.itemMinHeight = 160), this.itemMinHeight = Math.min(this.itemMinHeight, t.clientHeight)), 
        this.$.generator.itemMinHeight = this.itemMinHeight;
    },
    itemSpacingChanged: function() {
        0 > this.itemSpacing && (this.itemSpacing = 0), this.itemSpacing = this.itemSpacing, 
        this.$.generator.itemSpacing = this.itemSpacing;
    },
    normalizeRowsChanged: function() {
        this.$.generator.normalizeRows = this.normalizeRows;
    },
    bottomUpChanged: function() {
        this.bottomUp = !1, this.pageBound = "top";
    },
    reflow: enyo.inherit(function(t) {
        return function() {
            this._calculateItemsPerRow(), t.apply(this, arguments);
        };
    }),
    _calculateItemsPerRow: function() {
        var t = this.hasNode();
        if (t) {
            this.itemsPerRow = Math.floor((t.clientWidth - this.itemSpacing) / (this.itemMinWidth + this.itemSpacing));
            var e = Math.round((t.clientHeight - this.itemSpacing) / (this.itemMinHeight + this.itemSpacing));
            if (this.itemFixedSize || this.itemFluidWidth) {
                var i = Math.floor((t.clientWidth - this.itemSpacing) / (this.itemWidth + this.itemSpacing)), o = Math.floor(i), n = Math.ceil(i), s = t.clientWidth - this.itemSpacing - n * (this.itemWidth + this.itemSpacing);
                this.itemsPerRow = s > 0 ? n : o, e = Math.round((t.clientHeight - this.itemSpacing) / (this.itemHeight + this.itemSpacing));
            }
            this.itemsPerRow = Math.max(1, this.itemsPerRow), this.rowsPerPage = 3 * this.itemsPerRow * e, 
            this.$.generator.itemsPerRow = this.itemsPerRow;
        }
    },
    _setComponents: function() {
        this.listTools = enyo.clone(this.listTools), this.listTools[0] = enyo.clone(this.listTools[0]), 
        this.listTools[0].components = enyo.clone(this.listTools[0].components);
        var t = this.listTools[0].components;
        this.createComponent(new enyo.Component({
            name: "_dummy_",
            allowHtml: !0,
            classes: "enyo-gridlist-dummy",
            showing: !1
        }, {
            owner: this
        }));
        for (var e = 0; t.length > e; e++) if ("generator" == t[e].name) return t[e] = enyo.clone(t[e]), 
        t[e].kind = "enyo.GridFlyWeightRepeater", void 0;
    }
});

// lib/layout/list/source/GridListImageItem.js
enyo.kind({
    name: "enyo.GridListImageItem",
    classes: "enyo-gridlist-imageitem",
    components: [ {
        name: "image",
        kind: "enyo.Image"
    }, {
        name: "caption",
        classes: "caption"
    }, {
        name: "subCaption",
        classes: "sub-caption"
    } ],
    published: {
        source: "",
        caption: "",
        subCaption: "",
        selected: !1
    },
    bindings: [ {
        from: ".source",
        to: ".$.image.src"
    }, {
        from: ".caption",
        to: ".$.caption.content"
    }, {
        from: ".caption",
        to: ".$.caption.showing",
        kind: "enyo.EmptyBinding"
    }, {
        from: ".subCaption",
        to: ".$.subCaption.content"
    }, {
        from: ".subCaption",
        to: ".$.subCaption.showing",
        kind: "enyo.EmptyBinding"
    } ],
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.selectedChanged();
        };
    }),
    selectedChanged: function() {
        this.addRemoveClass("selected", this.selected);
    },
    disabledChanged: function() {
        this.addRemoveClass("disabled", this.disabled);
    }
});

// lib/layout/slideable/source/Slideable.js
enyo.kind({
    name: "enyo.Slideable",
    kind: "Control",
    published: {
        axis: "h",
        value: 0,
        unit: "px",
        min: 0,
        max: 0,
        accelerated: "auto",
        overMoving: !0,
        draggable: !0
    },
    events: {
        onAnimateFinish: "",
        onChange: ""
    },
    preventDragPropagation: !1,
    tools: [ {
        kind: "Animator",
        onStep: "animatorStep",
        onEnd: "animatorComplete"
    } ],
    handlers: {
        ondragstart: "dragstart",
        ondrag: "drag",
        ondragfinish: "dragfinish"
    },
    kDragScalar: 1,
    dragEventProp: "dx",
    unitModifier: !1,
    canTransform: !1,
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.acceleratedChanged(), this.transformChanged(), this.axisChanged(), 
            this.valueChanged(), this.addClass("enyo-slideable");
        };
    }),
    initComponents: enyo.inherit(function(t) {
        return function() {
            this.createComponents(this.tools), t.apply(this, arguments);
        };
    }),
    rendered: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.canModifyUnit(), this.updateDragScalar();
        };
    }),
    resizeHandler: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.updateDragScalar();
        };
    }),
    canModifyUnit: function() {
        if (!this.canTransform) {
            var t = this.getInitialStyleValue(this.hasNode(), this.boundary);
            t.match(/px/i) && "%" === this.unit && (this.unitModifier = this.getBounds()[this.dimension]);
        }
    },
    getInitialStyleValue: function(t, e) {
        var i = enyo.dom.getComputedStyle(t);
        return i ? i.getPropertyValue(e) : t && t.currentStyle ? t.currentStyle[e] : "0";
    },
    updateBounds: function(t, e) {
        var i = {};
        i[this.boundary] = t, this.setBounds(i, this.unit), this.setInlineStyles(t, e);
    },
    updateDragScalar: function() {
        if ("%" == this.unit) {
            var t = this.getBounds()[this.dimension];
            this.kDragScalar = t ? 100 / t : 1, this.canTransform || this.updateBounds(this.value, 100);
        }
    },
    transformChanged: function() {
        this.canTransform = enyo.dom.canTransform();
    },
    acceleratedChanged: function() {
        (!enyo.platform.android || 2 >= enyo.platform.android) && enyo.dom.accelerate(this, this.accelerated);
    },
    axisChanged: function() {
        var t = "h" == this.axis;
        this.dragMoveProp = t ? "dx" : "dy", this.shouldDragProp = t ? "horizontal" : "vertical", 
        this.transform = t ? "translateX" : "translateY", this.dimension = t ? "width" : "height", 
        this.boundary = t ? "left" : "top";
    },
    setInlineStyles: function(t, e) {
        var i = {};
        this.unitModifier ? (i[this.boundary] = this.percentToPixels(t, this.unitModifier), 
        i[this.dimension] = this.unitModifier, this.setBounds(i)) : (e ? i[this.dimension] = e : i[this.boundary] = t, 
        this.setBounds(i, this.unit));
    },
    valueChanged: function(t) {
        var e = this.value;
        this.isOob(e) && !this.isAnimating() && (this.value = this.overMoving ? this.dampValue(e) : this.clampValue(e)), 
        enyo.platform.android > 2 && (this.value ? (0 === t || void 0 === t) && enyo.dom.accelerate(this, this.accelerated) : enyo.dom.accelerate(this, !1)), 
        this.canTransform ? enyo.dom.transformValue(this, this.transform, this.value + this.unit) : this.setInlineStyles(this.value, !1), 
        this.doChange();
    },
    getAnimator: function() {
        return this.$.animator;
    },
    isAtMin: function() {
        return this.value <= this.calcMin();
    },
    isAtMax: function() {
        return this.value >= this.calcMax();
    },
    calcMin: function() {
        return this.min;
    },
    calcMax: function() {
        return this.max;
    },
    clampValue: function(t) {
        var e = this.calcMin(), i = this.calcMax();
        return Math.max(e, Math.min(t, i));
    },
    dampValue: function(t) {
        return this.dampBound(this.dampBound(t, this.min, 1), this.max, -1);
    },
    dampBound: function(t, e, i) {
        var o = t;
        return e * i > o * i && (o = e + (o - e) / 4), o;
    },
    percentToPixels: function(t, e) {
        return Math.floor(e / 100 * t);
    },
    pixelsToPercent: function(t) {
        var e = this.unitModifier ? this.getBounds()[this.dimension] : this.container.getBounds()[this.dimension];
        return 100 * (t / e);
    },
    shouldDrag: function(t) {
        return this.draggable && t[this.shouldDragProp];
    },
    isOob: function(t) {
        return t > this.calcMax() || this.calcMin() > t;
    },
    dragstart: function(t, e) {
        return this.shouldDrag(e) ? (e.preventDefault(), this.$.animator.stop(), e.dragInfo = {}, 
        this.dragging = !0, this.drag0 = this.value, this.dragd0 = 0, this.preventDragPropagation) : void 0;
    },
    drag: function(t, e) {
        if (this.dragging) {
            e.preventDefault();
            var i = this.canTransform ? e[this.dragMoveProp] * this.kDragScalar : this.pixelsToPercent(e[this.dragMoveProp]), o = this.drag0 + i, n = i - this.dragd0;
            return this.dragd0 = i, n && (e.dragInfo.minimizing = 0 > n), this.setValue(o), 
            this.preventDragPropagation;
        }
    },
    dragfinish: function(t, e) {
        return this.dragging ? (this.dragging = !1, this.completeDrag(e), e.preventTap(), 
        this.preventDragPropagation) : void 0;
    },
    completeDrag: function(t) {
        this.value !== this.calcMax() && this.value != this.calcMin() && this.animateToMinMax(t.dragInfo.minimizing);
    },
    isAnimating: function() {
        return this.$.animator.isAnimating();
    },
    play: function(t, e) {
        this.$.animator.play({
            startValue: t,
            endValue: e,
            node: this.hasNode()
        });
    },
    animateTo: function(t) {
        this.play(this.value, t);
    },
    animateToMin: function() {
        this.animateTo(this.calcMin());
    },
    animateToMax: function() {
        this.animateTo(this.calcMax());
    },
    animateToMinMax: function(t) {
        t ? this.animateToMin() : this.animateToMax();
    },
    animatorStep: function(t) {
        return this.setValue(t.value), !0;
    },
    animatorComplete: function(t) {
        return this.doAnimateFinish(t), !0;
    },
    toggleMinMax: function() {
        this.animateToMinMax(!this.isAtMin());
    }
});

// lib/layout/panels/source/arrangers/Arranger.js
enyo.kind({
    name: "enyo.Arranger",
    kind: "Layout",
    layoutClass: "enyo-arranger",
    accelerated: "auto",
    dragProp: "ddx",
    dragDirectionProp: "xDirection",
    canDragProp: "horizontal",
    incrementalPoints: !1,
    destroy: enyo.inherit(function(t) {
        return function() {
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) e._arranger = null;
            t.apply(this, arguments);
        };
    }),
    arrange: function() {},
    size: function() {},
    start: function() {
        var t = this.container.fromIndex, e = this.container.toIndex, i = this.container.transitionPoints = [ t ];
        if (this.incrementalPoints) for (var n = Math.abs(e - t) - 2, o = t; n >= 0; ) o += t > e ? -1 : 1, 
        i.push(o), n--;
        i.push(this.container.toIndex);
    },
    finish: function() {},
    calcArrangementDifference: function() {},
    canDragEvent: function(t) {
        return t[this.canDragProp];
    },
    calcDragDirection: function(t) {
        return t[this.dragDirectionProp];
    },
    calcDrag: function(t) {
        return t[this.dragProp];
    },
    drag: function(t, e, i, n, o) {
        var s = this.measureArrangementDelta(-t, e, i, n, o);
        return s;
    },
    measureArrangementDelta: function(t, e, i, n, o) {
        var s = this.calcArrangementDifference(e, i, n, o), r = s ? t / Math.abs(s) : 0;
        return r *= this.container.fromIndex > this.container.toIndex ? -1 : 1;
    },
    _arrange: function(t) {
        this.containerBounds || this.reflow();
        var e = this.getOrderedControls(t);
        this.arrange(e, t);
    },
    arrangeControl: function(t, e) {
        t._arranger = enyo.mixin(t._arranger || {}, e);
    },
    flow: function() {
        this.c$ = [].concat(this.container.getPanels()), this.controlsIndex = 0;
        for (var t, e = 0, i = this.container.getPanels(); t = i[e]; e++) if (enyo.dom.accelerate(t, !t.preventAccelerate && this.accelerated), 
        enyo.platform.safari) for (var n, o = t.children, s = 0; n = o[s]; s++) enyo.dom.accelerate(n, this.accelerated);
    },
    reflow: function() {
        var t = this.container.hasNode();
        this.containerBounds = t ? {
            width: t.clientWidth,
            height: t.clientHeight
        } : {}, this.size();
    },
    flowArrangement: function() {
        var t = this.container.arrangement;
        if (t) for (var e, i = 0, n = this.container.getPanels(); (e = n[i]) && t[i]; i++) this.flowControl(e, t[i]);
    },
    flowControl: function(t, e) {
        enyo.Arranger.positionControl(t, e);
        var i = e.opacity;
        null != i && enyo.Arranger.opacifyControl(t, i);
    },
    getOrderedControls: function(t) {
        for (var e = Math.floor(t), i = e - this.controlsIndex, n = i > 0, o = this.c$ || [], s = 0; Math.abs(i) > s; s++) n ? o.push(o.shift()) : o.unshift(o.pop());
        return this.controlsIndex = e, o;
    },
    statics: {
        positionControl: function(t, e, i) {
            var n = i || "px";
            if (!this.updating) if (!enyo.dom.canTransform() || t.preventTransform || enyo.platform.android || 10 === enyo.platform.ie) enyo.dom.canTransform() && t.preventTransform && enyo.dom.transform(t, {
                translateX: null,
                translateY: null
            }), t.setBounds(e, i); else {
                var o = e.left, s = e.top;
                o = enyo.isString(o) ? o : o && o + n, s = enyo.isString(s) ? s : s && s + n, enyo.dom.transform(t, {
                    translateX: o || null,
                    translateY: s || null
                });
            }
        },
        opacifyControl: function(t, e) {
            var i = e;
            i = i > .99 ? 1 : .01 > i ? 0 : i, 9 > enyo.platform.ie ? t.applyStyle("filter", "progid:DXImageTransform.Microsoft.Alpha(Opacity=" + 100 * i + ")") : t.applyStyle("opacity", i);
        }
    }
});

// lib/layout/panels/source/arrangers/CardArranger.js
enyo.kind({
    name: "enyo.CardArranger",
    kind: "Arranger",
    layoutClass: "enyo-arranger enyo-arranger-fit",
    calcArrangementDifference: function() {
        return this.containerBounds.width;
    },
    arrange: function(t) {
        for (var e, i, n = 0; e = t[n]; n++) i = 0 === n ? 1 : 0, this.arrangeControl(e, {
            opacity: i
        });
    },
    start: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments);
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) {
                var o = e.showing;
                e.setShowing(n == this.container.fromIndex || n == this.container.toIndex), e.showing && !o && e.resized();
            }
        };
    }),
    finish: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments);
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) e.setShowing(n == this.container.toIndex);
        };
    }),
    destroy: enyo.inherit(function(t) {
        return function() {
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) enyo.Arranger.opacifyControl(e, 1), 
            e.showing || e.setShowing(!0);
            t.apply(this, arguments);
        };
    })
});

// lib/layout/panels/source/arrangers/CardSlideInArranger.js
enyo.kind({
    name: "enyo.CardSlideInArranger",
    kind: "CardArranger",
    start: function() {
        for (var t, e = this.container.getPanels(), i = 0; t = e[i]; i++) {
            var n = t.showing;
            t.setShowing(i == this.container.fromIndex || i == this.container.toIndex), t.showing && !n && t.resized();
        }
        var o = this.container.fromIndex;
        i = this.container.toIndex, this.container.transitionPoints = [ i + "." + o + ".s", i + "." + o + ".f" ];
    },
    finish: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments);
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) e.setShowing(n == this.container.toIndex);
        };
    }),
    arrange: function(t, e) {
        for (var i, n, o = e.split("."), s = o[0], r = o[1], a = "s" == o[2], h = this.containerBounds.width, l = 0, d = this.container.getPanels(); i = d[l]; l++) n = h, 
        r == l && (n = a ? 0 : -h), s == l && (n = a ? h : 0), r == l && r == s && (n = 0), 
        this.arrangeControl(i, {
            left: n
        });
    },
    destroy: enyo.inherit(function(t) {
        return function() {
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) enyo.Arranger.positionControl(e, {
                left: null
            });
            t.apply(this, arguments);
        };
    })
});

// lib/layout/panels/source/arrangers/CarouselArranger.js
enyo.kind({
    name: "enyo.CarouselArranger",
    kind: "Arranger",
    size: function() {
        var t, e, i, n, o, s = this.container.getPanels(), r = this.containerPadding = this.container.hasNode() ? enyo.dom.calcPaddingExtents(this.container.node) : {}, a = this.containerBounds;
        a.height -= r.top + r.bottom, a.width -= r.left + r.right;
        var h;
        for (t = 0, i = 0; o = s[t]; t++) n = enyo.dom.calcMarginExtents(o.hasNode()), o.width = o.getBounds().width, 
        o.marginWidth = n.right + n.left, i += (o.fit ? 0 : o.width) + o.marginWidth, o.fit && (h = o);
        if (h) {
            var l = a.width - i;
            h.width = l >= 0 ? l : h.width;
        }
        for (t = 0, e = r.left; o = s[t]; t++) o.setBounds({
            top: r.top,
            bottom: r.bottom,
            width: o.fit ? o.width : null
        });
    },
    arrange: function(t, e) {
        this.container.wrap ? this.arrangeWrap(t, e) : this.arrangeNoWrap(t, e);
    },
    arrangeNoWrap: function(t, e) {
        var i, n, o, s, r = this.container.getPanels(), a = this.container.clamp(e), h = this.containerBounds.width;
        for (i = a, o = 0; (s = r[i]) && (o += s.width + s.marginWidth, !(o > h)); i++) ;
        var l = h - o, d = 0;
        if (l > 0) for (i = a - 1, n = 0; s = r[i]; i--) if (n += s.width + s.marginWidth, 
        0 >= l - n) {
            d = l - n, a = i;
            break;
        }
        var c, g;
        for (i = 0, g = this.containerPadding.left + d; s = r[i]; i++) c = s.width + s.marginWidth, 
        a > i ? this.arrangeControl(s, {
            left: -c
        }) : (this.arrangeControl(s, {
            left: Math.floor(g)
        }), g += c);
    },
    arrangeWrap: function(t) {
        for (var e, i = 0, n = this.containerPadding.left; e = t[i]; i++) this.arrangeControl(e, {
            left: n
        }), n += e.width + e.marginWidth;
    },
    calcArrangementDifference: function(t, e, i, n) {
        var o = Math.abs(t % this.c$.length);
        return e[o].left - n[o].left;
    },
    destroy: enyo.inherit(function(t) {
        return function() {
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) enyo.Arranger.positionControl(e, {
                left: null,
                top: null
            }), e.applyStyle("top", null), e.applyStyle("bottom", null), e.applyStyle("left", null), 
            e.applyStyle("width", null);
            t.apply(this, arguments);
        };
    })
});

// lib/layout/panels/source/arrangers/CollapsingArranger.js
enyo.kind({
    name: "enyo.CollapsingArranger",
    kind: "CarouselArranger",
    peekWidth: 0,
    size: enyo.inherit(function(t) {
        return function() {
            this.clearLastSize(), t.apply(this, arguments);
        };
    }),
    clearLastSize: function() {
        for (var t, e = 0, i = this.container.getPanels(); t = i[e]; e++) t._fit && e != i.length - 1 && (t.applyStyle("width", null), 
        t._fit = null);
    },
    constructor: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.peekWidth = null != this.container.peekWidth ? this.container.peekWidth : this.peekWidth;
        };
    }),
    arrange: function(t, e) {
        for (var i, n = this.container.getPanels(), o = 0, s = this.containerPadding.left, r = 0; i = n[o]; o++) i.getShowing() ? (this.arrangeControl(i, {
            left: s + r * this.peekWidth
        }), o >= e && (s += i.width + i.marginWidth - this.peekWidth), r++) : (this.arrangeControl(i, {
            left: s
        }), o >= e && (s += i.width + i.marginWidth)), o == n.length - 1 && 0 > e && this.arrangeControl(i, {
            left: s - e
        });
    },
    calcArrangementDifference: function(t, e, i, n) {
        var o = this.container.getPanels().length - 1;
        return Math.abs(n[o].left - e[o].left);
    },
    flowControl: enyo.inherit(function(t) {
        return function(e, i) {
            if (t.apply(this, arguments), this.container.realtimeFit) {
                var n = this.container.getPanels(), o = n.length - 1, s = n[o];
                e == s && this.fitControl(e, i.left);
            }
        };
    }),
    finish: enyo.inherit(function(t) {
        return function() {
            if (t.apply(this, arguments), !this.container.realtimeFit && this.containerBounds) {
                var e = this.container.getPanels(), i = this.container.arrangement, n = e.length - 1, o = e[n];
                this.fitControl(o, i[n].left);
            }
        };
    }),
    fitControl: function(t, e) {
        t._fit = !0, t.applyStyle("width", this.containerBounds.width - e + "px"), t.resized();
    }
});

// lib/layout/panels/source/arrangers/DockRightArranger.js
enyo.kind({
    name: "enyo.DockRightArranger",
    kind: "Arranger",
    basePanel: !1,
    overlap: 0,
    layoutWidth: 0,
    constructor: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.overlap = null != this.container.overlap ? this.container.overlap : this.overlap, 
            this.layoutWidth = null != this.container.layoutWidth ? this.container.layoutWidth : this.layoutWidth;
        };
    }),
    size: function() {
        var t, e, i, n = this.container.getPanels(), o = this.containerPadding = this.container.hasNode() ? enyo.dom.calcPaddingExtents(this.container.node) : {}, s = this.containerBounds;
        s.width -= o.left + o.right;
        var r, a = s.width, h = n.length;
        for (this.container.transitionPositions = {}, t = 0; i = n[t]; t++) i.width = 0 === t && this.container.basePanel ? a : i.getBounds().width;
        for (t = 0; i = n[t]; t++) {
            0 === t && this.container.basePanel && i.setBounds({
                width: a
            }), i.setBounds({
                top: o.top,
                bottom: o.bottom
            });
            for (var l = 0; i = n[l]; l++) {
                var d;
                if (0 === t && this.container.basePanel) d = 0; else if (t > l) d = a; else {
                    if (t !== l) break;
                    r = a > this.layoutWidth ? this.overlap : 0, d = a - n[t].width + r;
                }
                this.container.transitionPositions[t + "." + l] = d;
            }
            if (h > l) for (var c = !1, g = t + 1; h > g; g++) {
                if (r = 0, c) r = 0; else if (n[t].width + n[g].width - this.overlap > a) r = 0, 
                c = !0; else {
                    for (r = n[t].width - this.overlap, e = t; g > e; e++) {
                        var u = r + n[e + 1].width - this.overlap;
                        if (!(a > u)) {
                            r = a;
                            break;
                        }
                        r = u;
                    }
                    r = a - r;
                }
                this.container.transitionPositions[t + "." + g] = r;
            }
        }
    },
    arrange: function(t, e) {
        var i, n, o = this.container.getPanels(), s = this.container.clamp(e);
        for (i = 0; n = o[i]; i++) {
            var r = this.container.transitionPositions[i + "." + s];
            this.arrangeControl(n, {
                left: r
            });
        }
    },
    calcArrangementDifference: function(t, e, i) {
        var n = this.container.getPanels(), o = i > t ? n[i].width : n[t].width;
        return o;
    },
    destroy: enyo.inherit(function(t) {
        return function() {
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) enyo.Arranger.positionControl(e, {
                left: null,
                top: null
            }), e.applyStyle("top", null), e.applyStyle("bottom", null), e.applyStyle("left", null), 
            e.applyStyle("width", null);
            t.apply(this, arguments);
        };
    })
});

// lib/layout/panels/source/arrangers/OtherArrangers.js
enyo.kind({
    name: "enyo.LeftRightArranger",
    kind: "Arranger",
    margin: 40,
    axisSize: "width",
    offAxisSize: "height",
    axisPosition: "left",
    constructor: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.margin = null != this.container.margin ? this.container.margin : this.margin;
        };
    }),
    size: function() {
        for (var t, e, i = this.container.getPanels(), n = this.containerBounds[this.axisSize], o = n - this.margin - this.margin, s = 0; e = i[s]; s++) t = {}, 
        t[this.axisSize] = o, t[this.offAxisSize] = "100%", e.setBounds(t);
    },
    start: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments);
            for (var e, i = this.container.fromIndex, n = this.container.toIndex, o = this.getOrderedControls(n), s = Math.floor(o.length / 2), r = 0; e = o[r]; r++) i > n ? r == o.length - s ? e.applyStyle("z-index", 0) : e.applyStyle("z-index", 1) : r == o.length - 1 - s ? e.applyStyle("z-index", 0) : e.applyStyle("z-index", 1);
        };
    }),
    arrange: function(t, e) {
        var i, n, o;
        if (1 == this.container.getPanels().length) return o = {}, o[this.axisPosition] = this.margin, 
        this.arrangeControl(this.container.getPanels()[0], o), void 0;
        var s = Math.floor(this.container.getPanels().length / 2), r = this.getOrderedControls(Math.floor(e) - s), a = this.containerBounds[this.axisSize] - this.margin - this.margin, h = this.margin - a * s;
        for (i = 0; n = r[i]; i++) o = {}, o[this.axisPosition] = h, this.arrangeControl(n, o), 
        h += a;
    },
    calcArrangementDifference: function(t, e, i, n) {
        if (1 == this.container.getPanels().length) return 0;
        var o = Math.abs(t % this.c$.length);
        return e[o][this.axisPosition] - n[o][this.axisPosition];
    },
    destroy: enyo.inherit(function(t) {
        return function() {
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) enyo.Arranger.positionControl(e, {
                left: null,
                top: null
            }), enyo.Arranger.opacifyControl(e, 1), e.applyStyle("left", null), e.applyStyle("top", null), 
            e.applyStyle("height", null), e.applyStyle("width", null);
            t.apply(this, arguments);
        };
    })
}), enyo.kind({
    name: "enyo.TopBottomArranger",
    kind: "LeftRightArranger",
    dragProp: "ddy",
    dragDirectionProp: "yDirection",
    canDragProp: "vertical",
    axisSize: "height",
    offAxisSize: "width",
    axisPosition: "top"
}), enyo.kind({
    name: "enyo.SpiralArranger",
    kind: "Arranger",
    incrementalPoints: !0,
    inc: 20,
    size: function() {
        for (var t, e = this.container.getPanels(), i = this.containerBounds, n = this.controlWidth = i.width / 3, o = this.controlHeight = i.height / 3, s = 0; t = e[s]; s++) t.setBounds({
            width: n,
            height: o
        });
    },
    arrange: function(t) {
        for (var e, i = this.inc, n = 0, o = t.length; e = t[n]; n++) {
            var s = Math.cos(2 * (n / o) * Math.PI) * n * i + this.controlWidth, r = Math.sin(2 * (n / o) * Math.PI) * n * i + this.controlHeight;
            this.arrangeControl(e, {
                left: s,
                top: r
            });
        }
    },
    start: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments);
            for (var e, i = this.getOrderedControls(this.container.toIndex), n = 0; e = i[n]; n++) e.applyStyle("z-index", i.length - n);
        };
    }),
    calcArrangementDifference: function() {
        return this.controlWidth;
    },
    destroy: enyo.inherit(function(t) {
        return function() {
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) e.applyStyle("z-index", null), 
            enyo.Arranger.positionControl(e, {
                left: null,
                top: null
            }), e.applyStyle("left", null), e.applyStyle("top", null), e.applyStyle("height", null), 
            e.applyStyle("width", null);
            t.apply(this, arguments);
        };
    })
}), enyo.kind({
    name: "enyo.GridArranger",
    kind: "Arranger",
    incrementalPoints: !0,
    colWidth: 100,
    colHeight: 100,
    size: function() {
        for (var t, e = this.container.getPanels(), i = this.colWidth, n = this.colHeight, o = 0; t = e[o]; o++) t.setBounds({
            width: i,
            height: n
        });
    },
    arrange: function(t) {
        for (var e, i = this.colWidth, n = this.colHeight, o = Math.max(1, Math.floor(this.containerBounds.width / i)), s = 0, r = 0; t.length > r; s++) for (var a = 0; o > a && (e = t[r]); a++, 
        r++) this.arrangeControl(e, {
            left: i * a,
            top: n * s
        });
    },
    flowControl: enyo.inherit(function(t) {
        return function(e, i) {
            t.apply(this, arguments), enyo.Arranger.opacifyControl(e, 0 !== i.top % this.colHeight ? .25 : 1);
        };
    }),
    calcArrangementDifference: function() {
        return this.colWidth;
    },
    destroy: enyo.inherit(function(t) {
        return function() {
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) enyo.Arranger.positionControl(e, {
                left: null,
                top: null
            }), e.applyStyle("left", null), e.applyStyle("top", null), e.applyStyle("height", null), 
            e.applyStyle("width", null);
            t.apply(this, arguments);
        };
    })
});

// lib/layout/panels/source/Panels.js
enyo.kind({
    name: "enyo.Panels",
    classes: "enyo-panels",
    published: {
        index: 0,
        draggable: !0,
        animate: !0,
        wrap: !1,
        arrangerKind: "CardArranger",
        narrowFit: !0
    },
    events: {
        onTransitionStart: "",
        onTransitionFinish: ""
    },
    handlers: {
        ondragstart: "dragstart",
        ondrag: "drag",
        ondragfinish: "dragfinish",
        onscroll: "domScroll"
    },
    tools: [ {
        kind: "Animator",
        onStep: "step",
        onEnd: "completed"
    } ],
    fraction: 0,
    create: enyo.inherit(function(t) {
        return function() {
            this.transitionPoints = [], t.apply(this, arguments), this.arrangerKindChanged(), 
            this.narrowFitChanged(), this.indexChanged();
        };
    }),
    rendered: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), enyo.makeBubble(this, "scroll");
        };
    }),
    domScroll: function() {
        this.hasNode() && this.node.scrollLeft > 0 && (this.node.scrollLeft = 0);
    },
    initComponents: enyo.inherit(function(t) {
        return function() {
            this.createChrome(this.tools), t.apply(this, arguments);
        };
    }),
    arrangerKindChanged: function() {
        this.setLayoutKind(this.arrangerKind);
    },
    narrowFitChanged: function() {
        this.addRemoveClass("enyo-panels-fit-narrow", this.narrowFit && enyo.Panels.isScreenNarrow());
    },
    destroy: enyo.inherit(function(t) {
        return function() {
            this.destroying = !0, t.apply(this, arguments);
        };
    }),
    removeControl: enyo.inherit(function(t) {
        return function(e) {
            if (this.destroying) return t.apply(this, arguments);
            var i = -1, n = enyo.indexOf(e, this.controls);
            n === this.index && (i = Math.max(n - 1, 0)), t.apply(this, arguments), -1 !== i && this.controls.length > 0 && (this.setIndex(i), 
            this.flow(), this.reflow());
        };
    }),
    isPanel: function() {
        return !0;
    },
    flow: enyo.inherit(function(t) {
        return function() {
            this.arrangements = [], t.apply(this, arguments);
        };
    }),
    reflow: enyo.inherit(function(t) {
        return function() {
            this.arrangements = [], t.apply(this, arguments), this.refresh();
        };
    }),
    getPanels: function() {
        var t = this.controlParent || this;
        return t.children;
    },
    getActive: function() {
        var t = this.getPanels(), e = this.index % t.length;
        return 0 > e && (e += t.length), t[e];
    },
    getAnimator: function() {
        return this.$.animator;
    },
    setIndex: function(t) {
        var e = this.get("index");
        this.index = this.clamp(t), this.notifyObservers("index", e, t);
    },
    setIndexDirect: function(t) {
        this.setIndex(t), this.completed();
    },
    selectPanelByName: function(t) {
        if (t) for (var e = 0, i = this.getPanels(), n = i.length; n > e; ++e) if (t === i[e].name) return this.setIndex(e), 
        e;
    },
    previous: function() {
        var t = this.index - 1;
        this.wrap && 0 > t && (t = this.getPanels().length - 1), this.setIndex(t);
    },
    next: function() {
        var t = this.index + 1;
        this.wrap && t >= this.getPanels().length && (t = 0), this.setIndex(t);
    },
    clamp: function(t) {
        var e = this.getPanels().length - 1;
        return this.wrap ? t : Math.max(0, Math.min(t, e));
    },
    indexChanged: function(t) {
        this.lastIndex = t, !this.dragging && this.$.animator && (this.$.animator.isAnimating() && (this.finishTransitionInfo && (this.finishTransitionInfo.animating = !0), 
        this.completed()), this.$.animator.stop(), this.hasNode() && (this.animate ? (this.startTransition(!0), 
        this.$.animator.play({
            startValue: this.fraction
        })) : this.refresh()));
    },
    step: function(t) {
        return this.fraction = t.value, this.stepTransition(), !0;
    },
    completed: function() {
        return this.$.animator.isAnimating() && this.$.animator.stop(), this.fraction = 1, 
        this.stepTransition(), this.finishTransition(!0), !0;
    },
    dragstart: function(t, e) {
        return this.draggable && this.layout && this.layout.canDragEvent(e) ? (e.preventDefault(), 
        this.dragstartTransition(e), this.dragging = !0, this.$.animator.stop(), !0) : void 0;
    },
    drag: function(t, e) {
        this.dragging && (e.preventDefault(), this.dragTransition(e));
    },
    dragfinish: function(t, e) {
        this.dragging && (this.dragging = !1, e.preventTap(), this.dragfinishTransition(e));
    },
    dragstartTransition: function(t) {
        if (this.$.animator.isAnimating()) this.verifyDragTransition(t); else {
            var e = this.fromIndex = this.index;
            this.toIndex = e - (this.layout ? this.layout.calcDragDirection(t) : 0);
        }
        this.fromIndex = this.clamp(this.fromIndex), this.toIndex = this.clamp(this.toIndex), 
        this.fireTransitionStart(), this.layout && this.layout.start();
    },
    dragTransition: function(t) {
        var e = this.layout ? this.layout.calcDrag(t) : 0, i = this.transitionPoints, n = i[0], o = i[i.length - 1], s = this.fetchArrangement(n), r = this.fetchArrangement(o), a = this.layout ? this.layout.drag(e, n, s, o, r) : 0, h = e && !a;
        this.fraction += a;
        var l = this.fraction;
        (l > 1 || 0 > l || h) && ((l > 0 || h) && this.dragfinishTransition(t), this.dragstartTransition(t), 
        this.fraction = 0), this.stepTransition();
    },
    dragfinishTransition: function(t) {
        this.verifyDragTransition(t), this.setIndex(this.toIndex), this.dragging && this.fireTransitionFinish();
    },
    verifyDragTransition: function(t) {
        var e = this.layout ? this.layout.calcDragDirection(t) : 0, i = Math.min(this.fromIndex, this.toIndex), n = Math.max(this.fromIndex, this.toIndex);
        if (e > 0) {
            var o = i;
            i = n, n = o;
        }
        i != this.fromIndex && (this.fraction = 1 - this.fraction), this.fromIndex = i, 
        this.toIndex = n;
    },
    refresh: function() {
        this.$.animator && this.$.animator.isAnimating() && this.$.animator.stop(), this.startTransition(!1), 
        this.fraction = 1, this.stepTransition(), this.finishTransition(!1);
    },
    startTransition: function(t) {
        this.fromIndex = null != this.fromIndex ? this.fromIndex : this.lastIndex || 0, 
        this.toIndex = null != this.toIndex ? this.toIndex : this.index, this.layout && this.layout.start(), 
        t && this.fireTransitionStart();
    },
    finishTransition: function(t) {
        this.layout && this.layout.finish(), this.transitionPoints = [], this.fraction = 0, 
        this.fromIndex = this.toIndex = null, t && this.fireTransitionFinish();
    },
    fireTransitionStart: function() {
        var t = this.startTransitionInfo;
        !this.hasNode() || t && t.fromIndex == this.fromIndex && t.toIndex == this.toIndex || (this.startTransitionInfo = {
            fromIndex: this.fromIndex,
            toIndex: this.toIndex
        }, this.doTransitionStart(enyo.clone(this.startTransitionInfo)));
    },
    fireTransitionFinish: function() {
        var t = this.finishTransitionInfo;
        !this.hasNode() || t && t.fromIndex == this.lastIndex && t.toIndex == this.index || (this.finishTransitionInfo = t && t.animating ? {
            fromIndex: t.toIndex,
            toIndex: this.lastIndex
        } : {
            fromIndex: this.lastIndex,
            toIndex: this.index
        }, this.doTransitionFinish(enyo.clone(this.finishTransitionInfo)));
    },
    stepTransition: function() {
        if (this.hasNode()) {
            var t = this.transitionPoints, e = (this.fraction || 0) * (t.length - 1), i = Math.floor(e);
            e -= i;
            var n = t[i], o = t[i + 1], s = this.fetchArrangement(n), r = this.fetchArrangement(o);
            this.arrangement = s && r ? enyo.Panels.lerp(s, r, e) : s || r, this.arrangement && this.layout && this.layout.flowArrangement();
        }
    },
    fetchArrangement: function(t) {
        return null != t && !this.arrangements[t] && this.layout && (this.layout._arrange(t), 
        this.arrangements[t] = this.readArrangement(this.getPanels())), this.arrangements[t];
    },
    readArrangement: function(t) {
        for (var e, i = [], n = 0, o = t; e = o[n]; n++) i.push(enyo.clone(e._arranger));
        return i;
    },
    statics: {
        isScreenNarrow: function() {
            var t = navigator.userAgent, e = enyo.dom.getWindowWidth();
            switch (enyo.platform.platformName) {
              case "ios":
                return /iP(?:hone|od;(?: U;)? CPU) OS (\d+)/.test(t);

              case "android":
                return /Mobile/.test(t) && (enyo.platform.android > 2 ? !0 : 800 >= e);
            }
            return 800 >= e;
        },
        lerp: function(t, e, i) {
            for (var n, o = [], s = 0, r = enyo.keys(t); n = r[s]; s++) o.push(this.lerpObject(t[n], e[n], i));
            return o;
        },
        lerpObject: function(t, e, i) {
            var n, o, s = enyo.clone(t);
            if (e) for (var r in t) n = t[r], o = e[r], n != o && (s[r] = n - (n - o) * i);
            return s;
        }
    }
});

// lib/layout/tree/source/Node.js
enyo.kind({
    name: "enyo.Node",
    published: {
        expandable: !1,
        expanded: !1,
        icon: "",
        onlyIconExpands: !1,
        selected: !1
    },
    style: "padding: 0 0 0 16px;",
    content: "Node",
    defaultKind: "Node",
    classes: "enyo-node",
    components: [ {
        name: "icon",
        kind: "Image",
        showing: !1
    }, {
        kind: "Control",
        name: "caption",
        Xtag: "span",
        style: "display: inline-block; padding: 4px;",
        allowHtml: !0
    }, {
        kind: "Control",
        name: "extra",
        tag: "span",
        allowHtml: !0
    } ],
    childClient: [ {
        kind: "Control",
        name: "box",
        classes: "enyo-node-box",
        Xstyle: "border: 1px solid orange;",
        components: [ {
            kind: "Control",
            name: "client",
            classes: "enyo-node-client",
            Xstyle: "border: 1px solid lightblue;"
        } ]
    } ],
    handlers: {
        ondblclick: "dblclick"
    },
    events: {
        onNodeTap: "nodeTap",
        onNodeDblClick: "nodeDblClick",
        onExpand: "nodeExpand",
        onDestroyed: "nodeDestroyed"
    },
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.selectedChanged(), this.iconChanged();
        };
    }),
    destroy: enyo.inherit(function(t) {
        return function() {
            this.doDestroyed(), t.apply(this, arguments);
        };
    }),
    initComponents: enyo.inherit(function(t) {
        return function() {
            this.expandable && (this.kindComponents = this.kindComponents.concat(this.childClient)), 
            t.apply(this, arguments);
        };
    }),
    contentChanged: function() {
        this.$.caption.setContent(this.content);
    },
    iconChanged: function() {
        this.$.icon.setSrc(this.icon), this.$.icon.setShowing(Boolean(this.icon));
    },
    selectedChanged: function() {
        this.addRemoveClass("enyo-selected", this.selected);
    },
    rendered: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.expandable && !this.expanded && this.quickCollapse();
        };
    }),
    addNodes: function(t) {
        this.destroyClientControls();
        for (var e, i = 0; e = t[i]; i++) this.createComponent(e);
        this.$.client.render();
    },
    addTextNodes: function(t) {
        this.destroyClientControls();
        for (var e, i = 0; e = t[i]; i++) this.createComponent({
            content: e
        });
        this.$.client.render();
    },
    tap: function(t, e) {
        return this.onlyIconExpands ? e.target == this.$.icon.hasNode() ? this.toggleExpanded() : this.doNodeTap() : (this.toggleExpanded(), 
        this.doNodeTap()), !0;
    },
    dblclick: function() {
        return this.doNodeDblClick(), !0;
    },
    toggleExpanded: function() {
        this.setExpanded(!this.expanded);
    },
    quickCollapse: function() {
        this.removeClass("enyo-animate"), this.$.box.applyStyle("height", "0");
        var t = this.$.client.getBounds().height;
        this.$.client.setBounds({
            top: -t
        });
    },
    _expand: function() {
        this.addClass("enyo-animate");
        var t = this.$.client.getBounds().height;
        this.$.box.setBounds({
            height: t
        }), this.$.client.setBounds({
            top: 0
        }), setTimeout(this.bindSafely(function() {
            this.expanded && (this.removeClass("enyo-animate"), this.$.box.applyStyle("height", "auto"));
        }), 225);
    },
    _collapse: function() {
        this.removeClass("enyo-animate");
        var t = this.$.client.getBounds().height;
        this.$.box.setBounds({
            height: t
        }), setTimeout(this.bindSafely(function() {
            this.addClass("enyo-animate"), this.$.box.applyStyle("height", "0"), this.$.client.setBounds({
                top: -t
            });
        }), 25);
    },
    expandedChanged: function() {
        if (this.expandable) {
            var t = {
                expanded: this.expanded
            };
            this.doExpand(t), t.wait || this.effectExpanded();
        } else this.expanded = !1;
    },
    effectExpanded: function() {
        this.$.client && (this.expanded ? this._expand() : this._collapse());
    }
});

// lib/layout/imageview/source/PanZoomView.js
enyo.kind({
    name: "enyo.PanZoomView",
    kind: enyo.Scroller,
    touchOverscroll: !1,
    thumb: !1,
    animate: !0,
    verticalDragPropagation: !0,
    horizontalDragPropagation: !0,
    published: {
        scale: "auto",
        disableZoom: !1
    },
    events: {
        onZoom: ""
    },
    touch: !0,
    preventDragPropagation: !1,
    handlers: {
        ondragstart: "dragPropagation",
        onSetDimensions: "setDimensions"
    },
    components: [ {
        name: "animator",
        kind: "Animator",
        onStep: "zoomAnimationStep",
        onEnd: "zoomAnimationEnd"
    }, {
        name: "viewport",
        style: "overflow:hidden;min-height:100%;min-width:100%;",
        classes: "enyo-fit",
        ongesturechange: "gestureTransform",
        ongestureend: "saveState",
        ontap: "singleTap",
        ondblclick: "doubleClick",
        onmousewheel: "mousewheel",
        components: [ {
            name: "content"
        } ]
    } ],
    create: enyo.inherit(function(t) {
        return function() {
            this.scaleKeyword = this.scale;
            var e = this.components;
            if (this.components = [], t.apply(this, arguments), this.$.content.applyStyle("width", this.contentWidth + "px"), 
            this.$.content.applyStyle("height", this.contentHeight + "px"), this.unscaledComponents) {
                var i = this.hasOwnProperty("unscaledComponents") ? this.getInstanceOwner() : this;
                this.createComponents(this.unscaledComponents, {
                    owner: i
                });
            }
            this.controlParentName = "content", this.discoverControlParent(), this.createComponents(e), 
            this.canTransform = enyo.dom.canTransform(), this.canTransform || this.$.content.applyStyle("position", "relative"), 
            this.canAccelerate = enyo.dom.canAccelerate(), this.getStrategy().setDragDuringGesture(!1);
        };
    }),
    rendered: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.getOriginalScale();
        };
    }),
    dragPropagation: function(t, e) {
        var i = this.getStrategy().getScrollBounds(), n = 0 === i.top && e.dy > 0 || i.top >= i.maxTop - 2 && 0 > e.dy, o = 0 === i.left && e.dx > 0 || i.left >= i.maxLeft - 2 && 0 > e.dx;
        return !(n && this.verticalDragPropagation || o && this.horizontalDragPropagation);
    },
    mousewheel: function(t, e) {
        e.pageX |= e.clientX + e.target.scrollLeft, e.pageY |= e.clientY + e.target.scrollTop;
        var i = (this.maxScale - this.minScale) / 10, n = this.scale;
        return e.wheelDelta > 0 || 0 > e.detail ? this.scale = this.limitScale(this.scale + i) : (0 > e.wheelDelta || e.detail > 0) && (this.scale = this.limitScale(this.scale - i)), 
        this.eventPt = this.calcEventLocation(e), this.transform(this.scale), n != this.scale && this.doZoom({
            scale: this.scale
        }), this.ratioX = this.ratioY = null, e.preventDefault(), !0;
    },
    resizeHandler: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.scaleChanged();
        };
    }),
    setDimensions: function(t, e) {
        return this.$.content.applyStyle("width", e.width + "px"), this.$.content.applyStyle("height", e.height + "px"), 
        this.originalWidth = e.width, this.originalHeight = e.height, this.scale = this.scaleKeyword, 
        this.scaleChanged(), !0;
    },
    getOriginalScale: function() {
        this.$.content.hasNode() && (this.originalWidth = this.$.content.node.clientWidth, 
        this.originalHeight = this.$.content.node.clientHeight, this.scale = this.scaleKeyword, 
        this.scaleChanged());
    },
    scaleChanged: function() {
        var t = this.hasNode();
        if (t) {
            this.containerWidth = t.clientWidth, this.containerHeight = t.clientHeight;
            var e = this.containerWidth / this.originalWidth, i = this.containerHeight / this.originalHeight;
            this.minScale = Math.min(e, i), this.maxScale = 1 > 3 * this.minScale ? 1 : 3 * this.minScale, 
            "auto" == this.scale ? this.scale = this.minScale : "width" == this.scale ? this.scale = e : "height" == this.scale ? this.scale = i : "fit" == this.scale ? (this.fitAlignment = "center", 
            this.scale = Math.max(e, i)) : (this.maxScale = Math.max(this.maxScale, this.scale), 
            this.scale = this.limitScale(this.scale));
        }
        this.eventPt = this.calcEventLocation(), this.transform(this.scale), this.getStrategy().$.scrollMath && this.getStrategy().$.scrollMath.start(), 
        this.align();
    },
    align: function() {
        if (this.fitAlignment && "center" === this.fitAlignment) {
            var t = this.getScrollBounds();
            this.setScrollLeft(t.maxLeft / 2), this.setScrollTop(t.maxTop / 2);
        }
    },
    gestureTransform: function(t, e) {
        this.eventPt = this.calcEventLocation(e), this.transform(this.limitScale(this.scale * e.scale));
    },
    calcEventLocation: function(t) {
        var e = {
            x: 0,
            y: 0
        };
        if (t && this.hasNode()) {
            var i = this.node.getBoundingClientRect();
            e.x = Math.round(t.pageX - i.left - this.bounds.x), e.x = Math.max(0, Math.min(this.bounds.width, e.x)), 
            e.y = Math.round(t.pageY - i.top - this.bounds.y), e.y = Math.max(0, Math.min(this.bounds.height, e.y));
        }
        return e;
    },
    transform: function(t) {
        this.tapped = !1;
        var e = this.bounds || this.innerBounds(t);
        this.bounds = this.innerBounds(t), this.scale > this.minScale ? this.$.viewport.applyStyle("cursor", "move") : this.$.viewport.applyStyle("cursor", null), 
        this.$.viewport.setBounds({
            width: this.bounds.width + "px",
            height: this.bounds.height + "px"
        }), this.ratioX = this.ratioX || (this.eventPt.x + this.getScrollLeft()) / e.width, 
        this.ratioY = this.ratioY || (this.eventPt.y + this.getScrollTop()) / e.height;
        var i, n;
        if (this.$.animator.ratioLock ? (i = this.$.animator.ratioLock.x * this.bounds.width - this.containerWidth / 2, 
        n = this.$.animator.ratioLock.y * this.bounds.height - this.containerHeight / 2) : (i = this.ratioX * this.bounds.width - this.eventPt.x, 
        n = this.ratioY * this.bounds.height - this.eventPt.y), i = Math.max(0, Math.min(this.bounds.width - this.containerWidth, i)), 
        n = Math.max(0, Math.min(this.bounds.height - this.containerHeight, n)), this.canTransform) {
            var o = {
                scale: t
            };
            o = this.canAccelerate ? enyo.mixin({
                translate3d: Math.round(this.bounds.left) + "px, " + Math.round(this.bounds.top) + "px, 0px"
            }, o) : enyo.mixin({
                translate: this.bounds.left + "px, " + this.bounds.top + "px"
            }, o), enyo.dom.transform(this.$.content, o);
        } else if (enyo.platform.ie) {
            var s = '"progid:DXImageTransform.Microsoft.Matrix(M11=' + t + ", M12=0, M21=0, M22=" + t + ", SizingMethod='auto expand')\"";
            this.$.content.applyStyle("-ms-filter", s), this.$.content.setBounds({
                width: this.bounds.width * t + "px",
                height: this.bounds.height * t + "px",
                left: this.bounds.left + "px",
                top: this.bounds.top + "px"
            }), this.$.content.applyStyle("width", t * this.bounds.width), this.$.content.applyStyle("height", t * this.bounds.height);
        }
        this.setScrollLeft(i), this.setScrollTop(n), this.positionClientControls(t);
    },
    limitScale: function(t) {
        return this.disableZoom ? t = this.scale : t > this.maxScale ? t = this.maxScale : this.minScale > t && (t = this.minScale), 
        t;
    },
    innerBounds: function(t) {
        var e = this.originalWidth * t, i = this.originalHeight * t, n = {
            x: 0,
            y: 0,
            transX: 0,
            transY: 0
        };
        return this.containerWidth > e && (n.x += (this.containerWidth - e) / 2), this.containerHeight > i && (n.y += (this.containerHeight - i) / 2), 
        this.canTransform && (n.transX -= (this.originalWidth - e) / 2, n.transY -= (this.originalHeight - i) / 2), 
        {
            left: n.x + n.transX,
            top: n.y + n.transY,
            width: e,
            height: i,
            x: n.x,
            y: n.y
        };
    },
    saveState: function(t, e) {
        var i = this.scale;
        this.scale *= e.scale, this.scale = this.limitScale(this.scale), i != this.scale && this.doZoom({
            scale: this.scale
        }), this.ratioX = this.ratioY = null;
    },
    doubleClick: function(t, e) {
        8 == enyo.platform.ie && (this.tapped = !0, e.pageX = e.clientX + e.target.scrollLeft, 
        e.pageY = e.clientY + e.target.scrollTop, this.singleTap(t, e), e.preventDefault());
    },
    singleTap: function(t, e) {
        setTimeout(this.bindSafely(function() {
            this.tapped = !1;
        }), 300), this.tapped ? (this.tapped = !1, this.smartZoom(t, e)) : this.tapped = !0;
    },
    smartZoom: function(t, e) {
        var i = this.hasNode(), n = this.$.content.hasNode();
        if (i && n && this.hasNode() && !this.disableZoom) {
            var o = this.scale;
            if (this.scale = this.scale != this.minScale ? this.minScale : this.maxScale, this.eventPt = this.calcEventLocation(e), 
            this.animate) {
                var s = {
                    x: (this.eventPt.x + this.getScrollLeft()) / this.bounds.width,
                    y: (this.eventPt.y + this.getScrollTop()) / this.bounds.height
                };
                this.$.animator.play({
                    duration: 350,
                    ratioLock: s,
                    baseScale: o,
                    deltaScale: this.scale - o
                });
            } else this.transform(this.scale), this.doZoom({
                scale: this.scale
            });
        }
    },
    zoomAnimationStep: function() {
        var t = this.$.animator.baseScale + this.$.animator.deltaScale * this.$.animator.value;
        return this.transform(t), !0;
    },
    zoomAnimationEnd: function() {
        return this.stabilize(), this.doZoom({
            scale: this.scale
        }), this.$.animator.ratioLock = void 0, !0;
    },
    positionClientControls: function(t) {
        this.waterfallDown("onPositionPin", {
            scale: t,
            bounds: this.bounds
        });
    }
});

// lib/layout/imageview/source/ImageViewPin.js
enyo.kind({
    name: "enyo.ImageViewPin",
    kind: "enyo.Control",
    published: {
        highlightAnchorPoint: !1,
        anchor: {
            top: 0,
            left: 0
        },
        position: {
            top: 0,
            left: 0
        }
    },
    style: "position:absolute;z-index:1000;width:0px;height:0px;",
    handlers: {
        onPositionPin: "reAnchor"
    },
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.styleClientControls(), this.positionClientControls(), 
            this.highlightAnchorPointChanged(), this.anchorChanged();
        };
    }),
    styleClientControls: function() {
        for (var t = this.getClientControls(), e = 0; t.length > e; e++) t[e].applyStyle("position", "absolute");
    },
    positionClientControls: function() {
        for (var t = this.getClientControls(), e = 0; t.length > e; e++) for (var i in this.position) t[e].applyStyle(i, this.position[i] + "px");
    },
    highlightAnchorPointChanged: function() {
        this.addRemoveClass("pinDebug", this.highlightAnchorPoint);
    },
    anchorChanged: function() {
        var t = null, e = null;
        for (e in this.anchor) t = ("" + this.anchor[e]).match(/^(\d+(?:\.\d+)?)(.*)$/), 
        t && (this.anchor[e + "Coords"] = {
            value: t[1],
            units: t[2] || "px"
        });
    },
    reAnchor: function(t, e) {
        var i = e.scale, n = e.bounds, o = this.anchor.right ? "px" == this.anchor.rightCoords.units ? n.width + n.x - this.anchor.rightCoords.value * i : n.width * (100 - this.anchor.rightCoords.value) / 100 + n.x : "px" == this.anchor.leftCoords.units ? this.anchor.leftCoords.value * i + n.x : n.width * this.anchor.leftCoords.value / 100 + n.x, s = this.anchor.bottom ? "px" == this.anchor.bottomCoords.units ? n.height + n.y - this.anchor.bottomCoords.value * i : n.height * (100 - this.anchor.bottomCoords.value) / 100 + n.y : "px" == this.anchor.topCoords.units ? this.anchor.topCoords.value * i + n.y : n.height * this.anchor.topCoords.value / 100 + n.y;
        this.applyStyle("left", o + "px"), this.applyStyle("top", s + "px");
    }
});

// lib/layout/imageview/source/ImageView.js
enyo.kind({
    name: "enyo.ImageView",
    kind: "enyo.PanZoomView",
    subKindComponents: [ {
        kind: "Image",
        ondown: "down",
        style: "vertical-align: text-top;"
    } ],
    create: enyo.inherit(function(t) {
        return function() {
            this.unscaledComponents = this.components, this.components = [], this.kindComponents[1].components[0].components = this.subKindComponents, 
            t.apply(this, arguments), this.$.content.applyStyle("display", "inline-block"), 
            this.bufferImage = new Image(), this.bufferImage.onload = enyo.bind(this, "imageLoaded"), 
            this.bufferImage.onerror = enyo.bind(this, "imageError"), this.srcChanged(), this.getStrategy().$.scrollMath && this.getStrategy().$.scrollMath.start();
        };
    }),
    destroy: enyo.inherit(function(t) {
        return function() {
            this.bufferImage && (this.bufferImage.onerror = void 0, this.bufferImage.onerror = void 0, 
            delete this.bufferImage), t.apply(this, arguments);
        };
    }),
    down: function(t, e) {
        e.preventDefault();
    },
    srcChanged: function() {
        this.src && this.src.length > 0 && this.bufferImage && this.src != this.bufferImage.src && (this.bufferImage.src = this.src);
    },
    imageLoaded: function() {
        this.scale = this.scaleKeyword, this.originalWidth = this.contentWidth = this.bufferImage.width, 
        this.originalHeight = this.contentHeight = this.bufferImage.height, this.scaleChanged(), 
        this.$.image.setSrc(this.bufferImage.src), enyo.dom.transformValue(this.getStrategy().$.client, "translate3d", "0px, 0px, 0"), 
        this.positionClientControls(this.scale), this.align();
    },
    imageError: function(t) {
        enyo.error("Error loading image: " + this.src), this.bubble("onerror", t);
    }
});

// lib/layout/imageview/source/ImageCarousel.js
enyo.kind({
    name: "enyo.ImageCarousel",
    kind: enyo.Panels,
    arrangerKind: "enyo.CarouselArranger",
    defaultScale: "auto",
    disableZoom: !1,
    lowMemory: !1,
    published: {
        images: []
    },
    handlers: {
        onTransitionStart: "transitionStart",
        onTransitionFinish: "transitionFinish"
    },
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.imageCount = this.images.length, this.images.length > 0 && (this.initContainers(), 
            this.loadNearby());
        };
    }),
    initContainers: function() {
        for (var t = 0; this.images.length > t; t++) this.$["container" + t] || (this.createComponent({
            name: "container" + t,
            style: "height:100%; width:100%;"
        }), this.$["container" + t].render());
        for (t = this.images.length; this.imageCount > t; t++) this.$["image" + t] && this.$["image" + t].destroy(), 
        this.$["container" + t].destroy();
        this.imageCount = this.images.length;
    },
    loadNearby: function() {
        var t = this.getBufferRange();
        for (var e in t) this.loadImageView(t[e]);
    },
    getBufferRange: function() {
        var t = [];
        if (this.layout.containerBounds) {
            var e, i, n, o, s = 1, r = this.layout.containerBounds;
            for (i = this.index - 1, n = 0, o = r.width * s; i >= 0 && o >= n; ) e = this.$["container" + i], 
            n += e.width + e.marginWidth, t.unshift(i), i--;
            for (i = this.index, n = 0, o = r.width * (s + 1); this.images.length > i && o >= n; ) e = this.$["container" + i], 
            n += e.width + e.marginWidth, t.push(i), i++;
        }
        return t;
    },
    reflow: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.loadNearby();
        };
    }),
    loadImageView: function(t) {
        return this.wrap && (t = (t % this.images.length + this.images.length) % this.images.length), 
        t >= 0 && this.images.length - 1 >= t && (this.$["image" + t] ? this.$["image" + t].src != this.images[t] && (this.$["image" + t].setSrc(this.images[t]), 
        this.$["image" + t].setScale(this.defaultScale), this.$["image" + t].setDisableZoom(this.disableZoom)) : (this.$["container" + t].createComponent({
            name: "image" + t,
            kind: "ImageView",
            scale: this.defaultScale,
            disableZoom: this.disableZoom,
            src: this.images[t],
            verticalDragPropagation: !1,
            style: "height:100%; width:100%;"
        }, {
            owner: this
        }), this.$["image" + t].render())), this.$["image" + t];
    },
    setImages: function(t) {
        this.set("images", t);
    },
    imagesChanged: function() {
        this.initContainers(), this.loadNearby();
    },
    indexChanged: enyo.inherit(function(t) {
        return function() {
            this.loadNearby(), this.lowMemory && this.cleanupMemory(), t.apply(this, arguments);
        };
    }),
    transitionStart: function(t, e) {
        return e.fromIndex == e.toIndex ? !0 : void 0;
    },
    transitionFinish: function() {
        this.loadNearby(), this.lowMemory && this.cleanupMemory();
    },
    getActiveImage: function() {
        return this.getImageByIndex(this.index);
    },
    getImageByIndex: function(t) {
        return this.$["image" + t] || this.loadImageView(t);
    },
    cleanupMemory: function() {
        for (var t = this.getBufferRange(), e = 0; this.images.length > e; e++) -1 === enyo.indexOf(e, t) && this.$["image" + e] && this.$["image" + e].destroy();
    }
});

// lib/onyx/version.js
enyo && enyo.version && (enyo.version.onyx = "2.4.0-pre.1");

// lib/onyx/source/Icon.js
enyo.kind({
    name: "onyx.Icon",
    published: {
        src: "",
        disabled: !1
    },
    classes: "onyx-icon",
    create: function() {
        this.inherited(arguments), this.src && this.srcChanged(), this.disabledChanged();
    },
    disabledChanged: function() {
        this.addRemoveClass("disabled", this.disabled);
    },
    srcChanged: function() {
        this.applyStyle("background-image", "url(" + enyo.path.rewrite(this.src) + ")");
    }
});

// lib/onyx/source/Button.js
enyo.kind({
    name: "onyx.Button",
    kind: "enyo.Button",
    classes: "onyx-button enyo-unselectable",
    handlers: {
        ondown: "down",
        onenter: "enter",
        ondrag: "drag",
        onleave: "leave",
        onup: "up"
    },
    down: function() {
        this.addClass("pressed"), this._isInControl = !0;
    },
    enter: function() {
        this._isInControl = !0;
    },
    drag: function() {
        this.addRemoveClass("pressed", this._isInControl);
    },
    leave: function() {
        this.removeClass("pressed"), this._isInControl = !1;
    },
    up: function() {
        this.removeClass("pressed"), this._isInControl = !1;
    }
});

// lib/onyx/source/IconButton.js
enyo.kind({
    name: "onyx.IconButton",
    kind: "onyx.Icon",
    published: {
        active: !1
    },
    classes: "onyx-icon-button",
    handlers: {
        ondown: "down",
        onenter: "enter",
        ondrag: "drag",
        onleave: "leave",
        onup: "up"
    },
    rendered: function() {
        this.inherited(arguments), this.activeChanged();
    },
    tap: function() {
        return this.disabled ? !0 : (this.setActive(!0), void 0);
    },
    down: function() {
        return this.disabled ? !0 : (this.addClass("pressed"), this._isInControl = !0, void 0);
    },
    enter: function() {
        return this.disabled ? !0 : (this._isInControl = !0, void 0);
    },
    drag: function() {
        return this.disabled ? !0 : (this.addRemoveClass("pressed", this._isInControl), 
        void 0);
    },
    leave: function() {
        return this.disabled ? !0 : (this.removeClass("pressed"), this._isInControl = !1, 
        void 0);
    },
    up: function() {
        return this.disabled ? !0 : (this.removeClass("pressed"), this._isInControl = !1, 
        void 0);
    },
    activeChanged: function() {
        this.bubble("onActivate");
    }
});

// lib/onyx/source/Checkbox.js
enyo.kind({
    name: "onyx.Checkbox",
    classes: "onyx-checkbox",
    kind: enyo.Checkbox,
    tag: "div",
    handlers: {
        onclick: ""
    },
    tap: function() {
        return this.disabled || (this.setChecked(!this.getChecked()), this.bubble("onchange")), 
        !this.disabled;
    },
    dragstart: function() {}
});

// lib/onyx/source/Drawer.js
enyo.kind({
    name: "onyx.Drawer",
    kind: "enyo.Drawer"
});

// lib/onyx/source/Grabber.js
enyo.kind({
    name: "onyx.Grabber",
    classes: "onyx-grabber"
});

// lib/onyx/source/Groupbox.js
enyo.kind({
    name: "onyx.Groupbox",
    classes: "onyx-groupbox"
}), enyo.kind({
    name: "onyx.GroupboxHeader",
    classes: "onyx-groupbox-header"
});

// lib/onyx/source/Input.js
enyo.kind({
    name: "onyx.Input",
    kind: "enyo.Input",
    classes: "onyx-input"
});

// lib/onyx/source/Popup.js
enyo.kind({
    name: "onyx.Popup",
    kind: "enyo.Popup",
    classes: "onyx-popup",
    published: {
        scrimWhenModal: !0,
        scrim: !1,
        scrimClassName: ""
    },
    protectedStatics: {
        count: 0,
        highestZ: 120
    },
    defaultZ: 120,
    showingChanged: function() {
        this.showing ? (onyx.Popup.count++, this.applyZIndex()) : onyx.Popup.count > 0 && onyx.Popup.count--, 
        this.showHideScrim(this.showing), this.inherited(arguments);
    },
    showHideScrim: function(t) {
        if (this.floating && (this.scrim || this.modal && this.scrimWhenModal)) {
            var e = this.getScrim();
            if (t) {
                var i = this.getScrimZIndex();
                this._scrimZ = i, e.showAtZIndex(i);
            } else e.hideAtZIndex(this._scrimZ);
            enyo.call(e, "addRemoveClass", [ this.scrimClassName, e.showing ]);
        }
    },
    getScrimZIndex: function() {
        return onyx.Popup.highestZ >= this._zIndex ? this._zIndex - 1 : onyx.Popup.highestZ;
    },
    getScrim: function() {
        return this.modal && this.scrimWhenModal && !this.scrim ? onyx.scrimTransparent.make() : onyx.scrim.make();
    },
    applyZIndex: function() {
        this._zIndex = 2 * onyx.Popup.count + this.findZIndex() + 1, this._zIndex <= onyx.Popup.highestZ && (this._zIndex = onyx.Popup.highestZ + 1), 
        this._zIndex > onyx.Popup.highestZ && (onyx.Popup.highestZ = this._zIndex), this.applyStyle("z-index", this._zIndex);
    },
    findZIndex: function() {
        var t = this.defaultZ;
        return this._zIndex ? t = this._zIndex : this.hasNode() && (t = Number(enyo.dom.getComputedStyleValue(this.node, "z-index")) || t), 
        this.defaultZ > t && (t = this.defaultZ), this._zIndex = t, this._zIndex;
    }
});

// lib/onyx/source/TextArea.js
enyo.kind({
    name: "onyx.TextArea",
    kind: "enyo.TextArea",
    classes: "onyx-textarea"
});

// lib/onyx/source/RichText.js
enyo.kind({
    name: "onyx.RichText",
    kind: "enyo.RichText",
    classes: "onyx-richtext"
});

// lib/onyx/source/InputDecorator.js
enyo.kind({
    name: "onyx.InputDecorator",
    kind: "enyo.ToolDecorator",
    tag: "label",
    classes: "onyx-input-decorator",
    published: {
        alwaysLooksFocused: !1
    },
    handlers: {
        onDisabledChange: "disabledChange",
        onfocus: "receiveFocus",
        onblur: "receiveBlur"
    },
    create: function() {
        this.inherited(arguments), this.updateFocus(!1);
    },
    alwaysLooksFocusedChanged: function() {
        this.updateFocus(this.focus);
    },
    updateFocus: function(t) {
        this.focused = t, this.addRemoveClass("onyx-focused", this.alwaysLooksFocused || this.focused);
    },
    receiveFocus: function() {
        this.updateFocus(!0);
    },
    receiveBlur: function() {
        this.updateFocus(!1);
    },
    disabledChange: function(t, e) {
        this.addRemoveClass("onyx-disabled", e.originator.disabled);
    }
});

// lib/onyx/source/Tooltip.js
enyo.kind({
    name: "onyx.Tooltip",
    kind: "onyx.Popup",
    classes: "onyx-tooltip below left-arrow",
    autoDismiss: !1,
    showDelay: 500,
    defaultLeft: -6,
    handlers: {
        onRequestShowTooltip: "requestShow",
        onRequestHideTooltip: "requestHide"
    },
    requestShow: function() {
        return this.showJob = setTimeout(this.bindSafely("show"), this.showDelay), !0;
    },
    cancelShow: function() {
        clearTimeout(this.showJob);
    },
    requestHide: function() {
        return this.cancelShow(), this.inherited(arguments);
    },
    showingChanged: function() {
        this.cancelShow(), this.adjustPosition(!0), this.inherited(arguments);
    },
    applyPosition: function(t) {
        var e = "";
        for (var i in t) e += i + ":" + t[i] + (isNaN(t[i]) ? "; " : "px; ");
        this.addStyles(e);
    },
    adjustPosition: function() {
        if (this.showing && this.hasNode()) {
            var t = this.node.getBoundingClientRect();
            t.top + t.height > window.innerHeight ? (this.addRemoveClass("below", !1), this.addRemoveClass("above", !0)) : (this.addRemoveClass("above", !1), 
            this.addRemoveClass("below", !0)), t.left + t.width > window.innerWidth && (this.applyPosition({
                "margin-left": -t.width,
                bottom: "auto"
            }), this.addRemoveClass("left-arrow", !1), this.addRemoveClass("right-arrow", !0));
        }
    },
    resizeHandler: function() {
        this.applyPosition({
            "margin-left": this.defaultLeft,
            bottom: "auto"
        }), this.addRemoveClass("left-arrow", !0), this.addRemoveClass("right-arrow", !1), 
        this.adjustPosition(!0), this.inherited(arguments);
    }
});

// lib/onyx/source/TooltipDecorator.js
enyo.kind({
    name: "onyx.TooltipDecorator",
    defaultKind: "onyx.Button",
    classes: "onyx-popup-decorator",
    handlers: {
        onenter: "enter",
        onleave: "leave"
    },
    enter: function() {
        this.requestShowTooltip();
    },
    leave: function() {
        this.requestHideTooltip();
    },
    tap: function() {
        this.requestHideTooltip();
    },
    requestShowTooltip: function() {
        this.waterfallDown("onRequestShowTooltip");
    },
    requestHideTooltip: function() {
        this.waterfallDown("onRequestHideTooltip");
    }
});

// lib/onyx/source/MenuDecorator.js
enyo.kind({
    name: "onyx.MenuDecorator",
    kind: "onyx.TooltipDecorator",
    defaultKind: "onyx.Button",
    classes: "onyx-popup-decorator enyo-unselectable",
    handlers: {
        onActivate: "activated",
        onHide: "menuHidden"
    },
    activated: function(t, e) {
        this.requestHideTooltip(), e.originator.active && (this.menuActive = !0, this.activator = e.originator, 
        this.activator.addClass("active"), this.requestShowMenu());
    },
    requestShowMenu: function() {
        this.waterfallDown("onRequestShowMenu", {
            activator: this.activator
        });
    },
    requestHideMenu: function() {
        this.waterfallDown("onRequestHideMenu");
    },
    menuHidden: function() {
        this.menuActive = !1, this.activator && (this.activator.setActive(!1), this.activator.removeClass("active"));
    },
    enter: function() {
        this.menuActive || this.inherited(arguments);
    },
    leave: function() {
        this.menuActive || this.inherited(arguments);
    }
});

// lib/onyx/source/Menu.js
enyo.kind({
    name: "onyx.Menu",
    kind: "onyx.Popup",
    modal: !0,
    defaultKind: "onyx.MenuItem",
    classes: "onyx-menu",
    published: {
        maxHeight: 200,
        scrolling: !0,
        scrollStrategyKind: "TouchScrollStrategy"
    },
    handlers: {
        onActivate: "itemActivated",
        onRequestShowMenu: "requestMenuShow",
        onRequestHideMenu: "requestHide"
    },
    childComponents: [ {
        name: "client",
        kind: "enyo.Scroller"
    } ],
    showOnTop: !1,
    scrollerName: "client",
    create: function() {
        this.inherited(arguments), this.maxHeightChanged();
    },
    initComponents: function() {
        this.scrolling && this.createComponents(this.childComponents, {
            isChrome: !0,
            strategyKind: this.scrollStrategyKind
        }), this.inherited(arguments);
    },
    getScroller: function() {
        return this.$[this.scrollerName];
    },
    maxHeightChanged: function() {
        this.scrolling && this.getScroller().setMaxHeight(this.maxHeight + "px");
    },
    itemActivated: function(t, e) {
        return e.originator.setActive(!1), !0;
    },
    showingChanged: function() {
        this.inherited(arguments), this.scrolling && this.getScroller().setShowing(this.showing), 
        this.adjustPosition(!0);
    },
    requestMenuShow: function(t, e) {
        if (this.floating) {
            var i = e.activator.hasNode();
            if (i) {
                var n = this.activatorOffset = this.getPageOffset(i);
                this.applyPosition({
                    top: n.top + (this.showOnTop ? 0 : n.height),
                    left: n.left,
                    width: n.width
                });
            }
        }
        return this.show(), !0;
    },
    applyPosition: function(t) {
        var e = "";
        for (var i in t) e += i + ":" + t[i] + (isNaN(t[i]) ? "; " : "px; ");
        this.addStyles(e);
    },
    getPageOffset: function(t) {
        var e = t.getBoundingClientRect(), i = void 0 === window.pageYOffset ? document.documentElement.scrollTop : window.pageYOffset, n = void 0 === window.pageXOffset ? document.documentElement.scrollLeft : window.pageXOffset, o = void 0 === e.height ? e.bottom - e.top : e.height, s = void 0 === e.width ? e.right - e.left : e.width;
        return {
            top: e.top + i,
            left: e.left + n,
            height: o,
            width: s
        };
    },
    adjustPosition: function() {
        if (this.showing && this.hasNode()) {
            this.scrolling && !this.showOnTop && this.getScroller().setMaxHeight(this.maxHeight + "px"), 
            this.removeClass("onyx-menu-up"), this.floating || this.applyPosition({
                left: "auto"
            });
            var t = this.node.getBoundingClientRect(), e = void 0 === t.height ? t.bottom - t.top : t.height, i = void 0 === window.innerHeight ? document.documentElement.clientHeight : window.innerHeight, n = void 0 === window.innerWidth ? document.documentElement.clientWidth : window.innerWidth;
            if (this.menuUp = t.top + e > i && i - t.bottom < t.top - e, this.addRemoveClass("onyx-menu-up", this.menuUp), 
            this.floating) {
                var o = this.activatorOffset;
                this.menuUp ? this.applyPosition({
                    top: o.top - e + (this.showOnTop ? o.height : 0),
                    bottom: "auto"
                }) : t.top < o.top && i > o.top + (this.showOnTop ? 0 : o.height) + e && this.applyPosition({
                    top: o.top + (this.showOnTop ? 0 : o.height),
                    bottom: "auto"
                });
            }
            if (t.right > n && (this.floating ? this.applyPosition({
                left: n - t.width
            }) : this.applyPosition({
                left: -(t.right - n)
            })), 0 > t.left && (this.floating ? this.applyPosition({
                left: 0,
                right: "auto"
            }) : "auto" == this.getComputedStyleValue("right") ? this.applyPosition({
                left: -t.left
            }) : this.applyPosition({
                right: t.left
            })), this.scrolling && !this.showOnTop) {
                t = this.node.getBoundingClientRect();
                var s;
                s = this.menuUp ? this.maxHeight < t.bottom ? this.maxHeight : t.bottom : i > t.top + this.maxHeight ? this.maxHeight : i - t.top, 
                this.getScroller().setMaxHeight(s + "px");
            }
        }
    },
    resizeHandler: function() {
        this.inherited(arguments), this.adjustPosition();
    },
    requestHide: function() {
        this.setShowing(!1);
    }
});

// lib/onyx/source/MenuItem.js
enyo.kind({
    name: "onyx.MenuItem",
    kind: "enyo.Button",
    events: {
        onSelect: "",
        onItemContentChange: ""
    },
    classes: "onyx-menu-item",
    tag: "div",
    create: function() {
        this.silence(), this.inherited(arguments), this.unsilence(), this.active && this.bubble("onActivate");
    },
    tap: function() {
        this.inherited(arguments), this.bubble("onRequestHideMenu"), this.doSelect({
            selected: this,
            content: this.content
        });
    },
    contentChanged: function() {
        this.inherited(arguments), this.doItemContentChange({
            content: this.content
        });
    }
});

// lib/onyx/source/Submenu.js
enyo.kind({
    name: "onyx.Submenu",
    defaultKind: "onyx.MenuItem",
    initComponents: function() {
        this.createChrome([ {
            name: "label",
            kind: "enyo.Control",
            classes: "onyx-menu-item",
            content: this.content || this.name,
            isChrome: !0,
            ontap: "toggleOpen"
        }, {
            kind: "onyx.Drawer",
            name: "client",
            classes: "client onyx-submenu",
            isChrome: !0,
            open: !1
        } ]), this.inherited(arguments);
    },
    toggleOpen: function() {
        this.setOpen(!this.getOpen());
    },
    setOpen: function(t) {
        this.$.client.setOpen(t);
    },
    getOpen: function() {
        return this.$.client.getOpen();
    }
});

// lib/onyx/source/PickerDecorator.js
enyo.kind({
    name: "onyx.PickerDecorator",
    kind: "onyx.MenuDecorator",
    classes: "onyx-picker-decorator",
    defaultKind: "onyx.PickerButton",
    handlers: {
        onChange: "change"
    },
    change: function(t, e) {
        this.waterfallDown("onChange", e);
    }
});

// lib/onyx/source/PickerButton.js
enyo.kind({
    name: "onyx.PickerButton",
    kind: "onyx.Button",
    handlers: {
        onChange: "change"
    },
    change: function(t, e) {
        void 0 !== e.content && this.setContent(e.content);
    }
});

// lib/onyx/source/Picker.js
enyo.kind({
    name: "onyx.Picker",
    kind: "onyx.Menu",
    classes: "onyx-picker enyo-unselectable",
    published: {
        selected: null
    },
    events: {
        onChange: ""
    },
    handlers: {
        onItemContentChange: "itemContentChange"
    },
    floating: !0,
    showOnTop: !0,
    initComponents: function() {
        this.setScrolling(!0), this.inherited(arguments);
    },
    showingChanged: function() {
        this.getScroller().setShowing(this.showing), this.inherited(arguments), this.showing && this.selected && this.scrollToSelected();
    },
    scrollToSelected: function() {
        this.getScroller().scrollToControl(this.selected, !this.menuUp);
    },
    itemActivated: function(t, e) {
        return this.processActivatedItem(e.originator), this.inherited(arguments);
    },
    processActivatedItem: function(t) {
        t.active && this.setSelected(t);
    },
    selectedChanged: function(t) {
        t && t.removeClass("selected"), this.selected && (this.selected.addClass("selected"), 
        this.doChange({
            selected: this.selected,
            content: this.selected.content
        }));
    },
    itemContentChange: function(t, e) {
        e.originator == this.selected && this.doChange({
            selected: this.selected,
            content: this.selected.content
        });
    },
    resizeHandler: function() {
        this.inherited(arguments), this.adjustPosition();
    }
});

// lib/onyx/source/FlyweightPicker.js
enyo.kind({
    name: "onyx.FlyweightPicker",
    kind: "onyx.Picker",
    classes: "onyx-flyweight-picker",
    published: {
        count: 0
    },
    events: {
        onSetupItem: "",
        onSelect: ""
    },
    handlers: {
        onSelect: "itemSelect"
    },
    components: [ {
        name: "scroller",
        kind: "enyo.Scroller",
        strategyKind: "TouchScrollStrategy",
        components: [ {
            name: "flyweight",
            kind: "FlyweightRepeater",
            noSelect: !0,
            ontap: "itemTap"
        } ]
    } ],
    scrollerName: "scroller",
    initComponents: function() {
        this.controlParentName = "flyweight", this.inherited(arguments), this.$.flyweight.$.client.children[0].setActive(!0);
    },
    create: function() {
        this.inherited(arguments), this.countChanged();
    },
    rendered: function() {
        this.inherited(arguments), this.selectedChanged();
    },
    scrollToSelected: function() {
        var t = this.$.flyweight.fetchRowNode(this.selected);
        this.getScroller().scrollToNode(t, !this.menuUp);
    },
    countChanged: function() {
        this.$.flyweight.count = this.count;
    },
    processActivatedItem: function(t) {
        this.item = t;
    },
    selectedChanged: function(t) {
        if (this.item) {
            null != t && (this.item.removeClass("selected"), this.$.flyweight.renderRow(t));
            var e;
            null != this.selected && (this.item.addClass("selected"), this.$.flyweight.renderRow(this.selected), 
            this.item.removeClass("selected"), e = this.$.flyweight.fetchRowNode(this.selected)), 
            this.doChange({
                selected: this.selected,
                content: e && e.textContent || this.item.content
            });
        }
    },
    itemTap: function(t, e) {
        this.setSelected(e.rowIndex), this.doSelect({
            selected: this.item,
            content: this.item.content
        });
    },
    itemSelect: function(t, e) {
        return e.originator != this ? !0 : void 0;
    }
});

// lib/onyx/source/DatePicker.js
enyo.kind({
    name: "onyx.DatePicker",
    classes: "onyx-toolbar-inline",
    published: {
        disabled: !1,
        locale: "en_us",
        dayHidden: !1,
        monthHidden: !1,
        yearHidden: !1,
        minYear: 1900,
        maxYear: 2099,
        value: null
    },
    events: {
        onSelect: ""
    },
    create: function() {
        this.inherited(arguments), enyo.g11n && (this.locale = enyo.g11n.currentLocale().getLocale()), 
        this.initDefaults();
    },
    initDefaults: function() {
        var t = [ "JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC" ];
        enyo.g11n && (this._tf = new enyo.g11n.Fmts({
            locale: this.locale
        }), t = this._tf.getMonthFields()), this.setupPickers(this._tf ? this._tf.getDateFieldOrder() : "mdy"), 
        this.dayHiddenChanged(), this.monthHiddenChanged(), this.yearHiddenChanged();
        for (var e, i = this.value = this.value || new Date(), n = 0; e = t[n]; n++) this.$.monthPicker.createComponent({
            content: e,
            value: n,
            active: n == i.getMonth()
        });
        var o = i.getFullYear();
        for (this.$.yearPicker.setSelected(o - this.minYear), n = 1; this.monthLength(i.getYear(), i.getMonth()) >= n; n++) this.$.dayPicker.createComponent({
            content: n,
            value: n,
            active: n == i.getDate()
        });
    },
    monthLength: function(t, e) {
        return 32 - new Date(t, e, 32).getDate();
    },
    setupYear: function(t, e) {
        return this.$.year.setContent(this.minYear + e.index), !0;
    },
    setupPickers: function(t) {
        var e, i, n, o = t.split("");
        for (i = 0, n = o.length; n > i; i++) switch (e = o[i]) {
          case "d":
            this.createDay();
            break;

          case "m":
            this.createMonth();
            break;

          case "y":
            this.createYear();
            break;

          default:        }
    },
    createYear: function() {
        var t = this.maxYear - this.minYear;
        this.createComponent({
            kind: "onyx.PickerDecorator",
            onSelect: "updateYear",
            components: [ {
                classes: "onyx-datepicker-year",
                name: "yearPickerButton",
                disabled: this.disabled
            }, {
                name: "yearPicker",
                kind: "onyx.FlyweightPicker",
                count: ++t,
                onSetupItem: "setupYear",
                components: [ {
                    name: "year"
                } ]
            } ]
        });
    },
    createMonth: function() {
        this.createComponent({
            kind: "onyx.PickerDecorator",
            onSelect: "updateMonth",
            components: [ {
                classes: "onyx-datepicker-month",
                name: "monthPickerButton",
                disabled: this.disabled
            }, {
                name: "monthPicker",
                kind: "onyx.Picker"
            } ]
        });
    },
    createDay: function() {
        this.createComponent({
            kind: "onyx.PickerDecorator",
            onSelect: "updateDay",
            components: [ {
                classes: "onyx-datepicker-day",
                name: "dayPickerButton",
                disabled: this.disabled
            }, {
                name: "dayPicker",
                kind: "onyx.Picker"
            } ]
        });
    },
    localeChanged: function() {
        this.refresh();
    },
    dayHiddenChanged: function() {
        this.$.dayPicker.getParent().setShowing(this.dayHidden ? !1 : !0);
    },
    monthHiddenChanged: function() {
        this.$.monthPicker.getParent().setShowing(this.monthHidden ? !1 : !0);
    },
    yearHiddenChanged: function() {
        this.$.yearPicker.getParent().setShowing(this.yearHidden ? !1 : !0);
    },
    minYearChanged: function() {
        this.refresh();
    },
    maxYearChanged: function() {
        this.refresh();
    },
    valueChanged: function() {
        this.refresh();
    },
    disabledChanged: function() {
        this.$.yearPickerButton.setDisabled(this.disabled), this.$.monthPickerButton.setDisabled(this.disabled), 
        this.$.dayPickerButton.setDisabled(this.disabled);
    },
    updateDay: function(t, e) {
        var i = this.calcDate(this.value.getFullYear(), this.value.getMonth(), e.selected.value);
        return this.doSelect({
            name: this.name,
            value: i
        }), this.setValue(i), !0;
    },
    updateMonth: function(t, e) {
        var i = this.calcDate(this.value.getFullYear(), e.selected.value, this.value.getDate());
        return this.doSelect({
            name: this.name,
            value: i
        }), this.setValue(i), !0;
    },
    updateYear: function(t, e) {
        if (-1 != e.originator.selected) {
            var i = this.calcDate(this.minYear + e.originator.selected, this.value.getMonth(), this.value.getDate());
            this.doSelect({
                name: this.name,
                value: i
            }), this.setValue(i);
        }
        return !0;
    },
    calcDate: function(t, e, i) {
        return new Date(t, e, i, this.value.getHours(), this.value.getMinutes(), this.value.getSeconds(), this.value.getMilliseconds());
    },
    refresh: function() {
        this.destroyClientControls(), this.initDefaults(), this.render();
    }
});

// lib/onyx/source/TimePicker.js
enyo.kind({
    name: "onyx.TimePicker",
    classes: "onyx-toolbar-inline",
    published: {
        disabled: !1,
        locale: "en_us",
        is24HrMode: null,
        value: null
    },
    events: {
        onSelect: ""
    },
    create: function() {
        this.inherited(arguments), enyo.g11n && (this.locale = enyo.g11n.currentLocale().getLocale()), 
        this.initDefaults();
    },
    initDefaults: function() {
        var t = "AM", e = "PM";
        enyo.g11n ? (this._tf = new enyo.g11n.Fmts({
            locale: this.locale
        }), t = this._tf.getAmCaption(), e = this._tf.getPmCaption(), null == this.is24HrMode && (this.is24HrMode = !this._tf.isAmPm())) : null == this.is24HrMode && (this.is24HrMode = !1), 
        this.setupPickers(this._tf ? this._tf.getTimeFieldOrder() : "hma");
        var i, n = this.value = this.value || new Date();
        if (this.is24HrMode) for (i = 0; 24 > i; i++) this.$.hourPicker.createComponent({
            content: i,
            value: i,
            active: i == n.getHours()
        }); else {
            var o = n.getHours();
            for (o = 0 === o ? 12 : o, i = 1; 12 >= i; i++) this.$.hourPicker.createComponent({
                content: i,
                value: i,
                active: i == (o > 12 ? o % 12 : o)
            });
        }
        for (i = 0; 59 >= i; i++) this.$.minutePicker.createComponent({
            content: 10 > i ? "0" + i : i,
            value: i,
            active: i == n.getMinutes()
        });
        n.getHours() >= 12 ? this.$.ampmPicker.createComponents([ {
            content: t
        }, {
            content: e,
            active: !0
        } ]) : this.$.ampmPicker.createComponents([ {
            content: t,
            active: !0
        }, {
            content: e
        } ]), this.$.ampmPicker.getParent().setShowing(!this.is24HrMode);
    },
    setupPickers: function(t) {
        var e, i, n, o = t.split("");
        for (i = 0, n = o.length; n > i; i++) switch (e = o[i]) {
          case "h":
            this.createHour();
            break;

          case "m":
            this.createMinute();
            break;

          case "a":
            this.createAmPm();
            break;

          default:        }
    },
    createHour: function() {
        this.createComponent({
            kind: "onyx.PickerDecorator",
            onSelect: "updateHour",
            components: [ {
                classes: "onyx-timepicker-hour",
                name: "hourPickerButton",
                disabled: this.disabled
            }, {
                name: "hourPicker",
                kind: "onyx.Picker"
            } ]
        });
    },
    createMinute: function() {
        this.createComponent({
            kind: "onyx.PickerDecorator",
            onSelect: "updateMinute",
            components: [ {
                classes: "onyx-timepicker-minute",
                name: "minutePickerButton",
                disabled: this.disabled
            }, {
                name: "minutePicker",
                kind: "onyx.Picker"
            } ]
        });
    },
    createAmPm: function() {
        this.createComponent({
            kind: "onyx.PickerDecorator",
            onSelect: "updateAmPm",
            components: [ {
                classes: "onyx-timepicker-ampm",
                name: "ampmPickerButton",
                disabled: this.disabled
            }, {
                name: "ampmPicker",
                kind: "onyx.Picker"
            } ]
        });
    },
    disabledChanged: function() {
        this.$.hourPickerButton.setDisabled(this.disabled), this.$.minutePickerButton.setDisabled(this.disabled), 
        this.$.ampmPickerButton.setDisabled(this.disabled);
    },
    localeChanged: function() {
        this.is24HrMode = null, this.refresh();
    },
    is24HrModeChanged: function() {
        this.refresh();
    },
    valueChanged: function() {
        this.refresh();
    },
    updateHour: function(t, e) {
        var i = e.selected.value;
        if (!this.is24HrMode) {
            var n = this.$.ampmPicker.getParent().controlAtIndex(0).content;
            i = i + (12 == i ? -12 : 0) + (this.isAm(n) ? 0 : 12);
        }
        return this.setValue(this.calcTime(i, this.value.getMinutes())), this.doSelect({
            name: this.name,
            value: this.value
        }), !0;
    },
    updateMinute: function(t, e) {
        return this.setValue(this.calcTime(this.value.getHours(), e.selected.value)), this.doSelect({
            name: this.name,
            value: this.value
        }), !0;
    },
    updateAmPm: function(t, e) {
        var i = this.value.getHours();
        return this.is24HrMode || (i += i > 11 ? this.isAm(e.content) ? -12 : 0 : this.isAm(e.content) ? 0 : 12), 
        this.setValue(this.calcTime(i, this.value.getMinutes())), this.doSelect({
            name: this.name,
            value: this.value
        }), !0;
    },
    calcTime: function(t, e) {
        return new Date(this.value.getFullYear(), this.value.getMonth(), this.value.getDate(), t, e, this.value.getSeconds(), this.value.getMilliseconds());
    },
    isAm: function(t) {
        var e, i;
        try {
            e = this._tf.getAmCaption(), i = this._tf.getPmCaption();
        } catch (n) {
            e = "AM", i = "PM";
        }
        return t == e ? !0 : !1;
    },
    refresh: function() {
        this.destroyClientControls(), this.initDefaults(), this.render();
    }
});

// lib/onyx/source/RadioButton.js
enyo.kind({
    name: "onyx.RadioButton",
    kind: "enyo.Button",
    classes: "onyx-radiobutton"
});

// lib/onyx/source/RadioGroup.js
enyo.kind({
    name: "onyx.RadioGroup",
    kind: "enyo.Group",
    defaultKind: "onyx.RadioButton",
    highlander: !0
});

// lib/onyx/source/ToggleButton.js
enyo.kind({
    name: "onyx.ToggleButton",
    classes: "onyx-toggle-button",
    published: {
        active: !1,
        value: !1,
        onContent: "On",
        offContent: "Off",
        disabled: !1
    },
    events: {
        onChange: ""
    },
    handlers: {
        ondragstart: "dragstart",
        ondrag: "drag",
        ondragfinish: "dragfinish"
    },
    components: [ {
        name: "contentOn",
        classes: "onyx-toggle-content on"
    }, {
        name: "contentOff",
        classes: "onyx-toggle-content off"
    }, {
        classes: "onyx-toggle-button-knob"
    } ],
    create: function() {
        this.inherited(arguments), this.value = Boolean(this.value || this.active), this.onContentChanged(), 
        this.offContentChanged(), this.disabledChanged();
    },
    rendered: function() {
        this.inherited(arguments), this.updateVisualState();
    },
    updateVisualState: function() {
        this.addRemoveClass("off", !this.value), this.$.contentOn.setShowing(this.value), 
        this.$.contentOff.setShowing(!this.value), this.setActive(this.value);
    },
    valueChanged: function() {
        this.updateVisualState(), this.doChange({
            value: this.value
        });
    },
    activeChanged: function() {
        this.setValue(this.active), this.bubble("onActivate");
    },
    onContentChanged: function() {
        this.$.contentOn.setContent(this.onContent || ""), this.$.contentOn.addRemoveClass("empty", !this.onContent);
    },
    offContentChanged: function() {
        this.$.contentOff.setContent(this.offContent || ""), this.$.contentOff.addRemoveClass("empty", !this.onContent);
    },
    disabledChanged: function() {
        this.addRemoveClass("disabled", this.disabled);
    },
    updateValue: function(t) {
        this.disabled || this.setValue(t);
    },
    tap: function() {
        this.updateValue(!this.value);
    },
    dragstart: function(t, e) {
        return e.horizontal ? (e.preventDefault(), this.dragging = !0, this.dragged = !1, 
        !0) : void 0;
    },
    drag: function(t, e) {
        if (this.dragging) {
            var i = e.dx;
            return Math.abs(i) > 10 && (this.updateValue(i > 0), this.dragged = !0), !0;
        }
    },
    dragfinish: function(t, e) {
        this.dragging = !1, this.dragged && e.preventTap();
    }
});

// lib/onyx/source/ToggleIconButton.js
enyo.kind({
    name: "onyx.ToggleIconButton",
    kind: "onyx.Icon",
    published: {
        active: !1,
        value: !1
    },
    events: {
        onChange: ""
    },
    classes: "onyx-icon-button onyx-icon-toggle",
    activeChanged: function() {
        this.addRemoveClass("active", this.value), this.bubble("onActivate");
    },
    updateValue: function(t) {
        this.disabled || (this.setValue(t), this.doChange({
            value: this.value
        }));
    },
    tap: function() {
        this.updateValue(!this.value);
    },
    valueChanged: function() {
        this.setActive(this.value);
    },
    create: function() {
        this.inherited(arguments), this.value = Boolean(this.value || this.active);
    },
    rendered: function() {
        this.inherited(arguments), this.valueChanged(), this.removeClass("onyx-icon");
    }
});

// lib/onyx/source/Toolbar.js
enyo.kind({
    name: "onyx.Toolbar",
    classes: "onyx onyx-toolbar onyx-toolbar-inline",
    create: function() {
        this.inherited(arguments), this.hasClass("onyx-menu-toolbar") && enyo.platform.android >= 4 && this.applyStyle("position", "static");
    }
});

// lib/onyx/source/ProgressBar.js
enyo.kind({
    name: "onyx.ProgressBar",
    classes: "onyx-progress-bar",
    published: {
        progress: 0,
        min: 0,
        max: 100,
        barClasses: "",
        showStripes: !0,
        animateStripes: !0,
        increment: 0
    },
    events: {
        onAnimateProgressFinish: ""
    },
    components: [ {
        name: "progressAnimator",
        kind: "enyo.Animator",
        onStep: "progressAnimatorStep",
        onEnd: "progressAnimatorComplete"
    }, {
        name: "bar",
        classes: "onyx-progress-bar-bar"
    } ],
    create: function() {
        this.inherited(arguments), this.progressChanged(), this.barClassesChanged(), this.showStripesChanged(), 
        this.animateStripesChanged();
    },
    barClassesChanged: function(t) {
        this.$.bar.removeClass(t), this.$.bar.addClass(this.barClasses);
    },
    showStripesChanged: function() {
        this.$.bar.addRemoveClass("striped", this.showStripes);
    },
    animateStripesChanged: function() {
        this.$.bar.addRemoveClass("animated", this.animateStripes);
    },
    progressChanged: function() {
        this.progress = this.clampValue(this.min, this.max, this.progress);
        var t = this.calcPercent(this.progress);
        this.updateBarPosition(t);
    },
    calcIncrement: function(t) {
        return Math.round(t / this.increment) * this.increment;
    },
    clampValue: function(t, e, i) {
        return Math.max(t, Math.min(i, e));
    },
    calcRatio: function(t) {
        return (t - this.min) / (this.max - this.min);
    },
    calcPercent: function(t) {
        return 100 * this.calcRatio(t);
    },
    updateBarPosition: function(t) {
        this.$.bar.applyStyle("width", t + "%");
    },
    animateProgressTo: function(t) {
        this.$.progressAnimator.play({
            startValue: this.progress,
            endValue: t,
            node: this.hasNode()
        });
    },
    progressAnimatorStep: function(t) {
        return this.setProgress(t.value), !0;
    },
    progressAnimatorComplete: function(t) {
        return this.doAnimateProgressFinish(t), !0;
    }
});

// lib/onyx/source/ProgressButton.js
enyo.kind({
    name: "onyx.ProgressButton",
    kind: "onyx.ProgressBar",
    classes: "onyx-progress-button",
    events: {
        onCancel: ""
    },
    components: [ {
        name: "progressAnimator",
        kind: "enyo.Animator",
        onStep: "progressAnimatorStep",
        onEnd: "progressAnimatorComplete"
    }, {
        name: "bar",
        classes: "onyx-progress-bar-bar onyx-progress-button-bar"
    }, {
        name: "client",
        classes: "onyx-progress-button-client"
    }, {
        kind: "onyx.Icon",
        src: "$lib/onyx/images/progress-button-cancel.png",
        classes: "onyx-progress-button-icon",
        ontap: "cancelTap"
    } ],
    cancelTap: function() {
        this.doCancel();
    }
});

// lib/onyx/source/Scrim.js
enyo.kind({
    name: "onyx.Scrim",
    showing: !1,
    classes: "onyx-scrim enyo-fit",
    floating: !1,
    create: function() {
        this.inherited(arguments), this.zStack = [], this.floating && this.setParent(enyo.floatingLayer);
    },
    showingChanged: function() {
        this.floating && this.showing && !this.hasNode() && this.render(), this.inherited(arguments);
    },
    addZIndex: function(t) {
        0 > enyo.indexOf(t, this.zStack) && this.zStack.push(t);
    },
    removeZIndex: function(t) {
        enyo.remove(t, this.zStack);
    },
    showAtZIndex: function(t) {
        this.addZIndex(t), void 0 !== t && this.setZIndex(t), this.show();
    },
    hideAtZIndex: function(t) {
        if (this.removeZIndex(t), this.zStack.length) {
            var e = this.zStack[this.zStack.length - 1];
            this.setZIndex(e);
        } else this.hide();
    },
    setZIndex: function(t) {
        this.zIndex = t, this.applyStyle("z-index", t);
    },
    make: function() {
        return this;
    }
}), enyo.kind({
    name: "onyx.scrimSingleton",
    kind: null,
    constructor: function(t, e) {
        this.instanceName = t, enyo.setPath(this.instanceName, this), this.props = e || {};
    },
    make: function() {
        var t = new onyx.Scrim(this.props);
        return enyo.setPath(this.instanceName, t), t;
    },
    showAtZIndex: function(t) {
        var e = this.make();
        e.showAtZIndex(t);
    },
    hideAtZIndex: enyo.nop,
    show: function() {
        var t = this.make();
        t.show();
    }
}), new onyx.scrimSingleton("onyx.scrim", {
    floating: !0,
    classes: "onyx-scrim-translucent"
}), new onyx.scrimSingleton("onyx.scrimTransparent", {
    floating: !0,
    classes: "onyx-scrim-transparent"
});

// lib/onyx/source/Slider.js
enyo.kind({
    name: "onyx.Slider",
    kind: "onyx.ProgressBar",
    classes: "onyx-slider",
    published: {
        value: 0,
        lockBar: !0,
        tappable: !0
    },
    events: {
        onChange: "",
        onChanging: "",
        onAnimateFinish: ""
    },
    showStripes: !1,
    handlers: {
        ondragstart: "dragstart",
        ondrag: "drag",
        ondragfinish: "dragfinish"
    },
    moreComponents: [ {
        kind: "Animator",
        onStep: "animatorStep",
        onEnd: "animatorComplete"
    }, {
        classes: "onyx-slider-taparea"
    }, {
        name: "knob",
        classes: "onyx-slider-knob"
    } ],
    create: function() {
        this.inherited(arguments), this.moreComponents[2].ondown = "knobDown", this.moreComponents[2].onup = "knobUp", 
        this.createComponents(this.moreComponents), this.valueChanged();
    },
    valueChanged: function() {
        this.value = this.clampValue(this.min, this.max, this.value);
        var t = this.calcPercent(this.value);
        this.updateKnobPosition(t), this.lockBar && this.setProgress(this.value);
    },
    updateKnobPosition: function(t) {
        this.$.knob.applyStyle("left", t + "%");
    },
    calcKnobPosition: function(t) {
        var e = t.clientX - this.hasNode().getBoundingClientRect().left;
        return e / this.getBounds().width * (this.max - this.min) + this.min;
    },
    dragstart: function(t, e) {
        return e.horizontal ? (e.preventDefault(), this.dragging = !0, t.addClass("pressed"), 
        !0) : void 0;
    },
    drag: function(t, e) {
        if (this.dragging) {
            var i = this.calcKnobPosition(e);
            return i = this.increment ? this.calcIncrement(i) : i, this.setValue(i), this.doChanging({
                value: this.value
            }), !0;
        }
    },
    dragfinish: function(t, e) {
        return this.dragging = !1, e.preventTap(), this.doChange({
            value: this.value
        }), t.removeClass("pressed"), !0;
    },
    tap: function(t, e) {
        if (this.tappable) {
            var i = this.calcKnobPosition(e);
            return i = this.increment ? this.calcIncrement(i) : i, this.tapped = !0, this.animateTo(i), 
            !0;
        }
    },
    knobDown: function() {
        this.$.knob.addClass("pressed");
    },
    knobUp: function() {
        this.$.knob.removeClass("pressed");
    },
    animateTo: function(t) {
        this.$.animator.play({
            startValue: this.value,
            endValue: t,
            node: this.hasNode()
        });
    },
    animatorStep: function(t) {
        return this.setValue(t.value), !0;
    },
    animatorComplete: function(t) {
        return this.tapped && (this.tapped = !1, this.doChange({
            value: this.value
        })), this.doAnimateFinish(t), !0;
    }
});

// lib/onyx/source/RangeSlider.js
enyo.kind({
    name: "onyx.RangeSlider",
    kind: "onyx.ProgressBar",
    classes: "onyx-slider",
    published: {
        rangeMin: 0,
        rangeMax: 100,
        rangeStart: 0,
        rangeEnd: 100,
        beginValue: 0,
        endValue: 0
    },
    events: {
        onChange: "",
        onChanging: ""
    },
    showStripes: !1,
    showLabels: !1,
    handlers: {
        ondragstart: "dragstart",
        ondrag: "drag",
        ondragfinish: "dragfinish",
        ondown: "down"
    },
    moreComponents: [ {
        name: "startKnob",
        classes: "onyx-slider-knob"
    }, {
        name: "endKnob",
        classes: "onyx-slider-knob onyx-range-slider-knob"
    } ],
    create: function() {
        this.inherited(arguments), this.createComponents(this.moreComponents), this.initControls();
    },
    rendered: function() {
        this.inherited(arguments);
        var t = this.calcPercent(this.beginValue);
        this.updateBarPosition(t);
    },
    initControls: function() {
        this.$.bar.applyStyle("position", "relative"), this.refreshRangeSlider(), this.showLabels && (this.$.startKnob.createComponent({
            name: "startLabel",
            kind: "onyx.RangeSliderKnobLabel"
        }), this.$.endKnob.createComponent({
            name: "endLabel",
            kind: "onyx.RangeSliderKnobLabel"
        })), this.$.startKnob.ondown = "knobDown", this.$.startKnob.onup = "knobUp", this.$.endKnob.ondown = "knobDown", 
        this.$.endKnob.onup = "knobUp";
    },
    refreshRangeSlider: function() {
        this.beginValue = this.calcKnobPercent(this.rangeStart), this.endValue = this.calcKnobPercent(this.rangeEnd), 
        this.beginValueChanged(), this.endValueChanged();
    },
    calcKnobRatio: function(t) {
        return (t - this.rangeMin) / (this.rangeMax - this.rangeMin);
    },
    calcKnobPercent: function(t) {
        return 100 * this.calcKnobRatio(t);
    },
    beginValueChanged: function(t) {
        if (void 0 === t) {
            var e = this.calcPercent(this.beginValue);
            this.updateKnobPosition(e, this.$.startKnob);
        }
    },
    endValueChanged: function(t) {
        if (void 0 === t) {
            var e = this.calcPercent(this.endValue);
            this.updateKnobPosition(e, this.$.endKnob);
        }
    },
    calcKnobPosition: function(t) {
        var e = t.clientX - this.hasNode().getBoundingClientRect().left;
        return e / this.getBounds().width * (this.max - this.min) + this.min;
    },
    updateKnobPosition: function(t, e) {
        e.applyStyle("left", t + "%"), this.updateBarPosition();
    },
    updateBarPosition: function() {
        if (void 0 !== this.$.startKnob && void 0 !== this.$.endKnob) {
            var t = this.calcKnobPercent(this.rangeStart), e = this.calcKnobPercent(this.rangeEnd) - t;
            this.$.bar.applyStyle("left", t + "%"), this.$.bar.applyStyle("width", e + "%");
        }
    },
    calcRangeRatio: function(t) {
        return t / 100 * (this.rangeMax - this.rangeMin) + this.rangeMin - this.increment / 2;
    },
    swapZIndex: function(t) {
        "startKnob" === t ? (this.$.startKnob.applyStyle("z-index", 1), this.$.endKnob.applyStyle("z-index", 0)) : "endKnob" === t && (this.$.startKnob.applyStyle("z-index", 0), 
        this.$.endKnob.applyStyle("z-index", 1));
    },
    down: function(t) {
        this.swapZIndex(t.name);
    },
    dragstart: function(t, e) {
        return e.horizontal ? (e.preventDefault(), this.dragging = !0, t.addClass("pressed"), 
        !0) : void 0;
    },
    drag: function(t, e) {
        if (this.dragging) {
            var i, n, o, s = this.calcKnobPosition(e);
            if ("startKnob" === t.name && s >= 0) {
                if (!(this.endValue >= s && -1 === e.xDirection || this.endValue >= s)) return this.drag(this.$.endKnob, e);
                this.setBeginValue(s), i = this.calcRangeRatio(this.beginValue), n = this.increment ? this.calcIncrement(i + .5 * this.increment) : i, 
                o = this.calcKnobPercent(n), this.updateKnobPosition(o, this.$.startKnob), this.setRangeStart(n), 
                this.doChanging({
                    value: n
                });
            } else if ("endKnob" === t.name && 100 >= s) {
                if (!(s >= this.beginValue && 1 === e.xDirection || s >= this.beginValue)) return this.drag(this.$.startKnob, e);
                this.setEndValue(s), i = this.calcRangeRatio(this.endValue), n = this.increment ? this.calcIncrement(i + .5 * this.increment) : i, 
                o = this.calcKnobPercent(n), this.updateKnobPosition(o, this.$.endKnob), this.setRangeEnd(n), 
                this.doChanging({
                    value: n
                });
            }
            return !0;
        }
    },
    dragfinish: function(t, e) {
        this.dragging = !1, e.preventTap();
        var i;
        return "startKnob" === t.name ? (i = this.calcRangeRatio(this.beginValue), this.doChange({
            value: i,
            startChanged: !0
        })) : "endKnob" === t.name && (i = this.calcRangeRatio(this.endValue), this.doChange({
            value: i,
            startChanged: !1
        })), t.removeClass("pressed"), !0;
    },
    knobDown: function(t) {
        t.addClass("pressed");
    },
    knobUp: function(t) {
        t.removeClass("pressed");
    },
    rangeMinChanged: function() {
        this.refreshRangeSlider();
    },
    rangeMaxChanged: function() {
        this.refreshRangeSlider();
    },
    rangeStartChanged: function() {
        this.refreshRangeSlider();
    },
    rangeEndChanged: function() {
        this.refreshRangeSlider();
    },
    setStartLabel: function(t) {
        this.$.startKnob.waterfallDown("onSetLabel", t);
    },
    setEndLabel: function(t) {
        this.$.endKnob.waterfallDown("onSetLabel", t);
    }
}), enyo.kind({
    name: "onyx.RangeSliderKnobLabel",
    classes: "onyx-range-slider-label",
    handlers: {
        onSetLabel: "setLabel"
    },
    setLabel: function(t, e) {
        this.setContent(e);
    }
});

// lib/onyx/source/Item.js
enyo.kind({
    name: "onyx.Item",
    classes: "onyx-item",
    tapHighlight: !0,
    handlers: {
        onhold: "hold",
        onrelease: "release"
    },
    hold: function(t, e) {
        this.tapHighlight && onyx.Item.addRemoveFlyweightClass(this.controlParent || this, "onyx-highlight", !0, e);
    },
    release: function(t, e) {
        this.tapHighlight && onyx.Item.addRemoveFlyweightClass(this.controlParent || this, "onyx-highlight", !1, e);
    },
    statics: {
        addRemoveFlyweightClass: function(t, e, i, n, o) {
            var s = n.flyweight;
            if (s) {
                var a = void 0 !== o ? o : n.index;
                s.performOnRow(a, function() {
                    t.addRemoveClass(e, i);
                });
            }
        }
    }
});

// lib/onyx/source/Spinner.js
enyo.kind({
    name: "onyx.Spinner",
    classes: "onyx-spinner",
    stop: function() {
        this.setShowing(!1);
    },
    start: function() {
        this.setShowing(!0);
    },
    toggle: function() {
        this.setShowing(!this.getShowing());
    }
});

// lib/onyx/source/MoreToolbar.js
enyo.kind({
    name: "onyx.MoreToolbar",
    classes: "onyx-toolbar onyx-more-toolbar",
    menuClass: "",
    movedClass: "",
    layoutKind: "FittableColumnsLayout",
    noStretch: !0,
    handlers: {
        onHide: "reflow"
    },
    published: {
        clientLayoutKind: "FittableColumnsLayout"
    },
    tools: [ {
        name: "client",
        noStretch: !0,
        fit: !0,
        classes: "onyx-toolbar-inline"
    }, {
        name: "nard",
        kind: "onyx.MenuDecorator",
        showing: !1,
        onActivate: "activated",
        components: [ {
            kind: "onyx.IconButton",
            classes: "onyx-more-button"
        }, {
            name: "menu",
            kind: "onyx.Menu",
            scrolling: !1,
            classes: "onyx-more-menu"
        } ]
    } ],
    initComponents: function() {
        this.menuClass && this.menuClass.length > 0 && !this.$.menu.hasClass(this.menuClass) && this.$.menu.addClass(this.menuClass), 
        this.createChrome(this.tools), this.inherited(arguments), this.$.client.setLayoutKind(this.clientLayoutKind);
    },
    clientLayoutKindChanged: function() {
        this.$.client.setLayoutKind(this.clientLayoutKind);
    },
    reflow: function() {
        this.inherited(arguments), this.isContentOverflowing() ? (this.$.nard.show(), this.popItem() && this.reflow()) : this.tryPushItem() ? this.reflow() : this.$.menu.children.length || (this.$.nard.hide(), 
        this.$.menu.hide());
    },
    activated: function(t, e) {
        this.addRemoveClass("active", e.originator.active);
    },
    popItem: function() {
        var t = this.findCollapsibleItem();
        if (t) {
            this.movedClass && this.movedClass.length > 0 && !t.hasClass(this.movedClass) && t.addClass(this.movedClass), 
            this.$.menu.addChild(t, null);
            var e = this.$.menu.hasNode();
            return e && t.hasNode() && t.insertNodeInParent(e), !0;
        }
    },
    pushItem: function() {
        var t = this.$.menu.children, e = t[0];
        if (e) {
            this.movedClass && this.movedClass.length > 0 && e.hasClass(this.movedClass) && e.removeClass(this.movedClass), 
            this.$.client.addChild(e);
            var i = this.$.client.hasNode();
            if (i && e.hasNode()) {
                for (var n, o, s = 0; this.$.client.children.length > s; s++) {
                    var a = this.$.client.children[s];
                    if (void 0 !== a.toolbarIndex && a.toolbarIndex != s) {
                        n = a, o = s;
                        break;
                    }
                }
                if (n && n.hasNode()) {
                    e.insertNodeInParent(i, n.node);
                    var r = this.$.client.children.pop();
                    this.$.client.children.splice(o, 0, r);
                } else e.appendNodeToParent(i);
            }
            return !0;
        }
    },
    tryPushItem: function() {
        if (this.pushItem()) {
            if (!this.isContentOverflowing()) return !0;
            this.popItem();
        }
    },
    isContentOverflowing: function() {
        if (this.$.client.hasNode()) {
            var t = this.$.client.children, e = t.length && t[t.length - 1].hasNode();
            if (e) return this.$.client.reflow(), e.offsetLeft + e.offsetWidth > this.$.client.node.clientWidth;
        }
    },
    findCollapsibleItem: function() {
        for (var t, e = this.$.client.children, i = e.length - 1; t = e[i]; i--) {
            if (!t.unmoveable) return t;
            void 0 === t.toolbarIndex && (t.toolbarIndex = i);
        }
    }
});

// lib/onyx/source/IntegerPicker.js
enyo.kind({
    name: "onyx.IntegerPicker",
    kind: "onyx.Picker",
    published: {
        value: 0,
        min: 0,
        max: 9
    },
    create: function() {
        this.inherited(arguments), this.rangeChanged();
    },
    minChanged: function() {
        this.destroyClientControls(), this.rangeChanged(), this.render();
    },
    maxChanged: function() {
        this.destroyClientControls(), this.rangeChanged(), this.render();
    },
    rangeChanged: function() {
        for (var t = this.min; this.max >= t; t++) this.createComponent({
            content: t,
            active: t === this.value ? !0 : !1
        });
    },
    valueChanged: function() {
        var t = this.getClientControls(), e = t.length;
        this.value = Math.min(this.max, Math.max(this.value, this.min));
        for (var i = 0; e > i; i++) if (this.value === parseInt(t[i].content, 10)) {
            this.setSelected(t[i]);
            break;
        }
    },
    selectedChanged: function(t) {
        t && t.removeClass("selected"), this.selected && (this.selected.addClass("selected"), 
        this.doChange({
            selected: this.selected,
            content: this.selected.content
        })), this.setValue(parseInt(this.selected.content, 10));
    }
});

// lib/onyx/source/ContextualPopup.js
enyo.kind({
    name: "onyx.ContextualPopup",
    kind: "enyo.Popup",
    modal: !0,
    autoDismiss: !0,
    floating: !1,
    classes: "onyx-contextual-popup enyo-unselectable",
    published: {
        maxHeight: 100,
        scrolling: !0,
        title: void 0,
        actionButtons: []
    },
    vertFlushMargin: 60,
    horizFlushMargin: 50,
    widePopup: 200,
    longPopup: 200,
    horizBuffer: 16,
    events: {
        onTap: ""
    },
    handlers: {
        onRequestShowMenu: "requestShow",
        onRequestHideMenu: "requestHide"
    },
    components: [ {
        name: "title",
        classes: "onyx-contextual-popup-title"
    }, {
        classes: "onyx-contextual-popup-scroller",
        components: [ {
            name: "client",
            kind: "enyo.Scroller",
            vertical: "auto",
            classes: "enyo-unselectable",
            thumb: !1,
            strategyKind: "TouchScrollStrategy"
        } ]
    }, {
        name: "actionButtons",
        classes: "onyx-contextual-popup-action-buttons"
    } ],
    scrollerName: "client",
    create: function() {
        this.inherited(arguments), this.maxHeightChanged(), this.titleChanged(), this.actionButtonsChanged();
    },
    getScroller: function() {
        return this.$[this.scrollerName];
    },
    titleChanged: function() {
        this.$.title.setContent(this.title);
    },
    actionButtonsChanged: function() {
        for (var t = 0; this.actionButtons.length > t; t++) this.$.actionButtons.createComponent({
            kind: "onyx.Button",
            content: this.actionButtons[t].content,
            classes: this.actionButtons[t].classes + " onyx-contextual-popup-action-button",
            name: this.actionButtons[t].name ? this.actionButtons[t].name : "ActionButton" + t,
            index: t,
            tap: this.actionButtons[t].ontap ? this.owner.bindSafely(this.actionButtons[t].ontap) : this.bindSafely(this.tapHandler)
        });
    },
    tapHandler: function(t, e) {
        return e.actionButton = !0, e.popup = this, this.bubble("ontap", e), !0;
    },
    maxHeightChanged: function() {
        this.scrolling && this.getScroller().setMaxHeight(this.maxHeight + "px");
    },
    showingChanged: function() {
        this.inherited(arguments), this.scrolling && this.getScroller().setShowing(this.showing), 
        this.adjustPosition();
    },
    requestShow: function(t, e) {
        var i = e.activator.hasNode();
        return i && (this.activatorOffset = this.getPageOffset(i)), this.show(), !0;
    },
    applyPosition: function(t) {
        var e = "";
        for (var i in t) e += i + ":" + t[i] + (isNaN(t[i]) ? "; " : "px; ");
        this.addStyles(e);
    },
    getPageOffset: function(t) {
        var e = this.getBoundingRect(t), i = void 0 === window.pageYOffset ? document.documentElement.scrollTop : window.pageYOffset, n = void 0 === window.pageXOffset ? document.documentElement.scrollLeft : window.pageXOffset, o = void 0 === e.height ? e.bottom - e.top : e.height, s = void 0 === e.width ? e.right - e.left : e.width;
        return {
            top: e.top + i,
            left: e.left + n,
            height: o,
            width: s
        };
    },
    adjustPosition: function() {
        if (this.showing && this.hasNode()) {
            this.resetPositioning();
            var t = this.getViewWidth(), e = this.getViewHeight(), i = this.vertFlushMargin, n = e - this.vertFlushMargin, o = this.horizFlushMargin, s = t - this.horizFlushMargin;
            if (i > this.activatorOffset.top + this.activatorOffset.height || this.activatorOffset.top > n) {
                if (this.applyVerticalFlushPositioning(o, s)) return;
                if (this.applyHorizontalFlushPositioning(o, s)) return;
                if (this.applyVerticalPositioning()) return;
            } else if ((o > this.activatorOffset.left + this.activatorOffset.width || this.activatorOffset.left > s) && this.applyHorizontalPositioning()) return;
            var a = this.getBoundingRect(this.node);
            if (a.width > this.widePopup) {
                if (this.applyVerticalPositioning()) return;
            } else if (a.height > this.longPopup && this.applyHorizontalPositioning()) return;
            if (this.applyVerticalPositioning()) return;
            if (this.applyHorizontalPositioning()) return;
        }
    },
    initVerticalPositioning: function() {
        this.resetPositioning(), this.addClass("vertical");
        var t = this.getBoundingRect(this.node), e = this.getViewHeight();
        return this.floating ? e / 2 > this.activatorOffset.top ? (this.applyPosition({
            top: this.activatorOffset.top + this.activatorOffset.height,
            bottom: "auto"
        }), this.addClass("below")) : (this.applyPosition({
            top: this.activatorOffset.top - t.height,
            bottom: "auto"
        }), this.addClass("above")) : t.top + t.height > e && e - t.bottom < t.top - t.height ? this.addClass("above") : this.addClass("below"), 
        t = this.getBoundingRect(this.node), t.top + t.height > e || 0 > t.top ? !1 : !0;
    },
    applyVerticalPositioning: function() {
        if (!this.initVerticalPositioning()) return !1;
        var t = this.getBoundingRect(this.node), e = this.getViewWidth();
        if (this.floating) {
            var i = this.activatorOffset.left + this.activatorOffset.width / 2 - t.width / 2;
            i + t.width > e ? (this.applyPosition({
                left: this.activatorOffset.left + this.activatorOffset.width - t.width
            }), this.addClass("left")) : 0 > i ? (this.applyPosition({
                left: this.activatorOffset.left
            }), this.addClass("right")) : this.applyPosition({
                left: i
            });
        } else {
            var n = this.activatorOffset.left + this.activatorOffset.width / 2 - t.left - t.width / 2;
            t.right + n > e ? (this.applyPosition({
                left: this.activatorOffset.left + this.activatorOffset.width - t.right
            }), this.addRemoveClass("left", !0)) : 0 > t.left + n ? this.addRemoveClass("right", !0) : this.applyPosition({
                left: n
            });
        }
        return !0;
    },
    applyVerticalFlushPositioning: function(t, e) {
        if (!this.initVerticalPositioning()) return !1;
        var i = this.getBoundingRect(this.node), n = this.getViewWidth();
        return t > this.activatorOffset.left + this.activatorOffset.width / 2 ? (this.activatorOffset.left + this.activatorOffset.width / 2 < this.horizBuffer ? this.applyPosition({
            left: this.horizBuffer + (this.floating ? 0 : -i.left)
        }) : this.applyPosition({
            left: this.activatorOffset.width / 2 + (this.floating ? this.activatorOffset.left : 0)
        }), this.addClass("right"), this.addClass("corner"), !0) : this.activatorOffset.left + this.activatorOffset.width / 2 > e ? (this.activatorOffset.left + this.activatorOffset.width / 2 > n - this.horizBuffer ? this.applyPosition({
            left: n - this.horizBuffer - i.right
        }) : this.applyPosition({
            left: this.activatorOffset.left + this.activatorOffset.width / 2 - i.right
        }), this.addClass("left"), this.addClass("corner"), !0) : !1;
    },
    initHorizontalPositioning: function() {
        this.resetPositioning();
        var t = this.getBoundingRect(this.node), e = this.getViewWidth();
        return this.floating ? e / 2 > this.activatorOffset.left + this.activatorOffset.width ? (this.applyPosition({
            left: this.activatorOffset.left + this.activatorOffset.width
        }), this.addRemoveClass("left", !0)) : (this.applyPosition({
            left: this.activatorOffset.left - t.width
        }), this.addRemoveClass("right", !0)) : this.activatorOffset.left - t.width > 0 ? (this.applyPosition({
            left: this.activatorOffset.left - t.left - t.width
        }), this.addRemoveClass("right", !0)) : (this.applyPosition({
            left: this.activatorOffset.width
        }), this.addRemoveClass("left", !0)), this.addRemoveClass("horizontal", !0), t = this.getBoundingRect(this.node), 
        0 > t.left || t.left + t.width > e ? !1 : !0;
    },
    applyHorizontalPositioning: function() {
        if (!this.initHorizontalPositioning()) return !1;
        var t = this.getBoundingRect(this.node), e = this.getViewHeight(), i = this.activatorOffset.top + this.activatorOffset.height / 2;
        return this.floating ? i >= e / 2 - .05 * e && e / 2 + .05 * e >= i ? this.applyPosition({
            top: this.activatorOffset.top + this.activatorOffset.height / 2 - t.height / 2,
            bottom: "auto"
        }) : e / 2 > this.activatorOffset.top + this.activatorOffset.height ? (this.applyPosition({
            top: this.activatorOffset.top - this.activatorOffset.height,
            bottom: "auto"
        }), this.addRemoveClass("high", !0)) : (this.applyPosition({
            top: this.activatorOffset.top - t.height + 2 * this.activatorOffset.height,
            bottom: "auto"
        }), this.addRemoveClass("low", !0)) : i >= e / 2 - .05 * e && e / 2 + .05 * e >= i ? this.applyPosition({
            top: (this.activatorOffset.height - t.height) / 2
        }) : e / 2 > this.activatorOffset.top + this.activatorOffset.height ? (this.applyPosition({
            top: -this.activatorOffset.height
        }), this.addRemoveClass("high", !0)) : (this.applyPosition({
            top: t.top - t.height - this.activatorOffset.top + this.activatorOffset.height
        }), this.addRemoveClass("low", !0)), !0;
    },
    applyHorizontalFlushPositioning: function(t, e) {
        if (!this.initHorizontalPositioning()) return !1;
        var i = this.getBoundingRect(this.node), n = this.getViewHeight();
        return this.floating ? n / 2 > this.activatorOffset.top ? (this.applyPosition({
            top: this.activatorOffset.top + this.activatorOffset.height / 2
        }), this.addRemoveClass("high", !0)) : (this.applyPosition({
            top: this.activatorOffset.top + this.activatorOffset.height / 2 - i.height
        }), this.addRemoveClass("low", !0)) : i.top + i.height > n && n - i.bottom < i.top - i.height ? (this.applyPosition({
            top: i.top - i.height - this.activatorOffset.top - this.activatorOffset.height / 2
        }), this.addRemoveClass("low", !0)) : (this.applyPosition({
            top: this.activatorOffset.height / 2
        }), this.addRemoveClass("high", !0)), t > this.activatorOffset.left + this.activatorOffset.width ? (this.addClass("left"), 
        this.addClass("corner"), !0) : this.activatorOffset.left > e ? (this.addClass("right"), 
        this.addClass("corner"), !0) : !1;
    },
    getBoundingRect: function(t) {
        var e = t.getBoundingClientRect();
        return e.width && e.height ? e : {
            left: e.left,
            right: e.right,
            top: e.top,
            bottom: e.bottom,
            width: e.right - e.left,
            height: e.bottom - e.top
        };
    },
    getViewHeight: function() {
        return void 0 === window.innerHeight ? document.documentElement.clientHeight : window.innerHeight;
    },
    getViewWidth: function() {
        return void 0 === window.innerWidth ? document.documentElement.clientWidth : window.innerWidth;
    },
    resetPositioning: function() {
        this.removeClass("right"), this.removeClass("left"), this.removeClass("high"), this.removeClass("low"), 
        this.removeClass("corner"), this.removeClass("below"), this.removeClass("above"), 
        this.removeClass("vertical"), this.removeClass("horizontal"), this.applyPosition({
            left: "auto"
        }), this.applyPosition({
            top: "auto"
        });
    },
    resizeHandler: function() {
        this.inherited(arguments), this.adjustPosition();
    },
    requestHide: function() {
        this.setShowing(!1);
    }
});

// lib/canvas/version.js
enyo && enyo.version && (enyo.version.canvas = "2.3.0-rc.1");

// lib/canvas/Canvas.js
enyo.kind({
    name: "enyo.Canvas",
    kind: enyo.Control,
    tag: "canvas",
    attributes: {
        width: 500,
        height: 500
    },
    defaultKind: "enyo.canvas.Control",
    generateInnerHtml: function() {
        return "";
    },
    teardownChildren: function() {},
    rendered: function() {
        this.renderChildren();
    },
    addChild: function() {
        enyo.UiComponent.prototype.addChild.apply(this, arguments);
    },
    removeChild: function() {
        enyo.UiComponent.prototype.removeChild.apply(this, arguments);
    },
    renderChildren: function(t) {
        var e = t, i = this.hasNode();
        if (e || i.getContext && (e = i.getContext("2d")), e) for (var n, o = 0; n = this.children[o]; o++) n.render(e);
    },
    update: function() {
        var t = this.hasNode();
        if (t.getContext) {
            var e = t.getContext("2d"), i = this.getBounds();
            e.clearRect(0, 0, i.width, i.height), this.renderChildren(e);
        }
    }
});

// lib/canvas/CanvasControl.js
enyo.kind({
    name: "enyo.canvas.Control",
    kind: enyo.UiComponent,
    defaultKind: "enyo.canvas.Control",
    published: {
        bounds: null
    },
    events: {
        onRender: ""
    },
    constructor: function() {
        this.bounds = {
            l: enyo.irand(400),
            t: enyo.irand(400),
            w: enyo.irand(100),
            h: enyo.irand(100)
        }, this.inherited(arguments);
    },
    importProps: function(t) {
        this.inherited(arguments), t && t.bounds && (enyo.mixin(this.bounds, t.bounds), 
        delete t.bounds);
    },
    renderSelf: function(t) {
        this.doRender({
            context: t
        });
    },
    render: function(t) {
        this.children.length ? this.renderChildren(t) : this.renderSelf(t);
    },
    renderChildren: function(t) {
        for (var e, i = 0; e = this.children[i]; i++) e.render(t);
    }
});

// lib/canvas/Shape.js
enyo.kind({
    name: "enyo.canvas.Shape",
    kind: enyo.canvas.Control,
    published: {
        color: "red",
        outlineColor: ""
    },
    fill: function(t) {
        t.fill();
    },
    outline: function(t) {
        t.stroke();
    },
    draw: function(t) {
        this.color && (t.fillStyle = this.color, this.fill(t)), this.outlineColor && (t.strokeStyle = this.outlineColor, 
        this.outline(t));
    }
});

// lib/canvas/Circle.js
enyo.kind({
    name: "enyo.canvas.Circle",
    kind: enyo.canvas.Shape,
    renderSelf: function(t) {
        t.beginPath(), t.arc(this.bounds.l, this.bounds.t, this.bounds.w, 0, 2 * Math.PI), 
        this.draw(t);
    }
});

// lib/canvas/Rectangle.js
enyo.kind({
    name: "enyo.canvas.Rectangle",
    kind: enyo.canvas.Shape,
    published: {
        clear: !1
    },
    renderSelf: function(t) {
        this.clear ? t.clearRect(this.bounds.l, this.bounds.t, this.bounds.w, this.bounds.h) : this.draw(t);
    },
    fill: function(t) {
        t.fillRect(this.bounds.l, this.bounds.t, this.bounds.w, this.bounds.h);
    },
    outline: function(t) {
        t.strokeRect(this.bounds.l, this.bounds.t, this.bounds.w, this.bounds.h);
    }
});

// lib/canvas/Text.js
enyo.kind({
    name: "enyo.canvas.Text",
    kind: enyo.canvas.Shape,
    published: {
        text: "",
        font: "12pt Arial",
        align: "left"
    },
    renderSelf: function(t) {
        t.textAlign = this.align, t.font = this.font, this.draw(t);
    },
    fill: function(t) {
        t.fillText(this.text, this.bounds.l, this.bounds.t);
    },
    outline: function(t) {
        t.strokeText(this.text, this.bounds.l, this.bounds.t);
    }
});

// lib/canvas/Image.js
enyo.kind({
    name: "enyo.canvas.Image",
    kind: enyo.canvas.Control,
    published: {
        src: ""
    },
    create: function() {
        this.image = new Image(), this.inherited(arguments), this.srcChanged();
    },
    srcChanged: function() {
        this.src && (this.image.src = this.src);
    },
    renderSelf: function(t) {
        t.drawImage(this.image, this.bounds.l, this.bounds.t);
    }
});

// lib/canvas/Line.js
enyo.kind({
    name: "enyo.canvas.Line",
    kind: enyo.canvas.Shape,
    renderSelf: function(t) {
        t.save(), t.beginPath(), t.strokeStyle = this.bounds.Style, t.lineWidth = this.bounds.width, 
        t.lineCap = this.bounds.cap, t.moveTo(this.bounds.start_x, this.bounds.start_y), 
        t.lineTo(this.bounds.finish_x, this.bounds.finish_y), t.stroke(), t.restore();
    }
});

// source/global.js
function saveSettings() {
    document.cookie = "settings=" + JSON.stringify(SETTINGS);
}

function loadSettings() {
    console.log(document.cookie);
    var t = document.cookie.split("=")[1];
    t && (SETTINGS = JSON.parse(t), console.log(SETTINGS));
}

function parseGPX(t) {
    if (window.DOMParser) {
        console.log("XML parser!"), this.parser = new DOMParser(), this.xmlDoc = this.parser.parseFromString(t, "text/xml");
        var e = this.xmlDoc.getElementsByTagName("trkpt");
        if (1 > e.length && (console.log("Cannot find 'trkpt' entries, trying to find 'route points'"), 
        e = this.xmlDoc.getElementsByTagName("rtept")), 1 > e.length && (console.log("Cannot find 'rtept' entries, trying to find 'waypoints'"), 
        e = this.xmlDoc.getElementsByTagName("wpt")), 1 > e.length) return console.log("Cannot find waypoints. Break"), 
        0;
        console.log("found %i points", e.length), POINTS = [], TRACK = [];
        for (var i = 0; e.length > i; i++) {
            for (var n = 0, o = 0, s = 0; e[i].attributes.length > s; s++) "LAT" === e[i].attributes[s].name.toUpperCase() ? n = e[i].attributes[s].value : "LON" === e[i].attributes[s].name.toUpperCase() && (o = e[i].attributes[s].value);
            var a = new Target(n, o);
            a.oid = i, TRACK.push(a);
        }
        if (console.log("Track simplification..."), simpleTrack(TRACK, 1), POINTS = POINTS.concat(TRACK), 
        simpleTrack(POINTS), console.log("Done. " + POINTS.length + " turns left"), console.log("Done. " + TRACK.length + " points in track left"), 
        POINTS[0]) {
            var r = calcDistance(1, TRACK[0].point);
            MUL = r.lon / r.lat;
        }
        return NUMPOINTS = POINTS.length;
    }
}

function toHuman(t) {
    return 1024 >= t ? t : t > 1024 && 1048576 > t ? (t / 1024).toFixed(2) + " Kb" : (t / 1024 / 1024).toFixed(2) + " Mb";
}

function calcDistance(t, e) {
    e || (e = LOCATION);
    var i = t / 111, n = t / (111 * Math.cos(e.lat * Math.PI / 180));
    return {
        lat: i,
        lon: n
    };
}

var POINTS = [], FILES = [], TRACK = [], LOCATION = new Point(0, 0), DIRECTION = new Point(1, 0), ANGLE_DIRECTION, WRONGDIRECTION = 0, NUMPOINTS = 0, CURPOINT = 0, MUL = 1, REQUEST = "http://api.openstreetmap.org/api/0.6/notes.json?bbox=" + (LOCATION.lon - 1) + "," + (LOCATION.lat - 1) + "," + (LOCATION.lon + 1) + "," + (LOCATION.lat + 1) + "&closed=0", VERSION = "v0.3.51", PAYPAL_BUTTON = '<a href="https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=7CNM3U9DVEGDS&lc=RU&item_name=Shura0&item_number=geobug_mozilla&currency_code=USD&bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted" target=_blank><img src="https://www.paypalobjects.com/en_US/RU/i/btn/btn_donateCC_LG.gif"></a>', ABOUT_TEXT = '<div style="text-align:center"><b>Track Giude ' + VERSION + '</b><br></div><div>The program is written by Alexander Zaitsev <a href="mailto:shura0@yandex.ru">shura0@yandex.ru</a> and distributed under BSD license.<br>If you like the program please donate<br></div><div style="text-align:center">' + PAYPAL_BUTTON + "</div>", SETTINGS = {}, DISPLAYMODE = "alwayson", SHIFT = new Point(0, 0);

cloneObject = function(t) {
    for (i in t) this[i] = "source" == typeof t[i] ? new cloneObject(t[i]) : t[i];
};

// source/osmutil.js
function getMap(t, e) {
    function i() {
        var t = [];
        for (I = 0, r = 0; s.length > r; r++) {
            h = s[r];
            var i = 0;
            if (MAP && MAP.hashes) for (var n = 0; MAP.hashes.length > n; n++) if (MAP.hashes[n] === s[r].hash) {
                i = 1, console.log("cache hit");
                break;
            }
            if (i) I++; else {
                console.log("Cache miss. Hash=" + h.hash);
                var o = "http://api.openstreetmap.org/api/0.6/map?bbox=" + h.lon1 + "," + h.lat1 + "," + h.lon2 + "," + h.lat2, a = new XMLHttpRequest();
                a.onreadystatechange = g, a.id = r, a.request = s[r], t.push(a);
            }
        }
        1 > t.length ? e(1, 1) : newData = 1;
        for (var r = 0; t.length > r; r++) {
            var h = t[r].request;
            console.log("hash=" + h.hash), o = "http://api.openstreetmap.org/api/0.6/map?bbox=" + h.lon1 + "," + h.lat1 + "," + h.lon2 + "," + h.lat2, 
            t[r].open("GET", o, !0), t[r].send();
        }
    }
    var n = {};
    MAP = 0, newData = 0, t[0] && (n.lat1 = n.lat2 = Number(t[0].point.lat), n.lon1 = n.lon2 = Number(t[0].point.lon)), 
    n.lat1 = Number(n.lat1), n.lat2 = Number(n.lat2), n.lon1 = Number(n.lon1), n.lon2 = Number(n.lon2);
    for (var o = 1; t.length > o; o++) d = t[o].point, d.lat = Number(d.lat), d.lon = Number(d.lon), 
    d.lat < n.lat1 && (n.lat1 = d.lat), d.lon < n.lon1 && (n.lon1 = d.lon), d.lat > n.lat2 && (n.lat2 = d.lat), 
    d.lon > n.lon2 && (n.lon2 = d.lon);
    console.log("bbox="), n.lat1 = Number(Number(n.lat1).toFixed(2)), n.lat2 = Number(Number(n.lat2).toFixed(2)), 
    n.lon1 = Number(Number(n.lon1).toFixed(2)), n.lon2 = Number(Number(n.lon2).toFixed(2)), 
    console.log(n);
    var s = [], a = calcDistance(.5, t[0].point);
    a.lat = Number(a.lat.toFixed(4)), a.lon = Number(a.lon.toFixed(4)), console.log(a);
    for (var r = n.lat1; n.lat2 + 2 * a.lat > r; r += a.lat) for (var h = n.lon1; n.lon2 + 2 * a.lon > h; h += a.lon) {
        var l = {};
        l.lat1 = r - a.lat, l.lat2 = r, l.lon1 = h - a.lon, l.lon2 = h, l.hash = l.lat1.toFixed(4) + "_" + l.lon1.toFixed(4), 
        s.push(l);
    }
    for (console.log("needed " + s.length + " requests"), o = 0; t.length > o; o++) {
        var d = t[o].point;
        d.lat = Number(d.lat), d.lon = Number(d.lon);
        for (var c = 0; s.length > c; c++) {
            var u = s[c];
            d.lat > u.lat1 && d.lat < u.lat2 && d.lon > u.lon1 && d.lon < u.lon2 && (s[c].valid = 1);
        }
    }
    for (o = 0; s.length > o; o++) s[o].valid || (s.splice(o, 1), o--);
    console.log("trying to get cache");
    var g = function(t) {
        if (4 === t.target.readyState) if (200 === t.target.status) {
            I++;
            var i = t.target.request;
            if (!i) {
                console.log("Seems like it's google chrome. God save the following code");
                var n = t.target.responseXML.URL.match(/bbox=([\d\.]+),([\d\.]+)/);
                console.log(n), i = {}, i.hash = n[1] + "_" + n[2];
            }
            var o = t.target.responseText, a = osm2geo(o);
            if (console.log("r=" + i.hash), MAP) for (var r = MAP.features, h = a.features, l = 0; h.length > l; l++) {
                for (var d = 0, c = 0; r.length > c; c++) if (r[c].id === h[l].id) {
                    d = 1;
                    break;
                }
                d || MAP.features.push(h[l]);
            } else MAP = a, MAP.hashes = [], MAP.hashes.push(i.hash);
            MAP.hashes.push(i.hash), e(I, s.length), console.log("downloaded chunk " + I + "/" + s.length), 
            console.log("MAP objects:" + MAP.features.length);
        } else switch (t.target.status) {
          case 0:
            console.log("Cannot connect to the server");
            break;

          default:
            console.log(t.target.statusText);
        }
    };
    if (navigator.getDeviceStorage) {
        var p = navigator.getDeviceStorage("sdcard"), f = p.get("trackguide.mapchache");
        f.onsuccess = function() {
            var t = this.result.name;
            console.log('File "' + t + '" successfully retrieved from the sd card storage area');
            var e = new FileReader();
            e.readAsText(this.result), e.onload = function() {
                MAP = JSON.parse(this.result), i();
            }, e.onerror = function() {
                console.log("Cannot read file"), i();
            };
        }, f.onerror = function() {
            console.warn("Unable to get the file: " + this.error), i();
        };
    } else i();
    console.log("valid requests: " + s.length);
}

function doneMapDownloading() {
    if (navigator.getDeviceStorage && newData) {
        var t = navigator.getDeviceStorage("sdcard"), e = t.delete("trackguide.mapchache");
        e.onsuccess = function() {
            var e = new Blob([ JSON.stringify(MAP) ], {
                type: "text/plain"
            }), i = t.addNamed(e, "trackguide.mapchache");
            i.onsuccess = function() {
                var t = this.result;
                done(MAP), console.log('File "' + t + '" successfully wrote on the sdcard storage area');
            }, i.onerror = function() {
                console.warn("Unable to write the file: " + this.error), done(MAP);
            };
        }, e.onerror = function() {
            console.log("Unable to delete the file: " + this.error);
            var e = new Blob([ JSON.stringify(MAP) ], {
                type: "text/plain"
            }), i = t.addNamed(e, "trackguide.mapchache");
            i.onsuccess = function() {
                var t = this.result;
                done(MAP), console.log('File "' + t + '" successfully wrote on the sdcard storage area');
            }, i.onerror = function() {
                console.warn("Unable to write the file: " + this.error), done(MAP);
            };
        };
    } else done(MAP);
}

var I = 0, MAP, newData = 0;

// source/track.js
var filedata1 = '<?xml version="1.0"?><gpx version="1.0" ><trk hidden="hidden">  <name>2013-08-08T16:34:11Z</name>  <trkseg>  <trkpt lat="56.008018493999998" lon="37.824569701999998">    <time>2013-08-08T16:34:11Z</time>  </trkpt>  <trkpt lat="56.007911682" lon="37.824733733999999">    <time>2013-08-08T16:34:14Z</time>  </trkpt>  <trkpt lat="56.0078125" lon="37.824859619000001">    <time>2013-08-08T16:34:17Z</time>  </trkpt>  <trkpt lat="56.007762909" lon="37.824886321999998">    <time>2013-08-08T16:34:21Z</time>  </trkpt>  <trkpt lat="56.007717133" lon="37.824871063000003">    <time>2013-08-08T16:34:24Z</time>  </trkpt>  <trkpt lat="56.007690429999997" lon="37.824966431">    <time>2013-08-08T16:34:27Z</time>  </trkpt>  <trkpt lat="56.007663727000001" lon="37.825130463000001">    <time>2013-08-08T16:34:30Z</time>  </trkpt>  <trkpt lat="56.007587432999998" lon="37.825305939000003">    <time>2013-08-08T16:34:33Z</time>  </trkpt>  <trkpt lat="56.007503509999999" lon="37.825485229000002">    <time>2013-08-08T16:34:36Z</time>  </trkpt>  <trkpt lat="56.007415770999998" lon="37.825622559000003">    <time>2013-08-08T16:34:39Z</time>  </trkpt>  <trkpt lat="56.007316588999998" lon="37.825794219999999">    <time>2013-08-08T16:34:42Z</time>  </trkpt>  <trkpt lat="56.007228851000001" lon="37.825962066999999">    <time>2013-08-08T16:34:45Z</time>  </trkpt>  <trkpt lat="56.007148743000002" lon="37.826148987000003">    <time>2013-08-08T16:34:48Z</time>  </trkpt>  <trkpt lat="56.007064819" lon="37.826366425000003">    <time>2013-08-08T16:34:51Z</time>  </trkpt>  <trkpt lat="56.006984711000001" lon="37.826576232999997">    <time>2013-08-08T16:34:54Z</time>  </trkpt>  <trkpt lat="56.006908416999998" lon="37.826793670999997">    <time>2013-08-08T16:34:57Z</time>  </trkpt>  <trkpt lat="56.006839751999998" lon="37.827030182000001">    <time>2013-08-08T16:35:00Z</time>  </trkpt>  <trkpt lat="56.006763458000002" lon="37.827308655000003">    <time>2013-08-08T16:35:03Z</time>  </trkpt>  <trkpt lat="56.006671906000001" lon="37.827632903999998">    <time>2013-08-08T16:35:06Z</time>  </trkpt>  <trkpt lat="56.006599426000001" lon="37.827934265000003">    <time>2013-08-08T16:35:09Z</time>  </trkpt>  <trkpt lat="56.006519318000002" lon="37.828250885000003">    <time>2013-08-08T16:35:12Z</time>  </trkpt>  <trkpt lat="56.006443023999999" lon="37.828552246000001">    <time>2013-08-08T16:35:15Z</time>  </trkpt>  <trkpt lat="56.006355286000002" lon="37.828804015999999">    <time>2013-08-08T16:35:18Z</time>  </trkpt>  <trkpt lat="56.006240845000001" lon="37.829010009999998">    <time>2013-08-08T16:35:21Z</time>  </trkpt>  <trkpt lat="56.006072998" lon="37.829196930000002">    <time>2013-08-08T16:35:24Z</time>  </trkpt>  <trkpt lat="56.005878447999997" lon="37.829273223999998">    <time>2013-08-08T16:35:27Z</time>  </trkpt>  <trkpt lat="56.005683898999997" lon="37.829330444">    <time>2013-08-08T16:35:30Z</time>  </trkpt>  <trkpt lat="56.005474091000004" lon="37.829418181999998">    <time>2013-08-08T16:35:33Z</time>  </trkpt>  <trkpt lat="56.005260468000003" lon="37.829505920000003">    <time>2013-08-08T16:35:36Z</time>  </trkpt>  <trkpt lat="56.005039214999996" lon="37.829612732000001">    <time>2013-08-08T16:35:39Z</time>  </trkpt>  <trkpt lat="56.004787444999998" lon="37.829704284999998">    <time>2013-08-08T16:35:42Z</time>  </trkpt>  <trkpt lat="56.004508972000004" lon="37.829830170000001">    <time>2013-08-08T16:35:45Z</time>  </trkpt>  <trkpt lat="56.004203795999999" lon="37.829986572000003">    <time>2013-08-08T16:35:48Z</time>  </trkpt>  <trkpt lat="56.003890990999999" lon="37.830142975000001">    <time>2013-08-08T16:35:51Z</time>  </trkpt>  <trkpt lat="56.003582000999998" lon="37.830287933000001">    <time>2013-08-08T16:35:54Z</time>  </trkpt>  <trkpt lat="56.003299712999997" lon="37.830444335999999">    <time>2013-08-08T16:35:57Z</time>  </trkpt>  <trkpt lat="56.003032683999997" lon="37.830566406000003">    <time>2013-08-08T16:36:00Z</time>  </trkpt>  <trkpt lat="56.002780913999999" lon="37.830638884999999">    <time>2013-08-08T16:36:03Z</time>  </trkpt>  <trkpt lat="56.002502440999997" lon="37.830715179000002">    <time>2013-08-08T16:36:06Z</time>  </trkpt>  <trkpt lat="56.002201079999999" lon="37.830772400000001">    <time>2013-08-08T16:36:09Z</time>  </trkpt>  <trkpt lat="56.001895904999998" lon="37.830825806">    <time>2013-08-08T16:36:12Z</time>  </trkpt>  <trkpt lat="56.001609801999997" lon="37.830852509000003">    <time>2013-08-08T16:36:15Z</time>  </trkpt>  <trkpt lat="56.001335144000002" lon="37.830883026000002">    <time>2013-08-08T16:36:18Z</time>  </trkpt>  <trkpt lat="56.001068115000002" lon="37.830890656000001">    <time>2013-08-08T16:36:21Z</time>  </trkpt>  <trkpt lat="56.000801086000003" lon="37.830886841000002">    <time>2013-08-08T16:36:24Z</time>  </trkpt>  <trkpt lat="56.000549315999997" lon="37.830898285000004">    <time>2013-08-08T16:36:27Z</time>  </trkpt>  <trkpt lat="56.000293732000003" lon="37.830894469999997">    <time>2013-08-08T16:36:30Z</time>  </trkpt>  <trkpt lat="56.000038146999998" lon="37.830871582">    <time>2013-08-08T16:36:33Z</time>  </trkpt>  <trkpt lat="55.999790191999999" lon="37.830848693999997">    <time>2013-08-08T16:36:36Z</time>  </trkpt>  <trkpt lat="55.999542236000003" lon="37.830829620000003">    <time>2013-08-08T16:36:39Z</time>  </trkpt>  <trkpt lat="55.99930191" lon="37.830806731999999">    <time>2013-08-08T16:36:42Z</time>  </trkpt>  <trkpt lat="55.999073029000002" lon="37.830776215">    <time>2013-08-08T16:36:45Z</time>  </trkpt>  <trkpt lat="55.998847961000003" lon="37.830738068000002">    <time>2013-08-08T16:36:48Z</time>  </trkpt>  <trkpt lat="55.998638153000002" lon="37.830680847000004">    <time>2013-08-08T16:36:51Z</time>  </trkpt>  <trkpt lat="55.998432158999996" lon="37.830581664999997">    <time>2013-08-08T16:36:54Z</time>  </trkpt>  <trkpt lat="55.998226166000002" lon="37.830486297999997">    <time>2013-08-08T16:36:57Z</time>  </trkpt>  <trkpt lat="55.998016356999997" lon="37.830375670999999">    <time>2013-08-08T16:37:00Z</time>  </trkpt>  <trkpt lat="55.997810364000003" lon="37.830242157000001">    <time>2013-08-08T16:37:03Z</time>  </trkpt>  <trkpt lat="55.997600554999998" lon="37.830116271999998">    <time>2013-08-08T16:37:06Z</time>  </trkpt>  <trkpt lat="55.997394561999997" lon="37.829975128000001">    <time>2013-08-08T16:37:09Z</time>  </trkpt>  <trkpt lat="55.997196197999997" lon="37.829849242999998">    <time>2013-08-08T16:37:12Z</time>  </trkpt>  <trkpt lat="55.996997833000002" lon="37.829734801999997">    <time>2013-08-08T16:37:15Z</time>  </trkpt>  <trkpt lat="55.996803284000002" lon="37.829608917000002">    <time>2013-08-08T16:37:18Z</time>  </trkpt>  <trkpt lat="55.996616363999998" lon="37.829494476000001">    <time>2013-08-08T16:37:21Z</time>  </trkpt>  <trkpt lat="55.996433258000003" lon="37.829391479000002">    <time>2013-08-08T16:37:24Z</time>  </trkpt>  <trkpt lat="55.996307373" lon="37.829154967999997">    <time>2013-08-08T16:37:27Z</time>  </trkpt>  <trkpt lat="55.996257782000001" lon="37.828842162999997">    <time>2013-08-08T16:37:30Z</time>  </trkpt>  <trkpt lat="55.996250152999998" lon="37.828498840000002">    <time>2013-08-08T16:37:33Z</time>  </trkpt>  <trkpt lat="55.996246337999999" lon="37.828186035000002">    <time>2013-08-08T16:37:36Z</time>  </trkpt>  <trkpt lat="55.996227263999998" lon="37.827877045000001">    <time>2013-08-08T16:37:39Z</time>  </trkpt>  <trkpt lat="55.996196746999999" lon="37.827571869000003">    <time>2013-08-08T16:37:42Z</time>  </trkpt>  <trkpt lat="55.996131896999998" lon="37.827297211000001">    <time>2013-08-08T16:37:45Z</time>  </trkpt>  <trkpt lat="55.996006012000002" lon="37.827110290999997">    <time>2013-08-08T16:37:48Z</time>  </trkpt>  <trkpt lat="55.995864867999998" lon="37.826915741000001">    <time>2013-08-08T16:37:51Z</time>  </trkpt>  <trkpt lat="55.995727539000001" lon="37.826953887999998">    <time>2013-08-08T16:37:54Z</time>  </trkpt>  <trkpt lat="55.995628357000001" lon="37.827129364000001">    <time>2013-08-08T16:37:57Z</time>  </trkpt>  <trkpt lat="55.995552062999998" lon="37.827384948999999">    <time>2013-08-08T16:38:00Z</time>  </trkpt>  <trkpt lat="55.995471954000003" lon="37.827629088999998">    <time>2013-08-08T16:38:03Z</time>  </trkpt>  <trkpt lat="55.99539566" lon="37.827877045000001">    <time>2013-08-08T16:38:06Z</time>  </trkpt>  <trkpt lat="55.995338439999998" lon="37.828117370999998">    <time>2013-08-08T16:38:09Z</time>  </trkpt>  <trkpt lat="55.995277405000003" lon="37.828353882000002">    <time>2013-08-08T16:38:12Z</time>  </trkpt>  <trkpt lat="55.995182036999999" lon="37.828571320000002">    <time>2013-08-08T16:38:15Z</time>  </trkpt>  <trkpt lat="55.995094299000002" lon="37.828765869000001">    <time>2013-08-08T16:38:18Z</time>  </trkpt>  <trkpt lat="55.995040893999999" lon="37.828937531000001">    <time>2013-08-08T16:38:21Z</time>  </trkpt>  <trkpt lat="55.994987488" lon="37.829086304">    <time>2013-08-08T16:38:24Z</time>  </trkpt>  <trkpt lat="55.994934082" lon="37.829120635999999">    <time>2013-08-08T16:38:27Z</time>  </trkpt>  <trkpt lat="55.994926452999998" lon="37.829109191999997">    <time>2013-08-08T16:38:30Z</time>  </trkpt>  <trkpt lat="55.994926452999998" lon="37.829128265000001">    <time>2013-08-08T16:38:33Z</time>  </trkpt>  <trkpt lat="55.994915009000003" lon="37.829120635999999">    <time>2013-08-08T16:38:36Z</time>  </trkpt>  <trkpt lat="55.994899750000002" lon="37.829105376999998">    <time>2013-08-08T16:38:39Z</time>  </trkpt>  <trkpt lat="55.994884491000001" lon="37.829097748000002">    <time>2013-08-08T16:38:42Z</time>  </trkpt>  <trkpt lat="55.994865417" lon="37.829097748000002">    <time>2013-08-08T16:38:45Z</time>  </trkpt>  <trkpt lat="55.994865417" lon="37.829101561999998">    <time>2013-08-08T16:38:48Z</time>  </trkpt>  <trkpt lat="55.994819640999999" lon="37.829074859999999">    <time>2013-08-08T16:38:51Z</time>  </trkpt>  <trkpt lat="55.994743347000004" lon="37.829036713000001">    <time>2013-08-08T16:38:54Z</time>  </trkpt>  <trkpt lat="55.994655608999999" lon="37.828994751000003">    <time>2013-08-08T16:38:57Z</time>  </trkpt>  <trkpt lat="55.994579315000003" lon="37.828933716000002">    <time>2013-08-08T16:39:00Z</time>  </trkpt>  <trkpt lat="55.994506835999999" lon="37.828891753999997">    <time>2013-08-08T16:39:03Z</time>  </trkpt>  <trkpt lat="55.994457245" lon="37.828861236999998">    <time>2013-08-08T16:39:06Z</time>  </trkpt>  <trkpt lat="55.994415283000002" lon="37.828834534000002">    <time>2013-08-08T16:39:09Z</time>  </trkpt>  <trkpt lat="55.994384766000003" lon="37.828819275000001">    <time>2013-08-08T16:39:12Z</time>  </trkpt>  <trkpt lat="55.994335175000003" lon="37.828804015999999">    <time>2013-08-08T16:39:15Z</time>  </trkpt>  <trkpt lat="55.994300842000001" lon="37.828773499">    <time>2013-08-08T16:39:18Z</time>  </trkpt>  <trkpt lat="55.994224547999998" lon="37.828731537000003">    <time>2013-08-08T16:39:21Z</time>  </trkpt>  <trkpt lat="55.994106293000002" lon="37.828662872000002">    <time>2013-08-08T16:39:24Z</time>  </trkpt>  <trkpt lat="55.993957520000002" lon="37.828586577999999">    <time>2013-08-08T16:39:27Z</time>  </trkpt>  <trkpt lat="55.993812560999999" lon="37.828487396">    <time>2013-08-08T16:39:30Z</time>  </trkpt>  <trkpt lat="55.993671417000002" lon="37.828392029">    <time>2013-08-08T16:39:33Z</time>  </trkpt>  <trkpt lat="55.993530272999998" lon="37.828311919999997">    <time>2013-08-08T16:39:36Z</time>  </trkpt>  <trkpt lat="55.993377686000002" lon="37.828216552999997">    <time>2013-08-08T16:39:39Z</time>  </trkpt>  <trkpt lat="55.993236541999998" lon="37.828128814999999">    <time>2013-08-08T16:39:42Z</time>  </trkpt>  <trkpt lat="55.993091583000002" lon="37.828044890999998">    <time>2013-08-08T16:39:45Z</time>  </trkpt>  <trkpt lat="55.992950438999998" lon="37.827953338999997">    <time>2013-08-08T16:39:48Z</time>  </trkpt>  <trkpt lat="55.992809295999997" lon="37.827877045000001">    <time>2013-08-08T16:39:51Z</time>  </trkpt>  <trkpt lat="55.992706298999998" lon="37.827743529999999">    <time>2013-08-08T16:39:54Z</time>  </trkpt>  <trkpt lat="55.992568970000001" lon="37.827655792000002">    <time>2013-08-08T16:39:57Z</time>  </trkpt>  <trkpt lat="55.992412567000002" lon="37.827568053999997">    <time>2013-08-08T16:40:00Z</time>  </trkpt>  <trkpt lat="55.992252350000001" lon="37.827472686999997">    <time>2013-08-08T16:40:03Z</time>  </trkpt>  <trkpt lat="55.992073058999999" lon="37.827362061000002">    <time>2013-08-08T16:40:06Z</time>  </trkpt>  <trkpt lat="55.991901398000003" lon="37.827270507999998">    <time>2013-08-08T16:40:09Z</time>  </trkpt>  <trkpt lat="55.991725922000001" lon="37.827156066999997">    <time>2013-08-08T16:40:12Z</time>  </trkpt>  <trkpt lat="55.991558075" lon="37.827049254999999">    <time>2013-08-08T16:40:15Z</time>  </trkpt>  <trkpt lat="55.991397857999999" lon="37.826950072999999">    <time>2013-08-08T16:40:18Z</time>  </trkpt>  <trkpt lat="55.991241455000001" lon="37.826828003000003">    <time>2013-08-08T16:40:21Z</time>  </trkpt>  <trkpt lat="55.991069793999998" lon="37.826740264999998">    <time>2013-08-08T16:40:24Z</time>  </trkpt>  <trkpt lat="55.990894318000002" lon="37.826614380000002">    <time>2013-08-08T16:40:27Z</time>  </trkpt>  <trkpt lat="55.990718842" lon="37.826499939000001">    <time>2013-08-08T16:40:30Z</time>  </trkpt>  <trkpt lat="55.990543365000001" lon="37.826393127000003">    <time>2013-08-08T16:40:33Z</time>  </trkpt>  <trkpt lat="55.990367888999998" lon="37.826290131">    <time>2013-08-08T16:40:36Z</time>  </trkpt>  <trkpt lat="55.990184784" lon="37.826179504000002">    <time>2013-08-08T16:40:39Z</time>  </trkpt>  <trkpt lat="55.990013122999997" lon="37.826068878000001">    <time>2013-08-08T16:40:42Z</time>  </trkpt>  <trkpt lat="55.989856719999999" lon="37.825977324999997">    <time>2013-08-08T16:40:45Z</time>  </trkpt>  <trkpt lat="55.989707946999999" lon="37.825878142999997">    <time>2013-08-08T16:40:48Z</time>  </trkpt>  <trkpt lat="55.989532470999997" lon="37.825782775999997">    <time>2013-08-08T16:40:51Z</time>  </trkpt>  <trkpt lat="55.989360808999997" lon="37.825679778999998">    <time>2013-08-08T16:40:54Z</time>  </trkpt>  <trkpt lat="55.989196776999997" lon="37.825572968000003">    <time>2013-08-08T16:40:57Z</time>  </trkpt>  <trkpt lat="55.989048003999997" lon="37.825450897000003">    <time>2013-08-08T16:41:00Z</time>  </trkpt>  <trkpt lat="55.98890686" lon="37.825347899999997">    <time>2013-08-08T16:41:03Z</time>  </trkpt>  <trkpt lat="55.988780974999997" lon="37.825241089000002">    <time>2013-08-08T16:41:06Z</time>  </trkpt>  <trkpt lat="55.988632201999998" lon="37.825141907000003">    <time>2013-08-08T16:41:09Z</time>  </trkpt>  <trkpt lat="55.988468169999997" lon="37.825054168999998">    <time>2013-08-08T16:41:12Z</time>  </trkpt>  <trkpt lat="55.988300322999997" lon="37.824974060000002">    <time>2013-08-08T16:41:15Z</time>  </trkpt>  <trkpt lat="55.988136292" lon="37.824871063000003">    <time>2013-08-08T16:41:18Z</time>  </trkpt>  <trkpt lat="55.987968445" lon="37.824771880999997">    <time>2013-08-08T16:41:21Z</time>  </trkpt>  <trkpt lat="55.987812042000002" lon="37.824657440000003">    <time>2013-08-08T16:41:24Z</time>  </trkpt>  <trkpt lat="55.987648010000001" lon="37.824554442999997">    <time>2013-08-08T16:41:27Z</time>  </trkpt>  <trkpt lat="55.987491607999999" lon="37.824447632000002">    <time>2013-08-08T16:41:30Z</time>  </trkpt>  <trkpt lat="55.987331390000001" lon="37.824356078999998">    <time>2013-08-08T16:41:33Z</time>  </trkpt>  <trkpt lat="55.987167358000001" lon="37.824264526">    <time>2013-08-08T16:41:36Z</time>  </trkpt>  <trkpt lat="55.987003326" lon="37.824169159">    <time>2013-08-08T16:41:39Z</time>  </trkpt>  <trkpt lat="55.986843108999999" lon="37.824085236000002">    <time>2013-08-08T16:41:42Z</time>  </trkpt>  <trkpt lat="55.986694335999999" lon="37.823978424000003">    <time>2013-08-08T16:41:45Z</time>  </trkpt>  <trkpt lat="55.986545563" lon="37.823890685999999">    <time>2013-08-08T16:41:48Z</time>  </trkpt>  <trkpt lat="55.986396790000001" lon="37.823802948000001">    <time>2013-08-08T16:41:51Z</time>  </trkpt>  <trkpt lat="55.986236572000003" lon="37.823715210000003">    <time>2013-08-08T16:41:54Z</time>  </trkpt>  <trkpt lat="55.986083983999997" lon="37.823589325">    <time>2013-08-08T16:41:57Z</time>  </trkpt>  <trkpt lat="55.985908508000001" lon="37.823493958">    <time>2013-08-08T16:42:00Z</time>  </trkpt>  <trkpt lat="55.985748291" lon="37.823398589999996">    <time>2013-08-08T16:42:03Z</time>  </trkpt>  <trkpt lat="55.985584258999999" lon="37.823287964000002">    <time>2013-08-08T16:42:06Z</time>  </trkpt>  <trkpt lat="55.985431671000001" lon="37.823181151999997">    <time>2013-08-08T16:42:09Z</time>  </trkpt>  <trkpt lat="55.985267639" lon="37.823081969999997">    <time>2013-08-08T16:42:12Z</time>  </trkpt>  <trkpt lat="55.985107421999999" lon="37.822975159000002">    <time>2013-08-08T16:42:15Z</time>  </trkpt>  <trkpt lat="55.984943389999998" lon="37.822883605999998">    <time>2013-08-08T16:42:18Z</time>  </trkpt>  <trkpt lat="55.984786987" lon="37.822772980000003">    <time>2013-08-08T16:42:21Z</time>  </trkpt>  <trkpt lat="55.984619141000003" lon="37.822677612">    <time>2013-08-08T16:42:24Z</time>  </trkpt>  <trkpt lat="55.984451294000003" lon="37.82257843">    <time>2013-08-08T16:42:27Z</time>  </trkpt>  <trkpt lat="55.984287262000002" lon="37.822471618999998">    <time>2013-08-08T16:42:30Z</time>  </trkpt>  <trkpt lat="55.984111786" lon="37.822380066000001">    <time>2013-08-08T16:42:33Z</time>  </trkpt>  <trkpt lat="55.983951568999998" lon="37.822265625">    <time>2013-08-08T16:42:36Z</time>  </trkpt>  <trkpt lat="55.983779906999999" lon="37.822158813000001">    <time>2013-08-08T16:42:39Z</time>  </trkpt>  <trkpt lat="55.983612061000002" lon="37.822052002">    <time>2013-08-08T16:42:42Z</time>  </trkpt>  <trkpt lat="55.983436584000003" lon="37.821929932000003">    <time>2013-08-08T16:42:45Z</time>  </trkpt>  <trkpt lat="55.983276367000002" lon="37.821823119999998">    <time>2013-08-08T16:42:48Z</time>  </trkpt>  <trkpt lat="55.983108520999998" lon="37.821712494000003">    <time>2013-08-08T16:42:51Z</time>  </trkpt>  <trkpt lat="55.982936858999999" lon="37.821601868000002">    <time>2013-08-08T16:42:54Z</time>  </trkpt>  <trkpt lat="55.982769011999999" lon="37.821506499999998">    <time>2013-08-08T16:42:57Z</time>  </trkpt>  <trkpt lat="55.982612609999997" lon="37.821388245000001">    <time>2013-08-08T16:43:00Z</time>  </trkpt>  <trkpt lat="55.982448578000003" lon="37.821289061999998">    <time>2013-08-08T16:43:03Z</time>  </trkpt>  <trkpt lat="55.982284546000002" lon="37.821201324">    <time>2013-08-08T16:43:06Z</time>  </trkpt>  <trkpt lat="55.982112884999999" lon="37.821098327999998">    <time>2013-08-08T16:43:09Z</time>  </trkpt>  <trkpt lat="55.981933593999997" lon="37.820987701">    <time>2013-08-08T16:43:12Z</time>  </trkpt>  <trkpt lat="55.981761931999998" lon="37.820880889999998">    <time>2013-08-08T16:43:15Z</time>  </trkpt>  <trkpt lat="55.981590271000002" lon="37.820781707999998">    <time>2013-08-08T16:43:18Z</time>  </trkpt>  <trkpt lat="55.98141098" lon="37.820682525999999">    <time>2013-08-08T16:43:21Z</time>  </trkpt>  <trkpt lat="55.981239318999997" lon="37.820579529">    <time>2013-08-08T16:43:24Z</time>  </trkpt>  <trkpt lat="55.981063843000001" lon="37.820480347">    <time>2013-08-08T16:43:27Z</time>  </trkpt>  <trkpt lat="55.980892181000002" lon="37.820358276">    <time>2013-08-08T16:43:30Z</time>  </trkpt>  <trkpt lat="55.980724334999998" lon="37.820240020999996">    <time>2013-08-08T16:43:33Z</time>  </trkpt>  <trkpt lat="55.980560302999997" lon="37.820117949999997">    <time>2013-08-08T16:43:36Z</time>  </trkpt>  <trkpt lat="55.980381012000002" lon="37.820022582999997">    <time>2013-08-08T16:43:39Z</time>  </trkpt>  <trkpt lat="55.980201721" lon="37.819908142000003">    <time>2013-08-08T16:43:42Z</time>  </trkpt>  <trkpt lat="55.980033874999997" lon="37.819797516000001">    <time>2013-08-08T16:43:45Z</time>  </trkpt>  <trkpt lat="55.979869843000003" lon="37.819675445999998">    <time>2013-08-08T16:43:48Z</time>  </trkpt>  <trkpt lat="55.979709624999998" lon="37.819553374999998">    <time>2013-08-08T16:43:51Z</time>  </trkpt>  <trkpt lat="55.979541779000002" lon="37.819419861">    <time>2013-08-08T16:43:54Z</time>  </trkpt>  <trkpt lat="55.979377747000001" lon="37.819293975999997">    <time>2013-08-08T16:43:57Z</time>  </trkpt>  <trkpt lat="55.979213715" lon="37.819187163999999">    <time>2013-08-08T16:44:00Z</time>  </trkpt>  <trkpt lat="55.979038238999998" lon="37.819080352999997">    <time>2013-08-08T16:44:03Z</time>  </trkpt>  <trkpt lat="55.978866576999998" lon="37.818992614999999">    <time>2013-08-08T16:44:06Z</time>  </trkpt>  <trkpt lat="55.978691101000003" lon="37.818912505999997">    <time>2013-08-08T16:44:09Z</time>  </trkpt>  <trkpt lat="55.978519439999999" lon="37.818809508999998">    <time>2013-08-08T16:44:12Z</time>  </trkpt>  <trkpt lat="55.978363037000001" lon="37.818695067999997">    <time>2013-08-08T16:44:15Z</time>  </trkpt>  <trkpt lat="55.978225707999997" lon="37.818538666000002">    <time>2013-08-08T16:44:18Z</time>  </trkpt>  <trkpt lat="55.978065491000002" lon="37.818450927999997">    <time>2013-08-08T16:44:21Z</time>  </trkpt>  <trkpt lat="55.977893829000003" lon="37.818355560000001">    <time>2013-08-08T16:44:24Z</time>  </trkpt>  <trkpt lat="55.977722168" lon="37.818305969000001">    <time>2013-08-08T16:44:27Z</time>  </trkpt>  <trkpt lat="55.977592467999997" lon="37.818199157999999">    <time>2013-08-08T16:44:30Z</time>  </trkpt>  <trkpt lat="55.977546691999997" lon="37.818141937">    <time>2013-08-08T16:44:33Z</time>  </trkpt>  <trkpt lat="55.977489470999998" lon="37.818111420000001">    <time>2013-08-08T16:44:36Z</time>  </trkpt>  <trkpt lat="55.977470398000001" lon="37.81804657">    <time>2013-08-08T16:44:39Z</time>  </trkpt>  <trkpt lat="55.977455139" lon="37.817947388">    <time>2013-08-08T16:44:42Z</time>  </trkpt>  <trkpt lat="55.977375031000001" lon="37.817939758000001">    <time>2013-08-08T16:44:45Z</time>  </trkpt>  <trkpt lat="55.977313995000003" lon="37.817981719999999">    <time>2013-08-08T16:44:48Z</time>  </trkpt>  <trkpt lat="55.977279662999997" lon="37.818027495999999">    <time>2013-08-08T16:44:51Z</time>  </trkpt>  <trkpt lat="55.977233886999997" lon="37.818016051999997">    <time>2013-08-08T16:44:54Z</time>  </trkpt>  <trkpt lat="55.977165222000004" lon="37.817977904999999">    <time>2013-08-08T16:44:57Z</time>  </trkpt>  <trkpt lat="55.977081298999998" lon="37.817935943999998">    <time>2013-08-08T16:45:00Z</time>  </trkpt>  <trkpt lat="55.976985931000002" lon="37.817882537999999">    <time>2013-08-08T16:45:03Z</time>  </trkpt>  <trkpt lat="55.976905823000003" lon="37.817829132">    <time>2013-08-08T16:45:06Z</time>  </trkpt>  <trkpt lat="55.976799010999997" lon="37.817756652999996">    <time>2013-08-08T16:45:09Z</time>  </trkpt>  <trkpt lat="55.976673126000001" lon="37.817684174">    <time>2013-08-08T16:45:12Z</time>  </trkpt>  <trkpt lat="55.976539612000003" lon="37.817615508999999">    <time>2013-08-08T16:45:15Z</time>  </trkpt>  <trkpt lat="55.976413727000001" lon="37.817516327">    <time>2013-08-08T16:45:18Z</time>  </trkpt>  <trkpt lat="55.976284026999998" lon="37.817428589000002">    <time>2013-08-08T16:45:21Z</time>  </trkpt>  <trkpt lat="55.976139068999998" lon="37.817359924000002">    <time>2013-08-08T16:45:24Z</time>  </trkpt>  <trkpt lat="55.976001740000001" lon="37.817272185999997">    <time>2013-08-08T16:45:27Z</time>  </trkpt>  <trkpt lat="55.975868224999999" lon="37.817192077999998">    <time>2013-08-08T16:45:30Z</time>  </trkpt>  <trkpt lat="55.975738524999997" lon="37.817115784000002">    <time>2013-08-08T16:45:33Z</time>  </trkpt>  <trkpt lat="55.975608825999998" lon="37.817028045999997">    <time>2013-08-08T16:45:36Z</time>  </trkpt>  <trkpt lat="55.975471497000001" lon="37.816928863999998">    <time>2013-08-08T16:45:39Z</time>  </trkpt>  <trkpt lat="55.975326537999997" lon="37.816841125000003">    <time>2013-08-08T16:45:42Z</time>  </trkpt>  <trkpt lat="55.975181579999997" lon="37.816738129000001">    <time>2013-08-08T16:45:45Z</time>  </trkpt>  <trkpt lat="55.975036621000001" lon="37.816635132000002">    <time>2013-08-08T16:45:48Z</time>  </trkpt>  <trkpt lat="55.974872589" lon="37.816532135000003">    <time>2013-08-08T16:45:51Z</time>  </trkpt>  <trkpt lat="55.974704742" lon="37.816436768000003">    <time>2013-08-08T16:45:54Z</time>  </trkpt>  <trkpt lat="55.974529265999998" lon="37.816322327000002">    <time>2013-08-08T16:45:57Z</time>  </trkpt>  <trkpt lat="55.974349975999999" lon="37.816223145000002">    <time>2013-08-08T16:46:00Z</time>  </trkpt>  <trkpt lat="55.974159241000002" lon="37.816116332999997">    <time>2013-08-08T16:46:03Z</time>  </trkpt>  <trkpt lat="55.973976135000001" lon="37.816005707000002">    <time>2013-08-08T16:46:06Z</time>  </trkpt>  <trkpt lat="55.973796843999999" lon="37.815898894999997">    <time>2013-08-08T16:46:09Z</time>  </trkpt>  <trkpt lat="55.973625183000003" lon="37.815788269000002">    <time>2013-08-08T16:46:12Z</time>  </trkpt>  <trkpt lat="55.973438262999998" lon="37.815670013000002">    <time>2013-08-08T16:46:15Z</time>  </trkpt>  <trkpt lat="55.973251343000001" lon="37.815532683999997">    <time>2013-08-08T16:46:18Z</time>  </trkpt>  <trkpt lat="55.973045349000003" lon="37.815402984999999">    <time>2013-08-08T16:46:21Z</time>  </trkpt>  <trkpt lat="55.972850800000003" lon="37.815303802000003">    <time>2013-08-08T16:46:24Z</time>  </trkpt>  <trkpt lat="55.972652435000001" lon="37.815193176000001">    <time>2013-08-08T16:46:27Z</time>  </trkpt>  <trkpt lat="55.972469330000003" lon="37.815059662000003">    <time>2013-08-08T16:46:30Z</time>  </trkpt>  <trkpt lat="55.972274779999999" lon="37.814941406000003">    <time>2013-08-08T16:46:33Z</time>  </trkpt>  <trkpt lat="55.972080231" lon="37.814830780000001">    <time>2013-08-08T16:46:36Z</time>  </trkpt>  <trkpt lat="55.971885681000003" lon="37.814712524000001">    <time>2013-08-08T16:46:39Z</time>  </trkpt>  <trkpt lat="55.971717834000003" lon="37.814567566000001">    <time>2013-08-08T16:46:42Z</time>  </trkpt>  <trkpt lat="55.971546173" lon="37.814472197999997">    <time>2013-08-08T16:46:45Z</time>  </trkpt>  <trkpt lat="55.971435546999999" lon="37.814395904999998">    <time>2013-08-08T16:46:48Z</time>  </trkpt>  <trkpt lat="55.971298218000001" lon="37.814331054999997">    <time>2013-08-08T16:46:51Z</time>  </trkpt>  <trkpt lat="55.971141815000003" lon="37.814216614000003">    <time>2013-08-08T16:46:54Z</time>  </trkpt>  <trkpt lat="55.970970154" lon="37.814094543000003">    <time>2013-08-08T16:46:57Z</time>  </trkpt>  <trkpt lat="55.970787047999998" lon="37.813938141000001">    <time>2013-08-08T16:47:00Z</time>  </trkpt>  <trkpt lat="55.970592498999999" lon="37.813781738000003">    <time>2013-08-08T16:47:03Z</time>  </trkpt>  <trkpt lat="55.970401764000002" lon="37.813667297000002">    <time>2013-08-08T16:47:06Z</time>  </trkpt>  <trkpt lat="55.970233917000002" lon="37.813568115000002">    <time>2013-08-08T16:47:09Z</time>  </trkpt>  <trkpt lat="55.970088959000002" lon="37.813461304">    <time>2013-08-08T16:47:12Z</time>  </trkpt>  <trkpt lat="55.969943999999998" lon="37.813365935999997">    <time>2013-08-08T16:47:15Z</time>  </trkpt>  <trkpt lat="55.969795226999999" lon="37.813285827999998">    <time>2013-08-08T16:47:18Z</time>  </trkpt>  <trkpt lat="55.969661713000001" lon="37.813152313000003">    <time>2013-08-08T16:47:21Z</time>  </trkpt>  <trkpt lat="55.969535827999998" lon="37.813018798999998">    <time>2013-08-08T16:47:24Z</time>  </trkpt>  <trkpt lat="55.969406128000003" lon="37.812938690000003">    <time>2013-08-08T16:47:27Z</time>  </trkpt>  <trkpt lat="55.969295502000001" lon="37.812908172999997">    <time>2013-08-08T16:47:30Z</time>  </trkpt>  <trkpt lat="55.969207763999997" lon="37.813011168999999">    <time>2013-08-08T16:47:33Z</time>  </trkpt>  <trkpt lat="55.969150542999998" lon="37.813194275000001">    <time>2013-08-08T16:47:36Z</time>  </trkpt>  <trkpt lat="55.969158172999997" lon="37.813400268999999">    <time>2013-08-08T16:47:39Z</time>  </trkpt>  <trkpt lat="55.969158172999997" lon="37.813613891999999">    <time>2013-08-08T16:47:42Z</time>  </trkpt>  <trkpt lat="55.969181061" lon="37.813812255999999">    <time>2013-08-08T16:47:45Z</time>  </trkpt>  <trkpt lat="55.969284058" lon="37.813934326000002">    <time>2013-08-08T16:47:48Z</time>  </trkpt>  <trkpt lat="55.969390869000001" lon="37.813999176000003">    <time>2013-08-08T16:47:51Z</time>  </trkpt>  <trkpt lat="55.969516753999997" lon="37.814025878999999">    <time>2013-08-08T16:47:54Z</time>  </trkpt>  <trkpt lat="55.969635009999998" lon="37.813987732000001">    <time>2013-08-08T16:47:57Z</time>  </trkpt>  <trkpt lat="55.969741821" lon="37.814014434999997">    <time>2013-08-08T16:48:00Z</time>  </trkpt>  <trkpt lat="55.969860077" lon="37.814102173000002">    <time>2013-08-08T16:48:03Z</time>  </trkpt>  <trkpt lat="55.969997405999997" lon="37.814197540000002">    <time>2013-08-08T16:48:06Z</time>  </trkpt>  <trkpt lat="55.970146178999997" lon="37.814289092999999">    <time>2013-08-08T16:48:09Z</time>  </trkpt>  <trkpt lat="55.970302582000002" lon="37.814373015999998">    <time>2013-08-08T16:48:12Z</time>  </trkpt>  <trkpt lat="55.970447540000002" lon="37.814472197999997">    <time>2013-08-08T16:48:15Z</time>  </trkpt>  <trkpt lat="55.970592498999999" lon="37.814552307">    <time>2013-08-08T16:48:18Z</time>  </trkpt>  <trkpt lat="55.970718384000001" lon="37.814617157000001">    <time>2013-08-08T16:48:21Z</time>  </trkpt>  <trkpt lat="55.970809936999999" lon="37.814739226999997">    <time>2013-08-08T16:48:24Z</time>  </trkpt>  <trkpt lat="55.970836638999998" lon="37.815025329999997">    <time>2013-08-08T16:48:27Z</time>  </trkpt>  <trkpt lat="55.970874786000003" lon="37.815212250000002">    <time>2013-08-08T16:48:30Z</time>  </trkpt>  <trkpt lat="55.970981598000002" lon="37.815231322999999">    <time>2013-08-08T16:48:33Z</time>  </trkpt>  <trkpt lat="55.971073150999999" lon="37.815299988">    <time>2013-08-08T16:48:36Z</time>  </trkpt>  <trkpt lat="55.971054076999998" lon="37.815410614000001">    <time>2013-08-08T16:48:39Z</time>  </trkpt>  <trkpt lat="55.970996857000003" lon="37.815544127999999">    <time>2013-08-08T16:48:42Z</time>  </trkpt>  <trkpt lat="55.970905303999999" lon="37.815643311000002">    <time>2013-08-08T16:48:45Z</time>  </trkpt>  <trkpt lat="55.970802307" lon="37.815628052000001">    <time>2013-08-08T16:48:48Z</time>  </trkpt>  <trkpt lat="55.970680237000003" lon="37.815631865999997">    <time>2013-08-08T16:48:51Z</time>  </trkpt>  <trkpt lat="55.970596313000001" lon="37.815773010000001">    <time>2013-08-08T16:48:54Z</time>  </trkpt>  <trkpt lat="55.970569611000002" lon="37.815967559999997">    <time>2013-08-08T16:48:57Z</time>  </trkpt>  <trkpt lat="55.970569611000002" lon="37.816169739000003">    <time>2013-08-08T16:49:00Z</time>  </trkpt>  <trkpt lat="55.970539092999999" lon="37.816352844000001">    <time>2013-08-08T16:49:03Z</time>  </trkpt>  <trkpt lat="55.970489502" lon="37.816482544000003">    <time>2013-08-08T16:49:06Z</time>  </trkpt>  <trkpt lat="55.970401764000002" lon="37.816631317000002">    <time>2013-08-08T16:49:09Z</time>  </trkpt>  <trkpt lat="55.970325469999999" lon="37.816768646">    <time>2013-08-08T16:49:12Z</time>  </trkpt>  <trkpt lat="55.970260619999998" lon="37.816848755000002">    <time>2013-08-08T16:49:15Z</time>  </trkpt>  <trkpt lat="55.970172882" lon="37.816898346000002">    <time>2013-08-08T16:49:18Z</time>  </trkpt>  <trkpt lat="55.970123291" lon="37.816925048999998">    <time>2013-08-08T16:49:21Z</time>  </trkpt>  <trkpt lat="55.970039368000002" lon="37.816955565999997">    <time>2013-08-08T16:49:24Z</time>  </trkpt>  <trkpt lat="55.969951629999997" lon="37.817016602000002">    <time>2013-08-08T16:49:27Z</time>  </trkpt>  <trkpt lat="55.969860077" lon="37.817066193000002">    <time>2013-08-08T16:49:30Z</time>  </trkpt>  <trkpt lat="55.969799041999998" lon="37.817157745000003">    <time>2013-08-08T16:49:33Z</time>  </trkpt>  <trkpt lat="55.969814301" lon="37.817298889">    <time>2013-08-08T16:49:36Z</time>  </trkpt>  <trkpt lat="55.969829558999997" lon="37.817466736">    <time>2013-08-08T16:49:39Z</time>  </trkpt>  <trkpt lat="55.969841002999999" lon="37.817642212000003">    <time>2013-08-08T16:49:42Z</time>  </trkpt>  <trkpt lat="55.969848632999998" lon="37.817810059000003">    <time>2013-08-08T16:49:45Z</time>  </trkpt>  <trkpt lat="55.969852447999997" lon="37.817977904999999">    <time>2013-08-08T16:49:48Z</time>  </trkpt>  <trkpt lat="55.969848632999998" lon="37.818153381000002">    <time>2013-08-08T16:49:51Z</time>  </trkpt>  <trkpt lat="55.969856262" lon="37.818347930999998">    <time>2013-08-08T16:49:54Z</time>  </trkpt>  <trkpt lat="55.969841002999999" lon="37.818527222">    <time>2013-08-08T16:49:57Z</time>  </trkpt>  <trkpt lat="55.969844817999999" lon="37.818740845000001">    <time>2013-08-08T16:50:00Z</time>  </trkpt>  <trkpt lat="55.969882964999996" lon="37.818897247000002">    <time>2013-08-08T16:50:03Z</time>  </trkpt>  <trkpt lat="55.969917297000002" lon="37.819072722999998">    <time>2013-08-08T16:50:06Z</time>  </trkpt>  <trkpt lat="55.969963073999999" lon="37.819252014">    <time>2013-08-08T16:50:09Z</time>  </trkpt>  <trkpt lat="55.970005035" lon="37.819423676">    <time>2013-08-08T16:50:12Z</time>  </trkpt>  <trkpt lat="55.970027924" lon="37.819591522000003">    <time>2013-08-08T16:50:15Z</time>  </trkpt>  <trkpt lat="55.970054626" lon="37.819763184000003">    <time>2013-08-08T16:50:18Z</time>  </trkpt>  <trkpt lat="55.970069885000001" lon="37.819908142000003">    <time>2013-08-08T16:50:21Z</time>  </trkpt>  <trkpt lat="55.970062255999999" lon="37.819911957000002">    <time>2013-08-08T16:50:24Z</time>  </trkpt>  <trkpt lat="55.970062255999999" lon="37.819919585999997">    <time>2013-08-08T16:50:27Z</time>  </trkpt>  <trkpt lat="55.970069885000001" lon="37.819919585999997">    <time>2013-08-08T16:50:30Z</time>  </trkpt>  <trkpt lat="55.970085144000002" lon="37.819934844999999">    <time>2013-08-08T16:50:33Z</time>  </trkpt>  <trkpt lat="55.970104218000003" lon="37.819984435999999">    <time>2013-08-08T16:50:36Z</time>  </trkpt>  <trkpt lat="55.970123291" lon="37.820007324000002">    <time>2013-08-08T16:50:39Z</time>  </trkpt>  <trkpt lat="55.970138550000001" lon="37.820053100999999">    <time>2013-08-08T16:50:42Z</time>  </trkpt>  <trkpt lat="55.970195769999997" lon="37.820144653">    <time>2013-08-08T16:50:45Z</time>  </trkpt>  <trkpt lat="55.970283508000001" lon="37.820266724">    <time>2013-08-08T16:50:48Z</time>  </trkpt>  <trkpt lat="55.970371245999999" lon="37.820407867">    <time>2013-08-08T16:50:51Z</time>  </trkpt>  <trkpt lat="55.970455170000001" lon="37.820568084999998">    <time>2013-08-08T16:50:54Z</time>  </trkpt>  <trkpt lat="55.970577239999997" lon="37.820705414000003">    <time>2013-08-08T16:50:57Z</time>  </trkpt>  <trkpt lat="55.970661163000003" lon="37.820816039999997">    <time>2013-08-08T16:51:00Z</time>  </trkpt>  <trkpt lat="55.970752716" lon="37.820926665999998">    <time>2013-08-08T16:51:03Z</time>  </trkpt>  <trkpt lat="55.970829010000003" lon="37.821075438999998">    <time>2013-08-08T16:51:06Z</time>  </trkpt>  <trkpt lat="55.970890044999997" lon="37.821250915999997">    <time>2013-08-08T16:51:09Z</time>  </trkpt>  <trkpt lat="55.970943450999997" lon="37.821422577">    <time>2013-08-08T16:51:12Z</time>  </trkpt>  <trkpt lat="55.970989226999997" lon="37.821590424">    <time>2013-08-08T16:51:15Z</time>  </trkpt>  <trkpt lat="55.971042633000003" lon="37.821739196999999">    <time>2013-08-08T16:51:18Z</time>  </trkpt>  <trkpt lat="55.971080780000001" lon="37.821876525999997">    <time>2013-08-08T16:51:21Z</time>  </trkpt>  <trkpt lat="55.971126556000002" lon="37.821987151999998">    <time>2013-08-08T16:51:24Z</time>  </trkpt>  <trkpt lat="55.971153258999998" lon="37.822109222000002">    <time>2013-08-08T16:51:27Z</time>  </trkpt>  <trkpt lat="55.971191406000003" lon="37.822242737000003">    <time>2013-08-08T16:51:30Z</time>  </trkpt>  <trkpt lat="55.971221923999998" lon="37.822391510000003">    <time>2013-08-08T16:51:33Z</time>  </trkpt>  <trkpt lat="55.971233368" lon="37.822563170999999">    <time>2013-08-08T16:51:36Z</time>  </trkpt>  <trkpt lat="55.971240997000002" lon="37.822685241999999">    <time>2013-08-08T16:51:39Z</time>  </trkpt>  <trkpt lat="55.971256255999997" lon="37.822700500000003">    <time>2013-08-08T16:51:42Z</time>  </trkpt>  <trkpt lat="55.971252440999997" lon="37.822719573999997">    <time>2013-08-08T16:51:45Z</time>  </trkpt>  <trkpt lat="55.971256255999997" lon="37.822765349999997">    <time>2013-08-08T16:51:48Z</time>  </trkpt>  <trkpt lat="55.971263884999999" lon="37.822822571000003">    <time>2013-08-08T16:51:51Z</time>  </trkpt>  <trkpt lat="55.971267699999999" lon="37.822868347000004">    <time>2013-08-08T16:51:54Z</time>  </trkpt>  <trkpt lat="55.971267699999999" lon="37.822906494000001">    <time>2013-08-08T16:51:57Z</time>  </trkpt>  <trkpt lat="55.971275329999997" lon="37.822971344000003">    <time>2013-08-08T16:52:00Z</time>  </trkpt>  <trkpt lat="55.971286773999999" lon="37.823051452999998">    <time>2013-08-08T16:52:03Z</time>  </trkpt>  <trkpt lat="55.971271514999998" lon="37.823112488">    <time>2013-08-08T16:52:06Z</time>  </trkpt>  <trkpt lat="55.971282959" lon="37.823154449">    <time>2013-08-08T16:52:09Z</time>  </trkpt>  <trkpt lat="55.971294403000002" lon="37.823188782000003">    <time>2013-08-08T16:52:12Z</time>  </trkpt>  <trkpt lat="55.971305847000004" lon="37.823242188000002">    <time>2013-08-08T16:52:15Z</time>  </trkpt>  <trkpt lat="55.971309662000003" lon="37.823268890000001">    <time>2013-08-08T16:52:18Z</time>  </trkpt>  <trkpt lat="55.971305847000004" lon="37.82327652">    <time>2013-08-08T16:52:21Z</time>  </trkpt>  <trkpt lat="55.971317290999998" lon="37.823322296000001">    <time>2013-08-08T16:52:24Z</time>  </trkpt>  <trkpt lat="55.971355438000003" lon="37.823440552000001">    <time>2013-08-08T16:52:27Z</time>  </trkpt>  <trkpt lat="55.971370696999998" lon="37.823596954000003">    <time>2013-08-08T16:52:30Z</time>  </trkpt>  <trkpt lat="55.971408844000003" lon="37.823745727999999">    <time>2013-08-08T16:52:33Z</time>  </trkpt>  <trkpt lat="55.971446991000001" lon="37.82390213">    <time>2013-08-08T16:52:36Z</time>  </trkpt>  <trkpt lat="55.971485137999998" lon="37.824066162000001">    <time>2013-08-08T16:52:39Z</time>  </trkpt>  <trkpt lat="55.971530913999999" lon="37.824195862000003">    <time>2013-08-08T16:52:42Z</time>  </trkpt>  <trkpt lat="55.971580504999999" lon="37.824329376000001">    <time>2013-08-08T16:52:45Z</time>  </trkpt>  <trkpt lat="55.971637725999997" lon="37.824436188">    <time>2013-08-08T16:52:48Z</time>  </trkpt>  <trkpt lat="55.971698760999999" lon="37.824523925999998">    <time>2013-08-08T16:52:51Z</time>  </trkpt>  <trkpt lat="55.971767426" lon="37.824619292999998">    <time>2013-08-08T16:52:54Z</time>  </trkpt>  <trkpt lat="55.971805572999997" lon="37.824665070000002">    <time>2013-08-08T16:52:57Z</time>  </trkpt>  <trkpt lat="55.971801757999998" lon="37.824687957999998">    <time>2013-08-08T16:53:00Z</time>  </trkpt>  <trkpt lat="55.971839905000003" lon="37.824714661000002">    <time>2013-08-08T16:53:03Z</time>  </trkpt>  <trkpt lat="55.971862793" lon="37.824764252000001">    <time>2013-08-08T16:53:06Z</time>  </trkpt>  <trkpt lat="55.971889496000003" lon="37.824810028000002">    <time>2013-08-08T16:53:09Z</time>  </trkpt>  <trkpt lat="55.971920013000002" lon="37.824867249">    <time>2013-08-08T16:53:12Z</time>  </trkpt>  <trkpt lat="55.97195816" lon="37.824897765999999">    <time>2013-08-08T16:53:15Z</time>  </trkpt>  <trkpt lat="55.971973419000001" lon="37.824909210000001">    <time>2013-08-08T16:53:18Z</time>  </trkpt>  <trkpt lat="55.971977234000001" lon="37.824913025000001">    <time>2013-08-08T16:53:21Z</time>  </trkpt>  <trkpt lat="55.971981049" lon="37.824935912999997">    <time>2013-08-08T16:53:24Z</time>  </trkpt>  <trkpt lat="55.971992493000002" lon="37.824954986999998">    <time>2013-08-08T16:53:27Z</time>  </trkpt>  <trkpt lat="55.972000121999997" lon="37.824966431">    <time>2013-08-08T16:53:30Z</time>  </trkpt>  <trkpt lat="55.972019195999998" lon="37.824958801000001">    <time>2013-08-08T16:53:33Z</time>  </trkpt>  <trkpt lat="55.972049712999997" lon="37.824913025000001">    <time>2013-08-08T16:53:36Z</time>  </trkpt>  <trkpt lat="55.972068786999998" lon="37.824893951">    <time>2013-08-08T16:53:39Z</time>  </trkpt>  <trkpt lat="55.972076416" lon="37.824909210000001">    <time>2013-08-08T16:53:42Z</time>  </trkpt>  <trkpt lat="55.972068786999998" lon="37.824905395999998">    <time>2013-08-08T16:53:45Z</time>  </trkpt>  <trkpt lat="55.972064971999998" lon="37.824924469000003">    <time>2013-08-08T16:53:48Z</time>  </trkpt>  <trkpt lat="55.97203064" lon="37.825016022">    <time>2013-08-08T16:53:51Z</time>  </trkpt>  <trkpt lat="55.971965789999999" lon="37.825176239000001">    <time>2013-08-08T16:53:54Z</time>  </trkpt>  <trkpt lat="55.971885681000003" lon="37.825363158999998">    <time>2013-08-08T16:53:57Z</time>  </trkpt>  <trkpt lat="55.971790314000003" lon="37.825576781999999">    <time>2013-08-08T16:54:00Z</time>  </trkpt>  <trkpt lat="55.971691131999997" lon="37.825801849000001">    <time>2013-08-08T16:54:03Z</time>  </trkpt>  <trkpt lat="55.971580504999999" lon="37.826023102000001">    <time>2013-08-08T16:54:06Z</time>  </trkpt>  <trkpt lat="55.971466063999998" lon="37.826259612999998">    <time>2013-08-08T16:54:09Z</time>  </trkpt>  <trkpt lat="55.971351624" lon="37.826461792000003">    <time>2013-08-08T16:54:12Z</time>  </trkpt>  <trkpt lat="55.971229553000001" lon="37.826656342">    <time>2013-08-08T16:54:15Z</time>  </trkpt>  <trkpt lat="55.971092224000003" lon="37.826843261999997">    <time>2013-08-08T16:54:18Z</time>  </trkpt>  <trkpt lat="55.970947266000003" lon="37.826999663999999">    <time>2013-08-08T16:54:21Z</time>  </trkpt>  <trkpt lat="55.970813751000001" lon="37.827167510999999">    <time>2013-08-08T16:54:24Z</time>  </trkpt>  <trkpt lat="55.970672606999997" lon="37.827323913999997">    <time>2013-08-08T16:54:27Z</time>  </trkpt>  <trkpt lat="55.970523833999998" lon="37.827461243000002">    <time>2013-08-08T16:54:30Z</time>  </trkpt>  <trkpt lat="55.970367432000003" lon="37.827594757">    <time>2013-08-08T16:54:33Z</time>  </trkpt>  <trkpt lat="55.970218658" lon="37.827739716000004">    <time>2013-08-08T16:54:36Z</time>  </trkpt>  <trkpt lat="55.970058440999999" lon="37.827899932999998">    <time>2013-08-08T16:54:39Z</time>  </trkpt>  <trkpt lat="55.969882964999996" lon="37.828033447000003">    <time>2013-08-08T16:54:42Z</time>  </trkpt>  <trkpt lat="55.969726561999998" lon="37.828166961999997">    <time>2013-08-08T16:54:45Z</time>  </trkpt>  <trkpt lat="55.969570160000004" lon="37.828308104999998">    <time>2013-08-08T16:54:48Z</time>  </trkpt>  <trkpt lat="55.969398499" lon="37.828468323000003">    <time>2013-08-08T16:54:51Z</time>  </trkpt>  <trkpt lat="55.969272613999998" lon="37.828716278000002">    <time>2013-08-08T16:54:54Z</time>  </trkpt>  <trkpt lat="55.969150542999998" lon="37.828983307000001">    <time>2013-08-08T16:54:57Z</time>  </trkpt>  <trkpt lat="55.969036101999997" lon="37.829269408999998">    <time>2013-08-08T16:55:00Z</time>  </trkpt>  <trkpt lat="55.968921661000003" lon="37.829551696999999">    <time>2013-08-08T16:55:03Z</time>  </trkpt>  <trkpt lat="55.968811035000002" lon="37.829822540000002">    <time>2013-08-08T16:55:06Z</time>  </trkpt>  <trkpt lat="55.968708038000003" lon="37.830116271999998">    <time>2013-08-08T16:55:09Z</time>  </trkpt>  <trkpt lat="55.968608856000003" lon="37.830394745">    <time>2013-08-08T16:55:12Z</time>  </trkpt>  <trkpt lat="55.968517302999999" lon="37.830677031999997">    <time>2013-08-08T16:55:15Z</time>  </trkpt>  <trkpt lat="55.968425750999998" lon="37.830974578999999">    <time>2013-08-08T16:55:18Z</time>  </trkpt>  <trkpt lat="55.968330383000001" lon="37.831256865999997">    <time>2013-08-08T16:55:21Z</time>  </trkpt>  <trkpt lat="55.968242644999997" lon="37.831546783">    <time>2013-08-08T16:55:24Z</time>  </trkpt>  <trkpt lat="55.968139647999998" lon="37.831832886000001">    <time>2013-08-08T16:55:27Z</time>  </trkpt>  <trkpt lat="55.968021393000001" lon="37.832092285000002">    <time>2013-08-08T16:55:30Z</time>  </trkpt>  <trkpt lat="55.967876433999997" lon="37.832279204999999">    <time>2013-08-08T16:55:33Z</time>  </trkpt>  <trkpt lat="55.967716217000003" lon="37.832462311">    <time>2013-08-08T16:55:36Z</time>  </trkpt>  <trkpt lat="55.967556000000002" lon="37.832649230999998">    <time>2013-08-08T16:55:39Z</time>  </trkpt>  <trkpt lat="55.967407227000002" lon="37.832820892000001">    <time>2013-08-08T16:55:42Z</time>  </trkpt>  <trkpt lat="55.967247008999998" lon="37.833011626999998">    <time>2013-08-08T16:55:45Z</time>  </trkpt>  <trkpt lat="55.967067718999999" lon="37.833240508999999">    <time>2013-08-08T16:55:48Z</time>  </trkpt>  <trkpt lat="55.966869354000004" lon="37.833526611000003">    <time>2013-08-08T16:55:51Z</time>  </trkpt>  <trkpt lat="55.966674804999997" lon="37.833869933999999">    <time>2013-08-08T16:55:54Z</time>  </trkpt>  <trkpt lat="55.966514586999999" lon="37.834239959999998">    <time>2013-08-08T16:55:57Z</time>  </trkpt>  <trkpt lat="55.966388702000003" lon="37.834594727000002">    <time>2013-08-08T16:56:00Z</time>  </trkpt>  <trkpt lat="55.966285706000001" lon="37.834934234999999">    <time>2013-08-08T16:56:03Z</time>  </trkpt>  <trkpt lat="55.966194152999996" lon="37.835250854000002">    <time>2013-08-08T16:56:06Z</time>  </trkpt>  <trkpt lat="55.966114044000001" lon="37.835502624999997">    <time>2013-08-08T16:56:09Z</time>  </trkpt>  <trkpt lat="55.966018677000001" lon="37.835762023999997">    <time>2013-08-08T16:56:12Z</time>  </trkpt>  <trkpt lat="55.965892791999998" lon="37.836044311999999">    <time>2013-08-08T16:56:15Z</time>  </trkpt>  <trkpt lat="55.965808868000003" lon="37.836322783999996">    <time>2013-08-08T16:56:18Z</time>  </trkpt>  <trkpt lat="55.965717316000003" lon="37.836593628000003">    <time>2013-08-08T16:56:21Z</time>  </trkpt>  <trkpt lat="55.965625762999998" lon="37.836864470999998">    <time>2013-08-08T16:56:24Z</time>  </trkpt>  <trkpt lat="55.965522765999999" lon="37.837169647000003">    <time>2013-08-08T16:56:27Z</time>  </trkpt>  <trkpt lat="55.965435028000002" lon="37.837459564">    <time>2013-08-08T16:56:30Z</time>  </trkpt>  <trkpt lat="55.965370178000001" lon="37.837711333999998">    <time>2013-08-08T16:56:33Z</time>  </trkpt>  <trkpt lat="55.965297698999997" lon="37.837951660000002">    <time>2013-08-08T16:56:36Z</time>  </trkpt>  <trkpt lat="55.965190886999999" lon="37.838142394999998">    <time>2013-08-08T16:56:39Z</time>  </trkpt>  <trkpt lat="55.965084075999997" lon="37.838268280000001">    <time>2013-08-08T16:56:42Z</time>  </trkpt>  <trkpt lat="55.964992522999999" lon="37.838256835999999">    <time>2013-08-08T16:56:45Z</time>  </trkpt>  <trkpt lat="55.964927672999998" lon="37.838233948000003">    <time>2013-08-08T16:56:48Z</time>  </trkpt>  <trkpt lat="55.964904785000002" lon="37.838340758999998">    <time>2013-08-08T16:56:51Z</time>  </trkpt>  <trkpt lat="55.964874268000003" lon="37.838420868">    <time>2013-08-08T16:56:54Z</time>  </trkpt>  <trkpt lat="55.964862822999997" lon="37.838459014999998">    <time>2013-08-08T16:56:57Z</time>  </trkpt>  <trkpt lat="55.964866637999997" lon="37.838462829999997">    <time>2013-08-08T16:57:00Z</time>  </trkpt>  <trkpt lat="55.964866637999997" lon="37.838466644">    <time>2013-08-08T16:57:09Z</time>  </trkpt>  <trkpt lat="55.964878081999998" lon="37.838485718000001">    <time>2013-08-08T16:57:21Z</time>  </trkpt>  <trkpt lat="55.964920044000003" lon="37.838546753000003">    <time>2013-08-08T16:57:24Z</time>  </trkpt>  <trkpt lat="55.964962006" lon="37.838626861999998">    <time>2013-08-08T16:57:27Z</time>  </trkpt>  <trkpt lat="55.964996337999999" lon="37.838737488">    <time>2013-08-08T16:57:30Z</time>  </trkpt>  <trkpt lat="55.964984893999997" lon="37.838882446">    <time>2013-08-08T16:57:33Z</time>  </trkpt>  <trkpt lat="55.964916229000004" lon="37.839019774999997">    <time>2013-08-08T16:57:36Z</time>  </trkpt>  <trkpt lat="55.964801788000003" lon="37.839153289999999">    <time>2013-08-08T16:57:39Z</time>  </trkpt>  <trkpt lat="55.964656830000003" lon="37.839084624999998">    <time>2013-08-08T16:57:42Z</time>  </trkpt>  <trkpt lat="55.964523315000001" lon="37.838981627999999">    <time>2013-08-08T16:57:45Z</time>  </trkpt>  <trkpt lat="55.964389801000003" lon="37.838897705000001">    <time>2013-08-08T16:57:48Z</time>  </trkpt>  <trkpt lat="55.964286803999997" lon="37.838794708000002">    <time>2013-08-08T16:57:51Z</time>  </trkpt>  <trkpt lat="55.964210510000001" lon="37.838695526000002">    <time>2013-08-08T16:57:54Z</time>  </trkpt>  <trkpt lat="55.964141845999997" lon="37.838607787999997">    <time>2013-08-08T16:57:57Z</time>  </trkpt>  <trkpt lat="55.964073181000003" lon="37.838527679000002">    <time>2013-08-08T16:57:59Z</time>  </trkpt>  <trkpt lat="55.964000702" lon="37.838455199999999">    <time>2013-08-08T16:58:03Z</time>  </trkpt>  <trkpt lat="55.963943481000001" lon="37.838378906000003">    <time>2013-08-08T16:58:06Z</time>  </trkpt>  <trkpt lat="55.963874816999997" lon="37.838279724000003">    <time>2013-08-08T16:58:09Z</time>  </trkpt>  <trkpt lat="55.963813782000003" lon="37.838195800999998">    <time>2013-08-08T16:58:12Z</time>  </trkpt>  <trkpt lat="55.963752747000001" lon="37.838134766000003">    <time>2013-08-08T16:58:15Z</time>  </trkpt>  <trkpt lat="55.963687897" lon="37.838047027999998">    <time>2013-08-08T16:58:18Z</time>  </trkpt>  <trkpt lat="55.963615417" lon="37.837963104000004">    <time>2013-08-08T16:58:21Z</time>  </trkpt>  <trkpt lat="55.963539124" lon="37.837879180999998">    <time>2013-08-08T16:58:24Z</time>  </trkpt>  <trkpt lat="55.963459014999998" lon="37.837768554999997">    <time>2013-08-08T16:58:27Z</time>  </trkpt>  <trkpt lat="55.963367462000001" lon="37.837657927999999">    <time>2013-08-08T16:58:30Z</time>  </trkpt>  <trkpt lat="55.963275908999996" lon="37.837532043000003">    <time>2013-08-08T16:58:33Z</time>  </trkpt>  <trkpt lat="55.963184357000003" lon="37.837390900000003">    <time>2013-08-08T16:58:36Z</time>  </trkpt>  <trkpt lat="55.963100433000001" lon="37.837249755999999">    <time>2013-08-08T16:58:39Z</time>  </trkpt>  <trkpt lat="55.963012695000003" lon="37.837112427000001">    <time>2013-08-08T16:58:42Z</time>  </trkpt>  <trkpt lat="55.962932586999997" lon="37.836952209000003">    <time>2013-08-08T16:58:45Z</time>  </trkpt>  <trkpt lat="55.962844849" lon="37.836795807000001">    <time>2013-08-08T16:58:48Z</time>  </trkpt>  <trkpt lat="55.962749481000003" lon="37.836631775000001">    <time>2013-08-08T16:58:51Z</time>  </trkpt>  <trkpt lat="55.962650299000003" lon="37.836456298999998">    <time>2013-08-08T16:58:54Z</time>  </trkpt>  <trkpt lat="55.962554932000003" lon="37.836257934999999">    <time>2013-08-08T16:58:57Z</time>  </trkpt>  <trkpt lat="55.962463378999999" lon="37.836025237999998">    <time>2013-08-08T16:59:00Z</time>  </trkpt>  <trkpt lat="55.962364196999999" lon="37.835796356000003">    <time>2013-08-08T16:59:03Z</time>  </trkpt>  <trkpt lat="55.962272644000002" lon="37.835567474000001">    <time>2013-08-08T16:59:06Z</time>  </trkpt>  <trkpt lat="55.962184905999997" lon="37.835308075">    <time>2013-08-08T16:59:09Z</time>  </trkpt>  <trkpt lat="55.962097168" lon="37.835052490000002">    <time>2013-08-08T16:59:12Z</time>  </trkpt>  <trkpt lat="55.962017058999997" lon="37.834789276000002">    <time>2013-08-08T16:59:15Z</time>  </trkpt>  <trkpt lat="55.961952209000003" lon="37.834503173999998">    <time>2013-08-08T16:59:18Z</time>  </trkpt>  <trkpt lat="55.961887359999999" lon="37.834224700999997">    <time>2013-08-08T16:59:21Z</time>  </trkpt>  <trkpt lat="55.961826324" lon="37.833938599">    <time>2013-08-08T16:59:24Z</time>  </trkpt>  <trkpt lat="55.961772918999998" lon="37.833656310999999">    <time>2013-08-08T16:59:27Z</time>  </trkpt>  <trkpt lat="55.961723327999998" lon="37.833374022999998">    <time>2013-08-08T16:59:30Z</time>  </trkpt>  <trkpt lat="55.961666106999999" lon="37.833084106000001">    <time>2013-08-08T16:59:33Z</time>  </trkpt>  <trkpt lat="55.961601256999998" lon="37.832794188999998">    <time>2013-08-08T16:59:36Z</time>  </trkpt>  <trkpt lat="55.961528778000002" lon="37.832485198999997">    <time>2013-08-08T16:59:39Z</time>  </trkpt>  <trkpt lat="55.961475372000002" lon="37.832172393999997">    <time>2013-08-08T16:59:42Z</time>  </trkpt>  <trkpt lat="55.961410522000001" lon="37.831863403">    <time>2013-08-08T16:59:45Z</time>  </trkpt>  <trkpt lat="55.961345672999997" lon="37.831546783">    <time>2013-08-08T16:59:48Z</time>  </trkpt>  <trkpt lat="55.961288451999998" lon="37.831226348999998">    <time>2013-08-08T16:59:51Z</time>  </trkpt>  <trkpt lat="55.961227417000003" lon="37.830898285000004">    <time>2013-08-08T16:59:54Z</time>  </trkpt>  <trkpt lat="55.961162567000002" lon="37.830581664999997">    <time>2013-08-08T16:59:57Z</time>  </trkpt>  <trkpt lat="55.961101532000001" lon="37.830249786000003">    <time>2013-08-08T17:00:00Z</time>  </trkpt>  <trkpt lat="55.961032867" lon="37.829917907999999">    <time>2013-08-08T17:00:03Z</time>  </trkpt>  <trkpt lat="55.960964203000003" lon="37.829593658">    <time>2013-08-08T17:00:06Z</time>  </trkpt>  <trkpt lat="55.960899353000002" lon="37.829280853">    <time>2013-08-08T17:00:09Z</time>  </trkpt>  <trkpt lat="55.960838318" lon="37.828945160000004">    <time>2013-08-08T17:00:12Z</time>  </trkpt>  <trkpt lat="55.960773467999999" lon="37.828624724999997">    <time>2013-08-08T17:00:15Z</time>  </trkpt>  <trkpt lat="55.960697174000003" lon="37.828304291000002">    <time>2013-08-08T17:00:18Z</time>  </trkpt>  <trkpt lat="55.960628509999999" lon="37.827957153">    <time>2013-08-08T17:00:21Z</time>  </trkpt>  <trkpt lat="55.960559844999999" lon="37.827644348">    <time>2013-08-08T17:00:24Z</time>  </trkpt>  <trkpt lat="55.960479736000003" lon="37.827342987000002">    <time>2013-08-08T17:00:27Z</time>  </trkpt>  <trkpt lat="55.960399627999998" lon="37.827049254999999">    <time>2013-08-08T17:00:30Z</time>  </trkpt>  <trkpt lat="55.960330962999997" lon="37.8268013">    <time>2013-08-08T17:00:33Z</time>  </trkpt>  <trkpt lat="55.960254669000001" lon="37.826557158999996">    <time>2013-08-08T17:00:36Z</time>  </trkpt>  <trkpt lat="55.960166931000003" lon="37.826328277999998">    <time>2013-08-08T17:00:39Z</time>  </trkpt>  <trkpt lat="55.960094452" lon="37.826114654999998">    <time>2013-08-08T17:00:42Z</time>  </trkpt>  <trkpt lat="55.960010529000002" lon="37.825920105000002">    <time>2013-08-08T17:00:45Z</time>  </trkpt>  <trkpt lat="55.959934234999999" lon="37.825717926000003">    <time>2013-08-08T17:00:48Z</time>  </trkpt>  <trkpt lat="55.959888458000002" lon="37.825553894000002">    <time>2013-08-08T17:00:51Z</time>  </trkpt>  <trkpt lat="55.959888458000002" lon="37.825523376">    <time>2013-08-08T17:00:54Z</time>  </trkpt>  <trkpt lat="55.959888458000002" lon="37.825519561999997">    <time>2013-08-08T17:00:57Z</time>  </trkpt>  <trkpt lat="55.959896088000001" lon="37.82554245">    <time>2013-08-08T17:01:00Z</time>  </trkpt>  <trkpt lat="55.959896088000001" lon="37.825607300000001">    <time>2013-08-08T17:01:03Z</time>  </trkpt>  <trkpt lat="55.959918975999997" lon="37.825660706000001">    <time>2013-08-08T17:01:06Z</time>  </trkpt>  <trkpt lat="55.959945679" lon="37.825714111000003">    <time>2013-08-08T17:01:09Z</time>  </trkpt>  <trkpt lat="55.959964751999998" lon="37.825744628999999">    <time>2013-08-08T17:01:12Z</time>  </trkpt>  <trkpt lat="55.959983825999998" lon="37.825786591000004">    <time>2013-08-08T17:01:15Z</time>  </trkpt>  <trkpt lat="55.95999527" lon="37.825824738000001">    <time>2013-08-08T17:01:18Z</time>  </trkpt>  <trkpt lat="55.95999527" lon="37.825866699000002">    <time>2013-08-08T17:01:21Z</time>  </trkpt>  <trkpt lat="55.960002899000003" lon="37.825897216999998">    <time>2013-08-08T17:01:24Z</time>  </trkpt>  <trkpt lat="55.960021973000003" lon="37.825931549000003">    <time>2013-08-08T17:01:27Z</time>  </trkpt>  <trkpt lat="55.960033416999998" lon="37.825965881000002">    <time>2013-08-08T17:01:30Z</time>  </trkpt>  <trkpt lat="55.960033416999998" lon="37.825996398999997">    <time>2013-08-08T17:01:33Z</time>  </trkpt>  <trkpt lat="55.959899901999997" lon="37.825889586999999">    <time>2013-08-08T17:01:36Z</time>  </trkpt>  <trkpt lat="55.959823608000001" lon="37.825843810999999">    <time>2013-08-08T17:01:39Z</time>  </trkpt>  <trkpt lat="55.959796906000001" lon="37.825813293000003">    <time>2013-08-08T17:01:42Z</time>  </trkpt>  <trkpt lat="55.959793091000002" lon="37.825798034999998">    <time>2013-08-08T17:01:45Z</time>  </trkpt>  <trkpt lat="55.959747313999998" lon="37.825794219999999">    <time>2013-08-08T17:01:48Z</time>  </trkpt>  <trkpt lat="55.959720611999998" lon="37.825809479">    <time>2013-08-08T17:01:51Z</time>  </trkpt>  <trkpt lat="55.959716796999999" lon="37.825805664000001">    <time>2013-08-08T17:01:54Z</time>  </trkpt>  <trkpt lat="55.959701537999997" lon="37.825817108000003">    <time>2013-08-08T17:01:57Z</time>  </trkpt>  <trkpt lat="55.959655761999997" lon="37.825874329000001">    <time>2013-08-08T17:02:00Z</time>  </trkpt>  <trkpt lat="55.959579468000001" lon="37.825954437">    <time>2013-08-08T17:02:03Z</time>  </trkpt>  <trkpt lat="55.959510803000001" lon="37.826042174999998">    <time>2013-08-08T17:02:06Z</time>  </trkpt>  <trkpt lat="55.959438323999997" lon="37.826091765999998">    <time>2013-08-08T17:02:09Z</time>  </trkpt>  <trkpt lat="55.959358215000002" lon="37.826183319000002">    <time>2013-08-08T17:02:12Z</time>  </trkpt>  <trkpt lat="55.959247589" lon="37.826313018999997">    <time>2013-08-08T17:02:15Z</time>  </trkpt>  <trkpt lat="55.959140777999998" lon="37.826469420999999">    <time>2013-08-08T17:02:18Z</time>  </trkpt>  <trkpt lat="55.959037780999999" lon="37.826633452999999">    <time>2013-08-08T17:02:21Z</time>  </trkpt>  <trkpt lat="55.958919524999999" lon="37.826843261999997">    <time>2013-08-08T17:02:24Z</time>  </trkpt>  <trkpt lat="55.958812713999997" lon="37.827056884999998">    <time>2013-08-08T17:02:27Z</time>  </trkpt>  <trkpt lat="55.958740233999997" lon="37.827289581000002">    <time>2013-08-08T17:02:30Z</time>  </trkpt>  <trkpt lat="55.95867157" lon="37.827541351000001">    <time>2013-08-08T17:02:33Z</time>  </trkpt>  <trkpt lat="55.958553314" lon="37.827785491999997">    <time>2013-08-08T17:02:36Z</time>  </trkpt>  <trkpt lat="55.958442687999998" lon="37.828041077000002">    <time>2013-08-08T17:02:39Z</time>  </trkpt>  <trkpt lat="55.958328246999997" lon="37.828289032000001">    <time>2013-08-08T17:02:42Z</time>  </trkpt>  <trkpt lat="55.958229064999998" lon="37.828514099000003">    <time>2013-08-08T17:02:45Z</time>  </trkpt>  <trkpt lat="55.958126067999999" lon="37.828727722000004">    <time>2013-08-08T17:02:48Z</time>  </trkpt>  <trkpt lat="55.958034515000001" lon="37.828907012999998">    <time>2013-08-08T17:02:51Z</time>  </trkpt>  <trkpt lat="55.957969665999997" lon="37.829032898000001">    <time>2013-08-08T17:02:54Z</time>  </trkpt>  <trkpt lat="55.957916259999998" lon="37.829097748000002">    <time>2013-08-08T17:02:57Z</time>  </trkpt>  <trkpt lat="55.957885742000002" lon="37.829120635999999">    <time>2013-08-08T17:03:00Z</time>  </trkpt>  <trkpt lat="55.957889557000001" lon="37.829139709000003">    <time>2013-08-08T17:03:03Z</time>  </trkpt>  <trkpt lat="55.957881927000003" lon="37.829143524000003">    <time>2013-08-08T17:03:06Z</time>  </trkpt>  <trkpt lat="55.957881927000003" lon="37.829147339000002">    <time>2013-08-08T17:03:09Z</time>  </trkpt>  <trkpt lat="55.957881927000003" lon="37.829151154000002">    <time>2013-08-08T17:03:24Z</time>  </trkpt>  <trkpt lat="55.957885742000002" lon="37.829154967999997">    <time>2013-08-08T17:03:27Z</time>  </trkpt>  <trkpt lat="55.957927703999999" lon="37.829219817999999">    <time>2013-08-08T17:03:30Z</time>  </trkpt>  <trkpt lat="55.958000183000003" lon="37.829307556000003">    <time>2013-08-08T17:03:33Z</time>  </trkpt>  <trkpt lat="55.958068848000003" lon="37.829399109000001">    <time>2013-08-08T17:03:36Z</time>  </trkpt>  <trkpt lat="55.958145141999999" lon="37.829467772999998">    <time>2013-08-08T17:03:39Z</time>  </trkpt>  <trkpt lat="55.958209990999997" lon="37.829559326000002">    <time>2013-08-08T17:03:42Z</time>  </trkpt>  <trkpt lat="55.958278655999997" lon="37.829643249999997">    <time>2013-08-08T17:03:45Z</time>  </trkpt>  <trkpt lat="55.958374022999998" lon="37.829704284999998">    <time>2013-08-08T17:03:48Z</time>  </trkpt>  <trkpt lat="55.958465576000002" lon="37.829776764000002">    <time>2013-08-08T17:03:51Z</time>  </trkpt>  <trkpt lat="55.958568573000001" lon="37.829822540000002">    <time>2013-08-08T17:03:54Z</time>  </trkpt>  <trkpt lat="55.958644866999997" lon="37.829860687">    <time>2013-08-08T17:03:57Z</time>  </trkpt>  <trkpt lat="55.958667755" lon="37.829887390000003">    <time>2013-08-08T17:04:00Z</time>  </trkpt>  <trkpt lat="55.958667755" lon="37.829898833999998">    <time>2013-08-08T17:04:03Z</time>  </trkpt>  <trkpt lat="55.958675384999999" lon="37.829902648999997">    <time>2013-08-08T17:04:06Z</time>  </trkpt>  <trkpt lat="55.958686829000001" lon="37.829936981000003">    <time>2013-08-08T17:04:09Z</time>  </trkpt>  <trkpt lat="55.958683014000002" lon="37.829959869">    <time>2013-08-08T17:04:12Z</time>  </trkpt>  <trkpt lat="55.958686829000001" lon="37.829967498999999">    <time>2013-08-08T17:04:15Z</time>  </trkpt>  <trkpt lat="55.958679199000002" lon="37.830028534">    <time>2013-08-08T17:04:18Z</time>  </trkpt>  <trkpt lat="55.958663940000001" lon="37.830131530999999">    <time>2013-08-08T17:04:21Z</time>  </trkpt>  <trkpt lat="55.958656310999999" lon="37.830249786000003">    <time>2013-08-08T17:04:24Z</time>  </trkpt>  <trkpt lat="55.958641051999997" lon="37.830375670999999">    <time>2013-08-08T17:04:27Z</time>  </trkpt>  <trkpt lat="55.958610534999998" lon="37.830486297999997">    <time>2013-08-08T17:04:30Z</time>  </trkpt>  <trkpt lat="55.958568573000001" lon="37.830513000000003">    <time>2013-08-08T17:04:33Z</time>  </trkpt>  <trkpt lat="55.958560943999998" lon="37.830509186">    <time>2013-08-08T17:04:36Z</time>  </trkpt>  <trkpt lat="55.958560943999998" lon="37.830505371000001">    <time>2013-08-08T17:04:39Z</time>  </trkpt>  <trkpt lat="55.958560943999998" lon="37.830509186">    <time>2013-08-08T17:04:42Z</time>  </trkpt>  <trkpt lat="55.958560943999998" lon="37.830505371000001">    <time>2013-08-08T17:04:54Z</time>  </trkpt>  <trkpt lat="55.958557128999999" lon="37.830501556000002">    <time>2013-08-08T17:05:42Z</time>  </trkpt>  <trkpt lat="55.958507537999999" lon="37.830463408999996">    <time>2013-08-08T17:05:45Z</time>  </trkpt>  <trkpt lat="55.958438872999999" lon="37.830425261999999">    <time>2013-08-08T17:05:48Z</time>  </trkpt>  <trkpt lat="55.958351135000001" lon="37.830371857000003">    <time>2013-08-08T17:05:51Z</time>  </trkpt>  <trkpt lat="55.958255768000001" lon="37.830326079999999">    <time>2013-08-08T17:05:54Z</time>  </trkpt>  <trkpt lat="55.958152771000002" lon="37.830295563">    <time>2013-08-08T17:05:57Z</time>  </trkpt>  <trkpt lat="55.958038330000001" lon="37.830242157000001">    <time>2013-08-08T17:06:00Z</time>  </trkpt>  <trkpt lat="55.957916259999998" lon="37.830188751000001">    <time>2013-08-08T17:06:03Z</time>  </trkpt>  <trkpt lat="55.957790375000002" lon="37.830135345000002">    <time>2013-08-08T17:06:06Z</time>  </trkpt>  <trkpt lat="55.957660675" lon="37.830081939999999">    <time>2013-08-08T17:06:09Z</time>  </trkpt>  <trkpt lat="55.957530974999997" lon="37.830043793000002">    <time>2013-08-08T17:06:12Z</time>  </trkpt>  <trkpt lat="55.957412720000001" lon="37.830024719000001">    <time>2013-08-08T17:06:15Z</time>  </trkpt>  <trkpt lat="55.957305908000002" lon="37.830024719000001">    <time>2013-08-08T17:06:18Z</time>  </trkpt>  <trkpt lat="55.957218169999997" lon="37.830032349">    <time>2013-08-08T17:06:21Z</time>  </trkpt>  <trkpt lat="55.957157135000003" lon="37.830043793000002">    <time>2013-08-08T17:06:24Z</time>  </trkpt>  <trkpt lat="55.957130432" lon="37.830055237000003">    <time>2013-08-08T17:06:27Z</time>  </trkpt>  <trkpt lat="55.957130432" lon="37.830047606999997">    <time>2013-08-08T17:06:30Z</time>  </trkpt>  <trkpt lat="55.957130432" lon="37.830043793000002">    <time>2013-08-08T17:06:33Z</time>  </trkpt>  <trkpt lat="55.957130432" lon="37.830032349">    <time>2013-08-08T17:06:36Z</time>  </trkpt>  <trkpt lat="55.957130432" lon="37.830024719000001">    <time>2013-08-08T17:06:39Z</time>  </trkpt>  <trkpt lat="55.957134246999999" lon="37.830028534">    <time>2013-08-08T17:06:42Z</time>  </trkpt>  <trkpt lat="55.957141876000001" lon="37.830020904999998">    <time>2013-08-08T17:06:45Z</time>  </trkpt>  <trkpt lat="55.957153320000003" lon="37.830020904999998">    <time>2013-08-08T17:06:48Z</time>  </trkpt>  <trkpt lat="55.957202911000003" lon="37.830028534">    <time>2013-08-08T17:06:51Z</time>  </trkpt>  <trkpt lat="55.957286834999998" lon="37.830032349">    <time>2013-08-08T17:06:54Z</time>  </trkpt>  <trkpt lat="55.957386016999997" lon="37.830020904999998">    <time>2013-08-08T17:06:57Z</time>  </trkpt>  <trkpt lat="55.957489013999997" lon="37.830013274999999">    <time>2013-08-08T17:07:00Z</time>  </trkpt>  <trkpt lat="55.957592009999999" lon="37.830024719000001">    <time>2013-08-08T17:07:03Z</time>  </trkpt>  <trkpt lat="55.957706451" lon="37.830062865999999">    <time>2013-08-08T17:07:06Z</time>  </trkpt>  <trkpt lat="55.957817077999998" lon="37.830097197999997">    <time>2013-08-08T17:07:09Z</time>  </trkpt>  <trkpt lat="55.957935333000002" lon="37.830135345000002">    <time>2013-08-08T17:07:12Z</time>  </trkpt>  <trkpt lat="55.958061217999997" lon="37.830184936999999">    <time>2013-08-08T17:07:15Z</time>  </trkpt>  <trkpt lat="55.958183288999997" lon="37.830238342000001">    <time>2013-08-08T17:07:18Z</time>  </trkpt>  <trkpt lat="55.958305359000001" lon="37.830284118999998">    <time>2013-08-08T17:07:21Z</time>  </trkpt>  <trkpt lat="55.958427428999997" lon="37.830352783000002">    <time>2013-08-08T17:07:24Z</time>  </trkpt>  <trkpt lat="55.958541869999998" lon="37.830444335999999">    <time>2013-08-08T17:07:27Z</time>  </trkpt>  <trkpt lat="55.958652495999999" lon="37.830570221000002">    <time>2013-08-08T17:07:30Z</time>  </trkpt>  <trkpt lat="55.958755492999998" lon="37.830715179000002">    <time>2013-08-08T17:07:33Z</time>  </trkpt>  <trkpt lat="55.958835602000001" lon="37.830883026000002">    <time>2013-08-08T17:07:36Z</time>  </trkpt>  <trkpt lat="55.958908080999997" lon="37.831066131999997">    <time>2013-08-08T17:07:39Z</time>  </trkpt>  <trkpt lat="55.958980560000001" lon="37.831256865999997">    <time>2013-08-08T17:07:42Z</time>  </trkpt>  <trkpt lat="55.959056854000004" lon="37.831439971999998">    <time>2013-08-08T17:07:45Z</time>  </trkpt>  <trkpt lat="55.959095001000001" lon="37.831634520999998">    <time>2013-08-08T17:07:48Z</time>  </trkpt>  <trkpt lat="55.959091186999999" lon="37.831844330000003">    <time>2013-08-08T17:07:51Z</time>  </trkpt>  <trkpt lat="55.959049225000001" lon="37.831977844000001">    <time>2013-08-08T17:07:54Z</time>  </trkpt>  <trkpt lat="55.958984375" lon="37.832042694000002">    <time>2013-08-08T17:07:57Z</time>  </trkpt>  <trkpt lat="55.958908080999997" lon="37.832057953000003">    <time>2013-08-08T17:08:00Z</time>  </trkpt>  <trkpt lat="55.958824157999999" lon="37.832065581999998">    <time>2013-08-08T17:08:03Z</time>  </trkpt>  <trkpt lat="55.958732605000002" lon="37.832103729000004">    <time>2013-08-08T17:08:06Z</time>  </trkpt>  <trkpt lat="55.958637238000001" lon="37.832168578999998">    <time>2013-08-08T17:08:09Z</time>  </trkpt>  <trkpt lat="55.958564758000001" lon="37.832183837999999">    <time>2013-08-08T17:08:12Z</time>  </trkpt>  <trkpt lat="55.958568573000001" lon="37.832180022999999">    <time>2013-08-08T17:08:18Z</time>  </trkpt>  <trkpt lat="55.958564758000001" lon="37.832183837999999">    <time>2013-08-08T17:08:21Z</time>  </trkpt>  <trkpt lat="55.958564758000001" lon="37.832187652999998">    <time>2013-08-08T17:08:39Z</time>  </trkpt>  <trkpt lat="55.958564758000001" lon="37.832183837999999">    <time>2013-08-08T17:08:48Z</time>  </trkpt>  <trkpt lat="55.958549499999997" lon="37.832199097">    <time>2013-08-08T17:08:51Z</time>  </trkpt>  <trkpt lat="55.958541869999998" lon="37.832237243999998">    <time>2013-08-08T17:08:54Z</time>  </trkpt>  <trkpt lat="55.958538054999998" lon="37.832260132000002">    <time>2013-08-08T17:08:57Z</time>  </trkpt>  <trkpt lat="55.958530426000003" lon="37.832286834999998">    <time>2013-08-08T17:09:00Z</time>  </trkpt>  <trkpt lat="55.958526611000003" lon="37.832305908000002">    <time>2013-08-08T17:09:03Z</time>  </trkpt>  <trkpt lat="55.958515167000002" lon="37.832321167000003">    <time>2013-08-08T17:09:06Z</time>  </trkpt>  <trkpt lat="55.958503723" lon="37.832420349000003">    <time>2013-08-08T17:09:09Z</time>  </trkpt>  <trkpt lat="55.958496093999997" lon="37.832546233999999">    <time>2013-08-08T17:09:12Z</time>  </trkpt>  <trkpt lat="55.958492278999998" lon="37.832687378000003">    <time>2013-08-08T17:09:15Z</time>  </trkpt>  <trkpt lat="55.958484650000003" lon="37.832824707">    <time>2013-08-08T17:09:18Z</time>  </trkpt>  <trkpt lat="55.958488463999998" lon="37.832977294999999">    <time>2013-08-08T17:09:21Z</time>  </trkpt>  <trkpt lat="55.958480835000003" lon="37.833118439000003">    <time>2013-08-08T17:09:24Z</time>  </trkpt>  <trkpt lat="55.958473206000001" lon="37.833209990999997">    <time>2013-08-08T17:09:27Z</time>  </trkpt>  <trkpt lat="55.958477019999997" lon="37.833255768000001">    <time>2013-08-08T17:09:30Z</time>  </trkpt>  <trkpt lat="55.958469391000001" lon="37.833309174">    <time>2013-08-08T17:09:33Z</time>  </trkpt>  <trkpt lat="55.958465576000002" lon="37.833427428999997">    <time>2013-08-08T17:09:36Z</time>  </trkpt>  <trkpt lat="55.958488463999998" lon="37.833538054999998">    <time>2013-08-08T17:09:39Z</time>  </trkpt>  <trkpt lat="55.958549499999997" lon="37.833644866999997">    <time>2013-08-08T17:09:42Z</time>  </trkpt>  <trkpt lat="55.958614349000001" lon="37.833740233999997">    <time>2013-08-08T17:09:45Z</time>  </trkpt>  <trkpt lat="55.958675384999999" lon="37.833869933999999">    <time>2013-08-08T17:09:48Z</time>  </trkpt>  <trkpt lat="55.958740233999997" lon="37.833980560000001">    <time>2013-08-08T17:09:51Z</time>  </trkpt>  <trkpt lat="55.958812713999997" lon="37.834079742">    <time>2013-08-08T17:09:54Z</time>  </trkpt>  <trkpt lat="55.958862304999997" lon="37.834220885999997">    <time>2013-08-08T17:09:57Z</time>  </trkpt>  <trkpt lat="55.958873748999999" lon="37.834381104000002">    <time>2013-08-08T17:10:00Z</time>  </trkpt>  <trkpt lat="55.958873748999999" lon="37.834533690999997">    <time>2013-08-08T17:10:03Z</time>  </trkpt>  <trkpt lat="55.958862304999997" lon="37.834667205999999">    <time>2013-08-08T17:10:06Z</time>  </trkpt>  <trkpt lat="55.958858489999997" lon="37.834804535000004">    <time>2013-08-08T17:10:09Z</time>  </trkpt>  <trkpt lat="55.958850861000002" lon="37.834972381999997">    <time>2013-08-08T17:10:12Z</time>  </trkpt>  <trkpt lat="55.958835602000001" lon="37.835128783999998">    <time>2013-08-08T17:10:15Z</time>  </trkpt>  <trkpt lat="55.958835602000001" lon="37.835300445999998">    <time>2013-08-08T17:10:18Z</time>  </trkpt>  <trkpt lat="55.958831787000001" lon="37.835491179999998">    <time>2013-08-08T17:10:21Z</time>  </trkpt>  <trkpt lat="55.958801270000002" lon="37.835758208999998">    <time>2013-08-08T17:10:24Z</time>  </trkpt>  <trkpt lat="55.958770752" lon="37.836032867">    <time>2013-08-08T17:10:27Z</time>  </trkpt>  <trkpt lat="55.958747864000003" lon="37.836315155000001">    <time>2013-08-08T17:10:30Z</time>  </trkpt>  <trkpt lat="55.958717346" lon="37.836616515999999">    <time>2013-08-08T17:10:33Z</time>  </trkpt>  <trkpt lat="55.958679199000002" lon="37.836917876999998">    <time>2013-08-08T17:10:36Z</time>  </trkpt>  <trkpt lat="55.958625793000003" lon="37.837173462000003">    <time>2013-08-08T17:10:39Z</time>  </trkpt>  <trkpt lat="55.958576202000003" lon="37.837440491000002">    <time>2013-08-08T17:10:42Z</time>  </trkpt>  <trkpt lat="55.958518982000001" lon="37.837718963999997">    <time>2013-08-08T17:10:45Z</time>  </trkpt>  <trkpt lat="55.958450317" lon="37.837982177999997">    <time>2013-08-08T17:10:48Z</time>  </trkpt>  <trkpt lat="55.958389281999999" lon="37.838226317999997">    <time>2013-08-08T17:10:51Z</time>  </trkpt>  <trkpt lat="55.958320618000002" lon="37.838459014999998">    <time>2013-08-08T17:10:54Z</time>  </trkpt>  <trkpt lat="55.958263397000003" lon="37.838722228999998">    <time>2013-08-08T17:10:57Z</time>  </trkpt>  <trkpt lat="55.958213806000003" lon="37.838985442999999">    <time>2013-08-08T17:11:00Z</time>  </trkpt>  <trkpt lat="55.958183288999997" lon="37.839248656999999">    <time>2013-08-08T17:11:03Z</time>  </trkpt>  <trkpt lat="55.958171843999999" lon="37.83952713">    <time>2013-08-08T17:11:06Z</time>  </trkpt>  <trkpt lat="55.958179473999998" lon="37.839790344000001">    <time>2013-08-08T17:11:09Z</time>  </trkpt>  <trkpt lat="55.958213806000003" lon="37.840023041000002">    <time>2013-08-08T17:11:12Z</time>  </trkpt>  <trkpt lat="55.958187103" lon="37.840225220000001">    <time>2013-08-08T17:11:15Z</time>  </trkpt>  <trkpt lat="55.958087921000001" lon="37.840351105000003">    <time>2013-08-08T17:11:18Z</time>  </trkpt>  <trkpt lat="55.95797348" lon="37.84046936">    <time>2013-08-08T17:11:21Z</time>  </trkpt>  <trkpt lat="55.957866668999998" lon="37.840618134000003">    <time>2013-08-08T17:11:24Z</time>  </trkpt>  <trkpt lat="55.957725525000001" lon="37.840755463000001">    <time>2013-08-08T17:11:27Z</time>  </trkpt>  <trkpt lat="55.957611084" lon="37.840950012">    <time>2013-08-08T17:11:30Z</time>  </trkpt>  <trkpt lat="55.957492827999999" lon="37.841121674">    <time>2013-08-08T17:11:33Z</time>  </trkpt>  <trkpt lat="55.957374573000003" lon="37.841285706000001">    <time>2013-08-08T17:11:36Z</time>  </trkpt>  <trkpt lat="55.957252502000003" lon="37.841430664000001">    <time>2013-08-08T17:11:39Z</time>  </trkpt>  <trkpt lat="55.957126617" lon="37.841564177999999">    <time>2013-08-08T17:11:42Z</time>  </trkpt>  <trkpt lat="55.957004546999997" lon="37.841712952000002">    <time>2013-08-08T17:11:45Z</time>  </trkpt>  <trkpt lat="55.956890106000003" lon="37.841861725000001">    <time>2013-08-08T17:11:48Z</time>  </trkpt>  <trkpt lat="55.956790924000003" lon="37.841995238999999">    <time>2013-08-08T17:11:51Z</time>  </trkpt>  <trkpt lat="55.956764221" lon="37.842185974000003">    <time>2013-08-08T17:11:54Z</time>  </trkpt>  <trkpt lat="55.956729889000002" lon="37.842338562000002">    <time>2013-08-08T17:11:57Z</time>  </trkpt>  <trkpt lat="55.956691741999997" lon="37.842456818000002">    <time>2013-08-08T17:12:00Z</time>  </trkpt>  <trkpt lat="55.956684113000001" lon="37.842536926000001">    <time>2013-08-08T17:12:03Z</time>  </trkpt>  <trkpt lat="55.956722259999999" lon="37.842613219999997">    <time>2013-08-08T17:12:06Z</time>  </trkpt>  <trkpt lat="55.956787108999997" lon="37.842655182000001">    <time>2013-08-08T17:12:09Z</time>  </trkpt>  <trkpt lat="55.956825256000002" lon="37.842720032000003">    <time>2013-08-08T17:12:12Z</time>  </trkpt>  <trkpt lat="55.956863403" lon="37.842754364000001">    <time>2013-08-08T17:12:15Z</time>  </trkpt>  <trkpt lat="55.956874847000002" lon="37.842754364000001">    <time>2013-08-08T17:12:18Z</time>  </trkpt>  <trkpt lat="55.956893921000002" lon="37.842815399000003">    <time>2013-08-08T17:12:21Z</time>  </trkpt>  <trkpt lat="55.956863403" lon="37.842864990000002">    <time>2013-08-08T17:12:24Z</time>  </trkpt>  <trkpt lat="55.956790924000003" lon="37.842788696">    <time>2013-08-08T17:12:27Z</time>  </trkpt>  <trkpt lat="55.956687926999997" lon="37.842632293999998">    <time>2013-08-08T17:12:30Z</time>  </trkpt>  <trkpt lat="55.956550598" lon="37.842494965">    <time>2013-08-08T17:12:33Z</time>  </trkpt>  <trkpt lat="55.956398010000001" lon="37.842365264999998">    <time>2013-08-08T17:12:36Z</time>  </trkpt>  <trkpt lat="55.956245422000002" lon="37.842231750000003">    <time>2013-08-08T17:12:39Z</time>  </trkpt>  <trkpt lat="55.956081390000001" lon="37.842113495">    <time>2013-08-08T17:12:42Z</time>  </trkpt>  <trkpt lat="55.955913543999998" lon="37.841995238999999">    <time>2013-08-08T17:12:45Z</time>  </trkpt>  <trkpt lat="55.955749511999997" lon="37.841865540000001">    <time>2013-08-08T17:12:48Z</time>  </trkpt>  <trkpt lat="55.955585480000003" lon="37.841754913000003">    <time>2013-08-08T17:12:51Z</time>  </trkpt>  <trkpt lat="55.955417633000003" lon="37.841609955000003">    <time>2013-08-08T17:12:54Z</time>  </trkpt>  <trkpt lat="55.955245972" lon="37.841468810999999">    <time>2013-08-08T17:12:57Z</time>  </trkpt>  <trkpt lat="55.955081939999999" lon="37.841339111000003">    <time>2013-08-08T17:13:00Z</time>  </trkpt>  <trkpt lat="55.954914092999999" lon="37.841209411999998">    <time>2013-08-08T17:13:03Z</time>  </trkpt>  <trkpt lat="55.954750060999999" lon="37.841072083">    <time>2013-08-08T17:13:06Z</time>  </trkpt>  <trkpt lat="55.954570769999997" lon="37.840946197999997">    <time>2013-08-08T17:13:09Z</time>  </trkpt>  <trkpt lat="55.954399109000001" lon="37.84078598">    <time>2013-08-08T17:13:12Z</time>  </trkpt>  <trkpt lat="55.954219817999999" lon="37.840641022">    <time>2013-08-08T17:13:15Z</time>  </trkpt>  <trkpt lat="55.954051970999998" lon="37.840496063000003">    <time>2013-08-08T17:13:18Z</time>  </trkpt>  <trkpt lat="55.953872681" lon="37.840366363999998">    <time>2013-08-08T17:13:21Z</time>  </trkpt>  <trkpt lat="55.953712463000002" lon="37.840221405000001">    <time>2013-08-08T17:13:24Z</time>  </trkpt>  <trkpt lat="55.953544616999999" lon="37.840065002000003">    <time>2013-08-08T17:13:27Z</time>  </trkpt>  <trkpt lat="55.953395843999999" lon="37.839923859000002">    <time>2013-08-08T17:13:30Z</time>  </trkpt>  <trkpt lat="55.953212737999998" lon="37.839782714999998">    <time>2013-08-08T17:13:33Z</time>  </trkpt>  <trkpt lat="55.953010558999999" lon="37.839630127">    <time>2013-08-08T17:13:36Z</time>  </trkpt>  <trkpt lat="55.952831267999997" lon="37.839481354">    <time>2013-08-08T17:13:39Z</time>  </trkpt>  <trkpt lat="55.952644348" lon="37.839359283">    <time>2013-08-08T17:13:42Z</time>  </trkpt>  <trkpt lat="55.952468871999997" lon="37.839233397999998">    <time>2013-08-08T17:13:45Z</time>  </trkpt>  <trkpt lat="55.952320098999998" lon="37.839153289999999">    <time>2013-08-08T17:13:48Z</time>  </trkpt>  <trkpt lat="55.952194214000002" lon="37.839061737000002">    <time>2013-08-08T17:13:51Z</time>  </trkpt>  <trkpt lat="55.952075958000002" lon="37.838985442999999">    <time>2013-08-08T17:13:54Z</time>  </trkpt>  <trkpt lat="55.951995850000003" lon="37.83890152">    <time>2013-08-08T17:13:57Z</time>  </trkpt>  <trkpt lat="55.951999663999999" lon="37.83890152">    <time>2013-08-08T17:14:00Z</time>  </trkpt>  <trkpt lat="55.952003478999998" lon="37.838897705000001">    <time>2013-08-08T17:14:03Z</time>  </trkpt>  <trkpt lat="55.952003478999998" lon="37.83890152">    <time>2013-08-08T17:14:33Z</time>  </trkpt>  <trkpt lat="55.952003478999998" lon="37.838897705000001">    <time>2013-08-08T17:14:36Z</time>  </trkpt>  <trkpt lat="55.952007293999998" lon="37.838893890000001">    <time>2013-08-08T17:14:39Z</time>  </trkpt>  <trkpt lat="55.952011108000001" lon="37.838893890000001">    <time>2013-08-08T17:14:48Z</time>  </trkpt>  <trkpt lat="55.952011108000001" lon="37.838890075999998">    <time>2013-08-08T17:14:54Z</time>  </trkpt>  <trkpt lat="55.952011108000001" lon="37.838893890000001">    <time>2013-08-08T17:15:15Z</time>  </trkpt>  <trkpt lat="55.952007293999998" lon="37.838890075999998">    <time>2013-08-08T17:15:18Z</time>  </trkpt>  <trkpt lat="55.951953887999998" lon="37.838890075999998">    <time>2013-08-08T17:15:21Z</time>  </trkpt>  <trkpt lat="55.951869965" lon="37.838813782000003">    <time>2013-08-08T17:15:24Z</time>  </trkpt>  <trkpt lat="55.951763153000002" lon="37.838703156000001">    <time>2013-08-08T17:15:27Z</time>  </trkpt>  <trkpt lat="55.951614380000002" lon="37.838542938000003">    <time>2013-08-08T17:15:30Z</time>  </trkpt>  <trkpt lat="55.951465607000003" lon="37.838382721000002">    <time>2013-08-08T17:15:33Z</time>  </trkpt>  <trkpt lat="55.951316833" lon="37.838191985999998">    <time>2013-08-08T17:15:36Z</time>  </trkpt>  <trkpt lat="55.951171875" lon="37.838012695000003">    <time>2013-08-08T17:15:39Z</time>  </trkpt>  <trkpt lat="55.951023102000001" lon="37.837818145999996">    <time>2013-08-08T17:15:42Z</time>  </trkpt>  <trkpt lat="55.950881957999997" lon="37.837604523000003">    <time>2013-08-08T17:15:45Z</time>  </trkpt>  <trkpt lat="55.950752258000001" lon="37.837371826000002">    <time>2013-08-08T17:15:48Z</time>  </trkpt>  <trkpt lat="55.950618744000003" lon="37.837142944">    <time>2013-08-08T17:15:51Z</time>  </trkpt>  <trkpt lat="55.950492859000001" lon="37.836917876999998">    <time>2013-08-08T17:15:54Z</time>  </trkpt>  <trkpt lat="55.950370788999997" lon="37.836692810000002">    <time>2013-08-08T17:15:57Z</time>  </trkpt>  <trkpt lat="55.950267791999998" lon="37.836467743">    <time>2013-08-08T17:16:00Z</time>  </trkpt>  <trkpt lat="55.950164794999999" lon="37.836231232000003">    <time>2013-08-08T17:16:03Z</time>  </trkpt>  <trkpt lat="55.950061798" lon="37.835956572999997">    <time>2013-08-08T17:16:06Z</time>  </trkpt>  <trkpt lat="55.949974060000002" lon="37.835674286">    <time>2013-08-08T17:16:09Z</time>  </trkpt>  <trkpt lat="55.949897765999999" lon="37.835407257">    <time>2013-08-08T17:16:12Z</time>  </trkpt>  <trkpt lat="55.949829102000002" lon="37.835144043">    <time>2013-08-08T17:16:15Z</time>  </trkpt>  <trkpt lat="55.949737548999998" lon="37.834903717000003">    <time>2013-08-08T17:16:18Z</time>  </trkpt>  <trkpt lat="55.949649811" lon="37.834659576">    <time>2013-08-08T17:16:21Z</time>  </trkpt>  <trkpt lat="55.949558258000003" lon="37.834411621000001">    <time>2013-08-08T17:16:24Z</time>  </trkpt>  <trkpt lat="55.949447632000002" lon="37.834190368999998">    <time>2013-08-08T17:16:27Z</time>  </trkpt>  <trkpt lat="55.949371337999999" lon="37.833942413000003">    <time>2013-08-08T17:16:30Z</time>  </trkpt>  <trkpt lat="55.949283600000001" lon="37.833705901999998">    <time>2013-08-08T17:16:33Z</time>  </trkpt>  <trkpt lat="55.949188231999997" lon="37.833477019999997">    <time>2013-08-08T17:16:36Z</time>  </trkpt>  <trkpt lat="55.949092864999997" lon="37.833274840999998">    <time>2013-08-08T17:16:39Z</time>  </trkpt>  <trkpt lat="55.949008941999999" lon="37.833087921000001">    <time>2013-08-08T17:16:42Z</time>  </trkpt>  <trkpt lat="55.948932648000003" lon="37.832927703999999">    <time>2013-08-08T17:16:45Z</time>  </trkpt>  <trkpt lat="55.948863983000003" lon="37.832767486999998">    <time>2013-08-08T17:16:48Z</time>  </trkpt>  <trkpt lat="55.948814392000003" lon="37.832645415999998">    <time>2013-08-08T17:16:51Z</time>  </trkpt>  <trkpt lat="55.948783874999997" lon="37.832557678000001">    <time>2013-08-08T17:16:54Z</time>  </trkpt>  <trkpt lat="55.948791503999999" lon="37.832447051999999">    <time>2013-08-08T17:16:57Z</time>  </trkpt>  <trkpt lat="55.948795318999998" lon="37.83234787">    <time>2013-08-08T17:17:00Z</time>  </trkpt>  <trkpt lat="55.948768616000002" lon="37.832260132000002">    <time>2013-08-08T17:17:03Z</time>  </trkpt>  <trkpt lat="55.948749542000002" lon="37.832248688">    <time>2013-08-08T17:17:06Z</time>  </trkpt>  <trkpt lat="55.948745727999999" lon="37.832256317000002">    <time>2013-08-08T17:17:09Z</time>  </trkpt>  <trkpt lat="55.948745727999999" lon="37.832252502000003">    <time>2013-08-08T17:17:21Z</time>  </trkpt>  <trkpt lat="55.948745727999999" lon="37.832256317000002">    <time>2013-08-08T17:17:24Z</time>  </trkpt>  <trkpt lat="55.948745727999999" lon="37.832252502000003">    <time>2013-08-08T17:17:54Z</time>  </trkpt>  <trkpt lat="55.948749542000002" lon="37.832252502000003">    <time>2013-08-08T17:18:03Z</time>  </trkpt>  <trkpt lat="55.948749542000002" lon="37.832256317000002">    <time>2013-08-08T17:19:09Z</time>  </trkpt>  <trkpt lat="55.948745727999999" lon="37.832256317000002">    <time>2013-08-08T17:19:21Z</time>  </trkpt>  <trkpt lat="55.948745727999999" lon="37.832260132000002">    <time>2013-08-08T17:19:30Z</time>  </trkpt>  <trkpt lat="55.948745727999999" lon="37.832252502000003">    <time>2013-08-08T17:19:36Z</time>  </trkpt>  <trkpt lat="55.948745727999999" lon="37.832256317000002">    <time>2013-08-08T17:19:39Z</time>  </trkpt>  <trkpt lat="55.948745727999999" lon="37.832260132000002">    <time>2013-08-08T17:20:45Z</time>  </trkpt>  <trkpt lat="55.948741912999999" lon="37.832260132000002">    <time>2013-08-08T17:21:00Z</time>  </trkpt>  <trkpt lat="55.948734283" lon="37.832267760999997">    <time>2013-08-08T17:21:09Z</time>  </trkpt>  <trkpt lat="55.948680877999998" lon="37.832271575999997">    <time>2013-08-08T17:21:12Z</time>  </trkpt>  <trkpt lat="55.948623656999999" lon="37.832260132000002">    <time>2013-08-08T17:21:15Z</time>  </trkpt>  <trkpt lat="55.948566436999997" lon="37.832355499000002">    <time>2013-08-08T17:21:18Z</time>  </trkpt>  <trkpt lat="55.948558806999998" lon="37.832492827999999">    <time>2013-08-08T17:21:21Z</time>  </trkpt>  <trkpt lat="55.948486328000001" lon="37.832664489999999">    <time>2013-08-08T17:21:24Z</time>  </trkpt>  <trkpt lat="55.948379516999999" lon="37.832832336000003">    <time>2013-08-08T17:21:27Z</time>  </trkpt>  <trkpt lat="55.948253631999997" lon="37.832996368000003">    <time>2013-08-08T17:21:30Z</time>  </trkpt>  <trkpt lat="55.948131560999997" lon="37.833171843999999">    <time>2013-08-08T17:21:33Z</time>  </trkpt>  <trkpt lat="55.948005676000001" lon="37.833351135000001">    <time>2013-08-08T17:21:36Z</time>  </trkpt>  <trkpt lat="55.947875977000002" lon="37.833538054999998">    <time>2013-08-08T17:21:39Z</time>  </trkpt>  <trkpt lat="55.947734832999998" lon="37.833740233999997">    <time>2013-08-08T17:21:42Z</time>  </trkpt>  <trkpt lat="55.947589874000002" lon="37.833946228000002">    <time>2013-08-08T17:21:45Z</time>  </trkpt>  <trkpt lat="55.947441101000003" lon="37.834152222">    <time>2013-08-08T17:21:48Z</time>  </trkpt>  <trkpt lat="55.947292328000003" lon="37.834365845000001">    <time>2013-08-08T17:21:51Z</time>  </trkpt>  <trkpt lat="55.947147369" lon="37.834587097000004">    <time>2013-08-08T17:21:54Z</time>  </trkpt>  <trkpt lat="55.947002411" lon="37.834789276000002">    <time>2013-08-08T17:21:57Z</time>  </trkpt>  <trkpt lat="55.946846008000001" lon="37.834999084000003">    <time>2013-08-08T17:22:00Z</time>  </trkpt>  <trkpt lat="55.946697235000002" lon="37.835227965999998">    <time>2013-08-08T17:22:03Z</time>  </trkpt>  <trkpt lat="55.946548462000003" lon="37.835441588999998">    <time>2013-08-08T17:22:06Z</time>  </trkpt>  <trkpt lat="55.946395873999997" lon="37.835655211999999">    <time>2013-08-08T17:22:09Z</time>  </trkpt>  <trkpt lat="55.946243285999998" lon="37.835876464999998">    <time>2013-08-08T17:22:12Z</time>  </trkpt>  <trkpt lat="55.946094512999998" lon="37.836090087999999">    <time>2013-08-08T17:22:15Z</time>  </trkpt>  <trkpt lat="55.945941925" lon="37.836299896">    <time>2013-08-08T17:22:18Z</time>  </trkpt>  <trkpt lat="55.945777892999999" lon="37.836524963000002">    <time>2013-08-08T17:22:21Z</time>  </trkpt>  <trkpt lat="55.945632934999999" lon="37.836746216000002">    <time>2013-08-08T17:22:24Z</time>  </trkpt>  <trkpt lat="55.945484161000003" lon="37.836978911999999">    <time>2013-08-08T17:22:27Z</time>  </trkpt>  <trkpt lat="55.945335387999997" lon="37.837245940999999">    <time>2013-08-08T17:22:30Z</time>  </trkpt>  <trkpt lat="55.945217133" lon="37.837532043000003">    <time>2013-08-08T17:22:33Z</time>  </trkpt>  <trkpt lat="55.945133208999998" lon="37.837837219000001">    <time>2013-08-08T17:22:36Z</time>  </trkpt>  <trkpt lat="55.945079802999999" lon="37.838176726999997">    <time>2013-08-08T17:22:39Z</time>  </trkpt>  <trkpt lat="55.945041656000001" lon="37.838516235">    <time>2013-08-08T17:22:42Z</time>  </trkpt>  <trkpt lat="55.945018767999997" lon="37.838859558000003">    <time>2013-08-08T17:22:45Z</time>  </trkpt>  <trkpt lat="55.944988250999998" lon="37.839210510000001">    <time>2013-08-08T17:22:48Z</time>  </trkpt>  <trkpt lat="55.944969176999997" lon="37.839550017999997">    <time>2013-08-08T17:22:51Z</time>  </trkpt>  <trkpt lat="55.944965363000001" lon="37.839916229000004">    <time>2013-08-08T17:22:54Z</time>  </trkpt>  <trkpt lat="55.944969176999997" lon="37.840274811">    <time>2013-08-08T17:22:57Z</time>  </trkpt>  <trkpt lat="55.944980620999999" lon="37.840633392000001">    <time>2013-08-08T17:23:00Z</time>  </trkpt>  <trkpt lat="55.944976807000003" lon="37.840988158999998">    <time>2013-08-08T17:23:03Z</time>  </trkpt>  <trkpt lat="55.944972991999997" lon="37.841339111000003">    <time>2013-08-08T17:23:06Z</time>  </trkpt>  <trkpt lat="55.944976807000003" lon="37.841686248999999">    <time>2013-08-08T17:23:09Z</time>  </trkpt>  <trkpt lat="55.944976807000003" lon="37.842060089">    <time>2013-08-08T17:23:12Z</time>  </trkpt>  <trkpt lat="55.944965363000001" lon="37.842453003000003">    <time>2013-08-08T17:23:15Z</time>  </trkpt>  <trkpt lat="55.944953918000003" lon="37.842826842999997">    <time>2013-08-08T17:23:18Z</time>  </trkpt>  <trkpt lat="55.944942474000001" lon="37.843200684000003">    <time>2013-08-08T17:23:21Z</time>  </trkpt>  <trkpt lat="55.944946289000001" lon="37.843605042">    <time>2013-08-08T17:23:24Z</time>  </trkpt>  <trkpt lat="55.944908142000003" lon="37.843971252000003">    <time>2013-08-08T17:23:27Z</time>  </trkpt>  <trkpt lat="55.944858551000003" lon="37.844348906999997">    <time>2013-08-08T17:23:30Z</time>  </trkpt>  <trkpt lat="55.944801331000001" lon="37.844726561999998">    <time>2013-08-08T17:23:33Z</time>  </trkpt>  <trkpt lat="55.944755553999997" lon="37.845092772999998">    <time>2013-08-08T17:23:36Z</time>  </trkpt>  <trkpt lat="55.944755553999997" lon="37.845447540000002">    <time>2013-08-08T17:23:39Z</time>  </trkpt>  <trkpt lat="55.944847107000001" lon="37.845825195000003">    <time>2013-08-08T17:23:42Z</time>  </trkpt>  <trkpt lat="55.944957733000003" lon="37.846191406000003">    <time>2013-08-08T17:23:45Z</time>  </trkpt>  <trkpt lat="55.945068358999997" lon="37.846546173">    <time>2013-08-08T17:23:48Z</time>  </trkpt>  <trkpt lat="55.945194244" lon="37.846885681000003">    <time>2013-08-08T17:23:51Z</time>  </trkpt>  <trkpt lat="55.945316314999999" lon="37.847240448000001">    <time>2013-08-08T17:23:54Z</time>  </trkpt>  <trkpt lat="55.945384979000004" lon="37.847610474">    <time>2013-08-08T17:23:57Z</time>  </trkpt>  <trkpt lat="55.945407867" lon="37.847991942999997">    <time>2013-08-08T17:24:00Z</time>  </trkpt>  <trkpt lat="55.945415496999999" lon="37.848365784000002">    <time>2013-08-08T17:24:03Z</time>  </trkpt>  <trkpt lat="55.945430756" lon="37.848731995000001">    <time>2013-08-08T17:24:06Z</time>  </trkpt>  <trkpt lat="55.945449828999998" lon="37.849098206000001">    <time>2013-08-08T17:24:09Z</time>  </trkpt>  <trkpt lat="55.945449828999998" lon="37.849479674999998">    <time>2013-08-08T17:24:12Z</time>  </trkpt>  <trkpt lat="55.945465087999999" lon="37.849853516000003">    <time>2013-08-08T17:24:15Z</time>  </trkpt>  <trkpt lat="55.945449828999998" lon="37.850212097000004">    <time>2013-08-08T17:24:18Z</time>  </trkpt>  <trkpt lat="55.945365905999999" lon="37.850494384999998">    <time>2013-08-08T17:24:21Z</time>  </trkpt>  <trkpt lat="55.945220947000003" lon="37.850738524999997">    <time>2013-08-08T17:24:24Z</time>  </trkpt>  <trkpt lat="55.945045471" lon="37.850944519000002">    <time>2013-08-08T17:24:27Z</time>  </trkpt>  <trkpt lat="55.944877624999997" lon="37.851158142000003">    <time>2013-08-08T17:24:30Z</time>  </trkpt>  <trkpt lat="55.944709777999996" lon="37.851379395000002">    <time>2013-08-08T17:24:33Z</time>  </trkpt>  <trkpt lat="55.944530487000002" lon="37.851589203000003">    <time>2013-08-08T17:24:36Z</time>  </trkpt>  <trkpt lat="55.944355010999999" lon="37.851806641000003">    <time>2013-08-08T17:24:39Z</time>  </trkpt>  <trkpt lat="55.944164276000002" lon="37.852035522000001">    <time>2013-08-08T17:24:42Z</time>  </trkpt>  <trkpt lat="55.943992614999999" lon="37.852264404000003">    <time>2013-08-08T17:24:45Z</time>  </trkpt>  <trkpt lat="55.943820952999999" lon="37.852489470999998">    <time>2013-08-08T17:24:48Z</time>  </trkpt>  <trkpt lat="55.943645476999997" lon="37.852722168">    <time>2013-08-08T17:24:51Z</time>  </trkpt>  <trkpt lat="55.943477631" lon="37.852954865000001">    <time>2013-08-08T17:24:54Z</time>  </trkpt>  <trkpt lat="55.943305969000001" lon="37.853191375999998">    <time>2013-08-08T17:24:57Z</time>  </trkpt>  <trkpt lat="55.943145752" lon="37.853424072000003">    <time>2013-08-08T17:25:00Z</time>  </trkpt>  <trkpt lat="55.942977904999999" lon="37.853664397999999">    <time>2013-08-08T17:25:03Z</time>  </trkpt>  <trkpt lat="55.942810059000003" lon="37.853916167999998">    <time>2013-08-08T17:25:06Z</time>  </trkpt>  <trkpt lat="55.942646027000002" lon="37.854167938000003">    <time>2013-08-08T17:25:09Z</time>  </trkpt>  <trkpt lat="55.942481995000001" lon="37.854415893999999">    <time>2013-08-08T17:25:12Z</time>  </trkpt>  <trkpt lat="55.942314148000001" lon="37.854656218999999">    <time>2013-08-08T17:25:15Z</time>  </trkpt>  <trkpt lat="55.942146301000001" lon="37.854892731">    <time>2013-08-08T17:25:18Z</time>  </trkpt>  <trkpt lat="55.941982269" lon="37.855133057000003">    <time>2013-08-08T17:25:21Z</time>  </trkpt>  <trkpt lat="55.941810607999997" lon="37.855381012000002">    <time>2013-08-08T17:25:24Z</time>  </trkpt>  <trkpt lat="55.941650391000003" lon="37.855598450000002">    <time>2013-08-08T17:25:27Z</time>  </trkpt>  <trkpt lat="55.941478729000004" lon="37.855854033999996">    <time>2013-08-08T17:25:30Z</time>  </trkpt>  <trkpt lat="55.941303253000001" lon="37.856098175">    <time>2013-08-08T17:25:33Z</time>  </trkpt>  <trkpt lat="55.941131591999998" lon="37.856353759999998">    <time>2013-08-08T17:25:36Z</time>  </trkpt>  <trkpt lat="55.940959929999998" lon="37.856605530000003">    <time>2013-08-08T17:25:39Z</time>  </trkpt>  <trkpt lat="55.940788269000002" lon="37.856849670000003">    <time>2013-08-08T17:25:42Z</time>  </trkpt>  <trkpt lat="55.940631865999997" lon="37.857093810999999">    <time>2013-08-08T17:25:45Z</time>  </trkpt>  <trkpt lat="55.940475464000002" lon="37.857330322000003">    <time>2013-08-08T17:25:48Z</time>  </trkpt>  <trkpt lat="55.940326691000003" lon="37.857566833">    <time>2013-08-08T17:25:51Z</time>  </trkpt>  <trkpt lat="55.940185546999999" lon="37.857788085999999">    <time>2013-08-08T17:25:54Z</time>  </trkpt>  <trkpt lat="55.940029144" lon="37.858013153000002">    <time>2013-08-08T17:25:57Z</time>  </trkpt>  <trkpt lat="55.939872741999999" lon="37.858181000000002">    <time>2013-08-08T17:26:00Z</time>  </trkpt>  <trkpt lat="55.939697266000003" lon="37.858158111999998">    <time>2013-08-08T17:26:03Z</time>  </trkpt>  <trkpt lat="55.939521790000001" lon="37.858078003000003">    <time>2013-08-08T17:26:06Z</time>  </trkpt>  <trkpt lat="55.939357758" lon="37.857990264999998">    <time>2013-08-08T17:26:09Z</time>  </trkpt>  <trkpt lat="55.939189911" lon="37.857913971000002">    <time>2013-08-08T17:26:12Z</time>  </trkpt>  <trkpt lat="55.939022064" lon="37.857830047999997">    <time>2013-08-08T17:26:15Z</time>  </trkpt>  <trkpt lat="55.938850402999996" lon="37.857746124000002">    <time>2013-08-08T17:26:18Z</time>  </trkpt>  <trkpt lat="55.938682556000003" lon="37.857666016000003">    <time>2013-08-08T17:26:21Z</time>  </trkpt>  <trkpt lat="55.938526154000002" lon="37.857597351000003">    <time>2013-08-08T17:26:24Z</time>  </trkpt>  <trkpt lat="55.938385009999998" lon="37.857532501000001">    <time>2013-08-08T17:26:27Z</time>  </trkpt>  <trkpt lat="55.938266753999997" lon="37.857463836999997">    <time>2013-08-08T17:26:30Z</time>  </trkpt>  <trkpt lat="55.938148499" lon="37.857398987000003">    <time>2013-08-08T17:26:33Z</time>  </trkpt>  <trkpt lat="55.938030243" lon="37.857349395999996">    <time>2013-08-08T17:26:36Z</time>  </trkpt>  <trkpt lat="55.937931061" lon="37.857303619">    <time>2013-08-08T17:26:39Z</time>  </trkpt>  <trkpt lat="55.937896729000002" lon="37.857261657999999">    <time>2013-08-08T17:26:42Z</time>  </trkpt>  <trkpt lat="55.937904357999997" lon="37.857257842999999">    <time>2013-08-08T17:26:45Z</time>  </trkpt>  <trkpt lat="55.937908172999997" lon="37.857265472000002">    <time>2013-08-08T17:26:48Z</time>  </trkpt>  <trkpt lat="55.937908172999997" lon="37.857269287000001">    <time>2013-08-08T17:26:51Z</time>  </trkpt>  <trkpt lat="55.937904357999997" lon="37.857269287000001">    <time>2013-08-08T17:26:54Z</time>  </trkpt>  <trkpt lat="55.937908172999997" lon="37.857269287000001">    <time>2013-08-08T17:27:03Z</time>  </trkpt>  <trkpt lat="55.937904357999997" lon="37.857269287000001">    <time>2013-08-08T17:27:06Z</time>  </trkpt>  <trkpt lat="55.937908172999997" lon="37.857265472000002">    <time>2013-08-08T17:28:12Z</time>  </trkpt>  <trkpt lat="55.937904357999997" lon="37.857265472000002">    <time>2013-08-08T17:28:45Z</time>  </trkpt>  <trkpt lat="55.937904357999997" lon="37.857269287000001">    <time>2013-08-08T17:28:54Z</time>  </trkpt>  <trkpt lat="55.937877655000001" lon="37.857257842999999">    <time>2013-08-08T17:29:24Z</time>  </trkpt>  <trkpt lat="55.937854766999997" lon="37.857177733999997">    <time>2013-08-08T17:29:27Z</time>  </trkpt>  <trkpt lat="55.937847136999999" lon="37.857086182000003">    <time>2013-08-08T17:29:30Z</time>  </trkpt>  <trkpt lat="55.937835692999997" lon="37.857006073000001">    <time>2013-08-08T17:29:33Z</time>  </trkpt>  <trkpt lat="55.937824249000002" lon="37.856948852999999">    <time>2013-08-08T17:29:36Z</time>  </trkpt>  <trkpt lat="55.937820434999999" lon="37.856937408">    <time>2013-08-08T17:29:39Z</time>  </trkpt>  <trkpt lat="55.937820434999999" lon="37.856929778999998">    <time>2013-08-08T17:29:42Z</time>  </trkpt>  <trkpt lat="55.937820434999999" lon="37.856933593999997">    <time>2013-08-08T17:29:48Z</time>  </trkpt>  <trkpt lat="55.937797545999999" lon="37.856929778999998">    <time>2013-08-08T17:30:00Z</time>  </trkpt>  <trkpt lat="55.937755584999998" lon="37.857040404999999">    <time>2013-08-08T17:30:03Z</time>  </trkpt>  <trkpt lat="55.937763214" lon="37.857238770000002">    <time>2013-08-08T17:30:06Z</time>  </trkpt>  <trkpt lat="55.937793732000003" lon="37.857494354000004">    <time>2013-08-08T17:30:09Z</time>  </trkpt>  <trkpt lat="55.937828064000001" lon="37.857795715000002">    <time>2013-08-08T17:30:12Z</time>  </trkpt>  <trkpt lat="55.937877655000001" lon="37.858127594000003">    <time>2013-08-08T17:30:15Z</time>  </trkpt>  <trkpt lat="55.937908172999997" lon="37.858482361">    <time>2013-08-08T17:30:18Z</time>  </trkpt>  <trkpt lat="55.937942505000002" lon="37.858856201000002">    <time>2013-08-08T17:30:21Z</time>  </trkpt>  <trkpt lat="55.937965392999999" lon="37.859256744">    <time>2013-08-08T17:30:24Z</time>  </trkpt>  <trkpt lat="55.937988281000003" lon="37.859672545999999">    <time>2013-08-08T17:30:27Z</time>  </trkpt>  <trkpt lat="55.938011168999999" lon="37.86007309">    <time>2013-08-08T17:30:30Z</time>  </trkpt>  <trkpt lat="55.938056946000003" lon="37.860454558999997">    <time>2013-08-08T17:30:33Z</time>  </trkpt>  <trkpt lat="55.938091278000002" lon="37.860836028999998">    <time>2013-08-08T17:30:36Z</time>  </trkpt>  <trkpt lat="55.938117980999998" lon="37.861194611000002">    <time>2013-08-08T17:30:39Z</time>  </trkpt>  <trkpt lat="55.938140869000001" lon="37.861568450999997">    <time>2013-08-08T17:30:42Z</time>  </trkpt>  <trkpt lat="55.938167571999998" lon="37.861976624">    <time>2013-08-08T17:30:45Z</time>  </trkpt>  <trkpt lat="55.93819809" lon="37.862384796000001">    <time>2013-08-08T17:30:48Z</time>  </trkpt>  <trkpt lat="55.938224792" lon="37.862792968999997">    <time>2013-08-08T17:30:51Z</time>  </trkpt>  <trkpt lat="55.938259125000002" lon="37.863178253000001">    <time>2013-08-08T17:30:54Z</time>  </trkpt>  <trkpt lat="55.938289642000001" lon="37.863567351999997">    <time>2013-08-08T17:30:57Z</time>  </trkpt>  <trkpt lat="55.938320160000004" lon="37.863960265999999">    <time>2013-08-08T17:31:00Z</time>  </trkpt>  <trkpt lat="55.938358307000001" lon="37.864322661999999">    <time>2013-08-08T17:31:03Z</time>  </trkpt>  <trkpt lat="55.938381194999998" lon="37.864665985000002">    <time>2013-08-08T17:31:06Z</time>  </trkpt>  <trkpt lat="55.938423157000003" lon="37.864994049000003">    <time>2013-08-08T17:31:09Z</time>  </trkpt>  <trkpt lat="55.938457489000001" lon="37.865295410000002">    <time>2013-08-08T17:31:12Z</time>  </trkpt>  <trkpt lat="55.938488006999997" lon="37.865566254000001">    <time>2013-08-08T17:31:15Z</time>  </trkpt>  <trkpt lat="55.938495635999999" lon="37.865760803000001">    <time>2013-08-08T17:31:18Z</time>  </trkpt>  <trkpt lat="55.938510895" lon="37.865943909000002">    <time>2013-08-08T17:31:21Z</time>  </trkpt>  <trkpt lat="55.938510895" lon="37.866149901999997">    <time>2013-08-08T17:31:24Z</time>  </trkpt>  <trkpt lat="55.938514709000003" lon="37.866363524999997">    <time>2013-08-08T17:31:27Z</time>  </trkpt>  <trkpt lat="55.938491821" lon="37.86656189">    <time>2013-08-08T17:31:30Z</time>  </trkpt>  <trkpt lat="55.938510895" lon="37.866752624999997">    <time>2013-08-08T17:31:33Z</time>  </trkpt>  <trkpt lat="55.938594817999999" lon="37.866867065000001">    <time>2013-08-08T17:31:36Z</time>  </trkpt>  <trkpt lat="55.938751220999997" lon="37.866958617999998">    <time>2013-08-08T17:31:39Z</time>  </trkpt>  <trkpt lat="55.938949585000003" lon="37.867080688000001">    <time>2013-08-08T17:31:42Z</time>  </trkpt>  <trkpt lat="55.939151764000002" lon="37.867195129000002">    <time>2013-08-08T17:31:45Z</time>  </trkpt>  <trkpt lat="55.939350128000001" lon="37.867294311999999">    <time>2013-08-08T17:31:48Z</time>  </trkpt>  <trkpt lat="55.939556121999999" lon="37.867374419999997">    <time>2013-08-08T17:31:51Z</time>  </trkpt>  <trkpt lat="55.939762115000001" lon="37.867477417000003">    <time>2013-08-08T17:31:54Z</time>  </trkpt>  <trkpt lat="55.939968108999999" lon="37.867584229000002">    <time>2013-08-08T17:31:57Z</time>  </trkpt>  <trkpt lat="55.940166472999998" lon="37.867679596000002">    <time>2013-08-08T17:32:00Z</time>  </trkpt>  <trkpt lat="55.940368651999997" lon="37.867767334">    <time>2013-08-08T17:32:03Z</time>  </trkpt>  <trkpt lat="55.940563202" lon="37.867870330999999">    <time>2013-08-08T17:32:06Z</time>  </trkpt>  <trkpt lat="55.940761565999999" lon="37.867969512999998">    <time>2013-08-08T17:32:09Z</time>  </trkpt>  <trkpt lat="55.940959929999998" lon="37.868061066000003">    <time>2013-08-08T17:32:12Z</time>  </trkpt>  <trkpt lat="55.941188812" lon="37.868175506999997">    <time>2013-08-08T17:32:15Z</time>  </trkpt>  <trkpt lat="55.941387177000003" lon="37.868278502999999">    <time>2013-08-08T17:32:18Z</time>  </trkpt>  <trkpt lat="55.941574097" lon="37.868377686000002">    <time>2013-08-08T17:32:21Z</time>  </trkpt>  <trkpt lat="55.941757201999998" lon="37.868495940999999">    <time>2013-08-08T17:32:24Z</time>  </trkpt>  <trkpt lat="55.941955565999997" lon="37.868614196999999">    <time>2013-08-08T17:32:27Z</time>  </trkpt>  <trkpt lat="55.942165375000002" lon="37.868705749999997">    <time>2013-08-08T17:32:30Z</time>  </trkpt>  <trkpt lat="55.942386626999998" lon="37.868778229">    <time>2013-08-08T17:32:33Z</time>  </trkpt>  <trkpt lat="55.942600249999998" lon="37.868778229">    <time>2013-08-08T17:32:36Z</time>  </trkpt>  <trkpt lat="55.942798615000001" lon="37.868679047000001">    <time>2013-08-08T17:32:39Z</time>  </trkpt>  <trkpt lat="55.942989349000001" lon="37.868526459000002">    <time>2013-08-08T17:32:42Z</time>  </trkpt>  <trkpt lat="55.943164824999997" lon="37.868331908999998">    <time>2013-08-08T17:32:45Z</time>  </trkpt>  <trkpt lat="55.943344115999999" lon="37.868156433000003">    <time>2013-08-08T17:32:48Z</time>  </trkpt>  <trkpt lat="55.943550109999997" lon="37.868091583000002">    <time>2013-08-08T17:32:51Z</time>  </trkpt>  <trkpt lat="55.943759917999998" lon="37.868125915999997">    <time>2013-08-08T17:32:54Z</time>  </trkpt>  <trkpt lat="55.943969727000002" lon="37.868179321">    <time>2013-08-08T17:32:57Z</time>  </trkpt>  <trkpt lat="55.944183350000003" lon="37.868217467999997">    <time>2013-08-08T17:33:00Z</time>  </trkpt>  <trkpt lat="55.944393157999997" lon="37.868274689000003">    <time>2013-08-08T17:33:03Z</time>  </trkpt>  <trkpt lat="55.944606780999997" lon="37.868316649999997">    <time>2013-08-08T17:33:06Z</time>  </trkpt>  <trkpt lat="55.944808960000003" lon="37.868373871000003">    <time>2013-08-08T17:33:09Z</time>  </trkpt>  <trkpt lat="55.945022582999997" lon="37.868423462000003">    <time>2013-08-08T17:33:12Z</time>  </trkpt>  <trkpt lat="55.945243834999999" lon="37.868465424">    <time>2013-08-08T17:33:15Z</time>  </trkpt>  <trkpt lat="55.945457458" lon="37.868515015">    <time>2013-08-08T17:33:18Z</time>  </trkpt>  <trkpt lat="55.945674896" lon="37.868568420000003">    <time>2013-08-08T17:33:21Z</time>  </trkpt>  <trkpt lat="55.945888519" lon="37.868614196999999">    <time>2013-08-08T17:33:24Z</time>  </trkpt>  <trkpt lat="55.946094512999998" lon="37.868675232000001">    <time>2013-08-08T17:33:27Z</time>  </trkpt>  <trkpt lat="55.946296691999997" lon="37.868721008000001">    <time>2013-08-08T17:33:30Z</time>  </trkpt>  <trkpt lat="55.946514129999997" lon="37.868759154999999">    <time>2013-08-08T17:33:33Z</time>  </trkpt>  <trkpt lat="55.946731567" lon="37.868789673000002">    <time>2013-08-08T17:33:36Z</time>  </trkpt>  <trkpt lat="55.946945190000001" lon="37.868816375999998">    <time>2013-08-08T17:33:39Z</time>  </trkpt>  <trkpt lat="55.947154998999999" lon="37.868835449000002">    <time>2013-08-08T17:33:42Z</time>  </trkpt>  <trkpt lat="55.947364807" lon="37.868858336999999">    <time>2013-08-08T17:33:45Z</time>  </trkpt>  <trkpt lat="55.947586059999999" lon="37.868885040000002">    <time>2013-08-08T17:33:48Z</time>  </trkpt>  <trkpt lat="55.947792053000001" lon="37.868911742999998">    <time>2013-08-08T17:33:51Z</time>  </trkpt>  <trkpt lat="55.947998046999999" lon="37.868927002">    <time>2013-08-08T17:33:54Z</time>  </trkpt>  <trkpt lat="55.948207855" lon="37.868953705000003">    <time>2013-08-08T17:33:57Z</time>  </trkpt>  <trkpt lat="55.948410033999998" lon="37.868965148999997">    <time>2013-08-08T17:34:00Z</time>  </trkpt>  <trkpt lat="55.948616027999996" lon="37.868976592999999">    <time>2013-08-08T17:34:03Z</time>  </trkpt>  <trkpt lat="55.948818207000002" lon="37.868980407999999">    <time>2013-08-08T17:34:06Z</time>  </trkpt>  <trkpt lat="55.949031830000003" lon="37.869003296000002">    <time>2013-08-08T17:34:09Z</time>  </trkpt>  <trkpt lat="55.949249268000003" lon="37.869026183999999">    <time>2013-08-08T17:34:12Z</time>  </trkpt>  <trkpt lat="55.949459075999997" lon="37.869045258">    <time>2013-08-08T17:34:15Z</time>  </trkpt>  <trkpt lat="55.949672698999997" lon="37.869052887000002">    <time>2013-08-08T17:34:18Z</time>  </trkpt>  <trkpt lat="55.949871063000003" lon="37.869037628000001">    <time>2013-08-08T17:34:21Z</time>  </trkpt>  <trkpt lat="55.950069427000003" lon="37.868991852000001">    <time>2013-08-08T17:34:24Z</time>  </trkpt>  <trkpt lat="55.950279236" lon="37.868938446000001">    <time>2013-08-08T17:34:27Z</time>  </trkpt>  <trkpt lat="55.950489044000001" lon="37.868862151999998">    <time>2013-08-08T17:34:30Z</time>  </trkpt>  <trkpt lat="55.950683593999997" lon="37.868766784999998">    <time>2013-08-08T17:34:33Z</time>  </trkpt>  <trkpt lat="55.950885773000003" lon="37.868633269999997">    <time>2013-08-08T17:34:36Z</time>  </trkpt>  <trkpt lat="55.951080322000003" lon="37.868461609000001">    <time>2013-08-08T17:34:39Z</time>  </trkpt>  <trkpt lat="55.951271057" lon="37.868270873999997">    <time>2013-08-08T17:34:42Z</time>  </trkpt>  <trkpt lat="55.951454163000001" lon="37.868083953999999">    <time>2013-08-08T17:34:45Z</time>  </trkpt>  <trkpt lat="55.951622008999998" lon="37.867870330999999">    <time>2013-08-08T17:34:48Z</time>  </trkpt>  <trkpt lat="55.9518013" lon="37.867656707999998">    <time>2013-08-08T17:34:51Z</time>  </trkpt>  <trkpt lat="55.951984406000001" lon="37.867439269999998">    <time>2013-08-08T17:34:54Z</time>  </trkpt>  <trkpt lat="55.952159881999997" lon="37.867206572999997">    <time>2013-08-08T17:34:57Z</time>  </trkpt>  <trkpt lat="55.952327728" lon="37.866977691999999">    <time>2013-08-08T17:35:00Z</time>  </trkpt>  <trkpt lat="55.952457428000002" lon="37.866672516000001">    <time>2013-08-08T17:35:03Z</time>  </trkpt>  <trkpt lat="55.952533721999998" lon="37.866352081000002">    <time>2013-08-08T17:35:06Z</time>  </trkpt>  <trkpt lat="55.952610016000001" lon="37.865966796999999">    <time>2013-08-08T17:35:09Z</time>  </trkpt>  <trkpt lat="55.952678679999998" lon="37.865585326999998">    <time>2013-08-08T17:35:12Z</time>  </trkpt>  <trkpt lat="55.952735900999997" lon="37.865203856999997">    <time>2013-08-08T17:35:15Z</time>  </trkpt>  <trkpt lat="55.952796935999999" lon="37.864841460999997">    <time>2013-08-08T17:35:18Z</time>  </trkpt>  <trkpt lat="55.952861786" lon="37.864521027000002">    <time>2013-08-08T17:35:21Z</time>  </trkpt>  <trkpt lat="55.952960967999999" lon="37.864269256999997">    <time>2013-08-08T17:35:24Z</time>  </trkpt>  <trkpt lat="55.953075409" lon="37.864059447999999">    <time>2013-08-08T17:35:27Z</time>  </trkpt>  <trkpt lat="55.953216552999997" lon="37.863857269">    <time>2013-08-08T17:35:30Z</time>  </trkpt>  <trkpt lat="55.953395843999999" lon="37.863666533999996">    <time>2013-08-08T17:35:33Z</time>  </trkpt>  <trkpt lat="55.953594207999998" lon="37.863452911000003">    <time>2013-08-08T17:35:36Z</time>  </trkpt>  <trkpt lat="55.953784943000002" lon="37.863231659">    <time>2013-08-08T17:35:39Z</time>  </trkpt>  <trkpt lat="55.953968048" lon="37.863018036">    <time>2013-08-08T17:35:42Z</time>  </trkpt>  <trkpt lat="55.954151154000002" lon="37.862842559999997">    <time>2013-08-08T17:35:45Z</time>  </trkpt>  <trkpt lat="55.954341888000002" lon="37.862659454000003">    <time>2013-08-08T17:35:48Z</time>  </trkpt>  <trkpt lat="55.954532622999999" lon="37.862495422000002">    <time>2013-08-08T17:35:51Z</time>  </trkpt>  <trkpt lat="55.954723358000003" lon="37.862373351999999">    <time>2013-08-08T17:35:54Z</time>  </trkpt>  <trkpt lat="55.954917907999999" lon="37.862266540999997">    <time>2013-08-08T17:35:57Z</time>  </trkpt>  <trkpt lat="55.955123901" lon="37.862186432000001">    <time>2013-08-08T17:36:00Z</time>  </trkpt>  <trkpt lat="55.955333709999998" lon="37.862125397">    <time>2013-08-08T17:36:03Z</time>  </trkpt>  <trkpt lat="55.955547332999998" lon="37.862068176000001">    <time>2013-08-08T17:36:06Z</time>  </trkpt>  <trkpt lat="55.955760955999999" lon="37.862033844000003">    <time>2013-08-08T17:36:09Z</time>  </trkpt>  <trkpt lat="55.955970764" lon="37.861984253000003">    <time>2013-08-08T17:36:12Z</time>  </trkpt>  <trkpt lat="55.956172942999999" lon="37.861927031999997">    <time>2013-08-08T17:36:15Z</time>  </trkpt>  <trkpt lat="55.956375121999997" lon="37.861934662000003">    <time>2013-08-08T17:36:18Z</time>  </trkpt>  <trkpt lat="55.956558227999999" lon="37.861984253000003">    <time>2013-08-08T17:36:21Z</time>  </trkpt>  <trkpt lat="55.956726074000002" lon="37.862071991000001">    <time>2013-08-08T17:36:24Z</time>  </trkpt>  <trkpt lat="55.956886292" lon="37.862098693999997">    <time>2013-08-08T17:36:27Z</time>  </trkpt>  <trkpt lat="55.957069396999998" lon="37.862174988">    <time>2013-08-08T17:36:30Z</time>  </trkpt>  <trkpt lat="55.957241058000001" lon="37.862258910999998">    <time>2013-08-08T17:36:33Z</time>  </trkpt>  <trkpt lat="55.957401275999999" lon="37.862312316999997">    <time>2013-08-08T17:36:36Z</time>  </trkpt>  <trkpt lat="55.957572937000002" lon="37.862327575999998">    <time>2013-08-08T17:36:39Z</time>  </trkpt>  <trkpt lat="55.957721710000001" lon="37.862213134999998">    <time>2013-08-08T17:36:42Z</time>  </trkpt>  <trkpt lat="55.957790375000002" lon="37.861965179000002">    <time>2013-08-08T17:36:45Z</time>  </trkpt>  <trkpt lat="55.957855225000003" lon="37.861682891999997">    <time>2013-08-08T17:36:48Z</time>  </trkpt>  <trkpt lat="55.957920074" lon="37.861404419000003">    <time>2013-08-08T17:36:51Z</time>  </trkpt>  <trkpt lat="55.957992554" lon="37.861148833999998">    <time>2013-08-08T17:36:54Z</time>  </trkpt>  <trkpt lat="55.958061217999997" lon="37.860912323000001">    <time>2013-08-08T17:36:57Z</time>  </trkpt>  <trkpt lat="55.958118439000003" lon="37.860683440999999">    <time>2013-08-08T17:37:00Z</time>  </trkpt>  <trkpt lat="55.958183288999997" lon="37.860485077">    <time>2013-08-08T17:37:03Z</time>  </trkpt>  <trkpt lat="55.958240508999999" lon="37.86031723">    <time>2013-08-08T17:37:06Z</time>  </trkpt>  <trkpt lat="55.958244323999999" lon="37.860260009999998">    <time>2013-08-08T17:37:09Z</time>  </trkpt>  <trkpt lat="55.958240508999999" lon="37.860256194999998">    <time>2013-08-08T17:37:12Z</time>  </trkpt>  <trkpt lat="55.958240508999999" lon="37.860260009999998">    <time>2013-08-08T17:37:24Z</time>  </trkpt>  <trkpt lat="55.958236694" lon="37.860260009999998">    <time>2013-08-08T17:37:30Z</time>  </trkpt>  <trkpt lat="55.958236694" lon="37.860263824">    <time>2013-08-08T17:37:39Z</time>  </trkpt>  <trkpt lat="55.958232879999997" lon="37.860237122000001">    <time>2013-08-08T17:37:48Z</time>  </trkpt>  <trkpt lat="55.958190918" lon="37.860248566000003">    <time>2013-08-08T17:37:51Z</time>  </trkpt>  <trkpt lat="55.958141327" lon="37.860382080000001">    <time>2013-08-08T17:37:54Z</time>  </trkpt>  <trkpt lat="55.958065032999997" lon="37.860618590999998">    <time>2013-08-08T17:37:57Z</time>  </trkpt>  <trkpt lat="55.957977294999999" lon="37.860916138">    <time>2013-08-08T17:38:00Z</time>  </trkpt>  <trkpt lat="55.957901001000003" lon="37.861194611000002">    <time>2013-08-08T17:38:03Z</time>  </trkpt>  <trkpt lat="55.957828522" lon="37.861461638999998">    <time>2013-08-08T17:38:06Z</time>  </trkpt>  <trkpt lat="55.957759856999999" lon="37.861717224000003">    <time>2013-08-08T17:38:09Z</time>  </trkpt>  <trkpt lat="55.957691193000002" lon="37.861953735">    <time>2013-08-08T17:38:12Z</time>  </trkpt>  <trkpt lat="55.957679749" lon="37.862197876000003">    <time>2013-08-08T17:38:15Z</time>  </trkpt>  <trkpt lat="55.957641602000002" lon="37.862487793">    <time>2013-08-08T17:38:18Z</time>  </trkpt>  <trkpt lat="55.957660675" lon="37.862785338999998">    <time>2013-08-08T17:38:21Z</time>  </trkpt>  <trkpt lat="55.957778931" lon="37.862899779999999">    <time>2013-08-08T17:38:24Z</time>  </trkpt>  <trkpt lat="55.957931518999999" lon="37.862957000999998">    <time>2013-08-08T17:38:27Z</time>  </trkpt>  <trkpt lat="55.958084106000001" lon="37.863021850999999">    <time>2013-08-08T17:38:30Z</time>  </trkpt>  <trkpt lat="55.958232879999997" lon="37.863075256000002">    <time>2013-08-08T17:38:33Z</time>  </trkpt>  <trkpt lat="55.958374022999998" lon="37.863124847000002">    <time>2013-08-08T17:38:36Z</time>  </trkpt>  <trkpt lat="55.958522797000001" lon="37.863162994">    <time>2013-08-08T17:38:39Z</time>  </trkpt>  <trkpt lat="55.958686829000001" lon="37.863216399999999">    <time>2013-08-08T17:38:42Z</time>  </trkpt>  <trkpt lat="55.958858489999997" lon="37.863269805999998">    <time>2013-08-08T17:38:45Z</time>  </trkpt>  <trkpt lat="55.959022521999998" lon="37.863323211999997">    <time>2013-08-08T17:38:48Z</time>  </trkpt>  <trkpt lat="55.959182738999999" lon="37.863376617">    <time>2013-08-08T17:38:51Z</time>  </trkpt>  <trkpt lat="55.959331511999999" lon="37.863426208">    <time>2013-08-08T17:38:54Z</time>  </trkpt>  <trkpt lat="55.959449767999999" lon="37.863491058000001">    <time>2013-08-08T17:38:57Z</time>  </trkpt>  <trkpt lat="55.959537505999997" lon="37.863662720000001">    <time>2013-08-08T17:39:00Z</time>  </trkpt>  <trkpt lat="55.959529877000001" lon="37.863899230999998">    <time>2013-08-08T17:39:03Z</time>  </trkpt>  <trkpt lat="55.959491730000003" lon="37.864135742000002">    <time>2013-08-08T17:39:06Z</time>  </trkpt>  <trkpt lat="55.959453582999998" lon="37.864364623999997">    <time>2013-08-08T17:39:09Z</time>  </trkpt>  <trkpt lat="55.959426880000002" lon="37.864589690999999">    <time>2013-08-08T17:39:12Z</time>  </trkpt>  <trkpt lat="55.959381104000002" lon="37.864810943999998">    <time>2013-08-08T17:39:15Z</time>  </trkpt>  <trkpt lat="55.959396362" lon="37.865047455000003">    <time>2013-08-08T17:39:18Z</time>  </trkpt>  <trkpt lat="55.959484099999997" lon="37.865238189999999">    <time>2013-08-08T17:39:21Z</time>  </trkpt>  <trkpt lat="55.959564209" lon="37.865356445000003">    <time>2013-08-08T17:39:24Z</time>  </trkpt>  <trkpt lat="55.959583281999997" lon="37.865539550999998">    <time>2013-08-08T17:39:27Z</time>  </trkpt>  <trkpt lat="55.959598540999998" lon="37.865772247000002">    <time>2013-08-08T17:39:30Z</time>  </trkpt>  <trkpt lat="55.959621429000002" lon="37.866016387999998">    <time>2013-08-08T17:39:33Z</time>  </trkpt>  <trkpt lat="55.959648131999998" lon="37.866256714000002">    <time>2013-08-08T17:39:36Z</time>  </trkpt>  <trkpt lat="55.959701537999997" lon="37.866443633999999">    <time>2013-08-08T17:39:39Z</time>  </trkpt>  <trkpt lat="55.959766387999998" lon="37.866596221999998">    <time>2013-08-08T17:39:42Z</time>  </trkpt>  <trkpt lat="55.959846497000001" lon="37.866771698000001">    <time>2013-08-08T17:39:45Z</time>  </trkpt>  <trkpt lat="55.960006714000002" lon="37.866878509999999">    <time>2013-08-08T17:39:48Z</time>  </trkpt>  <trkpt lat="55.960166931000003" lon="37.867015838999997">    <time>2013-08-08T17:39:51Z</time>  </trkpt>  <trkpt lat="55.960323334000002" lon="37.867164612000003">    <time>2013-08-08T17:39:54Z</time>  </trkpt>  <trkpt lat="55.960491179999998" lon="37.867290496999999">    <time>2013-08-08T17:39:57Z</time>  </trkpt>  <trkpt lat="55.960655211999999" lon="37.867427825999997">    <time>2013-08-08T17:40:00Z</time>  </trkpt>  <trkpt lat="55.960823058999999" lon="37.867553710999999">    <time>2013-08-08T17:40:03Z</time>  </trkpt>  <trkpt lat="55.961002350000001" lon="37.867668152">    <time>2013-08-08T17:40:06Z</time>  </trkpt>  <trkpt lat="55.961181641000003" lon="37.867744446000003">    <time>2013-08-08T17:40:09Z</time>  </trkpt>  <trkpt lat="55.961368561" lon="37.867774963000002">    <time>2013-08-08T17:40:12Z</time>  </trkpt>  <trkpt lat="55.961559295999997" lon="37.867805480999998">    <time>2013-08-08T17:40:15Z</time>  </trkpt>  <trkpt lat="55.961742401000002" lon="37.867824554000002">    <time>2013-08-08T17:40:18Z</time>  </trkpt>  <trkpt lat="55.961921691999997" lon="37.867820739999999">    <time>2013-08-08T17:40:21Z</time>  </trkpt>  <trkpt lat="55.962089538999997" lon="37.86781311">    <time>2013-08-08T17:40:24Z</time>  </trkpt>  <trkpt lat="55.962245940999999" lon="37.867847443000002">    <time>2013-08-08T17:40:27Z</time>  </trkpt>  <trkpt lat="55.962417602999999" lon="37.867862701">    <time>2013-08-08T17:40:30Z</time>  </trkpt>  <trkpt lat="55.962581634999999" lon="37.867862701">    <time>2013-08-08T17:40:33Z</time>  </trkpt>  <trkpt lat="55.962738037000001" lon="37.867855071999998">    <time>2013-08-08T17:40:36Z</time>  </trkpt>  <trkpt lat="55.962886810000001" lon="37.867893219000003">    <time>2013-08-08T17:40:39Z</time>  </trkpt>  <trkpt lat="55.962997436999999" lon="37.867927551000001">    <time>2013-08-08T17:40:42Z</time>  </trkpt>  <trkpt lat="55.963096618999998" lon="37.867950438999998">    <time>2013-08-08T17:40:45Z</time>  </trkpt>  <trkpt lat="55.963188170999999" lon="37.867980957">    <time>2013-08-08T17:40:48Z</time>  </trkpt>  <trkpt lat="55.963268280000001" lon="37.867977142000001">    <time>2013-08-08T17:40:51Z</time>  </trkpt>  <trkpt lat="55.963325500000003" lon="37.867965697999999">    <time>2013-08-08T17:40:54Z</time>  </trkpt>  <trkpt lat="55.963405608999999" lon="37.867977142000001">    <time>2013-08-08T17:40:57Z</time>  </trkpt>  <trkpt lat="55.963474273999999" lon="37.867984772">    <time>2013-08-08T17:41:00Z</time>  </trkpt>  <trkpt lat="55.963535309000001" lon="37.868049622000001">    <time>2013-08-08T17:41:03Z</time>  </trkpt>  <trkpt lat="55.963577270999998" lon="37.868164061999998">    <time>2013-08-08T17:41:06Z</time>  </trkpt>  <trkpt lat="55.963600159000002" lon="37.868175506999997">    <time>2013-08-08T17:41:09Z</time>  </trkpt>  <trkpt lat="55.963596344000003" lon="37.868160248000002">    <time>2013-08-08T17:41:12Z</time>  </trkpt>  <trkpt lat="55.963600159000002" lon="37.868160248000002">    <time>2013-08-08T17:41:18Z</time>  </trkpt>  <trkpt lat="55.963596344000003" lon="37.868160248000002">    <time>2013-08-08T17:41:21Z</time>  </trkpt>  <trkpt lat="55.963596344000003" lon="37.868164061999998">    <time>2013-08-08T17:41:36Z</time>  </trkpt>  <trkpt lat="55.963588715" lon="37.868114470999998">    <time>2013-08-08T17:41:48Z</time>  </trkpt>  <trkpt lat="55.963584900000001" lon="37.868026733000001">    <time>2013-08-08T17:41:51Z</time>  </trkpt>  <trkpt lat="55.963630676000001" lon="37.867992401000002">    <time>2013-08-08T17:41:54Z</time>  </trkpt>  <trkpt lat="55.963703156000001" lon="37.868000031000001">    <time>2013-08-08T17:41:57Z</time>  </trkpt>  <trkpt lat="55.963806151999997" lon="37.868038177000003">    <time>2013-08-08T17:42:00Z</time>  </trkpt>  <trkpt lat="55.963882446" lon="37.868038177000003">    <time>2013-08-08T17:42:03Z</time>  </trkpt>  <trkpt lat="55.963947296000001" lon="37.868068694999998">    <time>2013-08-08T17:42:06Z</time>  </trkpt>  <trkpt lat="55.964038848999998" lon="37.868076324">    <time>2013-08-08T17:42:09Z</time>  </trkpt>  <trkpt lat="55.964153289999999" lon="37.868099213000001">    <time>2013-08-08T17:42:12Z</time>  </trkpt>  <trkpt lat="55.964279175000001" lon="37.868179321">    <time>2013-08-08T17:42:15Z</time>  </trkpt>  <trkpt lat="55.964401244999998" lon="37.868255615000002">    <time>2013-08-08T17:42:18Z</time>  </trkpt>  <trkpt lat="55.964534759999999" lon="37.868263245000001">    <time>2013-08-08T17:42:21Z</time>  </trkpt>  <trkpt lat="55.964672088999997" lon="37.868259430000002">    <time>2013-08-08T17:42:24Z</time>  </trkpt>  <trkpt lat="55.964817046999997" lon="37.868255615000002">    <time>2013-08-08T17:42:27Z</time>  </trkpt>  <trkpt lat="55.964965820000003" lon="37.868270873999997">    <time>2013-08-08T17:42:30Z</time>  </trkpt>  <trkpt lat="55.965106964" lon="37.868282317999999">    <time>2013-08-08T17:42:33Z</time>  </trkpt>  <trkpt lat="55.965248107999997" lon="37.868293762">    <time>2013-08-08T17:42:36Z</time>  </trkpt>  <trkpt lat="55.965400696000003" lon="37.868312836000001">    <time>2013-08-08T17:42:39Z</time>  </trkpt>  <trkpt lat="55.965549469000003" lon="37.868320464999996">    <time>2013-08-08T17:42:42Z</time>  </trkpt>  <trkpt lat="55.965682983000001" lon="37.868274689000003">    <time>2013-08-08T17:42:45Z</time>  </trkpt>  <trkpt lat="55.965789794999999" lon="37.868160248000002">    <time>2013-08-08T17:42:48Z</time>  </trkpt>  <trkpt lat="55.965866089000002" lon="37.868103026999997">    <time>2013-08-08T17:42:51Z</time>  </trkpt>  <trkpt lat="55.965927123999997" lon="37.868030548">    <time>2013-08-08T17:42:54Z</time>  </trkpt>  <trkpt lat="55.966011047000002" lon="37.868011475000003">    <time>2013-08-08T17:42:57Z</time>  </trkpt>  <trkpt lat="55.966121674" lon="37.867923736999998">    <time>2013-08-08T17:43:00Z</time>  </trkpt>  <trkpt lat="55.966205596999998" lon="37.867805480999998">    <time>2013-08-08T17:43:03Z</time>  </trkpt>  <trkpt lat="55.966266632" lon="37.867733002000001">    <time>2013-08-08T17:43:06Z</time>  </trkpt>  <trkpt lat="55.966339111000003" lon="37.867660522000001">    <time>2013-08-08T17:43:09Z</time>  </trkpt>  <trkpt lat="55.966396332000002" lon="37.867774963000002">    <time>2013-08-08T17:43:12Z</time>  </trkpt>  <trkpt lat="55.966449738000001" lon="37.867942810000002">    <time>2013-08-08T17:43:15Z</time>  </trkpt>  <trkpt lat="55.966491699000002" lon="37.868148804">    <time>2013-08-08T17:43:18Z</time>  </trkpt>  <trkpt lat="55.966564177999999" lon="37.868331908999998">    <time>2013-08-08T17:43:21Z</time>  </trkpt>  <trkpt lat="55.966651917" lon="37.868515015">    <time>2013-08-08T17:43:24Z</time>  </trkpt>  <trkpt lat="55.966709137000002" lon="37.868709564">    <time>2013-08-08T17:43:27Z</time>  </trkpt>  <trkpt lat="55.966808319000002" lon="37.868930816999999">    <time>2013-08-08T17:43:30Z</time>  </trkpt>  <trkpt lat="55.966915131" lon="37.869129180999998">    <time>2013-08-08T17:43:33Z</time>  </trkpt>  <trkpt lat="55.967010498" lon="37.869338988999999">    <time>2013-08-08T17:43:36Z</time>  </trkpt>  <trkpt lat="55.967094420999999" lon="37.869586945000002">    <time>2013-08-08T17:43:39Z</time>  </trkpt>  <trkpt lat="55.967182158999996" lon="37.869781494000001">    <time>2013-08-08T17:43:42Z</time>  </trkpt>  <trkpt lat="55.967258452999999" lon="37.869983673">    <time>2013-08-08T17:43:45Z</time>  </trkpt>  <trkpt lat="55.967304230000003" lon="37.870189666999998">    <time>2013-08-08T17:43:48Z</time>  </trkpt>  <trkpt lat="55.967330933" lon="37.870391845999997">    <time>2013-08-08T17:43:51Z</time>  </trkpt>  <trkpt lat="55.967323303000001" lon="37.870582581000001">    <time>2013-08-08T17:43:54Z</time>  </trkpt>  <trkpt lat="55.967319488999998" lon="37.870792389000002">    <time>2013-08-08T17:43:57Z</time>  </trkpt>  <trkpt lat="55.967311858999999" lon="37.871028899999999">    <time>2013-08-08T17:44:00Z</time>  </trkpt>  <trkpt lat="55.967308043999999" lon="37.871257782000001">    <time>2013-08-08T17:44:03Z</time>  </trkpt>  <trkpt lat="55.967296599999997" lon="37.871467590000002">    <time>2013-08-08T17:44:06Z</time>  </trkpt>  <trkpt lat="55.967288971000002" lon="37.871688843000001">    <time>2013-08-08T17:44:09Z</time>  </trkpt>  <trkpt lat="55.967300414999997" lon="37.871902466000002">    <time>2013-08-08T17:44:12Z</time>  </trkpt>  <trkpt lat="55.967315673999998" lon="37.872066498000002">    <time>2013-08-08T17:44:15Z</time>  </trkpt>  <trkpt lat="55.967353821000003" lon="37.872138976999999">    <time>2013-08-08T17:44:18Z</time>  </trkpt>  <trkpt lat="55.967449188000003" lon="37.872131348000003">    <time>2013-08-08T17:44:21Z</time>  </trkpt>  <trkpt lat="55.967582702999998" lon="37.872020720999998">    <time>2013-08-08T17:44:24Z</time>  </trkpt>  <trkpt lat="55.967708588000001" lon="37.871841431">    <time>2013-08-08T17:44:27Z</time>  </trkpt>  <trkpt lat="55.967857361" lon="37.871700287000003">    <time>2013-08-08T17:44:30Z</time>  </trkpt>  <trkpt lat="55.968029022000003" lon="37.871627808">    <time>2013-08-08T17:44:33Z</time>  </trkpt>  <trkpt lat="55.968204497999999" lon="37.871585846000002">    <time>2013-08-08T17:44:36Z</time>  </trkpt>  <trkpt lat="55.968387604" lon="37.871585846000002">    <time>2013-08-08T17:44:39Z</time>  </trkpt>  <trkpt lat="55.968566895000002" lon="37.871585846000002">    <time>2013-08-08T17:44:42Z</time>  </trkpt>  <trkpt lat="55.968757629000002" lon="37.871597289999997">    <time>2013-08-08T17:44:45Z</time>  </trkpt>  <trkpt lat="55.968936919999997" lon="37.871604918999999">    <time>2013-08-08T17:44:48Z</time>  </trkpt>  <trkpt lat="55.969127655000001" lon="37.871608733999999">    <time>2013-08-08T17:44:51Z</time>  </trkpt>  <trkpt lat="55.969318389999998" lon="37.871620178000001">    <time>2013-08-08T17:44:54Z</time>  </trkpt>  <trkpt lat="55.969512938999998" lon="37.871631622000002">    <time>2013-08-08T17:44:57Z</time>  </trkpt>  <trkpt lat="55.969707489000001" lon="37.871627808">    <time>2013-08-08T17:45:00Z</time>  </trkpt>  <trkpt lat="55.969905853" lon="37.871616363999998">    <time>2013-08-08T17:45:03Z</time>  </trkpt>  <trkpt lat="55.970108031999999" lon="37.871574402">    <time>2013-08-08T17:45:06Z</time>  </trkpt>  <trkpt lat="55.970302582000002" lon="37.871505737">    <time>2013-08-08T17:45:09Z</time>  </trkpt>  <trkpt lat="55.970493316999999" lon="37.871395110999998">    <time>2013-08-08T17:45:12Z</time>  </trkpt>  <trkpt lat="55.970672606999997" lon="37.871273041000002">    <time>2013-08-08T17:45:15Z</time>  </trkpt>  <trkpt lat="55.970848083" lon="37.871120453000003">    <time>2013-08-08T17:45:18Z</time>  </trkpt>  <trkpt lat="55.971023559999999" lon="37.870948792">    <time>2013-08-08T17:45:21Z</time>  </trkpt>  <trkpt lat="55.971179962000001" lon="37.870746613000001">    <time>2013-08-08T17:45:24Z</time>  </trkpt>  <trkpt lat="55.97133255" lon="37.870521545000003">    <time>2013-08-08T17:45:27Z</time>  </trkpt>  <trkpt lat="55.971469878999997" lon="37.870288848999998">    <time>2013-08-08T17:45:30Z</time>  </trkpt>  <trkpt lat="55.971595764" lon="37.870025634999998">    <time>2013-08-08T17:45:33Z</time>  </trkpt>  <trkpt lat="55.971717834000003" lon="37.869758605999998">    <time>2013-08-08T17:45:36Z</time>  </trkpt>  <trkpt lat="55.971820831000002" lon="37.869476317999997">    <time>2013-08-08T17:45:39Z</time>  </trkpt>  <trkpt lat="55.971939087000003" lon="37.869197845000002">    <time>2013-08-08T17:45:42Z</time>  </trkpt>  <trkpt lat="55.972045897999998" lon="37.868915557999998">    <time>2013-08-08T17:45:45Z</time>  </trkpt>  <trkpt lat="55.972164153999998" lon="37.868633269999997">    <time>2013-08-08T17:45:48Z</time>  </trkpt>  <trkpt lat="55.972278594999999" lon="37.868358612000002">    <time>2013-08-08T17:45:51Z</time>  </trkpt>  <trkpt lat="55.972393036" lon="37.868095398000001">    <time>2013-08-08T17:45:54Z</time>  </trkpt>  <trkpt lat="55.972503662000001" lon="37.867820739999999">    <time>2013-08-08T17:45:57Z</time>  </trkpt>  <trkpt lat="55.972614288000003" lon="37.867549896">    <time>2013-08-08T17:46:00Z</time>  </trkpt>  <trkpt lat="55.972724915000001" lon="37.867286682">    <time>2013-08-08T17:46:03Z</time>  </trkpt>  <trkpt lat="55.972839354999998" lon="37.867012023999997">    <time>2013-08-08T17:46:06Z</time>  </trkpt>  <trkpt lat="55.972949982000003" lon="37.866744994999998">    <time>2013-08-08T17:46:09Z</time>  </trkpt>  <trkpt lat="55.973064422999997" lon="37.866477965999998">    <time>2013-08-08T17:46:12Z</time>  </trkpt>  <trkpt lat="55.973178863999998" lon="37.866210938000002">    <time>2013-08-08T17:46:15Z</time>  </trkpt>  <trkpt lat="55.973316193000002" lon="37.865985870000003">    <time>2013-08-08T17:46:18Z</time>  </trkpt>  <trkpt lat="55.973476410000004" lon="37.865814209">    <time>2013-08-08T17:46:21Z</time>  </trkpt>  <trkpt lat="55.973644256999997" lon="37.865695952999999">    <time>2013-08-08T17:46:24Z</time>  </trkpt>  <trkpt lat="55.973823547000002" lon="37.865631104000002">    <time>2013-08-08T17:46:27Z</time>  </trkpt>  <trkpt lat="55.974002837999997" lon="37.865612030000001">    <time>2013-08-08T17:46:30Z</time>  </trkpt>  <trkpt lat="55.974185943999998" lon="37.865661621000001">    <time>2013-08-08T17:46:33Z</time>  </trkpt>  <trkpt lat="55.974357605000002" lon="37.865795134999999">    <time>2013-08-08T17:46:36Z</time>  </trkpt>  <trkpt lat="55.974525452000002" lon="37.865947722999998">    <time>2013-08-08T17:46:39Z</time>  </trkpt>  <trkpt lat="55.974678040000001" lon="37.866134643999999">    <time>2013-08-08T17:46:42Z</time>  </trkpt>  <trkpt lat="55.974822998" lon="37.866325377999999">    <time>2013-08-08T17:46:45Z</time>  </trkpt>  <trkpt lat="55.974975585999999" lon="37.866504669000001">    <time>2013-08-08T17:46:48Z</time>  </trkpt>  <trkpt lat="55.975128173999998" lon="37.866680144999997">    <time>2013-08-08T17:46:51Z</time>  </trkpt>  <trkpt lat="55.975276946999998" lon="37.866855620999999">    <time>2013-08-08T17:46:54Z</time>  </trkpt>  <trkpt lat="55.975433350000003" lon="37.867031097000002">    <time>2013-08-08T17:46:57Z</time>  </trkpt>  <trkpt lat="55.975593566999997" lon="37.867202759000001">    <time>2013-08-08T17:47:00Z</time>  </trkpt>  <trkpt lat="55.975753783999998" lon="37.867359161000003">    <time>2013-08-08T17:47:03Z</time>  </trkpt>  <trkpt lat="55.975921630999999" lon="37.867515564000001">    <time>2013-08-08T17:47:06Z</time>  </trkpt>  <trkpt lat="55.976093292000002" lon="37.867637633999998">    <time>2013-08-08T17:47:09Z</time>  </trkpt>  <trkpt lat="55.976276398000003" lon="37.867721558">    <time>2013-08-08T17:47:12Z</time>  </trkpt>  <trkpt lat="55.976463318" lon="37.867755889999998">    <time>2013-08-08T17:47:15Z</time>  </trkpt>  <trkpt lat="55.976657867" lon="37.867759704999997">    <time>2013-08-08T17:47:18Z</time>  </trkpt>  <trkpt lat="55.976852417000003" lon="37.867710113999998">    <time>2013-08-08T17:47:21Z</time>  </trkpt>  <trkpt lat="55.977039337000001" lon="37.867607116999999">    <time>2013-08-08T17:47:24Z</time>  </trkpt>  <trkpt lat="55.977218628000003" lon="37.867462158000002">    <time>2013-08-08T17:47:27Z</time>  </trkpt>  <trkpt lat="55.977397918999998" lon="37.867275237999998">    <time>2013-08-08T17:47:30Z</time>  </trkpt>  <trkpt lat="55.977550506999997" lon="37.867057799999998">    <time>2013-08-08T17:47:33Z</time>  </trkpt>  <trkpt lat="55.977684021000002" lon="37.866809844999999">    <time>2013-08-08T17:47:36Z</time>  </trkpt>  <trkpt lat="55.977809905999997" lon="37.866550445999998">    <time>2013-08-08T17:47:39Z</time>  </trkpt>  <trkpt lat="55.977924346999998" lon="37.866275786999999">    <time>2013-08-08T17:47:42Z</time>  </trkpt>  <trkpt lat="55.978046417000002" lon="37.866008759000003">    <time>2013-08-08T17:47:45Z</time>  </trkpt>  <trkpt lat="55.978172301999997" lon="37.865730286000002">    <time>2013-08-08T17:47:48Z</time>  </trkpt>  <trkpt lat="55.978305816999999" lon="37.865459442000002">    <time>2013-08-08T17:47:51Z</time>  </trkpt>  <trkpt lat="55.978435515999998" lon="37.865196228000002">    <time>2013-08-08T17:47:54Z</time>  </trkpt>  <trkpt lat="55.978561401" lon="37.864925384999999">    <time>2013-08-08T17:47:57Z</time>  </trkpt>  <trkpt lat="55.978683472" lon="37.864654541">    <time>2013-08-08T17:48:00Z</time>  </trkpt>  <trkpt lat="55.978813170999999" lon="37.864383697999997">    <time>2013-08-08T17:48:03Z</time>  </trkpt>  <trkpt lat="55.978946686" lon="37.864112853999998">    <time>2013-08-08T17:48:06Z</time>  </trkpt>  <trkpt lat="55.979072571000003" lon="37.863845824999999">    <time>2013-08-08T17:48:09Z</time>  </trkpt>  <trkpt lat="55.979198455999999" lon="37.863567351999997">    <time>2013-08-08T17:48:12Z</time>  </trkpt>  <trkpt lat="55.979305267000001" lon="37.863342285000002">    <time>2013-08-08T17:48:15Z</time>  </trkpt>  <trkpt lat="55.979373932000001" lon="37.863170623999999">    <time>2013-08-08T17:48:18Z</time>  </trkpt>  <trkpt lat="55.979427338000001" lon="37.863086699999997">    <time>2013-08-08T17:48:21Z</time>  </trkpt>  <trkpt lat="55.979457855" lon="37.863033295000001">    <time>2013-08-08T17:48:24Z</time>  </trkpt>  <trkpt lat="55.979457855" lon="37.862934113000001">    <time>2013-08-08T17:48:27Z</time>  </trkpt>  <trkpt lat="55.979366302000003" lon="37.862865448000001">    <time>2013-08-08T17:48:30Z</time>  </trkpt>  <trkpt lat="55.979339600000003" lon="37.862731934000003">    <time>2013-08-08T17:48:33Z</time>  </trkpt>  <trkpt lat="55.979366302000003" lon="37.862606049">    <time>2013-08-08T17:48:36Z</time>  </trkpt>  <trkpt lat="55.979385376000003" lon="37.862499237000002">    <time>2013-08-08T17:48:39Z</time>  </trkpt>  <trkpt lat="55.979381560999997" lon="37.862396240000002">    <time>2013-08-08T17:48:42Z</time>  </trkpt>  <trkpt lat="55.979381560999997" lon="37.862319946">    <time>2013-08-08T17:48:45Z</time>  </trkpt>  <trkpt lat="55.979370117000002" lon="37.862312316999997">    <time>2013-08-08T17:48:48Z</time>  </trkpt>  <trkpt lat="55.979373932000001" lon="37.862316131999997">    <time>2013-08-08T17:48:54Z</time>  </trkpt>  <trkpt lat="55.979370117000002" lon="37.862316131999997">    <time>2013-08-08T17:48:57Z</time>  </trkpt>  <trkpt lat="55.979373932000001" lon="37.862319946">    <time>2013-08-08T17:49:00Z</time>  </trkpt>  <trkpt lat="55.979385376000003" lon="37.862316131999997">    <time>2013-08-08T17:49:03Z</time>  </trkpt>  <trkpt lat="55.979454040999997" lon="37.862251282000003">    <time>2013-08-08T17:49:06Z</time>  </trkpt>  <trkpt lat="55.979541779000002" lon="37.862117767000001">    <time>2013-08-08T17:49:09Z</time>  </trkpt>  <trkpt lat="55.979637146000002" lon="37.861980438000003">    <time>2013-08-08T17:49:12Z</time>  </trkpt>  <trkpt lat="55.979763030999997" lon="37.861953735">    <time>2013-08-08T17:49:15Z</time>  </trkpt>  <trkpt lat="55.979888916" lon="37.862030029000003">    <time>2013-08-08T17:49:18Z</time>  </trkpt>  <trkpt lat="55.980022429999998" lon="37.862174988">    <time>2013-08-08T17:49:21Z</time>  </trkpt>  <trkpt lat="55.980175017999997" lon="37.862304688000002">    <time>2013-08-08T17:49:24Z</time>  </trkpt>  <trkpt lat="55.980331421000002" lon="37.862442016999999">    <time>2013-08-08T17:49:27Z</time>  </trkpt>  <trkpt lat="55.980480194000002" lon="37.862586974999999">    <time>2013-08-08T17:49:30Z</time>  </trkpt>  <trkpt lat="55.980632782000001" lon="37.862728119000003">    <time>2013-08-08T17:49:33Z</time>  </trkpt>  <trkpt lat="55.980792999000002" lon="37.862861633000001">    <time>2013-08-08T17:49:36Z</time>  </trkpt>  <trkpt lat="55.980953217" lon="37.862987517999997">    <time>2013-08-08T17:49:39Z</time>  </trkpt>  <trkpt lat="55.981109619000001" lon="37.863136292">    <time>2013-08-08T17:49:42Z</time>  </trkpt>  <trkpt lat="55.981292725000003" lon="37.863277435000001">    <time>2013-08-08T17:49:45Z</time>  </trkpt>  <trkpt lat="55.981452941999997" lon="37.863407135000003">    <time>2013-08-08T17:49:48Z</time>  </trkpt>  <trkpt lat="55.981609343999999" lon="37.863555908000002">    <time>2013-08-08T17:49:51Z</time>  </trkpt>  <trkpt lat="55.981784820999998" lon="37.863697051999999">    <time>2013-08-08T17:49:54Z</time>  </trkpt>  <trkpt lat="55.981952667000002" lon="37.863842009999999">    <time>2013-08-08T17:49:57Z</time>  </trkpt>  <trkpt lat="55.982116699000002" lon="37.863986969000003">    <time>2013-08-08T17:50:00Z</time>  </trkpt>  <trkpt lat="55.982273102000001" lon="37.864139557000001">    <time>2013-08-08T17:50:03Z</time>  </trkpt>  <trkpt lat="55.982433319000002" lon="37.864276885999999">    <time>2013-08-08T17:50:06Z</time>  </trkpt>  <trkpt lat="55.982593536000003" lon="37.864421843999999">    <time>2013-08-08T17:50:09Z</time>  </trkpt>  <trkpt lat="55.982753754000001" lon="37.864555359000001">    <time>2013-08-08T17:50:12Z</time>  </trkpt>  <trkpt lat="55.982917786000002" lon="37.864681244000003">    <time>2013-08-08T17:50:15Z</time>  </trkpt>  <trkpt lat="55.983066559000001" lon="37.864826202000003">    <time>2013-08-08T17:50:18Z</time>  </trkpt>  <trkpt lat="55.983230591000002" lon="37.864959716999998">    <time>2013-08-08T17:50:21Z</time>  </trkpt>  <trkpt lat="55.983383179" lon="37.865116119">    <time>2013-08-08T17:50:24Z</time>  </trkpt>  <trkpt lat="55.983547211000001" lon="37.865242004000002">    <time>2013-08-08T17:50:27Z</time>  </trkpt>  <trkpt lat="55.983711243000002" lon="37.865375518999997">    <time>2013-08-08T17:50:30Z</time>  </trkpt>  <trkpt lat="55.983871460000003" lon="37.865509033000002">    <time>2013-08-08T17:50:33Z</time>  </trkpt>  <trkpt lat="55.984039307000003" lon="37.865650176999999">    <time>2013-08-08T17:50:36Z</time>  </trkpt>  <trkpt lat="55.984207153" lon="37.865791321000003">    <time>2013-08-08T17:50:39Z</time>  </trkpt>  <trkpt lat="55.984371185000001" lon="37.865928650000001">    <time>2013-08-08T17:50:42Z</time>  </trkpt>  <trkpt lat="55.984539032000001" lon="37.866077423">    <time>2013-08-08T17:50:45Z</time>  </trkpt>  <trkpt lat="55.984714508000003" lon="37.866222381999997">    <time>2013-08-08T17:50:48Z</time>  </trkpt>  <trkpt lat="55.984878539999997" lon="37.866386413999997">    <time>2013-08-08T17:50:51Z</time>  </trkpt>  <trkpt lat="55.985054015999999" lon="37.866542815999999">    <time>2013-08-08T17:50:54Z</time>  </trkpt>  <trkpt lat="55.985221863" lon="37.866706848">    <time>2013-08-08T17:50:57Z</time>  </trkpt>  <trkpt lat="55.985366821" lon="37.866840363000001">    <time>2013-08-08T17:51:00Z</time>  </trkpt>  <trkpt lat="55.985477447999997" lon="37.866920471">    <time>2013-08-08T17:51:03Z</time>  </trkpt>  <trkpt lat="55.985549927000001" lon="37.866977691999999">    <time>2013-08-08T17:51:06Z</time>  </trkpt>  <trkpt lat="55.985633849999999" lon="37.867012023999997">    <time>2013-08-08T17:51:09Z</time>  </trkpt>  <trkpt lat="55.985694885000001" lon="37.867046356000003">    <time>2013-08-08T17:51:12Z</time>  </trkpt>  <trkpt lat="55.985729218000003" lon="37.867134094000001">    <time>2013-08-08T17:51:15Z</time>  </trkpt>  <trkpt lat="55.985767365000001" lon="37.867179870999998">    <time>2013-08-08T17:51:18Z</time>  </trkpt>  <trkpt lat="55.985824585000003" lon="37.867176055999998">    <time>2013-08-08T17:51:21Z</time>  </trkpt>  <trkpt lat="55.985828400000003" lon="37.867031097000002">    <time>2013-08-08T17:51:24Z</time>  </trkpt>  <trkpt lat="55.985717772999998" lon="37.866855620999999">    <time>2013-08-08T17:51:27Z</time>  </trkpt>  <trkpt lat="55.985691070999998" lon="37.866565704000003">    <time>2013-08-08T17:51:30Z</time>  </trkpt>  <trkpt lat="55.985729218000003" lon="37.866252899000003">    <time>2013-08-08T17:51:33Z</time>  </trkpt>  <trkpt lat="55.985778809000003" lon="37.865940094000003">    <time>2013-08-08T17:51:36Z</time>  </trkpt>  <trkpt lat="55.985836028999998" lon="37.865627289000003">    <time>2013-08-08T17:51:39Z</time>  </trkpt>  <trkpt lat="55.985885619999998" lon="37.865303040000001">    <time>2013-08-08T17:51:42Z</time>  </trkpt>  <trkpt lat="55.985927582000002" lon="37.864978790000002">    <time>2013-08-08T17:51:45Z</time>  </trkpt>  <trkpt lat="55.985961914000001" lon="37.864654541">    <time>2013-08-08T17:51:48Z</time>  </trkpt>  <trkpt lat="55.986003875999998" lon="37.864345551">    <time>2013-08-08T17:51:51Z</time>  </trkpt>  <trkpt lat="55.986045836999999" lon="37.864044188999998">    <time>2013-08-08T17:51:54Z</time>  </trkpt>  <trkpt lat="55.986103057999998" lon="37.863719940000003">    <time>2013-08-08T17:51:57Z</time>  </trkpt>  <trkpt lat="55.986179352000001" lon="37.863410950000002">    <time>2013-08-08T17:52:00Z</time>  </trkpt>  <trkpt lat="55.986267089999998" lon="37.863113403">    <time>2013-08-08T17:52:03Z</time>  </trkpt>  <trkpt lat="55.986373901" lon="37.862812042000002">    <time>2013-08-08T17:52:06Z</time>  </trkpt>  <trkpt lat="55.986484527999998" lon="37.862518311000002">    <time>2013-08-08T17:52:09Z</time>  </trkpt>  <trkpt lat="55.986595154" lon="37.862220764">    <time>2013-08-08T17:52:12Z</time>  </trkpt>  <trkpt lat="55.986709595000001" lon="37.861938477000002">    <time>2013-08-08T17:52:15Z</time>  </trkpt>  <trkpt lat="55.986824036000002" lon="37.861656189000001">    <time>2013-08-08T17:52:18Z</time>  </trkpt>  <trkpt lat="55.986938477000002" lon="37.861366271999998">    <time>2013-08-08T17:52:21Z</time>  </trkpt>  <trkpt lat="55.987037659000002" lon="37.861072540000002">    <time>2013-08-08T17:52:24Z</time>  </trkpt>  <trkpt lat="55.987136841000002" lon="37.860778809000003">    <time>2013-08-08T17:52:27Z</time>  </trkpt>  <trkpt lat="55.987239838000001" lon="37.860492706000002">    <time>2013-08-08T17:52:30Z</time>  </trkpt>  <trkpt lat="55.987350464000002" lon="37.860198975000003">    <time>2013-08-08T17:52:33Z</time>  </trkpt>  <trkpt lat="55.987464905000003" lon="37.859893798999998">    <time>2013-08-08T17:52:36Z</time>  </trkpt>  <trkpt lat="55.987567902000002" lon="37.859569550000003">    <time>2013-08-08T17:52:39Z</time>  </trkpt>  <trkpt lat="55.987648010000001" lon="37.859230042">    <time>2013-08-08T17:52:42Z</time>  </trkpt>  <trkpt lat="55.987716675000001" lon="37.858879088999998">    <time>2013-08-08T17:52:45Z</time>  </trkpt>  <trkpt lat="55.987785338999998" lon="37.858520507999998">    <time>2013-08-08T17:52:48Z</time>  </trkpt>  <trkpt lat="55.987861633000001" lon="37.858173370000003">    <time>2013-08-08T17:52:51Z</time>  </trkpt>  <trkpt lat="55.987941741999997" lon="37.857822417999998">    <time>2013-08-08T17:52:54Z</time>  </trkpt>  <trkpt lat="55.988014221" lon="37.857471466">    <time>2013-08-08T17:52:57Z</time>  </trkpt>  <trkpt lat="55.988090515000003" lon="37.857112884999999">    <time>2013-08-08T17:53:00Z</time>  </trkpt>  <trkpt lat="55.988162994" lon="37.856750488000003">    <time>2013-08-08T17:53:03Z</time>  </trkpt>  <trkpt lat="55.988246918000002" lon="37.856384276999997">    <time>2013-08-08T17:53:06Z</time>  </trkpt>  <trkpt lat="55.988327026" lon="37.855998993">    <time>2013-08-08T17:53:09Z</time>  </trkpt>  <trkpt lat="55.988407135000003" lon="37.855617522999999">    <time>2013-08-08T17:53:12Z</time>  </trkpt>  <trkpt lat="55.988483428999999" lon="37.855228424000003">    <time>2013-08-08T17:53:15Z</time>  </trkpt>  <trkpt lat="55.988571167000003" lon="37.854846954000003">    <time>2013-08-08T17:53:18Z</time>  </trkpt>  <trkpt lat="55.988651275999999" lon="37.854469299000002">    <time>2013-08-08T17:53:21Z</time>  </trkpt>  <trkpt lat="55.988727570000002" lon="37.854129790999998">    <time>2013-08-08T17:53:24Z</time>  </trkpt>  <trkpt lat="55.988811493" lon="37.853790283000002">    <time>2013-08-08T17:53:27Z</time>  </trkpt>  <trkpt lat="55.988891602000002" lon="37.853462219000001">    <time>2013-08-08T17:53:30Z</time>  </trkpt>  <trkpt lat="55.988971710000001" lon="37.853134154999999">    <time>2013-08-08T17:53:33Z</time>  </trkpt>  <trkpt lat="55.989051818999997" lon="37.852809905999997">    <time>2013-08-08T17:53:36Z</time>  </trkpt>  <trkpt lat="55.989131927000003" lon="37.852512359999999">    <time>2013-08-08T17:53:39Z</time>  </trkpt>  <trkpt lat="55.989219665999997" lon="37.852222443000002">    <time>2013-08-08T17:53:42Z</time>  </trkpt>  <trkpt lat="55.989311217999997" lon="37.851917266999997">    <time>2013-08-08T17:53:45Z</time>  </trkpt>  <trkpt lat="55.989402771000002" lon="37.851615905999999">    <time>2013-08-08T17:53:48Z</time>  </trkpt>  <trkpt lat="55.989490508999999" lon="37.851314545000001">    <time>2013-08-08T17:53:51Z</time>  </trkpt>  <trkpt lat="55.989578246999997" lon="37.851001740000001">    <time>2013-08-08T17:53:54Z</time>  </trkpt>  <trkpt lat="55.989673615000001" lon="37.850692748999997">    <time>2013-08-08T17:53:57Z</time>  </trkpt>  <trkpt lat="55.989765167000002" lon="37.850395202999998">    <time>2013-08-08T17:54:00Z</time>  </trkpt>  <trkpt lat="55.989849091000004" lon="37.850074767999999">    <time>2013-08-08T17:54:03Z</time>  </trkpt>  <trkpt lat="55.989940642999997" lon="37.849765777999998">    <time>2013-08-08T17:54:06Z</time>  </trkpt>  <trkpt lat="55.990036011000001" lon="37.849460602000001">    <time>2013-08-08T17:54:09Z</time>  </trkpt>  <trkpt lat="55.990131378000001" lon="37.849143982000001">    <time>2013-08-08T17:54:12Z</time>  </trkpt>  <trkpt lat="55.990226745999998" lon="37.848842621000003">    <time>2013-08-08T17:54:15Z</time>  </trkpt>  <trkpt lat="55.990322112999998" lon="37.848537444999998">    <time>2013-08-08T17:54:18Z</time>  </trkpt>  <trkpt lat="55.990409851000003" lon="37.848255156999997">    <time>2013-08-08T17:54:21Z</time>  </trkpt>  <trkpt lat="55.990497589" lon="37.847999573000003">    <time>2013-08-08T17:54:24Z</time>  </trkpt>  <trkpt lat="55.990589141999997" lon="37.847724915000001">    <time>2013-08-08T17:54:27Z</time>  </trkpt>  <trkpt lat="55.990669250000003" lon="37.847454071000001">    <time>2013-08-08T17:54:30Z</time>  </trkpt>  <trkpt lat="55.990741730000003" lon="37.847141266000001">    <time>2013-08-08T17:54:33Z</time>  </trkpt>  <trkpt lat="55.990821838000002" lon="37.846855163999997">    <time>2013-08-08T17:54:36Z</time>  </trkpt>  <trkpt lat="55.990901946999998" lon="37.846572876000003">    <time>2013-08-08T17:54:39Z</time>  </trkpt>  <trkpt lat="55.990993500000002" lon="37.846286773999999">    <time>2013-08-08T17:54:42Z</time>  </trkpt>  <trkpt lat="55.991085052000003" lon="37.846000670999999">    <time>2013-08-08T17:54:45Z</time>  </trkpt>  <trkpt lat="55.991180419999999" lon="37.845706939999999">    <time>2013-08-08T17:54:48Z</time>  </trkpt>  <trkpt lat="55.991275786999999" lon="37.845417023000003">    <time>2013-08-08T17:54:51Z</time>  </trkpt>  <trkpt lat="55.991374968999999" lon="37.845108031999999">    <time>2013-08-08T17:54:54Z</time>  </trkpt>  <trkpt lat="55.991477965999998" lon="37.844814301">    <time>2013-08-08T17:54:57Z</time>  </trkpt>  <trkpt lat="55.991577147999998" lon="37.844516753999997">    <time>2013-08-08T17:55:00Z</time>  </trkpt>  <trkpt lat="55.991680144999997" lon="37.844219207999998">    <time>2013-08-08T17:55:03Z</time>  </trkpt>  <trkpt lat="55.991790770999998" lon="37.843929291000002">    <time>2013-08-08T17:55:06Z</time>  </trkpt>  <trkpt lat="55.991916656000001" lon="37.843647003000001">    <time>2013-08-08T17:55:09Z</time>  </trkpt>  <trkpt lat="55.992076873999999" lon="37.843410491999997">    <time>2013-08-08T17:55:12Z</time>  </trkpt>  <trkpt lat="55.992263794000003" lon="37.843158721999998">    <time>2013-08-08T17:55:15Z</time>  </trkpt>  <trkpt lat="55.992450714" lon="37.842838286999999">    <time>2013-08-08T17:55:18Z</time>  </trkpt>  <trkpt lat="55.992603301999999" lon="37.842460631999998">    <time>2013-08-08T17:55:21Z</time>  </trkpt>  <trkpt lat="55.992687224999997" lon="37.842014313">    <time>2013-08-08T17:55:24Z</time>  </trkpt>  <trkpt lat="55.992774963000002" lon="37.841587066999999">    <time>2013-08-08T17:55:27Z</time>  </trkpt>  <trkpt lat="55.992870330999999" lon="37.841171265">    <time>2013-08-08T17:55:30Z</time>  </trkpt>  <trkpt lat="55.992958068999997" lon="37.840755463000001">    <time>2013-08-08T17:55:33Z</time>  </trkpt>  <trkpt lat="55.993041992000002" lon="37.840351105000003">    <time>2013-08-08T17:55:36Z</time>  </trkpt>  <trkpt lat="55.993122100999997" lon="37.839931487999998">    <time>2013-08-08T17:55:39Z</time>  </trkpt>  <trkpt lat="55.993209839000002" lon="37.839515685999999">    <time>2013-08-08T17:55:42Z</time>  </trkpt>  <trkpt lat="55.993297577" lon="37.839080811000002">    <time>2013-08-08T17:55:45Z</time>  </trkpt>  <trkpt lat="55.993350982999999" lon="37.838638306">    <time>2013-08-08T17:55:48Z</time>  </trkpt>  <trkpt lat="55.993377686000002" lon="37.838211059999999">    <time>2013-08-08T17:55:51Z</time>  </trkpt>  <trkpt lat="55.993389129999997" lon="37.837795258">    <time>2013-08-08T17:55:54Z</time>  </trkpt>  <trkpt lat="55.993408203000001" lon="37.837417602999999">    <time>2013-08-08T17:55:57Z</time>  </trkpt>  <trkpt lat="55.993415833" lon="37.837066649999997">    <time>2013-08-08T17:56:00Z</time>  </trkpt>  <trkpt lat="55.993423462000003" lon="37.836708068999997">    <time>2013-08-08T17:56:03Z</time>  </trkpt>  <trkpt lat="55.993446349999999" lon="37.836368561">    <time>2013-08-08T17:56:06Z</time>  </trkpt>  <trkpt lat="55.993465424" lon="37.836051941000001">    <time>2013-08-08T17:56:09Z</time>  </trkpt>  <trkpt lat="55.993499755999999" lon="37.835746765000003">    <time>2013-08-08T17:56:12Z</time>  </trkpt>  <trkpt lat="55.993530272999998" lon="37.835433960000003">    <time>2013-08-08T17:56:15Z</time>  </trkpt>  <trkpt lat="55.993568420000003" lon="37.835113524999997">    <time>2013-08-08T17:56:18Z</time>  </trkpt>  <trkpt lat="55.993610382" lon="37.834777832">    <time>2013-08-08T17:56:21Z</time>  </trkpt>  <trkpt lat="55.993656158" lon="37.834457397000001">    <time>2013-08-08T17:56:24Z</time>  </trkpt>  <trkpt lat="55.993705749999997" lon="37.834148407000001">    <time>2013-08-08T17:56:27Z</time>  </trkpt>  <trkpt lat="55.993755341000004" lon="37.833843231000003">    <time>2013-08-08T17:56:30Z</time>  </trkpt>  <trkpt lat="55.993820190000001" lon="37.833530426000003">    <time>2013-08-08T17:56:33Z</time>  </trkpt>  <trkpt lat="55.993892670000001" lon="37.833213806000003">    <time>2013-08-08T17:56:36Z</time>  </trkpt>  <trkpt lat="55.993961333999998" lon="37.832897185999997">    <time>2013-08-08T17:56:39Z</time>  </trkpt>  <trkpt lat="55.994029998999999" lon="37.832603454999997">    <time>2013-08-08T17:56:42Z</time>  </trkpt>  <trkpt lat="55.994094849" lon="37.832324982000003">    <time>2013-08-08T17:56:45Z</time>  </trkpt>  <trkpt lat="55.994152069000002" lon="37.832069396999998">    <time>2013-08-08T17:56:48Z</time>  </trkpt>  <trkpt lat="55.994209290000001" lon="37.831809997999997">    <time>2013-08-08T17:56:51Z</time>  </trkpt>  <trkpt lat="55.994258881" lon="37.831535338999998">    <time>2013-08-08T17:56:54Z</time>  </trkpt>  <trkpt lat="55.994312286000003" lon="37.831268311000002">    <time>2013-08-08T17:56:57Z</time>  </trkpt>  <trkpt lat="55.994373322000001" lon="37.830997467000003">    <time>2013-08-08T17:57:00Z</time>  </trkpt>  <trkpt lat="55.994449615000001" lon="37.830711364999999">    <time>2013-08-08T17:57:03Z</time>  </trkpt>  <trkpt lat="55.994541167999998" lon="37.830429076999998">    <time>2013-08-08T17:57:06Z</time>  </trkpt>  <trkpt lat="55.994663238999998" lon="37.830181121999999">    <time>2013-08-08T17:57:09Z</time>  </trkpt>  <trkpt lat="55.994792938000003" lon="37.829902648999997">    <time>2013-08-08T17:57:12Z</time>  </trkpt>  <trkpt lat="55.994838715" lon="37.829708099000001">    <time>2013-08-08T17:57:15Z</time>  </trkpt>  <trkpt lat="55.994838715" lon="37.829635619999998">    <time>2013-08-08T17:57:18Z</time>  </trkpt>  <trkpt lat="55.994831085000001" lon="37.829654693999998">    <time>2013-08-08T17:57:21Z</time>  </trkpt>  <trkpt lat="55.994838715" lon="37.829647064">    <time>2013-08-08T17:57:27Z</time>  </trkpt>  <trkpt lat="55.994846344000003" lon="37.829631804999998">    <time>2013-08-08T17:57:30Z</time>  </trkpt>  <trkpt lat="55.994857787999997" lon="37.829627991000002">    <time>2013-08-08T17:57:33Z</time>  </trkpt>  <trkpt lat="55.994884491000001" lon="37.829608917000002">    <time>2013-08-08T17:57:36Z</time>  </trkpt>  <trkpt lat="55.994922637999998" lon="37.829559326000002">    <time>2013-08-08T17:57:39Z</time>  </trkpt>  <trkpt lat="55.994960785000004" lon="37.829524994000003">    <time>2013-08-08T17:57:42Z</time>  </trkpt>  <trkpt lat="55.994987488" lon="37.829502106">    <time>2013-08-08T17:57:45Z</time>  </trkpt>  <trkpt lat="55.995014191000003" lon="37.829463959000002">    <time>2013-08-08T17:57:48Z</time>  </trkpt>  <trkpt lat="55.995044708000002" lon="37.829421996999997">    <time>2013-08-08T17:57:51Z</time>  </trkpt>  <trkpt lat="55.995071410999998" lon="37.829399109000001">    <time>2013-08-08T17:57:54Z</time>  </trkpt>  <trkpt lat="55.995086669999999" lon="37.829383849999999">    <time>2013-08-08T17:57:57Z</time>  </trkpt>  <trkpt lat="55.995105743000003" lon="37.829349518000001">    <time>2013-08-08T17:58:00Z</time>  </trkpt>  <trkpt lat="55.995132446" lon="37.829315186000002">    <time>2013-08-08T17:58:03Z</time>  </trkpt>  <trkpt lat="55.995136260999999" lon="37.829280853">    <time>2013-08-08T17:58:06Z</time>  </trkpt>  <trkpt lat="55.995136260999999" lon="37.829231262">    <time>2013-08-08T17:58:09Z</time>  </trkpt>  <trkpt lat="55.995143890000001" lon="37.829177856000001">    <time>2013-08-08T17:58:12Z</time>  </trkpt>  <trkpt lat="55.995155334000003" lon="37.829170226999999">    <time>2013-08-08T17:58:15Z</time>  </trkpt>  <trkpt lat="55.995155334000003" lon="37.829158782999997">    <time>2013-08-08T17:58:18Z</time>  </trkpt>  <trkpt lat="55.995147705000001" lon="37.829162598000003">    <time>2013-08-08T17:58:21Z</time>  </trkpt>  <trkpt lat="55.995143890000001" lon="37.829162598000003">    <time>2013-08-08T17:58:39Z</time>  </trkpt>  <trkpt lat="55.995143890000001" lon="37.829143524000003">    <time>2013-08-08T17:58:57Z</time>  </trkpt>  <trkpt lat="55.995113373000002" lon="37.829051970999998">    <time>2013-08-08T17:59:00Z</time>  </trkpt>  <trkpt lat="55.995132446" lon="37.828933716000002">    <time>2013-08-08T17:59:03Z</time>  </trkpt>  <trkpt lat="55.995189666999998" lon="37.828811645999998">    <time>2013-08-08T17:59:06Z</time>  </trkpt>  <trkpt lat="55.995269774999997" lon="37.828681946000003">    <time>2013-08-08T17:59:09Z</time>  </trkpt>  <trkpt lat="55.995334624999998" lon="37.828502655000001">    <time>2013-08-08T17:59:12Z</time>  </trkpt>  <trkpt lat="55.995403289999999" lon="37.828304291000002">    <time>2013-08-08T17:59:15Z</time>  </trkpt>  <trkpt lat="55.995487212999997" lon="37.828102112000003">    <time>2013-08-08T17:59:18Z</time>  </trkpt>  <trkpt lat="55.995559692" lon="37.827873230000002">    <time>2013-08-08T17:59:21Z</time>  </trkpt>  <trkpt lat="55.995624542000002" lon="37.827617644999997">    <time>2013-08-08T17:59:24Z</time>  </trkpt>  <trkpt lat="55.995677948000001" lon="37.827392578000001">    <time>2013-08-08T17:59:27Z</time>  </trkpt>  <trkpt lat="55.995735168000003" lon="37.827198029000002">    <time>2013-08-08T17:59:30Z</time>  </trkpt>  <trkpt lat="55.995811461999999" lon="37.826995850000003">    <time>2013-08-08T17:59:33Z</time>  </trkpt>  <trkpt lat="55.995918273999997" lon="37.826911926000001">    <time>2013-08-08T17:59:36Z</time>  </trkpt>  <trkpt lat="55.996025084999999" lon="37.827056884999998">    <time>2013-08-08T17:59:39Z</time>  </trkpt>  <trkpt lat="55.996109009000001" lon="37.827285766999999">    <time>2013-08-08T17:59:42Z</time>  </trkpt>  <trkpt lat="55.996162415000001" lon="37.827575684000003">    <time>2013-08-08T17:59:45Z</time>  </trkpt>  <trkpt lat="55.996196746999999" lon="37.827884674000003">    <time>2013-08-08T17:59:48Z</time>  </trkpt>  <trkpt lat="55.996219635000003" lon="37.828193665000001">    <time>2013-08-08T17:59:51Z</time>  </trkpt>  <trkpt lat="55.996227263999998" lon="37.828487396">    <time>2013-08-08T17:59:54Z</time>  </trkpt>  <trkpt lat="55.996231078999998" lon="37.828746795999997">    <time>2013-08-08T17:59:57Z</time>  </trkpt>  <trkpt lat="55.996253967000001" lon="37.828971863">    <time>2013-08-08T18:00:00Z</time>  </trkpt>  <trkpt lat="55.996364593999999" lon="37.829193115000002">    <time>2013-08-08T18:00:03Z</time>  </trkpt>  <trkpt lat="55.996540070000002" lon="37.829364777000002">    <time>2013-08-08T18:00:06Z</time>  </trkpt>  <trkpt lat="55.996677398999999" lon="37.829483031999999">    <time>2013-08-08T18:00:09Z</time>  </trkpt>  <trkpt lat="55.996704102000002" lon="37.829467772999998">    <time>2013-08-08T18:00:12Z</time>  </trkpt>  <trkpt lat="55.996730804000002" lon="37.829498291">    <time>2013-08-08T18:00:15Z</time>  </trkpt>  <trkpt lat="55.996788025000001" lon="37.829540252999998">    <time>2013-08-08T18:00:18Z</time>  </trkpt>  <trkpt lat="55.996875762999998" lon="37.829605102999999">    <time>2013-08-08T18:00:21Z</time>  </trkpt>  <trkpt lat="55.996974944999998" lon="37.829669952000003">    <time>2013-08-08T18:00:24Z</time>  </trkpt>  <trkpt lat="55.997074126999998" lon="37.829734801999997">    <time>2013-08-08T18:00:27Z</time>  </trkpt>  <trkpt lat="55.997173308999997" lon="37.829795836999999">    <time>2013-08-08T18:00:30Z</time>  </trkpt>  <trkpt lat="55.997241973999998" lon="37.829841614000003">    <time>2013-08-08T18:00:33Z</time>  </trkpt>  <trkpt lat="55.997291564999998" lon="37.829856872999997">    <time>2013-08-08T18:00:36Z</time>  </trkpt>  <trkpt lat="55.997364044000001" lon="37.829898833999998">    <time>2013-08-08T18:00:39Z</time>  </trkpt>  <trkpt lat="55.997440337999997" lon="37.829952239999997">    <time>2013-08-08T18:00:42Z</time>  </trkpt>  <trkpt lat="55.997528076000002" lon="37.830009459999999">    <time>2013-08-08T18:00:45Z</time>  </trkpt>  <trkpt lat="55.997653960999997" lon="37.830089569000002">    <time>2013-08-08T18:00:48Z</time>  </trkpt>  <trkpt lat="55.997795105000002" lon="37.830177307">    <time>2013-08-08T18:00:51Z</time>  </trkpt>  <trkpt lat="55.997943878000001" lon="37.830265044999997">    <time>2013-08-08T18:00:54Z</time>  </trkpt>  <trkpt lat="55.998096466" lon="37.830356598000002">    <time>2013-08-08T18:00:57Z</time>  </trkpt>  <trkpt lat="55.998249053999999" lon="37.830444335999999">    <time>2013-08-08T18:01:00Z</time>  </trkpt>  <trkpt lat="55.998401641999997" lon="37.830528258999998">    <time>2013-08-08T18:01:03Z</time>  </trkpt>  <trkpt lat="55.998561858999999" lon="37.830604553000001">    <time>2013-08-08T18:01:06Z</time>  </trkpt>  <trkpt lat="55.998718261999997" lon="37.830657959">    <time>2013-08-08T18:01:09Z</time>  </trkpt>  <trkpt lat="55.998878478999998" lon="37.830703735">    <time>2013-08-08T18:01:12Z</time>  </trkpt>  <trkpt lat="55.999042510999999" lon="37.830738068000002">    <time>2013-08-08T18:01:15Z</time>  </trkpt>  <trkpt lat="55.999206543" lon="37.830753326">    <time>2013-08-08T18:01:18Z</time>  </trkpt>  <trkpt lat="55.999366760000001" lon="37.830776215">    <time>2013-08-08T18:01:21Z</time>  </trkpt>  <trkpt lat="55.999534607000001" lon="37.830806731999999">    <time>2013-08-08T18:01:24Z</time>  </trkpt>  <trkpt lat="55.999687195" lon="37.830825806">    <time>2013-08-08T18:01:27Z</time>  </trkpt>  <trkpt lat="55.999835967999999" lon="37.830844878999997">    <time>2013-08-08T18:01:30Z</time>  </trkpt>  <trkpt lat="55.999973296999997" lon="37.830860137999998">    <time>2013-08-08T18:01:33Z</time>  </trkpt>  <trkpt lat="56.000102996999999" lon="37.830883026000002">    <time>2013-08-08T18:01:36Z</time>  </trkpt>  <trkpt lat="56.000217438" lon="37.830894469999997">    <time>2013-08-08T18:01:39Z</time>  </trkpt>  <trkpt lat="56.000328064000001" lon="37.830905913999999">    <time>2013-08-08T18:01:42Z</time>  </trkpt>  <trkpt lat="56.000434875000003" lon="37.830902100000003">    <time>2013-08-08T18:01:45Z</time>  </trkpt>  <trkpt lat="56.000526428000001" lon="37.830913543999998">    <time>2013-08-08T18:01:48Z</time>  </trkpt>  <trkpt lat="56.000568389999998" lon="37.830932617000002">    <time>2013-08-08T18:01:51Z</time>  </trkpt>  <trkpt lat="56.000556946000003" lon="37.830989838000001">    <time>2013-08-08T18:01:54Z</time>  </trkpt>  <trkpt lat="56.000476837000001" lon="37.831016540999997">    <time>2013-08-08T18:01:57Z</time>  </trkpt>  <trkpt lat="56.000385283999996" lon="37.831001282000003">    <time>2013-08-08T18:02:00Z</time>  </trkpt>  <trkpt lat="56.000377655000001" lon="37.831130981000001">    <time>2013-08-08T18:02:03Z</time>  </trkpt>  <trkpt lat="56.000495911000002" lon="37.831260681000003">    <time>2013-08-08T18:02:06Z</time>  </trkpt>  <trkpt lat="56.000652313000003" lon="37.831375121999997">    <time>2013-08-08T18:02:09Z</time>  </trkpt>  <trkpt lat="56.000793457" lon="37.831512451000002">    <time>2013-08-08T18:02:12Z</time>  </trkpt>  <trkpt lat="56.000926970999998" lon="37.831665039000001">    <time>2013-08-08T18:02:15Z</time>  </trkpt>  <trkpt lat="56.001064301" lon="37.831821441999999">    <time>2013-08-08T18:02:18Z</time>  </trkpt>  <trkpt lat="56.001190186000002" lon="37.831981659">    <time>2013-08-08T18:02:21Z</time>  </trkpt>  <trkpt lat="56.001304626" lon="37.832160950000002">    <time>2013-08-08T18:02:24Z</time>  </trkpt>  <trkpt lat="56.001422882" lon="37.832321167000003">    <time>2013-08-08T18:02:27Z</time>  </trkpt>  <trkpt lat="56.001541138" lon="37.832481383999998">    <time>2013-08-08T18:02:30Z</time>  </trkpt>  <trkpt lat="56.001667023000003" lon="37.832637787000003">    <time>2013-08-08T18:02:33Z</time>  </trkpt>  <trkpt lat="56.001785278" lon="37.832798003999997">    <time>2013-08-08T18:02:36Z</time>  </trkpt>  <trkpt lat="56.001907349" lon="37.832946776999997">    <time>2013-08-08T18:02:39Z</time>  </trkpt>  <trkpt lat="56.002033234000002" lon="37.833103180000002">    <time>2013-08-08T18:02:42Z</time>  </trkpt>  <trkpt lat="56.002159118999998" lon="37.833248138000002">    <time>2013-08-08T18:02:45Z</time>  </trkpt>  <trkpt lat="56.002292633000003" lon="37.833385468000003">    <time>2013-08-08T18:02:48Z</time>  </trkpt>  <trkpt lat="56.002429962000001" lon="37.833518982000001">    <time>2013-08-08T18:02:51Z</time>  </trkpt>  <trkpt lat="56.002578735" lon="37.833629608000003">    <time>2013-08-08T18:02:54Z</time>  </trkpt>  <trkpt lat="56.002727509000003" lon="37.833713531000001">    <time>2013-08-08T18:02:57Z</time>  </trkpt>  <trkpt lat="56.002883910999998" lon="37.833702086999999">    <time>2013-08-08T18:03:00Z</time>  </trkpt>  <trkpt lat="56.003036498999997" lon="37.833560943999998">    <time>2013-08-08T18:03:03Z</time>  </trkpt>  <trkpt lat="56.003181458" lon="37.833408356">    <time>2013-08-08T18:03:06Z</time>  </trkpt>  <trkpt lat="56.003322601000001" lon="37.833251953000001">    <time>2013-08-08T18:03:09Z</time>  </trkpt>  <trkpt lat="56.003467559999997" lon="37.833080291999998">    <time>2013-08-08T18:03:12Z</time>  </trkpt>  <trkpt lat="56.003612517999997" lon="37.832927703999999">    <time>2013-08-08T18:03:15Z</time>  </trkpt>  <trkpt lat="56.003757477000001" lon="37.832794188999998">    <time>2013-08-08T18:03:18Z</time>  </trkpt>  <trkpt lat="56.003890990999999" lon="37.832641602000002">    <time>2013-08-08T18:03:21Z</time>  </trkpt>  <trkpt lat="56.004032135000003" lon="37.832469940000003">    <time>2013-08-08T18:03:24Z</time>  </trkpt>  <trkpt lat="56.004161834999998" lon="37.832271575999997">    <time>2013-08-08T18:03:27Z</time>  </trkpt>  <trkpt lat="56.004280090000002" lon="37.832004546999997">    <time>2013-08-08T18:03:30Z</time>  </trkpt>  <trkpt lat="56.004379272000001" lon="37.83171463">    <time>2013-08-08T18:03:33Z</time>  </trkpt>  <trkpt lat="56.004474639999998" lon="37.831420897999998">    <time>2013-08-08T18:03:36Z</time>  </trkpt>  <trkpt lat="56.004570006999998" lon="37.831134796000001">    <time>2013-08-08T18:03:39Z</time>  </trkpt>  <trkpt lat="56.004676818999997" lon="37.830852509000003">    <time>2013-08-08T18:03:42Z</time>  </trkpt>  <trkpt lat="56.004772185999997" lon="37.830574036000002">    <time>2013-08-08T18:03:45Z</time>  </trkpt>  <trkpt lat="56.004878998000002" lon="37.830337524000001">    <time>2013-08-08T18:03:48Z</time>  </trkpt>  <trkpt lat="56.005012512" lon="37.830120086999997">    <time>2013-08-08T18:03:51Z</time>  </trkpt>  <trkpt lat="56.005142212000003" lon="37.829936981000003">    <time>2013-08-08T18:03:54Z</time>  </trkpt>  <trkpt lat="56.005271911999998" lon="37.829772949000002">    <time>2013-08-08T18:03:57Z</time>  </trkpt>  <trkpt lat="56.005409241000002" lon="37.829692841000004">    <time>2013-08-08T18:04:00Z</time>  </trkpt>  <trkpt lat="56.00554657" lon="37.829780579000001">    <time>2013-08-08T18:04:03Z</time>  </trkpt>  <trkpt lat="56.005672455000003" lon="37.829906463999997">    <time>2013-08-08T18:04:06Z</time>  </trkpt>  <trkpt lat="56.005794524999999" lon="37.829998015999998">    <time>2013-08-08T18:04:09Z</time>  </trkpt>  <trkpt lat="56.005863189999999" lon="37.830085754000002">    <time>2013-08-08T18:04:12Z</time>  </trkpt>  <trkpt lat="56.005962371999999" lon="37.830013274999999">    <time>2013-08-08T18:04:15Z</time>  </trkpt>  <trkpt lat="56.006080627000003" lon="37.829975128000001">    <time>2013-08-08T18:04:18Z</time>  </trkpt>  <trkpt lat="56.006217956999997" lon="37.830036163000003">    <time>2013-08-08T18:04:21Z</time>  </trkpt>  <trkpt lat="56.006343842" lon="37.830142975000001">    <time>2013-08-08T18:04:24Z</time>  </trkpt>  <trkpt lat="56.0064888" lon="37.830215453999998">    <time>2013-08-08T18:04:27Z</time>  </trkpt>  <trkpt lat="56.006603241000001" lon="37.830295563">    <time>2013-08-08T18:04:30Z</time>  </trkpt>  <trkpt lat="56.006698608000001" lon="37.830245972">    <time>2013-08-08T18:04:33Z</time>  </trkpt>  <trkpt lat="56.006740569999998" lon="37.830078125">    <time>2013-08-08T18:04:36Z</time>  </trkpt>  <trkpt lat="56.006778717000003" lon="37.829906463999997">    <time>2013-08-08T18:04:39Z</time>  </trkpt>  <trkpt lat="56.006877899000003" lon="37.829872131000002">    <time>2013-08-08T18:04:42Z</time>  </trkpt>  <trkpt lat="56.007007598999998" lon="37.829963683999999">    <time>2013-08-08T18:04:45Z</time>  </trkpt>  <trkpt lat="56.007156371999997" lon="37.830047606999997">    <time>2013-08-08T18:04:48Z</time>  </trkpt>  <trkpt lat="56.007312775000003" lon="37.830139160000002">    <time>2013-08-08T18:04:51Z</time>  </trkpt>  <trkpt lat="56.007472991999997" lon="37.830226897999999">    <time>2013-08-08T18:04:54Z</time>  </trkpt>  <trkpt lat="56.007637023999997" lon="37.830314635999997">    <time>2013-08-08T18:04:57Z</time>  </trkpt>  <trkpt lat="56.007808685000001" lon="37.830394745">    <time>2013-08-08T18:05:00Z</time>  </trkpt>  <trkpt lat="56.007976532000001" lon="37.830474854000002">    <time>2013-08-08T18:05:03Z</time>  </trkpt>  <trkpt lat="56.008140564000001" lon="37.830581664999997">    <time>2013-08-08T18:05:06Z</time>  </trkpt>  <trkpt lat="56.008316039999997" lon="37.830680847000004">    <time>2013-08-08T18:05:09Z</time>  </trkpt>  <trkpt lat="56.008472443000002" lon="37.830722809000001">    <time>2013-08-08T18:05:12Z</time>  </trkpt>  <trkpt lat="56.008602142000001" lon="37.830600738999998">    <time>2013-08-08T18:05:15Z</time>  </trkpt>  <trkpt lat="56.008670807000001" lon="37.830257416000002">    <time>2013-08-08T18:05:18Z</time>  </trkpt>  <trkpt lat="56.008728026999997" lon="37.829895020000002">    <time>2013-08-08T18:05:21Z</time>  </trkpt>  <trkpt lat="56.008792876999998" lon="37.829551696999999">    <time>2013-08-08T18:05:24Z</time>  </trkpt>  <trkpt lat="56.008850098000003" lon="37.829216002999999">    <time>2013-08-08T18:05:27Z</time>  </trkpt>  <trkpt lat="56.008903502999999" lon="37.828887938999998">    <time>2013-08-08T18:05:30Z</time>  </trkpt>  <trkpt lat="56.008941649999997" lon="37.828590392999999">    <time>2013-08-08T18:05:33Z</time>  </trkpt>  <trkpt lat="56.008975982999999" lon="37.828273772999999">    <time>2013-08-08T18:05:36Z</time>  </trkpt>  <trkpt lat="56.008914947999997" lon="37.827953338999997">    <time>2013-08-08T18:05:39Z</time>  </trkpt>  <trkpt lat="56.008808135999999" lon="37.827663422000001">    <time>2013-08-08T18:05:42Z</time>  </trkpt>  <trkpt lat="56.008705139" lon="37.827381133999999">    <time>2013-08-08T18:05:45Z</time>  </trkpt>  <trkpt lat="56.008586884000003" lon="37.827091217000003">    <time>2013-08-08T18:05:48Z</time>  </trkpt>  <trkpt lat="56.008483886999997" lon="37.826797485">    <time>2013-08-08T18:05:51Z</time>  </trkpt>  <trkpt lat="56.008380889999998" lon="37.826499939000001">    <time>2013-08-08T18:05:54Z</time>  </trkpt>  <trkpt lat="56.008277892999999" lon="37.826221466">    <time>2013-08-08T18:05:57Z</time>  </trkpt>  <trkpt lat="56.008159636999999" lon="37.825931549000003">    <time>2013-08-08T18:06:00Z</time>  </trkpt>  <trkpt lat="56.008052825999997" lon="37.825649261000002">    <time>2013-08-08T18:06:03Z</time>  </trkpt>  <trkpt lat="56.007957458" lon="37.825370788999997">    <time>2013-08-08T18:06:06Z</time>  </trkpt>  <trkpt lat="56.007911682" lon="37.825103759999998">    <time>2013-08-08T18:06:09Z</time>  </trkpt>  <trkpt lat="56.007999419999997" lon="37.82484436">    <time>2013-08-08T18:06:12Z</time>  </trkpt>  <trkpt lat="56.008148192999997" lon="37.824604033999996">    <time>2013-08-08T18:06:15Z</time>  </trkpt>  <trkpt lat="56.008285522000001" lon="37.824367522999999">    <time>2013-08-08T18:06:18Z</time>  </trkpt>  <trkpt lat="56.008434295999997" lon="37.824123383">    <time>2013-08-08T18:06:21Z</time>  </trkpt>  <trkpt lat="56.008579253999997" lon="37.823883057000003">    <time>2013-08-08T18:06:24Z</time>  </trkpt>  <trkpt lat="56.008735657000003" lon="37.823638916">    <time>2013-08-08T18:06:27Z</time>  </trkpt>  <trkpt lat="56.008895873999997" lon="37.823406218999999">    <time>2013-08-08T18:06:30Z</time>  </trkpt>  <trkpt lat="56.009059905999997" lon="37.823188782000003">    <time>2013-08-08T18:06:33Z</time>  </trkpt>  <trkpt lat="56.009212494000003" lon="37.822944640999999">    <time>2013-08-08T18:06:36Z</time>  </trkpt>  <trkpt lat="56.009384154999999" lon="37.822761536000002">    <time>2013-08-08T18:06:39Z</time>  </trkpt>  <trkpt lat="56.009559631000002" lon="37.822574615000001">    <time>2013-08-08T18:06:42Z</time>  </trkpt>  <trkpt lat="56.009723663000003" lon="37.822406768999997">    <time>2013-08-08T18:06:45Z</time>  </trkpt>  <trkpt lat="56.009902953999998" lon="37.822242737000003">    <time>2013-08-08T18:06:48Z</time>  </trkpt>  <trkpt lat="56.010070800999998" lon="37.822097778">    <time>2013-08-08T18:06:51Z</time>  </trkpt>  <trkpt lat="56.010234832999998" lon="37.821960449000002">    <time>2013-08-08T18:06:54Z</time>  </trkpt>  <trkpt lat="56.010406494000001" lon="37.821834564">    <time>2013-08-08T18:06:57Z</time>  </trkpt>  <trkpt lat="56.010581969999997" lon="37.821701050000001">    <time>2013-08-08T18:07:00Z</time>  </trkpt>  <trkpt lat="56.010757446" lon="37.821617126">    <time>2013-08-08T18:07:03Z</time>  </trkpt>  <trkpt lat="56.010913848999998" lon="37.821632385000001">    <time>2013-08-08T18:07:06Z</time>  </trkpt>  <trkpt lat="56.011058806999998" lon="37.821460723999998">    <time>2013-08-08T18:07:09Z</time>  </trkpt>  <trkpt lat="56.011226653999998" lon="37.821296691999997">    <time>2013-08-08T18:07:12Z</time>  </trkpt>  <trkpt lat="56.011405945" lon="37.821105957">    <time>2013-08-08T18:07:15Z</time>  </trkpt>  <trkpt lat="56.011558532999999" lon="37.820899963000002">    <time>2013-08-08T18:07:18Z</time>  </trkpt>  <trkpt lat="56.011665344000001" lon="37.820724487">    <time>2013-08-08T18:07:21Z</time>  </trkpt>  <trkpt lat="56.011711120999998" lon="37.820636749000002">    <time>2013-08-08T18:07:24Z</time>  </trkpt>  <trkpt lat="56.011749268000003" lon="37.820549010999997">    <time>2013-08-08T18:07:27Z</time>  </trkpt>  </trkseg></trk></gpx>', filedata = '<?xml version="1.0"?> <gpx version="1.0" creator="Viking -- http://viking.sf.net/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns="http://www.topografix.com/GPX/1/0" xsi:schemaLocation="http://www.topografix.com/GPX/1/0 http://www.topografix.com/GPX/1/0/gpx.xsd"><trk>  <name>Route</name>  <trkseg>  <trkpt lat="56.007727554575922" lon="37.825100013153076">  </trkpt>  <trkpt lat="56.006311932365961" lon="37.829069682495117">  </trkpt>  <trkpt lat="56.005088217134457" lon="37.829670497314453">  </trkpt>  <trkpt lat="56.004344371290273" lon="37.831601687805176">  </trkpt>  <trkpt lat="56.005532118315578" lon="37.832266875640869">  </trkpt>  <trkpt lat="56.005772062776629" lon="37.832181044952392">  </trkpt>  <trkpt lat="56.008123439641807" lon="37.833318301574707">  </trkpt>  <trkpt lat="56.007631581827845" lon="37.836343833343506">  </trkpt>  <trkpt lat="56.002625672699594" lon="37.833591886894226">  </trkpt>  </trkseg></trk></gpx>';

// source/point.js
function Point(t, e) {
    this.lat = t, this.lon = e;
}

function Target(t, e) {
    return this.point = new Point(t, e), this.id = 0, this.oid = 0, this.distance = 0, 
    this.direction = 0, this.flags = {}, this.image = "assets/images/nogps.png", this;
}

function Distance(t, e) {
    var i = t.lat, n = e.lat, o = t.lon, r = e.lon, a = 6378.137, l = (n - i) * Math.PI / 180, s = (r - o) * Math.PI / 180, p = Math.sin(l / 2) * Math.sin(l / 2) + Math.cos(i * Math.PI / 180) * Math.cos(n * Math.PI / 180) * Math.sin(s / 2) * Math.sin(s / 2), h = 2 * Math.atan2(Math.sqrt(p), Math.sqrt(1 - p)), m = a * h;
    return Math.round(1e3 * m);
}

function Angle(t, e) {
    var i = Math.atan2(t.lat * e.lon - e.lat * t.lon, t.lat * e.lat + t.lon * e.lon);
    return i;
}

function normalize(t) {
    var e = Math.sqrt(t.lat * t.lat + t.lon * t.lon);
    return t.lat /= e, t.lon /= e, t;
}

function calcDirection(t, e) {
    return t.lat += e.lat, t.lon += e.lon, normalize(t), t;
}

function simpleTrack(t, e) {
    if (e) for (var i = 1; t.length > i && t[i] && t[i]; i++) 5 > Distance(t[i].point, t[i - 1].point) && (t.splice(i, 1), 
    i--); else for (var i = 1; t.length > i && t[i] && t[i]; i++) 15 > Distance(t[i].point, t[i - 1].point) && (t.splice(i, 1), 
    i--);
    var n, o = 10;
    if (e) {
        do {
            n = 0;
            for (var i = 1; t.length - 1 > i && t[i] && t[i + 1]; i++) {
                var r = new Point(0, 0);
                r.lon = t[i].point.lon - t[i - 1].point.lon, r.lat = t[i].point.lat - t[i - 1].point.lat;
                var a = new Point(0, 0);
                a.lon = t[i + 1].point.lon - t[i].point.lon, a.lat = t[i + 1].point.lat - t[i].point.lat;
                var l = Angle(r, a);
                .1 > Math.abs(l) && (t.splice(i, 1), i--, n = 1);
            }
            o--;
        } while (n && o > 0);
    } else do {
        n = 0;
        for (var i = 1; t.length - 1 > i && t[i] && t[i + 1]; i++) {
            var r = new Point(0, 0);
            r.lon = t[i].point.lon - t[i - 1].point.lon, r.lat = t[i].point.lat - t[i - 1].point.lat;
            var a = new Point(0, 0);
            a.lon = t[i + 1].point.lon - t[i].point.lon, a.lat = t[i + 1].point.lat - t[i].point.lat;
            var l = Angle(r, a);
            .25 > Math.abs(l) && (t.splice(i, 1), i--, n = 1);
        }
        o--;
    } while (n && o > 0);
    if (e) for (var i = 0; t.length > i; i++) t[i].oid = i; else for (var i = 0; t.length > i; i++) t[i].id = i;
}

Point.prototype.setPosition = function(t, e) {
    this.lat = t, this.lon = e;
}, Target.prototype.copyFrom = function(t) {
    return this.direction = t.direction, this.distance = t.distance, this.flags = t.flags, 
    this.id = t.id, this.image = t.image, this.point.lat = t.point.lat, this.point.lon = t.point.lon, 
    this;
}, Target.prototype.setPosition = function(t, e) {
    this.point.setPosition(t, e);
}, Target.prototype.calcDistance = function(t) {
    this.distance = Distance(t, this.point);
}, Target.prototype.calcDirection = function(t, e) {
    var i = new Point(this.point.lat, this.point.lon);
    if (i.lat -= t.lat, i.lon -= t.lon, 0 === e.lat && 0 === e.lon) return this.image2 = "assets/images/arrows/00.png", 
    this.image = "assets/images/nogps.png", this.dir = -1, void 0;
    var n = Angle(i, e);
    this.direction = n;
    var o = Math.PI / 8, r = Math.round(n / o + o / 2);
    r = -r, 0 > r && (r = 16 + r), this.dir = r, this.image2 = "assets/images/arrows/" + r + ".png", 
    this.image = "assets/images/turns/" + r + ".png";
};

// source/guide.js
enyo.kind({
    name: "GuideScene",
    kind: "FittableRows",
    classes: "enyo-fit bk",
    components: [ {
        kind: "onyx.Toolbar",
        components: [ {
            components: [ {
                kind: "FittableColumns",
                classes: "enyo-fit",
                style: "padding:6px",
                components: [ {
                    kind: "onyx.IconButton",
                    src: "assets/images/common-back.png",
                    ontap: "tback",
                    style: "height:32px"
                }, {
                    fit: !0,
                    content: "Turns: 0 of 0",
                    style: "text-align:center",
                    name: "header"
                }, {
                    kind: "onyx.MenuDecorator",
                    onSelect: "menuSelected",
                    components: [ {
                        kind: "onyx.IconButton",
                        src: "assets/images/menu.png"
                    }, {
                        kind: "onyx.Menu",
                        floating: !0,
                        components: [ {
                            content: "Sound on turn",
                            name: "soundMenu"
                        }, {
                            content: "Dark theme",
                            name: "themeMenu"
                        }, {
                            content: "Display track & map",
                            name: "trackmenu"
                        }, {
                            content: "Start from here"
                        }, {
                            classes: "onyx-menu-divider"
                        }, {
                            content: "About"
                        } ]
                    } ]
                } ]
            } ]
        } ]
    }, {
        name: "popup",
        kind: "onyx.Popup",
        centered: !0,
        floating: !0,
        modal: !0,
        allowHtml: !0,
        style: "padding: 10px;"
    }, {
        classes: "center",
        name: "turnHolder",
        components: [ {
            name: "turn",
            kind: "Image",
            classes: "turn"
        } ]
    }, {
        classes: "center",
        name: "compassHolder",
        components: [ {
            name: "compass",
            kind: "Image",
            classes: "compass"
        } ]
    }, {
        classes: "center",
        name: "distanceHolder",
        components: [ {
            name: "distance"
        } ]
    }, {
        kind: "enyo.Audio",
        name: "turnSound",
        src: "assets/audio/turn.ogg"
    }, {
        classes: "map",
        name: "mapHolder",
        components: [ {
            kind: "enyo.Canvas",
            name: "map",
            attributes: {
                width: 320,
                height: 200
            },
            components: []
        } ]
    } ],
    create: function() {
        this.inherited(arguments), this.$.turn.setSrc("assets/images/nogps.png"), this.$.compass.setSrc("assets/images/arrows/00.png");
    },
    rendered: function() {
        this.inherited(arguments), console.log("guide rendered");
    },
    start: function() {
        !this.screenLock && window.navigator.requestWakeLock && (this.screenLock = window.navigator.requestWakeLock("screen"));
        var t = this.$.mapHolder.getBounds();
        if (console.log(t), this.$.map.setAttribute("width", t.width - t.left), this.$.map.setAttribute("height", t.height - t.top), 
        this.startGeowatching(), SETTINGS.dark ? (this.removeClass("bk"), this.addClass("bk_dark"), 
        this.$.distanceHolder.removeClass("center"), this.$.distanceHolder.addClass("center_dark"), 
        this.$.turnHolder.removeClass("center"), this.$.turnHolder.addClass("center_dark"), 
        this.$.compassHolder.removeClass("center"), this.$.compassHolder.addClass("center_dark"), 
        this.$.mapHolder.removeClass("center"), this.$.mapHolder.addClass("center_dark"), 
        this.$.themeMenu.setContent("Bright theme")) : (this.addClass("bk"), this.removeClass("bk_dark"), 
        this.$.distanceHolder.removeClass("center_dark"), this.$.distanceHolder.addClass("center"), 
        this.$.turnHolder.removeClass("center_dark"), this.$.turnHolder.addClass("center"), 
        this.$.compassHolder.removeClass("center_dark"), this.$.compassHolder.addClass("center"), 
        this.$.mapHolder.removeClass("center_dark"), this.$.mapHolder.addClass("center"), 
        this.$.themeMenu.setContent("Dark theme")), SETTINGS.turnsound ? this.$.soundMenu.setContent("\u221a Sound on turn") : this.$.soundMenu.setContent("Sound on turn"), 
        this.$.map.destroyComponents(), SETTINGS.displaytrack) {
            if (this.$.trackmenu.setContent("\u221a Display track & map"), this.$.mapHolder.applyStyle("border", "solid 1px;"), 
            this.$.map.createComponent({
                kind: "enyo.my.prepare",
                outlineColor: "",
                color: ""
            }), waters) for (var e = 0; waters.length > e; e++) this.$.map.createComponent({
                kind: "enyo.my.water",
                water: waters[e],
                color: "",
                outlineColor: ""
            }, {
                addBefore: this.$.mapTrack
            });
            if (buildings) for (e = 0; buildings.length > e; e++) this.$.map.createComponent({
                kind: "enyo.my.building",
                building: buildings[e],
                color: "",
                outlineColor: ""
            }, {
                addBefore: this.$.mapTrack
            });
            if (highways) for (e = 0; highways.length > e; e++) {
                var i = highways[e].properties.highway;
                "primary" !== i && "secondary" !== i && "secondary_link" !== i && "motorway" !== i && "motorway_link" !== i && "trunk" !== i && "trunk_link" !== i && this.$.map.createComponent({
                    kind: "enyo.my.highway",
                    highway: highways[e],
                    color: "",
                    outlineColor: ""
                }, {
                    addBefore: this.$.mapTrack
                });
            }
            if (highways) for (e = 0; highways.length > e; e++) i = highways[e].properties.highway, 
            ("primary" === i || "secondary" === i || "secondary_link" === i || "motorway" === i || "motorway_link" === i || "trunk" === i || "trunk_link" === i) && this.$.map.createComponent({
                kind: "enyo.my.highway_primary",
                highway: highways[e],
                color: "",
                outlineColor: ""
            }, {
                addBefore: this.$.mapTrack
            });
            this.$.map.createComponent({
                kind: "enyo.my.track",
                name: "mapTrack",
                outlineColor: "",
                color: ""
            }), this.$.map.createComponent({
                kind: "enyo.my.finish",
                name: "finishDraw"
            }), this.$.map.createComponent({
                kind: "enyo.my.arrow",
                name: "mapArrow",
                color: "green"
            });
        } else this.$.trackmenu.setContent("Display track & map"), this.$.mapHolder.applyStyle("border", "none");
        this.$.map.update(), POINTS[0] && NUMPOINTS && this.$.header.setContent("Turn " + (POINTS[0].id + 1) + " of " + NUMPOINTS);
    },
    startGeowatching: function() {
        this.job || (this.job = navigator.geolocation.watchPosition(enyo.bind(this, "updatePosition"), enyo.bind(this, "getPositionFailed"), {
            timeout: 3e4
        }), this.counter = 0, console.log("geowatching started"));
    },
    stopGeowatching: function() {
        navigator.geolocation.clearWatch(this.job), this.job = 0, console.log("geowatching stopped");
    },
    updatePosition: function(t) {
        LOCATION.lon = t.coords.longitude, LOCATION.lat = t.coords.latitude;
        var e;
        if (isNaN(t.coords.heading) ? (e = 0, DIRECTION.lat = 0, DIRECTION.lon = 0) : e = t.coords.heading / 180 * Math.PI, 
        this.counter++, e !== this.prevangle) {
            var i = new Point(.85 * Math.cos(e), .85 * Math.sin(e));
            (i.lat || i.lon) && (DIRECTION = calcDirection(DIRECTION, i), ANGLE_DIRECTION = Angle(DIRECTION, {
                lon: 0,
                lat: 1
            })), this.prevangle = e;
        }
        if (POINTS[0]) {
            this.prevdistance = POINTS[0].distance, POINTS[0].calcDistance(LOCATION), 100 > POINTS[0].distance, 
            POINTS[0].calcDirection(LOCATION, DIRECTION);
            var n = POINTS[0].dir;
            if (n >= 7 && 9 >= n ? WRONGDIRECTION++ : WRONGDIRECTION > 0 && WRONGDIRECTION--, 
            35 > POINTS[0].distance && POINTS[0].distance > this.prevdistance || 20 > POINTS[0].distance) return CURPOINT = POINTS[0].oid, 
            POINTS.splice(0, 1), WRONGDIRECTION = 0, SETTINGS.turnsound && this.$.turnSound.play(), 
            POINTS[0] ? (this.$.header.setContent("Turn " + (POINTS[0].id + 1) + " of " + NUMPOINTS), 
            void 0) : (this.$.compass.setSrc("assets/images/arrows/00.png"), this.$.distance.setContent("Finished"), 
            void 0);
            if (POINTS[1] ? (POINTS[1].calcDirection(POINTS[0].point, DIRECTION), this.$.turn.setSrc(POINTS[1].image)) : this.$.turn.setSrc("assets/images/turns/finish.png"), 
            this.$.compass.setSrc(POINTS[0].image2), this.$.distance.setContent(POINTS[0].distance + " m"), 
            this.counter > 4) {
                var o = POINTS[0].distance, r = -1;
                this.counter = 0;
                for (var a = 1; 10 > a && POINTS[a]; a++) {
                    if (POINTS[a].calcDirection(LOCATION, DIRECTION), POINTS[a].calcDistance(LOCATION), 
                    20 > POINTS[a].distance) {
                        r = a;
                        break;
                    }
                    1.04 > Math.abs(POINTS[a].direction) && o > POINTS[a].distance && WRONGDIRECTION > 20 && (o = POINTS[a].distance, 
                    r = a);
                }
                if (r > 0) {
                    if (console.log("Cut off point!"), CURPOINT = POINTS[r - 1].oid, POINTS.splice(0, r), 
                    WRONGDIRECTION = 0, SETTINGS.turnsound && this.$.turnSound.play(), POINTS[1] || this.$.turn.setSrc("assets/images/turns/finish.png"), 
                    !POINTS[0]) return this.$.compass.setSrc("assets/images/arrows/00.png"), this.$.distance.setContent("Finished"), 
                    void 0;
                    this.$.header.setContent("Turn " + (POINTS[0].id + 1) + " of " + NUMPOINTS);
                }
            }
        }
        (SETTINGS.displaymap || SETTINGS.displaytrack) && this.$.map.update();
    },
    getPositionFailed: function(t) {
        console.log("Get position failed");
        var e = 0;
        switch (this.$.compass.setSrc("assets/images/arrows/00.png"), this.$.turn.setSrc("assets/images/nogps.png"), 
        t.code) {
          case 1:
            e = "Permission denied\nPlease allow the program to use geolocation";
            break;

          case 2:
            e = "Impossible to get your geolocation. Is GPS enabled?";
            break;

          case 3:
            console.log("GPS timeout");
            break;

          default:
            e = "Unknown GPS error: " + t.code;
        }
        e && console.log(e);
    },
    menuSelected: function(t, e) {
        if (console.log(this.name), e.originator.content) switch (e.originator.content) {
          case "Start again":
            this.$.deleteAllConfirmation.show();
            break;

          case "Sound on turn":
          case "\u221a Sound on turn":
            SETTINGS.turnsound = !SETTINGS.turnsound, saveSettings(), SETTINGS.turnsound ? this.$.soundMenu.setContent("\u221a Sound on turn") : this.$.soundMenu.setContent("Sound on turn");
            break;

          case "Dark theme":
          case "Bright theme":
            SETTINGS.dark = !SETTINGS.dark, saveSettings(), this.start();
            break;

          case "Display track & map":
          case "\u221a Display track & map":
            SETTINGS.displaytrack = !SETTINGS.displaytrack, saveSettings(), this.start();
            break;

          case "Start from here":
            if (!POINTS || !POINTS[0]) break;
            for (var i = POINTS[0].distance, n = -1, o = 1; POINTS.length > o && POINTS[o]; o++) POINTS[o].calcDirection(LOCATION, DIRECTION), 
            POINTS[o].calcDistance(LOCATION), i > POINTS[o].distance && (i = POINTS[o].distance, 
            n = o);
            if (n > 0) {
                if (console.log("Cut off point!"), CURPOINT = POINTS[n - 1].oid, POINTS.splice(0, n), 
                POINTS[1] || this.$.turn.setSrc("assets/images/turns/finish.png"), !POINTS[0]) return this.$.compass.setSrc("assets/images/arrows/00.png"), 
                this.$.distance.setContent("Finished"), void 0;
                this.$.header.setContent("Turn " + (POINTS[0].id + 1) + " of " + NUMPOINTS);
            }
            break;

          case "About":
            this.popup(ABOUT_TEXT);
        }
    },
    popup: function(t) {
        this.$.popup.setContent(t), this.$.popup.show();
    },
    tback: function() {
        this.stopGeowatching(), this.screenLock && (this.screenLock.unlock(), this.screenLock = 0), 
        this.back();
    },
    setBack: function(t) {
        this.back = t;
    }
}), enyo.kind({
    name: "enyo.my.arrow",
    kind: "enyo.canvas.Shape",
    renderSelf: function(t) {
        var e = t.canvas.width, i = t.canvas.height, n = 10, o = 10;
        t.fillStyle = "", t.beginPath(), t.moveTo(e / 2, .7 * i - o / 2), t.lineTo(e / 2 - n / 2, .7 * i + o), 
        t.lineTo(e / 2, .7 * i + .7 * o), t.lineTo(e / 2 + n / 2, .7 * i + o), t.lineTo(e / 2, .7 * i - o / 2), 
        this.draw(t);
    },
    create: function() {
        this.inherited(arguments);
    },
    destroy: function() {
        this.inherited(arguments);
    }
}), enyo.kind({
    name: "enyo.my.track",
    kind: "enyo.canvas.Shape",
    renderSelf: function(t) {
        if (TRACK[0]) {
            if (TRACK[1]) {
                t.lineWidth = 3, t.fillStyle = "", t.beginPath();
                var e, i, n = LOCATION.lon, o = LOCATION.lat, r = 128 * t.canvas.width, a = 128 * t.canvas.height, l = r / a * MUL;
                e = (TRACK[0].point.lon - n) * r, i = (TRACK[0].point.lat - o) * a * l, t.moveTo(e, -i);
                var s;
                for (s = TRACK.length > CURPOINT ? CURPOINT : TRACK.length, t.strokeStyle = "rgb(0,250,0)", 
                t.beginPath(), p = 1; s >= p; p++) e = (TRACK[p].point.lon - n) * r, i = (TRACK[p].point.lat - o) * a * l, 
                t.lineTo(e, -i);
                t.stroke(), t.strokeStyle = "rgb(200,0,0)", t.fillStyle = "", t.beginPath();
                for (var p = s; TRACK.length > p; p++) e = (TRACK[p].point.lon - n) * r, i = (TRACK[p].point.lat - o) * a * l, 
                t.lineTo(e, -i);
                t.stroke();
            }
            e = (TRACK[0].point.lon - n) * r, i = (TRACK[0].point.lat - o) * a * l, t.strokeStyle = "rgb(96,96,96)", 
            t.lineWidth = 1, t.beginPath(), t.moveTo(0, 0), t.lineTo(e, -i), t.stroke();
        }
    },
    create: function() {
        this.inherited(arguments);
    },
    destroy: function() {
        this.inherited(arguments);
    }
}), enyo.kind({
    name: "enyo.my.building",
    kind: "enyo.canvas.Shape",
    renderSelf: function(t) {
        t.lineWidth = 2, t.beginPath();
        var e, i, n = LOCATION.lon, o = LOCATION.lat, r = t.canvas.width, a = t.canvas.height, l = r / a;
        t.fillStyle = "rgb(255,238,211)", t.lineWidth = 1, t.strokeStyle = "#d5b88c";
        var s = this.building;
        if ("Polygon" === s.geometry.type && !(Math.abs(s.geometry.coordinates[0][0][0] - n) > .005 || Math.abs(s.geometry.coordinates[0][0][1] - o) > .005)) {
            e = 128 * (s.geometry.coordinates[0][0][0] - n) * r, i = 128 * (s.geometry.coordinates[0][0][1] - o) * a * MUL * l, 
            t.beginPath(), t.moveTo(e, -i);
            for (var p = 1; s.geometry.coordinates[0].length > p; p++) e = 128 * (s.geometry.coordinates[0][p][0] - n) * r, 
            i = 128 * (s.geometry.coordinates[0][p][1] - o) * a * MUL * l, t.lineTo(e, -i);
            t.closePath(), t.fill(), t.stroke();
        }
    },
    create: function() {
        this.inherited(arguments);
    },
    destroy: function() {
        this.inherited(arguments);
    }
}), enyo.kind({
    name: "enyo.my.highway_primary",
    kind: "enyo.canvas.Shape",
    renderSelf: function(t) {
        function e() {
            t.beginPath(), i = 128 * (p.geometry.coordinates[0][0] - o) * a, n = 128 * (p.geometry.coordinates[0][1] - r) * l * MUL * s, 
            t.moveTo(i, -n);
            for (var e = 1; p.geometry.coordinates.length > e; e++) i = 128 * (p.geometry.coordinates[e][0] - o) * a, 
            n = 128 * (p.geometry.coordinates[e][1] - r) * l * MUL * s, t.lineTo(i, -n);
            t.stroke();
        }
        t.lineWidth = 2;
        var i, n, o = LOCATION.lon, r = LOCATION.lat, a = t.canvas.width, l = t.canvas.height, s = a / l;
        t.strokeStyle = "#909090", t.lineJoin = "round", t.lineCap = "round";
        var p = this.highway;
        "secondary" === p.properties.highway || "secondary_link" === p.properties.highway ? (t.lineWidth = 10, 
        t.strokeStyle = "#606060", e(), t.lineWidth = 8, t.strokeStyle = "#D3C32F", e()) : "primary" === p.properties.highway ? (t.lineWidth = 10, 
        t.strokeStyle = "#606060", e(), t.lineWidth = 8, t.strokeStyle = "#C09090", e()) : "motorway" === p.properties.highway || "motorway_link" === p.properties.highway ? (t.lineWidth = 10, 
        t.strokeStyle = "#606060", e(), t.lineWidth = 8, t.strokeStyle = "#90C090", e()) : ("trunk" === p.properties.highway || "trunk_link" === p.properties.highway) && (t.lineWidth = 10, 
        t.strokeStyle = "#9BC3AE", e(), t.lineWidth = 8, t.strokeStyle = "#9BC3AE", e());
    },
    create: function() {
        this.inherited(arguments);
    },
    destroy: function() {
        this.inherited(arguments);
    }
}), enyo.kind({
    name: "enyo.my.highway",
    kind: "enyo.canvas.Shape",
    renderSelf: function(t) {
        function e() {
            t.beginPath(), i = 128 * (p.geometry.coordinates[0][0] - o) * a, n = 128 * (p.geometry.coordinates[0][1] - r) * l * MUL * s, 
            t.moveTo(i, -n);
            for (var e = 1; p.geometry.coordinates.length > e; e++) i = 128 * (p.geometry.coordinates[e][0] - o) * a, 
            n = 128 * (p.geometry.coordinates[e][1] - r) * l * MUL * s, t.lineTo(i, -n);
            t.stroke();
        }
        t.lineWidth = 2;
        var i, n, o = LOCATION.lon, r = LOCATION.lat, a = t.canvas.width, l = t.canvas.height, s = a / l;
        t.strokeStyle = "#909090", t.lineJoin = "round", t.lineCap = "round";
        var p = this.highway;
        "path" === p.properties.highway ? (t.lineWidth = 2, t.strokeStyle = "#cab19b") : "footway" === p.properties.highway ? (t.lineWidth = 2, 
        t.strokeStyle = "#cecece") : "track" === p.properties.highway ? (t.lineWidth = 3, 
        t.strokeStyle = "#c4a78b") : (t.lineWidth = 5, t.strokeStyle = "#808080"), e();
    },
    create: function() {
        this.inherited(arguments);
    },
    destroy: function() {
        this.inherited(arguments);
    }
}), enyo.kind({
    name: "enyo.my.water",
    kind: "enyo.canvas.Shape",
    renderSelf: function(t) {
        t.lineWidth = 2, t.beginPath();
        var e, i, n = LOCATION.lon, o = LOCATION.lat, r = t.canvas.width, a = t.canvas.height, l = r / a;
        t.fillStyle = "#bee1f6", t.strokeStyle = "#bee1f6";
        var s = this.water;
        if (t.beginPath(), "Polygon" === s.geometry.type) {
            t.lineWidth = 1, e = 128 * (s.geometry.coordinates[0][0][0] - n) * r, i = 128 * (s.geometry.coordinates[0][0][1] - o) * a * MUL * l, 
            t.moveTo(e, -i);
            for (var p = 1; s.geometry.coordinates[0].length > p; p++) e = 128 * (s.geometry.coordinates[0][p][0] - n) * r, 
            i = 128 * (s.geometry.coordinates[0][p][1] - o) * a * MUL * l, t.lineTo(e, -i);
            t.closePath(), t.fill(), t.stroke();
        } else {
            for (t.lineWidth = 8, e = 128 * (s.geometry.coordinates[0][0] - n) * r, i = 128 * (s.geometry.coordinates[0][1] - o) * a * MUL * l, 
            t.moveTo(e, -i), p = 1; s.geometry.coordinates.length > p; p++) e = 128 * (s.geometry.coordinates[p][0] - n) * r, 
            i = 128 * (s.geometry.coordinates[p][1] - o) * a * MUL * l, t.lineTo(e, -i);
            t.stroke();
        }
    },
    create: function() {
        this.inherited(arguments);
    },
    destroy: function() {
        this.inherited(arguments);
    }
}), enyo.kind({
    name: "enyo.my.prepare",
    kind: "enyo.canvas.Shape",
    renderSelf: function(t) {
        t.save();
        var e = t.canvas.width, i = t.canvas.height;
        t.translate(e / 2, .7 * i), t.rotate(ANGLE_DIRECTION);
    },
    create: function() {
        this.inherited(arguments);
    },
    destroy: function() {
        this.inherited(arguments);
    }
}), enyo.kind({
    name: "enyo.my.finish",
    kind: "enyo.canvas.Shape",
    renderSelf: function(t) {
        t.restore();
    },
    create: function() {
        this.inherited(arguments);
    },
    destroy: function() {
        this.inherited(arguments);
    }
});

// source/files.js
enyo.kind({
    name: "FilesScene",
    kind: "FittableRows",
    classes: "enyo-fit",
    components: [ {
        kind: "onyx.Toolbar",
        components: [ {
            components: [ {
                kind: "FittableColumns",
                classes: "enyo-fit",
                style: "padding:6px",
                components: [ {
                    fit: !0,
                    content: "Open track",
                    style: "text-align:center"
                }, {
                    kind: "onyx.MenuDecorator",
                    onSelect: "menuSelected",
                    components: [ {
                        kind: "onyx.IconButton",
                        src: "assets/images/menu.png"
                    }, {
                        kind: "onyx.Menu",
                        floating: !0,
                        components: [ {
                            content: "Refresh"
                        }, {
                            content: "Download map",
                            name: "mapmenu"
                        }, {
                            classes: "onyx-menu-divider"
                        }, {
                            content: "About"
                        } ]
                    } ]
                } ]
            } ]
        } ]
    }, {
        name: "popup",
        kind: "onyx.Popup",
        centered: !0,
        floating: !0,
        modal: !0,
        allowHtml: !0,
        style: "padding: 10px;"
    }, {
        name: "mapdownloadingpopup",
        kind: "onyx.Popup",
        centered: !0,
        floating: !0,
        modal: !0,
        allowHtml: !0,
        style: "padding: 10px;width:89%",
        components: [ {
            content: "Map downloading & processing",
            classes: "popup"
        }, {
            kind: "onyx.ProgressButton",
            name: "mapprogress",
            showStripes: !1,
            progress: 0,
            onCancel: "cancelMapDownloading"
        } ]
    }, {
        kind: "List",
        name: "list",
        fit: !0,
        classes: "bk",
        noSelect: !0,
        onSetupItem: "setupItem",
        fixedHeight: !0,
        components: [ {
            name: "item",
            style: "padding: 10px; max-height:10%",
            classes: "enyo-border-box list-item",
            ontap: "itemTap",
            components: [ {
                layoutKind: "FittableColumnsLayout",
                components: [ {
                    name: "filename",
                    classes: "filename"
                }, {
                    name: "filesize",
                    classes: "filesize"
                } ]
            } ]
        } ]
    }, {
        name: "openingSpinner",
        kind: "onyx.Popup",
        classes: "popup",
        centered: !0,
        modal: !0,
        floating: !0,
        autoDismiss: !1,
        components: [ {
            content: "Please wait, loading..."
        }, {
            style: "border-radius:5px; padding:15px",
            components: [ {
                kind: "onyx.Spinner"
            } ]
        } ]
    } ],
    create: function() {
        this.inherited(arguments);
    },
    rendered: function() {
        this.inherited(arguments);
    },
    start: function() {
        if (this.files = [], console.log("files scene started"), SETTINGS.downloadmap ? this.$.mapmenu.setContent("\u221a Download map") : this.$.mapmenu.setContent("Download map"), 
        navigator.getDeviceStorage) {
            console.log("Device storage is accessible");
            var t = navigator.getDeviceStorage("sdcard"), e = t.enumerate(), n = this;
            e.onsuccess = function(t) {
                console.log("Successfully get file");
                var i = t.target.result;
                return t.target.result ? (i && i.name.match(/.gpx/im) && (n.files.push(i), console.log("File found: " + i.name + " => " + i.size + " => " + toHuman(i.size))), 
                e.continue(), void 0) : (console.log("No more files. Count=" + n.files.length), 
                n.$.list.setCount(n.files.length), n.$.list.refresh(), 1 > n.files.length && n.popup("No any GPX files found<br>You need to have existed tracks in .gpx format for using this program"), 
                void 0);
            }, e.onerror = function() {
                console.warn("No files found: " + this.error), n.popup("No any GPX files found<br>You need to have existed tracks in .gpx format for using this program");
            };
        } else {
            for (console.log("Device storage is not accessible"), this.popup("Cannot get file list"), 
            this.files = [], i = 0; 10 > i; i++) {
                var o = {};
                o.name = "file" + i, o.size = 100 * i + 10, this.files.push(o);
            }
            this.$.list.setCount(this.files.length), this.$.list.refresh();
        }
    },
    setupItem: function(t, e) {
        var i = e.index, n = this.files[i];
        this.$.filename.setContent(n.name), this.$.filesize.setContent(toHuman(n.size));
    },
    itemTap: function(t, e) {
        var i = this;
        if (navigator.getDeviceStorage) {
            this.$.openingSpinner.show();
            var n = navigator.getDeviceStorage("sdcard"), o = n.get(this.files[e.index].name);
            o.onsuccess = function() {
                var t = this.result.name;
                console.log('File "' + t + '" successfully retrieved from the sdcard storage area');
                var e = new FileReader();
                e.readAsText(this.result), e.onload = function() {
                    var t = this.result;
                    parseGPX(t) ? (i.$.openingSpinner.hide(), SETTINGS.downloadmap ? (i.$.mapprogress.setProgress(0), 
                    i.$.mapdownloadingpopup.show(), getMap(TRACK, i.updateMapDownloadingProgress.bind(i))) : i.back()) : (i.$.openingSpinner.hide(), 
                    i.popup("Cannot parse file"));
                }, e.onerror = function() {
                    i.$.openingSpinner.hide(), console.log("Cannot read file"), this.popup("Cannot read file<br>" + this.error.name);
                };
            }, o.onerror = function() {
                console.warn("Unable to get the file: " + this.error), i.$.openingSpinner.hide(), 
                i.popup("Unable to open file <br>" + this.error.name);
            };
        } else enyo.platform.firefoxos || (parseGPX(filedata), SETTINGS.downloadmap ? (this.$.mapprogress.setProgress(0), 
        this.$.mapdownloadingpopup.show(), getMap(TRACK, this.updateMapDownloadingProgress.bind(this))) : this.back());
    },
    updateMapDownloadingProgress: function(t, e) {
        var i = 100 * (t / e);
        console.log("Progress:" + i), this.$.mapprogress.setProgress(i), t >= e && (this.$.mapdownloadingpopup.hide(), 
        doneMapDownloading(), this.back());
    },
    menuSelected: function(t, e) {
        if (e.originator.content) switch (e.originator.content) {
          case "Refresh":
            this.start();
            break;

          case "Download map":
          case "\u221a Download map":
            SETTINGS.downloadmap = !SETTINGS.downloadmap, SETTINGS.downloadmap ? (this.$.mapmenu.setContent("\u221a Download map"), 
            this.popup("Warning! Map downloading and processing cat take a lot of time. Please be patient or disable this feature")) : this.$.mapmenu.setContent("Download map"), 
            saveSettings();
            break;

          case "About":
            this.popup(ABOUT_TEXT);
        }
    },
    popup: function(t) {
        this.$.popup.setContent(t), this.$.popup.show();
    },
    setBack: function(t) {
        this.back = t;
    }
});

// source/mainmap.js
function drawAll() {
    NEED_REFRESH || (NEED_REFRESH = 1, setTimeout(redraw, 0));
}

function redraw() {
    NEED_REFRESH && (clear(), preDraw(CURSOR), drawGrasses(), drawWoods(), drawWaters(), 
    drawBuildings(), drawHighways(), drawRailways(), drawHousenumbers(), endDraw(), 
    NEED_REFRESH = 0);
}

function mousemove(t) {
    if (MOUSE_DOWN) {
        var e = t.clientX - DELTA.lon, i = t.clientY - DELTA.lat;
        DELTA.lon = t.clientX, DELTA.lat = t.clientY, CURSOR.lon += e, CURSOR.lat += i, 
        drawAll();
    }
}

function mousedown(t) {
    0 === t.button && (MOUSE_DOWN = 1, DELTA.lon = t.clientX, DELTA.lat = t.clientY);
}

function mouseup(t) {
    0 === t.button && (MOUSE_DOWN = 0);
}

function mousewheel(t) {
    t.detail > 0 ? ZOOM -= 100 : ZOOM += 100, drawAll();
}

function done(t) {
    getBuildings(t), getHighways(t), getRailways(t), getWoods(t), getWaters(t);
}

function main() {
    initCanvas(document.getElementById("screen")), console.log(data_json.length), document.getElementById("screen").addEventListener("mousemove", mousemove, !0), 
    document.getElementById("screen").addEventListener("mousedown", mousedown, !0), 
    document.getElementById("screen").addEventListener("mouseup", mouseup, !0), document.getElementById("screen").addEventListener("DOMMouseScroll", mousewheel, !0), 
    loadSettings(done);
}

var POSITION = new Point(56.010324, 37.8254), C, MOUSE_DOWN = 0, CURSOR = new Point(256, 256), DELTA = new Point(0, 0), ZOOM = 1e4, NEED_REFRESH = 0, ANGLE = 0;

// source/displaymap.js
function initCanvas(t) {
    _c = t.getContext("2d");
}

function preDraw(t) {
    cur = t, _c.save(), _c.translate(cur.lon, cur.lat), _c.rotate(ANGLE), _c.rect(-5, -5, 10, 10), 
    _c.stroke();
}

function endDraw() {
    _c.restore();
}

function setBuildings(t) {
    buildings = t;
}

function getBuildings(t) {
    if (buildings = [], t || t.features) {
        for (var e = 0; t.features.length > e; e++) {
            var i = t.features[e];
            if (i.properties && i.properties.building) {
                for (var n = 256, o = 256, r = -256, a = -256, s = 0; i.geometry.coordinates[0].length > s; s++) {
                    var l = i.geometry.coordinates[0][s];
                    o > l[0] && (o = l[0]), n > l[1] && (n = l[1]), l[0] > a && (a = l[0]), l[1] > r && (r = l[1]);
                }
                i.geometry.textposition = [], i.geometry.textposition[0] = (o + a) / 2 - 1e-4, i.geometry.textposition[1] = (n + r) / 2, 
                buildings.push(i);
            }
        }
        return console.log("found " + buildings.length + " buildings"), buildings;
    }
}

function getWoods(t) {
    if (woods = [], t || t.features) {
        for (var e = 0; t.features.length > e; e++) {
            var i = t.features[e];
            i.properties && i.properties.natural && ("wood" === i.properties.natural || "scrub" === i.properties.natural) && woods.push(i);
        }
        console.log("found " + woods.length + " wood");
    }
}

function getWaters(t) {
    if (waters = [], t || t.features) {
        for (var e = 0; t.features.length > e; e++) {
            var i = t.features[e];
            (i.properties && i.properties.waterway || i.properties.natural && "water" === i.properties.natural) && waters.push(i);
        }
        console.log("found " + waters.length + " water");
    }
}

function getGrasses(t) {
    if (t || t.features) {
        for (var e = 0; t.features.length > e; e++) {
            var i = t.features[e];
            i.properties && (i.properties.natural && "grassland" === i.properties.natural || i.properties.landuse && "meadow" === i.properties.landuse) && grasses.push(i);
        }
        console.log("found " + waters.length + " grasses");
    }
}

function getHighways(t) {
    if (highways = [], t || t.features) {
        for (var e = 0; t.features.length > e; e++) {
            var i = t.features[e];
            i.properties && i.properties.highway && ("path" === i.properties.highway || "footway" === i.properties.highway || "track" === i.properties.highway || "residential" === i.properties.highway || "service" === i.properties.highway || "tertiary" === i.properties.highway || "secondary" === i.properties.highway || "trunk" === i.properties.highway || "trunk_link" === i.properties.highway || "primary" === i.properties.highway || "secondary_link" === i.properties.highway) && highways.push(i);
        }
        console.log("found " + highways.length + " highways");
    }
}

function getRailways(t) {
    if (railways = [], t || t.features) {
        for (var e = 0; t.features.length > e; e++) {
            var i = t.features[e];
            i.properties && i.properties.railway && railways.push(i);
        }
        console.log("found " + railways.length + " railways");
    }
}

function drawBuildings() {
    _c.fillStyle = "#ffeed3", _c.lineWidth = 1, _c.strokeStyle = "#d5b88c";
    for (var t = 0; buildings.length > t; t++) {
        var e = buildings[t];
        if ("Polygon" === e.geometry.type) {
            _c.beginPath();
            var i = e.geometry.coordinates[0][0][0] - POSITION.lon, n = e.geometry.coordinates[0][0][1] - POSITION.lat;
            i *= 25 * ZOOM, n *= -50 * ZOOM, _c.moveTo(i, n);
            for (var o = 1; e.geometry.coordinates[0].length > o; o++) i = e.geometry.coordinates[0][o][0] - POSITION.lon, 
            n = e.geometry.coordinates[0][o][1] - POSITION.lat, i *= 25 * ZOOM, n *= -50 * ZOOM, 
            _c.lineTo(i, n);
            _c.closePath(), _c.fill(), _c.stroke();
        }
    }
}

function drawHousenumbers() {
    _c.font = "11px Arial", _c.fillStyle = "black", _c.rotate(-ANGLE);
    for (var t = 0; buildings.length > t; t++) {
        var e = buildings[t];
        if ("Polygon" === e.geometry.type && e.properties.hasOwnProperty("addr:housenumber")) {
            var i = e.geometry.textposition[0] - POSITION.lon, n = e.geometry.textposition[1] - POSITION.lat;
            i *= 25 * ZOOM, n *= -50 * ZOOM, _c.save(), _c.translate(-i, -n), _c.rotate(ANGLE), 
            _c.translate(i, n), _c.rotate(-ANGLE), _c.fillText(e.properties["addr:housenumber"], i, n), 
            _c.restore();
        }
    }
}

function drawHighways() {
    _c.strokeStyle = "#808080", _c.lineJoin = "round", _c.lineCap = "round";
    for (var t = 0; highways.length > t; t++) {
        var e = highways[t];
        "trunk" === e.properties.highway && (_c.lineWidth = 30 * ZOOM / 1e4 + 4, _c.strokeStyle = "#9BC3AE"), 
        "secondary" === e.properties.highway || "secondary_link" === e.properties.highway ? (_c.lineWidth = 30 * ZOOM / 1e4 + 2, 
        _c.strokeStyle = "#707070") : "path" === e.properties.highway ? (_c.lineWidth = 2, 
        _c.strokeStyle = "#cab19b") : "footway" === e.properties.highway ? (_c.lineWidth = 2, 
        _c.strokeStyle = "#cecece") : "track" === e.properties.highway ? (_c.lineWidth = 3, 
        _c.strokeStyle = "#c4a78b") : (_c.lineWidth = 10 * ZOOM / 1e4 + 1, _c.strokeStyle = "#808080"), 
        _c.beginPath();
        var i = e.geometry.coordinates[0][0] - POSITION.lon, n = e.geometry.coordinates[0][1] - POSITION.lat;
        i *= 25 * ZOOM, n *= -50 * ZOOM, _c.moveTo(i, n);
        for (var o = 1; e.geometry.coordinates.length > o; o++) i = e.geometry.coordinates[o][0] - POSITION.lon, 
        n = e.geometry.coordinates[o][1] - POSITION.lat, i *= 25 * ZOOM, n *= -50 * ZOOM, 
        _c.lineTo(i, n);
        _c.stroke();
    }
}

function drawRailways() {
    _c.lineWidth = 2 * ZOOM / 1e4, _c.strokeStyle = "red", _c.lineJoin = "round", _c.lineCap = "round";
    for (var t = 0; railways.length > t; t++) {
        var e = railways[t];
        _c.beginPath();
        var i = e.geometry.coordinates[0][0] - POSITION.lon, n = e.geometry.coordinates[0][1] - POSITION.lat;
        i *= 25 * ZOOM, n *= -50 * ZOOM, _c.moveTo(i, n);
        for (var o = 1; e.geometry.coordinates.length > o; o++) i = e.geometry.coordinates[o][0] - POSITION.lon, 
        n = e.geometry.coordinates[o][1] - POSITION.lat, i *= 25 * ZOOM, n *= -50 * ZOOM, 
        _c.lineTo(i, n);
        _c.stroke();
    }
}

function drawWoods() {
    _c.fillStyle = "#d0e4b7", _c.lineWidth = 1, _c.strokeStyle = "#d0e4b7";
    for (var t = 0; woods.length > t; t++) {
        var e = woods[t];
        _c.beginPath();
        var i = e.geometry.coordinates[0][0][0] - POSITION.lon, n = e.geometry.coordinates[0][0][1] - POSITION.lat;
        i *= 25 * ZOOM, n *= -50 * ZOOM, _c.moveTo(i, n);
        for (var o = 1; e.geometry.coordinates[0].length > o; o++) i = e.geometry.coordinates[0][o][0] - POSITION.lon, 
        n = e.geometry.coordinates[0][o][1] - POSITION.lat, i *= 25 * ZOOM, n *= -50 * ZOOM, 
        _c.lineTo(i, n);
        _c.closePath(), _c.fill(), _c.stroke();
    }
}

function drawGrasses() {
    _c.fillStyle = "#e4f0d2", _c.lineWidth = 1, _c.strokeStyle = "#e4f0d2";
    for (var t = 0; grasses.length > t; t++) {
        var e = grasses[t];
        _c.beginPath();
        var i = e.geometry.coordinates[0][0][0] - POSITION.lon, n = e.geometry.coordinates[0][0][1] - POSITION.lat;
        i *= 25 * ZOOM, n *= -50 * ZOOM, _c.moveTo(i, n);
        for (var o = 1; e.geometry.coordinates[0].length > o; o++) i = e.geometry.coordinates[0][o][0] - POSITION.lon, 
        n = e.geometry.coordinates[0][o][1] - POSITION.lat, i *= 25 * ZOOM, n *= -50 * ZOOM, 
        _c.lineTo(i, n);
        _c.closePath(), _c.fill(), _c.stroke();
    }
}

function drawWaters() {
    radius = 10, _c.fillStyle = "#bee1f6", _c.strokeStyle = "#bee1f6";
    for (var t = 0; waters.length > t; t++) {
        var e = waters[t];
        if (_c.beginPath(), "Polygon" == e.geometry.type) {
            _c.lineWidth = 1;
            var i = e.geometry.coordinates[0][0][0] - POSITION.lon, n = e.geometry.coordinates[0][0][1] - POSITION.lat;
            i *= 25 * ZOOM, n *= -50 * ZOOM, _c.moveTo(i, n);
            for (var o = 1; e.geometry.coordinates[0].length > o; o++) i = e.geometry.coordinates[0][o][0] - POSITION.lon, 
            n = e.geometry.coordinates[0][o][1] - POSITION.lat, i *= 25 * ZOOM, n *= -50 * ZOOM, 
            _c.lineTo(i, n);
            _c.closePath(), _c.fill(), _c.stroke();
        } else {
            _c.lineWidth = 8;
            var i = e.geometry.coordinates[0][0] - POSITION.lon, n = e.geometry.coordinates[0][1] - POSITION.lat;
            i *= 25 * ZOOM, n *= -50 * ZOOM, _c.moveTo(i, n);
            for (var o = 1; e.geometry.coordinates.length > o; o++) i = e.geometry.coordinates[o][0] - POSITION.lon, 
            n = e.geometry.coordinates[o][1] - POSITION.lat, i *= 25 * ZOOM, n *= -50 * ZOOM, 
            _c.lineTo(i, n);
            _c.stroke();
        }
    }
}

function clear() {
    _c.width = _c.width, _c.clearRect(0, 0, 512, 512);
}

var _c, buildings = [], highways = [], railways = [], woods = [], waters = [], grasses = [], cur;

// source/jquery.js
(function(t, e) {
    function i(t) {
        var e = t.length, i = he.type(t);
        return he.isWindow(t) ? !1 : 1 === t.nodeType && e ? !0 : "array" === i || "function" !== i && (0 === e || "number" == typeof e && e > 0 && e - 1 in t);
    }
    function n(t) {
        var e = Ce[t] = {};
        return he.each(t.match(ce) || [], function(t, i) {
            e[i] = !0;
        }), e;
    }
    function o(t, i, n, o) {
        if (he.acceptData(t)) {
            var r, a, s = he.expando, l = t.nodeType, p = l ? he.cache : t, h = l ? t[s] : t[s] && s;
            if (h && p[h] && (o || p[h].data) || n !== e || "string" != typeof i) return h || (h = l ? t[s] = ee.pop() || he.guid++ : s), 
            p[h] || (p[h] = l ? {} : {
                toJSON: he.noop
            }), ("object" == typeof i || "function" == typeof i) && (o ? p[h] = he.extend(p[h], i) : p[h].data = he.extend(p[h].data, i)), 
            a = p[h], o || (a.data || (a.data = {}), a = a.data), n !== e && (a[he.camelCase(i)] = n), 
            "string" == typeof i ? (r = a[i], null == r && (r = a[he.camelCase(i)])) : r = a, 
            r;
        }
    }
    function r(t, e, i) {
        if (he.acceptData(t)) {
            var n, o, r = t.nodeType, a = r ? he.cache : t, l = r ? t[he.expando] : he.expando;
            if (a[l]) {
                if (e && (n = i ? a[l] : a[l].data)) {
                    he.isArray(e) ? e = e.concat(he.map(e, he.camelCase)) : e in n ? e = [ e ] : (e = he.camelCase(e), 
                    e = e in n ? [ e ] : e.split(" ")), o = e.length;
                    for (;o--; ) delete n[e[o]];
                    if (i ? !s(n) : !he.isEmptyObject(n)) return;
                }
                (i || (delete a[l].data, s(a[l]))) && (r ? he.cleanData([ t ], !0) : he.support.deleteExpando || a != a.window ? delete a[l] : a[l] = null);
            }
        }
    }
    function a(t, i, n) {
        if (n === e && 1 === t.nodeType) {
            var o = "data-" + i.replace(Pe, "-$1").toLowerCase();
            if (n = t.getAttribute(o), "string" == typeof n) {
                try {
                    n = "true" === n ? !0 : "false" === n ? !1 : "null" === n ? null : +n + "" === n ? +n : Se.test(n) ? he.parseJSON(n) : n;
                } catch (r) {}
                he.data(t, i, n);
            } else n = e;
        }
        return n;
    }
    function s(t) {
        var e;
        for (e in t) if (("data" !== e || !he.isEmptyObject(t[e])) && "toJSON" !== e) return !1;
        return !0;
    }
    function l() {
        return !0;
    }
    function p() {
        return !1;
    }
    function h() {
        try {
            return X.activeElement;
        } catch (t) {}
    }
    function m(t, e) {
        do t = t[e]; while (t && 1 !== t.nodeType);
        return t;
    }
    function c(t, e, i) {
        if (he.isFunction(e)) return he.grep(t, function(t, n) {
            return !!e.call(t, n, t) !== i;
        });
        if (e.nodeType) return he.grep(t, function(t) {
            return t === e !== i;
        });
        if ("string" == typeof e) {
            if (ze.test(e)) return he.filter(e, t, i);
            e = he.filter(e, t);
        }
        return he.grep(t, function(t) {
            return he.inArray(t, e) >= 0 !== i;
        });
    }
    function d(t) {
        var e = qe.split("|"), i = t.createDocumentFragment();
        if (i.createElement) for (;e.length; ) i.createElement(e.pop());
        return i;
    }
    function u(t, e) {
        return he.nodeName(t, "table") && he.nodeName(1 === e.nodeType ? e : e.firstChild, "tr") ? t.getElementsByTagName("tbody")[0] || t.appendChild(t.ownerDocument.createElement("tbody")) : t;
    }
    function f(t) {
        return t.type = (null !== he.find.attr(t, "type")) + "/" + t.type, t;
    }
    function k(t) {
        var e = oi.exec(t.type);
        return e ? t.type = e[1] : t.removeAttribute("type"), t;
    }
    function g(t, e) {
        for (var i, n = 0; null != (i = t[n]); n++) he._data(i, "globalEval", !e || he._data(e[n], "globalEval"));
    }
    function T(t, e) {
        if (1 === e.nodeType && he.hasData(t)) {
            var i, n, o, r = he._data(t), a = he._data(e, r), s = r.events;
            if (s) {
                delete a.handle, a.events = {};
                for (i in s) for (n = 0, o = s[i].length; o > n; n++) he.event.add(e, i, s[i][n]);
            }
            a.data && (a.data = he.extend({}, a.data));
        }
    }
    function y(t, e) {
        var i, n, o;
        if (1 === e.nodeType) {
            if (i = e.nodeName.toLowerCase(), !he.support.noCloneEvent && e[he.expando]) {
                o = he._data(e);
                for (n in o.events) he.removeEvent(e, n, o.handle);
                e.removeAttribute(he.expando);
            }
            "script" === i && e.text !== t.text ? (f(e).text = t.text, k(e)) : "object" === i ? (e.parentNode && (e.outerHTML = t.outerHTML), 
            he.support.html5Clone && t.innerHTML && !he.trim(e.innerHTML) && (e.innerHTML = t.innerHTML)) : "input" === i && ei.test(t.type) ? (e.defaultChecked = e.checked = t.checked, 
            e.value !== t.value && (e.value = t.value)) : "option" === i ? e.defaultSelected = e.selected = t.defaultSelected : ("input" === i || "textarea" === i) && (e.defaultValue = t.defaultValue);
        }
    }
    function v(t, i) {
        var n, o, r = 0, a = typeof t.getElementsByTagName !== U ? t.getElementsByTagName(i || "*") : typeof t.querySelectorAll !== U ? t.querySelectorAll(i || "*") : e;
        if (!a) for (a = [], n = t.childNodes || t; null != (o = n[r]); r++) !i || he.nodeName(o, i) ? a.push(o) : he.merge(a, v(o, i));
        return i === e || i && he.nodeName(t, i) ? he.merge([ t ], a) : a;
    }
    function Z(t) {
        ei.test(t.type) && (t.defaultChecked = t.checked);
    }
    function w(t, e) {
        if (e in t) return e;
        for (var i = e.charAt(0).toUpperCase() + e.slice(1), n = e, o = xi.length; o--; ) if (e = xi[o] + i, 
        e in t) return e;
        return n;
    }
    function b(t, e) {
        return t = e || t, "none" === he.css(t, "display") || !he.contains(t.ownerDocument, t);
    }
    function x(t, e) {
        for (var i, n, o, r = [], a = 0, s = t.length; s > a; a++) n = t[a], n.style && (r[a] = he._data(n, "olddisplay"), 
        i = n.style.display, e ? (r[a] || "none" !== i || (n.style.display = ""), "" === n.style.display && b(n) && (r[a] = he._data(n, "olddisplay", N(n.nodeName)))) : r[a] || (o = b(n), 
        (i && "none" !== i || !o) && he._data(n, "olddisplay", o ? i : he.css(n, "display"))));
        for (a = 0; s > a; a++) n = t[a], n.style && (e && "none" !== n.style.display && "" !== n.style.display || (n.style.display = e ? r[a] || "" : "none"));
        return t;
    }
    function C(t, e, i) {
        var n = gi.exec(e);
        return n ? Math.max(0, n[1] - (i || 0)) + (n[2] || "px") : e;
    }
    function S(t, e, i, n, o) {
        for (var r = i === (n ? "border" : "content") ? 4 : "width" === e ? 1 : 0, a = 0; 4 > r; r += 2) "margin" === i && (a += he.css(t, i + bi[r], !0, o)), 
        n ? ("content" === i && (a -= he.css(t, "padding" + bi[r], !0, o)), "margin" !== i && (a -= he.css(t, "border" + bi[r] + "Width", !0, o))) : (a += he.css(t, "padding" + bi[r], !0, o), 
        "padding" !== i && (a += he.css(t, "border" + bi[r] + "Width", !0, o)));
        return a;
    }
    function P(t, e, i) {
        var n = !0, o = "width" === e ? t.offsetWidth : t.offsetHeight, r = hi(t), a = he.support.boxSizing && "border-box" === he.css(t, "boxSizing", !1, r);
        if (0 >= o || null == o) {
            if (o = mi(t, e, r), (0 > o || null == o) && (o = t.style[e]), Ti.test(o)) return o;
            n = a && (he.support.boxSizingReliable || o === t.style[e]), o = parseFloat(o) || 0;
        }
        return o + S(t, e, i || (a ? "border" : "content"), n, r) + "px";
    }
    function N(t) {
        var e = X, i = vi[t];
        return i || (i = I(t, e), "none" !== i && i || (pi = (pi || he("<iframe frameborder='0' width='0' height='0'/>").css("cssText", "display:block !important")).appendTo(e.documentElement), 
        e = (pi[0].contentWindow || pi[0].contentDocument).document, e.write("<!doctype html><html><body>"), 
        e.close(), i = I(t, e), pi.detach()), vi[t] = i), i;
    }
    function I(t, e) {
        var i = he(e.createElement(t)).appendTo(e.body), n = he.css(i[0], "display");
        return i.remove(), n;
    }
    function R(t, e, i, n) {
        var o;
        if (he.isArray(e)) he.each(e, function(e, o) {
            i || Si.test(t) ? n(t, o) : R(t + "[" + ("object" == typeof o ? e : "") + "]", o, i, n);
        }); else if (i || "object" !== he.type(e)) n(t, e); else for (o in e) R(t + "[" + o + "]", e[o], i, n);
    }
    function O(t) {
        return function(e, i) {
            "string" != typeof e && (i = e, e = "*");
            var n, o = 0, r = e.toLowerCase().match(ce) || [];
            if (he.isFunction(i)) for (;n = r[o++]; ) "+" === n[0] ? (n = n.slice(1) || "*", 
            (t[n] = t[n] || []).unshift(i)) : (t[n] = t[n] || []).push(i);
        };
    }
    function M(t, i, n, o) {
        function r(l) {
            var p;
            return a[l] = !0, he.each(t[l] || [], function(t, l) {
                var h = l(i, n, o);
                return "string" != typeof h || s || a[h] ? s ? !(p = h) : e : (i.dataTypes.unshift(h), 
                r(h), !1);
            }), p;
        }
        var a = {}, s = t === Wi;
        return r(i.dataTypes[0]) || !a["*"] && r("*");
    }
    function $(t, i) {
        var n, o, r = he.ajaxSettings.flatOptions || {};
        for (o in i) i[o] !== e && ((r[o] ? t : n || (n = {}))[o] = i[o]);
        return n && he.extend(!0, t, n), t;
    }
    function D(t, i, n) {
        for (var o, r, a, s, l = t.contents, p = t.dataTypes; "*" === p[0]; ) p.shift(), 
        r === e && (r = t.mimeType || i.getResponseHeader("Content-Type"));
        if (r) for (s in l) if (l[s] && l[s].test(r)) {
            p.unshift(s);
            break;
        }
        if (p[0] in n) a = p[0]; else {
            for (s in n) {
                if (!p[0] || t.converters[s + " " + p[0]]) {
                    a = s;
                    break;
                }
                o || (o = s);
            }
            a = a || o;
        }
        return a ? (a !== p[0] && p.unshift(a), n[a]) : e;
    }
    function A(t, e, i, n) {
        var o, r, a, s, l, p = {}, h = t.dataTypes.slice();
        if (h[1]) for (a in t.converters) p[a.toLowerCase()] = t.converters[a];
        for (r = h.shift(); r; ) if (t.responseFields[r] && (i[t.responseFields[r]] = e), 
        !l && n && t.dataFilter && (e = t.dataFilter(e, t.dataType)), l = r, r = h.shift()) if ("*" === r) r = l; else if ("*" !== l && l !== r) {
            if (a = p[l + " " + r] || p["* " + r], !a) for (o in p) if (s = o.split(" "), s[1] === r && (a = p[l + " " + s[0]] || p["* " + s[0]])) {
                a === !0 ? a = p[o] : p[o] !== !0 && (r = s[0], h.unshift(s[1]));
                break;
            }
            if (a !== !0) if (a && t["throws"]) e = a(e); else try {
                e = a(e);
            } catch (m) {
                return {
                    state: "parsererror",
                    error: a ? m : "No conversion from " + l + " to " + r
                };
            }
        }
        return {
            state: "success",
            data: e
        };
    }
    function H() {
        try {
            return new t.XMLHttpRequest();
        } catch (e) {}
    }
    function E() {
        try {
            return new t.ActiveXObject("Microsoft.XMLHTTP");
        } catch (e) {}
    }
    function B() {
        return setTimeout(function() {
            Ji = e;
        }), Ji = he.now();
    }
    function L(t, e, i) {
        for (var n, o = (rn[e] || []).concat(rn["*"]), r = 0, a = o.length; a > r; r++) if (n = o[r].call(i, e, t)) return n;
    }
    function _(t, e, i) {
        var n, o, r = 0, a = on.length, s = he.Deferred().always(function() {
            delete l.elem;
        }), l = function() {
            if (o) return !1;
            for (var e = Ji || B(), i = Math.max(0, p.startTime + p.duration - e), n = i / p.duration || 0, r = 1 - n, a = 0, l = p.tweens.length; l > a; a++) p.tweens[a].run(r);
            return s.notifyWith(t, [ p, r, i ]), 1 > r && l ? i : (s.resolveWith(t, [ p ]), 
            !1);
        }, p = s.promise({
            elem: t,
            props: he.extend({}, e),
            opts: he.extend(!0, {
                specialEasing: {}
            }, i),
            originalProperties: e,
            originalOptions: i,
            startTime: Ji || B(),
            duration: i.duration,
            tweens: [],
            createTween: function(e, i) {
                var n = he.Tween(t, p.opts, e, i, p.opts.specialEasing[e] || p.opts.easing);
                return p.tweens.push(n), n;
            },
            stop: function(e) {
                var i = 0, n = e ? p.tweens.length : 0;
                if (o) return this;
                for (o = !0; n > i; i++) p.tweens[i].run(1);
                return e ? s.resolveWith(t, [ p, e ]) : s.rejectWith(t, [ p, e ]), this;
            }
        }), h = p.props;
        for (F(h, p.opts.specialEasing); a > r; r++) if (n = on[r].call(p, t, h, p.opts)) return n;
        return he.map(h, L, p), he.isFunction(p.opts.start) && p.opts.start.call(t, p), 
        he.fx.timer(he.extend(l, {
            elem: t,
            anim: p,
            queue: p.opts.queue
        })), p.progress(p.opts.progress).done(p.opts.done, p.opts.complete).fail(p.opts.fail).always(p.opts.always);
    }
    function F(t, e) {
        var i, n, o, r, a;
        for (i in t) if (n = he.camelCase(i), o = e[n], r = t[i], he.isArray(r) && (o = r[1], 
        r = t[i] = r[0]), i !== n && (t[n] = r, delete t[i]), a = he.cssHooks[n], a && "expand" in a) {
            r = a.expand(r), delete t[n];
            for (i in r) i in t || (t[i] = r[i], e[i] = o);
        } else e[n] = o;
    }
    function z(t, e, i) {
        var n, o, r, a, s, l, p = this, h = {}, m = t.style, c = t.nodeType && b(t), d = he._data(t, "fxshow");
        i.queue || (s = he._queueHooks(t, "fx"), null == s.unqueued && (s.unqueued = 0, 
        l = s.empty.fire, s.empty.fire = function() {
            s.unqueued || l();
        }), s.unqueued++, p.always(function() {
            p.always(function() {
                s.unqueued--, he.queue(t, "fx").length || s.empty.fire();
            });
        })), 1 === t.nodeType && ("height" in e || "width" in e) && (i.overflow = [ m.overflow, m.overflowX, m.overflowY ], 
        "inline" === he.css(t, "display") && "none" === he.css(t, "float") && (he.support.inlineBlockNeedsLayout && "inline" !== N(t.nodeName) ? m.zoom = 1 : m.display = "inline-block")), 
        i.overflow && (m.overflow = "hidden", he.support.shrinkWrapBlocks || p.always(function() {
            m.overflow = i.overflow[0], m.overflowX = i.overflow[1], m.overflowY = i.overflow[2];
        }));
        for (n in e) if (o = e[n], tn.exec(o)) {
            if (delete e[n], r = r || "toggle" === o, o === (c ? "hide" : "show")) continue;
            h[n] = d && d[n] || he.style(t, n);
        }
        if (!he.isEmptyObject(h)) {
            d ? "hidden" in d && (c = d.hidden) : d = he._data(t, "fxshow", {}), r && (d.hidden = !c), 
            c ? he(t).show() : p.done(function() {
                he(t).hide();
            }), p.done(function() {
                var e;
                he._removeData(t, "fxshow");
                for (e in h) he.style(t, e, h[e]);
            });
            for (n in h) a = L(c ? d[n] : 0, n, p), n in d || (d[n] = a.start, c && (a.end = a.start, 
            a.start = "width" === n || "height" === n ? 1 : 0));
        }
    }
    function W(t, e, i, n, o) {
        return new W.prototype.init(t, e, i, n, o);
    }
    function j(t, e) {
        var i, n = {
            height: t
        }, o = 0;
        for (e = e ? 1 : 0; 4 > o; o += 2 - e) i = bi[o], n["margin" + i] = n["padding" + i] = t;
        return e && (n.opacity = n.width = t), n;
    }
    function V(t) {
        return he.isWindow(t) ? t : 9 === t.nodeType ? t.defaultView || t.parentWindow : !1;
    }
    var q, K, U = typeof e, G = t.location, X = t.document, Y = X.documentElement, J = t.jQuery, Q = t.$, te = {}, ee = [], ie = "1.10.2", ne = ee.concat, oe = ee.push, re = ee.slice, ae = ee.indexOf, se = te.toString, le = te.hasOwnProperty, pe = ie.trim, he = function(t, e) {
        return new he.fn.init(t, e, K);
    }, me = /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source, ce = /\S+/g, de = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, ue = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]*))$/, fe = /^<(\w+)\s*\/?>(?:<\/\1>|)$/, ke = /^[\],:{}\s]*$/, ge = /(?:^|:|,)(?:\s*\[)+/g, Te = /\\(?:["\\\/bfnrt]|u[\da-fA-F]{4})/g, ye = /"[^"\\\r\n]*"|true|false|null|-?(?:\d+\.|)\d+(?:[eE][+-]?\d+|)/g, ve = /^-ms-/, Ze = /-([\da-z])/gi, we = function(t, e) {
        return e.toUpperCase();
    }, be = function(t) {
        (X.addEventListener || "load" === t.type || "complete" === X.readyState) && (xe(), 
        he.ready());
    }, xe = function() {
        X.addEventListener ? (X.removeEventListener("DOMContentLoaded", be, !1), t.removeEventListener("load", be, !1)) : (X.detachEvent("onreadystatechange", be), 
        t.detachEvent("onload", be));
    };
    he.fn = he.prototype = {
        jquery: ie,
        constructor: he,
        init: function(t, i, n) {
            var o, r;
            if (!t) return this;
            if ("string" == typeof t) {
                if (o = "<" === t.charAt(0) && ">" === t.charAt(t.length - 1) && t.length >= 3 ? [ null, t, null ] : ue.exec(t), 
                !o || !o[1] && i) return !i || i.jquery ? (i || n).find(t) : this.constructor(i).find(t);
                if (o[1]) {
                    if (i = i instanceof he ? i[0] : i, he.merge(this, he.parseHTML(o[1], i && i.nodeType ? i.ownerDocument || i : X, !0)), 
                    fe.test(o[1]) && he.isPlainObject(i)) for (o in i) he.isFunction(this[o]) ? this[o](i[o]) : this.attr(o, i[o]);
                    return this;
                }
                if (r = X.getElementById(o[2]), r && r.parentNode) {
                    if (r.id !== o[2]) return n.find(t);
                    this.length = 1, this[0] = r;
                }
                return this.context = X, this.selector = t, this;
            }
            return t.nodeType ? (this.context = this[0] = t, this.length = 1, this) : he.isFunction(t) ? n.ready(t) : (t.selector !== e && (this.selector = t.selector, 
            this.context = t.context), he.makeArray(t, this));
        },
        selector: "",
        length: 0,
        toArray: function() {
            return re.call(this);
        },
        get: function(t) {
            return null == t ? this.toArray() : 0 > t ? this[this.length + t] : this[t];
        },
        pushStack: function(t) {
            var e = he.merge(this.constructor(), t);
            return e.prevObject = this, e.context = this.context, e;
        },
        each: function(t, e) {
            return he.each(this, t, e);
        },
        ready: function(t) {
            return he.ready.promise().done(t), this;
        },
        slice: function() {
            return this.pushStack(re.apply(this, arguments));
        },
        first: function() {
            return this.eq(0);
        },
        last: function() {
            return this.eq(-1);
        },
        eq: function(t) {
            var e = this.length, i = +t + (0 > t ? e : 0);
            return this.pushStack(i >= 0 && e > i ? [ this[i] ] : []);
        },
        map: function(t) {
            return this.pushStack(he.map(this, function(e, i) {
                return t.call(e, i, e);
            }));
        },
        end: function() {
            return this.prevObject || this.constructor(null);
        },
        push: oe,
        sort: [].sort,
        splice: [].splice
    }, he.fn.init.prototype = he.fn, he.extend = he.fn.extend = function() {
        var t, i, n, o, r, a, s = arguments[0] || {}, l = 1, p = arguments.length, h = !1;
        for ("boolean" == typeof s && (h = s, s = arguments[1] || {}, l = 2), "object" == typeof s || he.isFunction(s) || (s = {}), 
        p === l && (s = this, --l); p > l; l++) if (null != (r = arguments[l])) for (o in r) t = s[o], 
        n = r[o], s !== n && (h && n && (he.isPlainObject(n) || (i = he.isArray(n))) ? (i ? (i = !1, 
        a = t && he.isArray(t) ? t : []) : a = t && he.isPlainObject(t) ? t : {}, s[o] = he.extend(h, a, n)) : n !== e && (s[o] = n));
        return s;
    }, he.extend({
        expando: "jQuery" + (ie + Math.random()).replace(/\D/g, ""),
        noConflict: function(e) {
            return t.$ === he && (t.$ = Q), e && t.jQuery === he && (t.jQuery = J), he;
        },
        isReady: !1,
        readyWait: 1,
        holdReady: function(t) {
            t ? he.readyWait++ : he.ready(!0);
        },
        ready: function(t) {
            if (t === !0 ? !--he.readyWait : !he.isReady) {
                if (!X.body) return setTimeout(he.ready);
                he.isReady = !0, t !== !0 && --he.readyWait > 0 || (q.resolveWith(X, [ he ]), he.fn.trigger && he(X).trigger("ready").off("ready"));
            }
        },
        isFunction: function(t) {
            return "function" === he.type(t);
        },
        isArray: Array.isArray || function(t) {
            return "array" === he.type(t);
        },
        isWindow: function(t) {
            return null != t && t == t.window;
        },
        isNumeric: function(t) {
            return !isNaN(parseFloat(t)) && isFinite(t);
        },
        type: function(t) {
            return null == t ? t + "" : "object" == typeof t || "function" == typeof t ? te[se.call(t)] || "object" : typeof t;
        },
        isPlainObject: function(t) {
            var i;
            if (!t || "object" !== he.type(t) || t.nodeType || he.isWindow(t)) return !1;
            try {
                if (t.constructor && !le.call(t, "constructor") && !le.call(t.constructor.prototype, "isPrototypeOf")) return !1;
            } catch (n) {
                return !1;
            }
            if (he.support.ownLast) for (i in t) return le.call(t, i);
            for (i in t) ;
            return i === e || le.call(t, i);
        },
        isEmptyObject: function(t) {
            var e;
            for (e in t) return !1;
            return !0;
        },
        error: function(t) {
            throw Error(t);
        },
        parseHTML: function(t, e, i) {
            if (!t || "string" != typeof t) return null;
            "boolean" == typeof e && (i = e, e = !1), e = e || X;
            var n = fe.exec(t), o = !i && [];
            return n ? [ e.createElement(n[1]) ] : (n = he.buildFragment([ t ], e, o), o && he(o).remove(), 
            he.merge([], n.childNodes));
        },
        parseJSON: function(i) {
            return t.JSON && t.JSON.parse ? t.JSON.parse(i) : null === i ? i : "string" == typeof i && (i = he.trim(i), 
            i && ke.test(i.replace(Te, "@").replace(ye, "]").replace(ge, ""))) ? Function("return " + i)() : (he.error("Invalid JSON: " + i), 
            e);
        },
        parseXML: function(i) {
            var n, o;
            if (!i || "string" != typeof i) return null;
            try {
                t.DOMParser ? (o = new DOMParser(), n = o.parseFromString(i, "text/xml")) : (n = new ActiveXObject("Microsoft.XMLDOM"), 
                n.async = "false", n.loadXML(i));
            } catch (r) {
                n = e;
            }
            return n && n.documentElement && !n.getElementsByTagName("parsererror").length || he.error("Invalid XML: " + i), 
            n;
        },
        noop: function() {},
        globalEval: function(e) {
            e && he.trim(e) && (t.execScript || function(e) {
                t.eval.call(t, e);
            })(e);
        },
        camelCase: function(t) {
            return t.replace(ve, "ms-").replace(Ze, we);
        },
        nodeName: function(t, e) {
            return t.nodeName && t.nodeName.toLowerCase() === e.toLowerCase();
        },
        each: function(t, e, n) {
            var o, r = 0, a = t.length, s = i(t);
            if (n) {
                if (s) for (;a > r && (o = e.apply(t[r], n), o !== !1); r++) ; else for (r in t) if (o = e.apply(t[r], n), 
                o === !1) break;
            } else if (s) for (;a > r && (o = e.call(t[r], r, t[r]), o !== !1); r++) ; else for (r in t) if (o = e.call(t[r], r, t[r]), 
            o === !1) break;
            return t;
        },
        trim: pe && !pe.call("\ufeff\u00a0") ? function(t) {
            return null == t ? "" : pe.call(t);
        } : function(t) {
            return null == t ? "" : (t + "").replace(de, "");
        },
        makeArray: function(t, e) {
            var n = e || [];
            return null != t && (i(Object(t)) ? he.merge(n, "string" == typeof t ? [ t ] : t) : oe.call(n, t)), 
            n;
        },
        inArray: function(t, e, i) {
            var n;
            if (e) {
                if (ae) return ae.call(e, t, i);
                for (n = e.length, i = i ? 0 > i ? Math.max(0, n + i) : i : 0; n > i; i++) if (i in e && e[i] === t) return i;
            }
            return -1;
        },
        merge: function(t, i) {
            var n = i.length, o = t.length, r = 0;
            if ("number" == typeof n) for (;n > r; r++) t[o++] = i[r]; else for (;i[r] !== e; ) t[o++] = i[r++];
            return t.length = o, t;
        },
        grep: function(t, e, i) {
            var n, o = [], r = 0, a = t.length;
            for (i = !!i; a > r; r++) n = !!e(t[r], r), i !== n && o.push(t[r]);
            return o;
        },
        map: function(t, e, n) {
            var o, r = 0, a = t.length, s = i(t), l = [];
            if (s) for (;a > r; r++) o = e(t[r], r, n), null != o && (l[l.length] = o); else for (r in t) o = e(t[r], r, n), 
            null != o && (l[l.length] = o);
            return ne.apply([], l);
        },
        guid: 1,
        proxy: function(t, i) {
            var n, o, r;
            return "string" == typeof i && (r = t[i], i = t, t = r), he.isFunction(t) ? (n = re.call(arguments, 2), 
            o = function() {
                return t.apply(i || this, n.concat(re.call(arguments)));
            }, o.guid = t.guid = t.guid || he.guid++, o) : e;
        },
        access: function(t, i, n, o, r, a, s) {
            var l = 0, p = t.length, h = null == n;
            if ("object" === he.type(n)) {
                r = !0;
                for (l in n) he.access(t, i, l, n[l], !0, a, s);
            } else if (o !== e && (r = !0, he.isFunction(o) || (s = !0), h && (s ? (i.call(t, o), 
            i = null) : (h = i, i = function(t, e, i) {
                return h.call(he(t), i);
            })), i)) for (;p > l; l++) i(t[l], n, s ? o : o.call(t[l], l, i(t[l], n)));
            return r ? t : h ? i.call(t) : p ? i(t[0], n) : a;
        },
        now: function() {
            return new Date().getTime();
        },
        swap: function(t, e, i, n) {
            var o, r, a = {};
            for (r in e) a[r] = t.style[r], t.style[r] = e[r];
            o = i.apply(t, n || []);
            for (r in e) t.style[r] = a[r];
            return o;
        }
    }), he.ready.promise = function(e) {
        if (!q) if (q = he.Deferred(), "complete" === X.readyState) setTimeout(he.ready); else if (X.addEventListener) X.addEventListener("DOMContentLoaded", be, !1), 
        t.addEventListener("load", be, !1); else {
            X.attachEvent("onreadystatechange", be), t.attachEvent("onload", be);
            var i = !1;
            try {
                i = null == t.frameElement && X.documentElement;
            } catch (n) {}
            i && i.doScroll && function o() {
                if (!he.isReady) {
                    try {
                        i.doScroll("left");
                    } catch (t) {
                        return setTimeout(o, 50);
                    }
                    xe(), he.ready();
                }
            }();
        }
        return q.promise(e);
    }, he.each("Boolean Number String Function Array Date RegExp Object Error".split(" "), function(t, e) {
        te["[object " + e + "]"] = e.toLowerCase();
    }), K = he(X), function(t, e) {
        function i(t, e, i, n) {
            var o, r, a, s, l, p, h, m, u, f;
            if ((e ? e.ownerDocument || e : _) !== M && O(e), e = e || M, i = i || [], !t || "string" != typeof t) return i;
            if (1 !== (s = e.nodeType) && 9 !== s) return [];
            if (D && !n) {
                if (o = ye.exec(t)) if (a = o[1]) {
                    if (9 === s) {
                        if (r = e.getElementById(a), !r || !r.parentNode) return i;
                        if (r.id === a) return i.push(r), i;
                    } else if (e.ownerDocument && (r = e.ownerDocument.getElementById(a)) && B(e, r) && r.id === a) return i.push(r), 
                    i;
                } else {
                    if (o[2]) return te.apply(i, e.getElementsByTagName(t)), i;
                    if ((a = o[3]) && b.getElementsByClassName && e.getElementsByClassName) return te.apply(i, e.getElementsByClassName(a)), 
                    i;
                }
                if (b.qsa && (!A || !A.test(t))) {
                    if (m = h = L, u = e, f = 9 === s && t, 1 === s && "object" !== e.nodeName.toLowerCase()) {
                        for (p = c(t), (h = e.getAttribute("id")) ? m = h.replace(we, "\\$&") : e.setAttribute("id", m), 
                        m = "[id='" + m + "'] ", l = p.length; l--; ) p[l] = m + d(p[l]);
                        u = de.test(t) && e.parentNode || e, f = p.join(",");
                    }
                    if (f) try {
                        return te.apply(i, u.querySelectorAll(f)), i;
                    } catch (k) {} finally {
                        h || e.removeAttribute("id");
                    }
                }
            }
            return Z(t.replace(pe, "$1"), e, i, n);
        }
        function n() {
            function t(i, n) {
                return e.push(i += " ") > C.cacheLength && delete t[e.shift()], t[i] = n;
            }
            var e = [];
            return t;
        }
        function o(t) {
            return t[L] = !0, t;
        }
        function r(t) {
            var e = M.createElement("div");
            try {
                return !!t(e);
            } catch (i) {
                return !1;
            } finally {
                e.parentNode && e.parentNode.removeChild(e), e = null;
            }
        }
        function a(t, e) {
            for (var i = t.split("|"), n = t.length; n--; ) C.attrHandle[i[n]] = e;
        }
        function s(t, e) {
            var i = e && t, n = i && 1 === t.nodeType && 1 === e.nodeType && (~e.sourceIndex || G) - (~t.sourceIndex || G);
            if (n) return n;
            if (i) for (;i = i.nextSibling; ) if (i === e) return -1;
            return t ? 1 : -1;
        }
        function l(t) {
            return function(e) {
                var i = e.nodeName.toLowerCase();
                return "input" === i && e.type === t;
            };
        }
        function p(t) {
            return function(e) {
                var i = e.nodeName.toLowerCase();
                return ("input" === i || "button" === i) && e.type === t;
            };
        }
        function h(t) {
            return o(function(e) {
                return e = +e, o(function(i, n) {
                    for (var o, r = t([], i.length, e), a = r.length; a--; ) i[o = r[a]] && (i[o] = !(n[o] = i[o]));
                });
            });
        }
        function m() {}
        function c(t, e) {
            var n, o, r, a, s, l, p, h = j[t + " "];
            if (h) return e ? 0 : h.slice(0);
            for (s = t, l = [], p = C.preFilter; s; ) {
                (!n || (o = me.exec(s))) && (o && (s = s.slice(o[0].length) || s), l.push(r = [])), 
                n = !1, (o = ce.exec(s)) && (n = o.shift(), r.push({
                    value: n,
                    type: o[0].replace(pe, " ")
                }), s = s.slice(n.length));
                for (a in C.filter) !(o = ge[a].exec(s)) || p[a] && !(o = p[a](o)) || (n = o.shift(), 
                r.push({
                    value: n,
                    type: a,
                    matches: o
                }), s = s.slice(n.length));
                if (!n) break;
            }
            return e ? s.length : s ? i.error(t) : j(t, l).slice(0);
        }
        function d(t) {
            for (var e = 0, i = t.length, n = ""; i > e; e++) n += t[e].value;
            return n;
        }
        function u(t, e, i) {
            var n = e.dir, o = i && "parentNode" === n, r = z++;
            return e.first ? function(e, i, r) {
                for (;e = e[n]; ) if (1 === e.nodeType || o) return t(e, i, r);
            } : function(e, i, a) {
                var s, l, p, h = F + " " + r;
                if (a) {
                    for (;e = e[n]; ) if ((1 === e.nodeType || o) && t(e, i, a)) return !0;
                } else for (;e = e[n]; ) if (1 === e.nodeType || o) if (p = e[L] || (e[L] = {}), 
                (l = p[n]) && l[0] === h) {
                    if ((s = l[1]) === !0 || s === x) return s === !0;
                } else if (l = p[n] = [ h ], l[1] = t(e, i, a) || x, l[1] === !0) return !0;
            };
        }
        function f(t) {
            return t.length > 1 ? function(e, i, n) {
                for (var o = t.length; o--; ) if (!t[o](e, i, n)) return !1;
                return !0;
            } : t[0];
        }
        function k(t, e, i, n, o) {
            for (var r, a = [], s = 0, l = t.length, p = null != e; l > s; s++) (r = t[s]) && (!i || i(r, n, o)) && (a.push(r), 
            p && e.push(s));
            return a;
        }
        function g(t, e, i, n, r, a) {
            return n && !n[L] && (n = g(n)), r && !r[L] && (r = g(r, a)), o(function(o, a, s, l) {
                var p, h, m, c = [], d = [], u = a.length, f = o || v(e || "*", s.nodeType ? [ s ] : s, []), g = !t || !o && e ? f : k(f, c, t, s, l), T = i ? r || (o ? t : u || n) ? [] : a : g;
                if (i && i(g, T, s, l), n) for (p = k(T, d), n(p, [], s, l), h = p.length; h--; ) (m = p[h]) && (T[d[h]] = !(g[d[h]] = m));
                if (o) {
                    if (r || t) {
                        if (r) {
                            for (p = [], h = T.length; h--; ) (m = T[h]) && p.push(g[h] = m);
                            r(null, T = [], p, l);
                        }
                        for (h = T.length; h--; ) (m = T[h]) && (p = r ? ie.call(o, m) : c[h]) > -1 && (o[p] = !(a[p] = m));
                    }
                } else T = k(T === a ? T.splice(u, T.length) : T), r ? r(null, a, T, l) : te.apply(a, T);
            });
        }
        function T(t) {
            for (var e, i, n, o = t.length, r = C.relative[t[0].type], a = r || C.relative[" "], s = r ? 1 : 0, l = u(function(t) {
                return t === e;
            }, a, !0), p = u(function(t) {
                return ie.call(e, t) > -1;
            }, a, !0), h = [ function(t, i, n) {
                return !r && (n || i !== I) || ((e = i).nodeType ? l(t, i, n) : p(t, i, n));
            } ]; o > s; s++) if (i = C.relative[t[s].type]) h = [ u(f(h), i) ]; else {
                if (i = C.filter[t[s].type].apply(null, t[s].matches), i[L]) {
                    for (n = ++s; o > n && !C.relative[t[n].type]; n++) ;
                    return g(s > 1 && f(h), s > 1 && d(t.slice(0, s - 1).concat({
                        value: " " === t[s - 2].type ? "*" : ""
                    })).replace(pe, "$1"), i, n > s && T(t.slice(s, n)), o > n && T(t = t.slice(n)), o > n && d(t));
                }
                h.push(i);
            }
            return f(h);
        }
        function y(t, e) {
            var n = 0, r = e.length > 0, a = t.length > 0, s = function(o, s, l, p, h) {
                var m, c, d, u = [], f = 0, g = "0", T = o && [], y = null != h, v = I, Z = o || a && C.find.TAG("*", h && s.parentNode || s), w = F += null == v ? 1 : Math.random() || .1;
                for (y && (I = s !== M && s, x = n); null != (m = Z[g]); g++) {
                    if (a && m) {
                        for (c = 0; d = t[c++]; ) if (d(m, s, l)) {
                            p.push(m);
                            break;
                        }
                        y && (F = w, x = ++n);
                    }
                    r && ((m = !d && m) && f--, o && T.push(m));
                }
                if (f += g, r && g !== f) {
                    for (c = 0; d = e[c++]; ) d(T, u, s, l);
                    if (o) {
                        if (f > 0) for (;g--; ) T[g] || u[g] || (u[g] = J.call(p));
                        u = k(u);
                    }
                    te.apply(p, u), y && !o && u.length > 0 && f + e.length > 1 && i.uniqueSort(p);
                }
                return y && (F = w, I = v), T;
            };
            return r ? o(s) : s;
        }
        function v(t, e, n) {
            for (var o = 0, r = e.length; r > o; o++) i(t, e[o], n);
            return n;
        }
        function Z(t, e, i, n) {
            var o, r, a, s, l, p = c(t);
            if (!n && 1 === p.length) {
                if (r = p[0] = p[0].slice(0), r.length > 2 && "ID" === (a = r[0]).type && b.getById && 9 === e.nodeType && D && C.relative[r[1].type]) {
                    if (e = (C.find.ID(a.matches[0].replace(be, xe), e) || [])[0], !e) return i;
                    t = t.slice(r.shift().value.length);
                }
                for (o = ge.needsContext.test(t) ? 0 : r.length; o-- && (a = r[o], !C.relative[s = a.type]); ) if ((l = C.find[s]) && (n = l(a.matches[0].replace(be, xe), de.test(r[0].type) && e.parentNode || e))) {
                    if (r.splice(o, 1), t = n.length && d(r), !t) return te.apply(i, n), i;
                    break;
                }
            }
            return N(t, p)(n, e, !D, i, de.test(t)), i;
        }
        var w, b, x, C, S, P, N, I, R, O, M, $, D, A, H, E, B, L = "sizzle" + -new Date(), _ = t.document, F = 0, z = 0, W = n(), j = n(), V = n(), q = !1, K = function(t, e) {
            return t === e ? (q = !0, 0) : 0;
        }, U = typeof e, G = 1 << 31, X = {}.hasOwnProperty, Y = [], J = Y.pop, Q = Y.push, te = Y.push, ee = Y.slice, ie = Y.indexOf || function(t) {
            for (var e = 0, i = this.length; i > e; e++) if (this[e] === t) return e;
            return -1;
        }, ne = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped", oe = "[\\x20\\t\\r\\n\\f]", re = "(?:\\\\.|[\\w-]|[^\\x00-\\xa0])+", ae = re.replace("w", "w#"), se = "\\[" + oe + "*(" + re + ")" + oe + "*(?:([*^$|!~]?=)" + oe + "*(?:(['\"])((?:\\\\.|[^\\\\])*?)\\3|(" + ae + ")|)|)" + oe + "*\\]", le = ":(" + re + ")(?:\\(((['\"])((?:\\\\.|[^\\\\])*?)\\3|((?:\\\\.|[^\\\\()[\\]]|" + se.replace(3, 8) + ")*)|.*)\\)|)", pe = RegExp("^" + oe + "+|((?:^|[^\\\\])(?:\\\\.)*)" + oe + "+$", "g"), me = RegExp("^" + oe + "*," + oe + "*"), ce = RegExp("^" + oe + "*([>+~]|" + oe + ")" + oe + "*"), de = RegExp(oe + "*[+~]"), ue = RegExp("=" + oe + "*([^\\]'\"]*)" + oe + "*\\]", "g"), fe = RegExp(le), ke = RegExp("^" + ae + "$"), ge = {
            ID: RegExp("^#(" + re + ")"),
            CLASS: RegExp("^\\.(" + re + ")"),
            TAG: RegExp("^(" + re.replace("w", "w*") + ")"),
            ATTR: RegExp("^" + se),
            PSEUDO: RegExp("^" + le),
            CHILD: RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" + oe + "*(even|odd|(([+-]|)(\\d*)n|)" + oe + "*(?:([+-]|)" + oe + "*(\\d+)|))" + oe + "*\\)|)", "i"),
            bool: RegExp("^(?:" + ne + ")$", "i"),
            needsContext: RegExp("^" + oe + "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + oe + "*((?:-\\d)?\\d*)" + oe + "*\\)|)(?=[^-]|$)", "i")
        }, Te = /^[^{]+\{\s*\[native \w/, ye = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/, ve = /^(?:input|select|textarea|button)$/i, Ze = /^h\d$/i, we = /'|\\/g, be = RegExp("\\\\([\\da-f]{1,6}" + oe + "?|(" + oe + ")|.)", "ig"), xe = function(t, e, i) {
            var n = "0x" + e - 65536;
            return n !== n || i ? e : 0 > n ? String.fromCharCode(n + 65536) : String.fromCharCode(55296 | n >> 10, 56320 | 1023 & n);
        };
        try {
            te.apply(Y = ee.call(_.childNodes), _.childNodes), Y[_.childNodes.length].nodeType;
        } catch (Ce) {
            te = {
                apply: Y.length ? function(t, e) {
                    Q.apply(t, ee.call(e));
                } : function(t, e) {
                    for (var i = t.length, n = 0; t[i++] = e[n++]; ) ;
                    t.length = i - 1;
                }
            };
        }
        P = i.isXML = function(t) {
            var e = t && (t.ownerDocument || t).documentElement;
            return e ? "HTML" !== e.nodeName : !1;
        }, b = i.support = {}, O = i.setDocument = function(t) {
            var i = t ? t.ownerDocument || t : _, n = i.defaultView;
            return i !== M && 9 === i.nodeType && i.documentElement ? (M = i, $ = i.documentElement, 
            D = !P(i), n && n.attachEvent && n !== n.top && n.attachEvent("onbeforeunload", function() {
                O();
            }), b.attributes = r(function(t) {
                return t.className = "i", !t.getAttribute("className");
            }), b.getElementsByTagName = r(function(t) {
                return t.appendChild(i.createComment("")), !t.getElementsByTagName("*").length;
            }), b.getElementsByClassName = r(function(t) {
                return t.innerHTML = "<div class='a'></div><div class='a i'></div>", t.firstChild.className = "i", 
                2 === t.getElementsByClassName("i").length;
            }), b.getById = r(function(t) {
                return $.appendChild(t).id = L, !i.getElementsByName || !i.getElementsByName(L).length;
            }), b.getById ? (C.find.ID = function(t, e) {
                if (typeof e.getElementById !== U && D) {
                    var i = e.getElementById(t);
                    return i && i.parentNode ? [ i ] : [];
                }
            }, C.filter.ID = function(t) {
                var e = t.replace(be, xe);
                return function(t) {
                    return t.getAttribute("id") === e;
                };
            }) : (delete C.find.ID, C.filter.ID = function(t) {
                var e = t.replace(be, xe);
                return function(t) {
                    var i = typeof t.getAttributeNode !== U && t.getAttributeNode("id");
                    return i && i.value === e;
                };
            }), C.find.TAG = b.getElementsByTagName ? function(t, i) {
                return typeof i.getElementsByTagName !== U ? i.getElementsByTagName(t) : e;
            } : function(t, e) {
                var i, n = [], o = 0, r = e.getElementsByTagName(t);
                if ("*" === t) {
                    for (;i = r[o++]; ) 1 === i.nodeType && n.push(i);
                    return n;
                }
                return r;
            }, C.find.CLASS = b.getElementsByClassName && function(t, i) {
                return typeof i.getElementsByClassName !== U && D ? i.getElementsByClassName(t) : e;
            }, H = [], A = [], (b.qsa = Te.test(i.querySelectorAll)) && (r(function(t) {
                t.innerHTML = "<select><option selected=''></option></select>", t.querySelectorAll("[selected]").length || A.push("\\[" + oe + "*(?:value|" + ne + ")"), 
                t.querySelectorAll(":checked").length || A.push(":checked");
            }), r(function(t) {
                var e = i.createElement("input");
                e.setAttribute("type", "hidden"), t.appendChild(e).setAttribute("t", ""), t.querySelectorAll("[t^='']").length && A.push("[*^$]=" + oe + "*(?:''|\"\")"), 
                t.querySelectorAll(":enabled").length || A.push(":enabled", ":disabled"), t.querySelectorAll("*,:x"), 
                A.push(",.*:");
            })), (b.matchesSelector = Te.test(E = $.webkitMatchesSelector || $.mozMatchesSelector || $.oMatchesSelector || $.msMatchesSelector)) && r(function(t) {
                b.disconnectedMatch = E.call(t, "div"), E.call(t, "[s!='']:x"), H.push("!=", le);
            }), A = A.length && RegExp(A.join("|")), H = H.length && RegExp(H.join("|")), B = Te.test($.contains) || $.compareDocumentPosition ? function(t, e) {
                var i = 9 === t.nodeType ? t.documentElement : t, n = e && e.parentNode;
                return t === n || !(!n || 1 !== n.nodeType || !(i.contains ? i.contains(n) : t.compareDocumentPosition && 16 & t.compareDocumentPosition(n)));
            } : function(t, e) {
                if (e) for (;e = e.parentNode; ) if (e === t) return !0;
                return !1;
            }, K = $.compareDocumentPosition ? function(t, e) {
                if (t === e) return q = !0, 0;
                var n = e.compareDocumentPosition && t.compareDocumentPosition && t.compareDocumentPosition(e);
                return n ? 1 & n || !b.sortDetached && e.compareDocumentPosition(t) === n ? t === i || B(_, t) ? -1 : e === i || B(_, e) ? 1 : R ? ie.call(R, t) - ie.call(R, e) : 0 : 4 & n ? -1 : 1 : t.compareDocumentPosition ? -1 : 1;
            } : function(t, e) {
                var n, o = 0, r = t.parentNode, a = e.parentNode, l = [ t ], p = [ e ];
                if (t === e) return q = !0, 0;
                if (!r || !a) return t === i ? -1 : e === i ? 1 : r ? -1 : a ? 1 : R ? ie.call(R, t) - ie.call(R, e) : 0;
                if (r === a) return s(t, e);
                for (n = t; n = n.parentNode; ) l.unshift(n);
                for (n = e; n = n.parentNode; ) p.unshift(n);
                for (;l[o] === p[o]; ) o++;
                return o ? s(l[o], p[o]) : l[o] === _ ? -1 : p[o] === _ ? 1 : 0;
            }, i) : M;
        }, i.matches = function(t, e) {
            return i(t, null, null, e);
        }, i.matchesSelector = function(t, e) {
            if ((t.ownerDocument || t) !== M && O(t), e = e.replace(ue, "='$1']"), !(!b.matchesSelector || !D || H && H.test(e) || A && A.test(e))) try {
                var n = E.call(t, e);
                if (n || b.disconnectedMatch || t.document && 11 !== t.document.nodeType) return n;
            } catch (o) {}
            return i(e, M, null, [ t ]).length > 0;
        }, i.contains = function(t, e) {
            return (t.ownerDocument || t) !== M && O(t), B(t, e);
        }, i.attr = function(t, i) {
            (t.ownerDocument || t) !== M && O(t);
            var n = C.attrHandle[i.toLowerCase()], o = n && X.call(C.attrHandle, i.toLowerCase()) ? n(t, i, !D) : e;
            return o === e ? b.attributes || !D ? t.getAttribute(i) : (o = t.getAttributeNode(i)) && o.specified ? o.value : null : o;
        }, i.error = function(t) {
            throw Error("Syntax error, unrecognized expression: " + t);
        }, i.uniqueSort = function(t) {
            var e, i = [], n = 0, o = 0;
            if (q = !b.detectDuplicates, R = !b.sortStable && t.slice(0), t.sort(K), q) {
                for (;e = t[o++]; ) e === t[o] && (n = i.push(o));
                for (;n--; ) t.splice(i[n], 1);
            }
            return t;
        }, S = i.getText = function(t) {
            var e, i = "", n = 0, o = t.nodeType;
            if (o) {
                if (1 === o || 9 === o || 11 === o) {
                    if ("string" == typeof t.textContent) return t.textContent;
                    for (t = t.firstChild; t; t = t.nextSibling) i += S(t);
                } else if (3 === o || 4 === o) return t.nodeValue;
            } else for (;e = t[n]; n++) i += S(e);
            return i;
        }, C = i.selectors = {
            cacheLength: 50,
            createPseudo: o,
            match: ge,
            attrHandle: {},
            find: {},
            relative: {
                ">": {
                    dir: "parentNode",
                    first: !0
                },
                " ": {
                    dir: "parentNode"
                },
                "+": {
                    dir: "previousSibling",
                    first: !0
                },
                "~": {
                    dir: "previousSibling"
                }
            },
            preFilter: {
                ATTR: function(t) {
                    return t[1] = t[1].replace(be, xe), t[3] = (t[4] || t[5] || "").replace(be, xe), 
                    "~=" === t[2] && (t[3] = " " + t[3] + " "), t.slice(0, 4);
                },
                CHILD: function(t) {
                    return t[1] = t[1].toLowerCase(), "nth" === t[1].slice(0, 3) ? (t[3] || i.error(t[0]), 
                    t[4] = +(t[4] ? t[5] + (t[6] || 1) : 2 * ("even" === t[3] || "odd" === t[3])), t[5] = +(t[7] + t[8] || "odd" === t[3])) : t[3] && i.error(t[0]), 
                    t;
                },
                PSEUDO: function(t) {
                    var i, n = !t[5] && t[2];
                    return ge.CHILD.test(t[0]) ? null : (t[3] && t[4] !== e ? t[2] = t[4] : n && fe.test(n) && (i = c(n, !0)) && (i = n.indexOf(")", n.length - i) - n.length) && (t[0] = t[0].slice(0, i), 
                    t[2] = n.slice(0, i)), t.slice(0, 3));
                }
            },
            filter: {
                TAG: function(t) {
                    var e = t.replace(be, xe).toLowerCase();
                    return "*" === t ? function() {
                        return !0;
                    } : function(t) {
                        return t.nodeName && t.nodeName.toLowerCase() === e;
                    };
                },
                CLASS: function(t) {
                    var e = W[t + " "];
                    return e || (e = RegExp("(^|" + oe + ")" + t + "(" + oe + "|$)")) && W(t, function(t) {
                        return e.test("string" == typeof t.className && t.className || typeof t.getAttribute !== U && t.getAttribute("class") || "");
                    });
                },
                ATTR: function(t, e, n) {
                    return function(o) {
                        var r = i.attr(o, t);
                        return null == r ? "!=" === e : e ? (r += "", "=" === e ? r === n : "!=" === e ? r !== n : "^=" === e ? n && 0 === r.indexOf(n) : "*=" === e ? n && r.indexOf(n) > -1 : "$=" === e ? n && r.slice(-n.length) === n : "~=" === e ? (" " + r + " ").indexOf(n) > -1 : "|=" === e ? r === n || r.slice(0, n.length + 1) === n + "-" : !1) : !0;
                    };
                },
                CHILD: function(t, e, i, n, o) {
                    var r = "nth" !== t.slice(0, 3), a = "last" !== t.slice(-4), s = "of-type" === e;
                    return 1 === n && 0 === o ? function(t) {
                        return !!t.parentNode;
                    } : function(e, i, l) {
                        var p, h, m, c, d, u, f = r !== a ? "nextSibling" : "previousSibling", k = e.parentNode, g = s && e.nodeName.toLowerCase(), T = !l && !s;
                        if (k) {
                            if (r) {
                                for (;f; ) {
                                    for (m = e; m = m[f]; ) if (s ? m.nodeName.toLowerCase() === g : 1 === m.nodeType) return !1;
                                    u = f = "only" === t && !u && "nextSibling";
                                }
                                return !0;
                            }
                            if (u = [ a ? k.firstChild : k.lastChild ], a && T) {
                                for (h = k[L] || (k[L] = {}), p = h[t] || [], d = p[0] === F && p[1], c = p[0] === F && p[2], 
                                m = d && k.childNodes[d]; m = ++d && m && m[f] || (c = d = 0) || u.pop(); ) if (1 === m.nodeType && ++c && m === e) {
                                    h[t] = [ F, d, c ];
                                    break;
                                }
                            } else if (T && (p = (e[L] || (e[L] = {}))[t]) && p[0] === F) c = p[1]; else for (;(m = ++d && m && m[f] || (c = d = 0) || u.pop()) && ((s ? m.nodeName.toLowerCase() !== g : 1 !== m.nodeType) || !++c || (T && ((m[L] || (m[L] = {}))[t] = [ F, c ]), 
                            m !== e)); ) ;
                            return c -= o, c === n || 0 === c % n && c / n >= 0;
                        }
                    };
                },
                PSEUDO: function(t, e) {
                    var n, r = C.pseudos[t] || C.setFilters[t.toLowerCase()] || i.error("unsupported pseudo: " + t);
                    return r[L] ? r(e) : r.length > 1 ? (n = [ t, t, "", e ], C.setFilters.hasOwnProperty(t.toLowerCase()) ? o(function(t, i) {
                        for (var n, o = r(t, e), a = o.length; a--; ) n = ie.call(t, o[a]), t[n] = !(i[n] = o[a]);
                    }) : function(t) {
                        return r(t, 0, n);
                    }) : r;
                }
            },
            pseudos: {
                not: o(function(t) {
                    var e = [], i = [], n = N(t.replace(pe, "$1"));
                    return n[L] ? o(function(t, e, i, o) {
                        for (var r, a = n(t, null, o, []), s = t.length; s--; ) (r = a[s]) && (t[s] = !(e[s] = r));
                    }) : function(t, o, r) {
                        return e[0] = t, n(e, null, r, i), !i.pop();
                    };
                }),
                has: o(function(t) {
                    return function(e) {
                        return i(t, e).length > 0;
                    };
                }),
                contains: o(function(t) {
                    return function(e) {
                        return (e.textContent || e.innerText || S(e)).indexOf(t) > -1;
                    };
                }),
                lang: o(function(t) {
                    return ke.test(t || "") || i.error("unsupported lang: " + t), t = t.replace(be, xe).toLowerCase(), 
                    function(e) {
                        var i;
                        do if (i = D ? e.lang : e.getAttribute("xml:lang") || e.getAttribute("lang")) return i = i.toLowerCase(), 
                        i === t || 0 === i.indexOf(t + "-"); while ((e = e.parentNode) && 1 === e.nodeType);
                        return !1;
                    };
                }),
                target: function(e) {
                    var i = t.location && t.location.hash;
                    return i && i.slice(1) === e.id;
                },
                root: function(t) {
                    return t === $;
                },
                focus: function(t) {
                    return t === M.activeElement && (!M.hasFocus || M.hasFocus()) && !!(t.type || t.href || ~t.tabIndex);
                },
                enabled: function(t) {
                    return t.disabled === !1;
                },
                disabled: function(t) {
                    return t.disabled === !0;
                },
                checked: function(t) {
                    var e = t.nodeName.toLowerCase();
                    return "input" === e && !!t.checked || "option" === e && !!t.selected;
                },
                selected: function(t) {
                    return t.parentNode && t.parentNode.selectedIndex, t.selected === !0;
                },
                empty: function(t) {
                    for (t = t.firstChild; t; t = t.nextSibling) if (t.nodeName > "@" || 3 === t.nodeType || 4 === t.nodeType) return !1;
                    return !0;
                },
                parent: function(t) {
                    return !C.pseudos.empty(t);
                },
                header: function(t) {
                    return Ze.test(t.nodeName);
                },
                input: function(t) {
                    return ve.test(t.nodeName);
                },
                button: function(t) {
                    var e = t.nodeName.toLowerCase();
                    return "input" === e && "button" === t.type || "button" === e;
                },
                text: function(t) {
                    var e;
                    return "input" === t.nodeName.toLowerCase() && "text" === t.type && (null == (e = t.getAttribute("type")) || e.toLowerCase() === t.type);
                },
                first: h(function() {
                    return [ 0 ];
                }),
                last: h(function(t, e) {
                    return [ e - 1 ];
                }),
                eq: h(function(t, e, i) {
                    return [ 0 > i ? i + e : i ];
                }),
                even: h(function(t, e) {
                    for (var i = 0; e > i; i += 2) t.push(i);
                    return t;
                }),
                odd: h(function(t, e) {
                    for (var i = 1; e > i; i += 2) t.push(i);
                    return t;
                }),
                lt: h(function(t, e, i) {
                    for (var n = 0 > i ? i + e : i; --n >= 0; ) t.push(n);
                    return t;
                }),
                gt: h(function(t, e, i) {
                    for (var n = 0 > i ? i + e : i; e > ++n; ) t.push(n);
                    return t;
                })
            }
        }, C.pseudos.nth = C.pseudos.eq;
        for (w in {
            radio: !0,
            checkbox: !0,
            file: !0,
            password: !0,
            image: !0
        }) C.pseudos[w] = l(w);
        for (w in {
            submit: !0,
            reset: !0
        }) C.pseudos[w] = p(w);
        m.prototype = C.filters = C.pseudos, C.setFilters = new m(), N = i.compile = function(t, e) {
            var i, n = [], o = [], r = V[t + " "];
            if (!r) {
                for (e || (e = c(t)), i = e.length; i--; ) r = T(e[i]), r[L] ? n.push(r) : o.push(r);
                r = V(t, y(o, n));
            }
            return r;
        }, b.sortStable = L.split("").sort(K).join("") === L, b.detectDuplicates = q, O(), 
        b.sortDetached = r(function(t) {
            return 1 & t.compareDocumentPosition(M.createElement("div"));
        }), r(function(t) {
            return t.innerHTML = "<a href='#'></a>", "#" === t.firstChild.getAttribute("href");
        }) || a("type|href|height|width", function(t, i, n) {
            return n ? e : t.getAttribute(i, "type" === i.toLowerCase() ? 1 : 2);
        }), b.attributes && r(function(t) {
            return t.innerHTML = "<input/>", t.firstChild.setAttribute("value", ""), "" === t.firstChild.getAttribute("value");
        }) || a("value", function(t, i, n) {
            return n || "input" !== t.nodeName.toLowerCase() ? e : t.defaultValue;
        }), r(function(t) {
            return null == t.getAttribute("disabled");
        }) || a(ne, function(t, i, n) {
            var o;
            return n ? e : (o = t.getAttributeNode(i)) && o.specified ? o.value : t[i] === !0 ? i.toLowerCase() : null;
        }), he.find = i, he.expr = i.selectors, he.expr[":"] = he.expr.pseudos, he.unique = i.uniqueSort, 
        he.text = i.getText, he.isXMLDoc = i.isXML, he.contains = i.contains;
    }(t);
    var Ce = {};
    he.Callbacks = function(t) {
        t = "string" == typeof t ? Ce[t] || n(t) : he.extend({}, t);
        var i, o, r, a, s, l, p = [], h = !t.once && [], m = function(e) {
            for (o = t.memory && e, r = !0, s = l || 0, l = 0, a = p.length, i = !0; p && a > s; s++) if (p[s].apply(e[0], e[1]) === !1 && t.stopOnFalse) {
                o = !1;
                break;
            }
            i = !1, p && (h ? h.length && m(h.shift()) : o ? p = [] : c.disable());
        }, c = {
            add: function() {
                if (p) {
                    var e = p.length;
                    (function n(e) {
                        he.each(e, function(e, i) {
                            var o = he.type(i);
                            "function" === o ? t.unique && c.has(i) || p.push(i) : i && i.length && "string" !== o && n(i);
                        });
                    })(arguments), i ? a = p.length : o && (l = e, m(o));
                }
                return this;
            },
            remove: function() {
                return p && he.each(arguments, function(t, e) {
                    for (var n; (n = he.inArray(e, p, n)) > -1; ) p.splice(n, 1), i && (a >= n && a--, 
                    s >= n && s--);
                }), this;
            },
            has: function(t) {
                return t ? he.inArray(t, p) > -1 : !(!p || !p.length);
            },
            empty: function() {
                return p = [], a = 0, this;
            },
            disable: function() {
                return p = h = o = e, this;
            },
            disabled: function() {
                return !p;
            },
            lock: function() {
                return h = e, o || c.disable(), this;
            },
            locked: function() {
                return !h;
            },
            fireWith: function(t, e) {
                return !p || r && !h || (e = e || [], e = [ t, e.slice ? e.slice() : e ], i ? h.push(e) : m(e)), 
                this;
            },
            fire: function() {
                return c.fireWith(this, arguments), this;
            },
            fired: function() {
                return !!r;
            }
        };
        return c;
    }, he.extend({
        Deferred: function(t) {
            var e = [ [ "resolve", "done", he.Callbacks("once memory"), "resolved" ], [ "reject", "fail", he.Callbacks("once memory"), "rejected" ], [ "notify", "progress", he.Callbacks("memory") ] ], i = "pending", n = {
                state: function() {
                    return i;
                },
                always: function() {
                    return o.done(arguments).fail(arguments), this;
                },
                then: function() {
                    var t = arguments;
                    return he.Deferred(function(i) {
                        he.each(e, function(e, r) {
                            var a = r[0], s = he.isFunction(t[e]) && t[e];
                            o[r[1]](function() {
                                var t = s && s.apply(this, arguments);
                                t && he.isFunction(t.promise) ? t.promise().done(i.resolve).fail(i.reject).progress(i.notify) : i[a + "With"](this === n ? i.promise() : this, s ? [ t ] : arguments);
                            });
                        }), t = null;
                    }).promise();
                },
                promise: function(t) {
                    return null != t ? he.extend(t, n) : n;
                }
            }, o = {};
            return n.pipe = n.then, he.each(e, function(t, r) {
                var a = r[2], s = r[3];
                n[r[1]] = a.add, s && a.add(function() {
                    i = s;
                }, e[1 ^ t][2].disable, e[2][2].lock), o[r[0]] = function() {
                    return o[r[0] + "With"](this === o ? n : this, arguments), this;
                }, o[r[0] + "With"] = a.fireWith;
            }), n.promise(o), t && t.call(o, o), o;
        },
        when: function(t) {
            var e, i, n, o = 0, r = re.call(arguments), a = r.length, s = 1 !== a || t && he.isFunction(t.promise) ? a : 0, l = 1 === s ? t : he.Deferred(), p = function(t, i, n) {
                return function(o) {
                    i[t] = this, n[t] = arguments.length > 1 ? re.call(arguments) : o, n === e ? l.notifyWith(i, n) : --s || l.resolveWith(i, n);
                };
            };
            if (a > 1) for (e = Array(a), i = Array(a), n = Array(a); a > o; o++) r[o] && he.isFunction(r[o].promise) ? r[o].promise().done(p(o, n, r)).fail(l.reject).progress(p(o, i, e)) : --s;
            return s || l.resolveWith(n, r), l.promise();
        }
    }), he.support = function(e) {
        var i, n, o, r, a, s, l, p, h, m = X.createElement("div");
        if (m.setAttribute("className", "t"), m.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>", 
        i = m.getElementsByTagName("*") || [], n = m.getElementsByTagName("a")[0], !n || !n.style || !i.length) return e;
        r = X.createElement("select"), s = r.appendChild(X.createElement("option")), o = m.getElementsByTagName("input")[0], 
        n.style.cssText = "top:1px;float:left;opacity:.5", e.getSetAttribute = "t" !== m.className, 
        e.leadingWhitespace = 3 === m.firstChild.nodeType, e.tbody = !m.getElementsByTagName("tbody").length, 
        e.htmlSerialize = !!m.getElementsByTagName("link").length, e.style = /top/.test(n.getAttribute("style")), 
        e.hrefNormalized = "/a" === n.getAttribute("href"), e.opacity = /^0.5/.test(n.style.opacity), 
        e.cssFloat = !!n.style.cssFloat, e.checkOn = !!o.value, e.optSelected = s.selected, 
        e.enctype = !!X.createElement("form").enctype, e.html5Clone = "<:nav></:nav>" !== X.createElement("nav").cloneNode(!0).outerHTML, 
        e.inlineBlockNeedsLayout = !1, e.shrinkWrapBlocks = !1, e.pixelPosition = !1, e.deleteExpando = !0, 
        e.noCloneEvent = !0, e.reliableMarginRight = !0, e.boxSizingReliable = !0, o.checked = !0, 
        e.noCloneChecked = o.cloneNode(!0).checked, r.disabled = !0, e.optDisabled = !s.disabled;
        try {
            delete m.test;
        } catch (c) {
            e.deleteExpando = !1;
        }
        o = X.createElement("input"), o.setAttribute("value", ""), e.input = "" === o.getAttribute("value"), 
        o.value = "t", o.setAttribute("type", "radio"), e.radioValue = "t" === o.value, 
        o.setAttribute("checked", "t"), o.setAttribute("name", "t"), a = X.createDocumentFragment(), 
        a.appendChild(o), e.appendChecked = o.checked, e.checkClone = a.cloneNode(!0).cloneNode(!0).lastChild.checked, 
        m.attachEvent && (m.attachEvent("onclick", function() {
            e.noCloneEvent = !1;
        }), m.cloneNode(!0).click());
        for (h in {
            submit: !0,
            change: !0,
            focusin: !0
        }) m.setAttribute(l = "on" + h, "t"), e[h + "Bubbles"] = l in t || m.attributes[l].expando === !1;
        m.style.backgroundClip = "content-box", m.cloneNode(!0).style.backgroundClip = "", 
        e.clearCloneStyle = "content-box" === m.style.backgroundClip;
        for (h in he(e)) break;
        return e.ownLast = "0" !== h, he(function() {
            var i, n, o, r = "padding:0;margin:0;border:0;display:block;box-sizing:content-box;-moz-box-sizing:content-box;-webkit-box-sizing:content-box;", a = X.getElementsByTagName("body")[0];
            a && (i = X.createElement("div"), i.style.cssText = "border:0;width:0;height:0;position:absolute;top:0;left:-9999px;margin-top:1px", 
            a.appendChild(i).appendChild(m), m.innerHTML = "<table><tr><td></td><td>t</td></tr></table>", 
            o = m.getElementsByTagName("td"), o[0].style.cssText = "padding:0;margin:0;border:0;display:none", 
            p = 0 === o[0].offsetHeight, o[0].style.display = "", o[1].style.display = "none", 
            e.reliableHiddenOffsets = p && 0 === o[0].offsetHeight, m.innerHTML = "", m.style.cssText = "box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;padding:1px;border:1px;display:block;width:4px;margin-top:1%;position:absolute;top:1%;", 
            he.swap(a, null != a.style.zoom ? {
                zoom: 1
            } : {}, function() {
                e.boxSizing = 4 === m.offsetWidth;
            }), t.getComputedStyle && (e.pixelPosition = "1%" !== (t.getComputedStyle(m, null) || {}).top, 
            e.boxSizingReliable = "4px" === (t.getComputedStyle(m, null) || {
                width: "4px"
            }).width, n = m.appendChild(X.createElement("div")), n.style.cssText = m.style.cssText = r, 
            n.style.marginRight = n.style.width = "0", m.style.width = "1px", e.reliableMarginRight = !parseFloat((t.getComputedStyle(n, null) || {}).marginRight)), 
            typeof m.style.zoom !== U && (m.innerHTML = "", m.style.cssText = r + "width:1px;padding:1px;display:inline;zoom:1", 
            e.inlineBlockNeedsLayout = 3 === m.offsetWidth, m.style.display = "block", m.innerHTML = "<div></div>", 
            m.firstChild.style.width = "5px", e.shrinkWrapBlocks = 3 !== m.offsetWidth, e.inlineBlockNeedsLayout && (a.style.zoom = 1)), 
            a.removeChild(i), i = m = o = n = null);
        }), i = r = a = s = n = o = null, e;
    }({});
    var Se = /(?:\{[\s\S]*\}|\[[\s\S]*\])$/, Pe = /([A-Z])/g;
    he.extend({
        cache: {},
        noData: {
            applet: !0,
            embed: !0,
            object: "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"
        },
        hasData: function(t) {
            return t = t.nodeType ? he.cache[t[he.expando]] : t[he.expando], !!t && !s(t);
        },
        data: function(t, e, i) {
            return o(t, e, i);
        },
        removeData: function(t, e) {
            return r(t, e);
        },
        _data: function(t, e, i) {
            return o(t, e, i, !0);
        },
        _removeData: function(t, e) {
            return r(t, e, !0);
        },
        acceptData: function(t) {
            if (t.nodeType && 1 !== t.nodeType && 9 !== t.nodeType) return !1;
            var e = t.nodeName && he.noData[t.nodeName.toLowerCase()];
            return !e || e !== !0 && t.getAttribute("classid") === e;
        }
    }), he.fn.extend({
        data: function(t, i) {
            var n, o, r = null, s = 0, l = this[0];
            if (t === e) {
                if (this.length && (r = he.data(l), 1 === l.nodeType && !he._data(l, "parsedAttrs"))) {
                    for (n = l.attributes; n.length > s; s++) o = n[s].name, 0 === o.indexOf("data-") && (o = he.camelCase(o.slice(5)), 
                    a(l, o, r[o]));
                    he._data(l, "parsedAttrs", !0);
                }
                return r;
            }
            return "object" == typeof t ? this.each(function() {
                he.data(this, t);
            }) : arguments.length > 1 ? this.each(function() {
                he.data(this, t, i);
            }) : l ? a(l, t, he.data(l, t)) : null;
        },
        removeData: function(t) {
            return this.each(function() {
                he.removeData(this, t);
            });
        }
    }), he.extend({
        queue: function(t, i, n) {
            var o;
            return t ? (i = (i || "fx") + "queue", o = he._data(t, i), n && (!o || he.isArray(n) ? o = he._data(t, i, he.makeArray(n)) : o.push(n)), 
            o || []) : e;
        },
        dequeue: function(t, e) {
            e = e || "fx";
            var i = he.queue(t, e), n = i.length, o = i.shift(), r = he._queueHooks(t, e), a = function() {
                he.dequeue(t, e);
            };
            "inprogress" === o && (o = i.shift(), n--), o && ("fx" === e && i.unshift("inprogress"), 
            delete r.stop, o.call(t, a, r)), !n && r && r.empty.fire();
        },
        _queueHooks: function(t, e) {
            var i = e + "queueHooks";
            return he._data(t, i) || he._data(t, i, {
                empty: he.Callbacks("once memory").add(function() {
                    he._removeData(t, e + "queue"), he._removeData(t, i);
                })
            });
        }
    }), he.fn.extend({
        queue: function(t, i) {
            var n = 2;
            return "string" != typeof t && (i = t, t = "fx", n--), n > arguments.length ? he.queue(this[0], t) : i === e ? this : this.each(function() {
                var e = he.queue(this, t, i);
                he._queueHooks(this, t), "fx" === t && "inprogress" !== e[0] && he.dequeue(this, t);
            });
        },
        dequeue: function(t) {
            return this.each(function() {
                he.dequeue(this, t);
            });
        },
        delay: function(t, e) {
            return t = he.fx ? he.fx.speeds[t] || t : t, e = e || "fx", this.queue(e, function(e, i) {
                var n = setTimeout(e, t);
                i.stop = function() {
                    clearTimeout(n);
                };
            });
        },
        clearQueue: function(t) {
            return this.queue(t || "fx", []);
        },
        promise: function(t, i) {
            var n, o = 1, r = he.Deferred(), a = this, s = this.length, l = function() {
                --o || r.resolveWith(a, [ a ]);
            };
            for ("string" != typeof t && (i = t, t = e), t = t || "fx"; s--; ) n = he._data(a[s], t + "queueHooks"), 
            n && n.empty && (o++, n.empty.add(l));
            return l(), r.promise(i);
        }
    });
    var Ne, Ie, Re = /[\t\r\n\f]/g, Oe = /\r/g, Me = /^(?:input|select|textarea|button|object)$/i, $e = /^(?:a|area)$/i, De = /^(?:checked|selected)$/i, Ae = he.support.getSetAttribute, He = he.support.input;
    he.fn.extend({
        attr: function(t, e) {
            return he.access(this, he.attr, t, e, arguments.length > 1);
        },
        removeAttr: function(t) {
            return this.each(function() {
                he.removeAttr(this, t);
            });
        },
        prop: function(t, e) {
            return he.access(this, he.prop, t, e, arguments.length > 1);
        },
        removeProp: function(t) {
            return t = he.propFix[t] || t, this.each(function() {
                try {
                    this[t] = e, delete this[t];
                } catch (i) {}
            });
        },
        addClass: function(t) {
            var e, i, n, o, r, a = 0, s = this.length, l = "string" == typeof t && t;
            if (he.isFunction(t)) return this.each(function(e) {
                he(this).addClass(t.call(this, e, this.className));
            });
            if (l) for (e = (t || "").match(ce) || []; s > a; a++) if (i = this[a], n = 1 === i.nodeType && (i.className ? (" " + i.className + " ").replace(Re, " ") : " ")) {
                for (r = 0; o = e[r++]; ) 0 > n.indexOf(" " + o + " ") && (n += o + " ");
                i.className = he.trim(n);
            }
            return this;
        },
        removeClass: function(t) {
            var e, i, n, o, r, a = 0, s = this.length, l = 0 === arguments.length || "string" == typeof t && t;
            if (he.isFunction(t)) return this.each(function(e) {
                he(this).removeClass(t.call(this, e, this.className));
            });
            if (l) for (e = (t || "").match(ce) || []; s > a; a++) if (i = this[a], n = 1 === i.nodeType && (i.className ? (" " + i.className + " ").replace(Re, " ") : "")) {
                for (r = 0; o = e[r++]; ) for (;n.indexOf(" " + o + " ") >= 0; ) n = n.replace(" " + o + " ", " ");
                i.className = t ? he.trim(n) : "";
            }
            return this;
        },
        toggleClass: function(t, e) {
            var i = typeof t;
            return "boolean" == typeof e && "string" === i ? e ? this.addClass(t) : this.removeClass(t) : he.isFunction(t) ? this.each(function(i) {
                he(this).toggleClass(t.call(this, i, this.className, e), e);
            }) : this.each(function() {
                if ("string" === i) for (var e, n = 0, o = he(this), r = t.match(ce) || []; e = r[n++]; ) o.hasClass(e) ? o.removeClass(e) : o.addClass(e); else (i === U || "boolean" === i) && (this.className && he._data(this, "__className__", this.className), 
                this.className = this.className || t === !1 ? "" : he._data(this, "__className__") || "");
            });
        },
        hasClass: function(t) {
            for (var e = " " + t + " ", i = 0, n = this.length; n > i; i++) if (1 === this[i].nodeType && (" " + this[i].className + " ").replace(Re, " ").indexOf(e) >= 0) return !0;
            return !1;
        },
        val: function(t) {
            var i, n, o, r = this[0];
            return arguments.length ? (o = he.isFunction(t), this.each(function(i) {
                var r;
                1 === this.nodeType && (r = o ? t.call(this, i, he(this).val()) : t, null == r ? r = "" : "number" == typeof r ? r += "" : he.isArray(r) && (r = he.map(r, function(t) {
                    return null == t ? "" : t + "";
                })), n = he.valHooks[this.type] || he.valHooks[this.nodeName.toLowerCase()], n && "set" in n && n.set(this, r, "value") !== e || (this.value = r));
            })) : r ? (n = he.valHooks[r.type] || he.valHooks[r.nodeName.toLowerCase()], n && "get" in n && (i = n.get(r, "value")) !== e ? i : (i = r.value, 
            "string" == typeof i ? i.replace(Oe, "") : null == i ? "" : i)) : void 0;
        }
    }), he.extend({
        valHooks: {
            option: {
                get: function(t) {
                    var e = he.find.attr(t, "value");
                    return null != e ? e : t.text;
                }
            },
            select: {
                get: function(t) {
                    for (var e, i, n = t.options, o = t.selectedIndex, r = "select-one" === t.type || 0 > o, a = r ? null : [], s = r ? o + 1 : n.length, l = 0 > o ? s : r ? o : 0; s > l; l++) if (i = n[l], 
                    !(!i.selected && l !== o || (he.support.optDisabled ? i.disabled : null !== i.getAttribute("disabled")) || i.parentNode.disabled && he.nodeName(i.parentNode, "optgroup"))) {
                        if (e = he(i).val(), r) return e;
                        a.push(e);
                    }
                    return a;
                },
                set: function(t, e) {
                    for (var i, n, o = t.options, r = he.makeArray(e), a = o.length; a--; ) n = o[a], 
                    (n.selected = he.inArray(he(n).val(), r) >= 0) && (i = !0);
                    return i || (t.selectedIndex = -1), r;
                }
            }
        },
        attr: function(t, i, n) {
            var o, r, a = t.nodeType;
            return t && 3 !== a && 8 !== a && 2 !== a ? typeof t.getAttribute === U ? he.prop(t, i, n) : (1 === a && he.isXMLDoc(t) || (i = i.toLowerCase(), 
            o = he.attrHooks[i] || (he.expr.match.bool.test(i) ? Ie : Ne)), n === e ? o && "get" in o && null !== (r = o.get(t, i)) ? r : (r = he.find.attr(t, i), 
            null == r ? e : r) : null !== n ? o && "set" in o && (r = o.set(t, n, i)) !== e ? r : (t.setAttribute(i, n + ""), 
            n) : (he.removeAttr(t, i), e)) : void 0;
        },
        removeAttr: function(t, e) {
            var i, n, o = 0, r = e && e.match(ce);
            if (r && 1 === t.nodeType) for (;i = r[o++]; ) n = he.propFix[i] || i, he.expr.match.bool.test(i) ? He && Ae || !De.test(i) ? t[n] = !1 : t[he.camelCase("default-" + i)] = t[n] = !1 : he.attr(t, i, ""), 
            t.removeAttribute(Ae ? i : n);
        },
        attrHooks: {
            type: {
                set: function(t, e) {
                    if (!he.support.radioValue && "radio" === e && he.nodeName(t, "input")) {
                        var i = t.value;
                        return t.setAttribute("type", e), i && (t.value = i), e;
                    }
                }
            }
        },
        propFix: {
            "for": "htmlFor",
            "class": "className"
        },
        prop: function(t, i, n) {
            var o, r, a, s = t.nodeType;
            return t && 3 !== s && 8 !== s && 2 !== s ? (a = 1 !== s || !he.isXMLDoc(t), a && (i = he.propFix[i] || i, 
            r = he.propHooks[i]), n !== e ? r && "set" in r && (o = r.set(t, n, i)) !== e ? o : t[i] = n : r && "get" in r && null !== (o = r.get(t, i)) ? o : t[i]) : void 0;
        },
        propHooks: {
            tabIndex: {
                get: function(t) {
                    var e = he.find.attr(t, "tabindex");
                    return e ? parseInt(e, 10) : Me.test(t.nodeName) || $e.test(t.nodeName) && t.href ? 0 : -1;
                }
            }
        }
    }), Ie = {
        set: function(t, e, i) {
            return e === !1 ? he.removeAttr(t, i) : He && Ae || !De.test(i) ? t.setAttribute(!Ae && he.propFix[i] || i, i) : t[he.camelCase("default-" + i)] = t[i] = !0, 
            i;
        }
    }, he.each(he.expr.match.bool.source.match(/\w+/g), function(t, i) {
        var n = he.expr.attrHandle[i] || he.find.attr;
        he.expr.attrHandle[i] = He && Ae || !De.test(i) ? function(t, i, o) {
            var r = he.expr.attrHandle[i], a = o ? e : (he.expr.attrHandle[i] = e) != n(t, i, o) ? i.toLowerCase() : null;
            return he.expr.attrHandle[i] = r, a;
        } : function(t, i, n) {
            return n ? e : t[he.camelCase("default-" + i)] ? i.toLowerCase() : null;
        };
    }), He && Ae || (he.attrHooks.value = {
        set: function(t, i, n) {
            return he.nodeName(t, "input") ? (t.defaultValue = i, e) : Ne && Ne.set(t, i, n);
        }
    }), Ae || (Ne = {
        set: function(t, i, n) {
            var o = t.getAttributeNode(n);
            return o || t.setAttributeNode(o = t.ownerDocument.createAttribute(n)), o.value = i += "", 
            "value" === n || i === t.getAttribute(n) ? i : e;
        }
    }, he.expr.attrHandle.id = he.expr.attrHandle.name = he.expr.attrHandle.coords = function(t, i, n) {
        var o;
        return n ? e : (o = t.getAttributeNode(i)) && "" !== o.value ? o.value : null;
    }, he.valHooks.button = {
        get: function(t, i) {
            var n = t.getAttributeNode(i);
            return n && n.specified ? n.value : e;
        },
        set: Ne.set
    }, he.attrHooks.contenteditable = {
        set: function(t, e, i) {
            Ne.set(t, "" === e ? !1 : e, i);
        }
    }, he.each([ "width", "height" ], function(t, i) {
        he.attrHooks[i] = {
            set: function(t, n) {
                return "" === n ? (t.setAttribute(i, "auto"), n) : e;
            }
        };
    })), he.support.hrefNormalized || he.each([ "href", "src" ], function(t, e) {
        he.propHooks[e] = {
            get: function(t) {
                return t.getAttribute(e, 4);
            }
        };
    }), he.support.style || (he.attrHooks.style = {
        get: function(t) {
            return t.style.cssText || e;
        },
        set: function(t, e) {
            return t.style.cssText = e + "";
        }
    }), he.support.optSelected || (he.propHooks.selected = {
        get: function(t) {
            var e = t.parentNode;
            return e && (e.selectedIndex, e.parentNode && e.parentNode.selectedIndex), null;
        }
    }), he.each([ "tabIndex", "readOnly", "maxLength", "cellSpacing", "cellPadding", "rowSpan", "colSpan", "useMap", "frameBorder", "contentEditable" ], function() {
        he.propFix[this.toLowerCase()] = this;
    }), he.support.enctype || (he.propFix.enctype = "encoding"), he.each([ "radio", "checkbox" ], function() {
        he.valHooks[this] = {
            set: function(t, i) {
                return he.isArray(i) ? t.checked = he.inArray(he(t).val(), i) >= 0 : e;
            }
        }, he.support.checkOn || (he.valHooks[this].get = function(t) {
            return null === t.getAttribute("value") ? "on" : t.value;
        });
    });
    var Ee = /^(?:input|select|textarea)$/i, Be = /^key/, Le = /^(?:mouse|contextmenu)|click/, _e = /^(?:focusinfocus|focusoutblur)$/, Fe = /^([^.]*)(?:\.(.+)|)$/;
    he.event = {
        global: {},
        add: function(t, i, n, o, r) {
            var a, s, l, p, h, m, c, d, u, f, k, g = he._data(t);
            if (g) {
                for (n.handler && (p = n, n = p.handler, r = p.selector), n.guid || (n.guid = he.guid++), 
                (s = g.events) || (s = g.events = {}), (m = g.handle) || (m = g.handle = function(t) {
                    return typeof he === U || t && he.event.triggered === t.type ? e : he.event.dispatch.apply(m.elem, arguments);
                }, m.elem = t), i = (i || "").match(ce) || [ "" ], l = i.length; l--; ) a = Fe.exec(i[l]) || [], 
                u = k = a[1], f = (a[2] || "").split(".").sort(), u && (h = he.event.special[u] || {}, 
                u = (r ? h.delegateType : h.bindType) || u, h = he.event.special[u] || {}, c = he.extend({
                    type: u,
                    origType: k,
                    data: o,
                    handler: n,
                    guid: n.guid,
                    selector: r,
                    needsContext: r && he.expr.match.needsContext.test(r),
                    namespace: f.join(".")
                }, p), (d = s[u]) || (d = s[u] = [], d.delegateCount = 0, h.setup && h.setup.call(t, o, f, m) !== !1 || (t.addEventListener ? t.addEventListener(u, m, !1) : t.attachEvent && t.attachEvent("on" + u, m))), 
                h.add && (h.add.call(t, c), c.handler.guid || (c.handler.guid = n.guid)), r ? d.splice(d.delegateCount++, 0, c) : d.push(c), 
                he.event.global[u] = !0);
                t = null;
            }
        },
        remove: function(t, e, i, n, o) {
            var r, a, s, l, p, h, m, c, d, u, f, k = he.hasData(t) && he._data(t);
            if (k && (h = k.events)) {
                for (e = (e || "").match(ce) || [ "" ], p = e.length; p--; ) if (s = Fe.exec(e[p]) || [], 
                d = f = s[1], u = (s[2] || "").split(".").sort(), d) {
                    for (m = he.event.special[d] || {}, d = (n ? m.delegateType : m.bindType) || d, 
                    c = h[d] || [], s = s[2] && RegExp("(^|\\.)" + u.join("\\.(?:.*\\.|)") + "(\\.|$)"), 
                    l = r = c.length; r--; ) a = c[r], !o && f !== a.origType || i && i.guid !== a.guid || s && !s.test(a.namespace) || n && n !== a.selector && ("**" !== n || !a.selector) || (c.splice(r, 1), 
                    a.selector && c.delegateCount--, m.remove && m.remove.call(t, a));
                    l && !c.length && (m.teardown && m.teardown.call(t, u, k.handle) !== !1 || he.removeEvent(t, d, k.handle), 
                    delete h[d]);
                } else for (d in h) he.event.remove(t, d + e[p], i, n, !0);
                he.isEmptyObject(h) && (delete k.handle, he._removeData(t, "events"));
            }
        },
        trigger: function(i, n, o, r) {
            var a, s, l, p, h, m, c, d = [ o || X ], u = le.call(i, "type") ? i.type : i, f = le.call(i, "namespace") ? i.namespace.split(".") : [];
            if (l = m = o = o || X, 3 !== o.nodeType && 8 !== o.nodeType && !_e.test(u + he.event.triggered) && (u.indexOf(".") >= 0 && (f = u.split("."), 
            u = f.shift(), f.sort()), s = 0 > u.indexOf(":") && "on" + u, i = i[he.expando] ? i : new he.Event(u, "object" == typeof i && i), 
            i.isTrigger = r ? 2 : 3, i.namespace = f.join("."), i.namespace_re = i.namespace ? RegExp("(^|\\.)" + f.join("\\.(?:.*\\.|)") + "(\\.|$)") : null, 
            i.result = e, i.target || (i.target = o), n = null == n ? [ i ] : he.makeArray(n, [ i ]), 
            h = he.event.special[u] || {}, r || !h.trigger || h.trigger.apply(o, n) !== !1)) {
                if (!r && !h.noBubble && !he.isWindow(o)) {
                    for (p = h.delegateType || u, _e.test(p + u) || (l = l.parentNode); l; l = l.parentNode) d.push(l), 
                    m = l;
                    m === (o.ownerDocument || X) && d.push(m.defaultView || m.parentWindow || t);
                }
                for (c = 0; (l = d[c++]) && !i.isPropagationStopped(); ) i.type = c > 1 ? p : h.bindType || u, 
                a = (he._data(l, "events") || {})[i.type] && he._data(l, "handle"), a && a.apply(l, n), 
                a = s && l[s], a && he.acceptData(l) && a.apply && a.apply(l, n) === !1 && i.preventDefault();
                if (i.type = u, !r && !i.isDefaultPrevented() && (!h._default || h._default.apply(d.pop(), n) === !1) && he.acceptData(o) && s && o[u] && !he.isWindow(o)) {
                    m = o[s], m && (o[s] = null), he.event.triggered = u;
                    try {
                        o[u]();
                    } catch (k) {}
                    he.event.triggered = e, m && (o[s] = m);
                }
                return i.result;
            }
        },
        dispatch: function(t) {
            t = he.event.fix(t);
            var i, n, o, r, a, s = [], l = re.call(arguments), p = (he._data(this, "events") || {})[t.type] || [], h = he.event.special[t.type] || {};
            if (l[0] = t, t.delegateTarget = this, !h.preDispatch || h.preDispatch.call(this, t) !== !1) {
                for (s = he.event.handlers.call(this, t, p), i = 0; (r = s[i++]) && !t.isPropagationStopped(); ) for (t.currentTarget = r.elem, 
                a = 0; (o = r.handlers[a++]) && !t.isImmediatePropagationStopped(); ) (!t.namespace_re || t.namespace_re.test(o.namespace)) && (t.handleObj = o, 
                t.data = o.data, n = ((he.event.special[o.origType] || {}).handle || o.handler).apply(r.elem, l), 
                n !== e && (t.result = n) === !1 && (t.preventDefault(), t.stopPropagation()));
                return h.postDispatch && h.postDispatch.call(this, t), t.result;
            }
        },
        handlers: function(t, i) {
            var n, o, r, a, s = [], l = i.delegateCount, p = t.target;
            if (l && p.nodeType && (!t.button || "click" !== t.type)) for (;p != this; p = p.parentNode || this) if (1 === p.nodeType && (p.disabled !== !0 || "click" !== t.type)) {
                for (r = [], a = 0; l > a; a++) o = i[a], n = o.selector + " ", r[n] === e && (r[n] = o.needsContext ? he(n, this).index(p) >= 0 : he.find(n, this, null, [ p ]).length), 
                r[n] && r.push(o);
                r.length && s.push({
                    elem: p,
                    handlers: r
                });
            }
            return i.length > l && s.push({
                elem: this,
                handlers: i.slice(l)
            }), s;
        },
        fix: function(t) {
            if (t[he.expando]) return t;
            var e, i, n, o = t.type, r = t, a = this.fixHooks[o];
            for (a || (this.fixHooks[o] = a = Le.test(o) ? this.mouseHooks : Be.test(o) ? this.keyHooks : {}), 
            n = a.props ? this.props.concat(a.props) : this.props, t = new he.Event(r), e = n.length; e--; ) i = n[e], 
            t[i] = r[i];
            return t.target || (t.target = r.srcElement || X), 3 === t.target.nodeType && (t.target = t.target.parentNode), 
            t.metaKey = !!t.metaKey, a.filter ? a.filter(t, r) : t;
        },
        props: "altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "),
        fixHooks: {},
        keyHooks: {
            props: "char charCode key keyCode".split(" "),
            filter: function(t, e) {
                return null == t.which && (t.which = null != e.charCode ? e.charCode : e.keyCode), 
                t;
            }
        },
        mouseHooks: {
            props: "button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement".split(" "),
            filter: function(t, i) {
                var n, o, r, a = i.button, s = i.fromElement;
                return null == t.pageX && null != i.clientX && (o = t.target.ownerDocument || X, 
                r = o.documentElement, n = o.body, t.pageX = i.clientX + (r && r.scrollLeft || n && n.scrollLeft || 0) - (r && r.clientLeft || n && n.clientLeft || 0), 
                t.pageY = i.clientY + (r && r.scrollTop || n && n.scrollTop || 0) - (r && r.clientTop || n && n.clientTop || 0)), 
                !t.relatedTarget && s && (t.relatedTarget = s === t.target ? i.toElement : s), t.which || a === e || (t.which = 1 & a ? 1 : 2 & a ? 3 : 4 & a ? 2 : 0), 
                t;
            }
        },
        special: {
            load: {
                noBubble: !0
            },
            focus: {
                trigger: function() {
                    if (this !== h() && this.focus) try {
                        return this.focus(), !1;
                    } catch (t) {}
                },
                delegateType: "focusin"
            },
            blur: {
                trigger: function() {
                    return this === h() && this.blur ? (this.blur(), !1) : e;
                },
                delegateType: "focusout"
            },
            click: {
                trigger: function() {
                    return he.nodeName(this, "input") && "checkbox" === this.type && this.click ? (this.click(), 
                    !1) : e;
                },
                _default: function(t) {
                    return he.nodeName(t.target, "a");
                }
            },
            beforeunload: {
                postDispatch: function(t) {
                    t.result !== e && (t.originalEvent.returnValue = t.result);
                }
            }
        },
        simulate: function(t, e, i, n) {
            var o = he.extend(new he.Event(), i, {
                type: t,
                isSimulated: !0,
                originalEvent: {}
            });
            n ? he.event.trigger(o, null, e) : he.event.dispatch.call(e, o), o.isDefaultPrevented() && i.preventDefault();
        }
    }, he.removeEvent = X.removeEventListener ? function(t, e, i) {
        t.removeEventListener && t.removeEventListener(e, i, !1);
    } : function(t, e, i) {
        var n = "on" + e;
        t.detachEvent && (typeof t[n] === U && (t[n] = null), t.detachEvent(n, i));
    }, he.Event = function(t, i) {
        return this instanceof he.Event ? (t && t.type ? (this.originalEvent = t, this.type = t.type, 
        this.isDefaultPrevented = t.defaultPrevented || t.returnValue === !1 || t.getPreventDefault && t.getPreventDefault() ? l : p) : this.type = t, 
        i && he.extend(this, i), this.timeStamp = t && t.timeStamp || he.now(), this[he.expando] = !0, 
        e) : new he.Event(t, i);
    }, he.Event.prototype = {
        isDefaultPrevented: p,
        isPropagationStopped: p,
        isImmediatePropagationStopped: p,
        preventDefault: function() {
            var t = this.originalEvent;
            this.isDefaultPrevented = l, t && (t.preventDefault ? t.preventDefault() : t.returnValue = !1);
        },
        stopPropagation: function() {
            var t = this.originalEvent;
            this.isPropagationStopped = l, t && (t.stopPropagation && t.stopPropagation(), t.cancelBubble = !0);
        },
        stopImmediatePropagation: function() {
            this.isImmediatePropagationStopped = l, this.stopPropagation();
        }
    }, he.each({
        mouseenter: "mouseover",
        mouseleave: "mouseout"
    }, function(t, e) {
        he.event.special[t] = {
            delegateType: e,
            bindType: e,
            handle: function(t) {
                var i, n = this, o = t.relatedTarget, r = t.handleObj;
                return (!o || o !== n && !he.contains(n, o)) && (t.type = r.origType, i = r.handler.apply(this, arguments), 
                t.type = e), i;
            }
        };
    }), he.support.submitBubbles || (he.event.special.submit = {
        setup: function() {
            return he.nodeName(this, "form") ? !1 : (he.event.add(this, "click._submit keypress._submit", function(t) {
                var i = t.target, n = he.nodeName(i, "input") || he.nodeName(i, "button") ? i.form : e;
                n && !he._data(n, "submitBubbles") && (he.event.add(n, "submit._submit", function(t) {
                    t._submit_bubble = !0;
                }), he._data(n, "submitBubbles", !0));
            }), e);
        },
        postDispatch: function(t) {
            t._submit_bubble && (delete t._submit_bubble, this.parentNode && !t.isTrigger && he.event.simulate("submit", this.parentNode, t, !0));
        },
        teardown: function() {
            return he.nodeName(this, "form") ? !1 : (he.event.remove(this, "._submit"), e);
        }
    }), he.support.changeBubbles || (he.event.special.change = {
        setup: function() {
            return Ee.test(this.nodeName) ? (("checkbox" === this.type || "radio" === this.type) && (he.event.add(this, "propertychange._change", function(t) {
                "checked" === t.originalEvent.propertyName && (this._just_changed = !0);
            }), he.event.add(this, "click._change", function(t) {
                this._just_changed && !t.isTrigger && (this._just_changed = !1), he.event.simulate("change", this, t, !0);
            })), !1) : (he.event.add(this, "beforeactivate._change", function(t) {
                var e = t.target;
                Ee.test(e.nodeName) && !he._data(e, "changeBubbles") && (he.event.add(e, "change._change", function(t) {
                    !this.parentNode || t.isSimulated || t.isTrigger || he.event.simulate("change", this.parentNode, t, !0);
                }), he._data(e, "changeBubbles", !0));
            }), e);
        },
        handle: function(t) {
            var i = t.target;
            return this !== i || t.isSimulated || t.isTrigger || "radio" !== i.type && "checkbox" !== i.type ? t.handleObj.handler.apply(this, arguments) : e;
        },
        teardown: function() {
            return he.event.remove(this, "._change"), !Ee.test(this.nodeName);
        }
    }), he.support.focusinBubbles || he.each({
        focus: "focusin",
        blur: "focusout"
    }, function(t, e) {
        var i = 0, n = function(t) {
            he.event.simulate(e, t.target, he.event.fix(t), !0);
        };
        he.event.special[e] = {
            setup: function() {
                0 === i++ && X.addEventListener(t, n, !0);
            },
            teardown: function() {
                0 === --i && X.removeEventListener(t, n, !0);
            }
        };
    }), he.fn.extend({
        on: function(t, i, n, o, r) {
            var a, s;
            if ("object" == typeof t) {
                "string" != typeof i && (n = n || i, i = e);
                for (a in t) this.on(a, i, n, t[a], r);
                return this;
            }
            if (null == n && null == o ? (o = i, n = i = e) : null == o && ("string" == typeof i ? (o = n, 
            n = e) : (o = n, n = i, i = e)), o === !1) o = p; else if (!o) return this;
            return 1 === r && (s = o, o = function(t) {
                return he().off(t), s.apply(this, arguments);
            }, o.guid = s.guid || (s.guid = he.guid++)), this.each(function() {
                he.event.add(this, t, o, n, i);
            });
        },
        one: function(t, e, i, n) {
            return this.on(t, e, i, n, 1);
        },
        off: function(t, i, n) {
            var o, r;
            if (t && t.preventDefault && t.handleObj) return o = t.handleObj, he(t.delegateTarget).off(o.namespace ? o.origType + "." + o.namespace : o.origType, o.selector, o.handler), 
            this;
            if ("object" == typeof t) {
                for (r in t) this.off(r, i, t[r]);
                return this;
            }
            return (i === !1 || "function" == typeof i) && (n = i, i = e), n === !1 && (n = p), 
            this.each(function() {
                he.event.remove(this, t, n, i);
            });
        },
        trigger: function(t, e) {
            return this.each(function() {
                he.event.trigger(t, e, this);
            });
        },
        triggerHandler: function(t, i) {
            var n = this[0];
            return n ? he.event.trigger(t, i, n, !0) : e;
        }
    });
    var ze = /^.[^:#\[\.,]*$/, We = /^(?:parents|prev(?:Until|All))/, je = he.expr.match.needsContext, Ve = {
        children: !0,
        contents: !0,
        next: !0,
        prev: !0
    };
    he.fn.extend({
        find: function(t) {
            var e, i = [], n = this, o = n.length;
            if ("string" != typeof t) return this.pushStack(he(t).filter(function() {
                for (e = 0; o > e; e++) if (he.contains(n[e], this)) return !0;
            }));
            for (e = 0; o > e; e++) he.find(t, n[e], i);
            return i = this.pushStack(o > 1 ? he.unique(i) : i), i.selector = this.selector ? this.selector + " " + t : t, 
            i;
        },
        has: function(t) {
            var e, i = he(t, this), n = i.length;
            return this.filter(function() {
                for (e = 0; n > e; e++) if (he.contains(this, i[e])) return !0;
            });
        },
        not: function(t) {
            return this.pushStack(c(this, t || [], !0));
        },
        filter: function(t) {
            return this.pushStack(c(this, t || [], !1));
        },
        is: function(t) {
            return !!c(this, "string" == typeof t && je.test(t) ? he(t) : t || [], !1).length;
        },
        closest: function(t, e) {
            for (var i, n = 0, o = this.length, r = [], a = je.test(t) || "string" != typeof t ? he(t, e || this.context) : 0; o > n; n++) for (i = this[n]; i && i !== e; i = i.parentNode) if (11 > i.nodeType && (a ? a.index(i) > -1 : 1 === i.nodeType && he.find.matchesSelector(i, t))) {
                i = r.push(i);
                break;
            }
            return this.pushStack(r.length > 1 ? he.unique(r) : r);
        },
        index: function(t) {
            return t ? "string" == typeof t ? he.inArray(this[0], he(t)) : he.inArray(t.jquery ? t[0] : t, this) : this[0] && this[0].parentNode ? this.first().prevAll().length : -1;
        },
        add: function(t, e) {
            var i = "string" == typeof t ? he(t, e) : he.makeArray(t && t.nodeType ? [ t ] : t), n = he.merge(this.get(), i);
            return this.pushStack(he.unique(n));
        },
        addBack: function(t) {
            return this.add(null == t ? this.prevObject : this.prevObject.filter(t));
        }
    }), he.each({
        parent: function(t) {
            var e = t.parentNode;
            return e && 11 !== e.nodeType ? e : null;
        },
        parents: function(t) {
            return he.dir(t, "parentNode");
        },
        parentsUntil: function(t, e, i) {
            return he.dir(t, "parentNode", i);
        },
        next: function(t) {
            return m(t, "nextSibling");
        },
        prev: function(t) {
            return m(t, "previousSibling");
        },
        nextAll: function(t) {
            return he.dir(t, "nextSibling");
        },
        prevAll: function(t) {
            return he.dir(t, "previousSibling");
        },
        nextUntil: function(t, e, i) {
            return he.dir(t, "nextSibling", i);
        },
        prevUntil: function(t, e, i) {
            return he.dir(t, "previousSibling", i);
        },
        siblings: function(t) {
            return he.sibling((t.parentNode || {}).firstChild, t);
        },
        children: function(t) {
            return he.sibling(t.firstChild);
        },
        contents: function(t) {
            return he.nodeName(t, "iframe") ? t.contentDocument || t.contentWindow.document : he.merge([], t.childNodes);
        }
    }, function(t, e) {
        he.fn[t] = function(i, n) {
            var o = he.map(this, e, i);
            return "Until" !== t.slice(-5) && (n = i), n && "string" == typeof n && (o = he.filter(n, o)), 
            this.length > 1 && (Ve[t] || (o = he.unique(o)), We.test(t) && (o = o.reverse())), 
            this.pushStack(o);
        };
    }), he.extend({
        filter: function(t, e, i) {
            var n = e[0];
            return i && (t = ":not(" + t + ")"), 1 === e.length && 1 === n.nodeType ? he.find.matchesSelector(n, t) ? [ n ] : [] : he.find.matches(t, he.grep(e, function(t) {
                return 1 === t.nodeType;
            }));
        },
        dir: function(t, i, n) {
            for (var o = [], r = t[i]; r && 9 !== r.nodeType && (n === e || 1 !== r.nodeType || !he(r).is(n)); ) 1 === r.nodeType && o.push(r), 
            r = r[i];
            return o;
        },
        sibling: function(t, e) {
            for (var i = []; t; t = t.nextSibling) 1 === t.nodeType && t !== e && i.push(t);
            return i;
        }
    });
    var qe = "abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|header|hgroup|mark|meter|nav|output|progress|section|summary|time|video", Ke = / jQuery\d+="(?:null|\d+)"/g, Ue = RegExp("<(?:" + qe + ")[\\s/>]", "i"), Ge = /^\s+/, Xe = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi, Ye = /<([\w:]+)/, Je = /<tbody/i, Qe = /<|&#?\w+;/, ti = /<(?:script|style|link)/i, ei = /^(?:checkbox|radio)$/i, ii = /checked\s*(?:[^=]|=\s*.checked.)/i, ni = /^$|\/(?:java|ecma)script/i, oi = /^true\/(.*)/, ri = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g, ai = {
        option: [ 1, "<select multiple='multiple'>", "</select>" ],
        legend: [ 1, "<fieldset>", "</fieldset>" ],
        area: [ 1, "<map>", "</map>" ],
        param: [ 1, "<object>", "</object>" ],
        thead: [ 1, "<table>", "</table>" ],
        tr: [ 2, "<table><tbody>", "</tbody></table>" ],
        col: [ 2, "<table><tbody></tbody><colgroup>", "</colgroup></table>" ],
        td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],
        _default: he.support.htmlSerialize ? [ 0, "", "" ] : [ 1, "X<div>", "</div>" ]
    }, si = d(X), li = si.appendChild(X.createElement("div"));
    ai.optgroup = ai.option, ai.tbody = ai.tfoot = ai.colgroup = ai.caption = ai.thead, 
    ai.th = ai.td, he.fn.extend({
        text: function(t) {
            return he.access(this, function(t) {
                return t === e ? he.text(this) : this.empty().append((this[0] && this[0].ownerDocument || X).createTextNode(t));
            }, null, t, arguments.length);
        },
        append: function() {
            return this.domManip(arguments, function(t) {
                if (1 === this.nodeType || 11 === this.nodeType || 9 === this.nodeType) {
                    var e = u(this, t);
                    e.appendChild(t);
                }
            });
        },
        prepend: function() {
            return this.domManip(arguments, function(t) {
                if (1 === this.nodeType || 11 === this.nodeType || 9 === this.nodeType) {
                    var e = u(this, t);
                    e.insertBefore(t, e.firstChild);
                }
            });
        },
        before: function() {
            return this.domManip(arguments, function(t) {
                this.parentNode && this.parentNode.insertBefore(t, this);
            });
        },
        after: function() {
            return this.domManip(arguments, function(t) {
                this.parentNode && this.parentNode.insertBefore(t, this.nextSibling);
            });
        },
        remove: function(t, e) {
            for (var i, n = t ? he.filter(t, this) : this, o = 0; null != (i = n[o]); o++) e || 1 !== i.nodeType || he.cleanData(v(i)), 
            i.parentNode && (e && he.contains(i.ownerDocument, i) && g(v(i, "script")), i.parentNode.removeChild(i));
            return this;
        },
        empty: function() {
            for (var t, e = 0; null != (t = this[e]); e++) {
                for (1 === t.nodeType && he.cleanData(v(t, !1)); t.firstChild; ) t.removeChild(t.firstChild);
                t.options && he.nodeName(t, "select") && (t.options.length = 0);
            }
            return this;
        },
        clone: function(t, e) {
            return t = null == t ? !1 : t, e = null == e ? t : e, this.map(function() {
                return he.clone(this, t, e);
            });
        },
        html: function(t) {
            return he.access(this, function(t) {
                var i = this[0] || {}, n = 0, o = this.length;
                if (t === e) return 1 === i.nodeType ? i.innerHTML.replace(Ke, "") : e;
                if (!("string" != typeof t || ti.test(t) || !he.support.htmlSerialize && Ue.test(t) || !he.support.leadingWhitespace && Ge.test(t) || ai[(Ye.exec(t) || [ "", "" ])[1].toLowerCase()])) {
                    t = t.replace(Xe, "<$1></$2>");
                    try {
                        for (;o > n; n++) i = this[n] || {}, 1 === i.nodeType && (he.cleanData(v(i, !1)), 
                        i.innerHTML = t);
                        i = 0;
                    } catch (r) {}
                }
                i && this.empty().append(t);
            }, null, t, arguments.length);
        },
        replaceWith: function() {
            var t = he.map(this, function(t) {
                return [ t.nextSibling, t.parentNode ];
            }), e = 0;
            return this.domManip(arguments, function(i) {
                var n = t[e++], o = t[e++];
                o && (n && n.parentNode !== o && (n = this.nextSibling), he(this).remove(), o.insertBefore(i, n));
            }, !0), e ? this : this.remove();
        },
        detach: function(t) {
            return this.remove(t, !0);
        },
        domManip: function(t, e, i) {
            t = ne.apply([], t);
            var n, o, r, a, s, l, p = 0, h = this.length, m = this, c = h - 1, d = t[0], u = he.isFunction(d);
            if (u || !(1 >= h || "string" != typeof d || he.support.checkClone) && ii.test(d)) return this.each(function(n) {
                var o = m.eq(n);
                u && (t[0] = d.call(this, n, o.html())), o.domManip(t, e, i);
            });
            if (h && (l = he.buildFragment(t, this[0].ownerDocument, !1, !i && this), n = l.firstChild, 
            1 === l.childNodes.length && (l = n), n)) {
                for (a = he.map(v(l, "script"), f), r = a.length; h > p; p++) o = l, p !== c && (o = he.clone(o, !0, !0), 
                r && he.merge(a, v(o, "script"))), e.call(this[p], o, p);
                if (r) for (s = a[a.length - 1].ownerDocument, he.map(a, k), p = 0; r > p; p++) o = a[p], 
                ni.test(o.type || "") && !he._data(o, "globalEval") && he.contains(s, o) && (o.src ? he._evalUrl(o.src) : he.globalEval((o.text || o.textContent || o.innerHTML || "").replace(ri, "")));
                l = n = null;
            }
            return this;
        }
    }), he.each({
        appendTo: "append",
        prependTo: "prepend",
        insertBefore: "before",
        insertAfter: "after",
        replaceAll: "replaceWith"
    }, function(t, e) {
        he.fn[t] = function(t) {
            for (var i, n = 0, o = [], r = he(t), a = r.length - 1; a >= n; n++) i = n === a ? this : this.clone(!0), 
            he(r[n])[e](i), oe.apply(o, i.get());
            return this.pushStack(o);
        };
    }), he.extend({
        clone: function(t, e, i) {
            var n, o, r, a, s, l = he.contains(t.ownerDocument, t);
            if (he.support.html5Clone || he.isXMLDoc(t) || !Ue.test("<" + t.nodeName + ">") ? r = t.cloneNode(!0) : (li.innerHTML = t.outerHTML, 
            li.removeChild(r = li.firstChild)), !(he.support.noCloneEvent && he.support.noCloneChecked || 1 !== t.nodeType && 11 !== t.nodeType || he.isXMLDoc(t))) for (n = v(r), 
            s = v(t), a = 0; null != (o = s[a]); ++a) n[a] && y(o, n[a]);
            if (e) if (i) for (s = s || v(t), n = n || v(r), a = 0; null != (o = s[a]); a++) T(o, n[a]); else T(t, r);
            return n = v(r, "script"), n.length > 0 && g(n, !l && v(t, "script")), n = s = o = null, 
            r;
        },
        buildFragment: function(t, e, i, n) {
            for (var o, r, a, s, l, p, h, m = t.length, c = d(e), u = [], f = 0; m > f; f++) if (r = t[f], 
            r || 0 === r) if ("object" === he.type(r)) he.merge(u, r.nodeType ? [ r ] : r); else if (Qe.test(r)) {
                for (s = s || c.appendChild(e.createElement("div")), l = (Ye.exec(r) || [ "", "" ])[1].toLowerCase(), 
                h = ai[l] || ai._default, s.innerHTML = h[1] + r.replace(Xe, "<$1></$2>") + h[2], 
                o = h[0]; o--; ) s = s.lastChild;
                if (!he.support.leadingWhitespace && Ge.test(r) && u.push(e.createTextNode(Ge.exec(r)[0])), 
                !he.support.tbody) for (r = "table" !== l || Je.test(r) ? "<table>" !== h[1] || Je.test(r) ? 0 : s : s.firstChild, 
                o = r && r.childNodes.length; o--; ) he.nodeName(p = r.childNodes[o], "tbody") && !p.childNodes.length && r.removeChild(p);
                for (he.merge(u, s.childNodes), s.textContent = ""; s.firstChild; ) s.removeChild(s.firstChild);
                s = c.lastChild;
            } else u.push(e.createTextNode(r));
            for (s && c.removeChild(s), he.support.appendChecked || he.grep(v(u, "input"), Z), 
            f = 0; r = u[f++]; ) if ((!n || -1 === he.inArray(r, n)) && (a = he.contains(r.ownerDocument, r), 
            s = v(c.appendChild(r), "script"), a && g(s), i)) for (o = 0; r = s[o++]; ) ni.test(r.type || "") && i.push(r);
            return s = null, c;
        },
        cleanData: function(t, e) {
            for (var i, n, o, r, a = 0, s = he.expando, l = he.cache, p = he.support.deleteExpando, h = he.event.special; null != (i = t[a]); a++) if ((e || he.acceptData(i)) && (o = i[s], 
            r = o && l[o])) {
                if (r.events) for (n in r.events) h[n] ? he.event.remove(i, n) : he.removeEvent(i, n, r.handle);
                l[o] && (delete l[o], p ? delete i[s] : typeof i.removeAttribute !== U ? i.removeAttribute(s) : i[s] = null, 
                ee.push(o));
            }
        },
        _evalUrl: function(t) {
            return he.ajax({
                url: t,
                type: "GET",
                dataType: "script",
                async: !1,
                global: !1,
                "throws": !0
            });
        }
    }), he.fn.extend({
        wrapAll: function(t) {
            if (he.isFunction(t)) return this.each(function(e) {
                he(this).wrapAll(t.call(this, e));
            });
            if (this[0]) {
                var e = he(t, this[0].ownerDocument).eq(0).clone(!0);
                this[0].parentNode && e.insertBefore(this[0]), e.map(function() {
                    for (var t = this; t.firstChild && 1 === t.firstChild.nodeType; ) t = t.firstChild;
                    return t;
                }).append(this);
            }
            return this;
        },
        wrapInner: function(t) {
            return he.isFunction(t) ? this.each(function(e) {
                he(this).wrapInner(t.call(this, e));
            }) : this.each(function() {
                var e = he(this), i = e.contents();
                i.length ? i.wrapAll(t) : e.append(t);
            });
        },
        wrap: function(t) {
            var e = he.isFunction(t);
            return this.each(function(i) {
                he(this).wrapAll(e ? t.call(this, i) : t);
            });
        },
        unwrap: function() {
            return this.parent().each(function() {
                he.nodeName(this, "body") || he(this).replaceWith(this.childNodes);
            }).end();
        }
    });
    var pi, hi, mi, ci = /alpha\([^)]*\)/i, di = /opacity\s*=\s*([^)]*)/, ui = /^(top|right|bottom|left)$/, fi = /^(none|table(?!-c[ea]).+)/, ki = /^margin/, gi = RegExp("^(" + me + ")(.*)$", "i"), Ti = RegExp("^(" + me + ")(?!px)[a-z%]+$", "i"), yi = RegExp("^([+-])=(" + me + ")", "i"), vi = {
        BODY: "block"
    }, Zi = {
        position: "absolute",
        visibility: "hidden",
        display: "block"
    }, wi = {
        letterSpacing: 0,
        fontWeight: 400
    }, bi = [ "Top", "Right", "Bottom", "Left" ], xi = [ "Webkit", "O", "Moz", "ms" ];
    he.fn.extend({
        css: function(t, i) {
            return he.access(this, function(t, i, n) {
                var o, r, a = {}, s = 0;
                if (he.isArray(i)) {
                    for (r = hi(t), o = i.length; o > s; s++) a[i[s]] = he.css(t, i[s], !1, r);
                    return a;
                }
                return n !== e ? he.style(t, i, n) : he.css(t, i);
            }, t, i, arguments.length > 1);
        },
        show: function() {
            return x(this, !0);
        },
        hide: function() {
            return x(this);
        },
        toggle: function(t) {
            return "boolean" == typeof t ? t ? this.show() : this.hide() : this.each(function() {
                b(this) ? he(this).show() : he(this).hide();
            });
        }
    }), he.extend({
        cssHooks: {
            opacity: {
                get: function(t, e) {
                    if (e) {
                        var i = mi(t, "opacity");
                        return "" === i ? "1" : i;
                    }
                }
            }
        },
        cssNumber: {
            columnCount: !0,
            fillOpacity: !0,
            fontWeight: !0,
            lineHeight: !0,
            opacity: !0,
            order: !0,
            orphans: !0,
            widows: !0,
            zIndex: !0,
            zoom: !0
        },
        cssProps: {
            "float": he.support.cssFloat ? "cssFloat" : "styleFloat"
        },
        style: function(t, i, n, o) {
            if (t && 3 !== t.nodeType && 8 !== t.nodeType && t.style) {
                var r, a, s, l = he.camelCase(i), p = t.style;
                if (i = he.cssProps[l] || (he.cssProps[l] = w(p, l)), s = he.cssHooks[i] || he.cssHooks[l], 
                n === e) return s && "get" in s && (r = s.get(t, !1, o)) !== e ? r : p[i];
                if (a = typeof n, "string" === a && (r = yi.exec(n)) && (n = (r[1] + 1) * r[2] + parseFloat(he.css(t, i)), 
                a = "number"), !(null == n || "number" === a && isNaN(n) || ("number" !== a || he.cssNumber[l] || (n += "px"), 
                he.support.clearCloneStyle || "" !== n || 0 !== i.indexOf("background") || (p[i] = "inherit"), 
                s && "set" in s && (n = s.set(t, n, o)) === e))) try {
                    p[i] = n;
                } catch (h) {}
            }
        },
        css: function(t, i, n, o) {
            var r, a, s, l = he.camelCase(i);
            return i = he.cssProps[l] || (he.cssProps[l] = w(t.style, l)), s = he.cssHooks[i] || he.cssHooks[l], 
            s && "get" in s && (a = s.get(t, !0, n)), a === e && (a = mi(t, i, o)), "normal" === a && i in wi && (a = wi[i]), 
            "" === n || n ? (r = parseFloat(a), n === !0 || he.isNumeric(r) ? r || 0 : a) : a;
        }
    }), t.getComputedStyle ? (hi = function(e) {
        return t.getComputedStyle(e, null);
    }, mi = function(t, i, n) {
        var o, r, a, s = n || hi(t), l = s ? s.getPropertyValue(i) || s[i] : e, p = t.style;
        return s && ("" !== l || he.contains(t.ownerDocument, t) || (l = he.style(t, i)), 
        Ti.test(l) && ki.test(i) && (o = p.width, r = p.minWidth, a = p.maxWidth, p.minWidth = p.maxWidth = p.width = l, 
        l = s.width, p.width = o, p.minWidth = r, p.maxWidth = a)), l;
    }) : X.documentElement.currentStyle && (hi = function(t) {
        return t.currentStyle;
    }, mi = function(t, i, n) {
        var o, r, a, s = n || hi(t), l = s ? s[i] : e, p = t.style;
        return null == l && p && p[i] && (l = p[i]), Ti.test(l) && !ui.test(i) && (o = p.left, 
        r = t.runtimeStyle, a = r && r.left, a && (r.left = t.currentStyle.left), p.left = "fontSize" === i ? "1em" : l, 
        l = p.pixelLeft + "px", p.left = o, a && (r.left = a)), "" === l ? "auto" : l;
    }), he.each([ "height", "width" ], function(t, i) {
        he.cssHooks[i] = {
            get: function(t, n, o) {
                return n ? 0 === t.offsetWidth && fi.test(he.css(t, "display")) ? he.swap(t, Zi, function() {
                    return P(t, i, o);
                }) : P(t, i, o) : e;
            },
            set: function(t, e, n) {
                var o = n && hi(t);
                return C(t, e, n ? S(t, i, n, he.support.boxSizing && "border-box" === he.css(t, "boxSizing", !1, o), o) : 0);
            }
        };
    }), he.support.opacity || (he.cssHooks.opacity = {
        get: function(t, e) {
            return di.test((e && t.currentStyle ? t.currentStyle.filter : t.style.filter) || "") ? .01 * parseFloat(RegExp.$1) + "" : e ? "1" : "";
        },
        set: function(t, e) {
            var i = t.style, n = t.currentStyle, o = he.isNumeric(e) ? "alpha(opacity=" + 100 * e + ")" : "", r = n && n.filter || i.filter || "";
            i.zoom = 1, (e >= 1 || "" === e) && "" === he.trim(r.replace(ci, "")) && i.removeAttribute && (i.removeAttribute("filter"), 
            "" === e || n && !n.filter) || (i.filter = ci.test(r) ? r.replace(ci, o) : r + " " + o);
        }
    }), he(function() {
        he.support.reliableMarginRight || (he.cssHooks.marginRight = {
            get: function(t, i) {
                return i ? he.swap(t, {
                    display: "inline-block"
                }, mi, [ t, "marginRight" ]) : e;
            }
        }), !he.support.pixelPosition && he.fn.position && he.each([ "top", "left" ], function(t, i) {
            he.cssHooks[i] = {
                get: function(t, n) {
                    return n ? (n = mi(t, i), Ti.test(n) ? he(t).position()[i] + "px" : n) : e;
                }
            };
        });
    }), he.expr && he.expr.filters && (he.expr.filters.hidden = function(t) {
        return 0 >= t.offsetWidth && 0 >= t.offsetHeight || !he.support.reliableHiddenOffsets && "none" === (t.style && t.style.display || he.css(t, "display"));
    }, he.expr.filters.visible = function(t) {
        return !he.expr.filters.hidden(t);
    }), he.each({
        margin: "",
        padding: "",
        border: "Width"
    }, function(t, e) {
        he.cssHooks[t + e] = {
            expand: function(i) {
                for (var n = 0, o = {}, r = "string" == typeof i ? i.split(" ") : [ i ]; 4 > n; n++) o[t + bi[n] + e] = r[n] || r[n - 2] || r[0];
                return o;
            }
        }, ki.test(t) || (he.cssHooks[t + e].set = C);
    });
    var Ci = /%20/g, Si = /\[\]$/, Pi = /\r?\n/g, Ni = /^(?:submit|button|image|reset|file)$/i, Ii = /^(?:input|select|textarea|keygen)/i;
    he.fn.extend({
        serialize: function() {
            return he.param(this.serializeArray());
        },
        serializeArray: function() {
            return this.map(function() {
                var t = he.prop(this, "elements");
                return t ? he.makeArray(t) : this;
            }).filter(function() {
                var t = this.type;
                return this.name && !he(this).is(":disabled") && Ii.test(this.nodeName) && !Ni.test(t) && (this.checked || !ei.test(t));
            }).map(function(t, e) {
                var i = he(this).val();
                return null == i ? null : he.isArray(i) ? he.map(i, function(t) {
                    return {
                        name: e.name,
                        value: t.replace(Pi, "\r\n")
                    };
                }) : {
                    name: e.name,
                    value: i.replace(Pi, "\r\n")
                };
            }).get();
        }
    }), he.param = function(t, i) {
        var n, o = [], r = function(t, e) {
            e = he.isFunction(e) ? e() : null == e ? "" : e, o[o.length] = encodeURIComponent(t) + "=" + encodeURIComponent(e);
        };
        if (i === e && (i = he.ajaxSettings && he.ajaxSettings.traditional), he.isArray(t) || t.jquery && !he.isPlainObject(t)) he.each(t, function() {
            r(this.name, this.value);
        }); else for (n in t) R(n, t[n], i, r);
        return o.join("&").replace(Ci, "+");
    }, he.each("blur focus focusin focusout load resize scroll unload click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup error contextmenu".split(" "), function(t, e) {
        he.fn[e] = function(t, i) {
            return arguments.length > 0 ? this.on(e, null, t, i) : this.trigger(e);
        };
    }), he.fn.extend({
        hover: function(t, e) {
            return this.mouseenter(t).mouseleave(e || t);
        },
        bind: function(t, e, i) {
            return this.on(t, null, e, i);
        },
        unbind: function(t, e) {
            return this.off(t, null, e);
        },
        delegate: function(t, e, i, n) {
            return this.on(e, t, i, n);
        },
        undelegate: function(t, e, i) {
            return 1 === arguments.length ? this.off(t, "**") : this.off(e, t || "**", i);
        }
    });
    var Ri, Oi, Mi = he.now(), $i = /\?/, Di = /#.*$/, Ai = /([?&])_=[^&]*/, Hi = /^(.*?):[ \t]*([^\r\n]*)\r?$/gm, Ei = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/, Bi = /^(?:GET|HEAD)$/, Li = /^\/\//, _i = /^([\w.+-]+:)(?:\/\/([^\/?#:]*)(?::(\d+)|)|)/, Fi = he.fn.load, zi = {}, Wi = {}, ji = "*/".concat("*");
    try {
        Oi = G.href;
    } catch (Vi) {
        Oi = X.createElement("a"), Oi.href = "", Oi = Oi.href;
    }
    Ri = _i.exec(Oi.toLowerCase()) || [], he.fn.load = function(t, i, n) {
        if ("string" != typeof t && Fi) return Fi.apply(this, arguments);
        var o, r, a, s = this, l = t.indexOf(" ");
        return l >= 0 && (o = t.slice(l, t.length), t = t.slice(0, l)), he.isFunction(i) ? (n = i, 
        i = e) : i && "object" == typeof i && (a = "POST"), s.length > 0 && he.ajax({
            url: t,
            type: a,
            dataType: "html",
            data: i
        }).done(function(t) {
            r = arguments, s.html(o ? he("<div>").append(he.parseHTML(t)).find(o) : t);
        }).complete(n && function(t, e) {
            s.each(n, r || [ t.responseText, e, t ]);
        }), this;
    }, he.each([ "ajaxStart", "ajaxStop", "ajaxComplete", "ajaxError", "ajaxSuccess", "ajaxSend" ], function(t, e) {
        he.fn[e] = function(t) {
            return this.on(e, t);
        };
    }), he.extend({
        active: 0,
        lastModified: {},
        etag: {},
        ajaxSettings: {
            url: Oi,
            type: "GET",
            isLocal: Ei.test(Ri[1]),
            global: !0,
            processData: !0,
            async: !0,
            contentType: "application/x-www-form-urlencoded; charset=UTF-8",
            accepts: {
                "*": ji,
                text: "text/plain",
                html: "text/html",
                xml: "application/xml, text/xml",
                json: "application/json, text/javascript"
            },
            contents: {
                xml: /xml/,
                html: /html/,
                json: /json/
            },
            responseFields: {
                xml: "responseXML",
                text: "responseText",
                json: "responseJSON"
            },
            converters: {
                "* text": String,
                "text html": !0,
                "text json": he.parseJSON,
                "text xml": he.parseXML
            },
            flatOptions: {
                url: !0,
                context: !0
            }
        },
        ajaxSetup: function(t, e) {
            return e ? $($(t, he.ajaxSettings), e) : $(he.ajaxSettings, t);
        },
        ajaxPrefilter: O(zi),
        ajaxTransport: O(Wi),
        ajax: function(t, i) {
            function n(t, i, n, o) {
                var r, m, T, y, Z, b = i;
                2 !== v && (v = 2, l && clearTimeout(l), h = e, s = o || "", w.readyState = t > 0 ? 4 : 0, 
                r = t >= 200 && 300 > t || 304 === t, n && (y = D(c, w, n)), y = A(c, y, w, r), 
                r ? (c.ifModified && (Z = w.getResponseHeader("Last-Modified"), Z && (he.lastModified[a] = Z), 
                Z = w.getResponseHeader("etag"), Z && (he.etag[a] = Z)), 204 === t || "HEAD" === c.type ? b = "nocontent" : 304 === t ? b = "notmodified" : (b = y.state, 
                m = y.data, T = y.error, r = !T)) : (T = b, (t || !b) && (b = "error", 0 > t && (t = 0))), 
                w.status = t, w.statusText = (i || b) + "", r ? f.resolveWith(d, [ m, b, w ]) : f.rejectWith(d, [ w, b, T ]), 
                w.statusCode(g), g = e, p && u.trigger(r ? "ajaxSuccess" : "ajaxError", [ w, c, r ? m : T ]), 
                k.fireWith(d, [ w, b ]), p && (u.trigger("ajaxComplete", [ w, c ]), --he.active || he.event.trigger("ajaxStop")));
            }
            "object" == typeof t && (i = t, t = e), i = i || {};
            var o, r, a, s, l, p, h, m, c = he.ajaxSetup({}, i), d = c.context || c, u = c.context && (d.nodeType || d.jquery) ? he(d) : he.event, f = he.Deferred(), k = he.Callbacks("once memory"), g = c.statusCode || {}, T = {}, y = {}, v = 0, Z = "canceled", w = {
                readyState: 0,
                getResponseHeader: function(t) {
                    var e;
                    if (2 === v) {
                        if (!m) for (m = {}; e = Hi.exec(s); ) m[e[1].toLowerCase()] = e[2];
                        e = m[t.toLowerCase()];
                    }
                    return null == e ? null : e;
                },
                getAllResponseHeaders: function() {
                    return 2 === v ? s : null;
                },
                setRequestHeader: function(t, e) {
                    var i = t.toLowerCase();
                    return v || (t = y[i] = y[i] || t, T[t] = e), this;
                },
                overrideMimeType: function(t) {
                    return v || (c.mimeType = t), this;
                },
                statusCode: function(t) {
                    var e;
                    if (t) if (2 > v) for (e in t) g[e] = [ g[e], t[e] ]; else w.always(t[w.status]);
                    return this;
                },
                abort: function(t) {
                    var e = t || Z;
                    return h && h.abort(e), n(0, e), this;
                }
            };
            if (f.promise(w).complete = k.add, w.success = w.done, w.error = w.fail, c.url = ((t || c.url || Oi) + "").replace(Di, "").replace(Li, Ri[1] + "//"), 
            c.type = i.method || i.type || c.method || c.type, c.dataTypes = he.trim(c.dataType || "*").toLowerCase().match(ce) || [ "" ], 
            null == c.crossDomain && (o = _i.exec(c.url.toLowerCase()), c.crossDomain = !(!o || o[1] === Ri[1] && o[2] === Ri[2] && (o[3] || ("http:" === o[1] ? "80" : "443")) === (Ri[3] || ("http:" === Ri[1] ? "80" : "443")))), 
            c.data && c.processData && "string" != typeof c.data && (c.data = he.param(c.data, c.traditional)), 
            M(zi, c, i, w), 2 === v) return w;
            p = c.global, p && 0 === he.active++ && he.event.trigger("ajaxStart"), c.type = c.type.toUpperCase(), 
            c.hasContent = !Bi.test(c.type), a = c.url, c.hasContent || (c.data && (a = c.url += ($i.test(a) ? "&" : "?") + c.data, 
            delete c.data), c.cache === !1 && (c.url = Ai.test(a) ? a.replace(Ai, "$1_=" + Mi++) : a + ($i.test(a) ? "&" : "?") + "_=" + Mi++)), 
            c.ifModified && (he.lastModified[a] && w.setRequestHeader("If-Modified-Since", he.lastModified[a]), 
            he.etag[a] && w.setRequestHeader("If-None-Match", he.etag[a])), (c.data && c.hasContent && c.contentType !== !1 || i.contentType) && w.setRequestHeader("Content-Type", c.contentType), 
            w.setRequestHeader("Accept", c.dataTypes[0] && c.accepts[c.dataTypes[0]] ? c.accepts[c.dataTypes[0]] + ("*" !== c.dataTypes[0] ? ", " + ji + "; q=0.01" : "") : c.accepts["*"]);
            for (r in c.headers) w.setRequestHeader(r, c.headers[r]);
            if (c.beforeSend && (c.beforeSend.call(d, w, c) === !1 || 2 === v)) return w.abort();
            Z = "abort";
            for (r in {
                success: 1,
                error: 1,
                complete: 1
            }) w[r](c[r]);
            if (h = M(Wi, c, i, w)) {
                w.readyState = 1, p && u.trigger("ajaxSend", [ w, c ]), c.async && c.timeout > 0 && (l = setTimeout(function() {
                    w.abort("timeout");
                }, c.timeout));
                try {
                    v = 1, h.send(T, n);
                } catch (b) {
                    if (!(2 > v)) throw b;
                    n(-1, b);
                }
            } else n(-1, "No Transport");
            return w;
        },
        getJSON: function(t, e, i) {
            return he.get(t, e, i, "json");
        },
        getScript: function(t, i) {
            return he.get(t, e, i, "script");
        }
    }), he.each([ "get", "post" ], function(t, i) {
        he[i] = function(t, n, o, r) {
            return he.isFunction(n) && (r = r || o, o = n, n = e), he.ajax({
                url: t,
                type: i,
                dataType: r,
                data: n,
                success: o
            });
        };
    }), he.ajaxSetup({
        accepts: {
            script: "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"
        },
        contents: {
            script: /(?:java|ecma)script/
        },
        converters: {
            "text script": function(t) {
                return he.globalEval(t), t;
            }
        }
    }), he.ajaxPrefilter("script", function(t) {
        t.cache === e && (t.cache = !1), t.crossDomain && (t.type = "GET", t.global = !1);
    }), he.ajaxTransport("script", function(t) {
        if (t.crossDomain) {
            var i, n = X.head || he("head")[0] || X.documentElement;
            return {
                send: function(e, o) {
                    i = X.createElement("script"), i.async = !0, t.scriptCharset && (i.charset = t.scriptCharset), 
                    i.src = t.url, i.onload = i.onreadystatechange = function(t, e) {
                        (e || !i.readyState || /loaded|complete/.test(i.readyState)) && (i.onload = i.onreadystatechange = null, 
                        i.parentNode && i.parentNode.removeChild(i), i = null, e || o(200, "success"));
                    }, n.insertBefore(i, n.firstChild);
                },
                abort: function() {
                    i && i.onload(e, !0);
                }
            };
        }
    });
    var qi = [], Ki = /(=)\?(?=&|$)|\?\?/;
    he.ajaxSetup({
        jsonp: "callback",
        jsonpCallback: function() {
            var t = qi.pop() || he.expando + "_" + Mi++;
            return this[t] = !0, t;
        }
    }), he.ajaxPrefilter("json jsonp", function(i, n, o) {
        var r, a, s, l = i.jsonp !== !1 && (Ki.test(i.url) ? "url" : "string" == typeof i.data && !(i.contentType || "").indexOf("application/x-www-form-urlencoded") && Ki.test(i.data) && "data");
        return l || "jsonp" === i.dataTypes[0] ? (r = i.jsonpCallback = he.isFunction(i.jsonpCallback) ? i.jsonpCallback() : i.jsonpCallback, 
        l ? i[l] = i[l].replace(Ki, "$1" + r) : i.jsonp !== !1 && (i.url += ($i.test(i.url) ? "&" : "?") + i.jsonp + "=" + r), 
        i.converters["script json"] = function() {
            return s || he.error(r + " was not called"), s[0];
        }, i.dataTypes[0] = "json", a = t[r], t[r] = function() {
            s = arguments;
        }, o.always(function() {
            t[r] = a, i[r] && (i.jsonpCallback = n.jsonpCallback, qi.push(r)), s && he.isFunction(a) && a(s[0]), 
            s = a = e;
        }), "script") : e;
    });
    var Ui, Gi, Xi = 0, Yi = t.ActiveXObject && function() {
        var t;
        for (t in Ui) Ui[t](e, !0);
    };
    he.ajaxSettings.xhr = t.ActiveXObject ? function() {
        return !this.isLocal && H() || E();
    } : H, Gi = he.ajaxSettings.xhr(), he.support.cors = !!Gi && "withCredentials" in Gi, 
    Gi = he.support.ajax = !!Gi, Gi && he.ajaxTransport(function(i) {
        if (!i.crossDomain || he.support.cors) {
            var n;
            return {
                send: function(o, r) {
                    var a, s, l = i.xhr();
                    if (i.username ? l.open(i.type, i.url, i.async, i.username, i.password) : l.open(i.type, i.url, i.async), 
                    i.xhrFields) for (s in i.xhrFields) l[s] = i.xhrFields[s];
                    i.mimeType && l.overrideMimeType && l.overrideMimeType(i.mimeType), i.crossDomain || o["X-Requested-With"] || (o["X-Requested-With"] = "XMLHttpRequest");
                    try {
                        for (s in o) l.setRequestHeader(s, o[s]);
                    } catch (p) {}
                    l.send(i.hasContent && i.data || null), n = function(t, o) {
                        var s, p, h, m;
                        try {
                            if (n && (o || 4 === l.readyState)) if (n = e, a && (l.onreadystatechange = he.noop, 
                            Yi && delete Ui[a]), o) 4 !== l.readyState && l.abort(); else {
                                m = {}, s = l.status, p = l.getAllResponseHeaders(), "string" == typeof l.responseText && (m.text = l.responseText);
                                try {
                                    h = l.statusText;
                                } catch (c) {
                                    h = "";
                                }
                                s || !i.isLocal || i.crossDomain ? 1223 === s && (s = 204) : s = m.text ? 200 : 404;
                            }
                        } catch (d) {
                            o || r(-1, d);
                        }
                        m && r(s, h, m, p);
                    }, i.async ? 4 === l.readyState ? setTimeout(n) : (a = ++Xi, Yi && (Ui || (Ui = {}, 
                    he(t).unload(Yi)), Ui[a] = n), l.onreadystatechange = n) : n();
                },
                abort: function() {
                    n && n(e, !0);
                }
            };
        }
    });
    var Ji, Qi, tn = /^(?:toggle|show|hide)$/, en = RegExp("^(?:([+-])=|)(" + me + ")([a-z%]*)$", "i"), nn = /queueHooks$/, on = [ z ], rn = {
        "*": [ function(t, e) {
            var i = this.createTween(t, e), n = i.cur(), o = en.exec(e), r = o && o[3] || (he.cssNumber[t] ? "" : "px"), a = (he.cssNumber[t] || "px" !== r && +n) && en.exec(he.css(i.elem, t)), s = 1, l = 20;
            if (a && a[3] !== r) {
                r = r || a[3], o = o || [], a = +n || 1;
                do s = s || ".5", a /= s, he.style(i.elem, t, a + r); while (s !== (s = i.cur() / n) && 1 !== s && --l);
            }
            return o && (a = i.start = +a || +n || 0, i.unit = r, i.end = o[1] ? a + (o[1] + 1) * o[2] : +o[2]), 
            i;
        } ]
    };
    he.Animation = he.extend(_, {
        tweener: function(t, e) {
            he.isFunction(t) ? (e = t, t = [ "*" ]) : t = t.split(" ");
            for (var i, n = 0, o = t.length; o > n; n++) i = t[n], rn[i] = rn[i] || [], rn[i].unshift(e);
        },
        prefilter: function(t, e) {
            e ? on.unshift(t) : on.push(t);
        }
    }), he.Tween = W, W.prototype = {
        constructor: W,
        init: function(t, e, i, n, o, r) {
            this.elem = t, this.prop = i, this.easing = o || "swing", this.options = e, this.start = this.now = this.cur(), 
            this.end = n, this.unit = r || (he.cssNumber[i] ? "" : "px");
        },
        cur: function() {
            var t = W.propHooks[this.prop];
            return t && t.get ? t.get(this) : W.propHooks._default.get(this);
        },
        run: function(t) {
            var e, i = W.propHooks[this.prop];
            return this.pos = e = this.options.duration ? he.easing[this.easing](t, this.options.duration * t, 0, 1, this.options.duration) : t, 
            this.now = (this.end - this.start) * e + this.start, this.options.step && this.options.step.call(this.elem, this.now, this), 
            i && i.set ? i.set(this) : W.propHooks._default.set(this), this;
        }
    }, W.prototype.init.prototype = W.prototype, W.propHooks = {
        _default: {
            get: function(t) {
                var e;
                return null == t.elem[t.prop] || t.elem.style && null != t.elem.style[t.prop] ? (e = he.css(t.elem, t.prop, ""), 
                e && "auto" !== e ? e : 0) : t.elem[t.prop];
            },
            set: function(t) {
                he.fx.step[t.prop] ? he.fx.step[t.prop](t) : t.elem.style && (null != t.elem.style[he.cssProps[t.prop]] || he.cssHooks[t.prop]) ? he.style(t.elem, t.prop, t.now + t.unit) : t.elem[t.prop] = t.now;
            }
        }
    }, W.propHooks.scrollTop = W.propHooks.scrollLeft = {
        set: function(t) {
            t.elem.nodeType && t.elem.parentNode && (t.elem[t.prop] = t.now);
        }
    }, he.each([ "toggle", "show", "hide" ], function(t, e) {
        var i = he.fn[e];
        he.fn[e] = function(t, n, o) {
            return null == t || "boolean" == typeof t ? i.apply(this, arguments) : this.animate(j(e, !0), t, n, o);
        };
    }), he.fn.extend({
        fadeTo: function(t, e, i, n) {
            return this.filter(b).css("opacity", 0).show().end().animate({
                opacity: e
            }, t, i, n);
        },
        animate: function(t, e, i, n) {
            var o = he.isEmptyObject(t), r = he.speed(e, i, n), a = function() {
                var e = _(this, he.extend({}, t), r);
                (o || he._data(this, "finish")) && e.stop(!0);
            };
            return a.finish = a, o || r.queue === !1 ? this.each(a) : this.queue(r.queue, a);
        },
        stop: function(t, i, n) {
            var o = function(t) {
                var e = t.stop;
                delete t.stop, e(n);
            };
            return "string" != typeof t && (n = i, i = t, t = e), i && t !== !1 && this.queue(t || "fx", []), 
            this.each(function() {
                var e = !0, i = null != t && t + "queueHooks", r = he.timers, a = he._data(this);
                if (i) a[i] && a[i].stop && o(a[i]); else for (i in a) a[i] && a[i].stop && nn.test(i) && o(a[i]);
                for (i = r.length; i--; ) r[i].elem !== this || null != t && r[i].queue !== t || (r[i].anim.stop(n), 
                e = !1, r.splice(i, 1));
                (e || !n) && he.dequeue(this, t);
            });
        },
        finish: function(t) {
            return t !== !1 && (t = t || "fx"), this.each(function() {
                var e, i = he._data(this), n = i[t + "queue"], o = i[t + "queueHooks"], r = he.timers, a = n ? n.length : 0;
                for (i.finish = !0, he.queue(this, t, []), o && o.stop && o.stop.call(this, !0), 
                e = r.length; e--; ) r[e].elem === this && r[e].queue === t && (r[e].anim.stop(!0), 
                r.splice(e, 1));
                for (e = 0; a > e; e++) n[e] && n[e].finish && n[e].finish.call(this);
                delete i.finish;
            });
        }
    }), he.each({
        slideDown: j("show"),
        slideUp: j("hide"),
        slideToggle: j("toggle"),
        fadeIn: {
            opacity: "show"
        },
        fadeOut: {
            opacity: "hide"
        },
        fadeToggle: {
            opacity: "toggle"
        }
    }, function(t, e) {
        he.fn[t] = function(t, i, n) {
            return this.animate(e, t, i, n);
        };
    }), he.speed = function(t, e, i) {
        var n = t && "object" == typeof t ? he.extend({}, t) : {
            complete: i || !i && e || he.isFunction(t) && t,
            duration: t,
            easing: i && e || e && !he.isFunction(e) && e
        };
        return n.duration = he.fx.off ? 0 : "number" == typeof n.duration ? n.duration : n.duration in he.fx.speeds ? he.fx.speeds[n.duration] : he.fx.speeds._default, 
        (null == n.queue || n.queue === !0) && (n.queue = "fx"), n.old = n.complete, n.complete = function() {
            he.isFunction(n.old) && n.old.call(this), n.queue && he.dequeue(this, n.queue);
        }, n;
    }, he.easing = {
        linear: function(t) {
            return t;
        },
        swing: function(t) {
            return .5 - Math.cos(t * Math.PI) / 2;
        }
    }, he.timers = [], he.fx = W.prototype.init, he.fx.tick = function() {
        var t, i = he.timers, n = 0;
        for (Ji = he.now(); i.length > n; n++) t = i[n], t() || i[n] !== t || i.splice(n--, 1);
        i.length || he.fx.stop(), Ji = e;
    }, he.fx.timer = function(t) {
        t() && he.timers.push(t) && he.fx.start();
    }, he.fx.interval = 13, he.fx.start = function() {
        Qi || (Qi = setInterval(he.fx.tick, he.fx.interval));
    }, he.fx.stop = function() {
        clearInterval(Qi), Qi = null;
    }, he.fx.speeds = {
        slow: 600,
        fast: 200,
        _default: 400
    }, he.fx.step = {}, he.expr && he.expr.filters && (he.expr.filters.animated = function(t) {
        return he.grep(he.timers, function(e) {
            return t === e.elem;
        }).length;
    }), he.fn.offset = function(t) {
        if (arguments.length) return t === e ? this : this.each(function(e) {
            he.offset.setOffset(this, t, e);
        });
        var i, n, o = {
            top: 0,
            left: 0
        }, r = this[0], a = r && r.ownerDocument;
        return a ? (i = a.documentElement, he.contains(i, r) ? (typeof r.getBoundingClientRect !== U && (o = r.getBoundingClientRect()), 
        n = V(a), {
            top: o.top + (n.pageYOffset || i.scrollTop) - (i.clientTop || 0),
            left: o.left + (n.pageXOffset || i.scrollLeft) - (i.clientLeft || 0)
        }) : o) : void 0;
    }, he.offset = {
        setOffset: function(t, e, i) {
            var n = he.css(t, "position");
            "static" === n && (t.style.position = "relative");
            var o, r, a = he(t), s = a.offset(), l = he.css(t, "top"), p = he.css(t, "left"), h = ("absolute" === n || "fixed" === n) && he.inArray("auto", [ l, p ]) > -1, m = {}, c = {};
            h ? (c = a.position(), o = c.top, r = c.left) : (o = parseFloat(l) || 0, r = parseFloat(p) || 0), 
            he.isFunction(e) && (e = e.call(t, i, s)), null != e.top && (m.top = e.top - s.top + o), 
            null != e.left && (m.left = e.left - s.left + r), "using" in e ? e.using.call(t, m) : a.css(m);
        }
    }, he.fn.extend({
        position: function() {
            if (this[0]) {
                var t, e, i = {
                    top: 0,
                    left: 0
                }, n = this[0];
                return "fixed" === he.css(n, "position") ? e = n.getBoundingClientRect() : (t = this.offsetParent(), 
                e = this.offset(), he.nodeName(t[0], "html") || (i = t.offset()), i.top += he.css(t[0], "borderTopWidth", !0), 
                i.left += he.css(t[0], "borderLeftWidth", !0)), {
                    top: e.top - i.top - he.css(n, "marginTop", !0),
                    left: e.left - i.left - he.css(n, "marginLeft", !0)
                };
            }
        },
        offsetParent: function() {
            return this.map(function() {
                for (var t = this.offsetParent || Y; t && !he.nodeName(t, "html") && "static" === he.css(t, "position"); ) t = t.offsetParent;
                return t || Y;
            });
        }
    }), he.each({
        scrollLeft: "pageXOffset",
        scrollTop: "pageYOffset"
    }, function(t, i) {
        var n = /Y/.test(i);
        he.fn[t] = function(o) {
            return he.access(this, function(t, o, r) {
                var a = V(t);
                return r === e ? a ? i in a ? a[i] : a.document.documentElement[o] : t[o] : (a ? a.scrollTo(n ? he(a).scrollLeft() : r, n ? r : he(a).scrollTop()) : t[o] = r, 
                e);
            }, t, o, arguments.length, null);
        };
    }), he.each({
        Height: "height",
        Width: "width"
    }, function(t, i) {
        he.each({
            padding: "inner" + t,
            content: i,
            "": "outer" + t
        }, function(n, o) {
            he.fn[o] = function(o, r) {
                var a = arguments.length && (n || "boolean" != typeof o), s = n || (o === !0 || r === !0 ? "margin" : "border");
                return he.access(this, function(i, n, o) {
                    var r;
                    return he.isWindow(i) ? i.document.documentElement["client" + t] : 9 === i.nodeType ? (r = i.documentElement, 
                    Math.max(i.body["scroll" + t], r["scroll" + t], i.body["offset" + t], r["offset" + t], r["client" + t])) : o === e ? he.css(i, n, s) : he.style(i, n, o, s);
                }, i, a ? o : e, a, null);
            };
        });
    }), he.fn.size = function() {
        return this.length;
    }, he.fn.andSelf = he.fn.addBack, "object" == typeof module && module && "object" == typeof module.exports ? module.exports = he : (t.jQuery = t.$ = he, 
    "function" == typeof define && define.amd && define("jquery", [], function() {
        return he;
    }));
})(window);

// source/xmltojson.js
var osm2geo = function(t) {
    function e(t) {
        var e = [];
        return e.push(parseFloat(t.attr("minlon"))), e.push(parseFloat(t.attr("minlat"))), 
        e.push(parseFloat(t.attr("maxlon"))), e.push(parseFloat(t.attr("maxlat"))), e;
    }
    function i(t) {
        var e = {}, i = $(t).find("tag");
        return i.each(function(t, i) {
            ("building" == $(i).attr("k") || "highway" == $(i).attr("k") || "railway" == $(i).attr("k") || "natural" == $(i).attr("k") || "water" == $(i).attr("k")) && (e[$(i).attr("k")] = $(i).attr("v"));
        }), e;
    }
    function n(t, e) {
        return {
            geometry: {
                type: e,
                coordinates: []
            },
            type: "Feature",
            properties: i(t)
        };
    }
    var o = jQuery(t), r = {
        type: "FeatureCollection",
        features: []
    };
    r.bbox = e(o.find("bounds"));
    var a = $("way", o);
    a.each(function(t, e) {
        var i = {}, a = $(e).find("nd");
        $(a).last().attr("ref") === $(a).first().attr("ref") ? (i = n(e, "Polygon"), i.geometry.coordinates.push([])) : i = n(e, "LineString"), 
        i.id = e.id, a.each(function(t, e) {
            var n = o.find("node[id='" + $(e).attr("ref") + "']"), r = [ parseFloat(n.attr("lon")), parseFloat(n.attr("lat")) ];
            "Polygon" === i.geometry.type ? i.geometry.coordinates[0].push(r) : i.geometry.coordinates.push(r);
        }), r.features.push(i);
    });
    var s = $("node:has('tag')", o);
    return s.each(function(t, e) {
        var i = n(e, "Point");
        i.geometry.coordinates.push(parseFloat($(e).attr("lon"))), i.geometry.coordinates.push(parseFloat($(e).attr("lat"))), 
        i.id = e.id, r.features.push(i);
    }), r;
};

// source/App.js
var APP, MAIN;

enyo.kind({
    name: "App",
    kind: "FittableRows",
    classes: "enyo-unselectable enyo-fit",
    components: [ {
        name: "popup",
        kind: "onyx.Popup",
        centered: !0,
        floating: !0,
        modal: !0,
        classes: "onyx-sample-popup",
        style: "padding: 10px;",
        content: "Loading..."
    } ],
    create: function() {
        this.inherited(arguments);
    },
    rendered: function() {
        this.inherited(arguments), this.$.popup.show(), this.done();
    },
    done: function() {
        this.$.popup.hide(), MAIN || (MAIN = new MainScene()), MAIN.renderInto(document.body);
    },
    showMain: function() {
        MAIN || (MAIN = new MainScene()), MAIN.renderInto(document.body);
    }
}), enyo.kind({
    name: "MainScene",
    kind: "Panels",
    classes: "enyo-panels",
    arrangerKind: "LeftRightArranger",
    margin: 0,
    index: 0,
    draggable: !1,
    wrap: !1,
    fit: !0,
    components: [ {
        kind: "FilesScene",
        name: "files"
    }, {
        kind: "GuideScene",
        name: "guide"
    } ],
    rendered: function() {
        this.inherited(arguments), this.start();
    },
    start: function() {
        this.setIndex(0), this.$.files.setBack(enyo.bind(this, "toGuide")), this.$.guide.setBack(enyo.bind(this, "toFiles")), 
        this.$.files.start.call(this.$.files);
    },
    create: function() {
        this.inherited(arguments), this.screenLock = 0;
    },
    toFiles: function() {
        this.setIndex(0), this.$.files.start.call(this.$.files);
    },
    toGuide: function() {
        this.setIndex(1), this.$.guide.start();
    },
    popup: function(t) {
        this.$.popup.setContent(t), this.$.popup.show();
    },
    reflow: function() {
        this.inherited(arguments);
    },
    closePopup: function() {
        this.$.deleteConfirmation.hide();
    },
    closeAllPopup: function() {
        this.$.deleteAllConfirmation.hide();
    }
}), loadSettings(), console.log("VERSION: " + VERSION), MAIN = new MainScene(), 
MAIN.renderInto(document.body);
