
Date.prototype.formatDate = function() {
   var yyyy = this.getFullYear().toString();
   var mm = (this.getMonth()+1).toString(); // getMonth() is zero-based
   var dd  = this.getDate().toString();
   return yyyy +"/"+ (mm[1]?mm:"0"+mm[0])+"/" + (dd[1]?dd:"0"+dd[0]); // padding
  };


$('.submit').on('click',function ()
{
  var trackingNo = $(".trackingNo").val().toUpperCase();
  if(!$.trim(trackingNo)) {
    $('.results').empty();
    $('.results').show();
    $('.results').text("Введите трек-номер!");
    return false;
  }
  $('.results').empty();
  $('.results').append('<img class="ajax-loader" src="images/ajax-loader.gif"/>');
  $('.results').show();
  $.ajax({
    type: 'POST',
    url: 'https://service-rptracker3.rhcloud.com/trackdog/trackCheck',
    // post payload:
    data: trackingNo,
    timeout: 10000,
    contentType: 'text/plain; encoding=utf-8',
    success: function(data){
        var result = $.parseJSON(data);
        $('.results').empty();
        if($.isArray(result.events)) {
          $.each(result.events, function(key, value){
            var date = new Date(value.createTimeMillis);
            $('.results').append('<div class="event-date">'+date.formatDate()+'</div>');
            $('.results').append('<div class="event-text">'+value.description+'</div>');
          })
        } else {
          $('.results').text("Нет данных по отправлению. Повторите позднее");
        }

    },
    error: function(xhr, type){
      alert('error');
      $('.results').empty();
      $('.results').text("Сервис отслеживания недоступен. Повторите позднее");
    }
});

});