var BASE_URL = "http://app.trackeat.com";
var isPhoneGap = (document.location.protocol == "file:")

var SUCCESS = 1;
var UNSUCCESS = 2;

var g_log_date = null;
var g_curr_group_id = null;
var g_is_user_logged = false;

var g_simple_groups = null;
var g_simple_items = null;

var app = {
    // Application Constructor
    initialize: function() {
        this.bindEvents();
    },
    
    // Bind Event Listeners
    //
    // Bind any events that are required on startup. Common events are:
    // 'load', 'deviceready', 'offline', and 'online'.
    bindEvents: function() {
  		document.addEventListener('deviceready', this.onDeviceReady, false);

  		this.onDomReady();
		  if (!isPhoneGap) {
        	app.verifyLoggedUser();
       }
    },

    // deviceready Event Handler
    //
    onDeviceReady: function() {
    	var platform = device.platform;
        if (platform.toLowerCase().indexOf('ipad') >= 0) {
            $('#dietplan div[data-role="footer"]').css('margin-bottom','90px');
            $('#additem div[data-role="footer"]').css('margin-bottom','90px');
         }
        else if (platform.toLowerCase().indexOf('iphone') >= 0) {
             $('#dietplan div[data-role="footer"]').css('margin-bottom','50px');
             $('#additem div[data-role="footer"]').css('margin-bottom','50px');
         }
		 else if (platform.toLowerCase().indexOf('android') >= 0) {
			$('#create #create-bar form#create-form').css('color','#000');
			$('#create #create-bar form#create-form').css('text-align','left');
			$('#create #create-bar form#create-form div[data-role="fieldcontain"]').removeClass('ui-hide-label');
			$('#create #create-bar .slogen').css('display', 'none');
		 }
        
        app.verifyLoggedUser();
    },

    onDomReady: function() {
  		document.addEventListener("backbutton", this.onBackKeyDown, true);
                  
  		app.loadSimpleGroups();
  		app.loadSimpleItems();

      $('#login, #create, #signup, #loading').bind('pageshow', function () {
          if (g_is_user_logged) {
              $.mobile.changePage("#dietplan", { transition: "slidedown", reverse: false });
              return;
          }
          else if ($(this).attr('id') == 'loading') {
              $.mobile.changePage("#create", { transition: "slidedown", reverse: false });
          }
      });
      
       
       $('#dietplan').bind('pageshow', function () {
           app.loadPlan();
       });

       $('div#login .backhome-btn').click(function () {
           $.mobile.changePage("#create", { transition: "slide", reverse: true });
       });

       $('div#prepare a#no-help-link, div#home a#my-dietplan-link').click(function () {
           $.mobile.changePage("#dietplan", { transition: "slide", reverse: true });
       });

       $('#login-btn').click(function () {
           app.login();
       });
	   
       $('#create-btn').click(function () {
           app.createPlan();
       });
	   
       $('#sign-btn').click(function () {
           app.signup();
       });
	   
       $('#dietplan #next-btn, #dietplan #prev-btn').click(function() {
           app.loadPlan($(this).attr('date'));
       });
	   
       $('#already-got-account').click(function () {
           $.mobile.changePage("#login", { transition: "none", reverse: true });
       });
        
       $('li#additem-link').click(function () {
           if (g_curr_group_id > 0) {
               app.hideGroupItems(g_curr_group_id);
           }
           
           $('#additem #amount').val(1);
           
           $.mobile.changePage("#additem", { transition: "slideup", reverse: false });
       });
       
	   $('a#additemback-link').click(function () {
           $.mobile.changePage("#dietplan", { transition: "slidedown", reverse: false });
           app.loadPlan();
       });
       
	   $('li#simple-link').click(function () {
           $('#additem div.simple').css('display', 'block');
           $('#additem div.advanced').css('display', 'none');
           $('#additem div.customized').css('display', 'none');
       });
	   
       $('li#advanced-link').click(function () {
           $('#additem div.simple').css('display', 'none');
           $('#additem div.advanced').css('display', 'block');
           $('#additem div.customized').css('display', 'none');
       });
       
	   $('li#customized-link').click(function () {
           $('#additem div.simple').css('display', 'none');
           $('#additem div.advanced').css('display', 'none');
           $('#additem div.customized').css('display', 'block');
       });
       
	   $('#additem div.advanced #search-result').change(function () {
           var id = $("#search-result option:selected").attr('id');
           app.getItemMeasures(id, 'advanced');
       });

       $("#additem #simple-add-btn").click(function () {
           var id = $("#additem div.simple #item-id").val();
           var measure_id = $("#additem div.simple #measure option:selected").attr('id');
           var amount = $('#additem div.simple #amount').val();
           var hour = $("#additem div.simple #hour option:selected").val();

           if (hour == -1) {
               hour = getCurrentHour() < 6 ? 6 : getCurrentHour();
           }
           
           app.addItem(id, measure_id, amount, hour);
       });
	   
       $("#additem div.simple div#groups-back-btn a").click(function () {
           app.hideGroupItems(g_curr_group_id);
       });
	   
       $("#additem #adv-add-btn").click(function () {
           var id = $("#search-result option:selected").attr('id');
           var measure_id = $("#additem div.advanced #measure option:selected").attr('id');
           var amount = $('#additem div.advanced #amount').val();
           var hour = $("#additem div.advanced #hour option:selected").val();

           if (hour == -1) {
               hour = getCurrentHour() < 6 ? 6 : getCurrentHour();
           }
           app.addItem(id, measure_id, amount, hour);
       });
	   
       $('div#additem div.advanced #search-btn').click(function () {
           app.searchItem();
       });

    },
    
    login: function(redirect_on_fail) {
		var formData = $('#login-bar form').serialize();
        
        $("#login-bar form :input").attr("disabled", true);
        $.mobile.loading('show');

        $('div#login div.notification').css('display', 'none');
		$.ajax({
            url: BASE_URL + '/user/index/login',
            dataType: 'jsonp',
            data: formData,
            success: function (data) {
               $.mobile.loading('hide');
               if (data.err_code == SUCCESS) {
            	   g_is_user_logged = true;

            	   window.localStorage.setItem("email", $('#login-bar form #email').val());
            	   window.localStorage.setItem("password", $('#login-bar form #password').val()); 
            	   $.mobile.changePage("#dietplan", { transition: "slide", reverse: false });
               }
               else {
            	   g_is_user_logged = false;
            	   $("#login-bar form :input").attr("disabled", false);

            	   if (redirect_on_fail) {
                 	   $.mobile.changePage("#create", { transition: "slide", reverse: false });                    	
                   }
                   else {
                	   $('div#login div.notification').css('display', 'block');
                   }
               }
            },
            error: function (jqXHR, textStatus, errorThrown) {
               $.mobile.loading('hide');
               $("#login-bar form :input").attr("disabled", false);
               alert(jqXHR + " - " + textStatus + " - " + errorThrown);
            }
               
        });
	},
    
    createPlan: function() {
        var formData = $('#create-bar form#create-form').serialize();
    
        $("#create-bar form#create-form :input").attr("disabled", true);
        $.mobile.loading('show');
    
        $.ajax({
           url: BASE_URL + '/track/createplan',
           dataType: 'jsonp',
           data: formData,
           success: function (data) {
               $.mobile.loading('hide');
               if (data.err_code == SUCCESS) {
                    $.mobile.changePage("#signup", { transition: "slide", reverse: false });
               }
               else {
                    $("#create-bar form#create-form :input").attr("disabled", false);
                    $('div#create-bar div.notification').css('display', 'block');
               }
           },
           error: function (jqXHR, textStatus, errorThrown) {
               $.mobile.loading('hide');
               $("#create-bar form#create-form :input").attr("disabled", false);
               alert(jqXHR + " - " + textStatus + " - " + errorThrown);
           }
        });
    },
    
	signup: function() {
        var formData = $('#signup form#sign-form').serialize();
	        
        $("#signup form#sign-form :input").attr("disabled", true);
        $.mobile.loading('show');

		$.ajax({
			url: BASE_URL + '/user/index/sign',
			dataType: 'jsonp',
			data: formData,
			success: function (data) {
				$.mobile.loading('hide');
				if (data.err_code == SUCCESS) {
            	   window.localStorage.setItem("email", $('#signup form#sign-form #email').val());
            	   window.localStorage.setItem("password", $('#signup form#sign-form #password').val()); 

            	   $.mobile.changePage("#dietplan", { transition: "slide", reverse: false });
				}
				else {
					$("#signup form#sign-form :input").attr("disabled", false);
					$('#signup div.notification').text(data.err_message);
					$('#signup div.notification').css('display', 'block');
				}
			},
			error: function (jqXHR, textStatus, errorThrown) {
				$.mobile.loading('hide');
				$("#signup form#sign-form :input").attr("disabled", false);
				alert(jqXHR + " - " + textStatus + " - " + errorThrown);
			}
		});
	},
	
	loadPlan: function(planDate) {
        $.mobile.loading('show');

        var ajaxData;
        if (planDate != null) {
        	ajaxData = ({ ajax: 1, ld: planDate });
        }
        else {
        	ajaxData = ({ ajax: 1 });
        }
        
        $.ajax({
			url: BASE_URL + '/index',
			dataType: 'jsonp',
			data: ajaxData,
			success: function (data) {
				$.mobile.loading('hide');
				
				if (data.err_code == SUCCESS) {
					app.preparePlan(data.extra_data);
				}
				else {
					alert(data.err_message);
				}
			},
			error: function (jqXHR, textStatus, errorThrown) {
				$.mobile.loading('hide');
				alert(jqXHR + " - " + textStatus + " - " + errorThrown);
			}
		});
	},
	
	preparePlan: function(data) {
		g_log_date = data.curr_track_date

		var currDate = new Date(data.curr_track_time * 1000);
		$('#dietplan div[data-role=header] h3').text(currDate.getDate() + "/" + (currDate.getMonth() + 1));
		var nextDate = new Date(currDate.getFullYear(), currDate.getMonth(), currDate.getDate()+1);
		$('#dietplan #next-btn').attr('date', nextDate.getFullYear() + "" + pad((nextDate.getMonth() + 1), 2) + "" + pad(nextDate.getDate(), 2)); 
	    var prevDate = new Date(currDate.getFullYear(), currDate.getMonth(), currDate.getDate()-1);
		$('#dietplan #prev-btn').attr('date', prevDate.getFullYear() + pad((prevDate.getMonth() + 1), 2) + pad(prevDate.getDate(), 2));
		

		$('#dietplan ul[data-role=listview] li').remove();

		var topEntered = false;
		for (var i=6; i <= 23; i++) {
			var hourEntered = false;

			for (j = 0; j < data.plan_items.length; j++) {
				if (i == data.plan_items[j].hour) {
					var itemAmount = (data.plan_items[j].amount - data.plan_items[j].amount > 0) ? parseFloat(data.plan_items[j].amount) : parseFloat(data.plan_items[j].amount);
					var measureName = data.plan_items[j].nutr_item.measure_name;
					var itemName = data.plan_items[j].nutr_item.item_name;

					var addBottomCorner = data.plan_items.length == j + 1 ? true : false;
					var li = '<li id="item-' + data.plan_items[j].plan_item_id + '" marked="' + data.plan_items[j].marked + '" onclick="app.onItemClicked(' + data.plan_items[j].plan_item_id + ')" class="ui-btn ui-btn-up-c ui-btn-icon-right ui-li ui-li-has-alt ' + (!topEntered ? 'ui-corner-top' : (addBottomCorner ? 'ui-corner-bottom' : '')) + '" data-corners="false" data-shadow="false" data-iconshadow="true" data-wrapperels="div" data-icon="false" data-iconpos="right" data-theme="c">' +
								'<div class="ui-btn-inner ui-li ui-li-has-alt '+(!topEntered ? 'ui-corner-top' : (addBottomCorner ? 'ui-corner-bottom' : ''))+'">'+
									'<div class="ui-btn-text">'+
										'<a class="ui-link-inherit" href="#">'+
											'<div class="hour">' + (!hourEntered ? this.evalMealName(i) + '<div>' + i + ':00</div>' : '&nbsp;') + '</div>' +
											'<div class="item">' + itemAmount + " " + measureName + " " + itemName + '</div>' +
										'</a>'+
									'</div>'+
								'</div>'+
								'<a class="ui-li-link-alt ui-btn ui-btn-up-c ui-corner-tr" data-transition="slideup" data-theme="c" data-icon="false" data-rel="dialog" href="#" title="&nbsp;" data-corners="false" data-shadow="false" data-iconshadow="true" data-wrapperels="span" data-iconpos="false">' +
									'<span class="ui-btn-inner ui-corner-tr">'+
										'<span class="ui-btn-text ui-corner-tr"></span>'+
										'<span class="ui-btn  ' + (data.plan_items[j].marked ? 'ui-btn-up-b' : 'ui-btn-up-d') + ' ui-shadow ui-btn-corner-all ui-btn-icon-notext" data-corners="true" data-shadow="true" data-iconshadow="true" data-wrapperels="span" data-icon="check" data-iconpos="notext" data-theme="d" title="">' +
											'<span class="ui-btn-inner ui-btn-corner-all ui-corner-tr">'+
												'<span class="ui-btn-text ui-corner-tr"></span>'+
												'<span class="ui-icon ui-icon-check ui-icon-shadow">&nbsp;</span>'+
											'</span>'+
										'</span>'+
									'</span>' +
								'</a>'+
							'</li>';
					$('#dietplan ul[data-role=listview]').append(li);

					topEntered = true;
					hourEntered = true;
				}
			}

			for(j=0; j < data.nutr_items.length; j++) {
				if (data.nutr_items[j].plan_item_id == undefined && i == data.nutr_items[j].hour) {
					
					itemAmount = (data.nutr_items[j].amount - data.nutr_items[j].amount > 0) ? parseInt(data.nutr_items[j].amount) : parseInt(data.nutr_items[j].amount);
					measureName = data.nutr_items[j].nutr_item.measure_name;
					itemName = data.nutr_items[j].nutr_item.item_name;

					addBottomCorner = data.nutr_items.length == j + 1 ? true : false;
					li = '<li id="item-' + data.nutr_items[j].nutrition_track_id + '" class="ui-btn ui-btn-up-c ui-btn-icon-right ui-li ui-li-has-alt ' + (!topEntered ? 'ui-corner-top' : (addBottomCorner ? 'ui-corner-bottom' : '')) + '" data-corners="false" data-shadow="false" data-iconshadow="true" data-wrapperels="div" data-icon="false" data-iconpos="right" data-theme="c">' +
								'<div class="ui-btn-inner ui-li ui-li-has-alt '+(!topEntered ? 'ui-corner-top' : (addBottomCorner ? 'ui-corner-bottom' : ''))+'">'+
									'<div class="ui-btn-text">'+
										'<a class="ui-link-inherit" href="#">'+
											'<div class="hour">' + (!hourEntered ? i + ':00' : '&nbsp;') + '</div>' +
											'<div class="item">' + itemAmount + " " + measureName + " " + itemName + '</div>' +
										'</a>'+
									'</div>'+
								'</div>'+
								'<a onclick="app.removeItem(' + data.nutr_items[j].nutrition_track_id + ')" class="ui-li-link-alt ui-btn ui-btn-up-d ui-corner-tr" data-transition="slideup" data-theme="c" data-icon="false" data-rel="dialog" href="#" title="&nbsp;" data-corners="false" data-shadow="false" data-iconshadow="true" data-wrapperels="span" data-iconpos="false">' +
									'<span class="ui-btn-inner ui-corner-tr">'+
										'<span class="ui-btn-text ui-corner-tr"></span>'+
										'<span class="ui-btn ui-btn-up-e ui-shadow ui-btn-corner-all ui-btn-icon-notext" data-corners="true" data-shadow="true" data-iconshadow="true" data-wrapperels="span" data-icon="check" data-iconpos="notext" data-theme="e" title="">' +
											'<span class="ui-btn-inner ui-btn-corner-all ui-corner-tr">'+
												'<span class="ui-btn-text ui-corner-tr"></span>'+
												'<span class="ui-icon ui-icon-delete ui-icon-shadow">&nbsp;</span>'+
											'</span>'+
										'</span>'+
									'</span>' +
								'</a>'+
							'</li>';
					$('#dietplan ul[data-role=listview]').append(li);

					topEntered = true;
					hourEntered = true;
				}
			} 	
		}
	},

	searchItem: function() {
        var term = $('#searchterm').val();
        term = $.trim(term);
		if (term.length > 0) {

            $("#additem :input").attr("disabled", true);
            $.mobile.loading('show');
			
            $.ajax({
				url: BASE_URL + '/track/find',
				dataType: 'jsonp',
				data: ({ q: term }),
				success: function (data) {
			        $("#additem :input").attr("disabled", false);
			        $.mobile.loading('hide');

                   if (data.extra_data.length > 0) {
                        var options;
                        $.each(data.extra_data, function (index, item) {
                               options += '<option id=' + item.item_id + '>' + item.item_name + '</option>';
                               });
                        $('#search-result').html(options);
                        $('#search-result').selectmenu('refresh', true);

                        $('#additem div.advanced .search-results-ctrl-grp .ui-btn-text').html($('#search-result option:first').val());

                        app.getItemMeasures(data.extra_data[0].item_id, 'advanced');

                        $('#additem div.advanced #amount').val(1);
                   
                        $('#additem div.advanced .search-results').css('display', 'block');
                   }
                   else {
                        $('#search-popup').popup("open");
                   }
				}
			});
		}
        else {
            $('#search-popup').popup("open");
        }
	},
	
	getItemMeasures: function(id, formClass) {
		$.ajax({
			url: BASE_URL + '/track/measures',
			dataType: 'jsonp',
			data: ({ iid: id }),
			success: function (data) {
				var options = '';
			    
				$.each(data.extra_data, function (index, measure) {
					options += '<option id=' + measure.measure_id + '>' + measure.measure_name + '</option>';
				});
			    
				$('#additem div.' + formClass + ' #measure').html(options);
               $('#additem div.' + formClass + ' #measure').selectmenu('refresh', true);
			}
		});
	},

	addItem: function(id, measure_id, amount, hour) {
        $("#additem :input").attr("disabled", true);
        $.mobile.loading('show');
        
		if ($.trim(id) == '' || $.trim(id) == '-1') {
			alert("Please select food item");
	        $("#additem :input").attr("disabled", false);
	        $.mobile.loading('hide');
			return;
		}

        if ($.trim(measure_id) == '' || $.trim(measure_id) == '-1') {
            alert("Please select food measure");
            $("#additem :input").attr("disabled", false);
            $.mobile.loading('hide');
            return;
        }

        if ($.trim(amount) == '') {
			alert("Please enter amount of food items to add");
            $("#additem :input").attr("disabled", false);
            $.mobile.loading('hide');
			return;
		}

		// get item values and change tracker rows values
		$.ajax({
			url: BASE_URL + '/track/inserttrack',
			dataType: 'jsonp',
			data: ({ iid: id, mid: measure_id, amt: amount, hr: hour, ld: g_log_date }),
			success: function (data) {
	            $("#additem :input").attr("disabled", false);
	            $.mobile.loading('hide');

                $('#additem div.advanced .search-results').css('display', 'none');
               
	            $.mobile.changePage("#dietplan", { transition: "slidedown", reverse: false });
				app.loadPlan();
			},
			error: function (jqXHR, textStatus, errorThrown) {
	            $("#additem :input").attr("disabled", false);
	            $.mobile.loading('hide');

	            alert(jqXHR + " - " + textStatus + " - " + errorThrown);
			}
		});
	},

	removeItem: function(nutrition_track_id) {
		$.ajax({
			url: BASE_URL + '/track/deletetrack',
			dataType: 'jsonp',
			data: ({ ntid: nutrition_track_id }),
			success: function (data) {
				app.loadPlan();
			}
		});
	},
	
	showGroupItems: function(groupId) {
		g_curr_group_id = groupId;

		$('#additem .simple #groups div.names').css('visibility', 'hidden');

		$('#additem .simple #groups div.icons a').animate({ opacity: 0.25, left: '-=250' }, 500, function () {
			$('#additem .simple #group-' + groupId).css('display', 'block');
			$('div#additem div.simple div#groups-back-btn').css('visibility', 'visible');
            $('div#additem div.simple #items-slogan').css('display', 'block');
		});
	},

	hideGroupItems: function(groupId) {
		$('#additem .simple .group-items div.icons a').css('background-color', 'white');
		
		$('#additem .simple #groups div.icons a').animate({ opacity: 1, left: '+=250' }, 500, function () {
			$('#additem .simple #groups div.names').css('visibility', 'visible');
		});
		$('#additem .simple #group-' + groupId).css('display', 'none');
		$('div#additem div.simple div#group-item-details').css('display', 'none');
		$('#additem .simple #group-item-details #item-id').val("");
		$('div#additem div.simple div#groups-back-btn').css('visibility', 'hidden');
		$('div#additem div.simple #items-slogan').css('display', 'none');
        
		$('#additem .simple #measure').html('Select size');
		$('#additem .simple #amount').val('1');
		$('#additem .simple .measure-ctrl-grp .ui-btn-text').html('');
	},

    verifyLoggedUser: function() {
    	if (g_is_user_logged) {
            $.mobile.changePage("#dietplan", { transition: "slidedown", reverse: false });
        	return;
        }
        
		$.mobile.loading('show');
		var storageEmail = window.localStorage.getItem("email");
		var storagePassword = window.localStorage.getItem("password");
		//alert(storageEmail + ' ' + storagePassword);
		if(storageEmail != null && storagePassword != null) {
			$('#login-bar form #email').val(storageEmail);
			$('#login-bar form #password').val(storagePassword);
			app.login(true);
		}
		else {
			$.mobile.changePage("#create", { transition: "slidedown", reverse: false });
		}			
	},
	
	evalMealName: function(hour) {
		switch(hour)
		{
			case 8:
			  return "Breakfast";
			  break;
			case 10:
			  return "Break";
			  break;
			case 13:
				return "Lunch";
				break;
			case 16:
				return "Afternoon";
				break;
			case 19:
				return "Dinner";
				break;
			case 22:
				return "Night";
				break;
		}
	},
	
	loadSimpleGroups: function() 
	{
		
		$.ajax({
            url: BASE_URL + '/track/simplegroups',
            dataType: 'jsonp',
            data: ({ }),
            success: function (data) {
                if (data.err_code == SUCCESS && data.extra_data != null) {
                    g_simple_groups = data.extra_data;
               
                    var buttons = "";
                    var links = "";
                    var row_i = 0;
                    var col_i = 0;
                    for(i=0; i < g_simple_groups.length; i++) {
                    	var col_block = (col_i == 0 ? 'a' : (col_i == 1 ? 'b' : 'c'));
                    	buttons += '<a class="ui-block-'+col_block+' ui-btn ui-btn-up-c ui-btn-inline ui-shadow ui-btn-corner-all" group="'+g_simple_groups[i].id+'" data-inline="true" data-role="button" href="#" data-corners="true" data-shadow="true" data-iconshadow="true" data-wrapperels="span" data-theme="c" style="background: #fff url(\'img/simple/'+g_simple_groups[i].image+'\') 4px 6px no-repeat;">' +
			                        '<span class="ui-btn-inner ui-btn-corner-all">' +
			                        '<span class="ui-btn-text"></span>' +
			                        '</span>' +
			                        '</a>';
                    	links += '<a class="ui-block-'+col_block+' ui-link" group="1" data-inline="true" href="#">'+g_simple_groups[i].name+'</a>';
                    	
                    	col_i++;
                    	if (col_i == 3) {
                    		col_i = 0;
                    		var row_img_block = (row_i == 0 ? 'a' : (row_i == 1 ? 'b' : (row_i == 2 ? 'c' : (row_i == 3 ? 'd' : (row_i == 4 ? 'c' : 'd')))));
                    		row_i++
                    		var row_links_block = (row_i == 0 ? 'a' : (row_i == 1 ? 'b' : (row_i == 2 ? 'c' : (row_i == 3 ? 'd' : (row_i == 4 ? 'c' : 'd')))));
                    		row_i++;
                    		
                    		$('#additem .simple #groups')
                            .append('<div class="ui-grid-'+row_img_block+' icons">' +
                                    buttons + 
                                    '</div>' +
                                    '<div class="ui-grid-'+row_links_block+' names">' +
                                    links + 
                                    '</div>');
                    		
                    		buttons = "";
                    		links = "";                            
                        }
                    }
                    
                    $('#additem .simple #groups a').click(function () {
                        var groupId = $(this).attr('group');
                        app.showGroupItems(groupId);
                    });

                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                alert(jqXHR + " - " + textStatus + " - " + errorThrown);
            }
        });
	},

	loadSimpleItems: function() 
    {
        $.ajax({
            url: BASE_URL + '/track/simpleitems',
            dataType: 'jsonp',
            data: ({ nutorg : 'usda'}),
            success: function (data) {
                if (data.err_code == SUCCESS && data.extra_data != null) {
                    g_simple_items = data.extra_data;
                    
                    var buttons = "";
                    var links = "";
                    var group_div = "";
                    var row_i = 0;
                    var col_i = 0;
                    var last_group_id = g_simple_items[0].id; 
                    for(i=0; i < g_simple_items.length; i++) {
                    	if (g_simple_items[i].group_id != last_group_id) {
                    		   $('#additem .simple #items')
                               .append('<div id="group-'+last_group_id+'" class="group-items">' + 
                            		   group_div + 
                                       '</div>');
                               
                               buttons = "";
                               links = ""; 
                               group_div = "";
                               last_group_id = g_simple_items[i].group_id; 
                    	}
                    	
                        var col_block = (col_i == 0 ? 'a' : (col_i == 1 ? 'b' : 'c'));
                        buttons += '<a class="ui-block-'+col_block+' ui-btn ui-btn-up-c ui-btn-inline ui-shadow ui-btn-corner-all" item="'+g_simple_items[i].item_id+'" data-inline="true" data-role="button" href="#" data-corners="true" data-shadow="true" data-iconshadow="true" data-wrapperels="span" data-theme="c" style="background: #fff url(\'img/simple/'+g_simple_items[i].image+'\') 4px 6px no-repeat;">' +
                                    '<span class="ui-btn-inner ui-btn-corner-all">' +
                                    '<span class="ui-btn-text"></span>' +
                                    '</span>' +
                                    '</a>';
                        links += '<a class="ui-block-'+col_block+' ui-link" item="'+g_simple_items[i].item_id+'" data-inline="true" href="#">'+g_simple_items[i].friendly_desc+'</a>';
                        
                        col_i++;
                        if (col_i == 3) {
                            col_i = 0;
                            var row_img_block = (row_i == 0 ? 'a' : (row_i == 1 ? 'b' : (row_i == 2 ? 'c' : (row_i == 3 ? 'd' : (row_i == 4 ? 'c' : 'd')))));
                            row_i++
                            var row_links_block = (row_i == 0 ? 'a' : (row_i == 1 ? 'b' : (row_i == 2 ? 'c' : (row_i == 3 ? 'd' : (row_i == 4 ? 'c' : 'd')))));
                            row_i++;
                            
                            group_div += '<div class="ui-grid-'+row_img_block+' icons">' +
                                    buttons + 
                                    '</div>' +
                                    '<div class="ui-grid-'+row_links_block+' names">' +
                                    links + 
                                    '</div>';
                            
                            buttons = "";
                            links = "";                            
                        }
                    }
                    
                    // adding the last group outside the loop
                    $('#additem .simple #items')
                    .append('<div id="group-'+last_group_id+'" class="group-items">' + 
                            group_div + 
                            '</div>');

                }
                
                $('#additem .simple .group-items div.icons a, #additem .simple .group-items div.names a').click(function () {
                    var itemId = $(this).attr('item');

                    $('#additem div.simple #items-slogan').css('display', 'none');
                    $('#additem div.simple div#group-item-details').css('display', 'block');
                    $('#additem div.simple .measure-ctrl-grp .ui-btn-text').html('Loading...');
                	$('#additem .simple .group-items div.icons a').css('background-color', 'white'); 
                	$('div#additem div.simple div.group-items div.icons a[item='+itemId+']').css('background-color', '#9999FF');
                	
                    $('#additem .simple #group-item-details #item-id').val(itemId);
                    app.getItemMeasures(itemId, 'simple');
                });

            },
            error: function (jqXHR, textStatus, errorThrown) {
                alert(jqXHR + " - " + textStatus + " - " + errorThrown);
            }
        });
    },

	onBackKeyDown: function() {
	   var page_id = $.mobile.activePage.attr('id');
	   switch (page_id) {
       case 'login':
    	   $.mobile.changePage("#create", { transition: "slide", reverse: true });
    	   break;
       case 'additem':
           $.mobile.changePage("#dietplan", { transition: "slide", reverse: true });
    	   break;
       default:
    	   break;
       }

	   return false;
	},

	onItemClicked: function(id) {
		var isMarked = $('#item-' + id).attr('marked') == "true" ? true : false;

		if (isMarked) {
			$('#item-' + id + ' span.ui-btn').removeClass('ui-btn-up-b');
			$('#item-' + id + ' span.ui-btn').addClass('ui-btn-up-d');

			$.ajax({
				url: BASE_URL + '/track/deleteplannedtrack',
				dataType: 'jsonp',
				data: ({ ld: g_log_date, piid: id }),
				success: function (data) {}
			});
		}
		else {
			$('#item-' + id + ' span.ui-btn').removeClass('ui-btn-up-d');
			$('#item-' + id + ' span.ui-btn').addClass('ui-btn-up-b');

			$.ajax({
				url: BASE_URL + '/track/insertplannedtrack',
				dataType: 'jsonp',
				data: ({ ld: g_log_date, piid: id }),
				success: function (data) {}
			});
		}

		$('#item-' + id).attr('marked', isMarked ? false : true);
	}
};

// Global functions
function pad(number, length) {
	var str = '' + number;
	while (str.length < length) {
		str = '0' + str;
	}
   
	return str;
}

function getCurrentHour(){
	var currentTime = new Date()
	var hours = currentTime.getHours()
	return hours;
}