"use strict";
/* FILTERS */
var Filters = {};
Filters.grayscale = function(canvas) {
	var pixels = canvas.getContext("2d").getImageData(0, 0, canvas.width, canvas.height);
	var imgData = canvas.getContext("2d").createImageData(canvas.width, canvas.height);
	var d = imgData.data;
	
	for (var i=0; i<d.length; i+=4) {
		var r = pixels.data[i];
		var g = pixels.data[i+1];
		var b = pixels.data[i+2];
    
		var v = (1/3.0)*r + (1/3.0)*g + (1/3.0)*b;
		d[i] = d[i+1] = d[i+2] = v;
		d[i+3]=255;
	}
	return imgData;
};

Filters.invert = function(canvas) {
	var pixels = canvas.getContext("2d").getImageData(0, 0, canvas.width, canvas.height);
	var imgData = canvas.getContext("2d").createImageData(canvas.width, canvas.height);
	var d = imgData.data;
	
	for (var i=0; i<d.length; i+=4) {
		var r = pixels.data[i];
		var g = pixels.data[i+1];
		var b = pixels.data[i+2];
    
		var v = 255-((1/3.0)*r + (1/3.0)*g + (1/3.0)*b);
		d[i] = d[i+1] = d[i+2] = v;
		d[i+3]=255;
	}
	return imgData;
};

Filters.threshold = function(canvas, threshold) {
	var pixels = canvas.getContext("2d").getImageData(0, 0, canvas.width,canvas.height);
	var imgData = canvas.getContext("2d").createImageData(canvas.width, canvas.height);
	var d = imgData.data;
  
	for (var i=0; i<d.length; i+=4) {
		var r = pixels.data[i];
		var g = pixels.data[i+1];
		var b = pixels.data[i+2];
		
		var v = (0.2126*r + 0.7152*g + 0.0722*b >= threshold) ? 255 : 0;
		d[i] = d[i+1] = d[i+2] = v;
		d[i+3]=255;
	}
	return imgData;
};

Filters.brighter = function(canvas, value){
	var pixels = canvas.getContext("2d").getImageData(0, 0, canvas.width,canvas.height);
	var imgData = canvas.getContext("2d").createImageData(canvas.width, canvas.height);
	var d = imgData.data;
	
	for (var i=0; i<d.length; i+=4) {
		var r = pixels.data[i];
		var g = pixels.data[i+1];
		var b = pixels.data[i+2];
    
		d[i] = Math.min(255, r + value);
		d[i+1] = Math.min(255, g + value);
		d[i+2] = Math.min(255, b + value);
		d[i+3]=255;
	}
	return imgData;
};

Filters.color = function(canvas, remove1, remove2){
	var pixels = canvas.getContext("2d").getImageData(0,0,canvas.width,canvas.height);
	var imgData = canvas.getContext("2d").createImageData(canvas.width,canvas.height);
	var d = imgData.data;
  
	for (var i=0; i<d.length; i+=4) {
		var r = pixels.data[i];
		var g = pixels.data[i+1];
		var b = pixels.data[i+2];
    
		d[i] = (remove1==="r" || remove2==="r") ? 0 : r;
		d[i+1] = (remove1==="g" || remove2==="g") ? 0 : g;
		d[i+2] = (remove1==="b" || remove2==="b") ? 0 : b;
		d[i+3]=255;
	}
	return imgData;
};
/* !FILTERS */