var originalImage;
var canvas = $('#canvas')[0];
$(document).ready(function(){
  if (originalImage==null) {
    var ctx = canvas.getContext('2d');
    ctx.font = "20px serif";
    ctx.fillText("Pas d'image !", 10, 50);
  }
  
  $('#loadImage').click(function(){
    loadImage();
  });
  
  $('#reset').click(function(){
    if (isImageLoaded()) {
      resetOrigin();
    }
  });
  
  $('#download').click(function(){
    if (isImageLoaded()) {
      saveImage();
    }
  });
  
  // Traitements d'image
  $('#grayscale').click(function(){
    if (isImageLoaded()) {
      canvas.getContext('2d').putImageData(Filters.grayscale(canvas), 0 ,0);
    }
    $("#navpanel")[0].toggle();
  });
  
  $('#threshole').click(function(){
    if (isImageLoaded()) {
      canvas.getContext('2d').putImageData(Filters.threshold(canvas, 150), 0 ,0);
    }
  });
  
  $('#invert').click(function(){
    if (isImageLoaded()) {
      canvas.getContext('2d').putImageData(Filters.invert(canvas), 0 ,0);
    }
  });
  
  $('#lighten').click(function(){
    if (isImageLoaded()) {
      canvas.getContext('2d').putImageData(Filters.brighter(canvas, 10), 0 ,0);
    }
  });
  
  $('#darken').click(function(){
    if (isImageLoaded()) {
      canvas.getContext('2d').putImageData(Filters.brighter(canvas, -10), 0 ,0);
    }
  });
  
  $('#red').click(function(){
    if (isImageLoaded()) {
      canvas.getContext('2d').putImageData(Filters.color(canvas, "g", "b"), 0 ,0);
    }
  });
  
  $('#green').click(function(){
    if (isImageLoaded()) {
      canvas.getContext('2d').putImageData(Filters.color(canvas, "r", "b"), 0 ,0);
    }
  });
  
  $('#blue').click(function(){
    if (isImageLoaded()) {
      canvas.getContext('2d').putImageData(Filters.color(canvas, "r", "g"), 0 ,0);
    }
  });
});

function loadImage() {
  // Equivalent d'une intent pour récupérer une image
  var activity = new MozActivity({
      name: "pick",
      data: {
         type: ["image/jpg", "image/jpeg", "img/png"]
      }
  });
  
  activity.onsuccess = function() {
    var imgSrc = this.result.blob;
    
    // creer une image
    var img = new Image();
    //img.src = 'https://mdn.mozillademos.org/files/5397/rhino.jpg';
    img.src = window.URL.createObjectURL(imgSrc);

    // Stocker image dans originalImage
    originalImage = img;

    // quand l'image est totalement charge, on la dessiner sur le canvas
    img.onload = resetOrigin;
  }

  activity.onerror = function() {
    alert("Erreur !");
  } 
}

function saveImage() {
  canvas.toBlob(function(blob) {
    var name = askForAnImgName();
    if (name == null){
      alert("Pas de nom spécifié, sauvegarde annulée !");
    } else{
      var pics = navigator.getDeviceStorage("pictures");
      var file = blob;

      var request = pics.addNamed(file, name);

      request.onsuccess = function () {
         var name2 = this.result;
         alert('Image "' + name2 + '" enregistrée !');
      };

      // An error typically occur if a file with the same name already exist
      request.onerror = function () {
         alert('Impossible d' + "'" + 'enregistrer l' + "'" + 'image: ' + this.error);
      };
     }
   });
}

function resetOrigin(){
    var height = 300*(originalImage.height/originalImage.width);
    canvas.getContext('2d').drawImage(originalImage, 0 ,0, 300, height);
}

function isImageLoaded(){
    if (originalImage==null){
        alert("Chargez une image avant !");
        return false;
    } else{
        return true;
    }
}

function askForAnImgName() {
    var str = prompt("Nom de l'image ?", "image_"+Math.round(Math.random()*100+1));
    if (str != null){
        return str.split(".")[0]+".png";
    }
    else {
        return null;
    }
}