﻿function domReady(){
      if( document.isReady ){ return };
      if( !document.body || (document.readyState && document.readyState!='complete') ) { setTimeout( domReady, 100 ); return; };
      document.isReady= true;
      
      if( !!window.TouchEvent ) document.body.className += " touch-enabled";
      if( !window.navigator.onLine ){
        document.body.className += " offline";
      }
      else{
    	  window.location= "http://immh.transgo.mobi";
    	}
    }
    
if(window.addEventListener ){ window.addEventListener('DOMContentLoaded', domReady, false ); }
else if(window.attachEvent) { window.attachEvent('onreadystatechange', domReady ); window.attachEvent('onload', domReady ); }
else{ window.onload= domReady; }
	

function transgo(){
  this.audioElement= null;
  this.player= null;
  this.useMejs= false;
  
  this.audioSource= [];
  this.playableSrc= [];
  this.doTraceTime= false;
  this.tBarSeeking= false;
  
  this.listener= {
    uiReady: {},
    winResize: null,
  };
  

  this.avCtrl= {btn:{},ui:{},togs:[]};
  
  this.slideshow= {
    container:null,
    slide:[],
    start:[],
    end:[],
    active:false,
    getActiveSlide: function( pos, setActive ){
      if(typeof pos!='number') return this.slide[active];
      for(var i=0; i< this.slide.length; i++){
        if(this.slide[i].start < pos && this.slide[i].end > pos){
          if(setActive) this.setActiveSlide(i);
          return this.slide[i];
        }
      }
      return null;
    },
    setActiveSlide: function( id ){
      if( !this.slide[id] ) return false;
      if( this.active === id ) return true;
      trace('setActiveSlide->'+id);
      if( this.slide[this.active] ){
        this.slide[this.active].elem.className= this.slide[this.active].elem.className.replace(/\s?\bactive\b/g,'');
      } 
      this.active= id;
      this.slide[id].elem.className+= ' active';
      return true;
    }
  };
  
  
  this.dial= {
    value: null,
    baseHref: null,
    display: null,
    keys: {},
    
    init: function(me){
      var c;
      var me= document.getElementById(me);
      me.dial= this;
      this.container= me;
      var di= document.getElementsByClassName('di');
      for(var i=0; i<di.length; i++){
        if( !this.display && di[i].className.match(/\bd\b/) ){
          this.display= di[i];
          continue;
        }
        if( !(c= di[i].className.match(/\bk([\dXG]\b)/)[1]) ) continue;
        this.keys[c]= di[i];
        di[i].dial= this;
        if( c.match(/\d/) ) di[i].onclick= function(e){ this.dial.pressNum(this,e) };
        else if( c=='&lt;') di[i].onclick= function(e){ this.dial.pressRwd(this,e) };
        else if( c=='&gt;') di[i].onclick= function(e){ this.dial.pressFwd(this,e) };
        else if( c=='X')    di[i].onclick= function(e){ this.dial.pressDel(this,e) };
//        else if( c=='G')    di[i].onclick= this.pressGo;
      }
      this.baseHref= this.keys.G.href;
      trace('dialpad'+dump(this,2,0,1));
    },
    pressNum: function(me,e){
      this.display.innerHTML+= me.innerHTML;
      if(this.display.innerHTML.length>4) this.display.innerHTML= me.innerHTML;
      this.keys.G.href= this.baseHref+this.display.innerHTML;
      e.stopPropagation(); e.preventDefault();
    },
    pressFwd: function(me){
      this.display.innerHTML= parseInt(this.display.innerHTML)+1;
      this.keys.G.href= this.baseHref+this.display.innerHTML;
    },
    pressRwd: function(me){
      this.display.innerHTML= parseInt(this.display.innerHTML)-1;
      this.keys.G.href= this.baseHref+this.display.innerHTML;
    },
    pressDel: function(me){
      var n= this.display.innerHTML;
      this.display.innerHTML= n.substr(0,n.length-1);  
      this.keys.G.href= this.baseHref+this.display.innerHTML;
      e.stopPropagation(); e.preventDefault();
    },
    pressOk: function(me){
      window.location= this.title+this.dial.display.innerHTML;  
    }
    
  }
  
  
  this.init= function(){
trace('46: TGO INITs ');
    this.debug= !!document.body.className.match(/\b(debug|debugJs)\b/);
    if(this.debug) catcherr();
    trace('navigtor='+ dump(navigator) );
//    window.onresize= this.checkWindow;
  };


  this.load= function(){
  };
  
  
  this.cast= function(e){
trace('cast "'+e+'" to '+ dump(this.listener,2));
    for(var i in this.listener[e]){
// trace('cast "'+e+'" to '+i);
      this.listener[e][i].apply(this);
    }
    
  }
  
  
  this.initPcodeForm= function(){
    var pc= document.getElementById('pcode');
    pc.onfocus= function(){
      if(!this.undefault){
        this.undefault=this.value; this.value='';
      }; 
    };
  };
  
  this.initSlides= function(slides){
    var s,start,end;
    for(var i=0; i<slides.length; i++){
// trace('initSlide '+slides[i]);
      s= document.getElementById(slides[i]);
      start= parseFloat(s.style.left)/100;
      end= start + parseFloat(s.style.width)/100; 
      this.slideshow.slide[i]= {
        id:slides[i],
        start:start,
        end:end,
        elem:s
        };
      this.slideshow.start[i]= start;
      this.slideshow.end[i]= end;
    }
    this.slideshow.container= s.parentElement;
    trace( "slides ready" + dump(this.slideshow,1) );
    this.slideshow.setActiveSlide(0);
    this.scrollCenter(this.slideshow.container);
    this.setUiUpper(this.slideshow.container);
  };
  
  this.initAudio= function(id){
    trace( "initAudio "+id+' = '+ document.getElementById(id));
    ae= this.audioElement= document.getElementById(id);
    ae.tgo= this;

    this.getAudioSources(true);
//    if(1 || !this.playableSrc.length ){
    if(!this.playableSrc.length ){
      this.initMejs(ae);
      return '-1';
    }

    this.player= ae;
    if(this.debug){
      ae.volume= .1;
    }
    
    ae.setCurrentTime= function(t){ this.currentTime=t; };
    
    ae.getDuration= function(check,reload,src){
      if(this.duration){
        this.hasNoRealDuration= false;
        return this.duration;
      }
// BÖSER HACK FÜR DUMMES iOS
      if(!reload && this.mediaDuration) return this.mediaDuration;

      this.hasNoRealDuration= true;
      var tt= document.getElementById('tt').value;
//      if(!check && tt) return tt;

      var be= (this.buffered.length ? this.buffered.end(0) : 0);
trace('ae.gd('+src+'): bf.end='+ dump(be) +', tt.val='+ tt+', dur='+this.duration );
      if(src!='slp') this.tgo.setLoadProgress();
      if( be && tt && Math.abs(be-tt)<.5 ){
        this.mediaDuration= be;
        document.body.addClass('iosHackEnabled');
        return be;
      }
      return tt; 
    }

    this.attachAudioListeners();
    this.attachAudioUi();
    
// another BÖSER HACK FÜR DUMMES iOS
    if( navigator.userAgent.match(/Mobile.*Safari/) ){
      var aesrc=
      this.player.src=
      this.audioSource[ this.playableSrc[0] ].elem.src= 
        this.audioSource[ this.playableSrc[0] ].src +'?'+ (new Date).getTime();
      trace('initAudio(): iOS Hack set ae.src= '+ aesrc);
    }
  }

/*- _mejs -*/

  this.initMejs= function(me){
    if(!me) me= this.audioElement;
    MediaElement(me, {
      success: function(me){ tgo.mejsLoaded(me);  },
      error:   function(me){ tgo.mejsLoadErr(me); }
    });
  };
  
  this.mejsLoaded= function(me){
trace( "mejsLoaded(): "+dump(me,0)+' loaded' );
    mae= this.player= me;

    if(this.debug){
      mae.setVolume( .1 );
    }
    mae.getDuration= function(check,reload,src){
      return this.duration ? this.duration : document.getElementById('tt').value;
    };
    this.useMejs= true;
    this.attachAudioListeners();
trace( "mejsLoaded(): all done" );
    this.attachAudioUi();
  };

  this.mejsLoadErr= function(me){
trace( "MEJS PLAYER FAILED " );
    this.setFallback();
  };
  
  this.setFallback= function(){
    this.avCtrl.container.addClass('failed');
    alert('Audio kann nicht abgespielt werden');
  };
  



  this.checkWindow= function(){
//    alert('winresize '+this);
    tgo.setWindowSize( window.innerWidth, window.innerHeight);
  }
  
  this.setWindowSize= function(w,h){
    var ar= w/h;
    trace(ar);
  }
  
  this.scrollCenter= function(me){
    window.scrollTo( 0, -(window.innerHeight-me.offsetHeight)/2+ me.offsetTop  );
  }
  
/*- _media control -*/
  
  this.attachAudioListeners= function(ae){
    var pl= this.player;
    pl.tgo= this;
    var l= this.listener.audio= {};
trace('attachAudioListeners() to player'+ dump(pl,0) +', currentSrc='+ dump(pl.currentSrc) );
    l.lmd= pl.addEventListener('loadedmetadata',  function(e){ this.tgo.setReadyState(this,e,'lmd'); } ,false);
    l.rsc= pl.addEventListener('readystatechange',function(e){ this.tgo.setReadyState(this,e,'rsc'); } ,false);
    l.dch= pl.addEventListener('durationchange',  function(e){ this.tgo.setReadyState(this,e,'dc' ); } ,false);
//    pl.addEventListener('durationchange',function(e){ this.tgo.setDurationChange(this,e);} ,false);
    l.prg= pl.addEventListener('progress',        function(e){ this.tgo.setLoadProgress(this,e);     } ,false);
    l.tup= pl.addEventListener('timeupdate',      function(e){ this.tgo.runShow(this,e);             } ,false);
    l.ply= pl.addEventListener('play',            function(e){ this.tgo.setPlayStatus(null,e,'play');} ,false);
    l.pau= pl.addEventListener('pause',           function(e){ this.tgo.setPlayStatus(null,e,'paus');} ,false);
    l.end= pl.addEventListener('ended',           function(e){ this.tgo.setPlayStatus(null,e,'ende');} ,false);
    l.cpl= pl.addEventListener('canplay',         function(e){ this.tgo.setPlayStatus(null,e,'canp');} ,false);
trace('attachAudioListeners() done. mejs='+this.useMejs+'\nlistener= '+dump(l)); 
    if(!this.useMejs) this.setLoadProgress( null, null, 'attachAudioListeners()' );
  }  
  
  this.attachAudioUi= function(){
    var pl= this.player;
    var avc= document.getElementsByClassName('avCtrl');
    var c={};
trace( 'attachAudioUi() avc-elems= '+ dump(avc,1,0,0) );
    for(var i=0; i<avc.length; i++){
      if(      avc[i].className.match(/\bcontainer\b/) ) (c.co= this.avCtrl.container=  avc[i]).tgo= this;
      else if( avc[i].className.match(/\bbtnMain\b/)   ) (c.bm= this.avCtrl.btn.main=   avc[i]).tgo= this;
      else if( avc[i].className.match(/\bbtnExt\b/)    ) (c.be= this.avCtrl.btn.ext=    avc[i]).tgo= this;
      else if( avc[i].className.match(/\bbtnReplay\b/) ) (c.br= this.avCtrl.btn.replay= avc[i]).tgo= this;
      else if( avc[i].className.match(/\bbtnFull\b/)   ) (c.bf= this.avCtrl.btn.full=   avc[i]).tgo= this;
      else if( avc[i].className.match(/\buiTimebar\b/) ) (c.ub= this.avCtrl.ui.tbar=    avc[i]).tgo= this;
      else if( avc[i].className.match(/\buiTrack\b/)   ) (c.ut= this.avCtrl.ui.track=   avc[i]).tgo= this;
      else if( avc[i].className.match(/\buiHead\b/)    ) (c.uh= this.avCtrl.ui.head=    avc[i]).tgo= this;
      else if( avc[i].className.match(/\buiLoaded\b/)  ) (c.ul= this.avCtrl.ui.loaded=  avc[i]).tgo= this;
    }
//    if(c.co) this.attachAudioTog(c.co);
    if(c.bm) this.attachAudioTog(c.bm); // c.bm.addEventListener('click', function(e){ this.tgo.clickMainBtn(this,e) },false);
    if(c.ut){
      c.ut.addEventListener('mousedown',  function(e){ this.tgo.pressTimebar(this,e) },false);
      c.ut.addEventListener('touchstart', function(e){ this.tgo.pressTimebar(this,e) },false);
      c.ut.addEventListener('click',      function(e){ this.tgo.clickTimebar(this,e) },false);
    }
    if(c.br){
      c.br.addEventListener('click', function(e){ this.tgo.doReplay(this,e) },false);
    }
    if(c.bf){
      c.bf.addEventListener('click', function(e){ this.tgo.toggleFullscreen(this,e) },false);
    }
    if(this.slideshow.container){
      this.slideshow.container.tgo= this;
      this.slideshow.container.addEventListener('click', function(e){ this.tgo.toggleFullscreen(this,e) },false);
    }

//    c.ul.addEventListener('click',function(e){ trace( dump(this.tgo.player) ) },false);
//    c.uh.addEventListener('mousedown',function(e){ this.tgo.pressPlayhead(this,e) },false);
    if(c.ubp= document.getElementsByClassName('uib')[4]){
      this.attachAudioTog(c.ubp);
    }
    this.cast('uiReady');
  }
  
  this.attachAudioTog= function(me){
    this.avCtrl.togs.push(me);
    me.tgo= this;
    me.addEventListener('click', function(e){ this.tgo.doMainToggle(e) }, false);
    this.setPlayStatus(me,null,'attachAudioTog');
  }

  this.getAudioSources= function(check,force){
    if( !force && this.audioSource.length ) return this.audioSource;
    var i, plbl;
    var aecn= this.audioElement.childNodes;
    for(i in aecn){
      if(!aecn[i].tagName || !aecn[i].tagName.match(/source/i) ) continue;
// trace('90:'+ aecn[i].tagName +'=='+ (aecn[i].tagName.match(/source/i)) );
      plbl= (check ? (this.audioElement.canPlayType(aecn[i].type) ? true : false) : null );
      if(plbl) this.playableSrc.push(this.audioSource.length);
      this.audioSource.push( {
        id:aecn[i].id,
        type:aecn[i].type,
        src:aecn[i].src,
        playable:plbl,
        elem:aecn[i] 
        } );
    }
    return this.audioSource;
  }
  
  
  this.setLoadProgress= function(me,e,src,noRecurse){
// me: player obj, e: event
    if(!me && !(me=this.player)){
      trace('setLoadProgress(): no player attached');
      return false;
    } 

trace('setLoadProgress() buf='+ dump( me.buffered ) );
    var lp= me.buffered.length ? me.buffered.end(0)/me.getDuration(0,0,'slp') : 0;

trace('setLoadProgress(<-'+src+') readyState='+ me.readyState +',  buf='+ (me.buffered.length ? me.buffered.end(0) : '{}') +' / '+ me.getDuration(0,0,'slp') +' = '+ lp +', UI='+dump(this,0,0,1));

    if(this.doTraceTime) document.getElementById('lp').value= Math.round(lp*100);
    if(this.avCtrl.ui.loaded){ // loaded is a <DIV>!!
      return this.avCtrl.ui.loaded.style.left= (Math.round(lp*1000)/10)+'%';
    }
    else if(!noRecurse){
      trace('setLoadProgress(): no UI attached, postpone to {@uiReady}');
      this.listener.uiReady.setLoadBar=  function(){ this.setLoadProgress() };
      return 'uiReady.call';
    }
  };
  
  
  this.setDurationChange= function(me,e){
//     if(!me && !(me=this.player)){
//       trace('setDurationChange(): no player attached');
//       return false;
//     } 
    trace( 'ae.durationChange('+me+','+e+','+loop+'): '
//           +' -> '+dump(e,0,1)+'\n'
//           +'dur='+ dump(me.duration) +', buf='+me.buffered.end(0)+'\n'
//           +'tt='+ dump(document.getElementById('tt').value)
//           +', gd()='+ dump(me.getDuration())
         );
//     if(me.duration.toString()==='NaN'){
//       trace('setDurationChange: NaN');
// //      if(this.durationChangeTries++>5) return false;
//       setTimeout( 
//         function(){
//           trace("setDurationChange-loop: "+ dump(tgo.player.getDuration()));
// //          tgo.setDurationChange(); 
//         }
//         ,1000);
//       return NaN;
//     }
//     return this.setLoadProgress(me,e);
  }
  

  this.setReadyState= function(me,e,src){
    trace( 'ae.readyState('+src+'):  -> e='+dump(e,0,1)+'\n'
          +'dur='+ dump(me.duration) +', buf='+ (me.buffered.length ? me.buffered.end(0) : '{}')+'\n'
          +'ae.gdur()='+ me.getDuration()
         );
    this.setLoadProgress(me,e);
  }
  

/*- _ui interaction -*/

  this.clickMainBtn= function(me,e){
    this.doMainToggle(e);
  };
  
  this.clickTimebar= function(me,e){
    return;
    var sp= this.getSeekPos(me,e,1);
    this.player.setCurrentTime( sp * this.player.getDuration() );
trace( 'tbarCLICKed @ x'+ e.pageX +'='+ Math.round(this.getSeekPos(me,e)*100) +'% * '+ this.player.getDuration() +'s => '+ this.player.currentTime ); // +' '+dump(this,1,0,0) );
    if(this.player.hasNoRealDuration){
      setTimeout( function(){tgo.player.play()},100);
    }
    e.stopPropagation(); e.preventDefault();
  };

  this.pressTimebar= function(me,e){
    var sp= this.getSeekPos(me,e,1);
trace( 'tbarPRESSed @ x'+ e.pageX +'='+ Math.round(sp*100) +'% * '+this.player.getDuration() +'s => '+ this.player.currentTime ); // +' '+dump(this,1,0,0) );
    this.player.setCurrentTime( this.player.seekTargetTime= sp * this.player.getDuration() );
    this.startSeek(window,e);
    e.stopPropagation(); e.preventDefault();
  };

  this.pressPlayhead= function(me,e){
//    trace( 'headPressed' );
    e.stopPropagation(); e.preventDefault();
  }

  this.startSeek= function(me,e){
    this.player.playAfterSeek= !(this.player.paused || this.player.ended);
    this.player.timeBeforeSeek= this.player.currentTime;
    this.tBarSeeking= true;
    
//    this.player.pause();
    me.onmouseup=   function(e){ tgo.stopSeek(this,e)};
    me.ontouchend=  function(e){ tgo.stopSeek(this,e)};
    me.onmousemove= function(e){ tgo.doSeek(this,e)  };
    me.ontouchmove= function(e){ tgo.doSeek(this,e)  };
trace( 'startSeek @ '+me );
  }

  this.doSeek= function(me,e){
//    trace( 'doSeek() e.touch[0]='+ (e.touches && e.touches[0] ? dump(e.touches[0],1) : '--') +', pos='+ this.getSeekPos(me,e) );
    var sp= this.getSeekPos(me,e);
    var d=  this.player.getDuration();
    var st= this.player.seekTargetTime= sp * d;
    this.player.setCurrentTime( st );
    this.setPlayHead( sp );
    e.stopPropagation(); e.preventDefault();
  }

  this.stopSeek= function(me,e){
    me.onmousemove= null;
    me.ontouchmove= null;
    me.onmouseup=  null;
    me.ontouchend= null;
    this.tBarSeeking= false;
//    if(this.player.playAfterSeek) this.player.play();
trace( 'stopSeek & '+ (this.player.playAfterSeek ? 'play' : 'pause') +' @ '+me+'\n'
//       +'hack ? hasNoReDur='+ this.player.hasNoRealDuration +'\n'
//       +'e='+ dump(e,1)
     );
    if(this.player.hasNoRealDuration) this.seekHack('stopSeek');
    e.stopPropagation(); e.preventDefault();
  }
  
  this.getSeekPos= function(me,e,reload){
//     trace('e.x='+ e.pageX +', e.t[0].x='+ (e.touches && e.touches[0] ? e.touches[0].pageX : '--') +', uiTkX='+ this.getUiTrackX() );
     var pos= ( (e.pageX ? e.pageX : (e.touches && e.touches[0] ? e.touches[0].pageX : 1)) - this.getUiTrackX(reload) ) / this.avCtrl.ui.track.offsetWidth;
     return pos < 0 ? 0 : (pos > 1 ? 1 : pos)
  }
  this.getUiTrackX= function(reload){
    if(!reload && typeof this.uiTrackX != 'undefined') return this.uiTrackX
    var ret= this.uiTrackX= this.avCtrl.ui.track.getGlobal('offsetLeft');
    trace('getUiTrackX() -> '+ret);
    return ret;
  }

  
  this.seekHack= function(src){
trace('seekHack('+src+'), setTimeout HACK');
//      setTimeout( function(){ tgo.seekHackCallback() },100);
    this.seekHackCallback();
  }
  this.seekHackCallback= function(me,e){
    trace('callback setTimeout seek HACK, seekTargetTime='+ this.player.seekTargetTime);
    this.player.setCurrentTime( 0 );
  }
  
  
  
  this.showUi= function(me,e){
trace( 'UI up @ '+me );
    e.stopPropagation(); e.preventDefault();
  }
  this.setUiUpper= function(me){
    me.addEventListener('click', function(e){ tgo.showUi(this,e) }, false);
  }
  
  
  this.toggleFullscreen= function(me,e) {
    if(document.body.className.match(/\bfullscreen\b/)){
      document.body.rmClass('fullscreen');
      return 0;
    }
    else{
      document.body.addClass('fullscreen');
      return 1;
    }
  }


/*- _play control -*/
  this.runShow= function(ae){
    var d= ae.getDuration();
    var pos= d ? ae.currentTime / d : 0.01;
    if(!this.tBarSeeking) this.setPlayHead(pos);
    this.slideshow.getActiveSlide(pos,'set');
    if(this.doTraceTime) document.getElementById('t').value= this.slideshow.active +' | '+ pos;
    this.ctp= this.ctp ? '' : ':   ';
    if(this.debug) document.getElementById('aect').innerHTML= this.ctp + Math.round(ae.currentTime    *1000)/1000;
    if(this.debug) document.getElementById('aebf').innerHTML= Math.round(ae.buffered.length ? ae.buffered.end(0)*1000 : 0)/1000;
    if(this.debug) document.getElementById('aedu').innerHTML= Math.round(ae.duration       *1000)/1000;
  };
  
  this.setPlayHead= function(pos){
    if(!pos) var pos= this.player.currentTime / this.player.getDuration(false);
    var ph= this.avCtrl.ui.head;
    ph.style.right= 100-(Math.round( pos*1000 )/10)+'%';
// trace( tgo.avCtrl.ui.head.style.left );
  }
  
  
  
  this.doMainToggle= function(e){
    var ae= this.player;
//    trace( 'doMainToggle(): ae.dur='+ ae.duration +'\n'
//          +'ae.cT='+ (Math.round(ae.currentTime*10)/10) +'\n' 
//          +'ae.buf='+ ae.buffered.end(0) +'\n'
//          +'ae.gd()='+ ae.getDuration() +'\n'
//          +'ae.curSrc='+ ae.currentSrc +'\n'
//          +'ua='+ navigator.userAgent
//         );
    if(this.player.ended || this.player.paused){
      this.player.play();
    }
    else {
      this.player.pause();
    }
// trace( dump(this.player,1,1) );
  };
  
  
  this.doReplay= function(e){
    this.player.setCurrentTime( 0 );
    this.player.play();
  }
  
  
  this.setPlayStatus= function(me,e,src){
// trace('setPlayStatus_1 von '+ me ); 
    var c, b;
    if(!me){
      b= this.avCtrl.btn.main || 0;
//      if(b) b.innerHTML= this.player.error ? 'X-þ' : (this.player.paused || this.player.ended ? '>' : '');
    }
    if( this.player.error ) c= { add:'failed', rm:['plays','waits','pauses','seeks'] };
    else if( this.player.paused || this.player.ended )  c= { add:'pauses', rm:['plays','waits','pauses','failed'] };
//    else if( this.player.paused )  c= { add:'pauses', rm:['plays','waits','pauses','failed'] };
    else c={ add:'plays', rm:['waits','pauses','seeks','failed'] };

//    if(b) b.addClass( c.add, c.rm );
//    if( b=this.avCtrl.ui.container ) b.addClass( c.add, c.rm );
    var t= me ? [me] : this.avCtrl.togs;
trace('setPlayStatus(src='+src+') auf '+ c.add +' für '+ t.join(';') ); 
    for(var i=0; i < t.length; i++){
      t[i].addClass( c.add, c.rm );
    }
    
  };
  
};


/*- _common functions -*/

(function( window, undefined ) {
  var htmlNode= ( typeof HTMLElement != 'undefined' )
                  ? HTMLElement 
                  : ( ( typeof Element != 'undefined' )
                      ? Element
                      : Object
                    );
  var htmlNodeProto= htmlNode.prototype;
  
  htmlNodeProto.isDescendantOf= function(ancestor,maxDepth){
  // RFE: node.compareDocumentPosition( otherNode )
    if(!maxDepth) var maxDepth= 1000;
    if(typeof ancestor != 'object') return false;
    var pa=this;
    var depth=1;
    while( (pa=pa.parentNode) && (!maxDepth || depth<=maxDepth ) ){
      if(pa==ancestor) return depth;
      depth++;
    }
    return false;
  };

  htmlNodeProto.addClass= function(add,rm){
    if(rm) this.rmClass(rm);
    if(this.className){
      if( !this.className.match( new RegExp('\\b'+ add +'\\b') ) ){
        this.className+= " "+ add;
      }
    }
    else{
      this.className= add;
    }
    return this.className;
  };
  
  htmlNodeProto.rmClass= function(clas){
    var re= new RegExp('\\b'+ (typeof clas=='object' ? '('+ clas.join('|') +')' : clas) +'\\b','g');
    var nu= this.className.replace(re,' ').replace(/(^\s+|(\s)+|\s+$)/g,'$2');
    this.className= nu;
    return this.className;
  };
  
  htmlNodeProto.getChildsByClass= function( str ){
    var re= str.constructor==RegExp ? str : ( new RegExp('\\b'+ (typeof str=='object' ? '('+ str.join('|') +')' : str) +'\\b','g') );
    return this.getChildsBy('className',re); 
  }
  htmlNodeProto.getChildsByName= function( str ){ return this.getChildsBy( 'name', str) }; 

  htmlNodeProto.getChildsByTag=  function( str ){
    var re= str.constructor==RegExp ? str : (new RegExp('^'+str+'$','i'));
    return this.getChildsBy('tagName',re); 
  }; 

  htmlNodeProto.getChildsBy= function(prop,str){
    var cn= this.childNodes
    var ret= [];
    for(var i in cn){
trace( this+' ch['+i+']'+ cn[i] +' has '+prop+' = '+cn[i][prop]+(str.constructor==RegExp ? ' match ' :'==')+str+' ? ' );
      if(cn[i].nodeType!=1) continue;
      if( str.constructor==RegExp ?  cn[i][prop].match(str) : (cn[i][prop]==str) ) ret.push(cn[i]);
    }
    return ret; 
  }
  
  htmlNodeProto.getGlobal= function(prop,maxd){
    if(!maxd) var maxd=20;
    ret= 0;
    var n= this;
    while(n && n!=document && maxd--){
      ret+= n[prop];
      n= n.parentNode;
    }
    return ret;    
  }
  
  
})( window );



