var directions = new google.maps.DirectionsService();
var renderer = new google.maps.DirectionsRenderer();
var map, transitLayer;

function geocoder(){
  var geocoder = new google.maps.Geocoder();

  if (navigator.geolocation) {
    navigator.geolocation.getCurrentPosition(successFunction, errorFunction);
  } 

  function successFunction(position) {
    var lat = position.coords.latitude;
    var lng = position.coords.longitude;
    var latlng = new google.maps.LatLng(lat, lng);
    geocoder.geocode({'latLng': latlng}, function(results, status){
      if (status == google.maps.GeocoderStatus.OK) {
        if (results[1]) {
          sourceAdress = results[0].formatted_address;
          var source = document.getElementById('from');
          source.value = sourceAdress;
          for (var i=0; i<results[0].address_components.length; i++) {
            for (var b=0;b<results[0].address_components[i].types.length;b++) {
              if (results[0].address_components[i].types[b] == "administrative_area_level_1") {
                city= results[0].address_components[i];
                break;
              }
            }
          }
        } 
        else {
          alert("No results found");
        }
      } 
      else {
        alert("Geocoder failed due to: " + status);
      }
    });
  }

  function errorFunction(){
    alert("Geocoder failed");
  }
}

function initialize() {
  var mapOptions = {
    center: { lat: 13.082, lng: 80.27},
    zoom: 10,
    mapTypeId: google.maps.MapTypeId.ROADMAP
  };

  map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);
  google.maps.event.addDomListener(document.getElementById('go'), 'click', route);
  document.getElementById("track").onclick = geocoder;
  var source = document.getElementById('from');
  var autocomplete = new google.maps.places.Autocomplete(source);
  autocomplete.bindTo('bounds', map);

  var destination = document.getElementById('to');
  var autocomplete = new google.maps.places.Autocomplete(destination);
  autocomplete.bindTo('bounds', map);

  transitLayer = new google.maps.TransitLayer();

  route();
}


function route() {
  var departure = '';
  var bits = departure.split(':');
  var now = new Date();
  var tzOffset = (now.getTimezoneOffset() + 60) * 60 * 1000;

  var time = new Date();
  time.setHours(bits[0]);
  time.setMinutes(bits[1]);

  var ms = time.getTime() - tzOffset;
  if (ms < now.getTime()) {
    ms += 24 * 60 * 60 * 1000;
  }

  var departureTime = new Date(ms);

  var request = {
    origin: document.getElementById('from').value,
    destination: document.getElementById('to').value,
    travelMode: google.maps.DirectionsTravelMode.TRANSIT,
    provideRouteAlternatives: true,
    transitOptions: {
      departureTime: departureTime
    }
  };

  var panel = document.getElementById('panel');
  panel.innerHTML = '';
  directions.route(request, function(response, status) {
    if (status == google.maps.DirectionsStatus.OK) {
      renderer.setDirections(response);
      renderer.setMap(map);
      renderer.setPanel(panel);
    } else {
      renderer.setMap(null);
      renderer.setPanel(null);
    }
  });

}

google.maps.event.addDomListener(window, 'load', initialize);
