function CharMap() {
    this.nil = new Array(256);
    this.map = new Array(256);
    for (var i = 0; i < 256; ++i)
        this.map[i] = this.nil;
}

CharMap.prototype = {
get: function(code) { return this.map[code >> 8][code & 0xff]; },
set: function(code, value) {
    var hi = code >> 8;
    if (this.map[hi] == this.nil)
        this.map[hi] = new Array(256);
    this.map[hi][code & 0xff] = value;
}}

var Abc = {
langs: [null,
    ["de", 0, "A-ZÄÖÜß"],
    ["en", 0, "A-Z"],
    ["es", 0, "A-ZÑ"],
    ["fr", 0, "A-ZÀÂÇÈÉÊËÎÏÔÙÛÜŸÆŒ"],
    ["it", 0, "A-IL-VZÈÉÎÒÓ"],
    ["pl", 0, "A-ZĄĆĘŁŃÓŚŹŻ"],
    ["ru", 1, "А-ЯЁ"],
    ["tr", 0, "A-PR-VYZÇĞİıÖŞÜÂÎÛ"],
    ["uk", 1, "А-ЩЬЮЯҐІЄЇ"]],

expand: function(s) {
    var result = "";
    for (var i = 0; i < s.length; ++i) {
        var ch = s.charAt(i);
        if (ch != '-') {
            result += ch;
            continue;
        }
        var from = s.charCodeAt(i - 1), to = s.charCodeAt(i + 1);
        for (var code = from + 1; code < to; ++code)
            result += String.fromCharCode(code);
    }
    return result;
},

init: function() {
    this.chars = new CharMap();
    this.lids = {};
    for (var lid = 1; lid < this.langs.length; ++lid) {
        this.lids[this.langs[lid][0]] = lid;
        var mask = 1 << lid;
        var s = this.expand(this.langs[lid][2]);
        s += s.toLowerCase();
        for (var i = 0; i < s.length; ++i) {
            var code = s.charCodeAt(i);
            this.chars.set(code, this.chars.get(code) | mask);
        }
    }
},

check: function(s, langs) {
    var lidA = this.lids[langs[0]], lidB = this.lids[langs[1]];
    if (!lidA || !lidB)
        return "";
    var hypos = [[1 << lidA, 0, 0], [1 << lidB, 0, 0]];
    var divisor = (this.langs[lidA][1] == this.langs[lidB][1] ? 20 : 1000);
    var textLen = 0, nextCheckLen = 100;
    for (var i = 0; i <= s.length; ++i) {
        if (i < s.length) {
            var code = s.charCodeAt(i);
            var mask = this.chars.get(code);
            if (mask) {
                ++textLen;
                for (var j = 0; j < 2; ++j) {
                    if (mask & hypos[j][0])
                        hypos[j][1]++;
                    else if (code < 0x80)
                        hypos[j][2]++;
                }
            }
        }
        if (textLen >= nextCheckLen || i == s.length) {
            nextCheckLen += 100;
            var minDiff = Math.min(1 + Math.floor(textLen / divisor), 5);
            var w = [0, 0];
            for (var j = 0; j < 2; ++j)
                w[j] = hypos[j][1] + (hypos[j][1] ? hypos[j][2] : 0) / 2;
            var diff = w[1] - w[0];
            if (diff < 0)
                break;
            if (diff >= minDiff)
                return langs[1];
        }
    }
    return langs[0];
}
}

Abc.init();
