var ya_ = {};

(function($) {
$.util = {
    attachEvent: function(ctrl, event, handler) {
        function wrapper() {
            window.event.target = window.event.srcElement;
            return handler(window.event);
        }
        if (ctrl.addEventListener) {
            ctrl.addEventListener(event, handler, false);
            return handler;
        }
        ctrl.attachEvent("on" + event, wrapper);
        return wrapper;
    },

    detachEvent: function(ctrl, event, handler) {
        if (ctrl.removeEventListener)
            ctrl.removeEventListener(event, handler);
        else
            ctrl.detachEvent("on" + event, handler);
    },

    cancelEvent: function(event) {
        if ("preventDefault" in event)
            event.preventDefault();
        else
            event.returnValue = false;
    },

    htmlEncode: function(str) {
        return str.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
    },

    trim: function(str) {
        return str.replace(/^\s+|\s+$/g, "");
    },

    isAlpha: function(ch) {
        return ch.toLowerCase() != ch.toUpperCase() || ch.charCodeAt(0) == 0xdf;
    },

    createElement: function(tag, attrs, styles) {
        var elem = document.createElement(tag), attr;
        if (attrs) {
            for (attr in attrs)
                elem[attr] = attrs[attr];
        }
        if (styles) {
            for (attr in styles)
                elem.style[attr] = styles[attr];
        }
        return elem;
    },

    selectValue: function(ctrl, value) {
        ctrl.selectedIndex = -1;
        for (var i = 0; i < ctrl.options.length; ++i) {
            if (ctrl.options[i].value == value) {
                ctrl.selectedIndex = i;
                break;
            }
        }
        return ctrl.selectedIndex;
    },

    getSelectedValue: function(ctrl) {
        var index = ctrl.selectedIndex;
        return index < 0 ? "" : ctrl.options[index].value;
    },

    newSet: function(keys) {
        var set = {};
        for (var i = 0; i < keys.length; ++i)
            set[keys[i]] = 1;
        return set;
    },

    time: function() {
        return (new Date).getTime();
    },

    setCookies: function(name, dic, days) {
        var attr, value = "", sep = "";
        for (attr in dic) {
            value += sep + attr + "=" + dic[attr];
            sep = ":";
        }
        var expires = new Date($.util.time() + (days || 100) * 24 * 3600 * 1000);
        document.cookie = name + "=" + value + "; expires=" + expires.toUTCString();
    },

    getCookies: function(name) {
        var items = document.cookie.split("; ");
        var dic = {};
        for (var i = 0; i < items.length; ++i) {
            var item = items[i];
            var pos = item.indexOf("=");
            if (pos <= 0 || item.substr(0, pos) != name)
                continue;
            var attrs = item.substr(pos + 1).split(":");
            for (var j = 0; j < attrs.length; ++j) {
                var pair = attrs[j].split("=");
                dic[pair[0]] = pair[1] || "";
            }
            break;
        }
        return dic;
    },

    apply: function (target, fields) {
        for (var key in fields) if (fields.hasOwnProperty(key)) {
            target[key] = fields[key];
        }
    }
};

$.ajax = {
    createRequest: function() {
        if (window.XMLHttpRequest)
            return new XMLHttpRequest();
        if (window.ActiveXObject)
            return new ActiveXObject("Msxml2.XMLHTTP");
        return null;
    },

    sendQuery: function(query) {
        var request = this.createRequest();
        if (!request)
            return null;

        request.onreadystatechange = function() {
            if (request.readyState != 4)
                return;
            if (request.status == 200) {
                query.callback(request);
                return;
            }
            var msg = request.status + " (" + request.statusText + ")";
            query.callback(null, { type: "HttpError", message: msg, url: query.url });
        };

        var queryStr = "", arg;
        for (arg in query.args) {
            var value = query.args[arg];
            if (!(value instanceof Array))
                value = [ value ];
            for (var i = 0; i < value.length; ++i) {
                if (queryStr != "")
                    queryStr += "&";
                queryStr += arg + "=" + encodeURIComponent(value[i]);
            }
        }
        var queryUrl = query.url;
        if (query.method == "GET") {
            queryUrl += "?" + queryStr;
            queryStr = null;
        }

        request.open(query.method, queryUrl, true);
        if (query.method == "POST")
            request.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        request.send(queryStr);
        return request;
    }
};

$.json = {
    TIMEOUT: 20000, // milliseconds
    id: 0,
    r: {},
    prefix: 'json-query',

    sendQuery: function(query) {
        var id = (this.id++);
        this.r[id] = query;

        var queryStr = "callback=ya_.json.c(" + id + ")";
        for (var arg in query.args) {
            var value = query.args[arg];
            if (!(value instanceof Array))
                value = [ value ];
            for (var i = 0; i < value.length; ++i)
                queryStr += "&" + arg + "=" + encodeURIComponent(value[i]);
        }
        var queryUrl = query.url + "?" + queryStr;

        var head = document.getElementsByTagName("head")[0];
        var script = $.util.createElement("script"
            , { type: "text/javascript", src: queryUrl, charset: "utf-8", id: this.prefix + id });
        query.timer = window.setTimeout(
            function() { $.json.timeout(id) }, $.json.TIMEOUT);
        head.appendChild(script);
    },

    c: function(id) {
        var r = this.r[id];
        if (!r)
            return function() {};
        delete this.r[id];
        window.clearTimeout(r.timer);
        this.disposeQuery(id);

        return function(obj) { r.callback(obj) }
    },

    timeout: function(id) {
        var r = this.r[id];
        if (!r)
            return;
        delete this.r[id];
        r.callback(null, { type: "TimeoutError", message: "Timeout expired", url: r.url });
        this.disposeQuery(id);
    },

    disposeQuery: function (id) {
        var script = document.getElementById(this.prefix + id);
        script.parentNode.removeChild(script);
    }
};})(ya_);

var util = ya_.util, json = ya_.json, ajax = ya_.ajax;

//////////////////////////////////////////////////////////////////////////////
//
// LangCtrl
//

function LangCtrl(form, params) {
    var ref = this;
    this.ctrls = [ form["from"], form["to"] ];
    this.lang = form["lang"];
    this.uiLang = document.documentElement.lang || form['ui'].value;
    this.defaultValue = 'en' + '-' + (this.uiLang !== 'en' ? this.uiLang : 'ru');
    this.langs = params.langs.trnsl;
    this.ctrls[0].onchange = function() { ref.selectCtrl(0) }
    this.ctrls[1].onchange = function() { ref.selectCtrl(1) }
    if (navigator.userAgent.indexOf("Opera") < 0)
        document.onkeydown = function(e) { return ref.onKeyDown(e || window.event) }

    var fromLangs = {};
    for (var key in this.langs) {
        fromLangs[key] = true;
    }
    this.setItems(0, fromLangs);

    var value = this.lang.value;
    if (!this.checkDir(value))
        value = this.defaultValue;
    this.setValue(value);
}

LangCtrl.prototype.getValue = function() {
    return this.lang.value;
}

LangCtrl.prototype.getSrcLang = function() {
    return this.lang.value.split("-")[0];
}

LangCtrl.prototype.setValue = function(value) {
    if (!this.checkDir(value))
        return;
    this.selectDir(value);
}

LangCtrl.prototype.selectDir = function(dir) {
    var values = dir.split("-");
    util.selectValue(this.ctrls[0], values[0]);
    var toLangs = {};
    for (var key in this.langs) {
        if(key !== values[0]) {
            toLangs[key] = true;
        }
    }
    this.setItems(1, toLangs);

    if (util.selectValue(this.ctrls[1], values[1]) < 0) {
        this.ctrls[1].selectedIndex = 0;
    }

    this.updateValue();
}

LangCtrl.prototype.setItems = function(index, values) {
    var langs = [];
    for (var lang in values)
        langs.push(this.langs[lang] + ":" + lang);

    if (this.uiLang === 'tr' || this.uiLang === 'uk') {      /* sort with localCompare is slow, so is called only when necessary */
        langs = langs.sort(function(a, b) {
            return a.localeCompare(b);
        });
    }
    else {
        langs = langs.sort();
    }

    var ctrl = this.ctrls[index];
    ctrl.options.length = langs.length;
    for (var i = 0; i < langs.length; ++i) {
        var nameValue = langs[i].split(":");
        ctrl.options[i].text = nameValue[0];
        ctrl.options[i].value = nameValue[1];
    }
}

LangCtrl.prototype.selectCtrl = function(index) {
    var oldValue = this.getValue().split('-');

    this.updateValue();

    if (index === 0) {
        var value = this.getValue().split('-');

        if (value[0] === value[1]) {
            value[1] = oldValue[0];
        }

        this.selectDir(value.join('-'));
    }

    this.onChange && this.onChange(this);
}

LangCtrl.prototype.checkDir = function(dir) {
    var lang = dir.split("-");
    if (lang.length !== 2 || lang[0] === lang[1]) {
        return false;
    }

    return this.langs[lang[0]] && this.langs[lang[1]];
}

LangCtrl.prototype.updateValue = function() {
    this.lang.value = util.getSelectedValue(this.ctrls[0])
        + "-" + util.getSelectedValue(this.ctrls[1]);
}

LangCtrl.prototype.invertDir = function(){
    var values = this.lang.value.split("-");
    if (values.length == 2)
        this.setValue(values[1] + '-' + values[0]);
}

LangCtrl.prototype.onKeyDown = function(e) {
    if (e.ctrlKey && e.keyCode == 85 /*Ctrl+U*/) {
        this.invertDir();
        this.onChange && this.onChange(this);
        return false;
    }
    return true;
}

//////////////////////////////////////////////////////////////////////////////
//
// Breaker
//

var Breaker = {
    breakText: function(text, blockLen) {
        var result = [];
        var sent = [];
        var token = {};
        for (var pos = 0; this.nextToken(text, pos, token); pos += token.length) {
            var ch = token.word.charAt(0);
            if (ch.toLowerCase() != ch) {
                var dotPos = token.space.search(/[\.\?!]/);
                var spacePos = token.space.search(/\s/);
                if (dotPos >= 0 && spacePos > dotPos) {
                    sent.push(token.space.substr(0, spacePos + 1));
                    this.addSentence(result, sent, blockLen);
                    sent = [];
                    token.space = token.space.substr(spacePos + 1);
                }
            }
            sent.push(token.space);
            sent.push(token.word);
        }
        this.addSentence(result, sent, blockLen);
        return result;
    },

    nextToken: function(s, pos, token) {
        var sepPos = pos;
        while (pos < s.length && this.isSep(s.charCodeAt(pos)))
            ++pos;
        var wordPos = pos;
        while (pos < s.length && !this.isSep(s.charCodeAt(pos)))
            ++pos;
        token.space = s.substr(sepPos, wordPos - sepPos);
        token.word = s.substr(wordPos, pos - wordPos);
        token.length = pos - sepPos;
        return token.length > 0;
    },

    isSep: function(ch) {
        return ch < 0x2f || (ch >= 0x3a && ch <= 0x3f);
    },

    addSentence: function(result, sent, blockLen) {
        var sentText = sent.join("");
        if (sentText.length <= blockLen)
            sent = [sentText];

        var endIndex = result.length - 1;
        var textLen = (endIndex >= 0 ? result[endIndex].length : blockLen);
        for (var i = 0; i < sent.length; ++i) {
            var s = sent[i];
            if (!s)
                continue;
            if (textLen + s.length > blockLen) {
                result[++endIndex] = "";
                textLen = 0;
            }
            result[endIndex] += s;
            textLen += s.length;
        }
    }
};
