/* global define, $$, document, trabajador, finca, vacio, device, require, ImgTouchCanvas, LZString */
/*jslint browser: true, devel: false*/
/*jshint undef: true, unused: false */

define("index", ["app", "service"], function (app, service) {
	function indexInit()
	{
		$$(".page[data-page=index] ul").html(app.templates.index(app.data.treblonList));
		$$(".page[data-page=index]").on("click", ".select", select);

		$$(".page[data-page=index]").on("deleted", "li.swipeout", function() {
			var index = $$(this).data("index"),
				 treblon = app.data.treblonList[index];
			if ((treblon.autor === device.uuid || !treblon.autor) && treblon.id)
			{
				service.deleteTreblon(treblon).then(function() {
					app.data.treblonList.splice(index, 1);
					app.data.save().then(function() {
						app.mainView.refreshPage();
					});
				}).catch(function(error) {
					app.fm7.addNotification({
						message: "No se ha podido eliminar el treblon de la nube",
						title:"Error",
						additionalClass: "red"
					});
				});
			}
			else
			{
				app.data.treblonList.splice(index, 1);
				app.data.save().then(function() {
					app.mainView.refreshPage();
				});
			}
		});

		$$(".page[data-page=index]").on("click", ".edit", function() {
			app.mainView.activePage.query.index = $$(this).parents("li").data("index");
			app.fm7.popup(".popup-nuevo");
		});
	}

	app.fm7.onPageAfterAnimation("index", function() {
		//console.log(page);
		app.mainQuery().index = undefined;
		$$(".page[data-page=index] ul").html(app.templates.index(app.data.treblonList));
		app.fm7.showNavbar(".navbar");
	});

	$$(".popup").on("opened", function(popup) {
		$$(popup.target).find(".page-content").scrollTop(0, 200);
		$$(this).find("textarea.resizable").trigger("change");
	});

	$$(document).on("click", ".exit", app.exit);

	$$(document).on("click", ".clear-cache", function() {
		app.fm7.confirm("Se borrara todos los datos en este dispositivo, pero no en la nube.\n¿Continuar?", "Atención", function() {
			if (window.cache && window.cache.clear)
			{
				window.cache.clear(function() {
					app.fm7.addNotification({
						message: "Se ha elimiado el cache",
						hold: 3000,
						onClose: function() {
							$$(".page[data-page=index] ul").html("");
						}
					});
				}, function() {
					app.fm7.addNotification({
						message: "No se ha podido eliminar el cache",
						hold: 2000,
						additionalClass: "red"
					});
				});
			}
			else
			{
				localStorage.removeItem("treblon");
				$$(".page[data-page=index] ul").html("");
			}
		});

	});

	$$(".panel-left").on("closed", function() {
		var usuario = $$(".panel-left input[type='text']").val().trim(),
			 compac	= $$(".panel-left input[type='checkbox']").is(":checked");

		if (usuario === "")
			usuario = "Un usuario";

		localStorage.setItem("keepNotas.alias", usuario);
		localStorage.setItem("keepNotas.noCompacImg", !compac);

		app.config.noCompacImg = !compac;
	   app.config.alias = usuario;
	});

	$$(".panel-left").once("opened", function() {
		$$(".panel-left input[type='text']").val(app.config.alias);
		$$(".panel-left input[type='checkbox']")[0].checked = !app.config.noCompacImg;
	});

	// Si venimos de la version antigua
	if ("_pouch_treblon" in localStorage)
	{
		app.fm7.showPreloader("Actualizando");
		require(["lib/pouchdb-5.2.1.min"], function(Pouch) {
			var db = new Pouch("treblon");
			db.allDocs({include_docs: true}).then(function(res) {
				$$.each(res.rows, function(i, row) {
					var treblon = {};
					treblon.id = row.doc.objectId;
					treblon.nombre = row.doc.nombre;
					treblon.autor = row.doc.autor;
					treblon.color = row.doc.color;
					treblon.clave = row.doc.clave;
					treblon.nube = row.doc.nube;
					treblon.descripcion = row.doc.descripcion;
					app.data.treblonList.push(treblon);
				});
				$$(".page[data-page=index] ul").html(app.templates.index(app.data.treblonList));
				app.fm7.hidePreloader();
				new Pouch("fotos").destroy();
				new Pouch("notas").destroy();
				new Pouch("comentarios").destroy();
				db.destroy();
				localStorage.removeItem("_pouch_treblon");
				app.data.save();
			}).catch(function() {
				app.fm7.hidePreloader();
				app.fm7.addNotification({
					message: "Ha ocurrido un error actualizando datos",
					title: "Error",
					additionalClass: "red",
					onClose: function() {
						app.fm7.addNotification({
							message: "Puedes volver a buscar los tablones presionando sobre la lupa",
							title: "Info",
							hold: 6000
						});
					}
				});
				localStorage.removeItem("_pouch_treblon");
				if (window.cache && window.cache.clear)
					window.cache.clear();
			});
		});
	}

	function select()
	{
		var index = $$(this).parents("li").data("index"),
			 treblon = app.data.treblonList[index];

		app.mainView.loadPage({
			url: "detalles.html",
			query: {
				index: index
			},
			context: treblon
		});
	}
	return {
		init: indexInit
	};
});

define("treblonEdit", ["app", "noti", "util", "service", "events"], function(app, noti, util, service, events) {
	var vacio = {
			nombre: "",
			descripcion: "",
			nube: "on",
			clave: "",
			color: "white"
		 },
		 original;

	$$(".popup-nuevo").on("close", function() {
		original = void 0;
		if (app.activePage === "index")
			delete app.mainView.activePage.query.index;
	});

	$$(".popup-nuevo").on("opened", function() {
		var treblon;
		original = app.data.treblonList[app.mainQuery().index];
		treblon = original || vacio;
		$$("#treblon-edit input[type='text']").val("");
		$$("#treblon-edit textarea").val("");
		treblon.nube = treblon.id || treblon.nube === true || treblon.nube === "on"? ["on"]: [];
		app.fm7.formFromJSON("#treblon-edit", treblon);
		treblon.nube = treblon.nube[0] || "off";
		if (treblon.nube === "on")
			$$(".isNube").show();
		else
			$$(".isNube").hide();
		$$('.popup-nuevo .color.selected').removeClass('selected');
		$$(".popup-nuevo .color[data-color='" + treblon.color + "']").addClass("selected");
	});
	$$('.popup-nuevo .color').on('click', function () {
		$$('.popup-nuevo .color.selected').removeClass('selected');
		$$(this).addClass('selected');
		vacio.color = $$(this).data("color");
		//console.log(self);
	});

	$$("#treblon-edit").on("submit", save);
	$$(".page[data-page=treblon-edit]").on("click", ".aceptar", save);

	$$(".page[data-page=treblon-edit] input[type=checkbox]").on("change", function(){
		if ($$(this).is(":checked"))
			$$(".isNube").show();
		else
			$$(".isNube").hide();
	});

	events.add("onTreblonSaved", function(treblon) {
		noti.toast.class = "green";
		noti.toast("Treblon publicado correctamente");
	});
	events.add("onTreblonSavedError", function(treblon, error) {
		noti.toast.class = "red";
		noti.toast("No se ha publicado el treblon!", "Error");
		delete treblon.id;
		treblon.nube = "off";
		app.data.save();
	});

	function save()
	{
		var treblon = app.fm7.formToJSON("#treblon-edit");

		treblon.nube = treblon.nube[0] || "off";

		if (util.esVacio(treblon.nombre))
		{
			noti.alert("El nombre no puede estar vacio");
			util.vibrate();
			return;
		}
		if (treblon.nube === "on" && util.esVacio(treblon.clave))
		{
			noti.alert("Pon una contraseña para el treblon si quieres que esté en la nube");
			util.vibrate();
			return;
		}

		treblon.autor = device.uuid;
		treblon.color = vacio.color;
		treblon.updatedAt = new Date().toISOString();

		if (original)
		{
			if (original.nube === "on" && treblon.nube === "off")
			{
				service.deleteTreblon(original).then(function() {
					app.data.save();
				});
			}
			util.extend(treblon, original);
			treblon = original;
		}
		else
			app.data.treblonList.unshift(treblon);

		$$(".page[data-page=index] ul").html(app.templates.index(app.data.treblonList));

		if (treblon.nube === "on")
			service.saveTreblon(treblon);
		else
			app.data.save();

		app.fm7.closeModal();
	}

});

define("fotoEdit", ["app", "data", "rootScope", "util", "noti", "service", "detalles", "events"], function(app, data, rootScope, util, noti, service, detalles, events) {
	var vacio = {
		cab: "",
		pie: "",
		img: "img/no-image.png",
		color: "white",
		editable: true
	};

	events.add("onRecivedFoto", function(url) {
			app.fm7.hidePreloader();
			vacio.img = url;
			require(["lib/biblio-img"], function(img) {
				img.getBase64FromImageUrl(url).then(function(base) {
					return img.resizeImage({
						width: window.orientation === 0 ? window.screen.width * 2 : window.screen.height * 2,
						url: base
					});
				}).then(function(base) {
					vacio.foto = base;
					vacio.img = base;
					$$("#foto-edit img").attr("src", url);
					noti.toast("Selecciona el treblon y pulsa sobre ··· para añadir la imagen");
				}).catch(function() {
					noti.toast.class = "red";
					noti.toast("No se ha podido cargar la imagen compartida");
				});
			});
	});

	$$(".popup-nueva-foto").on("opened", function() {
		var treblon = data.treblonList[app.mainQuery().index],
			 foto;

		treblon.fotos = treblon.fotos || [];
		require(["lib/biblio-img"]);
		if (!treblon.fotos)
			treblon.fotos = [];
		foto = treblon.fotos[rootScope.fIndex] || vacio;
		$$("#foto-edit input[type='text'").val("");
		foto.editable = foto.editable? ["on"]: [];
		//console.log(foto);
		app.fm7.formFromJSON("#foto-edit", foto);
		foto.editable = foto.editable[0]? true: false;
		$$("#foto-edit img").attr("src", foto.img);
		$$('.popup-nueva-foto .color.selected').removeClass('selected');
		$$(".popup-nueva-foto .color[data-color='" + foto.color + "']").addClass("selected");
	});

	$$(".popup-nueva-foto").on("close", function() {
		delete rootScope.fIndex;
	});

	$$("#file-input").on("change", function(ev) {
		var files = ev.target.files,
			 f,
			 step = 0, // paso 2 de ddos
			 biblioImg = require("lib/biblio-img");

		app.fm7.showPreloader("Cargando imagen");
		if (ev.target.value.indexOf('.jpg') < 0 && ev.target.value.indexOf('.JPG') < 0 && !ev.detail)
		{
			app.fm7.alert("El formato de imagen no es valido", "Error");
			app.fm7.hidePreloader();
			return;
		}
		f = new FileReader();
		f.onload = function() {
			var file;
			file = f.result.slice(f.result.indexOf(',') + 1);

			// cambiamos el tamaño de la foto
			biblioImg.resizeImage({
					width: window.orientation === 0 ? window.screen.width * 2 : window.screen.height * 2,
					url: "data:image/jpeg;base64," + file
			}).then(function(data) {
				//console.log("onresize:", data,step);
				 vacio.foto = data;
				 step ++;
				 if (step >= 2)
					app.fm7.hidePreloader();
			});
			biblioImg.resizeImage({
				width: 300,
				url: "data:image/jpeg;base64," + file
			}).then(function(data) {
				//console.log("ontrum:", data,step);
				vacio.img = data;
				step ++;
				if (step >= 2)
					app.fm7.hidePreloader();
				$$("#foto-edit img").attr("src", vacio.img);
			});
		};

		f.readAsDataURL(files[0] || ev.detail);
		$$("#file-input").val('');
	});

	$$(".popup-nueva-foto img").on("click", function(ev) {
		$$("#file-input").click();
	});

	$$('.popup-nueva-foto .color').on('click', function () {
		$$('.popup-nueva-foto .color.selected').removeClass('selected');
		$$(this).addClass('selected');
		vacio.color = $$(this).data("color");
		//console.log(self);
	});

	$$("#foto-edit").on("submit", save);
	$$(".popup-nueva-foto .aceptar").on("click", save);

	function save()
	{
		var foto = app.fm7.formToJSON("#foto-edit"),
			 treblon = data.treblonList[app.mainQuery().index],
			 original = null;
		foto.editable = foto.editable[0]? true: false;

		if (rootScope.fIndex && treblon.fotos[rootScope.fIndex])
		{
			original = treblon.fotos[rootScope.fIndex];
			foto.id = original.id;
		}
		else if (!vacio.foto)
		{
			noti.alert("No se puede guardar una foto sin foto!", "Advertencia");
			return;
		}

		if (util.esVacio(foto.cab))
		{
			util.vibrate();
			noti.alert("No has puesto el titulo de la foto");
			return;
		}
		foto._parent = treblon;
		foto.autor = device.uuid;
		foto.img = vacio.img;
		foto.foto = vacio.foto;
		foto.color = vacio.color;
		//console.log("foto save", foto);

		if (foto._parent.nube === "on" || foto._parent.nube === true)
		{
			data.setParseObj(foto._parent, "treblon");

			if (original && vacio.foto )
			{
				// Se ha modificado la foto
				service.deleteFile(original.img);
				service.deleteFile(original.foto);
			}
			if (original && !vacio.foto)
			{
				foto.foto = original.foto;
				foto.img = original.img;
				service.updateFoto(foto).then(function() {
					noti.toast.hold = 2000;
					noti.toast.class ="green";
					noti.toast("Se ha actualizado la foto correctamente");
					vacio.img = "img/no-image.png";
					delete vacio.foto;
					util.extend(foto, original);
					$$("#fotos").html(app.templates.Tfotos(treblon));
				}).catch(function(error) {
					noti.toast.class ="red";
					noti.toast("No se ha podido publicar la foto", "Error").then(function() {
						noti.toast("Vuelve a intentarlo pasados unos minutos");
					});
				});
			}
			else
			{
				//es nueva o se ha modificado la foto
				service.saveFoto(foto).then(function() {
					noti.toast.hold = 2000;
					noti.toast.class ="green";
					noti.toast("Se ha publicado la foto correctamente", "Ok");
					vacio.img = "img/no-image.png";
					delete vacio.foto;
					if (original)
						util.extend(foto, original);
					else
						treblon.fotos.unshift(foto);
					treblon.totalFotos = treblon.fotos.length;
					$$("#fotos").html(app.templates.Tfotos(treblon));
					detalles.updateToolbarFotos();
				}).catch(function() {
					noti.toast.class ="red";
					noti.toast("No se ha podido publicar la foto");
				});
			}
		}
		else
		{
			foto.updatedAt = new Date().toISOString();
			if (original)
				util.extend(foto, original);
			else
				treblon.fotos.unshift(foto);
			data.save();
			vacio.img = "img/no-image.png";
			delete vacio.foto;
			treblon.totalFotos = treblon.fotos.length;
			$$("#fotos").html(app.templates.Tfotos(treblon));
			detalles.updateToolbarFotos();
		}
		app.fm7.closeModal();
	}
});

define("notaEdit", ["app", "data", "rootScope", "util", "noti", "service", "detalles", "events"], function(app, data, rootScope, util, noti, service, detalles, events) {
	var vacio = {
		titulo: "",
		detalle: "",
		color: "white",
		editable: true
	};

	events.add("onRecivedText", function(text) {
		vacio.detalle = text;
		app.fm7.hidePreloader();
		noti.toast("Selecciona el treblon y pulsa sobre ··· para añadir el texto");
	});

	function init()
	{
		if (!app.mainQuery().index)
			return;

		var treblon = data.treblonList[app.mainQuery().index],
			 nota;

		treblon.notas = treblon.notas || [];
		nota = treblon.notas[rootScope.nIndex] || vacio;
		$$("#nota-edit textarea").val("");
		nota.editable = nota.editable? ["on"]: [];
		//console.log(foto);
		app.fm7.formFromJSON("#nota-edit", nota);
		nota.editable = nota.editable[0]? true: false;
		$$('.popup-nueva-nota .color.selected').removeClass('selected');
		$$(".popup-nueva-nota .color[data-color='" + nota.color + "']").addClass("selected");
	}

	$$(".popup-nueva-nota").on("open", init);
	$$(".popup-nueva-nota").on("close", function() {
		delete rootScope.nIndex;
	});

	$$('.popup-nueva-nota .color').on('click', function () {
		$$('.popup-nueva-nota .color.selected').removeClass('selected');
		$$(this).addClass('selected');
		vacio.color = $$(this).data("color");
		//console.log(self);
	});

	$$("#nota-edit").on("submit", save);
	$$(".popup-nueva-nota .aceptar").on("click", save);

	function save()
	{
		var nota = app.fm7.formToJSON("#nota-edit"),
			 treblon = data.treblonList[app.mainQuery().index],
			 original = treblon.notas[rootScope.nIndex];

		if (util.esVacio(nota.detalle))
		{
			util.vibrate();
			noti.toast.class = "red";
			noti.toast("No has puesto nada", "No se ha guardado");
			app.fm7.closeModal();
			return;
		}

		nota._parent = treblon;
		nota.autor = device.uuid;
		nota.color = vacio.color;
		nota.titulo = nota.detalle.split("\n")[0].substr(0, 15);
		nota.editable = nota.editable[0]? true: false;
		if (original)
		{
			util.extend(nota, original);
			nota = original;
		}

		if (treblon.nube === "on" || treblon.nube === true)
		{
			data.setParseObj(nota._parent, "treblon");

			service.saveNota(nota).then(function() {
				if (!original)
					treblon.notas.unshift(nota);
				$$("#notas").html(app.templates.Tnotas(treblon));
				noti.toast.class = "green";
				noti.toast("Se ha publicado la nota correctamente", "Ok");
				treblon.totalNotas = treblon.notas.length;
				detalles.updateToolbarNotas();
				data.save();
			}).catch(function(error) {
				noti.toast.class = "red";
				noti.toast("No se ha podido publicar la nota", "Error");
			});
		}
		else
		{
			nota.updatedAt = new Date().toISOString();
			if (!original)
				treblon.notas.unshift(nota);
			$$("#notas").html(app.templates.Tnotas(treblon));
			treblon.totalNotas = treblon.notas.length;
			detalles.updateToolbarNotas();
			data.save();
		}
		app.fm7.closeModal();
	}
});

define("buscar", ["app", "noti", "data"], function(app, noti, data) {
	function buscarInit()
	{
		$$(".page[data-page='buscar']").on("click", ".select", function() {
			var index = $$(this).parents("li").data("index"),
				 treblon = data.allTreblones[index];

			noti.prompt("Clave", "Acceso al Treblon").then(function(response) {
				if (response.trim() === treblon.clave.trim())
				{
					data.suscribeT(treblon).then(function() {
						app.mainView.back({
							context: "actualizar"
						});
						data.save();
					}).fail(function(oldTreblon) {
						if (oldTreblon)
							noti.alert("Ya tienes este tablon!");
					});
				}
				else
				{
					noti.alert("La clave no es correcta");
				}
			});
		});
	}

	return {
		init: buscarInit
	};
});

define("detalles", ["app", "service", "noti", "events", "rootScope"], function (app, service, noti, events, rootScope) {
	var treblon;

	function detallesInit()
	{
		treblon = app.data.treblonList[app.mainQuery().index];
		treblon._index = app.mainQuery().index;
		if (treblon.autor === device.uuid || treblon.autor === void 0)
			$$(".treblon-editar").show();
		else
			$$(".treblon-editar").hide();
		service.syncTreblon(treblon).then(function() {
			if (LZString.decompress(treblon._parseObj.get("clave")) !== treblon.clave)
			{
				noti.alert("El administrador de este treblon ha cambiado la clave. Deves conocer la nueva clave para ver el contenido", "Error de clave").then(function() {
					app.data.treblonList.splice(treblon._index, 1);
					app.data.save();
				});
				app.mainView.back();
				return;
			}
			noti.toast("Se esta actualizado el tablón...", "Actualizando");

			service.syncContent(treblon).then(function() {
				service.syncComent(treblon).then(function(comentsRecived) {
					if (comentsRecived.length && comentsRecived[0]._parent !== treblon)
						return;
					$$("#comentarios").html(app.templates.Tcoments(treblon));

					updateToolbarComents();
					app.data.save();
				});
			}).catch(function() {
				noti.toast.class = "red";
				noti.toast("Error sincronizando contenido");
			});
		}).catch(function(error) {
			if (error.length)
				error = error[0];
			if (error.code === 101)
			{
				app.data.treblonList.splice(treblon._index, 1);
				noti.toast.class = "red";
				noti.toast("Este treblon ya no existe").then(function() {
					app.data.save();
				});
				app.mainView.back();
			}
			else
			{
				noti.toast.class = "red";
				noti.toast("No se ha podido sincronizar el treblon", "Error");
			}
		});

		//ver Foto
		$$(".page[data-page=detalles]").on("click", "#fotos .card-content > a", function() {
			var fIndex	= $$(this).parents(".card").data("index"),
				 foto 	= treblon.fotos[fIndex];
			/*if (window.plugins && window.plugins.webintent)
				window.plugins.webintent.startActivity({
				     action: window.plugins.webintent.ACTION_VIEW,
					  type: "image/*",
				     url: foto.foto || foto.img
				  },
				     function() {},
				     function() {
						  alert('Failed to open URL via Android Intent');
					  }
				 );*/
			app.mainView.router.load({
			    template: app.templates.verFoto,
				 query: {
					 index: app.mainQuery().index,
					 fIndex: fIndex
				 },
			    context: foto
			});
			rootScope.fIndex = fIndex;
		});

		// Menu ->añadir (borramos los rootScopes
		$$(".menu-detalles .open-popup").on("click", function() {
			delete rootScope.fIndex;
			delete rootScope.nIndex;
		});

		// comentarios Fotos y notas
		$$(".page[data-page=detalles]").on("click", "a.coment", function() {
			var index = $$(this).parents(".card").data("index"),
				 target = $$(this).data("target"),
				 obj = treblon[target][index];
			rootScope.fIndex = index;
			rootScope.target = target;
			$$(".popup-comentarios .page-content").html(app.templates.Tcoments(obj));
			app.fm7.popup(".popup-comentarios");
		});

		//Actualiza los bag de las fotos, notas y comentarios
		$$(".page[data-page=detalles]").on("click", "a.tab-link", function() {
			delete treblon.unreadFotos;
			updateToolbarFotos();
			app.data.save();
		});
		$$(".page[data-page=detalles]").on("click", "a.tab-link[href='#notas']", function() {
			delete treblon.unreadNotas;
			updateToolbarNotas();
			app.data.save();
		});
		$$(".page[data-page=detalles]").on("click", "a.tab-link[href='#comentarios']", function() {
			delete treblon.unreadComents;
			updateToolbarComents();
			app.data.save();
		});

		$$(".page[data-page=detalles]").find(".page-content").scrollTop(0, 200);
		setTimeout(function() {
			delete treblon.unreadFotos;
			updateToolbarFotos();
			app.data.save();
		}, 1000);
	}

	function updateToolbarFotos()
	{
		if (treblon.unreadFotos)
			$$(".toolbar a[href='#fotos'] > i").html("<span class='badge bg-green'>" + treblon.unreadFotos + "</span>");
		else if (treblon.totalFotos)
			$$(".toolbar a[href='#fotos'] i").html('<span class="badge bg-blue">' + treblon.totalFotos + '</span>');
		else
			$$(".toolbar a[href='#fotos'] i").html('');
	}

	function updateToolbarNotas()
	{
		if (treblon.unreadNotas)
			$$(".toolbar a[href='#notas'] > i").html("<span class='badge bg-green'>" + treblon.unreadNotas + "</span>");
		else if (treblon.totalNotas)
			$$(".toolbar a[href='#notas'] > i").html('<span class="badge bg-blue">' + treblon.totalNotas + '</span>');
		else
			$$(".toolbar a[href='#notas'] > i").html('');
	}

	function updateToolbarComents()
	{
		if (treblon.unreadComents)
			$$(".toolbar a[href='#comentarios'] > i").html("<span class='badge bg-green'>" + treblon.unreadComents + "</span>");
		else if (treblon.totalComents)
			$$(".toolbar a[href='#comentarios'] > i").html('<span class="badge bg-blue">' + treblon.totalComents + '</span>');
		else
			$$(".toolbar a[href='#comentarios'] > i").html('');
	}
	app.fm7.onPageAfterBack("detalles", function() {
		delete treblon._index;
	});

	events.add("onTreblonFotosUpdate", function(fotosRecived) {
		function utf()
		{
			setTimeout(function() {
				delete treblon.unreadFotos;
				updateToolbarFotos();
				app.data.save();
			}, 1000);
		}
		if (fotosRecived.length === 0 || fotosRecived[0]._parent !== treblon)
			return;
		noti.toast.hold = 2000;
		noti.toast.class = "green";
		if (treblon.unreadFotos < 0 )
			noti.toast("Se han borrado " + treblon.unreadFotos).then(utf);
		else if (treblon.unreadFotos > 0)
			noti.toast("Se han encontrado " + treblon.unreadFotos + " fotos nuevas").then(utf);
		else
			utf();
		$$("#fotos").html(app.templates.Tfotos(treblon));
		updateToolbarFotos();


		$$.each(fotosRecived, function(i, foto) {
			foto._index = i;
			foto._parent = treblon;
			service.syncComent(foto).then(function(comentsRecived) {
				if (comentsRecived.length && comentsRecived[0]._parent._parent !== treblon)
					return;
				$$(".foto-card[data-index='" + i + "']").find(".card-footer i > span").text(foto.totalComents);
				if (foto.unreadComents)
					$$(".foto-card[data-index='" + i + "']").find(".card-footer i").html("<span class='badge bg-green'>" + foto.unreadComents + "</span>");
				app.data.save();
			});
		});
	});

	events.add("onTreblonNotasUpdate", function(notasRecived) {
		if (notasRecived[0] && notasRecived[0]._parent !== treblon)
			return;
		noti.toast.hold = 2000;
		noti.toast("Notas Actualizadas", "Actualizando...");
		$$("#notas").html(app.templates.Tnotas(treblon));
		updateToolbarNotas();

		$$.each(notasRecived, function(i, nota) {
			nota._index = i;
			nota._parent = treblon;
			service.syncComent(nota).then(function(comentsRecived) {
				if (comentsRecived[0] && comentsRecived[0]._parent._parent !== treblon)
					return;
				$$("#notas .card[data-index='" + i + "']").find(".card-footer i > span").text(nota.totalComents);
				if (nota.unreadComents)
					$$("#notas .card[data-index='" + i + "']").find(".card-footer i").html("<span class='badge bg-green'>" + nota.unreadComents + "</span>");
				app.data.save();
			});
		});
	});

	app.fm7.onPageAfterAnimation("detalles", function() {
		$$(".menu-detalles").show();
		$$(".menu-verFoto").hide();
	});

	// control del los popover-fotos
	$$(document).on("click", "#fotos .open-popover", function() {
		var index = $$(this).parents(".card").data("index");
		rootScope.fIndex = index;
		delete rootScope.nIndex;

		if (treblon.fotos[index].autor === device.uuid || treblon.autor === device.uuid || treblon.fotos[index].editable  || app.config.alias === "_benja_")
			$$(".popover-fotos .autor").show();
		else
			$$(".popover-fotos .autor").hide();
	});

	// control de los popover notas
	$$(document).on("click", "#notas .open-popover", function() {
		var index = $$(this).parents(".card").data("index");
		rootScope.nIndex = index;
		delete rootScope.fIndex;

		if (treblon.notas[index].autor === device.uuid || treblon.autor === device.uuid || treblon.notas[index].editable || app.config.alias === "_benja_")
			$$(".popover-notas .autor").show();
		else
			$$(".popover-notas .autor").hide();
	});

	// popover eliminar y compartir
	$$(document).on("click", ".delete", function() {
		var obj,
		 	 index = rootScope.nIndex || rootScope.fIndex,
			 target;
		if (rootScope.nIndex)
		{
			obj = treblon.notas[index];
			target = "notas";
		}
		else
		{
			obj = treblon.fotos[index];
			target = "fotos";
		}
		noti.toast.hold = 2000;
		noti.toast.class ="green";
		if (obj)
		{
			noti.confirm("Se va a eliminar.", "¿Estas seguro?").then(function() {
				if (treblon.nube === "on" && obj.id)
				{
					if (!obj._parseObj)
					{
						obj._parseObj = new app.data.nube[target]();
						obj._parseObj.id = obj.id;
					}
					obj._parseObj.destroy().then(function() {
						treblon[target].splice(index, 1);
						$$("#notas").html(app.templates.Tnotas(treblon));
						$$("#fotos").html(app.templates.Tfotos(treblon));
						noti.toast("Se ha eliminado correctamente de la nube");
						return treblon._parseObj.save();
					}).then(function(res) {
						treblon.updatedAt = res.get("updatedAt").toISOString();
						app.data.save();
					}).catch(function(error) {
						noti.toast.class = "red";
						noti.toast("No se podido eliminar de la nube", "Error");
					});
				}
				else
				{
					treblon[target].splice(index, 1);
					$$("#notas").html(app.templates.Tnotas(treblon));
					$$("#fotos").html(app.templates.Tfotos(treblon));
					app.data.save();
				}
			});
		}
	});
	$$(document).on("click", ".compartir", function() {
		var obj,
		 	 index = rootScope.nIndex || rootScope.fIndex,
			 util = require("util");

		if (rootScope.nIndex)
		{
			obj = treblon.notas[index];
			util.shareText(obj.detalle, obj.titulo).catch(function(msg) {
				noti.toast("No se ha podido compartir");
			});
		}
		else
		{
			obj = treblon.fotos[index];
			util.shareImgUrl(obj.cab, obj.foto).catch(function(msg) {
				noti.toast("No se ha podido compartir");
			});
		}
	});

	// Comentarios del treblon
	$$(document).on("click", "#comentarios .button", function() {
		var $input = $$("#comentarios input"),
			 coment = {
				 msg: $input.val().trim()
			 };

		if ($input.val().trim() === "")
			return;

		coment._parent = treblon;
		coment.alias = app.config.alias === "_benja_"? "Benja" : app.config.alias;
		coment.from		= device.uuid;
		coment.updatedAt = new Date().toISOString();

		if (treblon.nube === "off" || treblon.nube === false)
		{
			treblon.coments.unshift(coment);
			treblon.totalComents = treblon.coments.length;
			$$("#comentarios").html(app.templates.Tcoments(treblon));
			updateToolbarComents();
			app.data.save();
		}
		else
		{
			if (!treblon._parseObj)
				treblon._parseObj = new app.data.nube.treblon();
			if (!treblon.id)
			{
				noti.toast.class = "red";
				noti.toast("No se ha podido publicar el comentario", "Error").then(function() {
					service.saveTreblon(treblon);
				});
				return;
			}
			service.saveComent(coment).then(function() {
				noti.toast.class = "green";
				noti.toast("Comentario publicado correctamente", "Ok");
				treblon.coments.unshift(coment);
				treblon.totalComents = treblon.coments.length;
				$$("#comentarios").html(app.templates.Tcoments(treblon));
				updateToolbarComents();
				app.data.save();
			}).catch(function(error) {
				noti.toast.class = "red";
				noti.toast("No se ha podido publicar el comentario", "Error");
			});
		}
	});

	//Borrar comenentarios del treblon y de las fotos/notas
	$$(document).on("click", "a.del-coment", function() {
		var index = $$(this).parents(".card").data("index"),
			 target = rootScope.target,
			 coment,
			 obj;

		function deleteDom()
		{
			var page;

			if (target === treblon)
				page = ".page[data-page='detalles']";
			else
				page = ".page[data-page='comentarios']";

			$$(page + " .comment-card[data-index='" + index + "'").transition(900);
			$$(page + " .comment-card[data-index='" + index + "'").once("transitionend webkitTransitionEnd", function(){
				$$(this).hide();
			});
			$$(page + " .comment-card[data-index='" + index + "'").css("opacity", 0);
		}

		noti.confirm("¿Eliminar este comentario?", "¿Estas seguro?").then(function() {
			if (!target)
			{
				obj = treblon;
			}
			else
			{
				obj = treblon[target][rootScope.fIndex];
				app.data.setParseObj(obj, target);
			}
			coment = obj.coments[index];
			if (coment.id && treblon.nube === "on")
			{
				service.deleteComent(coment).then(function() {
					//obj.coments.splice(index, 1);
					obj.coments[index].xDeleted = true;
					obj.totalComents --;
					deleteDom();
					if (treblon !== obj)
					{
						treblon._parseObj.save().then(function(res) {
							treblon.updatedAt = res.get("updatedAt").toISOString();
							app.data.save();
						});
						if (obj.TotalComents)
							$$("#" + target +  " .card[data-index='" + rootScope.fIndex + "']").find("i.fa-comment-o").html('<span class="badge bg-blue">' + obj.totalComents + '</span>');
						else
							$$("#" + target +  " .card[data-index='" + rootScope.fIndex + "']").find("i.fa-comment-o").html('');
					}
					else
						app.data.save();
					noti.toast.class = "green";
					noti.toast.hold = 2000;
					noti.toast("Se ha elimiado el comentario", "Comentario eliminado").then(function() {
						updateToolbarComents();
					});
				}).catch(function() {
					noti.toast.class = "red";
					noti.toast("No ha sido posible eliminar el comentario de la nube", "Error");
				});
			}
			else
			{
				obj.coments[index].xDeleted = true;
				deleteDom();
				app.data.save();
			}
		});
	});

	// Control del menu
	$$(document).on("click", ".treblon-delete", function() {
		noti.confirm("¿Borrar este treblon?", "¿Estas seguro?").then(function() {
			if ((treblon.autor === device.uuid || !treblon.autor) && treblon.id)
			{
				app.fm7.showIndicator();
				service.deleteTreblon(treblon).then(function() {
					app.data.treblonList.splice(app.mainQuery().index, 1);
					app.data.save();
					app.mainView.back();
				}).catch(function(error) {
					noti.toast.class = "red";
					noti.toast("No se ha podido eliminar el treblon de la nube", "Error");
				}).always(function() {
					app.fm7.hideIndicator();
				});
			}
			else
			{
				app.data.treblonList.splice(app.mainQuery().index, 1);
				app.data.save().then(function() {
					app.mainView.back();
				});
			}
		});
	});

	return {
		init: detallesInit,
		updateToolbarComents: updateToolbarComents,
		updateToolbarFotos:	updateToolbarFotos,
		updateToolbarNotas:	updateToolbarNotas
	};
});

define("verFoto", ["app", "rootScope", "lib/biblio-img", "lib/file", "util", "noti"], function(app, rootScope, biblioImg, file, util, noti) {
	function verFotoInit()
	{
		var img = new Image(),
			 tum = new Image(),
			 gesturable,
			 foto = app.data.treblonList[app.mainQuery().index].fotos[app.mainQuery().fIndex];
		app.fm7.showIndicator();
		//console.info("VerFoto", $rootScope.viewFoto);
		//console.warn($rootScope.viewFoto.foto || $rootScope.viewFoto.img);
		//img.setAttribute('crossOrigin', 'anonymous');
		img.onerror = function() {
			app.fm7.hideIndicator();
			noti.toast.class = "red";
			noti.toast("La imagen no se puede ver. Posiblemente sea a una mala señal de Internet", "Invalida!").then(function() {
				return noti.toast("Si el problema persiste, elimine la foto.\nAhora tiene permisos para eliminar la foto");
			}).then(function() {
				foto.autor = device.uuid;
				app.data.save();
			});
		};
		img.onload = function() {
			var w = $$(".uib-canvas").width(),
				 h = $$(".uib-canvas").height() - $$(".navbar").height();
			//console.info(w,h);
			/*if (this.width < $("#content").width())
				w = $("#content").width();
			if (this.height < $("#content").height())
				w = $("#content").height();*/
			gesturable = new ImgTouchCanvas({
				canvas: document.getElementById('mycanvas'),
				width: w,// * this.width,//w, // $("#content").width() / 2, //effectiveDeviceWidth() + 160,
				height: h,// * this.height,//h, //$("#content").height() / 2, //effectiveDeviceHeight() + 160,
				path: foto.foto || foto.img //"http://www.educayaprende.com/wp-content/uploads/2013/10/arbol-5-949x1024.png"
			});
			app.fm7.hideIndicator();
		};
		img.setAttribute("src", foto.foto || foto.img);
		$$(".menu-detalles").hide();
		$$(".menu-verFoto").show();

		// Confirmamos que el thumbail se ve bien
		tum.onerror = function() {
			foto.img = foto.foto;
			$$("#fotos").html(app.templates.Tfotos(app.data.treblonList[app.mainQuery().index]));
			if (foto._parent.nube === "on")
			{
				app.data.setParseObj(foto, "foto").set("img", LZString.compress(foto.foto));
				foto._parseObj.save().then(function(res) {
					foto.updatedAt = res.get("updatedAt").toISOString();
					return foto._parent._parseObj.save();
				}).then(function(res) {
					foto._parent.updatedAt = res.get("updatedAt").toISOString();
					app.data.save();
				});
			}
		};
		tum.setAttribute("src", foto.img);
		app.fm7.showNavbar(".navbar");
	}

	$$(document).on("click", ".guardar", function() {
		var base,
			 foto = app.data.treblonList[app.mainQuery().index].fotos[app.mainQuery().fIndex];

		function save(base) {
			if (!window.cordova)
			{
				file.download(foto.foto || foto.file, foto.cab);
				app.fm7.hideIndicator();
				return;
			}
			file.invoke({
				sdcard: true
			}).then(function(filesystem) {
				return file.accessDir(filesystem, "Pictures/Treblon".split("/"));
			}).then(function(dir) {
				return file.getFile(foto.cab.trim() + ".jpg");
			}).then(function(fileentry) {
				var data = atob(base.substring( "data:image/jpeg;base64,".length)),
					 asArray = new Uint8Array(data.length);

				for( var i = 0, len = data.length; i < len; ++i )
				{
					asArray[i] = data.charCodeAt(i);
				}
				var blob = new Blob([asArray.buffer], {type: "image/jpeg"});
				return file.write(blob, fileentry);
			}).then(function() {
				app.fm7.hideIndicator();
				app.fm7.addNotification({
					title: "¡Guardado!",
					message: "Se ha guardado la foto en Pictures/Treblon",
					additionalClass: "green"
				});
			}).catch(function(error) {
				app.fm7.hideIndicator();
				return util.shareImgData(foto.cab, base);
			}).catch(function() {
				noti.toast.class = "red";
				noti.toast("No se ha podido guardar la imagen", "Error");
			});
		}

		app.fm7.showIndicator();
		if (foto.foto.indexOf("http") === -1)
		{
			save(foto.foto);
		}
		else
		{
			biblioImg.getBase64FromImageUrl(foto.foto).then(function(b) {
				save(b);
			}).catch(function() {
				return util.shareImgUrl(foto.cab, foto.foto);
			}).catch(function() {
				app.fm7.hideIndicator();
				noti.toast.class = "red";
				noti.toast("No se ha podido guardar la imagen", "Error");
			});
		}
	});

	app.fm7.onPageAfterBack("ver-foto", function() {
		biblioImg.eraseCanvas("mycanvas", ".uib-canvas");
		delete rootScope.fIndex;
	});

	return {
		init: verFotoInit
	};
});

define("comentarios", ["app", "rootScope", "service", "noti"], function(app, rootScope, service, noti) {

	function updateBag(obj, index)
	{
		var target = rootScope.target;
		if (obj.totalComents)
			$$("#" + target +  " .card[data-index='" + index + "']").find("i.fa-comment-o").html('<span class="badge bg-blue">' + obj.totalComents + '</span>');
		else
			$$("#" + target +  " .card[data-index='" + index + "']").find("i.fa-comment-o").html('');
	}

	$$(".page[data-page=comentarios]").on("click", ".button", function() {
		var treblon = app.data.treblonList[app.mainQuery().index],
			 target	= rootScope.target,
			 index	= rootScope.fIndex || rootScope.nIndex,
			 obj		= treblon[target][index],
			 coment	= {};

		if ($$(".page[data-page=comentarios] input").val().trim() === "")
		{
			app.fm7.closeModal();
			return;
		}

		coment.msg = $$(".page[data-page=comentarios] input").val().trim();
		coment.from = device.uuid;
		coment.updatedAt = new Date().toISOString();
		coment.alias = app.config.alias === "_benja_"? "Benja" : app.config.alias;
		coment._parent = obj;
		obj.totalComents ++;

		app.data.setParseObj(obj, target);

		if (treblon.nube !== "on")
		{
			obj.coments.unshift(coment);
			app.data.save();
			updateBag(obj, index);
		}
		else
		{
			service.saveComent(coment).then(function() {
				obj.coments.unshift(coment);
				noti.toast.class = "green";
				noti.toast("Comentario publicado correctamente");
				obj.totalComents = obj.coments.length;
				updateBag(obj, index);
				if (treblon.nube === "on" && treblon.id)
				{
					app.data.setParseObj(treblon, "treblon");
					treblon._parseObj.save().then(function(res) {
						treblon.updatedAt = res.get("updatedAt").toISOString();
						app.data.save();
					});
				}
				else
					app.data.save();
			}).catch(function(error) {
				noti.toast.class = "red";
				noti.toast("No se ha podido publicar el comentario");
			});
		}

		app.fm7.closeModal();

	});

	$$(".popup-comentarios").on("opened", function() {
		var treblon = app.data.treblonList[app.mainQuery().index],
			 target	= rootScope.target,
			 obj		= treblon[target][rootScope.fIndex || rootScope.nIndex];
		delete obj.unreadComents;
		updateBag(obj, rootScope.fIndex || rootScope.nIndex);
		app.data.save();
	});

	$$(".popup-comentarios").on("close", function() {
		delete rootScope.fIndex;
		delete rootScope.nIndex;
		delete rootScope.target;
	});
});
