/* global define, $$, document, trabajador, finca */
/*jslint browser: true, devel: false*/
/*jshint undef: true, unused: false */

define("noti", ["app", "util"], function(app, util) {
	var pub = {},
		 defTitle = app.fm7.params.modalTitle;

	pub.alert = function(mes, title) {
		var dfrd = util.Deferred();

		title = title ||defTitle;
		app.fm7.alert(mes, title, function() {
			dfrd.resolve();
		});
		return dfrd.promise;
	};

	pub.confirm = function(mes, title) {
		var dfrd = util.Deferred();
		title = title || defTitle;

		app.fm7.confirm(mes, title, function() {
			dfrd.resolve();
		}, function() {
			dfrd.reject();
		});
		return dfrd.promise;
	};

	pub.prompt = function(mes, title) {
		var dfrd = util.Deferred();

		title = title || defTitle;

		app.fm7.prompt(mes, title, function(x) {
			dfrd.resolve(x);
		}, function(x) {
			dfrd.reject(x);
		});
		$$(".modal-text-input").focus();
		return dfrd.promise;
	};

	pub.toast = function(mes, title, button) {
		var dfrd = util.Deferred();

		button = button || title || {
			text: "Ok",
			color: "blue",
			close: true
		};

		app.fm7.addNotification({
			message: mes,
			title: title || app.fm7.params.modalTitle,
			button: button,
			hold: pub.toast.hold,
			additionalClass: pub.toast.class,
			onClose: function() {
				dfrd.resolve();
			}
		});

		pub.toast.hold = app.fm7.params.notificationHold;
		pub.toast.class = "";

		return dfrd.promise;
	};

	pub.toast.hold = app.fm7.params.notificationHold;
	pub.toast.class = "";

	return pub;
});
